/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheException;
import org.hibernate.cfg.Settings;

public class UpdateTimestampsCache {
    public static final String REGION_NAME = UpdateTimestampsCache.class.getName();
    private static final Log log = LogFactory.getLog((Class)UpdateTimestampsCache.class);
    private Cache updateTimestamps;
    private final String regionName;

    public void clear() throws CacheException {
        this.updateTimestamps.clear();
    }

    public UpdateTimestampsCache(Settings settings, Properties props) throws HibernateException {
        String prefix = settings.getCacheRegionPrefix();
        this.regionName = prefix == null ? REGION_NAME : prefix + '.' + REGION_NAME;
        log.info((Object)("starting update timestamps cache at region: " + this.regionName));
        this.updateTimestamps = settings.getCacheProvider().buildCache(this.regionName, props);
    }

    public synchronized void preinvalidate(Serializable[] spaces) throws CacheException {
        Long ts = new Long(this.updateTimestamps.nextTimestamp() + (long)this.updateTimestamps.getTimeout());
        for (int i = 0; i < spaces.length; ++i) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Pre-invalidating space [" + spaces[i] + "]"));
            }
            this.updateTimestamps.put(spaces[i], ts);
        }
    }

    public synchronized void invalidate(Serializable[] spaces) throws CacheException {
        Long ts = new Long(this.updateTimestamps.nextTimestamp());
        for (int i = 0; i < spaces.length; ++i) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Invalidating space [" + spaces[i] + "], timestamp: " + ts));
            }
            this.updateTimestamps.put(spaces[i], ts);
        }
    }

    public synchronized boolean isUpToDate(Set spaces, Long timestamp) throws HibernateException {
        Iterator iter = spaces.iterator();
        while (iter.hasNext()) {
            Serializable space = (Serializable)iter.next();
            Long lastUpdate = (Long)this.updateTimestamps.get(space);
            if (lastUpdate == null) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("[" + space + "] last update timestamp: " + lastUpdate + ", result set timestamp: " + timestamp));
            }
            if (lastUpdate < timestamp) continue;
            return false;
        }
        return true;
    }

    public void destroy() {
        try {
            this.updateTimestamps.destroy();
        }
        catch (Exception e) {
            log.warn((Object)"could not destroy UpdateTimestamps cache", (Throwable)e);
        }
    }

    public Cache getCache() {
        return this.updateTimestamps;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public String toString() {
        return "UpdateTimestampeCache";
    }
}

