/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.vsnet;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.vsnet.VsnetUtils;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalProgressBarUI;

public class VsnetMetalProgressBarUI
extends MetalProgressBarUI
implements ActionListener {
    private int repaintInterval;
    private int x = 0;
    private int y = 0;
    private int delta = 1;
    private Timer timer = null;
    private Rectangle boxRect;

    public static ComponentUI createUI(JComponent x) {
        return new VsnetMetalProgressBarUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        this.initRepaintInterval();
    }

    protected void startAnimationTimer() {
        if (this.timer == null) {
            this.timer = new Timer(this.getRepaintInterval() / 20, this);
        }
        this.y = 0;
        this.x = 0;
        this.delta = 1;
        this.timer.start();
    }

    protected void stopAnimationTimer() {
        if (this.timer != null) {
            this.timer.stop();
        }
    }

    public void actionPerformed(ActionEvent ae) {
        if (this.x == 0) {
            this.delta = 1;
        } else if (this.x == this.progressBar.getWidth()) {
            this.delta = -1;
        }
        this.x += this.delta;
        this.progressBar.repaint();
    }

    protected int getRepaintInterval() {
        return this.repaintInterval;
    }

    private int initRepaintInterval() {
        this.repaintInterval = UIDefaultsLookup.getInt("ProgressBar.repaintInterval");
        return this.repaintInterval;
    }

    public void paintIndeterminate(Graphics g2, JComponent c) {
        boolean isVertical;
        super.paintDeterminate(g2, c);
        if (!(g2 instanceof Graphics2D)) {
            return;
        }
        Color startColor = this.progressBar.getForeground();
        Color endColor = VsnetUtils.getLighterColor(startColor, 0.9f);
        Insets b = this.progressBar.getInsets();
        int barRectWidth = this.progressBar.getWidth() - (b.right + b.left);
        int barRectHeight = this.progressBar.getHeight() - (b.top + b.bottom);
        Graphics2D g2d = (Graphics2D)g2;
        boolean bl = isVertical = c.getHeight() > c.getWidth();
        if (this.delta > 0) {
            this.boxRect = new Rectangle(0, 0, this.x, this.progressBar.getHeight() - 1);
            JideSwingUtilities.fillNormalGradient(g2d, this.boxRect, endColor, startColor, isVertical);
        } else {
            this.boxRect = new Rectangle(this.x, 0, this.progressBar.getWidth() - this.x, this.progressBar.getHeight() - 1);
            JideSwingUtilities.fillNormalGradient(g2d, this.boxRect, startColor, endColor, isVertical);
        }
        if (this.progressBar.isStringPainted()) {
            if (this.progressBar.getOrientation() == 0) {
                this.paintString(g2d, b.left, b.top, barRectWidth, barRectHeight, this.boxRect.x, this.boxRect.width, b);
            } else {
                this.paintString(g2d, b.left, b.top, barRectWidth, barRectHeight, this.boxRect.y, this.boxRect.height, b);
            }
        }
    }

    private void paintString(Graphics g2, int x, int y, int width, int height, int fillStart, int amountFull, Insets b) {
        if (!(g2 instanceof Graphics2D)) {
            return;
        }
        Graphics2D g22 = (Graphics2D)g2;
        String progressString = this.progressBar.getString();
        g22.setFont(this.progressBar.getFont());
        Point renderLocation = this.getStringPlacement(g22, progressString, x, y, width, height);
        Rectangle oldClip = g22.getClipBounds();
        if (this.progressBar.getOrientation() == 0) {
            g22.setColor(this.getSelectionBackground());
            JideSwingUtilities.drawString(this.progressBar, g22, progressString, renderLocation.x, renderLocation.y);
            g22.setColor(this.getSelectionForeground());
            g22.clipRect(fillStart, y, amountFull, height);
            JideSwingUtilities.drawString(this.progressBar, g22, progressString, renderLocation.x, renderLocation.y);
        } else {
            g22.setColor(this.getSelectionBackground());
            AffineTransform rotate = AffineTransform.getRotateInstance(1.5707963267948966);
            g22.setFont(this.progressBar.getFont().deriveFont(rotate));
            renderLocation = this.getStringPlacement(g22, progressString, x, y, width, height);
            JideSwingUtilities.drawString(this.progressBar, g22, progressString, renderLocation.x, renderLocation.y);
            g22.setColor(this.getSelectionForeground());
            g22.clipRect(x, fillStart, width, amountFull);
            JideSwingUtilities.drawString(this.progressBar, g22, progressString, renderLocation.x, renderLocation.y);
        }
        g22.setClip(oldClip);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JProgressBar progressBar = new JProgressBar();
        JProgressBar myProgressBar = new JProgressBar();
        myProgressBar.setUI(new VsnetMetalProgressBarUI());
        progressBar.setIndeterminate(true);
        progressBar.setString("Percent");
        progressBar.setStringPainted(true);
        myProgressBar.setIndeterminate(true);
        myProgressBar.setString("Percent");
        myProgressBar.setStringPainted(true);
        JPanel panel = new JPanel(new BorderLayout(5, 5));
        panel.add((Component)progressBar, "North");
        panel.add((Component)myProgressBar, "South");
        JOptionPane.showMessageDialog(null, panel, "ProgressBars made intutive - santhosh@in.fiorano.com", 1);
        System.exit(0);
    }
}

