/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport;

import com.sshtools.j2ssh.transport.AbstractKnownHostsKeyVerification;
import com.sshtools.j2ssh.transport.InvalidHostFileException;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;

public class ConsoleKnownHostsKeyVerification
extends AbstractKnownHostsKeyVerification {
    public ConsoleKnownHostsKeyVerification() throws InvalidHostFileException {
        super(new File(System.getProperty("user.home"), ".ssh" + File.separator + "known_hosts").getAbsolutePath());
    }

    public ConsoleKnownHostsKeyVerification(String knownhosts) throws InvalidHostFileException {
        super(knownhosts);
    }

    public void onHostKeyMismatch(String host, SshPublicKey pk, SshPublicKey actual) {
        try {
            System.out.println("The host key supplied by " + host + " is: " + actual.getFingerprint());
            System.out.println("The current allowed key for " + host + " is: " + pk.getFingerprint());
            this.getResponse(host, pk);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onUnknownHost(String host, SshPublicKey pk) {
        try {
            System.out.println("The host " + host + " is currently unknown to the system");
            System.out.println("The host key fingerprint is: " + pk.getFingerprint());
            this.getResponse(host, pk);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void getResponse(String host, SshPublicKey pk) throws InvalidHostFileException, IOException {
        String response = "";
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        while (!(response.equalsIgnoreCase("YES") || response.equalsIgnoreCase("NO") || response.equalsIgnoreCase("ALWAYS") && this.isHostFileWriteable())) {
            String options;
            String string = options = this.isHostFileWriteable() ? "Yes|No|Always" : "Yes|No";
            if (!this.isHostFileWriteable()) {
                System.out.println("Always option disabled, host file is not writeable");
            }
            System.out.print("Do you want to allow this host key? [" + options + "]: ");
            response = reader.readLine();
        }
        if (response.equalsIgnoreCase("YES")) {
            this.allowHost(host, pk, false);
        }
        if (response.equalsIgnoreCase("NO")) {
            System.out.println("Cannot continue without a valid host key");
            System.exit(1);
        }
        if (response.equalsIgnoreCase("ALWAYS") && this.isHostFileWriteable()) {
            this.allowHost(host, pk, true);
        }
    }
}

