/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.io;

import com.sshtools.j2ssh.io.UnsignedInteger32;
import com.sshtools.j2ssh.io.UnsignedInteger64;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;

public class ByteArrayReader
extends ByteArrayInputStream {
    public ByteArrayReader(byte[] data) {
        super(data);
    }

    public static long readInt(byte[] data, int start) {
        long ret = (long)(data[start] & 0xFF) << 24 & 0xFFFFFFFFFFFFFFFFL | (long)((data[start + 1] & 0xFF) << 16) | (long)((data[start + 2] & 0xFF) << 8) | (long)((data[start + 3] & 0xFF) << 0);
        return ret;
    }

    public long readInt() throws IOException {
        byte[] raw = new byte[4];
        this.read(raw);
        long ret = (long)(raw[0] & 0xFF) << 24 & 0xFFFFFFFFFFFFFFFFL | (long)((raw[1] & 0xFF) << 16) | (long)((raw[2] & 0xFF) << 8) | (long)(raw[3] & 0xFF);
        return ret;
    }

    public UnsignedInteger32 readUINT32() throws IOException {
        return new UnsignedInteger32(this.readInt());
    }

    public UnsignedInteger64 readUINT64() throws IOException {
        byte[] raw = new byte[8];
        this.read(raw);
        return new UnsignedInteger64(raw);
    }

    public static String readString(byte[] data, int start) {
        int len = (int)ByteArrayReader.readInt(data, start);
        byte[] chars = new byte[len];
        System.arraycopy(data, start + 4, chars, 0, len);
        return new String(chars);
    }

    public BigInteger readBigInteger() throws IOException {
        int len = (int)this.readInt();
        byte[] raw = new byte[len];
        this.read(raw);
        return new BigInteger(raw);
    }

    public byte[] readBinaryString() throws IOException {
        long len = this.readInt();
        byte[] raw = new byte[(int)len];
        this.read(raw);
        return raw;
    }

    public String readString() throws IOException {
        long len = this.readInt();
        byte[] raw = new byte[(int)len];
        this.read(raw);
        return new String(raw);
    }
}

