// Code generated by running "go generate" in golang.org/x/text. DO NOT EDIT.

// +build go1.14

package runenames

// UnicodeVersion is the Unicode version from which the tables in this package are derived.
const UnicodeVersion = "12.0.0"

type entry uint64

func (e entry) startRune() int32 {
	return int32((e >> 43) & 0x1fffff)
}

func (e entry) numRunes() int {
	return int((e >> 27) & 0xffff)
}

func (e entry) index() int {
	return int((e >> 11) & 0xffff)
}

func (e entry) base() int {
	return int((e >> 5) & 0x3f)
}

func (e entry) direct() bool {
	const bit = 1 << 4
	return e&bit == bit
}

var entries = []entry{ // 688 elements
	// Entry 0 - 1F
	0x00000001000ac130, 0x00010002f8000000, 0x0003f801080ac130, 0x00050016c002f800,
	0x001bd0003019b800, 0x001c20003819e800, 0x001c6000081a2000, 0x001c7000a01a2800,
	0x001d180c681ac800, 0x0029880130273000, 0x002ac80190286000, 0x002c68001829f000,
	0x002c8801b82a0800, 0x002e8000d82bc000, 0x002f7800302c9800, 0x00300000e82cc800,
	0x0030f007802db000, 0x00387801e0353000, 0x003a680328371000, 0x003e0001d83a3800,
	0x003fe801883c1000, 0x00418000783d9800, 0x00420000e03e1000, 0x0042f000083ef000,
	0x00430000583ef800, 0x00450000a83f5000, 0x0045b000403ff800, 0x0046980588403800,
	0x004c28004045c000, 0x004c780010460000, 0x004c9800b0461000, 0x004d50003846c000,
	// Entry 20 - 3F
	0x004d90000846f800, 0x004db00020470000, 0x004de00048472000, 0x004e380010476800,
	0x004e580020477800, 0x004eb80008479800, 0x004ee0001047a000, 0x004ef8002847b000,
	0x004f3000c847d800, 0x005008001848a000, 0x005028003048b800, 0x005078001048e800,
	0x00509800b048f800, 0x005150003849a800, 0x005190001049e000, 0x0051a8001049f000,
	0x0051c000104a0000, 0x0051e000084a1000, 0x0051f000284a1800, 0x00523800104a4000,
	0x00525800184a5000, 0x00528800084a6800, 0x0052c800204a7000, 0x0052f000084a9000,
	0x00533000884a9800, 0x00540800184b2000, 0x00542800484b3800, 0x00547800084b8000,
	0x00548000104b8820, 0x00549800b04b9820, 0x00555000384c4820, 0x00559000104c8020,
	// Entry 40 - 5F
	0x0055a800284c9020, 0x0055e000504cb820, 0x00563800184d0820, 0x00565800184d2020,
	0x00568000084d3820, 0x00570000204d4020, 0x00573000604d6020, 0x0057c800384dc020,
	0x00580800184df820, 0x00582800404e1020, 0x00587800104e5020, 0x00589800b04e6020,
	0x00595000384f1020, 0x00599000104f4820, 0x0059a800284f5820, 0x0059e000484f8020,
	0x005a3800104fc820, 0x005a5800184fd820, 0x005ab000104ff020, 0x005ae00010500020,
	0x005af80028501020, 0x005b300090503820, 0x005c10001050c820, 0x005c28003050d820,
	0x005c700018510820, 0x005c900020512020, 0x005cc80010514020, 0x005ce00008515020,
	0x005cf00010515820, 0x005d180010516820, 0x005d400018517820, 0x005d700060519020,
	// Entry 60 - 7F
	0x005df0002851f020, 0x005e300018521820, 0x005e500020523020, 0x005e800008525020,
	0x005eb80008525820, 0x005f3000a8526020, 0x0060000068530820, 0x0060700018537020,
	0x00609000b8538820, 0x0061500080544020, 0x0061e8004054c020, 0x0062300018550020,
	0x0062500020551820, 0x0062a80010553820, 0x0062c00018554820, 0x0063000020556020,
	0x0063300050558020, 0x0063b800b055d020, 0x0064700018568020, 0x00649000b8569820,
	0x0065500050575020, 0x0065a8002857a020, 0x0065e0004857c820, 0x0066300018581020,
	0x0066500020582820, 0x0066a80010584820, 0x0066f00008585820, 0x0067000020586020,
	0x0067300050588020, 0x006788001058d020, 0x006800002058e020, 0x0068280040590020,
	// Entry 80 - 9F
	0x0068700018594020, 0x0068900198595820, 0x006a3000185af020, 0x006a5000305b0820,
	0x006aa000805b3820, 0x006b3000d05bb820, 0x006c1000105c8820, 0x006c2800905c9820,
	0x006cd000c05d2820, 0x006d9800485de820, 0x006de800085e3020, 0x006e0000385e3820,
	0x006e5000085e7020, 0x006e7800305e7820, 0x006eb000085ea820, 0x006ec000405eb020,
	0x006f3000505ef020, 0x006f9000185f4020, 0x00700801d05f5820, 0x0071f800e8612820,
	0x0074080010621020, 0x0074200008622020, 0x0074300028622820, 0x00746000c0625020,
	0x0075280008631020, 0x00753800b8631820, 0x007600002863d020, 0x007630000863f820,
	0x0076400030640020, 0x0076800050643020, 0x0076e00020648020, 0x007800024064a020,
	// Entry A0 - BF
	0x007a48012066e020, 0x007b880138680020, 0x007cc80120693820, 0x007df000786a5820,
	0x007e7000686ad020, 0x00800006306b3820, 0x0086380008716820, 0x0086680008717020,
	0x0086800bc8717820, 0x00925000207d4020, 0x00928000387d6020, 0x0092c000087d9820,
	0x0092d000207da020, 0x00930001487dc020, 0x00945000207f0820, 0x00948001087f2820,
	0x0095900020803020, 0x0095c00038805020, 0x0096000008808820, 0x0096100020809020,
	0x009640007880b020, 0x0096c001c8812820, 0x009890002082f020, 0x0098c00218831020,
	0x009ae80100852820, 0x009c0000d0862820, 0x009d0002b086f820, 0x009fc0003089a820,
	0x00a00014e889d820, 0x00b50002c89ec020, 0x00b8000068a18820, 0x00b8700038a1f020,
	// Entry C0 - DF
	0x00b90000b8a22820, 0x00ba0000a0a2e020, 0x00bb000018a38020, 0x00bb180050a39840,
	0x00bb700018a3e840, 0x00bb900010a40040, 0x00bc0002f0a41040, 0x00bf000050a70040,
	0x00bf800050a75040, 0x00c0000078a7a040, 0x00c0800050a81840, 0x00c10002c8a86840,
	0x00c4000158ab3040, 0x00c5800230ac8840, 0x00c80000f8aeb840, 0x00c9000060afb040,
	0x00c9800060b01040, 0x00ca000008b07040, 0x00ca200150b07840, 0x00cb800028b1c840,
	0x00cc000160b1f040, 0x00cd8000d0b35040, 0x00ce800058b42040, 0x00cef001f0b47840,
	0x00d0f00208b66840, 0x00d30000e8b87040, 0x00d3f80058b95840, 0x00d4800050b9b040,
	0x00d5000070ba0040, 0x00d5800078ba7040, 0x00d8000260bae840, 0x00da800168bd4840,
	// Entry E0 - FF
	0x00dc0003a0beb040, 0x00dfe001e0c25040, 0x00e1d80078c43040, 0x00e26801e0c4a840,
	0x00e4800158c68840, 0x00e5e80058c7e040, 0x00e6800158c83840, 0x00e80007d0c99040,
	0x00efd808d8d16040, 0x00f8c00030da3840, 0x00f9000130da6840, 0x00fa400030db9840,
	0x00fa800040dbc840, 0x00fac80008dc0840, 0x00fad80008dc1040, 0x00fae80008dc1840,
	0x00faf800f8dc2040, 0x00fc0001a8dd1840, 0x00fdb00078dec040, 0x00fe300070df3840,
	0x00feb00030dfa840, 0x00fee80098dfd840, 0x00ff900018e07040, 0x00ffb00048e08840,
	0x0100000328e0d040, 0x0103300060e3f840, 0x0103a000d8e45840, 0x0104800068e53040,
	0x0105000100e59840, 0x0106800108e69840, 0x0108000460e7a040, 0x010c800130ec0040,
	// Entry 100 - 11F
	0x010db01388ed3060, 0x012200005900b860, 0x01230038a1011060, 0x015bb0002139b060,
	0x015bd000e139d080, 0x015cc004b93ab080, 0x01618001793f6880, 0x01630004a140e080,
	0x0167c80169458080, 0x016938000946e880, 0x016968000946f080, 0x01698001c146f880,
	0x016b78001148b880, 0x016bf800c148c880, 0x016d000039498880, 0x016d40003949c080,
	0x016d80003949f880, 0x016dc000394a3080, 0x016e0000394a6880, 0x016e4000394aa080,
	0x016e8000394ad880, 0x016ec000394b1080, 0x016f0003814b4880, 0x01740000d14ec880,
	0x0174d802c94f9880, 0x01780006b1526080, 0x017f800061591080, 0x0180000201597080,
	0x01820802b15b7080, 0x0184c803395e2080, 0x0188280159615880, 0x01898802f162b080,
	// Entry 120 - 13F
	0x018c80015965a080, 0x018e00012166f880, 0x018f800179681880, 0x01910006f9699080,
	0x0198000801708880, 0x01a000cdb0000370, 0x026e000201788880, 0x0270028f800511f0,
	0x05000021d97a8880, 0x0521d802919c60a0, 0x05248001b99ef0a0, 0x0526800ae1a0a8a0,
	0x05320005c1ab88a0, 0x0538000601b148a0, 0x053e100029b748a0, 0x053fb801a9b770a0,
	0x0541800051b918a0, 0x05420001c1b968a0, 0x0544000231bb28a0, 0x0546700061bd58a0,
	0x05470003a1bdb8a0, 0x054af800f1c158a0, 0x054c000271c248a0, 0x054e780059c4b8a0,
	0x054ef00109c510a0, 0x05500001b9c618a0, 0x0552000071c7d0a0, 0x0552800051c840a0,
	0x0552e00339c890a0, 0x0556d800e1cbc8a0, 0x0558080031cca8a0, 0x0558480031ccd8a0,
	// Entry 140 - 15F
	0x0558880031cd08a0, 0x0559000039cd38a0, 0x0559400039cd70a0, 0x05598001c1cda8a0,
	0x055b8003f1cf68a0, 0x055f800051d358a0, 0x0560015d20058a30, 0x06bd8000b9d3a8a0,
	0x06be580189d460a0, 0x06c0001c00068c10, 0x06dc00040008eb90, 0x06e00020000611f0,
	0x070000c80009c9b0, 0x07c8000b71d5e8a0, 0x07d3800351e158a0, 0x07d8000039e4a8a0,
	0x07d8980029e4e0a0, 0x07d8e800d1e508a0, 0x07d9c00029e5d8a0, 0x07d9f00009e600a0,
	0x07da000011e608a0, 0x07da180011e618a0, 0x07da3003e1e628a0, 0x07de980251ea08a0,
	0x07e0e80919ec58c0, 0x07ea800201f570c0, 0x07ec9001b1f770c0, 0x07ef800071f920c0,
	0x07f00000d1f990c0, 0x07f1000199fa60c0, 0x07f2a00099fbf8c0, 0x07f3400021fc90c0,
	// Entry 160 - 17F
	0x07f3800029fcb0c0, 0x07f3b00439fcd8c0, 0x07f7f8000a0110c0, 0x07f80805f20118c0,
	0x07fe1000320708c0, 0x07fe5000320738c0, 0x07fe9000320768c0, 0x07fed0001a0798c0,
	0x07ff00003a07b0c0, 0x07ff40003a07e8c0, 0x07ffc8002a0820c0, 0x08000000620848c0,
	0x08006800d208a8c0, 0x080140009a0978c0, 0x0801e000120a10c0, 0x0801f8007a0a20c0,
	0x08028000720a98c0, 0x08040003da0b08c0, 0x080800001a0ee0c0, 0x080838016a0ef8c0,
	0x0809b802c21060c0, 0x080c8000621320c0, 0x080d00000a1380c0, 0x080e8001721388c0,
	0x08140000ea14f8c0, 0x081500018a15e0c0, 0x08170000e21768c0, 0x08180001221848c0,
	0x08196800f21968c0, 0x081a80015a1a58c0, 0x081c0000f21bb0c0, 0x081cf8012a1ca0c0,
	// Entry 180 - 19F
	0x081e4000721dc8c0, 0x08200004f21e38c0, 0x08250000522328c0, 0x08258001222378c0,
	0x0826c001222498c0, 0x082800014225b8c0, 0x08298001a226f8c0, 0x082b78000a2898c0,
	0x08300009ba28a0c0, 0x083a0000b23258c0, 0x083b0000423308c0, 0x08400000323348c0,
	0x084040000a3378c0, 0x08405001623380c0, 0x0841b8001234e0c0, 0x0841e0000a34f0c0,
	0x0841f8009a34f8c0, 0x08429000223590e0, 0x0842b8024235b0e0, 0x084538004a37f0e0,
	0x084700009a3838e0, 0x0847a0001238d0e0, 0x0847d8010a38e0e0, 0x0848f800da39e8e0,
	0x0849f8000a3ac0e0, 0x084c0001c23ac8e0, 0x084de000a23c88e0, 0x084e9001923d28e0,
	0x08502800123eb8e0, 0x08506000423ec8e0, 0x0850a8001a3f08e0, 0x0850c800ea3f20e0,
	// Entry 1A0 - 1BF
	0x0851c0001a4008e0, 0x0851f800524020e0, 0x085280004a4070e0, 0x085300020240b8e0,
	0x085600013a42b8e0, 0x085758006243f0e0, 0x08580001b24450e0, 0x0859c800ea4600e0,
	0x085ac000da46e8e0, 0x085bc000d247c0e0, 0x085cc800224890e0, 0x085d48003a48b0e0,
	0x086000024a48e8e0, 0x086400019a4b30e0, 0x086600019a4cc8e0, 0x0867d001724e60e0,
	0x08698000524fd0e0, 0x08730000fa5020e0, 0x08780001425118e0, 0x08798001525258e0,
	0x087f0000ba53a8e0, 0x08800002725460e0, 0x08829000f256d0e0, 0x0883f8021a57c0e0,
	0x088668000a59d8e0, 0x08868000ca59e0e0, 0x08878000525aa8e0, 0x08880001aa5af8e0,
	0x0889b0008a5ca0e0, 0x088a80013a5d28e0, 0x088c0002725e60e0, 0x088e80008260d0e0,
	// Entry 1C0 - 1DF
	0x088f0800a26150e0, 0x089000009261f0e0, 0x08909801626280e0, 0x089400003a63e0e0,
	0x089440000a6418e0, 0x08945000226420e0, 0x089478007a6440e0, 0x0894f8005a64b8e0,
	0x08958001da6510e0, 0x089780005266e8e0, 0x08980000226738e0, 0x08982800426758e0,
	0x08987800126798e0, 0x08989800b267a8e0, 0x089950003a6858e0, 0x08999000126890e0,
	0x0899a8002a68a0e0, 0x0899d8005268c8e0, 0x089a3800126918e0, 0x089a58001a6928e0,
	0x089a80000a6940e0, 0x089ab8000a6948e0, 0x089ae8003a6950e0, 0x089b30003a6988e0,
	0x089b80002a69c0e0, 0x08a00002d269e8e0, 0x08a2d8000a6cb8e0, 0x08a2e8001a6cc0e0,
	0x08a40002426cd8e0, 0x08a68000526f18e0, 0x08ac0001b26f68e0, 0x08adc001327118e0,
	// Entry 1E0 - 1FF
	0x08b000022a7248e0, 0x08b28000527470e0, 0x08b300006a74c0e0, 0x08b40001ca7528e0,
	0x08b600005276f0e0, 0x08b80000da7740e0, 0x08b8e8007a7818e0, 0x08b98000827890e0,
	0x08c00001e27910e0, 0x08c500029a7af0e0, 0x08c7f8000a7d88e0, 0x08cd0000427d90e0,
	0x08cd5001727dd0e0, 0x08ced0005a7f40e0, 0x08d00002427f98e0, 0x08d280029a81d8e0,
	0x08d60001ca8470e0, 0x08e000004a8638e0, 0x08e050016a8680e0, 0x08e1c0007287e8e0,
	0x08e28000ea8858e0, 0x08e38001028940e0, 0x08e49000b28a40e0, 0x08e54800728af0e0,
	0x08e800003a8b60e0, 0x08e84000128b98e0, 0x08e85801628ba8e0, 0x08e9d0000a8d08e0,
	0x08e9e000128d10e0, 0x08e9f8004a8d20e0, 0x08ea8000528d68e0, 0x08eb0000328db8e0,
	// Entry 200 - 21F
	0x08eb3800128de8e0, 0x08eb50012a8df8e0, 0x08ec8000128f20e0, 0x08ec9800328f30e0,
	0x08ed0000528f60e0, 0x08f700001a8fb0e0, 0x08f71800b28fc900, 0x08fe000192907900,
	0x08fff81cda920900, 0x092000037aaee100, 0x092380002ab25900, 0x0924000622b28100,
	0x098000217ab8a100, 0x09a180004ada1900, 0x0a20000322da6100, 0x0a23200f1add8120,
	0x0b400011caec9920, 0x0b520000fafe6120, 0x0b53000052ff5920, 0x0b53700012ffa920,
	0x0b568000f2ffb920, 0x0b5780003300a920, 0x0b5800023300d920, 0x0b5a800053030920,
	0x0b5ad8003b035920, 0x0b5b1800ab039120, 0x0b5be8009b043920, 0x0b720002db04d120,
	0x0b7800025b07a920, 0x0b7a7801cb0a0120, 0x0b7c78008b0bc920, 0x0b7f0000230c5120,
	// Entry 220 - 23F
	0x0b8000bfc00a3250, 0x0c4000179b0c7120, 0x0d800008fb240920, 0x0d8a80001b2d0120,
	0x0d8b2000232d1920, 0x0d8b800a832d3920, 0x0d960001e337b940, 0x0de000035b399940,
	0x0de380006b3cf140, 0x0de400004b3d5940, 0x0de48000533da140, 0x0de4e000433df140,
	0x0e800007b33e3140, 0x0e8800013b45e140, 0x0e89480603471940, 0x0e900002334d1940,
	0x0e970000a34f4940, 0x0e980002bb4fe940, 0x0e9b0000cb52a140, 0x0ea00002ab536940,
	0x0ea2b0023b561140, 0x0ea4f00013584940, 0x0ea510000b585940, 0x0ea5280013586140,
	0x0ea5480023587140, 0x0ea5700063589140, 0x0ea5d8000b58f140, 0x0ea5e8003b58f940,
	0x0ea628020b593140, 0x0ea83800235b3940, 0x0ea86800435b5940, 0x0ea8b0003b5b9940,
	// Entry 240 - 25F
	0x0ea8f000e35bd140, 0x0ea9d800235cb140, 0x0eaa00002b5cd140, 0x0eaa30000b5cf940,
	0x0eaa50003b5d0140, 0x0eaa900aa35d3940, 0x0eb540092367d940, 0x0ebe70049370f940,
	0x0ec3001163758960, 0x0ed4d8002b86e960, 0x0ed508007b871160, 0x0f0000003b878960,
	0x0f0040008b87c160, 0x0f00d8003b884960, 0x0f01180013888160, 0x0f0130002b889160,
	0x0f0800016b88b960, 0x0f098000738a2160, 0x0f0a0000538a9160, 0x0f0a7000138ae160,
	0x0f160001d38af160, 0x0f17f8000b8cc160, 0x0f4000062b8cc960, 0x0f4638008392f160,
	0x0f48000263937160, 0x0f4a80005395d160, 0x0f4af00013962160, 0x0f63880223963160,
	0x0f680801eb985160, 0x0f700000239a3960, 0x0f702800db9a5960, 0x0f710800139b3160,
	// Entry 260 - 27F
	0x0f7120000b9b4160, 0x0f7138000b9b4960, 0x0f714800539b5160, 0x0f71a000239ba160,
	0x0f71c8000b9bc160, 0x0f71d8000b9bc960, 0x0f7210000b9bd160, 0x0f7238000b9bd960,
	0x0f7248000b9be160, 0x0f7258000b9be960, 0x0f7268001b9bf160, 0x0f728800139c0960,
	0x0f72a0000b9c1960, 0x0f72b8000b9c2160, 0x0f72c8000b9c2960, 0x0f72d8000b9c3160,
	0x0f72e8000b9c3960, 0x0f72f8000b9c4160, 0x0f730800139c4960, 0x0f7320000b9c5960,
	0x0f733800239c6160, 0x0f7360003b9c8160, 0x0f73a000239cb960, 0x0f73c800239cd960,
	0x0f73f0000b9cf960, 0x0f740000539d0160, 0x0f7458008b9d5160, 0x0f7508001b9dd960,
	0x0f7528002b9df160, 0x0f7558008b9e1960, 0x0f778000139ea160, 0x0f800001639eb160,
	// Entry 280 - 29F
	0x0f81800323a01160, 0x0f8500007ba33160, 0x0f8588007ba3a960, 0x0f8608007ba42160,
	0x0f8688012ba49960, 0x0f8800006ba5c160, 0x0f888002eba62960, 0x0f8b8001eba91160,
	0x0f8f3000ebaaf960, 0x0f90800163abe160, 0x0f9200004bad4160, 0x0f92800013ad8960,
	0x0f93000033ad9960, 0x0f9800103badc960, 0x0fa8380e7bbe0180, 0x0fb700006bcc7980,
	0x0fb780005bcce180, 0x0fb80003a3cd3980, 0x0fbc0002cbd0d980, 0x0fbf000063d3a180,
	0x0fc0000063d40180, 0x0fc08001c3d46180, 0x0fc2800053d62180, 0x0fc3000143d67180,
	0x0fc48000f3d7b180, 0x0fc8000063d8a180, 0x0fc868032bd90180, 0x0fcb980023dc2980,
	0x0fcbd0014bdc4980, 0x0fcd280033dd9180, 0x0fcd7000ebddc180, 0x0fce68043bdea980,
	// Entry 2A0 - 2BF
	0x0fd3000073e2e180, 0x0fd3800023e35180, 0x0fd3c0001be37180, 0x0fd400001be38980,
	0x0fd4800033e3a180, 0x10000536b800db70, 0x15380081a801b370, 0x15ba0006f0028b70,
	0x15c100b410036370, 0x167580e988043b70, 0x17c00010f3e3d180, 0x700008000bf4c180,
	0x7001000303f4c980, 0x7008000783f7c980, 0x780007fff0078ad0, 0x800007fff0083ad0,
} // Size: 5528 bytes

var index = []uint16{ // 32746 elements
	// Entry 0 - 3F
	0x0000, 0x0005, 0x0015, 0x0023, 0x002e, 0x0039, 0x0045, 0x004e,
	0x0058, 0x0068, 0x0079, 0x0081, 0x008a, 0x008f, 0x009b, 0x00a4,
	0x00ab, 0x00b5, 0x00be, 0x00c7, 0x00d2, 0x00dc, 0x00e6, 0x00ef,
	0x00fa, 0x0105, 0x010f, 0x0114, 0x011d, 0x012b, 0x0136, 0x0147,
	0x0154, 0x0161, 0x0177, 0x018d, 0x01a3, 0x01b9, 0x01cf, 0x01e5,
	0x01fb, 0x0211, 0x0227, 0x023d, 0x0253, 0x0269, 0x027f, 0x0295,
	0x02ab, 0x02c1, 0x02d7, 0x02ed, 0x0303, 0x0319, 0x032f, 0x0345,
	0x035b, 0x0371, 0x0387, 0x039d, 0x03b0, 0x03bf, 0x03d3, 0x03e4,
	// Entry 40 - 7F
	0x03ec, 0x03f8, 0x040c, 0x0420, 0x0434, 0x0448, 0x045c, 0x0470,
	0x0484, 0x0498, 0x04ac, 0x04c0, 0x04d4, 0x04e8, 0x04fc, 0x0510,
	0x0524, 0x0538, 0x054c, 0x0560, 0x0574, 0x0588, 0x059c, 0x05b0,
	0x05c4, 0x05d8, 0x05ec, 0x0600, 0x0612, 0x061f, 0x0632, 0x0637,
	0x0645, 0x065e, 0x0667, 0x0671, 0x067e, 0x0686, 0x0690, 0x069c,
	0x06a5, 0x06b3, 0x06cd, 0x06f6, 0x06fe, 0x0709, 0x0718, 0x071e,
	0x0729, 0x0738, 0x0747, 0x0758, 0x0764, 0x076e, 0x077a, 0x0784,
	0x078b, 0x079a, 0x07b5, 0x07df, 0x07fa, 0x0812, 0x0830, 0x0846,
	// Entry 80 - BF
	0x0867, 0x0888, 0x08ae, 0x08cf, 0x08f4, 0x091a, 0x0931, 0x0954,
	0x0975, 0x0996, 0x09bc, 0x09e1, 0x0a02, 0x0a23, 0x0a49, 0x0a6e,
	0x0a86, 0x0aa7, 0x0ac8, 0x0ae9, 0x0b0f, 0x0b30, 0x0b55, 0x0b68,
	0x0b8a, 0x0bab, 0x0bcc, 0x0bf2, 0x0c17, 0x0c38, 0x0c52, 0x0c6c,
	0x0c8b, 0x0caa, 0x0cce, 0x0ced, 0x0d10, 0x0d34, 0x0d49, 0x0d6a,
	0x0d89, 0x0da8, 0x0dcc, 0x0def, 0x0e0e, 0x0e2d, 0x0e51, 0x0e74,
	0x0e8a, 0x0ea9, 0x0ec8, 0x0ee7, 0x0f0b, 0x0f2a, 0x0f4d, 0x0f5a,
	0x0f7a, 0x0f99, 0x0fb8, 0x0fdc, 0x0fff, 0x101e, 0x1036, 0x1059,
	// Entry C0 - FF
	0x107b, 0x109b, 0x10bc, 0x10db, 0x10fd, 0x111d, 0x113e, 0x115d,
	0x1183, 0x11a7, 0x11cc, 0x11ef, 0x1210, 0x122f, 0x1250, 0x126f,
	0x1291, 0x12b1, 0x12d3, 0x12f3, 0x1314, 0x1333, 0x1358, 0x137b,
	0x139d, 0x13bd, 0x13de, 0x13fd, 0x1423, 0x1447, 0x1468, 0x1487,
	0x14ac, 0x14cf, 0x14f2, 0x1513, 0x1539, 0x155d, 0x157f, 0x159f,
	0x15c0, 0x15df, 0x1601, 0x1621, 0x1642, 0x1661, 0x1683, 0x16a3,
	0x16c8, 0x16e4, 0x16fd, 0x1714, 0x173a, 0x175e, 0x1781, 0x17a2,
	0x17b8, 0x17d9, 0x17f8, 0x181b, 0x183c, 0x185d, 0x187c, 0x18a2,
	// Entry 100 - 13F
	0x18c6, 0x18e8, 0x1908, 0x1929, 0x1948, 0x196b, 0x198c, 0x19ad,
	0x19cc, 0x19f7, 0x1a0f, 0x1a25, 0x1a47, 0x1a67, 0x1a88, 0x1aa7,
	0x1acf, 0x1af5, 0x1b0e, 0x1b25, 0x1b46, 0x1b65, 0x1b88, 0x1ba9,
	0x1bca, 0x1be9, 0x1c0a, 0x1c29, 0x1c4f, 0x1c73, 0x1c96, 0x1cb7,
	0x1cd8, 0x1cf7, 0x1d1a, 0x1d3b, 0x1d5c, 0x1d7b, 0x1d9d, 0x1dbd,
	0x1dde, 0x1dfd, 0x1e1f, 0x1e3f, 0x1e60, 0x1e7f, 0x1ea5, 0x1ec9,
	0x1ef1, 0x1f17, 0x1f39, 0x1f59, 0x1f7f, 0x1fa3, 0x1fc9, 0x1fed,
	0x2012, 0x2033, 0x2052, 0x2077, 0x209a, 0x20bb, 0x20da, 0x20f3,
	// Entry 140 - 17F
	0x2113, 0x2133, 0x2155, 0x2175, 0x2192, 0x21ad, 0x21c8, 0x21e8,
	0x2206, 0x2224, 0x2244, 0x2266, 0x2286, 0x22a5, 0x22c4, 0x22de,
	0x22f9, 0x2319, 0x2337, 0x2357, 0x2371, 0x2386, 0x239f, 0x23c1,
	0x23e1, 0x23ff, 0x241c, 0x2441, 0x245e, 0x2483, 0x24ab, 0x24d3,
	0x24f3, 0x2511, 0x2528, 0x253d, 0x255d, 0x257b, 0x258a, 0x25a7,
	0x25c2, 0x25da, 0x25f8, 0x261e, 0x263e, 0x265c, 0x2686, 0x26a6,
	0x26c4, 0x26e0, 0x2700, 0x2720, 0x273e, 0x2760, 0x2780, 0x2798,
	0x27b9, 0x27d8, 0x27f8, 0x2814, 0x2832, 0x284e, 0x287c, 0x288d,
	// Entry 180 - 1BF
	0x28a6, 0x28c0, 0x28db, 0x28f7, 0x2919, 0x294e, 0x296e, 0x2985,
	0x29af, 0x29c4, 0x29db, 0x2a05, 0x2a1a, 0x2a3b, 0x2a5a, 0x2a7b,
	0x2a9a, 0x2abb, 0x2ada, 0x2afb, 0x2b1a, 0x2b4a, 0x2b78, 0x2ba7,
	0x2bd4, 0x2c03, 0x2c30, 0x2c5f, 0x2c8c, 0x2ca7, 0x2cd7, 0x2d05,
	0x2d35, 0x2d63, 0x2d86, 0x2da7, 0x2dc9, 0x2de9, 0x2e0a, 0x2e29,
	0x2e4a, 0x2e69, 0x2e8b, 0x2eab, 0x2ed8, 0x2f03, 0x2f26, 0x2f47,
	0x2f66, 0x2f7d, 0x2fa7, 0x2fbc, 0x2fdd, 0x2ffc, 0x3016, 0x302f,
	0x3050, 0x306f, 0x309f, 0x30cd, 0x30ef, 0x310f, 0x313b, 0x3165,
	// Entry 1C0 - 1FF
	0x318d, 0x31b3, 0x31dd, 0x3205, 0x322d, 0x3253, 0x327d, 0x32a5,
	0x32cd, 0x32f3, 0x331d, 0x3345, 0x336d, 0x3393, 0x33bd, 0x33e5,
	0x340d, 0x3433, 0x345d, 0x3485, 0x34ad, 0x34d3, 0x34fd, 0x3525,
	0x354c, 0x3571, 0x3598, 0x35bd, 0x35d6, 0x35ed, 0x360e, 0x362d,
	0x3657, 0x3675, 0x368c, 0x36a1, 0x36c1, 0x36df, 0x3704, 0x3727,
	0x374a, 0x376b, 0x379b, 0x37c9, 0x37f5, 0x381f, 0x3844, 0x3867,
	0x3897, 0x38c5, 0x38e7, 0x3907, 0x3925, 0x3943, 0x3961, 0x397d,
	0x399a, 0x39b7, 0x39d9, 0x39fb, 0x3a1b, 0x3a3a, 0x3a65, 0x3a89,
	// Entry 200 - 23F
	0x3aad, 0x3ace, 0x3aed, 0x3b0f, 0x3b29, 0x3b46, 0x3b68, 0x3b88,
	0x3baa, 0x3bca, 0x3bf5, 0x3c18, 0x3c3a, 0x3c5a, 0x3c7c, 0x3c9c,
	0x3cb7, 0x3ccf, 0x3cee, 0x3d0c, 0x3d25, 0x3d43, 0x3d61, 0x3d7f,
	0x3d9c, 0x3db4, 0x3dd6, 0x3def, 0x3e11, 0x3e3d, 0x3e66, 0x3e8e,
	0x3eac, 0x3ec7, 0x3ee3, 0x3efb, 0x3f17, 0x3f32, 0x3f50, 0x3f71,
	0x3f91, 0x3fa8, 0x3fc4, 0x3fea, 0x4008, 0x4030, 0x4047, 0x4062,
	0x408b, 0x40a9, 0x40cc, 0x40f4, 0x4110, 0x412b, 0x4148, 0x4167,
	0x417d, 0x4198, 0x41c1, 0x41e6, 0x4208, 0x4226, 0x4248, 0x4273,
	// Entry 240 - 27F
	0x428f, 0x42b4, 0x42d2, 0x42e8, 0x4319, 0x433e, 0x435e, 0x4379,
	0x43a1, 0x43b9, 0x43d3, 0x43f1, 0x440c, 0x4427, 0x4442, 0x445e,
	0x4486, 0x44a4, 0x44ba, 0x44da, 0x44f3, 0x451b, 0x453d, 0x4555,
	0x4570, 0x458c, 0x45ac, 0x45d2, 0x45ee, 0x4614, 0x462f, 0x464b,
	0x4669, 0x468e, 0x46bc, 0x46d9, 0x46f8, 0x471f, 0x473c, 0x475b,
	0x4782, 0x47a1, 0x47be, 0x47db, 0x47fb, 0x481b, 0x4844, 0x4876,
	0x488d, 0x48ae, 0x48c5, 0x48dc, 0x48fa, 0x4922, 0x494a, 0x4961,
	0x4978, 0x498d, 0x49a9, 0x49c5, 0x49df, 0x49fd, 0x4a1c, 0x4a3a,
	// Entry 280 - 2BF
	0x4a56, 0x4a7b, 0x4a99, 0x4ab8, 0x4ad4, 0x4af2, 0x4b13, 0x4b18,
	0x4b35, 0x4b4b, 0x4b67, 0x4b83, 0x4ba4, 0x4bbe, 0x4bde, 0x4bfe,
	0x4c1e, 0x4c43, 0x4c6a, 0x4c90, 0x4ca7, 0x4cc0, 0x4cd9, 0x4cf3,
	0x4cf8, 0x4d01, 0x4d0b, 0x4d11, 0x4d1c, 0x4d2f, 0x4d4a, 0x4d66,
	0x4d81, 0x4d98, 0x4daf, 0x4dc6, 0x4df1, 0x4e14, 0x4e31, 0x4e4d,
	0x4e69, 0x4e8b, 0x4eb2, 0x4eda, 0x4ef1, 0x4f0c, 0x4f2d, 0x4f4f,
	0x4f6f, 0x4f91, 0x4fb4, 0x4fcc, 0x4fef, 0x5019, 0x5043, 0x505c,
	0x5078, 0x5097, 0x50b4, 0x50d2, 0x50ee, 0x5103, 0x511d, 0x513b,
	// Entry 2C0 - 2FF
	0x5151, 0x5167, 0x5182, 0x5191, 0x51a1, 0x51b3, 0x51c2, 0x51d5,
	0x51e8, 0x51fc, 0x5210, 0x522d, 0x523c, 0x5259, 0x527d, 0x529a,
	0x52af, 0x52c7, 0x52e3, 0x52f8, 0x5316, 0x5331, 0x534d, 0x5369,
	0x5382, 0x539c, 0x53b6, 0x53c4, 0x53e2, 0x53f9, 0x5412, 0x542b,
	0x5445, 0x5465, 0x5483, 0x5496, 0x54af, 0x54c3, 0x54d8, 0x54e9,
	0x54f9, 0x5516, 0x552c, 0x5550, 0x5565, 0x5586, 0x559b, 0x55b9,
	0x55ce, 0x55e4, 0x55f6, 0x560f, 0x5626, 0x5644, 0x5661, 0x5680,
	0x569e, 0x56bd, 0x56dc, 0x56f2, 0x5709, 0x571a, 0x5732, 0x574b,
	// Entry 300 - 33F
	0x5764, 0x577d, 0x5798, 0x57af, 0x57ce, 0x57eb, 0x5801, 0x581c,
	0x5840, 0x585a, 0x5873, 0x588d, 0x58ac, 0x58cc, 0x58e9, 0x5902,
	0x5921, 0x593f, 0x5950, 0x5961, 0x597f, 0x599e, 0x59ce, 0x59ed,
	0x5a06, 0x5a1e, 0x5a39, 0x5a4f, 0x5a6b, 0x5a81, 0x5a98, 0x5ab5,
	0x5acb, 0x5aea, 0x5b11, 0x5b2f, 0x5b4d, 0x5b6b, 0x5b89, 0x5ba7,
	0x5bc5, 0x5be3, 0x5c01, 0x5c1f, 0x5c3d, 0x5c5b, 0x5c79, 0x5c97,
	0x5cb0, 0x5cc7, 0x5ce9, 0x5d09, 0x5d1b, 0x5d33, 0x5d5a, 0x5d7f,
	0x5d92, 0x5dba, 0x5de0, 0x5e0f, 0x5e22, 0x5e3a, 0x5e45, 0x5e5a,
	// Entry 340 - 37F
	0x5e7f, 0x5e8f, 0x5eb6, 0x5ed9, 0x5efd, 0x5f24, 0x5f4b, 0x5f70,
	0x5fa0, 0x5fba, 0x5fd3, 0x5fed, 0x6007, 0x6023, 0x603c, 0x6054,
	0x606e, 0x6087, 0x60a1, 0x60bb, 0x60d2, 0x60e9, 0x6100, 0x611c,
	0x6133, 0x614b, 0x6165, 0x617d, 0x6199, 0x61b1, 0x61c9, 0x61e1,
	0x61fb, 0x6223, 0x624e, 0x6271, 0x6296, 0x62b7, 0x62d9, 0x630c,
	0x6324, 0x633b, 0x6353, 0x636b, 0x6385, 0x639c, 0x63b2, 0x63ca,
	0x63e1, 0x63f9, 0x6411, 0x6426, 0x643b, 0x6450, 0x646a, 0x647f,
	0x6495, 0x64b3, 0x64cb, 0x64e1, 0x64fb, 0x6511, 0x6527, 0x653d,
	// Entry 380 - 3BF
	0x6555, 0x657b, 0x65a4, 0x65c9, 0x65ee, 0x6611, 0x6629, 0x663a,
	0x664c, 0x666a, 0x6692, 0x66be, 0x66ce, 0x66dd, 0x66ed, 0x6707,
	0x6727, 0x673a, 0x6753, 0x6767, 0x6781, 0x6793, 0x67ab, 0x67bd,
	0x67d5, 0x67ef, 0x6807, 0x6820, 0x6837, 0x6851, 0x6869, 0x6883,
	0x689b, 0x68b7, 0x68d1, 0x68ec, 0x6905, 0x691e, 0x6935, 0x6947,
	0x6957, 0x6970, 0x6980, 0x699a, 0x69b5, 0x69d9, 0x69f1, 0x6a07,
	0x6a28, 0x6a40, 0x6a56, 0x6a72, 0x6a9c, 0x6ac4, 0x6af5, 0x6b1a,
	0x6b34, 0x6b4f, 0x6b6a, 0x6b8e, 0x6ba9, 0x6bd9, 0x6bf3, 0x6c0d,
	// Entry 3C0 - 3FF
	0x6c28, 0x6c43, 0x6c5f, 0x6c7a, 0x6c9e, 0x6cbd, 0x6cd9, 0x6cf2,
	0x6d0c, 0x6d26, 0x6d41, 0x6d5b, 0x6d75, 0x6d90, 0x6daa, 0x6dc3,
	0x6de2, 0x6dfc, 0x6e16, 0x6e30, 0x6e4a, 0x6e63, 0x6e7d, 0x6e97,
	0x6eb1, 0x6ecb, 0x6ee4, 0x6efe, 0x6f18, 0x6f33, 0x6f4e, 0x6f69,
	0x6f86, 0x6fa7, 0x6fc3, 0x6fe4, 0x6ffd, 0x7017, 0x7031, 0x7048,
	0x7060, 0x7078, 0x7091, 0x70a9, 0x70c1, 0x70da, 0x70f2, 0x7109,
	0x7126, 0x713e, 0x7156, 0x716e, 0x7186, 0x719d, 0x71b5, 0x71cd,
	0x71e5, 0x71fd, 0x7214, 0x722c, 0x7244, 0x725d, 0x7276, 0x728f,
	// Entry 400 - 43F
	0x72aa, 0x72c9, 0x72e3, 0x7302, 0x7319, 0x7331, 0x7349, 0x736c,
	0x7384, 0x739d, 0x73b6, 0x73d8, 0x73f1, 0x741f, 0x7437, 0x744f,
	0x7468, 0x7481, 0x749b, 0x74b4, 0x74d6, 0x74f3, 0x750d, 0x752a,
	0x7545, 0x7560, 0x7579, 0x759b, 0x75bb, 0x75dd, 0x75fd, 0x7628,
	0x7651, 0x7670, 0x768d, 0x76b5, 0x76db, 0x76f6, 0x770f, 0x772a,
	0x7743, 0x775f, 0x7779, 0x7798, 0x77b5, 0x77ed, 0x7823, 0x783d,
	0x7855, 0x7878, 0x7899, 0x78c1, 0x78e7, 0x7901, 0x7919, 0x7936,
	0x7951, 0x7968, 0x7980, 0x79a1, 0x79c2, 0x79e3, 0x79fe, 0x7a27,
	// Entry 440 - 47F
	0x7a47, 0x7a70, 0x7a97, 0x7abc, 0x7adf, 0x7b03, 0x7b25, 0x7b4c,
	0x7b71, 0x7b98, 0x7bbd, 0x7be9, 0x7c13, 0x7c3d, 0x7c65, 0x7c8e,
	0x7cb5, 0x7cde, 0x7d05, 0x7d34, 0x7d61, 0x7d87, 0x7dab, 0x7dcd,
	0x7ded, 0x7e16, 0x7e3d, 0x7e5d, 0x7e7b, 0x7ea6, 0x7ecf, 0x7ef3,
	0x7f15, 0x7f3e, 0x7f65, 0x7f8e, 0x7fb5, 0x7fd7, 0x7ff7, 0x8025,
	0x8051, 0x807a, 0x80a1, 0x80c1, 0x80df, 0x8109, 0x8131, 0x8161,
	0x818f, 0x81ab, 0x81c5, 0x81ea, 0x820d, 0x8241, 0x8273, 0x828b,
	0x82b1, 0x82d5, 0x82f9, 0x831b, 0x833f, 0x8361, 0x8385, 0x83a7,
	// Entry 480 - 4BF
	0x83cb, 0x83ed, 0x8413, 0x8437, 0x845b, 0x847d, 0x849b, 0x84bf,
	0x84e1, 0x8509, 0x852f, 0x854d, 0x8569, 0x858e, 0x85b1, 0x85ce,
	0x85e9, 0x8615, 0x863f, 0x8669, 0x8691, 0x86ba, 0x86e1, 0x8706,
	0x8729, 0x874e, 0x8771, 0x8799, 0x87bf, 0x87e7, 0x880d, 0x882d,
	0x884b, 0x887a, 0x88a7, 0x88cf, 0x88f5, 0x891a, 0x893d, 0x8965,
	0x898b, 0x89b6, 0x89df, 0x8a09, 0x8a31, 0x8a5b, 0x8a83, 0x8aae,
	0x8ad7, 0x8b07, 0x8b35, 0x8b59, 0x8b7b, 0x8ba1, 0x8bc5, 0x8be4,
	0x8c01, 0x8c21, 0x8c3f, 0x8c5f, 0x8c7d, 0x8c9e, 0x8cbd, 0x8cdd,
	// Entry 4C0 - 4FF
	0x8cfb, 0x8d1b, 0x8d39, 0x8d59, 0x8d77, 0x8d97, 0x8db5, 0x8dd8,
	0x8df9, 0x8e1d, 0x8e3f, 0x8e5a, 0x8e73, 0x8e8e, 0x8ea7, 0x8ec2,
	0x8edb, 0x8ef5, 0x8f0d, 0x8f27, 0x8f3f, 0x8f5f, 0x8f7d, 0x8fa8,
	0x8fd1, 0x8ffc, 0x9025, 0x904e, 0x9075, 0x90a0, 0x90c9, 0x90f2,
	0x9119, 0x9136, 0x9151, 0x916d, 0x9187, 0x91b0, 0x91d7, 0x91f2,
	0x920d, 0x9228, 0x9242, 0x925d, 0x9277, 0x9291, 0x92ab, 0x92c5,
	0x92e0, 0x92fb, 0x9317, 0x9332, 0x934c, 0x9367, 0x9381, 0x939b,
	0x93b7, 0x93d3, 0x93ee, 0x9408, 0x9423, 0x943e, 0x9458, 0x9473,
	// Entry 500 - 53F
	0x948e, 0x94aa, 0x94c4, 0x94df, 0x94fa, 0x9516, 0x9531, 0x954b,
	0x9567, 0x9583, 0x959e, 0x95b8, 0x95d3, 0x95fa, 0x960d, 0x9623,
	0x963c, 0x964a, 0x9660, 0x967a, 0x969a, 0x96b3, 0x96cc, 0x96e5,
	0x96fd, 0x9716, 0x972e, 0x9746, 0x975e, 0x9776, 0x978f, 0x97a8,
	0x97c2, 0x97db, 0x97f3, 0x980c, 0x9824, 0x983c, 0x9856, 0x9870,
	0x9889, 0x98a1, 0x98ba, 0x98d3, 0x98eb, 0x9904, 0x991d, 0x9937,
	0x994f, 0x9968, 0x9981, 0x999b, 0x99b4, 0x99cc, 0x99e6, 0x9a00,
	0x9a19, 0x9a31, 0x9a4a, 0x9a6a, 0x9a8e, 0x9aa0, 0x9aaf, 0x9ad2,
	// Entry 540 - 57F
	0x9af4, 0x9b06, 0x9b1b, 0x9b2e, 0x9b46, 0x9b5f, 0x9b78, 0x9b8c,
	0x9b9f, 0x9bb2, 0x9bc6, 0x9bd9, 0x9bec, 0x9c00, 0x9c1b, 0x9c32,
	0x9c4b, 0x9c67, 0x9c7a, 0x9c94, 0x9ca7, 0x9cbd, 0x9cd1, 0x9cec,
	0x9cff, 0x9d12, 0x9d2e, 0x9d4a, 0x9d5b, 0x9d6d, 0x9d7f, 0x9d92,
	0x9dab, 0x9dbd, 0x9dd5, 0x9ded, 0x9e06, 0x9e18, 0x9e2a, 0x9e3c,
	0x9e4e, 0x9e61, 0x9e73, 0x9e93, 0x9ea6, 0x9ec2, 0x9ed4, 0x9eec,
	0x9efd, 0x9f15, 0x9f2a, 0x9f3e, 0x9f5a, 0x9f6f, 0x9f84, 0x9fa2,
	0x9fbb, 0x9fcd, 0x9fde, 0x9ff1, 0xa004, 0xa014, 0xa025, 0xa038,
	// Entry 580 - 5BF
	0xa049, 0xa05a, 0xa06b, 0xa082, 0xa093, 0xa0a6, 0xa0bd, 0xa0ce,
	0xa0e5, 0xa0f6, 0xa10a, 0xa11c, 0xa132, 0xa142, 0xa15b, 0xa16e,
	0xa17f, 0xa191, 0xa1a3, 0xa1b4, 0xa1c7, 0xa1e9, 0xa208, 0xa22a,
	0xa243, 0xa25f, 0xa271, 0xa282, 0xa298, 0xa2a9, 0xa2bb, 0xa2d3,
	0xa2e9, 0xa301, 0xa30b, 0xa326, 0xa348, 0xa354, 0xa360, 0xa375,
	0xa38d, 0xa39e, 0xa3c6, 0xa3e1, 0xa3ff, 0xa41c, 0xa431, 0xa446,
	0xa477, 0xa48d, 0xa49f, 0xa4b1, 0xa4c3, 0xa4d3, 0xa4e5, 0xa507,
	0xa51b, 0xa535, 0xa548, 0xa56b, 0xa58e, 0xa5b0, 0xa5d3, 0xa5f5,
	// Entry 5C0 - 5FF
	0xa607, 0xa618, 0xa631, 0xa642, 0xa654, 0xa666, 0xa677, 0xa689,
	0xa69a, 0xa6ac, 0xa6bd, 0xa6cf, 0xa6e1, 0xa6f4, 0xa705, 0xa716,
	0xa727, 0xa738, 0xa749, 0xa75c, 0xa783, 0xa7ac, 0xa7d3, 0xa7fe,
	0xa82b, 0xa839, 0xa84a, 0xa85b, 0xa86c, 0xa87d, 0xa88f, 0xa8a1,
	0xa8b2, 0xa8c3, 0xa8dd, 0xa8ee, 0xa8fd, 0xa90c, 0xa91b, 0xa927,
	0xa933, 0xa93f, 0xa94c, 0xa958, 0xa96b, 0xa97d, 0xa98f, 0xa9a4,
	0xa9b9, 0xa9d0, 0xa9df, 0xa9fe, 0xaa26, 0xaa41, 0xaa56, 0xaa70,
	0xaa87, 0xaa9e, 0xaab4, 0xaaca, 0xaae2, 0xaaf9, 0xab10, 0xab26,
	// Entry 600 - 63F
	0xab3e, 0xab56, 0xab6d, 0xab80, 0xab98, 0xabb2, 0xabca, 0xabe3,
	0xabfc, 0xac1a, 0xac32, 0xac5a, 0xac82, 0xac9a, 0xacb7, 0xacd3,
	0xacf3, 0xad0f, 0xad21, 0xad35, 0xad47, 0xad62, 0xad93, 0xada4,
	0xadb7, 0xadca, 0xadec, 0xae1a, 0xae2c, 0xae3e, 0xae65, 0xae78,
	0xae8d, 0xae9f, 0xaeba, 0xaeda, 0xaf08, 0xaf1b, 0xaf2f, 0xaf40,
	0xaf71, 0xaf97, 0xafa9, 0xafc7, 0xafe2, 0xb002, 0xb026, 0xb054,
	0xb079, 0xb08a, 0xb0b0, 0xb0df, 0xb107, 0xb144, 0xb169, 0xb190,
	0xb1b7, 0xb1de, 0xb1f7, 0xb21d, 0xb23d, 0xb24e, 0xb275, 0xb288,
	// Entry 640 - 67F
	0xb2a8, 0xb2cf, 0xb2e2, 0xb2f9, 0xb314, 0xb334, 0xb344, 0xb36b,
	0xb37c, 0xb397, 0xb3aa, 0xb3cf, 0xb3e1, 0xb408, 0xb426, 0xb446,
	0xb46d, 0xb494, 0xb4b5, 0xb4ce, 0xb4e1, 0xb4fd, 0xb525, 0xb542,
	0xb564, 0xb584, 0xb59a, 0xb5c1, 0xb5df, 0xb5fa, 0xb612, 0xb622,
	0xb631, 0xb641, 0xb659, 0xb67e, 0xb68e, 0xb6a5, 0xb6c0, 0xb6de,
	0xb6fe, 0xb70d, 0xb734, 0xb74c, 0xb775, 0xb785, 0xb795, 0xb7ce,
	0xb807, 0xb82a, 0xb844, 0xb85a, 0xb876, 0xb88c, 0xb89e, 0xb8b9,
	0xb8d7, 0xb901, 0xb927, 0xb94b, 0xb960, 0xb977, 0xb987, 0xb997,
	// Entry 680 - 6BF
	0xb9ac, 0xb9c2, 0xb9d8, 0xb9f4, 0xba11, 0xba3c, 0xba51, 0xba72,
	0xba93, 0xbab3, 0xbad2, 0xbaf1, 0xbb12, 0xbb32, 0xbb52, 0xbb71,
	0xbb92, 0xbbb3, 0xbbd3, 0xbbf5, 0xbc15, 0xbc37, 0xbc53, 0xbc76,
	0xbc97, 0xbcae, 0xbcca, 0xbce4, 0xbcfc, 0xbd12, 0xbd29, 0xbd41,
	0xbd5a, 0xbd7e, 0xbda1, 0xbdb3, 0xbdc9, 0xbde2, 0xbdfc, 0xbe14,
	0xbe27, 0xbe46, 0xbe58, 0xbe6b, 0xbe87, 0xbe9b, 0xbebc, 0xbecc,
	0xbedd, 0xbeef, 0xbf01, 0xbf13, 0xbf2e, 0xbf40, 0xbf55, 0xbf67,
	0xbf7b, 0xbf8c, 0xbf9d, 0xbfb2, 0xbfcd, 0xbfdc, 0xbfec, 0xc005,
	// Entry 6C0 - 6FF
	0xc018, 0xc02a, 0xc03c, 0xc04e, 0xc05f, 0xc07a, 0xc096, 0xc0b3,
	0xc0c6, 0xc0d9, 0xc0ed, 0xc100, 0xc113, 0xc127, 0xc139, 0xc14b,
	0xc169, 0xc184, 0xc196, 0xc1a8, 0xc1c1, 0xc1d3, 0xc1e5, 0xc1f1,
	0xc204, 0xc214, 0xc223, 0xc241, 0xc25f, 0xc276, 0xc28d, 0xc2a6,
	0xc2bf, 0xc2cb, 0xc2d9, 0xc2f4, 0xc30f, 0xc327, 0xc35b, 0xc390,
	0xc3c8, 0xc413, 0xc446, 0xc473, 0xc491, 0xc4b6, 0xc4ee, 0xc52c,
	0xc559, 0xc576, 0xc59d, 0xc5c2, 0xc5fc, 0xc62c, 0xc651, 0xc689,
	0xc6ab, 0xc6d4, 0xc70e, 0xc72f, 0xc750, 0xc776, 0xc797, 0xc7b6,
	// Entry 700 - 73F
	0xc7d0, 0xc800, 0xc822, 0xc853, 0xc887, 0xc8c2, 0xc8fe, 0xc939,
	0xc96d, 0xc9aa, 0xc9e9, 0xca2b, 0xca6f, 0xcab2, 0xcaee, 0xcb2c,
	0xcb6f, 0xcbb4, 0xcbf1, 0xcc2f, 0xcc51, 0xcc76, 0xcc87, 0xcc9e,
	0xccb1, 0xccc2, 0xccd3, 0xccea, 0xccfd, 0xcd10, 0xcd23, 0xcd36,
	0xcd49, 0xcd5d, 0xcd6f, 0xcd82, 0xcd95, 0xcdac, 0xcdbf, 0xcdd5,
	0xcdeb, 0xce01, 0xce12, 0xce28, 0xce3e, 0xce55, 0xce67, 0xce79,
	0xce8b, 0xce9f, 0xceb0, 0xcec4, 0xced8, 0xceec, 0xcefc, 0xcf0c,
	0xcf1e, 0xcf32, 0xcf45, 0xcf58, 0xcf66, 0xcf76, 0xcf84, 0xcf94,
	// Entry 740 - 77F
	0xcfa2, 0xcfb2, 0xcfc0, 0xcfd0, 0xcfde, 0xcfee, 0xcffa, 0xd00b,
	0xd019, 0xd026, 0xd033, 0xd042, 0xd050, 0xd05e, 0xd06b, 0xd07a,
	0xd089, 0xd097, 0xd0a3, 0xd0b0, 0xd0bc, 0xd0c8, 0xd0d4, 0xd0e1,
	0xd0ed, 0xd102, 0xd10e, 0xd11b, 0xd128, 0xd135, 0xd142, 0xd150,
	0xd15d, 0xd16a, 0xd178, 0xd185, 0xd193, 0xd1a0, 0xd1ad, 0xd1ba,
	0xd1ce, 0xd1db, 0xd1e9, 0xd1f6, 0xd203, 0xd210, 0xd21d, 0xd232,
	0xd244, 0xd257, 0xd269, 0xd286, 0xd2a2, 0xd2c1, 0xd2e3, 0xd2ff,
	0xd31a, 0xd338, 0xd357, 0xd375, 0xd38d, 0xd3a4, 0xd3b8, 0xd3cd,
	// Entry 780 - 7BF
	0xd3d6, 0xd3ea, 0xd3f8, 0xd406, 0xd415, 0xd423, 0xd438, 0xd44c,
	0xd462, 0xd478, 0xd48b, 0xd49f, 0xd4b3, 0xd4c6, 0xd4da, 0xd4ee,
	0xd503, 0xd519, 0xd52d, 0xd541, 0xd559, 0xd56c, 0xd57f, 0xd597,
	0xd5ab, 0xd5c0, 0xd5d5, 0xd5ea, 0xd5fb, 0xd611, 0xd629, 0xd63e,
	0xd666, 0xd683, 0xd69e, 0xd6b4, 0xd6d4, 0xd6f0, 0xd707, 0xd726,
	0xd741, 0xd757, 0xd778, 0xd794, 0xd7af, 0xd7c5, 0xd7e0, 0xd7fb,
	0xd811, 0xd827, 0xd841, 0xd857, 0xd874, 0xd890, 0xd8ab, 0xd8c4,
	0xd8e0, 0xd900, 0xd91b, 0xd93e, 0xd959, 0xd974, 0xd98e, 0xd9a8,
	// Entry 7C0 - 7FF
	0xd9c5, 0xd9e7, 0xda03, 0xda17, 0xda28, 0xda39, 0xda4a, 0xda5b,
	0xda71, 0xda82, 0xda93, 0xdaa5, 0xdab8, 0xdac9, 0xdada, 0xdaeb,
	0xdafc, 0xdb0d, 0xdb1e, 0xdb2f, 0xdb41, 0xdb52, 0xdb63, 0xdb75,
	0xdb86, 0xdb9d, 0xdbaf, 0xdbc1, 0xdbd9, 0xdbf2, 0xdc09, 0xdc1c,
	0xdc37, 0xdc51, 0xdc6c, 0xdc87, 0xdca2, 0xdcbe, 0xdcd9, 0xdcf3,
	0xdd0e, 0xdd2a, 0xdd45, 0xdd69, 0xdd8b, 0xddb1, 0xddd6, 0xde0b,
	0xde2b, 0xde4c, 0xde74, 0xdea9, 0xdedc, 0xdef7, 0xdf18, 0xdf32,
	0xdf48, 0xdf6f, 0xdf96, 0xdfbc, 0xdfd6, 0xdffe, 0xe025, 0xe045,
	// Entry 800 - 83F
	0xe06c, 0xe093, 0xe0b9, 0xe0e0, 0xe11a, 0xe133, 0xe14c, 0xe166,
	0xe17a, 0xe197, 0xe1ac, 0xe1c1, 0xe1d6, 0xe1f7, 0xe217, 0xe23a,
	0xe259, 0xe277, 0xe293, 0xe2ad, 0xe2c9, 0xe2ea, 0xe306, 0xe321,
	0xe33a, 0xe34c, 0xe35e, 0xe370, 0xe385, 0xe39a, 0xe3af, 0xe3c8,
	0xe3e2, 0xe3f8, 0xe411, 0xe42b, 0xe441, 0xe455, 0xe469, 0xe47d,
	0xe492, 0xe4a8, 0xe4c3, 0xe4de, 0xe4f9, 0xe515, 0xe530, 0xe54c,
	0xe56f, 0xe59b, 0xe5c0, 0xe5d5, 0xe5f5, 0xe619, 0xe634, 0xe64c,
	0xe663, 0xe67c, 0xe68f, 0xe6a3, 0xe6b6, 0xe6ca, 0xe6dd, 0xe6f1,
	// Entry 840 - 87F
	0xe70c, 0xe727, 0xe741, 0xe75a, 0xe76d, 0xe781, 0xe79b, 0xe7b4,
	0xe7c7, 0xe7db, 0xe7ef, 0xe804, 0xe818, 0xe82d, 0xe842, 0xe856,
	0xe86b, 0xe87f, 0xe894, 0xe8a9, 0xe8be, 0xe8d4, 0xe8e9, 0xe8ff,
	0xe914, 0xe928, 0xe93d, 0xe951, 0xe966, 0xe97a, 0xe990, 0xe9a4,
	0xe9b9, 0xe9cd, 0xe9e2, 0xe9f6, 0xea0a, 0xea1e, 0xea33, 0xea47,
	0xea5c, 0xea72, 0xea86, 0xea9b, 0xeab0, 0xeac4, 0xead8, 0xeaf0,
	0xeb09, 0xeb1e, 0xeb36, 0xeb4e, 0xeb65, 0xeb7d, 0xeb94, 0xebac,
	0xebcb, 0xebeb, 0xec09, 0xec26, 0xec3d, 0xec55, 0xec73, 0xec90,
	// Entry 880 - 8BF
	0xeca7, 0xecbf, 0xecd5, 0xecfa, 0xed12, 0xed1f, 0xed3c, 0xed5b,
	0xed72, 0xed89, 0xedac, 0xedc4, 0xeddd, 0xedf1, 0xee07, 0xee1d,
	0xee31, 0xee48, 0xee5d, 0xee71, 0xee86, 0xeea2, 0xeebe, 0xeedd,
	0xeefd, 0xef0d, 0xef24, 0xef39, 0xef4d, 0xef61, 0xef77, 0xef8c,
	0xefa1, 0xefb5, 0xefcb, 0xefe1, 0xeff6, 0xf012, 0xf032, 0xf04c,
	0xf060, 0xf075, 0xf089, 0xf09d, 0xf0b2, 0xf0cf, 0xf0e4, 0xf0fe,
	0xf113, 0xf128, 0xf146, 0xf15c, 0xf171, 0xf17d, 0xf195, 0xf1aa,
	0xf1be, 0xf1ce, 0xf1df, 0xf1ef, 0xf200, 0xf210, 0xf221, 0xf239,
	// Entry 8C0 - 8FF
	0xf251, 0xf261, 0xf272, 0xf282, 0xf293, 0xf2a4, 0xf2b6, 0xf2c7,
	0xf2d9, 0xf2eb, 0xf2fc, 0xf30e, 0xf31f, 0xf331, 0xf343, 0xf355,
	0xf368, 0xf37a, 0xf38d, 0xf39f, 0xf3b0, 0xf3c2, 0xf3d3, 0xf3e5,
	0xf3f6, 0xf407, 0xf419, 0xf42a, 0xf43c, 0xf44d, 0xf45e, 0xf46f,
	0xf480, 0xf492, 0xf4a4, 0xf4b5, 0xf4c6, 0xf4d8, 0xf4ed, 0xf502,
	0xf516, 0xf52b, 0xf53f, 0xf554, 0xf570, 0xf58d, 0xf5a1, 0xf5b6,
	0xf5ca, 0xf5df, 0xf5f2, 0xf60a, 0xf620, 0xf632, 0xf644, 0xf656,
	0xf66f, 0xf688, 0xf6a4, 0xf6c1, 0xf6d3, 0xf6e4, 0xf6f5, 0xf708,
	// Entry 900 - 93F
	0xf71a, 0xf72c, 0xf73d, 0xf750, 0xf763, 0xf775, 0xf79b, 0xf7c0,
	0xf7d2, 0xf7e4, 0xf802, 0xf820, 0xf840, 0xf85f, 0xf897, 0xf8bb,
	0xf8c9, 0xf8db, 0xf8f8, 0xf911, 0xf924, 0xf93c, 0xf94f, 0xf964,
	0xf975, 0xf987, 0xf998, 0xf9aa, 0xf9bb, 0xf9cd, 0xf9df, 0xf9f1,
	0xfa03, 0xfa15, 0xfa27, 0xfa3a, 0xfa4c, 0xfa5f, 0xfa72, 0xfa84,
	0xfa97, 0xfaa9, 0xfabc, 0xfacf, 0xfae2, 0xfaf6, 0xfb09, 0xfb1d,
	0xfb30, 0xfb42, 0xfb55, 0xfb67, 0xfb7a, 0xfb8c, 0xfb9e, 0xfbb1,
	0xfbc3, 0xfbd6, 0xfbe8, 0xfbfa, 0xfc0c, 0xfc1e, 0xfc31, 0xfc43,
	// Entry 940 - 97F
	0xfc56, 0xfc68, 0xfc7a, 0xfc8d, 0xfca3, 0xfcb8, 0xfcce, 0xfce3,
	0xfcf9, 0xfd0f, 0xfd25, 0xfd3b, 0xfd51, 0xfd65, 0xfd78, 0xfd8c,
	0xfda0, 0xfdb2, 0xfdc5, 0xfdd7, 0xfdea, 0xfdfc, 0xfe0e, 0xfe22,
	0xfe35, 0xfe48, 0xfe5a, 0xfe6e, 0xfe82, 0xfe95, 0xfea3, 0xfeb1,
	0xfebd, 0xfec9, 0xfeda, 0xfeee, 0xff08, 0xff21, 0xff37, 0xff4c,
	0xff5d, 0xff6f, 0xff80, 0xff92, 0xffa3, 0xffb5, 0xffce, 0xffe7,
	0xfffe, 0x000f, 0x0021, 0x0038, 0x0049, 0x005b, 0x006d, 0x0080,
	0x0092, 0x00a5, 0x00b8, 0x00ca, 0x00dd, 0x00ef, 0x0102, 0x0115,
	// Entry 980 - 9BF
	0x0128, 0x013c, 0x014f, 0x0163, 0x0176, 0x0188, 0x019b, 0x01ad,
	0x01c0, 0x01d2, 0x01e4, 0x01f7, 0x0209, 0x021c, 0x022e, 0x0240,
	0x0252, 0x0264, 0x0277, 0x0289, 0x029c, 0x02af, 0x02c1, 0x02d3,
	0x02e6, 0x02fc, 0x0312, 0x0327, 0x033d, 0x0352, 0x0368, 0x0385,
	0x03a3, 0x03bf, 0x03d4, 0x03ea, 0x0406, 0x041b, 0x0431, 0x0445,
	0x0450, 0x046a, 0x0484, 0x04a1, 0x04bf, 0x04d2, 0x04e4, 0x04f6,
	0x050a, 0x051d, 0x0530, 0x0542, 0x0556, 0x056a, 0x057d, 0x0597,
	0x05aa, 0x05bd, 0x05d0, 0x05e4, 0x05f8, 0x061b, 0x063b, 0x065f,
	// Entry 9C0 - 9FF
	0x0675, 0x0688, 0x069a, 0x06a8, 0x06b7, 0x06c5, 0x06d4, 0x06e2,
	0x06f1, 0x0707, 0x071d, 0x072b, 0x073a, 0x0748, 0x0757, 0x0766,
	0x0776, 0x0785, 0x0795, 0x07a5, 0x07b4, 0x07c4, 0x07d3, 0x07e3,
	0x07f3, 0x0803, 0x0814, 0x0824, 0x0835, 0x0845, 0x0854, 0x0864,
	0x0873, 0x0883, 0x0892, 0x08a1, 0x08b1, 0x08c0, 0x08d0, 0x08df,
	0x08ee, 0x08fd, 0x090c, 0x091c, 0x092b, 0x093b, 0x094b, 0x095a,
	0x0969, 0x0979, 0x098c, 0x099f, 0x09b1, 0x09c4, 0x09d6, 0x09e9,
	0x0a03, 0x0a1e, 0x0a30, 0x0a43, 0x0a55, 0x0a68, 0x0a79, 0x0a8d,
	// Entry A00 - A3F
	0x0aa1, 0x0ab1, 0x0ac1, 0x0ad1, 0x0ae8, 0x0aff, 0x0b19, 0x0b34,
	0x0b44, 0x0b53, 0x0b62, 0x0b73, 0x0b83, 0x0b93, 0x0ba2, 0x0bb3,
	0x0bc4, 0x0bd4, 0x0be0, 0x0bef, 0x0c09, 0x0c20, 0x0c3d, 0x0c59,
	0x0c72, 0x0c91, 0x0ca4, 0x0cb6, 0x0cc4, 0x0cd3, 0x0ce1, 0x0cf0,
	0x0cfe, 0x0d0d, 0x0d1b, 0x0d2a, 0x0d39, 0x0d47, 0x0d56, 0x0d65,
	0x0d74, 0x0d84, 0x0d93, 0x0da2, 0x0db2, 0x0dc2, 0x0dd2, 0x0de1,
	0x0df0, 0x0e01, 0x0e10, 0x0e1f, 0x0e2e, 0x0e3d, 0x0e4d, 0x0e5c,
	0x0e6c, 0x0e7d, 0x0e8c, 0x0e9c, 0x0eac, 0x0ebb, 0x0eca, 0x0edd,
	// Entry A40 - A7F
	0x0eef, 0x0f02, 0x0f14, 0x0f27, 0x0f39, 0x0f4c, 0x0f5f, 0x0f71,
	0x0f84, 0x0f97, 0x0fa8, 0x0fb0, 0x0fc4, 0x0fd4, 0x0fe3, 0x0ff2,
	0x1003, 0x1013, 0x1023, 0x1032, 0x1043, 0x1054, 0x1064, 0x1074,
	0x108c, 0x10a5, 0x10b3, 0x10c3, 0x10d2, 0x10e2, 0x10f3, 0x1106,
	0x1116, 0x1127, 0x114e, 0x1165, 0x1179, 0x118c, 0x11b0, 0x11bf,
	0x11cf, 0x11de, 0x11ee, 0x11fd, 0x120d, 0x1224, 0x123b, 0x124a,
	0x125a, 0x126a, 0x1279, 0x1289, 0x1299, 0x12a9, 0x12ba, 0x12ca,
	0x12db, 0x12ec, 0x12fc, 0x130d, 0x131d, 0x132e, 0x133f, 0x1350,
	// Entry A80 - ABF
	0x1362, 0x1373, 0x1385, 0x1396, 0x13a6, 0x13b7, 0x13c7, 0x13d8,
	0x13e8, 0x13f8, 0x1409, 0x1419, 0x142a, 0x143a, 0x144a, 0x145a,
	0x146b, 0x147b, 0x148c, 0x149e, 0x14ae, 0x14bf, 0x14d0, 0x14e0,
	0x14f0, 0x1504, 0x1518, 0x152b, 0x153f, 0x1552, 0x1566, 0x1581,
	0x159d, 0x15b0, 0x15c4, 0x15d8, 0x15eb, 0x15ff, 0x1613, 0x1625,
	0x1637, 0x164c, 0x165d, 0x166e, 0x1680, 0x1698, 0x16b0, 0x16cb,
	0x16e7, 0x16f8, 0x1708, 0x1718, 0x172a, 0x173b, 0x174c, 0x175c,
	0x176e, 0x1780, 0x1791, 0x17a4, 0x17d5, 0x1805, 0x1835, 0x1867,
	// Entry AC0 - AFF
	0x1898, 0x18c9, 0x18fc, 0x190d, 0x192d, 0x1945, 0x195a, 0x196e,
	0x1982, 0x1992, 0x19a3, 0x19b3, 0x19c4, 0x19d4, 0x19e5, 0x19fd,
	0x1a15, 0x1a25, 0x1a36, 0x1a47, 0x1a57, 0x1a68, 0x1a79, 0x1a8a,
	0x1a9c, 0x1aad, 0x1abf, 0x1ad1, 0x1ae2, 0x1af4, 0x1b05, 0x1b17,
	0x1b29, 0x1b3b, 0x1b4e, 0x1b60, 0x1b73, 0x1b85, 0x1b96, 0x1ba8,
	0x1bb9, 0x1bcb, 0x1bdc, 0x1bed, 0x1bff, 0x1c10, 0x1c22, 0x1c33,
	0x1c44, 0x1c55, 0x1c67, 0x1c78, 0x1c8a, 0x1c9b, 0x1cad, 0x1cbf,
	0x1cd0, 0x1ce1, 0x1cf3, 0x1d08, 0x1d1d, 0x1d31, 0x1d46, 0x1d5a,
	// Entry B00 - B3F
	0x1d6f, 0x1d8b, 0x1da8, 0x1dbc, 0x1dd1, 0x1de6, 0x1dfa, 0x1e0f,
	0x1e24, 0x1e37, 0x1e4a, 0x1e60, 0x1e71, 0x1e8a, 0x1ea3, 0x1ebf,
	0x1edc, 0x1eee, 0x1eff, 0x1f10, 0x1f23, 0x1f35, 0x1f47, 0x1f58,
	0x1f6b, 0x1f7e, 0x1f90, 0x1fa8, 0x1fc0, 0x1fe7, 0x2001, 0x2018,
	0x202e, 0x2040, 0x2053, 0x2065, 0x2078, 0x208a, 0x209d, 0x20b7,
	0x20d1, 0x20e3, 0x20f6, 0x2109, 0x211b, 0x212e, 0x2141, 0x2154,
	0x2168, 0x217b, 0x218f, 0x21a3, 0x21b6, 0x21ca, 0x21dd, 0x21f1,
	0x2205, 0x2219, 0x222e, 0x2242, 0x2257, 0x226b, 0x227e, 0x2292,
	// Entry B40 - B7F
	0x22a5, 0x22b9, 0x22cc, 0x22e1, 0x22f4, 0x2308, 0x231b, 0x232f,
	0x2342, 0x2355, 0x2368, 0x237c, 0x238f, 0x23a3, 0x23b8, 0x23cb,
	0x23df, 0x23f3, 0x2406, 0x2419, 0x242e, 0x2450, 0x246e, 0x2485,
	0x249c, 0x24b2, 0x24c9, 0x24df, 0x24f6, 0x2514, 0x2533, 0x2549,
	0x2560, 0x2577, 0x258d, 0x25a4, 0x25bb, 0x25d0, 0x25e9, 0x25fc,
	0x2615, 0x262e, 0x2649, 0x2661, 0x2690, 0x26af, 0x26d2, 0x26f2,
	0x270e, 0x2731, 0x274d, 0x2768, 0x2783, 0x279e, 0x27bc, 0x27db,
	0x27ef, 0x2802, 0x2815, 0x282a, 0x283e, 0x2852, 0x2865, 0x287a,
	// Entry B80 - BBF
	0x288f, 0x28a3, 0x28b7, 0x28d3, 0x28f0, 0x290e, 0x2929, 0x294a,
	0x296a, 0x2987, 0x29aa, 0x29bd, 0x29d7, 0x29f0, 0x2a0a, 0x2a23,
	0x2a3d, 0x2a56, 0x2a6d, 0x2a83, 0x2a98, 0x2aae, 0x2ac4, 0x2adb,
	0x2af0, 0x2b06, 0x2b1b, 0x2b31, 0x2b48, 0x2b60, 0x2b77, 0x2b8f,
	0x2ba4, 0x2bba, 0x2bd0, 0x2be5, 0x2bfb, 0x2c11, 0x2c32, 0x2c54,
	0x2c75, 0x2c97, 0x2cb8, 0x2cd6, 0x2cf7, 0x2d19, 0x2d3a, 0x2d5c,
	0x2d7d, 0x2da8, 0x2dc6, 0x2de8, 0x2e0b, 0x2e2d, 0x2e50, 0x2e70,
	0x2e8f, 0x2eb0, 0x2ed2, 0x2ef3, 0x2f15, 0x2f33, 0x2f51, 0x2f72,
	// Entry BC0 - BFF
	0x2f94, 0x2fb5, 0x2fd7, 0x2fed, 0x3008, 0x301e, 0x3034, 0x3052,
	0x3068, 0x3086, 0x30a6, 0x30c4, 0x30da, 0x30fa, 0x3110, 0x3126,
	0x3143, 0x3166, 0x3188, 0x31a9, 0x31c9, 0x31eb, 0x320c, 0x322b,
	0x3245, 0x3264, 0x3281, 0x32aa, 0x32d8, 0x3302, 0x3320, 0x3337,
	0x334d, 0x3363, 0x337b, 0x3392, 0x33a9, 0x33bf, 0x33d7, 0x33ef,
	0x3406, 0x342a, 0x344d, 0x346b, 0x3480, 0x3497, 0x34af, 0x34c7,
	0x34de, 0x34f8, 0x350e, 0x3525, 0x353d, 0x3555, 0x3569, 0x3580,
	0x3596, 0x35ad, 0x35c4, 0x35db, 0x35f8, 0x3612, 0x3627, 0x363c,
	// Entry C00 - C3F
	0x3651, 0x3669, 0x3682, 0x369a, 0x36ae, 0x36c6, 0x36db, 0x36f3,
	0x3707, 0x371e, 0x3733, 0x374d, 0x3761, 0x3776, 0x378b, 0x379c,
	0x37b2, 0x37c3, 0x37d9, 0x37ef, 0x3805, 0x381a, 0x382f, 0x3846,
	0x385a, 0x3872, 0x388a, 0x389f, 0x38ba, 0x38d0, 0x38e6, 0x38fb,
	0x3911, 0x3927, 0x393e, 0x3953, 0x3969, 0x397f, 0x3998, 0x39ad,
	0x39c3, 0x39d8, 0x39f6, 0x3a15, 0x3a2f, 0x3a46, 0x3a5e, 0x3a73,
	0x3a89, 0x3a9f, 0x3aba, 0x3ad4, 0x3aeb, 0x3b02, 0x3b18, 0x3b27,
	0x3b35, 0x3b43, 0x3b53, 0x3b62, 0x3b71, 0x3b7f, 0x3b8f, 0x3b9f,
	// Entry C40 - C7F
	0x3bae, 0x3bc7, 0x3bdc, 0x3be9, 0x3bfc, 0x3c0e, 0x3c21, 0x3c2f,
	0x3c3c, 0x3c4f, 0x3c60, 0x3c73, 0x3c81, 0x3c94, 0x3ca7, 0x3cbb,
	0x3cce, 0x3ce2, 0x3cf5, 0x3d02, 0x3d0f, 0x3d22, 0x3d34, 0x3d47,
	0x3d54, 0x3d61, 0x3d6e, 0x3d81, 0x3d92, 0x3da4, 0x3db6, 0x3dc9,
	0x3dd6, 0x3de3, 0x3df5, 0x3e07, 0x3e14, 0x3e2b, 0x3e42, 0x3e54,
	0x3e66, 0x3e79, 0x3e85, 0x3e96, 0x3ea2, 0x3eb2, 0x3ec8, 0x3ed9,
	0x3eea, 0x3efa, 0x3f0b, 0x3f1b, 0x3f2c, 0x3f3c, 0x3f4d, 0x3f61,
	0x3f77, 0x3f8c, 0x3fa2, 0x3fb2, 0x3fc3, 0x3fd3, 0x3fe4, 0x3ff5,
	// Entry C80 - CBF
	0x3ffe, 0x400d, 0x401d, 0x402c, 0x403f, 0x4054, 0x4061, 0x406f,
	0x407c, 0x4089, 0x4098, 0x40a6, 0x40b4, 0x40c1, 0x40d0, 0x40df,
	0x40ed, 0x40f6, 0x40ff, 0x4111, 0x4124, 0x4137, 0x415c, 0x4186,
	0x41b1, 0x41d5, 0x41f9, 0x4220, 0x4242, 0x4259, 0x4273, 0x4291,
	0x42b1, 0x42d3, 0x42e4, 0x42fa, 0x4311, 0x432d, 0x434e, 0x4369,
	0x4393, 0x43aa, 0x43ca, 0x43ea, 0x4419, 0x443c, 0x4462, 0x447d,
	0x4499, 0x44b4, 0x44ce, 0x44e9, 0x4508, 0x451a, 0x452b, 0x453c,
	0x454f, 0x4561, 0x4573, 0x4584, 0x4597, 0x45aa, 0x45bc, 0x45d2,
	// Entry CC0 - CFF
	0x45e8, 0x4600, 0x4617, 0x462e, 0x4644, 0x465c, 0x4674, 0x468b,
	0x46a2, 0x46ba, 0x46d9, 0x4704, 0x4726, 0x473a, 0x4750, 0x476b,
	0x4786, 0x47a1, 0x47bc, 0x47d2, 0x47e8, 0x47f9, 0x480b, 0x481c,
	0x482e, 0x4840, 0x4851, 0x4863, 0x4874, 0x4886, 0x4898, 0x48ab,
	0x48bd, 0x48d0, 0x48e2, 0x48f3, 0x4905, 0x4916, 0x4928, 0x4939,
	0x494a, 0x495c, 0x496d, 0x497f, 0x4990, 0x49a2, 0x49b5, 0x49c7,
	0x49da, 0x49eb, 0x49fd, 0x4a0e, 0x4a1f, 0x4a30, 0x4a41, 0x4a52,
	0x4a64, 0x4a76, 0x4a87, 0x4a98, 0x4aa8, 0x4abb, 0x4ad7, 0x4ae9,
	// Entry D00 - D3F
	0x4afb, 0x4b10, 0x4b24, 0x4b39, 0x4b4d, 0x4b62, 0x4b7e, 0x4b9b,
	0x4bb7, 0x4bd4, 0x4be8, 0x4bfd, 0x4c11, 0x4c26, 0x4c41, 0x4c57,
	0x4c74, 0x4c92, 0x4cad, 0x4cc2, 0x4cd6, 0x4ce9, 0x4cff, 0x4d16,
	0x4d2e, 0x4d43, 0x4d5f, 0x4d7b, 0x4d99, 0x4dbb, 0x4dda, 0x4e02,
	0x4e1d, 0x4e39, 0x4e54, 0x4e70, 0x4e8c, 0x4ea7, 0x4ec3, 0x4ede,
	0x4efa, 0x4f16, 0x4f33, 0x4f4f, 0x4f6c, 0x4f88, 0x4fa3, 0x4fbf,
	0x4fda, 0x4ff6, 0x5011, 0x502c, 0x5048, 0x5063, 0x507f, 0x509a,
	0x50b6, 0x50d3, 0x50ef, 0x510c, 0x5127, 0x5143, 0x515e, 0x5179,
	// Entry D40 - D7F
	0x5194, 0x51af, 0x51ca, 0x51e6, 0x5202, 0x521d, 0x5238, 0x5252,
	0x526f, 0x5295, 0x52bb, 0x52e1, 0x52f2, 0x5310, 0x5334, 0x5358,
	0x537b, 0x539f, 0x53b5, 0x53cb, 0x53e4, 0x5404, 0x541a, 0x542f,
	0x5450, 0x5471, 0x5492, 0x54b1, 0x54cb, 0x54ef, 0x5512, 0x5529,
	0x5559, 0x5589, 0x55a1, 0x55b8, 0x55da, 0x55fb, 0x561b, 0x563c,
	0x564d, 0x565f, 0x5670, 0x5682, 0x5694, 0x56a5, 0x56b7, 0x56c8,
	0x56da, 0x56ec, 0x56ff, 0x5711, 0x5724, 0x5736, 0x5749, 0x575b,
	0x576c, 0x577e, 0x578f, 0x57a1, 0x57b2, 0x57c3, 0x57d5, 0x57e6,
	// Entry D80 - DBF
	0x57f8, 0x5809, 0x581a, 0x582b, 0x583c, 0x584d, 0x585e, 0x586f,
	0x5881, 0x5891, 0x58a6, 0x58b6, 0x58c7, 0x58d7, 0x58e8, 0x58f8,
	0x590c, 0x591c, 0x592d, 0x5947, 0x595c, 0x5970, 0x5985, 0x5999,
	0x59ae, 0x59c2, 0x59d7, 0x59f0, 0x5a08, 0x5a22, 0x5a37, 0x5a4d,
	0x5a61, 0x5a74, 0x5a85, 0x5aa5, 0x5ac5, 0x5ae5, 0x5b05, 0x5b1c,
	0x5b2e, 0x5b3f, 0x5b50, 0x5b63, 0x5b75, 0x5b87, 0x5b98, 0x5bab,
	0x5bbe, 0x5bd0, 0x5beb, 0x5bff, 0x5c16, 0x5c2e, 0x5c4b, 0x5c62,
	0x5c74, 0x5c86, 0x5c9e, 0x5cb7, 0x5ccf, 0x5ce8, 0x5d04, 0x5d21,
	// Entry DC0 - DFF
	0x5d3d, 0x5d5a, 0x5d70, 0x5d86, 0x5d9c, 0x5db2, 0x5dd6, 0x5dfa,
	0x5e1e, 0x5e3b, 0x5e5b, 0x5e7d, 0x5ea0, 0x5ec4, 0x5ee8, 0x5f0f,
	0x5f36, 0x5f5b, 0x5f80, 0x5fa5, 0x5fca, 0x5fef, 0x6013, 0x6037,
	0x605c, 0x607b, 0x6096, 0x60b0, 0x60cb, 0x60e1, 0x60f8, 0x610e,
	0x6124, 0x613a, 0x6151, 0x6167, 0x617d, 0x6194, 0x61aa, 0x61c0,
	0x61d7, 0x61ed, 0x6212, 0x622c, 0x6245, 0x6264, 0x6283, 0x629b,
	0x62b3, 0x62cb, 0x62e3, 0x6303, 0x6323, 0x634a, 0x6369, 0x638a,
	0x63a1, 0x63b7, 0x63cd, 0x63e5, 0x63fc, 0x6413, 0x6429, 0x6441,
	// Entry E00 - E3F
	0x6459, 0x6470, 0x648a, 0x64a4, 0x64be, 0x64d9, 0x64f0, 0x650f,
	0x6529, 0x6544, 0x655f, 0x657a, 0x6594, 0x65af, 0x65ca, 0x65e5,
	0x65ff, 0x661a, 0x6635, 0x6650, 0x666b, 0x6685, 0x66a0, 0x66bc,
	0x66d7, 0x66f2, 0x670d, 0x6727, 0x6743, 0x675f, 0x677b, 0x6796,
	0x67b2, 0x67ce, 0x67e9, 0x6804, 0x681f, 0x683b, 0x6856, 0x6872,
	0x688d, 0x68a7, 0x68c2, 0x68dc, 0x68f7, 0x6912, 0x692c, 0x6947,
	0x6959, 0x696c, 0x697f, 0x6992, 0x69a4, 0x69b7, 0x69ca, 0x69dd,
	0x69ef, 0x6a02, 0x6a15, 0x6a28, 0x6a3b, 0x6a4d, 0x6a60, 0x6a74,
	// Entry E40 - E7F
	0x6a87, 0x6a9a, 0x6aad, 0x6abf, 0x6ad3, 0x6ae7, 0x6afb, 0x6b0e,
	0x6b22, 0x6b36, 0x6b49, 0x6b5c, 0x6b6f, 0x6b83, 0x6b96, 0x6baa,
	0x6bbd, 0x6bcf, 0x6be2, 0x6bf4, 0x6c07, 0x6c1a, 0x6c2c, 0x6c3e,
	0x6c53, 0x6c6d, 0x6c80, 0x6c9c, 0x6cb8, 0x6ccb, 0x6ce4, 0x6cff,
	0x6d15, 0x6d30, 0x6d45, 0x6d5b, 0x6d76, 0x6d8b, 0x6da0, 0x6db5,
	0x6dcf, 0x6de3, 0x6dfc, 0x6e11, 0x6e26, 0x6e40, 0x6e57, 0x6e6e,
	0x6e85, 0x6e9c, 0x6eb1, 0x6ecd, 0x6ee7, 0x6f03, 0x6f1e, 0x6f3b,
	0x6f56, 0x6f70, 0x6f8b, 0x6fa8, 0x6fc3, 0x6fe0, 0x6ffc, 0x7017,
	// Entry E80 - EBF
	0x7033, 0x704d, 0x706e, 0x708f, 0x70af, 0x70ce, 0x70ee, 0x7109,
	0x7126, 0x7143, 0x7160, 0x717d, 0x719f, 0x71ba, 0x71d4, 0x71ef,
	0x7209, 0x7223, 0x723d, 0x725e, 0x727c, 0x7296, 0x72b0, 0x72cc,
	0x72e8, 0x7304, 0x7320, 0x733a, 0x7356, 0x7377, 0x7396, 0x73ba,
	0x73d1, 0x73ed, 0x7409, 0x7424, 0x743f, 0x7459, 0x7476, 0x7490,
	0x74ab, 0x74c8, 0x74e5, 0x7502, 0x751a, 0x7535, 0x7552, 0x7574,
	0x7594, 0x75b9, 0x75d8, 0x75f5, 0x7614, 0x7636, 0x7653, 0x7672,
	0x768c, 0x76a7, 0x76c4, 0x76de, 0x76f9, 0x7714, 0x7730, 0x7746,
	// Entry EC0 - EFF
	0x775d, 0x776f, 0x7782, 0x7795, 0x77a9, 0x77bc, 0x77ce, 0x77e2,
	0x77f5, 0x7807, 0x781a, 0x782e, 0x7841, 0x7854, 0x7866, 0x787a,
	0x788d, 0x78a0, 0x78b3, 0x78c6, 0x78d9, 0x78eb, 0x78ff, 0x7913,
	0x7928, 0x793e, 0x7953, 0x7968, 0x797e, 0x7994, 0x79aa, 0x79bf,
	0x79d3, 0x79e8, 0x79fc, 0x7a10, 0x7a26, 0x7a3d, 0x7a54, 0x7a69,
	0x7a7e, 0x7a92, 0x7aa7, 0x7abf, 0x7ad4, 0x7ae8, 0x7afd, 0x7b13,
	0x7b28, 0x7b3f, 0x7b55, 0x7b6a, 0x7b7f, 0x7b94, 0x7baa, 0x7bbf,
	0x7bd3, 0x7be8, 0x7bfc, 0x7c10, 0x7c25, 0x7c3d, 0x7c53, 0x7c6c,
	// Entry F00 - F3F
	0x7c84, 0x7c9c, 0x7cb7, 0x7ccc, 0x7ce1, 0x7cf8, 0x7d0d, 0x7d23,
	0x7d3a, 0x7d56, 0x7d72, 0x7d88, 0x7da4, 0x7dc0, 0x7dd7, 0x7ded,
	0x7e0a, 0x7e26, 0x7e42, 0x7e5d, 0x7e7b, 0x7e99, 0x7eb5, 0x7ecb,
	0x7ee1, 0x7efc, 0x7f11, 0x7f2b, 0x7f41, 0x7f57, 0x7f6f, 0x7f87,
	0x7f9f, 0x7fb7, 0x7fcd, 0x7fea, 0x800d, 0x802a, 0x8047, 0x8062,
	0x8080, 0x809e, 0x80bc, 0x80d9, 0x80fb, 0x8117, 0x8134, 0x8157,
	0x8172, 0x8195, 0x81b6, 0x81d7, 0x81f9, 0x821d, 0x823d, 0x825b,
	0x8279, 0x829b, 0x82b8, 0x82d4, 0x82f0, 0x830b, 0x832b, 0x8349,
	// Entry F40 - F7F
	0x8367, 0x8383, 0x83a1, 0x83bd, 0x83db, 0x83f7, 0x8415, 0x8431,
	0x844d, 0x8468, 0x8483, 0x849b, 0x84b8, 0x84da, 0x84f5, 0x8513,
	0x852c, 0x854a, 0x856b, 0x8589, 0x85a9, 0x85c5, 0x85e1, 0x85fd,
	0x8619, 0x8635, 0x8652, 0x866f, 0x868e, 0x86ad, 0x86ca, 0x86e5,
	0x86f9, 0x870d, 0x8721, 0x8736, 0x874b, 0x875f, 0x8773, 0x8788,
	0x879c, 0x87b0, 0x87c4, 0x87d9, 0x87ee, 0x8802, 0x8816, 0x882b,
	0x8840, 0x8855, 0x886a, 0x8880, 0x8896, 0x88ab, 0x88c0, 0x88d6,
	0x88ea, 0x88fe, 0x8912, 0x8927, 0x893c, 0x8950, 0x8964, 0x8979,
	// Entry F80 - FBF
	0x898e, 0x89a3, 0x89b8, 0x89ce, 0x89e4, 0x89f9, 0x8a0e, 0x8a24,
	0x8a38, 0x8a4c, 0x8a60, 0x8a75, 0x8a8a, 0x8a9e, 0x8ab2, 0x8ac7,
	0x8adb, 0x8aef, 0x8b03, 0x8b18, 0x8b2d, 0x8b41, 0x8b55, 0x8b6a,
	0x8b7f, 0x8b94, 0x8ba9, 0x8bbf, 0x8bd5, 0x8bea, 0x8bff, 0x8c15,
	0x8c29, 0x8c3d, 0x8c51, 0x8c66, 0x8c7b, 0x8c8f, 0x8ca3, 0x8cb8,
	0x8ccd, 0x8ce2, 0x8cf8, 0x8d0e, 0x8d23, 0x8d38, 0x8d4d, 0x8d62,
	0x8d78, 0x8d8e, 0x8da3, 0x8db8, 0x8dce, 0x8de4, 0x8dfb, 0x8e12,
	0x8e28, 0x8e3c, 0x8e50, 0x8e64, 0x8e79, 0x8e8e, 0x8ea2, 0x8eb6,
	// Entry FC0 - FFF
	0x8ecb, 0x8edf, 0x8ef3, 0x8f07, 0x8f1c, 0x8f31, 0x8f45, 0x8f59,
	0x8f6e, 0x8f82, 0x8f96, 0x8faa, 0x8fbf, 0x8fd4, 0x8fe8, 0x8ffc,
	0x9011, 0x9025, 0x9039, 0x904d, 0x9062, 0x9077, 0x908b, 0x909f,
	0x90b4, 0x90c8, 0x90dc, 0x90f0, 0x9105, 0x911a, 0x912e, 0x9142,
	0x9157, 0x916c, 0x9181, 0x9197, 0x91ad, 0x91c2, 0x91d6, 0x91ea,
	0x91fe, 0x9213, 0x9228, 0x923c, 0x9250, 0x9265, 0x927a, 0x928f,
	0x92a4, 0x92ba, 0x92d0, 0x92e5, 0x92fa, 0x9310, 0x932b, 0x9346,
	0x9361, 0x937d, 0x9399, 0x93b4, 0x93cf, 0x93eb, 0x93ff, 0x9413,
	// Entry 1000 - 103F
	0x9427, 0x943c, 0x9451, 0x9465, 0x9479, 0x948e, 0x94a3, 0x94b8,
	0x94ce, 0x94e4, 0x94f9, 0x950e, 0x9523, 0x9538, 0x954e, 0x9564,
	0x9579, 0x958e, 0x95a4, 0x95ba, 0x95d1, 0x95e8, 0x95fe, 0x9612,
	0x9626, 0x963a, 0x964f, 0x9664, 0x9678, 0x968c, 0x96a1, 0x96bf,
	0x96dd, 0x96fb, 0x971a, 0x9739, 0x9757, 0x9775, 0x9789, 0x979d,
	0x97b1, 0x97c6, 0x97db, 0x97ef, 0x9803, 0x9818, 0x982d, 0x9842,
	0x9857, 0x986d, 0x9883, 0x9898, 0x98ad, 0x98c3, 0x98d7, 0x98eb,
	0x98ff, 0x9914, 0x9929, 0x993d, 0x9951, 0x9966, 0x997a, 0x998e,
	// Entry 1040 - 107F
	0x99a2, 0x99b7, 0x99cc, 0x99e0, 0x99f4, 0x9a09, 0x9a1e, 0x9a33,
	0x9a48, 0x9a5e, 0x9a74, 0x9a89, 0x9a9e, 0x9ab4, 0x9ac8, 0x9adc,
	0x9af0, 0x9b05, 0x9b1a, 0x9b2e, 0x9b42, 0x9b57, 0x9b6b, 0x9b7f,
	0x9b93, 0x9ba8, 0x9bbd, 0x9bd1, 0x9be5, 0x9bfa, 0x9c0f, 0x9c24,
	0x9c3a, 0x9c50, 0x9c65, 0x9c7a, 0x9c8f, 0x9ca4, 0x9cba, 0x9cd0,
	0x9ce5, 0x9cfa, 0x9d11, 0x9d26, 0x9d3b, 0x9d50, 0x9d66, 0x9d7c,
	0x9d91, 0x9da6, 0x9dbc, 0x9dd1, 0x9de6, 0x9dfb, 0x9e11, 0x9e27,
	0x9e3c, 0x9e51, 0x9e67, 0x9e7c, 0x9e91, 0x9ea6, 0x9ebc, 0x9ed2,
	// Entry 1080 - 10BF
	0x9ee7, 0x9efc, 0x9f12, 0x9f27, 0x9f3c, 0x9f51, 0x9f67, 0x9f7d,
	0x9f92, 0x9fa7, 0x9fbd, 0x9fd2, 0x9fe7, 0x9ffc, 0xa012, 0xa028,
	0xa03d, 0xa052, 0xa068, 0xa07c, 0xa090, 0xa0a4, 0xa0b9, 0xa0ce,
	0xa0e2, 0xa0f6, 0xa10b, 0xa11f, 0xa133, 0xa147, 0xa15c, 0xa171,
	0xa185, 0xa199, 0xa1ae, 0xa1c3, 0xa1d8, 0xa1ed, 0xa220, 0xa244,
	0xa266, 0xa27b, 0xa28d, 0xa29f, 0xa2ad, 0xa2bf, 0xa2cd, 0xa2e3,
	0xa2f9, 0xa315, 0xa327, 0xa339, 0xa34d, 0xa360, 0xa373, 0xa385,
	0xa399, 0xa3ad, 0xa3c0, 0xa3d3, 0xa3e9, 0xa3ff, 0xa414, 0xa429,
	// Entry 10C0 - 10FF
	0xa43e, 0xa455, 0xa46b, 0xa481, 0xa498, 0xa4b4, 0xa4d3, 0xa4e8,
	0xa4fe, 0xa513, 0xa532, 0xa547, 0xa55d, 0xa572, 0xa591, 0xa5a6,
	0xa5bc, 0xa5d1, 0xa5f0, 0xa605, 0xa61b, 0xa630, 0xa649, 0xa662,
	0xa67c, 0xa69c, 0xa6b5, 0xa6ce, 0xa6e8, 0xa701, 0xa720, 0xa738,
	0xa749, 0xa75a, 0xa76b, 0xa77c, 0xa78d, 0xa79e, 0xa7b0, 0xa7c2,
	0xa7d4, 0xa7e6, 0xa7f8, 0xa80a, 0xa81c, 0xa82e, 0xa840, 0xa852,
	0xa864, 0xa876, 0xa888, 0xa89a, 0xa8ac, 0xa8be, 0xa8d0, 0xa8e2,
	0xa8f4, 0xa906, 0xa918, 0xa92a, 0xa93c, 0xa94e, 0xa960, 0xa973,
	// Entry 1100 - 113F
	0xa986, 0xa998, 0xa9aa, 0xa9bc, 0xa9ce, 0xa9e0, 0xa9f3, 0xaa06,
	0xaa19, 0xaa2c, 0xaa3f, 0xaa52, 0xaa64, 0xaa75, 0xaa87, 0xaa99,
	0xaaab, 0xaabd, 0xaacf, 0xaae1, 0xaaf3, 0xab05, 0xab17, 0xab29,
	0xab3b, 0xab4d, 0xab5f, 0xab71, 0xab84, 0xab97, 0xabaa, 0xabbd,
	0xabd0, 0xabe3, 0xabf6, 0xac09, 0xac1c, 0xac2f, 0xac42, 0xac55,
	0xac68, 0xac7a, 0xac8c, 0xac9e, 0xacb0, 0xacc2, 0xacd4, 0xace6,
	0xacf8, 0xad0a, 0xad1c, 0xad2e, 0xad40, 0xad52, 0xad6a, 0xad82,
	0xad9a, 0xadb2, 0xadca, 0xade2, 0xadfb, 0xae0f, 0xae25, 0xae39,
	// Entry 1140 - 117F
	0xae4e, 0xae62, 0xae77, 0xae93, 0xaeb0, 0xaecc, 0xaee0, 0xaef5,
	0xaf0a, 0xaf29, 0xaf3e, 0xaf5d, 0xaf73, 0xaf93, 0xafa8, 0xafc7,
	0xafdd, 0xaffd, 0xb01b, 0xb030, 0xb04f, 0xb065, 0xb085, 0xb0a3,
	0xb0b8, 0xb0d3, 0xb0f2, 0xb110, 0xb12e, 0xb157, 0xb17d, 0xb1a5,
	0xb1c2, 0xb1e7, 0xb21d, 0xb240, 0xb270, 0xb28d, 0xb2af, 0xb2c4,
	0xb2d9, 0xb2ee, 0xb303, 0xb318, 0xb32f, 0xb344, 0xb35a, 0xb36f,
	0xb385, 0xb3a2, 0xb3c0, 0xb3dd, 0xb3f2, 0xb408, 0xb41e, 0xb43e,
	0xb454, 0xb474, 0xb48b, 0xb4ac, 0xb4c2, 0xb4e2, 0xb4f9, 0xb51a,
	// Entry 1180 - 11BF
	0xb530, 0xb550, 0xb567, 0xb588, 0xb5a6, 0xb5ba, 0xb5d8, 0xb5f4,
	0xb609, 0xb620, 0xb635, 0xb64b, 0xb660, 0xb676, 0xb693, 0xb6b1,
	0xb6ce, 0xb6e3, 0xb6f9, 0xb70f, 0xb72f, 0xb745, 0xb765, 0xb77c,
	0xb79d, 0xb7b3, 0xb7d3, 0xb7ea, 0xb80b, 0xb821, 0xb841, 0xb858,
	0xb879, 0xb898, 0xb8ac, 0xb8c2, 0xb8d8, 0xb8ee, 0xb904, 0xb919,
	0xb930, 0xb945, 0xb95b, 0xb970, 0xb986, 0xb9a3, 0xb9b8, 0xb9ce,
	0xb9e4, 0xba04, 0xba1a, 0xba3a, 0xba51, 0xba72, 0xba88, 0xbaa8,
	0xbabf, 0xbae0, 0xbaf6, 0xbb16, 0xbb2d, 0xbb4e, 0xbb6d, 0xbb81,
	// Entry 11C0 - 11FF
	0xbb96, 0xbbb9, 0xbbdc, 0xbbff, 0xbc22, 0xbc37, 0xbc4e, 0xbc63,
	0xbc79, 0xbc8e, 0xbca4, 0xbcc1, 0xbcd6, 0xbcec, 0xbd02, 0xbd22,
	0xbd38, 0xbd58, 0xbd6f, 0xbd90, 0xbda6, 0xbdc6, 0xbddd, 0xbdfe,
	0xbe14, 0xbe34, 0xbe4b, 0xbe6c, 0xbe8b, 0xbe9f, 0xbebb, 0xbed0,
	0xbee7, 0xbefc, 0xbf12, 0xbf27, 0xbf3d, 0xbf5a, 0xbf6f, 0xbf85,
	0xbf9b, 0xbfbb, 0xbfd1, 0xbff1, 0xc008, 0xc029, 0xc03f, 0xc05f,
	0xc076, 0xc097, 0xc0ad, 0xc0cd, 0xc0e4, 0xc105, 0xc124, 0xc138,
	0xc156, 0xc16b, 0xc18a, 0xc1a5, 0xc1ba, 0xc1d1, 0xc1e6, 0xc1fc,
	// Entry 1200 - 123F
	0xc211, 0xc227, 0xc244, 0xc259, 0xc26f, 0xc285, 0xc2a5, 0xc2bb,
	0xc2db, 0xc2f2, 0xc313, 0xc332, 0xc346, 0xc363, 0xc378, 0xc38d,
	0xc3a4, 0xc3b9, 0xc3cf, 0xc3e4, 0xc3fa, 0xc417, 0xc42c, 0xc442,
	0xc458, 0xc478, 0xc48e, 0xc4ae, 0xc4c5, 0xc4e6, 0xc4fc, 0xc51c,
	0xc533, 0xc554, 0xc56a, 0xc58a, 0xc5a1, 0xc5c2, 0xc5d6, 0xc5f4,
	0xc60f, 0xc624, 0xc63b, 0xc650, 0xc666, 0xc67b, 0xc691, 0xc6ae,
	0xc6c3, 0xc6d9, 0xc6ef, 0xc70f, 0xc725, 0xc745, 0xc75c, 0xc77d,
	0xc793, 0xc7b3, 0xc7ca, 0xc7eb, 0xc801, 0xc821, 0xc838, 0xc859,
	// Entry 1240 - 127F
	0xc878, 0xc88c, 0xc8ab, 0xc8c0, 0xc8de, 0xc8fe, 0xc91c, 0xc93a,
	0xc959, 0xc978, 0xc997, 0xc9b6, 0xc9cc, 0xc9e2, 0xc9f9, 0xca0f,
	0xca26, 0xca3c, 0xca53, 0xca6a, 0xca8b, 0xcaa2, 0xcac3, 0xcadb,
	0xcafd, 0xcb14, 0xcb35, 0xcb4d, 0xcb6f, 0xcb86, 0xcba7, 0xcbbf,
	0xcbe1, 0xcbf6, 0xcc0b, 0xcc22, 0xcc37, 0xcc4d, 0xcc62, 0xcc78,
	0xcc95, 0xccaa, 0xccc0, 0xccd6, 0xccf6, 0xcd0c, 0xcd2c, 0xcd43,
	0xcd64, 0xcd7a, 0xcd9a, 0xcdb1, 0xcdd2, 0xcde8, 0xce08, 0xce1f,
	0xce40, 0xce5f, 0xce73, 0xce92, 0xceb0, 0xcecc, 0xcee1, 0xcefd,
	// Entry 1280 - 12BF
	0xcf1c, 0xcf33, 0xcf48, 0xcf5e, 0xcf73, 0xcf89, 0xcfa8, 0xcfbd,
	0xcfd3, 0xcff2, 0xd009, 0xd02a, 0xd03e, 0xd05c, 0xd077, 0xd08c,
	0xd0a3, 0xd0b8, 0xd0ce, 0xd0e3, 0xd0f9, 0xd10e, 0xd124, 0xd13b,
	0xd15c, 0xd170, 0xd186, 0xd1a3, 0xd1b9, 0xd1d6, 0xd1ed, 0xd20b,
	0xd221, 0xd238, 0xd24e, 0xd265, 0xd27d, 0xd29f, 0xd2b4, 0xd2cb,
	0xd2e2, 0xd2f9, 0xd310, 0xd326, 0xd33c, 0xd352, 0xd368, 0xd37e,
	0xd39b, 0xd3b8, 0xd3d6, 0xd3f3, 0xd411, 0xd42e, 0xd44c, 0xd468,
	0xd484, 0xd499, 0xd4b0, 0xd4c5, 0xd4db, 0xd4f0, 0xd506, 0xd51b,
	// Entry 12C0 - 12FF
	0xd531, 0xd545, 0xd55c, 0xd573, 0xd58a, 0xd5a1, 0xd5c0, 0xd5df,
	0xd5fe, 0xd61d, 0xd635, 0xd64b, 0xd662, 0xd678, 0xd68f, 0xd6a5,
	0xd6bc, 0xd6d1, 0xd6e7, 0xd704, 0xd721, 0xd73e, 0xd75b, 0xd77c,
	0xd79d, 0xd7be, 0xd7df, 0xd7ff, 0xd815, 0xd82c, 0xd842, 0xd859,
	0xd86f, 0xd886, 0xd89b, 0xd8b9, 0xd8d7, 0xd8f6, 0xd914, 0xd933,
	0xd951, 0xd970, 0xd98d, 0xd9a9, 0xd9c7, 0xd9e5, 0xda03, 0xda21,
	0xda40, 0xda5f, 0xda7e, 0xda9d, 0xdabc, 0xdadb, 0xdafa, 0xdb19,
	0xdb38, 0xdb57, 0xdb76, 0xdb95, 0xdbb1, 0xdbcd, 0xdbe9, 0xdc05,
	// Entry 1300 - 133F
	0xdc23, 0xdc41, 0xdc5f, 0xdc7e, 0xdc9c, 0xdcba, 0xdcd7, 0xdcf4,
	0xdd11, 0xdd2f, 0xdd4c, 0xdd69, 0xdd86, 0xdda3, 0xddc0, 0xddde,
	0xddfb, 0xde18, 0xde36, 0xde54, 0xde72, 0xde91, 0xdeaf, 0xdecd,
	0xdeeb, 0xdf09, 0xdf27, 0xdf46, 0xdf64, 0xdf82, 0xdfa0, 0xdfbe,
	0xdfdc, 0xdffb, 0xe019, 0xe037, 0xe054, 0xe071, 0xe08e, 0xe0ac,
	0xe0c9, 0xe0e6, 0xe102, 0xe11f, 0xe13c, 0xe159, 0xe177, 0xe194,
	0xe1b1, 0xe1cf, 0xe1ed, 0xe20b, 0xe22a, 0xe248, 0xe266, 0xe284,
	0xe2a2, 0xe2c0, 0xe2df, 0xe2fd, 0xe31b, 0xe338, 0xe355, 0xe372,
	// Entry 1340 - 137F
	0xe38f, 0xe3ad, 0xe3ca, 0xe3e7, 0xe404, 0xe421, 0xe43e, 0xe45c,
	0xe479, 0xe496, 0xe4b3, 0xe4d0, 0xe4ed, 0xe50b, 0xe528, 0xe545,
	0xe562, 0xe57e, 0xe59b, 0xe5b8, 0xe5d6, 0xe5f3, 0xe60f, 0xe62c,
	0xe64a, 0xe668, 0xe686, 0xe6a5, 0xe6c3, 0xe6e1, 0xe6fe, 0xe71b,
	0xe738, 0xe756, 0xe773, 0xe790, 0xe7ae, 0xe7cc, 0xe7ea, 0xe809,
	0xe827, 0xe845, 0xe863, 0xe881, 0xe89f, 0xe8be, 0xe8dc, 0xe8fa,
	0xe919, 0xe938, 0xe957, 0xe977, 0xe996, 0xe9b5, 0xe9d3, 0xe9f1,
	0xea0f, 0xea2e, 0xea4c, 0xea6a, 0xea87, 0xeaa4, 0xeac1, 0xeadf,
	// Entry 1380 - 13BF
	0xeafc, 0xeb19, 0xeb35, 0xeb59, 0xeb77, 0xeb95, 0xebb3, 0xebd2,
	0xebf0, 0xec0e, 0xec2b, 0xec48, 0xec65, 0xec83, 0xeca0, 0xecbd,
	0xecdb, 0xecf9, 0xed17, 0xed36, 0xed54, 0xed72, 0xed8f, 0xedad,
	0xedcb, 0xede9, 0xee08, 0xee26, 0xee44, 0xee62, 0xee80, 0xee9e,
	0xeebd, 0xeedb, 0xeef9, 0xef18, 0xef37, 0xef56, 0xef76, 0xef95,
	0xefb4, 0xefcf, 0xefeb, 0xf001, 0xf018, 0xf02f, 0xf047, 0xf05e,
	0xf076, 0xf08d, 0xf0a5, 0xf0c8, 0xf0ea, 0xf10d, 0xf12f, 0xf152,
	0xf174, 0xf197, 0xf1bd, 0xf1db, 0xf1eb, 0xf1fd, 0xf20e, 0xf220,
	// Entry 13C0 - 13FF
	0xf231, 0xf242, 0xf253, 0xf264, 0xf276, 0xf287, 0xf299, 0xf2aa,
	0xf2bb, 0xf2cf, 0xf2e2, 0xf2f3, 0xf304, 0xf314, 0xf323, 0xf337,
	0xf34b, 0xf35f, 0xf36e, 0xf383, 0xf394, 0xf3ac, 0xf3be, 0xf3d0,
	0xf3eb, 0xf406, 0xf414, 0xf42a, 0xf439, 0xf447, 0xf455, 0xf476,
	0xf486, 0xf49a, 0xf4ab, 0xf4bc, 0xf4cd, 0xf4eb, 0xf508, 0xf516,
	0xf525, 0xf534, 0xf551, 0xf563, 0xf573, 0xf586, 0xf594, 0xf5a4,
	0xf5bc, 0xf5cc, 0xf5e5, 0xf5fa, 0xf60e, 0xf62f, 0xf64f, 0xf66d,
	0xf68b, 0xf6a0, 0xf6ba, 0xf6c8, 0xf6dc, 0xf6ec, 0xf70a, 0xf726,
	// Entry 1400 - 143F
	0xf73b, 0xf757, 0xf76f, 0xf784, 0xf7a8, 0xf7c5, 0xf7d3, 0xf7e1,
	0xf7fd, 0xf81a, 0xf828, 0xf84d, 0xf86e, 0xf883, 0xf896, 0xf8ad,
	0xf8c6, 0xf8e5, 0xf903, 0xf922, 0xf937, 0xf94a, 0xf95a, 0xf973,
	0xf98f, 0xf99f, 0xf9af, 0xf9c3, 0xf9d4, 0xf9e6, 0xf9f7, 0xfa12,
	0xfa2c, 0xfa45, 0xfa53, 0xfa61, 0xfa79, 0xfa93, 0xfaaa, 0xfabd,
	0xfad2, 0xfae7, 0xfaf5, 0xfb04, 0xfb13, 0xfb30, 0xfb4d, 0xfb6a,
	0xfb87, 0xfba6, 0xfbb6, 0xfbc6, 0xfbd6, 0xfbe7, 0xfbf8, 0xfc0a,
	0xfc1b, 0xfc2c, 0xfc3d, 0xfc4e, 0xfc5f, 0xfc70, 0xfc81, 0xfc92,
	// Entry 1440 - 147F
	0xfca3, 0xfcb4, 0xfcc5, 0xfcd9, 0xfced, 0xfd00, 0xfd10, 0xfd20,
	0xfd30, 0xfd41, 0xfd52, 0xfd64, 0xfd75, 0xfd86, 0xfd97, 0xfda8,
	0xfdb9, 0xfdca, 0xfddb, 0xfdec, 0xfdfd, 0xfe0e, 0xfe1f, 0xfe30,
	0xfe44, 0xfe58, 0xfe6d, 0xfe8a, 0xfea7, 0xfeb5, 0xfec3, 0xfed1,
	0xfee0, 0xfeef, 0xfeff, 0xff0e, 0xff1d, 0xff2c, 0xff3b, 0xff4a,
	0xff59, 0xff68, 0xff77, 0xff86, 0xff95, 0xffa4, 0xffb3, 0xffc5,
	0xffd7, 0xffe8, 0xfff9, 0x000a, 0x001c, 0x002e, 0x0041, 0x0053,
	0x0065, 0x0077, 0x0089, 0x009b, 0x00ad, 0x00bf, 0x00d1, 0x00e3,
	// Entry 1480 - 14BF
	0x00f5, 0x010a, 0x011f, 0x012e, 0x013e, 0x014d, 0x015d, 0x016d,
	0x017c, 0x018c, 0x019b, 0x01ab, 0x01bb, 0x01ca, 0x01db, 0x01ea,
	0x01fb, 0x020b, 0x021a, 0x022a, 0x0239, 0x0249, 0x0258, 0x0267,
	0x0277, 0x0286, 0x0296, 0x02a5, 0x02b4, 0x02c3, 0x02d2, 0x02e1,
	0x02f1, 0x0301, 0x0310, 0x031f, 0x032e, 0x033d, 0x0358, 0x0373,
	0x038d, 0x03a8, 0x03c2, 0x03dd, 0x03f8, 0x0414, 0x042e, 0x0449,
	0x0463, 0x047e, 0x0498, 0x04b3, 0x04d7, 0x04fb, 0x0516, 0x052d,
	0x0544, 0x0557, 0x0569, 0x057c, 0x058e, 0x05a1, 0x05b3, 0x05c6,
	// Entry 14C0 - 14FF
	0x05d9, 0x05ec, 0x05ff, 0x0612, 0x0624, 0x0637, 0x064a, 0x065d,
	0x0670, 0x0682, 0x0694, 0x06ac, 0x06c2, 0x06d4, 0x06e5, 0x06f5,
	0x070b, 0x071d, 0x072d, 0x0745, 0x0756, 0x0766, 0x077b, 0x078a,
	0x079f, 0x07b9, 0x07cb, 0x07dc, 0x07f2, 0x0804, 0x081e, 0x0836,
	0x0849, 0x0859, 0x0868, 0x0877, 0x0888, 0x0898, 0x08a8, 0x08b7,
	0x08c8, 0x08d9, 0x08e9, 0x0903, 0x091e, 0x0938, 0x0952, 0x096d,
	0x0988, 0x09a8, 0x09c7, 0x09e6, 0x0a06, 0x0a15, 0x0a27, 0x0a36,
	0x0a49, 0x0a58, 0x0a6b, 0x0a85, 0x0aac, 0x0ac2, 0x0adc, 0x0aec,
	// Entry 1500 - 153F
	0x0b11, 0x0b36, 0x0b5d, 0x0b76, 0x0b8a, 0x0b9d, 0x0bb0, 0x0bc5,
	0x0bd9, 0x0bed, 0x0c00, 0x0c15, 0x0c2a, 0x0c3e, 0x0c50, 0x0c62,
	0x0c74, 0x0c86, 0x0c98, 0x0cab, 0x0cbe, 0x0cd1, 0x0ce4, 0x0cf8,
	0x0d0b, 0x0d1e, 0x0d31, 0x0d44, 0x0d57, 0x0d6a, 0x0d7d, 0x0d91,
	0x0da4, 0x0db7, 0x0dcb, 0x0dde, 0x0df1, 0x0e04, 0x0e17, 0x0e2a,
	0x0e3d, 0x0e51, 0x0e65, 0x0e78, 0x0e8c, 0x0ea0, 0x0eb4, 0x0ec8,
	0x0edc, 0x0f01, 0x0f18, 0x0f2f, 0x0f46, 0x0f5d, 0x0f75, 0x0f8d,
	0x0fa6, 0x0fbe, 0x0fd6, 0x0fee, 0x1006, 0x101e, 0x1036, 0x104e,
	// Entry 1540 - 157F
	0x1067, 0x107f, 0x1098, 0x10b0, 0x10c8, 0x10e0, 0x10f9, 0x1112,
	0x112b, 0x1144, 0x115d, 0x1174, 0x118b, 0x11a3, 0x11bb, 0x11d2,
	0x11eb, 0x1203, 0x121b, 0x1233, 0x124b, 0x1264, 0x127c, 0x1294,
	0x12ac, 0x12c4, 0x12dd, 0x12f6, 0x130f, 0x1327, 0x1340, 0x1359,
	0x1372, 0x138b, 0x13a5, 0x13bf, 0x13d9, 0x13f4, 0x1416, 0x143c,
	0x1461, 0x1481, 0x14a2, 0x14cc, 0x14ec, 0x1512, 0x152d, 0x1548,
	0x1564, 0x1581, 0x159d, 0x15ba, 0x15d8, 0x15f5, 0x1612, 0x162e,
	0x164a, 0x1666, 0x1683, 0x16a0, 0x16bd, 0x16d9, 0x16f5, 0x1716,
	// Entry 1580 - 15BF
	0x1738, 0x175c, 0x1780, 0x17a3, 0x17c7, 0x17eb, 0x1810, 0x1833,
	0x1857, 0x187b, 0x189f, 0x18c3, 0x18e6, 0x1906, 0x1927, 0x194b,
	0x196c, 0x1990, 0x19a5, 0x19ba, 0x19d0, 0x19e6, 0x19fc, 0x1a12,
	0x1a29, 0x1a3f, 0x1a55, 0x1a6c, 0x1a82, 0x1a98, 0x1aae, 0x1ac4,
	0x1ada, 0x1af0, 0x1b07, 0x1b1e, 0x1b36, 0x1b4c, 0x1b62, 0x1b78,
	0x1b8e, 0x1bac, 0x1bc3, 0x1be2, 0x1bf8, 0x1c16, 0x1c2d, 0x1c4c,
	0x1c63, 0x1c79, 0x1c90, 0x1ca6, 0x1cbd, 0x1cd3, 0x1cef, 0x1d0b,
	0x1d27, 0x1d43, 0x1d5f, 0x1d7b, 0x1d97, 0x1db4, 0x1dd0, 0x1dec,
	// Entry 15C0 - 15FF
	0x1e0f, 0x1e32, 0x1e4f, 0x1e6f, 0x1e8f, 0x1ea6, 0x1ebd, 0x1ed5,
	0x1eed, 0x1f05, 0x1f1d, 0x1f35, 0x1f53, 0x1f71, 0x1f8e, 0x1fac,
	0x1fcf, 0x1fed, 0x200b, 0x2028, 0x2046, 0x2066, 0x2086, 0x20a9,
	0x20c3, 0x20d2, 0x20e2, 0x20f1, 0x2101, 0x2111, 0x2120, 0x2130,
	0x213f, 0x214f, 0x215f, 0x216e, 0x217e, 0x218d, 0x219d, 0x21ac,
	0x21bb, 0x21cb, 0x21da, 0x21ea, 0x21f9, 0x2208, 0x2217, 0x2226,
	0x2235, 0x2245, 0x2255, 0x2264, 0x2273, 0x2284, 0x2294, 0x22a6,
	0x22b8, 0x22ca, 0x22dd, 0x22f0, 0x2303, 0x2316, 0x2328, 0x233a,
	// Entry 1600 - 163F
	0x2353, 0x236c, 0x2385, 0x239a, 0x23b0, 0x23cb, 0x23e0, 0x23f5,
	0x240a, 0x241f, 0x2434, 0x2449, 0x245d, 0x2471, 0x2480, 0x248e,
	0x24a4, 0x24b7, 0x24c7, 0x24d6, 0x24e5, 0x24f6, 0x2506, 0x2516,
	0x2525, 0x2536, 0x2547, 0x2557, 0x2567, 0x2577, 0x2588, 0x2599,
	0x25a9, 0x25b9, 0x25c9, 0x25da, 0x25ea, 0x25fa, 0x260b, 0x261b,
	0x262b, 0x263b, 0x264b, 0x265b, 0x266c, 0x267e, 0x268e, 0x269d,
	0x26ac, 0x26bc, 0x26cc, 0x26db, 0x26eb, 0x26fa, 0x270a, 0x2719,
	0x272a, 0x273a, 0x274e, 0x2762, 0x2776, 0x278a, 0x279e, 0x27b8,
	// Entry 1640 - 167F
	0x27d1, 0x27eb, 0x2805, 0x2820, 0x2839, 0x2852, 0x286c, 0x2887,
	0x28a1, 0x28bb, 0x28d5, 0x28ee, 0x2907, 0x2921, 0x293c, 0x2956,
	0x296f, 0x2989, 0x29a2, 0x29bc, 0x29d7, 0x29f1, 0x2a0a, 0x2a24,
	0x2a3d, 0x2a57, 0x2a71, 0x2a8b, 0x2aa4, 0x2abd, 0x2ad6, 0x2af0,
	0x2b0a, 0x2b24, 0x2b3d, 0x2b56, 0x2b6f, 0x2b8a, 0x2ba5, 0x2bbf,
	0x2bd9, 0x2bf4, 0x2c0e, 0x2c34, 0x2c4d, 0x2c66, 0x2c7e, 0x2c97,
	0x2caf, 0x2cc8, 0x2ce0, 0x2cf9, 0x2d12, 0x2d2b, 0x2d45, 0x2d5e,
	0x2d77, 0x2d91, 0x2dab, 0x2dc4, 0x2dde, 0x2df9, 0x2e13, 0x2e2d,
	// Entry 1680 - 16BF
	0x2e47, 0x2e61, 0x2e7b, 0x2e92, 0x2ea9, 0x2ebf, 0x2ed4, 0x2ee9,
	0x2f00, 0x2f16, 0x2f2c, 0x2f41, 0x2f58, 0x2f6f, 0x2f85, 0x2f9f,
	0x2fb3, 0x2fc8, 0x2fdf, 0x2ff5, 0x300a, 0x301f, 0x3035, 0x304b,
	0x3066, 0x3080, 0x309a, 0x30b5, 0x30ca, 0x30e4, 0x30fd, 0x3116,
	0x3130, 0x314a, 0x3160, 0x3175, 0x3189, 0x319d, 0x31b2, 0x31c7,
	0x31e1, 0x31fa, 0x3213, 0x322d, 0x3241, 0x325a, 0x3272, 0x328a,
	0x32a3, 0x32bc, 0x32ce, 0x32e0, 0x32f3, 0x3307, 0x3319, 0x332b,
	0x333d, 0x3350, 0x3362, 0x3374, 0x3386, 0x3399, 0x33ab, 0x33bd,
	// Entry 16C0 - 16FF
	0x33d0, 0x33e4, 0x33f6, 0x3408, 0x341a, 0x342c, 0x343e, 0x344f,
	0x3461, 0x3476, 0x348b, 0x34a0, 0x34b5, 0x34cb, 0x34db, 0x34f2,
	0x3509, 0x3521, 0x3539, 0x354f, 0x3566, 0x357d, 0x3590, 0x35a7,
	0x35bf, 0x35d5, 0x35eb, 0x3602, 0x3615, 0x3629, 0x3643, 0x3655,
	0x366e, 0x3682, 0x3699, 0x36b1, 0x36c7, 0x36de, 0x36f0, 0x3702,
	0x3719, 0x3731, 0x3748, 0x375e, 0x3774, 0x378b, 0x379d, 0x37b3,
	0x37ca, 0x37dc, 0x37ef, 0x3801, 0x3814, 0x3826, 0x383e, 0x3856,
	0x386d, 0x3884, 0x3897, 0x38a8, 0x38be, 0x38cf, 0x38e1, 0x38f2,
	// Entry 1700 - 173F
	0x3904, 0x3916, 0x3928, 0x393b, 0x3953, 0x3974, 0x3995, 0x39b8,
	0x39d2, 0x39f3, 0x3a11, 0x3a3d, 0x3a57, 0x3a71, 0x3a8b, 0x3a9e,
	0x3ab3, 0x3ace, 0x3ae4, 0x3aff, 0x3b14, 0x3b2a, 0x3b40, 0x3b57,
	0x3b6c, 0x3b82, 0x3b97, 0x3bb3, 0x3bc9, 0x3bde, 0x3bf4, 0x3c0a,
	0x3c20, 0x3c3b, 0x3c57, 0x3c6d, 0x3c81, 0x3c95, 0x3caf, 0x3cc9,
	0x3ce3, 0x3cf8, 0x3d0d, 0x3d2a, 0x3d4e, 0x3d66, 0x3d7d, 0x3d94,
	0x3dad, 0x3dc5, 0x3ddd, 0x3df4, 0x3e0d, 0x3e26, 0x3e3e, 0x3e56,
	0x3e6d, 0x3e84, 0x3e9d, 0x3eb5, 0x3ecd, 0x3ee4, 0x3efd, 0x3f16,
	// Entry 1740 - 177F
	0x3f2e, 0x3f41, 0x3f58, 0x3f6b, 0x3f7d, 0x3f8e, 0x3fa2, 0x3fc5,
	0x3fdc, 0x3fee, 0x4003, 0x4018, 0x4030, 0x4042, 0x4055, 0x4078,
	0x4090, 0x40a2, 0x40bb, 0x40cf, 0x40e2, 0x40fd, 0x4116, 0x4136,
	0x4161, 0x418d, 0x41a8, 0x41ca, 0x41e5, 0x4202, 0x4219, 0x4231,
	0x4244, 0x4258, 0x426b, 0x4280, 0x429c, 0x42b1, 0x42cd, 0x42e2,
	0x42fe, 0x4315, 0x4333, 0x434b, 0x436a, 0x437f, 0x4395, 0x43aa,
	0x43c6, 0x43d8, 0x43f4, 0x4406, 0x441d, 0x4430, 0x4442, 0x4459,
	0x446b, 0x4482, 0x4495, 0x44ad, 0x44cf, 0x44f1, 0x4513, 0x452c,
	// Entry 1780 - 17BF
	0x453e, 0x4555, 0x4567, 0x457e, 0x4590, 0x45a2, 0x45ba, 0x45cc,
	0x45e6, 0x45f8, 0x460a, 0x461c, 0x462e, 0x4640, 0x4657, 0x466e,
	0x4680, 0x4692, 0x46a7, 0x46c1, 0x46d8, 0x46f4, 0x470c, 0x4729,
	0x4744, 0x4766, 0x4782, 0x47a5, 0x47bf, 0x47de, 0x47ff, 0x4825,
	0x483e, 0x485e, 0x4870, 0x4889, 0x48a3, 0x48bd, 0x48d5, 0x48ed,
	0x4906, 0x4922, 0x4935, 0x4947, 0x4959, 0x496d, 0x4980, 0x4993,
	0x49a5, 0x49b9, 0x49cd, 0x49e0, 0x49ee, 0x49fd, 0x4a0b, 0x4a23,
	0x4a36, 0x4a4c, 0x4a5d, 0x4a79, 0x4a95, 0x4ab1, 0x4acd, 0x4af0,
	// Entry 17C0 - 17FF
	0x4b0c, 0x4b29, 0x4b46, 0x4b63, 0x4b84, 0x4bab, 0x4bd2, 0x4bfa,
	0x4c22, 0x4c4b, 0x4c80, 0x4cb5, 0x4cdc, 0x4d02, 0x4d2d, 0x4d58,
	0x4d85, 0x4db2, 0x4ddd, 0x4e08, 0x4e35, 0x4e62, 0x4e8d, 0x4ea4,
	0x4ebc, 0x4ed4, 0x4ee6, 0x4ef8, 0x4f0a, 0x4f1d, 0x4f2f, 0x4f41,
	0x4f54, 0x4f67, 0x4f7a, 0x4f8d, 0x4fa1, 0x4fb4, 0x4fc7, 0x4fda,
	0x4fee, 0x5001, 0x5014, 0x5027, 0x503a, 0x504d, 0x5060, 0x5073,
	0x5086, 0x5099, 0x50ac, 0x50bf, 0x50d2, 0x50e5, 0x50f8, 0x510b,
	0x512d, 0x514e, 0x516e, 0x518b, 0x51a7, 0x51c6, 0x51e3, 0x51ff,
	// Entry 1800 - 183F
	0x521e, 0x5234, 0x5249, 0x526d, 0x5291, 0x52a5, 0x52b9, 0x52cd,
	0x52e0, 0x52f3, 0x5308, 0x531c, 0x5330, 0x5343, 0x5358, 0x536d,
	0x5381, 0x5393, 0x53a7, 0x53bb, 0x53cf, 0x53e7, 0x53ff, 0x540d,
	0x5426, 0x5435, 0x544f, 0x5469, 0x5478, 0x548c, 0x549b, 0x54b5,
	0x54c4, 0x54de, 0x54ed, 0x5507, 0x551d, 0x552c, 0x5546, 0x5555,
	0x5564, 0x5573, 0x558d, 0x559c, 0x55b6, 0x55ce, 0x55e6, 0x55f5,
	0x560f, 0x5629, 0x5638, 0x5652, 0x5662, 0x5671, 0x568b, 0x569b,
	0x56aa, 0x56ba, 0x56ca, 0x56d8, 0x56e6, 0x56f6, 0x5708, 0x5721,
	// Entry 1840 - 187F
	0x5734, 0x5746, 0x575d, 0x576f, 0x5786, 0x5798, 0x57bc, 0x57d3,
	0x57e9, 0x57f7, 0x5807, 0x5822, 0x583f, 0x5857, 0x5872, 0x5882,
	0x5893, 0x58a4, 0x58b4, 0x58c5, 0x58d6, 0x58e6, 0x58f7, 0x5907,
	0x5918, 0x5928, 0x5939, 0x5949, 0x5959, 0x5969, 0x597a, 0x598b,
	0x599b, 0x59ac, 0x59bc, 0x59cd, 0x59dd, 0x59ee, 0x59ff, 0x5a11,
	0x5a22, 0x5a32, 0x5a42, 0x5a52, 0x5a62, 0x5a73, 0x5a83, 0x5a93,
	0x5aa4, 0x5ab4, 0x5ac3, 0x5add, 0x5af7, 0x5b0b, 0x5b1e, 0x5b31,
	0x5b45, 0x5b58, 0x5b6c, 0x5b7f, 0x5b96, 0x5bad, 0x5bc4, 0x5bdb,
	// Entry 1880 - 18BF
	0x5bf2, 0x5c09, 0x5c20, 0x5c3d, 0x5c57, 0x5c66, 0x5c77, 0x5c90,
	0x5cb5, 0x5cce, 0x5cee, 0x5d07, 0x5d18, 0x5d28, 0x5d38, 0x5d4a,
	0x5d5b, 0x5d6c, 0x5d7c, 0x5d8e, 0x5da0, 0x5db1, 0x5dc2, 0x5dd4,
	0x5de5, 0x5df8, 0x5e0a, 0x5e1c, 0x5e30, 0x5e43, 0x5e56, 0x5e68,
	0x5e7c, 0x5e90, 0x5ea3, 0x5eb5, 0x5ec7, 0x5ed9, 0x5eec, 0x5efe,
	0x5f11, 0x5f24, 0x5f37, 0x5f4a, 0x5f5d, 0x5f6f, 0x5f81, 0x5f93,
	0x5fa6, 0x5fb8, 0x5fca, 0x5fdc, 0x5fee, 0x6001, 0x6013, 0x6025,
	0x6037, 0x604a, 0x605c, 0x606f, 0x6081, 0x6094, 0x60a6, 0x60b8,
	// Entry 18C0 - 18FF
	0x60ca, 0x60dd, 0x60f6, 0x6112, 0x6120, 0x6131, 0x613e, 0x6159,
	0x617b, 0x619b, 0x61bf, 0x61dd, 0x61fa, 0x6217, 0x623c, 0x6260,
	0x627e, 0x62a0, 0x62c3, 0x62e7, 0x630b, 0x632f, 0x6352, 0x6376,
	0x639a, 0x63be, 0x63e1, 0x6405, 0x6429, 0x644d, 0x6471, 0x6494,
	0x64b8, 0x64dd, 0x6501, 0x6525, 0x6549, 0x656c, 0x6591, 0x65b6,
	0x65db, 0x65ff, 0x6624, 0x6649, 0x666d, 0x6691, 0x66b5, 0x66da,
	0x66fe, 0x6723, 0x6747, 0x676a, 0x678e, 0x67b1, 0x67d5, 0x67f9,
	0x681c, 0x683f, 0x6865, 0x6890, 0x68b4, 0x68d8, 0x6902, 0x692e,
	// Entry 1900 - 193F
	0x694f, 0x6973, 0x6996, 0x69b7, 0x69de, 0x6a04, 0x6a2a, 0x6a50,
	0x6a63, 0x6a73, 0x6a85, 0x6a99, 0x6abe, 0x6af2, 0x6b1b, 0x6b4c,
	0x6b63, 0x6b9e, 0x6bb7, 0x6bd0, 0x6beb, 0x6bff, 0x6c18, 0x6c33,
	0x6c63, 0x6c8e, 0x6ca8, 0x6cc1, 0x6ce3, 0x6cfe, 0x6d22, 0x6d45,
	0x6d6a, 0x6d8a, 0x6daa, 0x6dc9, 0x6df2, 0x6e03, 0x6e24, 0x6e3c,
	0x6e5b, 0x6e7d, 0x6e94, 0x6eb3, 0x6eca, 0x6ee0, 0x6ef6, 0x6f09,
	0x6f1e, 0x6f3a, 0x6f61, 0x6f7d, 0x6f9a, 0x6fb6, 0x6fd9, 0x6ff5,
	0x7011, 0x702f, 0x704b, 0x706b, 0x7086, 0x70a2, 0x70be, 0x70e6,
	// Entry 1940 - 197F
	0x7102, 0x7127, 0x7143, 0x7164, 0x7181, 0x71a3, 0x71cc, 0x71e8,
	0x7205, 0x7222, 0x7242, 0x725e, 0x7283, 0x72a6, 0x72c2, 0x72de,
	0x72fb, 0x7324, 0x7348, 0x7364, 0x7380, 0x739c, 0x73ba, 0x73df,
	0x73ef, 0x740f, 0x742f, 0x744c, 0x746a, 0x7488, 0x74a8, 0x74c1,
	0x74db, 0x74f4, 0x7514, 0x752d, 0x7546, 0x7568, 0x7581, 0x759a,
	0x75b3, 0x75cc, 0x75e5, 0x75fe, 0x7617, 0x7630, 0x7652, 0x766b,
	0x7685, 0x769e, 0x76b7, 0x76d0, 0x76e9, 0x7702, 0x7719, 0x7737,
	0x7752, 0x7771, 0x7788, 0x779f, 0x77b6, 0x77d1, 0x77ed, 0x7810,
	// Entry 1980 - 19BF
	0x7827, 0x7845, 0x785c, 0x7873, 0x788c, 0x78a3, 0x78bf, 0x78df,
	0x7902, 0x7919, 0x7930, 0x7947, 0x7967, 0x7985, 0x799c, 0x79b5,
	0x79cf, 0x79f0, 0x7a0b, 0x7a2a, 0x7a43, 0x7a61, 0x7a7f, 0x7a9d,
	0x7abb, 0x7adc, 0x7afe, 0x7b1e, 0x7b3e, 0x7b5e, 0x7b73, 0x7b99,
	0x7bbf, 0x7be5, 0x7c0b, 0x7c31, 0x7c57, 0x7c7d, 0x7cb0, 0x7cd6,
	0x7cfc, 0x7d22, 0x7d3d, 0x7d58, 0x7d74, 0x7d9c, 0x7dc4, 0x7de7,
	0x7e07, 0x7e2f, 0x7e55, 0x7e7b, 0x7ea1, 0x7ec7, 0x7eed, 0x7f13,
	0x7f39, 0x7f5f, 0x7f85, 0x7fab, 0x7fd1, 0x7ff7, 0x801f, 0x8045,
	// Entry 19C0 - 19FF
	0x806b, 0x8091, 0x80b9, 0x80e5, 0x810c, 0x8134, 0x8161, 0x8197,
	0x81c3, 0x81eb, 0x8218, 0x8242, 0x826a, 0x8294, 0x82b6, 0x82cd,
	0x82ee, 0x8307, 0x832c, 0x8343, 0x836e, 0x838c, 0x83aa, 0x83cd,
	0x83e7, 0x8406, 0x8431, 0x845a, 0x8485, 0x84ae, 0x84cd, 0x84ee,
	0x851a, 0x8540, 0x856b, 0x858a, 0x85a8, 0x85c1, 0x85e2, 0x85fb,
	0x8624, 0x863f, 0x865c, 0x867b, 0x869c, 0x86ba, 0x86d1, 0x86fc,
	0x871d, 0x8736, 0x8751, 0x876e, 0x878b, 0x87a0, 0x87b9, 0x87cf,
	0x87e5, 0x87fb, 0x8811, 0x882c, 0x8847, 0x886b, 0x8881, 0x8897,
	// Entry 1A00 - 1A3F
	0x88b8, 0x88ce, 0x88e4, 0x88f6, 0x8908, 0x891a, 0x894d, 0x896c,
	0x898b, 0x89aa, 0x89d0, 0x89f6, 0x8a16, 0x8a34, 0x8a5a, 0x8a78,
	0x8a96, 0x8abc, 0x8ae2, 0x8b00, 0x8b26, 0x8b4c, 0x8b72, 0x8b90,
	0x8bb3, 0x8bd1, 0x8bf3, 0x8c11, 0x8c32, 0x8c54, 0x8c72, 0x8ca9,
	0x8ce8, 0x8d06, 0x8d26, 0x8d65, 0x8d83, 0x8db0, 0x8ddd, 0x8e0a,
	0x8e21, 0x8e3d, 0x8e58, 0x8e70, 0x8e94, 0x8eab, 0x8ed0, 0x8eef,
	0x8f0d, 0x8f3f, 0x8f65, 0x8f89, 0x8fae, 0x8fd1, 0x8ff6, 0x9019,
	0x903f, 0x9063, 0x9090, 0x90bb, 0x90e0, 0x9103, 0x9128, 0x914b,
	// Entry 1A40 - 1A7F
	0x9171, 0x9195, 0x91b8, 0x91d9, 0x9205, 0x922f, 0x925b, 0x9285,
	0x92b1, 0x92db, 0x9307, 0x9331, 0x9358, 0x937d, 0x93aa, 0x93d5,
	0x93fa, 0x941d, 0x943f, 0x945f, 0x9484, 0x94a7, 0x94cc, 0x94ef,
	0x9514, 0x9537, 0x955a, 0x957b, 0x95a2, 0x95c7, 0x95ee, 0x9613,
	0x9642, 0x966f, 0x9690, 0x96af, 0x96d4, 0x96f7, 0x971d, 0x9741,
	0x9766, 0x9789, 0x97b9, 0x97e7, 0x980d, 0x9831, 0x985d, 0x9887,
	0x98a8, 0x98c7, 0x98ec, 0x990f, 0x9934, 0x9957, 0x997c, 0x999f,
	0x99c4, 0x99e7, 0x9a0d, 0x9a31, 0x9a5d, 0x9a87, 0x9ab2, 0x9adb,
	// Entry 1A80 - 1ABF
	0x9b0a, 0x9b37, 0x9b63, 0x9b8d, 0x9bb9, 0x9be3, 0x9c04, 0x9c23,
	0x9c48, 0x9c6b, 0x9c90, 0x9cb3, 0x9cd8, 0x9cfb, 0x9d2b, 0x9d59,
	0x9d7f, 0x9da3, 0x9dc8, 0x9deb, 0x9e10, 0x9e33, 0x9e62, 0x9e8f,
	0x9ebe, 0x9eeb, 0x9f1e, 0x9f4f, 0x9f74, 0x9f97, 0x9fbc, 0x9fdf,
	0xa005, 0xa029, 0xa055, 0xa07f, 0xa0aa, 0xa0d3, 0xa0fa, 0xa11f,
	0xa14b, 0xa175, 0xa1a0, 0xa1c9, 0xa1f9, 0xa227, 0xa248, 0xa267,
	0xa28c, 0xa2af, 0xa2d0, 0xa2ef, 0xa310, 0xa32f, 0xa354, 0xa377,
	0xa39c, 0xa3bf, 0xa3e4, 0xa407, 0xa42c, 0xa44f, 0xa474, 0xa497,
	// Entry 1AC0 - 1AFF
	0xa4bc, 0xa4df, 0xa505, 0xa529, 0xa54e, 0xa571, 0xa597, 0xa5bb,
	0xa5df, 0xa602, 0xa626, 0xa64a, 0xa673, 0xa69b, 0xa6c9, 0xa6f3,
	0xa70f, 0xa727, 0xa74c, 0xa76f, 0xa795, 0xa7b9, 0xa7e9, 0xa817,
	0xa847, 0xa875, 0xa8aa, 0xa8dd, 0xa90d, 0xa93b, 0xa96f, 0xa9a1,
	0xa9cc, 0xa9f5, 0xaa20, 0xaa49, 0xaa79, 0xaaa7, 0xaad2, 0xaafb,
	0xab2a, 0xab57, 0xab7c, 0xab9f, 0xabc5, 0xabe9, 0xac0a, 0xac29,
	0xac59, 0xac87, 0xacb7, 0xace5, 0xad1a, 0xad4d, 0xad7d, 0xadab,
	0xaddf, 0xae11, 0xae37, 0xae5b, 0xae80, 0xaea3, 0xaec8, 0xaeeb,
	// Entry 1B00 - 1B3F
	0xaf11, 0xaf35, 0xaf65, 0xaf93, 0xafc3, 0xaff1, 0xb026, 0xb059,
	0xb089, 0xb0b7, 0xb0eb, 0xb11d, 0xb147, 0xb16f, 0xb199, 0xb1c1,
	0xb1f0, 0xb21d, 0xb247, 0xb26f, 0xb29d, 0xb2c9, 0xb2ee, 0xb311,
	0xb337, 0xb35b, 0xb385, 0xb3ad, 0xb3d7, 0xb3ff, 0xb42e, 0xb45b,
	0xb485, 0xb4ad, 0xb4db, 0xb507, 0xb528, 0xb547, 0xb56c, 0xb58f,
	0xb5b5, 0xb5d9, 0xb5fa, 0xb619, 0xb63d, 0xb65f, 0xb682, 0xb6a3,
	0xb6c3, 0xb6e1, 0xb704, 0xb727, 0xb754, 0xb781, 0xb7ad, 0xb7d9,
	0xb80c, 0xb83f, 0xb864, 0xb889, 0xb8b8, 0xb8e7, 0xb915, 0xb943,
	// Entry 1B40 - 1B7F
	0xb978, 0xb9ad, 0xb9d2, 0xb9f7, 0xba26, 0xba55, 0xba83, 0xbab1,
	0xbad8, 0xbaff, 0xbb30, 0xbb61, 0xbb91, 0xbbc1, 0xbbe2, 0xbc03,
	0xbc2e, 0xbc59, 0xbc83, 0xbcad, 0xbcde, 0xbd0f, 0xbd32, 0xbd55,
	0xbd82, 0xbdaf, 0xbddb, 0xbe07, 0xbe3a, 0xbe6d, 0xbe8f, 0xbeb1,
	0xbedd, 0xbf09, 0xbf34, 0xbf5f, 0xbf91, 0xbfc3, 0xbfe7, 0xc00b,
	0xc039, 0xc067, 0xc094, 0xc0c1, 0xc0f5, 0xc129, 0xc14e, 0xc173,
	0xc1a2, 0xc1d1, 0xc1ff, 0xc22d, 0xc254, 0xc27b, 0xc2ac, 0xc2dd,
	0xc30d, 0xc33d, 0xc362, 0xc387, 0xc3b6, 0xc3e5, 0xc413, 0xc441,
	// Entry 1B80 - 1BBF
	0xc476, 0xc4ab, 0xc4d2, 0xc503, 0xc533, 0xc56a, 0xc58d, 0xc5b0,
	0xc5dd, 0xc60a, 0xc636, 0xc662, 0xc695, 0xc6c8, 0xc6ed, 0xc712,
	0xc741, 0xc770, 0xc79e, 0xc7cc, 0xc801, 0xc836, 0xc859, 0xc87b,
	0xc8a0, 0xc8c4, 0xc8e5, 0xc905, 0xc927, 0xc948, 0xc96d, 0xc991,
	0xc9b6, 0xc9da, 0xc9fd, 0xca1f, 0xca54, 0xca89, 0xcac8, 0xcb07,
	0xcb45, 0xcb83, 0xcbc8, 0xcc0d, 0xcc45, 0xcc7d, 0xccbf, 0xcd01,
	0xcd42, 0xcd83, 0xcdcb, 0xce13, 0xce46, 0xce79, 0xceb6, 0xcef3,
	0xcf2f, 0xcf6b, 0xcfae, 0xcff1, 0xd027, 0xd05d, 0xd09d, 0xd0dd,
	// Entry 1BC0 - 1BFF
	0xd11c, 0xd15b, 0xd1a1, 0xd1e7, 0xd21c, 0xd251, 0xd290, 0xd2cf,
	0xd30d, 0xd34b, 0xd390, 0xd3d5, 0xd40d, 0xd445, 0xd487, 0xd4c9,
	0xd50a, 0xd54b, 0xd593, 0xd5db, 0xd5ff, 0xd623, 0xd658, 0xd683,
	0xd6b7, 0xd6e0, 0xd71b, 0xd741, 0xd767, 0xd78c, 0xd7b0, 0xd7de,
	0xd7eb, 0xd7ff, 0xd80a, 0xd81b, 0xd83a, 0xd86d, 0xd896, 0xd8c8,
	0xd8ef, 0xd928, 0xd94f, 0xd975, 0xd998, 0xd9ba, 0xd9e6, 0xd9fb,
	0xda0f, 0xda2a, 0xda4d, 0xda70, 0xdaa0, 0xdacf, 0xdaf7, 0xdb2d,
	0xdb52, 0xdb77, 0xdb9b, 0xdbbe, 0xdbd3, 0xdbe7, 0xdc02, 0xdc28,
	// Entry 1C00 - 1C3F
	0xdc4e, 0xdc81, 0xdcb3, 0xdcd4, 0xdcf5, 0xdd20, 0xdd59, 0xdd81,
	0xdda9, 0xddd0, 0xddf6, 0xde19, 0xde32, 0xde4a, 0xde55, 0xde8a,
	0xdeb5, 0xdee9, 0xdf12, 0xdf4d, 0xdf74, 0xdf9a, 0xdfbf, 0xdfe3,
	0xe011, 0xe01b, 0xe026, 0xe02d, 0xe034, 0xe03c, 0xe044, 0xe056,
	0xe067, 0xe077, 0xe083, 0xe094, 0xe09e, 0xe0a8, 0xe0b8, 0xe0cd,
	0xe0de, 0xe0f0, 0xe102, 0xe108, 0xe11b, 0xe126, 0xe12d, 0xe134,
	0xe142, 0xe156, 0xe165, 0xe17f, 0xe19a, 0xe1b5, 0xe1da, 0xe1f4,
	0xe20f, 0xe22a, 0xe24f, 0xe255, 0xe262, 0xe268, 0xe279, 0xe287,
	// Entry 1C40 - 1C7F
	0xe295, 0xe2a8, 0xe2b9, 0xe2c7, 0xe2da, 0xe2f1, 0xe308, 0xe322,
	0xe338, 0xe34e, 0xe363, 0xe371, 0xe386, 0xe38b, 0xe397, 0xe3a3,
	0xe3b1, 0xe3c6, 0xe3db, 0xe3e0, 0xe409, 0xe433, 0xe441, 0xe458,
	0xe463, 0xe46b, 0xe473, 0xe480, 0xe495, 0xe49d, 0xe4aa, 0xe4b8,
	0xe4d6, 0xe4f5, 0xe509, 0xe522, 0xe53b, 0xe54b, 0xe560, 0xe576,
	0xe58d, 0xe599, 0xe5ab, 0xe5b3, 0xe5d3, 0xe5e8, 0xe5f2, 0xe603,
	0xe61a, 0xe62f, 0xe63e, 0xe652, 0xe666, 0xe679, 0xe686, 0xe692,
	0xe69a, 0xe6ac, 0xe6c5, 0xe6d0, 0xe6e4, 0xe6f3, 0xe706, 0xe714,
	// Entry 1C80 - 1CBF
	0xe729, 0xe73e, 0xe752, 0xe769, 0xe783, 0xe79e, 0xe7b9, 0xe7d5,
	0xe7ea, 0xe7fe, 0xe80e, 0xe82e, 0xe83e, 0xe84e, 0xe85d, 0xe86e,
	0xe87f, 0xe88f, 0xe8a4, 0xe8b5, 0xe8cc, 0xe8e8, 0xe905, 0xe925,
	0xe933, 0xe940, 0xe94d, 0xe95c, 0xe96a, 0xe978, 0xe985, 0xe994,
	0xe9a3, 0xe9b1, 0xe9c4, 0xe9d3, 0xe9e8, 0xea02, 0xea1d, 0xea3b,
	0xea59, 0xea77, 0xea95, 0xeab7, 0xead5, 0xeaf3, 0xeb11, 0xeb2f,
	0xeb4d, 0xeb6b, 0xeb89, 0xeba7, 0xebb9, 0xebc3, 0xebd0, 0xebe1,
	0xebea, 0xebf3, 0xebfd, 0xec08, 0xec12, 0xec1a, 0xec29, 0xec32,
	// Entry 1CC0 - 1CFF
	0xec3b, 0xec43, 0xec4e, 0xec5a, 0xec6b, 0xec74, 0xec80, 0xec8c,
	0xec98, 0xeca1, 0xecb4, 0xecc1, 0xeccb, 0xecdc, 0xeced, 0xecfd,
	0xed07, 0xed11, 0xed1a, 0xed26, 0xed42, 0xed5f, 0xed83, 0xeda8,
	0xedcb, 0xedea, 0xee04, 0xee1f, 0xee35, 0xee55, 0xee79, 0xee93,
	0xeeac, 0xeec6, 0xeee0, 0xeefb, 0xef1f, 0xef3f, 0xef59, 0xef73,
	0xef9f, 0xefc0, 0xefe8, 0xf000, 0xf019, 0xf034, 0xf055, 0xf07a,
	0xf0aa, 0xf0d9, 0xf0f3, 0xf10e, 0xf126, 0xf130, 0xf148, 0xf15f,
	0xf16d, 0xf17f, 0xf186, 0xf18e, 0xf19c, 0xf1a3, 0xf1b4, 0xf1c2,
	// Entry 1D00 - 1D3F
	0xf1d2, 0xf1e8, 0xf1ff, 0xf20e, 0xf229, 0xf239, 0xf24f, 0xf25f,
	0xf26d, 0xf27b, 0xf292, 0xf29d, 0xf2b6, 0xf2c6, 0xf2dd, 0xf2f4,
	0xf304, 0xf31a, 0xf331, 0xf342, 0xf34a, 0xf356, 0xf364, 0xf373,
	0xf37b, 0xf392, 0xf39c, 0xf3a4, 0xf3b5, 0xf3cb, 0xf3e9, 0xf3f4,
	0xf401, 0xf411, 0xf427, 0xf437, 0xf445, 0xf455, 0xf465, 0xf475,
	0xf485, 0xf493, 0xf49e, 0xf4a8, 0xf4b4, 0xf4c0, 0xf4d2, 0xf4e3,
	0xf4f1, 0xf507, 0xf520, 0xf53b, 0xf553, 0xf570, 0xf58b, 0xf5a6,
	0xf5c3, 0xf5de, 0xf5fc, 0xf618, 0xf634, 0xf650, 0xf66c, 0xf679,
	// Entry 1D40 - 1D7F
	0xf689, 0xf691, 0xf69d, 0xf6ab, 0xf6c6, 0xf6e1, 0xf6fa, 0xf713,
	0xf72c, 0xf746, 0xf75f, 0xf779, 0xf795, 0xf7b0, 0xf7c9, 0xf7e4,
	0xf7fe, 0xf81b, 0xf837, 0xf854, 0xf86a, 0xf87b, 0xf88c, 0xf89f,
	0xf8b1, 0xf8c3, 0xf8d4, 0xf8e7, 0xf8fa, 0xf90c, 0xf91d, 0xf931,
	0xf945, 0xf958, 0xf971, 0xf98b, 0xf9a5, 0xf9bc, 0xf9d3, 0xf9ec,
	0xfa04, 0xfa1c, 0xfa33, 0xfa4c, 0xfa65, 0xfa7d, 0xfa94, 0xfaae,
	0xfac8, 0xfae1, 0xfb00, 0xfb20, 0xfb40, 0xfb5e, 0xfb79, 0xfb93,
	0xfbb5, 0xfbd2, 0xfbed, 0xfc0b, 0xfc27, 0xfc49, 0xfc64, 0xfc74,
	// Entry 1D80 - 1DBF
	0xfc86, 0xfc95, 0xfca2, 0xfcb2, 0xfcc1, 0xfcd1, 0xfcde, 0xfcee,
	0xfcfe, 0xfd0e, 0xfd1e, 0xfd39, 0xfd55, 0xfd69, 0xfd7e, 0xfd98,
	0xfdb0, 0xfdcb, 0xfde5, 0xfdfe, 0xfe18, 0xfe30, 0xfe46, 0xfe5f,
	0xfe77, 0xfe8e, 0xfea7, 0xfec1, 0xfeda, 0xfef4, 0xff09, 0xff25,
	0xff3b, 0xff5b, 0xff7c, 0xff9e, 0xffc1, 0xffe7, 0x000c, 0x002e,
	0x004c, 0x0068, 0x009b, 0x00ba, 0x00d5, 0x00f8, 0x011d, 0x0141,
	0x0164, 0x0188, 0x01ae, 0x01d4, 0x01f9, 0x021e, 0x0248, 0x026d,
	0x0284, 0x0299, 0x02b1, 0x02c8, 0x02f1, 0x031a, 0x033c, 0x035f,
	// Entry 1DC0 - 1DFF
	0x0382, 0x0398, 0x03ac, 0x03c3, 0x03d9, 0x03f0, 0x0404, 0x041b,
	0x0432, 0x0449, 0x0460, 0x0476, 0x048d, 0x04a5, 0x04be, 0x04de,
	0x0500, 0x0516, 0x052a, 0x0541, 0x0557, 0x056d, 0x0584, 0x0599,
	0x05ac, 0x05c2, 0x05d7, 0x05f3, 0x0612, 0x0645, 0x0676, 0x0690,
	0x06b6, 0x06d6, 0x06f0, 0x070a, 0x071d, 0x073a, 0x0764, 0x077b,
	0x079f, 0x07c4, 0x07e9, 0x0814, 0x0840, 0x086c, 0x0887, 0x08a3,
	0x08bf, 0x08c6, 0x08d0, 0x08e4, 0x08f0, 0x0904, 0x090d, 0x0916,
	0x091b, 0x0925, 0x0936, 0x0946, 0x0958, 0x0972, 0x098a, 0x0996,
	// Entry 1E00 - 1E3F
	0x09a3, 0x09b2, 0x09c1, 0x09cb, 0x09dd, 0x09e5, 0x09f3, 0x09fc,
	0x0a0d, 0x0a1a, 0x0a29, 0x0a34, 0x0a3d, 0x0a48, 0x0a57, 0x0a5f,
	0x0a6a, 0x0a6f, 0x0a7d, 0x0a8c, 0x0a93, 0x0aa2, 0x0aad, 0x0abc,
	0x0ac7, 0x0ad1, 0x0add, 0x0ae2, 0x0aea, 0x0af9, 0x0b08, 0x0b18,
	0x0b28, 0x0b37, 0x0b49, 0x0b63, 0x0b81, 0x0b8a, 0x0b91, 0x0b96,
	0x0ba0, 0x0ba9, 0x0baf, 0x0bc3, 0x0bcd, 0x0bdb, 0x0be9, 0x0bf8,
	0x0c01, 0x0c0f, 0x0c18, 0x0c23, 0x0c3a, 0x0c55, 0x0c6b, 0x0c92,
	0x0cbd, 0x0ccc, 0x0cdf, 0x0cf7, 0x0d03, 0x0d0f, 0x0d1c, 0x0d37,
	// Entry 1E40 - 1E7F
	0x0d49, 0x0d5d, 0x0d73, 0x0d99, 0x0dbb, 0x0dc7, 0x0dd3, 0x0de3,
	0x0df0, 0x0dfe, 0x0e07, 0x0e15, 0x0e20, 0x0e2e, 0x0e44, 0x0e4f,
	0x0e62, 0x0e6e, 0x0e7a, 0x0e8a, 0x0ea0, 0x0eb5, 0x0ecd, 0x0ee4,
	0x0efe, 0x0f18, 0x0f35, 0x0f43, 0x0f54, 0x0f5b, 0x0f6c, 0x0f79,
	0x0f89, 0x0fa7, 0x0fc8, 0x0fe2, 0x0fff, 0x1022, 0x1048, 0x1061,
	0x107a, 0x109c, 0x10be, 0x10c6, 0x10ce, 0x10e2, 0x10f6, 0x110f,
	0x1128, 0x1138, 0x1148, 0x1151, 0x115c, 0x116b, 0x117c, 0x1191,
	0x11a8, 0x11c8, 0x11ea, 0x1205, 0x1222, 0x122a, 0x1241, 0x124f,
	// Entry 1E80 - 1EBF
	0x125e, 0x1270, 0x128b, 0x12a9, 0x12b3, 0x12bd, 0x12c9, 0x12d6,
	0x12e3, 0x12f9, 0x130d, 0x1322, 0x133b, 0x1349, 0x1355, 0x1361,
	0x136e, 0x137b, 0x138f, 0x1399, 0x13a2, 0x13ab, 0x13b2, 0x13bb,
	0x13c1, 0x13c5, 0x13cb, 0x13ee, 0x1418, 0x1426, 0x142e, 0x143c,
	0x146e, 0x1485, 0x149c, 0x14ae, 0x14c9, 0x14e7, 0x150e, 0x1519,
	0x1521, 0x1529, 0x1543, 0x154e, 0x1551, 0x1555, 0x1558, 0x156c,
	0x157a, 0x158b, 0x159b, 0x15ad, 0x15b8, 0x15c8, 0x15d4, 0x15e1,
	0x15ef, 0x15f5, 0x161a, 0x1640, 0x1657, 0x166f, 0x1684, 0x1694,
	// Entry 1EC0 - 1EFF
	0x16a5, 0x16b2, 0x16c1, 0x16d4, 0x16e0, 0x16e9, 0x16fe, 0x1710,
	0x1725, 0x1738, 0x174e, 0x1770, 0x1792, 0x17a7, 0x17bf, 0x17d3,
	0x17e7, 0x1800, 0x1819, 0x1838, 0x185a, 0x1879, 0x189b, 0x18ba,
	0x18dc, 0x18fa, 0x1918, 0x192e, 0x1951, 0x1973, 0x199f, 0x19b0,
	0x19cb, 0x19e5, 0x1a01, 0x1a27, 0x1a5f, 0x1a9d, 0x1ab6, 0x1acd,
	0x1aea, 0x1b02, 0x1b28, 0x1b4c, 0x1b82, 0x1bbe, 0x1bd3, 0x1bee,
	0x1c07, 0x1c14, 0x1c22, 0x1c27, 0x1c33, 0x1c41, 0x1c4b, 0x1c56,
	0x1c5f, 0x1c6b, 0x1c78, 0x1c82, 0x1c8d, 0x1c9e, 0x1cae, 0x1cbc,
	// Entry 1F00 - 1F3F
	0x1cc9, 0x1cda, 0x1ce8, 0x1ceb, 0x1cf2, 0x1cf8, 0x1d0a, 0x1d1c,
	0x1d2b, 0x1d41, 0x1d50, 0x1d55, 0x1d5e, 0x1d6d, 0x1d7d, 0x1d8f,
	0x1da2, 0x1db3, 0x1dc7, 0x1dcc, 0x1dd1, 0x1df9, 0x1e03, 0x1e15,
	0x1e29, 0x1e31, 0x1e4c, 0x1e68, 0x1e79, 0x1e85, 0x1e91, 0x1ea3,
	0x1eab, 0x1eb7, 0x1ec7, 0x1ed4, 0x1ed9, 0x1ee4, 0x1eef, 0x1f0b,
	0x1f2c, 0x1f4c, 0x1f6d, 0x1f8f, 0x1fad, 0x1fce, 0x1ff0, 0x2010,
	0x202f, 0x2052, 0x2072, 0x2096, 0x20ba, 0x20e1, 0x2105, 0x212a,
	0x2154, 0x217f, 0x21a5, 0x21cd, 0x21ee, 0x2213, 0x2233, 0x2256,
	// Entry 1F40 - 1F7F
	0x2278, 0x22a0, 0x22c5, 0x22e4, 0x2307, 0x2325, 0x2346, 0x236a,
	0x2394, 0x23b8, 0x23dc, 0x2402, 0x2424, 0x2449, 0x246a, 0x248a,
	0x24ab, 0x24cb, 0x24f2, 0x2515, 0x2539, 0x255c, 0x2582, 0x25a7,
	0x25cc, 0x25f1, 0x261d, 0x263c, 0x265b, 0x2676, 0x2697, 0x26bf,
	0x26e3, 0x2706, 0x272c, 0x2750, 0x276a, 0x2783, 0x279e, 0x27c2,
	0x27e8, 0x280b, 0x282f, 0x284a, 0x2858, 0x287f, 0x2892, 0x289d,
	0x28ba, 0x28ca, 0x28e5, 0x2903, 0x2912, 0x2924, 0x294a, 0x2956,
	0x296c, 0x2977, 0x2998, 0x29ad, 0x29cf, 0x29da, 0x29eb, 0x29fc,
	// Entry 1F80 - 1FBF
	0x2a1d, 0x2a3e, 0x2a5d, 0x2a7a, 0x2a98, 0x2ab0, 0x2aca, 0x2ae6,
	0x2af3, 0x2afc, 0x2b0f, 0x2b22, 0x2b3d, 0x2b57, 0x2b72, 0x2b8e,
	0x2ba9, 0x2bc5, 0x2be5, 0x2c02, 0x2c22, 0x2c43, 0x2c61, 0x2c82,
	0x2c9f, 0x2cbe, 0x2cdb, 0x2cf2, 0x2d10, 0x2d30, 0x2d4e, 0x2d60,
	0x2d79, 0x2da8, 0x2dd7, 0x2de4, 0x2df4, 0x2e06, 0x2e1b, 0x2e48,
	0x2e5d, 0x2e73, 0x2e8a, 0x2ea0, 0x2eb6, 0x2ecc, 0x2ee2, 0x2f0f,
	0x2f3f, 0x2f6a, 0x2fa0, 0x2fd4, 0x3001, 0x3039, 0x306f, 0x3097,
	0x30cb, 0x30fd, 0x3127, 0x314f, 0x317b, 0x31aa, 0x31b5, 0x31c2,
	// Entry 1FC0 - 1FFF
	0x31ce, 0x31e5, 0x31f3, 0x320b, 0x3223, 0x3240, 0x325d, 0x3277,
	0x3287, 0x3299, 0x32ab, 0x32b7, 0x32bb, 0x32ca, 0x32dc, 0x32ed,
	0x3301, 0x331b, 0x3338, 0x3347, 0x335f, 0x336b, 0x3373, 0x337d,
	0x3394, 0x33ab, 0x33cf, 0x33f2, 0x3413, 0x3436, 0x346c, 0x34a1,
	0x34d7, 0x34e2, 0x34eb, 0x34f6, 0x3511, 0x3534, 0x3558, 0x3579,
	0x359c, 0x35af, 0x35c4, 0x35db, 0x35e7, 0x35fa, 0x3609, 0x361b,
	0x362e, 0x363d, 0x3658, 0x3670, 0x3686, 0x36a4, 0x36b6, 0x36cc,
	0x36db, 0x36ef, 0x370f, 0x3723, 0x3741, 0x3755, 0x376f, 0x3783,
	// Entry 2000 - 203F
	0x3796, 0x37b1, 0x37ce, 0x37eb, 0x380a, 0x3828, 0x3847, 0x3862,
	0x3886, 0x3897, 0x38af, 0x38c4, 0x38d5, 0x38ee, 0x3908, 0x3923,
	0x393c, 0x394c, 0x395d, 0x3969, 0x3971, 0x3983, 0x399d, 0x39bb,
	0x39c3, 0x39cc, 0x39d4, 0x39e5, 0x39f4, 0x39ff, 0x3a1d, 0x3a30,
	0x3a38, 0x3a53, 0x3a67, 0x3a78, 0x3a89, 0x3a9c, 0x3aae, 0x3ac0,
	0x3ad1, 0x3ae4, 0x3af7, 0x3b09, 0x3b1b, 0x3b30, 0x3b45, 0x3b5c,
	0x3b73, 0x3b89, 0x3b9f, 0x3bb7, 0x3bce, 0x3be5, 0x3bfa, 0x3c11,
	0x3c28, 0x3c41, 0x3c59, 0x3c71, 0x3c88, 0x3ca1, 0x3cba, 0x3cd2,
	// Entry 2040 - 207F
	0x3cea, 0x3d05, 0x3d20, 0x3d3d, 0x3d5a, 0x3d76, 0x3d92, 0x3db0,
	0x3dcd, 0x3dea, 0x3e05, 0x3e18, 0x3e2b, 0x3e40, 0x3e54, 0x3e68,
	0x3e7b, 0x3e90, 0x3ea5, 0x3eb9, 0x3ecd, 0x3ee4, 0x3efb, 0x3f14,
	0x3f2d, 0x3f45, 0x3f5d, 0x3f77, 0x3f90, 0x3fa9, 0x3fc0, 0x3fe2,
	0x4004, 0x4026, 0x4048, 0x406a, 0x408c, 0x40ae, 0x40d0, 0x40f2,
	0x4114, 0x4136, 0x4158, 0x417a, 0x419c, 0x41be, 0x41e0, 0x4202,
	0x4224, 0x4246, 0x4268, 0x428a, 0x42ac, 0x42ce, 0x42f0, 0x4312,
	0x4334, 0x4352, 0x4370, 0x438e, 0x43ac, 0x43ca, 0x43e8, 0x4406,
	// Entry 2080 - 20BF
	0x4424, 0x4442, 0x4460, 0x447e, 0x449c, 0x44ba, 0x44d8, 0x44f6,
	0x4514, 0x4532, 0x4550, 0x456e, 0x458c, 0x45aa, 0x45c8, 0x45e6,
	0x4604, 0x4622, 0x4640, 0x465c, 0x4678, 0x4694, 0x46b0, 0x46cc,
	0x46e8, 0x4704, 0x4720, 0x473c, 0x4758, 0x4774, 0x4790, 0x47ac,
	0x47c8, 0x47e4, 0x4800, 0x481c, 0x4838, 0x4854, 0x4870, 0x488c,
	0x48a8, 0x48c4, 0x48e0, 0x48fc, 0x4918, 0x492a, 0x4948, 0x4966,
	0x4986, 0x49a6, 0x49c5, 0x49e4, 0x4a05, 0x4a25, 0x4a45, 0x4a63,
	0x4a7b, 0x4a93, 0x4aad, 0x4ac6, 0x4adf, 0x4af7, 0x4b11, 0x4b2b,
	// Entry 20C0 - 20FF
	0x4b44, 0x4b5d, 0x4b78, 0x4b95, 0x4bb2, 0x4bcd, 0x4be8, 0x4c11,
	0x4c3a, 0x4c61, 0x4c88, 0x4cb4, 0x4ce0, 0x4d0a, 0x4d34, 0x4d55,
	0x4d7c, 0x4da3, 0x4dc4, 0x4de4, 0x4e0a, 0x4e30, 0x4e50, 0x4e6f,
	0x4e94, 0x4eb9, 0x4ed8, 0x4ef6, 0x4f1a, 0x4f3e, 0x4f5c, 0x4f81,
	0x4fac, 0x4fd6, 0x5000, 0x502b, 0x5055, 0x507f, 0x50a4, 0x50c8,
	0x50f2, 0x511b, 0x5144, 0x516e, 0x5197, 0x51c0, 0x51e4, 0x520a,
	0x5236, 0x5262, 0x528e, 0x52ba, 0x52e6, 0x5312, 0x5338, 0x535c,
	0x5386, 0x53b0, 0x53da, 0x5404, 0x542e, 0x5458, 0x547c, 0x54a6,
	// Entry 2100 - 213F
	0x54d6, 0x5506, 0x5536, 0x5565, 0x5594, 0x55c4, 0x55f3, 0x5622,
	0x5651, 0x5680, 0x56af, 0x56de, 0x570e, 0x573e, 0x5768, 0x5791,
	0x57ba, 0x57e1, 0x5808, 0x5826, 0x5842, 0x586b, 0x5894, 0x58b6,
	0x58de, 0x5906, 0x5927, 0x594e, 0x5975, 0x5995, 0x59bb, 0x59e1,
	0x5a00, 0x5a2d, 0x5a5a, 0x5a80, 0x5aac, 0x5ad8, 0x5afd, 0x5b2b,
	0x5b59, 0x5b80, 0x5bac, 0x5bd8, 0x5bfd, 0x5c2f, 0x5c61, 0x5c8c,
	0x5cb1, 0x5cd5, 0x5cf7, 0x5d1a, 0x5d4f, 0x5d84, 0x5da5, 0x5dbc,
	0x5dd1, 0x5de9, 0x5e00, 0x5e17, 0x5e2c, 0x5e44, 0x5e5b, 0x5e82,
	// Entry 2140 - 217F
	0x5ea6, 0x5ecd, 0x5ef1, 0x5f01, 0x5f17, 0x5f2e, 0x5f47, 0x5f57,
	0x5f6f, 0x5f89, 0x5fa2, 0x5fac, 0x5fc4, 0x5fdd, 0x5ff4, 0x6003,
	0x601b, 0x6031, 0x6046, 0x6056, 0x6061, 0x606d, 0x6077, 0x608d,
	0x60a3, 0x60b6, 0x60ca, 0x60dd, 0x610f, 0x6132, 0x6164, 0x6197,
	0x61ab, 0x61ce, 0x6201, 0x620d, 0x6219, 0x623a, 0x6264, 0x627f,
	0x6298, 0x62be, 0x62e8, 0x6312, 0x6336, 0x6348, 0x635a, 0x6369,
	0x6378, 0x6390, 0x63a8, 0x63bb, 0x63ce, 0x63e8, 0x6402, 0x6422,
	0x6442, 0x645f, 0x647c, 0x649f, 0x64c2, 0x64de, 0x64fa, 0x6516,
	// Entry 2180 - 21BF
	0x6532, 0x6554, 0x6576, 0x6592, 0x65ae, 0x65d0, 0x65f2, 0x660d,
	0x6628, 0x6635, 0x6642, 0x666e, 0x6675, 0x667c, 0x6688, 0x6695,
	0x66ae, 0x66b6, 0x66c2, 0x66dd, 0x66f9, 0x6715, 0x6731, 0x6757,
	0x6784, 0x679a, 0x67b1, 0x67bf, 0x67d3, 0x67f2, 0x6811, 0x6831,
	0x6852, 0x6873, 0x6893, 0x68a4, 0x68b5, 0x68cf, 0x68e8, 0x6901,
	0x691b, 0x6927, 0x6942, 0x695e, 0x6988, 0x69b3, 0x69dc, 0x69ff,
	0x6a28, 0x6a52, 0x6a5e, 0x6a83, 0x6aa8, 0x6ace, 0x6af4, 0x6b19,
	0x6b3e, 0x6b64, 0x6b8a, 0x6b9d, 0x6bb1, 0x6bc4, 0x6bd7, 0x6bea,
	// Entry 21C0 - 21FF
	0x6c03, 0x6c1c, 0x6c30, 0x6c43, 0x6c48, 0x6c50, 0x6c57, 0x6c5c,
	0x6c66, 0x6c70, 0x6c79, 0x6c85, 0x6c88, 0x6c96, 0x6ca5, 0x6cb0,
	0x6cba, 0x6cc9, 0x6cd8, 0x6ce2, 0x6cf7, 0x6d08, 0x6d0f, 0x6d27,
	0x6d33, 0x6d44, 0x6d55, 0x6d5d, 0x6d81, 0x6d9a, 0x6db4, 0x6dcd,
	0x6de4, 0x6dfe, 0x6e17, 0x6e2b, 0x6e37, 0x6e47, 0x6e55, 0x6e5d,
	0x6e61, 0x6e6f, 0x6e76, 0x6e87, 0x6e99, 0x6eaa, 0x6eb6, 0x6ec0,
	0x6ed1, 0x6edd, 0x6ee5, 0x6ef7, 0x6f07, 0x6f17, 0x6f2a, 0x6f3a,
	0x6f4b, 0x6f5f, 0x6f70, 0x6f7f, 0x6f92, 0x6fa4, 0x6fb6, 0x6fc9,
	// Entry 2200 - 223F
	0x6fdb, 0x6fec, 0x6ff3, 0x6ffe, 0x7003, 0x700c, 0x7013, 0x7019,
	0x701f, 0x7026, 0x702b, 0x7030, 0x7036, 0x703c, 0x7042, 0x7045,
	0x704a, 0x704f, 0x7057, 0x7062, 0x706b, 0x7073, 0x7079, 0x7089,
	0x709a, 0x70aa, 0x70bc, 0x70ce, 0x70de, 0x70ee, 0x70ff, 0x710f,
	0x7121, 0x7133, 0x7143, 0x7153, 0x7163, 0x7175, 0x7184, 0x7194,
	0x71a4, 0x71b6, 0x71c5, 0x71d0, 0x71dc, 0x71e7, 0x71fa, 0x7210,
	0x721f, 0x7231, 0x7241, 0x7252, 0x7263, 0x727d, 0x72a1, 0x72c5,
	0x72e9, 0x730d, 0x7331, 0x7355, 0x7379, 0x739f, 0x73bf, 0x73d4,
	// Entry 2240 - 227F
	0x73f3, 0x7407, 0x7418, 0x7422, 0x742c, 0x7436, 0x7440, 0x744a,
	0x7454, 0x746f, 0x7489, 0x74aa, 0x74ca, 0x74db, 0x74eb, 0x7502,
	0x7517, 0x752d, 0x7543, 0x754d, 0x7557, 0x7566, 0x756c, 0x757a,
	0x758e, 0x7594, 0x759b, 0x75a1, 0x75a5, 0x75b4, 0x75bf, 0x75cb,
	0x75de, 0x75fa, 0x7615, 0x7621, 0x7632, 0x7645, 0x7656, 0x7676,
	0x768a, 0x769f, 0x76c8, 0x76e6, 0x7706, 0x7719, 0x772c, 0x7745,
	0x7754, 0x7762, 0x777e, 0x7784, 0x778f, 0x7795, 0x779a, 0x77a0,
	0x77a4, 0x77a9, 0x77af, 0x77c0, 0x77c7, 0x77d2, 0x77da, 0x77e8,
	// Entry 2280 - 22BF
	0x77f3, 0x77fb, 0x7806, 0x7818, 0x782b, 0x783d, 0x7850, 0x7864,
	0x7874, 0x7878, 0x7885, 0x789b, 0x78b3, 0x78cb, 0x78e2, 0x78f0,
	0x78fc, 0x7905, 0x7909, 0x7914, 0x792b, 0x7941, 0x7947, 0x794f,
	0x7971, 0x798f, 0x79ad, 0x79c2, 0x79d7, 0x79e6, 0x7a08, 0x7a19,
	0x7a28, 0x7a58, 0x7a63, 0x7a7a, 0x7a91, 0x7aaf, 0x7ada, 0x7ae3,
	0x7b04, 0x7b24, 0x7b36, 0x7b4b, 0x7b58, 0x7b5e, 0x7b64, 0x7b71,
	0x7b81, 0x7b92, 0x7bab, 0x7bb3, 0x7bc5, 0x7bcd, 0x7bd9, 0x7bde,
	0x7be6, 0x7bf9, 0x7bfe, 0x7c07, 0x7c17, 0x7c1b, 0x7c2f, 0x7c49,
	// Entry 22C0 - 22FF
	0x7c52, 0x7c65, 0x7c93, 0x7ca8, 0x7cbc, 0x7cca, 0x7cde, 0x7cec,
	0x7d02, 0x7d19, 0x7d23, 0x7d2b, 0x7d33, 0x7d3e, 0x7d49, 0x7d55,
	0x7d61, 0x7d73, 0x7d79, 0x7d8b, 0x7d94, 0x7d9d, 0x7da7, 0x7db7,
	0x7dc7, 0x7ddd, 0x7de5, 0x7df3, 0x7e07, 0x7e18, 0x7e29, 0x7e40,
	0x7e4b, 0x7e65, 0x7e79, 0x7e86, 0x7e93, 0x7eb0, 0x7ecc, 0x7eee,
	0x7f07, 0x7f1e, 0x7f35, 0x7f3d, 0x7f57, 0x7f69, 0x7f7f, 0x7f96,
	0x7fa9, 0x7fc2, 0x7fcf, 0x7fe2, 0x7ff0, 0x8004, 0x8019, 0x8031,
	0x804c, 0x8062, 0x8086, 0x80b0, 0x80c9, 0x80e1, 0x80f9, 0x811d,
	// Entry 2300 - 233F
	0x813b, 0x8160, 0x816e, 0x817c, 0x81a2, 0x81c8, 0x81ef, 0x81f8,
	0x8212, 0x8229, 0x8230, 0x823d, 0x8254, 0x827c, 0x82aa, 0x82b4,
	0x82c9, 0x82e4, 0x830a, 0x8330, 0x8351, 0x8372, 0x838e, 0x83aa,
	0x83c9, 0x83e4, 0x8401, 0x8413, 0x8426, 0x8438, 0x8469, 0x8493,
	0x84c4, 0x84ee, 0x851c, 0x854a, 0x856d, 0x858c, 0x85b1, 0x85c2,
	0x85e2, 0x85ee, 0x8609, 0x8629, 0x864a, 0x8674, 0x869f, 0x86ca,
	0x86f6, 0x8727, 0x8759, 0x8783, 0x87ae, 0x87d8, 0x8803, 0x8825,
	0x8848, 0x886a, 0x888c, 0x88b0, 0x88d3, 0x88f6, 0x8918, 0x893c,
	// Entry 2340 - 237F
	0x8960, 0x8983, 0x89a6, 0x89ca, 0x89ee, 0x8a14, 0x8a39, 0x8a5e,
	0x8a82, 0x8aa8, 0x8ace, 0x8af3, 0x8b18, 0x8b45, 0x8b72, 0x8ba1,
	0x8bcf, 0x8bfd, 0x8c2a, 0x8c59, 0x8c88, 0x8cb6, 0x8ce4, 0x8d06,
	0x8d15, 0x8d25, 0x8d38, 0x8d4e, 0x8d64, 0x8d7a, 0x8d99, 0x8dbc,
	0x8ddc, 0x8e02, 0x8e29, 0x8e56, 0x8e6c, 0x8e94, 0x8ebf, 0x8ed9,
	0x8f0a, 0x8f39, 0x8f55, 0x8f81, 0x8fa4, 0x8fc6, 0x8ff1, 0x901d,
	0x904e, 0x907f, 0x90b2, 0x90bc, 0x90ef, 0x9113, 0x9133, 0x9153,
	0x9173, 0x9193, 0x91b9, 0x91df, 0x9205, 0x9225, 0x924c, 0x9269,
	// Entry 2380 - 23BF
	0x928c, 0x92aa, 0x92bb, 0x92d2, 0x9300, 0x930d, 0x9318, 0x9325,
	0x9340, 0x935c, 0x936e, 0x938e, 0x93a8, 0x93cb, 0x93e7, 0x93f4,
	0x9411, 0x9424, 0x9436, 0x9454, 0x9460, 0x947a, 0x9495, 0x94af,
	0x94be, 0x94ce, 0x94dd, 0x94ea, 0x94f9, 0x9518, 0x952b, 0x9538,
	0x9547, 0x9555, 0x956e, 0x9590, 0x95ab, 0x95da, 0x960a, 0x962a,
	0x964b, 0x9671, 0x9698, 0x96b7, 0x96d7, 0x96fd, 0x9724, 0x9752,
	0x9781, 0x97a8, 0x97d0, 0x97e7, 0x9800, 0x9821, 0x983e, 0x985b,
	0x986f, 0x9884, 0x9899, 0x98b4, 0x98d0, 0x98ec, 0x9909, 0x9927,
	// Entry 23C0 - 23FF
	0x994b, 0x9970, 0x998e, 0x99a3, 0x99b9, 0x99cf, 0x99e6, 0x99fc,
	0x9a13, 0x9a2a, 0x9a42, 0x9a58, 0x9a6f, 0x9a86, 0x9a9e, 0x9ab5,
	0x9acd, 0x9ae5, 0x9afe, 0x9b14, 0x9b2b, 0x9b42, 0x9b5a, 0x9b71,
	0x9b89, 0x9ba1, 0x9bba, 0x9bd1, 0x9be9, 0x9c01, 0x9c1a, 0x9c32,
	0x9c4b, 0x9c64, 0x9c7e, 0x9c94, 0x9cab, 0x9cc2, 0x9cda, 0x9cf1,
	0x9d09, 0x9d21, 0x9d3a, 0x9d51, 0x9d69, 0x9d81, 0x9d9a, 0x9db2,
	0x9dcb, 0x9de4, 0x9dfe, 0x9e15, 0x9e2d, 0x9e45, 0x9e5e, 0x9e76,
	0x9e8f, 0x9ea8, 0x9ec2, 0x9eda, 0x9ef3, 0x9f0c, 0x9f26, 0x9f3f,
	// Entry 2400 - 243F
	0x9f59, 0x9f73, 0x9f8e, 0x9fa4, 0x9fbb, 0x9fd2, 0x9fea, 0xa001,
	0xa019, 0xa031, 0xa04a, 0xa061, 0xa079, 0xa091, 0xa0aa, 0xa0c2,
	0xa0db, 0xa0f4, 0xa10e, 0xa125, 0xa13d, 0xa155, 0xa16e, 0xa186,
	0xa19f, 0xa1b8, 0xa1d2, 0xa1ea, 0xa203, 0xa21c, 0xa236, 0xa24f,
	0xa269, 0xa283, 0xa29e, 0xa2b5, 0xa2cd, 0xa2e5, 0xa2fe, 0xa316,
	0xa32f, 0xa348, 0xa362, 0xa37a, 0xa393, 0xa3ac, 0xa3c6, 0xa3df,
	0xa3f9, 0xa413, 0xa42e, 0xa446, 0xa45f, 0xa478, 0xa492, 0xa4ab,
	0xa4c5, 0xa4df, 0xa4fa, 0xa513, 0xa52d, 0xa547, 0xa562, 0xa57c,
	// Entry 2440 - 247F
	0xa597, 0xa5b2, 0xa5ce, 0xa5e4, 0xa5fb, 0xa612, 0xa62a, 0xa641,
	0xa659, 0xa671, 0xa68a, 0xa6a1, 0xa6b9, 0xa6d1, 0xa6ea, 0xa702,
	0xa71b, 0xa734, 0xa74e, 0xa765, 0xa77d, 0xa795, 0xa7ae, 0xa7c6,
	0xa7df, 0xa7f8, 0xa812, 0xa82a, 0xa843, 0xa85c, 0xa876, 0xa88f,
	0xa8a9, 0xa8c3, 0xa8de, 0xa8f5, 0xa90d, 0xa925, 0xa93e, 0xa956,
	0xa96f, 0xa988, 0xa9a2, 0xa9ba, 0xa9d3, 0xa9ec, 0xaa06, 0xaa1f,
	0xaa39, 0xaa53, 0xaa6e, 0xaa86, 0xaa9f, 0xaab8, 0xaad2, 0xaaeb,
	0xab05, 0xab1f, 0xab3a, 0xab53, 0xab6d, 0xab87, 0xaba2, 0xabbc,
	// Entry 2480 - 24BF
	0xabd7, 0xabf2, 0xac0e, 0xac25, 0xac3d, 0xac55, 0xac6e, 0xac86,
	0xac9f, 0xacb8, 0xacd2, 0xacea, 0xad03, 0xad1c, 0xad36, 0xad4f,
	0xad69, 0xad83, 0xad9e, 0xadb6, 0xadcf, 0xade8, 0xae02, 0xae1b,
	0xae35, 0xae4f, 0xae6a, 0xae83, 0xae9d, 0xaeb7, 0xaed2, 0xaeec,
	0xaf07, 0xaf22, 0xaf3e, 0xaf56, 0xaf6f, 0xaf88, 0xafa2, 0xafbb,
	0xafd5, 0xafef, 0xb00a, 0xb023, 0xb03d, 0xb057, 0xb072, 0xb08c,
	0xb0a7, 0xb0c2, 0xb0de, 0xb0f7, 0xb111, 0xb12b, 0xb146, 0xb160,
	0xb17b, 0xb196, 0xb1b2, 0xb1cc, 0xb1e7, 0xb202, 0xb21e, 0xb239,
	// Entry 24C0 - 24FF
	0xb255, 0xb271, 0xb28e, 0xb2be, 0xb2f5, 0xb320, 0xb34c, 0xb378,
	0xb39c, 0xb3bb, 0xb3db, 0xb401, 0xb425, 0xb439, 0xb44f, 0xb46a,
	0xb486, 0xb4a1, 0xb4bd, 0xb4e4, 0xb505, 0xb519, 0xb52f, 0xb55e,
	0xb594, 0xb5b9, 0xb5f3, 0xb634, 0xb648, 0xb65d, 0xb678, 0xb694,
	0xb6b4, 0xb6d5, 0xb6fe, 0xb728, 0xb747, 0xb766, 0xb780, 0xb79a,
	0xb7b4, 0xb7ce, 0xb7f3, 0xb818, 0xb83d, 0xb862, 0xb88b, 0xb8b4,
	0xb8de, 0xb908, 0xb932, 0xb95b, 0xb985, 0xb9af, 0xb9d1, 0xb9ff,
	0xba2f, 0xba5e, 0xba8e, 0xbaac, 0xbacd, 0xbae8, 0xbb06, 0xbb28,
	// Entry 2500 - 253F
	0xbb4d, 0xbb75, 0xbba0, 0xbbc1, 0xbbde, 0xbc0a, 0xbc36, 0xbc62,
	0xbc82, 0xbca1, 0xbcbb, 0xbce0, 0xbd0a, 0xbd2e, 0xbd52, 0xbd76,
	0xbd9a, 0xbdbc, 0xbde1, 0xbe07, 0xbe2a, 0xbe4f, 0xbe75, 0xbe9b,
	0xbec3, 0xbeea, 0xbf12, 0xbf37, 0xbf5e, 0xbf85, 0xbfad, 0xbfd5,
	0xbfff, 0xc028, 0xc052, 0xc079, 0xc0a2, 0xc0e7, 0xc12c, 0xc173,
	0xc1bc, 0xc200, 0xc248, 0xc28c, 0xc2d4, 0xc302, 0xc332, 0xc361,
	0xc392, 0xc3d9, 0xc420, 0xc444, 0xc466, 0xc48b, 0xc4af, 0xc4d4,
	0xc4fa, 0xc519, 0xc53a, 0xc55d, 0xc57a, 0xc598, 0xc5b6, 0xc5c4,
	// Entry 2540 - 257F
	0xc5d3, 0xc5df, 0xc5ed, 0xc60a, 0xc619, 0xc62e, 0xc646, 0xc65f,
	0xc675, 0xc68c, 0xc6a9, 0xc6c7, 0xc6e6, 0xc706, 0xc727, 0xc749,
	0xc774, 0xc7a3, 0xc7d1, 0xc7fd, 0xc818, 0xc834, 0xc84e, 0xc86c,
	0xc890, 0xc8b2, 0xc8d3, 0xc8f5, 0xc901, 0xc915, 0xc930, 0xc94f,
	0xc96c, 0xc97f, 0xc98a, 0xc9a6, 0xc9c0, 0xc9cc, 0xc9da, 0xc9ed,
	0xca09, 0xca21, 0xca3b, 0xca7d, 0xcabe, 0xcb02, 0xcb45, 0xcb87,
	0xcbc8, 0xcc0c, 0xcc4f, 0xcc61, 0xcc77, 0xcc98, 0xccb8, 0xccd7,
	0xccf1, 0xcd05, 0xcd15, 0xcd2c, 0xcd41, 0xcd86, 0xcda0, 0xcdcb,
	// Entry 2580 - 25BF
	0xcde2, 0xcdf6, 0xce04, 0xce15, 0xce29, 0xce4e, 0xce7d, 0xce9a,
	0xceb8, 0xcec8, 0xcedc, 0xceea, 0xcefc, 0xcf13, 0xcf29, 0xcf36,
	0xcf54, 0xcf76, 0xcf97, 0xcfb9, 0xcfd4, 0xcff0, 0xcffc, 0xd016,
	0xd031, 0xd040, 0xd04f, 0xd060, 0xd072, 0xd08a, 0xd0a3, 0xd0b6,
	0xd0c7, 0xd0e9, 0xd0fe, 0xd11b, 0xd127, 0xd136, 0xd156, 0xd187,
	0xd1a8, 0xd1b4, 0xd1c1, 0xd1ec, 0xd218, 0xd235, 0xd242, 0xd25e,
	0xd27a, 0xd293, 0xd2ac, 0xd2c6, 0xd2e0, 0xd2f9, 0xd312, 0xd31e,
	0xd336, 0xd34a, 0xd370, 0xd37b, 0xd38e, 0xd399, 0xd3a4, 0xd3c6,
	// Entry 25C0 - 25FF
	0xd3e9, 0xd3ed, 0xd3f1, 0xd40b, 0xd426, 0xd442, 0xd45f, 0xd47d,
	0xd49f, 0xd4ba, 0xd4d2, 0xd4e9, 0xd4fd, 0xd50b, 0xd522, 0xd53d,
	0xd551, 0xd56c, 0xd587, 0xd59b, 0xd5b4, 0xd5e6, 0xd619, 0xd640,
	0xd660, 0xd67c, 0xd6a3, 0xd6bb, 0xd6d5, 0xd6e8, 0xd6fd, 0xd713,
	0xd717, 0xd733, 0xd750, 0xd768, 0xd784, 0xd7a5, 0xd7cb, 0xd7e5,
	0xd7fd, 0xd817, 0xd833, 0xd850, 0xd86b, 0xd884, 0xd8a0, 0xd8bb,
	0xd8d8, 0xd8f6, 0xd90d, 0xd92f, 0xd950, 0xd975, 0xd982, 0xd9a9,
	0xd9d1, 0xda03, 0xda27, 0xda3c, 0xda51, 0xda67, 0xda86, 0xda96,
	// Entry 2600 - 263F
	0xdab0, 0xdad1, 0xdaea, 0xdaff, 0xdb14, 0xdb26, 0xdb3f, 0xdb5c,
	0xdb71, 0xdb89, 0xdba1, 0xdbc3, 0xdbe5, 0xdc07, 0xdc37, 0xdc4f,
	0xdc6e, 0xdc88, 0xdc9b, 0xdcc5, 0xdcdf, 0xdcf8, 0xdd0a, 0xdd1b,
	0xdd37, 0xdd52, 0xdd62, 0xdd73, 0xdd95, 0xddb1, 0xddcc, 0xddec,
	0xde0b, 0xde2a, 0xde43, 0xde63, 0xde7a, 0xde98, 0xdeb7, 0xded8,
	0xdef8, 0xdf12, 0xdf2a, 0xdf5b, 0xdf8c, 0xdfa9, 0xdfc8, 0xdfdd,
	0xdff5, 0xe009, 0xe02f, 0xe04e, 0xe069, 0xe084, 0xe0a4, 0xe0b6,
	0xe0d2, 0xe0f0, 0xe122, 0xe141, 0xe15d, 0xe17c, 0xe19e, 0xe1c3,
	// Entry 2640 - 267F
	0xe1e0, 0xe200, 0xe22d, 0xe25d, 0xe289, 0xe2b8, 0xe2ea, 0xe31e,
	0xe336, 0xe351, 0xe377, 0xe3a0, 0xe3bd, 0xe3dd, 0xe411, 0xe445,
	0xe465, 0xe488, 0xe4b2, 0xe4dc, 0xe510, 0xe544, 0xe588, 0xe5cc,
	0xe5e9, 0xe609, 0xe636, 0xe666, 0xe687, 0xe6ab, 0xe6d4, 0xe700,
	0xe714, 0xe72b, 0xe754, 0xe780, 0xe797, 0xe7b1, 0xe7d6, 0xe7f8,
	0xe815, 0xe82e, 0xe84a, 0xe877, 0xe8a7, 0xe8b3, 0xe8be, 0xe8d6,
	0xe8ed, 0xe909, 0xe92f, 0xe955, 0xe97c, 0xe9a3, 0xe9bd, 0xe9d7,
	0xe9f2, 0xea0d, 0xea2b, 0xea49, 0xea6b, 0xea8d, 0xea9c, 0xeaab,
	// Entry 2680 - 26BF
	0xeaba, 0xeacb, 0xeae6, 0xeb03, 0xeb28, 0xeb4f, 0xeb73, 0xeb99,
	0xebb4, 0xebd1, 0xebef, 0xec0f, 0xec2e, 0xec4f, 0xec6b, 0xec89,
	0xeca6, 0xecc4, 0xecd1, 0xece0, 0xecf9, 0xed14, 0xed29, 0xed3e,
	0xed51, 0xed68, 0xed7e, 0xedac, 0xedc8, 0xedde, 0xedf6, 0xedfd,
	0xee07, 0xee16, 0xee25, 0xee32, 0xee46, 0xee69, 0xee8b, 0xeead,
	0xeed6, 0xef03, 0xef1f, 0xef3a, 0xef5d, 0xef6d, 0xef7b, 0xef91,
	0xefb0, 0xefdc, 0xeffb, 0xf01a, 0xf035, 0xf054, 0xf070, 0xf093,
	0xf0bd, 0xf0d2, 0xf0e9, 0xf103, 0xf12c, 0xf158, 0xf176, 0xf198,
	// Entry 26C0 - 26FF
	0xf1af, 0xf1c1, 0xf1d9, 0xf1ef, 0xf205, 0xf21b, 0xf231, 0xf247,
	0xf25c, 0xf26f, 0xf284, 0xf29a, 0xf2b0, 0xf2c6, 0xf2dc, 0xf2f2,
	0xf305, 0xf328, 0xf349, 0xf36b, 0xf38b, 0xf3a5, 0xf3c2, 0xf3ed,
	0xf417, 0xf433, 0xf450, 0xf46b, 0xf489, 0xf496, 0xf4a8, 0xf4ba,
	0xf4d1, 0xf4e8, 0xf4f6, 0xf504, 0xf511, 0xf51e, 0xf536, 0xf548,
	0xf55c, 0xf570, 0xf584, 0xf598, 0xf5ab, 0xf5be, 0xf5d1, 0xf5e9,
	0xf601, 0xf617, 0xf62d, 0xf649, 0xf65f, 0xf67b, 0xf698, 0xf6c7,
	0xf6fd, 0xf720, 0xf746, 0xf766, 0xf794, 0xf7c9, 0xf7ed, 0xf826,
	// Entry 2700 - 273F
	0xf866, 0xf87f, 0xf8a0, 0xf8c1, 0xf8ed, 0xf91a, 0xf93f, 0xf960,
	0xf979, 0xf993, 0xf9c0, 0xf9ee, 0xfa12, 0xfa37, 0xfa63, 0xfa90,
	0xfab6, 0xfacf, 0xfaec, 0xfafd, 0xfb0d, 0xfb1d, 0xfb3a, 0xfb57,
	0xfb69, 0xfb84, 0xfba3, 0xfbaf, 0xfbc4, 0xfbe8, 0xfc10, 0xfc38,
	0xfc64, 0xfc91, 0xfcc4, 0xfce3, 0xfd00, 0xfd20, 0xfd3f, 0xfd5f,
	0xfd7c, 0xfd9c, 0xfdbc, 0xfddc, 0xfdfc, 0xfe22, 0xfe46, 0xfe6d,
	0xfe93, 0xfebe, 0xfeed, 0xff13, 0xff37, 0xff5e, 0xff84, 0xffab,
	0xffd2, 0xfff9, 0x0020, 0x005d, 0x0098, 0x00d6, 0x0113, 0x0125,
	// Entry 2740 - 277F
	0x0135, 0x017a, 0x01c4, 0x0209, 0x0253, 0x027a, 0x029f, 0x02c7,
	0x02ee, 0x0311, 0x0332, 0x0356, 0x0379, 0x03ab, 0x03de, 0x040f,
	0x043f, 0x044a, 0x0456, 0x0462, 0x046f, 0x0498, 0x04ae, 0x04e1,
	0x0514, 0x0548, 0x057c, 0x05a1, 0x05c4, 0x05ea, 0x060f, 0x0646,
	0x067e, 0x06b3, 0x06e9, 0x071e, 0x0754, 0x078b, 0x07c3, 0x07ed,
	0x0818, 0x0840, 0x0869, 0x0891, 0x08ba, 0x08e4, 0x090f, 0x0925,
	0x093c, 0x0950, 0x0965, 0x0979, 0x098e, 0x09a4, 0x09bb, 0x09eb,
	0x0a0a, 0x0a23, 0x0a46, 0x0a5f, 0x0a76, 0x0a7f, 0x0a8d, 0x0aa1,
	// Entry 2780 - 27BF
	0x0ab6, 0x0acb, 0x0ae3, 0x0af0, 0x0b19, 0x0b44, 0x0b6f, 0x0b9b,
	0x0bab, 0x0bc0, 0x0bd8, 0x0bf5, 0x0c1a, 0x0c31, 0x0c50, 0x0c69,
	0x0c79, 0x0c83, 0x0c91, 0x0ca1, 0x0cb0, 0x0cbf, 0x0cc9, 0x0cd3,
	0x0cda, 0x0ce0, 0x0ce6, 0x0cec, 0x0cfd, 0x0d13, 0x0d27, 0x0d2d,
	0x0d32, 0x0d36, 0x0d3c, 0x0d43, 0x0d4a, 0x0d52, 0x0d5a, 0x0d6e,
	0x0d83, 0x0d9c, 0x0db6, 0x0de9, 0x0e1a, 0x0e4e, 0x0e81, 0x0e8e,
	0x0e9b, 0x0ea0, 0x0ec5, 0x0ee7, 0x0f0b, 0x0f2f, 0x0f53, 0x0f78,
	0x0f97, 0x0fa4, 0x0fb4, 0x0fc2, 0x0fcf, 0x0fe3, 0x0ffd, 0x101a,
	// Entry 27C0 - 27FF
	0x1038, 0x1056, 0x1077, 0x1096, 0x10b5, 0x10d6, 0x10f5, 0x1115,
	0x1133, 0x1159, 0x1174, 0x1194, 0x11b2, 0x11d3, 0x11f4, 0x1213,
	0x1230, 0x1250, 0x126f, 0x128e, 0x12ae, 0x12cb, 0x12ea, 0x1308,
	0x1325, 0x1341, 0x135f, 0x137c, 0x139c, 0x13b9, 0x13d7, 0x13f5,
	0x1413, 0x1437, 0x1453, 0x1476, 0x14a3, 0x14bf, 0x14ea, 0x150b,
	0x1534, 0x1552, 0x1573, 0x1594, 0x15ba, 0x15e4, 0x15ff, 0x161b,
	0x1637, 0x1656, 0x1673, 0x1690, 0x16af, 0x16cc, 0x16ea, 0x1706,
	0x172a, 0x1743, 0x1761, 0x177d, 0x179c, 0x17bb, 0x17d8, 0x17f3,
	// Entry 2800 - 283F
	0x1811, 0x182e, 0x184b, 0x1869, 0x1884, 0x18a1, 0x18bd, 0x18d8,
	0x18f2, 0x190e, 0x1929, 0x1947, 0x1962, 0x197e, 0x199a, 0x19b6,
	0x19d8, 0x19f2, 0x1a13, 0x1a3e, 0x1a58, 0x1a81, 0x1aa0, 0x1ac7,
	0x1ae3, 0x1b02, 0x1b21, 0x1b45, 0x1b6d, 0x1b93, 0x1bb7, 0x1bdf,
	0x1c01, 0x1c21, 0x1c41, 0x1c6a, 0x1c8f, 0x1cb2, 0x1cd7, 0x1cfa,
	0x1d1f, 0x1d42, 0x1d5c, 0x1d7c, 0x1d99, 0x1dba, 0x1dde, 0x1dfe,
	0x1e1c, 0x1e3a, 0x1e55, 0x1e6e, 0x1e8d, 0x1eac, 0x1ed1, 0x1efa,
	0x1f1d, 0x1f3b, 0x1f54, 0x1f7a, 0x1fa0, 0x1fba, 0x1fd2, 0x1fec,
	// Entry 2840 - 287F
	0x2004, 0x201f, 0x2038, 0x2053, 0x206c, 0x2085, 0x209c, 0x20b5,
	0x20cc, 0x20e6, 0x20fe, 0x2118, 0x2130, 0x214c, 0x2166, 0x2181,
	0x219a, 0x21b4, 0x21cc, 0x21e7, 0x2200, 0x2218, 0x222e, 0x2246,
	0x225c, 0x2275, 0x228c, 0x22a3, 0x22b8, 0x22d0, 0x22e6, 0x22fe,
	0x2314, 0x232e, 0x2346, 0x235f, 0x2376, 0x238e, 0x23a4, 0x23bc,
	0x23d2, 0x23eb, 0x2402, 0x241b, 0x2432, 0x244b, 0x2462, 0x2486,
	0x24a8, 0x24cc, 0x24ee, 0x2515, 0x253a, 0x255e, 0x2580, 0x25a2,
	0x25c2, 0x25e8, 0x260c, 0x2630, 0x2652, 0x266d, 0x2686, 0x26a8,
	// Entry 2880 - 28BF
	0x26c8, 0x26ed, 0x2710, 0x2734, 0x2756, 0x2779, 0x279a, 0x27be,
	0x27e0, 0x2805, 0x2828, 0x284b, 0x286c, 0x288d, 0x28ac, 0x28d0,
	0x28f2, 0x2916, 0x2938, 0x295f, 0x2984, 0x29a8, 0x29ca, 0x29f0,
	0x2a14, 0x2a3a, 0x2a5e, 0x2a82, 0x2aa4, 0x2ac8, 0x2aea, 0x2b0e,
	0x2b30, 0x2b41, 0x2b54, 0x2b67, 0x2b7c, 0x2b90, 0x2ba4, 0x2bbc,
	0x2be4, 0x2c0a, 0x2c34, 0x2c5c, 0x2c75, 0x2c94, 0x2cb3, 0x2cd6,
	0x2cf7, 0x2d12, 0x2d38, 0x2d60, 0x2d7f, 0x2d97, 0x2da7, 0x2dc3,
	0x2ddb, 0x2df4, 0x2e0d, 0x2e26, 0x2e3e, 0x2e57, 0x2e70, 0x2e89,
	// Entry 28C0 - 28FF
	0x2ea1, 0x2eba, 0x2ed3, 0x2eec, 0x2f05, 0x2f1d, 0x2f36, 0x2f50,
	0x2f69, 0x2f82, 0x2f9b, 0x2fb3, 0x2fcd, 0x2fe7, 0x3001, 0x301a,
	0x3034, 0x304e, 0x3067, 0x3080, 0x3099, 0x30b3, 0x30cc, 0x30e6,
	0x30ff, 0x3117, 0x3130, 0x3148, 0x3161, 0x317a, 0x3192, 0x31ab,
	0x31bd, 0x31d0, 0x31e4, 0x31f7, 0x320c, 0x322e, 0x3241, 0x3254,
	0x3268, 0x327c, 0x3291, 0x32a4, 0x32b7, 0x32ca, 0x32e4, 0x32f9,
	0x330c, 0x332e, 0x3348, 0x335c, 0x336f, 0x3383, 0x339e, 0x33b1,
	0x33cb, 0x33dd, 0x33f1, 0x340d, 0x3428, 0x343b, 0x344e, 0x3461,
	// Entry 2900 - 293F
	0x347c, 0x3497, 0x34aa, 0x34bc, 0x34cf, 0x34e3, 0x34f7, 0x3512,
	0x352b, 0x353e, 0x3552, 0x3566, 0x3579, 0x358d, 0x35a1, 0x35b5,
	0x35c8, 0x35db, 0x35ee, 0x3601, 0x361f, 0x3633, 0x3645, 0x3657,
	0x3682, 0x3699, 0x36b2, 0x36c7, 0x36dc, 0x36f1, 0x3706, 0x371c,
	0x3731, 0x3746, 0x375b, 0x3770, 0x3786, 0x37a2, 0x37b7, 0x37cc,
	0x37e2, 0x37f7, 0x380d, 0x3823, 0x3839, 0x384e, 0x3864, 0x387a,
	0x3891, 0x38a7, 0x38bc, 0x38d1, 0x38e6, 0x38fc, 0x3912, 0x3927,
	0x393c, 0x3951, 0x3966, 0x397b, 0x3991, 0x39a7, 0x39bc, 0x39d1,
	// Entry 2940 - 297F
	0x39e6, 0x39fb, 0x3a10, 0x3a26, 0x3a3c, 0x3a51, 0x3a66, 0x3a7c,
	0x3a92, 0x3aa8, 0x3abf, 0x3ad6, 0x3aec, 0x3b02, 0x3b17, 0x3b2c,
	0x3b41, 0x3b57, 0x3b6d, 0x3b82, 0x3b97, 0x3bac, 0x3bc1, 0x3bd6,
	0x3bec, 0x3c02, 0x3c17, 0x3c2c, 0x3c41, 0x3c56, 0x3c6b, 0x3c81,
	0x3c97, 0x3cac, 0x3cc1, 0x3cd6, 0x3ceb, 0x3d00, 0x3d16, 0x3d2c,
	0x3d41, 0x3d56, 0x3d72, 0x3d8e, 0x3dab, 0x3dc7, 0x3de4, 0x3e00,
	0x3e1c, 0x3e38, 0x3e54, 0x3e70, 0x3e8b, 0x3ea7, 0x3ec3, 0x3edf,
	0x3efb, 0x3f17, 0x3f34, 0x3f51, 0x3f6e, 0x3f8d, 0x3fab, 0x3fca,
	// Entry 2980 - 29BF
	0x3fe5, 0x4001, 0x4020, 0x4046, 0x4063, 0x407f, 0x40a3, 0x40c7,
	0x40e8, 0x4112, 0x4131, 0x4157, 0x4170, 0x418a, 0x41aa, 0x41cb,
	0x41e6, 0x4208, 0x4223, 0x423d, 0x4258, 0x4265, 0x4281, 0x429e,
	0x42af, 0x42ba, 0x42cc, 0x42e7, 0x42f3, 0x4300, 0x4310, 0x431e,
	0x4339, 0x434e, 0x4362, 0x436d, 0x4382, 0x4397, 0x43b2, 0x43ce,
	0x43e2, 0x43f6, 0x4412, 0x442f, 0x4444, 0x445a, 0x4472, 0x448b,
	0x44a2, 0x44ba, 0x44d1, 0x44e9, 0x450a, 0x452b, 0x4547, 0x4554,
	0x456a, 0x4578, 0x4582, 0x459b, 0x45a7, 0x45b1, 0x45bd, 0x45cd,
	// Entry 29C0 - 29FF
	0x45e3, 0x45fa, 0x4607, 0x461c, 0x4627, 0x4634, 0x464a, 0x465b,
	0x466f, 0x4678, 0x4685, 0x4693, 0x46b7, 0x46cc, 0x46e2, 0x46f5,
	0x471a, 0x4724, 0x4737, 0x474b, 0x4759, 0x4766, 0x4774, 0x4784,
	0x4799, 0x47ae, 0x47c0, 0x47d1, 0x47e7, 0x47fd, 0x4815, 0x4827,
	0x4836, 0x4847, 0x485c, 0x4871, 0x4887, 0x4897, 0x48ac, 0x48c1,
	0x48d5, 0x48e9, 0x48ff, 0x4914, 0x4925, 0x4937, 0x494c, 0x4961,
	0x4976, 0x498b, 0x499b, 0x49aa, 0x49bb, 0x49ca, 0x49da, 0x49eb,
	0x49fd, 0x4a11, 0x4a26, 0x4a3b, 0x4a4b, 0x4a5e, 0x4a71, 0x4a97,
	// Entry 2A00 - 2A3F
	0x4aa6, 0x4ab5, 0x4ac5, 0x4ade, 0x4aed, 0x4b03, 0x4b19, 0x4b2b,
	0x4b3b, 0x4b58, 0x4b6b, 0x4b7e, 0x4b93, 0x4ba7, 0x4bb7, 0x4bc8,
	0x4bd7, 0x4be6, 0x4bf5, 0x4c0a, 0x4c1f, 0x4c2f, 0x4c41, 0x4c56,
	0x4c6b, 0x4c82, 0x4c93, 0x4ca6, 0x4cba, 0x4cce, 0x4cea, 0x4d05,
	0x4d15, 0x4d34, 0x4d52, 0x4d62, 0x4d7f, 0x4d9a, 0x4dae, 0x4dc2,
	0x4dd2, 0x4def, 0x4e03, 0x4e17, 0x4e34, 0x4e51, 0x4e66, 0x4e7b,
	0x4e8b, 0x4e9b, 0x4ec2, 0x4edf, 0x4efc, 0x4f18, 0x4f2b, 0x4f3e,
	0x4f53, 0x4f6f, 0x4f7f, 0x4f9d, 0x4fad, 0x4fbe, 0x4fdb, 0x4ff8,
	// Entry 2A40 - 2A7F
	0x5015, 0x5031, 0x504e, 0x506b, 0x5088, 0x50a5, 0x50c3, 0x50e1,
	0x5100, 0x511f, 0x5131, 0x5150, 0x516f, 0x5181, 0x5194, 0x51a6,
	0x51ba, 0x51cf, 0x51e2, 0x51f4, 0x5206, 0x5218, 0x522b, 0x523f,
	0x5253, 0x526a, 0x527e, 0x5290, 0x52a4, 0x52bb, 0x52cf, 0x52e3,
	0x52f6, 0x530a, 0x5327, 0x5346, 0x5358, 0x5371, 0x5384, 0x5398,
	0x53ae, 0x53c2, 0x53d6, 0x53ee, 0x5402, 0x5418, 0x5429, 0x5441,
	0x5457, 0x5469, 0x547d, 0x5491, 0x54a4, 0x54b7, 0x54cb, 0x54de,
	0x54f3, 0x5508, 0x551f, 0x5533, 0x5546, 0x555c, 0x5571, 0x5583,
	// Entry 2A80 - 2ABF
	0x559e, 0x55b9, 0x55d3, 0x55eb, 0x55ff, 0x5611, 0x5625, 0x563b,
	0x564e, 0x5662, 0x5678, 0x568b, 0x569e, 0x56b3, 0x56c5, 0x56da,
	0x56ef, 0x5701, 0x5716, 0x5728, 0x573a, 0x574c, 0x575f, 0x5772,
	0x5785, 0x5798, 0x57ac, 0x57c1, 0x57d6, 0x57ec, 0x57fe, 0x5811,
	0x5825, 0x5839, 0x584c, 0x585f, 0x5874, 0x588b, 0x58a9, 0x58bd,
	0x58d0, 0x58e2, 0x58f4, 0x590b, 0x591e, 0x5932, 0x5945, 0x5959,
	0x596c, 0x597e, 0x5992, 0x59ae, 0x59c5, 0x59df, 0x59f3, 0x5a06,
	0x5a19, 0x5a2b, 0x5a3f, 0x5a53, 0x5a67, 0x5a7c, 0x5a90, 0x5aa4,
	// Entry 2AC0 - 2AFF
	0x5ab7, 0x5acb, 0x5ae0, 0x5af3, 0x5b06, 0x5b18, 0x5b2a, 0x5b3e,
	0x5b54, 0x5b66, 0x5b78, 0x5b8b, 0x5b9d, 0x5bb1, 0x5bc4, 0x5bdb,
	0x5bee, 0x5c03, 0x5c18, 0x5c2d, 0x5c42, 0x5c55, 0x5c6c, 0x5c80,
	0x5c94, 0x5ca8, 0x5cbd, 0x5cd1, 0x5cee, 0x5d04, 0x5d17, 0x5d29,
	0x5d3c, 0x5d51, 0x5d66, 0x5d79, 0x5d8b, 0x5da0, 0x5db4, 0x5dc6,
	0x5dd8, 0x5deb, 0x5dfe, 0x5e11, 0x5e26, 0x5e3c, 0x5e4f, 0x5e62,
	0x5e75, 0x5e8f, 0x5ea5, 0x5eb8, 0x5ecb, 0x5ede, 0x5ef2, 0x5f06,
	0x5f26, 0x5f39, 0x5f4c, 0x5f60, 0x5f73, 0x5f89, 0x5fa6, 0x5fb9,
	// Entry 2B00 - 2B3F
	0x5fcd, 0x5fe0, 0x5ff3, 0x6005, 0x6017, 0x602a, 0x6041, 0x6055,
	0x6068, 0x607b, 0x608e, 0x60a2, 0x60c1, 0x60d8, 0x60ec, 0x60ff,
	0x6112, 0x6125, 0x6138, 0x614c, 0x615f, 0x6174, 0x6189, 0x619d,
	0x61b6, 0x61c9, 0x61de, 0x61f1, 0x6203, 0x6216, 0x6229, 0x623d,
	0x6252, 0x6267, 0x627b, 0x62aa, 0x62da, 0x6314, 0x634f, 0x637e,
	0x63b3, 0x63e8, 0x641c, 0x6456, 0x6491, 0x64cb, 0x64f5, 0x6506,
	0x6517, 0x652c, 0x6536, 0x6559, 0x6573, 0x658b, 0x65a2, 0x65b4,
	0x65c7, 0x65e0, 0x65fa, 0x660d, 0x6621, 0x663a, 0x6654, 0x6671,
	// Entry 2B40 - 2B7F
	0x668f, 0x669a, 0x66a3, 0x66be, 0x66da, 0x66f7, 0x6715, 0x6736,
	0x6758, 0x6771, 0x678b, 0x6794, 0x67b8, 0x67d3, 0x67f2, 0x6802,
	0x6816, 0x682a, 0x6840, 0x6855, 0x686a, 0x687e, 0x6894, 0x68aa,
	0x68bf, 0x68da, 0x68f6, 0x6915, 0x6933, 0x694e, 0x6969, 0x6972,
	0x698b, 0x69b6, 0x69da, 0x6a10, 0x6a34, 0x6a47, 0x6a77, 0x6a8b,
	0x6aa2, 0x6ab9, 0x6adc, 0x6ae5, 0x6afa, 0x6b19, 0x6b34, 0x6b4b,
	0x6b5c, 0x6b73, 0x6b84, 0x6b9b, 0x6bac, 0x6bc3, 0x6bd4, 0x6beb,
	0x6bfc, 0x6c0e, 0x6c20, 0x6c32, 0x6c44, 0x6c56, 0x6c68, 0x6c7a,
	// Entry 2B80 - 2BBF
	0x6c8c, 0x6c9e, 0x6cb0, 0x6cc2, 0x6cd4, 0x6ce6, 0x6cf8, 0x6d0a,
	0x6d1c, 0x6d2e, 0x6d40, 0x6d52, 0x6d64, 0x6d76, 0x6d88, 0x6d9a,
	0x6dac, 0x6dc4, 0x6dd6, 0x6de8, 0x6dfa, 0x6e0c, 0x6e1e, 0x6e30,
	0x6e42, 0x6e54, 0x6e66, 0x6e78, 0x6e8a, 0x6e9c, 0x6eae, 0x6ec0,
	0x6ed2, 0x6ee4, 0x6ef6, 0x6f08, 0x6f1a, 0x6f2c, 0x6f3e, 0x6f50,
	0x6f62, 0x6f74, 0x6f86, 0x6f98, 0x6faa, 0x6fbc, 0x6fce, 0x6fe0,
	0x6ff2, 0x700a, 0x701c, 0x7034, 0x7046, 0x705e, 0x7070, 0x7082,
	0x7094, 0x70a6, 0x70b8, 0x70ca, 0x70e2, 0x70f4, 0x7106, 0x7118,
	// Entry 2BC0 - 2BFF
	0x712a, 0x713b, 0x714d, 0x7165, 0x717d, 0x71aa, 0x71dc, 0x71ff,
	0x7227, 0x723e, 0x725c, 0x7271, 0x7290, 0x72a7, 0x72b8, 0x72cf,
	0x72e0, 0x72f7, 0x7308, 0x731f, 0x7330, 0x7347, 0x7358, 0x736a,
	0x737c, 0x738e, 0x73a0, 0x73b2, 0x73c4, 0x73d6, 0x73e8, 0x73fa,
	0x740c, 0x741e, 0x7430, 0x7442, 0x7454, 0x7466, 0x7478, 0x748a,
	0x749c, 0x74ae, 0x74c0, 0x74d2, 0x74e4, 0x74f6, 0x7508, 0x7520,
	0x7532, 0x7544, 0x7556, 0x7568, 0x757a, 0x758c, 0x759e, 0x75b0,
	0x75c2, 0x75d4, 0x75e6, 0x75f8, 0x760a, 0x761c, 0x762e, 0x7640,
	// Entry 2C00 - 2C3F
	0x7652, 0x7664, 0x7676, 0x7688, 0x769a, 0x76ac, 0x76be, 0x76d0,
	0x76e2, 0x76f4, 0x7706, 0x7718, 0x772a, 0x773c, 0x774e, 0x7766,
	0x7778, 0x7790, 0x77a2, 0x77ba, 0x77cc, 0x77de, 0x77f0, 0x7802,
	0x7814, 0x7826, 0x783e, 0x7850, 0x7862, 0x7874, 0x7886, 0x7897,
	0x78a9, 0x78c1, 0x78d9, 0x78eb, 0x78fd, 0x790f, 0x7921, 0x7934,
	0x795a, 0x7971, 0x798f, 0x79a4, 0x79b5, 0x79c6, 0x79d7, 0x79e8,
	0x79f9, 0x7a0a, 0x7a1b, 0x7a2c, 0x7a3d, 0x7a4e, 0x7a5f, 0x7a70,
	0x7a81, 0x7a92, 0x7aa4, 0x7ab6, 0x7ac8, 0x7ad9, 0x7aea, 0x7afb,
	// Entry 2C40 - 2C7F
	0x7b0c, 0x7b1d, 0x7b2e, 0x7b3f, 0x7b51, 0x7b63, 0x7b75, 0x7b87,
	0x7b99, 0x7bab, 0x7bbd, 0x7bd0, 0x7be3, 0x7bf5, 0x7c06, 0x7c17,
	0x7c29, 0x7c3a, 0x7c4c, 0x7c5e, 0x7c70, 0x7c90, 0x7ca2, 0x7cb6,
	0x7ccf, 0x7ce8, 0x7cfb, 0x7d14, 0x7d2d, 0x7d41, 0x7d5a, 0x7d6d,
	0x7d87, 0x7da0, 0x7db9, 0x7dd1, 0x7dec, 0x7e07, 0x7e20, 0x7e33,
	0x7e46, 0x7e5e, 0x7e76, 0x7e88, 0x7e9f, 0x7eb2, 0x7ec5, 0x7edd,
	0x7ef2, 0x7f07, 0x7f1c, 0x7f31, 0x7f44, 0x7f53, 0x7f63, 0x7f73,
	0x7f84, 0x7f94, 0x7fa3, 0x7fb4, 0x7fc4, 0x7fd3, 0x7fe3, 0x7ff4,
	// Entry 2C80 - 2CBF
	0x8004, 0x8014, 0x8023, 0x8034, 0x8044, 0x8054, 0x8064, 0x8074,
	0x8084, 0x8093, 0x80a0, 0x80b8, 0x80d2, 0x80ea, 0x8105, 0x8124,
	0x813e, 0x815c, 0x8177, 0x8196, 0x81af, 0x81c7, 0x81e2, 0x81fd,
	0x8217, 0x8231, 0x8250, 0x826f, 0x8288, 0x82a3, 0x82be, 0x82de,
	0x82f7, 0x830f, 0x8328, 0x8340, 0x8358, 0x836d, 0x8385, 0x839b,
	0x83b6, 0x83d4, 0x83f1, 0x8409, 0x8422, 0x8435, 0x8449, 0x845b,
	0x846f, 0x8482, 0x8494, 0x84a7, 0x84bb, 0x84de, 0x8501, 0x8520,
	0x853f, 0x8560, 0x8580, 0x859f, 0x85c1, 0x85e3, 0x8604, 0x8626,
	// Entry 2CC0 - 2CFF
	0x8647, 0x8669, 0x868b, 0x86ac, 0x86cb, 0x86dd, 0x86ef, 0x8701,
	0x8713, 0x8725, 0x8738, 0x874a, 0x875d, 0x876f, 0x8782, 0x8795,
	0x87a8, 0x87ba, 0x87cd, 0x87e1, 0x87f5, 0x8807, 0x8819, 0x882c,
	0x8840, 0x8857, 0x886e, 0x8885, 0x889c, 0x88ae, 0x88c0, 0x88d2,
	0x88de, 0x88eb, 0x88f8, 0x8906, 0x8913, 0x8921, 0x892f, 0x893c,
	0x894b, 0x895a, 0x8968, 0x8977, 0x8986, 0x8994, 0x89a3, 0x89af,
	0x89bb, 0x89c7, 0x89d3, 0x89e0, 0x89ec, 0x89f9, 0x8a06, 0x8a13,
	0x8a21, 0x8a2e, 0x8a3b, 0x8a48, 0x8a55, 0x8a62, 0x8a70, 0x8a7e,
	// Entry 2D00 - 2D3F
	0x8a8d, 0x8a9d, 0x8aaa, 0x8ab6, 0x8ace, 0x8ae6, 0x8afe, 0x8b16,
	0x8b2e, 0x8b46, 0x8b5e, 0x8b76, 0x8b8e, 0x8ba6, 0x8bbe, 0x8bd6,
	0x8bee, 0x8c06, 0x8c1e, 0x8c36, 0x8c51, 0x8c6b, 0x8c86, 0x8ca0,
	0x8cba, 0x8cd4, 0x8ced, 0x8d07, 0x8d21, 0x8d3d, 0x8d59, 0x8d75,
	0x8d91, 0x8dab, 0x8dc8, 0x8de4, 0x8e01, 0x8e1d, 0x8e39, 0x8e55,
	0x8e70, 0x8e8c, 0x8ea8, 0x8ec6, 0x8ee4, 0x8f02, 0x8f20, 0x8f3c,
	0x8f58, 0x8f7c, 0x8f9f, 0x8fba, 0x8fd5, 0x8ff2, 0x900e, 0x902a,
	0x9045, 0x9062, 0x907f, 0x909b, 0x90b6, 0x90d2, 0x90ee, 0x910b,
	// Entry 2D40 - 2D7F
	0x9127, 0x9144, 0x9161, 0x917c, 0x9199, 0x91b5, 0x91d4, 0x91f0,
	0x920f, 0x9230, 0x9256, 0x9273, 0x9294, 0x92b0, 0x92cd, 0x92ee,
	0x9310, 0x9330, 0x9350, 0x9370, 0x938c, 0x93a8, 0x93c5, 0x93df,
	0x93fd, 0x9415, 0x942b, 0x944d, 0x9472, 0x9497, 0x94bb, 0x94df,
	0x9503, 0x9529, 0x954e, 0x955e, 0x9577, 0x9590, 0x95ab, 0x95c5,
	0x95df, 0x95f8, 0x9613, 0x962e, 0x9648, 0x965d, 0x9676, 0x968f,
	0x96aa, 0x96c4, 0x96de, 0x96f3, 0x9707, 0x971c, 0x9730, 0x9744,
	0x9758, 0x976b, 0x977f, 0x9793, 0x97a9, 0x97bf, 0x97d5, 0x97eb,
	// Entry 2D80 - 2DBF
	0x97ff, 0x9816, 0x982c, 0x9843, 0x9859, 0x986f, 0x9885, 0x989a,
	0x98b0, 0x98c6, 0x98de, 0x98f6, 0x990e, 0x9926, 0x993c, 0x995b,
	0x9979, 0x998f, 0x99a5, 0x99ba, 0x99cf, 0x99e6, 0x99fc, 0x9a12,
	0x9a27, 0x9a3e, 0x9a55, 0x9a6b, 0x9a80, 0x9a96, 0x9aac, 0x9ac3,
	0x9ad9, 0x9af0, 0x9b07, 0x9b1c, 0x9b33, 0x9b49, 0x9b62, 0x9b78,
	0x9b91, 0x9bac, 0x9bcc, 0x9be3, 0x9bfb, 0x9c11, 0x9c29, 0x9c43,
	0x9c5e, 0x9c75, 0x9c90, 0x9ca6, 0x9cbc, 0x9cd2, 0x9ceb, 0x9d01,
	0x9d19, 0x9d2e, 0x9d44, 0x9d5b, 0x9d75, 0x9d8f, 0x9da6, 0x9dc1,
	// Entry 2DC0 - 2DFF
	0x9ddd, 0x9df7, 0x9e11, 0x9e28, 0x9e41, 0x9e5c, 0x9e77, 0x9e91,
	0x9ea5, 0x9ebd, 0x9ed5, 0x9eef, 0x9f08, 0x9f21, 0x9f39, 0x9f53,
	0x9f6d, 0x9f86, 0x9f9a, 0x9fc2, 0x9feb, 0xa011, 0xa037, 0xa05b,
	0xa080, 0xa0a5, 0xa0cc, 0xa0f6, 0xa11e, 0xa147, 0xa170, 0xa179,
	0xa183, 0xa18c, 0xa1a2, 0xa1b4, 0xa1c6, 0xa1d8, 0xa1ea, 0xa1fc,
	0xa20f, 0xa222, 0xa235, 0xa248, 0xa25b, 0xa26e, 0xa281, 0xa294,
	0xa2a7, 0xa2ba, 0xa2cd, 0xa2e0, 0xa2f3, 0xa306, 0xa319, 0xa32c,
	0xa33f, 0xa352, 0xa365, 0xa378, 0xa38b, 0xa39e, 0xa3b1, 0xa3c4,
	// Entry 2E00 - 2E3F
	0xa3d7, 0xa3ea, 0xa3fd, 0xa410, 0xa423, 0xa436, 0xa449, 0xa45c,
	0xa46f, 0xa482, 0xa495, 0xa4a8, 0xa4bb, 0xa4ce, 0xa4e1, 0xa4f4,
	0xa507, 0xa51a, 0xa527, 0xa534, 0xa540, 0xa54b, 0xa558, 0xa563,
	0xa56d, 0xa57c, 0xa588, 0xa593, 0xa59e, 0xa5aa, 0xa5b8, 0xa5c6,
	0xa5d2, 0xa5de, 0xa5e9, 0xa5f5, 0xa602, 0xa610, 0xa61b, 0xa62c,
	0xa63e, 0xa64e, 0xa65b, 0xa66b, 0xa67b, 0xa689, 0xa695, 0xa6a2,
	0xa6ae, 0xa6bc, 0xa6cb, 0xa6d9, 0xa6e5, 0xa6f1, 0xa6fd, 0xa708,
	0xa713, 0xa71d, 0xa728, 0xa734, 0xa740, 0xa74f, 0xa75b, 0xa769,
	// Entry 2E40 - 2E7F
	0xa779, 0xa786, 0xa791, 0xa79c, 0xa7ab, 0xa7b8, 0xa7c7, 0xa7d3,
	0xa7e3, 0xa7ee, 0xa7fb, 0xa808, 0xa814, 0xa820, 0xa82c, 0xa839,
	0xa846, 0xa850, 0xa85c, 0xa868, 0xa873, 0xa881, 0xa88d, 0xa899,
	0xa8a6, 0xa8b4, 0xa8c2, 0xa8cd, 0xa8dd, 0xa8e8, 0xa8f6, 0xa904,
	0xa910, 0xa91c, 0xa927, 0xa935, 0xa940, 0xa94c, 0xa95a, 0xa965,
	0xa974, 0xa980, 0xa9aa, 0xa9d3, 0xa9fc, 0xaa27, 0xaa51, 0xaa7b,
	0xaaa4, 0xaacf, 0xaafa, 0xab24, 0xab4d, 0xab79, 0xaba5, 0xabd3,
	0xac01, 0xac2e, 0xac5b, 0xac8a, 0xacb8, 0xace6, 0xad12, 0xad42,
	// Entry 2E80 - 2EBF
	0xad72, 0xada4, 0xadd5, 0xaddf, 0xade8, 0xadf1, 0xadfb, 0xae04,
	0xae0d, 0xae16, 0xae27, 0xae36, 0xae3f, 0xae55, 0xae6b, 0xae82,
	0xae97, 0xaea9, 0xaeb7, 0xaec0, 0xaecb, 0xaed4, 0xaedd, 0xaee6,
	0xaeef, 0xaef8, 0xaf02, 0xaf0d, 0xaf16, 0xaf1f, 0xaf2a, 0xaf35,
	0xaf3e, 0xaf47, 0xaf50, 0xaf5a, 0xaf64, 0xaf6e, 0xaf78, 0xaf83,
	0xaf8c, 0xaf95, 0xaf9e, 0xafa7, 0xafb0, 0xafbb, 0xafc4, 0xafcd,
	0xafd6, 0xafe7, 0xaff8, 0xb008, 0xb019, 0xb028, 0xb037, 0xb045,
	0xb054, 0xb063, 0xb07a, 0xb083, 0xb08d, 0xb097, 0xb0a1, 0xb0ab,
	// Entry 2EC0 - 2EFF
	0xb0bc, 0xb0d5, 0xb0de, 0xb0e7, 0xb0f2, 0xb0fb, 0xb104, 0xb10d,
	0xb118, 0xb121, 0xb12a, 0xb138, 0xb141, 0xb14a, 0xb155, 0xb15e,
	0xb167, 0xb175, 0xb181, 0xb18d, 0xb196, 0xb19f, 0xb1a8, 0xb1b1,
	0xb1c1, 0xb1ca, 0xb1d3, 0xb1dc, 0xb1e5, 0xb1ee, 0xb1f7, 0xb200,
	0xb211, 0xb21a, 0xb223, 0xb22c, 0xb236, 0xb23f, 0xb24e, 0xb258,
	0xb262, 0xb26b, 0xb274, 0xb27e, 0xb287, 0xb290, 0xb299, 0xb2a2,
	0xb2b1, 0xb2c0, 0xb2e8, 0xb310, 0xb33a, 0xb363, 0xb38c, 0xb3b4,
	0xb3de, 0xb408, 0xb431, 0xb459, 0xb484, 0xb4af, 0xb4dc, 0xb509,
	// Entry 2F00 - 2F3F
	0xb535, 0xb561, 0xb58f, 0xb5bc, 0xb5e9, 0xb614, 0xb643, 0xb672,
	0xb6a3, 0xb6d3, 0xb703, 0xb732, 0xb763, 0xb794, 0xb7c4, 0xb7ef,
	0xb81e, 0xb828, 0xb848, 0xb868, 0xb890, 0xb8ab, 0xb8bf, 0xb8d4,
	0xb8e9, 0xb906, 0xb91f, 0xb934, 0xb946, 0xb95d, 0xb974, 0xb991,
	0xb9a5, 0xb9bc, 0xb9d2, 0xb9f2, 0xba07, 0xba21, 0xba3c, 0xba4e,
	0xba6a, 0xba7d, 0xba93, 0xbaac, 0xbac6, 0xbae6, 0xbb04, 0xbb22,
	0xbb38, 0xbb4d, 0xbb61, 0xbb79, 0xbb8e, 0xbbb1, 0xbbc8, 0xbbdf,
	0xbbf7, 0xbc0f, 0xbc24, 0xbc39, 0xbc52, 0xbc6d, 0xbc8c, 0xbca7,
	// Entry 2F40 - 2F7F
	0xbcbe, 0xbcd3, 0xbcea, 0xbd03, 0xbd24, 0xbd4b, 0xbd63, 0xbd83,
	0xbd99, 0xbdb2, 0xbdce, 0xbdea, 0xbe01, 0xbe18, 0xbe30, 0xbe50,
	0xbe6d, 0xbe8b, 0xbe99, 0xbea7, 0xbeb4, 0xbec2, 0xbed1, 0xbee0,
	0xbeee, 0xbefd, 0xbf0b, 0xbf19, 0xbf26, 0xbf34, 0xbf43, 0xbf51,
	0xbf60, 0xbf6e, 0xbf7c, 0xbf89, 0xbf97, 0xbfa5, 0xbfb2, 0xbfc0,
	0xbfcf, 0xbfde, 0xbfec, 0xbffb, 0xc00b, 0xc01b, 0xc02a, 0xc03a,
	0xc049, 0xc058, 0xc066, 0xc075, 0xc085, 0xc094, 0xc0a4, 0xc0b3,
	0xc0c2, 0xc0d0, 0xc0df, 0xc0ee, 0xc0fc, 0xc10b, 0xc11a, 0xc129,
	// Entry 2F80 - 2FBF
	0xc137, 0xc146, 0xc156, 0xc165, 0xc174, 0xc183, 0xc191, 0xc1a0,
	0xc1b0, 0xc1bf, 0xc1ce, 0xc1dd, 0xc1eb, 0xc1fa, 0xc20a, 0xc219,
	0xc229, 0xc238, 0xc247, 0xc255, 0xc264, 0xc274, 0xc283, 0xc293,
	0xc2a2, 0xc2b1, 0xc2bf, 0xc2ce, 0xc2dd, 0xc2ec, 0xc2fa, 0xc309,
	0xc319, 0xc328, 0xc337, 0xc346, 0xc354, 0xc363, 0xc373, 0xc382,
	0xc392, 0xc3a2, 0xc3b1, 0xc3c1, 0xc3d2, 0xc3e3, 0xc3f3, 0xc404,
	0xc414, 0xc424, 0xc433, 0xc443, 0xc454, 0xc464, 0xc475, 0xc485,
	0xc495, 0xc4a4, 0xc4b4, 0xc4c4, 0xc4d3, 0xc4e3, 0xc4f3, 0xc503,
	// Entry 2FC0 - 2FFF
	0xc512, 0xc522, 0xc533, 0xc543, 0xc553, 0xc563, 0xc572, 0xc582,
	0xc592, 0xc5a2, 0xc5b1, 0xc5c1, 0xc5d2, 0xc5e2, 0xc5f3, 0xc603,
	0xc613, 0xc622, 0xc632, 0xc642, 0xc652, 0xc661, 0xc671, 0xc681,
	0xc691, 0xc6a0, 0xc6b0, 0xc6c1, 0xc6d1, 0xc6e1, 0xc6f1, 0xc700,
	0xc710, 0xc721, 0xc731, 0xc741, 0xc751, 0xc760, 0xc770, 0xc781,
	0xc791, 0xc7a2, 0xc7b2, 0xc7c2, 0xc7d1, 0xc7e1, 0xc7f2, 0xc802,
	0xc813, 0xc823, 0xc833, 0xc842, 0xc852, 0xc862, 0xc872, 0xc881,
	0xc891, 0xc8a2, 0xc8b2, 0xc8c2, 0xc8d1, 0xc8e1, 0xc8f2, 0xc902,
	// Entry 3000 - 303F
	0xc911, 0xc920, 0xc92e, 0xc93d, 0xc94d, 0xc95c, 0xc96c, 0xc97b,
	0xc98a, 0xc998, 0xc9a7, 0xc9b7, 0xc9c7, 0xc9d6, 0xc9e6, 0xc9f5,
	0xca04, 0xca12, 0xca21, 0xca30, 0xca3e, 0xca4d, 0xca5c, 0xca6a,
	0xca79, 0xca89, 0xca98, 0xcaa7, 0xcab6, 0xcac4, 0xcad3, 0xcae2,
	0xcaf1, 0xcaff, 0xcb0e, 0xcb1d, 0xcb2c, 0xcb3a, 0xcb49, 0xcb58,
	0xcb66, 0xcb75, 0xcb84, 0xcb93, 0xcba1, 0xcbb0, 0xcbc0, 0xcbcf,
	0xcbde, 0xcbed, 0xcbfb, 0xcc0a, 0xcc19, 0xcc28, 0xcc36, 0xcc45,
	0xcc55, 0xcc65, 0xcc74, 0xcc84, 0xcc93, 0xcca2, 0xccb0, 0xccbf,
	// Entry 3040 - 307F
	0xccce, 0xccdd, 0xcceb, 0xccfa, 0xcd09, 0xcd18, 0xcd27, 0xcd36,
	0xcd44, 0xcd53, 0xcd63, 0xcd72, 0xcd81, 0xcd90, 0xcd9e, 0xcdad,
	0xcdbd, 0xcdcc, 0xcddb, 0xcdea, 0xcdf8, 0xce07, 0xce17, 0xce26,
	0xce36, 0xce45, 0xce54, 0xce62, 0xce71, 0xce81, 0xce90, 0xce9f,
	0xceae, 0xcebc, 0xcecb, 0xceda, 0xcee8, 0xcef7, 0xcf06, 0xcf15,
	0xcf23, 0xcf32, 0xcf42, 0xcf51, 0xcf60, 0xcf6f, 0xcf7d, 0xcf8c,
	0xcf9c, 0xcfab, 0xcfbb, 0xcfca, 0xcfd9, 0xcfe7, 0xcff6, 0xd006,
	0xd016, 0xd025, 0xd035, 0xd044, 0xd053, 0xd061, 0xd070, 0xd07f,
	// Entry 3080 - 30BF
	0xd08d, 0xd09c, 0xd0ab, 0xd0ba, 0xd0c8, 0xd0d7, 0xd0e7, 0xd0f6,
	0xd106, 0xd116, 0xd125, 0xd135, 0xd146, 0xd156, 0xd167, 0xd177,
	0xd187, 0xd196, 0xd1a6, 0xd1b7, 0xd1c7, 0xd1d8, 0xd1e8, 0xd1f8,
	0xd207, 0xd217, 0xd227, 0xd236, 0xd246, 0xd256, 0xd266, 0xd275,
	0xd285, 0xd296, 0xd2a6, 0xd2b6, 0xd2c6, 0xd2d5, 0xd2e5, 0xd2f6,
	0xd306, 0xd316, 0xd326, 0xd335, 0xd345, 0xd355, 0xd365, 0xd374,
	0xd384, 0xd394, 0xd3a3, 0xd3b3, 0xd3c3, 0xd3d3, 0xd3e2, 0xd3f2,
	0xd403, 0xd413, 0xd423, 0xd433, 0xd442, 0xd452, 0xd463, 0xd474,
	// Entry 30C0 - 30FF
	0xd484, 0xd495, 0xd4a5, 0xd4b5, 0xd4c4, 0xd4d4, 0xd4e5, 0xd4f5,
	0xd505, 0xd515, 0xd525, 0xd535, 0xd544, 0xd554, 0xd564, 0xd573,
	0xd582, 0xd590, 0xd59f, 0xd5af, 0xd5be, 0xd5ce, 0xd5dd, 0xd5eb,
	0xd5fa, 0xd60a, 0xd619, 0xd629, 0xd638, 0xd647, 0xd655, 0xd664,
	0xd673, 0xd681, 0xd690, 0xd69f, 0xd6ae, 0xd6bc, 0xd6cb, 0xd6db,
	0xd6ea, 0xd6fa, 0xd70a, 0xd719, 0xd729, 0xd73a, 0xd74a, 0xd75b,
	0xd76b, 0xd77b, 0xd78a, 0xd79a, 0xd7ab, 0xd7bb, 0xd7cc, 0xd7dc,
	0xd7eb, 0xd7fb, 0xd80b, 0xd81a, 0xd82a, 0xd83a, 0xd84a, 0xd859,
	// Entry 3100 - 313F
	0xd869, 0xd87a, 0xd88a, 0xd89a, 0xd8aa, 0xd8b9, 0xd8c9, 0xd8da,
	0xd8ea, 0xd8f9, 0xd908, 0xd916, 0xd925, 0xd935, 0xd945, 0xd954,
	0xd964, 0xd973, 0xd982, 0xd990, 0xd99f, 0xd9af, 0xd9bf, 0xd9ce,
	0xd9de, 0xd9ed, 0xd9fc, 0xda0a, 0xda19, 0xda28, 0xda36, 0xda45,
	0xda54, 0xda63, 0xda71, 0xda80, 0xda90, 0xda9f, 0xdaae, 0xdabd,
	0xdacb, 0xdada, 0xdaea, 0xdaf9, 0xdb08, 0xdb17, 0xdb25, 0xdb34,
	0xdb44, 0xdb54, 0xdb63, 0xdb73, 0xdb82, 0xdb91, 0xdb9f, 0xdbae,
	0xdbbe, 0xdbce, 0xdbdd, 0xdbed, 0xdbfc, 0xdc0b, 0xdc19, 0xdc28,
	// Entry 3140 - 317F
	0xdc37, 0xdc46, 0xdc54, 0xdc63, 0xdc72, 0xdc81, 0xdc8f, 0xdc9e,
	0xdcae, 0xdcbd, 0xdccc, 0xdcdb, 0xdce9, 0xdcf8, 0xdd08, 0xdd17,
	0xdd27, 0xdd36, 0xdd45, 0xdd53, 0xdd62, 0xdd72, 0xdd81, 0xdd91,
	0xdda0, 0xddaf, 0xddbd, 0xddcc, 0xdddb, 0xddea, 0xddf8, 0xde07,
	0xde16, 0xde25, 0xde33, 0xde42, 0xde52, 0xde61, 0xde71, 0xde81,
	0xde90, 0xdea1, 0xdeb1, 0xdec2, 0xded2, 0xdee2, 0xdef1, 0xdf01,
	0xdf12, 0xdf23, 0xdf33, 0xdf44, 0xdf54, 0xdf64, 0xdf73, 0xdf83,
	0xdf93, 0xdfa3, 0xdfb2, 0xdfc2, 0xdfd2, 0xdfe2, 0xdff1, 0xe001,
	// Entry 3180 - 31BF
	0xe012, 0xe022, 0xe033, 0xe043, 0xe053, 0xe063, 0xe072, 0xe082,
	0xe093, 0xe0a3, 0xe0b4, 0xe0c4, 0xe0d4, 0xe0e3, 0xe0f3, 0xe103,
	0xe112, 0xe122, 0xe132, 0xe142, 0xe151, 0xe161, 0xe172, 0xe182,
	0xe192, 0xe1a2, 0xe1b1, 0xe1c1, 0xe1d2, 0xe1e3, 0xe1f3, 0xe204,
	0xe214, 0xe224, 0xe233, 0xe243, 0xe254, 0xe265, 0xe275, 0xe286,
	0xe296, 0xe2a6, 0xe2b5, 0xe2c5, 0xe2d5, 0xe2e4, 0xe2f4, 0xe305,
	0xe315, 0xe326, 0xe336, 0xe346, 0xe355, 0xe365, 0xe376, 0xe387,
	0xe397, 0xe3a7, 0xe3b7, 0xe3c6, 0xe3d6, 0xe3e6, 0xe3f5, 0xe405,
	// Entry 31C0 - 31FF
	0xe414, 0xe424, 0xe433, 0xe442, 0xe451, 0xe45f, 0xe46e, 0xe47e,
	0xe48e, 0xe49d, 0xe4ad, 0xe4bc, 0xe4cb, 0xe4d9, 0xe4e8, 0xe4f7,
	0xe505, 0xe514, 0xe523, 0xe532, 0xe540, 0xe54f, 0xe55f, 0xe56e,
	0xe57e, 0xe58d, 0xe59b, 0xe5aa, 0xe5b9, 0xe5c7, 0xe5d6, 0xe5e5,
	0xe5f4, 0xe602, 0xe611, 0xe621, 0xe630, 0xe640, 0xe64f, 0xe65e,
	0xe66c, 0xe67b, 0xe68b, 0xe69a, 0xe6aa, 0xe6b9, 0xe6c8, 0xe6d6,
	0xe6e5, 0xe6f4, 0xe702, 0xe711, 0xe720, 0xe72f, 0xe73d, 0xe74c,
	0xe75c, 0xe76b, 0xe77a, 0xe789, 0xe797, 0xe7a6, 0xe7b6, 0xe7c5,
	// Entry 3200 - 323F
	0xe7d4, 0xe7e3, 0xe7f1, 0xe800, 0xe810, 0xe820, 0xe82f, 0xe83f,
	0xe84e, 0xe85d, 0xe86b, 0xe87a, 0xe88a, 0xe899, 0xe8a9, 0xe8b8,
	0xe8c7, 0xe8d5, 0xe8e4, 0xe8f3, 0xe901, 0xe910, 0xe91f, 0xe92e,
	0xe93c, 0xe94b, 0xe95b, 0xe96a, 0xe979, 0xe988, 0xe996, 0xe9a5,
	0xe9b5, 0xe9c4, 0xe9d4, 0xe9e4, 0xe9f3, 0xea03, 0xea14, 0xea25,
	0xea35, 0xea46, 0xea56, 0xea66, 0xea75, 0xea85, 0xea95, 0xeaa4,
	0xeab4, 0xeac4, 0xead3, 0xeae3, 0xeaf3, 0xeb02, 0xeb12, 0xeb23,
	0xeb33, 0xeb43, 0xeb53, 0xeb62, 0xeb72, 0xeb83, 0xeb93, 0xeba3,
	// Entry 3240 - 327F
	0xebb3, 0xebc2, 0xebd2, 0xebe3, 0xebf3, 0xec04, 0xec14, 0xec24,
	0xec33, 0xec43, 0xec54, 0xec64, 0xec74, 0xec84, 0xec94, 0xeca3,
	0xecb3, 0xecc2, 0xecd2, 0xece3, 0xecf3, 0xed03, 0xed13, 0xed22,
	0xed32, 0xed43, 0xed53, 0xed62, 0xed71, 0xed7f, 0xed8e, 0xed9e,
	0xedad, 0xedbd, 0xedcc, 0xeddb, 0xede9, 0xedf8, 0xee08, 0xee17,
	0xee27, 0xee36, 0xee45, 0xee53, 0xee62, 0xee71, 0xee7f, 0xee8e,
	0xee9d, 0xeeac, 0xeeba, 0xeec9, 0xeed9, 0xeee8, 0xeef7, 0xef06,
	0xef14, 0xef23, 0xef33, 0xef42, 0xef52, 0xef62, 0xef71, 0xef81,
	// Entry 3280 - 32BF
	0xef92, 0xefa2, 0xefb3, 0xefc3, 0xefd3, 0xefe2, 0xeff2, 0xf002,
	0xf012, 0xf021, 0xf031, 0xf041, 0xf050, 0xf060, 0xf070, 0xf080,
	0xf08f, 0xf09f, 0xf0af, 0xf0bf, 0xf0ce, 0xf0de, 0xf0ef, 0xf0ff,
	0xf10f, 0xf11f, 0xf12e, 0xf13e, 0xf14f, 0xf15f, 0xf170, 0xf180,
	0xf190, 0xf19f, 0xf1af, 0xf1bf, 0xf1cf, 0xf1de, 0xf1ee, 0xf1fe,
	0xf20e, 0xf21d, 0xf22d, 0xf23e, 0xf24e, 0xf25e, 0xf26e, 0xf27d,
	0xf28d, 0xf29e, 0xf2ae, 0xf2be, 0xf2ce, 0xf2dd, 0xf2ed, 0xf2fe,
	0xf30f, 0xf31f, 0xf330, 0xf340, 0xf350, 0xf35f, 0xf36f, 0xf37f,
	// Entry 32C0 - 32FF
	0xf38f, 0xf39e, 0xf3ae, 0xf3be, 0xf3cd, 0xf3dd, 0xf3ee, 0xf3fe,
	0xf40e, 0xf41e, 0xf42d, 0xf43d, 0xf44e, 0xf45e, 0xf46e, 0xf47d,
	0xf48e, 0xf49e, 0xf4ae, 0xf4be, 0xf4cd, 0xf4dd, 0xf4ed, 0xf4fd,
	0xf50c, 0xf51c, 0xf52c, 0xf53c, 0xf54b, 0xf55b, 0xf56c, 0xf57c,
	0xf58c, 0xf59c, 0xf5ab, 0xf5bb, 0xf5cc, 0xf5dc, 0xf5ec, 0xf5fc,
	0xf60b, 0xf61b, 0xf62b, 0xf63a, 0xf64a, 0xf65a, 0xf66a, 0xf679,
	0xf689, 0xf699, 0xf6a9, 0xf6b8, 0xf6c8, 0xf6d9, 0xf6e9, 0xf6f9,
	0xf709, 0xf718, 0xf728, 0xf739, 0xf749, 0xf759, 0xf769, 0xf778,
	// Entry 3300 - 333F
	0xf788, 0xf799, 0xf7a9, 0xf7ba, 0xf7ca, 0xf7da, 0xf7e9, 0xf7f9,
	0xf809, 0xf819, 0xf828, 0xf838, 0xf848, 0xf858, 0xf867, 0xf877,
	0xf888, 0xf898, 0xf8a8, 0xf8b8, 0xf8c7, 0xf8d7, 0xf8e8, 0xf8f8,
	0xf907, 0xf916, 0xf924, 0xf933, 0xf943, 0xf952, 0xf962, 0xf971,
	0xf980, 0xf98e, 0xf99d, 0xf9ac, 0xf9ba, 0xf9c9, 0xf9d8, 0xf9e7,
	0xf9f5, 0xfa04, 0xfa14, 0xfa23, 0xfa32, 0xfa41, 0xfa4f, 0xfa5e,
	0xfa6e, 0xfa7d, 0xfa8c, 0xfa9b, 0xfaa9, 0xfab8, 0xfac8, 0xfad8,
	0xfae7, 0xfaf7, 0xfb07, 0xfb17, 0xfb26, 0xfb36, 0xfb45, 0xfb54,
	// Entry 3340 - 337F
	0xfb62, 0xfb71, 0xfb80, 0xfb8f, 0xfb9d, 0xfbac, 0xfbbc, 0xfbcb,
	0xfbda, 0xfbe9, 0xfbf7, 0xfc06, 0xfc16, 0xfc25, 0xfc34, 0xfc43,
	0xfc51, 0xfc60, 0xfc70, 0xfc80, 0xfc8f, 0xfc9f, 0xfcaf, 0xfcbf,
	0xfcce, 0xfcde, 0xfced, 0xfcfc, 0xfd0a, 0xfd19, 0xfd28, 0xfd37,
	0xfd45, 0xfd54, 0xfd64, 0xfd73, 0xfd82, 0xfd91, 0xfd9f, 0xfdae,
	0xfdbe, 0xfdcd, 0xfddd, 0xfded, 0xfdfc, 0xfe0c, 0xfe1d, 0xfe2e,
	0xfe3e, 0xfe4f, 0xfe60, 0xfe70, 0xfe81, 0xfe91, 0xfea1, 0xfeb0,
	0xfec0, 0xfed0, 0xfee0, 0xfeef, 0xfeff, 0xff10, 0xff20, 0xff30,
	// Entry 3380 - 33BF
	0xff40, 0xff4f, 0xff5f, 0xff6f, 0xff7f, 0xff8e, 0xff9e, 0xffaf,
	0xffc0, 0xffd0, 0xffe1, 0xfff2, 0x0002, 0x0012, 0x0022, 0x0031,
	0x0041, 0x0051, 0x0060, 0x0070, 0x0081, 0x0091, 0x00a1, 0x00b1,
	0x00c0, 0x00d0, 0x00e1, 0x00f1, 0x0101, 0x0111, 0x0120, 0x0130,
	0x0141, 0x0152, 0x0162, 0x0173, 0x0184, 0x0194, 0x01a5, 0x01b5,
	0x01c5, 0x01d4, 0x01e4, 0x01f4, 0x0204, 0x0213, 0x0223, 0x0232,
	0x0241, 0x024f, 0x025e, 0x026e, 0x027e, 0x028d, 0x029d, 0x02ad,
	0x02bc, 0x02cb, 0x02da, 0x02e8, 0x02f7, 0x0306, 0x0315, 0x0323,
	// Entry 33C0 - 33FF
	0x0332, 0x0342, 0x0351, 0x0360, 0x036f, 0x037d, 0x038c, 0x039c,
	0x03ac, 0x03bb, 0x03cb, 0x03db, 0x03eb, 0x03fa, 0x040a, 0x0419,
	0x0428, 0x0436, 0x0445, 0x0454, 0x0463, 0x0471, 0x0480, 0x0490,
	0x049f, 0x04ae, 0x04bd, 0x04cb, 0x04da, 0x04ea, 0x04f9, 0x0507,
	0x0514, 0x0522, 0x0531, 0x053f, 0x054d, 0x055c, 0x056a, 0x0577,
	0x0586, 0x0594, 0x05a3, 0x05b1, 0x05be, 0x05cc, 0x05db, 0x05e9,
	0x05f6, 0x0604, 0x0612, 0x0621, 0x062f, 0x063e, 0x064d, 0x065a,
	0x0667, 0x0676, 0x0684, 0x0692, 0x06a0, 0x06ae, 0x06bc, 0x06ca,
	// Entry 3400 - 343F
	0x06d8, 0x06e5, 0x06f2, 0x0701, 0x070f, 0x071d, 0x072c, 0x0739,
	0x0746, 0x0755, 0x0763, 0x0770, 0x077f, 0x078d, 0x079c, 0x07ab,
	0x07b9, 0x07c8, 0x07d6, 0x07e6, 0x07f5, 0x0802, 0x0810, 0x081e,
	0x082d, 0x083b, 0x0849, 0x0858, 0x0866, 0x0874, 0x0883, 0x0891,
	0x089f, 0x08ae, 0x08bd, 0x08cc, 0x08dc, 0x08ea, 0x08f8, 0x0906,
	0x0914, 0x0923, 0x0931, 0x0940, 0x094e, 0x095c, 0x096b, 0x0979,
	0x0987, 0x0996, 0x09a4, 0x09b3, 0x09c0, 0x09ce, 0x09db, 0x09e9,
	0x09f6, 0x0a03, 0x0a10, 0x0a1e, 0x0a2c, 0x0a3a, 0x0a51, 0x0a67,
	// Entry 3440 - 347F
	0x0a7f, 0x0a96, 0x0aad, 0x0ac5, 0x0adb, 0x0af5, 0x0b04, 0x0b14,
	0x0b24, 0x0b34, 0x0b45, 0x0b55, 0x0b66, 0x0b76, 0x0b87, 0x0b98,
	0x0baa, 0x0bbb, 0x0bcb, 0x0bdb, 0x0beb, 0x0bfc, 0x0c0d, 0x0c1f,
	0x0c2f, 0x0c3f, 0x0c4f, 0x0c60, 0x0c70, 0x0c81, 0x0c91, 0x0ca2,
	0x0cb2, 0x0cc2, 0x0cd3, 0x0ce3, 0x0cf3, 0x0d05, 0x0d15, 0x0d25,
	0x0d35, 0x0d46, 0x0d54, 0x0d63, 0x0d72, 0x0d82, 0x0d91, 0x0da1,
	0x0db0, 0x0dc0, 0x0dcf, 0x0ddf, 0x0def, 0x0e00, 0x0e10, 0x0e1f,
	0x0e2e, 0x0e3d, 0x0e4d, 0x0e5d, 0x0e6e, 0x0e7d, 0x0e8c, 0x0e9b,
	// Entry 3480 - 34BF
	0x0eab, 0x0eba, 0x0eca, 0x0ed9, 0x0ee9, 0x0ef8, 0x0f07, 0x0f17,
	0x0f26, 0x0f35, 0x0f46, 0x0f55, 0x0f64, 0x0f73, 0x0f83, 0x0f91,
	0x0fa0, 0x0fb1, 0x0fc0, 0x0fd0, 0x0fdf, 0x0fef, 0x0ffe, 0x100e,
	0x101d, 0x102d, 0x103d, 0x104e, 0x105f, 0x106f, 0x107e, 0x108d,
	0x109c, 0x10ac, 0x10bc, 0x10cd, 0x10dc, 0x10eb, 0x10fa, 0x110a,
	0x1119, 0x1129, 0x1138, 0x1148, 0x1157, 0x1166, 0x1176, 0x1185,
	0x1194, 0x11a4, 0x11b5, 0x11c4, 0x11d3, 0x11e2, 0x11f2, 0x1201,
	0x1211, 0x1221, 0x1231, 0x1242, 0x1252, 0x1263, 0x1273, 0x1284,
	// Entry 34C0 - 34FF
	0x1295, 0x12a7, 0x12b8, 0x12c8, 0x12d8, 0x12e8, 0x12f9, 0x130a,
	0x131c, 0x132c, 0x133c, 0x134c, 0x135d, 0x136d, 0x137e, 0x138e,
	0x139f, 0x13af, 0x13bf, 0x13d0, 0x13e0, 0x13f0, 0x1402, 0x1412,
	0x1422, 0x1432, 0x1443, 0x1451, 0x1460, 0x146f, 0x147f, 0x148e,
	0x149e, 0x14ad, 0x14bd, 0x14cc, 0x14dc, 0x14ec, 0x14fd, 0x150d,
	0x151c, 0x152b, 0x153a, 0x154a, 0x155a, 0x156b, 0x157a, 0x1589,
	0x1598, 0x15a8, 0x15b7, 0x15c7, 0x15d6, 0x15e6, 0x15f5, 0x1604,
	0x1614, 0x1623, 0x1632, 0x1643, 0x1652, 0x1661, 0x1670, 0x1680,
	// Entry 3500 - 353F
	0x168e, 0x169d, 0x16ae, 0x16bd, 0x16cd, 0x16dc, 0x16ec, 0x16fb,
	0x170b, 0x171a, 0x172a, 0x173a, 0x174b, 0x175b, 0x176c, 0x177b,
	0x178a, 0x1799, 0x17a9, 0x17b9, 0x17ca, 0x17d9, 0x17e8, 0x17f7,
	0x1807, 0x1816, 0x1826, 0x1835, 0x1845, 0x1854, 0x1863, 0x1873,
	0x1882, 0x1891, 0x18a2, 0x18b1, 0x18c0, 0x18cf, 0x18df, 0x18ed,
	0x18fc, 0x190d, 0x191c, 0x192c, 0x193b, 0x194b, 0x195a, 0x196a,
	0x1979, 0x1989, 0x1999, 0x19aa, 0x19bb, 0x19cb, 0x19dc, 0x19eb,
	0x19fa, 0x1a09, 0x1a19, 0x1a29, 0x1a3a, 0x1a49, 0x1a58, 0x1a67,
	// Entry 3540 - 357F
	0x1a77, 0x1a86, 0x1a96, 0x1aa5, 0x1ab5, 0x1ac4, 0x1ad3, 0x1ae3,
	0x1af2, 0x1b01, 0x1b12, 0x1b24, 0x1b33, 0x1b43, 0x1b52, 0x1b61,
	0x1b71, 0x1b80, 0x1b97, 0x1ba0, 0x1bad, 0x1bbe, 0x1bd3, 0x1be8,
	0x1bfe, 0x1c0e, 0x1c1e, 0x1c2d, 0x1c3b, 0x1c4a, 0x1c58, 0x1c66,
	0x1c75, 0x1c85, 0x1c94, 0x1ca3, 0x1cb2, 0x1cc1, 0x1ccf, 0x1cdc,
	0x1ce9, 0x1cf8, 0x1d06, 0x1d14, 0x1d21, 0x1d30, 0x1d3f, 0x1d4d,
	0x1d62, 0x1d77, 0x1d95, 0x1db1, 0x1dce, 0x1de9, 0x1e0d, 0x1e2f,
	0x1e4b, 0x1e65, 0x1e82, 0x1e9d, 0x1ec1, 0x1ee3, 0x1f06, 0x1f27,
	// Entry 3580 - 35BF
	0x1f4a, 0x1f6b, 0x1f95, 0x1fbd, 0x1fe1, 0x2003, 0x2026, 0x2047,
	0x2069, 0x2089, 0x20b2, 0x20d9, 0x20fc, 0x211d, 0x214f, 0x217f,
	0x2199, 0x21b1, 0x21d5, 0x21f7, 0x2216, 0x2233, 0x2252, 0x226f,
	0x228e, 0x22ab, 0x22ce, 0x22ef, 0x2312, 0x2333, 0x235d, 0x2385,
	0x23a2, 0x23ba, 0x23de, 0x2406, 0x242f, 0x2440, 0x2466, 0x2481,
	0x249d, 0x24b8, 0x24db, 0x24f9, 0x251c, 0x253b, 0x2554, 0x256e,
	0x257d, 0x258d, 0x25a8, 0x25c1, 0x25dd, 0x25f7, 0x2613, 0x262d,
	0x2649, 0x2663, 0x267f, 0x2699, 0x26c4, 0x26ed, 0x2708, 0x2721,
	// Entry 35C0 - 35FF
	0x273d, 0x2757, 0x2773, 0x278d, 0x27a9, 0x27c3, 0x27de, 0x27f7,
	0x2813, 0x282d, 0x284d, 0x286b, 0x288c, 0x28ab, 0x28cd, 0x28ef,
	0x290b, 0x292f, 0x293d, 0x294c, 0x295a, 0x2969, 0x2978, 0x2988,
	0x2998, 0x29a6, 0x29b6, 0x29c4, 0x29d3, 0x29e2, 0x29f2, 0x2a03,
	0x2a15, 0x2a27, 0x2a37, 0x2a48, 0x2a5a, 0x2a68, 0x2a78, 0x2a87,
	0x2a98, 0x2aa7, 0x2ab9, 0x2aca, 0x2adb, 0x2aeb, 0x2afc, 0x2b0b,
	0x2b1d, 0x2b2d, 0x2b3d, 0x2b4d, 0x2b5c, 0x2b6d, 0x2b7e, 0x2b8f,
	0x2ba0, 0x2bb1, 0x2bc1, 0x2bd1, 0x2be1, 0x2bf1, 0x2c00, 0x2c0f,
	// Entry 3600 - 363F
	0x2c1e, 0x2c2d, 0x2c3e, 0x2c4e, 0x2c5e, 0x2c72, 0x2c83, 0x2c93,
	0x2ca3, 0x2cb4, 0x2cc3, 0x2cd3, 0x2ce2, 0x2cf1, 0x2d00, 0x2d0f,
	0x2d1f, 0x2d2e, 0x2d3f, 0x2d4f, 0x2d5f, 0x2d6e, 0x2d7d, 0x2d8c,
	0x2d9b, 0x2dac, 0x2dbc, 0x2dcc, 0x2ddc, 0x2ded, 0x2dff, 0x2e12,
	0x2e24, 0x2e37, 0x2e53, 0x2e71, 0x2e7e, 0x2e8d, 0x2e98, 0x2ea3,
	0x2eb2, 0x2ec5, 0x2eea, 0x2f10, 0x2f36, 0x2f5d, 0x2f80, 0x2fa4,
	0x2fc7, 0x2feb, 0x3015, 0x3039, 0x305c, 0x307f, 0x30a8, 0x30dc,
	0x310a, 0x3137, 0x3164, 0x3197, 0x31c4, 0x31eb, 0x3211, 0x3237,
	// Entry 3640 - 367F
	0x3263, 0x3283, 0x329c, 0x32be, 0x32e6, 0x3305, 0x3326, 0x334d,
	0x337d, 0x33aa, 0x33ce, 0x33f1, 0x3418, 0x343d, 0x3463, 0x3487,
	0x34a0, 0x34b7, 0x34ce, 0x34e3, 0x3500, 0x351b, 0x3539, 0x3555,
	0x357e, 0x35a5, 0x35c1, 0x35dd, 0x35f4, 0x3609, 0x3620, 0x3635,
	0x364c, 0x3661, 0x3678, 0x368d, 0x36b8, 0x36e1, 0x36f8, 0x370d,
	0x3735, 0x375b, 0x377d, 0x379d, 0x37c8, 0x37f1, 0x3827, 0x385b,
	0x3878, 0x3893, 0x38ba, 0x38df, 0x390e, 0x393b, 0x395b, 0x3979,
	0x3990, 0x39a5, 0x39d9, 0x3a0b, 0x3a2f, 0x3a51, 0x3a7a, 0x3aa1,
	// Entry 3680 - 36BF
	0x3ad5, 0x3b07, 0x3b32, 0x3b5b, 0x3b79, 0x3b95, 0x3bb5, 0x3bd3,
	0x3bfe, 0x3c27, 0x3c3e, 0x3c53, 0x3c74, 0x3c93, 0x3cb9, 0x3cdd,
	0x3d15, 0x3d4b, 0x3d64, 0x3d7b, 0x3d92, 0x3da7, 0x3dbe, 0x3dd3,
	0x3deb, 0x3e01, 0x3e13, 0x3e29, 0x3e3f, 0x3e55, 0x3e6b, 0x3e81,
	0x3e9f, 0x3eb5, 0x3eca, 0x3ee8, 0x3f04, 0x3f22, 0x3f3e, 0x3f5c,
	0x3f81, 0x3fa4, 0x3fc1, 0x3fdc, 0x3ffa, 0x4016, 0x4034, 0x4050,
	0x406e, 0x408a, 0x40af, 0x40c4, 0x40e5, 0x4102, 0x411d, 0x413a,
	0x416b, 0x4187, 0x41ac, 0x41cf, 0x41ee, 0x420b, 0x4231, 0x4257,
	// Entry 36C0 - 36FF
	0x427b, 0x429d, 0x42bf, 0x42df, 0x42fe, 0x431b, 0x433a, 0x4357,
	0x4376, 0x4393, 0x43bd, 0x43e5, 0x440f, 0x4437, 0x4461, 0x4489,
	0x44b3, 0x44db, 0x4505, 0x452d, 0x454d, 0x4571, 0x458e, 0x45ae,
	0x45d2, 0x45ee, 0x460b, 0x4628, 0x4650, 0x4668, 0x4681, 0x4698,
	0x46b2, 0x46ca, 0x46ec, 0x470c, 0x472a, 0x4746, 0x4764, 0x4780,
	0x479e, 0x47ba, 0x47da, 0x47f8, 0x4820, 0x4840, 0x4868, 0x488a,
	0x48af, 0x48d0, 0x48f3, 0x4915, 0x4937, 0x4959, 0x4978, 0x4999,
	0x49ae, 0x49c3, 0x49dd, 0x49f2, 0x4a07, 0x4a1c, 0x4a35, 0x4a4b,
	// Entry 3700 - 373F
	0x4a62, 0x4a78, 0x4a8f, 0x4aa9, 0x4abf, 0x4ad6, 0x4aec, 0x4b03,
	0x4b1a, 0x4b32, 0x4b49, 0x4b61, 0x4b77, 0x4b8e, 0x4ba4, 0x4bbb,
	0x4bd1, 0x4be7, 0x4bfe, 0x4c14, 0x4c2b, 0x4c41, 0x4c57, 0x4c6d,
	0x4c84, 0x4c9a, 0x4cb0, 0x4cc9, 0x4ce2, 0x4cfb, 0x4d14, 0x4d2e,
	0x4d48, 0x4d62, 0x4d7c, 0x4d96, 0x4db6, 0x4dd3, 0x4df6, 0x4e18,
	0x4e37, 0x4e5c, 0x4e74, 0x4e90, 0x4ea6, 0x4ebf, 0x4ed1, 0x4ee4,
	0x4ef6, 0x4f09, 0x4f1b, 0x4f2e, 0x4f40, 0x4f53, 0x4f65, 0x4f78,
	0x4f8a, 0x4f9c, 0x4fae, 0x4fc1, 0x4fd3, 0x4fe5, 0x4ff8, 0x500c,
	// Entry 3740 - 377F
	0x501f, 0x5031, 0x5044, 0x5056, 0x506d, 0x507f, 0x5091, 0x50a3,
	0x50b6, 0x50c8, 0x50da, 0x50eb, 0x50fc, 0x510d, 0x511e, 0x512f,
	0x5141, 0x5153, 0x5165, 0x5178, 0x518a, 0x51a6, 0x51c2, 0x51d5,
	0x51e9, 0x51fc, 0x520f, 0x522b, 0x5248, 0x5261, 0x527d, 0x5299,
	0x52b6, 0x52d1, 0x52ea, 0x5303, 0x5315, 0x532e, 0x5346, 0x535d,
	0x5370, 0x5384, 0x5397, 0x53ab, 0x53be, 0x53d2, 0x53ed, 0x5409,
	0x5424, 0x5440, 0x5453, 0x5467, 0x547b, 0x548e, 0x54a2, 0x54b6,
	0x54ca, 0x54df, 0x54f3, 0x5508, 0x551d, 0x5531, 0x5546, 0x555a,
	// Entry 3780 - 37BF
	0x556f, 0x5584, 0x5599, 0x55af, 0x55c4, 0x55da, 0x55ef, 0x5603,
	0x5618, 0x562c, 0x5641, 0x5655, 0x5669, 0x567e, 0x5692, 0x56a7,
	0x56bb, 0x56cf, 0x56e3, 0x56f7, 0x570b, 0x5720, 0x5735, 0x5749,
	0x575d, 0x5772, 0x5791, 0x57a9, 0x57c0, 0x57d8, 0x57ef, 0x5807,
	0x5826, 0x5846, 0x5865, 0x5885, 0x589c, 0x58b4, 0x58cc, 0x58e3,
	0x58fb, 0x5913, 0x5929, 0x5944, 0x5954, 0x596b, 0x5980, 0x5994,
	0x59a8, 0x59be, 0x59d3, 0x59e8, 0x59fc, 0x5a12, 0x5a28, 0x5a3d,
	0x5a5c, 0x5a7a, 0x5a98, 0x5ab8, 0x5ad7, 0x5af6, 0x5b14, 0x5b34,
	// Entry 37C0 - 37FF
	0x5b54, 0x5b73, 0x5b90, 0x5bad, 0x5bcb, 0x5be9, 0x5c07, 0x5c25,
	0x5c43, 0x5c65, 0x5c88, 0x5caa, 0x5cd3, 0x5cf2, 0x5d13, 0x5d37,
	0x5d4f, 0x5d64, 0x5d74, 0x5d89, 0x5da0, 0x5db2, 0x5dc6, 0x5dde,
	0x5df1, 0x5e03, 0x5e15, 0x5e29, 0x5e3c, 0x5e4f, 0x5e61, 0x5e75,
	0x5e89, 0x5e9c, 0x5eae, 0x5ec1, 0x5ed3, 0x5ee6, 0x5ef8, 0x5f0b,
	0x5f1d, 0x5f30, 0x5f42, 0x5f55, 0x5f67, 0x5f79, 0x5f8c, 0x5f9e,
	0x5fb0, 0x5fc2, 0x5fd4, 0x5fe6, 0x5ff8, 0x600a, 0x601d, 0x602f,
	0x6041, 0x6053, 0x6064, 0x6076, 0x6087, 0x6099, 0x60aa, 0x60ba,
	// Entry 3800 - 383F
	0x60ca, 0x60db, 0x60eb, 0x60ff, 0x6112, 0x612c, 0x613d, 0x614f,
	0x615f, 0x616f, 0x6180, 0x6190, 0x61a0, 0x61b0, 0x61c0, 0x61d0,
	0x61e0, 0x61f0, 0x6200, 0x6211, 0x6221, 0x6231, 0x6241, 0x6251,
	0x6261, 0x6271, 0x6282, 0x6294, 0x62a5, 0x62b7, 0x62c6, 0x62d9,
	0x62ec, 0x62ff, 0x6313, 0x6326, 0x633a, 0x634e, 0x6362, 0x637a,
	0x6391, 0x63a8, 0x63bf, 0x63cc, 0x63df, 0x63fb, 0x6417, 0x6432,
	0x644e, 0x646a, 0x648b, 0x64a7, 0x64c8, 0x64e3, 0x64fe, 0x651e,
	0x6541, 0x655b, 0x6576, 0x6593, 0x65af, 0x65cb, 0x65e5, 0x6607,
	// Entry 3840 - 387F
	0x6624, 0x663f, 0x665e, 0x6679, 0x6694, 0x66b4, 0x66d0, 0x66ed,
	0x6707, 0x6727, 0x673e, 0x6751, 0x6764, 0x6779, 0x678a, 0x67a0,
	0x67b1, 0x67c3, 0x67d4, 0x67ec, 0x6805, 0x6826, 0x6837, 0x6849,
	0x685a, 0x686c, 0x6884, 0x689c, 0x68ae, 0x68c6, 0x68d9, 0x68eb,
	0x6903, 0x6915, 0x692e, 0x694a, 0x695d, 0x6970, 0x698d, 0x69a0,
	0x69bd, 0x69d5, 0x69e7, 0x69ff, 0x6a11, 0x6a2d, 0x6a3f, 0x6a51,
	0x6a69, 0x6a7b, 0x6a93, 0x6aa5, 0x6ab7, 0x6ac9, 0x6ae1, 0x6af3,
	0x6b05, 0x6b1d, 0x6b39, 0x6b4b, 0x6b5d, 0x6b75, 0x6b8f, 0x6ba9,
	// Entry 3880 - 38BF
	0x6bc1, 0x6bdf, 0x6bf7, 0x6c16, 0x6c30, 0x6c4e, 0x6c67, 0x6c84,
	0x6ca3, 0x6cc0, 0x6cd0, 0x6ce7, 0x6cff, 0x6d12, 0x6d25, 0x6d38,
	0x6d4b, 0x6d60, 0x6d74, 0x6d88, 0x6d9a, 0x6db1, 0x6dc6, 0x6de2,
	0x6df6, 0x6e09, 0x6e1b, 0x6e2d, 0x6e41, 0x6e54, 0x6e67, 0x6e79,
	0x6e8d, 0x6ea1, 0x6eb4, 0x6ecf, 0x6ee6, 0x6efd, 0x6f14, 0x6f2b,
	0x6f42, 0x6f59, 0x6f6e, 0x6f98, 0x6fb4, 0x6fcf, 0x6fea, 0x7006,
	0x7021, 0x703d, 0x7059, 0x7076, 0x7092, 0x70ae, 0x70c9, 0x70e4,
	0x7101, 0x711d, 0x7139, 0x7154, 0x7171, 0x718e, 0x71aa, 0x71c6,
	// Entry 38C0 - 38FF
	0x71e1, 0x71fd, 0x7218, 0x7234, 0x7241, 0x724e, 0x725b, 0x7268,
	0x7276, 0x7283, 0x7291, 0x72a0, 0x72ae, 0x72bd, 0x72cd, 0x72dc,
	0x72eb, 0x72fb, 0x7309, 0x7318, 0x7328, 0x7337, 0x7347, 0x7355,
	0x7364, 0x7372, 0x7381, 0x7390, 0x739e, 0x73ad, 0x73bb, 0x73ca,
	0x73d9, 0x73e7, 0x73f6, 0x7405, 0x7413, 0x7422, 0x7430, 0x743e,
	0x744c, 0x745a, 0x7469, 0x7477, 0x7485, 0x7497, 0x74a8, 0x74ba,
	0x74cc, 0x74dd, 0x74ef, 0x7500, 0x7512, 0x7524, 0x7536, 0x754c,
	0x7562, 0x7578, 0x758e, 0x75a1, 0x75b4, 0x75c8, 0x75e4, 0x75f8,
	// Entry 3900 - 393F
	0x760b, 0x761e, 0x7631, 0x7644, 0x7657, 0x766a, 0x767e, 0x7699,
	0x76b4, 0x76c3, 0x76d1, 0x76df, 0x76ef, 0x76fe, 0x770d, 0x771b,
	0x772b, 0x773b, 0x774a, 0x7761, 0x7777, 0x7794, 0x77b1, 0x77c9,
	0x77e1, 0x77fa, 0x7812, 0x782b, 0x7844, 0x785d, 0x7877, 0x7890,
	0x78aa, 0x78c3, 0x78db, 0x78f3, 0x790b, 0x7924, 0x793c, 0x7968,
	0x7980, 0x7998, 0x79b0, 0x79cb, 0x79e5, 0x79ff, 0x7a1f, 0x7a37,
	0x7a4f, 0x7a66, 0x7a81, 0x7a9e, 0x7abb, 0x7ada, 0x7af9, 0x7b0f,
	0x7b26, 0x7b3d, 0x7b55, 0x7b6d, 0x7b86, 0x7b9c, 0x7bb3, 0x7bca,
	// Entry 3940 - 397F
	0x7be2, 0x7bf8, 0x7c0f, 0x7c26, 0x7c3e, 0x7c54, 0x7c6b, 0x7c82,
	0x7c9a, 0x7cb0, 0x7cc7, 0x7cdd, 0x7cf4, 0x7d0b, 0x7d23, 0x7d39,
	0x7d50, 0x7d66, 0x7d7d, 0x7d93, 0x7daa, 0x7dc1, 0x7dd9, 0x7def,
	0x7e06, 0x7e1c, 0x7e33, 0x7e49, 0x7e60, 0x7e76, 0x7e8d, 0x7ea3,
	0x7eba, 0x7ed0, 0x7ee7, 0x7efd, 0x7f14, 0x7f29, 0x7f3f, 0x7f50,
	0x7f61, 0x7f71, 0x7f82, 0x7f92, 0x7fa2, 0x7fb2, 0x7fc3, 0x7fd4,
	0x7fe6, 0x7ff7, 0x8009, 0x801a, 0x802b, 0x803c, 0x8050, 0x8067,
	0x807c, 0x8092, 0x80a5, 0x80ba, 0x80cd, 0x80e3, 0x80fa, 0x810f,
	// Entry 3980 - 39BF
	0x8124, 0x813b, 0x8152, 0x8169, 0x8181, 0x8198, 0x81b0, 0x81c7,
	0x81de, 0x81f5, 0x820f, 0x8229, 0x8244, 0x825e, 0x8279, 0x828e,
	0x82a7, 0x82b8, 0x82dd, 0x82fe, 0x831d, 0x8330, 0x8346, 0x835c,
	0x8373, 0x838a, 0x83a0, 0x83b6, 0x83cc, 0x83e2, 0x83f9, 0x8410,
	0x8426, 0x843c, 0x8451, 0x8466, 0x847c, 0x8492, 0x84a7, 0x84bc,
	0x84d3, 0x84ea, 0x8501, 0x8519, 0x8531, 0x8548, 0x855f, 0x8574,
	0x8589, 0x859e, 0x85b4, 0x85ca, 0x85df, 0x85f4, 0x8613, 0x8636,
	0x8656, 0x8671, 0x8693, 0x86ad, 0x86da, 0x8703, 0x8730, 0x8755,
	// Entry 39C0 - 39FF
	0x877b, 0x87a1, 0x87c9, 0x87e9, 0x8815, 0x883a, 0x8858, 0x8880,
	0x88b3, 0x88d5, 0x8903, 0x891f, 0x894a, 0x896d, 0x8988, 0x89ae,
	0x89db, 0x89f6, 0x8a1b, 0x8a3a, 0x8a63, 0x8a90, 0x8aa5, 0x8ac1,
	0x8ae4, 0x8afa, 0x8b24, 0x8b4e, 0x8b76, 0x8b9d, 0x8bd7, 0x8c09,
	0x8c32, 0x8c54, 0x8c6e, 0x8c9a, 0x8cc3, 0x8ce9, 0x8d05, 0x8d22,
	0x8d3c, 0x8d51, 0x8d72, 0x8d92, 0x8dc3, 0x8df4, 0x8e0b, 0x8e22,
	0x8e39, 0x8e50, 0x8e67, 0x8e7e, 0x8e96, 0x8eae, 0x8ec6, 0x8ede,
	0x8ef6, 0x8f0e, 0x8f26, 0x8f3e, 0x8f56, 0x8f6e, 0x8f86, 0x8f9e,
	// Entry 3A00 - 3A3F
	0x8fb6, 0x8fce, 0x8fe6, 0x8ffe, 0x9016, 0x902e, 0x9046, 0x905e,
	0x9076, 0x908e, 0x90a6, 0x90be, 0x90d6, 0x90ef, 0x9108, 0x9120,
	0x9138, 0x9150, 0x9168, 0x9180, 0x9199, 0x91b2, 0x91cb, 0x91e4,
	0x91fd, 0x9216, 0x922e, 0x9245, 0x925d, 0x9275, 0x928d, 0x92a5,
	0x92bd, 0x92d5, 0x92ed, 0x9305, 0x931d, 0x9335, 0x934d, 0x9365,
	0x937d, 0x9395, 0x93ae, 0x93c7, 0x93e0, 0x93f9, 0x9412, 0x942b,
	0x9444, 0x945d, 0x9476, 0x948f, 0x94a8, 0x94c1, 0x94da, 0x94f2,
	0x950a, 0x9522, 0x953a, 0x9552, 0x956a, 0x9582, 0x9599, 0x95b0,
	// Entry 3A40 - 3A7F
	0x95c7, 0x95de, 0x95f4, 0x960a, 0x9622, 0x9639, 0x9651, 0x9669,
	0x9681, 0x9698, 0x96b0, 0x96c7, 0x96dd, 0x96f2, 0x970a, 0x9723,
	0x973a, 0x9752, 0x9769, 0x977f, 0x9796, 0x97ad, 0x97c5, 0x97dd,
	0x97f5, 0x9813, 0x9831, 0x984f, 0x986c, 0x9889, 0x98a7, 0x98c6,
	0x98e2, 0x98fe, 0x991a, 0x9936, 0x9953, 0x9971, 0x998d, 0x99ac,
	0x99c8, 0x99dd, 0x99f2, 0x9a08, 0x9a1f, 0x9a35, 0x9a4b, 0x9a63,
	0x9a7a, 0x9a91, 0x9aa7, 0x9abf, 0x9ad7, 0x9aee, 0x9b04, 0x9b1a,
	0x9b2f, 0x9b45, 0x9b5b, 0x9b71, 0x9b87, 0x9b9d, 0x9bb2, 0x9bc7,
	// Entry 3A80 - 3ABF
	0x9bdd, 0x9bf2, 0x9c07, 0x9c1e, 0x9c34, 0x9c4a, 0x9c5f, 0x9c75,
	0x9c8a, 0x9c9f, 0x9cb3, 0x9ccb, 0x9ce3, 0x9cff, 0x9d1d, 0x9d39,
	0x9d5b, 0x9d78, 0x9d94, 0x9db7, 0x9dd4, 0x9df3, 0x9e12, 0x9e34,
	0x9e57, 0x9e7a, 0x9e9c, 0x9ebf, 0x9ee3, 0x9f02, 0x9f2a, 0x9f48,
	0x9f64, 0x9f85, 0x9fa0, 0x9fc1, 0x9fdd, 0x9ffa, 0xa01e, 0xa03a,
	0xa055, 0xa077, 0xa093, 0xa0b1, 0xa0cc, 0xa0ef, 0xa110, 0xa131,
	0xa14e, 0xa169, 0xa186, 0xa1a3, 0xa1be, 0xa1dc, 0xa202, 0xa221,
	0xa240, 0xa25c, 0xa27d, 0xa298, 0xa2b5, 0xa2d5, 0xa2f5, 0xa315,
	// Entry 3AC0 - 3AFF
	0xa335, 0xa355, 0xa375, 0xa395, 0xa3b5, 0xa3d5, 0xa3f5, 0xa415,
	0xa435, 0xa455, 0xa475, 0xa495, 0xa4b5, 0xa4d5, 0xa4f5, 0xa515,
	0xa535, 0xa555, 0xa575, 0xa595, 0xa5b5, 0xa5d5, 0xa5f5, 0xa615,
	0xa635, 0xa655, 0xa675, 0xa695, 0xa6b5, 0xa6d5, 0xa6f5, 0xa715,
	0xa735, 0xa755, 0xa775, 0xa795, 0xa7b5, 0xa7d5, 0xa7f5, 0xa815,
	0xa835, 0xa855, 0xa875, 0xa895, 0xa8b5, 0xa8d5, 0xa8f5, 0xa915,
	0xa935, 0xa955, 0xa975, 0xa995, 0xa9b5, 0xa9d5, 0xa9f5, 0xaa15,
	0xaa35, 0xaa55, 0xaa75, 0xaa95, 0xaab5, 0xaad5, 0xaaf5, 0xab15,
	// Entry 3B00 - 3B3F
	0xab35, 0xab55, 0xab75, 0xab95, 0xabb5, 0xabd5, 0xabf5, 0xac15,
	0xac35, 0xac55, 0xac75, 0xac95, 0xacb5, 0xacd5, 0xacf5, 0xad15,
	0xad35, 0xad55, 0xad75, 0xad95, 0xadb5, 0xadd5, 0xadf5, 0xae15,
	0xae35, 0xae55, 0xae75, 0xae95, 0xaeb5, 0xaed5, 0xaef5, 0xaf15,
	0xaf35, 0xaf55, 0xaf75, 0xaf95, 0xafb5, 0xafd5, 0xaff5, 0xb015,
	0xb035, 0xb055, 0xb075, 0xb095, 0xb0b5, 0xb0d5, 0xb0f5, 0xb115,
	0xb135, 0xb155, 0xb175, 0xb195, 0xb1b5, 0xb1d5, 0xb1f5, 0xb215,
	0xb235, 0xb255, 0xb275, 0xb295, 0xb2b5, 0xb2d5, 0xb2f5, 0xb315,
	// Entry 3B40 - 3B7F
	0xb335, 0xb355, 0xb375, 0xb395, 0xb3b5, 0xb3d5, 0xb3f5, 0xb415,
	0xb435, 0xb455, 0xb475, 0xb495, 0xb4b5, 0xb4d5, 0xb4f5, 0xb515,
	0xb535, 0xb555, 0xb575, 0xb595, 0xb5b5, 0xb5d5, 0xb5f5, 0xb615,
	0xb635, 0xb655, 0xb675, 0xb695, 0xb6b5, 0xb6d5, 0xb6f5, 0xb715,
	0xb735, 0xb755, 0xb775, 0xb795, 0xb7b5, 0xb7d5, 0xb7f5, 0xb815,
	0xb835, 0xb855, 0xb875, 0xb895, 0xb8b5, 0xb8d5, 0xb8f5, 0xb915,
	0xb935, 0xb955, 0xb975, 0xb995, 0xb9b5, 0xb9d5, 0xb9f5, 0xba15,
	0xba35, 0xba55, 0xba75, 0xba95, 0xbab5, 0xbad5, 0xbaf5, 0xbb15,
	// Entry 3B80 - 3BBF
	0xbb35, 0xbb55, 0xbb75, 0xbb95, 0xbbb5, 0xbbd5, 0xbbf5, 0xbc15,
	0xbc35, 0xbc55, 0xbc75, 0xbc95, 0xbcb5, 0xbcd5, 0xbcf5, 0xbd15,
	0xbd35, 0xbd55, 0xbd75, 0xbd95, 0xbdb5, 0xbdd5, 0xbdf5, 0xbe15,
	0xbe35, 0xbe55, 0xbe75, 0xbe95, 0xbeb5, 0xbed5, 0xbef5, 0xbf15,
	0xbf35, 0xbf55, 0xbf75, 0xbf95, 0xbfb5, 0xbfd5, 0xbff5, 0xc015,
	0xc035, 0xc055, 0xc075, 0xc095, 0xc0b5, 0xc0d5, 0xc0f5, 0xc115,
	0xc135, 0xc155, 0xc175, 0xc195, 0xc1b5, 0xc1d5, 0xc1f5, 0xc215,
	0xc235, 0xc255, 0xc275, 0xc295, 0xc2b5, 0xc2d5, 0xc2f5, 0xc315,
	// Entry 3BC0 - 3BFF
	0xc335, 0xc355, 0xc375, 0xc395, 0xc3b5, 0xc3d5, 0xc3f5, 0xc415,
	0xc435, 0xc455, 0xc475, 0xc495, 0xc4b5, 0xc4d5, 0xc4f5, 0xc515,
	0xc535, 0xc555, 0xc575, 0xc595, 0xc5b5, 0xc5d5, 0xc5f5, 0xc615,
	0xc635, 0xc655, 0xc675, 0xc695, 0xc6b5, 0xc6d5, 0xc6f5, 0xc715,
	0xc735, 0xc755, 0xc775, 0xc795, 0xc7b5, 0xc7d5, 0xc7f5, 0xc815,
	0xc835, 0xc855, 0xc875, 0xc895, 0xc8b5, 0xc8d5, 0xc8f5, 0xc915,
	0xc935, 0xc955, 0xc975, 0xc995, 0xc9b5, 0xc9d5, 0xc9f5, 0xca15,
	0xca35, 0xca55, 0xca75, 0xca95, 0xcab5, 0xcad5, 0xcaf5, 0xcb15,
	// Entry 3C00 - 3C3F
	0xcb35, 0xcb55, 0xcb75, 0xcb95, 0xcbb5, 0xcbd5, 0xcbf5, 0xcc15,
	0xcc35, 0xcc55, 0xcc75, 0xcc95, 0xccb5, 0xccd5, 0xccf5, 0xcd15,
	0xcd35, 0xcd55, 0xcd75, 0xcd95, 0xcdb5, 0xcdd5, 0xcdf5, 0xce15,
	0xce35, 0xce55, 0xce75, 0xce95, 0xceb5, 0xced5, 0xcef5, 0xcf15,
	0xcf35, 0xcf55, 0xcf75, 0xcf95, 0xcfb5, 0xcfd5, 0xcff5, 0xd015,
	0xd035, 0xd055, 0xd075, 0xd095, 0xd0b5, 0xd0d5, 0xd0f5, 0xd115,
	0xd135, 0xd155, 0xd175, 0xd195, 0xd1b5, 0xd1d5, 0xd1f5, 0xd215,
	0xd235, 0xd255, 0xd275, 0xd295, 0xd2b5, 0xd2d5, 0xd2f5, 0xd315,
	// Entry 3C40 - 3C7F
	0xd335, 0xd355, 0xd375, 0xd395, 0xd3b5, 0xd3d5, 0xd3f5, 0xd415,
	0xd435, 0xd455, 0xd475, 0xd495, 0xd4b5, 0xd4d5, 0xd4f5, 0xd515,
	0xd535, 0xd555, 0xd575, 0xd595, 0xd5b5, 0xd5d5, 0xd5f5, 0xd615,
	0xd635, 0xd655, 0xd675, 0xd695, 0xd6b5, 0xd6d5, 0xd6f5, 0xd715,
	0xd735, 0xd755, 0xd775, 0xd795, 0xd7b5, 0xd7d5, 0xd7f5, 0xd815,
	0xd835, 0xd855, 0xd875, 0xd895, 0xd8b5, 0xd8d5, 0xd8f5, 0xd915,
	0xd935, 0xd955, 0xd975, 0xd995, 0xd9b5, 0xd9d5, 0xd9f5, 0xda15,
	0xda35, 0xda55, 0xda75, 0xda95, 0xdab5, 0xdad5, 0xdaf5, 0xdb15,
	// Entry 3C80 - 3CBF
	0xdb35, 0xdb55, 0xdb75, 0xdb95, 0xdbb5, 0xdbd5, 0xdbf5, 0xdc15,
	0xdc35, 0xdc55, 0xdc75, 0xdc95, 0xdcb5, 0xdcd5, 0xdcf5, 0xdd15,
	0xdd35, 0xdd55, 0xdd75, 0xdd95, 0xddb5, 0xddd5, 0xddec, 0xde03,
	0xde1a, 0xde32, 0xde4a, 0xde67, 0xde7e, 0xde9d, 0xdebc, 0xdedb,
	0xdefa, 0xdf19, 0xdf35, 0xdf56, 0xdf7b, 0xdf99, 0xdfb0, 0xdfc8,
	0xdfdd, 0xdff3, 0xe00b, 0xe027, 0xe03e, 0xe054, 0xe077, 0xe097,
	0xe0b6, 0xe0e1, 0xe10b, 0xe128, 0xe146, 0xe163, 0xe180, 0xe19f,
	0xe1be, 0xe1d9, 0xe1f6, 0xe215, 0xe232, 0xe24f, 0xe272, 0xe28f,
	// Entry 3CC0 - 3CFF
	0xe2ae, 0xe2cb, 0xe2e8, 0xe308, 0xe32a, 0xe346, 0xe365, 0xe382,
	0xe3a0, 0xe3be, 0xe3db, 0xe3f7, 0xe412, 0xe42d, 0xe447, 0xe461,
	0xe487, 0xe4aa, 0xe4ca, 0xe4e7, 0xe506, 0xe524, 0xe543, 0xe55f,
	0xe57d, 0xe59a, 0xe5bb, 0xe5d9, 0xe5f9, 0xe618, 0xe63a, 0xe659,
	0xe67a, 0xe69a, 0xe6bb, 0xe6d9, 0xe6f9, 0xe718, 0xe738, 0xe755,
	0xe774, 0xe792, 0xe7b1, 0xe7cd, 0xe7eb, 0xe808, 0xe829, 0xe847,
	0xe867, 0xe886, 0xe8a6, 0xe8c3, 0xe8e2, 0xe900, 0xe920, 0xe93d,
	0xe95c, 0xe97a, 0xe99b, 0xe9b9, 0xe9d9, 0xe9f8, 0xea1b, 0xea3b,
	// Entry 3D00 - 3D3F
	0xea5d, 0xea7e, 0xeaa0, 0xeabf, 0xeae0, 0xeafe, 0xeb1d, 0xeb39,
	0xeb59, 0xeb76, 0xeb95, 0xebb1, 0xebd1, 0xebee, 0xec0f, 0xec2d,
	0xec4d, 0xec6c, 0xec8b, 0xeca7, 0xecc5, 0xece2, 0xed02, 0xed1f,
	0xed3e, 0xed5c, 0xed7d, 0xed9b, 0xedbb, 0xedda, 0xee01, 0xee25,
	0xee46, 0xee64, 0xee84, 0xeea3, 0xeed1, 0xeefc, 0xef20, 0xef41,
	0xef64, 0xef86, 0xefb1, 0xefd9, 0xf003, 0xf02c, 0xf052, 0xf075,
	0xf0ac, 0xf0e0, 0xf0f7, 0xf10e, 0xf12a, 0xf146, 0xf164, 0xf182,
	0xf1b3, 0xf1e4, 0xf201, 0xf21e, 0xf245, 0xf26c, 0xf293, 0xf2a5,
	// Entry 3D40 - 3D7F
	0xf2c2, 0xf2df, 0xf2fd, 0xf318, 0xf335, 0xf351, 0xf36e, 0xf388,
	0xf3a6, 0xf3c1, 0xf3df, 0xf3fa, 0xf428, 0xf446, 0xf461, 0xf487,
	0xf4aa, 0xf4d0, 0xf4f3, 0xf510, 0xf52a, 0xf546, 0xf561, 0xf59e,
	0xf5da, 0xf616, 0xf64f, 0xf689, 0xf6c0, 0xf6fb, 0xf733, 0xf76c,
	0xf7a2, 0xf7dc, 0xf813, 0xf84d, 0xf884, 0xf8bd, 0xf8f3, 0xf92b,
	0xf97e, 0xf9ce, 0xfa20, 0xfa45, 0xfa67, 0xfa8b, 0xfaae, 0xfaea,
	0xfb25, 0xfb61, 0xfba5, 0xfbe0, 0xfc0b, 0xfc35, 0xfc60, 0xfc8b,
	0xfcbe, 0xfce8, 0xfd13, 0xfd3d, 0xfd68, 0xfd93, 0xfdc6, 0xfdf0,
	// Entry 3D80 - 3DBF
	0xfe1c, 0xfe48, 0xfe7c, 0xfea7, 0xfed2, 0xfefe, 0xff29, 0xff54,
	0xff80, 0xffab, 0xffd7, 0x0003, 0x002e, 0x005a, 0x0086, 0x00b0,
	0x00db, 0x0106, 0x0130, 0x015b, 0x0186, 0x01b0, 0x01db, 0x0206,
	0x0231, 0x025c, 0x0289, 0x02b6, 0x02e1, 0x030b, 0x0336, 0x0361,
	0x0394, 0x03be, 0x03e8, 0x0413, 0x0446, 0x0470, 0x049b, 0x04c6,
	0x04f0, 0x051b, 0x0545, 0x0570, 0x05a3, 0x05cd, 0x05f8, 0x0622,
	0x064d, 0x0678, 0x06ab, 0x06d5, 0x0701, 0x072c, 0x0758, 0x0784,
	0x07b8, 0x07e3, 0x080f, 0x083a, 0x0866, 0x0892, 0x08c6, 0x08f1,
	// Entry 3DC0 - 3DFF
	0x091c, 0x0947, 0x097a, 0x09a4, 0x09cf, 0x09f9, 0x0a24, 0x0a4f,
	0x0a82, 0x0aac, 0x0ae4, 0x0b1b, 0x0b5b, 0x0b8d, 0x0bbf, 0x0bee,
	0x0c1d, 0x0c4c, 0x0c86, 0x0cbe, 0x0cf7, 0x0d30, 0x0d69, 0x0daa,
	0x0de2, 0x0e09, 0x0e31, 0x0e59, 0x0e81, 0x0eb1, 0x0ed8, 0x0eff,
	0x0f27, 0x0f4f, 0x0f77, 0x0fa7, 0x0fce, 0x0ff6, 0x101f, 0x1048,
	0x1071, 0x10a2, 0x10ca, 0x10fa, 0x1121, 0x1151, 0x1178, 0x11a0,
	0x11c7, 0x11ef, 0x121f, 0x1246, 0x126e, 0x129e, 0x12c5, 0x12ee,
	0x1317, 0x133f, 0x1368, 0x1391, 0x13ba, 0x13eb, 0x1413, 0x1450,
	// Entry 3E00 - 3E3F
	0x1477, 0x149f, 0x14c7, 0x14ef, 0x151f, 0x1546, 0x1581, 0x15bb,
	0x15f6, 0x1631, 0x166b, 0x1695, 0x16be, 0x16e8, 0x1712, 0x173b,
	0x1765, 0x178e, 0x17b8, 0x17e2, 0x180b, 0x1836, 0x1860, 0x188b,
	0x18b5, 0x18df, 0x190a, 0x1935, 0x1960, 0x198a, 0x19b5, 0x19e0,
	0x1a09, 0x1a33, 0x1a5d, 0x1a87, 0x1ab0, 0x1ada, 0x1b04, 0x1b2d,
	0x1b57, 0x1b81, 0x1bab, 0x1bd7, 0x1c03, 0x1c2d, 0x1c56, 0x1c80,
	0x1caa, 0x1cd3, 0x1cfd, 0x1d27, 0x1d50, 0x1d7a, 0x1da3, 0x1dcd,
	0x1df7, 0x1e20, 0x1e4a, 0x1e74, 0x1e9d, 0x1ec8, 0x1ef2, 0x1f1d,
	// Entry 3E40 - 3E7F
	0x1f48, 0x1f73, 0x1f9d, 0x1fc8, 0x1ff3, 0x201d, 0x2047, 0x2071,
	0x20a7, 0x20d1, 0x20fa, 0x2124, 0x214e, 0x2177, 0x21b1, 0x21ea,
	0x2213, 0x223b, 0x2264, 0x228c, 0x22b6, 0x22df, 0x2309, 0x2332,
	0x235d, 0x2387, 0x23af, 0x23d8, 0x2401, 0x242b, 0x2454, 0x247d,
	0x24a5, 0x24d2, 0x24ff, 0x252c, 0x255f, 0x2589, 0x25bc, 0x25e6,
	0x261b, 0x2647, 0x267b, 0x26a6, 0x26db, 0x2707, 0x273a, 0x2764,
	0x2798, 0x27c3, 0x27f7, 0x2822, 0x2855, 0x287f, 0x28b2, 0x28dc,
	0x2909, 0x2935, 0x2962, 0x298f, 0x29bb, 0x29e6, 0x2a10, 0x2a3a,
	// Entry 3E80 - 3EBF
	0x2a6a, 0x2a91, 0x2ac1, 0x2ae8, 0x2b1a, 0x2b43, 0x2b74, 0x2b9c,
	0x2bce, 0x2bf7, 0x2c27, 0x2c4e, 0x2c7f, 0x2ca7, 0x2cd8, 0x2d00,
	0x2d30, 0x2d57, 0x2d87, 0x2dae, 0x2dd8, 0x2e01, 0x2e2b, 0x2e55,
	0x2e7e, 0x2ea6, 0x2ecd, 0x2ef4, 0x2f20, 0x2f4b, 0x2f77, 0x2fa3,
	0x2fcd, 0x2ff8, 0x3022, 0x304c, 0x3075, 0x309f, 0x30ca, 0x30f4,
	0x311f, 0x3148, 0x3171, 0x319e, 0x31ce, 0x31e5, 0x31fd, 0x3231,
	0x3262, 0x3295, 0x32c8, 0x32fc, 0x3330, 0x3363, 0x3397, 0x33c9,
	0x33fd, 0x342e, 0x3468, 0x349c, 0x34d0, 0x350b, 0x353d, 0x3571,
	// Entry 3EC0 - 3EFF
	0x35a6, 0x35d9, 0x360e, 0x363e, 0x3670, 0x36a2, 0x36d5, 0x370a,
	0x373d, 0x3771, 0x37a7, 0x37db, 0x3811, 0x384a, 0x387c, 0x38b0,
	0x38e1, 0x3914, 0x3948, 0x3979, 0x39ab, 0x39dd, 0x3a11, 0x3a4b,
	0x3a7f, 0x3ab2, 0x3aee, 0x3b20, 0x3b54, 0x3b85, 0x3bb7, 0x3be8,
	0x3c18, 0x3c51, 0x3c85, 0x3cb7, 0x3ce9, 0x3d1d, 0x3d4e, 0x3d81,
	0x3db5, 0x3de9, 0x3e1a, 0x3e4e, 0x3e83, 0x3eb8, 0x3eed, 0x3f22,
	0x3f56, 0x3f8a, 0x3fbe, 0x3ff8, 0x402b, 0x4060, 0x409b, 0x40cd,
	0x4108, 0x413a, 0x416e, 0x419f, 0x41d0, 0x420a, 0x423b, 0x4275,
	// Entry 3F00 - 3F3F
	0x42a6, 0x42e0, 0x4312, 0x434c, 0x4387, 0x43c2, 0x43f2, 0x4424,
	0x4454, 0x4485, 0x44b6, 0x44e6, 0x4517, 0x4548, 0x457a, 0x45ab,
	0x45dc, 0x460f, 0x4642, 0x4673, 0x46a4, 0x46d8, 0x470a, 0x473e,
	0x4770, 0x47a2, 0x47d4, 0x4805, 0x4836, 0x4868, 0x4899, 0x48c9,
	0x48fd, 0x4931, 0x4965, 0x4997, 0x49c9, 0x4a06, 0x4a42, 0x4a65,
	0x4a88, 0x4aae, 0x4ad1, 0x4af5, 0x4b19, 0x4b3f, 0x4b62, 0x4b8d,
	0x4bac, 0x4bb5, 0x4be2, 0x4bf6, 0x4c0a, 0x4c1e, 0x4c32, 0x4c46,
	0x4c5a, 0x4c6e, 0x4c82, 0x4c96, 0x4cab, 0x4cc0, 0x4cd5, 0x4cea,
	// Entry 3F40 - 3F7F
	0x4cff, 0x4d14, 0x4d29, 0x4d4d, 0x4d7d, 0x4db1, 0x4dd5, 0x4dfd,
	0x4e2c, 0x4e58, 0x4e94, 0x4ed1, 0x4f03, 0x4f1f, 0x4f3c, 0x4f5c,
	0x4f7d, 0x4f97, 0x4fb2, 0x4fcd, 0x4fef, 0x5012, 0x5031, 0x5051,
	0x5071, 0x5092, 0x50b3, 0x50d5, 0x50f8, 0x5125, 0x514b, 0x5171,
	0x5198, 0x51c4, 0x51f3, 0x5223, 0x5254, 0x5286, 0x52c0, 0x52fb,
	0x5337, 0x5374, 0x53ac, 0x53e5, 0x5416, 0x5448, 0x547a, 0x54ad,
	0x54e5, 0x551e, 0x5528, 0x5538, 0x556a, 0x559d, 0x55ac, 0x55bf,
	0x55cc, 0x55e0, 0x55ef, 0x5602, 0x560f, 0x561a, 0x5631, 0x5640,
	// Entry 3F80 - 3FBF
	0x564f, 0x565a, 0x566d, 0x5683, 0x5690, 0x56a6, 0x56bd, 0x56d5,
	0x56ee, 0x570f, 0x5731, 0x5742, 0x5751, 0x575f, 0x576e, 0x5780,
	0x5794, 0x57ab, 0x57bc, 0x57d1, 0x57e2, 0x57f4, 0x5807, 0x5824,
	0x5846, 0x5863, 0x5877, 0x5894, 0x58ae, 0x58c6, 0x58e0, 0x58f8,
	0x5912, 0x592a, 0x5945, 0x595e, 0x5978, 0x5990, 0x59b1, 0x59e2,
	0x5a10, 0x5a41, 0x5a6f, 0x5a9f, 0x5acc, 0x5afd, 0x5b2b, 0x5b5b,
	0x5b88, 0x5bb7, 0x5be5, 0x5c05, 0x5c22, 0x5c41, 0x5c5d, 0x5c7b,
	0x5c98, 0x5cbf, 0x5ce3, 0x5d02, 0x5d1e, 0x5d3c, 0x5d59, 0x5d79,
	// Entry 3FC0 - 3FFF
	0x5d96, 0x5db5, 0x5dd3, 0x5df3, 0x5e10, 0x5e2f, 0x5e4d, 0x5e6c,
	0x5e88, 0x5ea6, 0x5ec3, 0x5ee3, 0x5f00, 0x5f1f, 0x5f3d, 0x5f5c,
	0x5f78, 0x5f98, 0x5fb5, 0x5fd4, 0x5ff0, 0x6010, 0x602d, 0x604d,
	0x606a, 0x6089, 0x60a7, 0x60c8, 0x60e6, 0x6106, 0x6125, 0x6144,
	0x6160, 0x617e, 0x619b, 0x61ba, 0x61d6, 0x61f4, 0x6211, 0x6230,
	0x624c, 0x626a, 0x6287, 0x62a6, 0x62c2, 0x62e0, 0x62fd, 0x631c,
	0x6338, 0x6356, 0x6373, 0x6394, 0x63b2, 0x63d2, 0x63f1, 0x6410,
	0x642c, 0x644a, 0x6467, 0x6486, 0x64a2, 0x64c0, 0x64dd, 0x64fc,
	// Entry 4000 - 403F
	0x6518, 0x6536, 0x6553, 0x6572, 0x658e, 0x65ac, 0x65c9, 0x65e9,
	0x6606, 0x6625, 0x6643, 0x6663, 0x6680, 0x669f, 0x66bd, 0x66dc,
	0x66f8, 0x6716, 0x6733, 0x6752, 0x676e, 0x6796, 0x67bb, 0x67da,
	0x67f6, 0x6814, 0x6831, 0x686d, 0x68a6, 0x68e2, 0x691b, 0x6957,
	0x6990, 0x69bb, 0x69e3, 0x69fc, 0x6a16, 0x6a2e, 0x6a43, 0x6a58,
	0x6a6e, 0x6a81, 0x6a95, 0x6aaf, 0x6aca, 0x6adc, 0x6aef, 0x6afe,
	0x6b14, 0x6b27, 0x6b38, 0x6b4c, 0x6b5f, 0x6b72, 0x6b87, 0x6b9b,
	0x6baf, 0x6bc2, 0x6bd7, 0x6bec, 0x6c00, 0x6c0f, 0x6c22, 0x6c3a,
	// Entry 4040 - 407F
	0x6c4f, 0x6c6a, 0x6c81, 0x6c98, 0x6cb8, 0x6cd8, 0x6cf8, 0x6d18,
	0x6d38, 0x6d58, 0x6d78, 0x6d98, 0x6db8, 0x6dd8, 0x6df8, 0x6e18,
	0x6e38, 0x6e58, 0x6e78, 0x6e98, 0x6eb8, 0x6ed8, 0x6ef8, 0x6f18,
	0x6f38, 0x6f58, 0x6f78, 0x6f98, 0x6fb8, 0x6fd8, 0x6ff5, 0x700e,
	0x702c, 0x7047, 0x7059, 0x706f, 0x708d, 0x70ab, 0x70c9, 0x70e7,
	0x7105, 0x7123, 0x7141, 0x715f, 0x717d, 0x719b, 0x71b9, 0x71d7,
	0x71f5, 0x7213, 0x7231, 0x724f, 0x726d, 0x728b, 0x72a9, 0x72c7,
	0x72e5, 0x7303, 0x7321, 0x733f, 0x735d, 0x737b, 0x7397, 0x73ae,
	// Entry 4080 - 40BF
	0x73cb, 0x73da, 0x73fa, 0x741b, 0x743a, 0x7457, 0x7475, 0x7490,
	0x74ad, 0x74c9, 0x74ea, 0x750b, 0x752c, 0x754d, 0x756e, 0x7590,
	0x75b2, 0x75d4, 0x75f6, 0x7626, 0x7641, 0x765c, 0x7677, 0x7692,
	0x76ad, 0x76c9, 0x76e5, 0x7701, 0x771d, 0x7739, 0x7755, 0x7771,
	0x778d, 0x77a9, 0x77c5, 0x77e1, 0x77fd, 0x7819, 0x7835, 0x7851,
	0x786d, 0x7889, 0x78a5, 0x78c1, 0x78dd, 0x78f9, 0x7915, 0x7931,
	0x794d, 0x7969, 0x7985, 0x79a1, 0x79bd, 0x79d9, 0x79f5, 0x7a11,
	0x7a2d, 0x7a49, 0x7a65, 0x7a81, 0x7a9d, 0x7ab9, 0x7ad5, 0x7af1,
	// Entry 40C0 - 40FF
	0x7b0c, 0x7b30, 0x7b59, 0x7b70, 0x7b8e, 0x7bb1, 0x7bd4, 0x7bf1,
	0x7c14, 0x7c37, 0x7c55, 0x7c78, 0x7c95, 0x7cb9, 0x7cdc, 0x7cff,
	0x7d21, 0x7d46, 0x7d6b, 0x7d8e, 0x7dab, 0x7dc8, 0x7dea, 0x7e0c,
	0x7e28, 0x7e49, 0x7e66, 0x7e83, 0x7ea5, 0x7ec4, 0x7ee3, 0x7f02,
	0x7f21, 0x7f3e, 0x7f57, 0x7f71, 0x7f8b, 0x7fa6, 0x7fc0, 0x7fd9,
	0x7ff4, 0x800e, 0x8027, 0x8041, 0x805c, 0x8076, 0x8090, 0x80a9,
	0x80c4, 0x80de, 0x80f8, 0x8112, 0x812c, 0x8146, 0x815f, 0x8172,
	0x8186, 0x8198, 0x81a8, 0x81bc, 0x81ce, 0x81e0, 0x81fe, 0x8217,
	// Entry 4100 - 413F
	0x822e, 0x8248, 0x8261, 0x8277, 0x828d, 0x82aa, 0x82ca, 0x82eb,
	0x8307, 0x831c, 0x8334, 0x834c, 0x8364, 0x837c, 0x8394, 0x83ad,
	0x83c6, 0x83df, 0x83f8, 0x8411, 0x842a, 0x8443, 0x845c, 0x8475,
	0x848e, 0x84a7, 0x84c0, 0x84d9, 0x84f2, 0x850b, 0x8524, 0x853d,
	0x8556, 0x856f, 0x8588, 0x85a1, 0x85ba, 0x85d3, 0x85ec, 0x8605,
	0x861e, 0x8637, 0x8650, 0x8669, 0x8682, 0x869b, 0x86b4, 0x86cd,
	0x86e6, 0x86ff, 0x8718, 0x8731, 0x874a, 0x8763, 0x877c, 0x8795,
	0x87ae, 0x87c7, 0x87e0, 0x87f9, 0x8812, 0x882b, 0x8844, 0x885d,
	// Entry 4140 - 417F
	0x8876, 0x888f, 0x88a8, 0x88c1, 0x88da, 0x88f3, 0x890c, 0x8925,
	0x893e, 0x8958, 0x8972, 0x898c, 0x89a6, 0x89c0, 0x89da, 0x89f4,
	0x8a0e, 0x8a28, 0x8a42, 0x8a5c, 0x8a70, 0x8a84, 0x8a98, 0x8aac,
	0x8ac0, 0x8ad4, 0x8ae8, 0x8afc, 0x8b10, 0x8b24, 0x8b38, 0x8b4c,
	0x8b60, 0x8b74, 0x8b8e, 0x8baa, 0x8bc5, 0x8be1, 0x8bfd, 0x8c1d,
	0x8c38, 0x8c53, 0x8c73, 0x8c92, 0x8cad, 0x8cc9, 0x8ce4, 0x8d00,
	0x8d1c, 0x8d39, 0x8d55, 0x8d71, 0x8d8f, 0x8daa, 0x8dc7, 0x8de1,
	0x8dfc, 0x8e12, 0x8e2e, 0x8e49, 0x8e66, 0x8e81, 0x8e97, 0x8eb2,
	// Entry 4180 - 41BF
	0x8ec8, 0x8ede, 0x8ef9, 0x8f0f, 0x8f25, 0x8f3b, 0x8f57, 0x8f6d,
	0x8f83, 0x8f9f, 0x8fb5, 0x8fcb, 0x8fe9, 0x9006, 0x901c, 0x9032,
	0x9048, 0x905e, 0x9074, 0x908a, 0x90a0, 0x90b6, 0x90cc, 0x90e8,
	0x90fe, 0x9119, 0x912f, 0x9145, 0x915b, 0x9171, 0x9187, 0x919d,
	0x91b3, 0x91c9, 0x91df, 0x91f5, 0x920b, 0x9228, 0x9248, 0x9266,
	0x9282, 0x929e, 0x92b4, 0x92d0, 0x92e6, 0x92fc, 0x9322, 0x9340,
	0x9364, 0x9380, 0x9396, 0x93ac, 0x93c8, 0x93de, 0x93f4, 0x940a,
	0x9420, 0x9436, 0x9451, 0x9467, 0x947d, 0x9493, 0x94a9, 0x94bf,
	// Entry 41C0 - 41FF
	0x94dc, 0x94f9, 0x9516, 0x9533, 0x9550, 0x956d, 0x958a, 0x95a7,
	0x95c4, 0x95e1, 0x95fe, 0x961b, 0x9638, 0x9655, 0x9672, 0x968f,
	0x96ac, 0x96c9, 0x96e6, 0x9703, 0x9720, 0x973d, 0x975a, 0x9777,
	0x9794, 0x97b1, 0x97ce, 0x97eb, 0x9808, 0x9822, 0x983b, 0x984c,
	0x985d, 0x986e, 0x9881, 0x9893, 0x98a5, 0x98b6, 0x98c9, 0x98dc,
	0x98ee, 0x98ff, 0x9913, 0x9927, 0x993a, 0x994d, 0x9960, 0x9975,
	0x9989, 0x999d, 0x99b6, 0x99cf, 0x99ea, 0x9a04, 0x9a1e, 0x9a37,
	0x9a52, 0x9a6d, 0x9a87, 0x9aa1, 0x9abb, 0x9ad7, 0x9af2, 0x9b0d,
	// Entry 4200 - 423F
	0x9b27, 0x9b43, 0x9b5f, 0x9b7a, 0x9b94, 0x9bb1, 0x9bce, 0x9bea,
	0x9c06, 0x9c22, 0x9c40, 0x9c5d, 0x9c7a, 0x9c91, 0x9cac, 0x9cc8,
	0x9ce3, 0x9cff, 0x9d1f, 0x9d42, 0x9d5f, 0x9d7b, 0x9d9d, 0x9dbc,
	0x9dde, 0x9df9, 0x9e15, 0x9e38, 0x9e5c, 0x9e81, 0x9ea4, 0x9ec6,
	0x9eea, 0x9f14, 0x9f3f, 0x9f6a, 0x9f96, 0x9fb9, 0x9fdb, 0x9fff,
	0xa029, 0xa054, 0xa07f, 0xa0aa, 0xa0d7, 0xa0f6, 0xa11b, 0xa138,
	0xa157, 0xa176, 0xa193, 0xa1b9, 0xa1e1, 0xa201, 0xa220, 0xa24e,
	0xa26d, 0xa28b, 0xa2a8, 0xa2c8, 0xa2e9, 0xa319, 0xa33a, 0xa359,
	// Entry 4240 - 427F
	0xa37e, 0xa3a5, 0xa3cd, 0xa3f5, 0xa41b, 0xa442, 0xa466, 0xa48c,
	0xa4b3, 0xa4d5, 0xa4f9, 0xa50c, 0xa52e, 0xa543, 0xa55c, 0xa56b,
	0xa57c, 0xa58e, 0xa59d, 0xa5b1, 0xa5c7, 0xa5dc, 0xa5f1, 0xa604,
	0xa61b, 0xa62b, 0xa63c, 0xa64d, 0xa65e, 0xa66f, 0xa680, 0xa698,
	0xa6a7, 0xa6bd, 0xa6d0, 0xa6e4, 0xa6f0, 0xa702, 0xa712, 0xa725,
	0xa737, 0xa751, 0xa763, 0xa776, 0xa78a, 0xa79f, 0xa7b3, 0xa7c0,
	0xa7d4, 0xa7e8, 0xa805, 0xa823, 0xa843, 0xa85d, 0xa875, 0xa88d,
	0xa8a6, 0xa8c1, 0xa8d9, 0xa8f1, 0xa907, 0xa920, 0xa937, 0xa952,
	// Entry 4280 - 42BF
	0xa96c, 0xa982, 0xa998, 0xa9b4, 0xa9d6, 0xa9ef, 0xaa06, 0xaa1e,
	0xaa37, 0xaa51, 0xaa68, 0xaa7f, 0xaa96, 0xaab2, 0xaac8, 0xaade,
	0xaaf6, 0xab0d, 0xab25, 0xab3b, 0xab58, 0xab6f, 0xab89, 0xaba3,
	0xabba, 0xabd4, 0xabec, 0xac05, 0xac20, 0xac3c, 0xac58, 0xac83,
	0xac92, 0xaca1, 0xacb0, 0xacc0, 0xaccf, 0xacde, 0xaced, 0xacfc,
	0xad0b, 0xad1b, 0xad2a, 0xad39, 0xad48, 0xad57, 0xad66, 0xad75,
	0xad85, 0xad95, 0xada4, 0xadb3, 0xadc3, 0xadd2, 0xade1, 0xadf0,
	0xae00, 0xae10, 0xae20, 0xae2f, 0xae3e, 0xae4d, 0xae5d, 0xae6c,
	// Entry 42C0 - 42FF
	0xae7b, 0xae8c, 0xae9b, 0xaeab, 0xaebb, 0xaeca, 0xaed9, 0xaee8,
	0xaef7, 0xaf07, 0xaf16, 0xaf26, 0xaf37, 0xaf46, 0xaf58, 0xaf67,
	0xaf77, 0xaf86, 0xaf95, 0xafa6, 0xafb5, 0xafc5, 0xafd4, 0xafe3,
	0xaff5, 0xb004, 0xb014, 0xb024, 0xb034, 0xb043, 0xb053, 0xb063,
	0xb074, 0xb084, 0xb094, 0xb0a6, 0xb0b6, 0xb0c8, 0xb0d8, 0xb0e8,
	0xb0f9, 0xb10a, 0xb11b, 0xb12c, 0xb13c, 0xb14e, 0xb169, 0xb17f,
	0xb195, 0xb1ad, 0xb1c4, 0xb1db, 0xb1f1, 0xb209, 0xb221, 0xb238,
	0xb24f, 0xb269, 0xb283, 0xb29c, 0xb2b5, 0xb2ce, 0xb2e9, 0xb303,
	// Entry 4300 - 433F
	0xb31d, 0xb33c, 0xb35b, 0xb37c, 0xb39c, 0xb3bc, 0xb3db, 0xb3fc,
	0xb41d, 0xb43d, 0xb450, 0xb464, 0xb478, 0xb48c, 0xb49f, 0xb4b3,
	0xb4c7, 0xb4db, 0xb4f0, 0xb503, 0xb517, 0xb52b, 0xb53f, 0xb553,
	0xb568, 0xb57b, 0xb58f, 0xb5a4, 0xb5b8, 0xb5cc, 0xb5e0, 0xb5f4,
	0xb607, 0xb61c, 0xb631, 0xb646, 0xb65a, 0xb66f, 0xb684, 0xb698,
	0xb6ac, 0xb6c1, 0xb6d7, 0xb6ee, 0xb704, 0xb71c, 0xb730, 0xb74e,
	0xb76c, 0xb77e, 0xb793, 0xb7a5, 0xb7b7, 0xb7cb, 0xb7e1, 0xb7f3,
	0xb805, 0xb819, 0xb82a, 0xb83d, 0xb850, 0xb863, 0xb877, 0xb888,
	// Entry 4340 - 437F
	0xb89a, 0xb8b0, 0xb8c4, 0xb8d7, 0xb8ea, 0xb8fd, 0xb910, 0xb923,
	0xb936, 0xb949, 0xb95c, 0xb976, 0xb98a, 0xb99f, 0xb9b4, 0xb9c9,
	0xb9dc, 0xb9f2, 0xba09, 0xba1f, 0xba36, 0xba49, 0xba5f, 0xba74,
	0xba8b, 0xbaa2, 0xbab8, 0xbace, 0xbae3, 0xbaf8, 0xbb0d, 0xbb20,
	0xbb37, 0xbb4e, 0xbb67, 0xbb7c, 0xbb92, 0xbba5, 0xbbb9, 0xbbcd,
	0xbbe1, 0xbbf7, 0xbc0c, 0xbc21, 0xbc37, 0xbc4c, 0xbc60, 0xbc74,
	0xbc88, 0xbc9c, 0xbcba, 0xbcd9, 0xbcf9, 0xbd1a, 0xbd39, 0xbd4d,
	0xbd61, 0xbd76, 0xbd89, 0xbd9e, 0xbdb0, 0xbdc2, 0xbdd6, 0xbdea,
	// Entry 4380 - 43BF
	0xbdfd, 0xbe10, 0xbe23, 0xbe37, 0xbe4c, 0xbe5f, 0xbe73, 0xbe86,
	0xbe98, 0xbead, 0xbec0, 0xbed2, 0xbee6, 0xbefa, 0xbf0f, 0xbf25,
	0xbf3a, 0xbf4c, 0xbf5d, 0xbf6e, 0xbf81, 0xbf96, 0xbfa8, 0xbfba,
	0xbfcc, 0xbfdf, 0xbff2, 0xc005, 0xc018, 0xc02b, 0xc03e, 0xc051,
	0xc064, 0xc077, 0xc08a, 0xc09d, 0xc0b0, 0xc0c3, 0xc0d7, 0xc0ea,
	0xc0fd, 0xc110, 0xc123, 0xc136, 0xc149, 0xc15c, 0xc16f, 0xc182,
	0xc195, 0xc1a8, 0xc1bb, 0xc1ce, 0xc1e1, 0xc1f4, 0xc207, 0xc21b,
	0xc22f, 0xc242, 0xc25d, 0xc27a, 0xc297, 0xc2b4, 0xc2ce, 0xc2ea,
	// Entry 43C0 - 43FF
	0xc2ff, 0xc317, 0xc32f, 0xc345, 0xc35b, 0xc371, 0xc38a, 0xc3a4,
	0xc3c1, 0xc3de, 0xc3fb, 0xc419, 0xc436, 0xc454, 0xc472, 0xc490,
	0xc4ae, 0xc4cd, 0xc4eb, 0xc50a, 0xc523, 0xc53c, 0xc555, 0xc56f,
	0xc587, 0xc5a1, 0xc5bb, 0xc5d5, 0xc5ef, 0xc60a, 0xc624, 0xc63e,
	0xc658, 0xc671, 0xc68b, 0xc6a5, 0xc6c0, 0xc6d9, 0xc6f3, 0xc70d,
	0xc728, 0xc741, 0xc75a, 0xc773, 0xc78c, 0xc7a6, 0xc7bf, 0xc7d8,
	0xc7f3, 0xc80e, 0xc829, 0xc845, 0xc860, 0xc87c, 0xc898, 0xc8b4,
	0xc8d0, 0xc8ed, 0xc909, 0xc926, 0xc93d, 0xc954, 0xc96b, 0xc983,
	// Entry 4400 - 443F
	0xc999, 0xc9b1, 0xc9c9, 0xc9e1, 0xc9f9, 0xca12, 0xca2a, 0xca42,
	0xca5a, 0xca71, 0xca89, 0xcaa1, 0xcaba, 0xcad1, 0xcae9, 0xcb01,
	0xcb1a, 0xcb31, 0xcb48, 0xcb5f, 0xcb76, 0xcb8e, 0xcba5, 0xcbbc,
	0xcbcf, 0xcbe1, 0xcbf4, 0xcc06, 0xcc1a, 0xcc2b, 0xcc3e, 0xcc53,
	0xcc65, 0xcc78, 0xcc8a, 0xcc9d, 0xccaf, 0xccc1, 0xccd4, 0xcce6,
	0xccfc, 0xcd10, 0xcd22, 0xcd36, 0xcd49, 0xcd5c, 0xcd6d, 0xcd7f,
	0xcd91, 0xcda3, 0xcdb4, 0xcdc7, 0xcdd9, 0xcdea, 0xcdfd, 0xce0f,
	0xce21, 0xce33, 0xce45, 0xce56, 0xce68, 0xce7b, 0xce8d, 0xce9f,
	// Entry 4440 - 447F
	0xceb1, 0xcec2, 0xced4, 0xcee6, 0xcefa, 0xcf0c, 0xcf1e, 0xcf30,
	0xcf43, 0xcf54, 0xcf65, 0xcf76, 0xcf87, 0xcf99, 0xcfac, 0xcfbd,
	0xcfce, 0xcfe2, 0xcff4, 0xd007, 0xd018, 0xd029, 0xd03c, 0xd04f,
	0xd062, 0xd075, 0xd088, 0xd09a, 0xd0ab, 0xd0bc, 0xd0cc, 0xd0dc,
	0xd0ec, 0xd0fc, 0xd10c, 0xd11d, 0xd12e, 0xd13f, 0xd151, 0xd162,
	0xd173, 0xd186, 0xd198, 0xd1aa, 0xd1bb, 0xd1ce, 0xd1e1, 0xd1f3,
	0xd209, 0xd220, 0xd238, 0xd24f, 0xd267, 0xd27f, 0xd299, 0xd2af,
	0xd2c7, 0xd2de, 0xd2f6, 0xd30c, 0xd323, 0xd33c, 0xd354, 0xd36b,
	// Entry 4480 - 44BF
	0xd382, 0xd399, 0xd3af, 0xd3c7, 0xd3de, 0xd3f7, 0xd40e, 0xd426,
	0xd43d, 0xd456, 0xd46e, 0xd488, 0xd4a1, 0xd4b9, 0xd4cf, 0xd4e6,
	0xd4fe, 0xd516, 0xd52d, 0xd545, 0xd559, 0xd56e, 0xd584, 0xd599,
	0xd5af, 0xd5c5, 0xd5dd, 0xd5f1, 0xd607, 0xd61c, 0xd632, 0xd646,
	0xd65b, 0xd672, 0xd688, 0xd69d, 0xd6b2, 0xd6c7, 0xd6db, 0xd6f1,
	0xd706, 0xd71d, 0xd732, 0xd748, 0xd75d, 0xd774, 0xd78a, 0xd7a2,
	0xd7b9, 0xd7cf, 0xd7e3, 0xd7f8, 0xd80e, 0xd824, 0xd839, 0xd84f,
	0xd85f, 0xd870, 0xd881, 0xd893, 0xd8a4, 0xd8b6, 0xd8c8, 0xd8d9,
	// Entry 44C0 - 44FF
	0xd8e9, 0xd8fa, 0xd90b, 0xd91d, 0xd92e, 0xd93e, 0xd94f, 0xd960,
	0xd971, 0xd983, 0xd994, 0xd9a5, 0xd9b6, 0xd9c8, 0xd9d8, 0xd9e9,
	0xd9fa, 0xda0b, 0xda1d, 0xda2e, 0xda40, 0xda51, 0xda63, 0xda73,
	0xda84, 0xda95, 0xdaa5, 0xdab6, 0xdac8, 0xdada, 0xdaef, 0xdb01,
	0xdb1e, 0xdb3b, 0xdb58, 0xdb75, 0xdb91, 0xdbaf, 0xdbcc, 0xdbea,
	0xdc07, 0xdc24, 0xdc42, 0xdc5f, 0xdc7c, 0xdc99, 0xdcb6, 0xdcd4,
	0xdcf2, 0xdd10, 0xdd2d, 0xdd4b, 0xdd68, 0xdd86, 0xdda4, 0xddc1,
	0xddde, 0xddfc, 0xde19, 0xde37, 0xde54, 0xde71, 0xde8f, 0xdeae,
	// Entry 4500 - 453F
	0xdecc, 0xdeea, 0xdf06, 0xdf24, 0xdf41, 0xdf5f, 0xdf7d, 0xdf9a,
	0xdfb9, 0xdfd6, 0xdff4, 0xe012, 0xe030, 0xe04e, 0xe06b, 0xe089,
	0xe0a7, 0xe0c5, 0xe0e3, 0xe100, 0xe120, 0xe133, 0xe146, 0xe159,
	0xe16c, 0xe17f, 0xe192, 0xe1a5, 0xe1b8, 0xe1cb, 0xe1de, 0xe1f1,
	0xe204, 0xe217, 0xe22a, 0xe23d, 0xe250, 0xe264, 0xe278, 0xe28b,
	0xe29f, 0xe2b3, 0xe2c6, 0xe2da, 0xe2ed, 0xe300, 0xe313, 0xe326,
	0xe339, 0xe34c, 0xe35f, 0xe372, 0xe385, 0xe398, 0xe3ab, 0xe3be,
	0xe3d1, 0xe3e4, 0xe3f7, 0xe40a, 0xe41d, 0xe430, 0xe443, 0xe456,
	// Entry 4540 - 457F
	0xe469, 0xe47c, 0xe48f, 0xe4a2, 0xe4b5, 0xe4c8, 0xe4db, 0xe4ee,
	0xe501, 0xe514, 0xe527, 0xe53a, 0xe54d, 0xe560, 0xe573, 0xe586,
	0xe599, 0xe5ac, 0xe5bf, 0xe5d2, 0xe5e5, 0xe5f8, 0xe60b, 0xe61e,
	0xe631, 0xe644, 0xe657, 0xe66a, 0xe680, 0xe693, 0xe6a6, 0xe6b9,
	0xe6cc, 0xe6df, 0xe6f3, 0xe707, 0xe71a, 0xe72d, 0xe740, 0xe753,
	0xe766, 0xe779, 0xe78b, 0xe79d, 0xe7af, 0xe7c1, 0xe7d3, 0xe7e5,
	0xe7f7, 0xe809, 0xe81c, 0xe82f, 0xe842, 0xe854, 0xe866, 0xe878,
	0xe88b, 0xe89e, 0xe8b1, 0xe8c3, 0xe8d5, 0xe8e7, 0xe8f9, 0xe90b,
	// Entry 4580 - 45BF
	0xe91d, 0xe92f, 0xe941, 0xe953, 0xe965, 0xe977, 0xe989, 0xe99b,
	0xe9ad, 0xe9bf, 0xe9d1, 0xe9e3, 0xe9f5, 0xea07, 0xea19, 0xea2b,
	0xea3d, 0xea4f, 0xea61, 0xea73, 0xea85, 0xea97, 0xeaa9, 0xeabb,
	0xeacd, 0xeadf, 0xeaf1, 0xeb03, 0xeb15, 0xeb27, 0xeb39, 0xeb4b,
	0xeb5d, 0xeb6f, 0xeb81, 0xeb93, 0xeba5, 0xebb7, 0xebc9, 0xebdb,
	0xebed, 0xebff, 0xec11, 0xec23, 0xec35, 0xec47, 0xec59, 0xec6b,
	0xec7d, 0xec8f, 0xeca1, 0xecb3, 0xecc5, 0xecdb, 0xecf1, 0xed07,
	0xed1d, 0xed33, 0xed49, 0xed5f, 0xed75, 0xed8b, 0xeda1, 0xedb7,
	// Entry 45C0 - 45FF
	0xedcd, 0xede3, 0xedf9, 0xee0f, 0xee25, 0xee3b, 0xee51, 0xee67,
	0xee79, 0xee8b, 0xee9d, 0xeeaf, 0xeec1, 0xeed3, 0xeee5, 0xeef7,
	0xef09, 0xef1b, 0xef2d, 0xef3f, 0xef51, 0xef63, 0xef75, 0xef87,
	0xef99, 0xefab, 0xefbd, 0xefcf, 0xefe1, 0xeff3, 0xf005, 0xf017,
	0xf029, 0xf03b, 0xf04d, 0xf05f, 0xf071, 0xf083, 0xf095, 0xf0a7,
	0xf0b9, 0xf0cb, 0xf0dd, 0xf0ef, 0xf101, 0xf113, 0xf125, 0xf137,
	0xf149, 0xf15b, 0xf16d, 0xf17f, 0xf191, 0xf1a3, 0xf1b5, 0xf1c7,
	0xf1d9, 0xf1eb, 0xf1fd, 0xf20f, 0xf221, 0xf233, 0xf245, 0xf257,
	// Entry 4600 - 463F
	0xf269, 0xf27b, 0xf28d, 0xf29f, 0xf2b1, 0xf2c3, 0xf2d5, 0xf2e7,
	0xf2f9, 0xf30b, 0xf31d, 0xf32f, 0xf341, 0xf353, 0xf365, 0xf377,
	0xf389, 0xf39b, 0xf3ad, 0xf3bf, 0xf3d1, 0xf3e3, 0xf3f5, 0xf407,
	0xf419, 0xf42b, 0xf43d, 0xf44f, 0xf461, 0xf473, 0xf485, 0xf497,
	0xf4a9, 0xf4bb, 0xf4cd, 0xf4df, 0xf4f1, 0xf503, 0xf515, 0xf527,
	0xf539, 0xf54b, 0xf55d, 0xf56f, 0xf581, 0xf593, 0xf5a5, 0xf5b7,
	0xf5c9, 0xf5db, 0xf5ed, 0xf5ff, 0xf611, 0xf623, 0xf635, 0xf647,
	0xf659, 0xf66b, 0xf67d, 0xf68f, 0xf6a1, 0xf6b3, 0xf6c5, 0xf6d7,
	// Entry 4640 - 467F
	0xf6e9, 0xf6fb, 0xf70d, 0xf71f, 0xf731, 0xf743, 0xf755, 0xf767,
	0xf779, 0xf78b, 0xf79d, 0xf7af, 0xf7c3, 0xf7d7, 0xf7eb, 0xf7ff,
	0xf813, 0xf827, 0xf83b, 0xf84f, 0xf863, 0xf87a, 0xf891, 0xf8a8,
	0xf8bf, 0xf8d3, 0xf8e7, 0xf8fb, 0xf913, 0xf929, 0xf93e, 0xf953,
	0xf96a, 0xf97f, 0xf991, 0xf9a3, 0xf9b5, 0xf9c7, 0xf9d9, 0xf9eb,
	0xf9fd, 0xfa0f, 0xfa21, 0xfa33, 0xfa45, 0xfa57, 0xfa69, 0xfa7c,
	0xfa8f, 0xfaa2, 0xfab5, 0xfac8, 0xfadb, 0xfaee, 0xfb01, 0xfb14,
	0xfb27, 0xfb3a, 0xfb4d, 0xfb60, 0xfb73, 0xfb86, 0xfb99, 0xfbac,
	// Entry 4680 - 46BF
	0xfbbf, 0xfbd2, 0xfbe5, 0xfbf8, 0xfc0b, 0xfc1e, 0xfc31, 0xfc44,
	0xfc57, 0xfc6a, 0xfc7d, 0xfc90, 0xfca3, 0xfcb6, 0xfcc9, 0xfcdc,
	0xfcef, 0xfd02, 0xfd15, 0xfd28, 0xfd3b, 0xfd4e, 0xfd61, 0xfd74,
	0xfd87, 0xfd9a, 0xfdad, 0xfdc0, 0xfdd3, 0xfde6, 0xfdf9, 0xfe0c,
	0xfe1f, 0xfe3c, 0xfe58, 0xfe75, 0xfe93, 0xfead, 0xfec8, 0xfee5,
	0xff01, 0xff1d, 0xff39, 0xff55, 0xff73, 0xff8e, 0xffa9, 0xffc7,
	0xffe3, 0xfffd, 0x001a, 0x0036, 0x0052, 0x006e, 0x0089, 0x00a6,
	0x00c1, 0x00dc, 0x00f9, 0x0114, 0x0132, 0x0155, 0x0179, 0x019d,
	// Entry 46C0 - 46FF
	0x01b3, 0x01c8, 0x01de, 0x01f5, 0x0208, 0x021c, 0x0232, 0x0247,
	0x025c, 0x0271, 0x0286, 0x029d, 0x02b1, 0x02cb, 0x02df, 0x02f6,
	0x030b, 0x031e, 0x0334, 0x0349, 0x035e, 0x0373, 0x0387, 0x03a6,
	0x03c6, 0x03da, 0x03ee, 0x0404, 0x0419, 0x042e, 0x0442, 0x0459,
	0x0475, 0x048b, 0x04a6, 0x04bb, 0x04d1, 0x04e8, 0x0501, 0x0514,
	0x0528, 0x053e, 0x0553, 0x0568, 0x0583, 0x0598, 0x05b3, 0x05c8,
	0x05e5, 0x05fc, 0x0616, 0x062a, 0x0644, 0x0658, 0x066f, 0x0684,
	0x0697, 0x06ad, 0x06c2, 0x06d7, 0x06f2, 0x0707, 0x071b, 0x072f,
	// Entry 4700 - 473F
	0x0743, 0x0759, 0x076e, 0x078d, 0x07a2, 0x07b6, 0x07cd, 0x07e9,
	0x07fc, 0x080e, 0x0821, 0x083a, 0x084a, 0x085b, 0x086d, 0x087f,
	0x0891, 0x08a3, 0x08b5, 0x08c9, 0x08da, 0x08eb, 0x08ff, 0x0910,
	0x0920, 0x0933, 0x0945, 0x0957, 0x0968, 0x0979, 0x098b, 0x099c,
	0x09b0, 0x09c9, 0x09de, 0x09f3, 0x0a09, 0x0a1f, 0x0a33, 0x0a48,
	0x0a5d, 0x0a72, 0x0a87, 0x0a9c, 0x0ab1, 0x0ac7, 0x0adc, 0x0af1,
	0x0b07, 0x0b1c, 0x0b30, 0x0b46, 0x0b5b, 0x0b71, 0x0b87, 0x0b9c,
	0x0bb1, 0x0bc6, 0x0bde, 0x0bfb, 0x0c10, 0x0c27, 0x0c40, 0x0c4f,
	// Entry 4740 - 477F
	0x0c5e, 0x0c6d, 0x0c7c, 0x0c8b, 0x0c9a, 0x0ca9, 0x0cb8, 0x0cc7,
	0x0cd6, 0x0ce5, 0x0cf4, 0x0d03, 0x0d12, 0x0d22, 0x0d31, 0x0d40,
	0x0d4f, 0x0d5e, 0x0d6d, 0x0d7d, 0x0d8d, 0x0d9d, 0x0dad, 0x0dbd,
	0x0dcc, 0x0de2, 0x0e00, 0x0e1e, 0x0e3c, 0x0e5a, 0x0e79, 0x0e98,
	0x0eb7, 0x0ed8, 0x0ef7, 0x0f16, 0x0f35, 0x0f56, 0x0f75, 0x0f96,
	0x0fb5, 0x0fd6, 0x0ff5, 0x1015, 0x1035, 0x1054, 0x1075, 0x1094,
	0x10b3, 0x10d2, 0x10f1, 0x1112, 0x1131, 0x1152, 0x1171, 0x1190,
	0x11b1, 0x11d4, 0x11ed, 0x1206, 0x121f, 0x1238, 0x1252, 0x126c,
	// Entry 4780 - 47BF
	0x1286, 0x12a0, 0x12ba, 0x12d4, 0x12ee, 0x1308, 0x1322, 0x133d,
	0x1358, 0x1372, 0x1394, 0x13ae, 0x13c8, 0x13e2, 0x13fc, 0x1416,
	0x1430, 0x144a, 0x1473, 0x1495, 0x14b2, 0x14cf, 0x14ea, 0x1505,
	0x1522, 0x153e, 0x155a, 0x1575, 0x1592, 0x15af, 0x15cb, 0x15e6,
	0x1604, 0x1622, 0x163f, 0x165c, 0x1679, 0x1698, 0x16bb, 0x16de,
	0x1703, 0x1727, 0x174b, 0x176e, 0x1793, 0x17b8, 0x17dc, 0x1800,
	0x1824, 0x184a, 0x186f, 0x1894, 0x18b8, 0x18de, 0x1904, 0x1929,
	0x194d, 0x1974, 0x199b, 0x19c1, 0x19e7, 0x1a0d, 0x1a35, 0x1a5c,
	// Entry 47C0 - 47FF
	0x1a83, 0x1aaf, 0x1adb, 0x1b09, 0x1b36, 0x1b63, 0x1b8f, 0x1bbd,
	0x1beb, 0x1c18, 0x1c3d, 0x1c63, 0x1c8b, 0x1cb2, 0x1cd9, 0x1cff,
	0x1d27, 0x1d4f, 0x1d76, 0x1d9c, 0x1daf, 0x1dc6, 0x1ddd, 0x1dfc,
	0x1e13, 0x1e2a, 0x1e46, 0x1e67, 0x1e7f, 0x1e96, 0x1eaa, 0x1ebf,
	0x1ed3, 0x1ee8, 0x1efc, 0x1f11, 0x1f25, 0x1f3a, 0x1f4f, 0x1f65,
	0x1f7a, 0x1f90, 0x1fa5, 0x1fb9, 0x1fce, 0x1fe2, 0x1ff7, 0x200b,
	0x201f, 0x2034, 0x2048, 0x205d, 0x2071, 0x2085, 0x2099, 0x20ad,
	0x20c1, 0x20d6, 0x20eb, 0x20ff, 0x2113, 0x2127, 0x213c, 0x2153,
	// Entry 4800 - 483F
	0x2169, 0x217e, 0x2197, 0x21ac, 0x21c5, 0x21d6, 0x21ea, 0x21fe,
	0x2214, 0x2229, 0x223e, 0x2256, 0x2273, 0x2291, 0x22ad, 0x22c7,
	0x22ea, 0x2307, 0x232a, 0x2349, 0x2365, 0x2381, 0x23a4, 0x23c0,
	0x23db, 0x23fa, 0x2417, 0x2433, 0x2450, 0x246c, 0x2489, 0x24a6,
	0x24c3, 0x24df, 0x24fb, 0x2518, 0x2534, 0x2552, 0x2570, 0x258f,
	0x25aa, 0x25c7, 0x25e3, 0x2602, 0x2620, 0x263f, 0x265d, 0x267a,
	0x2697, 0x26b7, 0x26d4, 0x26f1, 0x270f, 0x272b, 0x2749, 0x276c,
	0x2788, 0x27a4, 0x27c0, 0x27dd, 0x27f9, 0x2815, 0x2832, 0x284e,
	// Entry 4840 - 487F
	0x286a, 0x2886, 0x28a3, 0x28bf, 0x28dc, 0x28f9, 0x2915, 0x2932,
	0x294e, 0x296b, 0x2987, 0x29a3, 0x29c0, 0x29dc, 0x29fa, 0x2a16,
	0x2a33, 0x2a50, 0x2a6c, 0x2a89, 0x2aa5, 0x2ac1, 0x2add, 0x2afc,
	0x2b13, 0x2b29, 0x2b40, 0x2b57, 0x2b6f, 0x2b87, 0x2b9b, 0x2bb0,
	0x2bc2, 0x2bd9, 0x2bf1, 0x2c08, 0x2c20, 0x2c36, 0x2c4c, 0x2c62,
	0x2c78, 0x2c8e, 0x2ca5, 0x2cbd, 0x2cd6, 0x2cef, 0x2d04, 0x2d19,
	0x2d31, 0x2d47, 0x2d5e, 0x2d72, 0x2d86, 0x2d9d, 0x2db3, 0x2dc9,
	0x2de0, 0x2df6, 0x2e0c, 0x2e23, 0x2e38, 0x2e5a, 0x2e7c, 0x2e91,
	// Entry 4880 - 48BF
	0x2ea7, 0x2ebc, 0x2ed4, 0x2ef1, 0x2f0c, 0x2f2a, 0x2f56, 0x2f7b,
	0x2f95, 0x2fb4, 0x2fd6, 0x2fe6, 0x2ff7, 0x3008, 0x301a, 0x302b,
	0x303d, 0x304e, 0x3060, 0x3070, 0x3081, 0x3091, 0x30a2, 0x30b2,
	0x30c3, 0x30d3, 0x30e4, 0x30f5, 0x3106, 0x3118, 0x312a, 0x313b,
	0x314d, 0x315f, 0x3170, 0x3181, 0x3192, 0x31a4, 0x31b5, 0x31c7,
	0x31d9, 0x31ea, 0x31fb, 0x320c, 0x321e, 0x3230, 0x3243, 0x3256,
	0x3267, 0x3279, 0x328b, 0x329c, 0x32ae, 0x32c0, 0x32d1, 0x32e2,
	0x32f3, 0x3304, 0x3315, 0x3326, 0x3338, 0x334a, 0x335d, 0x3370,
	// Entry 48C0 - 48FF
	0x3381, 0x339a, 0x33c0, 0x33e7, 0x340e, 0x3435, 0x345e, 0x3487,
	0x34aa, 0x34cc, 0x34ef, 0x3513, 0x3533, 0x3554, 0x3577, 0x3599,
	0x35bb, 0x35dd, 0x35ff, 0x3623, 0x3644, 0x3665, 0x3689, 0x36ab,
	0x36cb, 0x36ee, 0x3710, 0x3732, 0x3754, 0x3775, 0x3796, 0x37b7,
	0x37da, 0x37fc, 0x381d, 0x3841, 0x386a, 0x3894, 0x38b6, 0x38d7,
	0x38f9, 0x391c, 0x393b, 0x3965, 0x3987, 0x39a8, 0x39c9, 0x39ea,
	0x3a0b, 0x3a2e, 0x3a53, 0x3a73, 0x3a96, 0x3ab5, 0x3ad7, 0x3af8,
	0x3b18, 0x3b38, 0x3b58, 0x3b7a, 0x3b9b, 0x3bbb, 0x3bde, 0x3c06,
	// Entry 4900 - 493F
	0x3c2f, 0x3c4b, 0x3c66, 0x3c82, 0x3c9f, 0x3cb8, 0x3cdc, 0x3cf8,
	0x3d13, 0x3d2e, 0x3d49, 0x3d66, 0x3d85, 0x3d9f, 0x3dbc, 0x3dd5,
	0x3df1, 0x3e0c, 0x3e26, 0x3e42, 0x3e65, 0x3e89, 0x3eab, 0x3ec5,
	0x3edf, 0x3efb, 0x3f16, 0x3f30, 0x3f4d, 0x3f6f, 0x3f89, 0x3fa4,
	0x3fc0, 0x3fda, 0x3ff5, 0x4010, 0x402a, 0x4045, 0x4061, 0x407c,
	0x4098, 0x40b4, 0x40d1, 0x40ec, 0x4108, 0x4124, 0x4141, 0x415c,
	0x4178, 0x4194, 0x41af, 0x41cb, 0x41e6, 0x4202, 0x421e, 0x423b,
	0x4257, 0x4274, 0x4290, 0x42ad, 0x42c8, 0x42e4, 0x4300, 0x431c,
	// Entry 4940 - 497F
	0x4337, 0x4352, 0x436e, 0x438b, 0x43a7, 0x43c4, 0x43e0, 0x43fd,
	0x4419, 0x4436, 0x4453, 0x446f, 0x448d, 0x44a8, 0x44c3, 0x44de,
	0x44f9, 0x4515, 0x4530, 0x454c, 0x4567, 0x4583, 0x459e, 0x45ba,
	0x45d5, 0x45f1, 0x460d, 0x4628, 0x4644, 0x4660, 0x467d, 0x4699,
	0x46b6, 0x46d1, 0x46ed, 0x4709, 0x4726, 0x4741, 0x475e, 0x477c,
	0x479b, 0x47ba, 0x47da, 0x47f9, 0x4819, 0x4839, 0x4858, 0x4878,
	0x4896, 0x48ba, 0x48d9, 0x48f8, 0x4917, 0x4937, 0x4956, 0x4974,
	0x4993, 0x49b2, 0x49d1, 0x49f0, 0x4a10, 0x4a2f, 0x4a4f, 0x4a6e,
	// Entry 4980 - 49BF
	0x4a8d, 0x4aad, 0x4acb, 0x4aea, 0x4b14, 0x4b3d, 0x4b5d, 0x4b7c,
	0x4b9c, 0x4bbb, 0x4be0, 0x4bff, 0x4c1f, 0x4c3e, 0x4c5e, 0x4c7e,
	0x4c9e, 0x4cbc, 0x4cdb, 0x4d05, 0x4d2e, 0x4d4d, 0x4d6c, 0x4d8c,
	0x4db8, 0x4dd7, 0x4df3, 0x4e10, 0x4e2d, 0x4e4b, 0x4e68, 0x4e86,
	0x4ea4, 0x4ec1, 0x4edf, 0x4efb, 0x4f1d, 0x4f3a, 0x4f57, 0x4f74,
	0x4f92, 0x4faf, 0x4fcb, 0x4fe8, 0x5005, 0x5022, 0x503f, 0x505d,
	0x507a, 0x5098, 0x50b5, 0x50d2, 0x50f0, 0x510c, 0x5129, 0x5151,
	0x5178, 0x5196, 0x51b3, 0x51d1, 0x51ee, 0x5211, 0x522e, 0x524c,
	// Entry 49C0 - 49FF
	0x5269, 0x5287, 0x52a5, 0x52c3, 0x52df, 0x52fc, 0x5324, 0x534b,
	0x5368, 0x5385, 0x53a3, 0x53cd, 0x53ea, 0x5402, 0x541b, 0x5433,
	0x544d, 0x546d, 0x548e, 0x54a6, 0x54bf, 0x54d8, 0x54f1, 0x550b,
	0x5524, 0x553d, 0x5556, 0x5570, 0x5589, 0x55a2, 0x55bc, 0x55d5,
	0x55ef, 0x5608, 0x5621, 0x563b, 0x5654, 0x566d, 0x5686, 0x569f,
	0x56b8, 0x56d1, 0x56f0, 0x5709, 0x5728, 0x5742, 0x575c, 0x5775,
	0x578c, 0x57a3, 0x57ba, 0x57d1, 0x57e8, 0x5802, 0x5820, 0x583d,
	0x5858, 0x5871, 0x588b, 0x58a5, 0x58be, 0x58d7, 0x58f2, 0x590c,
	// Entry 4A00 - 4A3F
	0x5926, 0x593f, 0x595a, 0x5975, 0x598f, 0x599d, 0x59ab, 0x59bb,
	0x59ca, 0x59d9, 0x59e7, 0x59f7, 0x5a07, 0x5a16, 0x5a25, 0x5a37,
	0x5a49, 0x5a5a, 0x5a6b, 0x5a7c, 0x5a8f, 0x5aa1, 0x5ab3, 0x5aca,
	0x5ae1, 0x5afa, 0x5b12, 0x5b2a, 0x5b41, 0x5b5a, 0x5b73, 0x5b8b,
	0x5ba1, 0x5bba, 0x5bd1, 0x5be9, 0x5c01, 0x5c1f, 0x5c36, 0x5c53,
	0x5c6b, 0x5c80, 0x5c9b, 0x5cb1, 0x5cc9, 0x5ce0, 0x5cf7, 0x5d0e,
	0x5d27, 0x5d3d, 0x5d53, 0x5d6f, 0x5d9e, 0x5db7, 0x5dce, 0x5def,
	0x5e04, 0x5e1c, 0x5e3a, 0x5e6b, 0x5e8e, 0x5ea5, 0x5ebb, 0x5ed7,
	// Entry 4A40 - 4A7F
	0x5f06, 0x5f1c, 0x5f32, 0x5f4a, 0x5f61, 0x5f78, 0x5f8e, 0x5fa7,
	0x5fc0, 0x5fde, 0x5ffb, 0x601b, 0x602f, 0x6042, 0x6056, 0x6067,
	0x6079, 0x608d, 0x60a0, 0x60b3, 0x60c6, 0x60db, 0x60ed, 0x60ff,
	0x6114, 0x6127, 0x6138, 0x614c, 0x6164, 0x6177, 0x6189, 0x619c,
	0x61af, 0x61c7, 0x61e2, 0x6202, 0x621d, 0x623d, 0x625a, 0x6277,
	0x6293, 0x62af, 0x62d0, 0x62ec, 0x630a, 0x631c, 0x632e, 0x6343,
	0x635d, 0x6382, 0x63b1, 0x63d4, 0x63fd, 0x6425, 0x6439, 0x644c,
	0x6460, 0x6475, 0x6486, 0x6498, 0x64ac, 0x64bf, 0x64d2, 0x64e5,
	// Entry 4A80 - 4ABF
	0x64f8, 0x650d, 0x651f, 0x6531, 0x6546, 0x6559, 0x656a, 0x657e,
	0x6591, 0x65a4, 0x65b7, 0x65c9, 0x65e4, 0x65fb, 0x660f, 0x6622,
	0x6639, 0x6650, 0x665f, 0x666f, 0x667e, 0x668e, 0x669d, 0x66ad,
	0x66c4, 0x66dc, 0x66f3, 0x670b, 0x671a, 0x672a, 0x6739, 0x6749,
	0x6759, 0x676a, 0x677a, 0x678b, 0x679c, 0x67ac, 0x67bd, 0x67cd,
	0x67de, 0x67ef, 0x6800, 0x6812, 0x6823, 0x6835, 0x6846, 0x6856,
	0x6867, 0x6877, 0x6888, 0x6898, 0x68a8, 0x68b9, 0x68c9, 0x68da,
	0x68ea, 0x68fa, 0x690a, 0x691a, 0x692a, 0x693b, 0x694c, 0x695c,
	// Entry 4AC0 - 4AFF
	0x696c, 0x697d, 0x6999, 0x69b4, 0x69d0, 0x69e4, 0x6a04, 0x6a17,
	0x6a2b, 0x6a3e, 0x6a52, 0x6a6d, 0x6a89, 0x6aa4, 0x6ac0, 0x6ad3,
	0x6ae7, 0x6afa, 0x6b0e, 0x6b1b, 0x6b27, 0x6b3a, 0x6b50, 0x6b6d,
	0x6b84, 0x6ba3, 0x6bbb, 0x6bcc, 0x6bdd, 0x6bf0, 0x6c02, 0x6c14,
	0x6c25, 0x6c38, 0x6c4b, 0x6c5d, 0x6c6e, 0x6c82, 0x6c96, 0x6ca9,
	0x6cbc, 0x6ccf, 0x6ce4, 0x6cf8, 0x6d0c, 0x6d25, 0x6d3f, 0x6d50,
	0x6d60, 0x6d70, 0x6d82, 0x6d93, 0x6da4, 0x6db4, 0x6dc6, 0x6dd8,
	0x6de9, 0x6dfd, 0x6e14, 0x6e28, 0x6e3b, 0x6e4a, 0x6e5a, 0x6e69,
	// Entry 4B00 - 4B3F
	0x6e79, 0x6e88, 0x6e98, 0x6ea7, 0x6eb7, 0x6ec6, 0x6ed6, 0x6ee6,
	0x6ef7, 0x6f07, 0x6f18, 0x6f29, 0x6f39, 0x6f4a, 0x6f5a, 0x6f6b,
	0x6f7c, 0x6f8d, 0x6f9f, 0x6fb0, 0x6fc3, 0x6fd5, 0x6fe6, 0x6ff7,
	0x7007, 0x7018, 0x7028, 0x7039, 0x7049, 0x7059, 0x706a, 0x707a,
	0x708b, 0x709b, 0x70ab, 0x70bb, 0x70cb, 0x70db, 0x70ec, 0x70fd,
	0x710d, 0x711d, 0x7131, 0x7144, 0x7158, 0x716b, 0x717f, 0x7192,
	0x71a6, 0x71b9, 0x71cd, 0x71df, 0x71f0, 0x7208, 0x721f, 0x7231,
	0x7244, 0x725e, 0x726a, 0x727d, 0x7295, 0x72ac, 0x72c3, 0x72da,
	// Entry 4B40 - 4B7F
	0x72f1, 0x7308, 0x731f, 0x7336, 0x734e, 0x7365, 0x737c, 0x7393,
	0x73aa, 0x73c1, 0x73d8, 0x73ef, 0x7406, 0x741d, 0x7435, 0x744b,
	0x7462, 0x7478, 0x748e, 0x74a4, 0x74ba, 0x74d1, 0x74e8, 0x74fe,
	0x7514, 0x752c, 0x7543, 0x755a, 0x7570, 0x7588, 0x75a0, 0x75b7,
	0x75ce, 0x75e2, 0x75f5, 0x7605, 0x7614, 0x7623, 0x7632, 0x7643,
	0x7655, 0x7666, 0x7678, 0x768a, 0x769b, 0x76ad, 0x76be, 0x76d0,
	0x76e2, 0x76f4, 0x7707, 0x7719, 0x772c, 0x773e, 0x774f, 0x7761,
	0x7772, 0x7784, 0x7795, 0x77a6, 0x77b8, 0x77c9, 0x77db, 0x77ec,
	// Entry 4B80 - 4BBF
	0x77fe, 0x780f, 0x7820, 0x7831, 0x7842, 0x7853, 0x7864, 0x7877,
	0x788a, 0x789e, 0x78b1, 0x78c5, 0x78d8, 0x78ec, 0x78ff, 0x7913,
	0x7927, 0x7934, 0x7942, 0x794f, 0x795d, 0x796e, 0x797e, 0x798e,
	0x79a0, 0x79b1, 0x79c2, 0x79d2, 0x79e4, 0x79f6, 0x7a07, 0x7a1a,
	0x7a26, 0x7a39, 0x7a4d, 0x7a5f, 0x7a73, 0x7a87, 0x7a98, 0x7aa9,
	0x7aba, 0x7acb, 0x7adc, 0x7aee, 0x7b01, 0x7b13, 0x7b26, 0x7b38,
	0x7b4b, 0x7b5d, 0x7b70, 0x7b83, 0x7b96, 0x7baa, 0x7bbd, 0x7bd1,
	0x7be4, 0x7bf6, 0x7c09, 0x7c1b, 0x7c2e, 0x7c40, 0x7c52, 0x7c65,
	// Entry 4BC0 - 4BFF
	0x7c77, 0x7c8a, 0x7c9c, 0x7cae, 0x7cc0, 0x7cd2, 0x7ce4, 0x7cf6,
	0x7d09, 0x7d1c, 0x7d36, 0x7d4b, 0x7d61, 0x7d79, 0x7d8e, 0x7da2,
	0x7db2, 0x7dc3, 0x7dd3, 0x7de4, 0x7df4, 0x7e05, 0x7e1d, 0x7e36,
	0x7e4e, 0x7e67, 0x7e77, 0x7e88, 0x7e98, 0x7ea9, 0x7eba, 0x7ecc,
	0x7edd, 0x7eef, 0x7f01, 0x7f12, 0x7f24, 0x7f35, 0x7f47, 0x7f59,
	0x7f6b, 0x7f7e, 0x7f90, 0x7fa3, 0x7fb5, 0x7fc6, 0x7fd8, 0x7fe9,
	0x7ffb, 0x800c, 0x801d, 0x802f, 0x8040, 0x8052, 0x8063, 0x8074,
	0x8085, 0x8096, 0x80a8, 0x80b9, 0x80cb, 0x80dd, 0x80ee, 0x80ff,
	// Entry 4C00 - 4C3F
	0x8114, 0x8128, 0x813d, 0x8151, 0x8166, 0x8182, 0x819f, 0x81bb,
	0x81d8, 0x81ec, 0x8201, 0x8215, 0x822a, 0x823d, 0x8252, 0x826a,
	0x8282, 0x828c, 0x8299, 0x82ad, 0x82c6, 0x82d7, 0x82ea, 0x82fc,
	0x8317, 0x8335, 0x8347, 0x8359, 0x836a, 0x837b, 0x838e, 0x83a0,
	0x83b2, 0x83c3, 0x83d6, 0x83e9, 0x83fb, 0x8407, 0x841b, 0x842d,
	0x8446, 0x845c, 0x8472, 0x848b, 0x84a4, 0x84bf, 0x84d9, 0x84f3,
	0x850c, 0x8527, 0x8542, 0x855c, 0x8576, 0x8593, 0x85b0, 0x85cc,
	0x85e8, 0x8604, 0x8622, 0x863f, 0x865c, 0x867e, 0x86a1, 0x86b0,
	// Entry 4C40 - 4C7F
	0x86c0, 0x86cf, 0x86de, 0x86ed, 0x86fd, 0x870c, 0x871c, 0x872c,
	0x873d, 0x874d, 0x875e, 0x876f, 0x8780, 0x8790, 0x87a1, 0x87b1,
	0x87c2, 0x87d3, 0x87e4, 0x87f6, 0x8807, 0x8819, 0x882a, 0x883a,
	0x884b, 0x885b, 0x886d, 0x887e, 0x888e, 0x889e, 0x88af, 0x88bf,
	0x88d0, 0x88e1, 0x88f1, 0x8901, 0x8911, 0x8921, 0x8931, 0x8941,
	0x8951, 0x8962, 0x8976, 0x8989, 0x899d, 0x89b0, 0x89c3, 0x89d7,
	0x89ea, 0x89fe, 0x8a12, 0x8a24, 0x8a35, 0x8a47, 0x8a53, 0x8a66,
	0x8a7b, 0x8a8e, 0x8aa8, 0x8ac0, 0x8ad1, 0x8ae1, 0x8af1, 0x8b01,
	// Entry 4C80 - 4CBF
	0x8b11, 0x8b22, 0x8b34, 0x8b45, 0x8b57, 0x8b68, 0x8b7a, 0x8b8b,
	0x8b9d, 0x8baf, 0x8bc1, 0x8bd4, 0x8be6, 0x8bf9, 0x8c0c, 0x8c1e,
	0x8c2f, 0x8c41, 0x8c52, 0x8c64, 0x8c75, 0x8c86, 0x8c98, 0x8ca9,
	0x8cbb, 0x8ccc, 0x8cdd, 0x8cee, 0x8cff, 0x8d10, 0x8d21, 0x8d32,
	0x8d44, 0x8d56, 0x8d6a, 0x8d7c, 0x8d8f, 0x8da1, 0x8db4, 0x8dc6,
	0x8dd9, 0x8deb, 0x8dfe, 0x8e10, 0x8e23, 0x8e36, 0x8e4a, 0x8e5d,
	0x8e71, 0x8e85, 0x8e99, 0x8eac, 0x8ec0, 0x8ed3, 0x8ee7, 0x8efb,
	0x8f0f, 0x8f23, 0x8f38, 0x8f4c, 0x8f61, 0x8f75, 0x8f8a, 0x8f9e,
	// Entry 4CC0 - 4CFF
	0x8fb1, 0x8fc5, 0x8fd8, 0x8fec, 0x8fff, 0x9012, 0x9026, 0x9039,
	0x904d, 0x9061, 0x9074, 0x9087, 0x909a, 0x90ad, 0x90c0, 0x90d4,
	0x90e7, 0x90fa, 0x9111, 0x9128, 0x913e, 0x9155, 0x916b, 0x9182,
	0x9198, 0x91af, 0x91c5, 0x91dc, 0x91f0, 0x9205, 0x9219, 0x922c,
	0x923f, 0x9254, 0x9268, 0x927c, 0x928f, 0x92a4, 0x92b9, 0x92cd,
	0x92f2, 0x930a, 0x931f, 0x9333, 0x9343, 0x9354, 0x9364, 0x9375,
	0x9385, 0x9396, 0x93ae, 0x93c6, 0x93d7, 0x93e8, 0x93f9, 0x940a,
	0x941b, 0x942d, 0x943e, 0x9450, 0x9462, 0x9473, 0x9485, 0x9496,
	// Entry 4D00 - 4D3F
	0x94a8, 0x94ba, 0x94cc, 0x94df, 0x94f1, 0x9504, 0x9516, 0x9527,
	0x9539, 0x954a, 0x955c, 0x956d, 0x957e, 0x9590, 0x95a1, 0x95b3,
	0x95c4, 0x95d5, 0x95e6, 0x95f7, 0x9609, 0x961a, 0x962c, 0x963e,
	0x964f, 0x9660, 0x9675, 0x9687, 0x969c, 0x96b1, 0x96c5, 0x96da,
	0x96ee, 0x9703, 0x971f, 0x973c, 0x9751, 0x9766, 0x977b, 0x9790,
	0x97a3, 0x97ad, 0x97c3, 0x97d5, 0x97f2, 0x9816, 0x982f, 0x9848,
	0x9864, 0x9881, 0x989d, 0x98b8, 0x98d3, 0x98f0, 0x990c, 0x9928,
	0x9943, 0x995d, 0x9978, 0x9993, 0x99ae, 0x99c9, 0x99d6, 0x99e4,
	// Entry 4D40 - 4D7F
	0x99f1, 0x99ff, 0x9a0c, 0x9a1a, 0x9a2f, 0x9a45, 0x9a5a, 0x9a70,
	0x9a7d, 0x9a8b, 0x9a98, 0x9aa6, 0x9ab4, 0x9ac3, 0x9ad1, 0x9ae0,
	0x9aef, 0x9aff, 0x9b0d, 0x9b1c, 0x9b2a, 0x9b39, 0x9b48, 0x9b58,
	0x9b67, 0x9b77, 0x9b86, 0x9b96, 0x9ba5, 0x9bb3, 0x9bc2, 0x9bd0,
	0x9bdf, 0x9bed, 0x9bfc, 0x9c0a, 0x9c19, 0x9c27, 0x9c36, 0x9c44,
	0x9c53, 0x9c61, 0x9c6f, 0x9c7e, 0x9c8c, 0x9c9b, 0x9ca9, 0x9cb8,
	0x9cc7, 0x9cd5, 0x9ce3, 0x9cf5, 0x9d06, 0x9d18, 0x9d29, 0x9d3b,
	0x9d54, 0x9d6e, 0x9d87, 0x9da1, 0x9db2, 0x9dc4, 0x9dd5, 0x9de7,
	// Entry 4D80 - 4DBF
	0x9df7, 0x9e0c, 0x9e1e, 0x9e2f, 0x9e3e, 0x9e50, 0x9e68, 0x9e6f,
	0x9e7a, 0x9e84, 0x9e95, 0x9e9f, 0x9eae, 0x9ec4, 0x9ed3, 0x9ee1,
	0x9eef, 0x9eff, 0x9f0e, 0x9f1d, 0x9f2b, 0x9f3b, 0x9f4b, 0x9f5a,
	0x9f6f, 0x9f82, 0x9f92, 0x9fac, 0x9fb8, 0x9fc8, 0x9fd9, 0x9fe9,
	0x9ffa, 0xa00a, 0xa01b, 0xa033, 0xa04c, 0xa064, 0xa07d, 0xa08d,
	0xa09e, 0xa0ae, 0xa0bf, 0xa0d0, 0xa0e2, 0xa0f3, 0xa105, 0xa117,
	0xa128, 0xa13a, 0xa14b, 0xa15d, 0xa16f, 0xa181, 0xa194, 0xa1a6,
	0xa1b9, 0xa1cb, 0xa1dc, 0xa1ee, 0xa1ff, 0xa211, 0xa222, 0xa233,
	// Entry 4DC0 - 4DFF
	0xa245, 0xa256, 0xa268, 0xa279, 0xa28a, 0xa29b, 0xa2ac, 0xa2bd,
	0xa2cf, 0xa2e1, 0xa2f2, 0xa303, 0xa318, 0xa32c, 0xa341, 0xa355,
	0xa36a, 0xa386, 0xa3a3, 0xa3bf, 0xa3dc, 0xa3f0, 0xa40a, 0xa41f,
	0xa433, 0xa44d, 0xa462, 0xa47a, 0xa48f, 0xa4a3, 0xa4b6, 0xa4c8,
	0xa4dd, 0xa4ea, 0xa503, 0xa50d, 0xa51f, 0xa530, 0xa541, 0xa554,
	0xa566, 0xa578, 0xa589, 0xa59c, 0xa5af, 0xa5c1, 0xa5d1, 0xa5e2,
	0xa5f2, 0xa603, 0xa613, 0xa624, 0xa63c, 0xa655, 0xa66d, 0xa686,
	0xa696, 0xa6a7, 0xa6b7, 0xa6c8, 0xa6d9, 0xa6eb, 0xa6fc, 0xa70e,
	// Entry 4E00 - 4E3F
	0xa720, 0xa731, 0xa743, 0xa754, 0xa766, 0xa778, 0xa78a, 0xa79d,
	0xa7af, 0xa7c2, 0xa7d4, 0xa7e5, 0xa7f7, 0xa808, 0xa81a, 0xa82b,
	0xa83c, 0xa84e, 0xa85f, 0xa871, 0xa882, 0xa893, 0xa8a4, 0xa8b5,
	0xa8c6, 0xa8d8, 0xa8ea, 0xa8fb, 0xa90c, 0xa921, 0xa935, 0xa94a,
	0xa95e, 0xa973, 0xa98f, 0xa9ac, 0xa9c0, 0xa9d5, 0xa9e9, 0xa9fe,
	0xaa16, 0xaa2b, 0xaa3f, 0xaa52, 0xaa64, 0xaa78, 0xaa85, 0xaa99,
	0xaaae, 0xaac3, 0xaadc, 0xaaf5, 0xab0e, 0xab26, 0xab5e, 0xab94,
	0xabc7, 0xac01, 0xac3b, 0xac5b, 0xac85, 0xacaf, 0xacd9, 0xad06,
	// Entry 4E40 - 4E7F
	0xad32, 0xad5c, 0xad90, 0xadc5, 0xadec, 0xae11, 0xae37, 0xae51,
	0xae6f, 0xae8e, 0xae9b, 0xaea9, 0xaeb6, 0xaec4, 0xaed1, 0xaedf,
	0xaef4, 0xaf0a, 0xaf1f, 0xaf35, 0xaf42, 0xaf50, 0xaf5d, 0xaf6b,
	0xaf79, 0xaf88, 0xaf96, 0xafa5, 0xafb4, 0xafc2, 0xafd1, 0xafdf,
	0xafee, 0xaffd, 0xb00c, 0xb01c, 0xb02b, 0xb03b, 0xb04a, 0xb058,
	0xb067, 0xb075, 0xb084, 0xb092, 0xb0a0, 0xb0af, 0xb0bd, 0xb0cc,
	0xb0da, 0xb0e8, 0xb0f6, 0xb104, 0xb112, 0xb121, 0xb130, 0xb13e,
	0xb14c, 0xb15b, 0xb16d, 0xb17e, 0xb190, 0xb1a1, 0xb1b3, 0xb1cc,
	// Entry 4E80 - 4EBF
	0xb1e6, 0xb1ff, 0xb219, 0xb22a, 0xb23c, 0xb24d, 0xb25f, 0xb271,
	0xb282, 0xb292, 0xb2a7, 0xb2b1, 0xb2c2, 0xb2d8, 0xb2e6, 0xb2f5,
	0xb303, 0xb311, 0xb321, 0xb330, 0xb33f, 0xb34d, 0xb35d, 0xb36d,
	0xb37c, 0xb399, 0xb3b0, 0xb3d4, 0xb3f8, 0xb41c, 0xb441, 0xb46d,
	0xb485, 0xb4b2, 0xb4c7, 0xb4ea, 0xb514, 0xb545, 0xb553, 0xb562,
	0xb570, 0xb57f, 0xb58d, 0xb59c, 0xb5aa, 0xb5b9, 0xb5c7, 0xb5d6,
	0xb5e5, 0xb5f5, 0xb604, 0xb614, 0xb624, 0xb633, 0xb643, 0xb652,
	0xb662, 0xb672, 0xb682, 0xb693, 0xb6a3, 0xb6b4, 0xb6c4, 0xb6d3,
	// Entry 4EC0 - 4EFF
	0xb6e3, 0xb6f2, 0xb702, 0xb711, 0xb720, 0xb730, 0xb73f, 0xb74f,
	0xb75e, 0xb76d, 0xb77c, 0xb78b, 0xb79a, 0xb7aa, 0xb7b9, 0xb7c8,
	0xb7d8, 0xb7eb, 0xb7fd, 0xb810, 0xb822, 0xb835, 0xb847, 0xb85a,
	0xb86c, 0xb87f, 0xb891, 0xb8a4, 0xb8b5, 0xb8c5, 0xb8dd, 0xb8ed,
	0xb8fc, 0xb90b, 0xb91c, 0xb92c, 0xb93c, 0xb94b, 0xb95c, 0xb96d,
	0xb97d, 0xb98b, 0xb99a, 0xb9a9, 0xb9b7, 0xb9c5, 0xb9dd, 0xb9eb,
	0xb9fa, 0xba08, 0xba16, 0xba24, 0xba33, 0xba42, 0xba50, 0xba5e,
	0xba6c, 0xba7b, 0xba89, 0xba96, 0xbaa4, 0xbab3, 0xbac1, 0xbad9,
	// Entry 4F00 - 4F3F
	0xbae8, 0xbaf7, 0xbb06, 0xbb1e, 0xbb3b, 0xbb58, 0xbb7e, 0xbb8f,
	0xbba1, 0xbbb2, 0xbbc4, 0xbbd5, 0xbbe7, 0xbbf8, 0xbc0a, 0xbc1b,
	0xbc2d, 0xbc3f, 0xbc4f, 0xbc5e, 0xbc6c, 0xbc7a, 0xbc8a, 0xbc99,
	0xbca8, 0xbcb6, 0xbcc6, 0xbcd6, 0xbce5, 0xbcf4, 0xbd06, 0xbd1d,
	0xbd2e, 0xbd3d, 0xbd4b, 0xbd59, 0xbd68, 0xbd76, 0xbd85, 0xbd93,
	0xbda2, 0xbdb0, 0xbdbf, 0xbdcd, 0xbddc, 0xbdeb, 0xbdfb, 0xbe0a,
	0xbe1a, 0xbe2a, 0xbe39, 0xbe49, 0xbe58, 0xbe68, 0xbe78, 0xbe88,
	0xbe99, 0xbea9, 0xbeba, 0xbeca, 0xbed9, 0xbee9, 0xbef8, 0xbf08,
	// Entry 4F40 - 4F7F
	0xbf17, 0xbf26, 0xbf36, 0xbf45, 0xbf55, 0xbf64, 0xbf73, 0xbf82,
	0xbf91, 0xbfa0, 0xbfb0, 0xbfc0, 0xbfcf, 0xbfde, 0xbfee, 0xc001,
	0xc013, 0xc026, 0xc038, 0xc04b, 0xc065, 0xc080, 0xc092, 0xc0a5,
	0xc0b7, 0xc0ca, 0xc0dd, 0xc0ef, 0xc100, 0xc110, 0xc127, 0xc146,
	0xc162, 0xc17f, 0xc19c, 0xc1b9, 0xc1d6, 0xc1f3, 0xc210, 0xc22c,
	0xc248, 0xc266, 0xc283, 0xc2a0, 0xc2be, 0xc2dc, 0xc2f9, 0xc317,
	0xc335, 0xc353, 0xc372, 0xc38f, 0xc3ac, 0xc3c9, 0xc3e6, 0xc403,
	0xc422, 0xc441, 0xc460, 0xc47e, 0xc49d, 0xc4bb, 0xc4da, 0xc4f7,
	// Entry 4F80 - 4FBF
	0xc511, 0xc52c, 0xc547, 0xc562, 0xc57d, 0xc598, 0xc5b3, 0xc5cd,
	0xc5e7, 0xc603, 0xc61e, 0xc639, 0xc655, 0xc671, 0xc68c, 0xc6a8,
	0xc6c4, 0xc6e0, 0xc6fd, 0xc718, 0xc733, 0xc74e, 0xc769, 0xc784,
	0xc7a1, 0xc7be, 0xc7db, 0xc7f7, 0xc814, 0xc830, 0xc84d, 0xc863,
	0xc878, 0xc88d, 0xc8a4, 0xc8ba, 0xc8d0, 0xc8e5, 0xc8fc, 0xc913,
	0xc929, 0xc93f, 0xc958, 0xc971, 0xc989, 0xc9a1, 0xc9b9, 0xc9d3,
	0xc9ec, 0xca05, 0xca13, 0xca27, 0xca3c, 0xca50, 0xca65, 0xca79,
	0xca8e, 0xcaaa, 0xcac7, 0xcadb, 0xcaf0, 0xcb04, 0xcb19, 0xcb2e,
	// Entry 4FC0 - 4FFF
	0xcb44, 0xcb59, 0xcb6f, 0xcb85, 0xcb9a, 0xcbb0, 0xcbc5, 0xcbdb,
	0xcbf1, 0xcc07, 0xcc1e, 0xcc34, 0xcc4b, 0xcc61, 0xcc76, 0xcc8c,
	0xcca1, 0xccb7, 0xcccc, 0xcce1, 0xccf7, 0xcd0c, 0xcd22, 0xcd37,
	0xcd4c, 0xcd61, 0xcd76, 0xcd8b, 0xcda1, 0xcdb7, 0xcdcc, 0xcde1,
	0xcdf7, 0xce0d, 0xce26, 0xce3e, 0xce57, 0xce6f, 0xce88, 0xcea8,
	0xcec9, 0xcee1, 0xcefa, 0xcf12, 0xcf2b, 0xcf44, 0xcf5c, 0xcf73,
	0xcf8c, 0xcfa4, 0xcfba, 0xcfe0, 0xcff9, 0xd016, 0xd034, 0xd051,
	0xd06e, 0xd08c, 0xd0a9, 0xd0c7, 0xd0e5, 0xd10b, 0xd12d, 0xd147,
	// Entry 5000 - 503F
	0xd162, 0xd17c, 0xd197, 0xd1b2, 0xd1cc, 0xd1e7, 0xd201, 0xd21c,
	0xd237, 0xd253, 0xd26e, 0xd28a, 0xd2a5, 0xd2bf, 0xd2da, 0xd2f4,
	0xd30f, 0xd329, 0xd343, 0xd35e, 0xd378, 0xd393, 0xd3ad, 0xd3c8,
	0xd3e4, 0xd3ff, 0xd41b, 0xd436, 0xd450, 0xd46a, 0xd484, 0xd49e,
	0xd4b8, 0xd4d2, 0xd4ed, 0xd508, 0xd522, 0xd53c, 0xd558, 0xd57d,
	0xd599, 0xd5ba, 0xd5e9, 0xd613, 0xd631, 0xd64e, 0xd678, 0xd6a0,
	0xd6c8, 0xd6f0, 0xd718, 0xd73a, 0xd75c, 0xd777, 0xd791, 0xd7b2,
	0xd7d2, 0xd801, 0xd830, 0xd84a, 0xd85a, 0xd86e, 0xd883, 0xd897,
	// Entry 5040 - 507F
	0xd8ab, 0xd8bf, 0xd8d4, 0xd8e9, 0xd8fe, 0xd91a, 0xd936, 0xd94f,
	0xd960, 0xd972, 0xd983, 0xd995, 0xd9a7, 0xd9b8, 0xd9ca, 0xd9db,
	0xd9ed, 0xd9ff, 0xda11, 0xda24, 0xda36, 0xda49, 0xda5b, 0xda6c,
	0xda7e, 0xda8f, 0xdaa1, 0xdab2, 0xdac3, 0xdad5, 0xdae6, 0xdaf8,
	0xdb09, 0xdb1b, 0xdb2e, 0xdb40, 0xdb52, 0xdb63, 0xdb74, 0xdb85,
	0xdb96, 0xdba7, 0xdbb8, 0xdbca, 0xdbdc, 0xdbed, 0xdbfe, 0xdc11,
	0xdc29, 0xdc41, 0xdc62, 0xdc83, 0xdca5, 0xdcc6, 0xdce4, 0xdd02,
	0xdd21, 0xdd3f, 0xdd5d, 0xdd7b, 0xdd99, 0xddb7, 0xddd5, 0xddf4,
	// Entry 5080 - 50BF
	0xde12, 0xde31, 0xde46, 0xde5a, 0xde71, 0xde82, 0xde94, 0xdea5,
	0xdebd, 0xdecf, 0xdf03, 0xdf30, 0xdf53, 0xdf6a, 0xdf81, 0xdf96,
	0xdfab, 0xdfc0, 0xdfd5, 0xdfea, 0xdfff, 0xe014, 0xe02a, 0xe03f,
	0xe054, 0xe06a, 0xe07f, 0xe094, 0xe0a9, 0xe0be, 0xe0d4, 0xe0e9,
	0xe0ff, 0xe114, 0xe129, 0xe13f, 0xe153, 0xe167, 0xe17b, 0xe18f,
	0xe1a3, 0xe1b8, 0xe1cd, 0xe1e7, 0xe201, 0xe21b, 0xe235, 0xe24f,
	0xe269, 0xe283, 0xe29e, 0xe2b8, 0xe2d4, 0xe2eb, 0xe30a, 0xe32c,
	0xe349, 0xe36e, 0xe38a, 0xe3a1, 0xe3c3, 0xe3e0, 0xe3fa, 0xe41a,
	// Entry 50C0 - 50FF
	0xe43f, 0xe45f, 0xe480, 0xe49c, 0xe4b4, 0xe4db, 0xe4fd, 0xe51b,
	0xe52d, 0xe540, 0xe552, 0xe565, 0xe577, 0xe58a, 0xe5a4, 0xe5bf,
	0xe5d9, 0xe5eb, 0xe5fe, 0xe610, 0xe623, 0xe636, 0xe64a, 0xe65d,
	0xe671, 0xe685, 0xe698, 0xe6ac, 0xe6bf, 0xe6d3, 0xe6e7, 0xe6fb,
	0xe710, 0xe724, 0xe739, 0xe74d, 0xe760, 0xe774, 0xe787, 0xe79b,
	0xe7ae, 0xe7c1, 0xe7d5, 0xe7e8, 0xe7fc, 0xe80f, 0xe822, 0xe835,
	0xe848, 0xe85b, 0xe86f, 0xe883, 0xe896, 0xe8a9, 0xe8c0, 0xe8d6,
	0xe8ed, 0xe903, 0xe91a, 0xe938, 0xe957, 0xe975, 0xe98b, 0xe9a2,
	// Entry 5100 - 513F
	0xe9b8, 0xe9cf, 0xe9e9, 0xea00, 0xea16, 0xea2b, 0xea42, 0xea51,
	0xea67, 0xea7f, 0xea95, 0xeaab, 0xeabf, 0xead2, 0xeae5, 0xeafa,
	0xeb0e, 0xeb22, 0xeb35, 0xeb4a, 0xeb5f, 0xeb73, 0xeb87, 0xeb9b,
	0xebb1, 0xebc6, 0xebdb, 0xebef, 0xec05, 0xec1b, 0xec30, 0xec44,
	0xec5b, 0xec72, 0xec88, 0xec9e, 0xecb4, 0xeccc, 0xece3, 0xecfa,
	0xed16, 0xed27, 0xed38, 0xed49, 0xed5b, 0xed6c, 0xed7e, 0xed8f,
	0xeda1, 0xedb2, 0xedc4, 0xedd5, 0xede7, 0xedf8, 0xee09, 0xee1a,
	0xee2c, 0xee3d, 0xee4e, 0xee60, 0xee73, 0xee85, 0xee96, 0xeea8,
	// Entry 5140 - 517F
	0xeeb9, 0xeeca, 0xeedb, 0xeeec, 0xeefd, 0xef0f, 0xef20, 0xef31,
	0xef41, 0xef5c, 0xef78, 0xef93, 0xefaf, 0xefca, 0xefe6, 0xf001,
	0xf01d, 0xf038, 0xf054, 0xf06f, 0xf08a, 0xf0a5, 0xf0c1, 0xf0dc,
	0xf0f7, 0xf113, 0xf130, 0xf14c, 0xf167, 0xf183, 0xf19e, 0xf1b9,
	0xf1d4, 0xf1ef, 0xf20b, 0xf226, 0xf241, 0xf25b, 0xf270, 0xf284,
	0xf298, 0xf2ac, 0xf2c0, 0xf2d5, 0xf2ed, 0xf303, 0xf31a, 0xf330,
	0xf347, 0xf35d, 0xf374, 0xf38a, 0xf3a1, 0xf3b7, 0xf3ce, 0xf3e5,
	0xf3fd, 0xf414, 0xf42c, 0xf444, 0xf45b, 0xf473, 0xf48a, 0xf4a2,
	// Entry 5180 - 51BF
	0xf4ba, 0xf4d2, 0xf4eb, 0xf503, 0xf51c, 0xf534, 0xf54b, 0xf563,
	0xf57a, 0xf592, 0xf5a9, 0xf5c0, 0xf5d8, 0xf5ef, 0xf607, 0xf61e,
	0xf635, 0xf64c, 0xf663, 0xf67a, 0xf692, 0xf6aa, 0xf6c1, 0xf6d8,
	0xf6f0, 0xf709, 0xf722, 0xf73a, 0xf755, 0xf76f, 0xf78a, 0xf7a4,
	0xf7bf, 0xf7e1, 0xf7fb, 0xf816, 0xf830, 0xf84b, 0xf866, 0xf880,
	0xf898, 0xf8b1, 0xf8cb, 0xf8df, 0xf8f2, 0xf907, 0xf91f, 0xf936,
	0xf94d, 0xf966, 0xf97e, 0xf996, 0xf9ad, 0xf9c6, 0xf9df, 0xf9f7,
	0xfa0d, 0xfa24, 0xfa3a, 0xfa51, 0xfa67, 0xfa7e, 0xfa95, 0xfaac,
	// Entry 51C0 - 51FF
	0xfac3, 0xfada, 0xfaf1, 0xfb08, 0xfb1f, 0xfb37, 0xfb4e, 0xfb65,
	0xfb7d, 0xfb94, 0xfbac, 0xfbc3, 0xfbda, 0xfbf2, 0xfc09, 0xfc21,
	0xfc38, 0xfc4f, 0xfc67, 0xfc7f, 0xfc98, 0xfcb0, 0xfcc7, 0xfcdf,
	0xfcf7, 0xfd10, 0xfd28, 0xfd3f, 0xfd57, 0xfd6e, 0xfd85, 0xfd9c,
	0xfdb7, 0xfdd1, 0xfdec, 0xfe06, 0xfe21, 0xfe3c, 0xfe57, 0xfe72,
	0xfe8d, 0xfea8, 0xfec2, 0xfed6, 0xfee6, 0xfefe, 0xff15, 0xff2c,
	0xff45, 0xff5d, 0xff75, 0xff8c, 0xffa5, 0xffbe, 0xffd6, 0xffe7,
	0xfff8, 0x000a, 0x001b, 0x002c, 0x003d, 0x004e, 0x005f, 0x0070,
	// Entry 5200 - 523F
	0x0081, 0x0092, 0x00a4, 0x00b5, 0x00c6, 0x00d7, 0x00e8, 0x00f9,
	0x0109, 0x0116, 0x012a, 0x013e, 0x0152, 0x0166, 0x0178, 0x018e,
	0x01bc, 0x01e7, 0x0203, 0x0222, 0x023d, 0x025d, 0x027c, 0x029e,
	0x02ba, 0x02d8, 0x02f6, 0x030e, 0x0327, 0x0346, 0x0365, 0x037d,
	0x0397, 0x03b0, 0x03c9, 0x03e6, 0x040d, 0x041b, 0x042c, 0x0440,
	0x0452, 0x0468, 0x0479, 0x048c, 0x04a0, 0x04b0, 0x04c0, 0x04ce,
	0x04e1, 0x04f2, 0x0502, 0x0511, 0x052b, 0x0545, 0x0554, 0x0567,
	0x0584, 0x05a1, 0x05b3, 0x05c5, 0x05d5, 0x05e5, 0x05fd, 0x0615,
	// Entry 5240 - 527F
	0x0629, 0x063e, 0x065b, 0x066b, 0x0683, 0x069d, 0x06bd, 0x06d6,
	0x06f0, 0x0711, 0x072c, 0x0746, 0x0757, 0x0768, 0x0784, 0x07a5,
	0x07c0, 0x07e1, 0x07fb, 0x081b, 0x0837, 0x0854, 0x0871, 0x0898,
	0x08ae, 0x08c0, 0x08de, 0x0900, 0x0923, 0x0940, 0x095d, 0x096e,
	0x097f, 0x099c, 0x09c3, 0x09d4, 0x09ee, 0x0a0a, 0x0a26, 0x0a40,
	0x0a5c, 0x0a76, 0x0a91, 0x0aac, 0x0abf, 0x0ad3, 0x0ae6, 0x0b03,
	0x0b14, 0x0b2d, 0x0b4a, 0x0b7b, 0x0b9e, 0x0bb2, 0x0bc5, 0x0bd8,
	0x0bf5, 0x0c09, 0x0c1d, 0x0c2f, 0x0c4b, 0x0c67, 0x0ca4, 0x0cc8,
	// Entry 5280 - 52BF
	0x0d0b, 0x0d1e, 0x0d33, 0x0d44, 0x0d56, 0x0d69, 0x0d7e, 0x0d90,
	0x0dab, 0x0dbf, 0x0dd1, 0x0de5, 0x0df6, 0x0e0f, 0x0e2a, 0x0e4a,
	0x0e5b, 0x0e77, 0x0e93, 0x0eb0, 0x0ec4, 0x0ee3, 0x0ef5, 0x0f08,
	0x0f19, 0x0f2b, 0x0f56, 0x0f7a, 0x0f9f, 0x0fc1, 0x0fe3, 0x100f,
	0x1031, 0x1055, 0x1078, 0x109a, 0x10bc, 0x10e6, 0x1109, 0x112b,
	0x114d, 0x117a, 0x119d, 0x11bf, 0x11eb, 0x120d, 0x1231, 0x125d,
	0x1280, 0x1292, 0x12a4, 0x12b8, 0x12cc, 0x12dd, 0x12ef, 0x1301,
	0x131d, 0x1330, 0x1342, 0x1367, 0x137a, 0x138b, 0x13a4, 0x13ba,
	// Entry 52C0 - 52FF
	0x13d3, 0x13e5, 0x1402, 0x1415, 0x1427, 0x143b, 0x144d, 0x145f,
	0x1472, 0x148a, 0x14a7, 0x14ba, 0x14cd, 0x14dd, 0x14f7, 0x151b,
	0x152c, 0x1555, 0x1570, 0x158a, 0x15a5, 0x15c0, 0x15d9, 0x15ec,
	0x15ff, 0x1610, 0x1621, 0x163d, 0x165e, 0x1678, 0x1695, 0x16b2,
	0x16cb, 0x16de, 0x16f2, 0x1705, 0x1718, 0x1733, 0x1757, 0x1785,
	0x17a1, 0x17be, 0x17e1, 0x1809, 0x1825, 0x1846, 0x1868, 0x1888,
	0x18b0, 0x18cd, 0x18e9, 0x1910, 0x192c, 0x1948, 0x1964, 0x1980,
	0x1991, 0x19a7, 0x19b9, 0x19e3, 0x1a05, 0x1a28, 0x1a52, 0x1a6d,
	// Entry 5300 - 533F
	0x1a89, 0x1aaf, 0x1acb, 0x1aef, 0x1b0b, 0x1b2f, 0x1b4a, 0x1b65,
	0x1b8b, 0x1ba7, 0x1bc2, 0x1be5, 0x1c00, 0x1c2b, 0x1c4d, 0x1c69,
	0x1c84, 0x1ca0, 0x1cc3, 0x1ce8, 0x1d15, 0x1d31, 0x1d55, 0x1d78,
	0x1d95, 0x1db6, 0x1de3, 0x1dff, 0x1e1e, 0x1e3a, 0x1e5f, 0x1e83,
	0x1e9e, 0x1ec1, 0x1edc, 0x1ef8, 0x1f1d, 0x1f38, 0x1f54, 0x1f70,
	0x1f8c, 0x1fb1, 0x1fce, 0x1fea, 0x2007, 0x2021, 0x203c, 0x205f,
	0x207a, 0x208d, 0x20ae, 0x20c0, 0x20e8, 0x20fa, 0x2126, 0x213a,
	0x214c, 0x215e, 0x2171, 0x2189, 0x21a6, 0x21c7, 0x21d9, 0x21ec,
	// Entry 5340 - 537F
	0x2201, 0x2217, 0x2237, 0x2248, 0x2261, 0x227a, 0x2297, 0x22a9,
	0x22c4, 0x22e3, 0x22f7, 0x230a, 0x2322, 0x2335, 0x2359, 0x237c,
	0x2399, 0x23be, 0x23da, 0x23ee, 0x2401, 0x2422, 0x243f, 0x245d,
	0x2475, 0x2486, 0x24a3, 0x24b5, 0x24d1, 0x24fc, 0x2518, 0x253e,
	0x2555, 0x2567, 0x258a, 0x25a6, 0x25c7, 0x25d9, 0x25eb, 0x2607,
	0x2619, 0x262c, 0x2640, 0x2655, 0x2666, 0x267c, 0x2692, 0x26a4,
	0x26b5, 0x26d0, 0x26ec, 0x2707, 0x2723, 0x273e, 0x2759, 0x2774,
	0x278f, 0x27a8, 0x27b9, 0x27cc, 0x27e8, 0x2805, 0x2825, 0x2843,
	// Entry 5380 - 53BF
	0x285f, 0x2872, 0x2882, 0x2894, 0x28a5, 0x28b8, 0x28d9, 0x28fe,
	0x290f, 0x2921, 0x2937, 0x294c, 0x2981, 0x2998, 0x29a9, 0x29ca,
	0x29dc, 0x29ed, 0x2a09, 0x2a26, 0x2a43, 0x2a5c, 0x2a6f, 0x2a80,
	0x2a91, 0x2aa3, 0x2ab4, 0x2acd, 0x2ae7, 0x2b0a, 0x2b26, 0x2b41,
	0x2b5e, 0x2b79, 0x2b93, 0x2bb0, 0x2bcc, 0x2be6, 0x2c01, 0x2c22,
	0x2c3d, 0x2c69, 0x2c83, 0x2c9f, 0x2cc4, 0x2cee, 0x2d08, 0x2d24,
	0x2d3f, 0x2d59, 0x2d74, 0x2d8e, 0x2da9, 0x2dc3, 0x2ddd, 0x2df7,
	0x2e19, 0x2e3b, 0x2e5d, 0x2e77, 0x2e9c, 0x2eb6, 0x2ed1, 0x2eeb,
	// Entry 53C0 - 53FF
	0x2f05, 0x2f1f, 0x2f3a, 0x2f55, 0x2f70, 0x2f8c, 0x2fa7, 0x2fc2,
	0x2fdf, 0x2ffa, 0x3013, 0x302d, 0x3047, 0x306c, 0x3087, 0x30a1,
	0x30b3, 0x30d2, 0x30e4, 0x30f7, 0x310a, 0x311d, 0x3130, 0x314d,
	0x315f, 0x3180, 0x3192, 0x31ae, 0x31cd, 0x31e0, 0x31f3, 0x3208,
	0x323e, 0x3280, 0x3294, 0x32a5, 0x32c0, 0x32d9, 0x32f3, 0x3305,
	0x3317, 0x332b, 0x333e, 0x3353, 0x3374, 0x3385, 0x33bf, 0x33d1,
	0x33e3, 0x3402, 0x3414, 0x3426, 0x343d, 0x344f, 0x3461, 0x3480,
	0x3495, 0x34aa, 0x34bb, 0x34cf, 0x34eb, 0x3517, 0x353c, 0x3561,
	// Entry 5400 - 543F
	0x357e, 0x359b, 0x35c3, 0x35e1, 0x35fe, 0x361c, 0x3639, 0x3656,
	0x3674, 0x3692, 0x36b9, 0x36d6, 0x36f4, 0x371b, 0x373e, 0x375b,
	0x3780, 0x37a5, 0x37c2, 0x37e0, 0x37fe, 0x381c, 0x3849, 0x3869,
	0x3888, 0x38a5, 0x38c3, 0x38e0, 0x3905, 0x3924, 0x3941, 0x3968,
	0x399d, 0x39cc, 0x39eb, 0x3a14, 0x3a32, 0x3a50, 0x3a6f, 0x3aa3,
	0x3abf, 0x3ae2, 0x3b0c, 0x3b32, 0x3b4f, 0x3b6d, 0x3b89, 0x3b9d,
	0x3bbb, 0x3be2, 0x3bfb, 0x3c28, 0x3c3d, 0x3c4f, 0x3c6b, 0x3c7d,
	0x3c99, 0x3cbd, 0x3cce, 0x3ce0, 0x3cf5, 0x3d08, 0x3d19, 0x3d34,
	// Entry 5440 - 547F
	0x3d46, 0x3d61, 0x3d7d, 0x3d9a, 0x3dbc, 0x3dde, 0x3e03, 0x3e1e,
	0x3e3b, 0x3e58, 0x3e7e, 0x3e99, 0x3ebd, 0x3edb, 0x3efe, 0x3f19,
	0x3f34, 0x3f58, 0x3f7d, 0x3f9a, 0x3fb1, 0x3fd0, 0x3fef, 0x4009,
	0x4023, 0x4035, 0x4049, 0x4068, 0x408b, 0x40a7, 0x40b9, 0x40cb,
	0x40dd, 0x40f8, 0x4120, 0x4131, 0x414d, 0x4163, 0x4175, 0x4187,
	0x4199, 0x41ac, 0x41c0, 0x41d1, 0x41e3, 0x41f4, 0x4206, 0x4217,
	0x4230, 0x4242, 0x4259, 0x426e, 0x4283, 0x4296, 0x42b1, 0x42ce,
	0x42ea, 0x4307, 0x4334, 0x4355, 0x4369, 0x4385, 0x43a9, 0x43c6,
	// Entry 5480 - 54BF
	0x43df, 0x43f0, 0x4402, 0x4415, 0x4431, 0x4453, 0x4474, 0x4488,
	0x44a2, 0x44b4, 0x44c7, 0x44d8, 0x44f1, 0x450b, 0x4524, 0x4535,
	0x454e, 0x4560, 0x4572, 0x4594, 0x45bf, 0x45d4, 0x45f2, 0x4611,
	0x4639, 0x4658, 0x4685, 0x46a3, 0x46c2, 0x46e1, 0x470a, 0x4732,
	0x4763, 0x478a, 0x47a9, 0x47bd, 0x47ce, 0x47e1, 0x47f3, 0x4815,
	0x4838, 0x485a, 0x4895, 0x48b7, 0x48ce, 0x48e9, 0x4908, 0x4938,
	0x494c, 0x4971, 0x4992, 0x49b4, 0x49d6, 0x49fd, 0x4a20, 0x4a41,
	0x4a62, 0x4a86, 0x4aa7, 0x4acb, 0x4af1, 0x4b02, 0x4b14, 0x4b26,
	// Entry 54C0 - 54FF
	0x4b38, 0x4b4c, 0x4b5d, 0x4b76, 0x4b90, 0x4baa, 0x4bc4, 0x4bdd,
	0x4bf6, 0x4c10, 0x4c29, 0x4c43, 0x4c60, 0x4c74, 0x4c92, 0x4caf,
	0x4ccc, 0x4cef, 0x4d00, 0x4d12, 0x4d23, 0x4d34, 0x4d45, 0x4d5f,
	0x4d71, 0x4d8b, 0x4da6, 0x4dc2, 0x4ddd, 0x4df9, 0x4e15, 0x4e31,
	0x4e4c, 0x4e68, 0x4e84, 0x4ea1, 0x4ebd, 0x4ed8, 0x4ef3, 0x4f0e,
	0x4f29, 0x4f45, 0x4f60, 0x4f77, 0x4f89, 0x4fac, 0x4fc1, 0x4fd3,
	0x4fe5, 0x4ff8, 0x5013, 0x5030, 0x504e, 0x506a, 0x5088, 0x50a5,
	0x50c0, 0x50e2, 0x50f5, 0x5109, 0x511d, 0x512f, 0x5144, 0x5179,
	// Entry 5500 - 553F
	0x51ae, 0x51c2, 0x51d5, 0x51e9, 0x51fe, 0x5215, 0x5228, 0x5243,
	0x525f, 0x5272, 0x528d, 0x52aa, 0x52c9, 0x52e6, 0x5303, 0x5320,
	0x5342, 0x5362, 0x537f, 0x539c, 0x53b9, 0x53ce, 0x53e1, 0x53f9,
	0x5423, 0x5437, 0x5449, 0x546d, 0x5480, 0x5495, 0x54a6, 0x54bc,
	0x54ce, 0x54e1, 0x5503, 0x5516, 0x552a, 0x553b, 0x5554, 0x5566,
	0x5579, 0x558d, 0x559f, 0x55b4, 0x55c6, 0x55d9, 0x55ea, 0x5604,
	0x561e, 0x5638, 0x564e, 0x5660, 0x5695, 0x56af, 0x56c1, 0x56dc,
	0x56f8, 0x5714, 0x5730, 0x574d, 0x5768, 0x577b, 0x578d, 0x579e,
	// Entry 5540 - 557F
	0x57b4, 0x57c5, 0x57db, 0x57ed, 0x57ff, 0x581c, 0x5837, 0x586c,
	0x587d, 0x5890, 0x58a2, 0x58b4, 0x58c6, 0x58ec, 0x58fc, 0x5910,
	0x5924, 0x5953, 0x5977, 0x59a9, 0x59ba, 0x59cb, 0x59dc, 0x59f4,
	0x5a0f, 0x5a29, 0x5a50, 0x5a7c, 0x5a92, 0x5aab, 0x5ace, 0x5ae1,
	0x5af2, 0x5b0f, 0x5b31, 0x5b4d, 0x5b66, 0x5b7a, 0x5b8d, 0x5bad,
	0x5bc9, 0x5bda, 0x5bf0, 0x5c01, 0x5c1e, 0x5c37, 0x5c49, 0x5c6b,
	0x5c8d, 0x5ca8, 0x5cc3, 0x5cdf, 0x5cfa, 0x5d1e, 0x5d41, 0x5d53,
	0x5d65, 0x5d78, 0x5d8a, 0x5da4, 0x5dc3, 0x5ddf, 0x5dfb, 0x5e16,
	// Entry 5580 - 55BF
	0x5e32, 0x5e54, 0x5e70, 0x5e8b, 0x5ea6, 0x5ec2, 0x5edd, 0x5ef9,
	0x5f14, 0x5f30, 0x5f4c, 0x5f67, 0x5f83, 0x5fa0, 0x5fbb, 0x5fde,
	0x5ff9, 0x6017, 0x602b, 0x6047, 0x6059, 0x6073, 0x608e, 0x60aa,
	0x60c7, 0x60da, 0x60ed, 0x6102, 0x6116, 0x6128, 0x6147, 0x6159,
	0x616a, 0x6180, 0x61a3, 0x61b5, 0x61c8, 0x61da, 0x61eb, 0x6204,
	0x6216, 0x6228, 0x6244, 0x6256, 0x6269, 0x627a, 0x628c, 0x62a6,
	0x62ba, 0x62cc, 0x62e6, 0x6301, 0x631b, 0x6338, 0x6364, 0x6377,
	0x6393, 0x63af, 0x63cc, 0x63e9, 0x6414, 0x6431, 0x6444, 0x6456,
	// Entry 55C0 - 55FF
	0x6469, 0x6486, 0x64a2, 0x64be, 0x64d9, 0x64fe, 0x6519, 0x6533,
	0x654f, 0x6569, 0x6584, 0x65a1, 0x65c5, 0x65eb, 0x6607, 0x661a,
	0x6637, 0x6649, 0x665b, 0x666e, 0x668d, 0x66ab, 0x66d5, 0x66f2,
	0x6705, 0x6726, 0x6738, 0x6752, 0x6764, 0x6782, 0x67a2, 0x67c1,
	0x67e0, 0x67fe, 0x681e, 0x683e, 0x685d, 0x687e, 0x689e, 0x68be,
	0x68dd, 0x68fe, 0x691f, 0x693f, 0x695c, 0x6979, 0x6995, 0x69b3,
	0x69d1, 0x69ee, 0x6a0e, 0x6a2e, 0x6a50, 0x6a71, 0x6a92, 0x6ab2,
	0x6ad4, 0x6af6, 0x6b17, 0x6b37, 0x6b57, 0x6b79, 0x6b9a, 0x6bbb,
	// Entry 5600 - 563F
	0x6bdb, 0x6bfd, 0x6c2c, 0x6c4d, 0x6c6e, 0x6c8e, 0x6cb0, 0x6cd2,
	0x6cf3, 0x6d13, 0x6d33, 0x6d55, 0x6d84, 0x6da5, 0x6dc6, 0x6df6,
	0x6e25, 0x6e44, 0x6e63, 0x6e84, 0x6eb2, 0x6ed2, 0x6ef2, 0x6f21,
	0x6f50, 0x6f7e, 0x6fad, 0x6fdd, 0x700d, 0x7039, 0x7068, 0x7098,
	0x70c8, 0x70f6, 0x7125, 0x7154, 0x7184, 0x71b4, 0x71e5, 0x7208,
	0x722d, 0x7251, 0x7275, 0x7298, 0x72b7, 0x72d6, 0x72f7, 0x7317,
	0x7344, 0x7364, 0x7391, 0x73b1, 0x73d1, 0x73f1, 0x7411, 0x7436,
	0x745c, 0x7483, 0x74b2, 0x74e2, 0x7507, 0x752d, 0x755a, 0x7589,
	// Entry 5640 - 567F
	0x75af, 0x75d2, 0x75fa, 0x7623, 0x7647, 0x766b, 0x7695, 0x76bf,
	0x76e8, 0x7713, 0x773e, 0x7768, 0x779c, 0x77c5, 0x77ee, 0x781a,
	0x7847, 0x7867, 0x7883, 0x789f, 0x78c1, 0x78e0, 0x78fe, 0x791c,
	0x793f, 0x795b, 0x7977, 0x7993, 0x79b1, 0x79cd, 0x79eb, 0x7a07,
	0x7a2b, 0x7a47, 0x7a63, 0x7a81, 0x7a9c, 0x7ab7, 0x7ad9, 0x7af6,
	0x7b11, 0x7b2c, 0x7b4d, 0x7b6c, 0x7b88, 0x7ba7, 0x7bd2, 0x7bf2,
	0x7c0e, 0x7c34, 0x7c5a, 0x7c77, 0x7c93, 0x7cae, 0x7cc9, 0x7ce4,
	0x7d00, 0x7d20, 0x7d3b, 0x7d56, 0x7d6c, 0x7d8d, 0x7db2, 0x7dd6,
	// Entry 5680 - 56BF
	0x7e00, 0x7e24, 0x7e49, 0x7e6d, 0x7e92, 0x7eb6, 0x7ed2, 0x7ef1,
	0x7f12, 0x7f3d, 0x7f66, 0x7f83, 0x7f9e, 0x7fc2, 0x7fe6, 0x8008,
	0x8033, 0x804f, 0x8075, 0x8091, 0x80ae, 0x80c9, 0x80ec, 0x810f,
	0x812c, 0x8149, 0x8173, 0x8191, 0x81bd, 0x81de, 0x8205, 0x8220,
	0x824d, 0x8267, 0x8281, 0x829e, 0x82b8, 0x82dd, 0x82f3, 0x8309,
	0x831f, 0x8335, 0x834b, 0x8361, 0x8377, 0x839f, 0x83b5, 0x83d8,
	0x83ee, 0x8404, 0x841a, 0x8430, 0x8446, 0x845c, 0x8472, 0x8488,
	0x849e, 0x84b4, 0x84ca, 0x84e0, 0x84f6, 0x850c, 0x8522, 0x8538,
	// Entry 56C0 - 56FF
	0x854e, 0x8564, 0x857a, 0x8599, 0x85b9, 0x85e2, 0x8614, 0x863b,
	0x8651, 0x8667, 0x867d, 0x8693, 0x86a9, 0x86bf, 0x86d5, 0x86eb,
	0x8701, 0x8717, 0x872d, 0x874d, 0x876d, 0x8798, 0x87b8, 0x87d7,
	0x87f7, 0x8816, 0x8835, 0x8854, 0x8876, 0x888c, 0x88a2, 0x88c2,
	0x88e1, 0x8901, 0x8926, 0x8945, 0x8977, 0x89a1, 0x89c0, 0x89e2,
	0x89f8, 0x8a0e, 0x8a2f, 0x8a4c, 0x8a68, 0x8a84, 0x8ab2, 0x8acf,
	0x8ae9, 0x8b0f, 0x8b36, 0x8b5a, 0x8b7a, 0x8b99, 0x8bb7, 0x8bd8,
	0x8bfb, 0x8c1b, 0x8c43, 0x8c60, 0x8c84, 0x8ca5, 0x8cc5, 0x8ce0,
	// Entry 5700 - 573F
	0x8d04, 0x8d21, 0x8d39, 0x8d54, 0x8d70, 0x8d8c, 0x8da7, 0x8dcc,
	0x8df0, 0x8e0c, 0x8e28, 0x8e4a, 0x8e6d, 0x8e88, 0x8ea3, 0x8ec1,
	0x8ee1, 0x8efd, 0x8f0f, 0x8f31, 0x8f59, 0x8f71, 0x8f89, 0x8fa1,
	0x8fb9, 0x8fd1, 0x8fea, 0x9002, 0x901b, 0x9034, 0x904c, 0x9064,
	0x907c, 0x9094, 0x90ac, 0x90c4, 0x90dc, 0x90f4, 0x910d, 0x9125,
	0x913d, 0x9155, 0x916e, 0x9186, 0x919e, 0x91b6, 0x91ce, 0x91e6,
	0x91fe, 0x9216, 0x922e, 0x9246, 0x925e, 0x9276, 0x928e, 0x92a6,
	0x92be, 0x92d6, 0x92ef, 0x9307, 0x931f, 0x9337, 0x934f, 0x9367,
	// Entry 5740 - 577F
	0x937f, 0x9397, 0x93af, 0x93c8, 0x93e0, 0x93f8, 0x9411, 0x9429,
	0x9442, 0x945a, 0x9472, 0x948b, 0x94a3, 0x94bb, 0x94d3, 0x94eb,
	0x9503, 0x951b, 0x9533, 0x954b, 0x9563, 0x957b, 0x9593, 0x95ab,
	0x95c3, 0x95db, 0x95f3, 0x960b, 0x9623, 0x963b, 0x9653, 0x966b,
	0x9683, 0x969b, 0x96b3, 0x96cb, 0x96e3, 0x96fb, 0x9713, 0x972b,
	0x9743, 0x975b, 0x9774, 0x978c, 0x97a4, 0x97bc, 0x97d4, 0x97ec,
	0x9804, 0x981d, 0x9836, 0x984f, 0x9867, 0x987f, 0x9897, 0x98af,
	0x98c7, 0x98df, 0x98f7, 0x990f, 0x9928, 0x9940, 0x9958, 0x9970,
	// Entry 5780 - 57BF
	0x9988, 0x99a0, 0x99b8, 0x99d0, 0x99e8, 0x9a00, 0x9a18, 0x9a30,
	0x9a48, 0x9a60, 0x9a78, 0x9a90, 0x9aa8, 0x9ac0, 0x9ad8, 0x9af0,
	0x9b08, 0x9b20, 0x9b38, 0x9b51, 0x9b69, 0x9b81, 0x9b99, 0x9bb1,
	0x9bc9, 0x9be1, 0x9bf9, 0x9c11, 0x9c29, 0x9c41, 0x9c59, 0x9c71,
	0x9c89, 0x9ca1, 0x9cb9, 0x9cd1, 0x9ce9, 0x9d01, 0x9d19, 0x9d32,
	0x9d4a, 0x9d62, 0x9d7a, 0x9d92, 0x9dab, 0x9dc3, 0x9ddb, 0x9df3,
	0x9e0c, 0x9e24, 0x9e3c, 0x9e54, 0x9e6c, 0x9e84, 0x9e9c, 0x9eb4,
	0x9ecc, 0x9ee4, 0x9efc, 0x9f14, 0x9f2c, 0x9f45, 0x9f5d, 0x9f75,
	// Entry 57C0 - 57FF
	0x9f8e, 0x9fa6, 0x9fbe, 0x9fd7, 0x9ff0, 0xa009, 0xa022, 0xa03b,
	0xa054, 0xa06d, 0xa086, 0xa09f, 0xa0b7, 0xa0cf, 0xa0e8, 0xa100,
	0xa118, 0xa131, 0xa149, 0xa161, 0xa179, 0xa191, 0xa1a9, 0xa1c1,
	0xa1d9, 0xa1f1, 0xa209, 0xa221, 0xa239, 0xa251, 0xa269, 0xa282,
	0xa29b, 0xa2b4, 0xa2cd, 0xa2e6, 0xa2ff, 0xa318, 0xa331, 0xa349,
	0xa361, 0xa379, 0xa391, 0xa3a9, 0xa3c1, 0xa3d9, 0xa3f1, 0xa40a,
	0xa422, 0xa43b, 0xa453, 0xa46b, 0xa483, 0xa49b, 0xa4b3, 0xa4cb,
	0xa4e3, 0xa4fc, 0xa514, 0xa52d, 0xa545, 0xa55d, 0xa575, 0xa58e,
	// Entry 5800 - 583F
	0xa5a6, 0xa5be, 0xa5d6, 0xa5ee, 0xa606, 0xa61e, 0xa636, 0xa64e,
	0xa667, 0xa67f, 0xa697, 0xa6af, 0xa6c7, 0xa6df, 0xa6f7, 0xa710,
	0xa728, 0xa740, 0xa758, 0xa770, 0xa789, 0xa7a1, 0xa7b9, 0xa7d1,
	0xa7e9, 0xa801, 0xa819, 0xa831, 0xa849, 0xa861, 0xa879, 0xa891,
	0xa8a9, 0xa8c2, 0xa8da, 0xa8f2, 0xa90a, 0xa922, 0xa93a, 0xa952,
	0xa96a, 0xa982, 0xa99b, 0xa9b3, 0xa9cb, 0xa9e3, 0xa9fb, 0xaa13,
	0xaa2b, 0xaa43, 0xaa5b, 0xaa73, 0xaa8b, 0xaaa4, 0xaabc, 0xaad4,
	0xaaec, 0xab04, 0xab1c, 0xab34, 0xab4d, 0xab65, 0xab7e, 0xab96,
	// Entry 5840 - 587F
	0xabae, 0xabc6, 0xabde, 0xabf6, 0xac0e, 0xac26, 0xac3f, 0xac57,
	0xac70, 0xac88, 0xaca1, 0xacb9, 0xacd1, 0xace9, 0xad01, 0xad1a,
	0xad33, 0xad4c, 0xad64, 0xad7c, 0xad94, 0xadac, 0xadc4, 0xaddc,
	0xadf4, 0xae0c, 0xae25, 0xae3d, 0xae56, 0xae6f, 0xae87, 0xae9f,
	0xaeb7, 0xaecf, 0xaee8, 0xaf00, 0xaf18, 0xaf30, 0xaf48, 0xaf60,
	0xaf78, 0xaf90, 0xafa8, 0xafc0, 0xafd9, 0xaff1, 0xb009, 0xb021,
	0xb039, 0xb051, 0xb069, 0xb082, 0xb09a, 0xb0b2, 0xb0ca, 0xb0e2,
	0xb0fa, 0xb112, 0xb12a, 0xb142, 0xb15a, 0xb172, 0xb18b, 0xb1a3,
	// Entry 5880 - 58BF
	0xb1bc, 0xb1d4, 0xb1ec, 0xb204, 0xb21c, 0xb234, 0xb24c, 0xb265,
	0xb27d, 0xb295, 0xb2ae, 0xb2c6, 0xb2de, 0xb2f6, 0xb30e, 0xb326,
	0xb33e, 0xb356, 0xb36e, 0xb386, 0xb39e, 0xb3b6, 0xb3ce, 0xb3e6,
	0xb3fe, 0xb416, 0xb42f, 0xb447, 0xb45f, 0xb477, 0xb48f, 0xb4a7,
	0xb4bf, 0xb4d7, 0xb4f0, 0xb508, 0xb520, 0xb538, 0xb550, 0xb569,
	0xb581, 0xb59a, 0xb5b2, 0xb5cb, 0xb5e3, 0xb5fb, 0xb613, 0xb62b,
	0xb643, 0xb65b, 0xb673, 0xb68b, 0xb6a3, 0xb6bb, 0xb6d3, 0xb6eb,
	0xb703, 0xb71b, 0xb734, 0xb74c, 0xb764, 0xb77c, 0xb794, 0xb7ad,
	// Entry 58C0 - 58FF
	0xb7c5, 0xb7dd, 0xb7f5, 0xb80e, 0xb827, 0xb83f, 0xb857, 0xb870,
	0xb888, 0xb8a0, 0xb8b8, 0xb8d0, 0xb8e8, 0xb900, 0xb918, 0xb931,
	0xb949, 0xb961, 0xb97a, 0xb993, 0xb9ac, 0xb9c5, 0xb9de, 0xb9f7,
	0xba10, 0xba29, 0xba41, 0xba59, 0xba71, 0xba8a, 0xbaa2, 0xbabb,
	0xbad3, 0xbaec, 0xbb04, 0xbb1c, 0xbb34, 0xbb4c, 0xbb64, 0xbb7d,
	0xbb95, 0xbbad, 0xbbc6, 0xbbde, 0xbbf6, 0xbc0e, 0xbc26, 0xbc3f,
	0xbc57, 0xbc6f, 0xbc87, 0xbca0, 0xbcb8, 0xbcd0, 0xbce9, 0xbd02,
	0xbd1a, 0xbd32, 0xbd4a, 0xbd62, 0xbd7a, 0xbd92, 0xbdaa, 0xbdc3,
	// Entry 5900 - 593F
	0xbddb, 0xbdf3, 0xbe0b, 0xbe23, 0xbe3b, 0xbe53, 0xbe6b, 0xbe83,
	0xbe9b, 0xbeb3, 0xbecb, 0xbee3, 0xbefb, 0xbf13, 0xbf2b, 0xbf43,
	0xbf5b, 0xbf73, 0xbf8b, 0xbfa3, 0xbfbb, 0xbfd3, 0xbfec, 0xc005,
	0xc01d, 0xc035, 0xc04d, 0xc065, 0xc07d, 0xc095, 0xc0ad, 0xc0c6,
	0xc0de, 0xc0f6, 0xc10e, 0xc126, 0xc13e, 0xc156, 0xc16e, 0xc186,
	0xc19f, 0xc1b7, 0xc1d0, 0xc1e8, 0xc201, 0xc219, 0xc231, 0xc24a,
	0xc262, 0xc27a, 0xc292, 0xc2aa, 0xc2c2, 0xc2db, 0xc2f4, 0xc30d,
	0xc326, 0xc33f, 0xc359, 0xc372, 0xc38b, 0xc3a4, 0xc3bd, 0xc3d6,
	// Entry 5940 - 597F
	0xc3ef, 0xc408, 0xc421, 0xc43a, 0xc453, 0xc46c, 0xc485, 0xc49f,
	0xc4b8, 0xc4d1, 0xc4ea, 0xc503, 0xc51c, 0xc535, 0xc54e, 0xc567,
	0xc580, 0xc599, 0xc5b2, 0xc5cb, 0xc5e4, 0xc5fe, 0xc617, 0xc631,
	0xc64a, 0xc663, 0xc67c, 0xc695, 0xc6ae, 0xc6c7, 0xc6e0, 0xc6fa,
	0xc713, 0xc72c, 0xc745, 0xc75e, 0xc778, 0xc790, 0xc7a9, 0xc7c1,
	0xc7d9, 0xc7f1, 0xc809, 0xc822, 0xc83a, 0xc853, 0xc86c, 0xc885,
	0xc89e, 0xc8b7, 0xc8d0, 0xc8e8, 0xc900, 0xc918, 0xc930, 0xc949,
	0xc962, 0xc97b, 0xc993, 0xc9ab, 0xc9c3, 0xc9db, 0xc9f3, 0xca0b,
	// Entry 5980 - 59BF
	0xca23, 0xca3b, 0xca53, 0xca6c, 0xca84, 0xca9d, 0xcab5, 0xcacd,
	0xcae5, 0xcafd, 0xcb16, 0xcb2e, 0xcb47, 0xcb5f, 0xcb77, 0xcb8f,
	0xcba7, 0xcbc0, 0xcbd8, 0xcbf1, 0xcc09, 0xcc21, 0xcc39, 0xcc52,
	0xcc6a, 0xcc82, 0xcc9a, 0xccb3, 0xcccc, 0xcce5, 0xccfe, 0xcd16,
	0xcd2e, 0xcd46, 0xcd5e, 0xcd76, 0xcd8e, 0xcda6, 0xcdbe, 0xcdd6,
	0xcdee, 0xce06, 0xce1e, 0xce36, 0xce4e, 0xce67, 0xce80, 0xce98,
	0xceb0, 0xcec9, 0xcee1, 0xcef9, 0xcf12, 0xcf2a, 0xcf42, 0xcf5a,
	0xcf72, 0xcf8a, 0xcfa2, 0xcfba, 0xcfd2, 0xcfea, 0xd002, 0xd01a,
	// Entry 59C0 - 59FF
	0xd032, 0xd04a, 0xd062, 0xd07a, 0xd092, 0xd0aa, 0xd0c3, 0xd0db,
	0xd0f4, 0xd10d, 0xd125, 0xd13d, 0xd155, 0xd16d, 0xd185, 0xd19d,
	0xd1b5, 0xd1ce, 0xd1e6, 0xd1fe, 0xd216, 0xd22e, 0xd246, 0xd25e,
	0xd277, 0xd28f, 0xd2a7, 0xd2bf, 0xd2d7, 0xd2ef, 0xd307, 0xd31f,
	0xd337, 0xd34f, 0xd367, 0xd37f, 0xd397, 0xd3af, 0xd3c7, 0xd3df,
	0xd3f8, 0xd410, 0xd428, 0xd440, 0xd458, 0xd471, 0xd489, 0xd4a1,
	0xd4b9, 0xd4d1, 0xd4e9, 0xd501, 0xd519, 0xd531, 0xd54a, 0xd563,
	0xd57b, 0xd593, 0xd5ab, 0xd5c4, 0xd5dc, 0xd5f4, 0xd60c, 0xd624,
	// Entry 5A00 - 5A3F
	0xd63c, 0xd654, 0xd66c, 0xd684, 0xd69c, 0xd6b5, 0xd6ce, 0xd6e6,
	0xd6fe, 0xd716, 0xd72e, 0xd746, 0xd75e, 0xd776, 0xd78e, 0xd7a6,
	0xd7bf, 0xd7d7, 0xd7ef, 0xd807, 0xd81f, 0xd837, 0xd84f, 0xd867,
	0xd87f, 0xd897, 0xd8af, 0xd8c7, 0xd8df, 0xd8f7, 0xd90f, 0xd928,
	0xd940, 0xd958, 0xd970, 0xd988, 0xd9a1, 0xd9b9, 0xd9d2, 0xd9ea,
	0xda03, 0xda1b, 0xda33, 0xda4c, 0xda64, 0xda7c, 0xda94, 0xdaac,
	0xdac4, 0xdadd, 0xdaf5, 0xdb0d, 0xdb25, 0xdb3d, 0xdb55, 0xdb6d,
	0xdb85, 0xdb9d, 0xdbb5, 0xdbcd, 0xdbe5, 0xdbfd, 0xdc15, 0xdc2d,
	// Entry 5A40 - 5A7F
	0xdc45, 0xdc5d, 0xdc76, 0xdc8e, 0xdca7, 0xdcbf, 0xdcd7, 0xdcef,
	0xdd07, 0xdd1f, 0xdd37, 0xdd4f, 0xdd67, 0xdd7f, 0xdd98, 0xddb1,
	0xddc9, 0xdde1, 0xddf9, 0xde11, 0xde29, 0xde41, 0xde59, 0xde71,
	0xde89, 0xdea1, 0xdeb9, 0xded1, 0xdee9, 0xdf01, 0xdf19, 0xdf31,
	0xdf49, 0xdf62, 0xdf7a, 0xdf92, 0xdfaa, 0xdfc2, 0xdfda, 0xdff2,
	0xe00b, 0xe023, 0xe03b, 0xe053, 0xe06c, 0xe084, 0xe09c, 0xe0b4,
	0xe0cc, 0xe0e4, 0xe0fc, 0xe114, 0xe12c, 0xe144, 0xe15c, 0xe174,
	0xe18d, 0xe1a6, 0xe1bf, 0xe1d8, 0xe1f1, 0xe20a, 0xe223, 0xe23c,
	// Entry 5A80 - 5ABF
	0xe255, 0xe26d, 0xe286, 0xe29e, 0xe2b6, 0xe2ce, 0xe2e6, 0xe2fe,
	0xe317, 0xe330, 0xe348, 0xe360, 0xe378, 0xe390, 0xe3a9, 0xe3c2,
	0xe3db, 0xe3f3, 0xe40c, 0xe425, 0xe43d, 0xe455, 0xe46d, 0xe485,
	0xe49d, 0xe4b5, 0xe4cd, 0xe4e5, 0xe4fe, 0xe517, 0xe530, 0xe549,
	0xe562, 0xe57b, 0xe594, 0xe5ad, 0xe5c6, 0xe5df, 0xe5f8, 0xe611,
	0xe629, 0xe641, 0xe659, 0xe672, 0xe68a, 0xe6a2, 0xe6ba, 0xe6d2,
	0xe6ea, 0xe703, 0xe71b, 0xe734, 0xe74c, 0xe765, 0xe77d, 0xe796,
	0xe7ae, 0xe7c6, 0xe7df, 0xe7f7, 0xe80f, 0xe827, 0xe83f, 0xe858,
	// Entry 5AC0 - 5AFF
	0xe870, 0xe888, 0xe8a0, 0xe8b9, 0xe8d1, 0xe8e9, 0xe901, 0xe91a,
	0xe932, 0xe94a, 0xe962, 0xe97a, 0xe992, 0xe9aa, 0xe9c3, 0xe9db,
	0xe9f4, 0xea0c, 0xea24, 0xea3c, 0xea54, 0xea6d, 0xea85, 0xea9d,
	0xeab5, 0xeace, 0xeae6, 0xeaff, 0xeb17, 0xeb2f, 0xeb47, 0xeb5f,
	0xeb77, 0xeb8f, 0xeba8, 0xebc0, 0xebd8, 0xebf0, 0xec08, 0xec20,
	0xec39, 0xec52, 0xec6a, 0xec82, 0xec9b, 0xecb3, 0xeccb, 0xece4,
	0xecfc, 0xed15, 0xed2d, 0xed45, 0xed5d, 0xed75, 0xed8d, 0xeda5,
	0xedbd, 0xedd5, 0xeded, 0xee06, 0xee1f, 0xee38, 0xee51, 0xee69,
	// Entry 5B00 - 5B3F
	0xee82, 0xee9b, 0xeeb3, 0xeecc, 0xeee4, 0xeefd, 0xef15, 0xef2d,
	0xef45, 0xef5d, 0xef75, 0xef8d, 0xefa5, 0xefbd, 0xefd5, 0xefed,
	0xf006, 0xf01f, 0xf038, 0xf051, 0xf06a, 0xf083, 0xf09c, 0xf0b5,
	0xf0ce, 0xf0e6, 0xf0ff, 0xf118, 0xf131, 0xf14a, 0xf163, 0xf17c,
	0xf195, 0xf1ae, 0xf1c7, 0xf1e0, 0xf1f9, 0xf212, 0xf22b, 0xf244,
	0xf25d, 0xf277, 0xf291, 0xf2aa, 0xf2c3, 0xf2dc, 0xf2f5, 0xf30e,
	0xf327, 0xf340, 0xf359, 0xf372, 0xf38b, 0xf3a4, 0xf3bd, 0xf3d6,
	0xf3ef, 0xf408, 0xf421, 0xf43a, 0xf453, 0xf46c, 0xf485, 0xf49e,
	// Entry 5B40 - 5B7F
	0xf4b7, 0xf4d0, 0xf4e9, 0xf502, 0xf525, 0xf54a, 0xf571, 0xf59b,
	0xf5c0, 0xf5e8, 0xf60a, 0xf62b, 0xf64a, 0xf663, 0xf67c, 0xf695,
	0xf6ae, 0xf6c7, 0xf6e0, 0xf6f9, 0xf712, 0xf72b, 0xf744, 0xf75e,
	0xf777, 0xf790, 0xf7a9, 0xf7c2, 0xf7db, 0xf7f4, 0xf80d, 0xf826,
	0xf83f, 0xf858, 0xf871, 0xf88a, 0xf8a3, 0xf8bc, 0xf8d5, 0xf8ee,
	0xf908, 0xf921, 0xf93a, 0xf953, 0xf96c, 0xf985, 0xf99e, 0xf9b7,
	0xf9d0, 0xf9e9, 0xfa02, 0xfa1b, 0xfa34, 0xfa4d, 0xfa67, 0xfa80,
	0xfa99, 0xfab3, 0xfacc, 0xfae5, 0xfafe, 0xfb17, 0xfb31, 0xfb4a,
	// Entry 5B80 - 5BBF
	0xfb64, 0xfb7e, 0xfb97, 0xfbb0, 0xfbc9, 0xfbe2, 0xfbfb, 0xfc14,
	0xfc2d, 0xfc46, 0xfc5f, 0xfc78, 0xfc91, 0xfcaa, 0xfcc3, 0xfcdc,
	0xfcf5, 0xfd0e, 0xfd27, 0xfd40, 0xfd59, 0xfd72, 0xfd8c, 0xfda6,
	0xfdc0, 0xfdd9, 0xfdf2, 0xfe0b, 0xfe24, 0xfe3d, 0xfe56, 0xfe6f,
	0xfe88, 0xfea1, 0xfeba, 0xfed3, 0xfeec, 0xff05, 0xff1e, 0xff37,
	0xff50, 0xff69, 0xff82, 0xff9b, 0xffb4, 0xffcd, 0xffe6, 0xffff,
	0x0018, 0x0031, 0x004a, 0x0063, 0x007c, 0x0095, 0x00ae, 0x00c7,
	0x00e1, 0x00fa, 0x0114, 0x012d, 0x0146, 0x0160, 0x0179, 0x0193,
	// Entry 5BC0 - 5BFF
	0x01ac, 0x01c6, 0x01df, 0x01f8, 0x0212, 0x022c, 0x0246, 0x025f,
	0x0279, 0x0293, 0x02ac, 0x02c5, 0x02df, 0x02f9, 0x0313, 0x032c,
	0x0345, 0x035e, 0x0378, 0x0392, 0x03ab, 0x03c4, 0x03dd, 0x03f6,
	0x040f, 0x0429, 0x0442, 0x045b, 0x0474, 0x048d, 0x04a6, 0x04bf,
	0x04d8, 0x04f1, 0x050a, 0x0523, 0x053d, 0x0556, 0x056f, 0x0588,
	0x05a1, 0x05ba, 0x05d3, 0x05ec, 0x0605, 0x061e, 0x0637, 0x0651,
	0x066a, 0x0683, 0x069c, 0x06b5, 0x06ce, 0x06e7, 0x0700, 0x0719,
	0x0732, 0x074b, 0x0764, 0x077d, 0x0796, 0x07af, 0x07c8, 0x07e1,
	// Entry 5C00 - 5C3F
	0x07fa, 0x0813, 0x082c, 0x0845, 0x085e, 0x0877, 0x0890, 0x08a9,
	0x08c2, 0x08db, 0x08f4, 0x090d, 0x0926, 0x093f, 0x0958, 0x0971,
	0x098a, 0x09a3, 0x09bc, 0x09d5, 0x09ee, 0x0a07, 0x0a20, 0x0a39,
	0x0a52, 0x0a6b, 0x0a84, 0x0a9d, 0x0ab6, 0x0acf, 0x0ae8, 0x0b01,
	0x0b1a, 0x0b33, 0x0b4c, 0x0b65, 0x0b7e, 0x0b97, 0x0bb0, 0x0bc9,
	0x0be2, 0x0bfb, 0x0c14, 0x0c2d, 0x0c46, 0x0c5f, 0x0c78, 0x0c91,
	0x0caa, 0x0cc3, 0x0cdc, 0x0cf6, 0x0d10, 0x0d29, 0x0d42, 0x0d5b,
	0x0d74, 0x0d8d, 0x0da7, 0x0dc0, 0x0dd9, 0x0df3, 0x0e0c, 0x0e25,
	// Entry 5C40 - 5C7F
	0x0e3e, 0x0e57, 0x0e70, 0x0e89, 0x0ea3, 0x0ebc, 0x0ed6, 0x0eef,
	0x0f08, 0x0f21, 0x0f3a, 0x0f53, 0x0f6c, 0x0f85, 0x0f9e, 0x0fb7,
	0x0fd0, 0x0fe9, 0x1003, 0x101c, 0x1035, 0x104e, 0x1067, 0x1080,
	0x1099, 0x10b2, 0x10cb, 0x10e4, 0x10fd, 0x1116, 0x112f, 0x1148,
	0x1161, 0x117a, 0x1193, 0x11ac, 0x11c5, 0x11de, 0x11f7, 0x1210,
	0x1229, 0x1242, 0x125b, 0x1274, 0x128d, 0x12a6, 0x12bf, 0x12d8,
	0x12f1, 0x130a, 0x1323, 0x133c, 0x1355, 0x136e, 0x1387, 0x13a0,
	0x13b9, 0x13d2, 0x13eb, 0x1405, 0x141e, 0x1437, 0x1450, 0x1469,
	// Entry 5C80 - 5CBF
	0x1482, 0x149b, 0x14b4, 0x14cd, 0x14e6, 0x14ff, 0x1518, 0x1531,
	0x154a, 0x1563, 0x157c, 0x1595, 0x15ae, 0x15c7, 0x15e0, 0x15f9,
	0x1612, 0x162b, 0x1645, 0x165e, 0x1677, 0x1690, 0x16a9, 0x16c2,
	0x16dc, 0x16f5, 0x170e, 0x1727, 0x1740, 0x1759, 0x1773, 0x178c,
	0x17a5, 0x17be, 0x17d7, 0x17f0, 0x1809, 0x1822, 0x183b, 0x1854,
	0x186d, 0x1887, 0x18a0, 0x18b9, 0x18d2, 0x18eb, 0x1904, 0x191d,
	0x1936, 0x194f, 0x1968, 0x1981, 0x199a, 0x19b3, 0x19cc, 0x19e5,
	0x19fe, 0x1a17, 0x1a30, 0x1a49, 0x1a62, 0x1a7b, 0x1a95, 0x1aae,
	// Entry 5CC0 - 5CFF
	0x1ac7, 0x1ae1, 0x1afb, 0x1b15, 0x1b2e, 0x1b47, 0x1b60, 0x1b79,
	0x1b93, 0x1bad, 0x1bc7, 0x1be0, 0x1bf9, 0x1c12, 0x1c2b, 0x1c44,
	0x1c5d, 0x1c76, 0x1c8f, 0x1ca8, 0x1cc1, 0x1cda, 0x1cf3, 0x1d0c,
	0x1d25, 0x1d3e, 0x1d57, 0x1d70, 0x1d89, 0x1da2, 0x1dbb, 0x1dd4,
	0x1ded, 0x1e06, 0x1e20, 0x1e39, 0x1e52, 0x1e6b, 0x1e84, 0x1e9d,
	0x1eb7, 0x1ed0, 0x1ee9, 0x1f02, 0x1f1b, 0x1f35, 0x1f4e, 0x1f67,
	0x1f80, 0x1f9a, 0x1fb3, 0x1fcc, 0x1fe5, 0x1ffe, 0x2017, 0x2030,
	0x2049, 0x2062, 0x207b, 0x2094, 0x20ae, 0x20c7, 0x20e9, 0x2103,
	// Entry 5D00 - 5D3F
	0x211c, 0x2135, 0x214e, 0x2168, 0x2181, 0x219a, 0x21b3, 0x21cc,
	0x21e5, 0x21fe, 0x221d, 0x2236, 0x224f, 0x2268, 0x2281, 0x229a,
	0x22b3, 0x22cc, 0x22e5, 0x22fe, 0x2317, 0x2330, 0x2349, 0x2362,
	0x237b, 0x2394, 0x23ad, 0x23da, 0x2406, 0x241f, 0x2438, 0x2451,
	0x246a, 0x2483, 0x249c, 0x24b5, 0x24ce, 0x24e7, 0x2500, 0x2519,
	0x2532, 0x254b, 0x2564, 0x257d, 0x2596, 0x25af, 0x25c8, 0x25e1,
	0x25fa, 0x2613, 0x262c, 0x2645, 0x265e, 0x2677, 0x2690, 0x26a9,
	0x26c2, 0x26db, 0x26f4, 0x270d, 0x2726, 0x273f, 0x2758, 0x2771,
	// Entry 5D40 - 5D7F
	0x278a, 0x27a3, 0x27bc, 0x27d5, 0x27ee, 0x2808, 0x2821, 0x283a,
	0x2853, 0x286c, 0x2885, 0x289e, 0x28b7, 0x28d1, 0x28ea, 0x2903,
	0x291c, 0x2935, 0x294e, 0x2967, 0x2980, 0x2999, 0x29b2, 0x29cb,
	0x29e4, 0x29fd, 0x2a16, 0x2a2f, 0x2a48, 0x2a61, 0x2a7a, 0x2a93,
	0x2aac, 0x2ac5, 0x2ade, 0x2af7, 0x2b10, 0x2b29, 0x2b42, 0x2b5b,
	0x2b74, 0x2b8d, 0x2ba6, 0x2bbf, 0x2bd8, 0x2bf1, 0x2c0a, 0x2c23,
	0x2c3c, 0x2c55, 0x2c6e, 0x2c87, 0x2ca0, 0x2cb9, 0x2cd2, 0x2ceb,
	0x2d04, 0x2d1d, 0x2d36, 0x2d4f, 0x2d68, 0x2d81, 0x2d9a, 0x2db3,
	// Entry 5D80 - 5DBF
	0x2dcc, 0x2de5, 0x2dfe, 0x2e17, 0x2e30, 0x2e49, 0x2e62, 0x2e7b,
	0x2e94, 0x2ead, 0x2ec6, 0x2edf, 0x2ef8, 0x2f11, 0x2f2a, 0x2f43,
	0x2f5c, 0x2f75, 0x2f8e, 0x2fa7, 0x2fc6, 0x2fe4, 0x300d, 0x3033,
	0x3050, 0x306f, 0x308d, 0x30aa, 0x30cc, 0x30f7, 0x311f, 0x313e,
	0x315c, 0x3177, 0x3194, 0x31b0, 0x31cf, 0x31eb, 0x3207, 0x3226,
	0x3241, 0x3259, 0x3278, 0x3292, 0x32ae, 0x32cc, 0x32e8, 0x3303,
	0x3321, 0x333d, 0x335e, 0x337c, 0x339a, 0x33bb, 0x33d9, 0x33f2,
	0x340d, 0x342e, 0x344a, 0x3463, 0x3483, 0x34a4, 0x34bc, 0x34d9,
	// Entry 5DC0 - 5DFF
	0x34f2, 0x350a, 0x3524, 0x353e, 0x3559, 0x3577, 0x3592, 0x35aa,
	0x35cb, 0x35e4, 0x3600, 0x3619, 0x3634, 0x364d, 0x3665, 0x367e,
	0x3696, 0x36b4, 0x36cf, 0x36e8, 0x370b, 0x372f, 0x374a, 0x3766,
	0x3782, 0x379c, 0x37b6, 0x37cf, 0x37ea, 0x3803, 0x381e, 0x3836,
	0x384f, 0x386a, 0x3883, 0x389b, 0x38b3, 0x38cc, 0x38e4, 0x38fb,
	0x3913, 0x392b, 0x3944, 0x395f, 0x3980, 0x3999, 0x39b4, 0x39d2,
	0x39f1, 0x3a0b, 0x3a26, 0x3a42, 0x3a5a, 0x3a75, 0x3a97, 0x3aba,
	0x3adb, 0x3af8, 0x3b18, 0x3b30, 0x3b4d, 0x3b6b, 0x3b89, 0x3ba9,
	// Entry 5E00 - 5E3F
	0x3bca, 0x3be8, 0x3c03, 0x3c20, 0x3c3c, 0x3c57, 0x3c71, 0x3c8a,
	0x3cab, 0x3cc9, 0x3ce3, 0x3cff, 0x3d18, 0x3d31, 0x3d4c, 0x3d6d,
	0x3d88, 0x3da0, 0x3dbb, 0x3dd8, 0x3df4, 0x3e10, 0x3e30, 0x3e49,
	0x3e63, 0x3e7b, 0x3e96, 0x3eb6, 0x3ed3, 0x3eeb, 0x3f06, 0x3f1f,
	0x3f36, 0x3f4e, 0x3f67, 0x3f88, 0x3fa0, 0x3fb8, 0x3fd5, 0x3fef,
	0x400d, 0x4027, 0x4042, 0x405f, 0x4079, 0x409f, 0x40bc, 0x40d6,
	0x40f2, 0x410d, 0x4133, 0x4152, 0x416b, 0x4186, 0x41a4, 0x41be,
	0x41d7, 0x41f3, 0x420c, 0x4225, 0x4240, 0x4258, 0x4271, 0x428b,
	// Entry 5E40 - 5E7F
	0x42a7, 0x42c1, 0x42de, 0x42f8, 0x4319, 0x4332, 0x434f, 0x436e,
	0x4387, 0x43a2, 0x43ba, 0x43d7, 0x43f3, 0x4410, 0x442c, 0x4446,
	0x445e, 0x4478, 0x4490, 0x44aa, 0x44c3, 0x44e0, 0x44fb, 0x4512,
	0x452c, 0x4544, 0x4560, 0x457f, 0x459a, 0x45b2, 0x45cb, 0x45e5,
	0x4600, 0x4617, 0x462f, 0x4648, 0x4661, 0x4679, 0x4695, 0x46ae,
	0x46c7, 0x46e8, 0x4701, 0x471a, 0x4737, 0x474f, 0x4768, 0x4782,
	0x479d, 0x47b5, 0x47d0, 0x47eb, 0x4807, 0x4821, 0x483a, 0x485a,
	0x4874, 0x488e, 0x48a7, 0x48c0, 0x48d9, 0x48f5, 0x4915, 0x492e,
	// Entry 5E80 - 5EBF
	0x4946, 0x495e, 0x4976, 0x498e, 0x49a6, 0x49bf, 0x49d7, 0x49ef,
	0x4a08, 0x4a22, 0x4a3b, 0x4a55, 0x4a6f, 0x4a8c, 0x4aa5, 0x4abf,
	0x4ad9, 0x4af2, 0x4b0c, 0x4b2b, 0x4b44, 0x4b5f, 0x4b78, 0x4b90,
	0x4ba8, 0x4bc4, 0x4bdd, 0x4bf5, 0x4c0f, 0x4c29, 0x4c45, 0x4c5e,
	0x4c79, 0x4c91, 0x4cad, 0x4ccd, 0x4ce9, 0x4d00, 0x4d19, 0x4d34,
	0x4d52, 0x4d6b, 0x4d87, 0x4da2, 0x4dbb, 0x4dd4, 0x4def, 0x4e08,
	0x4e23, 0x4e3b, 0x4e53, 0x4e6e, 0x4e87, 0x4ea1, 0x4eba, 0x4ed5,
	0x4eed, 0x4f07, 0x4f20, 0x4f39, 0x4f53, 0x4f70, 0x4f8b, 0x4fa6,
	// Entry 5EC0 - 5EFF
	0x4fbf, 0x4fd7, 0x4ff2, 0x500b, 0x5023, 0x503e, 0x5058, 0x5074,
	0x508d, 0x50a5, 0x50be, 0x50d7, 0x50f1, 0x510a, 0x5122, 0x513d,
	0x5158, 0x5171, 0x518a, 0x51a2, 0x51bb, 0x51d4, 0x51f0, 0x520a,
	0x5223, 0x523e, 0x5258, 0x5272, 0x528d, 0x52a4, 0x52c0, 0x52d8,
	0x52f0, 0x5308, 0x5320, 0x533a, 0x5354, 0x536a, 0x5382, 0x5399,
	0x53b2, 0x53cc, 0x53e5, 0x53fc, 0x5414, 0x542d, 0x5445, 0x545c,
	0x5475, 0x548d, 0x54a6, 0x54be, 0x54db, 0x54f2, 0x550b, 0x552a,
	0x5542, 0x555a, 0x5573, 0x558c, 0x55a6, 0x55be, 0x55d6, 0x55ef,
	// Entry 5F00 - 5F3F
	0x5607, 0x561f, 0x5637, 0x5652, 0x566b, 0x5684, 0x569c, 0x56b5,
	0x56cf, 0x56e7, 0x56ff, 0x571c, 0x5735, 0x574d, 0x5766, 0x577e,
	0x5799, 0x57b2, 0x57cb, 0x57e6, 0x57ff, 0x5819, 0x5834, 0x584e,
	0x5867, 0x587f, 0x589b, 0x58b4, 0x58ce, 0x58eb, 0x5907, 0x591f,
	0x5938, 0x5954, 0x596d, 0x598c, 0x59a4, 0x59bc, 0x59de, 0x5a02,
	0x5a1b, 0x5a35, 0x5a4e, 0x5a68, 0x5a7f, 0x5a99, 0x5ab3, 0x5acd,
	0x5ae8, 0x5b02, 0x5b1b, 0x5b34, 0x5b4b, 0x5b64, 0x5b80, 0x5b9d,
	0x5bb9, 0x5bd3, 0x5bec, 0x5c05, 0x5c1e, 0x5c37, 0x5c4f, 0x5c68,
	// Entry 5F40 - 5F7F
	0x5c80, 0x5ca0, 0x5cb8, 0x5cd2, 0x5cec, 0x5d06, 0x5d1f, 0x5d3a,
	0x5d52, 0x5d6c, 0x5d86, 0x5d9e, 0x5db6, 0x5dd2, 0x5deb, 0x5e02,
	0x5e1b, 0x5e34, 0x5e4d, 0x5e69, 0x5e89, 0x5ea2, 0x5ebb, 0x5ed4,
	0x5eed, 0x5f05, 0x5f1e, 0x5f39, 0x5f52, 0x5f6a, 0x5f83, 0x5f9d,
	0x5fb5, 0x5fce, 0x5fe7, 0x6002, 0x601c, 0x603a, 0x6056, 0x606e,
	0x6087, 0x609d, 0x60b5, 0x60cb, 0x60e1, 0x60f9, 0x6117, 0x612f,
	0x6147, 0x6169, 0x6182, 0x619b, 0x61b5, 0x61cf, 0x61f0, 0x620e,
	0x6226, 0x623e, 0x6257, 0x6270, 0x628f, 0x62a7, 0x62bf, 0x62d7,
	// Entry 5F80 - 5FBF
	0x62ef, 0x6306, 0x631d, 0x6336, 0x634e, 0x6369, 0x6381, 0x6399,
	0x63b2, 0x63d0, 0x63e7, 0x63fe, 0x6416, 0x642d, 0x6445, 0x645c,
	0x6474, 0x648c, 0x64a3, 0x64bb, 0x64d3, 0x64eb, 0x6504, 0x651b,
	0x6531, 0x6548, 0x655f, 0x6577, 0x658f, 0x65a7, 0x65be, 0x65d6,
	0x65ef, 0x6609, 0x6621, 0x663a, 0x6654, 0x666a, 0x6682, 0x669b,
	0x66b2, 0x66cb, 0x66e4, 0x66fc, 0x6715, 0x672c, 0x6746, 0x675e,
	0x6776, 0x678d, 0x67a6, 0x67bf, 0x67d8, 0x67f0, 0x6808, 0x681f,
	0x6836, 0x684f, 0x6867, 0x6883, 0x689c, 0x68b4, 0x68cd, 0x68e5,
	// Entry 5FC0 - 5FFF
	0x68fc, 0x6913, 0x692b, 0x6942, 0x695b, 0x6973, 0x698a, 0x69a1,
	0x69ba, 0x69d2, 0x69ea, 0x6a04, 0x6a1d, 0x6a2a, 0x6a38, 0x6a45,
	0x6a53, 0x6a60, 0x6a6d, 0x6a79, 0x6a87, 0x6a96, 0x6aa4, 0x6ab2,
	0x6ac0, 0x6ad0, 0x6add, 0x6aec, 0x6afa, 0x6b07, 0x6b14, 0x6b20,
	0x6b2d, 0x6b3b, 0x6b4a, 0x6b57, 0x6b64, 0x6b70, 0x6b7d, 0x6b8b,
	0x6b98, 0x6ba6, 0x6bb3, 0x6bc1, 0x6bcf, 0x6bdc, 0x6be9, 0x6bf8,
	0x6c06, 0x6c14, 0x6c21, 0x6c30, 0x6c3f, 0x6c4d, 0x6c56, 0x6c66,
	0x6c7b, 0x6c8e, 0x6ca1, 0x6cb4, 0x6cc8, 0x6cdc, 0x6cf0, 0x6d05,
	// Entry 6000 - 603F
	0x6d1a, 0x6d2d, 0x6d42, 0x6d55, 0x6d68, 0x6d7c, 0x6d8f, 0x6da2,
	0x6db6, 0x6dc9, 0x6ddc, 0x6def, 0x6e04, 0x6e17, 0x6e2d, 0x6e3f,
	0x6e51, 0x6e64, 0x6e76, 0x6e89, 0x6e9b, 0x6ead, 0x6eca, 0x6ee6,
	0x6f02, 0x6f22, 0x6f43, 0x6f56, 0x6f6d, 0x6f84, 0x6f9a, 0x6fb0,
	0x6fc7, 0x6fde, 0x6ff4, 0x700a, 0x7020, 0x7036, 0x704d, 0x7064,
	0x707b, 0x7092, 0x70a9, 0x70c0, 0x70d7, 0x70ee, 0x7104, 0x711a,
	0x7131, 0x7148, 0x715e, 0x7174, 0x718a, 0x71a0, 0x71b7, 0x71ce,
	0x71e8, 0x7204, 0x721e, 0x7238, 0x7253, 0x726d, 0x7288, 0x72a3,
	// Entry 6040 - 607F
	0x72bd, 0x72d8, 0x72f2, 0x730d, 0x7329, 0x7344, 0x7360, 0x737c,
	0x7396, 0x73af, 0x73c9, 0x73e3, 0x73fc, 0x7414, 0x742d, 0x7447,
	0x7461, 0x747a, 0x7494, 0x74ae, 0x74ce, 0x74e9, 0x7504, 0x751e,
	0x753b, 0x7556, 0x7571, 0x758d, 0x75a7, 0x75c2, 0x75dc, 0x75f4,
	0x760a, 0x7628, 0x763f, 0x7655, 0x766b, 0x7683, 0x769a, 0x76b1,
	0x76c7, 0x76df, 0x76f7, 0x770e, 0x7726, 0x7742, 0x7763, 0x777f,
	0x77a3, 0x77c3, 0x77e0, 0x77f9, 0x780f, 0x7824, 0x7845, 0x785f,
	0x7875, 0x788b, 0x78a1, 0x78b7, 0x78cb, 0x78e8, 0x7904, 0x7919,
	// Entry 6080 - 60BF
	0x792e, 0x7943, 0x796b, 0x798c, 0x79a6, 0x79c5, 0x79e3, 0x7a01,
	0x7a1e, 0x7a39, 0x7a53, 0x7a6e, 0x7a8a, 0x7aa4, 0x7abf, 0x7ada,
	0x7af5, 0x7b10, 0x7b2b, 0x7b46, 0x7b60, 0x7b7a, 0x7b94, 0x7bae,
	0x7bc9, 0x7be3, 0x7bfd, 0x7c19, 0x7c35, 0x7c51, 0x7c6d, 0x7c8c,
	0x7ca8, 0x7cc5, 0x7ce1, 0x7cfd, 0x7d19, 0x7d35, 0x7d51, 0x7d6d,
	0x7d89, 0x7da5, 0x7dc1, 0x7ddd, 0x7df9, 0x7e15, 0x7e32, 0x7e4e,
	0x7e6a, 0x7e87, 0x7ea4, 0x7ec0, 0x7edc, 0x7ef9, 0x7f15, 0x7f31,
	0x7f4d, 0x7f6a, 0x7f86, 0x7fa0, 0x7fba, 0x7fd4, 0x7fee, 0x800b,
	// Entry 60C0 - 60FF
	0x8025, 0x8040, 0x805a, 0x8074, 0x808e, 0x80a8, 0x80c2, 0x80dc,
	0x80f6, 0x8110, 0x812a, 0x8144, 0x815e, 0x8178, 0x8193, 0x81ad,
	0x81c7, 0x81e2, 0x81fd, 0x8217, 0x8231, 0x824c, 0x8266, 0x8280,
	0x829a, 0x82b5, 0x82cf, 0x82e5, 0x82fa, 0x830f, 0x8326, 0x833c,
	0x8352, 0x8367, 0x837e, 0x8395, 0x83ab, 0x83c1, 0x83da, 0x83f3,
	0x840e, 0x8429, 0x8443, 0x845d, 0x8479, 0x8494, 0x84af, 0x84d3,
	0x84f7, 0x851d, 0x852e, 0x8543, 0x855a, 0x8574, 0x8582, 0x8590,
	0x85a1, 0x85b0, 0x85be, 0x85cd, 0x85e3, 0x85f1, 0x85ff, 0x860e,
	// Entry 6100 - 613F
	0x861c, 0x862a, 0x863c, 0x864d, 0x865c, 0x866b, 0x8679, 0x8688,
	0x869a, 0x86b0, 0x86bf, 0x86cf, 0x86dd, 0x86ec, 0x86fb, 0x870b,
	0x871b, 0x872b, 0x873c, 0x874d, 0x875b, 0x8769, 0x877a, 0x8788,
	0x8797, 0x87a6, 0x87b6, 0x87cd, 0x87db, 0x87e9, 0x87f8, 0x8808,
	0x8818, 0x8828, 0x8837, 0x8847, 0x8857, 0x8867, 0x887a, 0x888d,
	0x88a6, 0x88b5, 0x88c4, 0x88d3, 0x88e3, 0x88f2, 0x8901, 0x8913,
	0x8921, 0x892f, 0x893e, 0x894d, 0x895d, 0x8974, 0x8984, 0x8995,
	0x89a3, 0x89b1, 0x89c0, 0x89cf, 0x89de, 0x89ee, 0x89fc, 0x8a0b,
	// Entry 6140 - 617F
	0x8a1a, 0x8a3a, 0x8a52, 0x8a66, 0x8a80, 0x8a9d, 0x8aae, 0x8ac0,
	0x8ad3, 0x8ae5, 0x8af8, 0x8b09, 0x8b1b, 0x8b2d, 0x8b3e, 0x8b4f,
	0x8b61, 0x8b74, 0x8b87, 0x8b98, 0x8baa, 0x8bbd, 0x8bd1, 0x8be3,
	0x8bf5, 0x8c07, 0x8c19, 0x8c2c, 0x8c3d, 0x8c4f, 0x8c62, 0x8c76,
	0x8c88, 0x8c9b, 0x8cae, 0x8cbf, 0x8cd1, 0x8ce3, 0x8cf6, 0x8d09,
	0x8d24, 0x8d36, 0x8d50, 0x8d62, 0x8d74, 0x8d86, 0x8d98, 0x8da9,
	0x8dbb, 0x8dce, 0x8de1, 0x8df3, 0x8e06, 0x8e18, 0x8e2a, 0x8e3c,
	0x8e50, 0x8e62, 0x8e71, 0x8e84, 0x8e93, 0x8ea2, 0x8eb4, 0x8ec6,
	// Entry 6180 - 61BF
	0x8ed8, 0x8eea, 0x8efc, 0x8f0e, 0x8f20, 0x8f3b, 0x8f56, 0x8f71,
	0x8f8c, 0x8fa7, 0x8fc2, 0x8fd7, 0x8feb, 0x9000, 0x901a, 0x902e,
	0x9042, 0x9056, 0x906a, 0x907e, 0x9092, 0x90a6, 0x90ba, 0x90ce,
	0x90e2, 0x90f6, 0x910a, 0x911e, 0x9132, 0x9146, 0x915a, 0x916e,
	0x9182, 0x9196, 0x91aa, 0x91be, 0x91d2, 0x91e6, 0x91fa, 0x920e,
	0x9222, 0x9236, 0x924a, 0x925e, 0x9272, 0x9286, 0x929a, 0x92ae,
	0x92c2, 0x92d6, 0x92ea, 0x92fe, 0x9312, 0x9326, 0x933a, 0x934e,
	0x9362, 0x9376, 0x938a, 0x939e, 0x93b2, 0x93c6, 0x93da, 0x93ee,
	// Entry 61C0 - 61FF
	0x9402, 0x9416, 0x942a, 0x943e, 0x9452, 0x9466, 0x947a, 0x948e,
	0x94a2, 0x94b6, 0x94ca, 0x94de, 0x94f2, 0x9506, 0x951a, 0x952e,
	0x9542, 0x9556, 0x956a, 0x957e, 0x9592, 0x95a6, 0x95ba, 0x95ce,
	0x95e2, 0x95f6, 0x960a, 0x961e, 0x9632, 0x9646, 0x965a, 0x966e,
	0x9682, 0x9696, 0x96aa, 0x96be, 0x96d2, 0x96e6, 0x96fa, 0x970e,
	0x9722, 0x9736, 0x974a, 0x975e, 0x9772, 0x9786, 0x979a, 0x97ae,
	0x97c2, 0x97d6, 0x97ea, 0x97fe, 0x9812, 0x9826, 0x983a, 0x984e,
	0x9862, 0x9876, 0x988a, 0x989e, 0x98b2, 0x98c6, 0x98da, 0x98ee,
	// Entry 6200 - 623F
	0x9902, 0x9916, 0x992a, 0x993e, 0x9952, 0x9966, 0x997a, 0x998e,
	0x99a2, 0x99b6, 0x99ca, 0x99de, 0x99f2, 0x9a06, 0x9a1a, 0x9a2e,
	0x9a42, 0x9a56, 0x9a6a, 0x9a7e, 0x9a92, 0x9aa6, 0x9aba, 0x9ace,
	0x9ae2, 0x9af6, 0x9b0a, 0x9b1e, 0x9b32, 0x9b46, 0x9b5a, 0x9b6e,
	0x9b82, 0x9b96, 0x9baa, 0x9bbe, 0x9bd2, 0x9be6, 0x9bfa, 0x9c0e,
	0x9c22, 0x9c36, 0x9c4a, 0x9c5e, 0x9c72, 0x9c86, 0x9c9a, 0x9cae,
	0x9cc2, 0x9cd6, 0x9cea, 0x9cfe, 0x9d12, 0x9d26, 0x9d3a, 0x9d4e,
	0x9d62, 0x9d76, 0x9d8a, 0x9d9e, 0x9db2, 0x9dc6, 0x9dda, 0x9dee,
	// Entry 6240 - 627F
	0x9e02, 0x9e16, 0x9e2a, 0x9e3e, 0x9e52, 0x9e66, 0x9e7a, 0x9e8e,
	0x9ea2, 0x9eb6, 0x9eca, 0x9ede, 0x9ef2, 0x9f06, 0x9f1a, 0x9f2e,
	0x9f42, 0x9f56, 0x9f6a, 0x9f7e, 0x9f92, 0x9fa6, 0x9fba, 0x9fce,
	0x9fe2, 0x9ff6, 0xa00a, 0xa01e, 0xa032, 0xa046, 0xa05a, 0xa06e,
	0xa082, 0xa096, 0xa0aa, 0xa0be, 0xa0d2, 0xa0e6, 0xa0fa, 0xa10e,
	0xa122, 0xa136, 0xa14a, 0xa15e, 0xa172, 0xa186, 0xa19a, 0xa1ae,
	0xa1c2, 0xa1d6, 0xa1ea, 0xa1fe, 0xa212, 0xa226, 0xa23a, 0xa24e,
	0xa262, 0xa276, 0xa28a, 0xa29e, 0xa2b2, 0xa2c6, 0xa2da, 0xa2ee,
	// Entry 6280 - 62BF
	0xa302, 0xa316, 0xa32a, 0xa33e, 0xa352, 0xa366, 0xa37a, 0xa38e,
	0xa3a2, 0xa3b6, 0xa3ca, 0xa3de, 0xa3f2, 0xa406, 0xa41a, 0xa42e,
	0xa442, 0xa456, 0xa46a, 0xa47e, 0xa492, 0xa4a6, 0xa4ba, 0xa4ce,
	0xa4e2, 0xa4f6, 0xa50a, 0xa51e, 0xa532, 0xa546, 0xa55a, 0xa56e,
	0xa582, 0xa596, 0xa5aa, 0xa5be, 0xa5d2, 0xa5e6, 0xa5fa, 0xa60e,
	0xa622, 0xa636, 0xa64a, 0xa65e, 0xa672, 0xa686, 0xa69a, 0xa6ae,
	0xa6c2, 0xa6d6, 0xa6ea, 0xa6fe, 0xa712, 0xa726, 0xa73a, 0xa74e,
	0xa762, 0xa776, 0xa78a, 0xa79e, 0xa7b2, 0xa7c6, 0xa7da, 0xa7ee,
	// Entry 62C0 - 62FF
	0xa802, 0xa816, 0xa82a, 0xa83e, 0xa852, 0xa866, 0xa87a, 0xa88e,
	0xa8a2, 0xa8b6, 0xa8ca, 0xa8de, 0xa8f2, 0xa906, 0xa91a, 0xa92e,
	0xa942, 0xa956, 0xa96a, 0xa97e, 0xa992, 0xa9a6, 0xa9ba, 0xa9ce,
	0xa9e2, 0xa9f6, 0xaa0a, 0xaa1e, 0xaa32, 0xaa46, 0xaa5a, 0xaa6e,
	0xaa82, 0xaa96, 0xaaaa, 0xaabe, 0xaad2, 0xaae6, 0xaafa, 0xab0e,
	0xab22, 0xab36, 0xab4a, 0xab5e, 0xab72, 0xab86, 0xab9a, 0xabae,
	0xabc2, 0xabd6, 0xabea, 0xabfe, 0xac12, 0xac26, 0xac3a, 0xac4e,
	0xac62, 0xac76, 0xac8a, 0xac9e, 0xacb2, 0xacc6, 0xacda, 0xacee,
	// Entry 6300 - 633F
	0xad02, 0xad16, 0xad2a, 0xad3e, 0xad52, 0xad66, 0xad7a, 0xad8e,
	0xada2, 0xadb6, 0xadca, 0xadde, 0xadf2, 0xae06, 0xae1a, 0xae2e,
	0xae42, 0xae56, 0xae6a, 0xae7e, 0xae92, 0xaea6, 0xaeba, 0xaece,
	0xaee2, 0xaef6, 0xaf0a, 0xaf1e, 0xaf32, 0xaf46, 0xaf5a, 0xaf6e,
	0xaf82, 0xaf96, 0xafaa, 0xafbe, 0xafd2, 0xafe6, 0xaffa, 0xb00e,
	0xb022, 0xb036, 0xb04a, 0xb05e, 0xb072, 0xb086, 0xb09a, 0xb0ae,
	0xb0c2, 0xb0d6, 0xb0ea, 0xb0fe, 0xb112, 0xb126, 0xb13a, 0xb14e,
	0xb162, 0xb176, 0xb18a, 0xb19e, 0xb1b2, 0xb1c6, 0xb1da, 0xb1ee,
	// Entry 6340 - 637F
	0xb202, 0xb216, 0xb22a, 0xb23e, 0xb252, 0xb266, 0xb27a, 0xb28e,
	0xb2a2, 0xb2b6, 0xb2ca, 0xb2de, 0xb2f2, 0xb306, 0xb31a, 0xb32e,
	0xb342, 0xb356, 0xb36a, 0xb37e, 0xb392, 0xb3a6, 0xb3ba, 0xb3ce,
	0xb3e2, 0xb3f6, 0xb40a, 0xb41e, 0xb432, 0xb446, 0xb45a, 0xb46e,
	0xb482, 0xb496, 0xb4aa, 0xb4be, 0xb4d2, 0xb4e6, 0xb4fa, 0xb50e,
	0xb522, 0xb536, 0xb54a, 0xb55e, 0xb572, 0xb586, 0xb59a, 0xb5ae,
	0xb5c2, 0xb5d6, 0xb5ea, 0xb5fe, 0xb612, 0xb626, 0xb63a, 0xb64e,
	0xb662, 0xb676, 0xb68a, 0xb69e, 0xb6b2, 0xb6c6, 0xb6da, 0xb6ee,
	// Entry 6380 - 63BF
	0xb702, 0xb716, 0xb72a, 0xb73e, 0xb752, 0xb766, 0xb77a, 0xb78e,
	0xb7a2, 0xb7b6, 0xb7ca, 0xb7de, 0xb7f2, 0xb806, 0xb81a, 0xb82e,
	0xb842, 0xb856, 0xb86a, 0xb87e, 0xb892, 0xb8a6, 0xb8ba, 0xb8ce,
	0xb8e2, 0xb8f6, 0xb90a, 0xb91e, 0xb932, 0xb946, 0xb95a, 0xb96e,
	0xb982, 0xb996, 0xb9aa, 0xb9be, 0xb9d2, 0xb9e6, 0xb9fa, 0xba0e,
	0xba22, 0xba36, 0xba4a, 0xba5e, 0xba72, 0xba86, 0xba9a, 0xbaae,
	0xbac2, 0xbad6, 0xbaea, 0xbafe, 0xbb12, 0xbb26, 0xbb3a, 0xbb4e,
	0xbb62, 0xbb76, 0xbb8a, 0xbb9e, 0xbbb2, 0xbbc6, 0xbbda, 0xbbee,
	// Entry 63C0 - 63FF
	0xbc02, 0xbc16, 0xbc2a, 0xbc3e, 0xbc52, 0xbc66, 0xbc7a, 0xbc8e,
	0xbca2, 0xbcb6, 0xbcca, 0xbcde, 0xbcf2, 0xbd06, 0xbd1a, 0xbd2e,
	0xbd42, 0xbd56, 0xbd6a, 0xbd7e, 0xbd92, 0xbda6, 0xbdba, 0xbdce,
	0xbde2, 0xbdf6, 0xbe0a, 0xbe1e, 0xbe32, 0xbe46, 0xbe5a, 0xbe6e,
	0xbe82, 0xbe96, 0xbeaa, 0xbebe, 0xbed2, 0xbee6, 0xbefa, 0xbf0e,
	0xbf22, 0xbf36, 0xbf4a, 0xbf5e, 0xbf72, 0xbf86, 0xbf9a, 0xbfae,
	0xbfc2, 0xbfd6, 0xbfea, 0xbffe, 0xc012, 0xc026, 0xc03a, 0xc04e,
	0xc062, 0xc076, 0xc08a, 0xc09e, 0xc0b2, 0xc0c6, 0xc0da, 0xc0ee,
	// Entry 6400 - 643F
	0xc102, 0xc116, 0xc12a, 0xc13e, 0xc152, 0xc166, 0xc17a, 0xc18e,
	0xc1a2, 0xc1b6, 0xc1ca, 0xc1de, 0xc1f2, 0xc206, 0xc21a, 0xc22e,
	0xc242, 0xc256, 0xc26a, 0xc27e, 0xc292, 0xc2a6, 0xc2ba, 0xc2ce,
	0xc2e2, 0xc2f6, 0xc30a, 0xc31e, 0xc332, 0xc346, 0xc35a, 0xc36e,
	0xc382, 0xc396, 0xc3aa, 0xc3be, 0xc3d2, 0xc3e6, 0xc3fa, 0xc40e,
	0xc422, 0xc436, 0xc44a, 0xc45e, 0xc472, 0xc486, 0xc49a, 0xc4ae,
	0xc4c2, 0xc4d6, 0xc4ea, 0xc4fe, 0xc512, 0xc526, 0xc53a, 0xc54e,
	0xc562, 0xc576, 0xc58a, 0xc59e, 0xc5b2, 0xc5c6, 0xc5da, 0xc5ee,
	// Entry 6440 - 647F
	0xc602, 0xc616, 0xc62a, 0xc63e, 0xc652, 0xc666, 0xc67a, 0xc68e,
	0xc6a2, 0xc6b6, 0xc6ca, 0xc6de, 0xc6f2, 0xc706, 0xc71a, 0xc72e,
	0xc742, 0xc756, 0xc76a, 0xc77e, 0xc792, 0xc7a6, 0xc7ba, 0xc7ce,
	0xc7e2, 0xc7f6, 0xc80a, 0xc81e, 0xc832, 0xc846, 0xc85a, 0xc86e,
	0xc882, 0xc896, 0xc8aa, 0xc8be, 0xc8d2, 0xc8e6, 0xc8fa, 0xc90e,
	0xc922, 0xc936, 0xc94a, 0xc95e, 0xc972, 0xc986, 0xc99a, 0xc9ae,
	0xc9c2, 0xc9d6, 0xc9ea, 0xc9fe, 0xca12, 0xca26, 0xca3a, 0xca4e,
	0xca62, 0xca76, 0xca8a, 0xca9e, 0xcab2, 0xcac6, 0xcada, 0xcaee,
	// Entry 6480 - 64BF
	0xcb02, 0xcb16, 0xcb2f, 0xcb49, 0xcb5e, 0xcb73, 0xcb88, 0xcb9e,
	0xcbb3, 0xcbc8, 0xcbdd, 0xcbf2, 0xcc07, 0xcc1c, 0xcc31, 0xcc46,
	0xcc5b, 0xcc70, 0xcc85, 0xcc9a, 0xccaf, 0xccc4, 0xccd9, 0xccee,
	0xcd03, 0xcd19, 0xcd2f, 0xcd45, 0xcd5b, 0xcd71, 0xcd87, 0xcd9d,
	0xcdb3, 0xcdc9, 0xcde0, 0xcdf7, 0xce0e, 0xce24, 0xce3a, 0xce50,
	0xce66, 0xce7c, 0xce92, 0xcea8, 0xcebe, 0xced4, 0xceea, 0xcf00,
	0xcf16, 0xcf2c, 0xcf42, 0xcf58, 0xcf6e, 0xcf84, 0xcf9a, 0xcfb0,
	0xcfc6, 0xcfdc, 0xcff2, 0xd008, 0xd01e, 0xd035, 0xd04b, 0xd061,
	// Entry 64C0 - 64FF
	0xd077, 0xd08d, 0xd0a3, 0xd0b9, 0xd0cf, 0xd0e5, 0xd0fb, 0xd111,
	0xd127, 0xd13d, 0xd153, 0xd169, 0xd17f, 0xd195, 0xd1ab, 0xd1c1,
	0xd1d7, 0xd1ed, 0xd203, 0xd219, 0xd22f, 0xd245, 0xd25b, 0xd271,
	0xd287, 0xd29d, 0xd2b3, 0xd2c9, 0xd2df, 0xd2f5, 0xd30b, 0xd321,
	0xd337, 0xd34d, 0xd363, 0xd379, 0xd38f, 0xd3a5, 0xd3bb, 0xd3d1,
	0xd3e7, 0xd3fd, 0xd413, 0xd429, 0xd43f, 0xd455, 0xd46b, 0xd482,
	0xd498, 0xd4ae, 0xd4c4, 0xd4da, 0xd4f0, 0xd506, 0xd51c, 0xd532,
	0xd548, 0xd55e, 0xd574, 0xd58a, 0xd5a0, 0xd5b6, 0xd5cc, 0xd5e3,
	// Entry 6500 - 653F
	0xd5f9, 0xd60f, 0xd625, 0xd63b, 0xd651, 0xd667, 0xd67d, 0xd693,
	0xd6a9, 0xd6bf, 0xd6d5, 0xd6eb, 0xd701, 0xd717, 0xd72d, 0xd743,
	0xd75a, 0xd770, 0xd786, 0xd79c, 0xd7b2, 0xd7c8, 0xd7de, 0xd7f4,
	0xd80a, 0xd820, 0xd837, 0xd84d, 0xd863, 0xd879, 0xd88f, 0xd8a5,
	0xd8bb, 0xd8d1, 0xd8e7, 0xd8fd, 0xd913, 0xd929, 0xd93f, 0xd955,
	0xd96b, 0xd982, 0xd999, 0xd9af, 0xd9c5, 0xd9db, 0xd9f1, 0xda07,
	0xda1d, 0xda33, 0xda49, 0xda5f, 0xda75, 0xda8b, 0xdaa1, 0xdab7,
	0xdacd, 0xdae3, 0xdaf9, 0xdb0f, 0xdb25, 0xdb3b, 0xdb51, 0xdb67,
	// Entry 6540 - 657F
	0xdb7d, 0xdb93, 0xdba9, 0xdbbf, 0xdbd5, 0xdbeb, 0xdc01, 0xdc17,
	0xdc2d, 0xdc43, 0xdc59, 0xdc6f, 0xdc85, 0xdc9b, 0xdcb1, 0xdcc7,
	0xdcdd, 0xdcf3, 0xdd09, 0xdd1f, 0xdd35, 0xdd4b, 0xdd61, 0xdd77,
	0xdd8e, 0xdda4, 0xddba, 0xddd0, 0xdde6, 0xddfc, 0xde12, 0xde28,
	0xde3e, 0xde54, 0xde6a, 0xde80, 0xde97, 0xdead, 0xdec3, 0xded9,
	0xdeef, 0xdf05, 0xdf1b, 0xdf31, 0xdf47, 0xdf5d, 0xdf73, 0xdf89,
	0xdf9f, 0xdfb5, 0xdfcb, 0xdfe1, 0xdff7, 0xe00d, 0xe023, 0xe039,
	0xe04f, 0xe065, 0xe07b, 0xe091, 0xe0a7, 0xe0bd, 0xe0d3, 0xe0e9,
	// Entry 6580 - 65BF
	0xe0ff, 0xe115, 0xe12b, 0xe141, 0xe157, 0xe16d, 0xe183, 0xe199,
	0xe1af, 0xe1c5, 0xe1db, 0xe1f1, 0xe207, 0xe21d, 0xe233, 0xe249,
	0xe25f, 0xe275, 0xe28b, 0xe2a1, 0xe2b7, 0xe2cd, 0xe2e3, 0xe2f9,
	0xe30f, 0xe325, 0xe33b, 0xe351, 0xe367, 0xe37d, 0xe393, 0xe3ae,
	0xe3c9, 0xe3e1, 0xe3f9, 0xe411, 0xe429, 0xe441, 0xe459, 0xe470,
	0xe485, 0xe49a, 0xe4af, 0xe4c4, 0xe4d9, 0xe4ee, 0xe503, 0xe518,
	0xe52d, 0xe542, 0xe557, 0xe56c, 0xe581, 0xe596, 0xe5ab, 0xe5c0,
	0xe5d5, 0xe5ea, 0xe5ff, 0xe614, 0xe629, 0xe63e, 0xe653, 0xe668,
	// Entry 65C0 - 65FF
	0xe67d, 0xe692, 0xe6a7, 0xe6bc, 0xe6d1, 0xe6e6, 0xe6fb, 0xe710,
	0xe725, 0xe73a, 0xe74f, 0xe764, 0xe779, 0xe78e, 0xe7a3, 0xe7b8,
	0xe7cd, 0xe7e2, 0xe7f7, 0xe80c, 0xe821, 0xe836, 0xe84b, 0xe860,
	0xe875, 0xe88a, 0xe89f, 0xe8b4, 0xe8c9, 0xe8de, 0xe8f3, 0xe908,
	0xe91d, 0xe932, 0xe947, 0xe95c, 0xe971, 0xe986, 0xe99b, 0xe9b0,
	0xe9c5, 0xe9da, 0xe9ef, 0xea04, 0xea19, 0xea2e, 0xea43, 0xea58,
	0xea6d, 0xea82, 0xea97, 0xeaac, 0xeac1, 0xead6, 0xeaeb, 0xeb00,
	0xeb15, 0xeb2a, 0xeb3f, 0xeb54, 0xeb69, 0xeb7e, 0xeb93, 0xeba8,
	// Entry 6600 - 663F
	0xebbd, 0xebd2, 0xebe7, 0xebfc, 0xec11, 0xec26, 0xec3b, 0xec50,
	0xec65, 0xec7a, 0xec8f, 0xeca4, 0xecb9, 0xecce, 0xece3, 0xecf8,
	0xed0d, 0xed22, 0xed37, 0xed4c, 0xed61, 0xed76, 0xed8b, 0xeda0,
	0xedb5, 0xedca, 0xeddf, 0xedf4, 0xee09, 0xee1e, 0xee33, 0xee48,
	0xee5d, 0xee72, 0xee87, 0xee9c, 0xeeb1, 0xeec6, 0xeedb, 0xeef0,
	0xef05, 0xef1a, 0xef2f, 0xef44, 0xef59, 0xef6e, 0xef83, 0xef98,
	0xefad, 0xefc2, 0xefd7, 0xefec, 0xf001, 0xf016, 0xf02b, 0xf040,
	0xf055, 0xf06a, 0xf07f, 0xf094, 0xf0a9, 0xf0be, 0xf0d3, 0xf0e8,
	// Entry 6640 - 667F
	0xf0fd, 0xf112, 0xf127, 0xf13c, 0xf151, 0xf166, 0xf17b, 0xf190,
	0xf1a5, 0xf1ba, 0xf1cf, 0xf1e4, 0xf1f9, 0xf20e, 0xf223, 0xf238,
	0xf24d, 0xf262, 0xf277, 0xf28c, 0xf2a1, 0xf2b6, 0xf2cb, 0xf2e0,
	0xf2f5, 0xf30a, 0xf31f, 0xf334, 0xf349, 0xf35e, 0xf373, 0xf388,
	0xf39d, 0xf3b2, 0xf3c7, 0xf3dc, 0xf3f1, 0xf406, 0xf41b, 0xf430,
	0xf445, 0xf45a, 0xf46f, 0xf484, 0xf499, 0xf4ae, 0xf4c3, 0xf4d8,
	0xf4ed, 0xf502, 0xf517, 0xf52c, 0xf541, 0xf556, 0xf56b, 0xf580,
	0xf595, 0xf5aa, 0xf5bf, 0xf5d4, 0xf5e9, 0xf5fe, 0xf613, 0xf628,
	// Entry 6680 - 66BF
	0xf63d, 0xf652, 0xf667, 0xf67c, 0xf691, 0xf6a6, 0xf6bb, 0xf6d0,
	0xf6e5, 0xf6fa, 0xf70f, 0xf724, 0xf739, 0xf74e, 0xf763, 0xf778,
	0xf78d, 0xf7a2, 0xf7b7, 0xf7cc, 0xf7e1, 0xf7f6, 0xf80b, 0xf820,
	0xf835, 0xf84a, 0xf85f, 0xf874, 0xf889, 0xf89e, 0xf8b3, 0xf8c8,
	0xf8dd, 0xf8f2, 0xf907, 0xf91c, 0xf931, 0xf946, 0xf95b, 0xf970,
	0xf985, 0xf99a, 0xf9af, 0xf9c4, 0xf9d9, 0xf9ee, 0xfa03, 0xfa18,
	0xfa2d, 0xfa42, 0xfa57, 0xfa6c, 0xfa81, 0xfa96, 0xfaab, 0xfac0,
	0xfad5, 0xfaea, 0xfaff, 0xfb14, 0xfb29, 0xfb3e, 0xfb53, 0xfb68,
	// Entry 66C0 - 66FF
	0xfb7d, 0xfb92, 0xfba7, 0xfbbc, 0xfbd1, 0xfbe6, 0xfbfb, 0xfc10,
	0xfc25, 0xfc3a, 0xfc4f, 0xfc64, 0xfc79, 0xfc8e, 0xfca3, 0xfcb8,
	0xfccd, 0xfce2, 0xfcf7, 0xfd0c, 0xfd21, 0xfd36, 0xfd4b, 0xfd60,
	0xfd75, 0xfd8a, 0xfd9f, 0xfdb4, 0xfdc9, 0xfdde, 0xfdf3, 0xfe08,
	0xfe1d, 0xfe32, 0xfe47, 0xfe5c, 0xfe71, 0xfe86, 0xfe9b, 0xfeb0,
	0xfec5, 0xfeda, 0xfeef, 0xff04, 0xff19, 0xff2e, 0xff43, 0xff58,
	0xff6d, 0xff82, 0xff97, 0xffac, 0xffc1, 0xffd6, 0xffeb, 0x0000,
	0x0015, 0x002a, 0x003f, 0x0054, 0x0069, 0x007e, 0x0093, 0x00a8,
	// Entry 6700 - 673F
	0x00bd, 0x00d2, 0x00e7, 0x00fc, 0x0111, 0x0126, 0x013b, 0x0150,
	0x0165, 0x017a, 0x018f, 0x01a4, 0x01b9, 0x01ce, 0x01e3, 0x01f8,
	0x020d, 0x0222, 0x0237, 0x024c, 0x0261, 0x0276, 0x028b, 0x02a0,
	0x02b5, 0x02ca, 0x02df, 0x02f4, 0x0309, 0x031e, 0x0333, 0x0348,
	0x035d, 0x0372, 0x0387, 0x039c, 0x03b1, 0x03c6, 0x03db, 0x03f0,
	0x0405, 0x041a, 0x042f, 0x0444, 0x0459, 0x046e, 0x0483, 0x0498,
	0x04ad, 0x04c2, 0x04d7, 0x04ec, 0x04fd, 0x050e, 0x051f, 0x0530,
	0x0541, 0x0552, 0x0563, 0x0574, 0x0585, 0x0596, 0x05a7, 0x05b8,
	// Entry 6740 - 677F
	0x05cb, 0x05de, 0x05f1, 0x0604, 0x0617, 0x0629, 0x0641, 0x0653,
	0x0665, 0x067c, 0x068e, 0x06a0, 0x06b2, 0x06c3, 0x06d4, 0x06e5,
	0x06f6, 0x0709, 0x071c, 0x072f, 0x0742, 0x075c, 0x0776, 0x0790,
	0x07bc, 0x07d6, 0x07f6, 0x0809, 0x081c, 0x082f, 0x0842, 0x0857,
	0x086c, 0x0881, 0x0896, 0x08b2, 0x08c5, 0x08da, 0x08ed, 0x0902,
	0x0915, 0x092a, 0x093d, 0x0952, 0x0963, 0x0975, 0x0988, 0x099b,
	0x09ae, 0x09c3, 0x09d8, 0x09eb, 0x0a00, 0x0a11, 0x0a29, 0x0a3b,
	0x0a4c, 0x0a5f, 0x0a70, 0x0a81, 0x0a93, 0x0aaa, 0x0abc, 0x0ace,
	// Entry 6780 - 67BF
	0x0ae6, 0x0b00, 0x0b18, 0x0b2e, 0x0b40, 0x0b51, 0x0b63, 0x0b75,
	0x0b88, 0x0b9e, 0x0bb8, 0x0bca, 0x0be1, 0x0bf4, 0x0c06, 0x0c18,
	0x0c2a, 0x0c3c, 0x0c4e, 0x0c61, 0x0c74, 0x0c8b, 0x0ca2, 0x0cb9,
	0x0cd0, 0x0ce9, 0x0d02, 0x0d1a, 0x0d32, 0x0d4a, 0x0d63, 0x0d88,
	0x0dac, 0x0dd2, 0x0df4, 0x0e16, 0x0e39, 0x0e57, 0x0e83, 0x0ea2,
	0x0ebe, 0x0edc, 0x0efa, 0x0f1e, 0x0f37, 0x0f56, 0x0f6f, 0x0f8d,
	0x0fa4, 0x0fbe, 0x0fd6, 0x0fee, 0x100a, 0x1022, 0x1040, 0x1058,
	0x1075, 0x108b, 0x10a4, 0x10bb, 0x10d2, 0x10ed, 0x1105, 0x111f,
	// Entry 67C0 - 67FF
	0x113d, 0x1151, 0x1177, 0x1196, 0x11b9, 0x11d3, 0x11eb, 0x1209,
	0x1228, 0x124c, 0x1276, 0x129a, 0x12c5, 0x12ea, 0x130b, 0x132d,
	0x1351, 0x1373, 0x139b, 0x13bc, 0x13e6, 0x140e, 0x142d, 0x144f,
	0x1472, 0x149b, 0x14bb, 0x14d9, 0x1501, 0x1529, 0x1548, 0x1569,
	0x1587, 0x15ad, 0x15d6, 0x1601, 0x1622, 0x1643, 0x166c, 0x1694,
	0x16bd, 0x16e7, 0x1708, 0x1727, 0x1745, 0x176d, 0x178d, 0x17b2,
	0x17d1, 0x17fa, 0x1827, 0x1852, 0x1870, 0x188e, 0x18aa, 0x18c7,
	0x18e7, 0x1909, 0x192f, 0x1957, 0x1979, 0x19a3, 0x19cb, 0x19ec,
	// Entry 6800 - 683F
	0x1a0e, 0x1a2f, 0x1a59, 0x1a79, 0x1aa6, 0x1ad3, 0x1af3, 0x1b10,
	0x1b30, 0x1b56, 0x1b7c, 0x1ba1, 0x1bc6, 0x1be7, 0x1c0a, 0x1c2c,
	0x1c4c, 0x1c6d, 0x1c95, 0x1cbd, 0x1ce2, 0x1d0c, 0x1d34, 0x1d53,
	0x1d7a, 0x1dab, 0x1dcb, 0x1df3, 0x1e13, 0x1e33, 0x1e57, 0x1e7a,
	0x1e9d, 0x1ec3, 0x1ee2, 0x1f05, 0x1f25, 0x1f4d, 0x1f75, 0x1fa0,
	0x1fc0, 0x1fe8, 0x200d, 0x2030, 0x2054, 0x2072, 0x2097, 0x20b8,
	0x20db, 0x2100, 0x2129, 0x2151, 0x2178, 0x21a3, 0x21cf, 0x21f6,
	0x221e, 0x2245, 0x226b, 0x2298, 0x22be, 0x22e6, 0x230e, 0x2333,
	// Entry 6840 - 687F
	0x235c, 0x237e, 0x23a0, 0x23c2, 0x23e3, 0x2403, 0x2426, 0x244d,
	0x2476, 0x249b, 0x24bf, 0x24e4, 0x2501, 0x251f, 0x253e, 0x255f,
	0x257f, 0x25ab, 0x25d6, 0x2603, 0x2633, 0x2662, 0x2689, 0x26bf,
	0x26f2, 0x2713, 0x2750, 0x278c, 0x27c1, 0x27e3, 0x2801, 0x2824,
	0x2844, 0x286c, 0x2893, 0x28b6, 0x28db, 0x28fe, 0x2922, 0x294a,
	0x2973, 0x29a1, 0x29d4, 0x2a04, 0x2a39, 0x2a67, 0x2a92, 0x2ac2,
	0x2afa, 0x2b29, 0x2b58, 0x2b88, 0x2bbc, 0x2bea, 0x2c17, 0x2c42,
	0x2c6f, 0x2ca1, 0x2cd9, 0x2d05, 0x2d32, 0x2d61, 0x2d82, 0x2da5,
	// Entry 6880 - 68BF
	0x2ddc, 0x2e08, 0x2e36, 0x2e60, 0x2e8c, 0x2ebf, 0x2eeb, 0x2f17,
	0x2f48, 0x2f78, 0x2faf, 0x2fe8, 0x301c, 0x3051, 0x3077, 0x309b,
	0x30c0, 0x30e5, 0x311b, 0x314f, 0x317a, 0x31a5, 0x31d2, 0x3203,
	0x323f, 0x3274, 0x32ac, 0x32dd, 0x3319, 0x334e, 0x3386, 0x33ac,
	0x33d2, 0x33fe, 0x342b, 0x3452, 0x347b, 0x34a4, 0x34d5, 0x3507,
	0x353b, 0x3563, 0x3593, 0x35c4, 0x35f7, 0x361b, 0x3640, 0x365f,
	0x3682, 0x36a6, 0x36c9, 0x36ec, 0x370f, 0x3732, 0x3755, 0x3780,
	0x37a9, 0x37d4, 0x37fd, 0x3821, 0x3849, 0x3866, 0x3883, 0x389f,
	// Entry 68C0 - 68FF
	0x38c3, 0x38e0, 0x38fc, 0x391b, 0x393b, 0x3955, 0x396d, 0x3983,
	0x3997, 0x39aa, 0x39ca, 0x39ea, 0x3a0a, 0x3a20, 0x3a3c, 0x3a56,
	0x3a6c, 0x3a80, 0x3a96, 0x3ab3, 0x3ad0, 0x3aef, 0x3b0d, 0x3b2b,
	0x3b48, 0x3b6b, 0x3b8f, 0x3ba4, 0x3bc5, 0x3be7, 0x3bfc, 0x3c11,
	0x3c32, 0x3c54, 0x3c6e, 0x3c88, 0x3cac, 0x3cc7, 0x3ce1, 0x3cf7,
	0x3d0f, 0x3d28, 0x3d43, 0x3d5a, 0x3d73, 0x3d94, 0x3db4, 0x3dce,
	0x3de5, 0x3dff, 0x3e1a, 0x3e3a, 0x3e5b, 0x3e74, 0x3e8d, 0x3ea5,
	0x3ec0, 0x3eda, 0x3ef7, 0x3f18, 0x3f38, 0x3f65, 0x3f7e, 0x3f9a,
	// Entry 6900 - 693F
	0x3fba, 0x3fde, 0x4002, 0x402b, 0x4054, 0x407f, 0x40aa, 0x40d6,
	0x4102, 0x412d, 0x4158, 0x4187, 0x41b6, 0x41d8, 0x41fa, 0x422b,
	0x425c, 0x427f, 0x429b, 0x42b8, 0x42d4, 0x42f9, 0x431e, 0x4332,
	0x434b, 0x4363, 0x437e, 0x4398, 0x43b5, 0x43d6, 0x43f6, 0x4423,
	0x4440, 0x446a, 0x448c, 0x44ae, 0x44d0, 0x44f1, 0x4512, 0x4533,
	0x455c, 0x457b, 0x459a, 0x45b9, 0x45d8, 0x45f7, 0x4610, 0x4627,
	0x463f, 0x4655, 0x466e, 0x4685, 0x46a0, 0x46b9, 0x46d8, 0x46f9,
	0x4718, 0x473e, 0x475e, 0x4787, 0x47af, 0x47cd, 0x47e9, 0x4807,
	// Entry 6940 - 697F
	0x4824, 0x4840, 0x485d, 0x487b, 0x4898, 0x48be, 0x48e4, 0x48fe,
	0x4913, 0x4923, 0x4937, 0x494b, 0x495f, 0x4977, 0x4991, 0x49b0,
	0x49d2, 0x49e3, 0x49f6, 0x4a12, 0x4a2b, 0x4a41, 0x4a61, 0x4a81,
	0x4aa1, 0x4ac1, 0x4ae1, 0x4b01, 0x4b21, 0x4b41, 0x4b61, 0x4b82,
	0x4ba3, 0x4bbd, 0x4bd7, 0x4bf3, 0x4c0e, 0x4c2f, 0x4c4e, 0x4c6f,
	0x4c96, 0x4caf, 0x4ccb, 0x4ce9, 0x4d04, 0x4d21, 0x4d40, 0x4d53,
	0x4d6a, 0x4d7f, 0x4d93, 0x4da8, 0x4dc7, 0x4de6, 0x4dfb, 0x4e16,
	0x4e35, 0x4e54, 0x4e6d, 0x4e86, 0x4ea8, 0x4ecc, 0x4ee6, 0x4f04,
	// Entry 6980 - 69BF
	0x4f1e, 0x4f3c, 0x4f73, 0x4fac, 0x4ff0, 0x5029, 0x5064, 0x50ac,
	0x50f4, 0x513c, 0x5150, 0x516f, 0x518e, 0x51a5, 0x51b9, 0x51cf,
	0x51e4, 0x51fc, 0x5213, 0x522a, 0x5242, 0x5261, 0x5280, 0x52a1,
	0x52be, 0x52da, 0x52fc, 0x531c, 0x5341, 0x5361, 0x5380, 0x53ac,
	0x53d6, 0x5401, 0x542a, 0x5449, 0x5466, 0x5483, 0x54a0, 0x54bd,
	0x54da, 0x54f7, 0x5514, 0x5531, 0x554e, 0x556c, 0x558a, 0x55a8,
	0x55c6, 0x55e4, 0x5602, 0x5620, 0x563e, 0x565c, 0x567a, 0x5698,
	0x56b6, 0x56d4, 0x56f2, 0x5710, 0x572e, 0x574c, 0x576a, 0x5788,
	// Entry 69C0 - 69FF
	0x57a6, 0x57ca, 0x57ee, 0x5812, 0x5836, 0x585a, 0x587e, 0x58a3,
	0x58c8, 0x58ed, 0x5912, 0x5937, 0x595c, 0x5981, 0x59a6, 0x59cb,
	0x59f0, 0x5a15, 0x5a3a, 0x5a5f, 0x5a84, 0x5aa9, 0x5ace, 0x5af3,
	0x5b18, 0x5b3d, 0x5b62, 0x5b87, 0x5bac, 0x5bd1, 0x5bf6, 0x5c1b,
	0x5c40, 0x5c65, 0x5c8a, 0x5caf, 0x5cd4, 0x5cf9, 0x5d18, 0x5d39,
	0x5d5a, 0x5d6e, 0x5d80, 0x5d91, 0x5da2, 0x5db5, 0x5dc7, 0x5dd9,
	0x5dea, 0x5dfd, 0x5e10, 0x5e22, 0x5e33, 0x5e47, 0x5e5b, 0x5e71,
	0x5e87, 0x5e9c, 0x5eb1, 0x5ec8, 0x5ede, 0x5ef4, 0x5f06, 0x5f1f,
	// Entry 6A00 - 6A3F
	0x5f35, 0x5f4e, 0x5f66, 0x5f76, 0x5f8a, 0x5fa3, 0x5fb6, 0x5fcb,
	0x5fe6, 0x5fff, 0x6013, 0x602b, 0x6046, 0x606f, 0x6087, 0x60a1,
	0x60b7, 0x60d0, 0x60e3, 0x60f8, 0x6112, 0x6127, 0x613e, 0x6153,
	0x6168, 0x6180, 0x6192, 0x61a3, 0x61bb, 0x61d2, 0x61e6, 0x61fa,
	0x6214, 0x6231, 0x6246, 0x625a, 0x6271, 0x6286, 0x629d, 0x62b3,
	0x62c7, 0x62dd, 0x62f4, 0x630e, 0x6324, 0x633f, 0x6357, 0x636a,
	0x6381, 0x639a, 0x63af, 0x63c3, 0x63d7, 0x63f8, 0x640f, 0x6424,
	0x643a, 0x644d, 0x6467, 0x6481, 0x649a, 0x64b4, 0x64c9, 0x64e3,
	// Entry 6A40 - 6A7F
	0x64fe, 0x6511, 0x6524, 0x6539, 0x654c, 0x6563, 0x657a, 0x658f,
	0x65a7, 0x65be, 0x65d4, 0x65ea, 0x6602, 0x6617, 0x662c, 0x6645,
	0x665d, 0x6677, 0x6691, 0x66a8, 0x66bf, 0x66da, 0x66f5, 0x6712,
	0x672e, 0x674a, 0x6765, 0x6782, 0x679f, 0x67bb, 0x67d6, 0x67f1,
	0x680e, 0x682a, 0x6846, 0x6861, 0x687e, 0x689b, 0x68b7, 0x68d1,
	0x68eb, 0x6907, 0x6922, 0x693d, 0x694b, 0x695a, 0x6975, 0x6990,
	0x69ab, 0x69c6, 0x69e1, 0x69fc, 0x6a17, 0x6a32, 0x6a4d, 0x6a68,
	0x6a83, 0x6a9e, 0x6ab9, 0x6ad4, 0x6aef, 0x6b0a, 0x6b25, 0x6b40,
	// Entry 6A80 - 6ABF
	0x6b5b, 0x6b76, 0x6b91, 0x6bac, 0x6bc7, 0x6be2, 0x6bfd, 0x6c18,
	0x6c31, 0x6c4a, 0x6c63, 0x6c7c, 0x6c95, 0x6cae, 0x6cc7, 0x6ce0,
	0x6cf9, 0x6d12, 0x6d2b, 0x6d44, 0x6d5d, 0x6d76, 0x6d8f, 0x6da8,
	0x6dc1, 0x6dda, 0x6df3, 0x6e0c, 0x6e25, 0x6e3e, 0x6e57, 0x6e70,
	0x6e89, 0x6ea2, 0x6ebf, 0x6edc, 0x6ef9, 0x6f16, 0x6f33, 0x6f50,
	0x6f6d, 0x6f8a, 0x6fa7, 0x6fc4, 0x6fe1, 0x6ffe, 0x701b, 0x7038,
	0x7055, 0x7072, 0x708f, 0x70ac, 0x70c9, 0x70e6, 0x7103, 0x7120,
	0x713d, 0x715a, 0x7177, 0x7194, 0x71af, 0x71ca, 0x71e5, 0x7200,
	// Entry 6AC0 - 6AFF
	0x721b, 0x7236, 0x7251, 0x726c, 0x7287, 0x72a2, 0x72bd, 0x72d8,
	0x72f3, 0x730e, 0x7329, 0x7344, 0x735f, 0x737a, 0x7395, 0x73b0,
	0x73cb, 0x73e6, 0x7401, 0x741c, 0x7437, 0x7459, 0x747b, 0x749d,
	0x74bf, 0x74e1, 0x7503, 0x7525, 0x7547, 0x7569, 0x758b, 0x75ad,
	0x75cf, 0x75f1, 0x7613, 0x7635, 0x7657, 0x7679, 0x769b, 0x76bd,
	0x76df, 0x7701, 0x7723, 0x7745, 0x7767, 0x7789, 0x77ab, 0x77cb,
	0x77eb, 0x780b, 0x782b, 0x784b, 0x786b, 0x788b, 0x78ab, 0x78cb,
	0x78eb, 0x790b, 0x792b, 0x794b, 0x796b, 0x798b, 0x79ab, 0x79cb,
	// Entry 6B00 - 6B3F
	0x79eb, 0x7a0b, 0x7a2b, 0x7a4b, 0x7a6b, 0x7a8b, 0x7aab, 0x7acb,
	0x7aeb, 0x7b08, 0x7b25, 0x7b42, 0x7b5f, 0x7b7c, 0x7b99, 0x7bb6,
	0x7bd3, 0x7bf0, 0x7c0d, 0x7c2a, 0x7c47, 0x7c64, 0x7c81, 0x7c9e,
	0x7cbb, 0x7cd8, 0x7cf5, 0x7d10, 0x7d2b, 0x7d46, 0x7d61, 0x7d7c,
	0x7d97, 0x7db2, 0x7dcd, 0x7de8, 0x7e03, 0x7e1e, 0x7e39, 0x7e54,
	0x7e6f, 0x7e8a, 0x7ea5, 0x7ec0, 0x7edb, 0x7ef6, 0x7f11, 0x7f2c,
	0x7f47, 0x7f62, 0x7f84, 0x7fa6, 0x7fc8, 0x7fea, 0x800c, 0x802e,
	0x8050, 0x8072, 0x8094, 0x80b6, 0x80d8, 0x80fa, 0x811c, 0x813e,
	// Entry 6B40 - 6B7F
	0x8160, 0x8182, 0x81a4, 0x81c6, 0x81e8, 0x820a, 0x822c, 0x824e,
	0x8270, 0x8292, 0x82b4, 0x82d6, 0x82f6, 0x8316, 0x8336, 0x8356,
	0x8376, 0x8396, 0x83b6, 0x83d6, 0x83f6, 0x8416, 0x8436, 0x8456,
	0x8476, 0x8496, 0x84b6, 0x84d6, 0x84f6, 0x8516, 0x8536, 0x8556,
	0x8576, 0x8596, 0x85b6, 0x85d6, 0x85f6, 0x8616, 0x8634, 0x8652,
	0x8670, 0x868e, 0x86ac, 0x86ca, 0x86e8, 0x8706, 0x8724, 0x8742,
	0x8760, 0x877e, 0x879c, 0x87ba, 0x87d8, 0x87f6, 0x8814, 0x8832,
	0x8850, 0x886e, 0x888c, 0x88a8, 0x88c4, 0x88e0, 0x88fc, 0x8918,
	// Entry 6B80 - 6BBF
	0x8934, 0x8950, 0x896c, 0x8988, 0x89a4, 0x89c0, 0x89dc, 0x89f8,
	0x8a14, 0x8a30, 0x8a4c, 0x8a68, 0x8a84, 0x8aa0, 0x8abc, 0x8ad8,
	0x8af4, 0x8b10, 0x8b2c, 0x8b48, 0x8b64, 0x8b88, 0x8bac, 0x8bd0,
	0x8bf4, 0x8c18, 0x8c3c, 0x8c60, 0x8c84, 0x8ca8, 0x8ccc, 0x8cf0,
	0x8d14, 0x8d38, 0x8d5c, 0x8d80, 0x8da4, 0x8dc8, 0x8dec, 0x8e10,
	0x8e32, 0x8e54, 0x8e76, 0x8e98, 0x8eba, 0x8edc, 0x8efe, 0x8f20,
	0x8f42, 0x8f64, 0x8f86, 0x8fa8, 0x8fca, 0x8fec, 0x900e, 0x9030,
	0x9052, 0x9074, 0x9096, 0x90b8, 0x90da, 0x90fc, 0x911e, 0x9140,
	// Entry 6BC0 - 6BFF
	0x9162, 0x9184, 0x91a7, 0x91ca, 0x91ed, 0x9210, 0x9233, 0x9256,
	0x9279, 0x929c, 0x92bf, 0x92e2, 0x9305, 0x9328, 0x934b, 0x936e,
	0x9391, 0x93b4, 0x93d7, 0x93fa, 0x941d, 0x9440, 0x9463, 0x9486,
	0x94a9, 0x94cc, 0x94ef, 0x9512, 0x9533, 0x9554, 0x9575, 0x9596,
	0x95b7, 0x95d8, 0x95f9, 0x961a, 0x963b, 0x965c, 0x967d, 0x969e,
	0x96bf, 0x96e0, 0x9701, 0x9722, 0x9743, 0x9764, 0x9785, 0x97a6,
	0x97c7, 0x97e8, 0x9809, 0x982a, 0x984b, 0x986c, 0x988d, 0x98ae,
	0x98cf, 0x98f0, 0x9911, 0x9932, 0x9953, 0x9974, 0x9995, 0x99b6,
	// Entry 6C00 - 6C3F
	0x99d7, 0x99f8, 0x9a19, 0x9a3a, 0x9a5b, 0x9a7c, 0x9a9d, 0x9abe,
	0x9adf, 0x9b00, 0x9b21, 0x9b42, 0x9b63, 0x9b84, 0x9ba5, 0x9bc6,
	0x9be5, 0x9c04, 0x9c23, 0x9c42, 0x9c61, 0x9c80, 0x9c9f, 0x9cbe,
	0x9cdd, 0x9cfc, 0x9d1b, 0x9d3a, 0x9d59, 0x9d78, 0x9d97, 0x9db6,
	0x9dd5, 0x9df4, 0x9e13, 0x9e32, 0x9e51, 0x9e70, 0x9e8f, 0x9eae,
	0x9ecd, 0x9eec, 0x9f12, 0x9f38, 0x9f5e, 0x9f84, 0x9faa, 0x9fd0,
	0x9ff6, 0xa01c, 0xa042, 0xa068, 0xa08e, 0xa0b4, 0xa0da, 0xa100,
	0xa126, 0xa14c, 0xa172, 0xa198, 0xa1be, 0xa1e4, 0xa20a, 0xa230,
	// Entry 6C40 - 6C7F
	0xa256, 0xa27c, 0xa2a2, 0xa2c8, 0xa2ec, 0xa310, 0xa334, 0xa358,
	0xa37c, 0xa3a0, 0xa3c4, 0xa3e8, 0xa40c, 0xa430, 0xa454, 0xa478,
	0xa49c, 0xa4c0, 0xa4e4, 0xa508, 0xa52c, 0xa550, 0xa574, 0xa598,
	0xa5bc, 0xa5e0, 0xa604, 0xa628, 0xa64c, 0xa670, 0xa698, 0xa6c0,
	0xa6e8, 0xa710, 0xa738, 0xa760, 0xa788, 0xa7b0, 0xa7d8, 0xa800,
	0xa828, 0xa850, 0xa878, 0xa8a0, 0xa8c8, 0xa8f0, 0xa918, 0xa940,
	0xa968, 0xa990, 0xa9b8, 0xa9e0, 0xaa08, 0xaa30, 0xaa58, 0xaa80,
	0xaaa6, 0xaacc, 0xaaf2, 0xab18, 0xab3e, 0xab64, 0xab8a, 0xabb0,
	// Entry 6C80 - 6CBF
	0xabd6, 0xabfc, 0xac22, 0xac48, 0xac6e, 0xac94, 0xacba, 0xace0,
	0xad06, 0xad2c, 0xad52, 0xad78, 0xad9e, 0xadc4, 0xadea, 0xae10,
	0xae36, 0xae5c, 0xae89, 0xaeb6, 0xaee3, 0xaf10, 0xaf3d, 0xaf6a,
	0xaf97, 0xafc4, 0xaff1, 0xb01e, 0xb04b, 0xb078, 0xb0a5, 0xb0d2,
	0xb0ff, 0xb12c, 0xb159, 0xb186, 0xb1b3, 0xb1e0, 0xb20d, 0xb23a,
	0xb267, 0xb294, 0xb2c1, 0xb2ee, 0xb319, 0xb344, 0xb36f, 0xb39a,
	0xb3c5, 0xb3f0, 0xb41b, 0xb446, 0xb471, 0xb49c, 0xb4c7, 0xb4f2,
	0xb51d, 0xb548, 0xb573, 0xb59e, 0xb5c9, 0xb5f4, 0xb61f, 0xb64a,
	// Entry 6CC0 - 6CFF
	0xb675, 0xb6a0, 0xb6cb, 0xb6f6, 0xb721, 0xb74c, 0xb76c, 0xb78c,
	0xb7ac, 0xb7cc, 0xb7ec, 0xb80c, 0xb82c, 0xb84c, 0xb86c, 0xb88c,
	0xb8ac, 0xb8cc, 0xb8ec, 0xb90c, 0xb92c, 0xb94c, 0xb96c, 0xb98c,
	0xb9ac, 0xb9cc, 0xb9ec, 0xba0c, 0xba2c, 0xba4c, 0xba6c, 0xba8c,
	0xbaaa, 0xbac8, 0xbae6, 0xbb04, 0xbb22, 0xbb40, 0xbb5e, 0xbb7c,
	0xbb9a, 0xbbb8, 0xbbd6, 0xbbf4, 0xbc12, 0xbc30, 0xbc4e, 0xbc6c,
	0xbc8a, 0xbca8, 0xbcc6, 0xbce4, 0xbd02, 0xbd20, 0xbd3e, 0xbd5c,
	0xbd7a, 0xbd98, 0xbdbb, 0xbdde, 0xbdfd, 0xbe1b, 0xbe3a, 0xbe59,
	// Entry 6D00 - 6D3F
	0xbe7a, 0xbe98, 0xbeb5, 0xbed4, 0xbef2, 0xbf11, 0xbf30, 0xbf4c,
	0xbf68, 0xbf84, 0xbfa5, 0xbfc1, 0xbfde, 0xc004, 0xc023, 0xc040,
	0xc061, 0xc07e, 0xc09b, 0xc0b8, 0xc0d7, 0xc0ee, 0xc10b, 0xc127,
	0xc144, 0xc161, 0xc180, 0xc19c, 0xc1b7, 0xc1d4, 0xc1f0, 0xc20d,
	0xc22a, 0xc244, 0xc25e, 0xc278, 0xc297, 0xc2b1, 0xc2cc, 0xc2ef,
	0xc30c, 0xc327, 0xc346, 0xc361, 0xc37c, 0xc397, 0xc3b4, 0xc3da,
	0xc3fa, 0xc418, 0xc436, 0xc452, 0xc46e, 0xc489, 0xc4aa, 0xc4ca,
	0xc4eb, 0xc50c, 0xc52f, 0xc54f, 0xc56e, 0xc58f, 0xc5af, 0xc5d0,
	// Entry 6D40 - 6D7F
	0xc5f1, 0xc60f, 0xc62d, 0xc64b, 0xc66e, 0xc68c, 0xc6ab, 0xc6d3,
	0xc6f4, 0xc713, 0xc736, 0xc755, 0xc774, 0xc793, 0xc7b4, 0xc7cd,
	0xc7ec, 0xc80a, 0xc829, 0xc848, 0xc869, 0xc887, 0xc8a4, 0xc8c3,
	0xc8e1, 0xc900, 0xc91f, 0xc93b, 0xc957, 0xc973, 0xc994, 0xc9b0,
	0xc9cd, 0xc9f2, 0xca11, 0xca2e, 0xca4f, 0xca6c, 0xca89, 0xcaa6,
	0xcac5, 0xcaed, 0xcb0f, 0xcb2f, 0xcb4f, 0xcb6d, 0xcb8b, 0xcba8,
	0xcbce, 0xcbf3, 0xcc19, 0xcc3f, 0xcc67, 0xcc8c, 0xccb0, 0xccd6,
	0xccfb, 0xcd21, 0xcd47, 0xcd6a, 0xcd8d, 0xcdb0, 0xcdd8, 0xcdfb,
	// Entry 6D80 - 6DBF
	0xce1f, 0xce4c, 0xce72, 0xce96, 0xcebe, 0xcee2, 0xcf06, 0xcf2a,
	0xcf50, 0xcf6e, 0xcf92, 0xcfb5, 0xcfd9, 0xcffd, 0xd023, 0xd046,
	0xd068, 0xd08c, 0xd0af, 0xd0d3, 0xd0f7, 0xd118, 0xd139, 0xd15a,
	0xd180, 0xd1a1, 0xd1c3, 0xd1ed, 0xd211, 0xd233, 0xd259, 0xd27b,
	0xd29d, 0xd2bf, 0xd2e3, 0xd310, 0xd337, 0xd35c, 0xd381, 0xd3a4,
	0xd3c7, 0xd3e9, 0xd413, 0xd43c, 0xd466, 0xd490, 0xd4bc, 0xd4e5,
	0xd50d, 0xd537, 0xd560, 0xd58a, 0xd5b4, 0xd5db, 0xd602, 0xd629,
	0xd655, 0xd67c, 0xd6a4, 0xd6d5, 0xd6ff, 0xd727, 0xd753, 0xd77b,
	// Entry 6DC0 - 6DFF
	0xd7a3, 0xd7cb, 0xd7f5, 0xd817, 0xd83f, 0xd866, 0xd88e, 0xd8b6,
	0xd8e0, 0xd907, 0xd92d, 0xd955, 0xd97c, 0xd9a4, 0xd9cc, 0xd9f1,
	0xda16, 0xda3b, 0xda65, 0xda8a, 0xdab0, 0xdade, 0xdb06, 0xdb2c,
	0xdb56, 0xdb7c, 0xdba2, 0xdbc8, 0xdbf0, 0xdc21, 0xdc4c, 0xdc75,
	0xdc9e, 0xdcc5, 0xdcec, 0xdd12, 0xdd43, 0xdd73, 0xdda4, 0xddd5,
	0xde08, 0xde38, 0xde67, 0xde98, 0xdec8, 0xdef9, 0xdf2a, 0xdf58,
	0xdf86, 0xdfb4, 0xdfe7, 0xe015, 0xe044, 0xe07c, 0xe0ad, 0xe0dc,
	0xe10f, 0xe13e, 0xe16d, 0xe19c, 0xe1cd, 0xe1f6, 0xe225, 0xe253,
	// Entry 6E00 - 6E3F
	0xe282, 0xe2b1, 0xe2e2, 0xe310, 0xe33d, 0xe36c, 0xe39a, 0xe3c9,
	0xe3f8, 0xe424, 0xe450, 0xe47c, 0xe4ad, 0xe4d9, 0xe506, 0xe53b,
	0xe56a, 0xe597, 0xe5c8, 0xe5f5, 0xe622, 0xe64f, 0xe67e, 0xe6b6,
	0xe6e8, 0xe718, 0xe748, 0xe776, 0xe7a4, 0xe7d1, 0xe7f2, 0xe811,
	0xe82d, 0xe848, 0xe863, 0xe880, 0xe89c, 0xe8b8, 0xe8d3, 0xe8f0,
	0xe90d, 0xe929, 0xe94e, 0xe972, 0xe996, 0xe9bc, 0xe9e1, 0xea06,
	0xea2a, 0xea50, 0xea76, 0xea9b, 0xeabd, 0xeade, 0xeaff, 0xeb22,
	0xeb44, 0xeb66, 0xeb87, 0xebaa, 0xebcd, 0xebef, 0xec16, 0xec3c,
	// Entry 6E40 - 6E7F
	0xec62, 0xec8a, 0xecb1, 0xecd8, 0xecfe, 0xed26, 0xed4e, 0xed75,
	0xed96, 0xedb6, 0xedd6, 0xedf8, 0xee19, 0xee3a, 0xee5a, 0xee7c,
	0xee9e, 0xeebf, 0xeeda, 0xeef7, 0xef11, 0xef2c, 0xef48, 0xef64,
	0xef84, 0xefa6, 0xefd2, 0xeffc, 0xf01e, 0xf040, 0xf066, 0xf089,
	0xf0ab, 0xf0cf, 0xf0f6, 0xf128, 0xf151, 0xf17d, 0xf1a9, 0xf1d5,
	0xf20c, 0xf244, 0xf277, 0xf2aa, 0xf2d4, 0xf300, 0xf32c, 0xf358,
	0xf380, 0xf3aa, 0xf3e0, 0xf416, 0xf443, 0xf47e, 0xf4b5, 0xf4f1,
	0xf528, 0xf562, 0xf591, 0xf5c1, 0xf5f0, 0xf61f, 0xf658, 0xf68f,
	// Entry 6E80 - 6EBF
	0xf6d0, 0xf70c, 0xf73e, 0xf770, 0xf7ae, 0xf7e3, 0xf81d, 0xf85e,
	0xf890, 0xf8c2, 0xf8f5, 0xf92c, 0xf962, 0xf997, 0xf9ca, 0xfa03,
	0xfa36, 0xfa65, 0xfa9b, 0xfad6, 0xfb08, 0xfb3e, 0xfb60, 0xfb87,
	0xfbb0, 0xfbdc, 0xfc0e, 0xfc3a, 0xfc6b, 0xfc98, 0xfcc1, 0xfcef,
	0xfd22, 0xfd5a, 0xfd88, 0xfdbb, 0xfdf2, 0xfe1a, 0xfe47, 0xfe76,
	0xfe9f, 0xfecf, 0xff0a, 0xff43, 0xff58, 0xff82, 0xff9c, 0xffbc,
	0xffe1, 0x0001, 0x0024, 0x0050, 0x0072, 0x009f, 0x00d1, 0x00f3,
	0x0108, 0x0128, 0x0146, 0x0169, 0x0187, 0x019c, 0x01b5, 0x01c9,
	// Entry 6EC0 - 6EFF
	0x01ed, 0x020c, 0x022e, 0x024b, 0x0272, 0x0294, 0x02b2, 0x02cb,
	0x02e2, 0x02f7, 0x0317, 0x0335, 0x0358, 0x0373, 0x039c, 0x03b2,
	0x03ce, 0x03f4, 0x0415, 0x0439, 0x0458, 0x0488, 0x04b8, 0x04ce,
	0x04f5, 0x051e, 0x0546, 0x056e, 0x058b, 0x05b7, 0x05e8, 0x061a,
	0x063b, 0x066c, 0x069b, 0x06cb, 0x06ea, 0x0715, 0x0736, 0x0755,
	0x0775, 0x07a0, 0x07c1, 0x07eb, 0x080d, 0x0830, 0x0858, 0x0881,
	0x08ba, 0x08ef, 0x0911, 0x0935, 0x0958, 0x097b, 0x09a4, 0x09cf,
	0x09f9, 0x0a14, 0x0a3e, 0x0a6d, 0x0a9e, 0x0abd, 0x0af5, 0x0b2e,
	// Entry 6F00 - 6F3F
	0x0b4b, 0x0b74, 0x0b95, 0x0bb8, 0x0bd9, 0x0bfb, 0x0c1c, 0x0c47,
	0x0c78, 0x0c98, 0x0cb8, 0x0cd8, 0x0cff, 0x0d28, 0x0d56, 0x0d81,
	0x0dab, 0x0dd8, 0x0dfe, 0x0e26, 0x0e52, 0x0e7a, 0x0e9b, 0x0eb8,
	0x0ed7, 0x0ef8, 0x0f23, 0x0f4d, 0x0f6f, 0x0f98, 0x0fbb, 0x0fe3,
	0x100d, 0x103c, 0x1063, 0x108c, 0x10b9, 0x10e5, 0x110e, 0x113d,
	0x116f, 0x11a6, 0x11dc, 0x1211, 0x1243, 0x1266, 0x128c, 0x12b3,
	0x12e8, 0x131e, 0x134f, 0x1380, 0x13b0, 0x13e2, 0x141a, 0x144e,
	0x1474, 0x149e, 0x14d2, 0x1506, 0x1539, 0x1561, 0x1581, 0x15a6,
	// Entry 6F40 - 6F7F
	0x15cd, 0x15f5, 0x1617, 0x163f, 0x1665, 0x168a, 0x16ac, 0x16c7,
	0x16e7, 0x1710, 0x173a, 0x175f, 0x1782, 0x17b2, 0x17e1, 0x1810,
	0x183d, 0x1869, 0x1898, 0x18c6, 0x18fb, 0x1910, 0x192a, 0x1942,
	0x195c, 0x1975, 0x198d, 0x19a7, 0x19c0, 0x19d9, 0x19f4, 0x1a0e,
	0x1a26, 0x1a40, 0x1a59, 0x1a6f, 0x1a87, 0x1a9e, 0x1ab9, 0x1ad4,
	0x1af4, 0x1b14, 0x1b36, 0x1b58, 0x1b76, 0x1b94, 0x1bb2, 0x1bd2,
	0x1bf2, 0x1c0e, 0x1c33, 0x1c5b, 0x1c83, 0x1cab, 0x1cd5, 0x1d09,
	0x1d3d, 0x1d6d, 0x1d9a, 0x1dc8, 0x1dfc, 0x1e31, 0x1e65, 0x1e9b,
	// Entry 6F80 - 6FBF
	0x1ecb, 0x1ef9, 0x1f29, 0x1f5a, 0x1f96, 0x1fba, 0x1ff1, 0x2021,
	0x2052, 0x208e, 0x20b7, 0x20e1, 0x210a, 0x2135, 0x2161, 0x218c,
	0x21ba, 0x21e4, 0x220f, 0x2239, 0x2261, 0x228a, 0x22b2, 0x22dd,
	0x2309, 0x2334, 0x235e, 0x2389, 0x23b3, 0x23e9, 0x241f, 0x245a,
	0x2491, 0x24c8, 0x2504, 0x2528, 0x2556, 0x2584, 0x25b2, 0x25da,
	0x2603, 0x262b, 0x2655, 0x2680, 0x26ac, 0x26d7, 0x2704, 0x2734,
	0x2765, 0x2795, 0x27c7, 0x27fa, 0x282e, 0x2861, 0x2896, 0x28cb,
	0x2901, 0x2936, 0x296d, 0x299e, 0x29cd, 0x29fe, 0x2a30, 0x2a6d,
	// Entry 6FC0 - 6FFF
	0x2a92, 0x2aca, 0x2afb, 0x2b36, 0x2b73, 0x2b97, 0x2bc3, 0x2bf0,
	0x2c1c, 0x2c41, 0x2c6a, 0x2c94, 0x2cbd, 0x2ce9, 0x2d16, 0x2d42,
	0x2d6d, 0x2d99, 0x2dc4, 0x2dfc, 0x2e34, 0x2e71, 0x2ea8, 0x2edf,
	0x2f1b, 0x2f40, 0x2f72, 0x2fa5, 0x2fd7, 0x300b, 0x3041, 0x3078,
	0x30ae, 0x30e6, 0x3125, 0x3165, 0x318e, 0x31b8, 0x31e1, 0x320a,
	0x3234, 0x325d, 0x328d, 0x32c3, 0x32fa, 0x3330, 0x3366, 0x339d,
	0x33d3, 0x3405, 0x3436, 0x3468, 0x348d, 0x34b2, 0x34da, 0x3500,
	0x3537, 0x356d, 0x35a3, 0x35d9, 0x3611, 0x3649, 0x3686, 0x36b8,
	// Entry 7000 - 703F
	0x36e9, 0x371a, 0x374b, 0x377e, 0x37b1, 0x37e9, 0x3820, 0x3858,
	0x388f, 0x38ca, 0x3905, 0x3946, 0x3987, 0x39c8, 0x3a09, 0x3a4a,
	0x3a8b, 0x3acc, 0x3b0d, 0x3b47, 0x3b81, 0x3bb7, 0x3bed, 0x3c28,
	0x3c61, 0x3c9a, 0x3cd9, 0x3d18, 0x3d5e, 0x3da4, 0x3de3, 0x3e22,
	0x3e61, 0x3ea0, 0x3ed8, 0x3f10, 0x3f44, 0x3f78, 0x3fb1, 0x3fdc,
	0x4008, 0x4033, 0x4060, 0x408e, 0x40b8, 0x40e2, 0x410c, 0x4136,
	0x4160, 0x4186, 0x41ac, 0x41d7, 0x4207, 0x423d, 0x4274, 0x42aa,
	0x42e1, 0x4325, 0x436a, 0x43ae, 0x43f2, 0x4437, 0x447b, 0x44b3,
	// Entry 7040 - 707F
	0x44eb, 0x452b, 0x456b, 0x459f, 0x45d3, 0x4615, 0x4657, 0x467a,
	0x469d, 0x46b5, 0x46cd, 0x46e6, 0x4701, 0x4721, 0x474d, 0x4771,
	0x478c, 0x479c, 0x47b0, 0x47dc, 0x4804, 0x4831, 0x485a, 0x4884,
	0x48a4, 0x48dc, 0x490f, 0x494a, 0x496a, 0x498f, 0x49b1, 0x49d9,
	0x4a01, 0x4a27, 0x4a4d, 0x4a69, 0x4a85, 0x4aa2, 0x4ab7, 0x4ad0,
	0x4ae7, 0x4b03, 0x4b21, 0x4b3b, 0x4b55, 0x4b71, 0x4b93, 0x4ba7,
	0x4bbf, 0x4bd9, 0x4bf9, 0x4c1f, 0x4c4c, 0x4c7e, 0x4ca5, 0x4cd3,
	0x4d06, 0x4d2a, 0x4d4f, 0x4d75, 0x4d8e, 0x4da8, 0x4dc1, 0x4dde,
	// Entry 7080 - 70BF
	0x4dfd, 0x4e19, 0x4e29, 0x4e41, 0x4e59, 0x4e72, 0x4e8a, 0x4ea5,
	0x4ebf, 0x4ee3, 0x4f07, 0x4f20, 0x4f39, 0x4f59, 0x4f79, 0x4f99,
	0x4fb0, 0x4fd0, 0x4fec, 0x5003, 0x5023, 0x503f, 0x505c, 0x507a,
	0x5099, 0x50b4, 0x50d8, 0x50f8, 0x5118, 0x5141, 0x5166, 0x517c,
	0x519a, 0x51b9, 0x51d0, 0x51ef, 0x520d, 0x522e, 0x524e, 0x526e,
	0x5287, 0x52a8, 0x52c9, 0x52ec, 0x530b, 0x532e, 0x535a, 0x5381,
	0x53a7, 0x53cd, 0x53f3, 0x5404, 0x541e, 0x5439, 0x545d, 0x5476,
	0x5498, 0x54b3, 0x54d5, 0x54f8, 0x5508, 0x5518, 0x552e, 0x554c,
	// Entry 70C0 - 70FF
	0x556e, 0x5595, 0x55bd, 0x55e4, 0x5610, 0x5637, 0x565c, 0x568a,
	0x56a6, 0x56bf, 0x56d8, 0x56f1, 0x570a, 0x5723, 0x573c, 0x5755,
	0x5767, 0x578b, 0x57b0, 0x57cb, 0x57e5, 0x57ff, 0x581d, 0x5837,
	0x5858, 0x5869, 0x587e, 0x5893, 0x58a4, 0x58bb, 0x58d6, 0x58f1,
	0x590c, 0x5927, 0x5942, 0x5961, 0x5980, 0x599f, 0x59be, 0x59dd,
	0x59fc, 0x5a1b, 0x5a3a, 0x5a5a, 0x5a7a, 0x5a9a, 0x5aba, 0x5ada,
	0x5afa, 0x5b1a, 0x5b39, 0x5b59, 0x5b79, 0x5b9c, 0x5bbd, 0x5bde,
	0x5c01, 0x5c23, 0x5c43, 0x5c6b, 0x5c88, 0x5caa, 0x5cca, 0x5ced,
	// Entry 7100 - 713F
	0x5d10, 0x5d31, 0x5d50, 0x5d72, 0x5d93, 0x5db4, 0x5dd6, 0x5df5,
	0x5e16, 0x5e36, 0x5e56, 0x5e75, 0x5e97, 0x5eb6, 0x5ed6, 0x5ef6,
	0x5f16, 0x5f34, 0x5f59, 0x5f77, 0x5fa4, 0x5fc7, 0x5ff2, 0x6012,
	0x6032, 0x6053, 0x6074, 0x6094, 0x60b4, 0x60d4, 0x60f4, 0x6115,
	0x6135, 0x6155, 0x6175, 0x6195, 0x61b6, 0x61d8, 0x61f8, 0x6218,
	0x6239, 0x625a, 0x627a, 0x629c, 0x62bd, 0x62dd, 0x62fd, 0x631d,
	0x633d, 0x635e, 0x637e, 0x639f, 0x63c0, 0x63e1, 0x6403, 0x6424,
	0x6445, 0x6466, 0x6486, 0x64a7, 0x64c6, 0x64e6, 0x6505, 0x6524,
	// Entry 7140 - 717F
	0x6543, 0x6563, 0x6582, 0x65a2, 0x65c1, 0x65de, 0x65fb, 0x6618,
	0x6635, 0x6652, 0x666f, 0x668c, 0x66b2, 0x66d7, 0x66ff, 0x6725,
	0x6751, 0x6772, 0x679c, 0x67bd, 0x67dd, 0x67fd, 0x681f, 0x6840,
	0x6861, 0x6881, 0x68a3, 0x68c5, 0x68e6, 0x690a, 0x692b, 0x693b,
	0x694a, 0x695a, 0x696a, 0x697a, 0x698a, 0x699a, 0x69ab, 0x69bb,
	0x69cb, 0x69db, 0x69eb, 0x69fc, 0x6a0c, 0x6a1c, 0x6a2d, 0x6a3d,
	0x6a4d, 0x6a5d, 0x6a6d, 0x6a7d, 0x6a8c, 0x6a9c, 0x6aac, 0x6abc,
	0x6acd, 0x6add, 0x6aec, 0x6afb, 0x6b0c, 0x6b1b, 0x6b2d, 0x6b3e,
	// Entry 7180 - 71BF
	0x6b4f, 0x6b60, 0x6b72, 0x6b83, 0x6b94, 0x6ba4, 0x6bb4, 0x6bc5,
	0x6bd6, 0x6be7, 0x6bf8, 0x6c07, 0x6c18, 0x6c27, 0x6c38, 0x6c49,
	0x6c59, 0x6c69, 0x6c7b, 0x6c8c, 0x6c9d, 0x6cad, 0x6cbf, 0x6cd1,
	0x6ce2, 0x6cf2, 0x6d10, 0x6d2e, 0x6d4c, 0x6d6b, 0x6d89, 0x6da8,
	0x6dc6, 0x6de5, 0x6e03, 0x6e21, 0x6e3f, 0x6e5e, 0x6e7c, 0x6e9b,
	0x6eb9, 0x6ed8, 0x6ef7, 0x6f16, 0x6f35, 0x6f54, 0x6f73, 0x6f92,
	0x6fb1, 0x6fd0, 0x6fef, 0x700f, 0x702f, 0x704d, 0x706b, 0x7089,
	0x70a8, 0x70c6, 0x70e5, 0x7103, 0x7120, 0x713d, 0x715a, 0x7178,
	// Entry 71C0 - 71FF
	0x7195, 0x71b3, 0x71d0, 0x71ee, 0x720c, 0x722a, 0x7248, 0x7266,
	0x7284, 0x72a2, 0x72c0, 0x72df, 0x72fd, 0x731c, 0x733a, 0x7359,
	0x7377, 0x7395, 0x73b3, 0x73d2, 0x73f0, 0x740f, 0x742d, 0x7450,
	0x746e, 0x748c, 0x74aa, 0x74c9, 0x74e8, 0x7506, 0x7524, 0x7542,
	0x7560, 0x757f, 0x759d, 0x75bc, 0x75da, 0x75f8, 0x7616, 0x7634,
	0x7653, 0x7671, 0x7690, 0x76ae, 0x76d1, 0x76ef, 0x770d, 0x772b,
	0x774a, 0x7768, 0x7787, 0x77a5, 0x77c3, 0x77e1, 0x77ff, 0x781e,
	0x783c, 0x785b, 0x7879, 0x7898, 0x78b7, 0x78d6, 0x78f5, 0x7914,
	// Entry 7200 - 723F
	0x7933, 0x7952, 0x7970, 0x798e, 0x79ac, 0x79cb, 0x79e9, 0x7a08,
	0x7a26, 0x7a46, 0x7a66, 0x7a85, 0x7aa4, 0x7ac3, 0x7ae2, 0x7b01,
	0x7b21, 0x7b41, 0x7b61, 0x7b81, 0x7ba2, 0x7bc2, 0x7be3, 0x7c03,
	0x7c24, 0x7c45, 0x7c6a, 0x7c90, 0x7cb5, 0x7cd3, 0x7cf1, 0x7d0f,
	0x7d2e, 0x7d4e, 0x7d6e, 0x7d8e, 0x7dae, 0x7dcf, 0x7ded, 0x7e0b,
	0x7e29, 0x7e48, 0x7e66, 0x7e85, 0x7ea3, 0x7ec2, 0x7ee1, 0x7f00,
	0x7f20, 0x7f40, 0x7f5f, 0x7f7f, 0x7f9e, 0x7fbe, 0x7fe2, 0x8007,
	0x802b, 0x804a, 0x8069, 0x8088, 0x80a8, 0x80c7, 0x80e7, 0x8106,
	// Entry 7240 - 727F
	0x8125, 0x8144, 0x8163, 0x8183, 0x81a2, 0x81c2, 0x81e1, 0x81ff,
	0x821e, 0x823d, 0x825c, 0x827c, 0x829b, 0x82bb, 0x82da, 0x82f9,
	0x8318, 0x8338, 0x8358, 0x8376, 0x8394, 0x83b2, 0x83d1, 0x83ef,
	0x840e, 0x842c, 0x844c, 0x846c, 0x848c, 0x84ac, 0x84cc, 0x84e3,
	0x84fa, 0x8513, 0x852b, 0x8543, 0x855a, 0x8573, 0x858c, 0x85a4,
	0x85c8, 0x85eb, 0x8612, 0x863a, 0x8666, 0x8696, 0x86bd, 0x86d6,
	0x86f0, 0x8709, 0x8722, 0x8739, 0x8758, 0x876f, 0x8787, 0x879e,
	0x87b4, 0x87cb, 0x87e1, 0x87f7, 0x880f, 0x8827, 0x883f, 0x8857,
	// Entry 7280 - 72BF
	0x886f, 0x8886, 0x889c, 0x88b5, 0x88cd, 0x88e4, 0x88fd, 0x8914,
	0x892c, 0x8943, 0x895b, 0x8972, 0x898a, 0x89a2, 0x89ba, 0x89d2,
	0x89ea, 0x8a01, 0x8a19, 0x8a30, 0x8a47, 0x8a5c, 0x8a79, 0x8a8e,
	0x8aa4, 0x8ab9, 0x8acd, 0x8ae2, 0x8af6, 0x8b0a, 0x8b20, 0x8b36,
	0x8b4c, 0x8b62, 0x8b78, 0x8b8d, 0x8ba1, 0x8bb8, 0x8bce, 0x8be3,
	0x8bfa, 0x8c0f, 0x8c25, 0x8c3a, 0x8c50, 0x8c65, 0x8c7b, 0x8c91,
	0x8ca7, 0x8cbd, 0x8cd3, 0x8ce8, 0x8cfe, 0x8d13, 0x8d1e, 0x8d36,
	0x8d57, 0x8d62, 0x8d79, 0x8d89, 0x8d98, 0x8da7, 0x8db8, 0x8dc8,
	// Entry 72C0 - 72FF
	0x8dd8, 0x8de7, 0x8df8, 0x8e09, 0x8e19, 0x8e37, 0x8e52, 0x8e68,
	0x8e7e, 0x8e96, 0x8ead, 0x8ec4, 0x8eda, 0x8ef2, 0x8f0a, 0x8f21,
	0x8f37, 0x8f50, 0x8f69, 0x8f81, 0x8f99, 0x8fb1, 0x8fcb, 0x8fe4,
	0x8ffd, 0x901b, 0x9039, 0x9059, 0x9078, 0x9097, 0x90b5, 0x90d5,
	0x90f5, 0x9114, 0x9133, 0x9152, 0x9173, 0x9193, 0x91b3, 0x91d2,
	0x91f3, 0x9214, 0x9234, 0x9253, 0x9275, 0x9297, 0x92b8, 0x92d9,
	0x92fa, 0x931d, 0x933f, 0x9361, 0x9378, 0x9391, 0x93a6, 0x93be,
	0x93d8, 0x93f7, 0x9416, 0x9437, 0x9457, 0x9477, 0x9496, 0x94b7,
	// Entry 7300 - 733F
	0x94d8, 0x94f8, 0x950f, 0x952f, 0x954c, 0x956f, 0x9585, 0x95a5,
	0x95c5, 0x95ee, 0x960d, 0x9625, 0x963d, 0x9657, 0x9670, 0x9689,
	0x96a1, 0x96bb, 0x96d5, 0x96ee, 0x9706, 0x9721, 0x973c, 0x9756,
	0x9770, 0x978a, 0x97a6, 0x97c1, 0x97dc, 0x97fc, 0x981c, 0x983e,
	0x985f, 0x9880, 0x98a0, 0x98c2, 0x98e4, 0x9905, 0x9926, 0x9947,
	0x996a, 0x998c, 0x99ae, 0x99cf, 0x99f2, 0x9a15, 0x9a37, 0x9a58,
	0x9a7c, 0x9aa0, 0x9ac3, 0x9ae6, 0x9b09, 0x9b2e, 0x9b52, 0x9b76,
	0x9b8c, 0x9bae, 0x9bd2, 0x9bf5, 0x9c18, 0x9c3a, 0x9c5e, 0x9c82,
	// Entry 7340 - 737F
	0x9ca5, 0x9cc7, 0x9cf2, 0x9d1c, 0x9d47, 0x9d72, 0x9d91, 0x9db1,
	0x9dc9, 0x9de0, 0x9df8, 0x9e0f, 0x9e26, 0x9e3e, 0x9e55, 0x9e6c,
	0x9e83, 0x9e9a, 0x9eb1, 0x9ec9, 0x9ee1, 0x9ef9, 0x9f10, 0x9f27,
	0x9f3e, 0x9f55, 0x9f6c, 0x9f85, 0x9f9c, 0x9fb4, 0x9fcc, 0x9fe4,
	0x9ffb, 0xa012, 0xa02b, 0xa04a, 0xa06a, 0xa089, 0xa0a8, 0xa0c7,
	0xa0e7, 0xa106, 0xa125, 0xa144, 0xa163, 0xa182, 0xa1a2, 0xa1c2,
	0xa1e2, 0xa201, 0xa220, 0xa23f, 0xa25e, 0xa27f, 0xa29e, 0xa2be,
	0xa2de, 0xa2fd, 0xa31e, 0xa33d, 0xa35b, 0xa379, 0xa397, 0xa3b6,
	// Entry 7380 - 73BF
	0xa3d5, 0xa3f3, 0xa411, 0xa42f, 0xa44f, 0xa46e, 0xa48c, 0xa4ac,
	0xa4d3, 0xa4f9, 0xa51a, 0xa53c, 0xa55d, 0xa57e, 0xa59f, 0xa5c0,
	0xa5e1, 0xa603, 0xa625, 0xa647, 0xa668, 0xa689, 0xa6aa, 0xa6cb,
	0xa6ee, 0xa70f, 0xa731, 0xa753, 0xa774, 0xa795, 0xa7b8, 0xa7e1,
	0xa80a, 0xa829, 0xa847, 0xa866, 0xa884, 0xa8a2, 0xa8c0, 0xa8df,
	0xa8fd, 0xa91b, 0xa939, 0xa957, 0xa976, 0xa995, 0xa9b4, 0xa9d2,
	0xa9f0, 0xaa0e, 0xaa2c, 0xaa4a, 0xaa6a, 0xaa88, 0xaaa7, 0xaac6,
	0xaae5, 0xab03, 0xab21, 0xab41, 0xab66, 0xab8c, 0xabb1, 0xabd6,
	// Entry 73C0 - 73FF
	0xabfc, 0xac21, 0xac46, 0xac6b, 0xac90, 0xacb6, 0xacdc, 0xad02,
	0xad27, 0xad4c, 0xad71, 0xad96, 0xadbb, 0xade2, 0xae07, 0xae2d,
	0xae53, 0xae79, 0xae9e, 0xaec3, 0xaeea, 0xaf21, 0xaf4a, 0xaf60,
	0xaf77, 0xaf8d, 0xafa4, 0xafbb, 0xafd4, 0xafed, 0xb00b, 0xb029,
	0xb049, 0xb068, 0xb087, 0xb0a5, 0xb0c5, 0xb0e5, 0xb104, 0xb11f,
	0xb13a, 0xb157, 0xb173, 0xb18f, 0xb1aa, 0xb1c7, 0xb1e4, 0xb200,
	0xb21b, 0xb236, 0xb253, 0xb26f, 0xb28b, 0xb2a6, 0xb2c3, 0xb2e0,
	0xb2fc, 0xb30d, 0xb320, 0xb333, 0xb34d, 0xb360, 0xb373, 0xb386,
	// Entry 7400 - 743F
	0xb399, 0xb3ab, 0xb3bc, 0xb3d7, 0xb3f3, 0xb40f, 0xb42b, 0xb447,
	0xb463, 0xb47f, 0xb49b, 0xb4b7, 0xb4d3, 0xb4ef, 0xb50b, 0xb527,
	0xb543, 0xb55f, 0xb57b, 0xb597, 0xb5b3, 0xb5cf, 0xb5eb, 0xb607,
	0xb623, 0xb63f, 0xb65b, 0xb677, 0xb693, 0xb6af, 0xb6cb, 0xb6e7,
	0xb703, 0xb71f, 0xb73b, 0xb757, 0xb773, 0xb78f, 0xb7ab, 0xb7c7,
	0xb7e3, 0xb7ff, 0xb81b, 0xb837, 0xb853, 0xb86f, 0xb88b, 0xb8a7,
	0xb8c3, 0xb8df, 0xb8fb, 0xb917, 0xb933, 0xb94c, 0xb966, 0xb980,
	0xb99a, 0xb9b4, 0xb9ce, 0xb9e8, 0xba02, 0xba1c, 0xba36, 0xba50,
	// Entry 7440 - 747F
	0xba6a, 0xba84, 0xba9e, 0xbab8, 0xbad2, 0xbaec, 0xbb06, 0xbb20,
	0xbb3a, 0xbb54, 0xbb6e, 0xbb88, 0xbba2, 0xbbbc, 0xbbd6, 0xbbf0,
	0xbc0a, 0xbc24, 0xbc3e, 0xbc58, 0xbc72, 0xbc8c, 0xbca6, 0xbcc0,
	0xbcda, 0xbcf4, 0xbd0e, 0xbd28, 0xbd42, 0xbd5c, 0xbd76, 0xbd90,
	0xbdaa, 0xbdc4, 0xbdde, 0xbdf8, 0xbe12, 0xbe2c, 0xbe46, 0xbe57,
	0xbe71, 0xbe8b, 0xbea7, 0xbec2, 0xbedd, 0xbef7, 0xbf13, 0xbf2f,
	0xbf4a, 0xbf64, 0xbf7f, 0xbf9c, 0xbfb8, 0xbfd3, 0xbfed, 0xc007,
	0xc023, 0xc03e, 0xc059, 0xc073, 0xc08f, 0xc0ab, 0xc0c6, 0xc0e0,
	// Entry 7480 - 74BF
	0xc0fb, 0xc118, 0xc134, 0xc14f, 0xc165, 0xc181, 0xc19d, 0xc1bb,
	0xc1d8, 0xc1f5, 0xc211, 0xc22f, 0xc24d, 0xc26a, 0xc286, 0xc2a3,
	0xc2c2, 0xc2e0, 0xc2fd, 0xc315, 0xc32e, 0xc347, 0xc362, 0xc37c,
	0xc396, 0xc3af, 0xc3ca, 0xc3e5, 0xc3ff, 0xc418, 0xc432, 0xc44e,
	0xc469, 0xc483, 0xc49b, 0xc4ac, 0xc4c0, 0xc4d4, 0xc4e8, 0xc4fc,
	0xc510, 0xc524, 0xc538, 0xc54c, 0xc560, 0xc575, 0xc58a, 0xc59f,
	0xc5b4, 0xc5c9, 0xc5de, 0xc5f3, 0xc608, 0xc61d, 0xc632, 0xc647,
	0xc65c, 0xc670, 0xc680, 0xc68f, 0xc69e, 0xc6af, 0xc6bf, 0xc6cf,
	// Entry 74C0 - 74FF
	0xc6de, 0xc6ef, 0xc700, 0xc710, 0xc735, 0xc763, 0xc787, 0xc7ab,
	0xc7cf, 0xc7f3, 0xc817, 0xc83b, 0xc85f, 0xc883, 0xc8a7, 0xc8cb,
	0xc8ef, 0xc913, 0xc937, 0xc95b, 0xc97f, 0xc9a3, 0xc9c7, 0xc9eb,
	0xca0f, 0xca33, 0xca57, 0xca7b, 0xca9f, 0xcac3, 0xcae7, 0xcb0b,
	0xcb3a, 0xcb5f, 0xcb84, 0xcb8e, 0xcb98, 0xcba7, 0xcbc5, 0xcbe3,
	0xcc01, 0xcc1f, 0xcc3d, 0xcc5b, 0xcc79, 0xcc97, 0xccb5, 0xccd3,
	0xccf1, 0xcd0f, 0xcd2d, 0xcd4b, 0xcd69, 0xcd87, 0xcda5, 0xcdc3,
	0xcde1, 0xcdff, 0xce1d, 0xce3b, 0xce59, 0xce77, 0xce95, 0xceb3,
	// Entry 7500 - 753F
	0xcebd, 0xcec7, 0xced1, 0xcedb, 0xcee6, 0xcef0, 0xcf17, 0xcf3e,
	0xcf65, 0xcf8c, 0xcfb3, 0xcfda, 0xd001, 0xd028, 0xd04f, 0xd076,
	0xd09d, 0xd0c4, 0xd0eb, 0xd112, 0xd139, 0xd160, 0xd187, 0xd1ae,
	0xd1d5, 0xd1fc, 0xd223, 0xd24a, 0xd271, 0xd298, 0xd2bf, 0xd2e6,
	0xd2f4, 0xd302, 0xd310, 0xd337, 0xd35e, 0xd385, 0xd3ac, 0xd3d3,
	0xd3fa, 0xd421, 0xd448, 0xd46f, 0xd496, 0xd4bd, 0xd4e4, 0xd50b,
	0xd532, 0xd559, 0xd580, 0xd5a7, 0xd5ce, 0xd5f5, 0xd61c, 0xd643,
	0xd66a, 0xd691, 0xd6b8, 0xd6df, 0xd706, 0xd735, 0xd748, 0xd75b,
	// Entry 7540 - 757F
	0xd76e, 0xd781, 0xd794, 0xd79d, 0xd7a7, 0xd7b3, 0xd7bf, 0xd7c9,
	0xd7d4, 0xd7de, 0xd7e8, 0xd7f3, 0xd813, 0xd81d, 0xd82c, 0xd841,
	0xd84e, 0xd85c, 0xd86b, 0xd881, 0xd898, 0xd8b4, 0xd8c3, 0xd8df,
	0xd8fb, 0xd905, 0xd910, 0xd91e, 0xd92e, 0xd939, 0xd944, 0xd94f,
	0xd971, 0xd993, 0xd9b5, 0xd9d7, 0xd9f9, 0xda1b, 0xda3d, 0xda5f,
	0xda81, 0xdaa3, 0xdac5, 0xdae7, 0xdb09, 0xdb2b, 0xdb4d, 0xdb6f,
	0xdb91, 0xdbb3, 0xdbd5, 0xdbf7, 0xdc19, 0xdc3b, 0xdc5d, 0xdc7f,
	0xdca1, 0xdcc3, 0xdcd7, 0xdcec, 0xdcff, 0xdd21, 0xdd43, 0xdd65,
	// Entry 7580 - 75BF
	0xdd78, 0xdd9a, 0xddbc, 0xddde, 0xde00, 0xde22, 0xde44, 0xde66,
	0xde88, 0xdeaa, 0xdecc, 0xdeee, 0xdf10, 0xdf32, 0xdf54, 0xdf76,
	0xdf98, 0xdfba, 0xdfdc, 0xdffe, 0xe020, 0xe042, 0xe064, 0xe086,
	0xe0a8, 0xe0ca, 0xe0ec, 0xe10e, 0xe130, 0xe152, 0xe174, 0xe196,
	0xe1b8, 0xe1da, 0xe1fc, 0xe21e, 0xe240, 0xe262, 0xe284, 0xe2a6,
	0xe2c8, 0xe2fb, 0xe32e, 0xe361, 0xe394, 0xe3c7, 0xe3fa, 0xe42d,
	0xe460, 0xe493, 0xe4ae, 0xe4c6, 0xe4db, 0xe4f0, 0xe507, 0xe51c,
	0xe537, 0xe54d, 0xe554, 0xe559, 0xe568, 0xe578, 0xe58e, 0xe595,
	// Entry 75C0 - 75FF
	0xe5a6, 0xe5bb, 0xe5c2, 0xe5d1, 0xe5db, 0xe5e2, 0xe5eb, 0xe604,
	0xe618, 0xe632, 0xe646, 0xe655, 0xe670, 0xe689, 0xe6a3, 0xe6b3,
	0xe6cd, 0xe6e5, 0xe700, 0xe70d, 0xe71f, 0xe73b, 0xe756, 0xe769,
	0xe776, 0xe782, 0xe78f, 0xe79a, 0xe7a7, 0xe7b0, 0xe7ca, 0xe7e0,
	0xe800, 0xe80f, 0xe81e, 0xe832, 0xe844, 0xe847, 0xe858, 0xe85f,
	0xe863, 0xe86a, 0xe872, 0xe87a, 0xe888, 0xe896, 0xe89f, 0xe8a5,
	0xe8af, 0xe8b4, 0xe8c2, 0xe8c6, 0xe8ce, 0xe8d7, 0xe8de, 0xe8ea,
	0xe8f5, 0xe8f9, 0xe909, 0xe913, 0xe91e, 0xe935, 0xe93d, 0xe943,
	// Entry 7600 - 763F
	0xe94c, 0xe952, 0xe957, 0xe961, 0xe96a, 0xe96f, 0xe975, 0xe97e,
	0xe987, 0xe992, 0xe996, 0xe99b, 0xe9a3, 0xe9ad, 0xe9b6, 0xe9c4,
	0xe9d0, 0xe9db, 0xe9e7, 0xe9f0, 0xe9fb, 0xea09, 0xea16, 0xea1f,
	0xea24, 0xea30, 0xea44, 0xea49, 0xea4d, 0xea52, 0xea5e, 0xea79,
	0xea87, 0xea91, 0xea9a, 0xeaa2, 0xeaa8, 0xeab5, 0xeaba, 0xeac2,
	0xeac9, 0xead2, 0xeadb, 0xeae4, 0xeaef, 0xeaf6, 0xeb04, 0xeb19,
	0xeb2c, 0xeb36, 0xeb44, 0xeb52, 0xeb5a, 0xeb6c, 0xeb77, 0xeb90,
	0xeba8, 0xebaf, 0xebb5, 0xebc4, 0xebd1, 0xebdf, 0xebed, 0xebfd,
	// Entry 7640 - 767F
	0xec06, 0xec17, 0xec1e, 0xec2a, 0xec37, 0xec44, 0xec51, 0xec60,
	0xec6e, 0xec7b, 0xec85, 0xec9a, 0xeca8, 0xecb6, 0xecd0, 0xece2,
	0xecf0, 0xecff, 0xed1a, 0xed2b, 0xed37, 0xed44, 0xed62, 0xed81,
	0xed8c, 0xed9d, 0xedab, 0xedb7, 0xedc5, 0xedda, 0xede4, 0xedf0,
	0xedf6, 0xedff, 0xee0d, 0xee14, 0xee1f, 0xee25, 0xee32, 0xee41,
	0xee4b, 0xee55, 0xee61, 0xee6a, 0xee72, 0xee79, 0xee8d, 0xee99,
	0xeeaf, 0xeeb8, 0xeebe, 0xeece, 0xeed5, 0xeedb, 0xeee8, 0xeeff,
	0xef16, 0xef26, 0xef39, 0xef47, 0xef52, 0xef58, 0xef5e, 0xef6a,
	// Entry 7680 - 76BF
	0xef70, 0xef7c, 0xef8d, 0xef9b, 0xefa2, 0xefaf, 0xefb5, 0xefc6,
	0xefd0, 0xefe4, 0xefee, 0xf009, 0xf022, 0xf03e, 0xf052, 0xf059,
	0xf06c, 0xf081, 0xf090, 0xf099, 0xf0b0, 0xf0c2, 0xf0c8, 0xf0d5,
	0xf0e2, 0xf0e9, 0xf0f7, 0xf108, 0xf117, 0xf12b, 0xf13f, 0xf147,
	0xf14b, 0xf163, 0xf168, 0xf172, 0xf183, 0xf189, 0xf199, 0xf1a0,
	0xf1af, 0xf1be, 0xf1cd, 0xf1da, 0xf1e7, 0xf1f8, 0xf209, 0xf210,
	0xf21d, 0xf222, 0xf243, 0xf250, 0xf257, 0xf27a, 0xf29b, 0xf2bc,
	0xf2dd, 0xf2fe, 0xf301, 0xf306, 0xf308, 0xf315, 0xf318, 0xf31d,
	// Entry 76C0 - 76FF
	0xf324, 0xf32a, 0xf32d, 0xf333, 0xf33c, 0xf341, 0xf346, 0xf34b,
	0xf350, 0xf353, 0xf357, 0xf35c, 0xf362, 0xf369, 0xf370, 0xf373,
	0xf376, 0xf37a, 0xf382, 0xf389, 0xf395, 0xf398, 0xf39b, 0xf3a3,
	0xf3ae, 0xf3b2, 0xf3bf, 0xf3c7, 0xf3cd, 0xf3db, 0xf3e5, 0xf3fc,
	0xf400, 0xf407, 0xf40c, 0xf412, 0xf421, 0xf42f, 0xf436, 0xf440,
	0xf448, 0xf452, 0xf45d, 0xf465, 0xf470, 0xf47e, 0xf488, 0xf493,
	0xf49b, 0xf4a3, 0xf4ac, 0xf4b8, 0xf4c1, 0xf4ca, 0xf4d4, 0xf4dc,
	0xf4e6, 0xf4ee, 0xf4f2, 0xf4f5, 0xf4f8, 0xf4fc, 0xf501, 0xf507,
	// Entry 7700 - 773F
	0xf527, 0xf549, 0xf56b, 0xf58e, 0xf59e, 0xf5ae, 0xf5ba, 0xf5c8,
	0xf5d8, 0xf5eb, 0xf5fa, 0xf5ff, 0xf609, 0xf613, 0xf61a, 0xf621,
	0xf626, 0xf62b, 0xf631, 0xf637, 0xf645, 0xf64a, 0xf651, 0xf656,
	0xf65f, 0xf66c, 0xf67c, 0xf689, 0xf695, 0xf69f, 0xf6b1, 0xf6c4,
	0xf6c7, 0xf6cb, 0xf6ce, 0xf6d3, 0xf6d9, 0xf6f4, 0xf709, 0xf720,
	0xf72e, 0xf743, 0xf752, 0xf768, 0xf77b, 0xf78a, 0xf793, 0xf79e,
	0xf7a2, 0xf7b5, 0xf7bd, 0xf7ca, 0xf7d9, 0xf7de, 0xf7e8, 0xf7fe,
	0xf80b, 0xf80e, 0xf813, 0xf82a, 0xf833, 0xf839, 0xf841, 0xf84c,
	// Entry 7740 - 777F
	0xf858, 0xf85f, 0xf86a, 0xf871, 0xf875, 0xf87e, 0xf889, 0xf88d,
	0xf896, 0xf89a, 0xf8a1, 0xf8b2, 0xf8b9, 0xf8c6, 0xf8d2, 0xf8dc,
	0xf8eb, 0xf8f8, 0xf908, 0xf912, 0xf91d, 0xf929, 0xf935, 0xf946,
	0xf956, 0xf966, 0xf985, 0xf998, 0xf9a4, 0xf9a8, 0xf9b7, 0xf9c7,
	0xf9dd, 0xf9e4, 0xf9ef, 0xf9fa, 0xfa07, 0xfa13, 0xfa21, 0xfa30,
	0xfa3c, 0xfa51, 0xfa5a, 0xfa6b, 0xfa7c, 0xfa87, 0xfa9d, 0xfab6,
	0xfacd, 0xfae5, 0xfaf5, 0xfb1a, 0xfb1e, 0xfb2f, 0xfb38, 0xfb40,
	0xfb4b, 0xfb57, 0xfb5a, 0xfb65, 0xfb75, 0xfb83, 0xfb91, 0xfb99,
	// Entry 7780 - 77BF
	0xfbaa, 0xfbb4, 0xfbcc, 0xfbe6, 0xfbef, 0xfbf8, 0xfbff, 0xfc0c,
	0xfc15, 0xfc23, 0xfc33, 0xfc40, 0xfc46, 0xfc4e, 0xfc6c, 0xfc77,
	0xfc80, 0xfc8a, 0xfc93, 0xfc9e, 0xfca3, 0xfcad, 0xfcb3, 0xfcb7,
	0xfcc9, 0xfcce, 0xfcd9, 0xfcea, 0xfd04, 0xfd16, 0xfd21, 0xfd2b,
	0xfd32, 0xfd3f, 0xfd50, 0xfd73, 0xfd93, 0xfdb2, 0xfdcf, 0xfded,
	0xfdf4, 0xfdff, 0xfe08, 0xfe14, 0xfe3e, 0xfe4c, 0xfe5c, 0xfe6c,
	0xfe7d, 0xfe83, 0xfe94, 0xfea0, 0xfeaa, 0xfeaf, 0xfebc, 0xfeca,
	0xfed9, 0xfee5, 0xfefe, 0xff33, 0xff81, 0xffb3, 0xffe9, 0xfffe,
	// Entry 77C0 - 77FF
	0x0014, 0x0034, 0x003b, 0x0056, 0x0074, 0x007b, 0x0088, 0x00a6,
	0x00c5, 0x00d6, 0x00ea, 0x00ed, 0x00f1, 0x00fa, 0x00fe, 0x011b,
	0x0123, 0x012e, 0x013a, 0x0159, 0x0177, 0x01ab, 0x01cb, 0x01e7,
	0x0203, 0x020d, 0x0233, 0x0257, 0x026f, 0x0287, 0x02a5, 0x02a9,
	0x02b7, 0x02bd, 0x02c3, 0x02cf, 0x02d4, 0x02da, 0x02e4, 0x02ed,
	0x02f9, 0x0319, 0x0335, 0x0343, 0x0356, 0x0369, 0x0379, 0x038a,
	0x039e, 0x03b0, 0x03c4, 0x03d6, 0x03ee, 0x0408, 0x0426, 0x0446,
	0x0467, 0x0488, 0x049c, 0x04bf, 0x04cb, 0x04f2, 0x051a, 0x0532,
	// Entry 7800 - 783F
	0x0543, 0x0554, 0x0560, 0x0569, 0x0576, 0x057b, 0x0581, 0x058a,
	0x05a4, 0x05b3, 0x05c8, 0x05dd, 0x05f4, 0x060a, 0x0620, 0x0635,
	0x064c, 0x0663, 0x0679, 0x068e, 0x06a6, 0x06be, 0x06d3, 0x06e8,
	0x06ff, 0x0715, 0x072b, 0x0740, 0x0757, 0x076e, 0x0784, 0x0799,
	0x07b1, 0x07c9, 0x07d6, 0x07f7, 0x081b, 0x0823, 0x083c, 0x0848,
	0x084c, 0x0852, 0x0863, 0x087d, 0x0886, 0x088a, 0x08a9, 0x08b6,
	0x08c5, 0x08cb, 0x08d5, 0x08dd, 0x08e8, 0x0904, 0x0920, 0x093d,
	0x0956, 0x096f, 0x0988, 0x099e, 0x09ae, 0x09be, 0x09d5, 0x09e4,
	// Entry 7840 - 787F
	0x09fd, 0x0a0e, 0x0a1b, 0x0a2c, 0x0a44, 0x0a5b, 0x0a70, 0x0a81,
	0x0a92, 0x0aa5, 0x0ac5, 0x0aee, 0x0b05, 0x0b1e, 0x0b33, 0x0b5c,
	0x0b91, 0x0bb4, 0x0bd6, 0x0bf9, 0x0c1b, 0x0c3e, 0x0c60, 0x0c83,
	0x0ca3, 0x0cc5, 0x0ce5, 0x0d07, 0x0d27, 0x0d49, 0x0d54, 0x0d64,
	0x0d76, 0x0d8f, 0x0d96, 0x0da7, 0x0dc3, 0x0ddf, 0x0df5, 0x0e03,
	0x0e11, 0x0e21, 0x0e31, 0x0e43, 0x0e4c, 0x0e61, 0x0e6a, 0x0e70,
	0x0e7c, 0x0e84, 0x0e95, 0x0ea7, 0x0ec5, 0x0eda, 0x0eec, 0x0efc,
	0x0f0b, 0x0f17, 0x0f1d, 0x0f28, 0x0f3b, 0x0f48, 0x0f54, 0x0f5e,
	// Entry 7880 - 78BF
	0x0f6d, 0x0f7b, 0x0f7f, 0x0f88, 0x0f90, 0x0f9e, 0x0fa8, 0x0fb3,
	0x0fbb, 0x0fbf, 0x0fc4, 0x0fcf, 0x0fde, 0x0ff1, 0x0fff, 0x1007,
	0x100f, 0x1016, 0x1040, 0x104e, 0x1067, 0x1080, 0x108b, 0x1092,
	0x10a5, 0x10bb, 0x10c6, 0x10d2, 0x10d6, 0x10f1, 0x1101, 0x1111,
	0x1120, 0x1130, 0x1142, 0x1155, 0x1167, 0x117b, 0x118e, 0x11a2,
	0x11b3, 0x11c5, 0x11d0, 0x11e5, 0x11f3, 0x1209, 0x1218, 0x1230,
	0x1244, 0x1261, 0x1271, 0x128b, 0x1294, 0x129e, 0x12a9, 0x12ba,
	0x12cd, 0x12d2, 0x12df, 0x12fe, 0x1314, 0x1330, 0x135d, 0x1388,
	// Entry 78C0 - 78FF
	0x13bc, 0x13d2, 0x13e9, 0x13f5, 0x1413, 0x1430, 0x143d, 0x1460,
	0x147c, 0x1489, 0x1495, 0x14a8, 0x14b5, 0x14c9, 0x14d5, 0x14e2,
	0x14f1, 0x14fd, 0x1511, 0x152f, 0x154c, 0x1566, 0x1590, 0x15c2,
	0x15d3, 0x15df, 0x15e9, 0x15f5, 0x1600, 0x1610, 0x1629, 0x1647,
	0x1664, 0x1672, 0x167e, 0x1688, 0x1693, 0x169d, 0x16ab, 0x16bd,
	0x16d1, 0x16dc, 0x16ff, 0x1715, 0x1724, 0x1730, 0x173d, 0x1747,
	0x1759, 0x176f, 0x1792, 0x17ac, 0x17cc, 0x17f3, 0x180a, 0x182b,
	0x183b, 0x184a, 0x1858, 0x186e, 0x1883, 0x1893, 0x18a9, 0x18c2,
	// Entry 7900 - 793F
	0x18d6, 0x18ea, 0x18fc, 0x190f, 0x1923, 0x1940, 0x1968, 0x1977,
	0x198f, 0x19a7, 0x19bf, 0x19d7, 0x19ef, 0x1a07, 0x1a26, 0x1a45,
	0x1a64, 0x1a83, 0x1aa0, 0x1abd, 0x1ada, 0x1af7, 0x1b1a, 0x1b3d,
	0x1b60, 0x1b83, 0x1b9a, 0x1bb1, 0x1bc8, 0x1bdf, 0x1bfc, 0x1c19,
	0x1c36, 0x1c53, 0x1c6f, 0x1c9b, 0x1cb6, 0x1ce1, 0x1cf1, 0x1cff,
	0x1d10, 0x1d20, 0x1d3b, 0x1d5c, 0x1d75, 0x1d94, 0x1dac, 0x1dc4,
	0x1e00, 0x1e35, 0x1e6e, 0x1e88, 0x1ea7, 0x1ecc, 0x1ede, 0x1ef8,
	0x1f05, 0x1f1a, 0x1f20, 0x1f2a, 0x1f3a, 0x1f45, 0x1f55, 0x1f76,
	// Entry 7940 - 797F
	0x1f7b, 0x1f80, 0x1f8a, 0x1f91, 0x1f95, 0x1f9d, 0x1fa0, 0x1fac,
	0x1fb6, 0x1fbe, 0x1fc5, 0x1fce, 0x1fd9, 0x1fe3, 0x1ff6, 0x1ffa,
	0x2007, 0x2011, 0x2024, 0x2038, 0x2046, 0x2057, 0x205e, 0x2066,
	0x2076, 0x2088, 0x2099, 0x20a7, 0x20ab, 0x20b2, 0x20bb, 0x20d3,
	0x20e9, 0x20fa, 0x2115, 0x212c, 0x2130, 0x213d, 0x214b, 0x215c,
	0x217a, 0x218e, 0x21a2, 0x21ba, 0x21c1, 0x21cc, 0x21d5, 0x21e7,
	0x21f1, 0x21ff, 0x2210, 0x221b, 0x2228, 0x2230, 0x223b, 0x2241,
	0x224d, 0x2253, 0x2257, 0x225e, 0x226e, 0x2275, 0x2282, 0x228e,
	// Entry 7980 - 79BF
	0x22ab, 0x22ba, 0x22d4, 0x22df, 0x22eb, 0x22f9, 0x230f, 0x231c,
	0x2328, 0x232b, 0x233b, 0x2349, 0x2359, 0x235e, 0x2364, 0x2370,
	0x2381, 0x2387, 0x238f, 0x2397, 0x23a4, 0x23ae, 0x23cb, 0x23df,
	0x23f9, 0x2407, 0x2422, 0x2434, 0x2445, 0x244e, 0x2462, 0x2473,
	0x2481, 0x2488, 0x2495, 0x249a, 0x249e, 0x24ab, 0x24b5, 0x24c2,
	0x24e4, 0x24fd, 0x2517, 0x2532, 0x254d, 0x256d, 0x258d, 0x25af,
	0x25cf, 0x25f1, 0x260e, 0x262d, 0x264c, 0x2668, 0x2691, 0x26b3,
	0x26da, 0x2703, 0x272c, 0x274a, 0x2764, 0x277f, 0x279c, 0x27bb,
	// Entry 79C0 - 79FF
	0x27da, 0x27fb, 0x2815, 0x2831, 0x284f, 0x286f, 0x2893, 0x28b8,
	0x28d8, 0x28fd, 0x2926, 0x294c, 0x2974, 0x299c, 0x29cc, 0x29fd,
	0x2a1c, 0x2a39, 0x2a57, 0x2a79, 0x2aa4, 0x2aca, 0x2afd, 0x2b26,
	0x2b4f, 0x2b7a, 0x2b97, 0x2bb6, 0x2bd5, 0x2bf4, 0x2c10, 0x2c2e,
	0x2c4d, 0x2c6f, 0x2c8c, 0x2ca9, 0x2cc8, 0x2ce9, 0x2d0a, 0x2d26,
	0x2d44, 0x2d64, 0x2d7f, 0x2d9c, 0x2db9, 0x2dd3, 0x2dec, 0x2e08,
	0x2e26, 0x2e3f, 0x2e58, 0x2e74, 0x2e8e, 0x2ea9, 0x2ecc, 0x2ef1,
	0x2f0f, 0x2f2c, 0x2f51, 0x2f70, 0x2f8a, 0x2fa5, 0x2fc5, 0x2fe0,
	// Entry 7A00 - 7A3F
	0x2fff, 0x301a, 0x303e, 0x305b, 0x3086, 0x30b3, 0x30d4, 0x30f5,
	0x3112, 0x3130, 0x3150, 0x316c, 0x318e, 0x31ac, 0x31cc, 0x31ec,
	0x320c, 0x322c, 0x3249, 0x326b, 0x3290, 0x32ac, 0x32c6, 0x32e1,
	0x3300, 0x331b, 0x333a, 0x335a, 0x3386, 0x33b0, 0x33dd, 0x3409,
	0x3424, 0x343c, 0x344d, 0x345f, 0x3476, 0x3492, 0x34bc, 0x34c8,
	0x34d9, 0x34f4, 0x3506, 0x3519, 0x352a, 0x353c, 0x3553, 0x356f,
	0x359e, 0x35c9, 0x35d6, 0x35e8, 0x3600, 0x361a, 0x364b, 0x3678,
	0x3686, 0x3698, 0x36b0, 0x36ca, 0x36f6, 0x3706, 0x3717, 0x3729,
	// Entry 7A40 - 7A7F
	0x3739, 0x374e, 0x3764, 0x377f, 0x378b, 0x3798, 0x37a6, 0x37b2,
	0x37bf, 0x37d1, 0x37e8, 0x3802, 0x381d, 0x3836, 0x3850, 0x386f,
	0x3893, 0x38ac, 0x38c6, 0x38de, 0x38f7, 0x3915, 0x3938, 0x3953,
	0x396f, 0x3989, 0x39a4, 0x39c4, 0x39e2, 0x3a01, 0x3a19, 0x3a3b,
	0x3a58, 0x3a76, 0x3a8d, 0x3aae, 0x3ad6, 0x3af3, 0x3b10, 0x3b2d,
	0x3b49, 0x3b62, 0x3b81, 0x3b9f, 0x3bc2, 0x3be3, 0x3c02, 0x3c21,
	0x3c43, 0x3c53, 0x3c6c, 0x3c7a, 0x3c91, 0x3ca4, 0x3cb7, 0x3cc9,
	0x3cdc, 0x3cee, 0x3cfe, 0x3d0f, 0x3d22, 0x3d35, 0x3d47, 0x3d5a,
	// Entry 7A80 - 7ABF
	0x3d6c, 0x3d99, 0x3dc4, 0x3df2, 0x3e1f, 0x3e4d, 0x3e79, 0x3ea8,
	0x3ed6, 0x3f03, 0x3f2e, 0x3f5c, 0x3f89, 0x3fb9, 0x3fe7, 0x4018,
	0x4048, 0x4072, 0x409a, 0x40c5, 0x40ef, 0x411f, 0x414d, 0x417e,
	0x41ae, 0x41e4, 0x4218, 0x424f, 0x4285, 0x42b6, 0x42e5, 0x4317,
	0x4348, 0x4379, 0x43a8, 0x43da, 0x440b, 0x443a, 0x4467, 0x4497,
	0x44c6, 0x44f6, 0x4524, 0x4555, 0x4585, 0x45ba, 0x45ed, 0x4623,
	0x4658, 0x4673, 0x468c, 0x46a8, 0x46c3, 0x46da, 0x46ef, 0x4707,
	0x471e, 0x4738, 0x4750, 0x476b, 0x4785, 0x47a5, 0x47c3, 0x47e4,
	// Entry 7AC0 - 7AFF
	0x4804, 0x4819, 0x482c, 0x4842, 0x4857, 0x4871, 0x4889, 0x48a4,
	0x48be, 0x48d9, 0x48f4, 0x490f, 0x492a, 0x4945, 0x495d, 0x4983,
	0x49a7, 0x49ce, 0x49f4, 0x4a1b, 0x4a42, 0x4a69, 0x4a90, 0x4ab0,
	0x4ace, 0x4aef, 0x4b0f, 0x4b30, 0x4b51, 0x4b72, 0x4b93, 0x4bba,
	0x4bdf, 0x4c07, 0x4c2e, 0x4c56, 0x4c7e, 0x4ca6, 0x4cce, 0x4cf4,
	0x4d18, 0x4d3f, 0x4d65, 0x4d8c, 0x4db3, 0x4dda, 0x4e01, 0x4e2c,
	0x4e55, 0x4e81, 0x4eac, 0x4ed8, 0x4f04, 0x4f30, 0x4f5c, 0x4f78,
	0x4f92, 0x4faf, 0x4fcb, 0x4ffa, 0x5027, 0x5057, 0x5086, 0x50a7,
	// Entry 7B00 - 7B3F
	0x50c6, 0x50e8, 0x5109, 0x5124, 0x5146, 0x5166, 0x5187, 0x51aa,
	0x51ce, 0x51ee, 0x520f, 0x5230, 0x5253, 0x5275, 0x5297, 0x52c1,
	0x52ec, 0x5317, 0x5343, 0x535e, 0x5380, 0x53a3, 0x53c5, 0x53d9,
	0x53f8, 0x5418, 0x5436, 0x544f, 0x545f, 0x5473, 0x548f, 0x54ac,
	0x54d1, 0x54dc, 0x54e7, 0x54f4, 0x5505, 0x5515, 0x552a, 0x5533,
	0x5540, 0x5556, 0x5560, 0x556c, 0x557d, 0x5589, 0x559c, 0x55ac,
	0x55bd, 0x55c6, 0x55f0, 0x5604, 0x5618, 0x5622, 0x5630, 0x564d,
	0x565a, 0x5664, 0x566d, 0x567a, 0x5696, 0x56b2, 0x56e0, 0x5705,
	// Entry 7B40 - 7B7F
	0x572d, 0x5763, 0x5780, 0x57a0, 0x57ae, 0x57bc, 0x57cd, 0x57d3,
	0x57d9, 0x57e6, 0x57f6, 0x57fb, 0x5811, 0x5819, 0x581f, 0x5830,
	0x5839, 0x5843, 0x584b, 0x5856, 0x5863, 0x5877, 0x5887, 0x5894,
	0x5899, 0x58a1, 0x58a6, 0x58b7, 0x58c9, 0x58da, 0x58e6, 0x58fa,
	0x5907, 0x591e, 0x5926, 0x5931, 0x593a, 0x5941, 0x5949, 0x594e,
	0x5954, 0x595a, 0x5968, 0x5973, 0x5986, 0x5997, 0x599a, 0x59a7,
	0x59ae, 0x59b7, 0x59bf, 0x59c7, 0x59d5, 0x59e0, 0x59ea, 0x59f9,
	0x5a07, 0x5a0e, 0x5a16, 0x5a19, 0x5a20, 0x5a2b, 0x5a33, 0x5a3e,
	// Entry 7B80 - 7BBF
	0x5a49, 0x5a4e, 0x5a57, 0x5a5c, 0x5a8b, 0x5a97, 0x5ab9, 0x5add,
	0x5aec, 0x5af9, 0x5b10, 0x5b14, 0x5b1c, 0x5b23, 0x5b2e, 0x5b37,
	0x5b3b, 0x5b44, 0x5b4c, 0x5b52, 0x5b5e, 0x5b63, 0x5b67, 0x5b6a,
	0x5b6f, 0x5b72, 0x5b7a, 0x5b83, 0x5b87, 0x5b8e, 0x5b94, 0x5b9e,
	0x5ba4, 0x5ba9, 0x5bb5, 0x5bbf, 0x5bc7, 0x5bcf, 0x5bd4, 0x5bdb,
	0x5be3, 0x5be8, 0x5bef, 0x5bfb, 0x5c01, 0x5c08, 0x5c0f, 0x5c17,
	0x5c1e, 0x5c24, 0x5c28, 0x5c2d, 0x5c32, 0x5c3b, 0x5c40, 0x5c48,
	0x5c4e, 0x5c57, 0x5c63, 0x5c7b, 0x5c95, 0x5ca9, 0x5cc3, 0x5cc7,
	// Entry 7BC0 - 7BFF
	0x5cca, 0x5cce, 0x5cd3, 0x5cdc, 0x5ce8, 0x5cf3, 0x5d07, 0x5d1b,
	0x5d2c, 0x5d3a, 0x5d48, 0x5d54, 0x5d5b, 0x5d66, 0x5d72, 0x5d78,
	0x5d7d, 0x5d84, 0x5d8a, 0x5d90, 0x5d9a, 0x5da2, 0x5db1, 0x5dc0,
	0x5dcb, 0x5ddc, 0x5de1, 0x5de6, 0x5df1, 0x5dff, 0x5e14, 0x5e29,
	0x5e38, 0x5e50, 0x5e54, 0x5e59, 0x5e60, 0x5e69, 0x5e6c, 0x5e71,
	0x5e77, 0x5e7c, 0x5e88, 0x5e92, 0x5e97, 0x5e9d, 0x5ea1, 0x5ea6,
	0x5eb7, 0x5ec2, 0x5ed5, 0x5ede, 0x5ee8, 0x5ef8, 0x5eff, 0x5f05,
	0x5f16, 0x5f1d, 0x5f22, 0x5f28, 0x5f2f, 0x5f3c, 0x5f4b, 0x5f57,
	// Entry 7C00 - 7C3F
	0x5f61, 0x5f6b, 0x5f70, 0x5f76, 0x5f83, 0x5f8e, 0x5f94, 0x5f9b,
	0x5fa7, 0x5fb9, 0x5fcc, 0x5fde, 0x5ff2, 0x6006, 0x6018, 0x6045,
	0x6072, 0x60a1, 0x60c8, 0x60f0, 0x6117, 0x6140, 0x6169, 0x6190,
	0x61b7, 0x61df, 0x6206, 0x622f, 0x6258, 0x627f, 0x62a8, 0x62d2,
	0x62fb, 0x6326, 0x6351, 0x637a, 0x63b4, 0x63ee, 0x642a, 0x6441,
	0x6459, 0x6470, 0x6489, 0x64a2, 0x64b9, 0x64d0, 0x64e8, 0x64ff,
	0x6518, 0x6531, 0x6548, 0x6561, 0x657b, 0x6594, 0x65af, 0x65ca,
	0x65e3, 0x661d, 0x6657, 0x6693, 0x66c7, 0x66fc, 0x6730, 0x6766,
	// Entry 7C40 - 7C7F
	0x679c, 0x67d0, 0x6804, 0x6839, 0x686d, 0x68a3, 0x68d9, 0x690d,
	0x6943, 0x697a, 0x69b0, 0x69e8, 0x6a20, 0x6a56, 0x6a8e, 0x6ac6,
	0x6b00, 0x6b16, 0x6b2c, 0x6b44, 0x6b71, 0x6b9e, 0x6bcd, 0x6be5,
	0x6bfc, 0x6c15, 0x6c2d, 0x6c44, 0x6c5d, 0x6c70, 0x6c84, 0x6c98,
	0x6ca9, 0x6cbc, 0x6cce, 0x6ce1, 0x6cf6, 0x6d0c, 0x6d22, 0x6d35,
	0x6d4a, 0x6d5e, 0x6d73, 0x6d7f, 0x6d91, 0x6d97, 0x6d9d, 0x6daa,
	0x6dba, 0x6dc5, 0x6dca, 0x6dce, 0x6dd7, 0x6de4, 0x6de9, 0x6dee,
	0x6df1, 0x6dfa, 0x6dff, 0x6e20, 0x6e41, 0x6e62, 0x6e83, 0x6ea4,
	// Entry 7C80 - 7CBF
	0x6ec5, 0x6ee6, 0x6f07, 0x6f28, 0x6f49, 0x6f6a, 0x6f8b, 0x6fac,
	0x6fcd, 0x6fee, 0x700f, 0x7030, 0x7051, 0x7072, 0x7093, 0x70b4,
	0x70d5, 0x70f6, 0x7117, 0x7138, 0x7159, 0x717a, 0x719b, 0x71bc,
	0x71dd, 0x71fe, 0x721f, 0x7240, 0x7261, 0x7282, 0x72a3, 0x72c4,
	0x72e5, 0x7306, 0x7327, 0x7348, 0x7369, 0x738a, 0x73ab, 0x73cc,
	0x73ed, 0x740e, 0x742f, 0x7450, 0x7471, 0x7492, 0x74b3, 0x74d4,
	0x74f5, 0x7516, 0x7537, 0x7558, 0x7579, 0x759a, 0x75bb, 0x75dc,
	0x75fd, 0x761e, 0x763f, 0x7660, 0x7681, 0x76a2, 0x76c3, 0x76e4,
	// Entry 7CC0 - 7CFF
	0x7705, 0x7726, 0x7747, 0x7768, 0x7789, 0x77aa, 0x77cb, 0x77ec,
	0x780d, 0x782e, 0x784f, 0x7870, 0x7891, 0x78b2, 0x78d3, 0x78f4,
	0x7915, 0x7936, 0x7957, 0x7978, 0x7999, 0x79ba, 0x79db, 0x79fc,
	0x7a1d, 0x7a3e, 0x7a5f, 0x7a80, 0x7aa1, 0x7ac2, 0x7ae3, 0x7b04,
	0x7b25, 0x7b46, 0x7b67, 0x7b88, 0x7ba9, 0x7bca, 0x7beb, 0x7c0c,
	0x7c2d, 0x7c4e, 0x7c6f, 0x7c90, 0x7cb1, 0x7cd2, 0x7cf3, 0x7d14,
	0x7d35, 0x7d56, 0x7d77, 0x7d98, 0x7db9, 0x7dda, 0x7dfb, 0x7e1c,
	0x7e3d, 0x7e5e, 0x7e7f, 0x7ea0, 0x7ec1, 0x7ee2, 0x7f03, 0x7f24,
	// Entry 7D00 - 7D3F
	0x7f45, 0x7f66, 0x7f87, 0x7fa8, 0x7fc9, 0x7fea, 0x800b, 0x802c,
	0x804d, 0x806e, 0x808f, 0x80b0, 0x80d1, 0x80f2, 0x8113, 0x8134,
	0x8155, 0x8176, 0x8197, 0x81b8, 0x81d9, 0x81fa, 0x821b, 0x823c,
	0x825d, 0x827e, 0x829f, 0x82c0, 0x82e1, 0x8302, 0x8323, 0x8344,
	0x8365, 0x8386, 0x83a7, 0x83c8, 0x83e9, 0x840a, 0x842b, 0x844c,
	0x846d, 0x848e, 0x84af, 0x84d0, 0x84f1, 0x8512, 0x8533, 0x8554,
	0x8575, 0x8596, 0x85b7, 0x85d8, 0x85f9, 0x861a, 0x863b, 0x865c,
	0x867d, 0x869e, 0x86bf, 0x86e0, 0x8701, 0x8722, 0x8743, 0x8764,
	// Entry 7D40 - 7D7F
	0x8785, 0x87a6, 0x87c7, 0x87e8, 0x8809, 0x882a, 0x884b, 0x886c,
	0x888d, 0x88ae, 0x88cf, 0x88f0, 0x8911, 0x8932, 0x8953, 0x8974,
	0x8995, 0x89b6, 0x89d7, 0x89f8, 0x8a19, 0x8a3a, 0x8a5b, 0x8a7c,
	0x8a9d, 0x8abe, 0x8adf, 0x8b00, 0x8b21, 0x8b42, 0x8b63, 0x8b84,
	0x8ba5, 0x8bc6, 0x8be7, 0x8c08, 0x8c29, 0x8c4a, 0x8c6b, 0x8c8c,
	0x8cad, 0x8cce, 0x8cef, 0x8d10, 0x8d31, 0x8d52, 0x8d73, 0x8d94,
	0x8db5, 0x8dd6, 0x8df7, 0x8e18, 0x8e39, 0x8e5a, 0x8e7b, 0x8e9c,
	0x8ebd, 0x8ede, 0x8eff, 0x8f20, 0x8f41, 0x8f62, 0x8f83, 0x8fa4,
	// Entry 7D80 - 7DBF
	0x8fc5, 0x8fe6, 0x9007, 0x9028, 0x9049, 0x906a, 0x908b, 0x90ac,
	0x90cd, 0x90ee, 0x910f, 0x9130, 0x9151, 0x9172, 0x9193, 0x91b4,
	0x91d5, 0x91f6, 0x9217, 0x9238, 0x9259, 0x927a, 0x929b, 0x92bc,
	0x92dd, 0x92fe, 0x931f, 0x9340, 0x9361, 0x9382, 0x93a3, 0x93c4,
	0x93e5, 0x9406, 0x9427, 0x9448, 0x9469, 0x948a, 0x94ab, 0x94cc,
	0x94ed, 0x950e, 0x952f, 0x9550, 0x9571, 0x9592, 0x95b3, 0x95d4,
	0x95f5, 0x9616, 0x9637, 0x9658, 0x9679, 0x969a, 0x96bb, 0x96dc,
	0x96fd, 0x971e, 0x973f, 0x9760, 0x9781, 0x97a2, 0x97c3, 0x97e4,
	// Entry 7DC0 - 7DFF
	0x9805, 0x9826, 0x9847, 0x9868, 0x9889, 0x98aa, 0x98cb, 0x98ec,
	0x990d, 0x992e, 0x994f, 0x9970, 0x9991, 0x99b2, 0x99d3, 0x99f4,
	0x9a15, 0x9a36, 0x9a57, 0x9a78, 0x9a99, 0x9aba, 0x9adb, 0x9afc,
	0x9b1d, 0x9b3e, 0x9b5f, 0x9b80, 0x9ba1, 0x9bc2, 0x9be3, 0x9c04,
	0x9c25, 0x9c46, 0x9c67, 0x9c88, 0x9ca9, 0x9cca, 0x9ceb, 0x9d0c,
	0x9d2d, 0x9d4e, 0x9d6f, 0x9d90, 0x9db1, 0x9dd2, 0x9df3, 0x9e14,
	0x9e35, 0x9e56, 0x9e77, 0x9e98, 0x9eb9, 0x9eda, 0x9efb, 0x9f1c,
	0x9f3d, 0x9f5e, 0x9f7f, 0x9fa0, 0x9fc1, 0x9fe2, 0xa003, 0xa024,
	// Entry 7E00 - 7E3F
	0xa045, 0xa066, 0xa087, 0xa0a8, 0xa0c9, 0xa0ea, 0xa10b, 0xa12c,
	0xa14d, 0xa16e, 0xa18f, 0xa1b0, 0xa1d1, 0xa1f2, 0xa213, 0xa234,
	0xa255, 0xa276, 0xa297, 0xa2b8, 0xa2d9, 0xa2fa, 0xa31b, 0xa33c,
	0xa35d, 0xa37e, 0xa39f, 0xa3c0, 0xa3e1, 0xa402, 0xa423, 0xa444,
	0xa465, 0xa486, 0xa4a7, 0xa4c8, 0xa4e9, 0xa50a, 0xa52b, 0xa54c,
	0xa56d, 0xa58e, 0xa5af, 0xa5d0, 0xa5f1, 0xa612, 0xa633, 0xa654,
	0xa675, 0xa696, 0xa6b7, 0xa6d8, 0xa6f9, 0xa71a, 0xa73b, 0xa75c,
	0xa77d, 0xa79e, 0xa7bf, 0xa7e0, 0xa801, 0xa822, 0xa843, 0xa864,
	// Entry 7E40 - 7E7F
	0xa885, 0xa8a6, 0xa8c7, 0xa8e8, 0xa909, 0xa92a, 0xa94b, 0xa96c,
	0xa98d, 0xa9ae, 0xa9cf, 0xa9f0, 0xaa11, 0xaa32, 0xaa53, 0xaa74,
	0xaa95, 0xaab6, 0xaad7, 0xaaf8, 0xab19, 0xab3a, 0xab5b, 0xab7c,
	0xab9d, 0xabbe, 0xabdf, 0xac00, 0xac21, 0xac42, 0xac63, 0xac84,
	0xaca5, 0xacc6, 0xace7, 0xad08, 0xad29, 0xad4a, 0xad6b, 0xad8c,
	0xadad, 0xadce, 0xadef, 0xae10, 0xae31, 0xae52, 0xae73, 0xae94,
	0xaeb5, 0xaed6, 0xaef7, 0xaf18, 0xaf39, 0xaf5a, 0xaf7b, 0xaf9c,
	0xafbd, 0xafde, 0xafff, 0xb020, 0xb041, 0xb062, 0xb083, 0xb0a4,
	// Entry 7E80 - 7EBF
	0xb0c5, 0xb0e6, 0xb107, 0xb128, 0xb149, 0xb16a, 0xb18b, 0xb1ac,
	0xb1cd, 0xb1ee, 0xb20f, 0xb230, 0xb251, 0xb272, 0xb293, 0xb2b4,
	0xb2d5, 0xb2f6, 0xb317, 0xb338, 0xb359, 0xb37a, 0xb39b, 0xb3bc,
	0xb3dd, 0xb3e9, 0xb3f2, 0xb406, 0xb418, 0xb427, 0xb436, 0xb446,
	0xb453, 0xb461, 0xb475, 0xb48a, 0xb496, 0xb4a3, 0xb4ac, 0xb4bc,
	0xb4c9, 0xb4d4, 0xb4e2, 0xb4ef, 0xb4fc, 0xb50b, 0xb519, 0xb527,
	0xb534, 0xb543, 0xb552, 0xb560, 0xb569, 0xb576, 0xb588, 0xb597,
	0xb5ac, 0xb5bd, 0xb5ce, 0xb5e8, 0xb602, 0xb61c, 0xb636, 0xb650,
	// Entry 7EC0 - 7EFF
	0xb66a, 0xb684, 0xb69e, 0xb6b8, 0xb6d2, 0xb6ec, 0xb706, 0xb720,
	0xb73a, 0xb754, 0xb76e, 0xb788, 0xb7a2, 0xb7bc, 0xb7d6, 0xb7f0,
	0xb80a, 0xb824, 0xb83e, 0xb858, 0xb872, 0xb889, 0xb89c, 0xb8b4,
	0xb8c9, 0xb8d5, 0xb8e5, 0xb8fd, 0xb915, 0xb92d, 0xb945, 0xb95d,
	0xb975, 0xb98d, 0xb9a5, 0xb9bd, 0xb9d5, 0xb9ed, 0xba05, 0xba1d,
	0xba35, 0xba4d, 0xba65, 0xba7d, 0xba95, 0xbaad, 0xbac5, 0xbadd,
	0xbaf5, 0xbb0d, 0xbb25, 0xbb3d, 0xbb55, 0xbb6b, 0xbb7c, 0xbb93,
	0xbb9c, 0xbba6, 0xbbbb, 0xbbd0, 0xbbe5, 0xbbfa, 0xbc0f, 0xbc24,
	// Entry 7F00 - 7F3F
	0xbc39, 0xbc4e, 0xbc63, 0xbc78, 0xbc8d, 0xbca2, 0xbcb7, 0xbccc,
	0xbce1, 0xbcf6, 0xbd0b, 0xbd20, 0xbd35, 0xbd4a, 0xbd5f, 0xbd74,
	0xbd89, 0xbd9e, 0xbdb3, 0xbdc8, 0xbddd, 0xbdf2, 0xbe07, 0xbe1c,
	0xbe31, 0xbe46, 0xbe5b, 0xbe70, 0xbe85, 0xbe9a, 0xbeaf, 0xbec4,
	0xbed9, 0xbeee, 0xbf03, 0xbf18, 0xbf2d, 0xbf42, 0xbf57, 0xbf6c,
	0xbf81, 0xbf96, 0xbfab, 0xbfc0, 0xbfd5, 0xbfea, 0xbfff, 0xc014,
	0xc029, 0xc03e, 0xc053, 0xc068, 0xc07d, 0xc092, 0xc0a7, 0xc0bc,
	0xc0d1, 0xc0e6, 0xc0fb, 0xc110, 0xc125, 0xc13a, 0xc14f, 0xc164,
	// Entry 7F40 - 7F7F
	0xc179, 0xc18e, 0xc1a3, 0xc1b8, 0xc1cd, 0xc1e2, 0xc1f7, 0xc20c,
	0xc221, 0xc236, 0xc24b, 0xc260, 0xc275, 0xc28b, 0xc2a1, 0xc2b7,
	0xc2cd, 0xc2e3, 0xc2f9, 0xc30f, 0xc325, 0xc33b, 0xc351, 0xc367,
	0xc37d, 0xc393, 0xc3a9, 0xc3bf, 0xc3d5, 0xc3eb, 0xc401, 0xc417,
	0xc42d, 0xc443, 0xc459, 0xc46f, 0xc485, 0xc49b, 0xc4b1, 0xc4c7,
	0xc4dd, 0xc4f3, 0xc509, 0xc51f, 0xc535, 0xc54b, 0xc561, 0xc577,
	0xc58d, 0xc5a3, 0xc5b9, 0xc5cf, 0xc5e5, 0xc5fb, 0xc611, 0xc627,
	0xc63d, 0xc653, 0xc669, 0xc67f, 0xc695, 0xc6ab, 0xc6c1, 0xc6d7,
	// Entry 7F80 - 7FBF
	0xc6ed, 0xc703, 0xc719, 0xc72f, 0xc745, 0xc75b, 0xc771, 0xc787,
	0xc79d, 0xc7b3, 0xc7c9, 0xc7df, 0xc7f5, 0xc80b, 0xc821, 0xc837,
	0xc84d, 0xc863, 0xc879, 0xc88f, 0xc8a5, 0xc8bb, 0xc8d1, 0xc8e7,
	0xc8fd, 0xc913, 0xc929, 0xc93f, 0xc955, 0xc96b, 0xc981, 0xc997,
	0xc9ad, 0xc9c3, 0xc9d9, 0xc9ef, 0xca05, 0xca1b, 0xca31, 0xca47,
	0xca5d, 0xca73, 0xca89, 0xca9f, 0xcab5, 0xcacb, 0xcae1, 0xcaf7,
	0xcb0d, 0xcb23, 0xcb39, 0xcb4f, 0xcb65, 0xcb7b, 0xcb91, 0xcba7,
	0xcbbd, 0xcbd3, 0xcbe9, 0xcbff, 0xcc15, 0xcc2b, 0xcc41, 0xcc57,
	// Entry 7FC0 - 7FFF
	0xcc6d, 0xcc83, 0xcc99, 0xccaf, 0xccc5, 0xccdb, 0xccf1, 0xcd07,
	0xcd1d, 0xcd33, 0xcd49, 0xcd5f, 0xcd75, 0xcd8b, 0xcda1, 0xcdb7,
	0xcdcd, 0xcde3, 0xcdf9, 0xce0f, 0xce25, 0xce3b, 0xce51, 0xce67,
	0xce7d, 0xce93, 0xcea9, 0xcebf, 0xced5, 0xceeb, 0xcf01, 0xcf17,
	0xcf2d, 0xcf43, 0xcf59, 0xcf6f, 0xcf85, 0xcf9b, 0xcfb1, 0xcfc7,
	0xcfdd, 0xcff3,
} // Size: 65516 bytes

const directData string = "" + // Size: 353 bytes
	"<CJK Ideograph Extension A><CJK Ideograph Extension B><CJK Ideograph Ext" +
	"ension C><CJK Ideograph Extension D><CJK Ideograph Extension E><CJK Ideo" +
	"graph Extension F><CJK Ideograph><Hangul Syllable><Low Surrogate><Non Pr" +
	"ivate Use High Surrogate><Plane 15 Private Use><Plane 16 Private Use><Pr" +
	"ivate Use High Surrogate><Private Use><Tangut Ideograph><control>"

const singleData string = ("" + // Size: 839667 bytes; the redundant, explicit parens are for https://golang.org/issue/18078
	"SPACEEXCLAMATION MARKQUOTATION MARKNUMBER SIGNDOLLAR SIGNPERCENT SIGNAMP" +
	"ERSANDAPOSTROPHELEFT PARENTHESISRIGHT PARENTHESISASTERISKPLUS SIGNCOMMAH" +
	"YPHEN-MINUSFULL STOPSOLIDUSDIGIT ZERODIGIT ONEDIGIT TWODIGIT THREEDIGIT " +
	"FOURDIGIT FIVEDIGIT SIXDIGIT SEVENDIGIT EIGHTDIGIT NINECOLONSEMICOLONLES" +
	"S-THAN SIGNEQUALS SIGNGREATER-THAN SIGNQUESTION MARKCOMMERCIAL ATLATIN C" +
	"APITAL LETTER ALATIN CAPITAL LETTER BLATIN CAPITAL LETTER CLATIN CAPITAL" +
	" LETTER DLATIN CAPITAL LETTER ELATIN CAPITAL LETTER FLATIN CAPITAL LETTE" +
	"R GLATIN CAPITAL LETTER HLATIN CAPITAL LETTER ILATIN CAPITAL LETTER JLAT" +
	"IN CAPITAL LETTER KLATIN CAPITAL LETTER LLATIN CAPITAL LETTER MLATIN CAP" +
	"ITAL LETTER NLATIN CAPITAL LETTER OLATIN CAPITAL LETTER PLATIN CAPITAL L" +
	"ETTER QLATIN CAPITAL LETTER RLATIN CAPITAL LETTER SLATIN CAPITAL LETTER " +
	"TLATIN CAPITAL LETTER ULATIN CAPITAL LETTER VLATIN CAPITAL LETTER WLATIN" +
	" CAPITAL LETTER XLATIN CAPITAL LETTER YLATIN CAPITAL LETTER ZLEFT SQUARE" +
	" BRACKETREVERSE SOLIDUSRIGHT SQUARE BRACKETCIRCUMFLEX ACCENTLOW LINEGRAV" +
	"E ACCENTLATIN SMALL LETTER ALATIN SMALL LETTER BLATIN SMALL LETTER CLATI" +
	"N SMALL LETTER DLATIN SMALL LETTER ELATIN SMALL LETTER FLATIN SMALL LETT" +
	"ER GLATIN SMALL LETTER HLATIN SMALL LETTER ILATIN SMALL LETTER JLATIN SM" +
	"ALL LETTER KLATIN SMALL LETTER LLATIN SMALL LETTER MLATIN SMALL LETTER N" +
	"LATIN SMALL LETTER OLATIN SMALL LETTER PLATIN SMALL LETTER QLATIN SMALL " +
	"LETTER RLATIN SMALL LETTER SLATIN SMALL LETTER TLATIN SMALL LETTER ULATI" +
	"N SMALL LETTER VLATIN SMALL LETTER WLATIN SMALL LETTER XLATIN SMALL LETT" +
	"ER YLATIN SMALL LETTER ZLEFT CURLY BRACKETVERTICAL LINERIGHT CURLY BRACK" +
	"ETTILDENO-BREAK SPACEINVERTED EXCLAMATION MARKCENT SIGNPOUND SIGNCURRENC" +
	"Y SIGNYEN SIGNBROKEN BARSECTION SIGNDIAERESISCOPYRIGHT SIGNFEMININE ORDI" +
	"NAL INDICATORLEFT-POINTING DOUBLE ANGLE QUOTATION MARKNOT SIGNSOFT HYPHE" +
	"NREGISTERED SIGNMACRONDEGREE SIGNPLUS-MINUS SIGNSUPERSCRIPT TWOSUPERSCRI" +
	"PT THREEACUTE ACCENTMICRO SIGNPILCROW SIGNMIDDLE DOTCEDILLASUPERSCRIPT O" +
	"NEMASCULINE ORDINAL INDICATORRIGHT-POINTING DOUBLE ANGLE QUOTATION MARKV" +
	"ULGAR FRACTION ONE QUARTERVULGAR FRACTION ONE HALFVULGAR FRACTION THREE " +
	"QUARTERSINVERTED QUESTION MARKLATIN CAPITAL LETTER A WITH GRAVELATIN CAP" +
	"ITAL LETTER A WITH ACUTELATIN CAPITAL LETTER A WITH CIRCUMFLEXLATIN CAPI" +
	"TAL LETTER A WITH TILDELATIN CAPITAL LETTER A WITH DIAERESISLATIN CAPITA" +
	"L LETTER A WITH RING ABOVELATIN CAPITAL LETTER AELATIN CAPITAL LETTER C " +
	"WITH CEDILLALATIN CAPITAL LETTER E WITH GRAVELATIN CAPITAL LETTER E WITH" +
	" ACUTELATIN CAPITAL LETTER E WITH CIRCUMFLEXLATIN CAPITAL LETTER E WITH " +
	"DIAERESISLATIN CAPITAL LETTER I WITH GRAVELATIN CAPITAL LETTER I WITH AC" +
	"UTELATIN CAPITAL LETTER I WITH CIRCUMFLEXLATIN CAPITAL LETTER I WITH DIA" +
	"ERESISLATIN CAPITAL LETTER ETHLATIN CAPITAL LETTER N WITH TILDELATIN CAP" +
	"ITAL LETTER O WITH GRAVELATIN CAPITAL LETTER O WITH ACUTELATIN CAPITAL L" +
	"ETTER O WITH CIRCUMFLEXLATIN CAPITAL LETTER O WITH TILDELATIN CAPITAL LE" +
	"TTER O WITH DIAERESISMULTIPLICATION SIGNLATIN CAPITAL LETTER O WITH STRO" +
	"KELATIN CAPITAL LETTER U WITH GRAVELATIN CAPITAL LETTER U WITH ACUTELATI" +
	"N CAPITAL LETTER U WITH CIRCUMFLEXLATIN CAPITAL LETTER U WITH DIAERESISL" +
	"ATIN CAPITAL LETTER Y WITH ACUTELATIN CAPITAL LETTER THORNLATIN SMALL LE" +
	"TTER SHARP SLATIN SMALL LETTER A WITH GRAVELATIN SMALL LETTER A WITH ACU" +
	"TELATIN SMALL LETTER A WITH CIRCUMFLEXLATIN SMALL LETTER A WITH TILDELAT" +
	"IN SMALL LETTER A WITH DIAERESISLATIN SMALL LETTER A WITH RING ABOVELATI" +
	"N SMALL LETTER AELATIN SMALL LETTER C WITH CEDILLALATIN SMALL LETTER E W" +
	"ITH GRAVELATIN SMALL LETTER E WITH ACUTELATIN SMALL LETTER E WITH CIRCUM" +
	"FLEXLATIN SMALL LETTER E WITH DIAERESISLATIN SMALL LETTER I WITH GRAVELA" +
	"TIN SMALL LETTER I WITH ACUTELATIN SMALL LETTER I WITH CIRCUMFLEXLATIN S" +
	"MALL LETTER I WITH DIAERESISLATIN SMALL LETTER ETHLATIN SMALL LETTER N W" +
	"ITH TILDELATIN SMALL LETTER O WITH GRAVELATIN SMALL LETTER O WITH ACUTEL" +
	"ATIN SMALL LETTER O WITH CIRCUMFLEXLATIN SMALL LETTER O WITH TILDELATIN " +
	"SMALL LETTER O WITH DIAERESISDIVISION SIGNLATIN SMALL LETTER O WITH STRO" +
	"KELATIN SMALL LETTER U WITH GRAVELATIN SMALL LETTER U WITH ACUTELATIN SM" +
	"ALL LETTER U WITH CIRCUMFLEXLATIN SMALL LETTER U WITH DIAERESISLATIN SMA" +
	"LL LETTER Y WITH ACUTELATIN SMALL LETTER THORNLATIN SMALL LETTER Y WITH " +
	"DIAERESISLATIN CAPITAL LETTER A WITH MACRONLATIN SMALL LETTER A WITH MAC" +
	"RONLATIN CAPITAL LETTER A WITH BREVELATIN SMALL LETTER A WITH BREVELATIN" +
	" CAPITAL LETTER A WITH OGONEKLATIN SMALL LETTER A WITH OGONEKLATIN CAPIT" +
	"AL LETTER C WITH ACUTELATIN SMALL LETTER C WITH ACUTELATIN CAPITAL LETTE" +
	"R C WITH CIRCUMFLEXLATIN SMALL LETTER C WITH CIRCUMFLEXLATIN CAPITAL LET") + ("" +
	"TER C WITH DOT ABOVELATIN SMALL LETTER C WITH DOT ABOVELATIN CAPITAL LET" +
	"TER C WITH CARONLATIN SMALL LETTER C WITH CARONLATIN CAPITAL LETTER D WI" +
	"TH CARONLATIN SMALL LETTER D WITH CARONLATIN CAPITAL LETTER D WITH STROK" +
	"ELATIN SMALL LETTER D WITH STROKELATIN CAPITAL LETTER E WITH MACRONLATIN" +
	" SMALL LETTER E WITH MACRONLATIN CAPITAL LETTER E WITH BREVELATIN SMALL " +
	"LETTER E WITH BREVELATIN CAPITAL LETTER E WITH DOT ABOVELATIN SMALL LETT" +
	"ER E WITH DOT ABOVELATIN CAPITAL LETTER E WITH OGONEKLATIN SMALL LETTER " +
	"E WITH OGONEKLATIN CAPITAL LETTER E WITH CARONLATIN SMALL LETTER E WITH " +
	"CARONLATIN CAPITAL LETTER G WITH CIRCUMFLEXLATIN SMALL LETTER G WITH CIR" +
	"CUMFLEXLATIN CAPITAL LETTER G WITH BREVELATIN SMALL LETTER G WITH BREVEL" +
	"ATIN CAPITAL LETTER G WITH DOT ABOVELATIN SMALL LETTER G WITH DOT ABOVEL" +
	"ATIN CAPITAL LETTER G WITH CEDILLALATIN SMALL LETTER G WITH CEDILLALATIN" +
	" CAPITAL LETTER H WITH CIRCUMFLEXLATIN SMALL LETTER H WITH CIRCUMFLEXLAT" +
	"IN CAPITAL LETTER H WITH STROKELATIN SMALL LETTER H WITH STROKELATIN CAP" +
	"ITAL LETTER I WITH TILDELATIN SMALL LETTER I WITH TILDELATIN CAPITAL LET" +
	"TER I WITH MACRONLATIN SMALL LETTER I WITH MACRONLATIN CAPITAL LETTER I " +
	"WITH BREVELATIN SMALL LETTER I WITH BREVELATIN CAPITAL LETTER I WITH OGO" +
	"NEKLATIN SMALL LETTER I WITH OGONEKLATIN CAPITAL LETTER I WITH DOT ABOVE" +
	"LATIN SMALL LETTER DOTLESS ILATIN CAPITAL LIGATURE IJLATIN SMALL LIGATUR" +
	"E IJLATIN CAPITAL LETTER J WITH CIRCUMFLEXLATIN SMALL LETTER J WITH CIRC" +
	"UMFLEXLATIN CAPITAL LETTER K WITH CEDILLALATIN SMALL LETTER K WITH CEDIL" +
	"LALATIN SMALL LETTER KRALATIN CAPITAL LETTER L WITH ACUTELATIN SMALL LET" +
	"TER L WITH ACUTELATIN CAPITAL LETTER L WITH CEDILLALATIN SMALL LETTER L " +
	"WITH CEDILLALATIN CAPITAL LETTER L WITH CARONLATIN SMALL LETTER L WITH C" +
	"ARONLATIN CAPITAL LETTER L WITH MIDDLE DOTLATIN SMALL LETTER L WITH MIDD" +
	"LE DOTLATIN CAPITAL LETTER L WITH STROKELATIN SMALL LETTER L WITH STROKE" +
	"LATIN CAPITAL LETTER N WITH ACUTELATIN SMALL LETTER N WITH ACUTELATIN CA" +
	"PITAL LETTER N WITH CEDILLALATIN SMALL LETTER N WITH CEDILLALATIN CAPITA" +
	"L LETTER N WITH CARONLATIN SMALL LETTER N WITH CARONLATIN SMALL LETTER N" +
	" PRECEDED BY APOSTROPHELATIN CAPITAL LETTER ENGLATIN SMALL LETTER ENGLAT" +
	"IN CAPITAL LETTER O WITH MACRONLATIN SMALL LETTER O WITH MACRONLATIN CAP" +
	"ITAL LETTER O WITH BREVELATIN SMALL LETTER O WITH BREVELATIN CAPITAL LET" +
	"TER O WITH DOUBLE ACUTELATIN SMALL LETTER O WITH DOUBLE ACUTELATIN CAPIT" +
	"AL LIGATURE OELATIN SMALL LIGATURE OELATIN CAPITAL LETTER R WITH ACUTELA" +
	"TIN SMALL LETTER R WITH ACUTELATIN CAPITAL LETTER R WITH CEDILLALATIN SM" +
	"ALL LETTER R WITH CEDILLALATIN CAPITAL LETTER R WITH CARONLATIN SMALL LE" +
	"TTER R WITH CARONLATIN CAPITAL LETTER S WITH ACUTELATIN SMALL LETTER S W" +
	"ITH ACUTELATIN CAPITAL LETTER S WITH CIRCUMFLEXLATIN SMALL LETTER S WITH" +
	" CIRCUMFLEXLATIN CAPITAL LETTER S WITH CEDILLALATIN SMALL LETTER S WITH " +
	"CEDILLALATIN CAPITAL LETTER S WITH CARONLATIN SMALL LETTER S WITH CARONL" +
	"ATIN CAPITAL LETTER T WITH CEDILLALATIN SMALL LETTER T WITH CEDILLALATIN" +
	" CAPITAL LETTER T WITH CARONLATIN SMALL LETTER T WITH CARONLATIN CAPITAL" +
	" LETTER T WITH STROKELATIN SMALL LETTER T WITH STROKELATIN CAPITAL LETTE" +
	"R U WITH TILDELATIN SMALL LETTER U WITH TILDELATIN CAPITAL LETTER U WITH" +
	" MACRONLATIN SMALL LETTER U WITH MACRONLATIN CAPITAL LETTER U WITH BREVE" +
	"LATIN SMALL LETTER U WITH BREVELATIN CAPITAL LETTER U WITH RING ABOVELAT" +
	"IN SMALL LETTER U WITH RING ABOVELATIN CAPITAL LETTER U WITH DOUBLE ACUT" +
	"ELATIN SMALL LETTER U WITH DOUBLE ACUTELATIN CAPITAL LETTER U WITH OGONE" +
	"KLATIN SMALL LETTER U WITH OGONEKLATIN CAPITAL LETTER W WITH CIRCUMFLEXL" +
	"ATIN SMALL LETTER W WITH CIRCUMFLEXLATIN CAPITAL LETTER Y WITH CIRCUMFLE" +
	"XLATIN SMALL LETTER Y WITH CIRCUMFLEXLATIN CAPITAL LETTER Y WITH DIAERES" +
	"ISLATIN CAPITAL LETTER Z WITH ACUTELATIN SMALL LETTER Z WITH ACUTELATIN " +
	"CAPITAL LETTER Z WITH DOT ABOVELATIN SMALL LETTER Z WITH DOT ABOVELATIN " +
	"CAPITAL LETTER Z WITH CARONLATIN SMALL LETTER Z WITH CARONLATIN SMALL LE" +
	"TTER LONG SLATIN SMALL LETTER B WITH STROKELATIN CAPITAL LETTER B WITH H" +
	"OOKLATIN CAPITAL LETTER B WITH TOPBARLATIN SMALL LETTER B WITH TOPBARLAT" +
	"IN CAPITAL LETTER TONE SIXLATIN SMALL LETTER TONE SIXLATIN CAPITAL LETTE" +
	"R OPEN OLATIN CAPITAL LETTER C WITH HOOKLATIN SMALL LETTER C WITH HOOKLA" +
	"TIN CAPITAL LETTER AFRICAN DLATIN CAPITAL LETTER D WITH HOOKLATIN CAPITA" +
	"L LETTER D WITH TOPBARLATIN SMALL LETTER D WITH TOPBARLATIN SMALL LETTER" +
	" TURNED DELTALATIN CAPITAL LETTER REVERSED ELATIN CAPITAL LETTER SCHWALA" +
	"TIN CAPITAL LETTER OPEN ELATIN CAPITAL LETTER F WITH HOOKLATIN SMALL LET" +
	"TER F WITH HOOKLATIN CAPITAL LETTER G WITH HOOKLATIN CAPITAL LETTER GAMM" +
	"ALATIN SMALL LETTER HVLATIN CAPITAL LETTER IOTALATIN CAPITAL LETTER I WI") + ("" +
	"TH STROKELATIN CAPITAL LETTER K WITH HOOKLATIN SMALL LETTER K WITH HOOKL" +
	"ATIN SMALL LETTER L WITH BARLATIN SMALL LETTER LAMBDA WITH STROKELATIN C" +
	"APITAL LETTER TURNED MLATIN CAPITAL LETTER N WITH LEFT HOOKLATIN SMALL L" +
	"ETTER N WITH LONG RIGHT LEGLATIN CAPITAL LETTER O WITH MIDDLE TILDELATIN" +
	" CAPITAL LETTER O WITH HORNLATIN SMALL LETTER O WITH HORNLATIN CAPITAL L" +
	"ETTER OILATIN SMALL LETTER OILATIN CAPITAL LETTER P WITH HOOKLATIN SMALL" +
	" LETTER P WITH HOOKLATIN LETTER YRLATIN CAPITAL LETTER TONE TWOLATIN SMA" +
	"LL LETTER TONE TWOLATIN CAPITAL LETTER ESHLATIN LETTER REVERSED ESH LOOP" +
	"LATIN SMALL LETTER T WITH PALATAL HOOKLATIN CAPITAL LETTER T WITH HOOKLA" +
	"TIN SMALL LETTER T WITH HOOKLATIN CAPITAL LETTER T WITH RETROFLEX HOOKLA" +
	"TIN CAPITAL LETTER U WITH HORNLATIN SMALL LETTER U WITH HORNLATIN CAPITA" +
	"L LETTER UPSILONLATIN CAPITAL LETTER V WITH HOOKLATIN CAPITAL LETTER Y W" +
	"ITH HOOKLATIN SMALL LETTER Y WITH HOOKLATIN CAPITAL LETTER Z WITH STROKE" +
	"LATIN SMALL LETTER Z WITH STROKELATIN CAPITAL LETTER EZHLATIN CAPITAL LE" +
	"TTER EZH REVERSEDLATIN SMALL LETTER EZH REVERSEDLATIN SMALL LETTER EZH W" +
	"ITH TAILLATIN LETTER TWO WITH STROKELATIN CAPITAL LETTER TONE FIVELATIN " +
	"SMALL LETTER TONE FIVELATIN LETTER INVERTED GLOTTAL STOP WITH STROKELATI" +
	"N LETTER WYNNLATIN LETTER DENTAL CLICKLATIN LETTER LATERAL CLICKLATIN LE" +
	"TTER ALVEOLAR CLICKLATIN LETTER RETROFLEX CLICKLATIN CAPITAL LETTER DZ W" +
	"ITH CARONLATIN CAPITAL LETTER D WITH SMALL LETTER Z WITH CARONLATIN SMAL" +
	"L LETTER DZ WITH CARONLATIN CAPITAL LETTER LJLATIN CAPITAL LETTER L WITH" +
	" SMALL LETTER JLATIN SMALL LETTER LJLATIN CAPITAL LETTER NJLATIN CAPITAL" +
	" LETTER N WITH SMALL LETTER JLATIN SMALL LETTER NJLATIN CAPITAL LETTER A" +
	" WITH CARONLATIN SMALL LETTER A WITH CARONLATIN CAPITAL LETTER I WITH CA" +
	"RONLATIN SMALL LETTER I WITH CARONLATIN CAPITAL LETTER O WITH CARONLATIN" +
	" SMALL LETTER O WITH CARONLATIN CAPITAL LETTER U WITH CARONLATIN SMALL L" +
	"ETTER U WITH CARONLATIN CAPITAL LETTER U WITH DIAERESIS AND MACRONLATIN " +
	"SMALL LETTER U WITH DIAERESIS AND MACRONLATIN CAPITAL LETTER U WITH DIAE" +
	"RESIS AND ACUTELATIN SMALL LETTER U WITH DIAERESIS AND ACUTELATIN CAPITA" +
	"L LETTER U WITH DIAERESIS AND CARONLATIN SMALL LETTER U WITH DIAERESIS A" +
	"ND CARONLATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVELATIN SMALL LETTE" +
	"R U WITH DIAERESIS AND GRAVELATIN SMALL LETTER TURNED ELATIN CAPITAL LET" +
	"TER A WITH DIAERESIS AND MACRONLATIN SMALL LETTER A WITH DIAERESIS AND M" +
	"ACRONLATIN CAPITAL LETTER A WITH DOT ABOVE AND MACRONLATIN SMALL LETTER " +
	"A WITH DOT ABOVE AND MACRONLATIN CAPITAL LETTER AE WITH MACRONLATIN SMAL" +
	"L LETTER AE WITH MACRONLATIN CAPITAL LETTER G WITH STROKELATIN SMALL LET" +
	"TER G WITH STROKELATIN CAPITAL LETTER G WITH CARONLATIN SMALL LETTER G W" +
	"ITH CARONLATIN CAPITAL LETTER K WITH CARONLATIN SMALL LETTER K WITH CARO" +
	"NLATIN CAPITAL LETTER O WITH OGONEKLATIN SMALL LETTER O WITH OGONEKLATIN" +
	" CAPITAL LETTER O WITH OGONEK AND MACRONLATIN SMALL LETTER O WITH OGONEK" +
	" AND MACRONLATIN CAPITAL LETTER EZH WITH CARONLATIN SMALL LETTER EZH WIT" +
	"H CARONLATIN SMALL LETTER J WITH CARONLATIN CAPITAL LETTER DZLATIN CAPIT" +
	"AL LETTER D WITH SMALL LETTER ZLATIN SMALL LETTER DZLATIN CAPITAL LETTER" +
	" G WITH ACUTELATIN SMALL LETTER G WITH ACUTELATIN CAPITAL LETTER HWAIRLA" +
	"TIN CAPITAL LETTER WYNNLATIN CAPITAL LETTER N WITH GRAVELATIN SMALL LETT" +
	"ER N WITH GRAVELATIN CAPITAL LETTER A WITH RING ABOVE AND ACUTELATIN SMA" +
	"LL LETTER A WITH RING ABOVE AND ACUTELATIN CAPITAL LETTER AE WITH ACUTEL" +
	"ATIN SMALL LETTER AE WITH ACUTELATIN CAPITAL LETTER O WITH STROKE AND AC" +
	"UTELATIN SMALL LETTER O WITH STROKE AND ACUTELATIN CAPITAL LETTER A WITH" +
	" DOUBLE GRAVELATIN SMALL LETTER A WITH DOUBLE GRAVELATIN CAPITAL LETTER " +
	"A WITH INVERTED BREVELATIN SMALL LETTER A WITH INVERTED BREVELATIN CAPIT" +
	"AL LETTER E WITH DOUBLE GRAVELATIN SMALL LETTER E WITH DOUBLE GRAVELATIN" +
	" CAPITAL LETTER E WITH INVERTED BREVELATIN SMALL LETTER E WITH INVERTED " +
	"BREVELATIN CAPITAL LETTER I WITH DOUBLE GRAVELATIN SMALL LETTER I WITH D" +
	"OUBLE GRAVELATIN CAPITAL LETTER I WITH INVERTED BREVELATIN SMALL LETTER " +
	"I WITH INVERTED BREVELATIN CAPITAL LETTER O WITH DOUBLE GRAVELATIN SMALL" +
	" LETTER O WITH DOUBLE GRAVELATIN CAPITAL LETTER O WITH INVERTED BREVELAT" +
	"IN SMALL LETTER O WITH INVERTED BREVELATIN CAPITAL LETTER R WITH DOUBLE " +
	"GRAVELATIN SMALL LETTER R WITH DOUBLE GRAVELATIN CAPITAL LETTER R WITH I" +
	"NVERTED BREVELATIN SMALL LETTER R WITH INVERTED BREVELATIN CAPITAL LETTE" +
	"R U WITH DOUBLE GRAVELATIN SMALL LETTER U WITH DOUBLE GRAVELATIN CAPITAL" +
	" LETTER U WITH INVERTED BREVELATIN SMALL LETTER U WITH INVERTED BREVELAT" +
	"IN CAPITAL LETTER S WITH COMMA BELOWLATIN SMALL LETTER S WITH COMMA BELO" +
	"WLATIN CAPITAL LETTER T WITH COMMA BELOWLATIN SMALL LETTER T WITH COMMA ") + ("" +
	"BELOWLATIN CAPITAL LETTER YOGHLATIN SMALL LETTER YOGHLATIN CAPITAL LETTE" +
	"R H WITH CARONLATIN SMALL LETTER H WITH CARONLATIN CAPITAL LETTER N WITH" +
	" LONG RIGHT LEGLATIN SMALL LETTER D WITH CURLLATIN CAPITAL LETTER OULATI" +
	"N SMALL LETTER OULATIN CAPITAL LETTER Z WITH HOOKLATIN SMALL LETTER Z WI" +
	"TH HOOKLATIN CAPITAL LETTER A WITH DOT ABOVELATIN SMALL LETTER A WITH DO" +
	"T ABOVELATIN CAPITAL LETTER E WITH CEDILLALATIN SMALL LETTER E WITH CEDI" +
	"LLALATIN CAPITAL LETTER O WITH DIAERESIS AND MACRONLATIN SMALL LETTER O " +
	"WITH DIAERESIS AND MACRONLATIN CAPITAL LETTER O WITH TILDE AND MACRONLAT" +
	"IN SMALL LETTER O WITH TILDE AND MACRONLATIN CAPITAL LETTER O WITH DOT A" +
	"BOVELATIN SMALL LETTER O WITH DOT ABOVELATIN CAPITAL LETTER O WITH DOT A" +
	"BOVE AND MACRONLATIN SMALL LETTER O WITH DOT ABOVE AND MACRONLATIN CAPIT" +
	"AL LETTER Y WITH MACRONLATIN SMALL LETTER Y WITH MACRONLATIN SMALL LETTE" +
	"R L WITH CURLLATIN SMALL LETTER N WITH CURLLATIN SMALL LETTER T WITH CUR" +
	"LLATIN SMALL LETTER DOTLESS JLATIN SMALL LETTER DB DIGRAPHLATIN SMALL LE" +
	"TTER QP DIGRAPHLATIN CAPITAL LETTER A WITH STROKELATIN CAPITAL LETTER C " +
	"WITH STROKELATIN SMALL LETTER C WITH STROKELATIN CAPITAL LETTER L WITH B" +
	"ARLATIN CAPITAL LETTER T WITH DIAGONAL STROKELATIN SMALL LETTER S WITH S" +
	"WASH TAILLATIN SMALL LETTER Z WITH SWASH TAILLATIN CAPITAL LETTER GLOTTA" +
	"L STOPLATIN SMALL LETTER GLOTTAL STOPLATIN CAPITAL LETTER B WITH STROKEL" +
	"ATIN CAPITAL LETTER U BARLATIN CAPITAL LETTER TURNED VLATIN CAPITAL LETT" +
	"ER E WITH STROKELATIN SMALL LETTER E WITH STROKELATIN CAPITAL LETTER J W" +
	"ITH STROKELATIN SMALL LETTER J WITH STROKELATIN CAPITAL LETTER SMALL Q W" +
	"ITH HOOK TAILLATIN SMALL LETTER Q WITH HOOK TAILLATIN CAPITAL LETTER R W" +
	"ITH STROKELATIN SMALL LETTER R WITH STROKELATIN CAPITAL LETTER Y WITH ST" +
	"ROKELATIN SMALL LETTER Y WITH STROKELATIN SMALL LETTER TURNED ALATIN SMA" +
	"LL LETTER ALPHALATIN SMALL LETTER TURNED ALPHALATIN SMALL LETTER B WITH " +
	"HOOKLATIN SMALL LETTER OPEN OLATIN SMALL LETTER C WITH CURLLATIN SMALL L" +
	"ETTER D WITH TAILLATIN SMALL LETTER D WITH HOOKLATIN SMALL LETTER REVERS" +
	"ED ELATIN SMALL LETTER SCHWALATIN SMALL LETTER SCHWA WITH HOOKLATIN SMAL" +
	"L LETTER OPEN ELATIN SMALL LETTER REVERSED OPEN ELATIN SMALL LETTER REVE" +
	"RSED OPEN E WITH HOOKLATIN SMALL LETTER CLOSED REVERSED OPEN ELATIN SMAL" +
	"L LETTER DOTLESS J WITH STROKELATIN SMALL LETTER G WITH HOOKLATIN SMALL " +
	"LETTER SCRIPT GLATIN LETTER SMALL CAPITAL GLATIN SMALL LETTER GAMMALATIN" +
	" SMALL LETTER RAMS HORNLATIN SMALL LETTER TURNED HLATIN SMALL LETTER H W" +
	"ITH HOOKLATIN SMALL LETTER HENG WITH HOOKLATIN SMALL LETTER I WITH STROK" +
	"ELATIN SMALL LETTER IOTALATIN LETTER SMALL CAPITAL ILATIN SMALL LETTER L" +
	" WITH MIDDLE TILDELATIN SMALL LETTER L WITH BELTLATIN SMALL LETTER L WIT" +
	"H RETROFLEX HOOKLATIN SMALL LETTER LEZHLATIN SMALL LETTER TURNED MLATIN " +
	"SMALL LETTER TURNED M WITH LONG LEGLATIN SMALL LETTER M WITH HOOKLATIN S" +
	"MALL LETTER N WITH LEFT HOOKLATIN SMALL LETTER N WITH RETROFLEX HOOKLATI" +
	"N LETTER SMALL CAPITAL NLATIN SMALL LETTER BARRED OLATIN LETTER SMALL CA" +
	"PITAL OELATIN SMALL LETTER CLOSED OMEGALATIN SMALL LETTER PHILATIN SMALL" +
	" LETTER TURNED RLATIN SMALL LETTER TURNED R WITH LONG LEGLATIN SMALL LET" +
	"TER TURNED R WITH HOOKLATIN SMALL LETTER R WITH LONG LEGLATIN SMALL LETT" +
	"ER R WITH TAILLATIN SMALL LETTER R WITH FISHHOOKLATIN SMALL LETTER REVER" +
	"SED R WITH FISHHOOKLATIN LETTER SMALL CAPITAL RLATIN LETTER SMALL CAPITA" +
	"L INVERTED RLATIN SMALL LETTER S WITH HOOKLATIN SMALL LETTER ESHLATIN SM" +
	"ALL LETTER DOTLESS J WITH STROKE AND HOOKLATIN SMALL LETTER SQUAT REVERS" +
	"ED ESHLATIN SMALL LETTER ESH WITH CURLLATIN SMALL LETTER TURNED TLATIN S" +
	"MALL LETTER T WITH RETROFLEX HOOKLATIN SMALL LETTER U BARLATIN SMALL LET" +
	"TER UPSILONLATIN SMALL LETTER V WITH HOOKLATIN SMALL LETTER TURNED VLATI" +
	"N SMALL LETTER TURNED WLATIN SMALL LETTER TURNED YLATIN LETTER SMALL CAP" +
	"ITAL YLATIN SMALL LETTER Z WITH RETROFLEX HOOKLATIN SMALL LETTER Z WITH " +
	"CURLLATIN SMALL LETTER EZHLATIN SMALL LETTER EZH WITH CURLLATIN LETTER G" +
	"LOTTAL STOPLATIN LETTER PHARYNGEAL VOICED FRICATIVELATIN LETTER INVERTED" +
	" GLOTTAL STOPLATIN LETTER STRETCHED CLATIN LETTER BILABIAL CLICKLATIN LE" +
	"TTER SMALL CAPITAL BLATIN SMALL LETTER CLOSED OPEN ELATIN LETTER SMALL C" +
	"APITAL G WITH HOOKLATIN LETTER SMALL CAPITAL HLATIN SMALL LETTER J WITH " +
	"CROSSED-TAILLATIN SMALL LETTER TURNED KLATIN LETTER SMALL CAPITAL LLATIN" +
	" SMALL LETTER Q WITH HOOKLATIN LETTER GLOTTAL STOP WITH STROKELATIN LETT" +
	"ER REVERSED GLOTTAL STOP WITH STROKELATIN SMALL LETTER DZ DIGRAPHLATIN S" +
	"MALL LETTER DEZH DIGRAPHLATIN SMALL LETTER DZ DIGRAPH WITH CURLLATIN SMA" +
	"LL LETTER TS DIGRAPHLATIN SMALL LETTER TESH DIGRAPHLATIN SMALL LETTER TC" +
	" DIGRAPH WITH CURLLATIN SMALL LETTER FENG DIGRAPHLATIN SMALL LETTER LS D") + ("" +
	"IGRAPHLATIN SMALL LETTER LZ DIGRAPHLATIN LETTER BILABIAL PERCUSSIVELATIN" +
	" LETTER BIDENTAL PERCUSSIVELATIN SMALL LETTER TURNED H WITH FISHHOOKLATI" +
	"N SMALL LETTER TURNED H WITH FISHHOOK AND TAILMODIFIER LETTER SMALL HMOD" +
	"IFIER LETTER SMALL H WITH HOOKMODIFIER LETTER SMALL JMODIFIER LETTER SMA" +
	"LL RMODIFIER LETTER SMALL TURNED RMODIFIER LETTER SMALL TURNED R WITH HO" +
	"OKMODIFIER LETTER SMALL CAPITAL INVERTED RMODIFIER LETTER SMALL WMODIFIE" +
	"R LETTER SMALL YMODIFIER LETTER PRIMEMODIFIER LETTER DOUBLE PRIMEMODIFIE" +
	"R LETTER TURNED COMMAMODIFIER LETTER APOSTROPHEMODIFIER LETTER REVERSED " +
	"COMMAMODIFIER LETTER RIGHT HALF RINGMODIFIER LETTER LEFT HALF RINGMODIFI" +
	"ER LETTER GLOTTAL STOPMODIFIER LETTER REVERSED GLOTTAL STOPMODIFIER LETT" +
	"ER LEFT ARROWHEADMODIFIER LETTER RIGHT ARROWHEADMODIFIER LETTER UP ARROW" +
	"HEADMODIFIER LETTER DOWN ARROWHEADMODIFIER LETTER CIRCUMFLEX ACCENTCARON" +
	"MODIFIER LETTER VERTICAL LINEMODIFIER LETTER MACRONMODIFIER LETTER ACUTE" +
	" ACCENTMODIFIER LETTER GRAVE ACCENTMODIFIER LETTER LOW VERTICAL LINEMODI" +
	"FIER LETTER LOW MACRONMODIFIER LETTER LOW GRAVE ACCENTMODIFIER LETTER LO" +
	"W ACUTE ACCENTMODIFIER LETTER TRIANGULAR COLONMODIFIER LETTER HALF TRIAN" +
	"GULAR COLONMODIFIER LETTER CENTRED RIGHT HALF RINGMODIFIER LETTER CENTRE" +
	"D LEFT HALF RINGMODIFIER LETTER UP TACKMODIFIER LETTER DOWN TACKMODIFIER" +
	" LETTER PLUS SIGNMODIFIER LETTER MINUS SIGNBREVEDOT ABOVERING ABOVEOGONE" +
	"KSMALL TILDEDOUBLE ACUTE ACCENTMODIFIER LETTER RHOTIC HOOKMODIFIER LETTE" +
	"R CROSS ACCENTMODIFIER LETTER SMALL GAMMAMODIFIER LETTER SMALL LMODIFIER" +
	" LETTER SMALL SMODIFIER LETTER SMALL XMODIFIER LETTER SMALL REVERSED GLO" +
	"TTAL STOPMODIFIER LETTER EXTRA-HIGH TONE BARMODIFIER LETTER HIGH TONE BA" +
	"RMODIFIER LETTER MID TONE BARMODIFIER LETTER LOW TONE BARMODIFIER LETTER" +
	" EXTRA-LOW TONE BARMODIFIER LETTER YIN DEPARTING TONE MARKMODIFIER LETTE" +
	"R YANG DEPARTING TONE MARKMODIFIER LETTER VOICINGMODIFIER LETTER UNASPIR" +
	"ATEDMODIFIER LETTER DOUBLE APOSTROPHEMODIFIER LETTER LOW DOWN ARROWHEADM" +
	"ODIFIER LETTER LOW UP ARROWHEADMODIFIER LETTER LOW LEFT ARROWHEADMODIFIE" +
	"R LETTER LOW RIGHT ARROWHEADMODIFIER LETTER LOW RINGMODIFIER LETTER MIDD" +
	"LE GRAVE ACCENTMODIFIER LETTER MIDDLE DOUBLE GRAVE ACCENTMODIFIER LETTER" +
	" MIDDLE DOUBLE ACUTE ACCENTMODIFIER LETTER LOW TILDEMODIFIER LETTER RAIS" +
	"ED COLONMODIFIER LETTER BEGIN HIGH TONEMODIFIER LETTER END HIGH TONEMODI" +
	"FIER LETTER BEGIN LOW TONEMODIFIER LETTER END LOW TONEMODIFIER LETTER SH" +
	"ELFMODIFIER LETTER OPEN SHELFMODIFIER LETTER LOW LEFT ARROWCOMBINING GRA" +
	"VE ACCENTCOMBINING ACUTE ACCENTCOMBINING CIRCUMFLEX ACCENTCOMBINING TILD" +
	"ECOMBINING MACRONCOMBINING OVERLINECOMBINING BREVECOMBINING DOT ABOVECOM" +
	"BINING DIAERESISCOMBINING HOOK ABOVECOMBINING RING ABOVECOMBINING DOUBLE" +
	" ACUTE ACCENTCOMBINING CARONCOMBINING VERTICAL LINE ABOVECOMBINING DOUBL" +
	"E VERTICAL LINE ABOVECOMBINING DOUBLE GRAVE ACCENTCOMBINING CANDRABINDUC" +
	"OMBINING INVERTED BREVECOMBINING TURNED COMMA ABOVECOMBINING COMMA ABOVE" +
	"COMBINING REVERSED COMMA ABOVECOMBINING COMMA ABOVE RIGHTCOMBINING GRAVE" +
	" ACCENT BELOWCOMBINING ACUTE ACCENT BELOWCOMBINING LEFT TACK BELOWCOMBIN" +
	"ING RIGHT TACK BELOWCOMBINING LEFT ANGLE ABOVECOMBINING HORNCOMBINING LE" +
	"FT HALF RING BELOWCOMBINING UP TACK BELOWCOMBINING DOWN TACK BELOWCOMBIN" +
	"ING PLUS SIGN BELOWCOMBINING MINUS SIGN BELOWCOMBINING PALATALIZED HOOK " +
	"BELOWCOMBINING RETROFLEX HOOK BELOWCOMBINING DOT BELOWCOMBINING DIAERESI" +
	"S BELOWCOMBINING RING BELOWCOMBINING COMMA BELOWCOMBINING CEDILLACOMBINI" +
	"NG OGONEKCOMBINING VERTICAL LINE BELOWCOMBINING BRIDGE BELOWCOMBINING IN" +
	"VERTED DOUBLE ARCH BELOWCOMBINING CARON BELOWCOMBINING CIRCUMFLEX ACCENT" +
	" BELOWCOMBINING BREVE BELOWCOMBINING INVERTED BREVE BELOWCOMBINING TILDE" +
	" BELOWCOMBINING MACRON BELOWCOMBINING LOW LINECOMBINING DOUBLE LOW LINEC" +
	"OMBINING TILDE OVERLAYCOMBINING SHORT STROKE OVERLAYCOMBINING LONG STROK" +
	"E OVERLAYCOMBINING SHORT SOLIDUS OVERLAYCOMBINING LONG SOLIDUS OVERLAYCO" +
	"MBINING RIGHT HALF RING BELOWCOMBINING INVERTED BRIDGE BELOWCOMBINING SQ" +
	"UARE BELOWCOMBINING SEAGULL BELOWCOMBINING X ABOVECOMBINING VERTICAL TIL" +
	"DECOMBINING DOUBLE OVERLINECOMBINING GRAVE TONE MARKCOMBINING ACUTE TONE" +
	" MARKCOMBINING GREEK PERISPOMENICOMBINING GREEK KORONISCOMBINING GREEK D" +
	"IALYTIKA TONOSCOMBINING GREEK YPOGEGRAMMENICOMBINING BRIDGE ABOVECOMBINI" +
	"NG EQUALS SIGN BELOWCOMBINING DOUBLE VERTICAL LINE BELOWCOMBINING LEFT A" +
	"NGLE BELOWCOMBINING NOT TILDE ABOVECOMBINING HOMOTHETIC ABOVECOMBINING A" +
	"LMOST EQUAL TO ABOVECOMBINING LEFT RIGHT ARROW BELOWCOMBINING UPWARDS AR" +
	"ROW BELOWCOMBINING GRAPHEME JOINERCOMBINING RIGHT ARROWHEAD ABOVECOMBINI" +
	"NG LEFT HALF RING ABOVECOMBINING FERMATACOMBINING X BELOWCOMBINING LEFT " +
	"ARROWHEAD BELOWCOMBINING RIGHT ARROWHEAD BELOWCOMBINING RIGHT ARROWHEAD ") + ("" +
	"AND UP ARROWHEAD BELOWCOMBINING RIGHT HALF RING ABOVECOMBINING DOT ABOVE" +
	" RIGHTCOMBINING ASTERISK BELOWCOMBINING DOUBLE RING BELOWCOMBINING ZIGZA" +
	"G ABOVECOMBINING DOUBLE BREVE BELOWCOMBINING DOUBLE BREVECOMBINING DOUBL" +
	"E MACRONCOMBINING DOUBLE MACRON BELOWCOMBINING DOUBLE TILDECOMBINING DOU" +
	"BLE INVERTED BREVECOMBINING DOUBLE RIGHTWARDS ARROW BELOWCOMBINING LATIN" +
	" SMALL LETTER ACOMBINING LATIN SMALL LETTER ECOMBINING LATIN SMALL LETTE" +
	"R ICOMBINING LATIN SMALL LETTER OCOMBINING LATIN SMALL LETTER UCOMBINING" +
	" LATIN SMALL LETTER CCOMBINING LATIN SMALL LETTER DCOMBINING LATIN SMALL" +
	" LETTER HCOMBINING LATIN SMALL LETTER MCOMBINING LATIN SMALL LETTER RCOM" +
	"BINING LATIN SMALL LETTER TCOMBINING LATIN SMALL LETTER VCOMBINING LATIN" +
	" SMALL LETTER XGREEK CAPITAL LETTER HETAGREEK SMALL LETTER HETAGREEK CAP" +
	"ITAL LETTER ARCHAIC SAMPIGREEK SMALL LETTER ARCHAIC SAMPIGREEK NUMERAL S" +
	"IGNGREEK LOWER NUMERAL SIGNGREEK CAPITAL LETTER PAMPHYLIAN DIGAMMAGREEK " +
	"SMALL LETTER PAMPHYLIAN DIGAMMAGREEK YPOGEGRAMMENIGREEK SMALL REVERSED L" +
	"UNATE SIGMA SYMBOLGREEK SMALL DOTTED LUNATE SIGMA SYMBOLGREEK SMALL REVE" +
	"RSED DOTTED LUNATE SIGMA SYMBOLGREEK QUESTION MARKGREEK CAPITAL LETTER Y" +
	"OTGREEK TONOSGREEK DIALYTIKA TONOSGREEK CAPITAL LETTER ALPHA WITH TONOSG" +
	"REEK ANO TELEIAGREEK CAPITAL LETTER EPSILON WITH TONOSGREEK CAPITAL LETT" +
	"ER ETA WITH TONOSGREEK CAPITAL LETTER IOTA WITH TONOSGREEK CAPITAL LETTE" +
	"R OMICRON WITH TONOSGREEK CAPITAL LETTER UPSILON WITH TONOSGREEK CAPITAL" +
	" LETTER OMEGA WITH TONOSGREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS" +
	"GREEK CAPITAL LETTER ALPHAGREEK CAPITAL LETTER BETAGREEK CAPITAL LETTER " +
	"GAMMAGREEK CAPITAL LETTER DELTAGREEK CAPITAL LETTER EPSILONGREEK CAPITAL" +
	" LETTER ZETAGREEK CAPITAL LETTER ETAGREEK CAPITAL LETTER THETAGREEK CAPI" +
	"TAL LETTER IOTAGREEK CAPITAL LETTER KAPPAGREEK CAPITAL LETTER LAMDAGREEK" +
	" CAPITAL LETTER MUGREEK CAPITAL LETTER NUGREEK CAPITAL LETTER XIGREEK CA" +
	"PITAL LETTER OMICRONGREEK CAPITAL LETTER PIGREEK CAPITAL LETTER RHOGREEK" +
	" CAPITAL LETTER SIGMAGREEK CAPITAL LETTER TAUGREEK CAPITAL LETTER UPSILO" +
	"NGREEK CAPITAL LETTER PHIGREEK CAPITAL LETTER CHIGREEK CAPITAL LETTER PS" +
	"IGREEK CAPITAL LETTER OMEGAGREEK CAPITAL LETTER IOTA WITH DIALYTIKAGREEK" +
	" CAPITAL LETTER UPSILON WITH DIALYTIKAGREEK SMALL LETTER ALPHA WITH TONO" +
	"SGREEK SMALL LETTER EPSILON WITH TONOSGREEK SMALL LETTER ETA WITH TONOSG" +
	"REEK SMALL LETTER IOTA WITH TONOSGREEK SMALL LETTER UPSILON WITH DIALYTI" +
	"KA AND TONOSGREEK SMALL LETTER ALPHAGREEK SMALL LETTER BETAGREEK SMALL L" +
	"ETTER GAMMAGREEK SMALL LETTER DELTAGREEK SMALL LETTER EPSILONGREEK SMALL" +
	" LETTER ZETAGREEK SMALL LETTER ETAGREEK SMALL LETTER THETAGREEK SMALL LE" +
	"TTER IOTAGREEK SMALL LETTER KAPPAGREEK SMALL LETTER LAMDAGREEK SMALL LET" +
	"TER MUGREEK SMALL LETTER NUGREEK SMALL LETTER XIGREEK SMALL LETTER OMICR" +
	"ONGREEK SMALL LETTER PIGREEK SMALL LETTER RHOGREEK SMALL LETTER FINAL SI" +
	"GMAGREEK SMALL LETTER SIGMAGREEK SMALL LETTER TAUGREEK SMALL LETTER UPSI" +
	"LONGREEK SMALL LETTER PHIGREEK SMALL LETTER CHIGREEK SMALL LETTER PSIGRE" +
	"EK SMALL LETTER OMEGAGREEK SMALL LETTER IOTA WITH DIALYTIKAGREEK SMALL L" +
	"ETTER UPSILON WITH DIALYTIKAGREEK SMALL LETTER OMICRON WITH TONOSGREEK S" +
	"MALL LETTER UPSILON WITH TONOSGREEK SMALL LETTER OMEGA WITH TONOSGREEK C" +
	"APITAL KAI SYMBOLGREEK BETA SYMBOLGREEK THETA SYMBOLGREEK UPSILON WITH H" +
	"OOK SYMBOLGREEK UPSILON WITH ACUTE AND HOOK SYMBOLGREEK UPSILON WITH DIA" +
	"ERESIS AND HOOK SYMBOLGREEK PHI SYMBOLGREEK PI SYMBOLGREEK KAI SYMBOLGRE" +
	"EK LETTER ARCHAIC KOPPAGREEK SMALL LETTER ARCHAIC KOPPAGREEK LETTER STIG" +
	"MAGREEK SMALL LETTER STIGMAGREEK LETTER DIGAMMAGREEK SMALL LETTER DIGAMM" +
	"AGREEK LETTER KOPPAGREEK SMALL LETTER KOPPAGREEK LETTER SAMPIGREEK SMALL" +
	" LETTER SAMPICOPTIC CAPITAL LETTER SHEICOPTIC SMALL LETTER SHEICOPTIC CA" +
	"PITAL LETTER FEICOPTIC SMALL LETTER FEICOPTIC CAPITAL LETTER KHEICOPTIC " +
	"SMALL LETTER KHEICOPTIC CAPITAL LETTER HORICOPTIC SMALL LETTER HORICOPTI" +
	"C CAPITAL LETTER GANGIACOPTIC SMALL LETTER GANGIACOPTIC CAPITAL LETTER S" +
	"HIMACOPTIC SMALL LETTER SHIMACOPTIC CAPITAL LETTER DEICOPTIC SMALL LETTE" +
	"R DEIGREEK KAPPA SYMBOLGREEK RHO SYMBOLGREEK LUNATE SIGMA SYMBOLGREEK LE" +
	"TTER YOTGREEK CAPITAL THETA SYMBOLGREEK LUNATE EPSILON SYMBOLGREEK REVER" +
	"SED LUNATE EPSILON SYMBOLGREEK CAPITAL LETTER SHOGREEK SMALL LETTER SHOG" +
	"REEK CAPITAL LUNATE SIGMA SYMBOLGREEK CAPITAL LETTER SANGREEK SMALL LETT" +
	"ER SANGREEK RHO WITH STROKE SYMBOLGREEK CAPITAL REVERSED LUNATE SIGMA SY" +
	"MBOLGREEK CAPITAL DOTTED LUNATE SIGMA SYMBOLGREEK CAPITAL REVERSED DOTTE" +
	"D LUNATE SIGMA SYMBOLCYRILLIC CAPITAL LETTER IE WITH GRAVECYRILLIC CAPIT" +
	"AL LETTER IOCYRILLIC CAPITAL LETTER DJECYRILLIC CAPITAL LETTER GJECYRILL" +
	"IC CAPITAL LETTER UKRAINIAN IECYRILLIC CAPITAL LETTER DZECYRILLIC CAPITA") + ("" +
	"L LETTER BYELORUSSIAN-UKRAINIAN ICYRILLIC CAPITAL LETTER YICYRILLIC CAPI" +
	"TAL LETTER JECYRILLIC CAPITAL LETTER LJECYRILLIC CAPITAL LETTER NJECYRIL" +
	"LIC CAPITAL LETTER TSHECYRILLIC CAPITAL LETTER KJECYRILLIC CAPITAL LETTE" +
	"R I WITH GRAVECYRILLIC CAPITAL LETTER SHORT UCYRILLIC CAPITAL LETTER DZH" +
	"ECYRILLIC CAPITAL LETTER ACYRILLIC CAPITAL LETTER BECYRILLIC CAPITAL LET" +
	"TER VECYRILLIC CAPITAL LETTER GHECYRILLIC CAPITAL LETTER DECYRILLIC CAPI" +
	"TAL LETTER IECYRILLIC CAPITAL LETTER ZHECYRILLIC CAPITAL LETTER ZECYRILL" +
	"IC CAPITAL LETTER ICYRILLIC CAPITAL LETTER SHORT ICYRILLIC CAPITAL LETTE" +
	"R KACYRILLIC CAPITAL LETTER ELCYRILLIC CAPITAL LETTER EMCYRILLIC CAPITAL" +
	" LETTER ENCYRILLIC CAPITAL LETTER OCYRILLIC CAPITAL LETTER PECYRILLIC CA" +
	"PITAL LETTER ERCYRILLIC CAPITAL LETTER ESCYRILLIC CAPITAL LETTER TECYRIL" +
	"LIC CAPITAL LETTER UCYRILLIC CAPITAL LETTER EFCYRILLIC CAPITAL LETTER HA" +
	"CYRILLIC CAPITAL LETTER TSECYRILLIC CAPITAL LETTER CHECYRILLIC CAPITAL L" +
	"ETTER SHACYRILLIC CAPITAL LETTER SHCHACYRILLIC CAPITAL LETTER HARD SIGNC" +
	"YRILLIC CAPITAL LETTER YERUCYRILLIC CAPITAL LETTER SOFT SIGNCYRILLIC CAP" +
	"ITAL LETTER ECYRILLIC CAPITAL LETTER YUCYRILLIC CAPITAL LETTER YACYRILLI" +
	"C SMALL LETTER ACYRILLIC SMALL LETTER BECYRILLIC SMALL LETTER VECYRILLIC" +
	" SMALL LETTER GHECYRILLIC SMALL LETTER DECYRILLIC SMALL LETTER IECYRILLI" +
	"C SMALL LETTER ZHECYRILLIC SMALL LETTER ZECYRILLIC SMALL LETTER ICYRILLI" +
	"C SMALL LETTER SHORT ICYRILLIC SMALL LETTER KACYRILLIC SMALL LETTER ELCY" +
	"RILLIC SMALL LETTER EMCYRILLIC SMALL LETTER ENCYRILLIC SMALL LETTER OCYR" +
	"ILLIC SMALL LETTER PECYRILLIC SMALL LETTER ERCYRILLIC SMALL LETTER ESCYR" +
	"ILLIC SMALL LETTER TECYRILLIC SMALL LETTER UCYRILLIC SMALL LETTER EFCYRI" +
	"LLIC SMALL LETTER HACYRILLIC SMALL LETTER TSECYRILLIC SMALL LETTER CHECY" +
	"RILLIC SMALL LETTER SHACYRILLIC SMALL LETTER SHCHACYRILLIC SMALL LETTER " +
	"HARD SIGNCYRILLIC SMALL LETTER YERUCYRILLIC SMALL LETTER SOFT SIGNCYRILL" +
	"IC SMALL LETTER ECYRILLIC SMALL LETTER YUCYRILLIC SMALL LETTER YACYRILLI" +
	"C SMALL LETTER IE WITH GRAVECYRILLIC SMALL LETTER IOCYRILLIC SMALL LETTE" +
	"R DJECYRILLIC SMALL LETTER GJECYRILLIC SMALL LETTER UKRAINIAN IECYRILLIC" +
	" SMALL LETTER DZECYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN ICYRILLIC " +
	"SMALL LETTER YICYRILLIC SMALL LETTER JECYRILLIC SMALL LETTER LJECYRILLIC" +
	" SMALL LETTER NJECYRILLIC SMALL LETTER TSHECYRILLIC SMALL LETTER KJECYRI" +
	"LLIC SMALL LETTER I WITH GRAVECYRILLIC SMALL LETTER SHORT UCYRILLIC SMAL" +
	"L LETTER DZHECYRILLIC CAPITAL LETTER OMEGACYRILLIC SMALL LETTER OMEGACYR" +
	"ILLIC CAPITAL LETTER YATCYRILLIC SMALL LETTER YATCYRILLIC CAPITAL LETTER" +
	" IOTIFIED ECYRILLIC SMALL LETTER IOTIFIED ECYRILLIC CAPITAL LETTER LITTL" +
	"E YUSCYRILLIC SMALL LETTER LITTLE YUSCYRILLIC CAPITAL LETTER IOTIFIED LI" +
	"TTLE YUSCYRILLIC SMALL LETTER IOTIFIED LITTLE YUSCYRILLIC CAPITAL LETTER" +
	" BIG YUSCYRILLIC SMALL LETTER BIG YUSCYRILLIC CAPITAL LETTER IOTIFIED BI" +
	"G YUSCYRILLIC SMALL LETTER IOTIFIED BIG YUSCYRILLIC CAPITAL LETTER KSICY" +
	"RILLIC SMALL LETTER KSICYRILLIC CAPITAL LETTER PSICYRILLIC SMALL LETTER " +
	"PSICYRILLIC CAPITAL LETTER FITACYRILLIC SMALL LETTER FITACYRILLIC CAPITA" +
	"L LETTER IZHITSACYRILLIC SMALL LETTER IZHITSACYRILLIC CAPITAL LETTER IZH" +
	"ITSA WITH DOUBLE GRAVE ACCENTCYRILLIC SMALL LETTER IZHITSA WITH DOUBLE G" +
	"RAVE ACCENTCYRILLIC CAPITAL LETTER UKCYRILLIC SMALL LETTER UKCYRILLIC CA" +
	"PITAL LETTER ROUND OMEGACYRILLIC SMALL LETTER ROUND OMEGACYRILLIC CAPITA" +
	"L LETTER OMEGA WITH TITLOCYRILLIC SMALL LETTER OMEGA WITH TITLOCYRILLIC " +
	"CAPITAL LETTER OTCYRILLIC SMALL LETTER OTCYRILLIC CAPITAL LETTER KOPPACY" +
	"RILLIC SMALL LETTER KOPPACYRILLIC THOUSANDS SIGNCOMBINING CYRILLIC TITLO" +
	"COMBINING CYRILLIC PALATALIZATIONCOMBINING CYRILLIC DASIA PNEUMATACOMBIN" +
	"ING CYRILLIC PSILI PNEUMATACOMBINING CYRILLIC POKRYTIECOMBINING CYRILLIC" +
	" HUNDRED THOUSANDS SIGNCOMBINING CYRILLIC MILLIONS SIGNCYRILLIC CAPITAL " +
	"LETTER SHORT I WITH TAILCYRILLIC SMALL LETTER SHORT I WITH TAILCYRILLIC " +
	"CAPITAL LETTER SEMISOFT SIGNCYRILLIC SMALL LETTER SEMISOFT SIGNCYRILLIC " +
	"CAPITAL LETTER ER WITH TICKCYRILLIC SMALL LETTER ER WITH TICKCYRILLIC CA" +
	"PITAL LETTER GHE WITH UPTURNCYRILLIC SMALL LETTER GHE WITH UPTURNCYRILLI" +
	"C CAPITAL LETTER GHE WITH STROKECYRILLIC SMALL LETTER GHE WITH STROKECYR" +
	"ILLIC CAPITAL LETTER GHE WITH MIDDLE HOOKCYRILLIC SMALL LETTER GHE WITH " +
	"MIDDLE HOOKCYRILLIC CAPITAL LETTER ZHE WITH DESCENDERCYRILLIC SMALL LETT" +
	"ER ZHE WITH DESCENDERCYRILLIC CAPITAL LETTER ZE WITH DESCENDERCYRILLIC S" +
	"MALL LETTER ZE WITH DESCENDERCYRILLIC CAPITAL LETTER KA WITH DESCENDERCY" +
	"RILLIC SMALL LETTER KA WITH DESCENDERCYRILLIC CAPITAL LETTER KA WITH VER" +
	"TICAL STROKECYRILLIC SMALL LETTER KA WITH VERTICAL STROKECYRILLIC CAPITA" +
	"L LETTER KA WITH STROKECYRILLIC SMALL LETTER KA WITH STROKECYRILLIC CAPI") + ("" +
	"TAL LETTER BASHKIR KACYRILLIC SMALL LETTER BASHKIR KACYRILLIC CAPITAL LE" +
	"TTER EN WITH DESCENDERCYRILLIC SMALL LETTER EN WITH DESCENDERCYRILLIC CA" +
	"PITAL LIGATURE EN GHECYRILLIC SMALL LIGATURE EN GHECYRILLIC CAPITAL LETT" +
	"ER PE WITH MIDDLE HOOKCYRILLIC SMALL LETTER PE WITH MIDDLE HOOKCYRILLIC " +
	"CAPITAL LETTER ABKHASIAN HACYRILLIC SMALL LETTER ABKHASIAN HACYRILLIC CA" +
	"PITAL LETTER ES WITH DESCENDERCYRILLIC SMALL LETTER ES WITH DESCENDERCYR" +
	"ILLIC CAPITAL LETTER TE WITH DESCENDERCYRILLIC SMALL LETTER TE WITH DESC" +
	"ENDERCYRILLIC CAPITAL LETTER STRAIGHT UCYRILLIC SMALL LETTER STRAIGHT UC" +
	"YRILLIC CAPITAL LETTER STRAIGHT U WITH STROKECYRILLIC SMALL LETTER STRAI" +
	"GHT U WITH STROKECYRILLIC CAPITAL LETTER HA WITH DESCENDERCYRILLIC SMALL" +
	" LETTER HA WITH DESCENDERCYRILLIC CAPITAL LIGATURE TE TSECYRILLIC SMALL " +
	"LIGATURE TE TSECYRILLIC CAPITAL LETTER CHE WITH DESCENDERCYRILLIC SMALL " +
	"LETTER CHE WITH DESCENDERCYRILLIC CAPITAL LETTER CHE WITH VERTICAL STROK" +
	"ECYRILLIC SMALL LETTER CHE WITH VERTICAL STROKECYRILLIC CAPITAL LETTER S" +
	"HHACYRILLIC SMALL LETTER SHHACYRILLIC CAPITAL LETTER ABKHASIAN CHECYRILL" +
	"IC SMALL LETTER ABKHASIAN CHECYRILLIC CAPITAL LETTER ABKHASIAN CHE WITH " +
	"DESCENDERCYRILLIC SMALL LETTER ABKHASIAN CHE WITH DESCENDERCYRILLIC LETT" +
	"ER PALOCHKACYRILLIC CAPITAL LETTER ZHE WITH BREVECYRILLIC SMALL LETTER Z" +
	"HE WITH BREVECYRILLIC CAPITAL LETTER KA WITH HOOKCYRILLIC SMALL LETTER K" +
	"A WITH HOOKCYRILLIC CAPITAL LETTER EL WITH TAILCYRILLIC SMALL LETTER EL " +
	"WITH TAILCYRILLIC CAPITAL LETTER EN WITH HOOKCYRILLIC SMALL LETTER EN WI" +
	"TH HOOKCYRILLIC CAPITAL LETTER EN WITH TAILCYRILLIC SMALL LETTER EN WITH" +
	" TAILCYRILLIC CAPITAL LETTER KHAKASSIAN CHECYRILLIC SMALL LETTER KHAKASS" +
	"IAN CHECYRILLIC CAPITAL LETTER EM WITH TAILCYRILLIC SMALL LETTER EM WITH" +
	" TAILCYRILLIC SMALL LETTER PALOCHKACYRILLIC CAPITAL LETTER A WITH BREVEC" +
	"YRILLIC SMALL LETTER A WITH BREVECYRILLIC CAPITAL LETTER A WITH DIAERESI" +
	"SCYRILLIC SMALL LETTER A WITH DIAERESISCYRILLIC CAPITAL LIGATURE A IECYR" +
	"ILLIC SMALL LIGATURE A IECYRILLIC CAPITAL LETTER IE WITH BREVECYRILLIC S" +
	"MALL LETTER IE WITH BREVECYRILLIC CAPITAL LETTER SCHWACYRILLIC SMALL LET" +
	"TER SCHWACYRILLIC CAPITAL LETTER SCHWA WITH DIAERESISCYRILLIC SMALL LETT" +
	"ER SCHWA WITH DIAERESISCYRILLIC CAPITAL LETTER ZHE WITH DIAERESISCYRILLI" +
	"C SMALL LETTER ZHE WITH DIAERESISCYRILLIC CAPITAL LETTER ZE WITH DIAERES" +
	"ISCYRILLIC SMALL LETTER ZE WITH DIAERESISCYRILLIC CAPITAL LETTER ABKHASI" +
	"AN DZECYRILLIC SMALL LETTER ABKHASIAN DZECYRILLIC CAPITAL LETTER I WITH " +
	"MACRONCYRILLIC SMALL LETTER I WITH MACRONCYRILLIC CAPITAL LETTER I WITH " +
	"DIAERESISCYRILLIC SMALL LETTER I WITH DIAERESISCYRILLIC CAPITAL LETTER O" +
	" WITH DIAERESISCYRILLIC SMALL LETTER O WITH DIAERESISCYRILLIC CAPITAL LE" +
	"TTER BARRED OCYRILLIC SMALL LETTER BARRED OCYRILLIC CAPITAL LETTER BARRE" +
	"D O WITH DIAERESISCYRILLIC SMALL LETTER BARRED O WITH DIAERESISCYRILLIC " +
	"CAPITAL LETTER E WITH DIAERESISCYRILLIC SMALL LETTER E WITH DIAERESISCYR" +
	"ILLIC CAPITAL LETTER U WITH MACRONCYRILLIC SMALL LETTER U WITH MACRONCYR" +
	"ILLIC CAPITAL LETTER U WITH DIAERESISCYRILLIC SMALL LETTER U WITH DIAERE" +
	"SISCYRILLIC CAPITAL LETTER U WITH DOUBLE ACUTECYRILLIC SMALL LETTER U WI" +
	"TH DOUBLE ACUTECYRILLIC CAPITAL LETTER CHE WITH DIAERESISCYRILLIC SMALL " +
	"LETTER CHE WITH DIAERESISCYRILLIC CAPITAL LETTER GHE WITH DESCENDERCYRIL" +
	"LIC SMALL LETTER GHE WITH DESCENDERCYRILLIC CAPITAL LETTER YERU WITH DIA" +
	"ERESISCYRILLIC SMALL LETTER YERU WITH DIAERESISCYRILLIC CAPITAL LETTER G" +
	"HE WITH STROKE AND HOOKCYRILLIC SMALL LETTER GHE WITH STROKE AND HOOKCYR" +
	"ILLIC CAPITAL LETTER HA WITH HOOKCYRILLIC SMALL LETTER HA WITH HOOKCYRIL" +
	"LIC CAPITAL LETTER HA WITH STROKECYRILLIC SMALL LETTER HA WITH STROKECYR" +
	"ILLIC CAPITAL LETTER KOMI DECYRILLIC SMALL LETTER KOMI DECYRILLIC CAPITA" +
	"L LETTER KOMI DJECYRILLIC SMALL LETTER KOMI DJECYRILLIC CAPITAL LETTER K" +
	"OMI ZJECYRILLIC SMALL LETTER KOMI ZJECYRILLIC CAPITAL LETTER KOMI DZJECY" +
	"RILLIC SMALL LETTER KOMI DZJECYRILLIC CAPITAL LETTER KOMI LJECYRILLIC SM" +
	"ALL LETTER KOMI LJECYRILLIC CAPITAL LETTER KOMI NJECYRILLIC SMALL LETTER" +
	" KOMI NJECYRILLIC CAPITAL LETTER KOMI SJECYRILLIC SMALL LETTER KOMI SJEC" +
	"YRILLIC CAPITAL LETTER KOMI TJECYRILLIC SMALL LETTER KOMI TJECYRILLIC CA" +
	"PITAL LETTER REVERSED ZECYRILLIC SMALL LETTER REVERSED ZECYRILLIC CAPITA" +
	"L LETTER EL WITH HOOKCYRILLIC SMALL LETTER EL WITH HOOKCYRILLIC CAPITAL " +
	"LETTER LHACYRILLIC SMALL LETTER LHACYRILLIC CAPITAL LETTER RHACYRILLIC S" +
	"MALL LETTER RHACYRILLIC CAPITAL LETTER YAECYRILLIC SMALL LETTER YAECYRIL" +
	"LIC CAPITAL LETTER QACYRILLIC SMALL LETTER QACYRILLIC CAPITAL LETTER WEC" +
	"YRILLIC SMALL LETTER WECYRILLIC CAPITAL LETTER ALEUT KACYRILLIC SMALL LE" +
	"TTER ALEUT KACYRILLIC CAPITAL LETTER EL WITH MIDDLE HOOKCYRILLIC SMALL L") + ("" +
	"ETTER EL WITH MIDDLE HOOKCYRILLIC CAPITAL LETTER EN WITH MIDDLE HOOKCYRI" +
	"LLIC SMALL LETTER EN WITH MIDDLE HOOKCYRILLIC CAPITAL LETTER PE WITH DES" +
	"CENDERCYRILLIC SMALL LETTER PE WITH DESCENDERCYRILLIC CAPITAL LETTER SHH" +
	"A WITH DESCENDERCYRILLIC SMALL LETTER SHHA WITH DESCENDERCYRILLIC CAPITA" +
	"L LETTER EN WITH LEFT HOOKCYRILLIC SMALL LETTER EN WITH LEFT HOOKCYRILLI" +
	"C CAPITAL LETTER DZZHECYRILLIC SMALL LETTER DZZHECYRILLIC CAPITAL LETTER" +
	" DCHECYRILLIC SMALL LETTER DCHECYRILLIC CAPITAL LETTER EL WITH DESCENDER" +
	"CYRILLIC SMALL LETTER EL WITH DESCENDERARMENIAN CAPITAL LETTER AYBARMENI" +
	"AN CAPITAL LETTER BENARMENIAN CAPITAL LETTER GIMARMENIAN CAPITAL LETTER " +
	"DAARMENIAN CAPITAL LETTER ECHARMENIAN CAPITAL LETTER ZAARMENIAN CAPITAL " +
	"LETTER EHARMENIAN CAPITAL LETTER ETARMENIAN CAPITAL LETTER TOARMENIAN CA" +
	"PITAL LETTER ZHEARMENIAN CAPITAL LETTER INIARMENIAN CAPITAL LETTER LIWNA" +
	"RMENIAN CAPITAL LETTER XEHARMENIAN CAPITAL LETTER CAARMENIAN CAPITAL LET" +
	"TER KENARMENIAN CAPITAL LETTER HOARMENIAN CAPITAL LETTER JAARMENIAN CAPI" +
	"TAL LETTER GHADARMENIAN CAPITAL LETTER CHEHARMENIAN CAPITAL LETTER MENAR" +
	"MENIAN CAPITAL LETTER YIARMENIAN CAPITAL LETTER NOWARMENIAN CAPITAL LETT" +
	"ER SHAARMENIAN CAPITAL LETTER VOARMENIAN CAPITAL LETTER CHAARMENIAN CAPI" +
	"TAL LETTER PEHARMENIAN CAPITAL LETTER JHEHARMENIAN CAPITAL LETTER RAARME" +
	"NIAN CAPITAL LETTER SEHARMENIAN CAPITAL LETTER VEWARMENIAN CAPITAL LETTE" +
	"R TIWNARMENIAN CAPITAL LETTER REHARMENIAN CAPITAL LETTER COARMENIAN CAPI" +
	"TAL LETTER YIWNARMENIAN CAPITAL LETTER PIWRARMENIAN CAPITAL LETTER KEHAR" +
	"MENIAN CAPITAL LETTER OHARMENIAN CAPITAL LETTER FEHARMENIAN MODIFIER LET" +
	"TER LEFT HALF RINGARMENIAN APOSTROPHEARMENIAN EMPHASIS MARKARMENIAN EXCL" +
	"AMATION MARKARMENIAN COMMAARMENIAN QUESTION MARKARMENIAN ABBREVIATION MA" +
	"RKARMENIAN SMALL LETTER TURNED AYBARMENIAN SMALL LETTER AYBARMENIAN SMAL" +
	"L LETTER BENARMENIAN SMALL LETTER GIMARMENIAN SMALL LETTER DAARMENIAN SM" +
	"ALL LETTER ECHARMENIAN SMALL LETTER ZAARMENIAN SMALL LETTER EHARMENIAN S" +
	"MALL LETTER ETARMENIAN SMALL LETTER TOARMENIAN SMALL LETTER ZHEARMENIAN " +
	"SMALL LETTER INIARMENIAN SMALL LETTER LIWNARMENIAN SMALL LETTER XEHARMEN" +
	"IAN SMALL LETTER CAARMENIAN SMALL LETTER KENARMENIAN SMALL LETTER HOARME" +
	"NIAN SMALL LETTER JAARMENIAN SMALL LETTER GHADARMENIAN SMALL LETTER CHEH" +
	"ARMENIAN SMALL LETTER MENARMENIAN SMALL LETTER YIARMENIAN SMALL LETTER N" +
	"OWARMENIAN SMALL LETTER SHAARMENIAN SMALL LETTER VOARMENIAN SMALL LETTER" +
	" CHAARMENIAN SMALL LETTER PEHARMENIAN SMALL LETTER JHEHARMENIAN SMALL LE" +
	"TTER RAARMENIAN SMALL LETTER SEHARMENIAN SMALL LETTER VEWARMENIAN SMALL " +
	"LETTER TIWNARMENIAN SMALL LETTER REHARMENIAN SMALL LETTER COARMENIAN SMA" +
	"LL LETTER YIWNARMENIAN SMALL LETTER PIWRARMENIAN SMALL LETTER KEHARMENIA" +
	"N SMALL LETTER OHARMENIAN SMALL LETTER FEHARMENIAN SMALL LIGATURE ECH YI" +
	"WNARMENIAN SMALL LETTER YI WITH STROKEARMENIAN FULL STOPARMENIAN HYPHENR" +
	"IGHT-FACING ARMENIAN ETERNITY SIGNLEFT-FACING ARMENIAN ETERNITY SIGNARME" +
	"NIAN DRAM SIGNHEBREW ACCENT ETNAHTAHEBREW ACCENT SEGOLHEBREW ACCENT SHAL" +
	"SHELETHEBREW ACCENT ZAQEF QATANHEBREW ACCENT ZAQEF GADOLHEBREW ACCENT TI" +
	"PEHAHEBREW ACCENT REVIAHEBREW ACCENT ZARQAHEBREW ACCENT PASHTAHEBREW ACC" +
	"ENT YETIVHEBREW ACCENT TEVIRHEBREW ACCENT GERESHHEBREW ACCENT GERESH MUQ" +
	"DAMHEBREW ACCENT GERSHAYIMHEBREW ACCENT QARNEY PARAHEBREW ACCENT TELISHA" +
	" GEDOLAHEBREW ACCENT PAZERHEBREW ACCENT ATNAH HAFUKHHEBREW ACCENT MUNAHH" +
	"EBREW ACCENT MAHAPAKHHEBREW ACCENT MERKHAHEBREW ACCENT MERKHA KEFULAHEBR" +
	"EW ACCENT DARGAHEBREW ACCENT QADMAHEBREW ACCENT TELISHA QETANAHEBREW ACC" +
	"ENT YERAH BEN YOMOHEBREW ACCENT OLEHEBREW ACCENT ILUYHEBREW ACCENT DEHIH" +
	"EBREW ACCENT ZINORHEBREW MARK MASORA CIRCLEHEBREW POINT SHEVAHEBREW POIN" +
	"T HATAF SEGOLHEBREW POINT HATAF PATAHHEBREW POINT HATAF QAMATSHEBREW POI" +
	"NT HIRIQHEBREW POINT TSEREHEBREW POINT SEGOLHEBREW POINT PATAHHEBREW POI" +
	"NT QAMATSHEBREW POINT HOLAMHEBREW POINT HOLAM HASER FOR VAVHEBREW POINT " +
	"QUBUTSHEBREW POINT DAGESH OR MAPIQHEBREW POINT METEGHEBREW PUNCTUATION M" +
	"AQAFHEBREW POINT RAFEHEBREW PUNCTUATION PASEQHEBREW POINT SHIN DOTHEBREW" +
	" POINT SIN DOTHEBREW PUNCTUATION SOF PASUQHEBREW MARK UPPER DOTHEBREW MA" +
	"RK LOWER DOTHEBREW PUNCTUATION NUN HAFUKHAHEBREW POINT QAMATS QATANHEBRE" +
	"W LETTER ALEFHEBREW LETTER BETHEBREW LETTER GIMELHEBREW LETTER DALETHEBR" +
	"EW LETTER HEHEBREW LETTER VAVHEBREW LETTER ZAYINHEBREW LETTER HETHEBREW " +
	"LETTER TETHEBREW LETTER YODHEBREW LETTER FINAL KAFHEBREW LETTER KAFHEBRE" +
	"W LETTER LAMEDHEBREW LETTER FINAL MEMHEBREW LETTER MEMHEBREW LETTER FINA" +
	"L NUNHEBREW LETTER NUNHEBREW LETTER SAMEKHHEBREW LETTER AYINHEBREW LETTE" +
	"R FINAL PEHEBREW LETTER PEHEBREW LETTER FINAL TSADIHEBREW LETTER TSADIHE" +
	"BREW LETTER QOFHEBREW LETTER RESHHEBREW LETTER SHINHEBREW LETTER TAVHEBR") + ("" +
	"EW YOD TRIANGLEHEBREW LIGATURE YIDDISH DOUBLE VAVHEBREW LIGATURE YIDDISH" +
	" VAV YODHEBREW LIGATURE YIDDISH DOUBLE YODHEBREW PUNCTUATION GERESHHEBRE" +
	"W PUNCTUATION GERSHAYIMARABIC NUMBER SIGNARABIC SIGN SANAHARABIC FOOTNOT" +
	"E MARKERARABIC SIGN SAFHAARABIC SIGN SAMVATARABIC NUMBER MARK ABOVEARABI" +
	"C-INDIC CUBE ROOTARABIC-INDIC FOURTH ROOTARABIC RAYARABIC-INDIC PER MILL" +
	"E SIGNARABIC-INDIC PER TEN THOUSAND SIGNAFGHANI SIGNARABIC COMMAARABIC D" +
	"ATE SEPARATORARABIC POETIC VERSE SIGNARABIC SIGN MISRAARABIC SIGN SALLAL" +
	"LAHOU ALAYHE WASSALLAMARABIC SIGN ALAYHE ASSALLAMARABIC SIGN RAHMATULLAH" +
	" ALAYHEARABIC SIGN RADI ALLAHOU ANHUARABIC SIGN TAKHALLUSARABIC SMALL HI" +
	"GH TAHARABIC SMALL HIGH LIGATURE ALEF WITH LAM WITH YEHARABIC SMALL HIGH" +
	" ZAINARABIC SMALL FATHAARABIC SMALL DAMMAARABIC SMALL KASRAARABIC SEMICO" +
	"LONARABIC LETTER MARKARABIC TRIPLE DOT PUNCTUATION MARKARABIC QUESTION M" +
	"ARKARABIC LETTER KASHMIRI YEHARABIC LETTER HAMZAARABIC LETTER ALEF WITH " +
	"MADDA ABOVEARABIC LETTER ALEF WITH HAMZA ABOVEARABIC LETTER WAW WITH HAM" +
	"ZA ABOVEARABIC LETTER ALEF WITH HAMZA BELOWARABIC LETTER YEH WITH HAMZA " +
	"ABOVEARABIC LETTER ALEFARABIC LETTER BEHARABIC LETTER TEH MARBUTAARABIC " +
	"LETTER TEHARABIC LETTER THEHARABIC LETTER JEEMARABIC LETTER HAHARABIC LE" +
	"TTER KHAHARABIC LETTER DALARABIC LETTER THALARABIC LETTER REHARABIC LETT" +
	"ER ZAINARABIC LETTER SEENARABIC LETTER SHEENARABIC LETTER SADARABIC LETT" +
	"ER DADARABIC LETTER TAHARABIC LETTER ZAHARABIC LETTER AINARABIC LETTER G" +
	"HAINARABIC LETTER KEHEH WITH TWO DOTS ABOVEARABIC LETTER KEHEH WITH THRE" +
	"E DOTS BELOWARABIC LETTER FARSI YEH WITH INVERTED VARABIC LETTER FARSI Y" +
	"EH WITH TWO DOTS ABOVEARABIC LETTER FARSI YEH WITH THREE DOTS ABOVEARABI" +
	"C TATWEELARABIC LETTER FEHARABIC LETTER QAFARABIC LETTER KAFARABIC LETTE" +
	"R LAMARABIC LETTER MEEMARABIC LETTER NOONARABIC LETTER HEHARABIC LETTER " +
	"WAWARABIC LETTER ALEF MAKSURAARABIC LETTER YEHARABIC FATHATANARABIC DAMM" +
	"ATANARABIC KASRATANARABIC FATHAARABIC DAMMAARABIC KASRAARABIC SHADDAARAB" +
	"IC SUKUNARABIC MADDAH ABOVEARABIC HAMZA ABOVEARABIC HAMZA BELOWARABIC SU" +
	"BSCRIPT ALEFARABIC INVERTED DAMMAARABIC MARK NOON GHUNNAARABIC ZWARAKAYA" +
	"RABIC VOWEL SIGN SMALL V ABOVEARABIC VOWEL SIGN INVERTED SMALL V ABOVEAR" +
	"ABIC VOWEL SIGN DOT BELOWARABIC REVERSED DAMMAARABIC FATHA WITH TWO DOTS" +
	"ARABIC WAVY HAMZA BELOWARABIC-INDIC DIGIT ZEROARABIC-INDIC DIGIT ONEARAB" +
	"IC-INDIC DIGIT TWOARABIC-INDIC DIGIT THREEARABIC-INDIC DIGIT FOURARABIC-" +
	"INDIC DIGIT FIVEARABIC-INDIC DIGIT SIXARABIC-INDIC DIGIT SEVENARABIC-IND" +
	"IC DIGIT EIGHTARABIC-INDIC DIGIT NINEARABIC PERCENT SIGNARABIC DECIMAL S" +
	"EPARATORARABIC THOUSANDS SEPARATORARABIC FIVE POINTED STARARABIC LETTER " +
	"DOTLESS BEHARABIC LETTER DOTLESS QAFARABIC LETTER SUPERSCRIPT ALEFARABIC" +
	" LETTER ALEF WASLAARABIC LETTER ALEF WITH WAVY HAMZA ABOVEARABIC LETTER " +
	"ALEF WITH WAVY HAMZA BELOWARABIC LETTER HIGH HAMZAARABIC LETTER HIGH HAM" +
	"ZA ALEFARABIC LETTER HIGH HAMZA WAWARABIC LETTER U WITH HAMZA ABOVEARABI" +
	"C LETTER HIGH HAMZA YEHARABIC LETTER TTEHARABIC LETTER TTEHEHARABIC LETT" +
	"ER BEEHARABIC LETTER TEH WITH RINGARABIC LETTER TEH WITH THREE DOTS ABOV" +
	"E DOWNWARDSARABIC LETTER PEHARABIC LETTER TEHEHARABIC LETTER BEHEHARABIC" +
	" LETTER HAH WITH HAMZA ABOVEARABIC LETTER HAH WITH TWO DOTS VERTICAL ABO" +
	"VEARABIC LETTER NYEHARABIC LETTER DYEHARABIC LETTER HAH WITH THREE DOTS " +
	"ABOVEARABIC LETTER TCHEHARABIC LETTER TCHEHEHARABIC LETTER DDALARABIC LE" +
	"TTER DAL WITH RINGARABIC LETTER DAL WITH DOT BELOWARABIC LETTER DAL WITH" +
	" DOT BELOW AND SMALL TAHARABIC LETTER DAHALARABIC LETTER DDAHALARABIC LE" +
	"TTER DULARABIC LETTER DAL WITH THREE DOTS ABOVE DOWNWARDSARABIC LETTER D" +
	"AL WITH FOUR DOTS ABOVEARABIC LETTER RREHARABIC LETTER REH WITH SMALL VA" +
	"RABIC LETTER REH WITH RINGARABIC LETTER REH WITH DOT BELOWARABIC LETTER " +
	"REH WITH SMALL V BELOWARABIC LETTER REH WITH DOT BELOW AND DOT ABOVEARAB" +
	"IC LETTER REH WITH TWO DOTS ABOVEARABIC LETTER JEHARABIC LETTER REH WITH" +
	" FOUR DOTS ABOVEARABIC LETTER SEEN WITH DOT BELOW AND DOT ABOVEARABIC LE" +
	"TTER SEEN WITH THREE DOTS BELOWARABIC LETTER SEEN WITH THREE DOTS BELOW " +
	"AND THREE DOTS ABOVEARABIC LETTER SAD WITH TWO DOTS BELOWARABIC LETTER S" +
	"AD WITH THREE DOTS ABOVEARABIC LETTER TAH WITH THREE DOTS ABOVEARABIC LE" +
	"TTER AIN WITH THREE DOTS ABOVEARABIC LETTER DOTLESS FEHARABIC LETTER FEH" +
	" WITH DOT MOVED BELOWARABIC LETTER FEH WITH DOT BELOWARABIC LETTER VEHAR" +
	"ABIC LETTER FEH WITH THREE DOTS BELOWARABIC LETTER PEHEHARABIC LETTER QA" +
	"F WITH DOT ABOVEARABIC LETTER QAF WITH THREE DOTS ABOVEARABIC LETTER KEH" +
	"EHARABIC LETTER SWASH KAFARABIC LETTER KAF WITH RINGARABIC LETTER KAF WI" +
	"TH DOT ABOVEARABIC LETTER NGARABIC LETTER KAF WITH THREE DOTS BELOWARABI" +
	"C LETTER GAFARABIC LETTER GAF WITH RINGARABIC LETTER NGOEHARABIC LETTER ") + ("" +
	"GAF WITH TWO DOTS BELOWARABIC LETTER GUEHARABIC LETTER GAF WITH THREE DO" +
	"TS ABOVEARABIC LETTER LAM WITH SMALL VARABIC LETTER LAM WITH DOT ABOVEAR" +
	"ABIC LETTER LAM WITH THREE DOTS ABOVEARABIC LETTER LAM WITH THREE DOTS B" +
	"ELOWARABIC LETTER NOON WITH DOT BELOWARABIC LETTER NOON GHUNNAARABIC LET" +
	"TER RNOONARABIC LETTER NOON WITH RINGARABIC LETTER NOON WITH THREE DOTS " +
	"ABOVEARABIC LETTER HEH DOACHASHMEEARABIC LETTER TCHEH WITH DOT ABOVEARAB" +
	"IC LETTER HEH WITH YEH ABOVEARABIC LETTER HEH GOALARABIC LETTER HEH GOAL" +
	" WITH HAMZA ABOVEARABIC LETTER TEH MARBUTA GOALARABIC LETTER WAW WITH RI" +
	"NGARABIC LETTER KIRGHIZ OEARABIC LETTER OEARABIC LETTER UARABIC LETTER Y" +
	"UARABIC LETTER KIRGHIZ YUARABIC LETTER WAW WITH TWO DOTS ABOVEARABIC LET" +
	"TER VEARABIC LETTER FARSI YEHARABIC LETTER YEH WITH TAILARABIC LETTER YE" +
	"H WITH SMALL VARABIC LETTER WAW WITH DOT ABOVEARABIC LETTER EARABIC LETT" +
	"ER YEH WITH THREE DOTS BELOWARABIC LETTER YEH BARREEARABIC LETTER YEH BA" +
	"RREE WITH HAMZA ABOVEARABIC FULL STOPARABIC LETTER AEARABIC SMALL HIGH L" +
	"IGATURE SAD WITH LAM WITH ALEF MAKSURAARABIC SMALL HIGH LIGATURE QAF WIT" +
	"H LAM WITH ALEF MAKSURAARABIC SMALL HIGH MEEM INITIAL FORMARABIC SMALL H" +
	"IGH LAM ALEFARABIC SMALL HIGH JEEMARABIC SMALL HIGH THREE DOTSARABIC SMA" +
	"LL HIGH SEENARABIC END OF AYAHARABIC START OF RUB EL HIZBARABIC SMALL HI" +
	"GH ROUNDED ZEROARABIC SMALL HIGH UPRIGHT RECTANGULAR ZEROARABIC SMALL HI" +
	"GH DOTLESS HEAD OF KHAHARABIC SMALL HIGH MEEM ISOLATED FORMARABIC SMALL " +
	"LOW SEENARABIC SMALL HIGH MADDAARABIC SMALL WAWARABIC SMALL YEHARABIC SM" +
	"ALL HIGH YEHARABIC SMALL HIGH NOONARABIC PLACE OF SAJDAHARABIC EMPTY CEN" +
	"TRE LOW STOPARABIC EMPTY CENTRE HIGH STOPARABIC ROUNDED HIGH STOP WITH F" +
	"ILLED CENTREARABIC SMALL LOW MEEMARABIC LETTER DAL WITH INVERTED VARABIC" +
	" LETTER REH WITH INVERTED VEXTENDED ARABIC-INDIC DIGIT ZEROEXTENDED ARAB" +
	"IC-INDIC DIGIT ONEEXTENDED ARABIC-INDIC DIGIT TWOEXTENDED ARABIC-INDIC D" +
	"IGIT THREEEXTENDED ARABIC-INDIC DIGIT FOUREXTENDED ARABIC-INDIC DIGIT FI" +
	"VEEXTENDED ARABIC-INDIC DIGIT SIXEXTENDED ARABIC-INDIC DIGIT SEVENEXTEND" +
	"ED ARABIC-INDIC DIGIT EIGHTEXTENDED ARABIC-INDIC DIGIT NINEARABIC LETTER" +
	" SHEEN WITH DOT BELOWARABIC LETTER DAD WITH DOT BELOWARABIC LETTER GHAIN" +
	" WITH DOT BELOWARABIC SIGN SINDHI AMPERSANDARABIC SIGN SINDHI POSTPOSITI" +
	"ON MENARABIC LETTER HEH WITH INVERTED VSYRIAC END OF PARAGRAPHSYRIAC SUP" +
	"RALINEAR FULL STOPSYRIAC SUBLINEAR FULL STOPSYRIAC SUPRALINEAR COLONSYRI" +
	"AC SUBLINEAR COLONSYRIAC HORIZONTAL COLONSYRIAC COLON SKEWED LEFTSYRIAC " +
	"COLON SKEWED RIGHTSYRIAC SUPRALINEAR COLON SKEWED LEFTSYRIAC SUBLINEAR C" +
	"OLON SKEWED RIGHTSYRIAC CONTRACTIONSYRIAC HARKLEAN OBELUSSYRIAC HARKLEAN" +
	" METOBELUSSYRIAC HARKLEAN ASTERISCUSSYRIAC ABBREVIATION MARKSYRIAC LETTE" +
	"R ALAPHSYRIAC LETTER SUPERSCRIPT ALAPHSYRIAC LETTER BETHSYRIAC LETTER GA" +
	"MALSYRIAC LETTER GAMAL GARSHUNISYRIAC LETTER DALATHSYRIAC LETTER DOTLESS" +
	" DALATH RISHSYRIAC LETTER HESYRIAC LETTER WAWSYRIAC LETTER ZAINSYRIAC LE" +
	"TTER HETHSYRIAC LETTER TETHSYRIAC LETTER TETH GARSHUNISYRIAC LETTER YUDH" +
	"SYRIAC LETTER YUDH HESYRIAC LETTER KAPHSYRIAC LETTER LAMADHSYRIAC LETTER" +
	" MIMSYRIAC LETTER NUNSYRIAC LETTER SEMKATHSYRIAC LETTER FINAL SEMKATHSYR" +
	"IAC LETTER ESYRIAC LETTER PESYRIAC LETTER REVERSED PESYRIAC LETTER SADHE" +
	"SYRIAC LETTER QAPHSYRIAC LETTER RISHSYRIAC LETTER SHINSYRIAC LETTER TAWS" +
	"YRIAC LETTER PERSIAN BHETHSYRIAC LETTER PERSIAN GHAMALSYRIAC LETTER PERS" +
	"IAN DHALATHSYRIAC PTHAHA ABOVESYRIAC PTHAHA BELOWSYRIAC PTHAHA DOTTEDSYR" +
	"IAC ZQAPHA ABOVESYRIAC ZQAPHA BELOWSYRIAC ZQAPHA DOTTEDSYRIAC RBASA ABOV" +
	"ESYRIAC RBASA BELOWSYRIAC DOTTED ZLAMA HORIZONTALSYRIAC DOTTED ZLAMA ANG" +
	"ULARSYRIAC HBASA ABOVESYRIAC HBASA BELOWSYRIAC HBASA-ESASA DOTTEDSYRIAC " +
	"ESASA ABOVESYRIAC ESASA BELOWSYRIAC RWAHASYRIAC FEMININE DOTSYRIAC QUSHS" +
	"HAYASYRIAC RUKKAKHASYRIAC TWO VERTICAL DOTS ABOVESYRIAC TWO VERTICAL DOT" +
	"S BELOWSYRIAC THREE DOTS ABOVESYRIAC THREE DOTS BELOWSYRIAC OBLIQUE LINE" +
	" ABOVESYRIAC OBLIQUE LINE BELOWSYRIAC MUSICSYRIAC BARREKHSYRIAC LETTER S" +
	"OGDIAN ZHAINSYRIAC LETTER SOGDIAN KHAPHSYRIAC LETTER SOGDIAN FEARABIC LE" +
	"TTER BEH WITH THREE DOTS HORIZONTALLY BELOWARABIC LETTER BEH WITH DOT BE" +
	"LOW AND THREE DOTS ABOVEARABIC LETTER BEH WITH THREE DOTS POINTING UPWAR" +
	"DS BELOWARABIC LETTER BEH WITH THREE DOTS POINTING UPWARDS BELOW AND TWO" +
	" DOTS ABOVEARABIC LETTER BEH WITH TWO DOTS BELOW AND DOT ABOVEARABIC LET" +
	"TER BEH WITH INVERTED SMALL V BELOWARABIC LETTER BEH WITH SMALL VARABIC " +
	"LETTER HAH WITH TWO DOTS ABOVEARABIC LETTER HAH WITH THREE DOTS POINTING" +
	" UPWARDS BELOWARABIC LETTER DAL WITH TWO DOTS VERTICALLY BELOW AND SMALL" +
	" TAHARABIC LETTER DAL WITH INVERTED SMALL V BELOWARABIC LETTER REH WITH " +
	"STROKEARABIC LETTER SEEN WITH FOUR DOTS ABOVEARABIC LETTER AIN WITH TWO ") + ("" +
	"DOTS ABOVEARABIC LETTER AIN WITH THREE DOTS POINTING DOWNWARDS ABOVEARAB" +
	"IC LETTER AIN WITH TWO DOTS VERTICALLY ABOVEARABIC LETTER FEH WITH TWO D" +
	"OTS BELOWARABIC LETTER FEH WITH THREE DOTS POINTING UPWARDS BELOWARABIC " +
	"LETTER KEHEH WITH DOT ABOVEARABIC LETTER KEHEH WITH THREE DOTS ABOVEARAB" +
	"IC LETTER KEHEH WITH THREE DOTS POINTING UPWARDS BELOWARABIC LETTER MEEM" +
	" WITH DOT ABOVEARABIC LETTER MEEM WITH DOT BELOWARABIC LETTER NOON WITH " +
	"TWO DOTS BELOWARABIC LETTER NOON WITH SMALL TAHARABIC LETTER NOON WITH S" +
	"MALL VARABIC LETTER LAM WITH BARARABIC LETTER REH WITH TWO DOTS VERTICAL" +
	"LY ABOVEARABIC LETTER REH WITH HAMZA ABOVEARABIC LETTER SEEN WITH TWO DO" +
	"TS VERTICALLY ABOVEARABIC LETTER HAH WITH SMALL ARABIC LETTER TAH BELOWA" +
	"RABIC LETTER HAH WITH SMALL ARABIC LETTER TAH AND TWO DOTSARABIC LETTER " +
	"SEEN WITH SMALL ARABIC LETTER TAH AND TWO DOTSARABIC LETTER REH WITH SMA" +
	"LL ARABIC LETTER TAH AND TWO DOTSARABIC LETTER HAH WITH SMALL ARABIC LET" +
	"TER TAH ABOVEARABIC LETTER ALEF WITH EXTENDED ARABIC-INDIC DIGIT TWO ABO" +
	"VEARABIC LETTER ALEF WITH EXTENDED ARABIC-INDIC DIGIT THREE ABOVEARABIC " +
	"LETTER FARSI YEH WITH EXTENDED ARABIC-INDIC DIGIT TWO ABOVEARABIC LETTER" +
	" FARSI YEH WITH EXTENDED ARABIC-INDIC DIGIT THREE ABOVEARABIC LETTER FAR" +
	"SI YEH WITH EXTENDED ARABIC-INDIC DIGIT FOUR BELOWARABIC LETTER WAW WITH" +
	" EXTENDED ARABIC-INDIC DIGIT TWO ABOVEARABIC LETTER WAW WITH EXTENDED AR" +
	"ABIC-INDIC DIGIT THREE ABOVEARABIC LETTER YEH BARREE WITH EXTENDED ARABI" +
	"C-INDIC DIGIT TWO ABOVEARABIC LETTER YEH BARREE WITH EXTENDED ARABIC-IND" +
	"IC DIGIT THREE ABOVEARABIC LETTER HAH WITH EXTENDED ARABIC-INDIC DIGIT F" +
	"OUR BELOWARABIC LETTER SEEN WITH EXTENDED ARABIC-INDIC DIGIT FOUR ABOVEA" +
	"RABIC LETTER SEEN WITH INVERTED VARABIC LETTER KAF WITH TWO DOTS ABOVETH" +
	"AANA LETTER HAATHAANA LETTER SHAVIYANITHAANA LETTER NOONUTHAANA LETTER R" +
	"AATHAANA LETTER BAATHAANA LETTER LHAVIYANITHAANA LETTER KAAFUTHAANA LETT" +
	"ER ALIFUTHAANA LETTER VAAVUTHAANA LETTER MEEMUTHAANA LETTER FAAFUTHAANA " +
	"LETTER DHAALUTHAANA LETTER THAATHAANA LETTER LAAMUTHAANA LETTER GAAFUTHA" +
	"ANA LETTER GNAVIYANITHAANA LETTER SEENUTHAANA LETTER DAVIYANITHAANA LETT" +
	"ER ZAVIYANITHAANA LETTER TAVIYANITHAANA LETTER YAATHAANA LETTER PAVIYANI" +
	"THAANA LETTER JAVIYANITHAANA LETTER CHAVIYANITHAANA LETTER TTAATHAANA LE" +
	"TTER HHAATHAANA LETTER KHAATHAANA LETTER THAALUTHAANA LETTER ZAATHAANA L" +
	"ETTER SHEENUTHAANA LETTER SAADHUTHAANA LETTER DAADHUTHAANA LETTER TOTHAA" +
	"NA LETTER ZOTHAANA LETTER AINUTHAANA LETTER GHAINUTHAANA LETTER QAAFUTHA" +
	"ANA LETTER WAAVUTHAANA ABAFILITHAANA AABAAFILITHAANA IBIFILITHAANA EEBEE" +
	"FILITHAANA UBUFILITHAANA OOBOOFILITHAANA EBEFILITHAANA EYBEYFILITHAANA O" +
	"BOFILITHAANA OABOAFILITHAANA SUKUNTHAANA LETTER NAANKO DIGIT ZERONKO DIG" +
	"IT ONENKO DIGIT TWONKO DIGIT THREENKO DIGIT FOURNKO DIGIT FIVENKO DIGIT " +
	"SIXNKO DIGIT SEVENNKO DIGIT EIGHTNKO DIGIT NINENKO LETTER ANKO LETTER EE" +
	"NKO LETTER INKO LETTER ENKO LETTER UNKO LETTER OONKO LETTER ONKO LETTER " +
	"DAGBASINNANKO LETTER NNKO LETTER BANKO LETTER PANKO LETTER TANKO LETTER " +
	"JANKO LETTER CHANKO LETTER DANKO LETTER RANKO LETTER RRANKO LETTER SANKO" +
	" LETTER GBANKO LETTER FANKO LETTER KANKO LETTER LANKO LETTER NA WOLOSONK" +
	"O LETTER MANKO LETTER NYANKO LETTER NANKO LETTER HANKO LETTER WANKO LETT" +
	"ER YANKO LETTER NYA WOLOSONKO LETTER JONA JANKO LETTER JONA CHANKO LETTE" +
	"R JONA RANKO COMBINING SHORT HIGH TONENKO COMBINING SHORT LOW TONENKO CO" +
	"MBINING SHORT RISING TONENKO COMBINING LONG DESCENDING TONENKO COMBINING" +
	" LONG HIGH TONENKO COMBINING LONG LOW TONENKO COMBINING LONG RISING TONE" +
	"NKO COMBINING NASALIZATION MARKNKO COMBINING DOUBLE DOT ABOVENKO HIGH TO" +
	"NE APOSTROPHENKO LOW TONE APOSTROPHENKO SYMBOL OO DENNENNKO SYMBOL GBAKU" +
	"RUNENNKO COMMANKO EXCLAMATION MARKNKO LAJANYALANNKO DANTAYALANNKO DOROME" +
	" SIGNNKO TAMAN SIGNSAMARITAN LETTER ALAFSAMARITAN LETTER BITSAMARITAN LE" +
	"TTER GAMANSAMARITAN LETTER DALATSAMARITAN LETTER IYSAMARITAN LETTER BAAS" +
	"AMARITAN LETTER ZENSAMARITAN LETTER ITSAMARITAN LETTER TITSAMARITAN LETT" +
	"ER YUTSAMARITAN LETTER KAAFSAMARITAN LETTER LABATSAMARITAN LETTER MIMSAM" +
	"ARITAN LETTER NUNSAMARITAN LETTER SINGAATSAMARITAN LETTER INSAMARITAN LE" +
	"TTER FISAMARITAN LETTER TSAADIYSAMARITAN LETTER QUFSAMARITAN LETTER RISH" +
	"SAMARITAN LETTER SHANSAMARITAN LETTER TAAFSAMARITAN MARK INSAMARITAN MAR" +
	"K IN-ALAFSAMARITAN MARK OCCLUSIONSAMARITAN MARK DAGESHSAMARITAN MODIFIER" +
	" LETTER EPENTHETIC YUTSAMARITAN MARK EPENTHETIC YUTSAMARITAN VOWEL SIGN " +
	"LONG ESAMARITAN VOWEL SIGN ESAMARITAN VOWEL SIGN OVERLONG AASAMARITAN VO" +
	"WEL SIGN LONG AASAMARITAN VOWEL SIGN AASAMARITAN VOWEL SIGN OVERLONG ASA" +
	"MARITAN VOWEL SIGN LONG ASAMARITAN VOWEL SIGN ASAMARITAN MODIFIER LETTER" +
	" SHORT ASAMARITAN VOWEL SIGN SHORT ASAMARITAN VOWEL SIGN LONG USAMARITAN") + ("" +
	" VOWEL SIGN USAMARITAN MODIFIER LETTER ISAMARITAN VOWEL SIGN LONG ISAMAR" +
	"ITAN VOWEL SIGN ISAMARITAN VOWEL SIGN OSAMARITAN VOWEL SIGN SUKUNSAMARIT" +
	"AN MARK NEQUDAASAMARITAN PUNCTUATION NEQUDAASAMARITAN PUNCTUATION AFSAAQ" +
	"SAMARITAN PUNCTUATION ANGEDSAMARITAN PUNCTUATION BAUSAMARITAN PUNCTUATIO" +
	"N ATMAAUSAMARITAN PUNCTUATION SHIYYAALAASAMARITAN ABBREVIATION MARKSAMAR" +
	"ITAN PUNCTUATION MELODIC QITSASAMARITAN PUNCTUATION ZIQAASAMARITAN PUNCT" +
	"UATION QITSASAMARITAN PUNCTUATION ZAEFSAMARITAN PUNCTUATION TURUSAMARITA" +
	"N PUNCTUATION ARKAANUSAMARITAN PUNCTUATION SOF MASHFAATSAMARITAN PUNCTUA" +
	"TION ANNAAUMANDAIC LETTER HALQAMANDAIC LETTER ABMANDAIC LETTER AGMANDAIC" +
	" LETTER ADMANDAIC LETTER AHMANDAIC LETTER USHENNAMANDAIC LETTER AZMANDAI" +
	"C LETTER ITMANDAIC LETTER ATTMANDAIC LETTER AKSAMANDAIC LETTER AKMANDAIC" +
	" LETTER ALMANDAIC LETTER AMMANDAIC LETTER ANMANDAIC LETTER ASMANDAIC LET" +
	"TER INMANDAIC LETTER APMANDAIC LETTER ASZMANDAIC LETTER AQMANDAIC LETTER" +
	" ARMANDAIC LETTER ASHMANDAIC LETTER ATMANDAIC LETTER DUSHENNAMANDAIC LET" +
	"TER KADMANDAIC LETTER AINMANDAIC AFFRICATION MARKMANDAIC VOCALIZATION MA" +
	"RKMANDAIC GEMINATION MARKMANDAIC PUNCTUATIONSYRIAC LETTER MALAYALAM NGAS" +
	"YRIAC LETTER MALAYALAM JASYRIAC LETTER MALAYALAM NYASYRIAC LETTER MALAYA" +
	"LAM TTASYRIAC LETTER MALAYALAM NNASYRIAC LETTER MALAYALAM NNNASYRIAC LET" +
	"TER MALAYALAM BHASYRIAC LETTER MALAYALAM RASYRIAC LETTER MALAYALAM LLASY" +
	"RIAC LETTER MALAYALAM LLLASYRIAC LETTER MALAYALAM SSAARABIC LETTER BEH W" +
	"ITH SMALL V BELOWARABIC LETTER BEH WITH HAMZA ABOVEARABIC LETTER JEEM WI" +
	"TH TWO DOTS ABOVEARABIC LETTER TAH WITH TWO DOTS ABOVEARABIC LETTER FEH " +
	"WITH DOT BELOW AND THREE DOTS ABOVEARABIC LETTER QAF WITH DOT BELOWARABI" +
	"C LETTER LAM WITH DOUBLE BARARABIC LETTER MEEM WITH THREE DOTS ABOVEARAB" +
	"IC LETTER YEH WITH TWO DOTS BELOW AND HAMZA ABOVEARABIC LETTER YEH WITH " +
	"TWO DOTS BELOW AND DOT ABOVEARABIC LETTER REH WITH LOOPARABIC LETTER WAW" +
	" WITH DOT WITHINARABIC LETTER ROHINGYA YEHARABIC LETTER LOW ALEFARABIC L" +
	"ETTER DAL WITH THREE DOTS BELOWARABIC LETTER SAD WITH THREE DOTS BELOWAR" +
	"ABIC LETTER GAF WITH INVERTED STROKEARABIC LETTER STRAIGHT WAWARABIC LET" +
	"TER ZAIN WITH INVERTED V ABOVEARABIC LETTER AIN WITH THREE DOTS BELOWARA" +
	"BIC LETTER KAF WITH DOT BELOWARABIC LETTER BEH WITH SMALL MEEM ABOVEARAB" +
	"IC LETTER PEH WITH SMALL MEEM ABOVEARABIC LETTER TEH WITH SMALL TEH ABOV" +
	"EARABIC LETTER REH WITH SMALL NOON ABOVEARABIC LETTER YEH WITH TWO DOTS " +
	"BELOW AND SMALL NOON ABOVEARABIC LETTER AFRICAN FEHARABIC LETTER AFRICAN" +
	" QAFARABIC LETTER AFRICAN NOONARABIC SMALL LOW WAWARABIC SMALL HIGH WORD" +
	" AR-RUBARABIC SMALL HIGH SADARABIC SMALL HIGH AINARABIC SMALL HIGH QAFAR" +
	"ABIC SMALL HIGH NOON WITH KASRAARABIC SMALL LOW NOON WITH KASRAARABIC SM" +
	"ALL HIGH WORD ATH-THALATHAARABIC SMALL HIGH WORD AS-SAJDAARABIC SMALL HI" +
	"GH WORD AN-NISFARABIC SMALL HIGH WORD SAKTAARABIC SMALL HIGH WORD QIFARA" +
	"BIC SMALL HIGH WORD WAQFAARABIC SMALL HIGH FOOTNOTE MARKERARABIC SMALL H" +
	"IGH SIGN SAFHAARABIC DISPUTED END OF AYAHARABIC TURNED DAMMA BELOWARABIC" +
	" CURLY FATHAARABIC CURLY DAMMAARABIC CURLY KASRAARABIC CURLY FATHATANARA" +
	"BIC CURLY DAMMATANARABIC CURLY KASRATANARABIC TONE ONE DOT ABOVEARABIC T" +
	"ONE TWO DOTS ABOVEARABIC TONE LOOP ABOVEARABIC TONE ONE DOT BELOWARABIC " +
	"TONE TWO DOTS BELOWARABIC TONE LOOP BELOWARABIC OPEN FATHATANARABIC OPEN" +
	" DAMMATANARABIC OPEN KASRATANARABIC SMALL HIGH WAWARABIC FATHA WITH RING" +
	"ARABIC FATHA WITH DOT ABOVEARABIC KASRA WITH DOT BELOWARABIC LEFT ARROWH" +
	"EAD ABOVEARABIC RIGHT ARROWHEAD ABOVEARABIC LEFT ARROWHEAD BELOWARABIC R" +
	"IGHT ARROWHEAD BELOWARABIC DOUBLE RIGHT ARROWHEAD ABOVEARABIC DOUBLE RIG" +
	"HT ARROWHEAD ABOVE WITH DOTARABIC RIGHT ARROWHEAD ABOVE WITH DOTARABIC D" +
	"AMMA WITH DOTARABIC MARK SIDEWAYS NOON GHUNNADEVANAGARI SIGN INVERTED CA" +
	"NDRABINDUDEVANAGARI SIGN CANDRABINDUDEVANAGARI SIGN ANUSVARADEVANAGARI S" +
	"IGN VISARGADEVANAGARI LETTER SHORT ADEVANAGARI LETTER ADEVANAGARI LETTER" +
	" AADEVANAGARI LETTER IDEVANAGARI LETTER IIDEVANAGARI LETTER UDEVANAGARI " +
	"LETTER UUDEVANAGARI LETTER VOCALIC RDEVANAGARI LETTER VOCALIC LDEVANAGAR" +
	"I LETTER CANDRA EDEVANAGARI LETTER SHORT EDEVANAGARI LETTER EDEVANAGARI " +
	"LETTER AIDEVANAGARI LETTER CANDRA ODEVANAGARI LETTER SHORT ODEVANAGARI L" +
	"ETTER ODEVANAGARI LETTER AUDEVANAGARI LETTER KADEVANAGARI LETTER KHADEVA" +
	"NAGARI LETTER GADEVANAGARI LETTER GHADEVANAGARI LETTER NGADEVANAGARI LET" +
	"TER CADEVANAGARI LETTER CHADEVANAGARI LETTER JADEVANAGARI LETTER JHADEVA" +
	"NAGARI LETTER NYADEVANAGARI LETTER TTADEVANAGARI LETTER TTHADEVANAGARI L" +
	"ETTER DDADEVANAGARI LETTER DDHADEVANAGARI LETTER NNADEVANAGARI LETTER TA" +
	"DEVANAGARI LETTER THADEVANAGARI LETTER DADEVANAGARI LETTER DHADEVANAGARI" +
	" LETTER NADEVANAGARI LETTER NNNADEVANAGARI LETTER PADEVANAGARI LETTER PH") + ("" +
	"ADEVANAGARI LETTER BADEVANAGARI LETTER BHADEVANAGARI LETTER MADEVANAGARI" +
	" LETTER YADEVANAGARI LETTER RADEVANAGARI LETTER RRADEVANAGARI LETTER LAD" +
	"EVANAGARI LETTER LLADEVANAGARI LETTER LLLADEVANAGARI LETTER VADEVANAGARI" +
	" LETTER SHADEVANAGARI LETTER SSADEVANAGARI LETTER SADEVANAGARI LETTER HA" +
	"DEVANAGARI VOWEL SIGN OEDEVANAGARI VOWEL SIGN OOEDEVANAGARI SIGN NUKTADE" +
	"VANAGARI SIGN AVAGRAHADEVANAGARI VOWEL SIGN AADEVANAGARI VOWEL SIGN IDEV" +
	"ANAGARI VOWEL SIGN IIDEVANAGARI VOWEL SIGN UDEVANAGARI VOWEL SIGN UUDEVA" +
	"NAGARI VOWEL SIGN VOCALIC RDEVANAGARI VOWEL SIGN VOCALIC RRDEVANAGARI VO" +
	"WEL SIGN CANDRA EDEVANAGARI VOWEL SIGN SHORT EDEVANAGARI VOWEL SIGN EDEV" +
	"ANAGARI VOWEL SIGN AIDEVANAGARI VOWEL SIGN CANDRA ODEVANAGARI VOWEL SIGN" +
	" SHORT ODEVANAGARI VOWEL SIGN ODEVANAGARI VOWEL SIGN AUDEVANAGARI SIGN V" +
	"IRAMADEVANAGARI VOWEL SIGN PRISHTHAMATRA EDEVANAGARI VOWEL SIGN AWDEVANA" +
	"GARI OMDEVANAGARI STRESS SIGN UDATTADEVANAGARI STRESS SIGN ANUDATTADEVAN" +
	"AGARI GRAVE ACCENTDEVANAGARI ACUTE ACCENTDEVANAGARI VOWEL SIGN CANDRA LO" +
	"NG EDEVANAGARI VOWEL SIGN UEDEVANAGARI VOWEL SIGN UUEDEVANAGARI LETTER Q" +
	"ADEVANAGARI LETTER KHHADEVANAGARI LETTER GHHADEVANAGARI LETTER ZADEVANAG" +
	"ARI LETTER DDDHADEVANAGARI LETTER RHADEVANAGARI LETTER FADEVANAGARI LETT" +
	"ER YYADEVANAGARI LETTER VOCALIC RRDEVANAGARI LETTER VOCALIC LLDEVANAGARI" +
	" VOWEL SIGN VOCALIC LDEVANAGARI VOWEL SIGN VOCALIC LLDEVANAGARI DANDADEV" +
	"ANAGARI DOUBLE DANDADEVANAGARI DIGIT ZERODEVANAGARI DIGIT ONEDEVANAGARI " +
	"DIGIT TWODEVANAGARI DIGIT THREEDEVANAGARI DIGIT FOURDEVANAGARI DIGIT FIV" +
	"EDEVANAGARI DIGIT SIXDEVANAGARI DIGIT SEVENDEVANAGARI DIGIT EIGHTDEVANAG" +
	"ARI DIGIT NINEDEVANAGARI ABBREVIATION SIGNDEVANAGARI SIGN HIGH SPACING D" +
	"OTDEVANAGARI LETTER CANDRA ADEVANAGARI LETTER OEDEVANAGARI LETTER OOEDEV" +
	"ANAGARI LETTER AWDEVANAGARI LETTER UEDEVANAGARI LETTER UUEDEVANAGARI LET" +
	"TER MARWARI DDADEVANAGARI LETTER ZHADEVANAGARI LETTER HEAVY YADEVANAGARI" +
	" LETTER GGADEVANAGARI LETTER JJADEVANAGARI LETTER GLOTTAL STOPDEVANAGARI" +
	" LETTER DDDADEVANAGARI LETTER BBABENGALI ANJIBENGALI SIGN CANDRABINDUBEN" +
	"GALI SIGN ANUSVARABENGALI SIGN VISARGABENGALI LETTER ABENGALI LETTER AAB" +
	"ENGALI LETTER IBENGALI LETTER IIBENGALI LETTER UBENGALI LETTER UUBENGALI" +
	" LETTER VOCALIC RBENGALI LETTER VOCALIC LBENGALI LETTER EBENGALI LETTER " +
	"AIBENGALI LETTER OBENGALI LETTER AUBENGALI LETTER KABENGALI LETTER KHABE" +
	"NGALI LETTER GABENGALI LETTER GHABENGALI LETTER NGABENGALI LETTER CABENG" +
	"ALI LETTER CHABENGALI LETTER JABENGALI LETTER JHABENGALI LETTER NYABENGA" +
	"LI LETTER TTABENGALI LETTER TTHABENGALI LETTER DDABENGALI LETTER DDHABEN" +
	"GALI LETTER NNABENGALI LETTER TABENGALI LETTER THABENGALI LETTER DABENGA" +
	"LI LETTER DHABENGALI LETTER NABENGALI LETTER PABENGALI LETTER PHABENGALI" +
	" LETTER BABENGALI LETTER BHABENGALI LETTER MABENGALI LETTER YABENGALI LE" +
	"TTER RABENGALI LETTER LABENGALI LETTER SHABENGALI LETTER SSABENGALI LETT" +
	"ER SABENGALI LETTER HABENGALI SIGN NUKTABENGALI SIGN AVAGRAHABENGALI VOW" +
	"EL SIGN AABENGALI VOWEL SIGN IBENGALI VOWEL SIGN IIBENGALI VOWEL SIGN UB" +
	"ENGALI VOWEL SIGN UUBENGALI VOWEL SIGN VOCALIC RBENGALI VOWEL SIGN VOCAL" +
	"IC RRBENGALI VOWEL SIGN EBENGALI VOWEL SIGN AIBENGALI VOWEL SIGN OBENGAL" +
	"I VOWEL SIGN AUBENGALI SIGN VIRAMABENGALI LETTER KHANDA TABENGALI AU LEN" +
	"GTH MARKBENGALI LETTER RRABENGALI LETTER RHABENGALI LETTER YYABENGALI LE" +
	"TTER VOCALIC RRBENGALI LETTER VOCALIC LLBENGALI VOWEL SIGN VOCALIC LBENG" +
	"ALI VOWEL SIGN VOCALIC LLBENGALI DIGIT ZEROBENGALI DIGIT ONEBENGALI DIGI" +
	"T TWOBENGALI DIGIT THREEBENGALI DIGIT FOURBENGALI DIGIT FIVEBENGALI DIGI" +
	"T SIXBENGALI DIGIT SEVENBENGALI DIGIT EIGHTBENGALI DIGIT NINEBENGALI LET" +
	"TER RA WITH MIDDLE DIAGONALBENGALI LETTER RA WITH LOWER DIAGONALBENGALI " +
	"RUPEE MARKBENGALI RUPEE SIGNBENGALI CURRENCY NUMERATOR ONEBENGALI CURREN" +
	"CY NUMERATOR TWOBENGALI CURRENCY NUMERATOR THREEBENGALI CURRENCY NUMERAT" +
	"OR FOURBENGALI CURRENCY NUMERATOR ONE LESS THAN THE DENOMINATORBENGALI C" +
	"URRENCY DENOMINATOR SIXTEENBENGALI ISSHARBENGALI GANDA MARKBENGALI LETTE" +
	"R VEDIC ANUSVARABENGALI ABBREVIATION SIGNBENGALI SANDHI MARKGURMUKHI SIG" +
	"N ADAK BINDIGURMUKHI SIGN BINDIGURMUKHI SIGN VISARGAGURMUKHI LETTER AGUR" +
	"MUKHI LETTER AAGURMUKHI LETTER IGURMUKHI LETTER IIGURMUKHI LETTER UGURMU" +
	"KHI LETTER UUGURMUKHI LETTER EEGURMUKHI LETTER AIGURMUKHI LETTER OOGURMU" +
	"KHI LETTER AUGURMUKHI LETTER KAGURMUKHI LETTER KHAGURMUKHI LETTER GAGURM" +
	"UKHI LETTER GHAGURMUKHI LETTER NGAGURMUKHI LETTER CAGURMUKHI LETTER CHAG" +
	"URMUKHI LETTER JAGURMUKHI LETTER JHAGURMUKHI LETTER NYAGURMUKHI LETTER T" +
	"TAGURMUKHI LETTER TTHAGURMUKHI LETTER DDAGURMUKHI LETTER DDHAGURMUKHI LE" +
	"TTER NNAGURMUKHI LETTER TAGURMUKHI LETTER THAGURMUKHI LETTER DAGURMUKHI " +
	"LETTER DHAGURMUKHI LETTER NAGURMUKHI LETTER PAGURMUKHI LETTER PHAGURMUKH") + ("" +
	"I LETTER BAGURMUKHI LETTER BHAGURMUKHI LETTER MAGURMUKHI LETTER YAGURMUK" +
	"HI LETTER RAGURMUKHI LETTER LAGURMUKHI LETTER LLAGURMUKHI LETTER VAGURMU" +
	"KHI LETTER SHAGURMUKHI LETTER SAGURMUKHI LETTER HAGURMUKHI SIGN NUKTAGUR" +
	"MUKHI VOWEL SIGN AAGURMUKHI VOWEL SIGN IGURMUKHI VOWEL SIGN IIGURMUKHI V" +
	"OWEL SIGN UGURMUKHI VOWEL SIGN UUGURMUKHI VOWEL SIGN EEGURMUKHI VOWEL SI" +
	"GN AIGURMUKHI VOWEL SIGN OOGURMUKHI VOWEL SIGN AUGURMUKHI SIGN VIRAMAGUR" +
	"MUKHI SIGN UDAATGURMUKHI LETTER KHHAGURMUKHI LETTER GHHAGURMUKHI LETTER " +
	"ZAGURMUKHI LETTER RRAGURMUKHI LETTER FAGURMUKHI DIGIT ZEROGURMUKHI DIGIT" +
	" ONEGURMUKHI DIGIT TWOGURMUKHI DIGIT THREEGURMUKHI DIGIT FOURGURMUKHI DI" +
	"GIT FIVEGURMUKHI DIGIT SIXGURMUKHI DIGIT SEVENGURMUKHI DIGIT EIGHTGURMUK" +
	"HI DIGIT NINEGURMUKHI TIPPIGURMUKHI ADDAKGURMUKHI IRIGURMUKHI URAGURMUKH" +
	"I EK ONKARGURMUKHI SIGN YAKASHGURMUKHI ABBREVIATION SIGNGUJARATI SIGN CA" +
	"NDRABINDUGUJARATI SIGN ANUSVARAGUJARATI SIGN VISARGAGUJARATI LETTER AGUJ" +
	"ARATI LETTER AAGUJARATI LETTER IGUJARATI LETTER IIGUJARATI LETTER UGUJAR" +
	"ATI LETTER UUGUJARATI LETTER VOCALIC RGUJARATI LETTER VOCALIC LGUJARATI " +
	"VOWEL CANDRA EGUJARATI LETTER EGUJARATI LETTER AIGUJARATI VOWEL CANDRA O" +
	"GUJARATI LETTER OGUJARATI LETTER AUGUJARATI LETTER KAGUJARATI LETTER KHA" +
	"GUJARATI LETTER GAGUJARATI LETTER GHAGUJARATI LETTER NGAGUJARATI LETTER " +
	"CAGUJARATI LETTER CHAGUJARATI LETTER JAGUJARATI LETTER JHAGUJARATI LETTE" +
	"R NYAGUJARATI LETTER TTAGUJARATI LETTER TTHAGUJARATI LETTER DDAGUJARATI " +
	"LETTER DDHAGUJARATI LETTER NNAGUJARATI LETTER TAGUJARATI LETTER THAGUJAR" +
	"ATI LETTER DAGUJARATI LETTER DHAGUJARATI LETTER NAGUJARATI LETTER PAGUJA" +
	"RATI LETTER PHAGUJARATI LETTER BAGUJARATI LETTER BHAGUJARATI LETTER MAGU" +
	"JARATI LETTER YAGUJARATI LETTER RAGUJARATI LETTER LAGUJARATI LETTER LLAG" +
	"UJARATI LETTER VAGUJARATI LETTER SHAGUJARATI LETTER SSAGUJARATI LETTER S" +
	"AGUJARATI LETTER HAGUJARATI SIGN NUKTAGUJARATI SIGN AVAGRAHAGUJARATI VOW" +
	"EL SIGN AAGUJARATI VOWEL SIGN IGUJARATI VOWEL SIGN IIGUJARATI VOWEL SIGN" +
	" UGUJARATI VOWEL SIGN UUGUJARATI VOWEL SIGN VOCALIC RGUJARATI VOWEL SIGN" +
	" VOCALIC RRGUJARATI VOWEL SIGN CANDRA EGUJARATI VOWEL SIGN EGUJARATI VOW" +
	"EL SIGN AIGUJARATI VOWEL SIGN CANDRA OGUJARATI VOWEL SIGN OGUJARATI VOWE" +
	"L SIGN AUGUJARATI SIGN VIRAMAGUJARATI OMGUJARATI LETTER VOCALIC RRGUJARA" +
	"TI LETTER VOCALIC LLGUJARATI VOWEL SIGN VOCALIC LGUJARATI VOWEL SIGN VOC" +
	"ALIC LLGUJARATI DIGIT ZEROGUJARATI DIGIT ONEGUJARATI DIGIT TWOGUJARATI D" +
	"IGIT THREEGUJARATI DIGIT FOURGUJARATI DIGIT FIVEGUJARATI DIGIT SIXGUJARA" +
	"TI DIGIT SEVENGUJARATI DIGIT EIGHTGUJARATI DIGIT NINEGUJARATI ABBREVIATI" +
	"ON SIGNGUJARATI RUPEE SIGNGUJARATI LETTER ZHAGUJARATI SIGN SUKUNGUJARATI" +
	" SIGN SHADDAGUJARATI SIGN MADDAHGUJARATI SIGN THREE-DOT NUKTA ABOVEGUJAR" +
	"ATI SIGN CIRCLE NUKTA ABOVEGUJARATI SIGN TWO-CIRCLE NUKTA ABOVEORIYA SIG" +
	"N CANDRABINDUORIYA SIGN ANUSVARAORIYA SIGN VISARGAORIYA LETTER AORIYA LE" +
	"TTER AAORIYA LETTER IORIYA LETTER IIORIYA LETTER UORIYA LETTER UUORIYA L" +
	"ETTER VOCALIC RORIYA LETTER VOCALIC LORIYA LETTER EORIYA LETTER AIORIYA " +
	"LETTER OORIYA LETTER AUORIYA LETTER KAORIYA LETTER KHAORIYA LETTER GAORI" +
	"YA LETTER GHAORIYA LETTER NGAORIYA LETTER CAORIYA LETTER CHAORIYA LETTER" +
	" JAORIYA LETTER JHAORIYA LETTER NYAORIYA LETTER TTAORIYA LETTER TTHAORIY" +
	"A LETTER DDAORIYA LETTER DDHAORIYA LETTER NNAORIYA LETTER TAORIYA LETTER" +
	" THAORIYA LETTER DAORIYA LETTER DHAORIYA LETTER NAORIYA LETTER PAORIYA L" +
	"ETTER PHAORIYA LETTER BAORIYA LETTER BHAORIYA LETTER MAORIYA LETTER YAOR" +
	"IYA LETTER RAORIYA LETTER LAORIYA LETTER LLAORIYA LETTER VAORIYA LETTER " +
	"SHAORIYA LETTER SSAORIYA LETTER SAORIYA LETTER HAORIYA SIGN NUKTAORIYA S" +
	"IGN AVAGRAHAORIYA VOWEL SIGN AAORIYA VOWEL SIGN IORIYA VOWEL SIGN IIORIY" +
	"A VOWEL SIGN UORIYA VOWEL SIGN UUORIYA VOWEL SIGN VOCALIC RORIYA VOWEL S" +
	"IGN VOCALIC RRORIYA VOWEL SIGN EORIYA VOWEL SIGN AIORIYA VOWEL SIGN OORI" +
	"YA VOWEL SIGN AUORIYA SIGN VIRAMAORIYA AI LENGTH MARKORIYA AU LENGTH MAR" +
	"KORIYA LETTER RRAORIYA LETTER RHAORIYA LETTER YYAORIYA LETTER VOCALIC RR" +
	"ORIYA LETTER VOCALIC LLORIYA VOWEL SIGN VOCALIC LORIYA VOWEL SIGN VOCALI" +
	"C LLORIYA DIGIT ZEROORIYA DIGIT ONEORIYA DIGIT TWOORIYA DIGIT THREEORIYA" +
	" DIGIT FOURORIYA DIGIT FIVEORIYA DIGIT SIXORIYA DIGIT SEVENORIYA DIGIT E" +
	"IGHTORIYA DIGIT NINEORIYA ISSHARORIYA LETTER WAORIYA FRACTION ONE QUARTE" +
	"RORIYA FRACTION ONE HALFORIYA FRACTION THREE QUARTERSORIYA FRACTION ONE " +
	"SIXTEENTHORIYA FRACTION ONE EIGHTHORIYA FRACTION THREE SIXTEENTHSTAMIL S" +
	"IGN ANUSVARATAMIL SIGN VISARGATAMIL LETTER ATAMIL LETTER AATAMIL LETTER " +
	"ITAMIL LETTER IITAMIL LETTER UTAMIL LETTER UUTAMIL LETTER ETAMIL LETTER " +
	"EETAMIL LETTER AITAMIL LETTER OTAMIL LETTER OOTAMIL LETTER AUTAMIL LETTE" +
	"R KATAMIL LETTER NGATAMIL LETTER CATAMIL LETTER JATAMIL LETTER NYATAMIL ") + ("" +
	"LETTER TTATAMIL LETTER NNATAMIL LETTER TATAMIL LETTER NATAMIL LETTER NNN" +
	"ATAMIL LETTER PATAMIL LETTER MATAMIL LETTER YATAMIL LETTER RATAMIL LETTE" +
	"R RRATAMIL LETTER LATAMIL LETTER LLATAMIL LETTER LLLATAMIL LETTER VATAMI" +
	"L LETTER SHATAMIL LETTER SSATAMIL LETTER SATAMIL LETTER HATAMIL VOWEL SI" +
	"GN AATAMIL VOWEL SIGN ITAMIL VOWEL SIGN IITAMIL VOWEL SIGN UTAMIL VOWEL " +
	"SIGN UUTAMIL VOWEL SIGN ETAMIL VOWEL SIGN EETAMIL VOWEL SIGN AITAMIL VOW" +
	"EL SIGN OTAMIL VOWEL SIGN OOTAMIL VOWEL SIGN AUTAMIL SIGN VIRAMATAMIL OM" +
	"TAMIL AU LENGTH MARKTAMIL DIGIT ZEROTAMIL DIGIT ONETAMIL DIGIT TWOTAMIL " +
	"DIGIT THREETAMIL DIGIT FOURTAMIL DIGIT FIVETAMIL DIGIT SIXTAMIL DIGIT SE" +
	"VENTAMIL DIGIT EIGHTTAMIL DIGIT NINETAMIL NUMBER TENTAMIL NUMBER ONE HUN" +
	"DREDTAMIL NUMBER ONE THOUSANDTAMIL DAY SIGNTAMIL MONTH SIGNTAMIL YEAR SI" +
	"GNTAMIL DEBIT SIGNTAMIL CREDIT SIGNTAMIL AS ABOVE SIGNTAMIL RUPEE SIGNTA" +
	"MIL NUMBER SIGNTELUGU SIGN COMBINING CANDRABINDU ABOVETELUGU SIGN CANDRA" +
	"BINDUTELUGU SIGN ANUSVARATELUGU SIGN VISARGATELUGU SIGN COMBINING ANUSVA" +
	"RA ABOVETELUGU LETTER ATELUGU LETTER AATELUGU LETTER ITELUGU LETTER IITE" +
	"LUGU LETTER UTELUGU LETTER UUTELUGU LETTER VOCALIC RTELUGU LETTER VOCALI" +
	"C LTELUGU LETTER ETELUGU LETTER EETELUGU LETTER AITELUGU LETTER OTELUGU " +
	"LETTER OOTELUGU LETTER AUTELUGU LETTER KATELUGU LETTER KHATELUGU LETTER " +
	"GATELUGU LETTER GHATELUGU LETTER NGATELUGU LETTER CATELUGU LETTER CHATEL" +
	"UGU LETTER JATELUGU LETTER JHATELUGU LETTER NYATELUGU LETTER TTATELUGU L" +
	"ETTER TTHATELUGU LETTER DDATELUGU LETTER DDHATELUGU LETTER NNATELUGU LET" +
	"TER TATELUGU LETTER THATELUGU LETTER DATELUGU LETTER DHATELUGU LETTER NA" +
	"TELUGU LETTER PATELUGU LETTER PHATELUGU LETTER BATELUGU LETTER BHATELUGU" +
	" LETTER MATELUGU LETTER YATELUGU LETTER RATELUGU LETTER RRATELUGU LETTER" +
	" LATELUGU LETTER LLATELUGU LETTER LLLATELUGU LETTER VATELUGU LETTER SHAT" +
	"ELUGU LETTER SSATELUGU LETTER SATELUGU LETTER HATELUGU SIGN AVAGRAHATELU" +
	"GU VOWEL SIGN AATELUGU VOWEL SIGN ITELUGU VOWEL SIGN IITELUGU VOWEL SIGN" +
	" UTELUGU VOWEL SIGN UUTELUGU VOWEL SIGN VOCALIC RTELUGU VOWEL SIGN VOCAL" +
	"IC RRTELUGU VOWEL SIGN ETELUGU VOWEL SIGN EETELUGU VOWEL SIGN AITELUGU V" +
	"OWEL SIGN OTELUGU VOWEL SIGN OOTELUGU VOWEL SIGN AUTELUGU SIGN VIRAMATEL" +
	"UGU LENGTH MARKTELUGU AI LENGTH MARKTELUGU LETTER TSATELUGU LETTER DZATE" +
	"LUGU LETTER RRRATELUGU LETTER VOCALIC RRTELUGU LETTER VOCALIC LLTELUGU V" +
	"OWEL SIGN VOCALIC LTELUGU VOWEL SIGN VOCALIC LLTELUGU DIGIT ZEROTELUGU D" +
	"IGIT ONETELUGU DIGIT TWOTELUGU DIGIT THREETELUGU DIGIT FOURTELUGU DIGIT " +
	"FIVETELUGU DIGIT SIXTELUGU DIGIT SEVENTELUGU DIGIT EIGHTTELUGU DIGIT NIN" +
	"ETELUGU SIGN SIDDHAMTELUGU FRACTION DIGIT ZERO FOR ODD POWERS OF FOURTEL" +
	"UGU FRACTION DIGIT ONE FOR ODD POWERS OF FOURTELUGU FRACTION DIGIT TWO F" +
	"OR ODD POWERS OF FOURTELUGU FRACTION DIGIT THREE FOR ODD POWERS OF FOURT" +
	"ELUGU FRACTION DIGIT ONE FOR EVEN POWERS OF FOURTELUGU FRACTION DIGIT TW" +
	"O FOR EVEN POWERS OF FOURTELUGU FRACTION DIGIT THREE FOR EVEN POWERS OF " +
	"FOURTELUGU SIGN TUUMUKANNADA SIGN SPACING CANDRABINDUKANNADA SIGN CANDRA" +
	"BINDUKANNADA SIGN ANUSVARAKANNADA SIGN VISARGAKANNADA SIGN SIDDHAMKANNAD" +
	"A LETTER AKANNADA LETTER AAKANNADA LETTER IKANNADA LETTER IIKANNADA LETT" +
	"ER UKANNADA LETTER UUKANNADA LETTER VOCALIC RKANNADA LETTER VOCALIC LKAN" +
	"NADA LETTER EKANNADA LETTER EEKANNADA LETTER AIKANNADA LETTER OKANNADA L" +
	"ETTER OOKANNADA LETTER AUKANNADA LETTER KAKANNADA LETTER KHAKANNADA LETT" +
	"ER GAKANNADA LETTER GHAKANNADA LETTER NGAKANNADA LETTER CAKANNADA LETTER" +
	" CHAKANNADA LETTER JAKANNADA LETTER JHAKANNADA LETTER NYAKANNADA LETTER " +
	"TTAKANNADA LETTER TTHAKANNADA LETTER DDAKANNADA LETTER DDHAKANNADA LETTE" +
	"R NNAKANNADA LETTER TAKANNADA LETTER THAKANNADA LETTER DAKANNADA LETTER " +
	"DHAKANNADA LETTER NAKANNADA LETTER PAKANNADA LETTER PHAKANNADA LETTER BA" +
	"KANNADA LETTER BHAKANNADA LETTER MAKANNADA LETTER YAKANNADA LETTER RAKAN" +
	"NADA LETTER RRAKANNADA LETTER LAKANNADA LETTER LLAKANNADA LETTER VAKANNA" +
	"DA LETTER SHAKANNADA LETTER SSAKANNADA LETTER SAKANNADA LETTER HAKANNADA" +
	" SIGN NUKTAKANNADA SIGN AVAGRAHAKANNADA VOWEL SIGN AAKANNADA VOWEL SIGN " +
	"IKANNADA VOWEL SIGN IIKANNADA VOWEL SIGN UKANNADA VOWEL SIGN UUKANNADA V" +
	"OWEL SIGN VOCALIC RKANNADA VOWEL SIGN VOCALIC RRKANNADA VOWEL SIGN EKANN" +
	"ADA VOWEL SIGN EEKANNADA VOWEL SIGN AIKANNADA VOWEL SIGN OKANNADA VOWEL " +
	"SIGN OOKANNADA VOWEL SIGN AUKANNADA SIGN VIRAMAKANNADA LENGTH MARKKANNAD" +
	"A AI LENGTH MARKKANNADA LETTER FAKANNADA LETTER VOCALIC RRKANNADA LETTER" +
	" VOCALIC LLKANNADA VOWEL SIGN VOCALIC LKANNADA VOWEL SIGN VOCALIC LLKANN" +
	"ADA DIGIT ZEROKANNADA DIGIT ONEKANNADA DIGIT TWOKANNADA DIGIT THREEKANNA" +
	"DA DIGIT FOURKANNADA DIGIT FIVEKANNADA DIGIT SIXKANNADA DIGIT SEVENKANNA" +
	"DA DIGIT EIGHTKANNADA DIGIT NINEKANNADA SIGN JIHVAMULIYAKANNADA SIGN UPA") + ("" +
	"DHMANIYAMALAYALAM SIGN COMBINING ANUSVARA ABOVEMALAYALAM SIGN CANDRABIND" +
	"UMALAYALAM SIGN ANUSVARAMALAYALAM SIGN VISARGAMALAYALAM LETTER AMALAYALA" +
	"M LETTER AAMALAYALAM LETTER IMALAYALAM LETTER IIMALAYALAM LETTER UMALAYA" +
	"LAM LETTER UUMALAYALAM LETTER VOCALIC RMALAYALAM LETTER VOCALIC LMALAYAL" +
	"AM LETTER EMALAYALAM LETTER EEMALAYALAM LETTER AIMALAYALAM LETTER OMALAY" +
	"ALAM LETTER OOMALAYALAM LETTER AUMALAYALAM LETTER KAMALAYALAM LETTER KHA" +
	"MALAYALAM LETTER GAMALAYALAM LETTER GHAMALAYALAM LETTER NGAMALAYALAM LET" +
	"TER CAMALAYALAM LETTER CHAMALAYALAM LETTER JAMALAYALAM LETTER JHAMALAYAL" +
	"AM LETTER NYAMALAYALAM LETTER TTAMALAYALAM LETTER TTHAMALAYALAM LETTER D" +
	"DAMALAYALAM LETTER DDHAMALAYALAM LETTER NNAMALAYALAM LETTER TAMALAYALAM " +
	"LETTER THAMALAYALAM LETTER DAMALAYALAM LETTER DHAMALAYALAM LETTER NAMALA" +
	"YALAM LETTER NNNAMALAYALAM LETTER PAMALAYALAM LETTER PHAMALAYALAM LETTER" +
	" BAMALAYALAM LETTER BHAMALAYALAM LETTER MAMALAYALAM LETTER YAMALAYALAM L" +
	"ETTER RAMALAYALAM LETTER RRAMALAYALAM LETTER LAMALAYALAM LETTER LLAMALAY" +
	"ALAM LETTER LLLAMALAYALAM LETTER VAMALAYALAM LETTER SHAMALAYALAM LETTER " +
	"SSAMALAYALAM LETTER SAMALAYALAM LETTER HAMALAYALAM LETTER TTTAMALAYALAM " +
	"SIGN VERTICAL BAR VIRAMAMALAYALAM SIGN CIRCULAR VIRAMAMALAYALAM SIGN AVA" +
	"GRAHAMALAYALAM VOWEL SIGN AAMALAYALAM VOWEL SIGN IMALAYALAM VOWEL SIGN I" +
	"IMALAYALAM VOWEL SIGN UMALAYALAM VOWEL SIGN UUMALAYALAM VOWEL SIGN VOCAL" +
	"IC RMALAYALAM VOWEL SIGN VOCALIC RRMALAYALAM VOWEL SIGN EMALAYALAM VOWEL" +
	" SIGN EEMALAYALAM VOWEL SIGN AIMALAYALAM VOWEL SIGN OMALAYALAM VOWEL SIG" +
	"N OOMALAYALAM VOWEL SIGN AUMALAYALAM SIGN VIRAMAMALAYALAM LETTER DOT REP" +
	"HMALAYALAM SIGN PARAMALAYALAM LETTER CHILLU MMALAYALAM LETTER CHILLU YMA" +
	"LAYALAM LETTER CHILLU LLLMALAYALAM AU LENGTH MARKMALAYALAM FRACTION ONE " +
	"ONE-HUNDRED-AND-SIXTIETHMALAYALAM FRACTION ONE FORTIETHMALAYALAM FRACTIO" +
	"N THREE EIGHTIETHSMALAYALAM FRACTION ONE TWENTIETHMALAYALAM FRACTION ONE" +
	" TENTHMALAYALAM FRACTION THREE TWENTIETHSMALAYALAM FRACTION ONE FIFTHMAL" +
	"AYALAM LETTER ARCHAIC IIMALAYALAM LETTER VOCALIC RRMALAYALAM LETTER VOCA" +
	"LIC LLMALAYALAM VOWEL SIGN VOCALIC LMALAYALAM VOWEL SIGN VOCALIC LLMALAY" +
	"ALAM DIGIT ZEROMALAYALAM DIGIT ONEMALAYALAM DIGIT TWOMALAYALAM DIGIT THR" +
	"EEMALAYALAM DIGIT FOURMALAYALAM DIGIT FIVEMALAYALAM DIGIT SIXMALAYALAM D" +
	"IGIT SEVENMALAYALAM DIGIT EIGHTMALAYALAM DIGIT NINEMALAYALAM NUMBER TENM" +
	"ALAYALAM NUMBER ONE HUNDREDMALAYALAM NUMBER ONE THOUSANDMALAYALAM FRACTI" +
	"ON ONE QUARTERMALAYALAM FRACTION ONE HALFMALAYALAM FRACTION THREE QUARTE" +
	"RSMALAYALAM FRACTION ONE SIXTEENTHMALAYALAM FRACTION ONE EIGHTHMALAYALAM" +
	" FRACTION THREE SIXTEENTHSMALAYALAM DATE MARKMALAYALAM LETTER CHILLU NNM" +
	"ALAYALAM LETTER CHILLU NMALAYALAM LETTER CHILLU RRMALAYALAM LETTER CHILL" +
	"U LMALAYALAM LETTER CHILLU LLMALAYALAM LETTER CHILLU KSINHALA SIGN ANUSV" +
	"ARAYASINHALA SIGN VISARGAYASINHALA LETTER AYANNASINHALA LETTER AAYANNASI" +
	"NHALA LETTER AEYANNASINHALA LETTER AEEYANNASINHALA LETTER IYANNASINHALA " +
	"LETTER IIYANNASINHALA LETTER UYANNASINHALA LETTER UUYANNASINHALA LETTER " +
	"IRUYANNASINHALA LETTER IRUUYANNASINHALA LETTER ILUYANNASINHALA LETTER IL" +
	"UUYANNASINHALA LETTER EYANNASINHALA LETTER EEYANNASINHALA LETTER AIYANNA" +
	"SINHALA LETTER OYANNASINHALA LETTER OOYANNASINHALA LETTER AUYANNASINHALA" +
	" LETTER ALPAPRAANA KAYANNASINHALA LETTER MAHAAPRAANA KAYANNASINHALA LETT" +
	"ER ALPAPRAANA GAYANNASINHALA LETTER MAHAAPRAANA GAYANNASINHALA LETTER KA" +
	"NTAJA NAASIKYAYASINHALA LETTER SANYAKA GAYANNASINHALA LETTER ALPAPRAANA " +
	"CAYANNASINHALA LETTER MAHAAPRAANA CAYANNASINHALA LETTER ALPAPRAANA JAYAN" +
	"NASINHALA LETTER MAHAAPRAANA JAYANNASINHALA LETTER TAALUJA NAASIKYAYASIN" +
	"HALA LETTER TAALUJA SANYOOGA NAAKSIKYAYASINHALA LETTER SANYAKA JAYANNASI" +
	"NHALA LETTER ALPAPRAANA TTAYANNASINHALA LETTER MAHAAPRAANA TTAYANNASINHA" +
	"LA LETTER ALPAPRAANA DDAYANNASINHALA LETTER MAHAAPRAANA DDAYANNASINHALA " +
	"LETTER MUURDHAJA NAYANNASINHALA LETTER SANYAKA DDAYANNASINHALA LETTER AL" +
	"PAPRAANA TAYANNASINHALA LETTER MAHAAPRAANA TAYANNASINHALA LETTER ALPAPRA" +
	"ANA DAYANNASINHALA LETTER MAHAAPRAANA DAYANNASINHALA LETTER DANTAJA NAYA" +
	"NNASINHALA LETTER SANYAKA DAYANNASINHALA LETTER ALPAPRAANA PAYANNASINHAL" +
	"A LETTER MAHAAPRAANA PAYANNASINHALA LETTER ALPAPRAANA BAYANNASINHALA LET" +
	"TER MAHAAPRAANA BAYANNASINHALA LETTER MAYANNASINHALA LETTER AMBA BAYANNA" +
	"SINHALA LETTER YAYANNASINHALA LETTER RAYANNASINHALA LETTER DANTAJA LAYAN" +
	"NASINHALA LETTER VAYANNASINHALA LETTER TAALUJA SAYANNASINHALA LETTER MUU" +
	"RDHAJA SAYANNASINHALA LETTER DANTAJA SAYANNASINHALA LETTER HAYANNASINHAL" +
	"A LETTER MUURDHAJA LAYANNASINHALA LETTER FAYANNASINHALA SIGN AL-LAKUNASI" +
	"NHALA VOWEL SIGN AELA-PILLASINHALA VOWEL SIGN KETTI AEDA-PILLASINHALA VO" +
	"WEL SIGN DIGA AEDA-PILLASINHALA VOWEL SIGN KETTI IS-PILLASINHALA VOWEL S") + ("" +
	"IGN DIGA IS-PILLASINHALA VOWEL SIGN KETTI PAA-PILLASINHALA VOWEL SIGN DI" +
	"GA PAA-PILLASINHALA VOWEL SIGN GAETTA-PILLASINHALA VOWEL SIGN KOMBUVASIN" +
	"HALA VOWEL SIGN DIGA KOMBUVASINHALA VOWEL SIGN KOMBU DEKASINHALA VOWEL S" +
	"IGN KOMBUVA HAA AELA-PILLASINHALA VOWEL SIGN KOMBUVA HAA DIGA AELA-PILLA" +
	"SINHALA VOWEL SIGN KOMBUVA HAA GAYANUKITTASINHALA VOWEL SIGN GAYANUKITTA" +
	"SINHALA LITH DIGIT ZEROSINHALA LITH DIGIT ONESINHALA LITH DIGIT TWOSINHA" +
	"LA LITH DIGIT THREESINHALA LITH DIGIT FOURSINHALA LITH DIGIT FIVESINHALA" +
	" LITH DIGIT SIXSINHALA LITH DIGIT SEVENSINHALA LITH DIGIT EIGHTSINHALA L" +
	"ITH DIGIT NINESINHALA VOWEL SIGN DIGA GAETTA-PILLASINHALA VOWEL SIGN DIG" +
	"A GAYANUKITTASINHALA PUNCTUATION KUNDDALIYATHAI CHARACTER KO KAITHAI CHA" +
	"RACTER KHO KHAITHAI CHARACTER KHO KHUATTHAI CHARACTER KHO KHWAITHAI CHAR" +
	"ACTER KHO KHONTHAI CHARACTER KHO RAKHANGTHAI CHARACTER NGO NGUTHAI CHARA" +
	"CTER CHO CHANTHAI CHARACTER CHO CHINGTHAI CHARACTER CHO CHANGTHAI CHARAC" +
	"TER SO SOTHAI CHARACTER CHO CHOETHAI CHARACTER YO YINGTHAI CHARACTER DO " +
	"CHADATHAI CHARACTER TO PATAKTHAI CHARACTER THO THANTHAI CHARACTER THO NA" +
	"NGMONTHOTHAI CHARACTER THO PHUTHAOTHAI CHARACTER NO NENTHAI CHARACTER DO" +
	" DEKTHAI CHARACTER TO TAOTHAI CHARACTER THO THUNGTHAI CHARACTER THO THAH" +
	"ANTHAI CHARACTER THO THONGTHAI CHARACTER NO NUTHAI CHARACTER BO BAIMAITH" +
	"AI CHARACTER PO PLATHAI CHARACTER PHO PHUNGTHAI CHARACTER FO FATHAI CHAR" +
	"ACTER PHO PHANTHAI CHARACTER FO FANTHAI CHARACTER PHO SAMPHAOTHAI CHARAC" +
	"TER MO MATHAI CHARACTER YO YAKTHAI CHARACTER RO RUATHAI CHARACTER RUTHAI" +
	" CHARACTER LO LINGTHAI CHARACTER LUTHAI CHARACTER WO WAENTHAI CHARACTER " +
	"SO SALATHAI CHARACTER SO RUSITHAI CHARACTER SO SUATHAI CHARACTER HO HIPT" +
	"HAI CHARACTER LO CHULATHAI CHARACTER O ANGTHAI CHARACTER HO NOKHUKTHAI C" +
	"HARACTER PAIYANNOITHAI CHARACTER SARA ATHAI CHARACTER MAI HAN-AKATTHAI C" +
	"HARACTER SARA AATHAI CHARACTER SARA AMTHAI CHARACTER SARA ITHAI CHARACTE" +
	"R SARA IITHAI CHARACTER SARA UETHAI CHARACTER SARA UEETHAI CHARACTER SAR" +
	"A UTHAI CHARACTER SARA UUTHAI CHARACTER PHINTHUTHAI CURRENCY SYMBOL BAHT" +
	"THAI CHARACTER SARA ETHAI CHARACTER SARA AETHAI CHARACTER SARA OTHAI CHA" +
	"RACTER SARA AI MAIMUANTHAI CHARACTER SARA AI MAIMALAITHAI CHARACTER LAKK" +
	"HANGYAOTHAI CHARACTER MAIYAMOKTHAI CHARACTER MAITAIKHUTHAI CHARACTER MAI" +
	" EKTHAI CHARACTER MAI THOTHAI CHARACTER MAI TRITHAI CHARACTER MAI CHATTA" +
	"WATHAI CHARACTER THANTHAKHATTHAI CHARACTER NIKHAHITTHAI CHARACTER YAMAKK" +
	"ANTHAI CHARACTER FONGMANTHAI DIGIT ZEROTHAI DIGIT ONETHAI DIGIT TWOTHAI " +
	"DIGIT THREETHAI DIGIT FOURTHAI DIGIT FIVETHAI DIGIT SIXTHAI DIGIT SEVENT" +
	"HAI DIGIT EIGHTTHAI DIGIT NINETHAI CHARACTER ANGKHANKHUTHAI CHARACTER KH" +
	"OMUTLAO LETTER KOLAO LETTER KHO SUNGLAO LETTER KHO TAMLAO LETTER PALI GH" +
	"ALAO LETTER NGOLAO LETTER COLAO LETTER PALI CHALAO LETTER SO TAMLAO LETT" +
	"ER PALI JHALAO LETTER NYOLAO LETTER PALI NYALAO LETTER PALI TTALAO LETTE" +
	"R PALI TTHALAO LETTER PALI DDALAO LETTER PALI DDHALAO LETTER PALI NNALAO" +
	" LETTER DOLAO LETTER TOLAO LETTER THO SUNGLAO LETTER THO TAMLAO LETTER P" +
	"ALI DHALAO LETTER NOLAO LETTER BOLAO LETTER POLAO LETTER PHO SUNGLAO LET" +
	"TER FO TAMLAO LETTER PHO TAMLAO LETTER FO SUNGLAO LETTER PALI BHALAO LET" +
	"TER MOLAO LETTER YOLAO LETTER LO LINGLAO LETTER LO LOOTLAO LETTER WOLAO " +
	"LETTER SANSKRIT SHALAO LETTER SANSKRIT SSALAO LETTER SO SUNGLAO LETTER H" +
	"O SUNGLAO LETTER PALI LLALAO LETTER OLAO LETTER HO TAMLAO ELLIPSISLAO VO" +
	"WEL SIGN ALAO VOWEL SIGN MAI KANLAO VOWEL SIGN AALAO VOWEL SIGN AMLAO VO" +
	"WEL SIGN ILAO VOWEL SIGN IILAO VOWEL SIGN YLAO VOWEL SIGN YYLAO VOWEL SI" +
	"GN ULAO VOWEL SIGN UULAO SIGN PALI VIRAMALAO VOWEL SIGN MAI KONLAO SEMIV" +
	"OWEL SIGN LOLAO SEMIVOWEL SIGN NYOLAO VOWEL SIGN ELAO VOWEL SIGN EILAO V" +
	"OWEL SIGN OLAO VOWEL SIGN AYLAO VOWEL SIGN AILAO KO LALAO TONE MAI EKLAO" +
	" TONE MAI THOLAO TONE MAI TILAO TONE MAI CATAWALAO CANCELLATION MARKLAO " +
	"NIGGAHITALAO DIGIT ZEROLAO DIGIT ONELAO DIGIT TWOLAO DIGIT THREELAO DIGI" +
	"T FOURLAO DIGIT FIVELAO DIGIT SIXLAO DIGIT SEVENLAO DIGIT EIGHTLAO DIGIT" +
	" NINELAO HO NOLAO HO MOLAO LETTER KHMU GOLAO LETTER KHMU NYOTIBETAN SYLL" +
	"ABLE OMTIBETAN MARK GTER YIG MGO TRUNCATED ATIBETAN MARK GTER YIG MGO -U" +
	"M RNAM BCAD MATIBETAN MARK GTER YIG MGO -UM GTER TSHEG MATIBETAN MARK IN" +
	"ITIAL YIG MGO MDUN MATIBETAN MARK CLOSING YIG MGO SGAB MATIBETAN MARK CA" +
	"RET YIG MGO PHUR SHAD MATIBETAN MARK YIG MGO TSHEG SHAD MATIBETAN MARK S" +
	"BRUL SHADTIBETAN MARK BSKUR YIG MGOTIBETAN MARK BKA- SHOG YIG MGOTIBETAN" +
	" MARK INTERSYLLABIC TSHEGTIBETAN MARK DELIMITER TSHEG BSTARTIBETAN MARK " +
	"SHADTIBETAN MARK NYIS SHADTIBETAN MARK TSHEG SHADTIBETAN MARK NYIS TSHEG" +
	" SHADTIBETAN MARK RIN CHEN SPUNGS SHADTIBETAN MARK RGYA GRAM SHADTIBETAN" +
	" MARK CARET -DZUD RTAGS ME LONG CANTIBETAN MARK GTER TSHEGTIBETAN LOGOTY") + ("" +
	"PE SIGN CHAD RTAGSTIBETAN LOGOTYPE SIGN LHAG RTAGSTIBETAN ASTROLOGICAL S" +
	"IGN SGRA GCAN -CHAR RTAGSTIBETAN ASTROLOGICAL SIGN -KHYUD PATIBETAN ASTR" +
	"OLOGICAL SIGN SDONG TSHUGSTIBETAN SIGN RDEL DKAR GCIGTIBETAN SIGN RDEL D" +
	"KAR GNYISTIBETAN SIGN RDEL DKAR GSUMTIBETAN SIGN RDEL NAG GCIGTIBETAN SI" +
	"GN RDEL NAG GNYISTIBETAN SIGN RDEL DKAR RDEL NAGTIBETAN DIGIT ZEROTIBETA" +
	"N DIGIT ONETIBETAN DIGIT TWOTIBETAN DIGIT THREETIBETAN DIGIT FOURTIBETAN" +
	" DIGIT FIVETIBETAN DIGIT SIXTIBETAN DIGIT SEVENTIBETAN DIGIT EIGHTTIBETA" +
	"N DIGIT NINETIBETAN DIGIT HALF ONETIBETAN DIGIT HALF TWOTIBETAN DIGIT HA" +
	"LF THREETIBETAN DIGIT HALF FOURTIBETAN DIGIT HALF FIVETIBETAN DIGIT HALF" +
	" SIXTIBETAN DIGIT HALF SEVENTIBETAN DIGIT HALF EIGHTTIBETAN DIGIT HALF N" +
	"INETIBETAN DIGIT HALF ZEROTIBETAN MARK BSDUS RTAGSTIBETAN MARK NGAS BZUN" +
	"G NYI ZLATIBETAN MARK CARET -DZUD RTAGS BZHI MIG CANTIBETAN MARK NGAS BZ" +
	"UNG SGOR RTAGSTIBETAN MARK CHE MGOTIBETAN MARK TSA -PHRUTIBETAN MARK GUG" +
	" RTAGS GYONTIBETAN MARK GUG RTAGS GYASTIBETAN MARK ANG KHANG GYONTIBETAN" +
	" MARK ANG KHANG GYASTIBETAN SIGN YAR TSHESTIBETAN SIGN MAR TSHESTIBETAN " +
	"LETTER KATIBETAN LETTER KHATIBETAN LETTER GATIBETAN LETTER GHATIBETAN LE" +
	"TTER NGATIBETAN LETTER CATIBETAN LETTER CHATIBETAN LETTER JATIBETAN LETT" +
	"ER NYATIBETAN LETTER TTATIBETAN LETTER TTHATIBETAN LETTER DDATIBETAN LET" +
	"TER DDHATIBETAN LETTER NNATIBETAN LETTER TATIBETAN LETTER THATIBETAN LET" +
	"TER DATIBETAN LETTER DHATIBETAN LETTER NATIBETAN LETTER PATIBETAN LETTER" +
	" PHATIBETAN LETTER BATIBETAN LETTER BHATIBETAN LETTER MATIBETAN LETTER T" +
	"SATIBETAN LETTER TSHATIBETAN LETTER DZATIBETAN LETTER DZHATIBETAN LETTER" +
	" WATIBETAN LETTER ZHATIBETAN LETTER ZATIBETAN LETTER -ATIBETAN LETTER YA" +
	"TIBETAN LETTER RATIBETAN LETTER LATIBETAN LETTER SHATIBETAN LETTER SSATI" +
	"BETAN LETTER SATIBETAN LETTER HATIBETAN LETTER ATIBETAN LETTER KSSATIBET" +
	"AN LETTER FIXED-FORM RATIBETAN LETTER KKATIBETAN LETTER RRATIBETAN VOWEL" +
	" SIGN AATIBETAN VOWEL SIGN ITIBETAN VOWEL SIGN IITIBETAN VOWEL SIGN UTIB" +
	"ETAN VOWEL SIGN UUTIBETAN VOWEL SIGN VOCALIC RTIBETAN VOWEL SIGN VOCALIC" +
	" RRTIBETAN VOWEL SIGN VOCALIC LTIBETAN VOWEL SIGN VOCALIC LLTIBETAN VOWE" +
	"L SIGN ETIBETAN VOWEL SIGN EETIBETAN VOWEL SIGN OTIBETAN VOWEL SIGN OOTI" +
	"BETAN SIGN RJES SU NGA ROTIBETAN SIGN RNAM BCADTIBETAN VOWEL SIGN REVERS" +
	"ED ITIBETAN VOWEL SIGN REVERSED IITIBETAN SIGN NYI ZLA NAA DATIBETAN SIG" +
	"N SNA LDANTIBETAN MARK HALANTATIBETAN MARK PALUTATIBETAN SIGN LCI RTAGST" +
	"IBETAN SIGN YANG RTAGSTIBETAN SIGN LCE TSA CANTIBETAN SIGN MCHU CANTIBET" +
	"AN SIGN GRU CAN RGYINGSTIBETAN SIGN GRU MED RGYINGSTIBETAN SIGN INVERTED" +
	" MCHU CANTIBETAN SUBJOINED SIGN LCE TSA CANTIBETAN SUBJOINED SIGN MCHU C" +
	"ANTIBETAN SUBJOINED SIGN INVERTED MCHU CANTIBETAN SUBJOINED LETTER KATIB" +
	"ETAN SUBJOINED LETTER KHATIBETAN SUBJOINED LETTER GATIBETAN SUBJOINED LE" +
	"TTER GHATIBETAN SUBJOINED LETTER NGATIBETAN SUBJOINED LETTER CATIBETAN S" +
	"UBJOINED LETTER CHATIBETAN SUBJOINED LETTER JATIBETAN SUBJOINED LETTER N" +
	"YATIBETAN SUBJOINED LETTER TTATIBETAN SUBJOINED LETTER TTHATIBETAN SUBJO" +
	"INED LETTER DDATIBETAN SUBJOINED LETTER DDHATIBETAN SUBJOINED LETTER NNA" +
	"TIBETAN SUBJOINED LETTER TATIBETAN SUBJOINED LETTER THATIBETAN SUBJOINED" +
	" LETTER DATIBETAN SUBJOINED LETTER DHATIBETAN SUBJOINED LETTER NATIBETAN" +
	" SUBJOINED LETTER PATIBETAN SUBJOINED LETTER PHATIBETAN SUBJOINED LETTER" +
	" BATIBETAN SUBJOINED LETTER BHATIBETAN SUBJOINED LETTER MATIBETAN SUBJOI" +
	"NED LETTER TSATIBETAN SUBJOINED LETTER TSHATIBETAN SUBJOINED LETTER DZAT" +
	"IBETAN SUBJOINED LETTER DZHATIBETAN SUBJOINED LETTER WATIBETAN SUBJOINED" +
	" LETTER ZHATIBETAN SUBJOINED LETTER ZATIBETAN SUBJOINED LETTER -ATIBETAN" +
	" SUBJOINED LETTER YATIBETAN SUBJOINED LETTER RATIBETAN SUBJOINED LETTER " +
	"LATIBETAN SUBJOINED LETTER SHATIBETAN SUBJOINED LETTER SSATIBETAN SUBJOI" +
	"NED LETTER SATIBETAN SUBJOINED LETTER HATIBETAN SUBJOINED LETTER ATIBETA" +
	"N SUBJOINED LETTER KSSATIBETAN SUBJOINED LETTER FIXED-FORM WATIBETAN SUB" +
	"JOINED LETTER FIXED-FORM YATIBETAN SUBJOINED LETTER FIXED-FORM RATIBETAN" +
	" KU RU KHATIBETAN KU RU KHA BZHI MIG CANTIBETAN CANTILLATION SIGN HEAVY " +
	"BEATTIBETAN CANTILLATION SIGN LIGHT BEATTIBETAN CANTILLATION SIGN CANG T" +
	"E-UTIBETAN CANTILLATION SIGN SBUB -CHALTIBETAN SYMBOL DRIL BUTIBETAN SYM" +
	"BOL RDO RJETIBETAN SYMBOL PADMA GDANTIBETAN SYMBOL RDO RJE RGYA GRAMTIBE" +
	"TAN SYMBOL PHUR PATIBETAN SYMBOL NOR BUTIBETAN SYMBOL NOR BU NYIS -KHYIL" +
	"TIBETAN SYMBOL NOR BU GSUM -KHYILTIBETAN SYMBOL NOR BU BZHI -KHYILTIBETA" +
	"N SIGN RDEL NAG RDEL DKARTIBETAN SIGN RDEL NAG GSUMTIBETAN MARK BSKA- SH" +
	"OG GI MGO RGYANTIBETAN MARK MNYAM YIG GI MGO RGYANTIBETAN MARK NYIS TSHE" +
	"GTIBETAN MARK INITIAL BRDA RNYING YIG MGO MDUN MATIBETAN MARK CLOSING BR" +
	"DA RNYING YIG MGO SGAB MARIGHT-FACING SVASTI SIGNLEFT-FACING SVASTI SIGN") + ("" +
	"RIGHT-FACING SVASTI SIGN WITH DOTSLEFT-FACING SVASTI SIGN WITH DOTSTIBET" +
	"AN MARK LEADING MCHAN RTAGSTIBETAN MARK TRAILING MCHAN RTAGSMYANMAR LETT" +
	"ER KAMYANMAR LETTER KHAMYANMAR LETTER GAMYANMAR LETTER GHAMYANMAR LETTER" +
	" NGAMYANMAR LETTER CAMYANMAR LETTER CHAMYANMAR LETTER JAMYANMAR LETTER J" +
	"HAMYANMAR LETTER NYAMYANMAR LETTER NNYAMYANMAR LETTER TTAMYANMAR LETTER " +
	"TTHAMYANMAR LETTER DDAMYANMAR LETTER DDHAMYANMAR LETTER NNAMYANMAR LETTE" +
	"R TAMYANMAR LETTER THAMYANMAR LETTER DAMYANMAR LETTER DHAMYANMAR LETTER " +
	"NAMYANMAR LETTER PAMYANMAR LETTER PHAMYANMAR LETTER BAMYANMAR LETTER BHA" +
	"MYANMAR LETTER MAMYANMAR LETTER YAMYANMAR LETTER RAMYANMAR LETTER LAMYAN" +
	"MAR LETTER WAMYANMAR LETTER SAMYANMAR LETTER HAMYANMAR LETTER LLAMYANMAR" +
	" LETTER AMYANMAR LETTER SHAN AMYANMAR LETTER IMYANMAR LETTER IIMYANMAR L" +
	"ETTER UMYANMAR LETTER UUMYANMAR LETTER EMYANMAR LETTER MON EMYANMAR LETT" +
	"ER OMYANMAR LETTER AUMYANMAR VOWEL SIGN TALL AAMYANMAR VOWEL SIGN AAMYAN" +
	"MAR VOWEL SIGN IMYANMAR VOWEL SIGN IIMYANMAR VOWEL SIGN UMYANMAR VOWEL S" +
	"IGN UUMYANMAR VOWEL SIGN EMYANMAR VOWEL SIGN AIMYANMAR VOWEL SIGN MON II" +
	"MYANMAR VOWEL SIGN MON OMYANMAR VOWEL SIGN E ABOVEMYANMAR SIGN ANUSVARAM" +
	"YANMAR SIGN DOT BELOWMYANMAR SIGN VISARGAMYANMAR SIGN VIRAMAMYANMAR SIGN" +
	" ASATMYANMAR CONSONANT SIGN MEDIAL YAMYANMAR CONSONANT SIGN MEDIAL RAMYA" +
	"NMAR CONSONANT SIGN MEDIAL WAMYANMAR CONSONANT SIGN MEDIAL HAMYANMAR LET" +
	"TER GREAT SAMYANMAR DIGIT ZEROMYANMAR DIGIT ONEMYANMAR DIGIT TWOMYANMAR " +
	"DIGIT THREEMYANMAR DIGIT FOURMYANMAR DIGIT FIVEMYANMAR DIGIT SIXMYANMAR " +
	"DIGIT SEVENMYANMAR DIGIT EIGHTMYANMAR DIGIT NINEMYANMAR SIGN LITTLE SECT" +
	"IONMYANMAR SIGN SECTIONMYANMAR SYMBOL LOCATIVEMYANMAR SYMBOL COMPLETEDMY" +
	"ANMAR SYMBOL AFOREMENTIONEDMYANMAR SYMBOL GENITIVEMYANMAR LETTER SHAMYAN" +
	"MAR LETTER SSAMYANMAR LETTER VOCALIC RMYANMAR LETTER VOCALIC RRMYANMAR L" +
	"ETTER VOCALIC LMYANMAR LETTER VOCALIC LLMYANMAR VOWEL SIGN VOCALIC RMYAN" +
	"MAR VOWEL SIGN VOCALIC RRMYANMAR VOWEL SIGN VOCALIC LMYANMAR VOWEL SIGN " +
	"VOCALIC LLMYANMAR LETTER MON NGAMYANMAR LETTER MON JHAMYANMAR LETTER MON" +
	" BBAMYANMAR LETTER MON BBEMYANMAR CONSONANT SIGN MON MEDIAL NAMYANMAR CO" +
	"NSONANT SIGN MON MEDIAL MAMYANMAR CONSONANT SIGN MON MEDIAL LAMYANMAR LE" +
	"TTER SGAW KAREN SHAMYANMAR VOWEL SIGN SGAW KAREN EUMYANMAR TONE MARK SGA" +
	"W KAREN HATHIMYANMAR TONE MARK SGAW KAREN KE PHOMYANMAR LETTER WESTERN P" +
	"WO KAREN THAMYANMAR LETTER WESTERN PWO KAREN PWAMYANMAR VOWEL SIGN WESTE" +
	"RN PWO KAREN EUMYANMAR VOWEL SIGN WESTERN PWO KAREN UEMYANMAR SIGN WESTE" +
	"RN PWO KAREN TONE-1MYANMAR SIGN WESTERN PWO KAREN TONE-2MYANMAR SIGN WES" +
	"TERN PWO KAREN TONE-3MYANMAR SIGN WESTERN PWO KAREN TONE-4MYANMAR SIGN W" +
	"ESTERN PWO KAREN TONE-5MYANMAR LETTER EASTERN PWO KAREN NNAMYANMAR LETTE" +
	"R EASTERN PWO KAREN YWAMYANMAR LETTER EASTERN PWO KAREN GHWAMYANMAR VOWE" +
	"L SIGN GEBA KAREN IMYANMAR VOWEL SIGN KAYAH OEMYANMAR VOWEL SIGN KAYAH U" +
	"MYANMAR VOWEL SIGN KAYAH EEMYANMAR LETTER SHAN KAMYANMAR LETTER SHAN KHA" +
	"MYANMAR LETTER SHAN GAMYANMAR LETTER SHAN CAMYANMAR LETTER SHAN ZAMYANMA" +
	"R LETTER SHAN NYAMYANMAR LETTER SHAN DAMYANMAR LETTER SHAN NAMYANMAR LET" +
	"TER SHAN PHAMYANMAR LETTER SHAN FAMYANMAR LETTER SHAN BAMYANMAR LETTER S" +
	"HAN THAMYANMAR LETTER SHAN HAMYANMAR CONSONANT SIGN SHAN MEDIAL WAMYANMA" +
	"R VOWEL SIGN SHAN AAMYANMAR VOWEL SIGN SHAN EMYANMAR VOWEL SIGN SHAN E A" +
	"BOVEMYANMAR VOWEL SIGN SHAN FINAL YMYANMAR SIGN SHAN TONE-2MYANMAR SIGN " +
	"SHAN TONE-3MYANMAR SIGN SHAN TONE-5MYANMAR SIGN SHAN TONE-6MYANMAR SIGN " +
	"SHAN COUNCIL TONE-2MYANMAR SIGN SHAN COUNCIL TONE-3MYANMAR SIGN SHAN COU" +
	"NCIL EMPHATIC TONEMYANMAR LETTER RUMAI PALAUNG FAMYANMAR SIGN RUMAI PALA" +
	"UNG TONE-5MYANMAR SHAN DIGIT ZEROMYANMAR SHAN DIGIT ONEMYANMAR SHAN DIGI" +
	"T TWOMYANMAR SHAN DIGIT THREEMYANMAR SHAN DIGIT FOURMYANMAR SHAN DIGIT F" +
	"IVEMYANMAR SHAN DIGIT SIXMYANMAR SHAN DIGIT SEVENMYANMAR SHAN DIGIT EIGH" +
	"TMYANMAR SHAN DIGIT NINEMYANMAR SIGN KHAMTI TONE-1MYANMAR SIGN KHAMTI TO" +
	"NE-3MYANMAR VOWEL SIGN AITON AMYANMAR VOWEL SIGN AITON AIMYANMAR SYMBOL " +
	"SHAN ONEMYANMAR SYMBOL SHAN EXCLAMATIONGEORGIAN CAPITAL LETTER ANGEORGIA" +
	"N CAPITAL LETTER BANGEORGIAN CAPITAL LETTER GANGEORGIAN CAPITAL LETTER D" +
	"ONGEORGIAN CAPITAL LETTER ENGEORGIAN CAPITAL LETTER VINGEORGIAN CAPITAL " +
	"LETTER ZENGEORGIAN CAPITAL LETTER TANGEORGIAN CAPITAL LETTER INGEORGIAN " +
	"CAPITAL LETTER KANGEORGIAN CAPITAL LETTER LASGEORGIAN CAPITAL LETTER MAN" +
	"GEORGIAN CAPITAL LETTER NARGEORGIAN CAPITAL LETTER ONGEORGIAN CAPITAL LE" +
	"TTER PARGEORGIAN CAPITAL LETTER ZHARGEORGIAN CAPITAL LETTER RAEGEORGIAN " +
	"CAPITAL LETTER SANGEORGIAN CAPITAL LETTER TARGEORGIAN CAPITAL LETTER UNG" +
	"EORGIAN CAPITAL LETTER PHARGEORGIAN CAPITAL LETTER KHARGEORGIAN CAPITAL " +
	"LETTER GHANGEORGIAN CAPITAL LETTER QARGEORGIAN CAPITAL LETTER SHINGEORGI") + ("" +
	"AN CAPITAL LETTER CHINGEORGIAN CAPITAL LETTER CANGEORGIAN CAPITAL LETTER" +
	" JILGEORGIAN CAPITAL LETTER CILGEORGIAN CAPITAL LETTER CHARGEORGIAN CAPI" +
	"TAL LETTER XANGEORGIAN CAPITAL LETTER JHANGEORGIAN CAPITAL LETTER HAEGEO" +
	"RGIAN CAPITAL LETTER HEGEORGIAN CAPITAL LETTER HIEGEORGIAN CAPITAL LETTE" +
	"R WEGEORGIAN CAPITAL LETTER HARGEORGIAN CAPITAL LETTER HOEGEORGIAN CAPIT" +
	"AL LETTER YNGEORGIAN CAPITAL LETTER AENGEORGIAN LETTER ANGEORGIAN LETTER" +
	" BANGEORGIAN LETTER GANGEORGIAN LETTER DONGEORGIAN LETTER ENGEORGIAN LET" +
	"TER VINGEORGIAN LETTER ZENGEORGIAN LETTER TANGEORGIAN LETTER INGEORGIAN " +
	"LETTER KANGEORGIAN LETTER LASGEORGIAN LETTER MANGEORGIAN LETTER NARGEORG" +
	"IAN LETTER ONGEORGIAN LETTER PARGEORGIAN LETTER ZHARGEORGIAN LETTER RAEG" +
	"EORGIAN LETTER SANGEORGIAN LETTER TARGEORGIAN LETTER UNGEORGIAN LETTER P" +
	"HARGEORGIAN LETTER KHARGEORGIAN LETTER GHANGEORGIAN LETTER QARGEORGIAN L" +
	"ETTER SHINGEORGIAN LETTER CHINGEORGIAN LETTER CANGEORGIAN LETTER JILGEOR" +
	"GIAN LETTER CILGEORGIAN LETTER CHARGEORGIAN LETTER XANGEORGIAN LETTER JH" +
	"ANGEORGIAN LETTER HAEGEORGIAN LETTER HEGEORGIAN LETTER HIEGEORGIAN LETTE" +
	"R WEGEORGIAN LETTER HARGEORGIAN LETTER HOEGEORGIAN LETTER FIGEORGIAN LET" +
	"TER YNGEORGIAN LETTER ELIFIGEORGIAN LETTER TURNED GANGEORGIAN LETTER AIN" +
	"GEORGIAN PARAGRAPH SEPARATORMODIFIER LETTER GEORGIAN NARGEORGIAN LETTER " +
	"AENGEORGIAN LETTER HARD SIGNGEORGIAN LETTER LABIAL SIGNHANGUL CHOSEONG K" +
	"IYEOKHANGUL CHOSEONG SSANGKIYEOKHANGUL CHOSEONG NIEUNHANGUL CHOSEONG TIK" +
	"EUTHANGUL CHOSEONG SSANGTIKEUTHANGUL CHOSEONG RIEULHANGUL CHOSEONG MIEUM" +
	"HANGUL CHOSEONG PIEUPHANGUL CHOSEONG SSANGPIEUPHANGUL CHOSEONG SIOSHANGU" +
	"L CHOSEONG SSANGSIOSHANGUL CHOSEONG IEUNGHANGUL CHOSEONG CIEUCHANGUL CHO" +
	"SEONG SSANGCIEUCHANGUL CHOSEONG CHIEUCHHANGUL CHOSEONG KHIEUKHHANGUL CHO" +
	"SEONG THIEUTHHANGUL CHOSEONG PHIEUPHHANGUL CHOSEONG HIEUHHANGUL CHOSEONG" +
	" NIEUN-KIYEOKHANGUL CHOSEONG SSANGNIEUNHANGUL CHOSEONG NIEUN-TIKEUTHANGU" +
	"L CHOSEONG NIEUN-PIEUPHANGUL CHOSEONG TIKEUT-KIYEOKHANGUL CHOSEONG RIEUL" +
	"-NIEUNHANGUL CHOSEONG SSANGRIEULHANGUL CHOSEONG RIEUL-HIEUHHANGUL CHOSEO" +
	"NG KAPYEOUNRIEULHANGUL CHOSEONG MIEUM-PIEUPHANGUL CHOSEONG KAPYEOUNMIEUM" +
	"HANGUL CHOSEONG PIEUP-KIYEOKHANGUL CHOSEONG PIEUP-NIEUNHANGUL CHOSEONG P" +
	"IEUP-TIKEUTHANGUL CHOSEONG PIEUP-SIOSHANGUL CHOSEONG PIEUP-SIOS-KIYEOKHA" +
	"NGUL CHOSEONG PIEUP-SIOS-TIKEUTHANGUL CHOSEONG PIEUP-SIOS-PIEUPHANGUL CH" +
	"OSEONG PIEUP-SSANGSIOSHANGUL CHOSEONG PIEUP-SIOS-CIEUCHANGUL CHOSEONG PI" +
	"EUP-CIEUCHANGUL CHOSEONG PIEUP-CHIEUCHHANGUL CHOSEONG PIEUP-THIEUTHHANGU" +
	"L CHOSEONG PIEUP-PHIEUPHHANGUL CHOSEONG KAPYEOUNPIEUPHANGUL CHOSEONG KAP" +
	"YEOUNSSANGPIEUPHANGUL CHOSEONG SIOS-KIYEOKHANGUL CHOSEONG SIOS-NIEUNHANG" +
	"UL CHOSEONG SIOS-TIKEUTHANGUL CHOSEONG SIOS-RIEULHANGUL CHOSEONG SIOS-MI" +
	"EUMHANGUL CHOSEONG SIOS-PIEUPHANGUL CHOSEONG SIOS-PIEUP-KIYEOKHANGUL CHO" +
	"SEONG SIOS-SSANGSIOSHANGUL CHOSEONG SIOS-IEUNGHANGUL CHOSEONG SIOS-CIEUC" +
	"HANGUL CHOSEONG SIOS-CHIEUCHHANGUL CHOSEONG SIOS-KHIEUKHHANGUL CHOSEONG " +
	"SIOS-THIEUTHHANGUL CHOSEONG SIOS-PHIEUPHHANGUL CHOSEONG SIOS-HIEUHHANGUL" +
	" CHOSEONG CHITUEUMSIOSHANGUL CHOSEONG CHITUEUMSSANGSIOSHANGUL CHOSEONG C" +
	"EONGCHIEUMSIOSHANGUL CHOSEONG CEONGCHIEUMSSANGSIOSHANGUL CHOSEONG PANSIO" +
	"SHANGUL CHOSEONG IEUNG-KIYEOKHANGUL CHOSEONG IEUNG-TIKEUTHANGUL CHOSEONG" +
	" IEUNG-MIEUMHANGUL CHOSEONG IEUNG-PIEUPHANGUL CHOSEONG IEUNG-SIOSHANGUL " +
	"CHOSEONG IEUNG-PANSIOSHANGUL CHOSEONG SSANGIEUNGHANGUL CHOSEONG IEUNG-CI" +
	"EUCHANGUL CHOSEONG IEUNG-CHIEUCHHANGUL CHOSEONG IEUNG-THIEUTHHANGUL CHOS" +
	"EONG IEUNG-PHIEUPHHANGUL CHOSEONG YESIEUNGHANGUL CHOSEONG CIEUC-IEUNGHAN" +
	"GUL CHOSEONG CHITUEUMCIEUCHANGUL CHOSEONG CHITUEUMSSANGCIEUCHANGUL CHOSE" +
	"ONG CEONGCHIEUMCIEUCHANGUL CHOSEONG CEONGCHIEUMSSANGCIEUCHANGUL CHOSEONG" +
	" CHIEUCH-KHIEUKHHANGUL CHOSEONG CHIEUCH-HIEUHHANGUL CHOSEONG CHITUEUMCHI" +
	"EUCHHANGUL CHOSEONG CEONGCHIEUMCHIEUCHHANGUL CHOSEONG PHIEUPH-PIEUPHANGU" +
	"L CHOSEONG KAPYEOUNPHIEUPHHANGUL CHOSEONG SSANGHIEUHHANGUL CHOSEONG YEOR" +
	"INHIEUHHANGUL CHOSEONG KIYEOK-TIKEUTHANGUL CHOSEONG NIEUN-SIOSHANGUL CHO" +
	"SEONG NIEUN-CIEUCHANGUL CHOSEONG NIEUN-HIEUHHANGUL CHOSEONG TIKEUT-RIEUL" +
	"HANGUL CHOSEONG FILLERHANGUL JUNGSEONG FILLERHANGUL JUNGSEONG AHANGUL JU" +
	"NGSEONG AEHANGUL JUNGSEONG YAHANGUL JUNGSEONG YAEHANGUL JUNGSEONG EOHANG" +
	"UL JUNGSEONG EHANGUL JUNGSEONG YEOHANGUL JUNGSEONG YEHANGUL JUNGSEONG OH" +
	"ANGUL JUNGSEONG WAHANGUL JUNGSEONG WAEHANGUL JUNGSEONG OEHANGUL JUNGSEON" +
	"G YOHANGUL JUNGSEONG UHANGUL JUNGSEONG WEOHANGUL JUNGSEONG WEHANGUL JUNG" +
	"SEONG WIHANGUL JUNGSEONG YUHANGUL JUNGSEONG EUHANGUL JUNGSEONG YIHANGUL " +
	"JUNGSEONG IHANGUL JUNGSEONG A-OHANGUL JUNGSEONG A-UHANGUL JUNGSEONG YA-O" +
	"HANGUL JUNGSEONG YA-YOHANGUL JUNGSEONG EO-OHANGUL JUNGSEONG EO-UHANGUL J" +
	"UNGSEONG EO-EUHANGUL JUNGSEONG YEO-OHANGUL JUNGSEONG YEO-UHANGUL JUNGSEO") + ("" +
	"NG O-EOHANGUL JUNGSEONG O-EHANGUL JUNGSEONG O-YEHANGUL JUNGSEONG O-OHANG" +
	"UL JUNGSEONG O-UHANGUL JUNGSEONG YO-YAHANGUL JUNGSEONG YO-YAEHANGUL JUNG" +
	"SEONG YO-YEOHANGUL JUNGSEONG YO-OHANGUL JUNGSEONG YO-IHANGUL JUNGSEONG U" +
	"-AHANGUL JUNGSEONG U-AEHANGUL JUNGSEONG U-EO-EUHANGUL JUNGSEONG U-YEHANG" +
	"UL JUNGSEONG U-UHANGUL JUNGSEONG YU-AHANGUL JUNGSEONG YU-EOHANGUL JUNGSE" +
	"ONG YU-EHANGUL JUNGSEONG YU-YEOHANGUL JUNGSEONG YU-YEHANGUL JUNGSEONG YU" +
	"-UHANGUL JUNGSEONG YU-IHANGUL JUNGSEONG EU-UHANGUL JUNGSEONG EU-EUHANGUL" +
	" JUNGSEONG YI-UHANGUL JUNGSEONG I-AHANGUL JUNGSEONG I-YAHANGUL JUNGSEONG" +
	" I-OHANGUL JUNGSEONG I-UHANGUL JUNGSEONG I-EUHANGUL JUNGSEONG I-ARAEAHAN" +
	"GUL JUNGSEONG ARAEAHANGUL JUNGSEONG ARAEA-EOHANGUL JUNGSEONG ARAEA-UHANG" +
	"UL JUNGSEONG ARAEA-IHANGUL JUNGSEONG SSANGARAEAHANGUL JUNGSEONG A-EUHANG" +
	"UL JUNGSEONG YA-UHANGUL JUNGSEONG YEO-YAHANGUL JUNGSEONG O-YAHANGUL JUNG" +
	"SEONG O-YAEHANGUL JONGSEONG KIYEOKHANGUL JONGSEONG SSANGKIYEOKHANGUL JON" +
	"GSEONG KIYEOK-SIOSHANGUL JONGSEONG NIEUNHANGUL JONGSEONG NIEUN-CIEUCHANG" +
	"UL JONGSEONG NIEUN-HIEUHHANGUL JONGSEONG TIKEUTHANGUL JONGSEONG RIEULHAN" +
	"GUL JONGSEONG RIEUL-KIYEOKHANGUL JONGSEONG RIEUL-MIEUMHANGUL JONGSEONG R" +
	"IEUL-PIEUPHANGUL JONGSEONG RIEUL-SIOSHANGUL JONGSEONG RIEUL-THIEUTHHANGU" +
	"L JONGSEONG RIEUL-PHIEUPHHANGUL JONGSEONG RIEUL-HIEUHHANGUL JONGSEONG MI" +
	"EUMHANGUL JONGSEONG PIEUPHANGUL JONGSEONG PIEUP-SIOSHANGUL JONGSEONG SIO" +
	"SHANGUL JONGSEONG SSANGSIOSHANGUL JONGSEONG IEUNGHANGUL JONGSEONG CIEUCH" +
	"ANGUL JONGSEONG CHIEUCHHANGUL JONGSEONG KHIEUKHHANGUL JONGSEONG THIEUTHH" +
	"ANGUL JONGSEONG PHIEUPHHANGUL JONGSEONG HIEUHHANGUL JONGSEONG KIYEOK-RIE" +
	"ULHANGUL JONGSEONG KIYEOK-SIOS-KIYEOKHANGUL JONGSEONG NIEUN-KIYEOKHANGUL" +
	" JONGSEONG NIEUN-TIKEUTHANGUL JONGSEONG NIEUN-SIOSHANGUL JONGSEONG NIEUN" +
	"-PANSIOSHANGUL JONGSEONG NIEUN-THIEUTHHANGUL JONGSEONG TIKEUT-KIYEOKHANG" +
	"UL JONGSEONG TIKEUT-RIEULHANGUL JONGSEONG RIEUL-KIYEOK-SIOSHANGUL JONGSE" +
	"ONG RIEUL-NIEUNHANGUL JONGSEONG RIEUL-TIKEUTHANGUL JONGSEONG RIEUL-TIKEU" +
	"T-HIEUHHANGUL JONGSEONG SSANGRIEULHANGUL JONGSEONG RIEUL-MIEUM-KIYEOKHAN" +
	"GUL JONGSEONG RIEUL-MIEUM-SIOSHANGUL JONGSEONG RIEUL-PIEUP-SIOSHANGUL JO" +
	"NGSEONG RIEUL-PIEUP-HIEUHHANGUL JONGSEONG RIEUL-KAPYEOUNPIEUPHANGUL JONG" +
	"SEONG RIEUL-SSANGSIOSHANGUL JONGSEONG RIEUL-PANSIOSHANGUL JONGSEONG RIEU" +
	"L-KHIEUKHHANGUL JONGSEONG RIEUL-YEORINHIEUHHANGUL JONGSEONG MIEUM-KIYEOK" +
	"HANGUL JONGSEONG MIEUM-RIEULHANGUL JONGSEONG MIEUM-PIEUPHANGUL JONGSEONG" +
	" MIEUM-SIOSHANGUL JONGSEONG MIEUM-SSANGSIOSHANGUL JONGSEONG MIEUM-PANSIO" +
	"SHANGUL JONGSEONG MIEUM-CHIEUCHHANGUL JONGSEONG MIEUM-HIEUHHANGUL JONGSE" +
	"ONG KAPYEOUNMIEUMHANGUL JONGSEONG PIEUP-RIEULHANGUL JONGSEONG PIEUP-PHIE" +
	"UPHHANGUL JONGSEONG PIEUP-HIEUHHANGUL JONGSEONG KAPYEOUNPIEUPHANGUL JONG" +
	"SEONG SIOS-KIYEOKHANGUL JONGSEONG SIOS-TIKEUTHANGUL JONGSEONG SIOS-RIEUL" +
	"HANGUL JONGSEONG SIOS-PIEUPHANGUL JONGSEONG PANSIOSHANGUL JONGSEONG IEUN" +
	"G-KIYEOKHANGUL JONGSEONG IEUNG-SSANGKIYEOKHANGUL JONGSEONG SSANGIEUNGHAN" +
	"GUL JONGSEONG IEUNG-KHIEUKHHANGUL JONGSEONG YESIEUNGHANGUL JONGSEONG YES" +
	"IEUNG-SIOSHANGUL JONGSEONG YESIEUNG-PANSIOSHANGUL JONGSEONG PHIEUPH-PIEU" +
	"PHANGUL JONGSEONG KAPYEOUNPHIEUPHHANGUL JONGSEONG HIEUH-NIEUNHANGUL JONG" +
	"SEONG HIEUH-RIEULHANGUL JONGSEONG HIEUH-MIEUMHANGUL JONGSEONG HIEUH-PIEU" +
	"PHANGUL JONGSEONG YEORINHIEUHHANGUL JONGSEONG KIYEOK-NIEUNHANGUL JONGSEO" +
	"NG KIYEOK-PIEUPHANGUL JONGSEONG KIYEOK-CHIEUCHHANGUL JONGSEONG KIYEOK-KH" +
	"IEUKHHANGUL JONGSEONG KIYEOK-HIEUHHANGUL JONGSEONG SSANGNIEUNETHIOPIC SY" +
	"LLABLE HAETHIOPIC SYLLABLE HUETHIOPIC SYLLABLE HIETHIOPIC SYLLABLE HAAET" +
	"HIOPIC SYLLABLE HEEETHIOPIC SYLLABLE HEETHIOPIC SYLLABLE HOETHIOPIC SYLL" +
	"ABLE HOAETHIOPIC SYLLABLE LAETHIOPIC SYLLABLE LUETHIOPIC SYLLABLE LIETHI" +
	"OPIC SYLLABLE LAAETHIOPIC SYLLABLE LEEETHIOPIC SYLLABLE LEETHIOPIC SYLLA" +
	"BLE LOETHIOPIC SYLLABLE LWAETHIOPIC SYLLABLE HHAETHIOPIC SYLLABLE HHUETH" +
	"IOPIC SYLLABLE HHIETHIOPIC SYLLABLE HHAAETHIOPIC SYLLABLE HHEEETHIOPIC S" +
	"YLLABLE HHEETHIOPIC SYLLABLE HHOETHIOPIC SYLLABLE HHWAETHIOPIC SYLLABLE " +
	"MAETHIOPIC SYLLABLE MUETHIOPIC SYLLABLE MIETHIOPIC SYLLABLE MAAETHIOPIC " +
	"SYLLABLE MEEETHIOPIC SYLLABLE MEETHIOPIC SYLLABLE MOETHIOPIC SYLLABLE MW" +
	"AETHIOPIC SYLLABLE SZAETHIOPIC SYLLABLE SZUETHIOPIC SYLLABLE SZIETHIOPIC" +
	" SYLLABLE SZAAETHIOPIC SYLLABLE SZEEETHIOPIC SYLLABLE SZEETHIOPIC SYLLAB" +
	"LE SZOETHIOPIC SYLLABLE SZWAETHIOPIC SYLLABLE RAETHIOPIC SYLLABLE RUETHI" +
	"OPIC SYLLABLE RIETHIOPIC SYLLABLE RAAETHIOPIC SYLLABLE REEETHIOPIC SYLLA" +
	"BLE REETHIOPIC SYLLABLE ROETHIOPIC SYLLABLE RWAETHIOPIC SYLLABLE SAETHIO" +
	"PIC SYLLABLE SUETHIOPIC SYLLABLE SIETHIOPIC SYLLABLE SAAETHIOPIC SYLLABL" +
	"E SEEETHIOPIC SYLLABLE SEETHIOPIC SYLLABLE SOETHIOPIC SYLLABLE SWAETHIOP" +
	"IC SYLLABLE SHAETHIOPIC SYLLABLE SHUETHIOPIC SYLLABLE SHIETHIOPIC SYLLAB") + ("" +
	"LE SHAAETHIOPIC SYLLABLE SHEEETHIOPIC SYLLABLE SHEETHIOPIC SYLLABLE SHOE" +
	"THIOPIC SYLLABLE SHWAETHIOPIC SYLLABLE QAETHIOPIC SYLLABLE QUETHIOPIC SY" +
	"LLABLE QIETHIOPIC SYLLABLE QAAETHIOPIC SYLLABLE QEEETHIOPIC SYLLABLE QEE" +
	"THIOPIC SYLLABLE QOETHIOPIC SYLLABLE QOAETHIOPIC SYLLABLE QWAETHIOPIC SY" +
	"LLABLE QWIETHIOPIC SYLLABLE QWAAETHIOPIC SYLLABLE QWEEETHIOPIC SYLLABLE " +
	"QWEETHIOPIC SYLLABLE QHAETHIOPIC SYLLABLE QHUETHIOPIC SYLLABLE QHIETHIOP" +
	"IC SYLLABLE QHAAETHIOPIC SYLLABLE QHEEETHIOPIC SYLLABLE QHEETHIOPIC SYLL" +
	"ABLE QHOETHIOPIC SYLLABLE QHWAETHIOPIC SYLLABLE QHWIETHIOPIC SYLLABLE QH" +
	"WAAETHIOPIC SYLLABLE QHWEEETHIOPIC SYLLABLE QHWEETHIOPIC SYLLABLE BAETHI" +
	"OPIC SYLLABLE BUETHIOPIC SYLLABLE BIETHIOPIC SYLLABLE BAAETHIOPIC SYLLAB" +
	"LE BEEETHIOPIC SYLLABLE BEETHIOPIC SYLLABLE BOETHIOPIC SYLLABLE BWAETHIO" +
	"PIC SYLLABLE VAETHIOPIC SYLLABLE VUETHIOPIC SYLLABLE VIETHIOPIC SYLLABLE" +
	" VAAETHIOPIC SYLLABLE VEEETHIOPIC SYLLABLE VEETHIOPIC SYLLABLE VOETHIOPI" +
	"C SYLLABLE VWAETHIOPIC SYLLABLE TAETHIOPIC SYLLABLE TUETHIOPIC SYLLABLE " +
	"TIETHIOPIC SYLLABLE TAAETHIOPIC SYLLABLE TEEETHIOPIC SYLLABLE TEETHIOPIC" +
	" SYLLABLE TOETHIOPIC SYLLABLE TWAETHIOPIC SYLLABLE CAETHIOPIC SYLLABLE C" +
	"UETHIOPIC SYLLABLE CIETHIOPIC SYLLABLE CAAETHIOPIC SYLLABLE CEEETHIOPIC " +
	"SYLLABLE CEETHIOPIC SYLLABLE COETHIOPIC SYLLABLE CWAETHIOPIC SYLLABLE XA" +
	"ETHIOPIC SYLLABLE XUETHIOPIC SYLLABLE XIETHIOPIC SYLLABLE XAAETHIOPIC SY" +
	"LLABLE XEEETHIOPIC SYLLABLE XEETHIOPIC SYLLABLE XOETHIOPIC SYLLABLE XOAE" +
	"THIOPIC SYLLABLE XWAETHIOPIC SYLLABLE XWIETHIOPIC SYLLABLE XWAAETHIOPIC " +
	"SYLLABLE XWEEETHIOPIC SYLLABLE XWEETHIOPIC SYLLABLE NAETHIOPIC SYLLABLE " +
	"NUETHIOPIC SYLLABLE NIETHIOPIC SYLLABLE NAAETHIOPIC SYLLABLE NEEETHIOPIC" +
	" SYLLABLE NEETHIOPIC SYLLABLE NOETHIOPIC SYLLABLE NWAETHIOPIC SYLLABLE N" +
	"YAETHIOPIC SYLLABLE NYUETHIOPIC SYLLABLE NYIETHIOPIC SYLLABLE NYAAETHIOP" +
	"IC SYLLABLE NYEEETHIOPIC SYLLABLE NYEETHIOPIC SYLLABLE NYOETHIOPIC SYLLA" +
	"BLE NYWAETHIOPIC SYLLABLE GLOTTAL AETHIOPIC SYLLABLE GLOTTAL UETHIOPIC S" +
	"YLLABLE GLOTTAL IETHIOPIC SYLLABLE GLOTTAL AAETHIOPIC SYLLABLE GLOTTAL E" +
	"EETHIOPIC SYLLABLE GLOTTAL EETHIOPIC SYLLABLE GLOTTAL OETHIOPIC SYLLABLE" +
	" GLOTTAL WAETHIOPIC SYLLABLE KAETHIOPIC SYLLABLE KUETHIOPIC SYLLABLE KIE" +
	"THIOPIC SYLLABLE KAAETHIOPIC SYLLABLE KEEETHIOPIC SYLLABLE KEETHIOPIC SY" +
	"LLABLE KOETHIOPIC SYLLABLE KOAETHIOPIC SYLLABLE KWAETHIOPIC SYLLABLE KWI" +
	"ETHIOPIC SYLLABLE KWAAETHIOPIC SYLLABLE KWEEETHIOPIC SYLLABLE KWEETHIOPI" +
	"C SYLLABLE KXAETHIOPIC SYLLABLE KXUETHIOPIC SYLLABLE KXIETHIOPIC SYLLABL" +
	"E KXAAETHIOPIC SYLLABLE KXEEETHIOPIC SYLLABLE KXEETHIOPIC SYLLABLE KXOET" +
	"HIOPIC SYLLABLE KXWAETHIOPIC SYLLABLE KXWIETHIOPIC SYLLABLE KXWAAETHIOPI" +
	"C SYLLABLE KXWEEETHIOPIC SYLLABLE KXWEETHIOPIC SYLLABLE WAETHIOPIC SYLLA" +
	"BLE WUETHIOPIC SYLLABLE WIETHIOPIC SYLLABLE WAAETHIOPIC SYLLABLE WEEETHI" +
	"OPIC SYLLABLE WEETHIOPIC SYLLABLE WOETHIOPIC SYLLABLE WOAETHIOPIC SYLLAB" +
	"LE PHARYNGEAL AETHIOPIC SYLLABLE PHARYNGEAL UETHIOPIC SYLLABLE PHARYNGEA" +
	"L IETHIOPIC SYLLABLE PHARYNGEAL AAETHIOPIC SYLLABLE PHARYNGEAL EEETHIOPI" +
	"C SYLLABLE PHARYNGEAL EETHIOPIC SYLLABLE PHARYNGEAL OETHIOPIC SYLLABLE Z" +
	"AETHIOPIC SYLLABLE ZUETHIOPIC SYLLABLE ZIETHIOPIC SYLLABLE ZAAETHIOPIC S" +
	"YLLABLE ZEEETHIOPIC SYLLABLE ZEETHIOPIC SYLLABLE ZOETHIOPIC SYLLABLE ZWA" +
	"ETHIOPIC SYLLABLE ZHAETHIOPIC SYLLABLE ZHUETHIOPIC SYLLABLE ZHIETHIOPIC " +
	"SYLLABLE ZHAAETHIOPIC SYLLABLE ZHEEETHIOPIC SYLLABLE ZHEETHIOPIC SYLLABL" +
	"E ZHOETHIOPIC SYLLABLE ZHWAETHIOPIC SYLLABLE YAETHIOPIC SYLLABLE YUETHIO" +
	"PIC SYLLABLE YIETHIOPIC SYLLABLE YAAETHIOPIC SYLLABLE YEEETHIOPIC SYLLAB" +
	"LE YEETHIOPIC SYLLABLE YOETHIOPIC SYLLABLE YOAETHIOPIC SYLLABLE DAETHIOP" +
	"IC SYLLABLE DUETHIOPIC SYLLABLE DIETHIOPIC SYLLABLE DAAETHIOPIC SYLLABLE" +
	" DEEETHIOPIC SYLLABLE DEETHIOPIC SYLLABLE DOETHIOPIC SYLLABLE DWAETHIOPI" +
	"C SYLLABLE DDAETHIOPIC SYLLABLE DDUETHIOPIC SYLLABLE DDIETHIOPIC SYLLABL" +
	"E DDAAETHIOPIC SYLLABLE DDEEETHIOPIC SYLLABLE DDEETHIOPIC SYLLABLE DDOET" +
	"HIOPIC SYLLABLE DDWAETHIOPIC SYLLABLE JAETHIOPIC SYLLABLE JUETHIOPIC SYL" +
	"LABLE JIETHIOPIC SYLLABLE JAAETHIOPIC SYLLABLE JEEETHIOPIC SYLLABLE JEET" +
	"HIOPIC SYLLABLE JOETHIOPIC SYLLABLE JWAETHIOPIC SYLLABLE GAETHIOPIC SYLL" +
	"ABLE GUETHIOPIC SYLLABLE GIETHIOPIC SYLLABLE GAAETHIOPIC SYLLABLE GEEETH" +
	"IOPIC SYLLABLE GEETHIOPIC SYLLABLE GOETHIOPIC SYLLABLE GOAETHIOPIC SYLLA" +
	"BLE GWAETHIOPIC SYLLABLE GWIETHIOPIC SYLLABLE GWAAETHIOPIC SYLLABLE GWEE" +
	"ETHIOPIC SYLLABLE GWEETHIOPIC SYLLABLE GGAETHIOPIC SYLLABLE GGUETHIOPIC " +
	"SYLLABLE GGIETHIOPIC SYLLABLE GGAAETHIOPIC SYLLABLE GGEEETHIOPIC SYLLABL" +
	"E GGEETHIOPIC SYLLABLE GGOETHIOPIC SYLLABLE GGWAAETHIOPIC SYLLABLE THAET" +
	"HIOPIC SYLLABLE THUETHIOPIC SYLLABLE THIETHIOPIC SYLLABLE THAAETHIOPIC S" +
	"YLLABLE THEEETHIOPIC SYLLABLE THEETHIOPIC SYLLABLE THOETHIOPIC SYLLABLE ") + ("" +
	"THWAETHIOPIC SYLLABLE CHAETHIOPIC SYLLABLE CHUETHIOPIC SYLLABLE CHIETHIO" +
	"PIC SYLLABLE CHAAETHIOPIC SYLLABLE CHEEETHIOPIC SYLLABLE CHEETHIOPIC SYL" +
	"LABLE CHOETHIOPIC SYLLABLE CHWAETHIOPIC SYLLABLE PHAETHIOPIC SYLLABLE PH" +
	"UETHIOPIC SYLLABLE PHIETHIOPIC SYLLABLE PHAAETHIOPIC SYLLABLE PHEEETHIOP" +
	"IC SYLLABLE PHEETHIOPIC SYLLABLE PHOETHIOPIC SYLLABLE PHWAETHIOPIC SYLLA" +
	"BLE TSAETHIOPIC SYLLABLE TSUETHIOPIC SYLLABLE TSIETHIOPIC SYLLABLE TSAAE" +
	"THIOPIC SYLLABLE TSEEETHIOPIC SYLLABLE TSEETHIOPIC SYLLABLE TSOETHIOPIC " +
	"SYLLABLE TSWAETHIOPIC SYLLABLE TZAETHIOPIC SYLLABLE TZUETHIOPIC SYLLABLE" +
	" TZIETHIOPIC SYLLABLE TZAAETHIOPIC SYLLABLE TZEEETHIOPIC SYLLABLE TZEETH" +
	"IOPIC SYLLABLE TZOETHIOPIC SYLLABLE TZOAETHIOPIC SYLLABLE FAETHIOPIC SYL" +
	"LABLE FUETHIOPIC SYLLABLE FIETHIOPIC SYLLABLE FAAETHIOPIC SYLLABLE FEEET" +
	"HIOPIC SYLLABLE FEETHIOPIC SYLLABLE FOETHIOPIC SYLLABLE FWAETHIOPIC SYLL" +
	"ABLE PAETHIOPIC SYLLABLE PUETHIOPIC SYLLABLE PIETHIOPIC SYLLABLE PAAETHI" +
	"OPIC SYLLABLE PEEETHIOPIC SYLLABLE PEETHIOPIC SYLLABLE POETHIOPIC SYLLAB" +
	"LE PWAETHIOPIC SYLLABLE RYAETHIOPIC SYLLABLE MYAETHIOPIC SYLLABLE FYAETH" +
	"IOPIC COMBINING GEMINATION AND VOWEL LENGTH MARKETHIOPIC COMBINING VOWEL" +
	" LENGTH MARKETHIOPIC COMBINING GEMINATION MARKETHIOPIC SECTION MARKETHIO" +
	"PIC WORDSPACEETHIOPIC FULL STOPETHIOPIC COMMAETHIOPIC SEMICOLONETHIOPIC " +
	"COLONETHIOPIC PREFACE COLONETHIOPIC QUESTION MARKETHIOPIC PARAGRAPH SEPA" +
	"RATORETHIOPIC DIGIT ONEETHIOPIC DIGIT TWOETHIOPIC DIGIT THREEETHIOPIC DI" +
	"GIT FOURETHIOPIC DIGIT FIVEETHIOPIC DIGIT SIXETHIOPIC DIGIT SEVENETHIOPI" +
	"C DIGIT EIGHTETHIOPIC DIGIT NINEETHIOPIC NUMBER TENETHIOPIC NUMBER TWENT" +
	"YETHIOPIC NUMBER THIRTYETHIOPIC NUMBER FORTYETHIOPIC NUMBER FIFTYETHIOPI" +
	"C NUMBER SIXTYETHIOPIC NUMBER SEVENTYETHIOPIC NUMBER EIGHTYETHIOPIC NUMB" +
	"ER NINETYETHIOPIC NUMBER HUNDREDETHIOPIC NUMBER TEN THOUSANDETHIOPIC SYL" +
	"LABLE SEBATBEIT MWAETHIOPIC SYLLABLE MWIETHIOPIC SYLLABLE MWEEETHIOPIC S" +
	"YLLABLE MWEETHIOPIC SYLLABLE SEBATBEIT BWAETHIOPIC SYLLABLE BWIETHIOPIC " +
	"SYLLABLE BWEEETHIOPIC SYLLABLE BWEETHIOPIC SYLLABLE SEBATBEIT FWAETHIOPI" +
	"C SYLLABLE FWIETHIOPIC SYLLABLE FWEEETHIOPIC SYLLABLE FWEETHIOPIC SYLLAB" +
	"LE SEBATBEIT PWAETHIOPIC SYLLABLE PWIETHIOPIC SYLLABLE PWEEETHIOPIC SYLL" +
	"ABLE PWEETHIOPIC TONAL MARK YIZETETHIOPIC TONAL MARK DERETETHIOPIC TONAL" +
	" MARK RIKRIKETHIOPIC TONAL MARK SHORT RIKRIKETHIOPIC TONAL MARK DIFATETH" +
	"IOPIC TONAL MARK KENATETHIOPIC TONAL MARK CHIRETETHIOPIC TONAL MARK HIDE" +
	"TETHIOPIC TONAL MARK DERET-HIDETETHIOPIC TONAL MARK KURTCHEROKEE LETTER " +
	"ACHEROKEE LETTER ECHEROKEE LETTER ICHEROKEE LETTER OCHEROKEE LETTER UCHE" +
	"ROKEE LETTER VCHEROKEE LETTER GACHEROKEE LETTER KACHEROKEE LETTER GECHER" +
	"OKEE LETTER GICHEROKEE LETTER GOCHEROKEE LETTER GUCHEROKEE LETTER GVCHER" +
	"OKEE LETTER HACHEROKEE LETTER HECHEROKEE LETTER HICHEROKEE LETTER HOCHER" +
	"OKEE LETTER HUCHEROKEE LETTER HVCHEROKEE LETTER LACHEROKEE LETTER LECHER" +
	"OKEE LETTER LICHEROKEE LETTER LOCHEROKEE LETTER LUCHEROKEE LETTER LVCHER" +
	"OKEE LETTER MACHEROKEE LETTER MECHEROKEE LETTER MICHEROKEE LETTER MOCHER" +
	"OKEE LETTER MUCHEROKEE LETTER NACHEROKEE LETTER HNACHEROKEE LETTER NAHCH" +
	"EROKEE LETTER NECHEROKEE LETTER NICHEROKEE LETTER NOCHEROKEE LETTER NUCH" +
	"EROKEE LETTER NVCHEROKEE LETTER QUACHEROKEE LETTER QUECHEROKEE LETTER QU" +
	"ICHEROKEE LETTER QUOCHEROKEE LETTER QUUCHEROKEE LETTER QUVCHEROKEE LETTE" +
	"R SACHEROKEE LETTER SCHEROKEE LETTER SECHEROKEE LETTER SICHEROKEE LETTER" +
	" SOCHEROKEE LETTER SUCHEROKEE LETTER SVCHEROKEE LETTER DACHEROKEE LETTER" +
	" TACHEROKEE LETTER DECHEROKEE LETTER TECHEROKEE LETTER DICHEROKEE LETTER" +
	" TICHEROKEE LETTER DOCHEROKEE LETTER DUCHEROKEE LETTER DVCHEROKEE LETTER" +
	" DLACHEROKEE LETTER TLACHEROKEE LETTER TLECHEROKEE LETTER TLICHEROKEE LE" +
	"TTER TLOCHEROKEE LETTER TLUCHEROKEE LETTER TLVCHEROKEE LETTER TSACHEROKE" +
	"E LETTER TSECHEROKEE LETTER TSICHEROKEE LETTER TSOCHEROKEE LETTER TSUCHE" +
	"ROKEE LETTER TSVCHEROKEE LETTER WACHEROKEE LETTER WECHEROKEE LETTER WICH" +
	"EROKEE LETTER WOCHEROKEE LETTER WUCHEROKEE LETTER WVCHEROKEE LETTER YACH" +
	"EROKEE LETTER YECHEROKEE LETTER YICHEROKEE LETTER YOCHEROKEE LETTER YUCH" +
	"EROKEE LETTER YVCHEROKEE LETTER MVCHEROKEE SMALL LETTER YECHEROKEE SMALL" +
	" LETTER YICHEROKEE SMALL LETTER YOCHEROKEE SMALL LETTER YUCHEROKEE SMALL" +
	" LETTER YVCHEROKEE SMALL LETTER MVCANADIAN SYLLABICS HYPHENCANADIAN SYLL" +
	"ABICS ECANADIAN SYLLABICS AAICANADIAN SYLLABICS ICANADIAN SYLLABICS IICA" +
	"NADIAN SYLLABICS OCANADIAN SYLLABICS OOCANADIAN SYLLABICS Y-CREE OOCANAD" +
	"IAN SYLLABICS CARRIER EECANADIAN SYLLABICS CARRIER ICANADIAN SYLLABICS A" +
	"CANADIAN SYLLABICS AACANADIAN SYLLABICS WECANADIAN SYLLABICS WEST-CREE W" +
	"ECANADIAN SYLLABICS WICANADIAN SYLLABICS WEST-CREE WICANADIAN SYLLABICS " +
	"WIICANADIAN SYLLABICS WEST-CREE WIICANADIAN SYLLABICS WOCANADIAN SYLLABI") + ("" +
	"CS WEST-CREE WOCANADIAN SYLLABICS WOOCANADIAN SYLLABICS WEST-CREE WOOCAN" +
	"ADIAN SYLLABICS NASKAPI WOOCANADIAN SYLLABICS WACANADIAN SYLLABICS WEST-" +
	"CREE WACANADIAN SYLLABICS WAACANADIAN SYLLABICS WEST-CREE WAACANADIAN SY" +
	"LLABICS NASKAPI WAACANADIAN SYLLABICS AICANADIAN SYLLABICS Y-CREE WCANAD" +
	"IAN SYLLABICS GLOTTAL STOPCANADIAN SYLLABICS FINAL ACUTECANADIAN SYLLABI" +
	"CS FINAL GRAVECANADIAN SYLLABICS FINAL BOTTOM HALF RINGCANADIAN SYLLABIC" +
	"S FINAL TOP HALF RINGCANADIAN SYLLABICS FINAL RIGHT HALF RINGCANADIAN SY" +
	"LLABICS FINAL RINGCANADIAN SYLLABICS FINAL DOUBLE ACUTECANADIAN SYLLABIC" +
	"S FINAL DOUBLE SHORT VERTICAL STROKESCANADIAN SYLLABICS FINAL MIDDLE DOT" +
	"CANADIAN SYLLABICS FINAL SHORT HORIZONTAL STROKECANADIAN SYLLABICS FINAL" +
	" PLUSCANADIAN SYLLABICS FINAL DOWN TACKCANADIAN SYLLABICS ENCANADIAN SYL" +
	"LABICS INCANADIAN SYLLABICS ONCANADIAN SYLLABICS ANCANADIAN SYLLABICS PE" +
	"CANADIAN SYLLABICS PAAICANADIAN SYLLABICS PICANADIAN SYLLABICS PIICANADI" +
	"AN SYLLABICS POCANADIAN SYLLABICS POOCANADIAN SYLLABICS Y-CREE POOCANADI" +
	"AN SYLLABICS CARRIER HEECANADIAN SYLLABICS CARRIER HICANADIAN SYLLABICS " +
	"PACANADIAN SYLLABICS PAACANADIAN SYLLABICS PWECANADIAN SYLLABICS WEST-CR" +
	"EE PWECANADIAN SYLLABICS PWICANADIAN SYLLABICS WEST-CREE PWICANADIAN SYL" +
	"LABICS PWIICANADIAN SYLLABICS WEST-CREE PWIICANADIAN SYLLABICS PWOCANADI" +
	"AN SYLLABICS WEST-CREE PWOCANADIAN SYLLABICS PWOOCANADIAN SYLLABICS WEST" +
	"-CREE PWOOCANADIAN SYLLABICS PWACANADIAN SYLLABICS WEST-CREE PWACANADIAN" +
	" SYLLABICS PWAACANADIAN SYLLABICS WEST-CREE PWAACANADIAN SYLLABICS Y-CRE" +
	"E PWAACANADIAN SYLLABICS PCANADIAN SYLLABICS WEST-CREE PCANADIAN SYLLABI" +
	"CS CARRIER HCANADIAN SYLLABICS TECANADIAN SYLLABICS TAAICANADIAN SYLLABI" +
	"CS TICANADIAN SYLLABICS TIICANADIAN SYLLABICS TOCANADIAN SYLLABICS TOOCA" +
	"NADIAN SYLLABICS Y-CREE TOOCANADIAN SYLLABICS CARRIER DEECANADIAN SYLLAB" +
	"ICS CARRIER DICANADIAN SYLLABICS TACANADIAN SYLLABICS TAACANADIAN SYLLAB" +
	"ICS TWECANADIAN SYLLABICS WEST-CREE TWECANADIAN SYLLABICS TWICANADIAN SY" +
	"LLABICS WEST-CREE TWICANADIAN SYLLABICS TWIICANADIAN SYLLABICS WEST-CREE" +
	" TWIICANADIAN SYLLABICS TWOCANADIAN SYLLABICS WEST-CREE TWOCANADIAN SYLL" +
	"ABICS TWOOCANADIAN SYLLABICS WEST-CREE TWOOCANADIAN SYLLABICS TWACANADIA" +
	"N SYLLABICS WEST-CREE TWACANADIAN SYLLABICS TWAACANADIAN SYLLABICS WEST-" +
	"CREE TWAACANADIAN SYLLABICS NASKAPI TWAACANADIAN SYLLABICS TCANADIAN SYL" +
	"LABICS TTECANADIAN SYLLABICS TTICANADIAN SYLLABICS TTOCANADIAN SYLLABICS" +
	" TTACANADIAN SYLLABICS KECANADIAN SYLLABICS KAAICANADIAN SYLLABICS KICAN" +
	"ADIAN SYLLABICS KIICANADIAN SYLLABICS KOCANADIAN SYLLABICS KOOCANADIAN S" +
	"YLLABICS Y-CREE KOOCANADIAN SYLLABICS KACANADIAN SYLLABICS KAACANADIAN S" +
	"YLLABICS KWECANADIAN SYLLABICS WEST-CREE KWECANADIAN SYLLABICS KWICANADI" +
	"AN SYLLABICS WEST-CREE KWICANADIAN SYLLABICS KWIICANADIAN SYLLABICS WEST" +
	"-CREE KWIICANADIAN SYLLABICS KWOCANADIAN SYLLABICS WEST-CREE KWOCANADIAN" +
	" SYLLABICS KWOOCANADIAN SYLLABICS WEST-CREE KWOOCANADIAN SYLLABICS KWACA" +
	"NADIAN SYLLABICS WEST-CREE KWACANADIAN SYLLABICS KWAACANADIAN SYLLABICS " +
	"WEST-CREE KWAACANADIAN SYLLABICS NASKAPI KWAACANADIAN SYLLABICS KCANADIA" +
	"N SYLLABICS KWCANADIAN SYLLABICS SOUTH-SLAVEY KEHCANADIAN SYLLABICS SOUT" +
	"H-SLAVEY KIHCANADIAN SYLLABICS SOUTH-SLAVEY KOHCANADIAN SYLLABICS SOUTH-" +
	"SLAVEY KAHCANADIAN SYLLABICS CECANADIAN SYLLABICS CAAICANADIAN SYLLABICS" +
	" CICANADIAN SYLLABICS CIICANADIAN SYLLABICS COCANADIAN SYLLABICS COOCANA" +
	"DIAN SYLLABICS Y-CREE COOCANADIAN SYLLABICS CACANADIAN SYLLABICS CAACANA" +
	"DIAN SYLLABICS CWECANADIAN SYLLABICS WEST-CREE CWECANADIAN SYLLABICS CWI" +
	"CANADIAN SYLLABICS WEST-CREE CWICANADIAN SYLLABICS CWIICANADIAN SYLLABIC" +
	"S WEST-CREE CWIICANADIAN SYLLABICS CWOCANADIAN SYLLABICS WEST-CREE CWOCA" +
	"NADIAN SYLLABICS CWOOCANADIAN SYLLABICS WEST-CREE CWOOCANADIAN SYLLABICS" +
	" CWACANADIAN SYLLABICS WEST-CREE CWACANADIAN SYLLABICS CWAACANADIAN SYLL" +
	"ABICS WEST-CREE CWAACANADIAN SYLLABICS NASKAPI CWAACANADIAN SYLLABICS CC" +
	"ANADIAN SYLLABICS SAYISI THCANADIAN SYLLABICS MECANADIAN SYLLABICS MAAIC" +
	"ANADIAN SYLLABICS MICANADIAN SYLLABICS MIICANADIAN SYLLABICS MOCANADIAN " +
	"SYLLABICS MOOCANADIAN SYLLABICS Y-CREE MOOCANADIAN SYLLABICS MACANADIAN " +
	"SYLLABICS MAACANADIAN SYLLABICS MWECANADIAN SYLLABICS WEST-CREE MWECANAD" +
	"IAN SYLLABICS MWICANADIAN SYLLABICS WEST-CREE MWICANADIAN SYLLABICS MWII" +
	"CANADIAN SYLLABICS WEST-CREE MWIICANADIAN SYLLABICS MWOCANADIAN SYLLABIC" +
	"S WEST-CREE MWOCANADIAN SYLLABICS MWOOCANADIAN SYLLABICS WEST-CREE MWOOC" +
	"ANADIAN SYLLABICS MWACANADIAN SYLLABICS WEST-CREE MWACANADIAN SYLLABICS " +
	"MWAACANADIAN SYLLABICS WEST-CREE MWAACANADIAN SYLLABICS NASKAPI MWAACANA" +
	"DIAN SYLLABICS MCANADIAN SYLLABICS WEST-CREE MCANADIAN SYLLABICS MHCANAD" +
	"IAN SYLLABICS ATHAPASCAN MCANADIAN SYLLABICS SAYISI MCANADIAN SYLLABICS ") + ("" +
	"NECANADIAN SYLLABICS NAAICANADIAN SYLLABICS NICANADIAN SYLLABICS NIICANA" +
	"DIAN SYLLABICS NOCANADIAN SYLLABICS NOOCANADIAN SYLLABICS Y-CREE NOOCANA" +
	"DIAN SYLLABICS NACANADIAN SYLLABICS NAACANADIAN SYLLABICS NWECANADIAN SY" +
	"LLABICS WEST-CREE NWECANADIAN SYLLABICS NWACANADIAN SYLLABICS WEST-CREE " +
	"NWACANADIAN SYLLABICS NWAACANADIAN SYLLABICS WEST-CREE NWAACANADIAN SYLL" +
	"ABICS NASKAPI NWAACANADIAN SYLLABICS NCANADIAN SYLLABICS CARRIER NGCANAD" +
	"IAN SYLLABICS NHCANADIAN SYLLABICS LECANADIAN SYLLABICS LAAICANADIAN SYL" +
	"LABICS LICANADIAN SYLLABICS LIICANADIAN SYLLABICS LOCANADIAN SYLLABICS L" +
	"OOCANADIAN SYLLABICS Y-CREE LOOCANADIAN SYLLABICS LACANADIAN SYLLABICS L" +
	"AACANADIAN SYLLABICS LWECANADIAN SYLLABICS WEST-CREE LWECANADIAN SYLLABI" +
	"CS LWICANADIAN SYLLABICS WEST-CREE LWICANADIAN SYLLABICS LWIICANADIAN SY" +
	"LLABICS WEST-CREE LWIICANADIAN SYLLABICS LWOCANADIAN SYLLABICS WEST-CREE" +
	" LWOCANADIAN SYLLABICS LWOOCANADIAN SYLLABICS WEST-CREE LWOOCANADIAN SYL" +
	"LABICS LWACANADIAN SYLLABICS WEST-CREE LWACANADIAN SYLLABICS LWAACANADIA" +
	"N SYLLABICS WEST-CREE LWAACANADIAN SYLLABICS LCANADIAN SYLLABICS WEST-CR" +
	"EE LCANADIAN SYLLABICS MEDIAL LCANADIAN SYLLABICS SECANADIAN SYLLABICS S" +
	"AAICANADIAN SYLLABICS SICANADIAN SYLLABICS SIICANADIAN SYLLABICS SOCANAD" +
	"IAN SYLLABICS SOOCANADIAN SYLLABICS Y-CREE SOOCANADIAN SYLLABICS SACANAD" +
	"IAN SYLLABICS SAACANADIAN SYLLABICS SWECANADIAN SYLLABICS WEST-CREE SWEC" +
	"ANADIAN SYLLABICS SWICANADIAN SYLLABICS WEST-CREE SWICANADIAN SYLLABICS " +
	"SWIICANADIAN SYLLABICS WEST-CREE SWIICANADIAN SYLLABICS SWOCANADIAN SYLL" +
	"ABICS WEST-CREE SWOCANADIAN SYLLABICS SWOOCANADIAN SYLLABICS WEST-CREE S" +
	"WOOCANADIAN SYLLABICS SWACANADIAN SYLLABICS WEST-CREE SWACANADIAN SYLLAB" +
	"ICS SWAACANADIAN SYLLABICS WEST-CREE SWAACANADIAN SYLLABICS NASKAPI SWAA" +
	"CANADIAN SYLLABICS SCANADIAN SYLLABICS ATHAPASCAN SCANADIAN SYLLABICS SW" +
	"CANADIAN SYLLABICS BLACKFOOT SCANADIAN SYLLABICS MOOSE-CREE SKCANADIAN S" +
	"YLLABICS NASKAPI SKWCANADIAN SYLLABICS NASKAPI S-WCANADIAN SYLLABICS NAS" +
	"KAPI SPWACANADIAN SYLLABICS NASKAPI STWACANADIAN SYLLABICS NASKAPI SKWAC" +
	"ANADIAN SYLLABICS NASKAPI SCWACANADIAN SYLLABICS SHECANADIAN SYLLABICS S" +
	"HICANADIAN SYLLABICS SHIICANADIAN SYLLABICS SHOCANADIAN SYLLABICS SHOOCA" +
	"NADIAN SYLLABICS SHACANADIAN SYLLABICS SHAACANADIAN SYLLABICS SHWECANADI" +
	"AN SYLLABICS WEST-CREE SHWECANADIAN SYLLABICS SHWICANADIAN SYLLABICS WES" +
	"T-CREE SHWICANADIAN SYLLABICS SHWIICANADIAN SYLLABICS WEST-CREE SHWIICAN" +
	"ADIAN SYLLABICS SHWOCANADIAN SYLLABICS WEST-CREE SHWOCANADIAN SYLLABICS " +
	"SHWOOCANADIAN SYLLABICS WEST-CREE SHWOOCANADIAN SYLLABICS SHWACANADIAN S" +
	"YLLABICS WEST-CREE SHWACANADIAN SYLLABICS SHWAACANADIAN SYLLABICS WEST-C" +
	"REE SHWAACANADIAN SYLLABICS SHCANADIAN SYLLABICS YECANADIAN SYLLABICS YA" +
	"AICANADIAN SYLLABICS YICANADIAN SYLLABICS YIICANADIAN SYLLABICS YOCANADI" +
	"AN SYLLABICS YOOCANADIAN SYLLABICS Y-CREE YOOCANADIAN SYLLABICS YACANADI" +
	"AN SYLLABICS YAACANADIAN SYLLABICS YWECANADIAN SYLLABICS WEST-CREE YWECA" +
	"NADIAN SYLLABICS YWICANADIAN SYLLABICS WEST-CREE YWICANADIAN SYLLABICS Y" +
	"WIICANADIAN SYLLABICS WEST-CREE YWIICANADIAN SYLLABICS YWOCANADIAN SYLLA" +
	"BICS WEST-CREE YWOCANADIAN SYLLABICS YWOOCANADIAN SYLLABICS WEST-CREE YW" +
	"OOCANADIAN SYLLABICS YWACANADIAN SYLLABICS WEST-CREE YWACANADIAN SYLLABI" +
	"CS YWAACANADIAN SYLLABICS WEST-CREE YWAACANADIAN SYLLABICS NASKAPI YWAAC" +
	"ANADIAN SYLLABICS YCANADIAN SYLLABICS BIBLE-CREE YCANADIAN SYLLABICS WES" +
	"T-CREE YCANADIAN SYLLABICS SAYISI YICANADIAN SYLLABICS RECANADIAN SYLLAB" +
	"ICS R-CREE RECANADIAN SYLLABICS WEST-CREE LECANADIAN SYLLABICS RAAICANAD" +
	"IAN SYLLABICS RICANADIAN SYLLABICS RIICANADIAN SYLLABICS ROCANADIAN SYLL" +
	"ABICS ROOCANADIAN SYLLABICS WEST-CREE LOCANADIAN SYLLABICS RACANADIAN SY" +
	"LLABICS RAACANADIAN SYLLABICS WEST-CREE LACANADIAN SYLLABICS RWAACANADIA" +
	"N SYLLABICS WEST-CREE RWAACANADIAN SYLLABICS RCANADIAN SYLLABICS WEST-CR" +
	"EE RCANADIAN SYLLABICS MEDIAL RCANADIAN SYLLABICS FECANADIAN SYLLABICS F" +
	"AAICANADIAN SYLLABICS FICANADIAN SYLLABICS FIICANADIAN SYLLABICS FOCANAD" +
	"IAN SYLLABICS FOOCANADIAN SYLLABICS FACANADIAN SYLLABICS FAACANADIAN SYL" +
	"LABICS FWAACANADIAN SYLLABICS WEST-CREE FWAACANADIAN SYLLABICS FCANADIAN" +
	" SYLLABICS THECANADIAN SYLLABICS N-CREE THECANADIAN SYLLABICS THICANADIA" +
	"N SYLLABICS N-CREE THICANADIAN SYLLABICS THIICANADIAN SYLLABICS N-CREE T" +
	"HIICANADIAN SYLLABICS THOCANADIAN SYLLABICS THOOCANADIAN SYLLABICS THACA" +
	"NADIAN SYLLABICS THAACANADIAN SYLLABICS THWAACANADIAN SYLLABICS WEST-CRE" +
	"E THWAACANADIAN SYLLABICS THCANADIAN SYLLABICS TTHECANADIAN SYLLABICS TT" +
	"HICANADIAN SYLLABICS TTHOCANADIAN SYLLABICS TTHACANADIAN SYLLABICS TTHCA" +
	"NADIAN SYLLABICS TYECANADIAN SYLLABICS TYICANADIAN SYLLABICS TYOCANADIAN" +
	" SYLLABICS TYACANADIAN SYLLABICS NUNAVIK HECANADIAN SYLLABICS NUNAVIK HI") + ("" +
	"CANADIAN SYLLABICS NUNAVIK HIICANADIAN SYLLABICS NUNAVIK HOCANADIAN SYLL" +
	"ABICS NUNAVIK HOOCANADIAN SYLLABICS NUNAVIK HACANADIAN SYLLABICS NUNAVIK" +
	" HAACANADIAN SYLLABICS NUNAVIK HCANADIAN SYLLABICS NUNAVUT HCANADIAN SYL" +
	"LABICS HKCANADIAN SYLLABICS QAAICANADIAN SYLLABICS QICANADIAN SYLLABICS " +
	"QIICANADIAN SYLLABICS QOCANADIAN SYLLABICS QOOCANADIAN SYLLABICS QACANAD" +
	"IAN SYLLABICS QAACANADIAN SYLLABICS QCANADIAN SYLLABICS TLHECANADIAN SYL" +
	"LABICS TLHICANADIAN SYLLABICS TLHOCANADIAN SYLLABICS TLHACANADIAN SYLLAB" +
	"ICS WEST-CREE RECANADIAN SYLLABICS WEST-CREE RICANADIAN SYLLABICS WEST-C" +
	"REE ROCANADIAN SYLLABICS WEST-CREE RACANADIAN SYLLABICS NGAAICANADIAN SY" +
	"LLABICS NGICANADIAN SYLLABICS NGIICANADIAN SYLLABICS NGOCANADIAN SYLLABI" +
	"CS NGOOCANADIAN SYLLABICS NGACANADIAN SYLLABICS NGAACANADIAN SYLLABICS N" +
	"GCANADIAN SYLLABICS NNGCANADIAN SYLLABICS SAYISI SHECANADIAN SYLLABICS S" +
	"AYISI SHICANADIAN SYLLABICS SAYISI SHOCANADIAN SYLLABICS SAYISI SHACANAD" +
	"IAN SYLLABICS WOODS-CREE THECANADIAN SYLLABICS WOODS-CREE THICANADIAN SY" +
	"LLABICS WOODS-CREE THOCANADIAN SYLLABICS WOODS-CREE THACANADIAN SYLLABIC" +
	"S WOODS-CREE THCANADIAN SYLLABICS LHICANADIAN SYLLABICS LHIICANADIAN SYL" +
	"LABICS LHOCANADIAN SYLLABICS LHOOCANADIAN SYLLABICS LHACANADIAN SYLLABIC" +
	"S LHAACANADIAN SYLLABICS LHCANADIAN SYLLABICS TH-CREE THECANADIAN SYLLAB" +
	"ICS TH-CREE THICANADIAN SYLLABICS TH-CREE THIICANADIAN SYLLABICS TH-CREE" +
	" THOCANADIAN SYLLABICS TH-CREE THOOCANADIAN SYLLABICS TH-CREE THACANADIA" +
	"N SYLLABICS TH-CREE THAACANADIAN SYLLABICS TH-CREE THCANADIAN SYLLABICS " +
	"AIVILIK BCANADIAN SYLLABICS BLACKFOOT ECANADIAN SYLLABICS BLACKFOOT ICAN" +
	"ADIAN SYLLABICS BLACKFOOT OCANADIAN SYLLABICS BLACKFOOT ACANADIAN SYLLAB" +
	"ICS BLACKFOOT WECANADIAN SYLLABICS BLACKFOOT WICANADIAN SYLLABICS BLACKF" +
	"OOT WOCANADIAN SYLLABICS BLACKFOOT WACANADIAN SYLLABICS BLACKFOOT NECANA" +
	"DIAN SYLLABICS BLACKFOOT NICANADIAN SYLLABICS BLACKFOOT NOCANADIAN SYLLA" +
	"BICS BLACKFOOT NACANADIAN SYLLABICS BLACKFOOT KECANADIAN SYLLABICS BLACK" +
	"FOOT KICANADIAN SYLLABICS BLACKFOOT KOCANADIAN SYLLABICS BLACKFOOT KACAN" +
	"ADIAN SYLLABICS SAYISI HECANADIAN SYLLABICS SAYISI HICANADIAN SYLLABICS " +
	"SAYISI HOCANADIAN SYLLABICS SAYISI HACANADIAN SYLLABICS CARRIER GHUCANAD" +
	"IAN SYLLABICS CARRIER GHOCANADIAN SYLLABICS CARRIER GHECANADIAN SYLLABIC" +
	"S CARRIER GHEECANADIAN SYLLABICS CARRIER GHICANADIAN SYLLABICS CARRIER G" +
	"HACANADIAN SYLLABICS CARRIER RUCANADIAN SYLLABICS CARRIER ROCANADIAN SYL" +
	"LABICS CARRIER RECANADIAN SYLLABICS CARRIER REECANADIAN SYLLABICS CARRIE" +
	"R RICANADIAN SYLLABICS CARRIER RACANADIAN SYLLABICS CARRIER WUCANADIAN S" +
	"YLLABICS CARRIER WOCANADIAN SYLLABICS CARRIER WECANADIAN SYLLABICS CARRI" +
	"ER WEECANADIAN SYLLABICS CARRIER WICANADIAN SYLLABICS CARRIER WACANADIAN" +
	" SYLLABICS CARRIER HWUCANADIAN SYLLABICS CARRIER HWOCANADIAN SYLLABICS C" +
	"ARRIER HWECANADIAN SYLLABICS CARRIER HWEECANADIAN SYLLABICS CARRIER HWIC" +
	"ANADIAN SYLLABICS CARRIER HWACANADIAN SYLLABICS CARRIER THUCANADIAN SYLL" +
	"ABICS CARRIER THOCANADIAN SYLLABICS CARRIER THECANADIAN SYLLABICS CARRIE" +
	"R THEECANADIAN SYLLABICS CARRIER THICANADIAN SYLLABICS CARRIER THACANADI" +
	"AN SYLLABICS CARRIER TTUCANADIAN SYLLABICS CARRIER TTOCANADIAN SYLLABICS" +
	" CARRIER TTECANADIAN SYLLABICS CARRIER TTEECANADIAN SYLLABICS CARRIER TT" +
	"ICANADIAN SYLLABICS CARRIER TTACANADIAN SYLLABICS CARRIER PUCANADIAN SYL" +
	"LABICS CARRIER POCANADIAN SYLLABICS CARRIER PECANADIAN SYLLABICS CARRIER" +
	" PEECANADIAN SYLLABICS CARRIER PICANADIAN SYLLABICS CARRIER PACANADIAN S" +
	"YLLABICS CARRIER PCANADIAN SYLLABICS CARRIER GUCANADIAN SYLLABICS CARRIE" +
	"R GOCANADIAN SYLLABICS CARRIER GECANADIAN SYLLABICS CARRIER GEECANADIAN " +
	"SYLLABICS CARRIER GICANADIAN SYLLABICS CARRIER GACANADIAN SYLLABICS CARR" +
	"IER KHUCANADIAN SYLLABICS CARRIER KHOCANADIAN SYLLABICS CARRIER KHECANAD" +
	"IAN SYLLABICS CARRIER KHEECANADIAN SYLLABICS CARRIER KHICANADIAN SYLLABI" +
	"CS CARRIER KHACANADIAN SYLLABICS CARRIER KKUCANADIAN SYLLABICS CARRIER K" +
	"KOCANADIAN SYLLABICS CARRIER KKECANADIAN SYLLABICS CARRIER KKEECANADIAN " +
	"SYLLABICS CARRIER KKICANADIAN SYLLABICS CARRIER KKACANADIAN SYLLABICS CA" +
	"RRIER KKCANADIAN SYLLABICS CARRIER NUCANADIAN SYLLABICS CARRIER NOCANADI" +
	"AN SYLLABICS CARRIER NECANADIAN SYLLABICS CARRIER NEECANADIAN SYLLABICS " +
	"CARRIER NICANADIAN SYLLABICS CARRIER NACANADIAN SYLLABICS CARRIER MUCANA" +
	"DIAN SYLLABICS CARRIER MOCANADIAN SYLLABICS CARRIER MECANADIAN SYLLABICS" +
	" CARRIER MEECANADIAN SYLLABICS CARRIER MICANADIAN SYLLABICS CARRIER MACA" +
	"NADIAN SYLLABICS CARRIER YUCANADIAN SYLLABICS CARRIER YOCANADIAN SYLLABI" +
	"CS CARRIER YECANADIAN SYLLABICS CARRIER YEECANADIAN SYLLABICS CARRIER YI" +
	"CANADIAN SYLLABICS CARRIER YACANADIAN SYLLABICS CARRIER JUCANADIAN SYLLA" +
	"BICS SAYISI JUCANADIAN SYLLABICS CARRIER JOCANADIAN SYLLABICS CARRIER JE") + ("" +
	"CANADIAN SYLLABICS CARRIER JEECANADIAN SYLLABICS CARRIER JICANADIAN SYLL" +
	"ABICS SAYISI JICANADIAN SYLLABICS CARRIER JACANADIAN SYLLABICS CARRIER J" +
	"JUCANADIAN SYLLABICS CARRIER JJOCANADIAN SYLLABICS CARRIER JJECANADIAN S" +
	"YLLABICS CARRIER JJEECANADIAN SYLLABICS CARRIER JJICANADIAN SYLLABICS CA" +
	"RRIER JJACANADIAN SYLLABICS CARRIER LUCANADIAN SYLLABICS CARRIER LOCANAD" +
	"IAN SYLLABICS CARRIER LECANADIAN SYLLABICS CARRIER LEECANADIAN SYLLABICS" +
	" CARRIER LICANADIAN SYLLABICS CARRIER LACANADIAN SYLLABICS CARRIER DLUCA" +
	"NADIAN SYLLABICS CARRIER DLOCANADIAN SYLLABICS CARRIER DLECANADIAN SYLLA" +
	"BICS CARRIER DLEECANADIAN SYLLABICS CARRIER DLICANADIAN SYLLABICS CARRIE" +
	"R DLACANADIAN SYLLABICS CARRIER LHUCANADIAN SYLLABICS CARRIER LHOCANADIA" +
	"N SYLLABICS CARRIER LHECANADIAN SYLLABICS CARRIER LHEECANADIAN SYLLABICS" +
	" CARRIER LHICANADIAN SYLLABICS CARRIER LHACANADIAN SYLLABICS CARRIER TLH" +
	"UCANADIAN SYLLABICS CARRIER TLHOCANADIAN SYLLABICS CARRIER TLHECANADIAN " +
	"SYLLABICS CARRIER TLHEECANADIAN SYLLABICS CARRIER TLHICANADIAN SYLLABICS" +
	" CARRIER TLHACANADIAN SYLLABICS CARRIER TLUCANADIAN SYLLABICS CARRIER TL" +
	"OCANADIAN SYLLABICS CARRIER TLECANADIAN SYLLABICS CARRIER TLEECANADIAN S" +
	"YLLABICS CARRIER TLICANADIAN SYLLABICS CARRIER TLACANADIAN SYLLABICS CAR" +
	"RIER ZUCANADIAN SYLLABICS CARRIER ZOCANADIAN SYLLABICS CARRIER ZECANADIA" +
	"N SYLLABICS CARRIER ZEECANADIAN SYLLABICS CARRIER ZICANADIAN SYLLABICS C" +
	"ARRIER ZACANADIAN SYLLABICS CARRIER ZCANADIAN SYLLABICS CARRIER INITIAL " +
	"ZCANADIAN SYLLABICS CARRIER DZUCANADIAN SYLLABICS CARRIER DZOCANADIAN SY" +
	"LLABICS CARRIER DZECANADIAN SYLLABICS CARRIER DZEECANADIAN SYLLABICS CAR" +
	"RIER DZICANADIAN SYLLABICS CARRIER DZACANADIAN SYLLABICS CARRIER SUCANAD" +
	"IAN SYLLABICS CARRIER SOCANADIAN SYLLABICS CARRIER SECANADIAN SYLLABICS " +
	"CARRIER SEECANADIAN SYLLABICS CARRIER SICANADIAN SYLLABICS CARRIER SACAN" +
	"ADIAN SYLLABICS CARRIER SHUCANADIAN SYLLABICS CARRIER SHOCANADIAN SYLLAB" +
	"ICS CARRIER SHECANADIAN SYLLABICS CARRIER SHEECANADIAN SYLLABICS CARRIER" +
	" SHICANADIAN SYLLABICS CARRIER SHACANADIAN SYLLABICS CARRIER SHCANADIAN " +
	"SYLLABICS CARRIER TSUCANADIAN SYLLABICS CARRIER TSOCANADIAN SYLLABICS CA" +
	"RRIER TSECANADIAN SYLLABICS CARRIER TSEECANADIAN SYLLABICS CARRIER TSICA" +
	"NADIAN SYLLABICS CARRIER TSACANADIAN SYLLABICS CARRIER CHUCANADIAN SYLLA" +
	"BICS CARRIER CHOCANADIAN SYLLABICS CARRIER CHECANADIAN SYLLABICS CARRIER" +
	" CHEECANADIAN SYLLABICS CARRIER CHICANADIAN SYLLABICS CARRIER CHACANADIA" +
	"N SYLLABICS CARRIER TTSUCANADIAN SYLLABICS CARRIER TTSOCANADIAN SYLLABIC" +
	"S CARRIER TTSECANADIAN SYLLABICS CARRIER TTSEECANADIAN SYLLABICS CARRIER" +
	" TTSICANADIAN SYLLABICS CARRIER TTSACANADIAN SYLLABICS CHI SIGNCANADIAN " +
	"SYLLABICS FULL STOPCANADIAN SYLLABICS QAICANADIAN SYLLABICS NGAICANADIAN" +
	" SYLLABICS NNGICANADIAN SYLLABICS NNGIICANADIAN SYLLABICS NNGOCANADIAN S" +
	"YLLABICS NNGOOCANADIAN SYLLABICS NNGACANADIAN SYLLABICS NNGAACANADIAN SY" +
	"LLABICS WOODS-CREE THWEECANADIAN SYLLABICS WOODS-CREE THWICANADIAN SYLLA" +
	"BICS WOODS-CREE THWIICANADIAN SYLLABICS WOODS-CREE THWOCANADIAN SYLLABIC" +
	"S WOODS-CREE THWOOCANADIAN SYLLABICS WOODS-CREE THWACANADIAN SYLLABICS W" +
	"OODS-CREE THWAACANADIAN SYLLABICS WOODS-CREE FINAL THCANADIAN SYLLABICS " +
	"BLACKFOOT WOGHAM SPACE MARKOGHAM LETTER BEITHOGHAM LETTER LUISOGHAM LETT" +
	"ER FEARNOGHAM LETTER SAILOGHAM LETTER NIONOGHAM LETTER UATHOGHAM LETTER " +
	"DAIROGHAM LETTER TINNEOGHAM LETTER COLLOGHAM LETTER CEIRTOGHAM LETTER MU" +
	"INOGHAM LETTER GORTOGHAM LETTER NGEADALOGHAM LETTER STRAIFOGHAM LETTER R" +
	"UISOGHAM LETTER AILMOGHAM LETTER ONNOGHAM LETTER UROGHAM LETTER EADHADHO" +
	"GHAM LETTER IODHADHOGHAM LETTER EABHADHOGHAM LETTER OROGHAM LETTER UILLE" +
	"ANNOGHAM LETTER IFINOGHAM LETTER EAMHANCHOLLOGHAM LETTER PEITHOGHAM FEAT" +
	"HER MARKOGHAM REVERSED FEATHER MARKRUNIC LETTER FEHU FEOH FE FRUNIC LETT" +
	"ER VRUNIC LETTER URUZ UR URUNIC LETTER YRRUNIC LETTER YRUNIC LETTER WRUN" +
	"IC LETTER THURISAZ THURS THORNRUNIC LETTER ETHRUNIC LETTER ANSUZ ARUNIC " +
	"LETTER OS ORUNIC LETTER AC ARUNIC LETTER AESCRUNIC LETTER LONG-BRANCH-OS" +
	"S ORUNIC LETTER SHORT-TWIG-OSS ORUNIC LETTER ORUNIC LETTER OERUNIC LETTE" +
	"R ONRUNIC LETTER RAIDO RAD REID RRUNIC LETTER KAUNARUNIC LETTER CENRUNIC" +
	" LETTER KAUN KRUNIC LETTER GRUNIC LETTER ENGRUNIC LETTER GEBO GYFU GRUNI" +
	"C LETTER GARRUNIC LETTER WUNJO WYNN WRUNIC LETTER HAGLAZ HRUNIC LETTER H" +
	"AEGL HRUNIC LETTER LONG-BRANCH-HAGALL HRUNIC LETTER SHORT-TWIG-HAGALL HR" +
	"UNIC LETTER NAUDIZ NYD NAUD NRUNIC LETTER SHORT-TWIG-NAUD NRUNIC LETTER " +
	"DOTTED-NRUNIC LETTER ISAZ IS ISS IRUNIC LETTER ERUNIC LETTER JERAN JRUNI" +
	"C LETTER GERRUNIC LETTER LONG-BRANCH-AR AERUNIC LETTER SHORT-TWIG-AR ARU" +
	"NIC LETTER IWAZ EOHRUNIC LETTER PERTHO PEORTH PRUNIC LETTER ALGIZ EOLHXR" +
	"UNIC LETTER SOWILO SRUNIC LETTER SIGEL LONG-BRANCH-SOL SRUNIC LETTER SHO") + ("" +
	"RT-TWIG-SOL SRUNIC LETTER CRUNIC LETTER ZRUNIC LETTER TIWAZ TIR TYR TRUN" +
	"IC LETTER SHORT-TWIG-TYR TRUNIC LETTER DRUNIC LETTER BERKANAN BEORC BJAR" +
	"KAN BRUNIC LETTER SHORT-TWIG-BJARKAN BRUNIC LETTER DOTTED-PRUNIC LETTER " +
	"OPEN-PRUNIC LETTER EHWAZ EH ERUNIC LETTER MANNAZ MAN MRUNIC LETTER LONG-" +
	"BRANCH-MADR MRUNIC LETTER SHORT-TWIG-MADR MRUNIC LETTER LAUKAZ LAGU LOGR" +
	" LRUNIC LETTER DOTTED-LRUNIC LETTER INGWAZRUNIC LETTER INGRUNIC LETTER D" +
	"AGAZ DAEG DRUNIC LETTER OTHALAN ETHEL ORUNIC LETTER EARRUNIC LETTER IORR" +
	"UNIC LETTER CWEORTHRUNIC LETTER CALCRUNIC LETTER CEALCRUNIC LETTER STANR" +
	"UNIC LETTER LONG-BRANCH-YRRUNIC LETTER SHORT-TWIG-YRRUNIC LETTER ICELAND" +
	"IC-YRRUNIC LETTER QRUNIC LETTER XRUNIC SINGLE PUNCTUATIONRUNIC MULTIPLE " +
	"PUNCTUATIONRUNIC CROSS PUNCTUATIONRUNIC ARLAUG SYMBOLRUNIC TVIMADUR SYMB" +
	"OLRUNIC BELGTHOR SYMBOLRUNIC LETTER KRUNIC LETTER SHRUNIC LETTER OORUNIC" +
	" LETTER FRANKS CASKET OSRUNIC LETTER FRANKS CASKET ISRUNIC LETTER FRANKS" +
	" CASKET EHRUNIC LETTER FRANKS CASKET ACRUNIC LETTER FRANKS CASKET AESCTA" +
	"GALOG LETTER ATAGALOG LETTER ITAGALOG LETTER UTAGALOG LETTER KATAGALOG L" +
	"ETTER GATAGALOG LETTER NGATAGALOG LETTER TATAGALOG LETTER DATAGALOG LETT" +
	"ER NATAGALOG LETTER PATAGALOG LETTER BATAGALOG LETTER MATAGALOG LETTER Y" +
	"ATAGALOG LETTER LATAGALOG LETTER WATAGALOG LETTER SATAGALOG LETTER HATAG" +
	"ALOG VOWEL SIGN ITAGALOG VOWEL SIGN UTAGALOG SIGN VIRAMAHANUNOO LETTER A" +
	"HANUNOO LETTER IHANUNOO LETTER UHANUNOO LETTER KAHANUNOO LETTER GAHANUNO" +
	"O LETTER NGAHANUNOO LETTER TAHANUNOO LETTER DAHANUNOO LETTER NAHANUNOO L" +
	"ETTER PAHANUNOO LETTER BAHANUNOO LETTER MAHANUNOO LETTER YAHANUNOO LETTE" +
	"R RAHANUNOO LETTER LAHANUNOO LETTER WAHANUNOO LETTER SAHANUNOO LETTER HA" +
	"HANUNOO VOWEL SIGN IHANUNOO VOWEL SIGN UHANUNOO SIGN PAMUDPODPHILIPPINE " +
	"SINGLE PUNCTUATIONPHILIPPINE DOUBLE PUNCTUATIONBUHID LETTER ABUHID LETTE" +
	"R IBUHID LETTER UBUHID LETTER KABUHID LETTER GABUHID LETTER NGABUHID LET" +
	"TER TABUHID LETTER DABUHID LETTER NABUHID LETTER PABUHID LETTER BABUHID " +
	"LETTER MABUHID LETTER YABUHID LETTER RABUHID LETTER LABUHID LETTER WABUH" +
	"ID LETTER SABUHID LETTER HABUHID VOWEL SIGN IBUHID VOWEL SIGN UTAGBANWA " +
	"LETTER ATAGBANWA LETTER ITAGBANWA LETTER UTAGBANWA LETTER KATAGBANWA LET" +
	"TER GATAGBANWA LETTER NGATAGBANWA LETTER TATAGBANWA LETTER DATAGBANWA LE" +
	"TTER NATAGBANWA LETTER PATAGBANWA LETTER BATAGBANWA LETTER MATAGBANWA LE" +
	"TTER YATAGBANWA LETTER LATAGBANWA LETTER WATAGBANWA LETTER SATAGBANWA VO" +
	"WEL SIGN ITAGBANWA VOWEL SIGN UKHMER LETTER KAKHMER LETTER KHAKHMER LETT" +
	"ER KOKHMER LETTER KHOKHMER LETTER NGOKHMER LETTER CAKHMER LETTER CHAKHME" +
	"R LETTER COKHMER LETTER CHOKHMER LETTER NYOKHMER LETTER DAKHMER LETTER T" +
	"THAKHMER LETTER DOKHMER LETTER TTHOKHMER LETTER NNOKHMER LETTER TAKHMER " +
	"LETTER THAKHMER LETTER TOKHMER LETTER THOKHMER LETTER NOKHMER LETTER BAK" +
	"HMER LETTER PHAKHMER LETTER POKHMER LETTER PHOKHMER LETTER MOKHMER LETTE" +
	"R YOKHMER LETTER ROKHMER LETTER LOKHMER LETTER VOKHMER LETTER SHAKHMER L" +
	"ETTER SSOKHMER LETTER SAKHMER LETTER HAKHMER LETTER LAKHMER LETTER QAKHM" +
	"ER INDEPENDENT VOWEL QAQKHMER INDEPENDENT VOWEL QAAKHMER INDEPENDENT VOW" +
	"EL QIKHMER INDEPENDENT VOWEL QIIKHMER INDEPENDENT VOWEL QUKHMER INDEPEND" +
	"ENT VOWEL QUKKHMER INDEPENDENT VOWEL QUUKHMER INDEPENDENT VOWEL QUUVKHME" +
	"R INDEPENDENT VOWEL RYKHMER INDEPENDENT VOWEL RYYKHMER INDEPENDENT VOWEL" +
	" LYKHMER INDEPENDENT VOWEL LYYKHMER INDEPENDENT VOWEL QEKHMER INDEPENDEN" +
	"T VOWEL QAIKHMER INDEPENDENT VOWEL QOO TYPE ONEKHMER INDEPENDENT VOWEL Q" +
	"OO TYPE TWOKHMER INDEPENDENT VOWEL QAUKHMER VOWEL INHERENT AQKHMER VOWEL" +
	" INHERENT AAKHMER VOWEL SIGN AAKHMER VOWEL SIGN IKHMER VOWEL SIGN IIKHME" +
	"R VOWEL SIGN YKHMER VOWEL SIGN YYKHMER VOWEL SIGN UKHMER VOWEL SIGN UUKH" +
	"MER VOWEL SIGN UAKHMER VOWEL SIGN OEKHMER VOWEL SIGN YAKHMER VOWEL SIGN " +
	"IEKHMER VOWEL SIGN EKHMER VOWEL SIGN AEKHMER VOWEL SIGN AIKHMER VOWEL SI" +
	"GN OOKHMER VOWEL SIGN AUKHMER SIGN NIKAHITKHMER SIGN REAHMUKKHMER SIGN Y" +
	"UUKALEAPINTUKHMER SIGN MUUSIKATOANKHMER SIGN TRIISAPKHMER SIGN BANTOCKHM" +
	"ER SIGN ROBATKHMER SIGN TOANDAKHIATKHMER SIGN KAKABATKHMER SIGN AHSDAKHM" +
	"ER SIGN SAMYOK SANNYAKHMER SIGN VIRIAMKHMER SIGN COENGKHMER SIGN BATHAMA" +
	"SATKHMER SIGN KHANKHMER SIGN BARIYOOSANKHMER SIGN CAMNUC PII KUUHKHMER S" +
	"IGN LEK TOOKHMER SIGN BEYYALKHMER SIGN PHNAEK MUANKHMER SIGN KOOMUUTKHME" +
	"R CURRENCY SYMBOL RIELKHMER SIGN AVAKRAHASANYAKHMER SIGN ATTHACANKHMER D" +
	"IGIT ZEROKHMER DIGIT ONEKHMER DIGIT TWOKHMER DIGIT THREEKHMER DIGIT FOUR" +
	"KHMER DIGIT FIVEKHMER DIGIT SIXKHMER DIGIT SEVENKHMER DIGIT EIGHTKHMER D" +
	"IGIT NINEKHMER SYMBOL LEK ATTAK SONKHMER SYMBOL LEK ATTAK MUOYKHMER SYMB" +
	"OL LEK ATTAK PIIKHMER SYMBOL LEK ATTAK BEIKHMER SYMBOL LEK ATTAK BUONKHM" +
	"ER SYMBOL LEK ATTAK PRAMKHMER SYMBOL LEK ATTAK PRAM-MUOYKHMER SYMBOL LEK") + ("" +
	" ATTAK PRAM-PIIKHMER SYMBOL LEK ATTAK PRAM-BEIKHMER SYMBOL LEK ATTAK PRA" +
	"M-BUONMONGOLIAN BIRGAMONGOLIAN ELLIPSISMONGOLIAN COMMAMONGOLIAN FULL STO" +
	"PMONGOLIAN COLONMONGOLIAN FOUR DOTSMONGOLIAN TODO SOFT HYPHENMONGOLIAN S" +
	"IBE SYLLABLE BOUNDARY MARKERMONGOLIAN MANCHU COMMAMONGOLIAN MANCHU FULL " +
	"STOPMONGOLIAN NIRUGUMONGOLIAN FREE VARIATION SELECTOR ONEMONGOLIAN FREE " +
	"VARIATION SELECTOR TWOMONGOLIAN FREE VARIATION SELECTOR THREEMONGOLIAN V" +
	"OWEL SEPARATORMONGOLIAN DIGIT ZEROMONGOLIAN DIGIT ONEMONGOLIAN DIGIT TWO" +
	"MONGOLIAN DIGIT THREEMONGOLIAN DIGIT FOURMONGOLIAN DIGIT FIVEMONGOLIAN D" +
	"IGIT SIXMONGOLIAN DIGIT SEVENMONGOLIAN DIGIT EIGHTMONGOLIAN DIGIT NINEMO" +
	"NGOLIAN LETTER AMONGOLIAN LETTER EMONGOLIAN LETTER IMONGOLIAN LETTER OMO" +
	"NGOLIAN LETTER UMONGOLIAN LETTER OEMONGOLIAN LETTER UEMONGOLIAN LETTER E" +
	"EMONGOLIAN LETTER NAMONGOLIAN LETTER ANGMONGOLIAN LETTER BAMONGOLIAN LET" +
	"TER PAMONGOLIAN LETTER QAMONGOLIAN LETTER GAMONGOLIAN LETTER MAMONGOLIAN" +
	" LETTER LAMONGOLIAN LETTER SAMONGOLIAN LETTER SHAMONGOLIAN LETTER TAMONG" +
	"OLIAN LETTER DAMONGOLIAN LETTER CHAMONGOLIAN LETTER JAMONGOLIAN LETTER Y" +
	"AMONGOLIAN LETTER RAMONGOLIAN LETTER WAMONGOLIAN LETTER FAMONGOLIAN LETT" +
	"ER KAMONGOLIAN LETTER KHAMONGOLIAN LETTER TSAMONGOLIAN LETTER ZAMONGOLIA" +
	"N LETTER HAAMONGOLIAN LETTER ZRAMONGOLIAN LETTER LHAMONGOLIAN LETTER ZHI" +
	"MONGOLIAN LETTER CHIMONGOLIAN LETTER TODO LONG VOWEL SIGNMONGOLIAN LETTE" +
	"R TODO EMONGOLIAN LETTER TODO IMONGOLIAN LETTER TODO OMONGOLIAN LETTER T" +
	"ODO UMONGOLIAN LETTER TODO OEMONGOLIAN LETTER TODO UEMONGOLIAN LETTER TO" +
	"DO ANGMONGOLIAN LETTER TODO BAMONGOLIAN LETTER TODO PAMONGOLIAN LETTER T" +
	"ODO QAMONGOLIAN LETTER TODO GAMONGOLIAN LETTER TODO MAMONGOLIAN LETTER T" +
	"ODO TAMONGOLIAN LETTER TODO DAMONGOLIAN LETTER TODO CHAMONGOLIAN LETTER " +
	"TODO JAMONGOLIAN LETTER TODO TSAMONGOLIAN LETTER TODO YAMONGOLIAN LETTER" +
	" TODO WAMONGOLIAN LETTER TODO KAMONGOLIAN LETTER TODO GAAMONGOLIAN LETTE" +
	"R TODO HAAMONGOLIAN LETTER TODO JIAMONGOLIAN LETTER TODO NIAMONGOLIAN LE" +
	"TTER TODO DZAMONGOLIAN LETTER SIBE EMONGOLIAN LETTER SIBE IMONGOLIAN LET" +
	"TER SIBE IYMONGOLIAN LETTER SIBE UEMONGOLIAN LETTER SIBE UMONGOLIAN LETT" +
	"ER SIBE ANGMONGOLIAN LETTER SIBE KAMONGOLIAN LETTER SIBE GAMONGOLIAN LET" +
	"TER SIBE HAMONGOLIAN LETTER SIBE PAMONGOLIAN LETTER SIBE SHAMONGOLIAN LE" +
	"TTER SIBE TAMONGOLIAN LETTER SIBE DAMONGOLIAN LETTER SIBE JAMONGOLIAN LE" +
	"TTER SIBE FAMONGOLIAN LETTER SIBE GAAMONGOLIAN LETTER SIBE HAAMONGOLIAN " +
	"LETTER SIBE TSAMONGOLIAN LETTER SIBE ZAMONGOLIAN LETTER SIBE RAAMONGOLIA" +
	"N LETTER SIBE CHAMONGOLIAN LETTER SIBE ZHAMONGOLIAN LETTER MANCHU IMONGO" +
	"LIAN LETTER MANCHU KAMONGOLIAN LETTER MANCHU RAMONGOLIAN LETTER MANCHU F" +
	"AMONGOLIAN LETTER MANCHU ZHAMONGOLIAN LETTER CHA WITH TWO DOTSMONGOLIAN " +
	"LETTER ALI GALI ANUSVARA ONEMONGOLIAN LETTER ALI GALI VISARGA ONEMONGOLI" +
	"AN LETTER ALI GALI DAMARUMONGOLIAN LETTER ALI GALI UBADAMAMONGOLIAN LETT" +
	"ER ALI GALI INVERTED UBADAMAMONGOLIAN LETTER ALI GALI BALUDAMONGOLIAN LE" +
	"TTER ALI GALI THREE BALUDAMONGOLIAN LETTER ALI GALI AMONGOLIAN LETTER AL" +
	"I GALI IMONGOLIAN LETTER ALI GALI KAMONGOLIAN LETTER ALI GALI NGAMONGOLI" +
	"AN LETTER ALI GALI CAMONGOLIAN LETTER ALI GALI TTAMONGOLIAN LETTER ALI G" +
	"ALI TTHAMONGOLIAN LETTER ALI GALI DDAMONGOLIAN LETTER ALI GALI NNAMONGOL" +
	"IAN LETTER ALI GALI TAMONGOLIAN LETTER ALI GALI DAMONGOLIAN LETTER ALI G" +
	"ALI PAMONGOLIAN LETTER ALI GALI PHAMONGOLIAN LETTER ALI GALI SSAMONGOLIA" +
	"N LETTER ALI GALI ZHAMONGOLIAN LETTER ALI GALI ZAMONGOLIAN LETTER ALI GA" +
	"LI AHMONGOLIAN LETTER TODO ALI GALI TAMONGOLIAN LETTER TODO ALI GALI ZHA" +
	"MONGOLIAN LETTER MANCHU ALI GALI GHAMONGOLIAN LETTER MANCHU ALI GALI NGA" +
	"MONGOLIAN LETTER MANCHU ALI GALI CAMONGOLIAN LETTER MANCHU ALI GALI JHAM" +
	"ONGOLIAN LETTER MANCHU ALI GALI TTAMONGOLIAN LETTER MANCHU ALI GALI DDHA" +
	"MONGOLIAN LETTER MANCHU ALI GALI TAMONGOLIAN LETTER MANCHU ALI GALI DHAM" +
	"ONGOLIAN LETTER MANCHU ALI GALI SSAMONGOLIAN LETTER MANCHU ALI GALI CYAM" +
	"ONGOLIAN LETTER MANCHU ALI GALI ZHAMONGOLIAN LETTER MANCHU ALI GALI ZAMO" +
	"NGOLIAN LETTER ALI GALI HALF UMONGOLIAN LETTER ALI GALI HALF YAMONGOLIAN" +
	" LETTER MANCHU ALI GALI BHAMONGOLIAN LETTER ALI GALI DAGALGAMONGOLIAN LE" +
	"TTER MANCHU ALI GALI LHACANADIAN SYLLABICS OYCANADIAN SYLLABICS AYCANADI" +
	"AN SYLLABICS AAYCANADIAN SYLLABICS WAYCANADIAN SYLLABICS POYCANADIAN SYL" +
	"LABICS PAYCANADIAN SYLLABICS PWOYCANADIAN SYLLABICS TAYCANADIAN SYLLABIC" +
	"S KAYCANADIAN SYLLABICS KWAYCANADIAN SYLLABICS MAYCANADIAN SYLLABICS NOY" +
	"CANADIAN SYLLABICS NAYCANADIAN SYLLABICS LAYCANADIAN SYLLABICS SOYCANADI" +
	"AN SYLLABICS SAYCANADIAN SYLLABICS SHOYCANADIAN SYLLABICS SHAYCANADIAN S" +
	"YLLABICS SHWOYCANADIAN SYLLABICS YOYCANADIAN SYLLABICS YAYCANADIAN SYLLA" +
	"BICS RAYCANADIAN SYLLABICS NWICANADIAN SYLLABICS OJIBWAY NWICANADIAN SYL") + ("" +
	"LABICS NWIICANADIAN SYLLABICS OJIBWAY NWIICANADIAN SYLLABICS NWOCANADIAN" +
	" SYLLABICS OJIBWAY NWOCANADIAN SYLLABICS NWOOCANADIAN SYLLABICS OJIBWAY " +
	"NWOOCANADIAN SYLLABICS RWEECANADIAN SYLLABICS RWICANADIAN SYLLABICS RWII" +
	"CANADIAN SYLLABICS RWOCANADIAN SYLLABICS RWOOCANADIAN SYLLABICS RWACANAD" +
	"IAN SYLLABICS OJIBWAY PCANADIAN SYLLABICS OJIBWAY TCANADIAN SYLLABICS OJ" +
	"IBWAY KCANADIAN SYLLABICS OJIBWAY CCANADIAN SYLLABICS OJIBWAY MCANADIAN " +
	"SYLLABICS OJIBWAY NCANADIAN SYLLABICS OJIBWAY SCANADIAN SYLLABICS OJIBWA" +
	"Y SHCANADIAN SYLLABICS EASTERN WCANADIAN SYLLABICS WESTERN WCANADIAN SYL" +
	"LABICS FINAL SMALL RINGCANADIAN SYLLABICS FINAL RAISED DOTCANADIAN SYLLA" +
	"BICS R-CREE RWECANADIAN SYLLABICS WEST-CREE LOOCANADIAN SYLLABICS WEST-C" +
	"REE LAACANADIAN SYLLABICS THWECANADIAN SYLLABICS THWACANADIAN SYLLABICS " +
	"TTHWECANADIAN SYLLABICS TTHOOCANADIAN SYLLABICS TTHAACANADIAN SYLLABICS " +
	"TLHWECANADIAN SYLLABICS TLHOOCANADIAN SYLLABICS SAYISI SHWECANADIAN SYLL" +
	"ABICS SAYISI SHOOCANADIAN SYLLABICS SAYISI HOOCANADIAN SYLLABICS CARRIER" +
	" GWUCANADIAN SYLLABICS CARRIER DENE GEECANADIAN SYLLABICS CARRIER GAACAN" +
	"ADIAN SYLLABICS CARRIER GWACANADIAN SYLLABICS SAYISI JUUCANADIAN SYLLABI" +
	"CS CARRIER JWACANADIAN SYLLABICS BEAVER DENE LCANADIAN SYLLABICS BEAVER " +
	"DENE RCANADIAN SYLLABICS CARRIER DENTAL SLIMBU VOWEL-CARRIER LETTERLIMBU" +
	" LETTER KALIMBU LETTER KHALIMBU LETTER GALIMBU LETTER GHALIMBU LETTER NG" +
	"ALIMBU LETTER CALIMBU LETTER CHALIMBU LETTER JALIMBU LETTER JHALIMBU LET" +
	"TER YANLIMBU LETTER TALIMBU LETTER THALIMBU LETTER DALIMBU LETTER DHALIM" +
	"BU LETTER NALIMBU LETTER PALIMBU LETTER PHALIMBU LETTER BALIMBU LETTER B" +
	"HALIMBU LETTER MALIMBU LETTER YALIMBU LETTER RALIMBU LETTER LALIMBU LETT" +
	"ER WALIMBU LETTER SHALIMBU LETTER SSALIMBU LETTER SALIMBU LETTER HALIMBU" +
	" LETTER GYANLIMBU LETTER TRALIMBU VOWEL SIGN ALIMBU VOWEL SIGN ILIMBU VO" +
	"WEL SIGN ULIMBU VOWEL SIGN EELIMBU VOWEL SIGN AILIMBU VOWEL SIGN OOLIMBU" +
	" VOWEL SIGN AULIMBU VOWEL SIGN ELIMBU VOWEL SIGN OLIMBU SUBJOINED LETTER" +
	" YALIMBU SUBJOINED LETTER RALIMBU SUBJOINED LETTER WALIMBU SMALL LETTER " +
	"KALIMBU SMALL LETTER NGALIMBU SMALL LETTER ANUSVARALIMBU SMALL LETTER TA" +
	"LIMBU SMALL LETTER NALIMBU SMALL LETTER PALIMBU SMALL LETTER MALIMBU SMA" +
	"LL LETTER RALIMBU SMALL LETTER LALIMBU SIGN MUKPHRENGLIMBU SIGN KEMPHREN" +
	"GLIMBU SIGN SA-ILIMBU SIGN LOOLIMBU EXCLAMATION MARKLIMBU QUESTION MARKL" +
	"IMBU DIGIT ZEROLIMBU DIGIT ONELIMBU DIGIT TWOLIMBU DIGIT THREELIMBU DIGI" +
	"T FOURLIMBU DIGIT FIVELIMBU DIGIT SIXLIMBU DIGIT SEVENLIMBU DIGIT EIGHTL" +
	"IMBU DIGIT NINETAI LE LETTER KATAI LE LETTER XATAI LE LETTER NGATAI LE L" +
	"ETTER TSATAI LE LETTER SATAI LE LETTER YATAI LE LETTER TATAI LE LETTER T" +
	"HATAI LE LETTER LATAI LE LETTER PATAI LE LETTER PHATAI LE LETTER MATAI L" +
	"E LETTER FATAI LE LETTER VATAI LE LETTER HATAI LE LETTER QATAI LE LETTER" +
	" KHATAI LE LETTER TSHATAI LE LETTER NATAI LE LETTER ATAI LE LETTER ITAI " +
	"LE LETTER EETAI LE LETTER EHTAI LE LETTER UTAI LE LETTER OOTAI LE LETTER" +
	" OTAI LE LETTER UETAI LE LETTER ETAI LE LETTER AUETAI LE LETTER AITAI LE" +
	" LETTER TONE-2TAI LE LETTER TONE-3TAI LE LETTER TONE-4TAI LE LETTER TONE" +
	"-5TAI LE LETTER TONE-6NEW TAI LUE LETTER HIGH QANEW TAI LUE LETTER LOW Q" +
	"ANEW TAI LUE LETTER HIGH KANEW TAI LUE LETTER HIGH XANEW TAI LUE LETTER " +
	"HIGH NGANEW TAI LUE LETTER LOW KANEW TAI LUE LETTER LOW XANEW TAI LUE LE" +
	"TTER LOW NGANEW TAI LUE LETTER HIGH TSANEW TAI LUE LETTER HIGH SANEW TAI" +
	" LUE LETTER HIGH YANEW TAI LUE LETTER LOW TSANEW TAI LUE LETTER LOW SANE" +
	"W TAI LUE LETTER LOW YANEW TAI LUE LETTER HIGH TANEW TAI LUE LETTER HIGH" +
	" THANEW TAI LUE LETTER HIGH NANEW TAI LUE LETTER LOW TANEW TAI LUE LETTE" +
	"R LOW THANEW TAI LUE LETTER LOW NANEW TAI LUE LETTER HIGH PANEW TAI LUE " +
	"LETTER HIGH PHANEW TAI LUE LETTER HIGH MANEW TAI LUE LETTER LOW PANEW TA" +
	"I LUE LETTER LOW PHANEW TAI LUE LETTER LOW MANEW TAI LUE LETTER HIGH FAN" +
	"EW TAI LUE LETTER HIGH VANEW TAI LUE LETTER HIGH LANEW TAI LUE LETTER LO" +
	"W FANEW TAI LUE LETTER LOW VANEW TAI LUE LETTER LOW LANEW TAI LUE LETTER" +
	" HIGH HANEW TAI LUE LETTER HIGH DANEW TAI LUE LETTER HIGH BANEW TAI LUE " +
	"LETTER LOW HANEW TAI LUE LETTER LOW DANEW TAI LUE LETTER LOW BANEW TAI L" +
	"UE LETTER HIGH KVANEW TAI LUE LETTER HIGH XVANEW TAI LUE LETTER LOW KVAN" +
	"EW TAI LUE LETTER LOW XVANEW TAI LUE LETTER HIGH SUANEW TAI LUE LETTER L" +
	"OW SUANEW TAI LUE VOWEL SIGN VOWEL SHORTENERNEW TAI LUE VOWEL SIGN AANEW" +
	" TAI LUE VOWEL SIGN IINEW TAI LUE VOWEL SIGN UNEW TAI LUE VOWEL SIGN UUN" +
	"EW TAI LUE VOWEL SIGN ENEW TAI LUE VOWEL SIGN AENEW TAI LUE VOWEL SIGN O" +
	"NEW TAI LUE VOWEL SIGN OANEW TAI LUE VOWEL SIGN UENEW TAI LUE VOWEL SIGN" +
	" AYNEW TAI LUE VOWEL SIGN AAYNEW TAI LUE VOWEL SIGN UYNEW TAI LUE VOWEL " +
	"SIGN OYNEW TAI LUE VOWEL SIGN OAYNEW TAI LUE VOWEL SIGN UEYNEW TAI LUE V") + ("" +
	"OWEL SIGN IYNEW TAI LUE LETTER FINAL VNEW TAI LUE LETTER FINAL NGNEW TAI" +
	" LUE LETTER FINAL NNEW TAI LUE LETTER FINAL MNEW TAI LUE LETTER FINAL KN" +
	"EW TAI LUE LETTER FINAL DNEW TAI LUE LETTER FINAL BNEW TAI LUE TONE MARK" +
	"-1NEW TAI LUE TONE MARK-2NEW TAI LUE DIGIT ZERONEW TAI LUE DIGIT ONENEW " +
	"TAI LUE DIGIT TWONEW TAI LUE DIGIT THREENEW TAI LUE DIGIT FOURNEW TAI LU" +
	"E DIGIT FIVENEW TAI LUE DIGIT SIXNEW TAI LUE DIGIT SEVENNEW TAI LUE DIGI" +
	"T EIGHTNEW TAI LUE DIGIT NINENEW TAI LUE THAM DIGIT ONENEW TAI LUE SIGN " +
	"LAENEW TAI LUE SIGN LAEVKHMER SYMBOL PATHAMASATKHMER SYMBOL MUOY KOETKHM" +
	"ER SYMBOL PII KOETKHMER SYMBOL BEI KOETKHMER SYMBOL BUON KOETKHMER SYMBO" +
	"L PRAM KOETKHMER SYMBOL PRAM-MUOY KOETKHMER SYMBOL PRAM-PII KOETKHMER SY" +
	"MBOL PRAM-BEI KOETKHMER SYMBOL PRAM-BUON KOETKHMER SYMBOL DAP KOETKHMER " +
	"SYMBOL DAP-MUOY KOETKHMER SYMBOL DAP-PII KOETKHMER SYMBOL DAP-BEI KOETKH" +
	"MER SYMBOL DAP-BUON KOETKHMER SYMBOL DAP-PRAM KOETKHMER SYMBOL TUTEYASAT" +
	"KHMER SYMBOL MUOY ROCKHMER SYMBOL PII ROCKHMER SYMBOL BEI ROCKHMER SYMBO" +
	"L BUON ROCKHMER SYMBOL PRAM ROCKHMER SYMBOL PRAM-MUOY ROCKHMER SYMBOL PR" +
	"AM-PII ROCKHMER SYMBOL PRAM-BEI ROCKHMER SYMBOL PRAM-BUON ROCKHMER SYMBO" +
	"L DAP ROCKHMER SYMBOL DAP-MUOY ROCKHMER SYMBOL DAP-PII ROCKHMER SYMBOL D" +
	"AP-BEI ROCKHMER SYMBOL DAP-BUON ROCKHMER SYMBOL DAP-PRAM ROCBUGINESE LET" +
	"TER KABUGINESE LETTER GABUGINESE LETTER NGABUGINESE LETTER NGKABUGINESE " +
	"LETTER PABUGINESE LETTER BABUGINESE LETTER MABUGINESE LETTER MPABUGINESE" +
	" LETTER TABUGINESE LETTER DABUGINESE LETTER NABUGINESE LETTER NRABUGINES" +
	"E LETTER CABUGINESE LETTER JABUGINESE LETTER NYABUGINESE LETTER NYCABUGI" +
	"NESE LETTER YABUGINESE LETTER RABUGINESE LETTER LABUGINESE LETTER VABUGI" +
	"NESE LETTER SABUGINESE LETTER ABUGINESE LETTER HABUGINESE VOWEL SIGN IBU" +
	"GINESE VOWEL SIGN UBUGINESE VOWEL SIGN EBUGINESE VOWEL SIGN OBUGINESE VO" +
	"WEL SIGN AEBUGINESE PALLAWABUGINESE END OF SECTIONTAI THAM LETTER HIGH K" +
	"ATAI THAM LETTER HIGH KHATAI THAM LETTER HIGH KXATAI THAM LETTER LOW KAT" +
	"AI THAM LETTER LOW KXATAI THAM LETTER LOW KHATAI THAM LETTER NGATAI THAM" +
	" LETTER HIGH CATAI THAM LETTER HIGH CHATAI THAM LETTER LOW CATAI THAM LE" +
	"TTER LOW SATAI THAM LETTER LOW CHATAI THAM LETTER NYATAI THAM LETTER RAT" +
	"ATAI THAM LETTER HIGH RATHATAI THAM LETTER DATAI THAM LETTER LOW RATHATA" +
	"I THAM LETTER RANATAI THAM LETTER HIGH TATAI THAM LETTER HIGH THATAI THA" +
	"M LETTER LOW TATAI THAM LETTER LOW THATAI THAM LETTER NATAI THAM LETTER " +
	"BATAI THAM LETTER HIGH PATAI THAM LETTER HIGH PHATAI THAM LETTER HIGH FA" +
	"TAI THAM LETTER LOW PATAI THAM LETTER LOW FATAI THAM LETTER LOW PHATAI T" +
	"HAM LETTER MATAI THAM LETTER LOW YATAI THAM LETTER HIGH YATAI THAM LETTE" +
	"R RATAI THAM LETTER RUETAI THAM LETTER LATAI THAM LETTER LUETAI THAM LET" +
	"TER WATAI THAM LETTER HIGH SHATAI THAM LETTER HIGH SSATAI THAM LETTER HI" +
	"GH SATAI THAM LETTER HIGH HATAI THAM LETTER LLATAI THAM LETTER ATAI THAM" +
	" LETTER LOW HATAI THAM LETTER ITAI THAM LETTER IITAI THAM LETTER UTAI TH" +
	"AM LETTER UUTAI THAM LETTER EETAI THAM LETTER OOTAI THAM LETTER LAETAI T" +
	"HAM LETTER GREAT SATAI THAM CONSONANT SIGN MEDIAL RATAI THAM CONSONANT S" +
	"IGN MEDIAL LATAI THAM CONSONANT SIGN LA TANG LAITAI THAM SIGN MAI KANG L" +
	"AITAI THAM CONSONANT SIGN FINAL NGATAI THAM CONSONANT SIGN LOW PATAI THA" +
	"M CONSONANT SIGN HIGH RATHA OR LOW PATAI THAM CONSONANT SIGN MATAI THAM " +
	"CONSONANT SIGN BATAI THAM CONSONANT SIGN SATAI THAM SIGN SAKOTTAI THAM V" +
	"OWEL SIGN ATAI THAM VOWEL SIGN MAI SATTAI THAM VOWEL SIGN AATAI THAM VOW" +
	"EL SIGN TALL AATAI THAM VOWEL SIGN ITAI THAM VOWEL SIGN IITAI THAM VOWEL" +
	" SIGN UETAI THAM VOWEL SIGN UUETAI THAM VOWEL SIGN UTAI THAM VOWEL SIGN " +
	"UUTAI THAM VOWEL SIGN OTAI THAM VOWEL SIGN OA BELOWTAI THAM VOWEL SIGN O" +
	"YTAI THAM VOWEL SIGN ETAI THAM VOWEL SIGN AETAI THAM VOWEL SIGN OOTAI TH" +
	"AM VOWEL SIGN AITAI THAM VOWEL SIGN THAM AITAI THAM VOWEL SIGN OA ABOVET" +
	"AI THAM SIGN MAI KANGTAI THAM SIGN TONE-1TAI THAM SIGN TONE-2TAI THAM SI" +
	"GN KHUEN TONE-3TAI THAM SIGN KHUEN TONE-4TAI THAM SIGN KHUEN TONE-5TAI T" +
	"HAM SIGN RA HAAMTAI THAM SIGN MAI SAMTAI THAM SIGN KHUEN-LUE KARANTAI TH" +
	"AM COMBINING CRYPTOGRAMMIC DOTTAI THAM HORA DIGIT ZEROTAI THAM HORA DIGI" +
	"T ONETAI THAM HORA DIGIT TWOTAI THAM HORA DIGIT THREETAI THAM HORA DIGIT" +
	" FOURTAI THAM HORA DIGIT FIVETAI THAM HORA DIGIT SIXTAI THAM HORA DIGIT " +
	"SEVENTAI THAM HORA DIGIT EIGHTTAI THAM HORA DIGIT NINETAI THAM THAM DIGI" +
	"T ZEROTAI THAM THAM DIGIT ONETAI THAM THAM DIGIT TWOTAI THAM THAM DIGIT " +
	"THREETAI THAM THAM DIGIT FOURTAI THAM THAM DIGIT FIVETAI THAM THAM DIGIT" +
	" SIXTAI THAM THAM DIGIT SEVENTAI THAM THAM DIGIT EIGHTTAI THAM THAM DIGI" +
	"T NINETAI THAM SIGN WIANGTAI THAM SIGN WIANGWAAKTAI THAM SIGN SAWANTAI T" +
	"HAM SIGN KEOWTAI THAM SIGN HOYTAI THAM SIGN DOKMAITAI THAM SIGN REVERSED") + ("" +
	" ROTATED RANATAI THAM SIGN MAI YAMOKTAI THAM SIGN KAANTAI THAM SIGN KAAN" +
	"KUUTAI THAM SIGN SATKAANTAI THAM SIGN SATKAANKUUTAI THAM SIGN HANGTAI TH" +
	"AM SIGN CAANGCOMBINING DOUBLED CIRCUMFLEX ACCENTCOMBINING DIAERESIS-RING" +
	"COMBINING INFINITYCOMBINING DOWNWARDS ARROWCOMBINING TRIPLE DOTCOMBINING" +
	" X-X BELOWCOMBINING WIGGLY LINE BELOWCOMBINING OPEN MARK BELOWCOMBINING " +
	"DOUBLE OPEN MARK BELOWCOMBINING LIGHT CENTRALIZATION STROKE BELOWCOMBINI" +
	"NG STRONG CENTRALIZATION STROKE BELOWCOMBINING PARENTHESES ABOVECOMBININ" +
	"G DOUBLE PARENTHESES ABOVECOMBINING PARENTHESES BELOWCOMBINING PARENTHES" +
	"ES OVERLAYBALINESE SIGN ULU RICEMBALINESE SIGN ULU CANDRABALINESE SIGN C" +
	"ECEKBALINESE SIGN SURANGBALINESE SIGN BISAHBALINESE LETTER AKARABALINESE" +
	" LETTER AKARA TEDUNGBALINESE LETTER IKARABALINESE LETTER IKARA TEDUNGBAL" +
	"INESE LETTER UKARABALINESE LETTER UKARA TEDUNGBALINESE LETTER RA REPABAL" +
	"INESE LETTER RA REPA TEDUNGBALINESE LETTER LA LENGABALINESE LETTER LA LE" +
	"NGA TEDUNGBALINESE LETTER EKARABALINESE LETTER AIKARABALINESE LETTER OKA" +
	"RABALINESE LETTER OKARA TEDUNGBALINESE LETTER KABALINESE LETTER KA MAHAP" +
	"RANABALINESE LETTER GABALINESE LETTER GA GORABALINESE LETTER NGABALINESE" +
	" LETTER CABALINESE LETTER CA LACABALINESE LETTER JABALINESE LETTER JA JE" +
	"RABALINESE LETTER NYABALINESE LETTER TA LATIKBALINESE LETTER TA MURDA MA" +
	"HAPRANABALINESE LETTER DA MURDA ALPAPRANABALINESE LETTER DA MURDA MAHAPR" +
	"ANABALINESE LETTER NA RAMBATBALINESE LETTER TABALINESE LETTER TA TAWABAL" +
	"INESE LETTER DABALINESE LETTER DA MADUBALINESE LETTER NABALINESE LETTER " +
	"PABALINESE LETTER PA KAPALBALINESE LETTER BABALINESE LETTER BA KEMBANGBA" +
	"LINESE LETTER MABALINESE LETTER YABALINESE LETTER RABALINESE LETTER LABA" +
	"LINESE LETTER WABALINESE LETTER SA SAGABALINESE LETTER SA SAPABALINESE L" +
	"ETTER SABALINESE LETTER HABALINESE SIGN REREKANBALINESE VOWEL SIGN TEDUN" +
	"GBALINESE VOWEL SIGN ULUBALINESE VOWEL SIGN ULU SARIBALINESE VOWEL SIGN " +
	"SUKUBALINESE VOWEL SIGN SUKU ILUTBALINESE VOWEL SIGN RA REPABALINESE VOW" +
	"EL SIGN RA REPA TEDUNGBALINESE VOWEL SIGN LA LENGABALINESE VOWEL SIGN LA" +
	" LENGA TEDUNGBALINESE VOWEL SIGN TALINGBALINESE VOWEL SIGN TALING REPABA" +
	"LINESE VOWEL SIGN TALING TEDUNGBALINESE VOWEL SIGN TALING REPA TEDUNGBAL" +
	"INESE VOWEL SIGN PEPETBALINESE VOWEL SIGN PEPET TEDUNGBALINESE ADEG ADEG" +
	"BALINESE LETTER KAF SASAKBALINESE LETTER KHOT SASAKBALINESE LETTER TZIR " +
	"SASAKBALINESE LETTER EF SASAKBALINESE LETTER VE SASAKBALINESE LETTER ZAL" +
	" SASAKBALINESE LETTER ASYURA SASAKBALINESE DIGIT ZEROBALINESE DIGIT ONEB" +
	"ALINESE DIGIT TWOBALINESE DIGIT THREEBALINESE DIGIT FOURBALINESE DIGIT F" +
	"IVEBALINESE DIGIT SIXBALINESE DIGIT SEVENBALINESE DIGIT EIGHTBALINESE DI" +
	"GIT NINEBALINESE PANTIBALINESE PAMADABALINESE WINDUBALINESE CARIK PAMUNG" +
	"KAHBALINESE CARIK SIKIBALINESE CARIK PARERENBALINESE PAMENENGBALINESE MU" +
	"SICAL SYMBOL DONGBALINESE MUSICAL SYMBOL DENGBALINESE MUSICAL SYMBOL DUN" +
	"GBALINESE MUSICAL SYMBOL DANGBALINESE MUSICAL SYMBOL DANG SURANGBALINESE" +
	" MUSICAL SYMBOL DINGBALINESE MUSICAL SYMBOL DAENGBALINESE MUSICAL SYMBOL" +
	" DEUNGBALINESE MUSICAL SYMBOL DAINGBALINESE MUSICAL SYMBOL DANG GEDEBALI" +
	"NESE MUSICAL SYMBOL COMBINING TEGEHBALINESE MUSICAL SYMBOL COMBINING END" +
	"EPBALINESE MUSICAL SYMBOL COMBINING KEMPULBALINESE MUSICAL SYMBOL COMBIN" +
	"ING KEMPLIBALINESE MUSICAL SYMBOL COMBINING JEGOGANBALINESE MUSICAL SYMB" +
	"OL COMBINING KEMPUL WITH JEGOGANBALINESE MUSICAL SYMBOL COMBINING KEMPLI" +
	" WITH JEGOGANBALINESE MUSICAL SYMBOL COMBINING BENDEBALINESE MUSICAL SYM" +
	"BOL COMBINING GONGBALINESE MUSICAL SYMBOL RIGHT-HAND OPEN DUGBALINESE MU" +
	"SICAL SYMBOL RIGHT-HAND OPEN DAGBALINESE MUSICAL SYMBOL RIGHT-HAND CLOSE" +
	"D TUKBALINESE MUSICAL SYMBOL RIGHT-HAND CLOSED TAKBALINESE MUSICAL SYMBO" +
	"L LEFT-HAND OPEN PANGBALINESE MUSICAL SYMBOL LEFT-HAND OPEN PUNGBALINESE" +
	" MUSICAL SYMBOL LEFT-HAND CLOSED PLAKBALINESE MUSICAL SYMBOL LEFT-HAND C" +
	"LOSED PLUKBALINESE MUSICAL SYMBOL LEFT-HAND OPEN PINGSUNDANESE SIGN PANY" +
	"ECEKSUNDANESE SIGN PANGLAYARSUNDANESE SIGN PANGWISADSUNDANESE LETTER ASU" +
	"NDANESE LETTER ISUNDANESE LETTER USUNDANESE LETTER AESUNDANESE LETTER OS" +
	"UNDANESE LETTER ESUNDANESE LETTER EUSUNDANESE LETTER KASUNDANESE LETTER " +
	"QASUNDANESE LETTER GASUNDANESE LETTER NGASUNDANESE LETTER CASUNDANESE LE" +
	"TTER JASUNDANESE LETTER ZASUNDANESE LETTER NYASUNDANESE LETTER TASUNDANE" +
	"SE LETTER DASUNDANESE LETTER NASUNDANESE LETTER PASUNDANESE LETTER FASUN" +
	"DANESE LETTER VASUNDANESE LETTER BASUNDANESE LETTER MASUNDANESE LETTER Y" +
	"ASUNDANESE LETTER RASUNDANESE LETTER LASUNDANESE LETTER WASUNDANESE LETT" +
	"ER SASUNDANESE LETTER XASUNDANESE LETTER HASUNDANESE CONSONANT SIGN PAMI" +
	"NGKALSUNDANESE CONSONANT SIGN PANYAKRASUNDANESE CONSONANT SIGN PANYIKUSU" +
	"NDANESE VOWEL SIGN PANGHULUSUNDANESE VOWEL SIGN PANYUKUSUNDANESE VOWEL S") + ("" +
	"IGN PANAELAENGSUNDANESE VOWEL SIGN PANOLONGSUNDANESE VOWEL SIGN PAMEPETS" +
	"UNDANESE VOWEL SIGN PANEULEUNGSUNDANESE SIGN PAMAAEHSUNDANESE SIGN VIRAM" +
	"ASUNDANESE CONSONANT SIGN PASANGAN MASUNDANESE CONSONANT SIGN PASANGAN W" +
	"ASUNDANESE LETTER KHASUNDANESE LETTER SYASUNDANESE DIGIT ZEROSUNDANESE D" +
	"IGIT ONESUNDANESE DIGIT TWOSUNDANESE DIGIT THREESUNDANESE DIGIT FOURSUND" +
	"ANESE DIGIT FIVESUNDANESE DIGIT SIXSUNDANESE DIGIT SEVENSUNDANESE DIGIT " +
	"EIGHTSUNDANESE DIGIT NINESUNDANESE AVAGRAHASUNDANESE LETTER REUSUNDANESE" +
	" LETTER LEUSUNDANESE LETTER BHASUNDANESE LETTER FINAL KSUNDANESE LETTER " +
	"FINAL MBATAK LETTER ABATAK LETTER SIMALUNGUN ABATAK LETTER HABATAK LETTE" +
	"R SIMALUNGUN HABATAK LETTER MANDAILING HABATAK LETTER BABATAK LETTER KAR" +
	"O BABATAK LETTER PABATAK LETTER SIMALUNGUN PABATAK LETTER NABATAK LETTER" +
	" MANDAILING NABATAK LETTER WABATAK LETTER SIMALUNGUN WABATAK LETTER PAKP" +
	"AK WABATAK LETTER GABATAK LETTER SIMALUNGUN GABATAK LETTER JABATAK LETTE" +
	"R DABATAK LETTER RABATAK LETTER SIMALUNGUN RABATAK LETTER MABATAK LETTER" +
	" SIMALUNGUN MABATAK LETTER SOUTHERN TABATAK LETTER NORTHERN TABATAK LETT" +
	"ER SABATAK LETTER SIMALUNGUN SABATAK LETTER MANDAILING SABATAK LETTER YA" +
	"BATAK LETTER SIMALUNGUN YABATAK LETTER NGABATAK LETTER LABATAK LETTER SI" +
	"MALUNGUN LABATAK LETTER NYABATAK LETTER CABATAK LETTER NDABATAK LETTER M" +
	"BABATAK LETTER IBATAK LETTER UBATAK SIGN TOMPIBATAK VOWEL SIGN EBATAK VO" +
	"WEL SIGN PAKPAK EBATAK VOWEL SIGN EEBATAK VOWEL SIGN IBATAK VOWEL SIGN K" +
	"ARO IBATAK VOWEL SIGN OBATAK VOWEL SIGN KARO OBATAK VOWEL SIGN UBATAK VO" +
	"WEL SIGN U FOR SIMALUNGUN SABATAK CONSONANT SIGN NGBATAK CONSONANT SIGN " +
	"HBATAK PANGOLATBATAK PANONGONANBATAK SYMBOL BINDU NA METEKBATAK SYMBOL B" +
	"INDU PINARBORASBATAK SYMBOL BINDU JUDULBATAK SYMBOL BINDU PANGOLATLEPCHA" +
	" LETTER KALEPCHA LETTER KLALEPCHA LETTER KHALEPCHA LETTER GALEPCHA LETTE" +
	"R GLALEPCHA LETTER NGALEPCHA LETTER CALEPCHA LETTER CHALEPCHA LETTER JAL" +
	"EPCHA LETTER NYALEPCHA LETTER TALEPCHA LETTER THALEPCHA LETTER DALEPCHA " +
	"LETTER NALEPCHA LETTER PALEPCHA LETTER PLALEPCHA LETTER PHALEPCHA LETTER" +
	" FALEPCHA LETTER FLALEPCHA LETTER BALEPCHA LETTER BLALEPCHA LETTER MALEP" +
	"CHA LETTER MLALEPCHA LETTER TSALEPCHA LETTER TSHALEPCHA LETTER DZALEPCHA" +
	" LETTER YALEPCHA LETTER RALEPCHA LETTER LALEPCHA LETTER HALEPCHA LETTER " +
	"HLALEPCHA LETTER VALEPCHA LETTER SALEPCHA LETTER SHALEPCHA LETTER WALEPC" +
	"HA LETTER ALEPCHA SUBJOINED LETTER YALEPCHA SUBJOINED LETTER RALEPCHA VO" +
	"WEL SIGN AALEPCHA VOWEL SIGN ILEPCHA VOWEL SIGN OLEPCHA VOWEL SIGN OOLEP" +
	"CHA VOWEL SIGN ULEPCHA VOWEL SIGN UULEPCHA VOWEL SIGN ELEPCHA CONSONANT " +
	"SIGN KLEPCHA CONSONANT SIGN MLEPCHA CONSONANT SIGN LLEPCHA CONSONANT SIG" +
	"N NLEPCHA CONSONANT SIGN PLEPCHA CONSONANT SIGN RLEPCHA CONSONANT SIGN T" +
	"LEPCHA CONSONANT SIGN NYIN-DOLEPCHA CONSONANT SIGN KANGLEPCHA SIGN RANLE" +
	"PCHA SIGN NUKTALEPCHA PUNCTUATION TA-ROLLEPCHA PUNCTUATION NYET THYOOM T" +
	"A-ROLLEPCHA PUNCTUATION CER-WALEPCHA PUNCTUATION TSHOOK CER-WALEPCHA PUN" +
	"CTUATION TSHOOKLEPCHA DIGIT ZEROLEPCHA DIGIT ONELEPCHA DIGIT TWOLEPCHA D" +
	"IGIT THREELEPCHA DIGIT FOURLEPCHA DIGIT FIVELEPCHA DIGIT SIXLEPCHA DIGIT" +
	" SEVENLEPCHA DIGIT EIGHTLEPCHA DIGIT NINELEPCHA LETTER TTALEPCHA LETTER " +
	"TTHALEPCHA LETTER DDAOL CHIKI DIGIT ZEROOL CHIKI DIGIT ONEOL CHIKI DIGIT" +
	" TWOOL CHIKI DIGIT THREEOL CHIKI DIGIT FOUROL CHIKI DIGIT FIVEOL CHIKI D" +
	"IGIT SIXOL CHIKI DIGIT SEVENOL CHIKI DIGIT EIGHTOL CHIKI DIGIT NINEOL CH" +
	"IKI LETTER LAOL CHIKI LETTER ATOL CHIKI LETTER AGOL CHIKI LETTER ANGOL C" +
	"HIKI LETTER ALOL CHIKI LETTER LAAOL CHIKI LETTER AAKOL CHIKI LETTER AAJO" +
	"L CHIKI LETTER AAMOL CHIKI LETTER AAWOL CHIKI LETTER LIOL CHIKI LETTER I" +
	"SOL CHIKI LETTER IHOL CHIKI LETTER INYOL CHIKI LETTER IROL CHIKI LETTER " +
	"LUOL CHIKI LETTER UCOL CHIKI LETTER UDOL CHIKI LETTER UNNOL CHIKI LETTER" +
	" UYOL CHIKI LETTER LEOL CHIKI LETTER EPOL CHIKI LETTER EDDOL CHIKI LETTE" +
	"R ENOL CHIKI LETTER ERROL CHIKI LETTER LOOL CHIKI LETTER OTTOL CHIKI LET" +
	"TER OBOL CHIKI LETTER OVOL CHIKI LETTER OHOL CHIKI MU TTUDDAGOL CHIKI GA" +
	"AHLAA TTUDDAAGOL CHIKI MU-GAAHLAA TTUDDAAGOL CHIKI RELAAOL CHIKI PHAARKA" +
	"AOL CHIKI AHADOL CHIKI PUNCTUATION MUCAADOL CHIKI PUNCTUATION DOUBLE MUC" +
	"AADCYRILLIC SMALL LETTER ROUNDED VECYRILLIC SMALL LETTER LONG-LEGGED DEC" +
	"YRILLIC SMALL LETTER NARROW OCYRILLIC SMALL LETTER WIDE ESCYRILLIC SMALL" +
	" LETTER TALL TECYRILLIC SMALL LETTER THREE-LEGGED TECYRILLIC SMALL LETTE" +
	"R TALL HARD SIGNCYRILLIC SMALL LETTER TALL YATCYRILLIC SMALL LETTER UNBL" +
	"ENDED UKGEORGIAN MTAVRULI CAPITAL LETTER ANGEORGIAN MTAVRULI CAPITAL LET" +
	"TER BANGEORGIAN MTAVRULI CAPITAL LETTER GANGEORGIAN MTAVRULI CAPITAL LET" +
	"TER DONGEORGIAN MTAVRULI CAPITAL LETTER ENGEORGIAN MTAVRULI CAPITAL LETT" +
	"ER VINGEORGIAN MTAVRULI CAPITAL LETTER ZENGEORGIAN MTAVRULI CAPITAL LETT") + ("" +
	"ER TANGEORGIAN MTAVRULI CAPITAL LETTER INGEORGIAN MTAVRULI CAPITAL LETTE" +
	"R KANGEORGIAN MTAVRULI CAPITAL LETTER LASGEORGIAN MTAVRULI CAPITAL LETTE" +
	"R MANGEORGIAN MTAVRULI CAPITAL LETTER NARGEORGIAN MTAVRULI CAPITAL LETTE" +
	"R ONGEORGIAN MTAVRULI CAPITAL LETTER PARGEORGIAN MTAVRULI CAPITAL LETTER" +
	" ZHARGEORGIAN MTAVRULI CAPITAL LETTER RAEGEORGIAN MTAVRULI CAPITAL LETTE" +
	"R SANGEORGIAN MTAVRULI CAPITAL LETTER TARGEORGIAN MTAVRULI CAPITAL LETTE" +
	"R UNGEORGIAN MTAVRULI CAPITAL LETTER PHARGEORGIAN MTAVRULI CAPITAL LETTE" +
	"R KHARGEORGIAN MTAVRULI CAPITAL LETTER GHANGEORGIAN MTAVRULI CAPITAL LET" +
	"TER QARGEORGIAN MTAVRULI CAPITAL LETTER SHINGEORGIAN MTAVRULI CAPITAL LE" +
	"TTER CHINGEORGIAN MTAVRULI CAPITAL LETTER CANGEORGIAN MTAVRULI CAPITAL L" +
	"ETTER JILGEORGIAN MTAVRULI CAPITAL LETTER CILGEORGIAN MTAVRULI CAPITAL L" +
	"ETTER CHARGEORGIAN MTAVRULI CAPITAL LETTER XANGEORGIAN MTAVRULI CAPITAL " +
	"LETTER JHANGEORGIAN MTAVRULI CAPITAL LETTER HAEGEORGIAN MTAVRULI CAPITAL" +
	" LETTER HEGEORGIAN MTAVRULI CAPITAL LETTER HIEGEORGIAN MTAVRULI CAPITAL " +
	"LETTER WEGEORGIAN MTAVRULI CAPITAL LETTER HARGEORGIAN MTAVRULI CAPITAL L" +
	"ETTER HOEGEORGIAN MTAVRULI CAPITAL LETTER FIGEORGIAN MTAVRULI CAPITAL LE" +
	"TTER YNGEORGIAN MTAVRULI CAPITAL LETTER ELIFIGEORGIAN MTAVRULI CAPITAL L" +
	"ETTER TURNED GANGEORGIAN MTAVRULI CAPITAL LETTER AINGEORGIAN MTAVRULI CA" +
	"PITAL LETTER AENGEORGIAN MTAVRULI CAPITAL LETTER HARD SIGNGEORGIAN MTAVR" +
	"ULI CAPITAL LETTER LABIAL SIGNSUNDANESE PUNCTUATION BINDU SURYASUNDANESE" +
	" PUNCTUATION BINDU PANGLONGSUNDANESE PUNCTUATION BINDU PURNAMASUNDANESE " +
	"PUNCTUATION BINDU CAKRASUNDANESE PUNCTUATION BINDU LEU SATANGASUNDANESE " +
	"PUNCTUATION BINDU KA SATANGASUNDANESE PUNCTUATION BINDU DA SATANGASUNDAN" +
	"ESE PUNCTUATION BINDU BA SATANGAVEDIC TONE KARSHANAVEDIC TONE SHARAVEDIC" +
	" TONE PRENKHAVEDIC SIGN NIHSHVASAVEDIC SIGN YAJURVEDIC MIDLINE SVARITAVE" +
	"DIC TONE YAJURVEDIC AGGRAVATED INDEPENDENT SVARITAVEDIC TONE YAJURVEDIC " +
	"INDEPENDENT SVARITAVEDIC TONE YAJURVEDIC KATHAKA INDEPENDENT SVARITAVEDI" +
	"C TONE CANDRA BELOWVEDIC TONE YAJURVEDIC KATHAKA INDEPENDENT SVARITA SCH" +
	"ROEDERVEDIC TONE DOUBLE SVARITAVEDIC TONE TRIPLE SVARITAVEDIC TONE KATHA" +
	"KA ANUDATTAVEDIC TONE DOT BELOWVEDIC TONE TWO DOTS BELOWVEDIC TONE THREE" +
	" DOTS BELOWVEDIC TONE RIGVEDIC KASHMIRI INDEPENDENT SVARITAVEDIC TONE AT" +
	"HARVAVEDIC INDEPENDENT SVARITAVEDIC SIGN VISARGA SVARITAVEDIC SIGN VISAR" +
	"GA UDATTAVEDIC SIGN REVERSED VISARGA UDATTAVEDIC SIGN VISARGA ANUDATTAVE" +
	"DIC SIGN REVERSED VISARGA ANUDATTAVEDIC SIGN VISARGA UDATTA WITH TAILVED" +
	"IC SIGN VISARGA ANUDATTA WITH TAILVEDIC SIGN ANUSVARA ANTARGOMUKHAVEDIC " +
	"SIGN ANUSVARA BAHIRGOMUKHAVEDIC SIGN ANUSVARA VAMAGOMUKHAVEDIC SIGN ANUS" +
	"VARA VAMAGOMUKHA WITH TAILVEDIC SIGN TIRYAKVEDIC SIGN HEXIFORM LONG ANUS" +
	"VARAVEDIC SIGN LONG ANUSVARAVEDIC SIGN RTHANG LONG ANUSVARAVEDIC SIGN AN" +
	"USVARA UBHAYATO MUKHAVEDIC SIGN ARDHAVISARGAVEDIC SIGN ROTATED ARDHAVISA" +
	"RGAVEDIC TONE CANDRA ABOVEVEDIC SIGN JIHVAMULIYAVEDIC SIGN UPADHMANIYAVE" +
	"DIC SIGN ATIKRAMAVEDIC TONE RING ABOVEVEDIC TONE DOUBLE RING ABOVEVEDIC " +
	"SIGN DOUBLE ANUSVARA ANTARGOMUKHALATIN LETTER SMALL CAPITAL ALATIN LETTE" +
	"R SMALL CAPITAL AELATIN SMALL LETTER TURNED AELATIN LETTER SMALL CAPITAL" +
	" BARRED BLATIN LETTER SMALL CAPITAL CLATIN LETTER SMALL CAPITAL DLATIN L" +
	"ETTER SMALL CAPITAL ETHLATIN LETTER SMALL CAPITAL ELATIN SMALL LETTER TU" +
	"RNED OPEN ELATIN SMALL LETTER TURNED ILATIN LETTER SMALL CAPITAL JLATIN " +
	"LETTER SMALL CAPITAL KLATIN LETTER SMALL CAPITAL L WITH STROKELATIN LETT" +
	"ER SMALL CAPITAL MLATIN LETTER SMALL CAPITAL REVERSED NLATIN LETTER SMAL" +
	"L CAPITAL OLATIN LETTER SMALL CAPITAL OPEN OLATIN SMALL LETTER SIDEWAYS " +
	"OLATIN SMALL LETTER SIDEWAYS OPEN OLATIN SMALL LETTER SIDEWAYS O WITH ST" +
	"ROKELATIN SMALL LETTER TURNED OELATIN LETTER SMALL CAPITAL OULATIN SMALL" +
	" LETTER TOP HALF OLATIN SMALL LETTER BOTTOM HALF OLATIN LETTER SMALL CAP" +
	"ITAL PLATIN LETTER SMALL CAPITAL REVERSED RLATIN LETTER SMALL CAPITAL TU" +
	"RNED RLATIN LETTER SMALL CAPITAL TLATIN LETTER SMALL CAPITAL ULATIN SMAL" +
	"L LETTER SIDEWAYS ULATIN SMALL LETTER SIDEWAYS DIAERESIZED ULATIN SMALL " +
	"LETTER SIDEWAYS TURNED MLATIN LETTER SMALL CAPITAL VLATIN LETTER SMALL C" +
	"APITAL WLATIN LETTER SMALL CAPITAL ZLATIN LETTER SMALL CAPITAL EZHLATIN " +
	"LETTER VOICED LARYNGEAL SPIRANTLATIN LETTER AINGREEK LETTER SMALL CAPITA" +
	"L GAMMAGREEK LETTER SMALL CAPITAL LAMDAGREEK LETTER SMALL CAPITAL PIGREE" +
	"K LETTER SMALL CAPITAL RHOGREEK LETTER SMALL CAPITAL PSICYRILLIC LETTER " +
	"SMALL CAPITAL ELMODIFIER LETTER CAPITAL AMODIFIER LETTER CAPITAL AEMODIF" +
	"IER LETTER CAPITAL BMODIFIER LETTER CAPITAL BARRED BMODIFIER LETTER CAPI" +
	"TAL DMODIFIER LETTER CAPITAL EMODIFIER LETTER CAPITAL REVERSED EMODIFIER" +
	" LETTER CAPITAL GMODIFIER LETTER CAPITAL HMODIFIER LETTER CAPITAL IMODIF") + ("" +
	"IER LETTER CAPITAL JMODIFIER LETTER CAPITAL KMODIFIER LETTER CAPITAL LMO" +
	"DIFIER LETTER CAPITAL MMODIFIER LETTER CAPITAL NMODIFIER LETTER CAPITAL " +
	"REVERSED NMODIFIER LETTER CAPITAL OMODIFIER LETTER CAPITAL OUMODIFIER LE" +
	"TTER CAPITAL PMODIFIER LETTER CAPITAL RMODIFIER LETTER CAPITAL TMODIFIER" +
	" LETTER CAPITAL UMODIFIER LETTER CAPITAL WMODIFIER LETTER SMALL AMODIFIE" +
	"R LETTER SMALL TURNED AMODIFIER LETTER SMALL ALPHAMODIFIER LETTER SMALL " +
	"TURNED AEMODIFIER LETTER SMALL BMODIFIER LETTER SMALL DMODIFIER LETTER S" +
	"MALL EMODIFIER LETTER SMALL SCHWAMODIFIER LETTER SMALL OPEN EMODIFIER LE" +
	"TTER SMALL TURNED OPEN EMODIFIER LETTER SMALL GMODIFIER LETTER SMALL TUR" +
	"NED IMODIFIER LETTER SMALL KMODIFIER LETTER SMALL MMODIFIER LETTER SMALL" +
	" ENGMODIFIER LETTER SMALL OMODIFIER LETTER SMALL OPEN OMODIFIER LETTER S" +
	"MALL TOP HALF OMODIFIER LETTER SMALL BOTTOM HALF OMODIFIER LETTER SMALL " +
	"PMODIFIER LETTER SMALL TMODIFIER LETTER SMALL UMODIFIER LETTER SMALL SID" +
	"EWAYS UMODIFIER LETTER SMALL TURNED MMODIFIER LETTER SMALL VMODIFIER LET" +
	"TER SMALL AINMODIFIER LETTER SMALL BETAMODIFIER LETTER SMALL GREEK GAMMA" +
	"MODIFIER LETTER SMALL DELTAMODIFIER LETTER SMALL GREEK PHIMODIFIER LETTE" +
	"R SMALL CHILATIN SUBSCRIPT SMALL LETTER ILATIN SUBSCRIPT SMALL LETTER RL" +
	"ATIN SUBSCRIPT SMALL LETTER ULATIN SUBSCRIPT SMALL LETTER VGREEK SUBSCRI" +
	"PT SMALL LETTER BETAGREEK SUBSCRIPT SMALL LETTER GAMMAGREEK SUBSCRIPT SM" +
	"ALL LETTER RHOGREEK SUBSCRIPT SMALL LETTER PHIGREEK SUBSCRIPT SMALL LETT" +
	"ER CHILATIN SMALL LETTER UELATIN SMALL LETTER B WITH MIDDLE TILDELATIN S" +
	"MALL LETTER D WITH MIDDLE TILDELATIN SMALL LETTER F WITH MIDDLE TILDELAT" +
	"IN SMALL LETTER M WITH MIDDLE TILDELATIN SMALL LETTER N WITH MIDDLE TILD" +
	"ELATIN SMALL LETTER P WITH MIDDLE TILDELATIN SMALL LETTER R WITH MIDDLE " +
	"TILDELATIN SMALL LETTER R WITH FISHHOOK AND MIDDLE TILDELATIN SMALL LETT" +
	"ER S WITH MIDDLE TILDELATIN SMALL LETTER T WITH MIDDLE TILDELATIN SMALL " +
	"LETTER Z WITH MIDDLE TILDELATIN SMALL LETTER TURNED GMODIFIER LETTER CYR" +
	"ILLIC ENLATIN SMALL LETTER INSULAR GLATIN SMALL LETTER TH WITH STRIKETHR" +
	"OUGHLATIN SMALL CAPITAL LETTER I WITH STROKELATIN SMALL LETTER IOTA WITH" +
	" STROKELATIN SMALL LETTER P WITH STROKELATIN SMALL CAPITAL LETTER U WITH" +
	" STROKELATIN SMALL LETTER UPSILON WITH STROKELATIN SMALL LETTER B WITH P" +
	"ALATAL HOOKLATIN SMALL LETTER D WITH PALATAL HOOKLATIN SMALL LETTER F WI" +
	"TH PALATAL HOOKLATIN SMALL LETTER G WITH PALATAL HOOKLATIN SMALL LETTER " +
	"K WITH PALATAL HOOKLATIN SMALL LETTER L WITH PALATAL HOOKLATIN SMALL LET" +
	"TER M WITH PALATAL HOOKLATIN SMALL LETTER N WITH PALATAL HOOKLATIN SMALL" +
	" LETTER P WITH PALATAL HOOKLATIN SMALL LETTER R WITH PALATAL HOOKLATIN S" +
	"MALL LETTER S WITH PALATAL HOOKLATIN SMALL LETTER ESH WITH PALATAL HOOKL" +
	"ATIN SMALL LETTER V WITH PALATAL HOOKLATIN SMALL LETTER X WITH PALATAL H" +
	"OOKLATIN SMALL LETTER Z WITH PALATAL HOOKLATIN SMALL LETTER A WITH RETRO" +
	"FLEX HOOKLATIN SMALL LETTER ALPHA WITH RETROFLEX HOOKLATIN SMALL LETTER " +
	"D WITH HOOK AND TAILLATIN SMALL LETTER E WITH RETROFLEX HOOKLATIN SMALL " +
	"LETTER OPEN E WITH RETROFLEX HOOKLATIN SMALL LETTER REVERSED OPEN E WITH" +
	" RETROFLEX HOOKLATIN SMALL LETTER SCHWA WITH RETROFLEX HOOKLATIN SMALL L" +
	"ETTER I WITH RETROFLEX HOOKLATIN SMALL LETTER OPEN O WITH RETROFLEX HOOK" +
	"LATIN SMALL LETTER ESH WITH RETROFLEX HOOKLATIN SMALL LETTER U WITH RETR" +
	"OFLEX HOOKLATIN SMALL LETTER EZH WITH RETROFLEX HOOKMODIFIER LETTER SMAL" +
	"L TURNED ALPHAMODIFIER LETTER SMALL CMODIFIER LETTER SMALL C WITH CURLMO" +
	"DIFIER LETTER SMALL ETHMODIFIER LETTER SMALL REVERSED OPEN EMODIFIER LET" +
	"TER SMALL FMODIFIER LETTER SMALL DOTLESS J WITH STROKEMODIFIER LETTER SM" +
	"ALL SCRIPT GMODIFIER LETTER SMALL TURNED HMODIFIER LETTER SMALL I WITH S" +
	"TROKEMODIFIER LETTER SMALL IOTAMODIFIER LETTER SMALL CAPITAL IMODIFIER L" +
	"ETTER SMALL CAPITAL I WITH STROKEMODIFIER LETTER SMALL J WITH CROSSED-TA" +
	"ILMODIFIER LETTER SMALL L WITH RETROFLEX HOOKMODIFIER LETTER SMALL L WIT" +
	"H PALATAL HOOKMODIFIER LETTER SMALL CAPITAL LMODIFIER LETTER SMALL M WIT" +
	"H HOOKMODIFIER LETTER SMALL TURNED M WITH LONG LEGMODIFIER LETTER SMALL " +
	"N WITH LEFT HOOKMODIFIER LETTER SMALL N WITH RETROFLEX HOOKMODIFIER LETT" +
	"ER SMALL CAPITAL NMODIFIER LETTER SMALL BARRED OMODIFIER LETTER SMALL PH" +
	"IMODIFIER LETTER SMALL S WITH HOOKMODIFIER LETTER SMALL ESHMODIFIER LETT" +
	"ER SMALL T WITH PALATAL HOOKMODIFIER LETTER SMALL U BARMODIFIER LETTER S" +
	"MALL UPSILONMODIFIER LETTER SMALL CAPITAL UMODIFIER LETTER SMALL V WITH " +
	"HOOKMODIFIER LETTER SMALL TURNED VMODIFIER LETTER SMALL ZMODIFIER LETTER" +
	" SMALL Z WITH RETROFLEX HOOKMODIFIER LETTER SMALL Z WITH CURLMODIFIER LE" +
	"TTER SMALL EZHMODIFIER LETTER SMALL THETACOMBINING DOTTED GRAVE ACCENTCO" +
	"MBINING DOTTED ACUTE ACCENTCOMBINING SNAKE BELOWCOMBINING SUSPENSION MAR") + ("" +
	"KCOMBINING MACRON-ACUTECOMBINING GRAVE-MACRONCOMBINING MACRON-GRAVECOMBI" +
	"NING ACUTE-MACRONCOMBINING GRAVE-ACUTE-GRAVECOMBINING ACUTE-GRAVE-ACUTEC" +
	"OMBINING LATIN SMALL LETTER R BELOWCOMBINING BREVE-MACRONCOMBINING MACRO" +
	"N-BREVECOMBINING DOUBLE CIRCUMFLEX ABOVECOMBINING OGONEK ABOVECOMBINING " +
	"ZIGZAG BELOWCOMBINING IS BELOWCOMBINING UR ABOVECOMBINING US ABOVECOMBIN" +
	"ING LATIN SMALL LETTER FLATTENED OPEN A ABOVECOMBINING LATIN SMALL LETTE" +
	"R AECOMBINING LATIN SMALL LETTER AOCOMBINING LATIN SMALL LETTER AVCOMBIN" +
	"ING LATIN SMALL LETTER C CEDILLACOMBINING LATIN SMALL LETTER INSULAR DCO" +
	"MBINING LATIN SMALL LETTER ETHCOMBINING LATIN SMALL LETTER GCOMBINING LA" +
	"TIN LETTER SMALL CAPITAL GCOMBINING LATIN SMALL LETTER KCOMBINING LATIN " +
	"SMALL LETTER LCOMBINING LATIN LETTER SMALL CAPITAL LCOMBINING LATIN LETT" +
	"ER SMALL CAPITAL MCOMBINING LATIN SMALL LETTER NCOMBINING LATIN LETTER S" +
	"MALL CAPITAL NCOMBINING LATIN LETTER SMALL CAPITAL RCOMBINING LATIN SMAL" +
	"L LETTER R ROTUNDACOMBINING LATIN SMALL LETTER SCOMBINING LATIN SMALL LE" +
	"TTER LONG SCOMBINING LATIN SMALL LETTER ZCOMBINING LATIN SMALL LETTER AL" +
	"PHACOMBINING LATIN SMALL LETTER BCOMBINING LATIN SMALL LETTER BETACOMBIN" +
	"ING LATIN SMALL LETTER SCHWACOMBINING LATIN SMALL LETTER FCOMBINING LATI" +
	"N SMALL LETTER L WITH DOUBLE MIDDLE TILDECOMBINING LATIN SMALL LETTER O " +
	"WITH LIGHT CENTRALIZATION STROKECOMBINING LATIN SMALL LETTER PCOMBINING " +
	"LATIN SMALL LETTER ESHCOMBINING LATIN SMALL LETTER U WITH LIGHT CENTRALI" +
	"ZATION STROKECOMBINING LATIN SMALL LETTER WCOMBINING LATIN SMALL LETTER " +
	"A WITH DIAERESISCOMBINING LATIN SMALL LETTER O WITH DIAERESISCOMBINING L" +
	"ATIN SMALL LETTER U WITH DIAERESISCOMBINING UP TACK ABOVECOMBINING KAVYK" +
	"A ABOVE RIGHTCOMBINING KAVYKA ABOVE LEFTCOMBINING DOT ABOVE LEFTCOMBININ" +
	"G WIDE INVERTED BRIDGE BELOWCOMBINING DELETION MARKCOMBINING DOUBLE INVE" +
	"RTED BREVE BELOWCOMBINING ALMOST EQUAL TO BELOWCOMBINING LEFT ARROWHEAD " +
	"ABOVECOMBINING RIGHT ARROWHEAD AND DOWN ARROWHEAD BELOWLATIN CAPITAL LET" +
	"TER A WITH RING BELOWLATIN SMALL LETTER A WITH RING BELOWLATIN CAPITAL L" +
	"ETTER B WITH DOT ABOVELATIN SMALL LETTER B WITH DOT ABOVELATIN CAPITAL L" +
	"ETTER B WITH DOT BELOWLATIN SMALL LETTER B WITH DOT BELOWLATIN CAPITAL L" +
	"ETTER B WITH LINE BELOWLATIN SMALL LETTER B WITH LINE BELOWLATIN CAPITAL" +
	" LETTER C WITH CEDILLA AND ACUTELATIN SMALL LETTER C WITH CEDILLA AND AC" +
	"UTELATIN CAPITAL LETTER D WITH DOT ABOVELATIN SMALL LETTER D WITH DOT AB" +
	"OVELATIN CAPITAL LETTER D WITH DOT BELOWLATIN SMALL LETTER D WITH DOT BE" +
	"LOWLATIN CAPITAL LETTER D WITH LINE BELOWLATIN SMALL LETTER D WITH LINE " +
	"BELOWLATIN CAPITAL LETTER D WITH CEDILLALATIN SMALL LETTER D WITH CEDILL" +
	"ALATIN CAPITAL LETTER D WITH CIRCUMFLEX BELOWLATIN SMALL LETTER D WITH C" +
	"IRCUMFLEX BELOWLATIN CAPITAL LETTER E WITH MACRON AND GRAVELATIN SMALL L" +
	"ETTER E WITH MACRON AND GRAVELATIN CAPITAL LETTER E WITH MACRON AND ACUT" +
	"ELATIN SMALL LETTER E WITH MACRON AND ACUTELATIN CAPITAL LETTER E WITH C" +
	"IRCUMFLEX BELOWLATIN SMALL LETTER E WITH CIRCUMFLEX BELOWLATIN CAPITAL L" +
	"ETTER E WITH TILDE BELOWLATIN SMALL LETTER E WITH TILDE BELOWLATIN CAPIT" +
	"AL LETTER E WITH CEDILLA AND BREVELATIN SMALL LETTER E WITH CEDILLA AND " +
	"BREVELATIN CAPITAL LETTER F WITH DOT ABOVELATIN SMALL LETTER F WITH DOT " +
	"ABOVELATIN CAPITAL LETTER G WITH MACRONLATIN SMALL LETTER G WITH MACRONL" +
	"ATIN CAPITAL LETTER H WITH DOT ABOVELATIN SMALL LETTER H WITH DOT ABOVEL" +
	"ATIN CAPITAL LETTER H WITH DOT BELOWLATIN SMALL LETTER H WITH DOT BELOWL" +
	"ATIN CAPITAL LETTER H WITH DIAERESISLATIN SMALL LETTER H WITH DIAERESISL" +
	"ATIN CAPITAL LETTER H WITH CEDILLALATIN SMALL LETTER H WITH CEDILLALATIN" +
	" CAPITAL LETTER H WITH BREVE BELOWLATIN SMALL LETTER H WITH BREVE BELOWL" +
	"ATIN CAPITAL LETTER I WITH TILDE BELOWLATIN SMALL LETTER I WITH TILDE BE" +
	"LOWLATIN CAPITAL LETTER I WITH DIAERESIS AND ACUTELATIN SMALL LETTER I W" +
	"ITH DIAERESIS AND ACUTELATIN CAPITAL LETTER K WITH ACUTELATIN SMALL LETT" +
	"ER K WITH ACUTELATIN CAPITAL LETTER K WITH DOT BELOWLATIN SMALL LETTER K" +
	" WITH DOT BELOWLATIN CAPITAL LETTER K WITH LINE BELOWLATIN SMALL LETTER " +
	"K WITH LINE BELOWLATIN CAPITAL LETTER L WITH DOT BELOWLATIN SMALL LETTER" +
	" L WITH DOT BELOWLATIN CAPITAL LETTER L WITH DOT BELOW AND MACRONLATIN S" +
	"MALL LETTER L WITH DOT BELOW AND MACRONLATIN CAPITAL LETTER L WITH LINE " +
	"BELOWLATIN SMALL LETTER L WITH LINE BELOWLATIN CAPITAL LETTER L WITH CIR" +
	"CUMFLEX BELOWLATIN SMALL LETTER L WITH CIRCUMFLEX BELOWLATIN CAPITAL LET" +
	"TER M WITH ACUTELATIN SMALL LETTER M WITH ACUTELATIN CAPITAL LETTER M WI" +
	"TH DOT ABOVELATIN SMALL LETTER M WITH DOT ABOVELATIN CAPITAL LETTER M WI" +
	"TH DOT BELOWLATIN SMALL LETTER M WITH DOT BELOWLATIN CAPITAL LETTER N WI" +
	"TH DOT ABOVELATIN SMALL LETTER N WITH DOT ABOVELATIN CAPITAL LETTER N WI") + ("" +
	"TH DOT BELOWLATIN SMALL LETTER N WITH DOT BELOWLATIN CAPITAL LETTER N WI" +
	"TH LINE BELOWLATIN SMALL LETTER N WITH LINE BELOWLATIN CAPITAL LETTER N " +
	"WITH CIRCUMFLEX BELOWLATIN SMALL LETTER N WITH CIRCUMFLEX BELOWLATIN CAP" +
	"ITAL LETTER O WITH TILDE AND ACUTELATIN SMALL LETTER O WITH TILDE AND AC" +
	"UTELATIN CAPITAL LETTER O WITH TILDE AND DIAERESISLATIN SMALL LETTER O W" +
	"ITH TILDE AND DIAERESISLATIN CAPITAL LETTER O WITH MACRON AND GRAVELATIN" +
	" SMALL LETTER O WITH MACRON AND GRAVELATIN CAPITAL LETTER O WITH MACRON " +
	"AND ACUTELATIN SMALL LETTER O WITH MACRON AND ACUTELATIN CAPITAL LETTER " +
	"P WITH ACUTELATIN SMALL LETTER P WITH ACUTELATIN CAPITAL LETTER P WITH D" +
	"OT ABOVELATIN SMALL LETTER P WITH DOT ABOVELATIN CAPITAL LETTER R WITH D" +
	"OT ABOVELATIN SMALL LETTER R WITH DOT ABOVELATIN CAPITAL LETTER R WITH D" +
	"OT BELOWLATIN SMALL LETTER R WITH DOT BELOWLATIN CAPITAL LETTER R WITH D" +
	"OT BELOW AND MACRONLATIN SMALL LETTER R WITH DOT BELOW AND MACRONLATIN C" +
	"APITAL LETTER R WITH LINE BELOWLATIN SMALL LETTER R WITH LINE BELOWLATIN" +
	" CAPITAL LETTER S WITH DOT ABOVELATIN SMALL LETTER S WITH DOT ABOVELATIN" +
	" CAPITAL LETTER S WITH DOT BELOWLATIN SMALL LETTER S WITH DOT BELOWLATIN" +
	" CAPITAL LETTER S WITH ACUTE AND DOT ABOVELATIN SMALL LETTER S WITH ACUT" +
	"E AND DOT ABOVELATIN CAPITAL LETTER S WITH CARON AND DOT ABOVELATIN SMAL" +
	"L LETTER S WITH CARON AND DOT ABOVELATIN CAPITAL LETTER S WITH DOT BELOW" +
	" AND DOT ABOVELATIN SMALL LETTER S WITH DOT BELOW AND DOT ABOVELATIN CAP" +
	"ITAL LETTER T WITH DOT ABOVELATIN SMALL LETTER T WITH DOT ABOVELATIN CAP" +
	"ITAL LETTER T WITH DOT BELOWLATIN SMALL LETTER T WITH DOT BELOWLATIN CAP" +
	"ITAL LETTER T WITH LINE BELOWLATIN SMALL LETTER T WITH LINE BELOWLATIN C" +
	"APITAL LETTER T WITH CIRCUMFLEX BELOWLATIN SMALL LETTER T WITH CIRCUMFLE" +
	"X BELOWLATIN CAPITAL LETTER U WITH DIAERESIS BELOWLATIN SMALL LETTER U W" +
	"ITH DIAERESIS BELOWLATIN CAPITAL LETTER U WITH TILDE BELOWLATIN SMALL LE" +
	"TTER U WITH TILDE BELOWLATIN CAPITAL LETTER U WITH CIRCUMFLEX BELOWLATIN" +
	" SMALL LETTER U WITH CIRCUMFLEX BELOWLATIN CAPITAL LETTER U WITH TILDE A" +
	"ND ACUTELATIN SMALL LETTER U WITH TILDE AND ACUTELATIN CAPITAL LETTER U " +
	"WITH MACRON AND DIAERESISLATIN SMALL LETTER U WITH MACRON AND DIAERESISL" +
	"ATIN CAPITAL LETTER V WITH TILDELATIN SMALL LETTER V WITH TILDELATIN CAP" +
	"ITAL LETTER V WITH DOT BELOWLATIN SMALL LETTER V WITH DOT BELOWLATIN CAP" +
	"ITAL LETTER W WITH GRAVELATIN SMALL LETTER W WITH GRAVELATIN CAPITAL LET" +
	"TER W WITH ACUTELATIN SMALL LETTER W WITH ACUTELATIN CAPITAL LETTER W WI" +
	"TH DIAERESISLATIN SMALL LETTER W WITH DIAERESISLATIN CAPITAL LETTER W WI" +
	"TH DOT ABOVELATIN SMALL LETTER W WITH DOT ABOVELATIN CAPITAL LETTER W WI" +
	"TH DOT BELOWLATIN SMALL LETTER W WITH DOT BELOWLATIN CAPITAL LETTER X WI" +
	"TH DOT ABOVELATIN SMALL LETTER X WITH DOT ABOVELATIN CAPITAL LETTER X WI" +
	"TH DIAERESISLATIN SMALL LETTER X WITH DIAERESISLATIN CAPITAL LETTER Y WI" +
	"TH DOT ABOVELATIN SMALL LETTER Y WITH DOT ABOVELATIN CAPITAL LETTER Z WI" +
	"TH CIRCUMFLEXLATIN SMALL LETTER Z WITH CIRCUMFLEXLATIN CAPITAL LETTER Z " +
	"WITH DOT BELOWLATIN SMALL LETTER Z WITH DOT BELOWLATIN CAPITAL LETTER Z " +
	"WITH LINE BELOWLATIN SMALL LETTER Z WITH LINE BELOWLATIN SMALL LETTER H " +
	"WITH LINE BELOWLATIN SMALL LETTER T WITH DIAERESISLATIN SMALL LETTER W W" +
	"ITH RING ABOVELATIN SMALL LETTER Y WITH RING ABOVELATIN SMALL LETTER A W" +
	"ITH RIGHT HALF RINGLATIN SMALL LETTER LONG S WITH DOT ABOVELATIN SMALL L" +
	"ETTER LONG S WITH DIAGONAL STROKELATIN SMALL LETTER LONG S WITH HIGH STR" +
	"OKELATIN CAPITAL LETTER SHARP SLATIN SMALL LETTER DELTALATIN CAPITAL LET" +
	"TER A WITH DOT BELOWLATIN SMALL LETTER A WITH DOT BELOWLATIN CAPITAL LET" +
	"TER A WITH HOOK ABOVELATIN SMALL LETTER A WITH HOOK ABOVELATIN CAPITAL L" +
	"ETTER A WITH CIRCUMFLEX AND ACUTELATIN SMALL LETTER A WITH CIRCUMFLEX AN" +
	"D ACUTELATIN CAPITAL LETTER A WITH CIRCUMFLEX AND GRAVELATIN SMALL LETTE" +
	"R A WITH CIRCUMFLEX AND GRAVELATIN CAPITAL LETTER A WITH CIRCUMFLEX AND " +
	"HOOK ABOVELATIN SMALL LETTER A WITH CIRCUMFLEX AND HOOK ABOVELATIN CAPIT" +
	"AL LETTER A WITH CIRCUMFLEX AND TILDELATIN SMALL LETTER A WITH CIRCUMFLE" +
	"X AND TILDELATIN CAPITAL LETTER A WITH CIRCUMFLEX AND DOT BELOWLATIN SMA" +
	"LL LETTER A WITH CIRCUMFLEX AND DOT BELOWLATIN CAPITAL LETTER A WITH BRE" +
	"VE AND ACUTELATIN SMALL LETTER A WITH BREVE AND ACUTELATIN CAPITAL LETTE" +
	"R A WITH BREVE AND GRAVELATIN SMALL LETTER A WITH BREVE AND GRAVELATIN C" +
	"APITAL LETTER A WITH BREVE AND HOOK ABOVELATIN SMALL LETTER A WITH BREVE" +
	" AND HOOK ABOVELATIN CAPITAL LETTER A WITH BREVE AND TILDELATIN SMALL LE" +
	"TTER A WITH BREVE AND TILDELATIN CAPITAL LETTER A WITH BREVE AND DOT BEL" +
	"OWLATIN SMALL LETTER A WITH BREVE AND DOT BELOWLATIN CAPITAL LETTER E WI" +
	"TH DOT BELOWLATIN SMALL LETTER E WITH DOT BELOWLATIN CAPITAL LETTER E WI") + ("" +
	"TH HOOK ABOVELATIN SMALL LETTER E WITH HOOK ABOVELATIN CAPITAL LETTER E " +
	"WITH TILDELATIN SMALL LETTER E WITH TILDELATIN CAPITAL LETTER E WITH CIR" +
	"CUMFLEX AND ACUTELATIN SMALL LETTER E WITH CIRCUMFLEX AND ACUTELATIN CAP" +
	"ITAL LETTER E WITH CIRCUMFLEX AND GRAVELATIN SMALL LETTER E WITH CIRCUMF" +
	"LEX AND GRAVELATIN CAPITAL LETTER E WITH CIRCUMFLEX AND HOOK ABOVELATIN " +
	"SMALL LETTER E WITH CIRCUMFLEX AND HOOK ABOVELATIN CAPITAL LETTER E WITH" +
	" CIRCUMFLEX AND TILDELATIN SMALL LETTER E WITH CIRCUMFLEX AND TILDELATIN" +
	" CAPITAL LETTER E WITH CIRCUMFLEX AND DOT BELOWLATIN SMALL LETTER E WITH" +
	" CIRCUMFLEX AND DOT BELOWLATIN CAPITAL LETTER I WITH HOOK ABOVELATIN SMA" +
	"LL LETTER I WITH HOOK ABOVELATIN CAPITAL LETTER I WITH DOT BELOWLATIN SM" +
	"ALL LETTER I WITH DOT BELOWLATIN CAPITAL LETTER O WITH DOT BELOWLATIN SM" +
	"ALL LETTER O WITH DOT BELOWLATIN CAPITAL LETTER O WITH HOOK ABOVELATIN S" +
	"MALL LETTER O WITH HOOK ABOVELATIN CAPITAL LETTER O WITH CIRCUMFLEX AND " +
	"ACUTELATIN SMALL LETTER O WITH CIRCUMFLEX AND ACUTELATIN CAPITAL LETTER " +
	"O WITH CIRCUMFLEX AND GRAVELATIN SMALL LETTER O WITH CIRCUMFLEX AND GRAV" +
	"ELATIN CAPITAL LETTER O WITH CIRCUMFLEX AND HOOK ABOVELATIN SMALL LETTER" +
	" O WITH CIRCUMFLEX AND HOOK ABOVELATIN CAPITAL LETTER O WITH CIRCUMFLEX " +
	"AND TILDELATIN SMALL LETTER O WITH CIRCUMFLEX AND TILDELATIN CAPITAL LET" +
	"TER O WITH CIRCUMFLEX AND DOT BELOWLATIN SMALL LETTER O WITH CIRCUMFLEX " +
	"AND DOT BELOWLATIN CAPITAL LETTER O WITH HORN AND ACUTELATIN SMALL LETTE" +
	"R O WITH HORN AND ACUTELATIN CAPITAL LETTER O WITH HORN AND GRAVELATIN S" +
	"MALL LETTER O WITH HORN AND GRAVELATIN CAPITAL LETTER O WITH HORN AND HO" +
	"OK ABOVELATIN SMALL LETTER O WITH HORN AND HOOK ABOVELATIN CAPITAL LETTE" +
	"R O WITH HORN AND TILDELATIN SMALL LETTER O WITH HORN AND TILDELATIN CAP" +
	"ITAL LETTER O WITH HORN AND DOT BELOWLATIN SMALL LETTER O WITH HORN AND " +
	"DOT BELOWLATIN CAPITAL LETTER U WITH DOT BELOWLATIN SMALL LETTER U WITH " +
	"DOT BELOWLATIN CAPITAL LETTER U WITH HOOK ABOVELATIN SMALL LETTER U WITH" +
	" HOOK ABOVELATIN CAPITAL LETTER U WITH HORN AND ACUTELATIN SMALL LETTER " +
	"U WITH HORN AND ACUTELATIN CAPITAL LETTER U WITH HORN AND GRAVELATIN SMA" +
	"LL LETTER U WITH HORN AND GRAVELATIN CAPITAL LETTER U WITH HORN AND HOOK" +
	" ABOVELATIN SMALL LETTER U WITH HORN AND HOOK ABOVELATIN CAPITAL LETTER " +
	"U WITH HORN AND TILDELATIN SMALL LETTER U WITH HORN AND TILDELATIN CAPIT" +
	"AL LETTER U WITH HORN AND DOT BELOWLATIN SMALL LETTER U WITH HORN AND DO" +
	"T BELOWLATIN CAPITAL LETTER Y WITH GRAVELATIN SMALL LETTER Y WITH GRAVEL" +
	"ATIN CAPITAL LETTER Y WITH DOT BELOWLATIN SMALL LETTER Y WITH DOT BELOWL" +
	"ATIN CAPITAL LETTER Y WITH HOOK ABOVELATIN SMALL LETTER Y WITH HOOK ABOV" +
	"ELATIN CAPITAL LETTER Y WITH TILDELATIN SMALL LETTER Y WITH TILDELATIN C" +
	"APITAL LETTER MIDDLE-WELSH LLLATIN SMALL LETTER MIDDLE-WELSH LLLATIN CAP" +
	"ITAL LETTER MIDDLE-WELSH VLATIN SMALL LETTER MIDDLE-WELSH VLATIN CAPITAL" +
	" LETTER Y WITH LOOPLATIN SMALL LETTER Y WITH LOOPGREEK SMALL LETTER ALPH" +
	"A WITH PSILIGREEK SMALL LETTER ALPHA WITH DASIAGREEK SMALL LETTER ALPHA " +
	"WITH PSILI AND VARIAGREEK SMALL LETTER ALPHA WITH DASIA AND VARIAGREEK S" +
	"MALL LETTER ALPHA WITH PSILI AND OXIAGREEK SMALL LETTER ALPHA WITH DASIA" +
	" AND OXIAGREEK SMALL LETTER ALPHA WITH PSILI AND PERISPOMENIGREEK SMALL " +
	"LETTER ALPHA WITH DASIA AND PERISPOMENIGREEK CAPITAL LETTER ALPHA WITH P" +
	"SILIGREEK CAPITAL LETTER ALPHA WITH DASIAGREEK CAPITAL LETTER ALPHA WITH" +
	" PSILI AND VARIAGREEK CAPITAL LETTER ALPHA WITH DASIA AND VARIAGREEK CAP" +
	"ITAL LETTER ALPHA WITH PSILI AND OXIAGREEK CAPITAL LETTER ALPHA WITH DAS" +
	"IA AND OXIAGREEK CAPITAL LETTER ALPHA WITH PSILI AND PERISPOMENIGREEK CA" +
	"PITAL LETTER ALPHA WITH DASIA AND PERISPOMENIGREEK SMALL LETTER EPSILON " +
	"WITH PSILIGREEK SMALL LETTER EPSILON WITH DASIAGREEK SMALL LETTER EPSILO" +
	"N WITH PSILI AND VARIAGREEK SMALL LETTER EPSILON WITH DASIA AND VARIAGRE" +
	"EK SMALL LETTER EPSILON WITH PSILI AND OXIAGREEK SMALL LETTER EPSILON WI" +
	"TH DASIA AND OXIAGREEK CAPITAL LETTER EPSILON WITH PSILIGREEK CAPITAL LE" +
	"TTER EPSILON WITH DASIAGREEK CAPITAL LETTER EPSILON WITH PSILI AND VARIA" +
	"GREEK CAPITAL LETTER EPSILON WITH DASIA AND VARIAGREEK CAPITAL LETTER EP" +
	"SILON WITH PSILI AND OXIAGREEK CAPITAL LETTER EPSILON WITH DASIA AND OXI" +
	"AGREEK SMALL LETTER ETA WITH PSILIGREEK SMALL LETTER ETA WITH DASIAGREEK" +
	" SMALL LETTER ETA WITH PSILI AND VARIAGREEK SMALL LETTER ETA WITH DASIA " +
	"AND VARIAGREEK SMALL LETTER ETA WITH PSILI AND OXIAGREEK SMALL LETTER ET" +
	"A WITH DASIA AND OXIAGREEK SMALL LETTER ETA WITH PSILI AND PERISPOMENIGR" +
	"EEK SMALL LETTER ETA WITH DASIA AND PERISPOMENIGREEK CAPITAL LETTER ETA " +
	"WITH PSILIGREEK CAPITAL LETTER ETA WITH DASIAGREEK CAPITAL LETTER ETA WI" +
	"TH PSILI AND VARIAGREEK CAPITAL LETTER ETA WITH DASIA AND VARIAGREEK CAP") + ("" +
	"ITAL LETTER ETA WITH PSILI AND OXIAGREEK CAPITAL LETTER ETA WITH DASIA A" +
	"ND OXIAGREEK CAPITAL LETTER ETA WITH PSILI AND PERISPOMENIGREEK CAPITAL " +
	"LETTER ETA WITH DASIA AND PERISPOMENIGREEK SMALL LETTER IOTA WITH PSILIG" +
	"REEK SMALL LETTER IOTA WITH DASIAGREEK SMALL LETTER IOTA WITH PSILI AND " +
	"VARIAGREEK SMALL LETTER IOTA WITH DASIA AND VARIAGREEK SMALL LETTER IOTA" +
	" WITH PSILI AND OXIAGREEK SMALL LETTER IOTA WITH DASIA AND OXIAGREEK SMA" +
	"LL LETTER IOTA WITH PSILI AND PERISPOMENIGREEK SMALL LETTER IOTA WITH DA" +
	"SIA AND PERISPOMENIGREEK CAPITAL LETTER IOTA WITH PSILIGREEK CAPITAL LET" +
	"TER IOTA WITH DASIAGREEK CAPITAL LETTER IOTA WITH PSILI AND VARIAGREEK C" +
	"APITAL LETTER IOTA WITH DASIA AND VARIAGREEK CAPITAL LETTER IOTA WITH PS" +
	"ILI AND OXIAGREEK CAPITAL LETTER IOTA WITH DASIA AND OXIAGREEK CAPITAL L" +
	"ETTER IOTA WITH PSILI AND PERISPOMENIGREEK CAPITAL LETTER IOTA WITH DASI" +
	"A AND PERISPOMENIGREEK SMALL LETTER OMICRON WITH PSILIGREEK SMALL LETTER" +
	" OMICRON WITH DASIAGREEK SMALL LETTER OMICRON WITH PSILI AND VARIAGREEK " +
	"SMALL LETTER OMICRON WITH DASIA AND VARIAGREEK SMALL LETTER OMICRON WITH" +
	" PSILI AND OXIAGREEK SMALL LETTER OMICRON WITH DASIA AND OXIAGREEK CAPIT" +
	"AL LETTER OMICRON WITH PSILIGREEK CAPITAL LETTER OMICRON WITH DASIAGREEK" +
	" CAPITAL LETTER OMICRON WITH PSILI AND VARIAGREEK CAPITAL LETTER OMICRON" +
	" WITH DASIA AND VARIAGREEK CAPITAL LETTER OMICRON WITH PSILI AND OXIAGRE" +
	"EK CAPITAL LETTER OMICRON WITH DASIA AND OXIAGREEK SMALL LETTER UPSILON " +
	"WITH PSILIGREEK SMALL LETTER UPSILON WITH DASIAGREEK SMALL LETTER UPSILO" +
	"N WITH PSILI AND VARIAGREEK SMALL LETTER UPSILON WITH DASIA AND VARIAGRE" +
	"EK SMALL LETTER UPSILON WITH PSILI AND OXIAGREEK SMALL LETTER UPSILON WI" +
	"TH DASIA AND OXIAGREEK SMALL LETTER UPSILON WITH PSILI AND PERISPOMENIGR" +
	"EEK SMALL LETTER UPSILON WITH DASIA AND PERISPOMENIGREEK CAPITAL LETTER " +
	"UPSILON WITH DASIAGREEK CAPITAL LETTER UPSILON WITH DASIA AND VARIAGREEK" +
	" CAPITAL LETTER UPSILON WITH DASIA AND OXIAGREEK CAPITAL LETTER UPSILON " +
	"WITH DASIA AND PERISPOMENIGREEK SMALL LETTER OMEGA WITH PSILIGREEK SMALL" +
	" LETTER OMEGA WITH DASIAGREEK SMALL LETTER OMEGA WITH PSILI AND VARIAGRE" +
	"EK SMALL LETTER OMEGA WITH DASIA AND VARIAGREEK SMALL LETTER OMEGA WITH " +
	"PSILI AND OXIAGREEK SMALL LETTER OMEGA WITH DASIA AND OXIAGREEK SMALL LE" +
	"TTER OMEGA WITH PSILI AND PERISPOMENIGREEK SMALL LETTER OMEGA WITH DASIA" +
	" AND PERISPOMENIGREEK CAPITAL LETTER OMEGA WITH PSILIGREEK CAPITAL LETTE" +
	"R OMEGA WITH DASIAGREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIAGREEK C" +
	"APITAL LETTER OMEGA WITH DASIA AND VARIAGREEK CAPITAL LETTER OMEGA WITH " +
	"PSILI AND OXIAGREEK CAPITAL LETTER OMEGA WITH DASIA AND OXIAGREEK CAPITA" +
	"L LETTER OMEGA WITH PSILI AND PERISPOMENIGREEK CAPITAL LETTER OMEGA WITH" +
	" DASIA AND PERISPOMENIGREEK SMALL LETTER ALPHA WITH VARIAGREEK SMALL LET" +
	"TER ALPHA WITH OXIAGREEK SMALL LETTER EPSILON WITH VARIAGREEK SMALL LETT" +
	"ER EPSILON WITH OXIAGREEK SMALL LETTER ETA WITH VARIAGREEK SMALL LETTER " +
	"ETA WITH OXIAGREEK SMALL LETTER IOTA WITH VARIAGREEK SMALL LETTER IOTA W" +
	"ITH OXIAGREEK SMALL LETTER OMICRON WITH VARIAGREEK SMALL LETTER OMICRON " +
	"WITH OXIAGREEK SMALL LETTER UPSILON WITH VARIAGREEK SMALL LETTER UPSILON" +
	" WITH OXIAGREEK SMALL LETTER OMEGA WITH VARIAGREEK SMALL LETTER OMEGA WI" +
	"TH OXIAGREEK SMALL LETTER ALPHA WITH PSILI AND YPOGEGRAMMENIGREEK SMALL " +
	"LETTER ALPHA WITH DASIA AND YPOGEGRAMMENIGREEK SMALL LETTER ALPHA WITH P" +
	"SILI AND VARIA AND YPOGEGRAMMENIGREEK SMALL LETTER ALPHA WITH DASIA AND " +
	"VARIA AND YPOGEGRAMMENIGREEK SMALL LETTER ALPHA WITH PSILI AND OXIA AND " +
	"YPOGEGRAMMENIGREEK SMALL LETTER ALPHA WITH DASIA AND OXIA AND YPOGEGRAMM" +
	"ENIGREEK SMALL LETTER ALPHA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI" +
	"GREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENIGRE" +
	"EK CAPITAL LETTER ALPHA WITH PSILI AND PROSGEGRAMMENIGREEK CAPITAL LETTE" +
	"R ALPHA WITH DASIA AND PROSGEGRAMMENIGREEK CAPITAL LETTER ALPHA WITH PSI" +
	"LI AND VARIA AND PROSGEGRAMMENIGREEK CAPITAL LETTER ALPHA WITH DASIA AND" +
	" VARIA AND PROSGEGRAMMENIGREEK CAPITAL LETTER ALPHA WITH PSILI AND OXIA " +
	"AND PROSGEGRAMMENIGREEK CAPITAL LETTER ALPHA WITH DASIA AND OXIA AND PRO" +
	"SGEGRAMMENIGREEK CAPITAL LETTER ALPHA WITH PSILI AND PERISPOMENI AND PRO" +
	"SGEGRAMMENIGREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI AND PRO" +
	"SGEGRAMMENIGREEK SMALL LETTER ETA WITH PSILI AND YPOGEGRAMMENIGREEK SMAL" +
	"L LETTER ETA WITH DASIA AND YPOGEGRAMMENIGREEK SMALL LETTER ETA WITH PSI" +
	"LI AND VARIA AND YPOGEGRAMMENIGREEK SMALL LETTER ETA WITH DASIA AND VARI" +
	"A AND YPOGEGRAMMENIGREEK SMALL LETTER ETA WITH PSILI AND OXIA AND YPOGEG" +
	"RAMMENIGREEK SMALL LETTER ETA WITH DASIA AND OXIA AND YPOGEGRAMMENIGREEK" +
	" SMALL LETTER ETA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENIGREEK SMAL") + ("" +
	"L LETTER ETA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENIGREEK CAPITAL L" +
	"ETTER ETA WITH PSILI AND PROSGEGRAMMENIGREEK CAPITAL LETTER ETA WITH DAS" +
	"IA AND PROSGEGRAMMENIGREEK CAPITAL LETTER ETA WITH PSILI AND VARIA AND P" +
	"ROSGEGRAMMENIGREEK CAPITAL LETTER ETA WITH DASIA AND VARIA AND PROSGEGRA" +
	"MMENIGREEK CAPITAL LETTER ETA WITH PSILI AND OXIA AND PROSGEGRAMMENIGREE" +
	"K CAPITAL LETTER ETA WITH DASIA AND OXIA AND PROSGEGRAMMENIGREEK CAPITAL" +
	" LETTER ETA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENIGREEK CAPITAL L" +
	"ETTER ETA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENIGREEK SMALL LETTE" +
	"R OMEGA WITH PSILI AND YPOGEGRAMMENIGREEK SMALL LETTER OMEGA WITH DASIA " +
	"AND YPOGEGRAMMENIGREEK SMALL LETTER OMEGA WITH PSILI AND VARIA AND YPOGE" +
	"GRAMMENIGREEK SMALL LETTER OMEGA WITH DASIA AND VARIA AND YPOGEGRAMMENIG" +
	"REEK SMALL LETTER OMEGA WITH PSILI AND OXIA AND YPOGEGRAMMENIGREEK SMALL" +
	" LETTER OMEGA WITH DASIA AND OXIA AND YPOGEGRAMMENIGREEK SMALL LETTER OM" +
	"EGA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENIGREEK SMALL LETTER OMEGA" +
	" WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENIGREEK CAPITAL LETTER OMEGA " +
	"WITH PSILI AND PROSGEGRAMMENIGREEK CAPITAL LETTER OMEGA WITH DASIA AND P" +
	"ROSGEGRAMMENIGREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIA AND PROSGEG" +
	"RAMMENIGREEK CAPITAL LETTER OMEGA WITH DASIA AND VARIA AND PROSGEGRAMMEN" +
	"IGREEK CAPITAL LETTER OMEGA WITH PSILI AND OXIA AND PROSGEGRAMMENIGREEK " +
	"CAPITAL LETTER OMEGA WITH DASIA AND OXIA AND PROSGEGRAMMENIGREEK CAPITAL" +
	" LETTER OMEGA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENIGREEK CAPITAL" +
	" LETTER OMEGA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENIGREEK SMALL L" +
	"ETTER ALPHA WITH VRACHYGREEK SMALL LETTER ALPHA WITH MACRONGREEK SMALL L" +
	"ETTER ALPHA WITH VARIA AND YPOGEGRAMMENIGREEK SMALL LETTER ALPHA WITH YP" +
	"OGEGRAMMENIGREEK SMALL LETTER ALPHA WITH OXIA AND YPOGEGRAMMENIGREEK SMA" +
	"LL LETTER ALPHA WITH PERISPOMENIGREEK SMALL LETTER ALPHA WITH PERISPOMEN" +
	"I AND YPOGEGRAMMENIGREEK CAPITAL LETTER ALPHA WITH VRACHYGREEK CAPITAL L" +
	"ETTER ALPHA WITH MACRONGREEK CAPITAL LETTER ALPHA WITH VARIAGREEK CAPITA" +
	"L LETTER ALPHA WITH OXIAGREEK CAPITAL LETTER ALPHA WITH PROSGEGRAMMENIGR" +
	"EEK KORONISGREEK PROSGEGRAMMENIGREEK PSILIGREEK PERISPOMENIGREEK DIALYTI" +
	"KA AND PERISPOMENIGREEK SMALL LETTER ETA WITH VARIA AND YPOGEGRAMMENIGRE" +
	"EK SMALL LETTER ETA WITH YPOGEGRAMMENIGREEK SMALL LETTER ETA WITH OXIA A" +
	"ND YPOGEGRAMMENIGREEK SMALL LETTER ETA WITH PERISPOMENIGREEK SMALL LETTE" +
	"R ETA WITH PERISPOMENI AND YPOGEGRAMMENIGREEK CAPITAL LETTER EPSILON WIT" +
	"H VARIAGREEK CAPITAL LETTER EPSILON WITH OXIAGREEK CAPITAL LETTER ETA WI" +
	"TH VARIAGREEK CAPITAL LETTER ETA WITH OXIAGREEK CAPITAL LETTER ETA WITH " +
	"PROSGEGRAMMENIGREEK PSILI AND VARIAGREEK PSILI AND OXIAGREEK PSILI AND P" +
	"ERISPOMENIGREEK SMALL LETTER IOTA WITH VRACHYGREEK SMALL LETTER IOTA WIT" +
	"H MACRONGREEK SMALL LETTER IOTA WITH DIALYTIKA AND VARIAGREEK SMALL LETT" +
	"ER IOTA WITH DIALYTIKA AND OXIAGREEK SMALL LETTER IOTA WITH PERISPOMENIG" +
	"REEK SMALL LETTER IOTA WITH DIALYTIKA AND PERISPOMENIGREEK CAPITAL LETTE" +
	"R IOTA WITH VRACHYGREEK CAPITAL LETTER IOTA WITH MACRONGREEK CAPITAL LET" +
	"TER IOTA WITH VARIAGREEK CAPITAL LETTER IOTA WITH OXIAGREEK DASIA AND VA" +
	"RIAGREEK DASIA AND OXIAGREEK DASIA AND PERISPOMENIGREEK SMALL LETTER UPS" +
	"ILON WITH VRACHYGREEK SMALL LETTER UPSILON WITH MACRONGREEK SMALL LETTER" +
	" UPSILON WITH DIALYTIKA AND VARIAGREEK SMALL LETTER UPSILON WITH DIALYTI" +
	"KA AND OXIAGREEK SMALL LETTER RHO WITH PSILIGREEK SMALL LETTER RHO WITH " +
	"DASIAGREEK SMALL LETTER UPSILON WITH PERISPOMENIGREEK SMALL LETTER UPSIL" +
	"ON WITH DIALYTIKA AND PERISPOMENIGREEK CAPITAL LETTER UPSILON WITH VRACH" +
	"YGREEK CAPITAL LETTER UPSILON WITH MACRONGREEK CAPITAL LETTER UPSILON WI" +
	"TH VARIAGREEK CAPITAL LETTER UPSILON WITH OXIAGREEK CAPITAL LETTER RHO W" +
	"ITH DASIAGREEK DIALYTIKA AND VARIAGREEK DIALYTIKA AND OXIAGREEK VARIAGRE" +
	"EK SMALL LETTER OMEGA WITH VARIA AND YPOGEGRAMMENIGREEK SMALL LETTER OME" +
	"GA WITH YPOGEGRAMMENIGREEK SMALL LETTER OMEGA WITH OXIA AND YPOGEGRAMMEN" +
	"IGREEK SMALL LETTER OMEGA WITH PERISPOMENIGREEK SMALL LETTER OMEGA WITH " +
	"PERISPOMENI AND YPOGEGRAMMENIGREEK CAPITAL LETTER OMICRON WITH VARIAGREE" +
	"K CAPITAL LETTER OMICRON WITH OXIAGREEK CAPITAL LETTER OMEGA WITH VARIAG" +
	"REEK CAPITAL LETTER OMEGA WITH OXIAGREEK CAPITAL LETTER OMEGA WITH PROSG" +
	"EGRAMMENIGREEK OXIAGREEK DASIAEN QUADEM QUADEN SPACEEM SPACETHREE-PER-EM" +
	" SPACEFOUR-PER-EM SPACESIX-PER-EM SPACEFIGURE SPACEPUNCTUATION SPACETHIN" +
	" SPACEHAIR SPACEZERO WIDTH SPACEZERO WIDTH NON-JOINERZERO WIDTH JOINERLE" +
	"FT-TO-RIGHT MARKRIGHT-TO-LEFT MARKHYPHENNON-BREAKING HYPHENFIGURE DASHEN" +
	" DASHEM DASHHORIZONTAL BARDOUBLE VERTICAL LINEDOUBLE LOW LINELEFT SINGLE" +
	" QUOTATION MARKRIGHT SINGLE QUOTATION MARKSINGLE LOW-9 QUOTATION MARKSIN") + ("" +
	"GLE HIGH-REVERSED-9 QUOTATION MARKLEFT DOUBLE QUOTATION MARKRIGHT DOUBLE" +
	" QUOTATION MARKDOUBLE LOW-9 QUOTATION MARKDOUBLE HIGH-REVERSED-9 QUOTATI" +
	"ON MARKDAGGERDOUBLE DAGGERBULLETTRIANGULAR BULLETONE DOT LEADERTWO DOT L" +
	"EADERHORIZONTAL ELLIPSISHYPHENATION POINTLINE SEPARATORPARAGRAPH SEPARAT" +
	"ORLEFT-TO-RIGHT EMBEDDINGRIGHT-TO-LEFT EMBEDDINGPOP DIRECTIONAL FORMATTI" +
	"NGLEFT-TO-RIGHT OVERRIDERIGHT-TO-LEFT OVERRIDENARROW NO-BREAK SPACEPER M" +
	"ILLE SIGNPER TEN THOUSAND SIGNPRIMEDOUBLE PRIMETRIPLE PRIMEREVERSED PRIM" +
	"EREVERSED DOUBLE PRIMEREVERSED TRIPLE PRIMECARETSINGLE LEFT-POINTING ANG" +
	"LE QUOTATION MARKSINGLE RIGHT-POINTING ANGLE QUOTATION MARKREFERENCE MAR" +
	"KDOUBLE EXCLAMATION MARKINTERROBANGOVERLINEUNDERTIECHARACTER TIECARET IN" +
	"SERTION POINTASTERISMHYPHEN BULLETFRACTION SLASHLEFT SQUARE BRACKET WITH" +
	" QUILLRIGHT SQUARE BRACKET WITH QUILLDOUBLE QUESTION MARKQUESTION EXCLAM" +
	"ATION MARKEXCLAMATION QUESTION MARKTIRONIAN SIGN ETREVERSED PILCROW SIGN" +
	"BLACK LEFTWARDS BULLETBLACK RIGHTWARDS BULLETLOW ASTERISKREVERSED SEMICO" +
	"LONCLOSE UPTWO ASTERISKS ALIGNED VERTICALLYCOMMERCIAL MINUS SIGNSWUNG DA" +
	"SHINVERTED UNDERTIEFLOWER PUNCTUATION MARKTHREE DOT PUNCTUATIONQUADRUPLE" +
	" PRIMEFOUR DOT PUNCTUATIONFIVE DOT PUNCTUATIONTWO DOT PUNCTUATIONFOUR DO" +
	"T MARKDOTTED CROSSTRICOLONVERTICAL FOUR DOTSMEDIUM MATHEMATICAL SPACEWOR" +
	"D JOINERFUNCTION APPLICATIONINVISIBLE TIMESINVISIBLE SEPARATORINVISIBLE " +
	"PLUSLEFT-TO-RIGHT ISOLATERIGHT-TO-LEFT ISOLATEFIRST STRONG ISOLATEPOP DI" +
	"RECTIONAL ISOLATEINHIBIT SYMMETRIC SWAPPINGACTIVATE SYMMETRIC SWAPPINGIN" +
	"HIBIT ARABIC FORM SHAPINGACTIVATE ARABIC FORM SHAPINGNATIONAL DIGIT SHAP" +
	"ESNOMINAL DIGIT SHAPESSUPERSCRIPT ZEROSUPERSCRIPT LATIN SMALL LETTER ISU" +
	"PERSCRIPT FOURSUPERSCRIPT FIVESUPERSCRIPT SIXSUPERSCRIPT SEVENSUPERSCRIP" +
	"T EIGHTSUPERSCRIPT NINESUPERSCRIPT PLUS SIGNSUPERSCRIPT MINUSSUPERSCRIPT" +
	" EQUALS SIGNSUPERSCRIPT LEFT PARENTHESISSUPERSCRIPT RIGHT PARENTHESISSUP" +
	"ERSCRIPT LATIN SMALL LETTER NSUBSCRIPT ZEROSUBSCRIPT ONESUBSCRIPT TWOSUB" +
	"SCRIPT THREESUBSCRIPT FOURSUBSCRIPT FIVESUBSCRIPT SIXSUBSCRIPT SEVENSUBS" +
	"CRIPT EIGHTSUBSCRIPT NINESUBSCRIPT PLUS SIGNSUBSCRIPT MINUSSUBSCRIPT EQU" +
	"ALS SIGNSUBSCRIPT LEFT PARENTHESISSUBSCRIPT RIGHT PARENTHESISLATIN SUBSC" +
	"RIPT SMALL LETTER ALATIN SUBSCRIPT SMALL LETTER ELATIN SUBSCRIPT SMALL L" +
	"ETTER OLATIN SUBSCRIPT SMALL LETTER XLATIN SUBSCRIPT SMALL LETTER SCHWAL" +
	"ATIN SUBSCRIPT SMALL LETTER HLATIN SUBSCRIPT SMALL LETTER KLATIN SUBSCRI" +
	"PT SMALL LETTER LLATIN SUBSCRIPT SMALL LETTER MLATIN SUBSCRIPT SMALL LET" +
	"TER NLATIN SUBSCRIPT SMALL LETTER PLATIN SUBSCRIPT SMALL LETTER SLATIN S" +
	"UBSCRIPT SMALL LETTER TEURO-CURRENCY SIGNCOLON SIGNCRUZEIRO SIGNFRENCH F" +
	"RANC SIGNLIRA SIGNMILL SIGNNAIRA SIGNPESETA SIGNRUPEE SIGNWON SIGNNEW SH" +
	"EQEL SIGNDONG SIGNEURO SIGNKIP SIGNTUGRIK SIGNDRACHMA SIGNGERMAN PENNY S" +
	"IGNPESO SIGNGUARANI SIGNAUSTRAL SIGNHRYVNIA SIGNCEDI SIGNLIVRE TOURNOIS " +
	"SIGNSPESMILO SIGNTENGE SIGNINDIAN RUPEE SIGNTURKISH LIRA SIGNNORDIC MARK" +
	" SIGNMANAT SIGNRUBLE SIGNLARI SIGNBITCOIN SIGNCOMBINING LEFT HARPOON ABO" +
	"VECOMBINING RIGHT HARPOON ABOVECOMBINING LONG VERTICAL LINE OVERLAYCOMBI" +
	"NING SHORT VERTICAL LINE OVERLAYCOMBINING ANTICLOCKWISE ARROW ABOVECOMBI" +
	"NING CLOCKWISE ARROW ABOVECOMBINING LEFT ARROW ABOVECOMBINING RIGHT ARRO" +
	"W ABOVECOMBINING RING OVERLAYCOMBINING CLOCKWISE RING OVERLAYCOMBINING A" +
	"NTICLOCKWISE RING OVERLAYCOMBINING THREE DOTS ABOVECOMBINING FOUR DOTS A" +
	"BOVECOMBINING ENCLOSING CIRCLECOMBINING ENCLOSING SQUARECOMBINING ENCLOS" +
	"ING DIAMONDCOMBINING ENCLOSING CIRCLE BACKSLASHCOMBINING LEFT RIGHT ARRO" +
	"W ABOVECOMBINING ENCLOSING SCREENCOMBINING ENCLOSING KEYCAPCOMBINING ENC" +
	"LOSING UPWARD POINTING TRIANGLECOMBINING REVERSE SOLIDUS OVERLAYCOMBININ" +
	"G DOUBLE VERTICAL STROKE OVERLAYCOMBINING ANNUITY SYMBOLCOMBINING TRIPLE" +
	" UNDERDOTCOMBINING WIDE BRIDGE ABOVECOMBINING LEFTWARDS ARROW OVERLAYCOM" +
	"BINING LONG DOUBLE SOLIDUS OVERLAYCOMBINING RIGHTWARDS HARPOON WITH BARB" +
	" DOWNWARDSCOMBINING LEFTWARDS HARPOON WITH BARB DOWNWARDSCOMBINING LEFT " +
	"ARROW BELOWCOMBINING RIGHT ARROW BELOWCOMBINING ASTERISK ABOVEACCOUNT OF" +
	"ADDRESSED TO THE SUBJECTDOUBLE-STRUCK CAPITAL CDEGREE CELSIUSCENTRE LINE" +
	" SYMBOLCARE OFCADA UNAEULER CONSTANTSCRUPLEDEGREE FAHRENHEITSCRIPT SMALL" +
	" GSCRIPT CAPITAL HBLACK-LETTER CAPITAL HDOUBLE-STRUCK CAPITAL HPLANCK CO" +
	"NSTANTPLANCK CONSTANT OVER TWO PISCRIPT CAPITAL IBLACK-LETTER CAPITAL IS" +
	"CRIPT CAPITAL LSCRIPT SMALL LL B BAR SYMBOLDOUBLE-STRUCK CAPITAL NNUMERO" +
	" SIGNSOUND RECORDING COPYRIGHTSCRIPT CAPITAL PDOUBLE-STRUCK CAPITAL PDOU" +
	"BLE-STRUCK CAPITAL QSCRIPT CAPITAL RBLACK-LETTER CAPITAL RDOUBLE-STRUCK " +
	"CAPITAL RPRESCRIPTION TAKERESPONSESERVICE MARKTELEPHONE SIGNTRADE MARK S" +
	"IGNVERSICLEDOUBLE-STRUCK CAPITAL ZOUNCE SIGNOHM SIGNINVERTED OHM SIGNBLA") + ("" +
	"CK-LETTER CAPITAL ZTURNED GREEK SMALL LETTER IOTAKELVIN SIGNANGSTROM SIG" +
	"NSCRIPT CAPITAL BBLACK-LETTER CAPITAL CESTIMATED SYMBOLSCRIPT SMALL ESCR" +
	"IPT CAPITAL ESCRIPT CAPITAL FTURNED CAPITAL FSCRIPT CAPITAL MSCRIPT SMAL" +
	"L OALEF SYMBOLBET SYMBOLGIMEL SYMBOLDALET SYMBOLINFORMATION SOURCEROTATE" +
	"D CAPITAL QFACSIMILE SIGNDOUBLE-STRUCK SMALL PIDOUBLE-STRUCK SMALL GAMMA" +
	"DOUBLE-STRUCK CAPITAL GAMMADOUBLE-STRUCK CAPITAL PIDOUBLE-STRUCK N-ARY S" +
	"UMMATIONTURNED SANS-SERIF CAPITAL GTURNED SANS-SERIF CAPITAL LREVERSED S" +
	"ANS-SERIF CAPITAL LTURNED SANS-SERIF CAPITAL YDOUBLE-STRUCK ITALIC CAPIT" +
	"AL DDOUBLE-STRUCK ITALIC SMALL DDOUBLE-STRUCK ITALIC SMALL EDOUBLE-STRUC" +
	"K ITALIC SMALL IDOUBLE-STRUCK ITALIC SMALL JPROPERTY LINETURNED AMPERSAN" +
	"DPER SIGNAKTIESELSKABTURNED SMALL FSYMBOL FOR SAMARITAN SOURCEVULGAR FRA" +
	"CTION ONE SEVENTHVULGAR FRACTION ONE NINTHVULGAR FRACTION ONE TENTHVULGA" +
	"R FRACTION ONE THIRDVULGAR FRACTION TWO THIRDSVULGAR FRACTION ONE FIFTHV" +
	"ULGAR FRACTION TWO FIFTHSVULGAR FRACTION THREE FIFTHSVULGAR FRACTION FOU" +
	"R FIFTHSVULGAR FRACTION ONE SIXTHVULGAR FRACTION FIVE SIXTHSVULGAR FRACT" +
	"ION ONE EIGHTHVULGAR FRACTION THREE EIGHTHSVULGAR FRACTION FIVE EIGHTHSV" +
	"ULGAR FRACTION SEVEN EIGHTHSFRACTION NUMERATOR ONEROMAN NUMERAL ONEROMAN" +
	" NUMERAL TWOROMAN NUMERAL THREEROMAN NUMERAL FOURROMAN NUMERAL FIVEROMAN" +
	" NUMERAL SIXROMAN NUMERAL SEVENROMAN NUMERAL EIGHTROMAN NUMERAL NINEROMA" +
	"N NUMERAL TENROMAN NUMERAL ELEVENROMAN NUMERAL TWELVEROMAN NUMERAL FIFTY" +
	"ROMAN NUMERAL ONE HUNDREDROMAN NUMERAL FIVE HUNDREDROMAN NUMERAL ONE THO" +
	"USANDSMALL ROMAN NUMERAL ONESMALL ROMAN NUMERAL TWOSMALL ROMAN NUMERAL T" +
	"HREESMALL ROMAN NUMERAL FOURSMALL ROMAN NUMERAL FIVESMALL ROMAN NUMERAL " +
	"SIXSMALL ROMAN NUMERAL SEVENSMALL ROMAN NUMERAL EIGHTSMALL ROMAN NUMERAL" +
	" NINESMALL ROMAN NUMERAL TENSMALL ROMAN NUMERAL ELEVENSMALL ROMAN NUMERA" +
	"L TWELVESMALL ROMAN NUMERAL FIFTYSMALL ROMAN NUMERAL ONE HUNDREDSMALL RO" +
	"MAN NUMERAL FIVE HUNDREDSMALL ROMAN NUMERAL ONE THOUSANDROMAN NUMERAL ON" +
	"E THOUSAND C DROMAN NUMERAL FIVE THOUSANDROMAN NUMERAL TEN THOUSANDROMAN" +
	" NUMERAL REVERSED ONE HUNDREDLATIN SMALL LETTER REVERSED CROMAN NUMERAL " +
	"SIX LATE FORMROMAN NUMERAL FIFTY EARLY FORMROMAN NUMERAL FIFTY THOUSANDR" +
	"OMAN NUMERAL ONE HUNDRED THOUSANDVULGAR FRACTION ZERO THIRDSTURNED DIGIT" +
	" TWOTURNED DIGIT THREELEFTWARDS ARROWUPWARDS ARROWRIGHTWARDS ARROWDOWNWA" +
	"RDS ARROWLEFT RIGHT ARROWUP DOWN ARROWNORTH WEST ARROWNORTH EAST ARROWSO" +
	"UTH EAST ARROWSOUTH WEST ARROWLEFTWARDS ARROW WITH STROKERIGHTWARDS ARRO" +
	"W WITH STROKELEFTWARDS WAVE ARROWRIGHTWARDS WAVE ARROWLEFTWARDS TWO HEAD" +
	"ED ARROWUPWARDS TWO HEADED ARROWRIGHTWARDS TWO HEADED ARROWDOWNWARDS TWO" +
	" HEADED ARROWLEFTWARDS ARROW WITH TAILRIGHTWARDS ARROW WITH TAILLEFTWARD" +
	"S ARROW FROM BARUPWARDS ARROW FROM BARRIGHTWARDS ARROW FROM BARDOWNWARDS" +
	" ARROW FROM BARUP DOWN ARROW WITH BASELEFTWARDS ARROW WITH HOOKRIGHTWARD" +
	"S ARROW WITH HOOKLEFTWARDS ARROW WITH LOOPRIGHTWARDS ARROW WITH LOOPLEFT" +
	" RIGHT WAVE ARROWLEFT RIGHT ARROW WITH STROKEDOWNWARDS ZIGZAG ARROWUPWAR" +
	"DS ARROW WITH TIP LEFTWARDSUPWARDS ARROW WITH TIP RIGHTWARDSDOWNWARDS AR" +
	"ROW WITH TIP LEFTWARDSDOWNWARDS ARROW WITH TIP RIGHTWARDSRIGHTWARDS ARRO" +
	"W WITH CORNER DOWNWARDSDOWNWARDS ARROW WITH CORNER LEFTWARDSANTICLOCKWIS" +
	"E TOP SEMICIRCLE ARROWCLOCKWISE TOP SEMICIRCLE ARROWNORTH WEST ARROW TO " +
	"LONG BARLEFTWARDS ARROW TO BAR OVER RIGHTWARDS ARROW TO BARANTICLOCKWISE" +
	" OPEN CIRCLE ARROWCLOCKWISE OPEN CIRCLE ARROWLEFTWARDS HARPOON WITH BARB" +
	" UPWARDSLEFTWARDS HARPOON WITH BARB DOWNWARDSUPWARDS HARPOON WITH BARB R" +
	"IGHTWARDSUPWARDS HARPOON WITH BARB LEFTWARDSRIGHTWARDS HARPOON WITH BARB" +
	" UPWARDSRIGHTWARDS HARPOON WITH BARB DOWNWARDSDOWNWARDS HARPOON WITH BAR" +
	"B RIGHTWARDSDOWNWARDS HARPOON WITH BARB LEFTWARDSRIGHTWARDS ARROW OVER L" +
	"EFTWARDS ARROWUPWARDS ARROW LEFTWARDS OF DOWNWARDS ARROWLEFTWARDS ARROW " +
	"OVER RIGHTWARDS ARROWLEFTWARDS PAIRED ARROWSUPWARDS PAIRED ARROWSRIGHTWA" +
	"RDS PAIRED ARROWSDOWNWARDS PAIRED ARROWSLEFTWARDS HARPOON OVER RIGHTWARD" +
	"S HARPOONRIGHTWARDS HARPOON OVER LEFTWARDS HARPOONLEFTWARDS DOUBLE ARROW" +
	" WITH STROKELEFT RIGHT DOUBLE ARROW WITH STROKERIGHTWARDS DOUBLE ARROW W" +
	"ITH STROKELEFTWARDS DOUBLE ARROWUPWARDS DOUBLE ARROWRIGHTWARDS DOUBLE AR" +
	"ROWDOWNWARDS DOUBLE ARROWLEFT RIGHT DOUBLE ARROWUP DOWN DOUBLE ARROWNORT" +
	"H WEST DOUBLE ARROWNORTH EAST DOUBLE ARROWSOUTH EAST DOUBLE ARROWSOUTH W" +
	"EST DOUBLE ARROWLEFTWARDS TRIPLE ARROWRIGHTWARDS TRIPLE ARROWLEFTWARDS S" +
	"QUIGGLE ARROWRIGHTWARDS SQUIGGLE ARROWUPWARDS ARROW WITH DOUBLE STROKEDO" +
	"WNWARDS ARROW WITH DOUBLE STROKELEFTWARDS DASHED ARROWUPWARDS DASHED ARR" +
	"OWRIGHTWARDS DASHED ARROWDOWNWARDS DASHED ARROWLEFTWARDS ARROW TO BARRIG" +
	"HTWARDS ARROW TO BARLEFTWARDS WHITE ARROWUPWARDS WHITE ARROWRIGHTWARDS W") + ("" +
	"HITE ARROWDOWNWARDS WHITE ARROWUPWARDS WHITE ARROW FROM BARUPWARDS WHITE" +
	" ARROW ON PEDESTALUPWARDS WHITE ARROW ON PEDESTAL WITH HORIZONTAL BARUPW" +
	"ARDS WHITE ARROW ON PEDESTAL WITH VERTICAL BARUPWARDS WHITE DOUBLE ARROW" +
	"UPWARDS WHITE DOUBLE ARROW ON PEDESTALRIGHTWARDS WHITE ARROW FROM WALLNO" +
	"RTH WEST ARROW TO CORNERSOUTH EAST ARROW TO CORNERUP DOWN WHITE ARROWRIG" +
	"HT ARROW WITH SMALL CIRCLEDOWNWARDS ARROW LEFTWARDS OF UPWARDS ARROWTHRE" +
	"E RIGHTWARDS ARROWSLEFTWARDS ARROW WITH VERTICAL STROKERIGHTWARDS ARROW " +
	"WITH VERTICAL STROKELEFT RIGHT ARROW WITH VERTICAL STROKELEFTWARDS ARROW" +
	" WITH DOUBLE VERTICAL STROKERIGHTWARDS ARROW WITH DOUBLE VERTICAL STROKE" +
	"LEFT RIGHT ARROW WITH DOUBLE VERTICAL STROKELEFTWARDS OPEN-HEADED ARROWR" +
	"IGHTWARDS OPEN-HEADED ARROWLEFT RIGHT OPEN-HEADED ARROWFOR ALLCOMPLEMENT" +
	"PARTIAL DIFFERENTIALTHERE EXISTSTHERE DOES NOT EXISTEMPTY SETINCREMENTNA" +
	"BLAELEMENT OFNOT AN ELEMENT OFSMALL ELEMENT OFCONTAINS AS MEMBERDOES NOT" +
	" CONTAIN AS MEMBERSMALL CONTAINS AS MEMBEREND OF PROOFN-ARY PRODUCTN-ARY" +
	" COPRODUCTN-ARY SUMMATIONMINUS SIGNMINUS-OR-PLUS SIGNDOT PLUSDIVISION SL" +
	"ASHSET MINUSASTERISK OPERATORRING OPERATORBULLET OPERATORSQUARE ROOTCUBE" +
	" ROOTFOURTH ROOTPROPORTIONAL TOINFINITYRIGHT ANGLEANGLEMEASURED ANGLESPH" +
	"ERICAL ANGLEDIVIDESDOES NOT DIVIDEPARALLEL TONOT PARALLEL TOLOGICAL ANDL" +
	"OGICAL ORINTERSECTIONUNIONINTEGRALDOUBLE INTEGRALTRIPLE INTEGRALCONTOUR " +
	"INTEGRALSURFACE INTEGRALVOLUME INTEGRALCLOCKWISE INTEGRALCLOCKWISE CONTO" +
	"UR INTEGRALANTICLOCKWISE CONTOUR INTEGRALTHEREFOREBECAUSERATIOPROPORTION" +
	"DOT MINUSEXCESSGEOMETRIC PROPORTIONHOMOTHETICTILDE OPERATORREVERSED TILD" +
	"EINVERTED LAZY SSINE WAVEWREATH PRODUCTNOT TILDEMINUS TILDEASYMPTOTICALL" +
	"Y EQUAL TONOT ASYMPTOTICALLY EQUAL TOAPPROXIMATELY EQUAL TOAPPROXIMATELY" +
	" BUT NOT ACTUALLY EQUAL TONEITHER APPROXIMATELY NOR ACTUALLY EQUAL TOALM" +
	"OST EQUAL TONOT ALMOST EQUAL TOALMOST EQUAL OR EQUAL TOTRIPLE TILDEALL E" +
	"QUAL TOEQUIVALENT TOGEOMETRICALLY EQUIVALENT TODIFFERENCE BETWEENAPPROAC" +
	"HES THE LIMITGEOMETRICALLY EQUAL TOAPPROXIMATELY EQUAL TO OR THE IMAGE O" +
	"FIMAGE OF OR APPROXIMATELY EQUAL TOCOLON EQUALSEQUALS COLONRING IN EQUAL" +
	" TORING EQUAL TOCORRESPONDS TOESTIMATESEQUIANGULAR TOSTAR EQUALSDELTA EQ" +
	"UAL TOEQUAL TO BY DEFINITIONMEASURED BYQUESTIONED EQUAL TONOT EQUAL TOID" +
	"ENTICAL TONOT IDENTICAL TOSTRICTLY EQUIVALENT TOLESS-THAN OR EQUAL TOGRE" +
	"ATER-THAN OR EQUAL TOLESS-THAN OVER EQUAL TOGREATER-THAN OVER EQUAL TOLE" +
	"SS-THAN BUT NOT EQUAL TOGREATER-THAN BUT NOT EQUAL TOMUCH LESS-THANMUCH " +
	"GREATER-THANBETWEENNOT EQUIVALENT TONOT LESS-THANNOT GREATER-THANNEITHER" +
	" LESS-THAN NOR EQUAL TONEITHER GREATER-THAN NOR EQUAL TOLESS-THAN OR EQU" +
	"IVALENT TOGREATER-THAN OR EQUIVALENT TONEITHER LESS-THAN NOR EQUIVALENT " +
	"TONEITHER GREATER-THAN NOR EQUIVALENT TOLESS-THAN OR GREATER-THANGREATER" +
	"-THAN OR LESS-THANNEITHER LESS-THAN NOR GREATER-THANNEITHER GREATER-THAN" +
	" NOR LESS-THANPRECEDESSUCCEEDSPRECEDES OR EQUAL TOSUCCEEDS OR EQUAL TOPR" +
	"ECEDES OR EQUIVALENT TOSUCCEEDS OR EQUIVALENT TODOES NOT PRECEDEDOES NOT" +
	" SUCCEEDSUBSET OFSUPERSET OFNOT A SUBSET OFNOT A SUPERSET OFSUBSET OF OR" +
	" EQUAL TOSUPERSET OF OR EQUAL TONEITHER A SUBSET OF NOR EQUAL TONEITHER " +
	"A SUPERSET OF NOR EQUAL TOSUBSET OF WITH NOT EQUAL TOSUPERSET OF WITH NO" +
	"T EQUAL TOMULTISETMULTISET MULTIPLICATIONMULTISET UNIONSQUARE IMAGE OFSQ" +
	"UARE ORIGINAL OFSQUARE IMAGE OF OR EQUAL TOSQUARE ORIGINAL OF OR EQUAL T" +
	"OSQUARE CAPSQUARE CUPCIRCLED PLUSCIRCLED MINUSCIRCLED TIMESCIRCLED DIVIS" +
	"ION SLASHCIRCLED DOT OPERATORCIRCLED RING OPERATORCIRCLED ASTERISK OPERA" +
	"TORCIRCLED EQUALSCIRCLED DASHSQUARED PLUSSQUARED MINUSSQUARED TIMESSQUAR" +
	"ED DOT OPERATORRIGHT TACKLEFT TACKDOWN TACKUP TACKASSERTIONMODELSTRUEFOR" +
	"CESTRIPLE VERTICAL BAR RIGHT TURNSTILEDOUBLE VERTICAL BAR DOUBLE RIGHT T" +
	"URNSTILEDOES NOT PROVENOT TRUEDOES NOT FORCENEGATED DOUBLE VERTICAL BAR " +
	"DOUBLE RIGHT TURNSTILEPRECEDES UNDER RELATIONSUCCEEDS UNDER RELATIONNORM" +
	"AL SUBGROUP OFCONTAINS AS NORMAL SUBGROUPNORMAL SUBGROUP OF OR EQUAL TOC" +
	"ONTAINS AS NORMAL SUBGROUP OR EQUAL TOORIGINAL OFIMAGE OFMULTIMAPHERMITI" +
	"AN CONJUGATE MATRIXINTERCALATEXORNANDNORRIGHT ANGLE WITH ARCRIGHT TRIANG" +
	"LEN-ARY LOGICAL ANDN-ARY LOGICAL ORN-ARY INTERSECTIONN-ARY UNIONDIAMOND " +
	"OPERATORDOT OPERATORSTAR OPERATORDIVISION TIMESBOWTIELEFT NORMAL FACTOR " +
	"SEMIDIRECT PRODUCTRIGHT NORMAL FACTOR SEMIDIRECT PRODUCTLEFT SEMIDIRECT " +
	"PRODUCTRIGHT SEMIDIRECT PRODUCTREVERSED TILDE EQUALSCURLY LOGICAL ORCURL" +
	"Y LOGICAL ANDDOUBLE SUBSETDOUBLE SUPERSETDOUBLE INTERSECTIONDOUBLE UNION" +
	"PITCHFORKEQUAL AND PARALLEL TOLESS-THAN WITH DOTGREATER-THAN WITH DOTVER" +
	"Y MUCH LESS-THANVERY MUCH GREATER-THANLESS-THAN EQUAL TO OR GREATER-THAN" +
	"GREATER-THAN EQUAL TO OR LESS-THANEQUAL TO OR LESS-THANEQUAL TO OR GREAT") + ("" +
	"ER-THANEQUAL TO OR PRECEDESEQUAL TO OR SUCCEEDSDOES NOT PRECEDE OR EQUAL" +
	"DOES NOT SUCCEED OR EQUALNOT SQUARE IMAGE OF OR EQUAL TONOT SQUARE ORIGI" +
	"NAL OF OR EQUAL TOSQUARE IMAGE OF OR NOT EQUAL TOSQUARE ORIGINAL OF OR N" +
	"OT EQUAL TOLESS-THAN BUT NOT EQUIVALENT TOGREATER-THAN BUT NOT EQUIVALEN" +
	"T TOPRECEDES BUT NOT EQUIVALENT TOSUCCEEDS BUT NOT EQUIVALENT TONOT NORM" +
	"AL SUBGROUP OFDOES NOT CONTAIN AS NORMAL SUBGROUPNOT NORMAL SUBGROUP OF " +
	"OR EQUAL TODOES NOT CONTAIN AS NORMAL SUBGROUP OR EQUALVERTICAL ELLIPSIS" +
	"MIDLINE HORIZONTAL ELLIPSISUP RIGHT DIAGONAL ELLIPSISDOWN RIGHT DIAGONAL" +
	" ELLIPSISELEMENT OF WITH LONG HORIZONTAL STROKEELEMENT OF WITH VERTICAL " +
	"BAR AT END OF HORIZONTAL STROKESMALL ELEMENT OF WITH VERTICAL BAR AT END" +
	" OF HORIZONTAL STROKEELEMENT OF WITH DOT ABOVEELEMENT OF WITH OVERBARSMA" +
	"LL ELEMENT OF WITH OVERBARELEMENT OF WITH UNDERBARELEMENT OF WITH TWO HO" +
	"RIZONTAL STROKESCONTAINS WITH LONG HORIZONTAL STROKECONTAINS WITH VERTIC" +
	"AL BAR AT END OF HORIZONTAL STROKESMALL CONTAINS WITH VERTICAL BAR AT EN" +
	"D OF HORIZONTAL STROKECONTAINS WITH OVERBARSMALL CONTAINS WITH OVERBARZ " +
	"NOTATION BAG MEMBERSHIPDIAMETER SIGNELECTRIC ARROWHOUSEUP ARROWHEADDOWN " +
	"ARROWHEADPROJECTIVEPERSPECTIVEWAVY LINELEFT CEILINGRIGHT CEILINGLEFT FLO" +
	"ORRIGHT FLOORBOTTOM RIGHT CROPBOTTOM LEFT CROPTOP RIGHT CROPTOP LEFT CRO" +
	"PREVERSED NOT SIGNSQUARE LOZENGEARCSEGMENTSECTORTELEPHONE RECORDERPOSITI" +
	"ON INDICATORVIEWDATA SQUAREPLACE OF INTEREST SIGNTURNED NOT SIGNWATCHHOU" +
	"RGLASSTOP LEFT CORNERTOP RIGHT CORNERBOTTOM LEFT CORNERBOTTOM RIGHT CORN" +
	"ERTOP HALF INTEGRALBOTTOM HALF INTEGRALFROWNSMILEUP ARROWHEAD BETWEEN TW" +
	"O HORIZONTAL BARSOPTION KEYERASE TO THE RIGHTX IN A RECTANGLE BOXKEYBOAR" +
	"DLEFT-POINTING ANGLE BRACKETRIGHT-POINTING ANGLE BRACKETERASE TO THE LEF" +
	"TBENZENE RINGCYLINDRICITYALL AROUND-PROFILESYMMETRYTOTAL RUNOUTDIMENSION" +
	" ORIGINCONICAL TAPERSLOPECOUNTERBORECOUNTERSINKAPL FUNCTIONAL SYMBOL I-B" +
	"EAMAPL FUNCTIONAL SYMBOL SQUISH QUADAPL FUNCTIONAL SYMBOL QUAD EQUALAPL " +
	"FUNCTIONAL SYMBOL QUAD DIVIDEAPL FUNCTIONAL SYMBOL QUAD DIAMONDAPL FUNCT" +
	"IONAL SYMBOL QUAD JOTAPL FUNCTIONAL SYMBOL QUAD CIRCLEAPL FUNCTIONAL SYM" +
	"BOL CIRCLE STILEAPL FUNCTIONAL SYMBOL CIRCLE JOTAPL FUNCTIONAL SYMBOL SL" +
	"ASH BARAPL FUNCTIONAL SYMBOL BACKSLASH BARAPL FUNCTIONAL SYMBOL QUAD SLA" +
	"SHAPL FUNCTIONAL SYMBOL QUAD BACKSLASHAPL FUNCTIONAL SYMBOL QUAD LESS-TH" +
	"ANAPL FUNCTIONAL SYMBOL QUAD GREATER-THANAPL FUNCTIONAL SYMBOL LEFTWARDS" +
	" VANEAPL FUNCTIONAL SYMBOL RIGHTWARDS VANEAPL FUNCTIONAL SYMBOL QUAD LEF" +
	"TWARDS ARROWAPL FUNCTIONAL SYMBOL QUAD RIGHTWARDS ARROWAPL FUNCTIONAL SY" +
	"MBOL CIRCLE BACKSLASHAPL FUNCTIONAL SYMBOL DOWN TACK UNDERBARAPL FUNCTIO" +
	"NAL SYMBOL DELTA STILEAPL FUNCTIONAL SYMBOL QUAD DOWN CARETAPL FUNCTIONA" +
	"L SYMBOL QUAD DELTAAPL FUNCTIONAL SYMBOL DOWN TACK JOTAPL FUNCTIONAL SYM" +
	"BOL UPWARDS VANEAPL FUNCTIONAL SYMBOL QUAD UPWARDS ARROWAPL FUNCTIONAL S" +
	"YMBOL UP TACK OVERBARAPL FUNCTIONAL SYMBOL DEL STILEAPL FUNCTIONAL SYMBO" +
	"L QUAD UP CARETAPL FUNCTIONAL SYMBOL QUAD DELAPL FUNCTIONAL SYMBOL UP TA" +
	"CK JOTAPL FUNCTIONAL SYMBOL DOWNWARDS VANEAPL FUNCTIONAL SYMBOL QUAD DOW" +
	"NWARDS ARROWAPL FUNCTIONAL SYMBOL QUOTE UNDERBARAPL FUNCTIONAL SYMBOL DE" +
	"LTA UNDERBARAPL FUNCTIONAL SYMBOL DIAMOND UNDERBARAPL FUNCTIONAL SYMBOL " +
	"JOT UNDERBARAPL FUNCTIONAL SYMBOL CIRCLE UNDERBARAPL FUNCTIONAL SYMBOL U" +
	"P SHOE JOTAPL FUNCTIONAL SYMBOL QUOTE QUADAPL FUNCTIONAL SYMBOL CIRCLE S" +
	"TARAPL FUNCTIONAL SYMBOL QUAD COLONAPL FUNCTIONAL SYMBOL UP TACK DIAERES" +
	"ISAPL FUNCTIONAL SYMBOL DEL DIAERESISAPL FUNCTIONAL SYMBOL STAR DIAERESI" +
	"SAPL FUNCTIONAL SYMBOL JOT DIAERESISAPL FUNCTIONAL SYMBOL CIRCLE DIAERES" +
	"ISAPL FUNCTIONAL SYMBOL DOWN SHOE STILEAPL FUNCTIONAL SYMBOL LEFT SHOE S" +
	"TILEAPL FUNCTIONAL SYMBOL TILDE DIAERESISAPL FUNCTIONAL SYMBOL GREATER-T" +
	"HAN DIAERESISAPL FUNCTIONAL SYMBOL COMMA BARAPL FUNCTIONAL SYMBOL DEL TI" +
	"LDEAPL FUNCTIONAL SYMBOL ZILDEAPL FUNCTIONAL SYMBOL STILE TILDEAPL FUNCT" +
	"IONAL SYMBOL SEMICOLON UNDERBARAPL FUNCTIONAL SYMBOL QUAD NOT EQUALAPL F" +
	"UNCTIONAL SYMBOL QUAD QUESTIONAPL FUNCTIONAL SYMBOL DOWN CARET TILDEAPL " +
	"FUNCTIONAL SYMBOL UP CARET TILDEAPL FUNCTIONAL SYMBOL IOTAAPL FUNCTIONAL" +
	" SYMBOL RHOAPL FUNCTIONAL SYMBOL OMEGAAPL FUNCTIONAL SYMBOL ALPHA UNDERB" +
	"ARAPL FUNCTIONAL SYMBOL EPSILON UNDERBARAPL FUNCTIONAL SYMBOL IOTA UNDER" +
	"BARAPL FUNCTIONAL SYMBOL OMEGA UNDERBARAPL FUNCTIONAL SYMBOL ALPHANOT CH" +
	"ECK MARKRIGHT ANGLE WITH DOWNWARDS ZIGZAG ARROWSHOULDERED OPEN BOXBELL S" +
	"YMBOLVERTICAL LINE WITH MIDDLE DOTINSERTION SYMBOLCONTINUOUS UNDERLINE S" +
	"YMBOLDISCONTINUOUS UNDERLINE SYMBOLEMPHASIS SYMBOLCOMPOSITION SYMBOLWHIT" +
	"E SQUARE WITH CENTRE VERTICAL LINEENTER SYMBOLALTERNATIVE KEY SYMBOLHELM" +
	" SYMBOLCIRCLED HORIZONTAL BAR WITH NOTCHCIRCLED TRIANGLE DOWNBROKEN CIRC") + ("" +
	"LE WITH NORTHWEST ARROWUNDO SYMBOLMONOSTABLE SYMBOLHYSTERESIS SYMBOLOPEN" +
	"-CIRCUIT-OUTPUT H-TYPE SYMBOLOPEN-CIRCUIT-OUTPUT L-TYPE SYMBOLPASSIVE-PU" +
	"LL-DOWN-OUTPUT SYMBOLPASSIVE-PULL-UP-OUTPUT SYMBOLDIRECT CURRENT SYMBOL " +
	"FORM TWOSOFTWARE-FUNCTION SYMBOLAPL FUNCTIONAL SYMBOL QUADDECIMAL SEPARA" +
	"TOR KEY SYMBOLPREVIOUS PAGENEXT PAGEPRINT SCREEN SYMBOLCLEAR SCREEN SYMB" +
	"OLLEFT PARENTHESIS UPPER HOOKLEFT PARENTHESIS EXTENSIONLEFT PARENTHESIS " +
	"LOWER HOOKRIGHT PARENTHESIS UPPER HOOKRIGHT PARENTHESIS EXTENSIONRIGHT P" +
	"ARENTHESIS LOWER HOOKLEFT SQUARE BRACKET UPPER CORNERLEFT SQUARE BRACKET" +
	" EXTENSIONLEFT SQUARE BRACKET LOWER CORNERRIGHT SQUARE BRACKET UPPER COR" +
	"NERRIGHT SQUARE BRACKET EXTENSIONRIGHT SQUARE BRACKET LOWER CORNERLEFT C" +
	"URLY BRACKET UPPER HOOKLEFT CURLY BRACKET MIDDLE PIECELEFT CURLY BRACKET" +
	" LOWER HOOKCURLY BRACKET EXTENSIONRIGHT CURLY BRACKET UPPER HOOKRIGHT CU" +
	"RLY BRACKET MIDDLE PIECERIGHT CURLY BRACKET LOWER HOOKINTEGRAL EXTENSION" +
	"HORIZONTAL LINE EXTENSIONUPPER LEFT OR LOWER RIGHT CURLY BRACKET SECTION" +
	"UPPER RIGHT OR LOWER LEFT CURLY BRACKET SECTIONSUMMATION TOPSUMMATION BO" +
	"TTOMTOP SQUARE BRACKETBOTTOM SQUARE BRACKETBOTTOM SQUARE BRACKET OVER TO" +
	"P SQUARE BRACKETRADICAL SYMBOL BOTTOMLEFT VERTICAL BOX LINERIGHT VERTICA" +
	"L BOX LINEHORIZONTAL SCAN LINE-1HORIZONTAL SCAN LINE-3HORIZONTAL SCAN LI" +
	"NE-7HORIZONTAL SCAN LINE-9DENTISTRY SYMBOL LIGHT VERTICAL AND TOP RIGHTD" +
	"ENTISTRY SYMBOL LIGHT VERTICAL AND BOTTOM RIGHTDENTISTRY SYMBOL LIGHT VE" +
	"RTICAL WITH CIRCLEDENTISTRY SYMBOL LIGHT DOWN AND HORIZONTAL WITH CIRCLE" +
	"DENTISTRY SYMBOL LIGHT UP AND HORIZONTAL WITH CIRCLEDENTISTRY SYMBOL LIG" +
	"HT VERTICAL WITH TRIANGLEDENTISTRY SYMBOL LIGHT DOWN AND HORIZONTAL WITH" +
	" TRIANGLEDENTISTRY SYMBOL LIGHT UP AND HORIZONTAL WITH TRIANGLEDENTISTRY" +
	" SYMBOL LIGHT VERTICAL AND WAVEDENTISTRY SYMBOL LIGHT DOWN AND HORIZONTA" +
	"L WITH WAVEDENTISTRY SYMBOL LIGHT UP AND HORIZONTAL WITH WAVEDENTISTRY S" +
	"YMBOL LIGHT DOWN AND HORIZONTALDENTISTRY SYMBOL LIGHT UP AND HORIZONTALD" +
	"ENTISTRY SYMBOL LIGHT VERTICAL AND TOP LEFTDENTISTRY SYMBOL LIGHT VERTIC" +
	"AL AND BOTTOM LEFTSQUARE FOOTRETURN SYMBOLEJECT SYMBOLVERTICAL LINE EXTE" +
	"NSIONMETRICAL BREVEMETRICAL LONG OVER SHORTMETRICAL SHORT OVER LONGMETRI" +
	"CAL LONG OVER TWO SHORTSMETRICAL TWO SHORTS OVER LONGMETRICAL TWO SHORTS" +
	" JOINEDMETRICAL TRISEMEMETRICAL TETRASEMEMETRICAL PENTASEMEEARTH GROUNDF" +
	"USETOP PARENTHESISBOTTOM PARENTHESISTOP CURLY BRACKETBOTTOM CURLY BRACKE" +
	"TTOP TORTOISE SHELL BRACKETBOTTOM TORTOISE SHELL BRACKETWHITE TRAPEZIUMB" +
	"ENZENE RING WITH CIRCLESTRAIGHTNESSFLATNESSAC CURRENTELECTRICAL INTERSEC" +
	"TIONDECIMAL EXPONENT SYMBOLBLACK RIGHT-POINTING DOUBLE TRIANGLEBLACK LEF" +
	"T-POINTING DOUBLE TRIANGLEBLACK UP-POINTING DOUBLE TRIANGLEBLACK DOWN-PO" +
	"INTING DOUBLE TRIANGLEBLACK RIGHT-POINTING DOUBLE TRIANGLE WITH VERTICAL" +
	" BARBLACK LEFT-POINTING DOUBLE TRIANGLE WITH VERTICAL BARBLACK RIGHT-POI" +
	"NTING TRIANGLE WITH DOUBLE VERTICAL BARALARM CLOCKSTOPWATCHTIMER CLOCKHO" +
	"URGLASS WITH FLOWING SANDBLACK MEDIUM LEFT-POINTING TRIANGLEBLACK MEDIUM" +
	" RIGHT-POINTING TRIANGLEBLACK MEDIUM UP-POINTING TRIANGLEBLACK MEDIUM DO" +
	"WN-POINTING TRIANGLEDOUBLE VERTICAL BARBLACK SQUARE FOR STOPBLACK CIRCLE" +
	" FOR RECORDPOWER SYMBOLPOWER ON-OFF SYMBOLPOWER ON SYMBOLPOWER SLEEP SYM" +
	"BOLOBSERVER EYE SYMBOLSYMBOL FOR NULLSYMBOL FOR START OF HEADINGSYMBOL F" +
	"OR START OF TEXTSYMBOL FOR END OF TEXTSYMBOL FOR END OF TRANSMISSIONSYMB" +
	"OL FOR ENQUIRYSYMBOL FOR ACKNOWLEDGESYMBOL FOR BELLSYMBOL FOR BACKSPACES" +
	"YMBOL FOR HORIZONTAL TABULATIONSYMBOL FOR LINE FEEDSYMBOL FOR VERTICAL T" +
	"ABULATIONSYMBOL FOR FORM FEEDSYMBOL FOR CARRIAGE RETURNSYMBOL FOR SHIFT " +
	"OUTSYMBOL FOR SHIFT INSYMBOL FOR DATA LINK ESCAPESYMBOL FOR DEVICE CONTR" +
	"OL ONESYMBOL FOR DEVICE CONTROL TWOSYMBOL FOR DEVICE CONTROL THREESYMBOL" +
	" FOR DEVICE CONTROL FOURSYMBOL FOR NEGATIVE ACKNOWLEDGESYMBOL FOR SYNCHR" +
	"ONOUS IDLESYMBOL FOR END OF TRANSMISSION BLOCKSYMBOL FOR CANCELSYMBOL FO" +
	"R END OF MEDIUMSYMBOL FOR SUBSTITUTESYMBOL FOR ESCAPESYMBOL FOR FILE SEP" +
	"ARATORSYMBOL FOR GROUP SEPARATORSYMBOL FOR RECORD SEPARATORSYMBOL FOR UN" +
	"IT SEPARATORSYMBOL FOR SPACESYMBOL FOR DELETEBLANK SYMBOLOPEN BOXSYMBOL " +
	"FOR NEWLINESYMBOL FOR DELETE FORM TWOSYMBOL FOR SUBSTITUTE FORM TWOOCR H" +
	"OOKOCR CHAIROCR FORKOCR INVERTED FORKOCR BELT BUCKLEOCR BOW TIEOCR BRANC" +
	"H BANK IDENTIFICATIONOCR AMOUNT OF CHECKOCR DASHOCR CUSTOMER ACCOUNT NUM" +
	"BEROCR DOUBLE BACKSLASHCIRCLED DIGIT ONECIRCLED DIGIT TWOCIRCLED DIGIT T" +
	"HREECIRCLED DIGIT FOURCIRCLED DIGIT FIVECIRCLED DIGIT SIXCIRCLED DIGIT S" +
	"EVENCIRCLED DIGIT EIGHTCIRCLED DIGIT NINECIRCLED NUMBER TENCIRCLED NUMBE" +
	"R ELEVENCIRCLED NUMBER TWELVECIRCLED NUMBER THIRTEENCIRCLED NUMBER FOURT" +
	"EENCIRCLED NUMBER FIFTEENCIRCLED NUMBER SIXTEENCIRCLED NUMBER SEVENTEENC") + ("" +
	"IRCLED NUMBER EIGHTEENCIRCLED NUMBER NINETEENCIRCLED NUMBER TWENTYPARENT" +
	"HESIZED DIGIT ONEPARENTHESIZED DIGIT TWOPARENTHESIZED DIGIT THREEPARENTH" +
	"ESIZED DIGIT FOURPARENTHESIZED DIGIT FIVEPARENTHESIZED DIGIT SIXPARENTHE" +
	"SIZED DIGIT SEVENPARENTHESIZED DIGIT EIGHTPARENTHESIZED DIGIT NINEPARENT" +
	"HESIZED NUMBER TENPARENTHESIZED NUMBER ELEVENPARENTHESIZED NUMBER TWELVE" +
	"PARENTHESIZED NUMBER THIRTEENPARENTHESIZED NUMBER FOURTEENPARENTHESIZED " +
	"NUMBER FIFTEENPARENTHESIZED NUMBER SIXTEENPARENTHESIZED NUMBER SEVENTEEN" +
	"PARENTHESIZED NUMBER EIGHTEENPARENTHESIZED NUMBER NINETEENPARENTHESIZED " +
	"NUMBER TWENTYDIGIT ONE FULL STOPDIGIT TWO FULL STOPDIGIT THREE FULL STOP" +
	"DIGIT FOUR FULL STOPDIGIT FIVE FULL STOPDIGIT SIX FULL STOPDIGIT SEVEN F" +
	"ULL STOPDIGIT EIGHT FULL STOPDIGIT NINE FULL STOPNUMBER TEN FULL STOPNUM" +
	"BER ELEVEN FULL STOPNUMBER TWELVE FULL STOPNUMBER THIRTEEN FULL STOPNUMB" +
	"ER FOURTEEN FULL STOPNUMBER FIFTEEN FULL STOPNUMBER SIXTEEN FULL STOPNUM" +
	"BER SEVENTEEN FULL STOPNUMBER EIGHTEEN FULL STOPNUMBER NINETEEN FULL STO" +
	"PNUMBER TWENTY FULL STOPPARENTHESIZED LATIN SMALL LETTER APARENTHESIZED " +
	"LATIN SMALL LETTER BPARENTHESIZED LATIN SMALL LETTER CPARENTHESIZED LATI" +
	"N SMALL LETTER DPARENTHESIZED LATIN SMALL LETTER EPARENTHESIZED LATIN SM" +
	"ALL LETTER FPARENTHESIZED LATIN SMALL LETTER GPARENTHESIZED LATIN SMALL " +
	"LETTER HPARENTHESIZED LATIN SMALL LETTER IPARENTHESIZED LATIN SMALL LETT" +
	"ER JPARENTHESIZED LATIN SMALL LETTER KPARENTHESIZED LATIN SMALL LETTER L" +
	"PARENTHESIZED LATIN SMALL LETTER MPARENTHESIZED LATIN SMALL LETTER NPARE" +
	"NTHESIZED LATIN SMALL LETTER OPARENTHESIZED LATIN SMALL LETTER PPARENTHE" +
	"SIZED LATIN SMALL LETTER QPARENTHESIZED LATIN SMALL LETTER RPARENTHESIZE" +
	"D LATIN SMALL LETTER SPARENTHESIZED LATIN SMALL LETTER TPARENTHESIZED LA" +
	"TIN SMALL LETTER UPARENTHESIZED LATIN SMALL LETTER VPARENTHESIZED LATIN " +
	"SMALL LETTER WPARENTHESIZED LATIN SMALL LETTER XPARENTHESIZED LATIN SMAL" +
	"L LETTER YPARENTHESIZED LATIN SMALL LETTER ZCIRCLED LATIN CAPITAL LETTER" +
	" ACIRCLED LATIN CAPITAL LETTER BCIRCLED LATIN CAPITAL LETTER CCIRCLED LA" +
	"TIN CAPITAL LETTER DCIRCLED LATIN CAPITAL LETTER ECIRCLED LATIN CAPITAL " +
	"LETTER FCIRCLED LATIN CAPITAL LETTER GCIRCLED LATIN CAPITAL LETTER HCIRC" +
	"LED LATIN CAPITAL LETTER ICIRCLED LATIN CAPITAL LETTER JCIRCLED LATIN CA" +
	"PITAL LETTER KCIRCLED LATIN CAPITAL LETTER LCIRCLED LATIN CAPITAL LETTER" +
	" MCIRCLED LATIN CAPITAL LETTER NCIRCLED LATIN CAPITAL LETTER OCIRCLED LA" +
	"TIN CAPITAL LETTER PCIRCLED LATIN CAPITAL LETTER QCIRCLED LATIN CAPITAL " +
	"LETTER RCIRCLED LATIN CAPITAL LETTER SCIRCLED LATIN CAPITAL LETTER TCIRC" +
	"LED LATIN CAPITAL LETTER UCIRCLED LATIN CAPITAL LETTER VCIRCLED LATIN CA" +
	"PITAL LETTER WCIRCLED LATIN CAPITAL LETTER XCIRCLED LATIN CAPITAL LETTER" +
	" YCIRCLED LATIN CAPITAL LETTER ZCIRCLED LATIN SMALL LETTER ACIRCLED LATI" +
	"N SMALL LETTER BCIRCLED LATIN SMALL LETTER CCIRCLED LATIN SMALL LETTER D" +
	"CIRCLED LATIN SMALL LETTER ECIRCLED LATIN SMALL LETTER FCIRCLED LATIN SM" +
	"ALL LETTER GCIRCLED LATIN SMALL LETTER HCIRCLED LATIN SMALL LETTER ICIRC" +
	"LED LATIN SMALL LETTER JCIRCLED LATIN SMALL LETTER KCIRCLED LATIN SMALL " +
	"LETTER LCIRCLED LATIN SMALL LETTER MCIRCLED LATIN SMALL LETTER NCIRCLED " +
	"LATIN SMALL LETTER OCIRCLED LATIN SMALL LETTER PCIRCLED LATIN SMALL LETT" +
	"ER QCIRCLED LATIN SMALL LETTER RCIRCLED LATIN SMALL LETTER SCIRCLED LATI" +
	"N SMALL LETTER TCIRCLED LATIN SMALL LETTER UCIRCLED LATIN SMALL LETTER V" +
	"CIRCLED LATIN SMALL LETTER WCIRCLED LATIN SMALL LETTER XCIRCLED LATIN SM" +
	"ALL LETTER YCIRCLED LATIN SMALL LETTER ZCIRCLED DIGIT ZERONEGATIVE CIRCL" +
	"ED NUMBER ELEVENNEGATIVE CIRCLED NUMBER TWELVENEGATIVE CIRCLED NUMBER TH" +
	"IRTEENNEGATIVE CIRCLED NUMBER FOURTEENNEGATIVE CIRCLED NUMBER FIFTEENNEG" +
	"ATIVE CIRCLED NUMBER SIXTEENNEGATIVE CIRCLED NUMBER SEVENTEENNEGATIVE CI" +
	"RCLED NUMBER EIGHTEENNEGATIVE CIRCLED NUMBER NINETEENNEGATIVE CIRCLED NU" +
	"MBER TWENTYDOUBLE CIRCLED DIGIT ONEDOUBLE CIRCLED DIGIT TWODOUBLE CIRCLE" +
	"D DIGIT THREEDOUBLE CIRCLED DIGIT FOURDOUBLE CIRCLED DIGIT FIVEDOUBLE CI" +
	"RCLED DIGIT SIXDOUBLE CIRCLED DIGIT SEVENDOUBLE CIRCLED DIGIT EIGHTDOUBL" +
	"E CIRCLED DIGIT NINEDOUBLE CIRCLED NUMBER TENNEGATIVE CIRCLED DIGIT ZERO" +
	"BOX DRAWINGS LIGHT HORIZONTALBOX DRAWINGS HEAVY HORIZONTALBOX DRAWINGS L" +
	"IGHT VERTICALBOX DRAWINGS HEAVY VERTICALBOX DRAWINGS LIGHT TRIPLE DASH H" +
	"ORIZONTALBOX DRAWINGS HEAVY TRIPLE DASH HORIZONTALBOX DRAWINGS LIGHT TRI" +
	"PLE DASH VERTICALBOX DRAWINGS HEAVY TRIPLE DASH VERTICALBOX DRAWINGS LIG" +
	"HT QUADRUPLE DASH HORIZONTALBOX DRAWINGS HEAVY QUADRUPLE DASH HORIZONTAL" +
	"BOX DRAWINGS LIGHT QUADRUPLE DASH VERTICALBOX DRAWINGS HEAVY QUADRUPLE D" +
	"ASH VERTICALBOX DRAWINGS LIGHT DOWN AND RIGHTBOX DRAWINGS DOWN LIGHT AND" +
	" RIGHT HEAVYBOX DRAWINGS DOWN HEAVY AND RIGHT LIGHTBOX DRAWINGS HEAVY DO") + ("" +
	"WN AND RIGHTBOX DRAWINGS LIGHT DOWN AND LEFTBOX DRAWINGS DOWN LIGHT AND " +
	"LEFT HEAVYBOX DRAWINGS DOWN HEAVY AND LEFT LIGHTBOX DRAWINGS HEAVY DOWN " +
	"AND LEFTBOX DRAWINGS LIGHT UP AND RIGHTBOX DRAWINGS UP LIGHT AND RIGHT H" +
	"EAVYBOX DRAWINGS UP HEAVY AND RIGHT LIGHTBOX DRAWINGS HEAVY UP AND RIGHT" +
	"BOX DRAWINGS LIGHT UP AND LEFTBOX DRAWINGS UP LIGHT AND LEFT HEAVYBOX DR" +
	"AWINGS UP HEAVY AND LEFT LIGHTBOX DRAWINGS HEAVY UP AND LEFTBOX DRAWINGS" +
	" LIGHT VERTICAL AND RIGHTBOX DRAWINGS VERTICAL LIGHT AND RIGHT HEAVYBOX " +
	"DRAWINGS UP HEAVY AND RIGHT DOWN LIGHTBOX DRAWINGS DOWN HEAVY AND RIGHT " +
	"UP LIGHTBOX DRAWINGS VERTICAL HEAVY AND RIGHT LIGHTBOX DRAWINGS DOWN LIG" +
	"HT AND RIGHT UP HEAVYBOX DRAWINGS UP LIGHT AND RIGHT DOWN HEAVYBOX DRAWI" +
	"NGS HEAVY VERTICAL AND RIGHTBOX DRAWINGS LIGHT VERTICAL AND LEFTBOX DRAW" +
	"INGS VERTICAL LIGHT AND LEFT HEAVYBOX DRAWINGS UP HEAVY AND LEFT DOWN LI" +
	"GHTBOX DRAWINGS DOWN HEAVY AND LEFT UP LIGHTBOX DRAWINGS VERTICAL HEAVY " +
	"AND LEFT LIGHTBOX DRAWINGS DOWN LIGHT AND LEFT UP HEAVYBOX DRAWINGS UP L" +
	"IGHT AND LEFT DOWN HEAVYBOX DRAWINGS HEAVY VERTICAL AND LEFTBOX DRAWINGS" +
	" LIGHT DOWN AND HORIZONTALBOX DRAWINGS LEFT HEAVY AND RIGHT DOWN LIGHTBO" +
	"X DRAWINGS RIGHT HEAVY AND LEFT DOWN LIGHTBOX DRAWINGS DOWN LIGHT AND HO" +
	"RIZONTAL HEAVYBOX DRAWINGS DOWN HEAVY AND HORIZONTAL LIGHTBOX DRAWINGS R" +
	"IGHT LIGHT AND LEFT DOWN HEAVYBOX DRAWINGS LEFT LIGHT AND RIGHT DOWN HEA" +
	"VYBOX DRAWINGS HEAVY DOWN AND HORIZONTALBOX DRAWINGS LIGHT UP AND HORIZO" +
	"NTALBOX DRAWINGS LEFT HEAVY AND RIGHT UP LIGHTBOX DRAWINGS RIGHT HEAVY A" +
	"ND LEFT UP LIGHTBOX DRAWINGS UP LIGHT AND HORIZONTAL HEAVYBOX DRAWINGS U" +
	"P HEAVY AND HORIZONTAL LIGHTBOX DRAWINGS RIGHT LIGHT AND LEFT UP HEAVYBO" +
	"X DRAWINGS LEFT LIGHT AND RIGHT UP HEAVYBOX DRAWINGS HEAVY UP AND HORIZO" +
	"NTALBOX DRAWINGS LIGHT VERTICAL AND HORIZONTALBOX DRAWINGS LEFT HEAVY AN" +
	"D RIGHT VERTICAL LIGHTBOX DRAWINGS RIGHT HEAVY AND LEFT VERTICAL LIGHTBO" +
	"X DRAWINGS VERTICAL LIGHT AND HORIZONTAL HEAVYBOX DRAWINGS UP HEAVY AND " +
	"DOWN HORIZONTAL LIGHTBOX DRAWINGS DOWN HEAVY AND UP HORIZONTAL LIGHTBOX " +
	"DRAWINGS VERTICAL HEAVY AND HORIZONTAL LIGHTBOX DRAWINGS LEFT UP HEAVY A" +
	"ND RIGHT DOWN LIGHTBOX DRAWINGS RIGHT UP HEAVY AND LEFT DOWN LIGHTBOX DR" +
	"AWINGS LEFT DOWN HEAVY AND RIGHT UP LIGHTBOX DRAWINGS RIGHT DOWN HEAVY A" +
	"ND LEFT UP LIGHTBOX DRAWINGS DOWN LIGHT AND UP HORIZONTAL HEAVYBOX DRAWI" +
	"NGS UP LIGHT AND DOWN HORIZONTAL HEAVYBOX DRAWINGS RIGHT LIGHT AND LEFT " +
	"VERTICAL HEAVYBOX DRAWINGS LEFT LIGHT AND RIGHT VERTICAL HEAVYBOX DRAWIN" +
	"GS HEAVY VERTICAL AND HORIZONTALBOX DRAWINGS LIGHT DOUBLE DASH HORIZONTA" +
	"LBOX DRAWINGS HEAVY DOUBLE DASH HORIZONTALBOX DRAWINGS LIGHT DOUBLE DASH" +
	" VERTICALBOX DRAWINGS HEAVY DOUBLE DASH VERTICALBOX DRAWINGS DOUBLE HORI" +
	"ZONTALBOX DRAWINGS DOUBLE VERTICALBOX DRAWINGS DOWN SINGLE AND RIGHT DOU" +
	"BLEBOX DRAWINGS DOWN DOUBLE AND RIGHT SINGLEBOX DRAWINGS DOUBLE DOWN AND" +
	" RIGHTBOX DRAWINGS DOWN SINGLE AND LEFT DOUBLEBOX DRAWINGS DOWN DOUBLE A" +
	"ND LEFT SINGLEBOX DRAWINGS DOUBLE DOWN AND LEFTBOX DRAWINGS UP SINGLE AN" +
	"D RIGHT DOUBLEBOX DRAWINGS UP DOUBLE AND RIGHT SINGLEBOX DRAWINGS DOUBLE" +
	" UP AND RIGHTBOX DRAWINGS UP SINGLE AND LEFT DOUBLEBOX DRAWINGS UP DOUBL" +
	"E AND LEFT SINGLEBOX DRAWINGS DOUBLE UP AND LEFTBOX DRAWINGS VERTICAL SI" +
	"NGLE AND RIGHT DOUBLEBOX DRAWINGS VERTICAL DOUBLE AND RIGHT SINGLEBOX DR" +
	"AWINGS DOUBLE VERTICAL AND RIGHTBOX DRAWINGS VERTICAL SINGLE AND LEFT DO" +
	"UBLEBOX DRAWINGS VERTICAL DOUBLE AND LEFT SINGLEBOX DRAWINGS DOUBLE VERT" +
	"ICAL AND LEFTBOX DRAWINGS DOWN SINGLE AND HORIZONTAL DOUBLEBOX DRAWINGS " +
	"DOWN DOUBLE AND HORIZONTAL SINGLEBOX DRAWINGS DOUBLE DOWN AND HORIZONTAL" +
	"BOX DRAWINGS UP SINGLE AND HORIZONTAL DOUBLEBOX DRAWINGS UP DOUBLE AND H" +
	"ORIZONTAL SINGLEBOX DRAWINGS DOUBLE UP AND HORIZONTALBOX DRAWINGS VERTIC" +
	"AL SINGLE AND HORIZONTAL DOUBLEBOX DRAWINGS VERTICAL DOUBLE AND HORIZONT" +
	"AL SINGLEBOX DRAWINGS DOUBLE VERTICAL AND HORIZONTALBOX DRAWINGS LIGHT A" +
	"RC DOWN AND RIGHTBOX DRAWINGS LIGHT ARC DOWN AND LEFTBOX DRAWINGS LIGHT " +
	"ARC UP AND LEFTBOX DRAWINGS LIGHT ARC UP AND RIGHTBOX DRAWINGS LIGHT DIA" +
	"GONAL UPPER RIGHT TO LOWER LEFTBOX DRAWINGS LIGHT DIAGONAL UPPER LEFT TO" +
	" LOWER RIGHTBOX DRAWINGS LIGHT DIAGONAL CROSSBOX DRAWINGS LIGHT LEFTBOX " +
	"DRAWINGS LIGHT UPBOX DRAWINGS LIGHT RIGHTBOX DRAWINGS LIGHT DOWNBOX DRAW" +
	"INGS HEAVY LEFTBOX DRAWINGS HEAVY UPBOX DRAWINGS HEAVY RIGHTBOX DRAWINGS" +
	" HEAVY DOWNBOX DRAWINGS LIGHT LEFT AND HEAVY RIGHTBOX DRAWINGS LIGHT UP " +
	"AND HEAVY DOWNBOX DRAWINGS HEAVY LEFT AND LIGHT RIGHTBOX DRAWINGS HEAVY " +
	"UP AND LIGHT DOWNUPPER HALF BLOCKLOWER ONE EIGHTH BLOCKLOWER ONE QUARTER" +
	" BLOCKLOWER THREE EIGHTHS BLOCKLOWER HALF BLOCKLOWER FIVE EIGHTHS BLOCKL" +
	"OWER THREE QUARTERS BLOCKLOWER SEVEN EIGHTHS BLOCKFULL BLOCKLEFT SEVEN E") + ("" +
	"IGHTHS BLOCKLEFT THREE QUARTERS BLOCKLEFT FIVE EIGHTHS BLOCKLEFT HALF BL" +
	"OCKLEFT THREE EIGHTHS BLOCKLEFT ONE QUARTER BLOCKLEFT ONE EIGHTH BLOCKRI" +
	"GHT HALF BLOCKLIGHT SHADEMEDIUM SHADEDARK SHADEUPPER ONE EIGHTH BLOCKRIG" +
	"HT ONE EIGHTH BLOCKQUADRANT LOWER LEFTQUADRANT LOWER RIGHTQUADRANT UPPER" +
	" LEFTQUADRANT UPPER LEFT AND LOWER LEFT AND LOWER RIGHTQUADRANT UPPER LE" +
	"FT AND LOWER RIGHTQUADRANT UPPER LEFT AND UPPER RIGHT AND LOWER LEFTQUAD" +
	"RANT UPPER LEFT AND UPPER RIGHT AND LOWER RIGHTQUADRANT UPPER RIGHTQUADR" +
	"ANT UPPER RIGHT AND LOWER LEFTQUADRANT UPPER RIGHT AND LOWER LEFT AND LO" +
	"WER RIGHTBLACK SQUAREWHITE SQUAREWHITE SQUARE WITH ROUNDED CORNERSWHITE " +
	"SQUARE CONTAINING BLACK SMALL SQUARESQUARE WITH HORIZONTAL FILLSQUARE WI" +
	"TH VERTICAL FILLSQUARE WITH ORTHOGONAL CROSSHATCH FILLSQUARE WITH UPPER " +
	"LEFT TO LOWER RIGHT FILLSQUARE WITH UPPER RIGHT TO LOWER LEFT FILLSQUARE" +
	" WITH DIAGONAL CROSSHATCH FILLBLACK SMALL SQUAREWHITE SMALL SQUAREBLACK " +
	"RECTANGLEWHITE RECTANGLEBLACK VERTICAL RECTANGLEWHITE VERTICAL RECTANGLE" +
	"BLACK PARALLELOGRAMWHITE PARALLELOGRAMBLACK UP-POINTING TRIANGLEWHITE UP" +
	"-POINTING TRIANGLEBLACK UP-POINTING SMALL TRIANGLEWHITE UP-POINTING SMAL" +
	"L TRIANGLEBLACK RIGHT-POINTING TRIANGLEWHITE RIGHT-POINTING TRIANGLEBLAC" +
	"K RIGHT-POINTING SMALL TRIANGLEWHITE RIGHT-POINTING SMALL TRIANGLEBLACK " +
	"RIGHT-POINTING POINTERWHITE RIGHT-POINTING POINTERBLACK DOWN-POINTING TR" +
	"IANGLEWHITE DOWN-POINTING TRIANGLEBLACK DOWN-POINTING SMALL TRIANGLEWHIT" +
	"E DOWN-POINTING SMALL TRIANGLEBLACK LEFT-POINTING TRIANGLEWHITE LEFT-POI" +
	"NTING TRIANGLEBLACK LEFT-POINTING SMALL TRIANGLEWHITE LEFT-POINTING SMAL" +
	"L TRIANGLEBLACK LEFT-POINTING POINTERWHITE LEFT-POINTING POINTERBLACK DI" +
	"AMONDWHITE DIAMONDWHITE DIAMOND CONTAINING BLACK SMALL DIAMONDFISHEYELOZ" +
	"ENGEWHITE CIRCLEDOTTED CIRCLECIRCLE WITH VERTICAL FILLBULLSEYEBLACK CIRC" +
	"LECIRCLE WITH LEFT HALF BLACKCIRCLE WITH RIGHT HALF BLACKCIRCLE WITH LOW" +
	"ER HALF BLACKCIRCLE WITH UPPER HALF BLACKCIRCLE WITH UPPER RIGHT QUADRAN" +
	"T BLACKCIRCLE WITH ALL BUT UPPER LEFT QUADRANT BLACKLEFT HALF BLACK CIRC" +
	"LERIGHT HALF BLACK CIRCLEINVERSE BULLETINVERSE WHITE CIRCLEUPPER HALF IN" +
	"VERSE WHITE CIRCLELOWER HALF INVERSE WHITE CIRCLEUPPER LEFT QUADRANT CIR" +
	"CULAR ARCUPPER RIGHT QUADRANT CIRCULAR ARCLOWER RIGHT QUADRANT CIRCULAR " +
	"ARCLOWER LEFT QUADRANT CIRCULAR ARCUPPER HALF CIRCLELOWER HALF CIRCLEBLA" +
	"CK LOWER RIGHT TRIANGLEBLACK LOWER LEFT TRIANGLEBLACK UPPER LEFT TRIANGL" +
	"EBLACK UPPER RIGHT TRIANGLEWHITE BULLETSQUARE WITH LEFT HALF BLACKSQUARE" +
	" WITH RIGHT HALF BLACKSQUARE WITH UPPER LEFT DIAGONAL HALF BLACKSQUARE W" +
	"ITH LOWER RIGHT DIAGONAL HALF BLACKWHITE SQUARE WITH VERTICAL BISECTING " +
	"LINEWHITE UP-POINTING TRIANGLE WITH DOTUP-POINTING TRIANGLE WITH LEFT HA" +
	"LF BLACKUP-POINTING TRIANGLE WITH RIGHT HALF BLACKLARGE CIRCLEWHITE SQUA" +
	"RE WITH UPPER LEFT QUADRANTWHITE SQUARE WITH LOWER LEFT QUADRANTWHITE SQ" +
	"UARE WITH LOWER RIGHT QUADRANTWHITE SQUARE WITH UPPER RIGHT QUADRANTWHIT" +
	"E CIRCLE WITH UPPER LEFT QUADRANTWHITE CIRCLE WITH LOWER LEFT QUADRANTWH" +
	"ITE CIRCLE WITH LOWER RIGHT QUADRANTWHITE CIRCLE WITH UPPER RIGHT QUADRA" +
	"NTUPPER LEFT TRIANGLEUPPER RIGHT TRIANGLELOWER LEFT TRIANGLEWHITE MEDIUM" +
	" SQUAREBLACK MEDIUM SQUAREWHITE MEDIUM SMALL SQUAREBLACK MEDIUM SMALL SQ" +
	"UARELOWER RIGHT TRIANGLEBLACK SUN WITH RAYSCLOUDUMBRELLASNOWMANCOMETBLAC" +
	"K STARWHITE STARLIGHTNINGTHUNDERSTORMSUNASCENDING NODEDESCENDING NODECON" +
	"JUNCTIONOPPOSITIONBLACK TELEPHONEWHITE TELEPHONEBALLOT BOXBALLOT BOX WIT" +
	"H CHECKBALLOT BOX WITH XSALTIREUMBRELLA WITH RAIN DROPSHOT BEVERAGEWHITE" +
	" SHOGI PIECEBLACK SHOGI PIECESHAMROCKREVERSED ROTATED FLORAL HEART BULLE" +
	"TBLACK LEFT POINTING INDEXBLACK RIGHT POINTING INDEXWHITE LEFT POINTING " +
	"INDEXWHITE UP POINTING INDEXWHITE RIGHT POINTING INDEXWHITE DOWN POINTIN" +
	"G INDEXSKULL AND CROSSBONESCAUTION SIGNRADIOACTIVE SIGNBIOHAZARD SIGNCAD" +
	"UCEUSANKHORTHODOX CROSSCHI RHOCROSS OF LORRAINECROSS OF JERUSALEMSTAR AN" +
	"D CRESCENTFARSI SYMBOLADI SHAKTIHAMMER AND SICKLEPEACE SYMBOLYIN YANGTRI" +
	"GRAM FOR HEAVENTRIGRAM FOR LAKETRIGRAM FOR FIRETRIGRAM FOR THUNDERTRIGRA" +
	"M FOR WINDTRIGRAM FOR WATERTRIGRAM FOR MOUNTAINTRIGRAM FOR EARTHWHEEL OF" +
	" DHARMAWHITE FROWNING FACEWHITE SMILING FACEBLACK SMILING FACEWHITE SUN " +
	"WITH RAYSFIRST QUARTER MOONLAST QUARTER MOONMERCURYFEMALE SIGNEARTHMALE " +
	"SIGNJUPITERSATURNURANUSNEPTUNEPLUTOARIESTAURUSGEMINICANCERLEOVIRGOLIBRAS" +
	"CORPIUSSAGITTARIUSCAPRICORNAQUARIUSPISCESWHITE CHESS KINGWHITE CHESS QUE" +
	"ENWHITE CHESS ROOKWHITE CHESS BISHOPWHITE CHESS KNIGHTWHITE CHESS PAWNBL" +
	"ACK CHESS KINGBLACK CHESS QUEENBLACK CHESS ROOKBLACK CHESS BISHOPBLACK C" +
	"HESS KNIGHTBLACK CHESS PAWNBLACK SPADE SUITWHITE HEART SUITWHITE DIAMOND" +
	" SUITBLACK CLUB SUITWHITE SPADE SUITBLACK HEART SUITBLACK DIAMOND SUITWH") + ("" +
	"ITE CLUB SUITHOT SPRINGSQUARTER NOTEEIGHTH NOTEBEAMED EIGHTH NOTESBEAMED" +
	" SIXTEENTH NOTESMUSIC FLAT SIGNMUSIC NATURAL SIGNMUSIC SHARP SIGNWEST SY" +
	"RIAC CROSSEAST SYRIAC CROSSUNIVERSAL RECYCLING SYMBOLRECYCLING SYMBOL FO" +
	"R TYPE-1 PLASTICSRECYCLING SYMBOL FOR TYPE-2 PLASTICSRECYCLING SYMBOL FO" +
	"R TYPE-3 PLASTICSRECYCLING SYMBOL FOR TYPE-4 PLASTICSRECYCLING SYMBOL FO" +
	"R TYPE-5 PLASTICSRECYCLING SYMBOL FOR TYPE-6 PLASTICSRECYCLING SYMBOL FO" +
	"R TYPE-7 PLASTICSRECYCLING SYMBOL FOR GENERIC MATERIALSBLACK UNIVERSAL R" +
	"ECYCLING SYMBOLRECYCLED PAPER SYMBOLPARTIALLY-RECYCLED PAPER SYMBOLPERMA" +
	"NENT PAPER SIGNWHEELCHAIR SYMBOLDIE FACE-1DIE FACE-2DIE FACE-3DIE FACE-4" +
	"DIE FACE-5DIE FACE-6WHITE CIRCLE WITH DOT RIGHTWHITE CIRCLE WITH TWO DOT" +
	"SBLACK CIRCLE WITH WHITE DOT RIGHTBLACK CIRCLE WITH TWO WHITE DOTSMONOGR" +
	"AM FOR YANGMONOGRAM FOR YINDIGRAM FOR GREATER YANGDIGRAM FOR LESSER YIND" +
	"IGRAM FOR LESSER YANGDIGRAM FOR GREATER YINWHITE FLAGBLACK FLAGHAMMER AN" +
	"D PICKANCHORCROSSED SWORDSSTAFF OF AESCULAPIUSSCALESALEMBICFLOWERGEARSTA" +
	"FF OF HERMESATOM SYMBOLFLEUR-DE-LISOUTLINED WHITE STARTHREE LINES CONVER" +
	"GING RIGHTTHREE LINES CONVERGING LEFTWARNING SIGNHIGH VOLTAGE SIGNDOUBLE" +
	"D FEMALE SIGNDOUBLED MALE SIGNINTERLOCKED FEMALE AND MALE SIGNMALE AND F" +
	"EMALE SIGNMALE WITH STROKE SIGNMALE WITH STROKE AND MALE AND FEMALE SIGN" +
	"VERTICAL MALE WITH STROKE SIGNHORIZONTAL MALE WITH STROKE SIGNMEDIUM WHI" +
	"TE CIRCLEMEDIUM BLACK CIRCLEMEDIUM SMALL WHITE CIRCLEMARRIAGE SYMBOLDIVO" +
	"RCE SYMBOLUNMARRIED PARTNERSHIP SYMBOLCOFFINFUNERAL URNNEUTERCERESPALLAS" +
	"JUNOVESTACHIRONBLACK MOON LILITHSEXTILESEMISEXTILEQUINCUNXSESQUIQUADRATE" +
	"SOCCER BALLBASEBALLSQUARED KEYWHITE DRAUGHTS MANWHITE DRAUGHTS KINGBLACK" +
	" DRAUGHTS MANBLACK DRAUGHTS KINGSNOWMAN WITHOUT SNOWSUN BEHIND CLOUDRAIN" +
	"BLACK SNOWMANTHUNDER CLOUD AND RAINTURNED WHITE SHOGI PIECETURNED BLACK " +
	"SHOGI PIECEWHITE DIAMOND IN SQUARECROSSING LANESDISABLED CAROPHIUCHUSPIC" +
	"KCAR SLIDINGHELMET WITH WHITE CROSSCIRCLED CROSSING LANESCHAINSNO ENTRYA" +
	"LTERNATE ONE-WAY LEFT WAY TRAFFICBLACK TWO-WAY LEFT WAY TRAFFICWHITE TWO" +
	"-WAY LEFT WAY TRAFFICBLACK LEFT LANE MERGEWHITE LEFT LANE MERGEDRIVE SLO" +
	"W SIGNHEAVY WHITE DOWN-POINTING TRIANGLELEFT CLOSED ENTRYSQUARED SALTIRE" +
	"FALLING DIAGONAL IN WHITE CIRCLE IN BLACK SQUAREBLACK TRUCKRESTRICTED LE" +
	"FT ENTRY-1RESTRICTED LEFT ENTRY-2ASTRONOMICAL SYMBOL FOR URANUSHEAVY CIR" +
	"CLE WITH STROKE AND TWO DOTS ABOVEPENTAGRAMRIGHT-HANDED INTERLACED PENTA" +
	"GRAMLEFT-HANDED INTERLACED PENTAGRAMINVERTED PENTAGRAMBLACK CROSS ON SHI" +
	"ELDSHINTO SHRINECHURCHCASTLEHISTORIC SITEGEAR WITHOUT HUBGEAR WITH HANDL" +
	"ESMAP SYMBOL FOR LIGHTHOUSEMOUNTAINUMBRELLA ON GROUNDFOUNTAINFLAG IN HOL" +
	"EFERRYSAILBOATSQUARE FOUR CORNERSSKIERICE SKATEPERSON WITH BALLTENTJAPAN" +
	"ESE BANK SYMBOLHEADSTONE GRAVEYARD SYMBOLFUEL PUMPCUP ON BLACK SQUAREWHI" +
	"TE FLAG WITH HORIZONTAL MIDDLE BLACK STRIPEBLACK SAFETY SCISSORSUPPER BL" +
	"ADE SCISSORSBLACK SCISSORSLOWER BLADE SCISSORSWHITE SCISSORSWHITE HEAVY " +
	"CHECK MARKTELEPHONE LOCATION SIGNTAPE DRIVEAIRPLANEENVELOPERAISED FISTRA" +
	"ISED HANDVICTORY HANDWRITING HANDLOWER RIGHT PENCILPENCILUPPER RIGHT PEN" +
	"CILWHITE NIBBLACK NIBCHECK MARKHEAVY CHECK MARKMULTIPLICATION XHEAVY MUL" +
	"TIPLICATION XBALLOT XHEAVY BALLOT XOUTLINED GREEK CROSSHEAVY GREEK CROSS" +
	"OPEN CENTRE CROSSHEAVY OPEN CENTRE CROSSLATIN CROSSSHADOWED WHITE LATIN " +
	"CROSSOUTLINED LATIN CROSSMALTESE CROSSSTAR OF DAVIDFOUR TEARDROP-SPOKED " +
	"ASTERISKFOUR BALLOON-SPOKED ASTERISKHEAVY FOUR BALLOON-SPOKED ASTERISKFO" +
	"UR CLUB-SPOKED ASTERISKBLACK FOUR POINTED STARWHITE FOUR POINTED STARSPA" +
	"RKLESSTRESS OUTLINED WHITE STARCIRCLED WHITE STAROPEN CENTRE BLACK STARB" +
	"LACK CENTRE WHITE STAROUTLINED BLACK STARHEAVY OUTLINED BLACK STARPINWHE" +
	"EL STARSHADOWED WHITE STARHEAVY ASTERISKOPEN CENTRE ASTERISKEIGHT SPOKED" +
	" ASTERISKEIGHT POINTED BLACK STAREIGHT POINTED PINWHEEL STARSIX POINTED " +
	"BLACK STAREIGHT POINTED RECTILINEAR BLACK STARHEAVY EIGHT POINTED RECTIL" +
	"INEAR BLACK STARTWELVE POINTED BLACK STARSIXTEEN POINTED ASTERISKTEARDRO" +
	"P-SPOKED ASTERISKOPEN CENTRE TEARDROP-SPOKED ASTERISKHEAVY TEARDROP-SPOK" +
	"ED ASTERISKSIX PETALLED BLACK AND WHITE FLORETTEBLACK FLORETTEWHITE FLOR" +
	"ETTEEIGHT PETALLED OUTLINED BLACK FLORETTECIRCLED OPEN CENTRE EIGHT POIN" +
	"TED STARHEAVY TEARDROP-SPOKED PINWHEEL ASTERISKSNOWFLAKETIGHT TRIFOLIATE" +
	" SNOWFLAKEHEAVY CHEVRON SNOWFLAKESPARKLEHEAVY SPARKLEBALLOON-SPOKED ASTE" +
	"RISKEIGHT TEARDROP-SPOKED PROPELLER ASTERISKHEAVY EIGHT TEARDROP-SPOKED " +
	"PROPELLER ASTERISKCROSS MARKSHADOWED WHITE CIRCLENEGATIVE SQUARED CROSS " +
	"MARKLOWER RIGHT DROP-SHADOWED WHITE SQUAREUPPER RIGHT DROP-SHADOWED WHIT" +
	"E SQUARELOWER RIGHT SHADOWED WHITE SQUAREUPPER RIGHT SHADOWED WHITE SQUA" +
	"REBLACK QUESTION MARK ORNAMENTWHITE QUESTION MARK ORNAMENTWHITE EXCLAMAT") + ("" +
	"ION MARK ORNAMENTBLACK DIAMOND MINUS WHITE XHEAVY EXCLAMATION MARK SYMBO" +
	"LLIGHT VERTICAL BARMEDIUM VERTICAL BARHEAVY VERTICAL BARHEAVY SINGLE TUR" +
	"NED COMMA QUOTATION MARK ORNAMENTHEAVY SINGLE COMMA QUOTATION MARK ORNAM" +
	"ENTHEAVY DOUBLE TURNED COMMA QUOTATION MARK ORNAMENTHEAVY DOUBLE COMMA Q" +
	"UOTATION MARK ORNAMENTHEAVY LOW SINGLE COMMA QUOTATION MARK ORNAMENTHEAV" +
	"Y LOW DOUBLE COMMA QUOTATION MARK ORNAMENTCURVED STEM PARAGRAPH SIGN ORN" +
	"AMENTHEAVY EXCLAMATION MARK ORNAMENTHEAVY HEART EXCLAMATION MARK ORNAMEN" +
	"THEAVY BLACK HEARTROTATED HEAVY BLACK HEART BULLETFLORAL HEARTROTATED FL" +
	"ORAL HEART BULLETMEDIUM LEFT PARENTHESIS ORNAMENTMEDIUM RIGHT PARENTHESI" +
	"S ORNAMENTMEDIUM FLATTENED LEFT PARENTHESIS ORNAMENTMEDIUM FLATTENED RIG" +
	"HT PARENTHESIS ORNAMENTMEDIUM LEFT-POINTING ANGLE BRACKET ORNAMENTMEDIUM" +
	" RIGHT-POINTING ANGLE BRACKET ORNAMENTHEAVY LEFT-POINTING ANGLE QUOTATIO" +
	"N MARK ORNAMENTHEAVY RIGHT-POINTING ANGLE QUOTATION MARK ORNAMENTHEAVY L" +
	"EFT-POINTING ANGLE BRACKET ORNAMENTHEAVY RIGHT-POINTING ANGLE BRACKET OR" +
	"NAMENTLIGHT LEFT TORTOISE SHELL BRACKET ORNAMENTLIGHT RIGHT TORTOISE SHE" +
	"LL BRACKET ORNAMENTMEDIUM LEFT CURLY BRACKET ORNAMENTMEDIUM RIGHT CURLY " +
	"BRACKET ORNAMENTDINGBAT NEGATIVE CIRCLED DIGIT ONEDINGBAT NEGATIVE CIRCL" +
	"ED DIGIT TWODINGBAT NEGATIVE CIRCLED DIGIT THREEDINGBAT NEGATIVE CIRCLED" +
	" DIGIT FOURDINGBAT NEGATIVE CIRCLED DIGIT FIVEDINGBAT NEGATIVE CIRCLED D" +
	"IGIT SIXDINGBAT NEGATIVE CIRCLED DIGIT SEVENDINGBAT NEGATIVE CIRCLED DIG" +
	"IT EIGHTDINGBAT NEGATIVE CIRCLED DIGIT NINEDINGBAT NEGATIVE CIRCLED NUMB" +
	"ER TENDINGBAT CIRCLED SANS-SERIF DIGIT ONEDINGBAT CIRCLED SANS-SERIF DIG" +
	"IT TWODINGBAT CIRCLED SANS-SERIF DIGIT THREEDINGBAT CIRCLED SANS-SERIF D" +
	"IGIT FOURDINGBAT CIRCLED SANS-SERIF DIGIT FIVEDINGBAT CIRCLED SANS-SERIF" +
	" DIGIT SIXDINGBAT CIRCLED SANS-SERIF DIGIT SEVENDINGBAT CIRCLED SANS-SER" +
	"IF DIGIT EIGHTDINGBAT CIRCLED SANS-SERIF DIGIT NINEDINGBAT CIRCLED SANS-" +
	"SERIF NUMBER TENDINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT ONEDINGBAT NEG" +
	"ATIVE CIRCLED SANS-SERIF DIGIT TWODINGBAT NEGATIVE CIRCLED SANS-SERIF DI" +
	"GIT THREEDINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT FOURDINGBAT NEGATIVE " +
	"CIRCLED SANS-SERIF DIGIT FIVEDINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT S" +
	"IXDINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT SEVENDINGBAT NEGATIVE CIRCLE" +
	"D SANS-SERIF DIGIT EIGHTDINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT NINEDI" +
	"NGBAT NEGATIVE CIRCLED SANS-SERIF NUMBER TENHEAVY WIDE-HEADED RIGHTWARDS" +
	" ARROWHEAVY PLUS SIGNHEAVY MINUS SIGNHEAVY DIVISION SIGNHEAVY SOUTH EAST" +
	" ARROWHEAVY RIGHTWARDS ARROWHEAVY NORTH EAST ARROWDRAFTING POINT RIGHTWA" +
	"RDS ARROWHEAVY ROUND-TIPPED RIGHTWARDS ARROWTRIANGLE-HEADED RIGHTWARDS A" +
	"RROWHEAVY TRIANGLE-HEADED RIGHTWARDS ARROWDASHED TRIANGLE-HEADED RIGHTWA" +
	"RDS ARROWHEAVY DASHED TRIANGLE-HEADED RIGHTWARDS ARROWBLACK RIGHTWARDS A" +
	"RROWTHREE-D TOP-LIGHTED RIGHTWARDS ARROWHEADTHREE-D BOTTOM-LIGHTED RIGHT" +
	"WARDS ARROWHEADBLACK RIGHTWARDS ARROWHEADHEAVY BLACK CURVED DOWNWARDS AN" +
	"D RIGHTWARDS ARROWHEAVY BLACK CURVED UPWARDS AND RIGHTWARDS ARROWSQUAT B" +
	"LACK RIGHTWARDS ARROWHEAVY CONCAVE-POINTED BLACK RIGHTWARDS ARROWRIGHT-S" +
	"HADED WHITE RIGHTWARDS ARROWLEFT-SHADED WHITE RIGHTWARDS ARROWBACK-TILTE" +
	"D SHADOWED WHITE RIGHTWARDS ARROWFRONT-TILTED SHADOWED WHITE RIGHTWARDS " +
	"ARROWHEAVY LOWER RIGHT-SHADOWED WHITE RIGHTWARDS ARROWHEAVY UPPER RIGHT-" +
	"SHADOWED WHITE RIGHTWARDS ARROWNOTCHED LOWER RIGHT-SHADOWED WHITE RIGHTW" +
	"ARDS ARROWCURLY LOOPNOTCHED UPPER RIGHT-SHADOWED WHITE RIGHTWARDS ARROWC" +
	"IRCLED HEAVY WHITE RIGHTWARDS ARROWWHITE-FEATHERED RIGHTWARDS ARROWBLACK" +
	"-FEATHERED SOUTH EAST ARROWBLACK-FEATHERED RIGHTWARDS ARROWBLACK-FEATHER" +
	"ED NORTH EAST ARROWHEAVY BLACK-FEATHERED SOUTH EAST ARROWHEAVY BLACK-FEA" +
	"THERED RIGHTWARDS ARROWHEAVY BLACK-FEATHERED NORTH EAST ARROWTEARDROP-BA" +
	"RBED RIGHTWARDS ARROWHEAVY TEARDROP-SHANKED RIGHTWARDS ARROWWEDGE-TAILED" +
	" RIGHTWARDS ARROWHEAVY WEDGE-TAILED RIGHTWARDS ARROWOPEN-OUTLINED RIGHTW" +
	"ARDS ARROWDOUBLE CURLY LOOPTHREE DIMENSIONAL ANGLEWHITE TRIANGLE CONTAIN" +
	"ING SMALL WHITE TRIANGLEPERPENDICULAROPEN SUBSETOPEN SUPERSETLEFT S-SHAP" +
	"ED BAG DELIMITERRIGHT S-SHAPED BAG DELIMITEROR WITH DOT INSIDEREVERSE SO" +
	"LIDUS PRECEDING SUBSETSUPERSET PRECEDING SOLIDUSVERTICAL BAR WITH HORIZO" +
	"NTAL STROKEMATHEMATICAL RISING DIAGONALLONG DIVISIONMATHEMATICAL FALLING" +
	" DIAGONALSQUARED LOGICAL ANDSQUARED LOGICAL ORWHITE DIAMOND WITH CENTRED" +
	" DOTAND WITH DOTELEMENT OF OPENING UPWARDSLOWER RIGHT CORNER WITH DOTUPP" +
	"ER LEFT CORNER WITH DOTLEFT OUTER JOINRIGHT OUTER JOINFULL OUTER JOINLAR" +
	"GE UP TACKLARGE DOWN TACKLEFT AND RIGHT DOUBLE TURNSTILELEFT AND RIGHT T" +
	"ACKLEFT MULTIMAPLONG RIGHT TACKLONG LEFT TACKUP TACK WITH CIRCLE ABOVELO" +
	"ZENGE DIVIDED BY HORIZONTAL RULEWHITE CONCAVE-SIDED DIAMONDWHITE CONCAVE") + ("" +
	"-SIDED DIAMOND WITH LEFTWARDS TICKWHITE CONCAVE-SIDED DIAMOND WITH RIGHT" +
	"WARDS TICKWHITE SQUARE WITH LEFTWARDS TICKWHITE SQUARE WITH RIGHTWARDS T" +
	"ICKMATHEMATICAL LEFT WHITE SQUARE BRACKETMATHEMATICAL RIGHT WHITE SQUARE" +
	" BRACKETMATHEMATICAL LEFT ANGLE BRACKETMATHEMATICAL RIGHT ANGLE BRACKETM" +
	"ATHEMATICAL LEFT DOUBLE ANGLE BRACKETMATHEMATICAL RIGHT DOUBLE ANGLE BRA" +
	"CKETMATHEMATICAL LEFT WHITE TORTOISE SHELL BRACKETMATHEMATICAL RIGHT WHI" +
	"TE TORTOISE SHELL BRACKETMATHEMATICAL LEFT FLATTENED PARENTHESISMATHEMAT" +
	"ICAL RIGHT FLATTENED PARENTHESISUPWARDS QUADRUPLE ARROWDOWNWARDS QUADRUP" +
	"LE ARROWANTICLOCKWISE GAPPED CIRCLE ARROWCLOCKWISE GAPPED CIRCLE ARROWRI" +
	"GHT ARROW WITH CIRCLED PLUSLONG LEFTWARDS ARROWLONG RIGHTWARDS ARROWLONG" +
	" LEFT RIGHT ARROWLONG LEFTWARDS DOUBLE ARROWLONG RIGHTWARDS DOUBLE ARROW" +
	"LONG LEFT RIGHT DOUBLE ARROWLONG LEFTWARDS ARROW FROM BARLONG RIGHTWARDS" +
	" ARROW FROM BARLONG LEFTWARDS DOUBLE ARROW FROM BARLONG RIGHTWARDS DOUBL" +
	"E ARROW FROM BARLONG RIGHTWARDS SQUIGGLE ARROWBRAILLE PATTERN BLANKBRAIL" +
	"LE PATTERN DOTS-1BRAILLE PATTERN DOTS-2BRAILLE PATTERN DOTS-12BRAILLE PA" +
	"TTERN DOTS-3BRAILLE PATTERN DOTS-13BRAILLE PATTERN DOTS-23BRAILLE PATTER" +
	"N DOTS-123BRAILLE PATTERN DOTS-4BRAILLE PATTERN DOTS-14BRAILLE PATTERN D" +
	"OTS-24BRAILLE PATTERN DOTS-124BRAILLE PATTERN DOTS-34BRAILLE PATTERN DOT" +
	"S-134BRAILLE PATTERN DOTS-234BRAILLE PATTERN DOTS-1234BRAILLE PATTERN DO" +
	"TS-5BRAILLE PATTERN DOTS-15BRAILLE PATTERN DOTS-25BRAILLE PATTERN DOTS-1" +
	"25BRAILLE PATTERN DOTS-35BRAILLE PATTERN DOTS-135BRAILLE PATTERN DOTS-23" +
	"5BRAILLE PATTERN DOTS-1235BRAILLE PATTERN DOTS-45BRAILLE PATTERN DOTS-14" +
	"5BRAILLE PATTERN DOTS-245BRAILLE PATTERN DOTS-1245BRAILLE PATTERN DOTS-3" +
	"45BRAILLE PATTERN DOTS-1345BRAILLE PATTERN DOTS-2345BRAILLE PATTERN DOTS" +
	"-12345BRAILLE PATTERN DOTS-6BRAILLE PATTERN DOTS-16BRAILLE PATTERN DOTS-" +
	"26BRAILLE PATTERN DOTS-126BRAILLE PATTERN DOTS-36BRAILLE PATTERN DOTS-13" +
	"6BRAILLE PATTERN DOTS-236BRAILLE PATTERN DOTS-1236BRAILLE PATTERN DOTS-4" +
	"6BRAILLE PATTERN DOTS-146BRAILLE PATTERN DOTS-246BRAILLE PATTERN DOTS-12" +
	"46BRAILLE PATTERN DOTS-346BRAILLE PATTERN DOTS-1346BRAILLE PATTERN DOTS-" +
	"2346BRAILLE PATTERN DOTS-12346BRAILLE PATTERN DOTS-56BRAILLE PATTERN DOT" +
	"S-156BRAILLE PATTERN DOTS-256BRAILLE PATTERN DOTS-1256BRAILLE PATTERN DO" +
	"TS-356BRAILLE PATTERN DOTS-1356BRAILLE PATTERN DOTS-2356BRAILLE PATTERN " +
	"DOTS-12356BRAILLE PATTERN DOTS-456BRAILLE PATTERN DOTS-1456BRAILLE PATTE" +
	"RN DOTS-2456BRAILLE PATTERN DOTS-12456BRAILLE PATTERN DOTS-3456BRAILLE P" +
	"ATTERN DOTS-13456BRAILLE PATTERN DOTS-23456BRAILLE PATTERN DOTS-123456BR" +
	"AILLE PATTERN DOTS-7BRAILLE PATTERN DOTS-17BRAILLE PATTERN DOTS-27BRAILL" +
	"E PATTERN DOTS-127BRAILLE PATTERN DOTS-37BRAILLE PATTERN DOTS-137BRAILLE" +
	" PATTERN DOTS-237BRAILLE PATTERN DOTS-1237BRAILLE PATTERN DOTS-47BRAILLE" +
	" PATTERN DOTS-147BRAILLE PATTERN DOTS-247BRAILLE PATTERN DOTS-1247BRAILL" +
	"E PATTERN DOTS-347BRAILLE PATTERN DOTS-1347BRAILLE PATTERN DOTS-2347BRAI" +
	"LLE PATTERN DOTS-12347BRAILLE PATTERN DOTS-57BRAILLE PATTERN DOTS-157BRA" +
	"ILLE PATTERN DOTS-257BRAILLE PATTERN DOTS-1257BRAILLE PATTERN DOTS-357BR" +
	"AILLE PATTERN DOTS-1357BRAILLE PATTERN DOTS-2357BRAILLE PATTERN DOTS-123" +
	"57BRAILLE PATTERN DOTS-457BRAILLE PATTERN DOTS-1457BRAILLE PATTERN DOTS-" +
	"2457BRAILLE PATTERN DOTS-12457BRAILLE PATTERN DOTS-3457BRAILLE PATTERN D" +
	"OTS-13457BRAILLE PATTERN DOTS-23457BRAILLE PATTERN DOTS-123457BRAILLE PA" +
	"TTERN DOTS-67BRAILLE PATTERN DOTS-167BRAILLE PATTERN DOTS-267BRAILLE PAT" +
	"TERN DOTS-1267BRAILLE PATTERN DOTS-367BRAILLE PATTERN DOTS-1367BRAILLE P" +
	"ATTERN DOTS-2367BRAILLE PATTERN DOTS-12367BRAILLE PATTERN DOTS-467BRAILL" +
	"E PATTERN DOTS-1467BRAILLE PATTERN DOTS-2467BRAILLE PATTERN DOTS-12467BR" +
	"AILLE PATTERN DOTS-3467BRAILLE PATTERN DOTS-13467BRAILLE PATTERN DOTS-23" +
	"467BRAILLE PATTERN DOTS-123467BRAILLE PATTERN DOTS-567BRAILLE PATTERN DO" +
	"TS-1567BRAILLE PATTERN DOTS-2567BRAILLE PATTERN DOTS-12567BRAILLE PATTER" +
	"N DOTS-3567BRAILLE PATTERN DOTS-13567BRAILLE PATTERN DOTS-23567BRAILLE P" +
	"ATTERN DOTS-123567BRAILLE PATTERN DOTS-4567BRAILLE PATTERN DOTS-14567BRA" +
	"ILLE PATTERN DOTS-24567BRAILLE PATTERN DOTS-124567BRAILLE PATTERN DOTS-3" +
	"4567BRAILLE PATTERN DOTS-134567BRAILLE PATTERN DOTS-234567BRAILLE PATTER" +
	"N DOTS-1234567BRAILLE PATTERN DOTS-8BRAILLE PATTERN DOTS-18BRAILLE PATTE" +
	"RN DOTS-28BRAILLE PATTERN DOTS-128BRAILLE PATTERN DOTS-38BRAILLE PATTERN" +
	" DOTS-138BRAILLE PATTERN DOTS-238BRAILLE PATTERN DOTS-1238BRAILLE PATTER" +
	"N DOTS-48BRAILLE PATTERN DOTS-148BRAILLE PATTERN DOTS-248BRAILLE PATTERN" +
	" DOTS-1248BRAILLE PATTERN DOTS-348BRAILLE PATTERN DOTS-1348BRAILLE PATTE" +
	"RN DOTS-2348BRAILLE PATTERN DOTS-12348BRAILLE PATTERN DOTS-58BRAILLE PAT" +
	"TERN DOTS-158BRAILLE PATTERN DOTS-258BRAILLE PATTERN DOTS-1258BRAILLE PA") + ("" +
	"TTERN DOTS-358BRAILLE PATTERN DOTS-1358BRAILLE PATTERN DOTS-2358BRAILLE " +
	"PATTERN DOTS-12358BRAILLE PATTERN DOTS-458BRAILLE PATTERN DOTS-1458BRAIL" +
	"LE PATTERN DOTS-2458BRAILLE PATTERN DOTS-12458BRAILLE PATTERN DOTS-3458B" +
	"RAILLE PATTERN DOTS-13458BRAILLE PATTERN DOTS-23458BRAILLE PATTERN DOTS-" +
	"123458BRAILLE PATTERN DOTS-68BRAILLE PATTERN DOTS-168BRAILLE PATTERN DOT" +
	"S-268BRAILLE PATTERN DOTS-1268BRAILLE PATTERN DOTS-368BRAILLE PATTERN DO" +
	"TS-1368BRAILLE PATTERN DOTS-2368BRAILLE PATTERN DOTS-12368BRAILLE PATTER" +
	"N DOTS-468BRAILLE PATTERN DOTS-1468BRAILLE PATTERN DOTS-2468BRAILLE PATT" +
	"ERN DOTS-12468BRAILLE PATTERN DOTS-3468BRAILLE PATTERN DOTS-13468BRAILLE" +
	" PATTERN DOTS-23468BRAILLE PATTERN DOTS-123468BRAILLE PATTERN DOTS-568BR" +
	"AILLE PATTERN DOTS-1568BRAILLE PATTERN DOTS-2568BRAILLE PATTERN DOTS-125" +
	"68BRAILLE PATTERN DOTS-3568BRAILLE PATTERN DOTS-13568BRAILLE PATTERN DOT" +
	"S-23568BRAILLE PATTERN DOTS-123568BRAILLE PATTERN DOTS-4568BRAILLE PATTE" +
	"RN DOTS-14568BRAILLE PATTERN DOTS-24568BRAILLE PATTERN DOTS-124568BRAILL" +
	"E PATTERN DOTS-34568BRAILLE PATTERN DOTS-134568BRAILLE PATTERN DOTS-2345" +
	"68BRAILLE PATTERN DOTS-1234568BRAILLE PATTERN DOTS-78BRAILLE PATTERN DOT" +
	"S-178BRAILLE PATTERN DOTS-278BRAILLE PATTERN DOTS-1278BRAILLE PATTERN DO" +
	"TS-378BRAILLE PATTERN DOTS-1378BRAILLE PATTERN DOTS-2378BRAILLE PATTERN " +
	"DOTS-12378BRAILLE PATTERN DOTS-478BRAILLE PATTERN DOTS-1478BRAILLE PATTE" +
	"RN DOTS-2478BRAILLE PATTERN DOTS-12478BRAILLE PATTERN DOTS-3478BRAILLE P" +
	"ATTERN DOTS-13478BRAILLE PATTERN DOTS-23478BRAILLE PATTERN DOTS-123478BR" +
	"AILLE PATTERN DOTS-578BRAILLE PATTERN DOTS-1578BRAILLE PATTERN DOTS-2578" +
	"BRAILLE PATTERN DOTS-12578BRAILLE PATTERN DOTS-3578BRAILLE PATTERN DOTS-" +
	"13578BRAILLE PATTERN DOTS-23578BRAILLE PATTERN DOTS-123578BRAILLE PATTER" +
	"N DOTS-4578BRAILLE PATTERN DOTS-14578BRAILLE PATTERN DOTS-24578BRAILLE P" +
	"ATTERN DOTS-124578BRAILLE PATTERN DOTS-34578BRAILLE PATTERN DOTS-134578B" +
	"RAILLE PATTERN DOTS-234578BRAILLE PATTERN DOTS-1234578BRAILLE PATTERN DO" +
	"TS-678BRAILLE PATTERN DOTS-1678BRAILLE PATTERN DOTS-2678BRAILLE PATTERN " +
	"DOTS-12678BRAILLE PATTERN DOTS-3678BRAILLE PATTERN DOTS-13678BRAILLE PAT" +
	"TERN DOTS-23678BRAILLE PATTERN DOTS-123678BRAILLE PATTERN DOTS-4678BRAIL" +
	"LE PATTERN DOTS-14678BRAILLE PATTERN DOTS-24678BRAILLE PATTERN DOTS-1246" +
	"78BRAILLE PATTERN DOTS-34678BRAILLE PATTERN DOTS-134678BRAILLE PATTERN D" +
	"OTS-234678BRAILLE PATTERN DOTS-1234678BRAILLE PATTERN DOTS-5678BRAILLE P" +
	"ATTERN DOTS-15678BRAILLE PATTERN DOTS-25678BRAILLE PATTERN DOTS-125678BR" +
	"AILLE PATTERN DOTS-35678BRAILLE PATTERN DOTS-135678BRAILLE PATTERN DOTS-" +
	"235678BRAILLE PATTERN DOTS-1235678BRAILLE PATTERN DOTS-45678BRAILLE PATT" +
	"ERN DOTS-145678BRAILLE PATTERN DOTS-245678BRAILLE PATTERN DOTS-1245678BR" +
	"AILLE PATTERN DOTS-345678BRAILLE PATTERN DOTS-1345678BRAILLE PATTERN DOT" +
	"S-2345678BRAILLE PATTERN DOTS-12345678RIGHTWARDS TWO-HEADED ARROW WITH V" +
	"ERTICAL STROKERIGHTWARDS TWO-HEADED ARROW WITH DOUBLE VERTICAL STROKELEF" +
	"TWARDS DOUBLE ARROW WITH VERTICAL STROKERIGHTWARDS DOUBLE ARROW WITH VER" +
	"TICAL STROKELEFT RIGHT DOUBLE ARROW WITH VERTICAL STROKERIGHTWARDS TWO-H" +
	"EADED ARROW FROM BARLEFTWARDS DOUBLE ARROW FROM BARRIGHTWARDS DOUBLE ARR" +
	"OW FROM BARDOWNWARDS ARROW WITH HORIZONTAL STROKEUPWARDS ARROW WITH HORI" +
	"ZONTAL STROKEUPWARDS TRIPLE ARROWDOWNWARDS TRIPLE ARROWLEFTWARDS DOUBLE " +
	"DASH ARROWRIGHTWARDS DOUBLE DASH ARROWLEFTWARDS TRIPLE DASH ARROWRIGHTWA" +
	"RDS TRIPLE DASH ARROWRIGHTWARDS TWO-HEADED TRIPLE DASH ARROWRIGHTWARDS A" +
	"RROW WITH DOTTED STEMUPWARDS ARROW TO BARDOWNWARDS ARROW TO BARRIGHTWARD" +
	"S ARROW WITH TAIL WITH VERTICAL STROKERIGHTWARDS ARROW WITH TAIL WITH DO" +
	"UBLE VERTICAL STROKERIGHTWARDS TWO-HEADED ARROW WITH TAILRIGHTWARDS TWO-" +
	"HEADED ARROW WITH TAIL WITH VERTICAL STROKERIGHTWARDS TWO-HEADED ARROW W" +
	"ITH TAIL WITH DOUBLE VERTICAL STROKELEFTWARDS ARROW-TAILRIGHTWARDS ARROW" +
	"-TAILLEFTWARDS DOUBLE ARROW-TAILRIGHTWARDS DOUBLE ARROW-TAILLEFTWARDS AR" +
	"ROW TO BLACK DIAMONDRIGHTWARDS ARROW TO BLACK DIAMONDLEFTWARDS ARROW FRO" +
	"M BAR TO BLACK DIAMONDRIGHTWARDS ARROW FROM BAR TO BLACK DIAMONDNORTH WE" +
	"ST AND SOUTH EAST ARROWNORTH EAST AND SOUTH WEST ARROWNORTH WEST ARROW W" +
	"ITH HOOKNORTH EAST ARROW WITH HOOKSOUTH EAST ARROW WITH HOOKSOUTH WEST A" +
	"RROW WITH HOOKNORTH WEST ARROW AND NORTH EAST ARROWNORTH EAST ARROW AND " +
	"SOUTH EAST ARROWSOUTH EAST ARROW AND SOUTH WEST ARROWSOUTH WEST ARROW AN" +
	"D NORTH WEST ARROWRISING DIAGONAL CROSSING FALLING DIAGONALFALLING DIAGO" +
	"NAL CROSSING RISING DIAGONALSOUTH EAST ARROW CROSSING NORTH EAST ARROWNO" +
	"RTH EAST ARROW CROSSING SOUTH EAST ARROWFALLING DIAGONAL CROSSING NORTH " +
	"EAST ARROWRISING DIAGONAL CROSSING SOUTH EAST ARROWNORTH EAST ARROW CROS" +
	"SING NORTH WEST ARROWNORTH WEST ARROW CROSSING NORTH EAST ARROWWAVE ARRO") + ("" +
	"W POINTING DIRECTLY RIGHTARROW POINTING RIGHTWARDS THEN CURVING UPWARDSA" +
	"RROW POINTING RIGHTWARDS THEN CURVING DOWNWARDSARROW POINTING DOWNWARDS " +
	"THEN CURVING LEFTWARDSARROW POINTING DOWNWARDS THEN CURVING RIGHTWARDSRI" +
	"GHT-SIDE ARC CLOCKWISE ARROWLEFT-SIDE ARC ANTICLOCKWISE ARROWTOP ARC ANT" +
	"ICLOCKWISE ARROWBOTTOM ARC ANTICLOCKWISE ARROWTOP ARC CLOCKWISE ARROW WI" +
	"TH MINUSTOP ARC ANTICLOCKWISE ARROW WITH PLUSLOWER RIGHT SEMICIRCULAR CL" +
	"OCKWISE ARROWLOWER LEFT SEMICIRCULAR ANTICLOCKWISE ARROWANTICLOCKWISE CL" +
	"OSED CIRCLE ARROWCLOCKWISE CLOSED CIRCLE ARROWRIGHTWARDS ARROW ABOVE SHO" +
	"RT LEFTWARDS ARROWLEFTWARDS ARROW ABOVE SHORT RIGHTWARDS ARROWSHORT RIGH" +
	"TWARDS ARROW ABOVE LEFTWARDS ARROWRIGHTWARDS ARROW WITH PLUS BELOWLEFTWA" +
	"RDS ARROW WITH PLUS BELOWRIGHTWARDS ARROW THROUGH XLEFT RIGHT ARROW THRO" +
	"UGH SMALL CIRCLEUPWARDS TWO-HEADED ARROW FROM SMALL CIRCLELEFT BARB UP R" +
	"IGHT BARB DOWN HARPOONLEFT BARB DOWN RIGHT BARB UP HARPOONUP BARB RIGHT " +
	"DOWN BARB LEFT HARPOONUP BARB LEFT DOWN BARB RIGHT HARPOONLEFT BARB UP R" +
	"IGHT BARB UP HARPOONUP BARB RIGHT DOWN BARB RIGHT HARPOONLEFT BARB DOWN " +
	"RIGHT BARB DOWN HARPOONUP BARB LEFT DOWN BARB LEFT HARPOONLEFTWARDS HARP" +
	"OON WITH BARB UP TO BARRIGHTWARDS HARPOON WITH BARB UP TO BARUPWARDS HAR" +
	"POON WITH BARB RIGHT TO BARDOWNWARDS HARPOON WITH BARB RIGHT TO BARLEFTW" +
	"ARDS HARPOON WITH BARB DOWN TO BARRIGHTWARDS HARPOON WITH BARB DOWN TO B" +
	"ARUPWARDS HARPOON WITH BARB LEFT TO BARDOWNWARDS HARPOON WITH BARB LEFT " +
	"TO BARLEFTWARDS HARPOON WITH BARB UP FROM BARRIGHTWARDS HARPOON WITH BAR" +
	"B UP FROM BARUPWARDS HARPOON WITH BARB RIGHT FROM BARDOWNWARDS HARPOON W" +
	"ITH BARB RIGHT FROM BARLEFTWARDS HARPOON WITH BARB DOWN FROM BARRIGHTWAR" +
	"DS HARPOON WITH BARB DOWN FROM BARUPWARDS HARPOON WITH BARB LEFT FROM BA" +
	"RDOWNWARDS HARPOON WITH BARB LEFT FROM BARLEFTWARDS HARPOON WITH BARB UP" +
	" ABOVE LEFTWARDS HARPOON WITH BARB DOWNUPWARDS HARPOON WITH BARB LEFT BE" +
	"SIDE UPWARDS HARPOON WITH BARB RIGHTRIGHTWARDS HARPOON WITH BARB UP ABOV" +
	"E RIGHTWARDS HARPOON WITH BARB DOWNDOWNWARDS HARPOON WITH BARB LEFT BESI" +
	"DE DOWNWARDS HARPOON WITH BARB RIGHTLEFTWARDS HARPOON WITH BARB UP ABOVE" +
	" RIGHTWARDS HARPOON WITH BARB UPLEFTWARDS HARPOON WITH BARB DOWN ABOVE R" +
	"IGHTWARDS HARPOON WITH BARB DOWNRIGHTWARDS HARPOON WITH BARB UP ABOVE LE" +
	"FTWARDS HARPOON WITH BARB UPRIGHTWARDS HARPOON WITH BARB DOWN ABOVE LEFT" +
	"WARDS HARPOON WITH BARB DOWNLEFTWARDS HARPOON WITH BARB UP ABOVE LONG DA" +
	"SHLEFTWARDS HARPOON WITH BARB DOWN BELOW LONG DASHRIGHTWARDS HARPOON WIT" +
	"H BARB UP ABOVE LONG DASHRIGHTWARDS HARPOON WITH BARB DOWN BELOW LONG DA" +
	"SHUPWARDS HARPOON WITH BARB LEFT BESIDE DOWNWARDS HARPOON WITH BARB RIGH" +
	"TDOWNWARDS HARPOON WITH BARB LEFT BESIDE UPWARDS HARPOON WITH BARB RIGHT" +
	"RIGHT DOUBLE ARROW WITH ROUNDED HEADEQUALS SIGN ABOVE RIGHTWARDS ARROWTI" +
	"LDE OPERATOR ABOVE RIGHTWARDS ARROWLEFTWARDS ARROW ABOVE TILDE OPERATORR" +
	"IGHTWARDS ARROW ABOVE TILDE OPERATORRIGHTWARDS ARROW ABOVE ALMOST EQUAL " +
	"TOLESS-THAN ABOVE LEFTWARDS ARROWLEFTWARDS ARROW THROUGH LESS-THANGREATE" +
	"R-THAN ABOVE RIGHTWARDS ARROWSUBSET ABOVE RIGHTWARDS ARROWLEFTWARDS ARRO" +
	"W THROUGH SUBSETSUPERSET ABOVE LEFTWARDS ARROWLEFT FISH TAILRIGHT FISH T" +
	"AILUP FISH TAILDOWN FISH TAILTRIPLE VERTICAL BAR DELIMITERZ NOTATION SPO" +
	"TZ NOTATION TYPE COLONLEFT WHITE CURLY BRACKETRIGHT WHITE CURLY BRACKETL" +
	"EFT WHITE PARENTHESISRIGHT WHITE PARENTHESISZ NOTATION LEFT IMAGE BRACKE" +
	"TZ NOTATION RIGHT IMAGE BRACKETZ NOTATION LEFT BINDING BRACKETZ NOTATION" +
	" RIGHT BINDING BRACKETLEFT SQUARE BRACKET WITH UNDERBARRIGHT SQUARE BRAC" +
	"KET WITH UNDERBARLEFT SQUARE BRACKET WITH TICK IN TOP CORNERRIGHT SQUARE" +
	" BRACKET WITH TICK IN BOTTOM CORNERLEFT SQUARE BRACKET WITH TICK IN BOTT" +
	"OM CORNERRIGHT SQUARE BRACKET WITH TICK IN TOP CORNERLEFT ANGLE BRACKET " +
	"WITH DOTRIGHT ANGLE BRACKET WITH DOTLEFT ARC LESS-THAN BRACKETRIGHT ARC " +
	"GREATER-THAN BRACKETDOUBLE LEFT ARC GREATER-THAN BRACKETDOUBLE RIGHT ARC" +
	" LESS-THAN BRACKETLEFT BLACK TORTOISE SHELL BRACKETRIGHT BLACK TORTOISE " +
	"SHELL BRACKETDOTTED FENCEVERTICAL ZIGZAG LINEMEASURED ANGLE OPENING LEFT" +
	"RIGHT ANGLE VARIANT WITH SQUAREMEASURED RIGHT ANGLE WITH DOTANGLE WITH S" +
	" INSIDEACUTE ANGLESPHERICAL ANGLE OPENING LEFTSPHERICAL ANGLE OPENING UP" +
	"TURNED ANGLEREVERSED ANGLEANGLE WITH UNDERBARREVERSED ANGLE WITH UNDERBA" +
	"ROBLIQUE ANGLE OPENING UPOBLIQUE ANGLE OPENING DOWNMEASURED ANGLE WITH O" +
	"PEN ARM ENDING IN ARROW POINTING UP AND RIGHTMEASURED ANGLE WITH OPEN AR" +
	"M ENDING IN ARROW POINTING UP AND LEFTMEASURED ANGLE WITH OPEN ARM ENDIN" +
	"G IN ARROW POINTING DOWN AND RIGHTMEASURED ANGLE WITH OPEN ARM ENDING IN" +
	" ARROW POINTING DOWN AND LEFTMEASURED ANGLE WITH OPEN ARM ENDING IN ARRO" +
	"W POINTING RIGHT AND UPMEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POIN") + ("" +
	"TING LEFT AND UPMEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING RI" +
	"GHT AND DOWNMEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING LEFT A" +
	"ND DOWNREVERSED EMPTY SETEMPTY SET WITH OVERBAREMPTY SET WITH SMALL CIRC" +
	"LE ABOVEEMPTY SET WITH RIGHT ARROW ABOVEEMPTY SET WITH LEFT ARROW ABOVEC" +
	"IRCLE WITH HORIZONTAL BARCIRCLED VERTICAL BARCIRCLED PARALLELCIRCLED REV" +
	"ERSE SOLIDUSCIRCLED PERPENDICULARCIRCLE DIVIDED BY HORIZONTAL BAR AND TO" +
	"P HALF DIVIDED BY VERTICAL BARCIRCLE WITH SUPERIMPOSED XCIRCLED ANTICLOC" +
	"KWISE-ROTATED DIVISION SIGNUP ARROW THROUGH CIRCLECIRCLED WHITE BULLETCI" +
	"RCLED BULLETCIRCLED LESS-THANCIRCLED GREATER-THANCIRCLE WITH SMALL CIRCL" +
	"E TO THE RIGHTCIRCLE WITH TWO HORIZONTAL STROKES TO THE RIGHTSQUARED RIS" +
	"ING DIAGONAL SLASHSQUARED FALLING DIAGONAL SLASHSQUARED ASTERISKSQUARED " +
	"SMALL CIRCLESQUARED SQUARETWO JOINED SQUARESTRIANGLE WITH DOT ABOVETRIAN" +
	"GLE WITH UNDERBARS IN TRIANGLETRIANGLE WITH SERIFS AT BOTTOMRIGHT TRIANG" +
	"LE ABOVE LEFT TRIANGLELEFT TRIANGLE BESIDE VERTICAL BARVERTICAL BAR BESI" +
	"DE RIGHT TRIANGLEBOWTIE WITH LEFT HALF BLACKBOWTIE WITH RIGHT HALF BLACK" +
	"BLACK BOWTIETIMES WITH LEFT HALF BLACKTIMES WITH RIGHT HALF BLACKWHITE H" +
	"OURGLASSBLACK HOURGLASSLEFT WIGGLY FENCERIGHT WIGGLY FENCELEFT DOUBLE WI" +
	"GGLY FENCERIGHT DOUBLE WIGGLY FENCEINCOMPLETE INFINITYTIE OVER INFINITYI" +
	"NFINITY NEGATED WITH VERTICAL BARDOUBLE-ENDED MULTIMAPSQUARE WITH CONTOU" +
	"RED OUTLINEINCREASES ASSHUFFLE PRODUCTEQUALS SIGN AND SLANTED PARALLELEQ" +
	"UALS SIGN AND SLANTED PARALLEL WITH TILDE ABOVEIDENTICAL TO AND SLANTED " +
	"PARALLELGLEICH STARKTHERMODYNAMICDOWN-POINTING TRIANGLE WITH LEFT HALF B" +
	"LACKDOWN-POINTING TRIANGLE WITH RIGHT HALF BLACKBLACK DIAMOND WITH DOWN " +
	"ARROWBLACK LOZENGEWHITE CIRCLE WITH DOWN ARROWBLACK CIRCLE WITH DOWN ARR" +
	"OWERROR-BARRED WHITE SQUAREERROR-BARRED BLACK SQUAREERROR-BARRED WHITE D" +
	"IAMONDERROR-BARRED BLACK DIAMONDERROR-BARRED WHITE CIRCLEERROR-BARRED BL" +
	"ACK CIRCLERULE-DELAYEDREVERSE SOLIDUS OPERATORSOLIDUS WITH OVERBARREVERS" +
	"E SOLIDUS WITH HORIZONTAL STROKEBIG SOLIDUSBIG REVERSE SOLIDUSDOUBLE PLU" +
	"STRIPLE PLUSLEFT-POINTING CURVED ANGLE BRACKETRIGHT-POINTING CURVED ANGL" +
	"E BRACKETTINYMINYN-ARY CIRCLED DOT OPERATORN-ARY CIRCLED PLUS OPERATORN-" +
	"ARY CIRCLED TIMES OPERATORN-ARY UNION OPERATOR WITH DOTN-ARY UNION OPERA" +
	"TOR WITH PLUSN-ARY SQUARE INTERSECTION OPERATORN-ARY SQUARE UNION OPERAT" +
	"ORTWO LOGICAL AND OPERATORTWO LOGICAL OR OPERATORN-ARY TIMES OPERATORMOD" +
	"ULO TWO SUMSUMMATION WITH INTEGRALQUADRUPLE INTEGRAL OPERATORFINITE PART" +
	" INTEGRALINTEGRAL WITH DOUBLE STROKEINTEGRAL AVERAGE WITH SLASHCIRCULATI" +
	"ON FUNCTIONANTICLOCKWISE INTEGRATIONLINE INTEGRATION WITH RECTANGULAR PA" +
	"TH AROUND POLELINE INTEGRATION WITH SEMICIRCULAR PATH AROUND POLELINE IN" +
	"TEGRATION NOT INCLUDING THE POLEINTEGRAL AROUND A POINT OPERATORQUATERNI" +
	"ON INTEGRAL OPERATORINTEGRAL WITH LEFTWARDS ARROW WITH HOOKINTEGRAL WITH" +
	" TIMES SIGNINTEGRAL WITH INTERSECTIONINTEGRAL WITH UNIONINTEGRAL WITH OV" +
	"ERBARINTEGRAL WITH UNDERBARJOINLARGE LEFT TRIANGLE OPERATORZ NOTATION SC" +
	"HEMA COMPOSITIONZ NOTATION SCHEMA PIPINGZ NOTATION SCHEMA PROJECTIONPLUS" +
	" SIGN WITH SMALL CIRCLE ABOVEPLUS SIGN WITH CIRCUMFLEX ACCENT ABOVEPLUS " +
	"SIGN WITH TILDE ABOVEPLUS SIGN WITH DOT BELOWPLUS SIGN WITH TILDE BELOWP" +
	"LUS SIGN WITH SUBSCRIPT TWOPLUS SIGN WITH BLACK TRIANGLEMINUS SIGN WITH " +
	"COMMA ABOVEMINUS SIGN WITH DOT BELOWMINUS SIGN WITH FALLING DOTSMINUS SI" +
	"GN WITH RISING DOTSPLUS SIGN IN LEFT HALF CIRCLEPLUS SIGN IN RIGHT HALF " +
	"CIRCLEVECTOR OR CROSS PRODUCTMULTIPLICATION SIGN WITH DOT ABOVEMULTIPLIC" +
	"ATION SIGN WITH UNDERBARSEMIDIRECT PRODUCT WITH BOTTOM CLOSEDSMASH PRODU" +
	"CTMULTIPLICATION SIGN IN LEFT HALF CIRCLEMULTIPLICATION SIGN IN RIGHT HA" +
	"LF CIRCLECIRCLED MULTIPLICATION SIGN WITH CIRCUMFLEX ACCENTMULTIPLICATIO" +
	"N SIGN IN DOUBLE CIRCLECIRCLED DIVISION SIGNPLUS SIGN IN TRIANGLEMINUS S" +
	"IGN IN TRIANGLEMULTIPLICATION SIGN IN TRIANGLEINTERIOR PRODUCTRIGHTHAND " +
	"INTERIOR PRODUCTZ NOTATION RELATIONAL COMPOSITIONAMALGAMATION OR COPRODU" +
	"CTINTERSECTION WITH DOTUNION WITH MINUS SIGNUNION WITH OVERBARINTERSECTI" +
	"ON WITH OVERBARINTERSECTION WITH LOGICAL ANDUNION WITH LOGICAL ORUNION A" +
	"BOVE INTERSECTIONINTERSECTION ABOVE UNIONUNION ABOVE BAR ABOVE INTERSECT" +
	"IONINTERSECTION ABOVE BAR ABOVE UNIONUNION BESIDE AND JOINED WITH UNIONI" +
	"NTERSECTION BESIDE AND JOINED WITH INTERSECTIONCLOSED UNION WITH SERIFSC" +
	"LOSED INTERSECTION WITH SERIFSDOUBLE SQUARE INTERSECTIONDOUBLE SQUARE UN" +
	"IONCLOSED UNION WITH SERIFS AND SMASH PRODUCTLOGICAL AND WITH DOT ABOVEL" +
	"OGICAL OR WITH DOT ABOVEDOUBLE LOGICAL ANDDOUBLE LOGICAL ORTWO INTERSECT" +
	"ING LOGICAL ANDTWO INTERSECTING LOGICAL ORSLOPING LARGE ORSLOPING LARGE " +
	"ANDLOGICAL OR OVERLAPPING LOGICAL ANDLOGICAL AND WITH MIDDLE STEMLOGICAL") + ("" +
	" OR WITH MIDDLE STEMLOGICAL AND WITH HORIZONTAL DASHLOGICAL OR WITH HORI" +
	"ZONTAL DASHLOGICAL AND WITH DOUBLE OVERBARLOGICAL AND WITH UNDERBARLOGIC" +
	"AL AND WITH DOUBLE UNDERBARSMALL VEE WITH UNDERBARLOGICAL OR WITH DOUBLE" +
	" OVERBARLOGICAL OR WITH DOUBLE UNDERBARZ NOTATION DOMAIN ANTIRESTRICTION" +
	"Z NOTATION RANGE ANTIRESTRICTIONEQUALS SIGN WITH DOT BELOWIDENTICAL WITH" +
	" DOT ABOVETRIPLE HORIZONTAL BAR WITH DOUBLE VERTICAL STROKETRIPLE HORIZO" +
	"NTAL BAR WITH TRIPLE VERTICAL STROKETILDE OPERATOR WITH DOT ABOVETILDE O" +
	"PERATOR WITH RISING DOTSSIMILAR MINUS SIMILARCONGRUENT WITH DOT ABOVEEQU" +
	"ALS WITH ASTERISKALMOST EQUAL TO WITH CIRCUMFLEX ACCENTAPPROXIMATELY EQU" +
	"AL OR EQUAL TOEQUALS SIGN ABOVE PLUS SIGNPLUS SIGN ABOVE EQUALS SIGNEQUA" +
	"LS SIGN ABOVE TILDE OPERATORDOUBLE COLON EQUALTWO CONSECUTIVE EQUALS SIG" +
	"NSTHREE CONSECUTIVE EQUALS SIGNSEQUALS SIGN WITH TWO DOTS ABOVE AND TWO " +
	"DOTS BELOWEQUIVALENT WITH FOUR DOTS ABOVELESS-THAN WITH CIRCLE INSIDEGRE" +
	"ATER-THAN WITH CIRCLE INSIDELESS-THAN WITH QUESTION MARK ABOVEGREATER-TH" +
	"AN WITH QUESTION MARK ABOVELESS-THAN OR SLANTED EQUAL TOGREATER-THAN OR " +
	"SLANTED EQUAL TOLESS-THAN OR SLANTED EQUAL TO WITH DOT INSIDEGREATER-THA" +
	"N OR SLANTED EQUAL TO WITH DOT INSIDELESS-THAN OR SLANTED EQUAL TO WITH " +
	"DOT ABOVEGREATER-THAN OR SLANTED EQUAL TO WITH DOT ABOVELESS-THAN OR SLA" +
	"NTED EQUAL TO WITH DOT ABOVE RIGHTGREATER-THAN OR SLANTED EQUAL TO WITH " +
	"DOT ABOVE LEFTLESS-THAN OR APPROXIMATEGREATER-THAN OR APPROXIMATELESS-TH" +
	"AN AND SINGLE-LINE NOT EQUAL TOGREATER-THAN AND SINGLE-LINE NOT EQUAL TO" +
	"LESS-THAN AND NOT APPROXIMATEGREATER-THAN AND NOT APPROXIMATELESS-THAN A" +
	"BOVE DOUBLE-LINE EQUAL ABOVE GREATER-THANGREATER-THAN ABOVE DOUBLE-LINE " +
	"EQUAL ABOVE LESS-THANLESS-THAN ABOVE SIMILAR OR EQUALGREATER-THAN ABOVE " +
	"SIMILAR OR EQUALLESS-THAN ABOVE SIMILAR ABOVE GREATER-THANGREATER-THAN A" +
	"BOVE SIMILAR ABOVE LESS-THANLESS-THAN ABOVE GREATER-THAN ABOVE DOUBLE-LI" +
	"NE EQUALGREATER-THAN ABOVE LESS-THAN ABOVE DOUBLE-LINE EQUALLESS-THAN AB" +
	"OVE SLANTED EQUAL ABOVE GREATER-THAN ABOVE SLANTED EQUALGREATER-THAN ABO" +
	"VE SLANTED EQUAL ABOVE LESS-THAN ABOVE SLANTED EQUALSLANTED EQUAL TO OR " +
	"LESS-THANSLANTED EQUAL TO OR GREATER-THANSLANTED EQUAL TO OR LESS-THAN W" +
	"ITH DOT INSIDESLANTED EQUAL TO OR GREATER-THAN WITH DOT INSIDEDOUBLE-LIN" +
	"E EQUAL TO OR LESS-THANDOUBLE-LINE EQUAL TO OR GREATER-THANDOUBLE-LINE S" +
	"LANTED EQUAL TO OR LESS-THANDOUBLE-LINE SLANTED EQUAL TO OR GREATER-THAN" +
	"SIMILAR OR LESS-THANSIMILAR OR GREATER-THANSIMILAR ABOVE LESS-THAN ABOVE" +
	" EQUALS SIGNSIMILAR ABOVE GREATER-THAN ABOVE EQUALS SIGNDOUBLE NESTED LE" +
	"SS-THANDOUBLE NESTED GREATER-THANDOUBLE NESTED LESS-THAN WITH UNDERBARGR" +
	"EATER-THAN OVERLAPPING LESS-THANGREATER-THAN BESIDE LESS-THANLESS-THAN C" +
	"LOSED BY CURVEGREATER-THAN CLOSED BY CURVELESS-THAN CLOSED BY CURVE ABOV" +
	"E SLANTED EQUALGREATER-THAN CLOSED BY CURVE ABOVE SLANTED EQUALSMALLER T" +
	"HANLARGER THANSMALLER THAN OR EQUAL TOLARGER THAN OR EQUAL TOEQUALS SIGN" +
	" WITH BUMPY ABOVEPRECEDES ABOVE SINGLE-LINE EQUALS SIGNSUCCEEDS ABOVE SI" +
	"NGLE-LINE EQUALS SIGNPRECEDES ABOVE SINGLE-LINE NOT EQUAL TOSUCCEEDS ABO" +
	"VE SINGLE-LINE NOT EQUAL TOPRECEDES ABOVE EQUALS SIGNSUCCEEDS ABOVE EQUA" +
	"LS SIGNPRECEDES ABOVE NOT EQUAL TOSUCCEEDS ABOVE NOT EQUAL TOPRECEDES AB" +
	"OVE ALMOST EQUAL TOSUCCEEDS ABOVE ALMOST EQUAL TOPRECEDES ABOVE NOT ALMO" +
	"ST EQUAL TOSUCCEEDS ABOVE NOT ALMOST EQUAL TODOUBLE PRECEDESDOUBLE SUCCE" +
	"EDSSUBSET WITH DOTSUPERSET WITH DOTSUBSET WITH PLUS SIGN BELOWSUPERSET W" +
	"ITH PLUS SIGN BELOWSUBSET WITH MULTIPLICATION SIGN BELOWSUPERSET WITH MU" +
	"LTIPLICATION SIGN BELOWSUBSET OF OR EQUAL TO WITH DOT ABOVESUPERSET OF O" +
	"R EQUAL TO WITH DOT ABOVESUBSET OF ABOVE EQUALS SIGNSUPERSET OF ABOVE EQ" +
	"UALS SIGNSUBSET OF ABOVE TILDE OPERATORSUPERSET OF ABOVE TILDE OPERATORS" +
	"UBSET OF ABOVE ALMOST EQUAL TOSUPERSET OF ABOVE ALMOST EQUAL TOSUBSET OF" +
	" ABOVE NOT EQUAL TOSUPERSET OF ABOVE NOT EQUAL TOSQUARE LEFT OPEN BOX OP" +
	"ERATORSQUARE RIGHT OPEN BOX OPERATORCLOSED SUBSETCLOSED SUPERSETCLOSED S" +
	"UBSET OR EQUAL TOCLOSED SUPERSET OR EQUAL TOSUBSET ABOVE SUPERSETSUPERSE" +
	"T ABOVE SUBSETSUBSET ABOVE SUBSETSUPERSET ABOVE SUPERSETSUPERSET BESIDE " +
	"SUBSETSUPERSET BESIDE AND JOINED BY DASH WITH SUBSETELEMENT OF OPENING D" +
	"OWNWARDSPITCHFORK WITH TEE TOPTRANSVERSAL INTERSECTIONFORKINGNONFORKINGS" +
	"HORT LEFT TACKSHORT DOWN TACKSHORT UP TACKPERPENDICULAR WITH SVERTICAL B" +
	"AR TRIPLE RIGHT TURNSTILEDOUBLE VERTICAL BAR LEFT TURNSTILEVERTICAL BAR " +
	"DOUBLE LEFT TURNSTILEDOUBLE VERTICAL BAR DOUBLE LEFT TURNSTILELONG DASH " +
	"FROM LEFT MEMBER OF DOUBLE VERTICALSHORT DOWN TACK WITH OVERBARSHORT UP " +
	"TACK WITH UNDERBARSHORT UP TACK ABOVE SHORT DOWN TACKDOUBLE DOWN TACKDOU" +
	"BLE UP TACKDOUBLE STROKE NOT SIGNREVERSED DOUBLE STROKE NOT SIGNDOES NOT") + ("" +
	" DIVIDE WITH REVERSED NEGATION SLASHVERTICAL LINE WITH CIRCLE ABOVEVERTI" +
	"CAL LINE WITH CIRCLE BELOWDOWN TACK WITH CIRCLE BELOWPARALLEL WITH HORIZ" +
	"ONTAL STROKEPARALLEL WITH TILDE OPERATORTRIPLE VERTICAL BAR BINARY RELAT" +
	"IONTRIPLE VERTICAL BAR WITH HORIZONTAL STROKETRIPLE COLON OPERATORTRIPLE" +
	" NESTED LESS-THANTRIPLE NESTED GREATER-THANDOUBLE-LINE SLANTED LESS-THAN" +
	" OR EQUAL TODOUBLE-LINE SLANTED GREATER-THAN OR EQUAL TOTRIPLE SOLIDUS B" +
	"INARY RELATIONLARGE TRIPLE VERTICAL BAR OPERATORDOUBLE SOLIDUS OPERATORW" +
	"HITE VERTICAL BARN-ARY WHITE VERTICAL BARNORTH EAST WHITE ARROWNORTH WES" +
	"T WHITE ARROWSOUTH EAST WHITE ARROWSOUTH WEST WHITE ARROWLEFT RIGHT WHIT" +
	"E ARROWLEFTWARDS BLACK ARROWUPWARDS BLACK ARROWDOWNWARDS BLACK ARROWNORT" +
	"H EAST BLACK ARROWNORTH WEST BLACK ARROWSOUTH EAST BLACK ARROWSOUTH WEST" +
	" BLACK ARROWLEFT RIGHT BLACK ARROWUP DOWN BLACK ARROWRIGHTWARDS ARROW WI" +
	"TH TIP DOWNWARDSRIGHTWARDS ARROW WITH TIP UPWARDSLEFTWARDS ARROW WITH TI" +
	"P DOWNWARDSLEFTWARDS ARROW WITH TIP UPWARDSSQUARE WITH TOP HALF BLACKSQU" +
	"ARE WITH BOTTOM HALF BLACKSQUARE WITH UPPER RIGHT DIAGONAL HALF BLACKSQU" +
	"ARE WITH LOWER LEFT DIAGONAL HALF BLACKDIAMOND WITH LEFT HALF BLACKDIAMO" +
	"ND WITH RIGHT HALF BLACKDIAMOND WITH TOP HALF BLACKDIAMOND WITH BOTTOM H" +
	"ALF BLACKDOTTED SQUAREBLACK LARGE SQUAREWHITE LARGE SQUAREBLACK VERY SMA" +
	"LL SQUAREWHITE VERY SMALL SQUAREBLACK PENTAGONWHITE PENTAGONWHITE HEXAGO" +
	"NBLACK HEXAGONHORIZONTAL BLACK HEXAGONBLACK LARGE CIRCLEBLACK MEDIUM DIA" +
	"MONDWHITE MEDIUM DIAMONDBLACK MEDIUM LOZENGEWHITE MEDIUM LOZENGEBLACK SM" +
	"ALL DIAMONDBLACK SMALL LOZENGEWHITE SMALL LOZENGEBLACK HORIZONTAL ELLIPS" +
	"EWHITE HORIZONTAL ELLIPSEBLACK VERTICAL ELLIPSEWHITE VERTICAL ELLIPSELEF" +
	"T ARROW WITH SMALL CIRCLETHREE LEFTWARDS ARROWSLEFT ARROW WITH CIRCLED P" +
	"LUSLONG LEFTWARDS SQUIGGLE ARROWLEFTWARDS TWO-HEADED ARROW WITH VERTICAL" +
	" STROKELEFTWARDS TWO-HEADED ARROW WITH DOUBLE VERTICAL STROKELEFTWARDS T" +
	"WO-HEADED ARROW FROM BARLEFTWARDS TWO-HEADED TRIPLE DASH ARROWLEFTWARDS " +
	"ARROW WITH DOTTED STEMLEFTWARDS ARROW WITH TAIL WITH VERTICAL STROKELEFT" +
	"WARDS ARROW WITH TAIL WITH DOUBLE VERTICAL STROKELEFTWARDS TWO-HEADED AR" +
	"ROW WITH TAILLEFTWARDS TWO-HEADED ARROW WITH TAIL WITH VERTICAL STROKELE" +
	"FTWARDS TWO-HEADED ARROW WITH TAIL WITH DOUBLE VERTICAL STROKELEFTWARDS " +
	"ARROW THROUGH XWAVE ARROW POINTING DIRECTLY LEFTEQUALS SIGN ABOVE LEFTWA" +
	"RDS ARROWREVERSE TILDE OPERATOR ABOVE LEFTWARDS ARROWLEFTWARDS ARROW ABO" +
	"VE REVERSE ALMOST EQUAL TORIGHTWARDS ARROW THROUGH GREATER-THANRIGHTWARD" +
	"S ARROW THROUGH SUPERSETLEFTWARDS QUADRUPLE ARROWRIGHTWARDS QUADRUPLE AR" +
	"ROWREVERSE TILDE OPERATOR ABOVE RIGHTWARDS ARROWRIGHTWARDS ARROW ABOVE R" +
	"EVERSE ALMOST EQUAL TOTILDE OPERATOR ABOVE LEFTWARDS ARROWLEFTWARDS ARRO" +
	"W ABOVE ALMOST EQUAL TOLEFTWARDS ARROW ABOVE REVERSE TILDE OPERATORRIGHT" +
	"WARDS ARROW ABOVE REVERSE TILDE OPERATORDOWNWARDS TRIANGLE-HEADED ZIGZAG" +
	" ARROWSHORT SLANTED NORTH ARROWSHORT BACKSLANTED SOUTH ARROWWHITE MEDIUM" +
	" STARBLACK SMALL STARWHITE SMALL STARBLACK RIGHT-POINTING PENTAGONWHITE " +
	"RIGHT-POINTING PENTAGONHEAVY LARGE CIRCLEHEAVY OVAL WITH OVAL INSIDEHEAV" +
	"Y CIRCLE WITH CIRCLE INSIDEHEAVY CIRCLEHEAVY CIRCLED SALTIRESLANTED NORT" +
	"H ARROW WITH HOOKED HEADBACKSLANTED SOUTH ARROW WITH HOOKED TAILSLANTED " +
	"NORTH ARROW WITH HORIZONTAL TAILBACKSLANTED SOUTH ARROW WITH HORIZONTAL " +
	"TAILBENT ARROW POINTING DOWNWARDS THEN NORTH EASTSHORT BENT ARROW POINTI" +
	"NG DOWNWARDS THEN NORTH EASTLEFTWARDS TRIANGLE-HEADED ARROWUPWARDS TRIAN" +
	"GLE-HEADED ARROWRIGHTWARDS TRIANGLE-HEADED ARROWDOWNWARDS TRIANGLE-HEADE" +
	"D ARROWLEFT RIGHT TRIANGLE-HEADED ARROWUP DOWN TRIANGLE-HEADED ARROWNORT" +
	"H WEST TRIANGLE-HEADED ARROWNORTH EAST TRIANGLE-HEADED ARROWSOUTH EAST T" +
	"RIANGLE-HEADED ARROWSOUTH WEST TRIANGLE-HEADED ARROWLEFTWARDS TRIANGLE-H" +
	"EADED DASHED ARROWUPWARDS TRIANGLE-HEADED DASHED ARROWRIGHTWARDS TRIANGL" +
	"E-HEADED DASHED ARROWDOWNWARDS TRIANGLE-HEADED DASHED ARROWCLOCKWISE TRI" +
	"ANGLE-HEADED OPEN CIRCLE ARROWANTICLOCKWISE TRIANGLE-HEADED OPEN CIRCLE " +
	"ARROWLEFTWARDS TRIANGLE-HEADED ARROW TO BARUPWARDS TRIANGLE-HEADED ARROW" +
	" TO BARRIGHTWARDS TRIANGLE-HEADED ARROW TO BARDOWNWARDS TRIANGLE-HEADED " +
	"ARROW TO BARNORTH WEST TRIANGLE-HEADED ARROW TO BARNORTH EAST TRIANGLE-H" +
	"EADED ARROW TO BARSOUTH EAST TRIANGLE-HEADED ARROW TO BARSOUTH WEST TRIA" +
	"NGLE-HEADED ARROW TO BARLEFTWARDS TRIANGLE-HEADED ARROW WITH DOUBLE HORI" +
	"ZONTAL STROKEUPWARDS TRIANGLE-HEADED ARROW WITH DOUBLE HORIZONTAL STROKE" +
	"RIGHTWARDS TRIANGLE-HEADED ARROW WITH DOUBLE HORIZONTAL STROKEDOWNWARDS " +
	"TRIANGLE-HEADED ARROW WITH DOUBLE HORIZONTAL STROKEHORIZONTAL TAB KEYVER" +
	"TICAL TAB KEYLEFTWARDS TRIANGLE-HEADED ARROW OVER RIGHTWARDS TRIANGLE-HE" +
	"ADED ARROWUPWARDS TRIANGLE-HEADED ARROW LEFTWARDS OF DOWNWARDS TRIANGLE-") + ("" +
	"HEADED ARROWRIGHTWARDS TRIANGLE-HEADED ARROW OVER LEFTWARDS TRIANGLE-HEA" +
	"DED ARROWDOWNWARDS TRIANGLE-HEADED ARROW LEFTWARDS OF UPWARDS TRIANGLE-H" +
	"EADED ARROWLEFTWARDS TRIANGLE-HEADED PAIRED ARROWSUPWARDS TRIANGLE-HEADE" +
	"D PAIRED ARROWSRIGHTWARDS TRIANGLE-HEADED PAIRED ARROWSDOWNWARDS TRIANGL" +
	"E-HEADED PAIRED ARROWSLEFTWARDS BLACK CIRCLED WHITE ARROWUPWARDS BLACK C" +
	"IRCLED WHITE ARROWRIGHTWARDS BLACK CIRCLED WHITE ARROWDOWNWARDS BLACK CI" +
	"RCLED WHITE ARROWANTICLOCKWISE TRIANGLE-HEADED RIGHT U-SHAPED ARROWANTIC" +
	"LOCKWISE TRIANGLE-HEADED BOTTOM U-SHAPED ARROWANTICLOCKWISE TRIANGLE-HEA" +
	"DED LEFT U-SHAPED ARROWANTICLOCKWISE TRIANGLE-HEADED TOP U-SHAPED ARROWR" +
	"ETURN LEFTRETURN RIGHTNEWLINE LEFTNEWLINE RIGHTFOUR CORNER ARROWS CIRCLI" +
	"NG ANTICLOCKWISERIGHTWARDS BLACK ARROWTHREE-D TOP-LIGHTED LEFTWARDS EQUI" +
	"LATERAL ARROWHEADTHREE-D RIGHT-LIGHTED UPWARDS EQUILATERAL ARROWHEADTHRE" +
	"E-D TOP-LIGHTED RIGHTWARDS EQUILATERAL ARROWHEADTHREE-D LEFT-LIGHTED DOW" +
	"NWARDS EQUILATERAL ARROWHEADBLACK LEFTWARDS EQUILATERAL ARROWHEADBLACK U" +
	"PWARDS EQUILATERAL ARROWHEADBLACK RIGHTWARDS EQUILATERAL ARROWHEADBLACK " +
	"DOWNWARDS EQUILATERAL ARROWHEADDOWNWARDS TRIANGLE-HEADED ARROW WITH LONG" +
	" TIP LEFTWARDSDOWNWARDS TRIANGLE-HEADED ARROW WITH LONG TIP RIGHTWARDSUP" +
	"WARDS TRIANGLE-HEADED ARROW WITH LONG TIP LEFTWARDSUPWARDS TRIANGLE-HEAD" +
	"ED ARROW WITH LONG TIP RIGHTWARDSLEFTWARDS TRIANGLE-HEADED ARROW WITH LO" +
	"NG TIP UPWARDSRIGHTWARDS TRIANGLE-HEADED ARROW WITH LONG TIP UPWARDSLEFT" +
	"WARDS TRIANGLE-HEADED ARROW WITH LONG TIP DOWNWARDSRIGHTWARDS TRIANGLE-H" +
	"EADED ARROW WITH LONG TIP DOWNWARDSBLACK CURVED DOWNWARDS AND LEFTWARDS " +
	"ARROWBLACK CURVED DOWNWARDS AND RIGHTWARDS ARROWBLACK CURVED UPWARDS AND" +
	" LEFTWARDS ARROWBLACK CURVED UPWARDS AND RIGHTWARDS ARROWBLACK CURVED LE" +
	"FTWARDS AND UPWARDS ARROWBLACK CURVED RIGHTWARDS AND UPWARDS ARROWBLACK " +
	"CURVED LEFTWARDS AND DOWNWARDS ARROWBLACK CURVED RIGHTWARDS AND DOWNWARD" +
	"S ARROWRIBBON ARROW DOWN LEFTRIBBON ARROW DOWN RIGHTRIBBON ARROW UP LEFT" +
	"RIBBON ARROW UP RIGHTRIBBON ARROW LEFT UPRIBBON ARROW RIGHT UPRIBBON ARR" +
	"OW LEFT DOWNRIBBON ARROW RIGHT DOWNUPWARDS WHITE ARROW FROM BAR WITH HOR" +
	"IZONTAL BARUP ARROWHEAD IN A RECTANGLE BOXOVERLAPPING WHITE SQUARESOVERL" +
	"APPING WHITE AND BLACK SQUARESOVERLAPPING BLACK SQUARESBALLOT BOX WITH L" +
	"IGHT XCIRCLED XCIRCLED BOLD XBLACK SQUARE CENTREDBLACK DIAMOND CENTREDTU" +
	"RNED BLACK PENTAGONHORIZONTAL BLACK OCTAGONBLACK OCTAGONBLACK MEDIUM UP-" +
	"POINTING TRIANGLE CENTREDBLACK MEDIUM DOWN-POINTING TRIANGLE CENTREDBLAC" +
	"K MEDIUM LEFT-POINTING TRIANGLE CENTREDBLACK MEDIUM RIGHT-POINTING TRIAN" +
	"GLE CENTREDNEPTUNE FORM TWOTOP HALF BLACK CIRCLEBOTTOM HALF BLACK CIRCLE" +
	"LIGHT FOUR POINTED BLACK CUSPROTATED LIGHT FOUR POINTED BLACK CUSPWHITE " +
	"FOUR POINTED CUSPROTATED WHITE FOUR POINTED CUSPSQUARE POSITION INDICATO" +
	"RUNCERTAINTY SIGNGROUP MARKPLUTO FORM TWOPLUTO FORM THREEPLUTO FORM FOUR" +
	"PLUTO FORM FIVETRANSPLUTOPROSERPINAASTRAEAHYGIEAPHOLUSNESSUSWHITE MOON S" +
	"ELENABLACK DIAMOND ON CROSSTRUE LIGHT MOON ARTACUPIDOHADESZEUSKRONOSAPOL" +
	"LONADMETOSVULCANUSPOSEIDONLEFT HALF BLACK STARRIGHT HALF BLACK STARSTAR " +
	"WITH LEFT HALF BLACKSTAR WITH RIGHT HALF BLACKLEFTWARDS TWO-HEADED ARROW" +
	" WITH TRIANGLE ARROWHEADSUPWARDS TWO-HEADED ARROW WITH TRIANGLE ARROWHEA" +
	"DSRIGHTWARDS TWO-HEADED ARROW WITH TRIANGLE ARROWHEADSDOWNWARDS TWO-HEAD" +
	"ED ARROW WITH TRIANGLE ARROWHEADSERIS FORM ONEERIS FORM TWOSEDNARUSSIAN " +
	"ASTROLOGICAL SYMBOL VIGINTILERUSSIAN ASTROLOGICAL SYMBOL NOVILERUSSIAN A" +
	"STROLOGICAL SYMBOL QUINTILERUSSIAN ASTROLOGICAL SYMBOL BINOVILERUSSIAN A" +
	"STROLOGICAL SYMBOL SENTAGONRUSSIAN ASTROLOGICAL SYMBOL TREDECILEEQUALS S" +
	"IGN WITH INFINITY BELOWUNITED SYMBOLSEPARATED SYMBOLDOUBLED SYMBOLPASSED" +
	" SYMBOLREVERSED RIGHT ANGLEHELLSCHREIBER PAUSE SYMBOLGLAGOLITIC CAPITAL " +
	"LETTER AZUGLAGOLITIC CAPITAL LETTER BUKYGLAGOLITIC CAPITAL LETTER VEDEGL" +
	"AGOLITIC CAPITAL LETTER GLAGOLIGLAGOLITIC CAPITAL LETTER DOBROGLAGOLITIC" +
	" CAPITAL LETTER YESTUGLAGOLITIC CAPITAL LETTER ZHIVETEGLAGOLITIC CAPITAL" +
	" LETTER DZELOGLAGOLITIC CAPITAL LETTER ZEMLJAGLAGOLITIC CAPITAL LETTER I" +
	"ZHEGLAGOLITIC CAPITAL LETTER INITIAL IZHEGLAGOLITIC CAPITAL LETTER IGLAG" +
	"OLITIC CAPITAL LETTER DJERVIGLAGOLITIC CAPITAL LETTER KAKOGLAGOLITIC CAP" +
	"ITAL LETTER LJUDIJEGLAGOLITIC CAPITAL LETTER MYSLITEGLAGOLITIC CAPITAL L" +
	"ETTER NASHIGLAGOLITIC CAPITAL LETTER ONUGLAGOLITIC CAPITAL LETTER POKOJI" +
	"GLAGOLITIC CAPITAL LETTER RITSIGLAGOLITIC CAPITAL LETTER SLOVOGLAGOLITIC" +
	" CAPITAL LETTER TVRIDOGLAGOLITIC CAPITAL LETTER UKUGLAGOLITIC CAPITAL LE" +
	"TTER FRITUGLAGOLITIC CAPITAL LETTER HERUGLAGOLITIC CAPITAL LETTER OTUGLA" +
	"GOLITIC CAPITAL LETTER PEGLAGOLITIC CAPITAL LETTER SHTAGLAGOLITIC CAPITA" +
	"L LETTER TSIGLAGOLITIC CAPITAL LETTER CHRIVIGLAGOLITIC CAPITAL LETTER SH") + ("" +
	"AGLAGOLITIC CAPITAL LETTER YERUGLAGOLITIC CAPITAL LETTER YERIGLAGOLITIC " +
	"CAPITAL LETTER YATIGLAGOLITIC CAPITAL LETTER SPIDERY HAGLAGOLITIC CAPITA" +
	"L LETTER YUGLAGOLITIC CAPITAL LETTER SMALL YUSGLAGOLITIC CAPITAL LETTER " +
	"SMALL YUS WITH TAILGLAGOLITIC CAPITAL LETTER YOGLAGOLITIC CAPITAL LETTER" +
	" IOTATED SMALL YUSGLAGOLITIC CAPITAL LETTER BIG YUSGLAGOLITIC CAPITAL LE" +
	"TTER IOTATED BIG YUSGLAGOLITIC CAPITAL LETTER FITAGLAGOLITIC CAPITAL LET" +
	"TER IZHITSAGLAGOLITIC CAPITAL LETTER SHTAPICGLAGOLITIC CAPITAL LETTER TR" +
	"OKUTASTI AGLAGOLITIC CAPITAL LETTER LATINATE MYSLITEGLAGOLITIC SMALL LET" +
	"TER AZUGLAGOLITIC SMALL LETTER BUKYGLAGOLITIC SMALL LETTER VEDEGLAGOLITI" +
	"C SMALL LETTER GLAGOLIGLAGOLITIC SMALL LETTER DOBROGLAGOLITIC SMALL LETT" +
	"ER YESTUGLAGOLITIC SMALL LETTER ZHIVETEGLAGOLITIC SMALL LETTER DZELOGLAG" +
	"OLITIC SMALL LETTER ZEMLJAGLAGOLITIC SMALL LETTER IZHEGLAGOLITIC SMALL L" +
	"ETTER INITIAL IZHEGLAGOLITIC SMALL LETTER IGLAGOLITIC SMALL LETTER DJERV" +
	"IGLAGOLITIC SMALL LETTER KAKOGLAGOLITIC SMALL LETTER LJUDIJEGLAGOLITIC S" +
	"MALL LETTER MYSLITEGLAGOLITIC SMALL LETTER NASHIGLAGOLITIC SMALL LETTER " +
	"ONUGLAGOLITIC SMALL LETTER POKOJIGLAGOLITIC SMALL LETTER RITSIGLAGOLITIC" +
	" SMALL LETTER SLOVOGLAGOLITIC SMALL LETTER TVRIDOGLAGOLITIC SMALL LETTER" +
	" UKUGLAGOLITIC SMALL LETTER FRITUGLAGOLITIC SMALL LETTER HERUGLAGOLITIC " +
	"SMALL LETTER OTUGLAGOLITIC SMALL LETTER PEGLAGOLITIC SMALL LETTER SHTAGL" +
	"AGOLITIC SMALL LETTER TSIGLAGOLITIC SMALL LETTER CHRIVIGLAGOLITIC SMALL " +
	"LETTER SHAGLAGOLITIC SMALL LETTER YERUGLAGOLITIC SMALL LETTER YERIGLAGOL" +
	"ITIC SMALL LETTER YATIGLAGOLITIC SMALL LETTER SPIDERY HAGLAGOLITIC SMALL" +
	" LETTER YUGLAGOLITIC SMALL LETTER SMALL YUSGLAGOLITIC SMALL LETTER SMALL" +
	" YUS WITH TAILGLAGOLITIC SMALL LETTER YOGLAGOLITIC SMALL LETTER IOTATED " +
	"SMALL YUSGLAGOLITIC SMALL LETTER BIG YUSGLAGOLITIC SMALL LETTER IOTATED " +
	"BIG YUSGLAGOLITIC SMALL LETTER FITAGLAGOLITIC SMALL LETTER IZHITSAGLAGOL" +
	"ITIC SMALL LETTER SHTAPICGLAGOLITIC SMALL LETTER TROKUTASTI AGLAGOLITIC " +
	"SMALL LETTER LATINATE MYSLITELATIN CAPITAL LETTER L WITH DOUBLE BARLATIN" +
	" SMALL LETTER L WITH DOUBLE BARLATIN CAPITAL LETTER L WITH MIDDLE TILDEL" +
	"ATIN CAPITAL LETTER P WITH STROKELATIN CAPITAL LETTER R WITH TAILLATIN S" +
	"MALL LETTER A WITH STROKELATIN SMALL LETTER T WITH DIAGONAL STROKELATIN " +
	"CAPITAL LETTER H WITH DESCENDERLATIN SMALL LETTER H WITH DESCENDERLATIN " +
	"CAPITAL LETTER K WITH DESCENDERLATIN SMALL LETTER K WITH DESCENDERLATIN " +
	"CAPITAL LETTER Z WITH DESCENDERLATIN SMALL LETTER Z WITH DESCENDERLATIN " +
	"CAPITAL LETTER ALPHALATIN CAPITAL LETTER M WITH HOOKLATIN CAPITAL LETTER" +
	" TURNED ALATIN CAPITAL LETTER TURNED ALPHALATIN SMALL LETTER V WITH RIGH" +
	"T HOOKLATIN CAPITAL LETTER W WITH HOOKLATIN SMALL LETTER W WITH HOOKLATI" +
	"N SMALL LETTER V WITH CURLLATIN CAPITAL LETTER HALF HLATIN SMALL LETTER " +
	"HALF HLATIN SMALL LETTER TAILLESS PHILATIN SMALL LETTER E WITH NOTCHLATI" +
	"N SMALL LETTER TURNED R WITH TAILLATIN SMALL LETTER O WITH LOW RING INSI" +
	"DELATIN LETTER SMALL CAPITAL TURNED ELATIN SUBSCRIPT SMALL LETTER JMODIF" +
	"IER LETTER CAPITAL VLATIN CAPITAL LETTER S WITH SWASH TAILLATIN CAPITAL " +
	"LETTER Z WITH SWASH TAILCOPTIC CAPITAL LETTER ALFACOPTIC SMALL LETTER AL" +
	"FACOPTIC CAPITAL LETTER VIDACOPTIC SMALL LETTER VIDACOPTIC CAPITAL LETTE" +
	"R GAMMACOPTIC SMALL LETTER GAMMACOPTIC CAPITAL LETTER DALDACOPTIC SMALL " +
	"LETTER DALDACOPTIC CAPITAL LETTER EIECOPTIC SMALL LETTER EIECOPTIC CAPIT" +
	"AL LETTER SOUCOPTIC SMALL LETTER SOUCOPTIC CAPITAL LETTER ZATACOPTIC SMA" +
	"LL LETTER ZATACOPTIC CAPITAL LETTER HATECOPTIC SMALL LETTER HATECOPTIC C" +
	"APITAL LETTER THETHECOPTIC SMALL LETTER THETHECOPTIC CAPITAL LETTER IAUD" +
	"ACOPTIC SMALL LETTER IAUDACOPTIC CAPITAL LETTER KAPACOPTIC SMALL LETTER " +
	"KAPACOPTIC CAPITAL LETTER LAULACOPTIC SMALL LETTER LAULACOPTIC CAPITAL L" +
	"ETTER MICOPTIC SMALL LETTER MICOPTIC CAPITAL LETTER NICOPTIC SMALL LETTE" +
	"R NICOPTIC CAPITAL LETTER KSICOPTIC SMALL LETTER KSICOPTIC CAPITAL LETTE" +
	"R OCOPTIC SMALL LETTER OCOPTIC CAPITAL LETTER PICOPTIC SMALL LETTER PICO" +
	"PTIC CAPITAL LETTER ROCOPTIC SMALL LETTER ROCOPTIC CAPITAL LETTER SIMACO" +
	"PTIC SMALL LETTER SIMACOPTIC CAPITAL LETTER TAUCOPTIC SMALL LETTER TAUCO" +
	"PTIC CAPITAL LETTER UACOPTIC SMALL LETTER UACOPTIC CAPITAL LETTER FICOPT" +
	"IC SMALL LETTER FICOPTIC CAPITAL LETTER KHICOPTIC SMALL LETTER KHICOPTIC" +
	" CAPITAL LETTER PSICOPTIC SMALL LETTER PSICOPTIC CAPITAL LETTER OOUCOPTI" +
	"C SMALL LETTER OOUCOPTIC CAPITAL LETTER DIALECT-P ALEFCOPTIC SMALL LETTE" +
	"R DIALECT-P ALEFCOPTIC CAPITAL LETTER OLD COPTIC AINCOPTIC SMALL LETTER " +
	"OLD COPTIC AINCOPTIC CAPITAL LETTER CRYPTOGRAMMIC EIECOPTIC SMALL LETTER" +
	" CRYPTOGRAMMIC EIECOPTIC CAPITAL LETTER DIALECT-P KAPACOPTIC SMALL LETTE" +
	"R DIALECT-P KAPACOPTIC CAPITAL LETTER DIALECT-P NICOPTIC SMALL LETTER DI") + ("" +
	"ALECT-P NICOPTIC CAPITAL LETTER CRYPTOGRAMMIC NICOPTIC SMALL LETTER CRYP" +
	"TOGRAMMIC NICOPTIC CAPITAL LETTER OLD COPTIC OOUCOPTIC SMALL LETTER OLD " +
	"COPTIC OOUCOPTIC CAPITAL LETTER SAMPICOPTIC SMALL LETTER SAMPICOPTIC CAP" +
	"ITAL LETTER CROSSED SHEICOPTIC SMALL LETTER CROSSED SHEICOPTIC CAPITAL L" +
	"ETTER OLD COPTIC SHEICOPTIC SMALL LETTER OLD COPTIC SHEICOPTIC CAPITAL L" +
	"ETTER OLD COPTIC ESHCOPTIC SMALL LETTER OLD COPTIC ESHCOPTIC CAPITAL LET" +
	"TER AKHMIMIC KHEICOPTIC SMALL LETTER AKHMIMIC KHEICOPTIC CAPITAL LETTER " +
	"DIALECT-P HORICOPTIC SMALL LETTER DIALECT-P HORICOPTIC CAPITAL LETTER OL" +
	"D COPTIC HORICOPTIC SMALL LETTER OLD COPTIC HORICOPTIC CAPITAL LETTER OL" +
	"D COPTIC HACOPTIC SMALL LETTER OLD COPTIC HACOPTIC CAPITAL LETTER L-SHAP" +
	"ED HACOPTIC SMALL LETTER L-SHAPED HACOPTIC CAPITAL LETTER OLD COPTIC HEI" +
	"COPTIC SMALL LETTER OLD COPTIC HEICOPTIC CAPITAL LETTER OLD COPTIC HATCO" +
	"PTIC SMALL LETTER OLD COPTIC HATCOPTIC CAPITAL LETTER OLD COPTIC GANGIAC" +
	"OPTIC SMALL LETTER OLD COPTIC GANGIACOPTIC CAPITAL LETTER OLD COPTIC DJA" +
	"COPTIC SMALL LETTER OLD COPTIC DJACOPTIC CAPITAL LETTER OLD COPTIC SHIMA" +
	"COPTIC SMALL LETTER OLD COPTIC SHIMACOPTIC CAPITAL LETTER OLD NUBIAN SHI" +
	"MACOPTIC SMALL LETTER OLD NUBIAN SHIMACOPTIC CAPITAL LETTER OLD NUBIAN N" +
	"GICOPTIC SMALL LETTER OLD NUBIAN NGICOPTIC CAPITAL LETTER OLD NUBIAN NYI" +
	"COPTIC SMALL LETTER OLD NUBIAN NYICOPTIC CAPITAL LETTER OLD NUBIAN WAUCO" +
	"PTIC SMALL LETTER OLD NUBIAN WAUCOPTIC SYMBOL KAICOPTIC SYMBOL MI ROCOPT" +
	"IC SYMBOL PI ROCOPTIC SYMBOL STAUROSCOPTIC SYMBOL TAU ROCOPTIC SYMBOL KH" +
	"I ROCOPTIC SYMBOL SHIMA SIMACOPTIC CAPITAL LETTER CRYPTOGRAMMIC SHEICOPT" +
	"IC SMALL LETTER CRYPTOGRAMMIC SHEICOPTIC CAPITAL LETTER CRYPTOGRAMMIC GA" +
	"NGIACOPTIC SMALL LETTER CRYPTOGRAMMIC GANGIACOPTIC COMBINING NI ABOVECOP" +
	"TIC COMBINING SPIRITUS ASPERCOPTIC COMBINING SPIRITUS LENISCOPTIC CAPITA" +
	"L LETTER BOHAIRIC KHEICOPTIC SMALL LETTER BOHAIRIC KHEICOPTIC OLD NUBIAN" +
	" FULL STOPCOPTIC OLD NUBIAN DIRECT QUESTION MARKCOPTIC OLD NUBIAN INDIRE" +
	"CT QUESTION MARKCOPTIC OLD NUBIAN VERSE DIVIDERCOPTIC FRACTION ONE HALFC" +
	"OPTIC FULL STOPCOPTIC MORPHOLOGICAL DIVIDERGEORGIAN SMALL LETTER ANGEORG" +
	"IAN SMALL LETTER BANGEORGIAN SMALL LETTER GANGEORGIAN SMALL LETTER DONGE" +
	"ORGIAN SMALL LETTER ENGEORGIAN SMALL LETTER VINGEORGIAN SMALL LETTER ZEN" +
	"GEORGIAN SMALL LETTER TANGEORGIAN SMALL LETTER INGEORGIAN SMALL LETTER K" +
	"ANGEORGIAN SMALL LETTER LASGEORGIAN SMALL LETTER MANGEORGIAN SMALL LETTE" +
	"R NARGEORGIAN SMALL LETTER ONGEORGIAN SMALL LETTER PARGEORGIAN SMALL LET" +
	"TER ZHARGEORGIAN SMALL LETTER RAEGEORGIAN SMALL LETTER SANGEORGIAN SMALL" +
	" LETTER TARGEORGIAN SMALL LETTER UNGEORGIAN SMALL LETTER PHARGEORGIAN SM" +
	"ALL LETTER KHARGEORGIAN SMALL LETTER GHANGEORGIAN SMALL LETTER QARGEORGI" +
	"AN SMALL LETTER SHINGEORGIAN SMALL LETTER CHINGEORGIAN SMALL LETTER CANG" +
	"EORGIAN SMALL LETTER JILGEORGIAN SMALL LETTER CILGEORGIAN SMALL LETTER C" +
	"HARGEORGIAN SMALL LETTER XANGEORGIAN SMALL LETTER JHANGEORGIAN SMALL LET" +
	"TER HAEGEORGIAN SMALL LETTER HEGEORGIAN SMALL LETTER HIEGEORGIAN SMALL L" +
	"ETTER WEGEORGIAN SMALL LETTER HARGEORGIAN SMALL LETTER HOEGEORGIAN SMALL" +
	" LETTER YNGEORGIAN SMALL LETTER AENTIFINAGH LETTER YATIFINAGH LETTER YAB" +
	"TIFINAGH LETTER YABHTIFINAGH LETTER YAGTIFINAGH LETTER YAGHHTIFINAGH LET" +
	"TER BERBER ACADEMY YAJTIFINAGH LETTER YAJTIFINAGH LETTER YADTIFINAGH LET" +
	"TER YADHTIFINAGH LETTER YADDTIFINAGH LETTER YADDHTIFINAGH LETTER YEYTIFI" +
	"NAGH LETTER YAFTIFINAGH LETTER YAKTIFINAGH LETTER TUAREG YAKTIFINAGH LET" +
	"TER YAKHHTIFINAGH LETTER YAHTIFINAGH LETTER BERBER ACADEMY YAHTIFINAGH L" +
	"ETTER TUAREG YAHTIFINAGH LETTER YAHHTIFINAGH LETTER YAATIFINAGH LETTER Y" +
	"AKHTIFINAGH LETTER TUAREG YAKHTIFINAGH LETTER YAQTIFINAGH LETTER TUAREG " +
	"YAQTIFINAGH LETTER YITIFINAGH LETTER YAZHTIFINAGH LETTER AHAGGAR YAZHTIF" +
	"INAGH LETTER TUAREG YAZHTIFINAGH LETTER YALTIFINAGH LETTER YAMTIFINAGH L" +
	"ETTER YANTIFINAGH LETTER TUAREG YAGNTIFINAGH LETTER TUAREG YANGTIFINAGH " +
	"LETTER YAPTIFINAGH LETTER YUTIFINAGH LETTER YARTIFINAGH LETTER YARRTIFIN" +
	"AGH LETTER YAGHTIFINAGH LETTER TUAREG YAGHTIFINAGH LETTER AYER YAGHTIFIN" +
	"AGH LETTER YASTIFINAGH LETTER YASSTIFINAGH LETTER YASHTIFINAGH LETTER YA" +
	"TTIFINAGH LETTER YATHTIFINAGH LETTER YACHTIFINAGH LETTER YATTTIFINAGH LE" +
	"TTER YAVTIFINAGH LETTER YAWTIFINAGH LETTER YAYTIFINAGH LETTER YAZTIFINAG" +
	"H LETTER TAWELLEMET YAZTIFINAGH LETTER YAZZTIFINAGH LETTER YETIFINAGH LE" +
	"TTER YOTIFINAGH MODIFIER LETTER LABIALIZATION MARKTIFINAGH SEPARATOR MAR" +
	"KTIFINAGH CONSONANT JOINERETHIOPIC SYLLABLE LOAETHIOPIC SYLLABLE MOAETHI" +
	"OPIC SYLLABLE ROAETHIOPIC SYLLABLE SOAETHIOPIC SYLLABLE SHOAETHIOPIC SYL" +
	"LABLE BOAETHIOPIC SYLLABLE TOAETHIOPIC SYLLABLE COAETHIOPIC SYLLABLE NOA" +
	"ETHIOPIC SYLLABLE NYOAETHIOPIC SYLLABLE GLOTTAL OAETHIOPIC SYLLABLE ZOAE") + ("" +
	"THIOPIC SYLLABLE DOAETHIOPIC SYLLABLE DDOAETHIOPIC SYLLABLE JOAETHIOPIC " +
	"SYLLABLE THOAETHIOPIC SYLLABLE CHOAETHIOPIC SYLLABLE PHOAETHIOPIC SYLLAB" +
	"LE POAETHIOPIC SYLLABLE GGWAETHIOPIC SYLLABLE GGWIETHIOPIC SYLLABLE GGWE" +
	"EETHIOPIC SYLLABLE GGWEETHIOPIC SYLLABLE SSAETHIOPIC SYLLABLE SSUETHIOPI" +
	"C SYLLABLE SSIETHIOPIC SYLLABLE SSAAETHIOPIC SYLLABLE SSEEETHIOPIC SYLLA" +
	"BLE SSEETHIOPIC SYLLABLE SSOETHIOPIC SYLLABLE CCAETHIOPIC SYLLABLE CCUET" +
	"HIOPIC SYLLABLE CCIETHIOPIC SYLLABLE CCAAETHIOPIC SYLLABLE CCEEETHIOPIC " +
	"SYLLABLE CCEETHIOPIC SYLLABLE CCOETHIOPIC SYLLABLE ZZAETHIOPIC SYLLABLE " +
	"ZZUETHIOPIC SYLLABLE ZZIETHIOPIC SYLLABLE ZZAAETHIOPIC SYLLABLE ZZEEETHI" +
	"OPIC SYLLABLE ZZEETHIOPIC SYLLABLE ZZOETHIOPIC SYLLABLE CCHAETHIOPIC SYL" +
	"LABLE CCHUETHIOPIC SYLLABLE CCHIETHIOPIC SYLLABLE CCHAAETHIOPIC SYLLABLE" +
	" CCHEEETHIOPIC SYLLABLE CCHEETHIOPIC SYLLABLE CCHOETHIOPIC SYLLABLE QYAE" +
	"THIOPIC SYLLABLE QYUETHIOPIC SYLLABLE QYIETHIOPIC SYLLABLE QYAAETHIOPIC " +
	"SYLLABLE QYEEETHIOPIC SYLLABLE QYEETHIOPIC SYLLABLE QYOETHIOPIC SYLLABLE" +
	" KYAETHIOPIC SYLLABLE KYUETHIOPIC SYLLABLE KYIETHIOPIC SYLLABLE KYAAETHI" +
	"OPIC SYLLABLE KYEEETHIOPIC SYLLABLE KYEETHIOPIC SYLLABLE KYOETHIOPIC SYL" +
	"LABLE XYAETHIOPIC SYLLABLE XYUETHIOPIC SYLLABLE XYIETHIOPIC SYLLABLE XYA" +
	"AETHIOPIC SYLLABLE XYEEETHIOPIC SYLLABLE XYEETHIOPIC SYLLABLE XYOETHIOPI" +
	"C SYLLABLE GYAETHIOPIC SYLLABLE GYUETHIOPIC SYLLABLE GYIETHIOPIC SYLLABL" +
	"E GYAAETHIOPIC SYLLABLE GYEEETHIOPIC SYLLABLE GYEETHIOPIC SYLLABLE GYOCO" +
	"MBINING CYRILLIC LETTER BECOMBINING CYRILLIC LETTER VECOMBINING CYRILLIC" +
	" LETTER GHECOMBINING CYRILLIC LETTER DECOMBINING CYRILLIC LETTER ZHECOMB" +
	"INING CYRILLIC LETTER ZECOMBINING CYRILLIC LETTER KACOMBINING CYRILLIC L" +
	"ETTER ELCOMBINING CYRILLIC LETTER EMCOMBINING CYRILLIC LETTER ENCOMBININ" +
	"G CYRILLIC LETTER OCOMBINING CYRILLIC LETTER PECOMBINING CYRILLIC LETTER" +
	" ERCOMBINING CYRILLIC LETTER ESCOMBINING CYRILLIC LETTER TECOMBINING CYR" +
	"ILLIC LETTER HACOMBINING CYRILLIC LETTER TSECOMBINING CYRILLIC LETTER CH" +
	"ECOMBINING CYRILLIC LETTER SHACOMBINING CYRILLIC LETTER SHCHACOMBINING C" +
	"YRILLIC LETTER FITACOMBINING CYRILLIC LETTER ES-TECOMBINING CYRILLIC LET" +
	"TER ACOMBINING CYRILLIC LETTER IECOMBINING CYRILLIC LETTER DJERVCOMBININ" +
	"G CYRILLIC LETTER MONOGRAPH UKCOMBINING CYRILLIC LETTER YATCOMBINING CYR" +
	"ILLIC LETTER YUCOMBINING CYRILLIC LETTER IOTIFIED ACOMBINING CYRILLIC LE" +
	"TTER LITTLE YUSCOMBINING CYRILLIC LETTER BIG YUSCOMBINING CYRILLIC LETTE" +
	"R IOTIFIED BIG YUSRIGHT ANGLE SUBSTITUTION MARKERRIGHT ANGLE DOTTED SUBS" +
	"TITUTION MARKERLEFT SUBSTITUTION BRACKETRIGHT SUBSTITUTION BRACKETLEFT D" +
	"OTTED SUBSTITUTION BRACKETRIGHT DOTTED SUBSTITUTION BRACKETRAISED INTERP" +
	"OLATION MARKERRAISED DOTTED INTERPOLATION MARKERDOTTED TRANSPOSITION MAR" +
	"KERLEFT TRANSPOSITION BRACKETRIGHT TRANSPOSITION BRACKETRAISED SQUARELEF" +
	"T RAISED OMISSION BRACKETRIGHT RAISED OMISSION BRACKETEDITORIAL CORONISP" +
	"ARAGRAPHOSFORKED PARAGRAPHOSREVERSED FORKED PARAGRAPHOSHYPODIASTOLEDOTTE" +
	"D OBELOSDOWNWARDS ANCORAUPWARDS ANCORADOTTED RIGHT-POINTING ANGLEDOUBLE " +
	"OBLIQUE HYPHENINVERTED INTERROBANGPALM BRANCHHYPHEN WITH DIAERESISTILDE " +
	"WITH RING ABOVELEFT LOW PARAPHRASE BRACKETRIGHT LOW PARAPHRASE BRACKETTI" +
	"LDE WITH DOT ABOVETILDE WITH DOT BELOWLEFT VERTICAL BAR WITH QUILLRIGHT " +
	"VERTICAL BAR WITH QUILLTOP LEFT HALF BRACKETTOP RIGHT HALF BRACKETBOTTOM" +
	" LEFT HALF BRACKETBOTTOM RIGHT HALF BRACKETLEFT SIDEWAYS U BRACKETRIGHT " +
	"SIDEWAYS U BRACKETLEFT DOUBLE PARENTHESISRIGHT DOUBLE PARENTHESISTWO DOT" +
	"S OVER ONE DOT PUNCTUATIONONE DOT OVER TWO DOTS PUNCTUATIONSQUARED FOUR " +
	"DOT PUNCTUATIONFIVE DOT MARKREVERSED QUESTION MARKVERTICAL TILDERING POI" +
	"NTWORD SEPARATOR MIDDLE DOTTURNED COMMARAISED DOTRAISED COMMATURNED SEMI" +
	"COLONDAGGER WITH LEFT GUARDDAGGER WITH RIGHT GUARDTURNED DAGGERTOP HALF " +
	"SECTION SIGNTWO-EM DASHTHREE-EM DASHSTENOGRAPHIC FULL STOPVERTICAL SIX D" +
	"OTSWIGGLY VERTICAL LINECAPITULUMDOUBLE HYPHENREVERSED COMMADOUBLE LOW-RE" +
	"VERSED-9 QUOTATION MARKDASH WITH LEFT UPTURNDOUBLE SUSPENSION MARKINVERT" +
	"ED LOW KAVYKAINVERTED LOW KAVYKA WITH KAVYKA ABOVELOW KAVYKALOW KAVYKA W" +
	"ITH DOTDOUBLE STACKED COMMADOTTED SOLIDUSTRIPLE DAGGERMEDIEVAL COMMAPARA" +
	"GRAPHUS MARKPUNCTUS ELEVATUS MARKCORNISH VERSE DIVIDERCJK RADICAL REPEAT" +
	"CJK RADICAL CLIFFCJK RADICAL SECOND ONECJK RADICAL SECOND TWOCJK RADICAL" +
	" SECOND THREECJK RADICAL PERSONCJK RADICAL BOXCJK RADICAL TABLECJK RADIC" +
	"AL KNIFE ONECJK RADICAL KNIFE TWOCJK RADICAL DIVINATIONCJK RADICAL SEALC" +
	"JK RADICAL SMALL ONECJK RADICAL SMALL TWOCJK RADICAL LAME ONECJK RADICAL" +
	" LAME TWOCJK RADICAL LAME THREECJK RADICAL LAME FOURCJK RADICAL SNAKECJK" +
	" RADICAL THREADCJK RADICAL SNOUT ONECJK RADICAL SNOUT TWOCJK RADICAL HEA" +
	"RT ONECJK RADICAL HEART TWOCJK RADICAL HANDCJK RADICAL RAPCJK RADICAL CH") + ("" +
	"OKECJK RADICAL SUNCJK RADICAL MOONCJK RADICAL DEATHCJK RADICAL MOTHERCJK" +
	" RADICAL CIVILIANCJK RADICAL WATER ONECJK RADICAL WATER TWOCJK RADICAL F" +
	"IRECJK RADICAL PAW ONECJK RADICAL PAW TWOCJK RADICAL SIMPLIFIED HALF TRE" +
	"E TRUNKCJK RADICAL COWCJK RADICAL DOGCJK RADICAL JADECJK RADICAL BOLT OF" +
	" CLOTHCJK RADICAL EYECJK RADICAL SPIRIT ONECJK RADICAL SPIRIT TWOCJK RAD" +
	"ICAL BAMBOOCJK RADICAL SILKCJK RADICAL C-SIMPLIFIED SILKCJK RADICAL NET " +
	"ONECJK RADICAL NET TWOCJK RADICAL NET THREECJK RADICAL NET FOURCJK RADIC" +
	"AL MESHCJK RADICAL SHEEPCJK RADICAL RAMCJK RADICAL EWECJK RADICAL OLDCJK" +
	" RADICAL BRUSH ONECJK RADICAL BRUSH TWOCJK RADICAL MEATCJK RADICAL MORTA" +
	"RCJK RADICAL GRASS ONECJK RADICAL GRASS TWOCJK RADICAL GRASS THREECJK RA" +
	"DICAL TIGERCJK RADICAL CLOTHESCJK RADICAL WEST ONECJK RADICAL WEST TWOCJ" +
	"K RADICAL C-SIMPLIFIED SEECJK RADICAL SIMPLIFIED HORNCJK RADICAL HORNCJK" +
	" RADICAL C-SIMPLIFIED SPEECHCJK RADICAL C-SIMPLIFIED SHELLCJK RADICAL FO" +
	"OTCJK RADICAL C-SIMPLIFIED CARTCJK RADICAL SIMPLIFIED WALKCJK RADICAL WA" +
	"LK ONECJK RADICAL WALK TWOCJK RADICAL CITYCJK RADICAL C-SIMPLIFIED GOLDC" +
	"JK RADICAL LONG ONECJK RADICAL LONG TWOCJK RADICAL C-SIMPLIFIED LONGCJK " +
	"RADICAL C-SIMPLIFIED GATECJK RADICAL MOUND ONECJK RADICAL MOUND TWOCJK R" +
	"ADICAL RAINCJK RADICAL BLUECJK RADICAL C-SIMPLIFIED TANNED LEATHERCJK RA" +
	"DICAL C-SIMPLIFIED LEAFCJK RADICAL C-SIMPLIFIED WINDCJK RADICAL C-SIMPLI" +
	"FIED FLYCJK RADICAL EAT ONECJK RADICAL EAT TWOCJK RADICAL EAT THREECJK R" +
	"ADICAL C-SIMPLIFIED EATCJK RADICAL HEADCJK RADICAL C-SIMPLIFIED HORSECJK" +
	" RADICAL BONECJK RADICAL GHOSTCJK RADICAL C-SIMPLIFIED FISHCJK RADICAL C" +
	"-SIMPLIFIED BIRDCJK RADICAL C-SIMPLIFIED SALTCJK RADICAL SIMPLIFIED WHEA" +
	"TCJK RADICAL SIMPLIFIED YELLOWCJK RADICAL C-SIMPLIFIED FROGCJK RADICAL J" +
	"-SIMPLIFIED EVENCJK RADICAL C-SIMPLIFIED EVENCJK RADICAL J-SIMPLIFIED TO" +
	"OTHCJK RADICAL C-SIMPLIFIED TOOTHCJK RADICAL J-SIMPLIFIED DRAGONCJK RADI" +
	"CAL C-SIMPLIFIED DRAGONCJK RADICAL TURTLECJK RADICAL J-SIMPLIFIED TURTLE" +
	"CJK RADICAL C-SIMPLIFIED TURTLEKANGXI RADICAL ONEKANGXI RADICAL LINEKANG" +
	"XI RADICAL DOTKANGXI RADICAL SLASHKANGXI RADICAL SECONDKANGXI RADICAL HO" +
	"OKKANGXI RADICAL TWOKANGXI RADICAL LIDKANGXI RADICAL MANKANGXI RADICAL L" +
	"EGSKANGXI RADICAL ENTERKANGXI RADICAL EIGHTKANGXI RADICAL DOWN BOXKANGXI" +
	" RADICAL COVERKANGXI RADICAL ICEKANGXI RADICAL TABLEKANGXI RADICAL OPEN " +
	"BOXKANGXI RADICAL KNIFEKANGXI RADICAL POWERKANGXI RADICAL WRAPKANGXI RAD" +
	"ICAL SPOONKANGXI RADICAL RIGHT OPEN BOXKANGXI RADICAL HIDING ENCLOSUREKA" +
	"NGXI RADICAL TENKANGXI RADICAL DIVINATIONKANGXI RADICAL SEALKANGXI RADIC" +
	"AL CLIFFKANGXI RADICAL PRIVATEKANGXI RADICAL AGAINKANGXI RADICAL MOUTHKA" +
	"NGXI RADICAL ENCLOSUREKANGXI RADICAL EARTHKANGXI RADICAL SCHOLARKANGXI R" +
	"ADICAL GOKANGXI RADICAL GO SLOWLYKANGXI RADICAL EVENINGKANGXI RADICAL BI" +
	"GKANGXI RADICAL WOMANKANGXI RADICAL CHILDKANGXI RADICAL ROOFKANGXI RADIC" +
	"AL INCHKANGXI RADICAL SMALLKANGXI RADICAL LAMEKANGXI RADICAL CORPSEKANGX" +
	"I RADICAL SPROUTKANGXI RADICAL MOUNTAINKANGXI RADICAL RIVERKANGXI RADICA" +
	"L WORKKANGXI RADICAL ONESELFKANGXI RADICAL TURBANKANGXI RADICAL DRYKANGX" +
	"I RADICAL SHORT THREADKANGXI RADICAL DOTTED CLIFFKANGXI RADICAL LONG STR" +
	"IDEKANGXI RADICAL TWO HANDSKANGXI RADICAL SHOOTKANGXI RADICAL BOWKANGXI " +
	"RADICAL SNOUTKANGXI RADICAL BRISTLEKANGXI RADICAL STEPKANGXI RADICAL HEA" +
	"RTKANGXI RADICAL HALBERDKANGXI RADICAL DOORKANGXI RADICAL HANDKANGXI RAD" +
	"ICAL BRANCHKANGXI RADICAL RAPKANGXI RADICAL SCRIPTKANGXI RADICAL DIPPERK" +
	"ANGXI RADICAL AXEKANGXI RADICAL SQUAREKANGXI RADICAL NOTKANGXI RADICAL S" +
	"UNKANGXI RADICAL SAYKANGXI RADICAL MOONKANGXI RADICAL TREEKANGXI RADICAL" +
	" LACKKANGXI RADICAL STOPKANGXI RADICAL DEATHKANGXI RADICAL WEAPONKANGXI " +
	"RADICAL DO NOTKANGXI RADICAL COMPAREKANGXI RADICAL FURKANGXI RADICAL CLA" +
	"NKANGXI RADICAL STEAMKANGXI RADICAL WATERKANGXI RADICAL FIREKANGXI RADIC" +
	"AL CLAWKANGXI RADICAL FATHERKANGXI RADICAL DOUBLE XKANGXI RADICAL HALF T" +
	"REE TRUNKKANGXI RADICAL SLICEKANGXI RADICAL FANGKANGXI RADICAL COWKANGXI" +
	" RADICAL DOGKANGXI RADICAL PROFOUNDKANGXI RADICAL JADEKANGXI RADICAL MEL" +
	"ONKANGXI RADICAL TILEKANGXI RADICAL SWEETKANGXI RADICAL LIFEKANGXI RADIC" +
	"AL USEKANGXI RADICAL FIELDKANGXI RADICAL BOLT OF CLOTHKANGXI RADICAL SIC" +
	"KNESSKANGXI RADICAL DOTTED TENTKANGXI RADICAL WHITEKANGXI RADICAL SKINKA" +
	"NGXI RADICAL DISHKANGXI RADICAL EYEKANGXI RADICAL SPEARKANGXI RADICAL AR" +
	"ROWKANGXI RADICAL STONEKANGXI RADICAL SPIRITKANGXI RADICAL TRACKKANGXI R" +
	"ADICAL GRAINKANGXI RADICAL CAVEKANGXI RADICAL STANDKANGXI RADICAL BAMBOO" +
	"KANGXI RADICAL RICEKANGXI RADICAL SILKKANGXI RADICAL JARKANGXI RADICAL N" +
	"ETKANGXI RADICAL SHEEPKANGXI RADICAL FEATHERKANGXI RADICAL OLDKANGXI RAD" +
	"ICAL ANDKANGXI RADICAL PLOWKANGXI RADICAL EARKANGXI RADICAL BRUSHKANGXI ") + ("" +
	"RADICAL MEATKANGXI RADICAL MINISTERKANGXI RADICAL SELFKANGXI RADICAL ARR" +
	"IVEKANGXI RADICAL MORTARKANGXI RADICAL TONGUEKANGXI RADICAL OPPOSEKANGXI" +
	" RADICAL BOATKANGXI RADICAL STOPPINGKANGXI RADICAL COLORKANGXI RADICAL G" +
	"RASSKANGXI RADICAL TIGERKANGXI RADICAL INSECTKANGXI RADICAL BLOODKANGXI " +
	"RADICAL WALK ENCLOSUREKANGXI RADICAL CLOTHESKANGXI RADICAL WESTKANGXI RA" +
	"DICAL SEEKANGXI RADICAL HORNKANGXI RADICAL SPEECHKANGXI RADICAL VALLEYKA" +
	"NGXI RADICAL BEANKANGXI RADICAL PIGKANGXI RADICAL BADGERKANGXI RADICAL S" +
	"HELLKANGXI RADICAL REDKANGXI RADICAL RUNKANGXI RADICAL FOOTKANGXI RADICA" +
	"L BODYKANGXI RADICAL CARTKANGXI RADICAL BITTERKANGXI RADICAL MORNINGKANG" +
	"XI RADICAL WALKKANGXI RADICAL CITYKANGXI RADICAL WINEKANGXI RADICAL DIST" +
	"INGUISHKANGXI RADICAL VILLAGEKANGXI RADICAL GOLDKANGXI RADICAL LONGKANGX" +
	"I RADICAL GATEKANGXI RADICAL MOUNDKANGXI RADICAL SLAVEKANGXI RADICAL SHO" +
	"RT TAILED BIRDKANGXI RADICAL RAINKANGXI RADICAL BLUEKANGXI RADICAL WRONG" +
	"KANGXI RADICAL FACEKANGXI RADICAL LEATHERKANGXI RADICAL TANNED LEATHERKA" +
	"NGXI RADICAL LEEKKANGXI RADICAL SOUNDKANGXI RADICAL LEAFKANGXI RADICAL W" +
	"INDKANGXI RADICAL FLYKANGXI RADICAL EATKANGXI RADICAL HEADKANGXI RADICAL" +
	" FRAGRANTKANGXI RADICAL HORSEKANGXI RADICAL BONEKANGXI RADICAL TALLKANGX" +
	"I RADICAL HAIRKANGXI RADICAL FIGHTKANGXI RADICAL SACRIFICIAL WINEKANGXI " +
	"RADICAL CAULDRONKANGXI RADICAL GHOSTKANGXI RADICAL FISHKANGXI RADICAL BI" +
	"RDKANGXI RADICAL SALTKANGXI RADICAL DEERKANGXI RADICAL WHEATKANGXI RADIC" +
	"AL HEMPKANGXI RADICAL YELLOWKANGXI RADICAL MILLETKANGXI RADICAL BLACKKAN" +
	"GXI RADICAL EMBROIDERYKANGXI RADICAL FROGKANGXI RADICAL TRIPODKANGXI RAD" +
	"ICAL DRUMKANGXI RADICAL RATKANGXI RADICAL NOSEKANGXI RADICAL EVENKANGXI " +
	"RADICAL TOOTHKANGXI RADICAL DRAGONKANGXI RADICAL TURTLEKANGXI RADICAL FL" +
	"UTEIDEOGRAPHIC DESCRIPTION CHARACTER LEFT TO RIGHTIDEOGRAPHIC DESCRIPTIO" +
	"N CHARACTER ABOVE TO BELOWIDEOGRAPHIC DESCRIPTION CHARACTER LEFT TO MIDD" +
	"LE AND RIGHTIDEOGRAPHIC DESCRIPTION CHARACTER ABOVE TO MIDDLE AND BELOWI" +
	"DEOGRAPHIC DESCRIPTION CHARACTER FULL SURROUNDIDEOGRAPHIC DESCRIPTION CH" +
	"ARACTER SURROUND FROM ABOVEIDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FR" +
	"OM BELOWIDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM LEFTIDEOGRAPHIC " +
	"DESCRIPTION CHARACTER SURROUND FROM UPPER LEFTIDEOGRAPHIC DESCRIPTION CH" +
	"ARACTER SURROUND FROM UPPER RIGHTIDEOGRAPHIC DESCRIPTION CHARACTER SURRO" +
	"UND FROM LOWER LEFTIDEOGRAPHIC DESCRIPTION CHARACTER OVERLAIDIDEOGRAPHIC" +
	" SPACEIDEOGRAPHIC COMMAIDEOGRAPHIC FULL STOPDITTO MARKJAPANESE INDUSTRIA" +
	"L STANDARD SYMBOLIDEOGRAPHIC ITERATION MARKIDEOGRAPHIC CLOSING MARKIDEOG" +
	"RAPHIC NUMBER ZEROLEFT ANGLE BRACKETRIGHT ANGLE BRACKETLEFT DOUBLE ANGLE" +
	" BRACKETRIGHT DOUBLE ANGLE BRACKETLEFT CORNER BRACKETRIGHT CORNER BRACKE" +
	"TLEFT WHITE CORNER BRACKETRIGHT WHITE CORNER BRACKETLEFT BLACK LENTICULA" +
	"R BRACKETRIGHT BLACK LENTICULAR BRACKETPOSTAL MARKGETA MARKLEFT TORTOISE" +
	" SHELL BRACKETRIGHT TORTOISE SHELL BRACKETLEFT WHITE LENTICULAR BRACKETR" +
	"IGHT WHITE LENTICULAR BRACKETLEFT WHITE TORTOISE SHELL BRACKETRIGHT WHIT" +
	"E TORTOISE SHELL BRACKETLEFT WHITE SQUARE BRACKETRIGHT WHITE SQUARE BRAC" +
	"KETWAVE DASHREVERSED DOUBLE PRIME QUOTATION MARKDOUBLE PRIME QUOTATION M" +
	"ARKLOW DOUBLE PRIME QUOTATION MARKPOSTAL MARK FACEHANGZHOU NUMERAL ONEHA" +
	"NGZHOU NUMERAL TWOHANGZHOU NUMERAL THREEHANGZHOU NUMERAL FOURHANGZHOU NU" +
	"MERAL FIVEHANGZHOU NUMERAL SIXHANGZHOU NUMERAL SEVENHANGZHOU NUMERAL EIG" +
	"HTHANGZHOU NUMERAL NINEIDEOGRAPHIC LEVEL TONE MARKIDEOGRAPHIC RISING TON" +
	"E MARKIDEOGRAPHIC DEPARTING TONE MARKIDEOGRAPHIC ENTERING TONE MARKHANGU" +
	"L SINGLE DOT TONE MARKHANGUL DOUBLE DOT TONE MARKWAVY DASHVERTICAL KANA " +
	"REPEAT MARKVERTICAL KANA REPEAT WITH VOICED SOUND MARKVERTICAL KANA REPE" +
	"AT MARK UPPER HALFVERTICAL KANA REPEAT WITH VOICED SOUND MARK UPPER HALF" +
	"VERTICAL KANA REPEAT MARK LOWER HALFCIRCLED POSTAL MARKIDEOGRAPHIC TELEG" +
	"RAPH LINE FEED SEPARATOR SYMBOLHANGZHOU NUMERAL TENHANGZHOU NUMERAL TWEN" +
	"TYHANGZHOU NUMERAL THIRTYVERTICAL IDEOGRAPHIC ITERATION MARKMASU MARKPAR" +
	"T ALTERNATION MARKIDEOGRAPHIC VARIATION INDICATORIDEOGRAPHIC HALF FILL S" +
	"PACEHIRAGANA LETTER SMALL AHIRAGANA LETTER AHIRAGANA LETTER SMALL IHIRAG" +
	"ANA LETTER IHIRAGANA LETTER SMALL UHIRAGANA LETTER UHIRAGANA LETTER SMAL" +
	"L EHIRAGANA LETTER EHIRAGANA LETTER SMALL OHIRAGANA LETTER OHIRAGANA LET" +
	"TER KAHIRAGANA LETTER GAHIRAGANA LETTER KIHIRAGANA LETTER GIHIRAGANA LET" +
	"TER KUHIRAGANA LETTER GUHIRAGANA LETTER KEHIRAGANA LETTER GEHIRAGANA LET" +
	"TER KOHIRAGANA LETTER GOHIRAGANA LETTER SAHIRAGANA LETTER ZAHIRAGANA LET" +
	"TER SIHIRAGANA LETTER ZIHIRAGANA LETTER SUHIRAGANA LETTER ZUHIRAGANA LET" +
	"TER SEHIRAGANA LETTER ZEHIRAGANA LETTER SOHIRAGANA LETTER ZOHIRAGANA LET" +
	"TER TAHIRAGANA LETTER DAHIRAGANA LETTER TIHIRAGANA LETTER DIHIRAGANA LET") + ("" +
	"TER SMALL TUHIRAGANA LETTER TUHIRAGANA LETTER DUHIRAGANA LETTER TEHIRAGA" +
	"NA LETTER DEHIRAGANA LETTER TOHIRAGANA LETTER DOHIRAGANA LETTER NAHIRAGA" +
	"NA LETTER NIHIRAGANA LETTER NUHIRAGANA LETTER NEHIRAGANA LETTER NOHIRAGA" +
	"NA LETTER HAHIRAGANA LETTER BAHIRAGANA LETTER PAHIRAGANA LETTER HIHIRAGA" +
	"NA LETTER BIHIRAGANA LETTER PIHIRAGANA LETTER HUHIRAGANA LETTER BUHIRAGA" +
	"NA LETTER PUHIRAGANA LETTER HEHIRAGANA LETTER BEHIRAGANA LETTER PEHIRAGA" +
	"NA LETTER HOHIRAGANA LETTER BOHIRAGANA LETTER POHIRAGANA LETTER MAHIRAGA" +
	"NA LETTER MIHIRAGANA LETTER MUHIRAGANA LETTER MEHIRAGANA LETTER MOHIRAGA" +
	"NA LETTER SMALL YAHIRAGANA LETTER YAHIRAGANA LETTER SMALL YUHIRAGANA LET" +
	"TER YUHIRAGANA LETTER SMALL YOHIRAGANA LETTER YOHIRAGANA LETTER RAHIRAGA" +
	"NA LETTER RIHIRAGANA LETTER RUHIRAGANA LETTER REHIRAGANA LETTER ROHIRAGA" +
	"NA LETTER SMALL WAHIRAGANA LETTER WAHIRAGANA LETTER WIHIRAGANA LETTER WE" +
	"HIRAGANA LETTER WOHIRAGANA LETTER NHIRAGANA LETTER VUHIRAGANA LETTER SMA" +
	"LL KAHIRAGANA LETTER SMALL KECOMBINING KATAKANA-HIRAGANA VOICED SOUND MA" +
	"RKCOMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARKKATAKANA-HIRAGANA VO" +
	"ICED SOUND MARKKATAKANA-HIRAGANA SEMI-VOICED SOUND MARKHIRAGANA ITERATIO" +
	"N MARKHIRAGANA VOICED ITERATION MARKHIRAGANA DIGRAPH YORIKATAKANA-HIRAGA" +
	"NA DOUBLE HYPHENKATAKANA LETTER SMALL AKATAKANA LETTER AKATAKANA LETTER " +
	"SMALL IKATAKANA LETTER IKATAKANA LETTER SMALL UKATAKANA LETTER UKATAKANA" +
	" LETTER SMALL EKATAKANA LETTER EKATAKANA LETTER SMALL OKATAKANA LETTER O" +
	"KATAKANA LETTER KAKATAKANA LETTER GAKATAKANA LETTER KIKATAKANA LETTER GI" +
	"KATAKANA LETTER KUKATAKANA LETTER GUKATAKANA LETTER KEKATAKANA LETTER GE" +
	"KATAKANA LETTER KOKATAKANA LETTER GOKATAKANA LETTER SAKATAKANA LETTER ZA" +
	"KATAKANA LETTER SIKATAKANA LETTER ZIKATAKANA LETTER SUKATAKANA LETTER ZU" +
	"KATAKANA LETTER SEKATAKANA LETTER ZEKATAKANA LETTER SOKATAKANA LETTER ZO" +
	"KATAKANA LETTER TAKATAKANA LETTER DAKATAKANA LETTER TIKATAKANA LETTER DI" +
	"KATAKANA LETTER SMALL TUKATAKANA LETTER TUKATAKANA LETTER DUKATAKANA LET" +
	"TER TEKATAKANA LETTER DEKATAKANA LETTER TOKATAKANA LETTER DOKATAKANA LET" +
	"TER NAKATAKANA LETTER NIKATAKANA LETTER NUKATAKANA LETTER NEKATAKANA LET" +
	"TER NOKATAKANA LETTER HAKATAKANA LETTER BAKATAKANA LETTER PAKATAKANA LET" +
	"TER HIKATAKANA LETTER BIKATAKANA LETTER PIKATAKANA LETTER HUKATAKANA LET" +
	"TER BUKATAKANA LETTER PUKATAKANA LETTER HEKATAKANA LETTER BEKATAKANA LET" +
	"TER PEKATAKANA LETTER HOKATAKANA LETTER BOKATAKANA LETTER POKATAKANA LET" +
	"TER MAKATAKANA LETTER MIKATAKANA LETTER MUKATAKANA LETTER MEKATAKANA LET" +
	"TER MOKATAKANA LETTER SMALL YAKATAKANA LETTER YAKATAKANA LETTER SMALL YU" +
	"KATAKANA LETTER YUKATAKANA LETTER SMALL YOKATAKANA LETTER YOKATAKANA LET" +
	"TER RAKATAKANA LETTER RIKATAKANA LETTER RUKATAKANA LETTER REKATAKANA LET" +
	"TER ROKATAKANA LETTER SMALL WAKATAKANA LETTER WAKATAKANA LETTER WIKATAKA" +
	"NA LETTER WEKATAKANA LETTER WOKATAKANA LETTER NKATAKANA LETTER VUKATAKAN" +
	"A LETTER SMALL KAKATAKANA LETTER SMALL KEKATAKANA LETTER VAKATAKANA LETT" +
	"ER VIKATAKANA LETTER VEKATAKANA LETTER VOKATAKANA MIDDLE DOTKATAKANA-HIR" +
	"AGANA PROLONGED SOUND MARKKATAKANA ITERATION MARKKATAKANA VOICED ITERATI" +
	"ON MARKKATAKANA DIGRAPH KOTOBOPOMOFO LETTER BBOPOMOFO LETTER PBOPOMOFO L" +
	"ETTER MBOPOMOFO LETTER FBOPOMOFO LETTER DBOPOMOFO LETTER TBOPOMOFO LETTE" +
	"R NBOPOMOFO LETTER LBOPOMOFO LETTER GBOPOMOFO LETTER KBOPOMOFO LETTER HB" +
	"OPOMOFO LETTER JBOPOMOFO LETTER QBOPOMOFO LETTER XBOPOMOFO LETTER ZHBOPO" +
	"MOFO LETTER CHBOPOMOFO LETTER SHBOPOMOFO LETTER RBOPOMOFO LETTER ZBOPOMO" +
	"FO LETTER CBOPOMOFO LETTER SBOPOMOFO LETTER ABOPOMOFO LETTER OBOPOMOFO L" +
	"ETTER EBOPOMOFO LETTER EHBOPOMOFO LETTER AIBOPOMOFO LETTER EIBOPOMOFO LE" +
	"TTER AUBOPOMOFO LETTER OUBOPOMOFO LETTER ANBOPOMOFO LETTER ENBOPOMOFO LE" +
	"TTER ANGBOPOMOFO LETTER ENGBOPOMOFO LETTER ERBOPOMOFO LETTER IBOPOMOFO L" +
	"ETTER UBOPOMOFO LETTER IUBOPOMOFO LETTER VBOPOMOFO LETTER NGBOPOMOFO LET" +
	"TER GNBOPOMOFO LETTER IHBOPOMOFO LETTER O WITH DOT ABOVEBOPOMOFO LETTER " +
	"NNHANGUL LETTER KIYEOKHANGUL LETTER SSANGKIYEOKHANGUL LETTER KIYEOK-SIOS" +
	"HANGUL LETTER NIEUNHANGUL LETTER NIEUN-CIEUCHANGUL LETTER NIEUN-HIEUHHAN" +
	"GUL LETTER TIKEUTHANGUL LETTER SSANGTIKEUTHANGUL LETTER RIEULHANGUL LETT" +
	"ER RIEUL-KIYEOKHANGUL LETTER RIEUL-MIEUMHANGUL LETTER RIEUL-PIEUPHANGUL " +
	"LETTER RIEUL-SIOSHANGUL LETTER RIEUL-THIEUTHHANGUL LETTER RIEUL-PHIEUPHH" +
	"ANGUL LETTER RIEUL-HIEUHHANGUL LETTER MIEUMHANGUL LETTER PIEUPHANGUL LET" +
	"TER SSANGPIEUPHANGUL LETTER PIEUP-SIOSHANGUL LETTER SIOSHANGUL LETTER SS" +
	"ANGSIOSHANGUL LETTER IEUNGHANGUL LETTER CIEUCHANGUL LETTER SSANGCIEUCHAN" +
	"GUL LETTER CHIEUCHHANGUL LETTER KHIEUKHHANGUL LETTER THIEUTHHANGUL LETTE" +
	"R PHIEUPHHANGUL LETTER HIEUHHANGUL LETTER AHANGUL LETTER AEHANGUL LETTER" +
	" YAHANGUL LETTER YAEHANGUL LETTER EOHANGUL LETTER EHANGUL LETTER YEOHANG") + ("" +
	"UL LETTER YEHANGUL LETTER OHANGUL LETTER WAHANGUL LETTER WAEHANGUL LETTE" +
	"R OEHANGUL LETTER YOHANGUL LETTER UHANGUL LETTER WEOHANGUL LETTER WEHANG" +
	"UL LETTER WIHANGUL LETTER YUHANGUL LETTER EUHANGUL LETTER YIHANGUL LETTE" +
	"R IHANGUL FILLERHANGUL LETTER SSANGNIEUNHANGUL LETTER NIEUN-TIKEUTHANGUL" +
	" LETTER NIEUN-SIOSHANGUL LETTER NIEUN-PANSIOSHANGUL LETTER RIEUL-KIYEOK-" +
	"SIOSHANGUL LETTER RIEUL-TIKEUTHANGUL LETTER RIEUL-PIEUP-SIOSHANGUL LETTE" +
	"R RIEUL-PANSIOSHANGUL LETTER RIEUL-YEORINHIEUHHANGUL LETTER MIEUM-PIEUPH" +
	"ANGUL LETTER MIEUM-SIOSHANGUL LETTER MIEUM-PANSIOSHANGUL LETTER KAPYEOUN" +
	"MIEUMHANGUL LETTER PIEUP-KIYEOKHANGUL LETTER PIEUP-TIKEUTHANGUL LETTER P" +
	"IEUP-SIOS-KIYEOKHANGUL LETTER PIEUP-SIOS-TIKEUTHANGUL LETTER PIEUP-CIEUC" +
	"HANGUL LETTER PIEUP-THIEUTHHANGUL LETTER KAPYEOUNPIEUPHANGUL LETTER KAPY" +
	"EOUNSSANGPIEUPHANGUL LETTER SIOS-KIYEOKHANGUL LETTER SIOS-NIEUNHANGUL LE" +
	"TTER SIOS-TIKEUTHANGUL LETTER SIOS-PIEUPHANGUL LETTER SIOS-CIEUCHANGUL L" +
	"ETTER PANSIOSHANGUL LETTER SSANGIEUNGHANGUL LETTER YESIEUNGHANGUL LETTER" +
	" YESIEUNG-SIOSHANGUL LETTER YESIEUNG-PANSIOSHANGUL LETTER KAPYEOUNPHIEUP" +
	"HHANGUL LETTER SSANGHIEUHHANGUL LETTER YEORINHIEUHHANGUL LETTER YO-YAHAN" +
	"GUL LETTER YO-YAEHANGUL LETTER YO-IHANGUL LETTER YU-YEOHANGUL LETTER YU-" +
	"YEHANGUL LETTER YU-IHANGUL LETTER ARAEAHANGUL LETTER ARAEAEIDEOGRAPHIC A" +
	"NNOTATION LINKING MARKIDEOGRAPHIC ANNOTATION REVERSE MARKIDEOGRAPHIC ANN" +
	"OTATION ONE MARKIDEOGRAPHIC ANNOTATION TWO MARKIDEOGRAPHIC ANNOTATION TH" +
	"REE MARKIDEOGRAPHIC ANNOTATION FOUR MARKIDEOGRAPHIC ANNOTATION TOP MARKI" +
	"DEOGRAPHIC ANNOTATION MIDDLE MARKIDEOGRAPHIC ANNOTATION BOTTOM MARKIDEOG" +
	"RAPHIC ANNOTATION FIRST MARKIDEOGRAPHIC ANNOTATION SECOND MARKIDEOGRAPHI" +
	"C ANNOTATION THIRD MARKIDEOGRAPHIC ANNOTATION FOURTH MARKIDEOGRAPHIC ANN" +
	"OTATION HEAVEN MARKIDEOGRAPHIC ANNOTATION EARTH MARKIDEOGRAPHIC ANNOTATI" +
	"ON MAN MARKBOPOMOFO LETTER BUBOPOMOFO LETTER ZIBOPOMOFO LETTER JIBOPOMOF" +
	"O LETTER GUBOPOMOFO LETTER EEBOPOMOFO LETTER ENNBOPOMOFO LETTER OOBOPOMO" +
	"FO LETTER ONNBOPOMOFO LETTER IRBOPOMOFO LETTER ANNBOPOMOFO LETTER INNBOP" +
	"OMOFO LETTER UNNBOPOMOFO LETTER IMBOPOMOFO LETTER NGGBOPOMOFO LETTER AIN" +
	"NBOPOMOFO LETTER AUNNBOPOMOFO LETTER AMBOPOMOFO LETTER OMBOPOMOFO LETTER" +
	" ONGBOPOMOFO LETTER INNNBOPOMOFO FINAL LETTER PBOPOMOFO FINAL LETTER TBO" +
	"POMOFO FINAL LETTER KBOPOMOFO FINAL LETTER HBOPOMOFO LETTER GHBOPOMOFO L" +
	"ETTER LHBOPOMOFO LETTER ZYCJK STROKE TCJK STROKE WGCJK STROKE XGCJK STRO" +
	"KE BXGCJK STROKE SWCJK STROKE HZZCJK STROKE HZGCJK STROKE HPCJK STROKE H" +
	"ZWGCJK STROKE SZWGCJK STROKE HZTCJK STROKE HZZPCJK STROKE HPWGCJK STROKE" +
	" HZWCJK STROKE HZZZCJK STROKE NCJK STROKE HCJK STROKE SCJK STROKE PCJK S" +
	"TROKE SPCJK STROKE DCJK STROKE HZCJK STROKE HGCJK STROKE SZCJK STROKE SW" +
	"ZCJK STROKE STCJK STROKE SGCJK STROKE PDCJK STROKE PZCJK STROKE TNCJK ST" +
	"ROKE SZZCJK STROKE SWGCJK STROKE HXWGCJK STROKE HZZZGCJK STROKE PGCJK ST" +
	"ROKE QKATAKANA LETTER SMALL KUKATAKANA LETTER SMALL SIKATAKANA LETTER SM" +
	"ALL SUKATAKANA LETTER SMALL TOKATAKANA LETTER SMALL NUKATAKANA LETTER SM" +
	"ALL HAKATAKANA LETTER SMALL HIKATAKANA LETTER SMALL HUKATAKANA LETTER SM" +
	"ALL HEKATAKANA LETTER SMALL HOKATAKANA LETTER SMALL MUKATAKANA LETTER SM" +
	"ALL RAKATAKANA LETTER SMALL RIKATAKANA LETTER SMALL RUKATAKANA LETTER SM" +
	"ALL REKATAKANA LETTER SMALL ROPARENTHESIZED HANGUL KIYEOKPARENTHESIZED H" +
	"ANGUL NIEUNPARENTHESIZED HANGUL TIKEUTPARENTHESIZED HANGUL RIEULPARENTHE" +
	"SIZED HANGUL MIEUMPARENTHESIZED HANGUL PIEUPPARENTHESIZED HANGUL SIOSPAR" +
	"ENTHESIZED HANGUL IEUNGPARENTHESIZED HANGUL CIEUCPARENTHESIZED HANGUL CH" +
	"IEUCHPARENTHESIZED HANGUL KHIEUKHPARENTHESIZED HANGUL THIEUTHPARENTHESIZ" +
	"ED HANGUL PHIEUPHPARENTHESIZED HANGUL HIEUHPARENTHESIZED HANGUL KIYEOK A" +
	"PARENTHESIZED HANGUL NIEUN APARENTHESIZED HANGUL TIKEUT APARENTHESIZED H" +
	"ANGUL RIEUL APARENTHESIZED HANGUL MIEUM APARENTHESIZED HANGUL PIEUP APAR" +
	"ENTHESIZED HANGUL SIOS APARENTHESIZED HANGUL IEUNG APARENTHESIZED HANGUL" +
	" CIEUC APARENTHESIZED HANGUL CHIEUCH APARENTHESIZED HANGUL KHIEUKH APARE" +
	"NTHESIZED HANGUL THIEUTH APARENTHESIZED HANGUL PHIEUPH APARENTHESIZED HA" +
	"NGUL HIEUH APARENTHESIZED HANGUL CIEUC UPARENTHESIZED KOREAN CHARACTER O" +
	"JEONPARENTHESIZED KOREAN CHARACTER O HUPARENTHESIZED IDEOGRAPH ONEPARENT" +
	"HESIZED IDEOGRAPH TWOPARENTHESIZED IDEOGRAPH THREEPARENTHESIZED IDEOGRAP" +
	"H FOURPARENTHESIZED IDEOGRAPH FIVEPARENTHESIZED IDEOGRAPH SIXPARENTHESIZ" +
	"ED IDEOGRAPH SEVENPARENTHESIZED IDEOGRAPH EIGHTPARENTHESIZED IDEOGRAPH N" +
	"INEPARENTHESIZED IDEOGRAPH TENPARENTHESIZED IDEOGRAPH MOONPARENTHESIZED " +
	"IDEOGRAPH FIREPARENTHESIZED IDEOGRAPH WATERPARENTHESIZED IDEOGRAPH WOODP" +
	"ARENTHESIZED IDEOGRAPH METALPARENTHESIZED IDEOGRAPH EARTHPARENTHESIZED I" +
	"DEOGRAPH SUNPARENTHESIZED IDEOGRAPH STOCKPARENTHESIZED IDEOGRAPH HAVEPAR") + ("" +
	"ENTHESIZED IDEOGRAPH SOCIETYPARENTHESIZED IDEOGRAPH NAMEPARENTHESIZED ID" +
	"EOGRAPH SPECIALPARENTHESIZED IDEOGRAPH FINANCIALPARENTHESIZED IDEOGRAPH " +
	"CONGRATULATIONPARENTHESIZED IDEOGRAPH LABORPARENTHESIZED IDEOGRAPH REPRE" +
	"SENTPARENTHESIZED IDEOGRAPH CALLPARENTHESIZED IDEOGRAPH STUDYPARENTHESIZ" +
	"ED IDEOGRAPH SUPERVISEPARENTHESIZED IDEOGRAPH ENTERPRISEPARENTHESIZED ID" +
	"EOGRAPH RESOURCEPARENTHESIZED IDEOGRAPH ALLIANCEPARENTHESIZED IDEOGRAPH " +
	"FESTIVALPARENTHESIZED IDEOGRAPH RESTPARENTHESIZED IDEOGRAPH SELFPARENTHE" +
	"SIZED IDEOGRAPH REACHCIRCLED IDEOGRAPH QUESTIONCIRCLED IDEOGRAPH KINDERG" +
	"ARTENCIRCLED IDEOGRAPH SCHOOLCIRCLED IDEOGRAPH KOTOCIRCLED NUMBER TEN ON" +
	" BLACK SQUARECIRCLED NUMBER TWENTY ON BLACK SQUARECIRCLED NUMBER THIRTY " +
	"ON BLACK SQUARECIRCLED NUMBER FORTY ON BLACK SQUARECIRCLED NUMBER FIFTY " +
	"ON BLACK SQUARECIRCLED NUMBER SIXTY ON BLACK SQUARECIRCLED NUMBER SEVENT" +
	"Y ON BLACK SQUARECIRCLED NUMBER EIGHTY ON BLACK SQUAREPARTNERSHIP SIGNCI" +
	"RCLED NUMBER TWENTY ONECIRCLED NUMBER TWENTY TWOCIRCLED NUMBER TWENTY TH" +
	"REECIRCLED NUMBER TWENTY FOURCIRCLED NUMBER TWENTY FIVECIRCLED NUMBER TW" +
	"ENTY SIXCIRCLED NUMBER TWENTY SEVENCIRCLED NUMBER TWENTY EIGHTCIRCLED NU" +
	"MBER TWENTY NINECIRCLED NUMBER THIRTYCIRCLED NUMBER THIRTY ONECIRCLED NU" +
	"MBER THIRTY TWOCIRCLED NUMBER THIRTY THREECIRCLED NUMBER THIRTY FOURCIRC" +
	"LED NUMBER THIRTY FIVECIRCLED HANGUL KIYEOKCIRCLED HANGUL NIEUNCIRCLED H" +
	"ANGUL TIKEUTCIRCLED HANGUL RIEULCIRCLED HANGUL MIEUMCIRCLED HANGUL PIEUP" +
	"CIRCLED HANGUL SIOSCIRCLED HANGUL IEUNGCIRCLED HANGUL CIEUCCIRCLED HANGU" +
	"L CHIEUCHCIRCLED HANGUL KHIEUKHCIRCLED HANGUL THIEUTHCIRCLED HANGUL PHIE" +
	"UPHCIRCLED HANGUL HIEUHCIRCLED HANGUL KIYEOK ACIRCLED HANGUL NIEUN ACIRC" +
	"LED HANGUL TIKEUT ACIRCLED HANGUL RIEUL ACIRCLED HANGUL MIEUM ACIRCLED H" +
	"ANGUL PIEUP ACIRCLED HANGUL SIOS ACIRCLED HANGUL IEUNG ACIRCLED HANGUL C" +
	"IEUC ACIRCLED HANGUL CHIEUCH ACIRCLED HANGUL KHIEUKH ACIRCLED HANGUL THI" +
	"EUTH ACIRCLED HANGUL PHIEUPH ACIRCLED HANGUL HIEUH ACIRCLED KOREAN CHARA" +
	"CTER CHAMKOCIRCLED KOREAN CHARACTER JUEUICIRCLED HANGUL IEUNG UKOREAN ST" +
	"ANDARD SYMBOLCIRCLED IDEOGRAPH ONECIRCLED IDEOGRAPH TWOCIRCLED IDEOGRAPH" +
	" THREECIRCLED IDEOGRAPH FOURCIRCLED IDEOGRAPH FIVECIRCLED IDEOGRAPH SIXC" +
	"IRCLED IDEOGRAPH SEVENCIRCLED IDEOGRAPH EIGHTCIRCLED IDEOGRAPH NINECIRCL" +
	"ED IDEOGRAPH TENCIRCLED IDEOGRAPH MOONCIRCLED IDEOGRAPH FIRECIRCLED IDEO" +
	"GRAPH WATERCIRCLED IDEOGRAPH WOODCIRCLED IDEOGRAPH METALCIRCLED IDEOGRAP" +
	"H EARTHCIRCLED IDEOGRAPH SUNCIRCLED IDEOGRAPH STOCKCIRCLED IDEOGRAPH HAV" +
	"ECIRCLED IDEOGRAPH SOCIETYCIRCLED IDEOGRAPH NAMECIRCLED IDEOGRAPH SPECIA" +
	"LCIRCLED IDEOGRAPH FINANCIALCIRCLED IDEOGRAPH CONGRATULATIONCIRCLED IDEO" +
	"GRAPH LABORCIRCLED IDEOGRAPH SECRETCIRCLED IDEOGRAPH MALECIRCLED IDEOGRA" +
	"PH FEMALECIRCLED IDEOGRAPH SUITABLECIRCLED IDEOGRAPH EXCELLENTCIRCLED ID" +
	"EOGRAPH PRINTCIRCLED IDEOGRAPH ATTENTIONCIRCLED IDEOGRAPH ITEMCIRCLED ID" +
	"EOGRAPH RESTCIRCLED IDEOGRAPH COPYCIRCLED IDEOGRAPH CORRECTCIRCLED IDEOG" +
	"RAPH HIGHCIRCLED IDEOGRAPH CENTRECIRCLED IDEOGRAPH LOWCIRCLED IDEOGRAPH " +
	"LEFTCIRCLED IDEOGRAPH RIGHTCIRCLED IDEOGRAPH MEDICINECIRCLED IDEOGRAPH R" +
	"ELIGIONCIRCLED IDEOGRAPH STUDYCIRCLED IDEOGRAPH SUPERVISECIRCLED IDEOGRA" +
	"PH ENTERPRISECIRCLED IDEOGRAPH RESOURCECIRCLED IDEOGRAPH ALLIANCECIRCLED" +
	" IDEOGRAPH NIGHTCIRCLED NUMBER THIRTY SIXCIRCLED NUMBER THIRTY SEVENCIRC" +
	"LED NUMBER THIRTY EIGHTCIRCLED NUMBER THIRTY NINECIRCLED NUMBER FORTYCIR" +
	"CLED NUMBER FORTY ONECIRCLED NUMBER FORTY TWOCIRCLED NUMBER FORTY THREEC" +
	"IRCLED NUMBER FORTY FOURCIRCLED NUMBER FORTY FIVECIRCLED NUMBER FORTY SI" +
	"XCIRCLED NUMBER FORTY SEVENCIRCLED NUMBER FORTY EIGHTCIRCLED NUMBER FORT" +
	"Y NINECIRCLED NUMBER FIFTYIDEOGRAPHIC TELEGRAPH SYMBOL FOR JANUARYIDEOGR" +
	"APHIC TELEGRAPH SYMBOL FOR FEBRUARYIDEOGRAPHIC TELEGRAPH SYMBOL FOR MARC" +
	"HIDEOGRAPHIC TELEGRAPH SYMBOL FOR APRILIDEOGRAPHIC TELEGRAPH SYMBOL FOR " +
	"MAYIDEOGRAPHIC TELEGRAPH SYMBOL FOR JUNEIDEOGRAPHIC TELEGRAPH SYMBOL FOR" +
	" JULYIDEOGRAPHIC TELEGRAPH SYMBOL FOR AUGUSTIDEOGRAPHIC TELEGRAPH SYMBOL" +
	" FOR SEPTEMBERIDEOGRAPHIC TELEGRAPH SYMBOL FOR OCTOBERIDEOGRAPHIC TELEGR" +
	"APH SYMBOL FOR NOVEMBERIDEOGRAPHIC TELEGRAPH SYMBOL FOR DECEMBERSQUARE H" +
	"GSQUARE ERGSQUARE EVLIMITED LIABILITY SIGNCIRCLED KATAKANA ACIRCLED KATA" +
	"KANA ICIRCLED KATAKANA UCIRCLED KATAKANA ECIRCLED KATAKANA OCIRCLED KATA" +
	"KANA KACIRCLED KATAKANA KICIRCLED KATAKANA KUCIRCLED KATAKANA KECIRCLED " +
	"KATAKANA KOCIRCLED KATAKANA SACIRCLED KATAKANA SICIRCLED KATAKANA SUCIRC" +
	"LED KATAKANA SECIRCLED KATAKANA SOCIRCLED KATAKANA TACIRCLED KATAKANA TI" +
	"CIRCLED KATAKANA TUCIRCLED KATAKANA TECIRCLED KATAKANA TOCIRCLED KATAKAN" +
	"A NACIRCLED KATAKANA NICIRCLED KATAKANA NUCIRCLED KATAKANA NECIRCLED KAT" +
	"AKANA NOCIRCLED KATAKANA HACIRCLED KATAKANA HICIRCLED KATAKANA HUCIRCLED") + ("" +
	" KATAKANA HECIRCLED KATAKANA HOCIRCLED KATAKANA MACIRCLED KATAKANA MICIR" +
	"CLED KATAKANA MUCIRCLED KATAKANA MECIRCLED KATAKANA MOCIRCLED KATAKANA Y" +
	"ACIRCLED KATAKANA YUCIRCLED KATAKANA YOCIRCLED KATAKANA RACIRCLED KATAKA" +
	"NA RICIRCLED KATAKANA RUCIRCLED KATAKANA RECIRCLED KATAKANA ROCIRCLED KA" +
	"TAKANA WACIRCLED KATAKANA WICIRCLED KATAKANA WECIRCLED KATAKANA WOSQUARE" +
	" APAATOSQUARE ARUHUASQUARE ANPEASQUARE AARUSQUARE ININGUSQUARE INTISQUAR" +
	"E UONSQUARE ESUKUUDOSQUARE EEKAASQUARE ONSUSQUARE OOMUSQUARE KAIRISQUARE" +
	" KARATTOSQUARE KARORIISQUARE GARONSQUARE GANMASQUARE GIGASQUARE GINIISQU" +
	"ARE KYURIISQUARE GIRUDAASQUARE KIROSQUARE KIROGURAMUSQUARE KIROMEETORUSQ" +
	"UARE KIROWATTOSQUARE GURAMUSQUARE GURAMUTONSQUARE KURUZEIROSQUARE KUROON" +
	"ESQUARE KEESUSQUARE KORUNASQUARE KOOPOSQUARE SAIKURUSQUARE SANTIIMUSQUAR" +
	"E SIRINGUSQUARE SENTISQUARE SENTOSQUARE DAASUSQUARE DESISQUARE DORUSQUAR" +
	"E TONSQUARE NANOSQUARE NOTTOSQUARE HAITUSQUARE PAASENTOSQUARE PAATUSQUAR" +
	"E BAARERUSQUARE PIASUTORUSQUARE PIKURUSQUARE PIKOSQUARE BIRUSQUARE HUARA" +
	"DDOSQUARE HUIITOSQUARE BUSSYERUSQUARE HURANSQUARE HEKUTAARUSQUARE PESOSQ" +
	"UARE PENIHISQUARE HERUTUSQUARE PENSUSQUARE PEEZISQUARE BEETASQUARE POINT" +
	"OSQUARE BORUTOSQUARE HONSQUARE PONDOSQUARE HOORUSQUARE HOONSQUARE MAIKUR" +
	"OSQUARE MAIRUSQUARE MAHHASQUARE MARUKUSQUARE MANSYONSQUARE MIKURONSQUARE" +
	" MIRISQUARE MIRIBAARUSQUARE MEGASQUARE MEGATONSQUARE MEETORUSQUARE YAADO" +
	"SQUARE YAARUSQUARE YUANSQUARE RITTORUSQUARE RIRASQUARE RUPIISQUARE RUUBU" +
	"RUSQUARE REMUSQUARE RENTOGENSQUARE WATTOIDEOGRAPHIC TELEGRAPH SYMBOL FOR" +
	" HOUR ZEROIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR ONEIDEOGRAPHIC TELEGRAPH" +
	" SYMBOL FOR HOUR TWOIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR THREEIDEOGRAPH" +
	"IC TELEGRAPH SYMBOL FOR HOUR FOURIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR F" +
	"IVEIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SIXIDEOGRAPHIC TELEGRAPH SYMBOL" +
	" FOR HOUR SEVENIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR EIGHTIDEOGRAPHIC TE" +
	"LEGRAPH SYMBOL FOR HOUR NINEIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TENIDE" +
	"OGRAPHIC TELEGRAPH SYMBOL FOR HOUR ELEVENIDEOGRAPHIC TELEGRAPH SYMBOL FO" +
	"R HOUR TWELVEIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR THIRTEENIDEOGRAPHIC T" +
	"ELEGRAPH SYMBOL FOR HOUR FOURTEENIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR F" +
	"IFTEENIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SIXTEENIDEOGRAPHIC TELEGRAPH" +
	" SYMBOL FOR HOUR SEVENTEENIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR EIGHTEEN" +
	"IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR NINETEENIDEOGRAPHIC TELEGRAPH SYMB" +
	"OL FOR HOUR TWENTYIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-ONEIDEOGR" +
	"APHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-TWOIDEOGRAPHIC TELEGRAPH SYMBOL F" +
	"OR HOUR TWENTY-THREEIDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-FOURSQU" +
	"ARE HPASQUARE DASQUARE AUSQUARE BARSQUARE OVSQUARE PCSQUARE DMSQUARE DM " +
	"SQUAREDSQUARE DM CUBEDSQUARE IUSQUARE ERA NAME HEISEISQUARE ERA NAME SYO" +
	"UWASQUARE ERA NAME TAISYOUSQUARE ERA NAME MEIZISQUARE CORPORATIONSQUARE " +
	"PA AMPSSQUARE NASQUARE MU ASQUARE MASQUARE KASQUARE KBSQUARE MBSQUARE GB" +
	"SQUARE CALSQUARE KCALSQUARE PFSQUARE NFSQUARE MU FSQUARE MU GSQUARE MGSQ" +
	"UARE KGSQUARE HZSQUARE KHZSQUARE MHZSQUARE GHZSQUARE THZSQUARE MU LSQUAR" +
	"E MLSQUARE DLSQUARE KLSQUARE FMSQUARE NMSQUARE MU MSQUARE MMSQUARE CMSQU" +
	"ARE KMSQUARE MM SQUAREDSQUARE CM SQUAREDSQUARE M SQUAREDSQUARE KM SQUARE" +
	"DSQUARE MM CUBEDSQUARE CM CUBEDSQUARE M CUBEDSQUARE KM CUBEDSQUARE M OVE" +
	"R SSQUARE M OVER S SQUAREDSQUARE PASQUARE KPASQUARE MPASQUARE GPASQUARE " +
	"RADSQUARE RAD OVER SSQUARE RAD OVER S SQUAREDSQUARE PSSQUARE NSSQUARE MU" +
	" SSQUARE MSSQUARE PVSQUARE NVSQUARE MU VSQUARE MVSQUARE KVSQUARE MV MEGA" +
	"SQUARE PWSQUARE NWSQUARE MU WSQUARE MWSQUARE KWSQUARE MW MEGASQUARE K OH" +
	"MSQUARE M OHMSQUARE AMSQUARE BQSQUARE CCSQUARE CDSQUARE C OVER KGSQUARE " +
	"COSQUARE DBSQUARE GYSQUARE HASQUARE HPSQUARE INSQUARE KKSQUARE KM CAPITA" +
	"LSQUARE KTSQUARE LMSQUARE LNSQUARE LOGSQUARE LXSQUARE MB SMALLSQUARE MIL" +
	"SQUARE MOLSQUARE PHSQUARE PMSQUARE PPMSQUARE PRSQUARE SRSQUARE SVSQUARE " +
	"WBSQUARE V OVER MSQUARE A OVER MIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY ONE" +
	"IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWOIDEOGRAPHIC TELEGRAPH SYMBOL FOR" +
	" DAY THREEIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FOURIDEOGRAPHIC TELEGRAPH" +
	" SYMBOL FOR DAY FIVEIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SIXIDEOGRAPHIC " +
	"TELEGRAPH SYMBOL FOR DAY SEVENIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY EIGHT" +
	"IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY NINEIDEOGRAPHIC TELEGRAPH SYMBOL FO" +
	"R DAY TENIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY ELEVENIDEOGRAPHIC TELEGRAP" +
	"H SYMBOL FOR DAY TWELVEIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THIRTEENIDEO" +
	"GRAPHIC TELEGRAPH SYMBOL FOR DAY FOURTEENIDEOGRAPHIC TELEGRAPH SYMBOL FO" +
	"R DAY FIFTEENIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SIXTEENIDEOGRAPHIC TEL" +
	"EGRAPH SYMBOL FOR DAY SEVENTEENIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY EIGH") + ("" +
	"TEENIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY NINETEENIDEOGRAPHIC TELEGRAPH S" +
	"YMBOL FOR DAY TWENTYIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-ONEIDEOG" +
	"RAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-TWOIDEOGRAPHIC TELEGRAPH SYMBOL F" +
	"OR DAY TWENTY-THREEIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-FOURIDEOG" +
	"RAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-FIVEIDEOGRAPHIC TELEGRAPH SYMBOL " +
	"FOR DAY TWENTY-SIXIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-SEVENIDEOG" +
	"RAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-EIGHTIDEOGRAPHIC TELEGRAPH SYMBOL" +
	" FOR DAY TWENTY-NINEIDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THIRTYIDEOGRAPH" +
	"IC TELEGRAPH SYMBOL FOR DAY THIRTY-ONESQUARE GALHEXAGRAM FOR THE CREATIV" +
	"E HEAVENHEXAGRAM FOR THE RECEPTIVE EARTHHEXAGRAM FOR DIFFICULTY AT THE B" +
	"EGINNINGHEXAGRAM FOR YOUTHFUL FOLLYHEXAGRAM FOR WAITINGHEXAGRAM FOR CONF" +
	"LICTHEXAGRAM FOR THE ARMYHEXAGRAM FOR HOLDING TOGETHERHEXAGRAM FOR SMALL" +
	" TAMINGHEXAGRAM FOR TREADINGHEXAGRAM FOR PEACEHEXAGRAM FOR STANDSTILLHEX" +
	"AGRAM FOR FELLOWSHIPHEXAGRAM FOR GREAT POSSESSIONHEXAGRAM FOR MODESTYHEX" +
	"AGRAM FOR ENTHUSIASMHEXAGRAM FOR FOLLOWINGHEXAGRAM FOR WORK ON THE DECAY" +
	"EDHEXAGRAM FOR APPROACHHEXAGRAM FOR CONTEMPLATIONHEXAGRAM FOR BITING THR" +
	"OUGHHEXAGRAM FOR GRACEHEXAGRAM FOR SPLITTING APARTHEXAGRAM FOR RETURNHEX" +
	"AGRAM FOR INNOCENCEHEXAGRAM FOR GREAT TAMINGHEXAGRAM FOR MOUTH CORNERSHE" +
	"XAGRAM FOR GREAT PREPONDERANCEHEXAGRAM FOR THE ABYSMAL WATERHEXAGRAM FOR" +
	" THE CLINGING FIREHEXAGRAM FOR INFLUENCEHEXAGRAM FOR DURATIONHEXAGRAM FO" +
	"R RETREATHEXAGRAM FOR GREAT POWERHEXAGRAM FOR PROGRESSHEXAGRAM FOR DARKE" +
	"NING OF THE LIGHTHEXAGRAM FOR THE FAMILYHEXAGRAM FOR OPPOSITIONHEXAGRAM " +
	"FOR OBSTRUCTIONHEXAGRAM FOR DELIVERANCEHEXAGRAM FOR DECREASEHEXAGRAM FOR" +
	" INCREASEHEXAGRAM FOR BREAKTHROUGHHEXAGRAM FOR COMING TO MEETHEXAGRAM FO" +
	"R GATHERING TOGETHERHEXAGRAM FOR PUSHING UPWARDHEXAGRAM FOR OPPRESSIONHE" +
	"XAGRAM FOR THE WELLHEXAGRAM FOR REVOLUTIONHEXAGRAM FOR THE CAULDRONHEXAG" +
	"RAM FOR THE AROUSING THUNDERHEXAGRAM FOR THE KEEPING STILL MOUNTAINHEXAG" +
	"RAM FOR DEVELOPMENTHEXAGRAM FOR THE MARRYING MAIDENHEXAGRAM FOR ABUNDANC" +
	"EHEXAGRAM FOR THE WANDERERHEXAGRAM FOR THE GENTLE WINDHEXAGRAM FOR THE J" +
	"OYOUS LAKEHEXAGRAM FOR DISPERSIONHEXAGRAM FOR LIMITATIONHEXAGRAM FOR INN" +
	"ER TRUTHHEXAGRAM FOR SMALL PREPONDERANCEHEXAGRAM FOR AFTER COMPLETIONHEX" +
	"AGRAM FOR BEFORE COMPLETIONYI SYLLABLE ITYI SYLLABLE IXYI SYLLABLE IYI S" +
	"YLLABLE IPYI SYLLABLE IETYI SYLLABLE IEXYI SYLLABLE IEYI SYLLABLE IEPYI " +
	"SYLLABLE ATYI SYLLABLE AXYI SYLLABLE AYI SYLLABLE APYI SYLLABLE UOXYI SY" +
	"LLABLE UOYI SYLLABLE UOPYI SYLLABLE OTYI SYLLABLE OXYI SYLLABLE OYI SYLL" +
	"ABLE OPYI SYLLABLE EXYI SYLLABLE EYI SYLLABLE WUYI SYLLABLE BITYI SYLLAB" +
	"LE BIXYI SYLLABLE BIYI SYLLABLE BIPYI SYLLABLE BIETYI SYLLABLE BIEXYI SY" +
	"LLABLE BIEYI SYLLABLE BIEPYI SYLLABLE BATYI SYLLABLE BAXYI SYLLABLE BAYI" +
	" SYLLABLE BAPYI SYLLABLE BUOXYI SYLLABLE BUOYI SYLLABLE BUOPYI SYLLABLE " +
	"BOTYI SYLLABLE BOXYI SYLLABLE BOYI SYLLABLE BOPYI SYLLABLE BEXYI SYLLABL" +
	"E BEYI SYLLABLE BEPYI SYLLABLE BUTYI SYLLABLE BUXYI SYLLABLE BUYI SYLLAB" +
	"LE BUPYI SYLLABLE BURXYI SYLLABLE BURYI SYLLABLE BYTYI SYLLABLE BYXYI SY" +
	"LLABLE BYYI SYLLABLE BYPYI SYLLABLE BYRXYI SYLLABLE BYRYI SYLLABLE PITYI" +
	" SYLLABLE PIXYI SYLLABLE PIYI SYLLABLE PIPYI SYLLABLE PIEXYI SYLLABLE PI" +
	"EYI SYLLABLE PIEPYI SYLLABLE PATYI SYLLABLE PAXYI SYLLABLE PAYI SYLLABLE" +
	" PAPYI SYLLABLE PUOXYI SYLLABLE PUOYI SYLLABLE PUOPYI SYLLABLE POTYI SYL" +
	"LABLE POXYI SYLLABLE POYI SYLLABLE POPYI SYLLABLE PUTYI SYLLABLE PUXYI S" +
	"YLLABLE PUYI SYLLABLE PUPYI SYLLABLE PURXYI SYLLABLE PURYI SYLLABLE PYTY" +
	"I SYLLABLE PYXYI SYLLABLE PYYI SYLLABLE PYPYI SYLLABLE PYRXYI SYLLABLE P" +
	"YRYI SYLLABLE BBITYI SYLLABLE BBIXYI SYLLABLE BBIYI SYLLABLE BBIPYI SYLL" +
	"ABLE BBIETYI SYLLABLE BBIEXYI SYLLABLE BBIEYI SYLLABLE BBIEPYI SYLLABLE " +
	"BBATYI SYLLABLE BBAXYI SYLLABLE BBAYI SYLLABLE BBAPYI SYLLABLE BBUOXYI S" +
	"YLLABLE BBUOYI SYLLABLE BBUOPYI SYLLABLE BBOTYI SYLLABLE BBOXYI SYLLABLE" +
	" BBOYI SYLLABLE BBOPYI SYLLABLE BBEXYI SYLLABLE BBEYI SYLLABLE BBEPYI SY" +
	"LLABLE BBUTYI SYLLABLE BBUXYI SYLLABLE BBUYI SYLLABLE BBUPYI SYLLABLE BB" +
	"URXYI SYLLABLE BBURYI SYLLABLE BBYTYI SYLLABLE BBYXYI SYLLABLE BBYYI SYL" +
	"LABLE BBYPYI SYLLABLE NBITYI SYLLABLE NBIXYI SYLLABLE NBIYI SYLLABLE NBI" +
	"PYI SYLLABLE NBIEXYI SYLLABLE NBIEYI SYLLABLE NBIEPYI SYLLABLE NBATYI SY" +
	"LLABLE NBAXYI SYLLABLE NBAYI SYLLABLE NBAPYI SYLLABLE NBOTYI SYLLABLE NB" +
	"OXYI SYLLABLE NBOYI SYLLABLE NBOPYI SYLLABLE NBUTYI SYLLABLE NBUXYI SYLL" +
	"ABLE NBUYI SYLLABLE NBUPYI SYLLABLE NBURXYI SYLLABLE NBURYI SYLLABLE NBY" +
	"TYI SYLLABLE NBYXYI SYLLABLE NBYYI SYLLABLE NBYPYI SYLLABLE NBYRXYI SYLL" +
	"ABLE NBYRYI SYLLABLE HMITYI SYLLABLE HMIXYI SYLLABLE HMIYI SYLLABLE HMIP" +
	"YI SYLLABLE HMIEXYI SYLLABLE HMIEYI SYLLABLE HMIEPYI SYLLABLE HMATYI SYL") + ("" +
	"LABLE HMAXYI SYLLABLE HMAYI SYLLABLE HMAPYI SYLLABLE HMUOXYI SYLLABLE HM" +
	"UOYI SYLLABLE HMUOPYI SYLLABLE HMOTYI SYLLABLE HMOXYI SYLLABLE HMOYI SYL" +
	"LABLE HMOPYI SYLLABLE HMUTYI SYLLABLE HMUXYI SYLLABLE HMUYI SYLLABLE HMU" +
	"PYI SYLLABLE HMURXYI SYLLABLE HMURYI SYLLABLE HMYXYI SYLLABLE HMYYI SYLL" +
	"ABLE HMYPYI SYLLABLE HMYRXYI SYLLABLE HMYRYI SYLLABLE MITYI SYLLABLE MIX" +
	"YI SYLLABLE MIYI SYLLABLE MIPYI SYLLABLE MIEXYI SYLLABLE MIEYI SYLLABLE " +
	"MIEPYI SYLLABLE MATYI SYLLABLE MAXYI SYLLABLE MAYI SYLLABLE MAPYI SYLLAB" +
	"LE MUOTYI SYLLABLE MUOXYI SYLLABLE MUOYI SYLLABLE MUOPYI SYLLABLE MOTYI " +
	"SYLLABLE MOXYI SYLLABLE MOYI SYLLABLE MOPYI SYLLABLE MEXYI SYLLABLE MEYI" +
	" SYLLABLE MUTYI SYLLABLE MUXYI SYLLABLE MUYI SYLLABLE MUPYI SYLLABLE MUR" +
	"XYI SYLLABLE MURYI SYLLABLE MYTYI SYLLABLE MYXYI SYLLABLE MYYI SYLLABLE " +
	"MYPYI SYLLABLE FITYI SYLLABLE FIXYI SYLLABLE FIYI SYLLABLE FIPYI SYLLABL" +
	"E FATYI SYLLABLE FAXYI SYLLABLE FAYI SYLLABLE FAPYI SYLLABLE FOXYI SYLLA" +
	"BLE FOYI SYLLABLE FOPYI SYLLABLE FUTYI SYLLABLE FUXYI SYLLABLE FUYI SYLL" +
	"ABLE FUPYI SYLLABLE FURXYI SYLLABLE FURYI SYLLABLE FYTYI SYLLABLE FYXYI " +
	"SYLLABLE FYYI SYLLABLE FYPYI SYLLABLE VITYI SYLLABLE VIXYI SYLLABLE VIYI" +
	" SYLLABLE VIPYI SYLLABLE VIETYI SYLLABLE VIEXYI SYLLABLE VIEYI SYLLABLE " +
	"VIEPYI SYLLABLE VATYI SYLLABLE VAXYI SYLLABLE VAYI SYLLABLE VAPYI SYLLAB" +
	"LE VOTYI SYLLABLE VOXYI SYLLABLE VOYI SYLLABLE VOPYI SYLLABLE VEXYI SYLL" +
	"ABLE VEPYI SYLLABLE VUTYI SYLLABLE VUXYI SYLLABLE VUYI SYLLABLE VUPYI SY" +
	"LLABLE VURXYI SYLLABLE VURYI SYLLABLE VYTYI SYLLABLE VYXYI SYLLABLE VYYI" +
	" SYLLABLE VYPYI SYLLABLE VYRXYI SYLLABLE VYRYI SYLLABLE DITYI SYLLABLE D" +
	"IXYI SYLLABLE DIYI SYLLABLE DIPYI SYLLABLE DIEXYI SYLLABLE DIEYI SYLLABL" +
	"E DIEPYI SYLLABLE DATYI SYLLABLE DAXYI SYLLABLE DAYI SYLLABLE DAPYI SYLL" +
	"ABLE DUOXYI SYLLABLE DUOYI SYLLABLE DOTYI SYLLABLE DOXYI SYLLABLE DOYI S" +
	"YLLABLE DOPYI SYLLABLE DEXYI SYLLABLE DEYI SYLLABLE DEPYI SYLLABLE DUTYI" +
	" SYLLABLE DUXYI SYLLABLE DUYI SYLLABLE DUPYI SYLLABLE DURXYI SYLLABLE DU" +
	"RYI SYLLABLE TITYI SYLLABLE TIXYI SYLLABLE TIYI SYLLABLE TIPYI SYLLABLE " +
	"TIEXYI SYLLABLE TIEYI SYLLABLE TIEPYI SYLLABLE TATYI SYLLABLE TAXYI SYLL" +
	"ABLE TAYI SYLLABLE TAPYI SYLLABLE TUOTYI SYLLABLE TUOXYI SYLLABLE TUOYI " +
	"SYLLABLE TUOPYI SYLLABLE TOTYI SYLLABLE TOXYI SYLLABLE TOYI SYLLABLE TOP" +
	"YI SYLLABLE TEXYI SYLLABLE TEYI SYLLABLE TEPYI SYLLABLE TUTYI SYLLABLE T" +
	"UXYI SYLLABLE TUYI SYLLABLE TUPYI SYLLABLE TURXYI SYLLABLE TURYI SYLLABL" +
	"E DDITYI SYLLABLE DDIXYI SYLLABLE DDIYI SYLLABLE DDIPYI SYLLABLE DDIEXYI" +
	" SYLLABLE DDIEYI SYLLABLE DDIEPYI SYLLABLE DDATYI SYLLABLE DDAXYI SYLLAB" +
	"LE DDAYI SYLLABLE DDAPYI SYLLABLE DDUOXYI SYLLABLE DDUOYI SYLLABLE DDUOP" +
	"YI SYLLABLE DDOTYI SYLLABLE DDOXYI SYLLABLE DDOYI SYLLABLE DDOPYI SYLLAB" +
	"LE DDEXYI SYLLABLE DDEYI SYLLABLE DDEPYI SYLLABLE DDUTYI SYLLABLE DDUXYI" +
	" SYLLABLE DDUYI SYLLABLE DDUPYI SYLLABLE DDURXYI SYLLABLE DDURYI SYLLABL" +
	"E NDITYI SYLLABLE NDIXYI SYLLABLE NDIYI SYLLABLE NDIPYI SYLLABLE NDIEXYI" +
	" SYLLABLE NDIEYI SYLLABLE NDATYI SYLLABLE NDAXYI SYLLABLE NDAYI SYLLABLE" +
	" NDAPYI SYLLABLE NDOTYI SYLLABLE NDOXYI SYLLABLE NDOYI SYLLABLE NDOPYI S" +
	"YLLABLE NDEXYI SYLLABLE NDEYI SYLLABLE NDEPYI SYLLABLE NDUTYI SYLLABLE N" +
	"DUXYI SYLLABLE NDUYI SYLLABLE NDUPYI SYLLABLE NDURXYI SYLLABLE NDURYI SY" +
	"LLABLE HNITYI SYLLABLE HNIXYI SYLLABLE HNIYI SYLLABLE HNIPYI SYLLABLE HN" +
	"IETYI SYLLABLE HNIEXYI SYLLABLE HNIEYI SYLLABLE HNIEPYI SYLLABLE HNATYI " +
	"SYLLABLE HNAXYI SYLLABLE HNAYI SYLLABLE HNAPYI SYLLABLE HNUOXYI SYLLABLE" +
	" HNUOYI SYLLABLE HNOTYI SYLLABLE HNOXYI SYLLABLE HNOPYI SYLLABLE HNEXYI " +
	"SYLLABLE HNEYI SYLLABLE HNEPYI SYLLABLE HNUTYI SYLLABLE NITYI SYLLABLE N" +
	"IXYI SYLLABLE NIYI SYLLABLE NIPYI SYLLABLE NIEXYI SYLLABLE NIEYI SYLLABL" +
	"E NIEPYI SYLLABLE NAXYI SYLLABLE NAYI SYLLABLE NAPYI SYLLABLE NUOXYI SYL" +
	"LABLE NUOYI SYLLABLE NUOPYI SYLLABLE NOTYI SYLLABLE NOXYI SYLLABLE NOYI " +
	"SYLLABLE NOPYI SYLLABLE NEXYI SYLLABLE NEYI SYLLABLE NEPYI SYLLABLE NUTY" +
	"I SYLLABLE NUXYI SYLLABLE NUYI SYLLABLE NUPYI SYLLABLE NURXYI SYLLABLE N" +
	"URYI SYLLABLE HLITYI SYLLABLE HLIXYI SYLLABLE HLIYI SYLLABLE HLIPYI SYLL" +
	"ABLE HLIEXYI SYLLABLE HLIEYI SYLLABLE HLIEPYI SYLLABLE HLATYI SYLLABLE H" +
	"LAXYI SYLLABLE HLAYI SYLLABLE HLAPYI SYLLABLE HLUOXYI SYLLABLE HLUOYI SY" +
	"LLABLE HLUOPYI SYLLABLE HLOXYI SYLLABLE HLOYI SYLLABLE HLOPYI SYLLABLE H" +
	"LEXYI SYLLABLE HLEYI SYLLABLE HLEPYI SYLLABLE HLUTYI SYLLABLE HLUXYI SYL" +
	"LABLE HLUYI SYLLABLE HLUPYI SYLLABLE HLURXYI SYLLABLE HLURYI SYLLABLE HL" +
	"YTYI SYLLABLE HLYXYI SYLLABLE HLYYI SYLLABLE HLYPYI SYLLABLE HLYRXYI SYL" +
	"LABLE HLYRYI SYLLABLE LITYI SYLLABLE LIXYI SYLLABLE LIYI SYLLABLE LIPYI " +
	"SYLLABLE LIETYI SYLLABLE LIEXYI SYLLABLE LIEYI SYLLABLE LIEPYI SYLLABLE " +
	"LATYI SYLLABLE LAXYI SYLLABLE LAYI SYLLABLE LAPYI SYLLABLE LUOTYI SYLLAB") + ("" +
	"LE LUOXYI SYLLABLE LUOYI SYLLABLE LUOPYI SYLLABLE LOTYI SYLLABLE LOXYI S" +
	"YLLABLE LOYI SYLLABLE LOPYI SYLLABLE LEXYI SYLLABLE LEYI SYLLABLE LEPYI " +
	"SYLLABLE LUTYI SYLLABLE LUXYI SYLLABLE LUYI SYLLABLE LUPYI SYLLABLE LURX" +
	"YI SYLLABLE LURYI SYLLABLE LYTYI SYLLABLE LYXYI SYLLABLE LYYI SYLLABLE L" +
	"YPYI SYLLABLE LYRXYI SYLLABLE LYRYI SYLLABLE GITYI SYLLABLE GIXYI SYLLAB" +
	"LE GIYI SYLLABLE GIPYI SYLLABLE GIETYI SYLLABLE GIEXYI SYLLABLE GIEYI SY" +
	"LLABLE GIEPYI SYLLABLE GATYI SYLLABLE GAXYI SYLLABLE GAYI SYLLABLE GAPYI" +
	" SYLLABLE GUOTYI SYLLABLE GUOXYI SYLLABLE GUOYI SYLLABLE GUOPYI SYLLABLE" +
	" GOTYI SYLLABLE GOXYI SYLLABLE GOYI SYLLABLE GOPYI SYLLABLE GETYI SYLLAB" +
	"LE GEXYI SYLLABLE GEYI SYLLABLE GEPYI SYLLABLE GUTYI SYLLABLE GUXYI SYLL" +
	"ABLE GUYI SYLLABLE GUPYI SYLLABLE GURXYI SYLLABLE GURYI SYLLABLE KITYI S" +
	"YLLABLE KIXYI SYLLABLE KIYI SYLLABLE KIPYI SYLLABLE KIEXYI SYLLABLE KIEY" +
	"I SYLLABLE KIEPYI SYLLABLE KATYI SYLLABLE KAXYI SYLLABLE KAYI SYLLABLE K" +
	"APYI SYLLABLE KUOXYI SYLLABLE KUOYI SYLLABLE KUOPYI SYLLABLE KOTYI SYLLA" +
	"BLE KOXYI SYLLABLE KOYI SYLLABLE KOPYI SYLLABLE KETYI SYLLABLE KEXYI SYL" +
	"LABLE KEYI SYLLABLE KEPYI SYLLABLE KUTYI SYLLABLE KUXYI SYLLABLE KUYI SY" +
	"LLABLE KUPYI SYLLABLE KURXYI SYLLABLE KURYI SYLLABLE GGITYI SYLLABLE GGI" +
	"XYI SYLLABLE GGIYI SYLLABLE GGIEXYI SYLLABLE GGIEYI SYLLABLE GGIEPYI SYL" +
	"LABLE GGATYI SYLLABLE GGAXYI SYLLABLE GGAYI SYLLABLE GGAPYI SYLLABLE GGU" +
	"OTYI SYLLABLE GGUOXYI SYLLABLE GGUOYI SYLLABLE GGUOPYI SYLLABLE GGOTYI S" +
	"YLLABLE GGOXYI SYLLABLE GGOYI SYLLABLE GGOPYI SYLLABLE GGETYI SYLLABLE G" +
	"GEXYI SYLLABLE GGEYI SYLLABLE GGEPYI SYLLABLE GGUTYI SYLLABLE GGUXYI SYL" +
	"LABLE GGUYI SYLLABLE GGUPYI SYLLABLE GGURXYI SYLLABLE GGURYI SYLLABLE MG" +
	"IEXYI SYLLABLE MGIEYI SYLLABLE MGATYI SYLLABLE MGAXYI SYLLABLE MGAYI SYL" +
	"LABLE MGAPYI SYLLABLE MGUOXYI SYLLABLE MGUOYI SYLLABLE MGUOPYI SYLLABLE " +
	"MGOTYI SYLLABLE MGOXYI SYLLABLE MGOYI SYLLABLE MGOPYI SYLLABLE MGEXYI SY" +
	"LLABLE MGEYI SYLLABLE MGEPYI SYLLABLE MGUTYI SYLLABLE MGUXYI SYLLABLE MG" +
	"UYI SYLLABLE MGUPYI SYLLABLE MGURXYI SYLLABLE MGURYI SYLLABLE HXITYI SYL" +
	"LABLE HXIXYI SYLLABLE HXIYI SYLLABLE HXIPYI SYLLABLE HXIETYI SYLLABLE HX" +
	"IEXYI SYLLABLE HXIEYI SYLLABLE HXIEPYI SYLLABLE HXATYI SYLLABLE HXAXYI S" +
	"YLLABLE HXAYI SYLLABLE HXAPYI SYLLABLE HXUOTYI SYLLABLE HXUOXYI SYLLABLE" +
	" HXUOYI SYLLABLE HXUOPYI SYLLABLE HXOTYI SYLLABLE HXOXYI SYLLABLE HXOYI " +
	"SYLLABLE HXOPYI SYLLABLE HXEXYI SYLLABLE HXEYI SYLLABLE HXEPYI SYLLABLE " +
	"NGIEXYI SYLLABLE NGIEYI SYLLABLE NGIEPYI SYLLABLE NGATYI SYLLABLE NGAXYI" +
	" SYLLABLE NGAYI SYLLABLE NGAPYI SYLLABLE NGUOTYI SYLLABLE NGUOXYI SYLLAB" +
	"LE NGUOYI SYLLABLE NGOTYI SYLLABLE NGOXYI SYLLABLE NGOYI SYLLABLE NGOPYI" +
	" SYLLABLE NGEXYI SYLLABLE NGEYI SYLLABLE NGEPYI SYLLABLE HITYI SYLLABLE " +
	"HIEXYI SYLLABLE HIEYI SYLLABLE HATYI SYLLABLE HAXYI SYLLABLE HAYI SYLLAB" +
	"LE HAPYI SYLLABLE HUOTYI SYLLABLE HUOXYI SYLLABLE HUOYI SYLLABLE HUOPYI " +
	"SYLLABLE HOTYI SYLLABLE HOXYI SYLLABLE HOYI SYLLABLE HOPYI SYLLABLE HEXY" +
	"I SYLLABLE HEYI SYLLABLE HEPYI SYLLABLE WATYI SYLLABLE WAXYI SYLLABLE WA" +
	"YI SYLLABLE WAPYI SYLLABLE WUOXYI SYLLABLE WUOYI SYLLABLE WUOPYI SYLLABL" +
	"E WOXYI SYLLABLE WOYI SYLLABLE WOPYI SYLLABLE WEXYI SYLLABLE WEYI SYLLAB" +
	"LE WEPYI SYLLABLE ZITYI SYLLABLE ZIXYI SYLLABLE ZIYI SYLLABLE ZIPYI SYLL" +
	"ABLE ZIEXYI SYLLABLE ZIEYI SYLLABLE ZIEPYI SYLLABLE ZATYI SYLLABLE ZAXYI" +
	" SYLLABLE ZAYI SYLLABLE ZAPYI SYLLABLE ZUOXYI SYLLABLE ZUOYI SYLLABLE ZU" +
	"OPYI SYLLABLE ZOTYI SYLLABLE ZOXYI SYLLABLE ZOYI SYLLABLE ZOPYI SYLLABLE" +
	" ZEXYI SYLLABLE ZEYI SYLLABLE ZEPYI SYLLABLE ZUTYI SYLLABLE ZUXYI SYLLAB" +
	"LE ZUYI SYLLABLE ZUPYI SYLLABLE ZURXYI SYLLABLE ZURYI SYLLABLE ZYTYI SYL" +
	"LABLE ZYXYI SYLLABLE ZYYI SYLLABLE ZYPYI SYLLABLE ZYRXYI SYLLABLE ZYRYI " +
	"SYLLABLE CITYI SYLLABLE CIXYI SYLLABLE CIYI SYLLABLE CIPYI SYLLABLE CIET" +
	"YI SYLLABLE CIEXYI SYLLABLE CIEYI SYLLABLE CIEPYI SYLLABLE CATYI SYLLABL" +
	"E CAXYI SYLLABLE CAYI SYLLABLE CAPYI SYLLABLE CUOXYI SYLLABLE CUOYI SYLL" +
	"ABLE CUOPYI SYLLABLE COTYI SYLLABLE COXYI SYLLABLE COYI SYLLABLE COPYI S" +
	"YLLABLE CEXYI SYLLABLE CEYI SYLLABLE CEPYI SYLLABLE CUTYI SYLLABLE CUXYI" +
	" SYLLABLE CUYI SYLLABLE CUPYI SYLLABLE CURXYI SYLLABLE CURYI SYLLABLE CY" +
	"TYI SYLLABLE CYXYI SYLLABLE CYYI SYLLABLE CYPYI SYLLABLE CYRXYI SYLLABLE" +
	" CYRYI SYLLABLE ZZITYI SYLLABLE ZZIXYI SYLLABLE ZZIYI SYLLABLE ZZIPYI SY" +
	"LLABLE ZZIETYI SYLLABLE ZZIEXYI SYLLABLE ZZIEYI SYLLABLE ZZIEPYI SYLLABL" +
	"E ZZATYI SYLLABLE ZZAXYI SYLLABLE ZZAYI SYLLABLE ZZAPYI SYLLABLE ZZOXYI " +
	"SYLLABLE ZZOYI SYLLABLE ZZOPYI SYLLABLE ZZEXYI SYLLABLE ZZEYI SYLLABLE Z" +
	"ZEPYI SYLLABLE ZZUXYI SYLLABLE ZZUYI SYLLABLE ZZUPYI SYLLABLE ZZURXYI SY" +
	"LLABLE ZZURYI SYLLABLE ZZYTYI SYLLABLE ZZYXYI SYLLABLE ZZYYI SYLLABLE ZZ" +
	"YPYI SYLLABLE ZZYRXYI SYLLABLE ZZYRYI SYLLABLE NZITYI SYLLABLE NZIXYI SY") + ("" +
	"LLABLE NZIYI SYLLABLE NZIPYI SYLLABLE NZIEXYI SYLLABLE NZIEYI SYLLABLE N" +
	"ZIEPYI SYLLABLE NZATYI SYLLABLE NZAXYI SYLLABLE NZAYI SYLLABLE NZAPYI SY" +
	"LLABLE NZUOXYI SYLLABLE NZUOYI SYLLABLE NZOXYI SYLLABLE NZOPYI SYLLABLE " +
	"NZEXYI SYLLABLE NZEYI SYLLABLE NZUXYI SYLLABLE NZUYI SYLLABLE NZUPYI SYL" +
	"LABLE NZURXYI SYLLABLE NZURYI SYLLABLE NZYTYI SYLLABLE NZYXYI SYLLABLE N" +
	"ZYYI SYLLABLE NZYPYI SYLLABLE NZYRXYI SYLLABLE NZYRYI SYLLABLE SITYI SYL" +
	"LABLE SIXYI SYLLABLE SIYI SYLLABLE SIPYI SYLLABLE SIEXYI SYLLABLE SIEYI " +
	"SYLLABLE SIEPYI SYLLABLE SATYI SYLLABLE SAXYI SYLLABLE SAYI SYLLABLE SAP" +
	"YI SYLLABLE SUOXYI SYLLABLE SUOYI SYLLABLE SUOPYI SYLLABLE SOTYI SYLLABL" +
	"E SOXYI SYLLABLE SOYI SYLLABLE SOPYI SYLLABLE SEXYI SYLLABLE SEYI SYLLAB" +
	"LE SEPYI SYLLABLE SUTYI SYLLABLE SUXYI SYLLABLE SUYI SYLLABLE SUPYI SYLL" +
	"ABLE SURXYI SYLLABLE SURYI SYLLABLE SYTYI SYLLABLE SYXYI SYLLABLE SYYI S" +
	"YLLABLE SYPYI SYLLABLE SYRXYI SYLLABLE SYRYI SYLLABLE SSITYI SYLLABLE SS" +
	"IXYI SYLLABLE SSIYI SYLLABLE SSIPYI SYLLABLE SSIEXYI SYLLABLE SSIEYI SYL" +
	"LABLE SSIEPYI SYLLABLE SSATYI SYLLABLE SSAXYI SYLLABLE SSAYI SYLLABLE SS" +
	"APYI SYLLABLE SSOTYI SYLLABLE SSOXYI SYLLABLE SSOYI SYLLABLE SSOPYI SYLL" +
	"ABLE SSEXYI SYLLABLE SSEYI SYLLABLE SSEPYI SYLLABLE SSUTYI SYLLABLE SSUX" +
	"YI SYLLABLE SSUYI SYLLABLE SSUPYI SYLLABLE SSYTYI SYLLABLE SSYXYI SYLLAB" +
	"LE SSYYI SYLLABLE SSYPYI SYLLABLE SSYRXYI SYLLABLE SSYRYI SYLLABLE ZHATY" +
	"I SYLLABLE ZHAXYI SYLLABLE ZHAYI SYLLABLE ZHAPYI SYLLABLE ZHUOXYI SYLLAB" +
	"LE ZHUOYI SYLLABLE ZHUOPYI SYLLABLE ZHOTYI SYLLABLE ZHOXYI SYLLABLE ZHOY" +
	"I SYLLABLE ZHOPYI SYLLABLE ZHETYI SYLLABLE ZHEXYI SYLLABLE ZHEYI SYLLABL" +
	"E ZHEPYI SYLLABLE ZHUTYI SYLLABLE ZHUXYI SYLLABLE ZHUYI SYLLABLE ZHUPYI " +
	"SYLLABLE ZHURXYI SYLLABLE ZHURYI SYLLABLE ZHYTYI SYLLABLE ZHYXYI SYLLABL" +
	"E ZHYYI SYLLABLE ZHYPYI SYLLABLE ZHYRXYI SYLLABLE ZHYRYI SYLLABLE CHATYI" +
	" SYLLABLE CHAXYI SYLLABLE CHAYI SYLLABLE CHAPYI SYLLABLE CHUOTYI SYLLABL" +
	"E CHUOXYI SYLLABLE CHUOYI SYLLABLE CHUOPYI SYLLABLE CHOTYI SYLLABLE CHOX" +
	"YI SYLLABLE CHOYI SYLLABLE CHOPYI SYLLABLE CHETYI SYLLABLE CHEXYI SYLLAB" +
	"LE CHEYI SYLLABLE CHEPYI SYLLABLE CHUXYI SYLLABLE CHUYI SYLLABLE CHUPYI " +
	"SYLLABLE CHURXYI SYLLABLE CHURYI SYLLABLE CHYTYI SYLLABLE CHYXYI SYLLABL" +
	"E CHYYI SYLLABLE CHYPYI SYLLABLE CHYRXYI SYLLABLE CHYRYI SYLLABLE RRAXYI" +
	" SYLLABLE RRAYI SYLLABLE RRUOXYI SYLLABLE RRUOYI SYLLABLE RROTYI SYLLABL" +
	"E RROXYI SYLLABLE RROYI SYLLABLE RROPYI SYLLABLE RRETYI SYLLABLE RREXYI " +
	"SYLLABLE RREYI SYLLABLE RREPYI SYLLABLE RRUTYI SYLLABLE RRUXYI SYLLABLE " +
	"RRUYI SYLLABLE RRUPYI SYLLABLE RRURXYI SYLLABLE RRURYI SYLLABLE RRYTYI S" +
	"YLLABLE RRYXYI SYLLABLE RRYYI SYLLABLE RRYPYI SYLLABLE RRYRXYI SYLLABLE " +
	"RRYRYI SYLLABLE NRATYI SYLLABLE NRAXYI SYLLABLE NRAYI SYLLABLE NRAPYI SY" +
	"LLABLE NROXYI SYLLABLE NROYI SYLLABLE NROPYI SYLLABLE NRETYI SYLLABLE NR" +
	"EXYI SYLLABLE NREYI SYLLABLE NREPYI SYLLABLE NRUTYI SYLLABLE NRUXYI SYLL" +
	"ABLE NRUYI SYLLABLE NRUPYI SYLLABLE NRURXYI SYLLABLE NRURYI SYLLABLE NRY" +
	"TYI SYLLABLE NRYXYI SYLLABLE NRYYI SYLLABLE NRYPYI SYLLABLE NRYRXYI SYLL" +
	"ABLE NRYRYI SYLLABLE SHATYI SYLLABLE SHAXYI SYLLABLE SHAYI SYLLABLE SHAP" +
	"YI SYLLABLE SHUOXYI SYLLABLE SHUOYI SYLLABLE SHUOPYI SYLLABLE SHOTYI SYL" +
	"LABLE SHOXYI SYLLABLE SHOYI SYLLABLE SHOPYI SYLLABLE SHETYI SYLLABLE SHE" +
	"XYI SYLLABLE SHEYI SYLLABLE SHEPYI SYLLABLE SHUTYI SYLLABLE SHUXYI SYLLA" +
	"BLE SHUYI SYLLABLE SHUPYI SYLLABLE SHURXYI SYLLABLE SHURYI SYLLABLE SHYT" +
	"YI SYLLABLE SHYXYI SYLLABLE SHYYI SYLLABLE SHYPYI SYLLABLE SHYRXYI SYLLA" +
	"BLE SHYRYI SYLLABLE RATYI SYLLABLE RAXYI SYLLABLE RAYI SYLLABLE RAPYI SY" +
	"LLABLE RUOXYI SYLLABLE RUOYI SYLLABLE RUOPYI SYLLABLE ROTYI SYLLABLE ROX" +
	"YI SYLLABLE ROYI SYLLABLE ROPYI SYLLABLE REXYI SYLLABLE REYI SYLLABLE RE" +
	"PYI SYLLABLE RUTYI SYLLABLE RUXYI SYLLABLE RUYI SYLLABLE RUPYI SYLLABLE " +
	"RURXYI SYLLABLE RURYI SYLLABLE RYTYI SYLLABLE RYXYI SYLLABLE RYYI SYLLAB" +
	"LE RYPYI SYLLABLE RYRXYI SYLLABLE RYRYI SYLLABLE JITYI SYLLABLE JIXYI SY" +
	"LLABLE JIYI SYLLABLE JIPYI SYLLABLE JIETYI SYLLABLE JIEXYI SYLLABLE JIEY" +
	"I SYLLABLE JIEPYI SYLLABLE JUOTYI SYLLABLE JUOXYI SYLLABLE JUOYI SYLLABL" +
	"E JUOPYI SYLLABLE JOTYI SYLLABLE JOXYI SYLLABLE JOYI SYLLABLE JOPYI SYLL" +
	"ABLE JUTYI SYLLABLE JUXYI SYLLABLE JUYI SYLLABLE JUPYI SYLLABLE JURXYI S" +
	"YLLABLE JURYI SYLLABLE JYTYI SYLLABLE JYXYI SYLLABLE JYYI SYLLABLE JYPYI" +
	" SYLLABLE JYRXYI SYLLABLE JYRYI SYLLABLE QITYI SYLLABLE QIXYI SYLLABLE Q" +
	"IYI SYLLABLE QIPYI SYLLABLE QIETYI SYLLABLE QIEXYI SYLLABLE QIEYI SYLLAB" +
	"LE QIEPYI SYLLABLE QUOTYI SYLLABLE QUOXYI SYLLABLE QUOYI SYLLABLE QUOPYI" +
	" SYLLABLE QOTYI SYLLABLE QOXYI SYLLABLE QOYI SYLLABLE QOPYI SYLLABLE QUT" +
	"YI SYLLABLE QUXYI SYLLABLE QUYI SYLLABLE QUPYI SYLLABLE QURXYI SYLLABLE " +
	"QURYI SYLLABLE QYTYI SYLLABLE QYXYI SYLLABLE QYYI SYLLABLE QYPYI SYLLABL") + ("" +
	"E QYRXYI SYLLABLE QYRYI SYLLABLE JJITYI SYLLABLE JJIXYI SYLLABLE JJIYI S" +
	"YLLABLE JJIPYI SYLLABLE JJIETYI SYLLABLE JJIEXYI SYLLABLE JJIEYI SYLLABL" +
	"E JJIEPYI SYLLABLE JJUOXYI SYLLABLE JJUOYI SYLLABLE JJUOPYI SYLLABLE JJO" +
	"TYI SYLLABLE JJOXYI SYLLABLE JJOYI SYLLABLE JJOPYI SYLLABLE JJUTYI SYLLA" +
	"BLE JJUXYI SYLLABLE JJUYI SYLLABLE JJUPYI SYLLABLE JJURXYI SYLLABLE JJUR" +
	"YI SYLLABLE JJYTYI SYLLABLE JJYXYI SYLLABLE JJYYI SYLLABLE JJYPYI SYLLAB" +
	"LE NJITYI SYLLABLE NJIXYI SYLLABLE NJIYI SYLLABLE NJIPYI SYLLABLE NJIETY" +
	"I SYLLABLE NJIEXYI SYLLABLE NJIEYI SYLLABLE NJIEPYI SYLLABLE NJUOXYI SYL" +
	"LABLE NJUOYI SYLLABLE NJOTYI SYLLABLE NJOXYI SYLLABLE NJOYI SYLLABLE NJO" +
	"PYI SYLLABLE NJUXYI SYLLABLE NJUYI SYLLABLE NJUPYI SYLLABLE NJURXYI SYLL" +
	"ABLE NJURYI SYLLABLE NJYTYI SYLLABLE NJYXYI SYLLABLE NJYYI SYLLABLE NJYP" +
	"YI SYLLABLE NJYRXYI SYLLABLE NJYRYI SYLLABLE NYITYI SYLLABLE NYIXYI SYLL" +
	"ABLE NYIYI SYLLABLE NYIPYI SYLLABLE NYIETYI SYLLABLE NYIEXYI SYLLABLE NY" +
	"IEYI SYLLABLE NYIEPYI SYLLABLE NYUOXYI SYLLABLE NYUOYI SYLLABLE NYUOPYI " +
	"SYLLABLE NYOTYI SYLLABLE NYOXYI SYLLABLE NYOYI SYLLABLE NYOPYI SYLLABLE " +
	"NYUTYI SYLLABLE NYUXYI SYLLABLE NYUYI SYLLABLE NYUPYI SYLLABLE XITYI SYL" +
	"LABLE XIXYI SYLLABLE XIYI SYLLABLE XIPYI SYLLABLE XIETYI SYLLABLE XIEXYI" +
	" SYLLABLE XIEYI SYLLABLE XIEPYI SYLLABLE XUOXYI SYLLABLE XUOYI SYLLABLE " +
	"XOTYI SYLLABLE XOXYI SYLLABLE XOYI SYLLABLE XOPYI SYLLABLE XYTYI SYLLABL" +
	"E XYXYI SYLLABLE XYYI SYLLABLE XYPYI SYLLABLE XYRXYI SYLLABLE XYRYI SYLL" +
	"ABLE YITYI SYLLABLE YIXYI SYLLABLE YIYI SYLLABLE YIPYI SYLLABLE YIETYI S" +
	"YLLABLE YIEXYI SYLLABLE YIEYI SYLLABLE YIEPYI SYLLABLE YUOTYI SYLLABLE Y" +
	"UOXYI SYLLABLE YUOYI SYLLABLE YUOPYI SYLLABLE YOTYI SYLLABLE YOXYI SYLLA" +
	"BLE YOYI SYLLABLE YOPYI SYLLABLE YUTYI SYLLABLE YUXYI SYLLABLE YUYI SYLL" +
	"ABLE YUPYI SYLLABLE YURXYI SYLLABLE YURYI SYLLABLE YYTYI SYLLABLE YYXYI " +
	"SYLLABLE YYYI SYLLABLE YYPYI SYLLABLE YYRXYI SYLLABLE YYRYI RADICAL QOTY" +
	"I RADICAL LIYI RADICAL KITYI RADICAL NYIPYI RADICAL CYPYI RADICAL SSIYI " +
	"RADICAL GGOPYI RADICAL GEPYI RADICAL MIYI RADICAL HXITYI RADICAL LYRYI R" +
	"ADICAL BBUTYI RADICAL MOPYI RADICAL YOYI RADICAL PUTYI RADICAL HXUOYI RA" +
	"DICAL TATYI RADICAL GAYI RADICAL ZUPYI RADICAL CYTYI RADICAL DDURYI RADI" +
	"CAL BURYI RADICAL GGUOYI RADICAL NYOPYI RADICAL TUYI RADICAL OPYI RADICA" +
	"L JJUTYI RADICAL ZOTYI RADICAL PYTYI RADICAL HMOYI RADICAL YITYI RADICAL" +
	" VURYI RADICAL SHYYI RADICAL VEPYI RADICAL ZAYI RADICAL JOYI RADICAL NZU" +
	"PYI RADICAL JJYYI RADICAL GOTYI RADICAL JJIEYI RADICAL WOYI RADICAL DUYI" +
	" RADICAL SHURYI RADICAL LIEYI RADICAL CYYI RADICAL CUOPYI RADICAL CIPYI " +
	"RADICAL HXOPYI RADICAL SHATYI RADICAL ZURYI RADICAL SHOPYI RADICAL CHEYI" +
	" RADICAL ZZIETYI RADICAL NBIEYI RADICAL KELISU LETTER BALISU LETTER PALI" +
	"SU LETTER PHALISU LETTER DALISU LETTER TALISU LETTER THALISU LETTER GALI" +
	"SU LETTER KALISU LETTER KHALISU LETTER JALISU LETTER CALISU LETTER CHALI" +
	"SU LETTER DZALISU LETTER TSALISU LETTER TSHALISU LETTER MALISU LETTER NA" +
	"LISU LETTER LALISU LETTER SALISU LETTER ZHALISU LETTER ZALISU LETTER NGA" +
	"LISU LETTER HALISU LETTER XALISU LETTER HHALISU LETTER FALISU LETTER WAL" +
	"ISU LETTER SHALISU LETTER YALISU LETTER GHALISU LETTER ALISU LETTER AELI" +
	"SU LETTER ELISU LETTER EULISU LETTER ILISU LETTER OLISU LETTER ULISU LET" +
	"TER UELISU LETTER UHLISU LETTER OELISU LETTER TONE MYA TILISU LETTER TON" +
	"E NA POLISU LETTER TONE MYA CYALISU LETTER TONE MYA BOLISU LETTER TONE M" +
	"YA NALISU LETTER TONE MYA JEULISU PUNCTUATION COMMALISU PUNCTUATION FULL" +
	" STOPVAI SYLLABLE EEVAI SYLLABLE EENVAI SYLLABLE HEEVAI SYLLABLE WEEVAI " +
	"SYLLABLE WEENVAI SYLLABLE PEEVAI SYLLABLE BHEEVAI SYLLABLE BEEVAI SYLLAB" +
	"LE MBEEVAI SYLLABLE KPEEVAI SYLLABLE MGBEEVAI SYLLABLE GBEEVAI SYLLABLE " +
	"FEEVAI SYLLABLE VEEVAI SYLLABLE TEEVAI SYLLABLE THEEVAI SYLLABLE DHEEVAI" +
	" SYLLABLE DHHEEVAI SYLLABLE LEEVAI SYLLABLE REEVAI SYLLABLE DEEVAI SYLLA" +
	"BLE NDEEVAI SYLLABLE SEEVAI SYLLABLE SHEEVAI SYLLABLE ZEEVAI SYLLABLE ZH" +
	"EEVAI SYLLABLE CEEVAI SYLLABLE JEEVAI SYLLABLE NJEEVAI SYLLABLE YEEVAI S" +
	"YLLABLE KEEVAI SYLLABLE NGGEEVAI SYLLABLE GEEVAI SYLLABLE MEEVAI SYLLABL" +
	"E NEEVAI SYLLABLE NYEEVAI SYLLABLE IVAI SYLLABLE INVAI SYLLABLE HIVAI SY" +
	"LLABLE HINVAI SYLLABLE WIVAI SYLLABLE WINVAI SYLLABLE PIVAI SYLLABLE BHI" +
	"VAI SYLLABLE BIVAI SYLLABLE MBIVAI SYLLABLE KPIVAI SYLLABLE MGBIVAI SYLL" +
	"ABLE GBIVAI SYLLABLE FIVAI SYLLABLE VIVAI SYLLABLE TIVAI SYLLABLE THIVAI" +
	" SYLLABLE DHIVAI SYLLABLE DHHIVAI SYLLABLE LIVAI SYLLABLE RIVAI SYLLABLE" +
	" DIVAI SYLLABLE NDIVAI SYLLABLE SIVAI SYLLABLE SHIVAI SYLLABLE ZIVAI SYL" +
	"LABLE ZHIVAI SYLLABLE CIVAI SYLLABLE JIVAI SYLLABLE NJIVAI SYLLABLE YIVA" +
	"I SYLLABLE KIVAI SYLLABLE NGGIVAI SYLLABLE GIVAI SYLLABLE MIVAI SYLLABLE" +
	" NIVAI SYLLABLE NYIVAI SYLLABLE AVAI SYLLABLE ANVAI SYLLABLE NGANVAI SYL") + ("" +
	"LABLE HAVAI SYLLABLE HANVAI SYLLABLE WAVAI SYLLABLE WANVAI SYLLABLE PAVA" +
	"I SYLLABLE BHAVAI SYLLABLE BAVAI SYLLABLE MBAVAI SYLLABLE KPAVAI SYLLABL" +
	"E KPANVAI SYLLABLE MGBAVAI SYLLABLE GBAVAI SYLLABLE FAVAI SYLLABLE VAVAI" +
	" SYLLABLE TAVAI SYLLABLE THAVAI SYLLABLE DHAVAI SYLLABLE DHHAVAI SYLLABL" +
	"E LAVAI SYLLABLE RAVAI SYLLABLE DAVAI SYLLABLE NDAVAI SYLLABLE SAVAI SYL" +
	"LABLE SHAVAI SYLLABLE ZAVAI SYLLABLE ZHAVAI SYLLABLE CAVAI SYLLABLE JAVA" +
	"I SYLLABLE NJAVAI SYLLABLE YAVAI SYLLABLE KAVAI SYLLABLE KANVAI SYLLABLE" +
	" NGGAVAI SYLLABLE GAVAI SYLLABLE MAVAI SYLLABLE NAVAI SYLLABLE NYAVAI SY" +
	"LLABLE OOVAI SYLLABLE OONVAI SYLLABLE HOOVAI SYLLABLE WOOVAI SYLLABLE WO" +
	"ONVAI SYLLABLE POOVAI SYLLABLE BHOOVAI SYLLABLE BOOVAI SYLLABLE MBOOVAI " +
	"SYLLABLE KPOOVAI SYLLABLE MGBOOVAI SYLLABLE GBOOVAI SYLLABLE FOOVAI SYLL" +
	"ABLE VOOVAI SYLLABLE TOOVAI SYLLABLE THOOVAI SYLLABLE DHOOVAI SYLLABLE D" +
	"HHOOVAI SYLLABLE LOOVAI SYLLABLE ROOVAI SYLLABLE DOOVAI SYLLABLE NDOOVAI" +
	" SYLLABLE SOOVAI SYLLABLE SHOOVAI SYLLABLE ZOOVAI SYLLABLE ZHOOVAI SYLLA" +
	"BLE COOVAI SYLLABLE JOOVAI SYLLABLE NJOOVAI SYLLABLE YOOVAI SYLLABLE KOO" +
	"VAI SYLLABLE NGGOOVAI SYLLABLE GOOVAI SYLLABLE MOOVAI SYLLABLE NOOVAI SY" +
	"LLABLE NYOOVAI SYLLABLE UVAI SYLLABLE UNVAI SYLLABLE HUVAI SYLLABLE HUNV" +
	"AI SYLLABLE WUVAI SYLLABLE WUNVAI SYLLABLE PUVAI SYLLABLE BHUVAI SYLLABL" +
	"E BUVAI SYLLABLE MBUVAI SYLLABLE KPUVAI SYLLABLE MGBUVAI SYLLABLE GBUVAI" +
	" SYLLABLE FUVAI SYLLABLE VUVAI SYLLABLE TUVAI SYLLABLE THUVAI SYLLABLE D" +
	"HUVAI SYLLABLE DHHUVAI SYLLABLE LUVAI SYLLABLE RUVAI SYLLABLE DUVAI SYLL" +
	"ABLE NDUVAI SYLLABLE SUVAI SYLLABLE SHUVAI SYLLABLE ZUVAI SYLLABLE ZHUVA" +
	"I SYLLABLE CUVAI SYLLABLE JUVAI SYLLABLE NJUVAI SYLLABLE YUVAI SYLLABLE " +
	"KUVAI SYLLABLE NGGUVAI SYLLABLE GUVAI SYLLABLE MUVAI SYLLABLE NUVAI SYLL" +
	"ABLE NYUVAI SYLLABLE OVAI SYLLABLE ONVAI SYLLABLE NGONVAI SYLLABLE HOVAI" +
	" SYLLABLE HONVAI SYLLABLE WOVAI SYLLABLE WONVAI SYLLABLE POVAI SYLLABLE " +
	"BHOVAI SYLLABLE BOVAI SYLLABLE MBOVAI SYLLABLE KPOVAI SYLLABLE MGBOVAI S" +
	"YLLABLE GBOVAI SYLLABLE GBONVAI SYLLABLE FOVAI SYLLABLE VOVAI SYLLABLE T" +
	"OVAI SYLLABLE THOVAI SYLLABLE DHOVAI SYLLABLE DHHOVAI SYLLABLE LOVAI SYL" +
	"LABLE ROVAI SYLLABLE DOVAI SYLLABLE NDOVAI SYLLABLE SOVAI SYLLABLE SHOVA" +
	"I SYLLABLE ZOVAI SYLLABLE ZHOVAI SYLLABLE COVAI SYLLABLE JOVAI SYLLABLE " +
	"NJOVAI SYLLABLE YOVAI SYLLABLE KOVAI SYLLABLE NGGOVAI SYLLABLE GOVAI SYL" +
	"LABLE MOVAI SYLLABLE NOVAI SYLLABLE NYOVAI SYLLABLE EVAI SYLLABLE ENVAI " +
	"SYLLABLE NGENVAI SYLLABLE HEVAI SYLLABLE HENVAI SYLLABLE WEVAI SYLLABLE " +
	"WENVAI SYLLABLE PEVAI SYLLABLE BHEVAI SYLLABLE BEVAI SYLLABLE MBEVAI SYL" +
	"LABLE KPEVAI SYLLABLE KPENVAI SYLLABLE MGBEVAI SYLLABLE GBEVAI SYLLABLE " +
	"GBENVAI SYLLABLE FEVAI SYLLABLE VEVAI SYLLABLE TEVAI SYLLABLE THEVAI SYL" +
	"LABLE DHEVAI SYLLABLE DHHEVAI SYLLABLE LEVAI SYLLABLE REVAI SYLLABLE DEV" +
	"AI SYLLABLE NDEVAI SYLLABLE SEVAI SYLLABLE SHEVAI SYLLABLE ZEVAI SYLLABL" +
	"E ZHEVAI SYLLABLE CEVAI SYLLABLE JEVAI SYLLABLE NJEVAI SYLLABLE YEVAI SY" +
	"LLABLE KEVAI SYLLABLE NGGEVAI SYLLABLE NGGENVAI SYLLABLE GEVAI SYLLABLE " +
	"GENVAI SYLLABLE MEVAI SYLLABLE NEVAI SYLLABLE NYEVAI SYLLABLE NGVAI SYLL" +
	"ABLE LENGTHENERVAI COMMAVAI FULL STOPVAI QUESTION MARKVAI SYLLABLE NDOLE" +
	" FAVAI SYLLABLE NDOLE KAVAI SYLLABLE NDOLE SOOVAI SYMBOL FEENGVAI SYMBOL" +
	" KEENGVAI SYMBOL TINGVAI SYMBOL NIIVAI SYMBOL BANGVAI SYMBOL FAAVAI SYMB" +
	"OL TAAVAI SYMBOL DANGVAI SYMBOL DOONGVAI SYMBOL KUNGVAI SYMBOL TONGVAI S" +
	"YMBOL DO-OVAI SYMBOL JONGVAI DIGIT ZEROVAI DIGIT ONEVAI DIGIT TWOVAI DIG" +
	"IT THREEVAI DIGIT FOURVAI DIGIT FIVEVAI DIGIT SIXVAI DIGIT SEVENVAI DIGI" +
	"T EIGHTVAI DIGIT NINEVAI SYLLABLE NDOLE MAVAI SYLLABLE NDOLE DOCYRILLIC " +
	"CAPITAL LETTER ZEMLYACYRILLIC SMALL LETTER ZEMLYACYRILLIC CAPITAL LETTER" +
	" DZELOCYRILLIC SMALL LETTER DZELOCYRILLIC CAPITAL LETTER REVERSED DZECYR" +
	"ILLIC SMALL LETTER REVERSED DZECYRILLIC CAPITAL LETTER IOTACYRILLIC SMAL" +
	"L LETTER IOTACYRILLIC CAPITAL LETTER DJERVCYRILLIC SMALL LETTER DJERVCYR" +
	"ILLIC CAPITAL LETTER MONOGRAPH UKCYRILLIC SMALL LETTER MONOGRAPH UKCYRIL" +
	"LIC CAPITAL LETTER BROAD OMEGACYRILLIC SMALL LETTER BROAD OMEGACYRILLIC " +
	"CAPITAL LETTER NEUTRAL YERCYRILLIC SMALL LETTER NEUTRAL YERCYRILLIC CAPI" +
	"TAL LETTER YERU WITH BACK YERCYRILLIC SMALL LETTER YERU WITH BACK YERCYR" +
	"ILLIC CAPITAL LETTER IOTIFIED YATCYRILLIC SMALL LETTER IOTIFIED YATCYRIL" +
	"LIC CAPITAL LETTER REVERSED YUCYRILLIC SMALL LETTER REVERSED YUCYRILLIC " +
	"CAPITAL LETTER IOTIFIED ACYRILLIC SMALL LETTER IOTIFIED ACYRILLIC CAPITA" +
	"L LETTER CLOSED LITTLE YUSCYRILLIC SMALL LETTER CLOSED LITTLE YUSCYRILLI" +
	"C CAPITAL LETTER BLENDED YUSCYRILLIC SMALL LETTER BLENDED YUSCYRILLIC CA" +
	"PITAL LETTER IOTIFIED CLOSED LITTLE YUSCYRILLIC SMALL LETTER IOTIFIED CL" +
	"OSED LITTLE YUSCYRILLIC CAPITAL LETTER YNCYRILLIC SMALL LETTER YNCYRILLI") + ("" +
	"C CAPITAL LETTER REVERSED TSECYRILLIC SMALL LETTER REVERSED TSECYRILLIC " +
	"CAPITAL LETTER SOFT DECYRILLIC SMALL LETTER SOFT DECYRILLIC CAPITAL LETT" +
	"ER SOFT ELCYRILLIC SMALL LETTER SOFT ELCYRILLIC CAPITAL LETTER SOFT EMCY" +
	"RILLIC SMALL LETTER SOFT EMCYRILLIC CAPITAL LETTER MONOCULAR OCYRILLIC S" +
	"MALL LETTER MONOCULAR OCYRILLIC CAPITAL LETTER BINOCULAR OCYRILLIC SMALL" +
	" LETTER BINOCULAR OCYRILLIC CAPITAL LETTER DOUBLE MONOCULAR OCYRILLIC SM" +
	"ALL LETTER DOUBLE MONOCULAR OCYRILLIC LETTER MULTIOCULAR OCOMBINING CYRI" +
	"LLIC VZMETCOMBINING CYRILLIC TEN MILLIONS SIGNCOMBINING CYRILLIC HUNDRED" +
	" MILLIONS SIGNCOMBINING CYRILLIC THOUSAND MILLIONS SIGNSLAVONIC ASTERISK" +
	"COMBINING CYRILLIC LETTER UKRAINIAN IECOMBINING CYRILLIC LETTER ICOMBINI" +
	"NG CYRILLIC LETTER YICOMBINING CYRILLIC LETTER UCOMBINING CYRILLIC LETTE" +
	"R HARD SIGNCOMBINING CYRILLIC LETTER YERUCOMBINING CYRILLIC LETTER SOFT " +
	"SIGNCOMBINING CYRILLIC LETTER OMEGACOMBINING CYRILLIC KAVYKACOMBINING CY" +
	"RILLIC PAYEROKCYRILLIC KAVYKACYRILLIC PAYEROKCYRILLIC CAPITAL LETTER DWE" +
	"CYRILLIC SMALL LETTER DWECYRILLIC CAPITAL LETTER DZWECYRILLIC SMALL LETT" +
	"ER DZWECYRILLIC CAPITAL LETTER ZHWECYRILLIC SMALL LETTER ZHWECYRILLIC CA" +
	"PITAL LETTER CCHECYRILLIC SMALL LETTER CCHECYRILLIC CAPITAL LETTER DZZEC" +
	"YRILLIC SMALL LETTER DZZECYRILLIC CAPITAL LETTER TE WITH MIDDLE HOOKCYRI" +
	"LLIC SMALL LETTER TE WITH MIDDLE HOOKCYRILLIC CAPITAL LETTER TWECYRILLIC" +
	" SMALL LETTER TWECYRILLIC CAPITAL LETTER TSWECYRILLIC SMALL LETTER TSWEC" +
	"YRILLIC CAPITAL LETTER TSSECYRILLIC SMALL LETTER TSSECYRILLIC CAPITAL LE" +
	"TTER TCHECYRILLIC SMALL LETTER TCHECYRILLIC CAPITAL LETTER HWECYRILLIC S" +
	"MALL LETTER HWECYRILLIC CAPITAL LETTER SHWECYRILLIC SMALL LETTER SHWECYR" +
	"ILLIC CAPITAL LETTER DOUBLE OCYRILLIC SMALL LETTER DOUBLE OCYRILLIC CAPI" +
	"TAL LETTER CROSSED OCYRILLIC SMALL LETTER CROSSED OMODIFIER LETTER CYRIL" +
	"LIC HARD SIGNMODIFIER LETTER CYRILLIC SOFT SIGNCOMBINING CYRILLIC LETTER" +
	" EFCOMBINING CYRILLIC LETTER IOTIFIED EBAMUM LETTER ABAMUM LETTER KABAMU" +
	"M LETTER UBAMUM LETTER KUBAMUM LETTER EEBAMUM LETTER REEBAMUM LETTER TAE" +
	"BAMUM LETTER OBAMUM LETTER NYIBAMUM LETTER IBAMUM LETTER LABAMUM LETTER " +
	"PABAMUM LETTER RIIBAMUM LETTER RIEEBAMUM LETTER LEEEEBAMUM LETTER MEEEEB" +
	"AMUM LETTER TAABAMUM LETTER NDAABAMUM LETTER NJAEMBAMUM LETTER MBAMUM LE" +
	"TTER SUUBAMUM LETTER MUBAMUM LETTER SHIIBAMUM LETTER SIBAMUM LETTER SHEU" +
	"XBAMUM LETTER SEUXBAMUM LETTER KYEEBAMUM LETTER KETBAMUM LETTER NUAEBAMU" +
	"M LETTER NUBAMUM LETTER NJUAEBAMUM LETTER YOQBAMUM LETTER SHUBAMUM LETTE" +
	"R YUQBAMUM LETTER YABAMUM LETTER NSHABAMUM LETTER KEUXBAMUM LETTER PEUXB" +
	"AMUM LETTER NJEEBAMUM LETTER NTEEBAMUM LETTER PUEBAMUM LETTER WUEBAMUM L" +
	"ETTER PEEBAMUM LETTER FEEBAMUM LETTER RUBAMUM LETTER LUBAMUM LETTER MIBA" +
	"MUM LETTER NIBAMUM LETTER REUXBAMUM LETTER RAEBAMUM LETTER KENBAMUM LETT" +
	"ER NGKWAENBAMUM LETTER NGGABAMUM LETTER NGABAMUM LETTER SHOBAMUM LETTER " +
	"PUAEBAMUM LETTER FUBAMUM LETTER FOMBAMUM LETTER WABAMUM LETTER NABAMUM L" +
	"ETTER LIBAMUM LETTER PIBAMUM LETTER LOQBAMUM LETTER KOBAMUM LETTER MBENB" +
	"AMUM LETTER RENBAMUM LETTER MENBAMUM LETTER MABAMUM LETTER TIBAMUM LETTE" +
	"R KIBAMUM LETTER MOBAMUM LETTER MBAABAMUM LETTER TETBAMUM LETTER KPABAMU" +
	"M LETTER TENBAMUM LETTER NTUUBAMUM LETTER SAMBABAMUM LETTER FAAMAEBAMUM " +
	"LETTER KOVUUBAMUM LETTER KOGHOMBAMUM COMBINING MARK KOQNDONBAMUM COMBINI" +
	"NG MARK TUKWENTISBAMUM NJAEMLIBAMUM FULL STOPBAMUM COLONBAMUM COMMABAMUM" +
	" SEMICOLONBAMUM QUESTION MARKMODIFIER LETTER CHINESE TONE YIN PINGMODIFI" +
	"ER LETTER CHINESE TONE YANG PINGMODIFIER LETTER CHINESE TONE YIN SHANGMO" +
	"DIFIER LETTER CHINESE TONE YANG SHANGMODIFIER LETTER CHINESE TONE YIN QU" +
	"MODIFIER LETTER CHINESE TONE YANG QUMODIFIER LETTER CHINESE TONE YIN RUM" +
	"ODIFIER LETTER CHINESE TONE YANG RUMODIFIER LETTER EXTRA-HIGH DOTTED TON" +
	"E BARMODIFIER LETTER HIGH DOTTED TONE BARMODIFIER LETTER MID DOTTED TONE" +
	" BARMODIFIER LETTER LOW DOTTED TONE BARMODIFIER LETTER EXTRA-LOW DOTTED " +
	"TONE BARMODIFIER LETTER EXTRA-HIGH DOTTED LEFT-STEM TONE BARMODIFIER LET" +
	"TER HIGH DOTTED LEFT-STEM TONE BARMODIFIER LETTER MID DOTTED LEFT-STEM T" +
	"ONE BARMODIFIER LETTER LOW DOTTED LEFT-STEM TONE BARMODIFIER LETTER EXTR" +
	"A-LOW DOTTED LEFT-STEM TONE BARMODIFIER LETTER EXTRA-HIGH LEFT-STEM TONE" +
	" BARMODIFIER LETTER HIGH LEFT-STEM TONE BARMODIFIER LETTER MID LEFT-STEM" +
	" TONE BARMODIFIER LETTER LOW LEFT-STEM TONE BARMODIFIER LETTER EXTRA-LOW" +
	" LEFT-STEM TONE BARMODIFIER LETTER DOT VERTICAL BARMODIFIER LETTER DOT S" +
	"LASHMODIFIER LETTER DOT HORIZONTAL BARMODIFIER LETTER LOWER RIGHT CORNER" +
	" ANGLEMODIFIER LETTER RAISED UP ARROWMODIFIER LETTER RAISED DOWN ARROWMO" +
	"DIFIER LETTER RAISED EXCLAMATION MARKMODIFIER LETTER RAISED INVERTED EXC" +
	"LAMATION MARKMODIFIER LETTER LOW INVERTED EXCLAMATION MARKMODIFIER LETTE") + ("" +
	"R STRESS AND HIGH TONEMODIFIER LETTER STRESS AND LOW TONELATIN CAPITAL L" +
	"ETTER EGYPTOLOGICAL ALEFLATIN SMALL LETTER EGYPTOLOGICAL ALEFLATIN CAPIT" +
	"AL LETTER EGYPTOLOGICAL AINLATIN SMALL LETTER EGYPTOLOGICAL AINLATIN CAP" +
	"ITAL LETTER HENGLATIN SMALL LETTER HENGLATIN CAPITAL LETTER TZLATIN SMAL" +
	"L LETTER TZLATIN CAPITAL LETTER TRESILLOLATIN SMALL LETTER TRESILLOLATIN" +
	" CAPITAL LETTER CUATRILLOLATIN SMALL LETTER CUATRILLOLATIN CAPITAL LETTE" +
	"R CUATRILLO WITH COMMALATIN SMALL LETTER CUATRILLO WITH COMMALATIN LETTE" +
	"R SMALL CAPITAL FLATIN LETTER SMALL CAPITAL SLATIN CAPITAL LETTER AALATI" +
	"N SMALL LETTER AALATIN CAPITAL LETTER AOLATIN SMALL LETTER AOLATIN CAPIT" +
	"AL LETTER AULATIN SMALL LETTER AULATIN CAPITAL LETTER AVLATIN SMALL LETT" +
	"ER AVLATIN CAPITAL LETTER AV WITH HORIZONTAL BARLATIN SMALL LETTER AV WI" +
	"TH HORIZONTAL BARLATIN CAPITAL LETTER AYLATIN SMALL LETTER AYLATIN CAPIT" +
	"AL LETTER REVERSED C WITH DOTLATIN SMALL LETTER REVERSED C WITH DOTLATIN" +
	" CAPITAL LETTER K WITH STROKELATIN SMALL LETTER K WITH STROKELATIN CAPIT" +
	"AL LETTER K WITH DIAGONAL STROKELATIN SMALL LETTER K WITH DIAGONAL STROK" +
	"ELATIN CAPITAL LETTER K WITH STROKE AND DIAGONAL STROKELATIN SMALL LETTE" +
	"R K WITH STROKE AND DIAGONAL STROKELATIN CAPITAL LETTER BROKEN LLATIN SM" +
	"ALL LETTER BROKEN LLATIN CAPITAL LETTER L WITH HIGH STROKELATIN SMALL LE" +
	"TTER L WITH HIGH STROKELATIN CAPITAL LETTER O WITH LONG STROKE OVERLAYLA" +
	"TIN SMALL LETTER O WITH LONG STROKE OVERLAYLATIN CAPITAL LETTER O WITH L" +
	"OOPLATIN SMALL LETTER O WITH LOOPLATIN CAPITAL LETTER OOLATIN SMALL LETT" +
	"ER OOLATIN CAPITAL LETTER P WITH STROKE THROUGH DESCENDERLATIN SMALL LET" +
	"TER P WITH STROKE THROUGH DESCENDERLATIN CAPITAL LETTER P WITH FLOURISHL" +
	"ATIN SMALL LETTER P WITH FLOURISHLATIN CAPITAL LETTER P WITH SQUIRREL TA" +
	"ILLATIN SMALL LETTER P WITH SQUIRREL TAILLATIN CAPITAL LETTER Q WITH STR" +
	"OKE THROUGH DESCENDERLATIN SMALL LETTER Q WITH STROKE THROUGH DESCENDERL" +
	"ATIN CAPITAL LETTER Q WITH DIAGONAL STROKELATIN SMALL LETTER Q WITH DIAG" +
	"ONAL STROKELATIN CAPITAL LETTER R ROTUNDALATIN SMALL LETTER R ROTUNDALAT" +
	"IN CAPITAL LETTER RUM ROTUNDALATIN SMALL LETTER RUM ROTUNDALATIN CAPITAL" +
	" LETTER V WITH DIAGONAL STROKELATIN SMALL LETTER V WITH DIAGONAL STROKEL" +
	"ATIN CAPITAL LETTER VYLATIN SMALL LETTER VYLATIN CAPITAL LETTER VISIGOTH" +
	"IC ZLATIN SMALL LETTER VISIGOTHIC ZLATIN CAPITAL LETTER THORN WITH STROK" +
	"ELATIN SMALL LETTER THORN WITH STROKELATIN CAPITAL LETTER THORN WITH STR" +
	"OKE THROUGH DESCENDERLATIN SMALL LETTER THORN WITH STROKE THROUGH DESCEN" +
	"DERLATIN CAPITAL LETTER VENDLATIN SMALL LETTER VENDLATIN CAPITAL LETTER " +
	"ETLATIN SMALL LETTER ETLATIN CAPITAL LETTER ISLATIN SMALL LETTER ISLATIN" +
	" CAPITAL LETTER CONLATIN SMALL LETTER CONMODIFIER LETTER USLATIN SMALL L" +
	"ETTER DUMLATIN SMALL LETTER LUMLATIN SMALL LETTER MUMLATIN SMALL LETTER " +
	"NUMLATIN SMALL LETTER RUMLATIN LETTER SMALL CAPITAL RUMLATIN SMALL LETTE" +
	"R TUMLATIN SMALL LETTER UMLATIN CAPITAL LETTER INSULAR DLATIN SMALL LETT" +
	"ER INSULAR DLATIN CAPITAL LETTER INSULAR FLATIN SMALL LETTER INSULAR FLA" +
	"TIN CAPITAL LETTER INSULAR GLATIN CAPITAL LETTER TURNED INSULAR GLATIN S" +
	"MALL LETTER TURNED INSULAR GLATIN CAPITAL LETTER TURNED LLATIN SMALL LET" +
	"TER TURNED LLATIN CAPITAL LETTER INSULAR RLATIN SMALL LETTER INSULAR RLA" +
	"TIN CAPITAL LETTER INSULAR SLATIN SMALL LETTER INSULAR SLATIN CAPITAL LE" +
	"TTER INSULAR TLATIN SMALL LETTER INSULAR TMODIFIER LETTER LOW CIRCUMFLEX" +
	" ACCENTMODIFIER LETTER COLONMODIFIER LETTER SHORT EQUALS SIGNLATIN CAPIT" +
	"AL LETTER SALTILLOLATIN SMALL LETTER SALTILLOLATIN CAPITAL LETTER TURNED" +
	" HLATIN SMALL LETTER L WITH RETROFLEX HOOK AND BELTLATIN LETTER SINOLOGI" +
	"CAL DOTLATIN CAPITAL LETTER N WITH DESCENDERLATIN SMALL LETTER N WITH DE" +
	"SCENDERLATIN CAPITAL LETTER C WITH BARLATIN SMALL LETTER C WITH BARLATIN" +
	" SMALL LETTER C WITH PALATAL HOOKLATIN SMALL LETTER H WITH PALATAL HOOKL" +
	"ATIN CAPITAL LETTER B WITH FLOURISHLATIN SMALL LETTER B WITH FLOURISHLAT" +
	"IN CAPITAL LETTER F WITH STROKELATIN SMALL LETTER F WITH STROKELATIN CAP" +
	"ITAL LETTER VOLAPUK AELATIN SMALL LETTER VOLAPUK AELATIN CAPITAL LETTER " +
	"VOLAPUK OELATIN SMALL LETTER VOLAPUK OELATIN CAPITAL LETTER VOLAPUK UELA" +
	"TIN SMALL LETTER VOLAPUK UELATIN CAPITAL LETTER G WITH OBLIQUE STROKELAT" +
	"IN SMALL LETTER G WITH OBLIQUE STROKELATIN CAPITAL LETTER K WITH OBLIQUE" +
	" STROKELATIN SMALL LETTER K WITH OBLIQUE STROKELATIN CAPITAL LETTER N WI" +
	"TH OBLIQUE STROKELATIN SMALL LETTER N WITH OBLIQUE STROKELATIN CAPITAL L" +
	"ETTER R WITH OBLIQUE STROKELATIN SMALL LETTER R WITH OBLIQUE STROKELATIN" +
	" CAPITAL LETTER S WITH OBLIQUE STROKELATIN SMALL LETTER S WITH OBLIQUE S" +
	"TROKELATIN CAPITAL LETTER H WITH HOOKLATIN CAPITAL LETTER REVERSED OPEN " +
	"ELATIN CAPITAL LETTER SCRIPT GLATIN CAPITAL LETTER L WITH BELTLATIN CAPI") + ("" +
	"TAL LETTER SMALL CAPITAL ILATIN LETTER SMALL CAPITAL QLATIN CAPITAL LETT" +
	"ER TURNED KLATIN CAPITAL LETTER TURNED TLATIN CAPITAL LETTER J WITH CROS" +
	"SED-TAILLATIN CAPITAL LETTER CHILATIN CAPITAL LETTER BETALATIN SMALL LET" +
	"TER BETALATIN CAPITAL LETTER OMEGALATIN SMALL LETTER OMEGALATIN CAPITAL " +
	"LETTER U WITH STROKELATIN SMALL LETTER U WITH STROKELATIN CAPITAL LETTER" +
	" GLOTTAL ALATIN SMALL LETTER GLOTTAL ALATIN CAPITAL LETTER GLOTTAL ILATI" +
	"N SMALL LETTER GLOTTAL ILATIN CAPITAL LETTER GLOTTAL ULATIN SMALL LETTER" +
	" GLOTTAL ULATIN CAPITAL LETTER ANGLICANA WLATIN SMALL LETTER ANGLICANA W" +
	"LATIN CAPITAL LETTER C WITH PALATAL HOOKLATIN CAPITAL LETTER S WITH HOOK" +
	"LATIN CAPITAL LETTER Z WITH PALATAL HOOKLATIN EPIGRAPHIC LETTER SIDEWAYS" +
	" IMODIFIER LETTER CAPITAL H WITH STROKEMODIFIER LETTER SMALL LIGATURE OE" +
	"LATIN LETTER SMALL CAPITAL TURNED MLATIN EPIGRAPHIC LETTER REVERSED FLAT" +
	"IN EPIGRAPHIC LETTER REVERSED PLATIN EPIGRAPHIC LETTER INVERTED MLATIN E" +
	"PIGRAPHIC LETTER I LONGALATIN EPIGRAPHIC LETTER ARCHAIC MSYLOTI NAGRI LE" +
	"TTER ASYLOTI NAGRI LETTER ISYLOTI NAGRI SIGN DVISVARASYLOTI NAGRI LETTER" +
	" USYLOTI NAGRI LETTER ESYLOTI NAGRI LETTER OSYLOTI NAGRI SIGN HASANTASYL" +
	"OTI NAGRI LETTER KOSYLOTI NAGRI LETTER KHOSYLOTI NAGRI LETTER GOSYLOTI N" +
	"AGRI LETTER GHOSYLOTI NAGRI SIGN ANUSVARASYLOTI NAGRI LETTER COSYLOTI NA" +
	"GRI LETTER CHOSYLOTI NAGRI LETTER JOSYLOTI NAGRI LETTER JHOSYLOTI NAGRI " +
	"LETTER TTOSYLOTI NAGRI LETTER TTHOSYLOTI NAGRI LETTER DDOSYLOTI NAGRI LE" +
	"TTER DDHOSYLOTI NAGRI LETTER TOSYLOTI NAGRI LETTER THOSYLOTI NAGRI LETTE" +
	"R DOSYLOTI NAGRI LETTER DHOSYLOTI NAGRI LETTER NOSYLOTI NAGRI LETTER POS" +
	"YLOTI NAGRI LETTER PHOSYLOTI NAGRI LETTER BOSYLOTI NAGRI LETTER BHOSYLOT" +
	"I NAGRI LETTER MOSYLOTI NAGRI LETTER ROSYLOTI NAGRI LETTER LOSYLOTI NAGR" +
	"I LETTER RROSYLOTI NAGRI LETTER SOSYLOTI NAGRI LETTER HOSYLOTI NAGRI VOW" +
	"EL SIGN ASYLOTI NAGRI VOWEL SIGN ISYLOTI NAGRI VOWEL SIGN USYLOTI NAGRI " +
	"VOWEL SIGN ESYLOTI NAGRI VOWEL SIGN OOSYLOTI NAGRI POETRY MARK-1SYLOTI N" +
	"AGRI POETRY MARK-2SYLOTI NAGRI POETRY MARK-3SYLOTI NAGRI POETRY MARK-4NO" +
	"RTH INDIC FRACTION ONE QUARTERNORTH INDIC FRACTION ONE HALFNORTH INDIC F" +
	"RACTION THREE QUARTERSNORTH INDIC FRACTION ONE SIXTEENTHNORTH INDIC FRAC" +
	"TION ONE EIGHTHNORTH INDIC FRACTION THREE SIXTEENTHSNORTH INDIC QUARTER " +
	"MARKNORTH INDIC PLACEHOLDER MARKNORTH INDIC RUPEE MARKNORTH INDIC QUANTI" +
	"TY MARKPHAGS-PA LETTER KAPHAGS-PA LETTER KHAPHAGS-PA LETTER GAPHAGS-PA L" +
	"ETTER NGAPHAGS-PA LETTER CAPHAGS-PA LETTER CHAPHAGS-PA LETTER JAPHAGS-PA" +
	" LETTER NYAPHAGS-PA LETTER TAPHAGS-PA LETTER THAPHAGS-PA LETTER DAPHAGS-" +
	"PA LETTER NAPHAGS-PA LETTER PAPHAGS-PA LETTER PHAPHAGS-PA LETTER BAPHAGS" +
	"-PA LETTER MAPHAGS-PA LETTER TSAPHAGS-PA LETTER TSHAPHAGS-PA LETTER DZAP" +
	"HAGS-PA LETTER WAPHAGS-PA LETTER ZHAPHAGS-PA LETTER ZAPHAGS-PA LETTER SM" +
	"ALL APHAGS-PA LETTER YAPHAGS-PA LETTER RAPHAGS-PA LETTER LAPHAGS-PA LETT" +
	"ER SHAPHAGS-PA LETTER SAPHAGS-PA LETTER HAPHAGS-PA LETTER APHAGS-PA LETT" +
	"ER IPHAGS-PA LETTER UPHAGS-PA LETTER EPHAGS-PA LETTER OPHAGS-PA LETTER Q" +
	"APHAGS-PA LETTER XAPHAGS-PA LETTER FAPHAGS-PA LETTER GGAPHAGS-PA LETTER " +
	"EEPHAGS-PA SUBJOINED LETTER WAPHAGS-PA SUBJOINED LETTER YAPHAGS-PA LETTE" +
	"R TTAPHAGS-PA LETTER TTHAPHAGS-PA LETTER DDAPHAGS-PA LETTER NNAPHAGS-PA " +
	"LETTER ALTERNATE YAPHAGS-PA LETTER VOICELESS SHAPHAGS-PA LETTER VOICED H" +
	"APHAGS-PA LETTER ASPIRATED FAPHAGS-PA SUBJOINED LETTER RAPHAGS-PA SUPERF" +
	"IXED LETTER RAPHAGS-PA LETTER CANDRABINDUPHAGS-PA SINGLE HEAD MARKPHAGS-" +
	"PA DOUBLE HEAD MARKPHAGS-PA MARK SHADPHAGS-PA MARK DOUBLE SHADSAURASHTRA" +
	" SIGN ANUSVARASAURASHTRA SIGN VISARGASAURASHTRA LETTER ASAURASHTRA LETTE" +
	"R AASAURASHTRA LETTER ISAURASHTRA LETTER IISAURASHTRA LETTER USAURASHTRA" +
	" LETTER UUSAURASHTRA LETTER VOCALIC RSAURASHTRA LETTER VOCALIC RRSAURASH" +
	"TRA LETTER VOCALIC LSAURASHTRA LETTER VOCALIC LLSAURASHTRA LETTER ESAURA" +
	"SHTRA LETTER EESAURASHTRA LETTER AISAURASHTRA LETTER OSAURASHTRA LETTER " +
	"OOSAURASHTRA LETTER AUSAURASHTRA LETTER KASAURASHTRA LETTER KHASAURASHTR" +
	"A LETTER GASAURASHTRA LETTER GHASAURASHTRA LETTER NGASAURASHTRA LETTER C" +
	"ASAURASHTRA LETTER CHASAURASHTRA LETTER JASAURASHTRA LETTER JHASAURASHTR" +
	"A LETTER NYASAURASHTRA LETTER TTASAURASHTRA LETTER TTHASAURASHTRA LETTER" +
	" DDASAURASHTRA LETTER DDHASAURASHTRA LETTER NNASAURASHTRA LETTER TASAURA" +
	"SHTRA LETTER THASAURASHTRA LETTER DASAURASHTRA LETTER DHASAURASHTRA LETT" +
	"ER NASAURASHTRA LETTER PASAURASHTRA LETTER PHASAURASHTRA LETTER BASAURAS" +
	"HTRA LETTER BHASAURASHTRA LETTER MASAURASHTRA LETTER YASAURASHTRA LETTER" +
	" RASAURASHTRA LETTER LASAURASHTRA LETTER VASAURASHTRA LETTER SHASAURASHT" +
	"RA LETTER SSASAURASHTRA LETTER SASAURASHTRA LETTER HASAURASHTRA LETTER L" +
	"LASAURASHTRA CONSONANT SIGN HAARUSAURASHTRA VOWEL SIGN AASAURASHTRA VOWE") + ("" +
	"L SIGN ISAURASHTRA VOWEL SIGN IISAURASHTRA VOWEL SIGN USAURASHTRA VOWEL " +
	"SIGN UUSAURASHTRA VOWEL SIGN VOCALIC RSAURASHTRA VOWEL SIGN VOCALIC RRSA" +
	"URASHTRA VOWEL SIGN VOCALIC LSAURASHTRA VOWEL SIGN VOCALIC LLSAURASHTRA " +
	"VOWEL SIGN ESAURASHTRA VOWEL SIGN EESAURASHTRA VOWEL SIGN AISAURASHTRA V" +
	"OWEL SIGN OSAURASHTRA VOWEL SIGN OOSAURASHTRA VOWEL SIGN AUSAURASHTRA SI" +
	"GN VIRAMASAURASHTRA SIGN CANDRABINDUSAURASHTRA DANDASAURASHTRA DOUBLE DA" +
	"NDASAURASHTRA DIGIT ZEROSAURASHTRA DIGIT ONESAURASHTRA DIGIT TWOSAURASHT" +
	"RA DIGIT THREESAURASHTRA DIGIT FOURSAURASHTRA DIGIT FIVESAURASHTRA DIGIT" +
	" SIXSAURASHTRA DIGIT SEVENSAURASHTRA DIGIT EIGHTSAURASHTRA DIGIT NINECOM" +
	"BINING DEVANAGARI DIGIT ZEROCOMBINING DEVANAGARI DIGIT ONECOMBINING DEVA" +
	"NAGARI DIGIT TWOCOMBINING DEVANAGARI DIGIT THREECOMBINING DEVANAGARI DIG" +
	"IT FOURCOMBINING DEVANAGARI DIGIT FIVECOMBINING DEVANAGARI DIGIT SIXCOMB" +
	"INING DEVANAGARI DIGIT SEVENCOMBINING DEVANAGARI DIGIT EIGHTCOMBINING DE" +
	"VANAGARI DIGIT NINECOMBINING DEVANAGARI LETTER ACOMBINING DEVANAGARI LET" +
	"TER UCOMBINING DEVANAGARI LETTER KACOMBINING DEVANAGARI LETTER NACOMBINI" +
	"NG DEVANAGARI LETTER PACOMBINING DEVANAGARI LETTER RACOMBINING DEVANAGAR" +
	"I LETTER VICOMBINING DEVANAGARI SIGN AVAGRAHADEVANAGARI SIGN SPACING CAN" +
	"DRABINDUDEVANAGARI SIGN CANDRABINDU VIRAMADEVANAGARI SIGN DOUBLE CANDRAB" +
	"INDU VIRAMADEVANAGARI SIGN CANDRABINDU TWODEVANAGARI SIGN CANDRABINDU TH" +
	"REEDEVANAGARI SIGN CANDRABINDU AVAGRAHADEVANAGARI SIGN PUSHPIKADEVANAGAR" +
	"I GAP FILLERDEVANAGARI CARETDEVANAGARI HEADSTROKEDEVANAGARI SIGN SIDDHAM" +
	"DEVANAGARI JAIN OMDEVANAGARI LETTER AYDEVANAGARI VOWEL SIGN AYKAYAH LI D" +
	"IGIT ZEROKAYAH LI DIGIT ONEKAYAH LI DIGIT TWOKAYAH LI DIGIT THREEKAYAH L" +
	"I DIGIT FOURKAYAH LI DIGIT FIVEKAYAH LI DIGIT SIXKAYAH LI DIGIT SEVENKAY" +
	"AH LI DIGIT EIGHTKAYAH LI DIGIT NINEKAYAH LI LETTER KAKAYAH LI LETTER KH" +
	"AKAYAH LI LETTER GAKAYAH LI LETTER NGAKAYAH LI LETTER SAKAYAH LI LETTER " +
	"SHAKAYAH LI LETTER ZAKAYAH LI LETTER NYAKAYAH LI LETTER TAKAYAH LI LETTE" +
	"R HTAKAYAH LI LETTER NAKAYAH LI LETTER PAKAYAH LI LETTER PHAKAYAH LI LET" +
	"TER MAKAYAH LI LETTER DAKAYAH LI LETTER BAKAYAH LI LETTER RAKAYAH LI LET" +
	"TER YAKAYAH LI LETTER LAKAYAH LI LETTER WAKAYAH LI LETTER THAKAYAH LI LE" +
	"TTER HAKAYAH LI LETTER VAKAYAH LI LETTER CAKAYAH LI LETTER AKAYAH LI LET" +
	"TER OEKAYAH LI LETTER IKAYAH LI LETTER OOKAYAH LI VOWEL UEKAYAH LI VOWEL" +
	" EKAYAH LI VOWEL UKAYAH LI VOWEL EEKAYAH LI VOWEL OKAYAH LI TONE PLOPHUK" +
	"AYAH LI TONE CALYAKAYAH LI TONE CALYA PLOPHUKAYAH LI SIGN CWIKAYAH LI SI" +
	"GN SHYAREJANG LETTER KAREJANG LETTER GAREJANG LETTER NGAREJANG LETTER TA" +
	"REJANG LETTER DAREJANG LETTER NAREJANG LETTER PAREJANG LETTER BAREJANG L" +
	"ETTER MAREJANG LETTER CAREJANG LETTER JAREJANG LETTER NYAREJANG LETTER S" +
	"AREJANG LETTER RAREJANG LETTER LAREJANG LETTER YAREJANG LETTER WAREJANG " +
	"LETTER HAREJANG LETTER MBAREJANG LETTER NGGAREJANG LETTER NDAREJANG LETT" +
	"ER NYJAREJANG LETTER AREJANG VOWEL SIGN IREJANG VOWEL SIGN UREJANG VOWEL" +
	" SIGN EREJANG VOWEL SIGN AIREJANG VOWEL SIGN OREJANG VOWEL SIGN AUREJANG" +
	" VOWEL SIGN EUREJANG VOWEL SIGN EAREJANG CONSONANT SIGN NGREJANG CONSONA" +
	"NT SIGN NREJANG CONSONANT SIGN RREJANG CONSONANT SIGN HREJANG VIRAMAREJA" +
	"NG SECTION MARKHANGUL CHOSEONG TIKEUT-MIEUMHANGUL CHOSEONG TIKEUT-PIEUPH" +
	"ANGUL CHOSEONG TIKEUT-SIOSHANGUL CHOSEONG TIKEUT-CIEUCHANGUL CHOSEONG RI" +
	"EUL-KIYEOKHANGUL CHOSEONG RIEUL-SSANGKIYEOKHANGUL CHOSEONG RIEUL-TIKEUTH" +
	"ANGUL CHOSEONG RIEUL-SSANGTIKEUTHANGUL CHOSEONG RIEUL-MIEUMHANGUL CHOSEO" +
	"NG RIEUL-PIEUPHANGUL CHOSEONG RIEUL-SSANGPIEUPHANGUL CHOSEONG RIEUL-KAPY" +
	"EOUNPIEUPHANGUL CHOSEONG RIEUL-SIOSHANGUL CHOSEONG RIEUL-CIEUCHANGUL CHO" +
	"SEONG RIEUL-KHIEUKHHANGUL CHOSEONG MIEUM-KIYEOKHANGUL CHOSEONG MIEUM-TIK" +
	"EUTHANGUL CHOSEONG MIEUM-SIOSHANGUL CHOSEONG PIEUP-SIOS-THIEUTHHANGUL CH" +
	"OSEONG PIEUP-KHIEUKHHANGUL CHOSEONG PIEUP-HIEUHHANGUL CHOSEONG SSANGSIOS" +
	"-PIEUPHANGUL CHOSEONG IEUNG-RIEULHANGUL CHOSEONG IEUNG-HIEUHHANGUL CHOSE" +
	"ONG SSANGCIEUC-HIEUHHANGUL CHOSEONG SSANGTHIEUTHHANGUL CHOSEONG PHIEUPH-" +
	"HIEUHHANGUL CHOSEONG HIEUH-SIOSHANGUL CHOSEONG SSANGYEORINHIEUHJAVANESE " +
	"SIGN PANYANGGAJAVANESE SIGN CECAKJAVANESE SIGN LAYARJAVANESE SIGN WIGNYA" +
	"NJAVANESE LETTER AJAVANESE LETTER I KAWIJAVANESE LETTER IJAVANESE LETTER" +
	" IIJAVANESE LETTER UJAVANESE LETTER PA CEREKJAVANESE LETTER NGA LELETJAV" +
	"ANESE LETTER NGA LELET RASWADIJAVANESE LETTER EJAVANESE LETTER AIJAVANES" +
	"E LETTER OJAVANESE LETTER KAJAVANESE LETTER KA SASAKJAVANESE LETTER KA M" +
	"URDAJAVANESE LETTER GAJAVANESE LETTER GA MURDAJAVANESE LETTER NGAJAVANES" +
	"E LETTER CAJAVANESE LETTER CA MURDAJAVANESE LETTER JAJAVANESE LETTER NYA" +
	" MURDAJAVANESE LETTER JA MAHAPRANAJAVANESE LETTER NYAJAVANESE LETTER TTA" +
	"JAVANESE LETTER TTA MAHAPRANAJAVANESE LETTER DDAJAVANESE LETTER DDA MAHA") + ("" +
	"PRANAJAVANESE LETTER NA MURDAJAVANESE LETTER TAJAVANESE LETTER TA MURDAJ" +
	"AVANESE LETTER DAJAVANESE LETTER DA MAHAPRANAJAVANESE LETTER NAJAVANESE " +
	"LETTER PAJAVANESE LETTER PA MURDAJAVANESE LETTER BAJAVANESE LETTER BA MU" +
	"RDAJAVANESE LETTER MAJAVANESE LETTER YAJAVANESE LETTER RAJAVANESE LETTER" +
	" RA AGUNGJAVANESE LETTER LAJAVANESE LETTER WAJAVANESE LETTER SA MURDAJAV" +
	"ANESE LETTER SA MAHAPRANAJAVANESE LETTER SAJAVANESE LETTER HAJAVANESE SI" +
	"GN CECAK TELUJAVANESE VOWEL SIGN TARUNGJAVANESE VOWEL SIGN TOLONGJAVANES" +
	"E VOWEL SIGN WULUJAVANESE VOWEL SIGN WULU MELIKJAVANESE VOWEL SIGN SUKUJ" +
	"AVANESE VOWEL SIGN SUKU MENDUTJAVANESE VOWEL SIGN TALINGJAVANESE VOWEL S" +
	"IGN DIRGA MUREJAVANESE VOWEL SIGN PEPETJAVANESE CONSONANT SIGN KERETJAVA" +
	"NESE CONSONANT SIGN PENGKALJAVANESE CONSONANT SIGN CAKRAJAVANESE PANGKON" +
	"JAVANESE LEFT RERENGGANJAVANESE RIGHT RERENGGANJAVANESE PADA ANDAPJAVANE" +
	"SE PADA MADYAJAVANESE PADA LUHURJAVANESE PADA WINDUJAVANESE PADA PANGKAT" +
	"JAVANESE PADA LINGSAJAVANESE PADA LUNGSIJAVANESE PADA ADEGJAVANESE PADA " +
	"ADEG ADEGJAVANESE PADA PISELEHJAVANESE TURNED PADA PISELEHJAVANESE PANGR" +
	"ANGKEPJAVANESE DIGIT ZEROJAVANESE DIGIT ONEJAVANESE DIGIT TWOJAVANESE DI" +
	"GIT THREEJAVANESE DIGIT FOURJAVANESE DIGIT FIVEJAVANESE DIGIT SIXJAVANES" +
	"E DIGIT SEVENJAVANESE DIGIT EIGHTJAVANESE DIGIT NINEJAVANESE PADA TIRTA " +
	"TUMETESJAVANESE PADA ISEN-ISENMYANMAR LETTER SHAN GHAMYANMAR LETTER SHAN" +
	" CHAMYANMAR LETTER SHAN JHAMYANMAR LETTER SHAN NNAMYANMAR LETTER SHAN BH" +
	"AMYANMAR SIGN SHAN SAWMYANMAR MODIFIER LETTER SHAN REDUPLICATIONMYANMAR " +
	"LETTER TAI LAING NYAMYANMAR LETTER TAI LAING FAMYANMAR LETTER TAI LAING " +
	"GAMYANMAR LETTER TAI LAING GHAMYANMAR LETTER TAI LAING JAMYANMAR LETTER " +
	"TAI LAING JHAMYANMAR LETTER TAI LAING DDAMYANMAR LETTER TAI LAING DDHAMY" +
	"ANMAR LETTER TAI LAING NNAMYANMAR TAI LAING DIGIT ZEROMYANMAR TAI LAING " +
	"DIGIT ONEMYANMAR TAI LAING DIGIT TWOMYANMAR TAI LAING DIGIT THREEMYANMAR" +
	" TAI LAING DIGIT FOURMYANMAR TAI LAING DIGIT FIVEMYANMAR TAI LAING DIGIT" +
	" SIXMYANMAR TAI LAING DIGIT SEVENMYANMAR TAI LAING DIGIT EIGHTMYANMAR TA" +
	"I LAING DIGIT NINEMYANMAR LETTER TAI LAING LLAMYANMAR LETTER TAI LAING D" +
	"AMYANMAR LETTER TAI LAING DHAMYANMAR LETTER TAI LAING BAMYANMAR LETTER T" +
	"AI LAING BHACHAM LETTER ACHAM LETTER ICHAM LETTER UCHAM LETTER ECHAM LET" +
	"TER AICHAM LETTER OCHAM LETTER KACHAM LETTER KHACHAM LETTER GACHAM LETTE" +
	"R GHACHAM LETTER NGUECHAM LETTER NGACHAM LETTER CHACHAM LETTER CHHACHAM " +
	"LETTER JACHAM LETTER JHACHAM LETTER NHUECHAM LETTER NHACHAM LETTER NHJAC" +
	"HAM LETTER TACHAM LETTER THACHAM LETTER DACHAM LETTER DHACHAM LETTER NUE" +
	"CHAM LETTER NACHAM LETTER DDACHAM LETTER PACHAM LETTER PPACHAM LETTER PH" +
	"ACHAM LETTER BACHAM LETTER BHACHAM LETTER MUECHAM LETTER MACHAM LETTER B" +
	"BACHAM LETTER YACHAM LETTER RACHAM LETTER LACHAM LETTER VACHAM LETTER SS" +
	"ACHAM LETTER SACHAM LETTER HACHAM VOWEL SIGN AACHAM VOWEL SIGN ICHAM VOW" +
	"EL SIGN IICHAM VOWEL SIGN EICHAM VOWEL SIGN UCHAM VOWEL SIGN OECHAM VOWE" +
	"L SIGN OCHAM VOWEL SIGN AICHAM VOWEL SIGN AUCHAM VOWEL SIGN UECHAM CONSO" +
	"NANT SIGN YACHAM CONSONANT SIGN RACHAM CONSONANT SIGN LACHAM CONSONANT S" +
	"IGN WACHAM LETTER FINAL KCHAM LETTER FINAL GCHAM LETTER FINAL NGCHAM CON" +
	"SONANT SIGN FINAL NGCHAM LETTER FINAL CHCHAM LETTER FINAL TCHAM LETTER F" +
	"INAL NCHAM LETTER FINAL PCHAM LETTER FINAL YCHAM LETTER FINAL RCHAM LETT" +
	"ER FINAL LCHAM LETTER FINAL SSCHAM CONSONANT SIGN FINAL MCHAM CONSONANT " +
	"SIGN FINAL HCHAM DIGIT ZEROCHAM DIGIT ONECHAM DIGIT TWOCHAM DIGIT THREEC" +
	"HAM DIGIT FOURCHAM DIGIT FIVECHAM DIGIT SIXCHAM DIGIT SEVENCHAM DIGIT EI" +
	"GHTCHAM DIGIT NINECHAM PUNCTUATION SPIRALCHAM PUNCTUATION DANDACHAM PUNC" +
	"TUATION DOUBLE DANDACHAM PUNCTUATION TRIPLE DANDAMYANMAR LETTER KHAMTI G" +
	"AMYANMAR LETTER KHAMTI CAMYANMAR LETTER KHAMTI CHAMYANMAR LETTER KHAMTI " +
	"JAMYANMAR LETTER KHAMTI JHAMYANMAR LETTER KHAMTI NYAMYANMAR LETTER KHAMT" +
	"I TTAMYANMAR LETTER KHAMTI TTHAMYANMAR LETTER KHAMTI DDAMYANMAR LETTER K" +
	"HAMTI DDHAMYANMAR LETTER KHAMTI DHAMYANMAR LETTER KHAMTI NAMYANMAR LETTE" +
	"R KHAMTI SAMYANMAR LETTER KHAMTI HAMYANMAR LETTER KHAMTI HHAMYANMAR LETT" +
	"ER KHAMTI FAMYANMAR MODIFIER LETTER KHAMTI REDUPLICATIONMYANMAR LETTER K" +
	"HAMTI XAMYANMAR LETTER KHAMTI ZAMYANMAR LETTER KHAMTI RAMYANMAR LOGOGRAM" +
	" KHAMTI OAYMYANMAR LOGOGRAM KHAMTI QNMYANMAR LOGOGRAM KHAMTI HMMYANMAR S" +
	"YMBOL AITON EXCLAMATIONMYANMAR SYMBOL AITON ONEMYANMAR SYMBOL AITON TWOM" +
	"YANMAR LETTER AITON RAMYANMAR SIGN PAO KAREN TONEMYANMAR SIGN TAI LAING " +
	"TONE-2MYANMAR SIGN TAI LAING TONE-5MYANMAR LETTER SHWE PALAUNG CHAMYANMA" +
	"R LETTER SHWE PALAUNG SHATAI VIET LETTER LOW KOTAI VIET LETTER HIGH KOTA" +
	"I VIET LETTER LOW KHOTAI VIET LETTER HIGH KHOTAI VIET LETTER LOW KHHOTAI" +
	" VIET LETTER HIGH KHHOTAI VIET LETTER LOW GOTAI VIET LETTER HIGH GOTAI V") + ("" +
	"IET LETTER LOW NGOTAI VIET LETTER HIGH NGOTAI VIET LETTER LOW COTAI VIET" +
	" LETTER HIGH COTAI VIET LETTER LOW CHOTAI VIET LETTER HIGH CHOTAI VIET L" +
	"ETTER LOW SOTAI VIET LETTER HIGH SOTAI VIET LETTER LOW NYOTAI VIET LETTE" +
	"R HIGH NYOTAI VIET LETTER LOW DOTAI VIET LETTER HIGH DOTAI VIET LETTER L" +
	"OW TOTAI VIET LETTER HIGH TOTAI VIET LETTER LOW THOTAI VIET LETTER HIGH " +
	"THOTAI VIET LETTER LOW NOTAI VIET LETTER HIGH NOTAI VIET LETTER LOW BOTA" +
	"I VIET LETTER HIGH BOTAI VIET LETTER LOW POTAI VIET LETTER HIGH POTAI VI" +
	"ET LETTER LOW PHOTAI VIET LETTER HIGH PHOTAI VIET LETTER LOW FOTAI VIET " +
	"LETTER HIGH FOTAI VIET LETTER LOW MOTAI VIET LETTER HIGH MOTAI VIET LETT" +
	"ER LOW YOTAI VIET LETTER HIGH YOTAI VIET LETTER LOW ROTAI VIET LETTER HI" +
	"GH ROTAI VIET LETTER LOW LOTAI VIET LETTER HIGH LOTAI VIET LETTER LOW VO" +
	"TAI VIET LETTER HIGH VOTAI VIET LETTER LOW HOTAI VIET LETTER HIGH HOTAI " +
	"VIET LETTER LOW OTAI VIET LETTER HIGH OTAI VIET MAI KANGTAI VIET VOWEL A" +
	"ATAI VIET VOWEL ITAI VIET VOWEL UETAI VIET VOWEL UTAI VIET VOWEL ETAI VI" +
	"ET VOWEL OTAI VIET MAI KHITTAI VIET VOWEL IATAI VIET VOWEL UEATAI VIET V" +
	"OWEL UATAI VIET VOWEL AUETAI VIET VOWEL AYTAI VIET VOWEL ANTAI VIET VOWE" +
	"L AMTAI VIET TONE MAI EKTAI VIET TONE MAI NUENGTAI VIET TONE MAI THOTAI " +
	"VIET TONE MAI SONGTAI VIET SYMBOL KONTAI VIET SYMBOL NUENGTAI VIET SYMBO" +
	"L SAMTAI VIET SYMBOL HO HOITAI VIET SYMBOL KOI KOIMEETEI MAYEK LETTER EM" +
	"EETEI MAYEK LETTER OMEETEI MAYEK LETTER CHAMEETEI MAYEK LETTER NYAMEETEI" +
	" MAYEK LETTER TTAMEETEI MAYEK LETTER TTHAMEETEI MAYEK LETTER DDAMEETEI M" +
	"AYEK LETTER DDHAMEETEI MAYEK LETTER NNAMEETEI MAYEK LETTER SHAMEETEI MAY" +
	"EK LETTER SSAMEETEI MAYEK VOWEL SIGN IIMEETEI MAYEK VOWEL SIGN UUMEETEI " +
	"MAYEK VOWEL SIGN AAIMEETEI MAYEK VOWEL SIGN AUMEETEI MAYEK VOWEL SIGN AA" +
	"UMEETEI MAYEK CHEIKHANMEETEI MAYEK AHANG KHUDAMMEETEI MAYEK ANJIMEETEI M" +
	"AYEK SYLLABLE REPETITION MARKMEETEI MAYEK WORD REPETITION MARKMEETEI MAY" +
	"EK VOWEL SIGN VISARGAMEETEI MAYEK VIRAMAETHIOPIC SYLLABLE TTHUETHIOPIC S" +
	"YLLABLE TTHIETHIOPIC SYLLABLE TTHAAETHIOPIC SYLLABLE TTHEEETHIOPIC SYLLA" +
	"BLE TTHEETHIOPIC SYLLABLE TTHOETHIOPIC SYLLABLE DDHUETHIOPIC SYLLABLE DD" +
	"HIETHIOPIC SYLLABLE DDHAAETHIOPIC SYLLABLE DDHEEETHIOPIC SYLLABLE DDHEET" +
	"HIOPIC SYLLABLE DDHOETHIOPIC SYLLABLE DZUETHIOPIC SYLLABLE DZIETHIOPIC S" +
	"YLLABLE DZAAETHIOPIC SYLLABLE DZEEETHIOPIC SYLLABLE DZEETHIOPIC SYLLABLE" +
	" DZOETHIOPIC SYLLABLE CCHHAETHIOPIC SYLLABLE CCHHUETHIOPIC SYLLABLE CCHH" +
	"IETHIOPIC SYLLABLE CCHHAAETHIOPIC SYLLABLE CCHHEEETHIOPIC SYLLABLE CCHHE" +
	"ETHIOPIC SYLLABLE CCHHOETHIOPIC SYLLABLE BBAETHIOPIC SYLLABLE BBUETHIOPI" +
	"C SYLLABLE BBIETHIOPIC SYLLABLE BBAAETHIOPIC SYLLABLE BBEEETHIOPIC SYLLA" +
	"BLE BBEETHIOPIC SYLLABLE BBOLATIN SMALL LETTER BARRED ALPHALATIN SMALL L" +
	"ETTER A REVERSED-SCHWALATIN SMALL LETTER BLACKLETTER ELATIN SMALL LETTER" +
	" BARRED ELATIN SMALL LETTER E WITH FLOURISHLATIN SMALL LETTER LENIS FLAT" +
	"IN SMALL LETTER SCRIPT G WITH CROSSED-TAILLATIN SMALL LETTER L WITH INVE" +
	"RTED LAZY SLATIN SMALL LETTER L WITH DOUBLE MIDDLE TILDELATIN SMALL LETT" +
	"ER L WITH MIDDLE RINGLATIN SMALL LETTER M WITH CROSSED-TAILLATIN SMALL L" +
	"ETTER N WITH CROSSED-TAILLATIN SMALL LETTER ENG WITH CROSSED-TAILLATIN S" +
	"MALL LETTER BLACKLETTER OLATIN SMALL LETTER BLACKLETTER O WITH STROKELAT" +
	"IN SMALL LETTER OPEN O WITH STROKELATIN SMALL LETTER INVERTED OELATIN SM" +
	"ALL LETTER TURNED OE WITH STROKELATIN SMALL LETTER TURNED OE WITH HORIZO" +
	"NTAL STROKELATIN SMALL LETTER TURNED O OPEN-OLATIN SMALL LETTER TURNED O" +
	" OPEN-O WITH STROKELATIN SMALL LETTER STIRRUP RLATIN LETTER SMALL CAPITA" +
	"L R WITH RIGHT LEGLATIN SMALL LETTER R WITHOUT HANDLELATIN SMALL LETTER " +
	"DOUBLE RLATIN SMALL LETTER R WITH CROSSED-TAILLATIN SMALL LETTER DOUBLE " +
	"R WITH CROSSED-TAILLATIN SMALL LETTER SCRIPT RLATIN SMALL LETTER SCRIPT " +
	"R WITH RINGLATIN SMALL LETTER BASELINE ESHLATIN SMALL LETTER U WITH SHOR" +
	"T RIGHT LEGLATIN SMALL LETTER U BAR WITH SHORT RIGHT LEGLATIN SMALL LETT" +
	"ER UILATIN SMALL LETTER TURNED UILATIN SMALL LETTER U WITH LEFT HOOKLATI" +
	"N SMALL LETTER CHILATIN SMALL LETTER CHI WITH LOW RIGHT RINGLATIN SMALL " +
	"LETTER CHI WITH LOW LEFT SERIFLATIN SMALL LETTER X WITH LOW RIGHT RINGLA" +
	"TIN SMALL LETTER X WITH LONG LEFT LEGLATIN SMALL LETTER X WITH LONG LEFT" +
	" LEG AND LOW RIGHT RINGLATIN SMALL LETTER X WITH LONG LEFT LEG WITH SERI" +
	"FLATIN SMALL LETTER Y WITH SHORT RIGHT LEGMODIFIER BREVE WITH INVERTED B" +
	"REVEMODIFIER LETTER SMALL HENGMODIFIER LETTER SMALL L WITH INVERTED LAZY" +
	" SMODIFIER LETTER SMALL L WITH MIDDLE TILDEMODIFIER LETTER SMALL U WITH " +
	"LEFT HOOKLATIN SMALL LETTER SAKHA YATLATIN SMALL LETTER IOTIFIED ELATIN " +
	"SMALL LETTER OPEN OELATIN SMALL LETTER UOLATIN SMALL LETTER INVERTED ALP" +
	"HAGREEK LETTER SMALL CAPITAL OMEGALATIN SMALL LETTER DZ DIGRAPH WITH RET") + ("" +
	"ROFLEX HOOKLATIN SMALL LETTER TS DIGRAPH WITH RETROFLEX HOOKCHEROKEE SMA" +
	"LL LETTER ACHEROKEE SMALL LETTER ECHEROKEE SMALL LETTER ICHEROKEE SMALL " +
	"LETTER OCHEROKEE SMALL LETTER UCHEROKEE SMALL LETTER VCHEROKEE SMALL LET" +
	"TER GACHEROKEE SMALL LETTER KACHEROKEE SMALL LETTER GECHEROKEE SMALL LET" +
	"TER GICHEROKEE SMALL LETTER GOCHEROKEE SMALL LETTER GUCHEROKEE SMALL LET" +
	"TER GVCHEROKEE SMALL LETTER HACHEROKEE SMALL LETTER HECHEROKEE SMALL LET" +
	"TER HICHEROKEE SMALL LETTER HOCHEROKEE SMALL LETTER HUCHEROKEE SMALL LET" +
	"TER HVCHEROKEE SMALL LETTER LACHEROKEE SMALL LETTER LECHEROKEE SMALL LET" +
	"TER LICHEROKEE SMALL LETTER LOCHEROKEE SMALL LETTER LUCHEROKEE SMALL LET" +
	"TER LVCHEROKEE SMALL LETTER MACHEROKEE SMALL LETTER MECHEROKEE SMALL LET" +
	"TER MICHEROKEE SMALL LETTER MOCHEROKEE SMALL LETTER MUCHEROKEE SMALL LET" +
	"TER NACHEROKEE SMALL LETTER HNACHEROKEE SMALL LETTER NAHCHEROKEE SMALL L" +
	"ETTER NECHEROKEE SMALL LETTER NICHEROKEE SMALL LETTER NOCHEROKEE SMALL L" +
	"ETTER NUCHEROKEE SMALL LETTER NVCHEROKEE SMALL LETTER QUACHEROKEE SMALL " +
	"LETTER QUECHEROKEE SMALL LETTER QUICHEROKEE SMALL LETTER QUOCHEROKEE SMA" +
	"LL LETTER QUUCHEROKEE SMALL LETTER QUVCHEROKEE SMALL LETTER SACHEROKEE S" +
	"MALL LETTER SCHEROKEE SMALL LETTER SECHEROKEE SMALL LETTER SICHEROKEE SM" +
	"ALL LETTER SOCHEROKEE SMALL LETTER SUCHEROKEE SMALL LETTER SVCHEROKEE SM" +
	"ALL LETTER DACHEROKEE SMALL LETTER TACHEROKEE SMALL LETTER DECHEROKEE SM" +
	"ALL LETTER TECHEROKEE SMALL LETTER DICHEROKEE SMALL LETTER TICHEROKEE SM" +
	"ALL LETTER DOCHEROKEE SMALL LETTER DUCHEROKEE SMALL LETTER DVCHEROKEE SM" +
	"ALL LETTER DLACHEROKEE SMALL LETTER TLACHEROKEE SMALL LETTER TLECHEROKEE" +
	" SMALL LETTER TLICHEROKEE SMALL LETTER TLOCHEROKEE SMALL LETTER TLUCHERO" +
	"KEE SMALL LETTER TLVCHEROKEE SMALL LETTER TSACHEROKEE SMALL LETTER TSECH" +
	"EROKEE SMALL LETTER TSICHEROKEE SMALL LETTER TSOCHEROKEE SMALL LETTER TS" +
	"UCHEROKEE SMALL LETTER TSVCHEROKEE SMALL LETTER WACHEROKEE SMALL LETTER " +
	"WECHEROKEE SMALL LETTER WICHEROKEE SMALL LETTER WOCHEROKEE SMALL LETTER " +
	"WUCHEROKEE SMALL LETTER WVCHEROKEE SMALL LETTER YAMEETEI MAYEK LETTER KO" +
	"KMEETEI MAYEK LETTER SAMMEETEI MAYEK LETTER LAIMEETEI MAYEK LETTER MITME" +
	"ETEI MAYEK LETTER PAMEETEI MAYEK LETTER NAMEETEI MAYEK LETTER CHILMEETEI" +
	" MAYEK LETTER TILMEETEI MAYEK LETTER KHOUMEETEI MAYEK LETTER NGOUMEETEI " +
	"MAYEK LETTER THOUMEETEI MAYEK LETTER WAIMEETEI MAYEK LETTER YANGMEETEI M" +
	"AYEK LETTER HUKMEETEI MAYEK LETTER UNMEETEI MAYEK LETTER IMEETEI MAYEK L" +
	"ETTER PHAMMEETEI MAYEK LETTER ATIYAMEETEI MAYEK LETTER GOKMEETEI MAYEK L" +
	"ETTER JHAMMEETEI MAYEK LETTER RAIMEETEI MAYEK LETTER BAMEETEI MAYEK LETT" +
	"ER JILMEETEI MAYEK LETTER DILMEETEI MAYEK LETTER GHOUMEETEI MAYEK LETTER" +
	" DHOUMEETEI MAYEK LETTER BHAMMEETEI MAYEK LETTER KOK LONSUMMEETEI MAYEK " +
	"LETTER LAI LONSUMMEETEI MAYEK LETTER MIT LONSUMMEETEI MAYEK LETTER PA LO" +
	"NSUMMEETEI MAYEK LETTER NA LONSUMMEETEI MAYEK LETTER TIL LONSUMMEETEI MA" +
	"YEK LETTER NGOU LONSUMMEETEI MAYEK LETTER I LONSUMMEETEI MAYEK VOWEL SIG" +
	"N ONAPMEETEI MAYEK VOWEL SIGN INAPMEETEI MAYEK VOWEL SIGN ANAPMEETEI MAY" +
	"EK VOWEL SIGN YENAPMEETEI MAYEK VOWEL SIGN SOUNAPMEETEI MAYEK VOWEL SIGN" +
	" UNAPMEETEI MAYEK VOWEL SIGN CHEINAPMEETEI MAYEK VOWEL SIGN NUNGMEETEI M" +
	"AYEK CHEIKHEIMEETEI MAYEK LUM IYEKMEETEI MAYEK APUN IYEKMEETEI MAYEK DIG" +
	"IT ZEROMEETEI MAYEK DIGIT ONEMEETEI MAYEK DIGIT TWOMEETEI MAYEK DIGIT TH" +
	"REEMEETEI MAYEK DIGIT FOURMEETEI MAYEK DIGIT FIVEMEETEI MAYEK DIGIT SIXM" +
	"EETEI MAYEK DIGIT SEVENMEETEI MAYEK DIGIT EIGHTMEETEI MAYEK DIGIT NINEHA" +
	"NGUL JUNGSEONG O-YEOHANGUL JUNGSEONG O-O-IHANGUL JUNGSEONG YO-AHANGUL JU" +
	"NGSEONG YO-AEHANGUL JUNGSEONG YO-EOHANGUL JUNGSEONG U-YEOHANGUL JUNGSEON" +
	"G U-I-IHANGUL JUNGSEONG YU-AEHANGUL JUNGSEONG YU-OHANGUL JUNGSEONG EU-AH" +
	"ANGUL JUNGSEONG EU-EOHANGUL JUNGSEONG EU-EHANGUL JUNGSEONG EU-OHANGUL JU" +
	"NGSEONG I-YA-OHANGUL JUNGSEONG I-YAEHANGUL JUNGSEONG I-YEOHANGUL JUNGSEO" +
	"NG I-YEHANGUL JUNGSEONG I-O-IHANGUL JUNGSEONG I-YOHANGUL JUNGSEONG I-YUH" +
	"ANGUL JUNGSEONG I-IHANGUL JUNGSEONG ARAEA-AHANGUL JUNGSEONG ARAEA-EHANGU" +
	"L JONGSEONG NIEUN-RIEULHANGUL JONGSEONG NIEUN-CHIEUCHHANGUL JONGSEONG SS" +
	"ANGTIKEUTHANGUL JONGSEONG SSANGTIKEUT-PIEUPHANGUL JONGSEONG TIKEUT-PIEUP" +
	"HANGUL JONGSEONG TIKEUT-SIOSHANGUL JONGSEONG TIKEUT-SIOS-KIYEOKHANGUL JO" +
	"NGSEONG TIKEUT-CIEUCHANGUL JONGSEONG TIKEUT-CHIEUCHHANGUL JONGSEONG TIKE" +
	"UT-THIEUTHHANGUL JONGSEONG RIEUL-SSANGKIYEOKHANGUL JONGSEONG RIEUL-KIYEO" +
	"K-HIEUHHANGUL JONGSEONG SSANGRIEUL-KHIEUKHHANGUL JONGSEONG RIEUL-MIEUM-H" +
	"IEUHHANGUL JONGSEONG RIEUL-PIEUP-TIKEUTHANGUL JONGSEONG RIEUL-PIEUP-PHIE" +
	"UPHHANGUL JONGSEONG RIEUL-YESIEUNGHANGUL JONGSEONG RIEUL-YEORINHIEUH-HIE" +
	"UHHANGUL JONGSEONG KAPYEOUNRIEULHANGUL JONGSEONG MIEUM-NIEUNHANGUL JONGS" +
	"EONG MIEUM-SSANGNIEUNHANGUL JONGSEONG SSANGMIEUMHANGUL JONGSEONG MIEUM-P") + ("" +
	"IEUP-SIOSHANGUL JONGSEONG MIEUM-CIEUCHANGUL JONGSEONG PIEUP-TIKEUTHANGUL" +
	" JONGSEONG PIEUP-RIEUL-PHIEUPHHANGUL JONGSEONG PIEUP-MIEUMHANGUL JONGSEO" +
	"NG SSANGPIEUPHANGUL JONGSEONG PIEUP-SIOS-TIKEUTHANGUL JONGSEONG PIEUP-CI" +
	"EUCHANGUL JONGSEONG PIEUP-CHIEUCHHANGUL JONGSEONG SIOS-MIEUMHANGUL JONGS" +
	"EONG SIOS-KAPYEOUNPIEUPHANGUL JONGSEONG SSANGSIOS-KIYEOKHANGUL JONGSEONG" +
	" SSANGSIOS-TIKEUTHANGUL JONGSEONG SIOS-PANSIOSHANGUL JONGSEONG SIOS-CIEU" +
	"CHANGUL JONGSEONG SIOS-CHIEUCHHANGUL JONGSEONG SIOS-THIEUTHHANGUL JONGSE" +
	"ONG SIOS-HIEUHHANGUL JONGSEONG PANSIOS-PIEUPHANGUL JONGSEONG PANSIOS-KAP" +
	"YEOUNPIEUPHANGUL JONGSEONG YESIEUNG-MIEUMHANGUL JONGSEONG YESIEUNG-HIEUH" +
	"HANGUL JONGSEONG CIEUC-PIEUPHANGUL JONGSEONG CIEUC-SSANGPIEUPHANGUL JONG" +
	"SEONG SSANGCIEUCHANGUL JONGSEONG PHIEUPH-SIOSHANGUL JONGSEONG PHIEUPH-TH" +
	"IEUTHCJK COMPATIBILITY IDEOGRAPH-F900CJK COMPATIBILITY IDEOGRAPH-F901CJK" +
	" COMPATIBILITY IDEOGRAPH-F902CJK COMPATIBILITY IDEOGRAPH-F903CJK COMPATI" +
	"BILITY IDEOGRAPH-F904CJK COMPATIBILITY IDEOGRAPH-F905CJK COMPATIBILITY I" +
	"DEOGRAPH-F906CJK COMPATIBILITY IDEOGRAPH-F907CJK COMPATIBILITY IDEOGRAPH" +
	"-F908CJK COMPATIBILITY IDEOGRAPH-F909CJK COMPATIBILITY IDEOGRAPH-F90ACJK" +
	" COMPATIBILITY IDEOGRAPH-F90BCJK COMPATIBILITY IDEOGRAPH-F90CCJK COMPATI" +
	"BILITY IDEOGRAPH-F90DCJK COMPATIBILITY IDEOGRAPH-F90ECJK COMPATIBILITY I" +
	"DEOGRAPH-F90FCJK COMPATIBILITY IDEOGRAPH-F910CJK COMPATIBILITY IDEOGRAPH" +
	"-F911CJK COMPATIBILITY IDEOGRAPH-F912CJK COMPATIBILITY IDEOGRAPH-F913CJK" +
	" COMPATIBILITY IDEOGRAPH-F914CJK COMPATIBILITY IDEOGRAPH-F915CJK COMPATI" +
	"BILITY IDEOGRAPH-F916CJK COMPATIBILITY IDEOGRAPH-F917CJK COMPATIBILITY I" +
	"DEOGRAPH-F918CJK COMPATIBILITY IDEOGRAPH-F919CJK COMPATIBILITY IDEOGRAPH" +
	"-F91ACJK COMPATIBILITY IDEOGRAPH-F91BCJK COMPATIBILITY IDEOGRAPH-F91CCJK" +
	" COMPATIBILITY IDEOGRAPH-F91DCJK COMPATIBILITY IDEOGRAPH-F91ECJK COMPATI" +
	"BILITY IDEOGRAPH-F91FCJK COMPATIBILITY IDEOGRAPH-F920CJK COMPATIBILITY I" +
	"DEOGRAPH-F921CJK COMPATIBILITY IDEOGRAPH-F922CJK COMPATIBILITY IDEOGRAPH" +
	"-F923CJK COMPATIBILITY IDEOGRAPH-F924CJK COMPATIBILITY IDEOGRAPH-F925CJK" +
	" COMPATIBILITY IDEOGRAPH-F926CJK COMPATIBILITY IDEOGRAPH-F927CJK COMPATI" +
	"BILITY IDEOGRAPH-F928CJK COMPATIBILITY IDEOGRAPH-F929CJK COMPATIBILITY I" +
	"DEOGRAPH-F92ACJK COMPATIBILITY IDEOGRAPH-F92BCJK COMPATIBILITY IDEOGRAPH" +
	"-F92CCJK COMPATIBILITY IDEOGRAPH-F92DCJK COMPATIBILITY IDEOGRAPH-F92ECJK" +
	" COMPATIBILITY IDEOGRAPH-F92FCJK COMPATIBILITY IDEOGRAPH-F930CJK COMPATI" +
	"BILITY IDEOGRAPH-F931CJK COMPATIBILITY IDEOGRAPH-F932CJK COMPATIBILITY I" +
	"DEOGRAPH-F933CJK COMPATIBILITY IDEOGRAPH-F934CJK COMPATIBILITY IDEOGRAPH" +
	"-F935CJK COMPATIBILITY IDEOGRAPH-F936CJK COMPATIBILITY IDEOGRAPH-F937CJK" +
	" COMPATIBILITY IDEOGRAPH-F938CJK COMPATIBILITY IDEOGRAPH-F939CJK COMPATI" +
	"BILITY IDEOGRAPH-F93ACJK COMPATIBILITY IDEOGRAPH-F93BCJK COMPATIBILITY I" +
	"DEOGRAPH-F93CCJK COMPATIBILITY IDEOGRAPH-F93DCJK COMPATIBILITY IDEOGRAPH" +
	"-F93ECJK COMPATIBILITY IDEOGRAPH-F93FCJK COMPATIBILITY IDEOGRAPH-F940CJK" +
	" COMPATIBILITY IDEOGRAPH-F941CJK COMPATIBILITY IDEOGRAPH-F942CJK COMPATI" +
	"BILITY IDEOGRAPH-F943CJK COMPATIBILITY IDEOGRAPH-F944CJK COMPATIBILITY I" +
	"DEOGRAPH-F945CJK COMPATIBILITY IDEOGRAPH-F946CJK COMPATIBILITY IDEOGRAPH" +
	"-F947CJK COMPATIBILITY IDEOGRAPH-F948CJK COMPATIBILITY IDEOGRAPH-F949CJK" +
	" COMPATIBILITY IDEOGRAPH-F94ACJK COMPATIBILITY IDEOGRAPH-F94BCJK COMPATI" +
	"BILITY IDEOGRAPH-F94CCJK COMPATIBILITY IDEOGRAPH-F94DCJK COMPATIBILITY I" +
	"DEOGRAPH-F94ECJK COMPATIBILITY IDEOGRAPH-F94FCJK COMPATIBILITY IDEOGRAPH" +
	"-F950CJK COMPATIBILITY IDEOGRAPH-F951CJK COMPATIBILITY IDEOGRAPH-F952CJK" +
	" COMPATIBILITY IDEOGRAPH-F953CJK COMPATIBILITY IDEOGRAPH-F954CJK COMPATI" +
	"BILITY IDEOGRAPH-F955CJK COMPATIBILITY IDEOGRAPH-F956CJK COMPATIBILITY I" +
	"DEOGRAPH-F957CJK COMPATIBILITY IDEOGRAPH-F958CJK COMPATIBILITY IDEOGRAPH" +
	"-F959CJK COMPATIBILITY IDEOGRAPH-F95ACJK COMPATIBILITY IDEOGRAPH-F95BCJK" +
	" COMPATIBILITY IDEOGRAPH-F95CCJK COMPATIBILITY IDEOGRAPH-F95DCJK COMPATI" +
	"BILITY IDEOGRAPH-F95ECJK COMPATIBILITY IDEOGRAPH-F95FCJK COMPATIBILITY I" +
	"DEOGRAPH-F960CJK COMPATIBILITY IDEOGRAPH-F961CJK COMPATIBILITY IDEOGRAPH" +
	"-F962CJK COMPATIBILITY IDEOGRAPH-F963CJK COMPATIBILITY IDEOGRAPH-F964CJK" +
	" COMPATIBILITY IDEOGRAPH-F965CJK COMPATIBILITY IDEOGRAPH-F966CJK COMPATI" +
	"BILITY IDEOGRAPH-F967CJK COMPATIBILITY IDEOGRAPH-F968CJK COMPATIBILITY I" +
	"DEOGRAPH-F969CJK COMPATIBILITY IDEOGRAPH-F96ACJK COMPATIBILITY IDEOGRAPH" +
	"-F96BCJK COMPATIBILITY IDEOGRAPH-F96CCJK COMPATIBILITY IDEOGRAPH-F96DCJK" +
	" COMPATIBILITY IDEOGRAPH-F96ECJK COMPATIBILITY IDEOGRAPH-F96FCJK COMPATI" +
	"BILITY IDEOGRAPH-F970CJK COMPATIBILITY IDEOGRAPH-F971CJK COMPATIBILITY I" +
	"DEOGRAPH-F972CJK COMPATIBILITY IDEOGRAPH-F973CJK COMPATIBILITY IDEOGRAPH" +
	"-F974CJK COMPATIBILITY IDEOGRAPH-F975CJK COMPATIBILITY IDEOGRAPH-F976CJK") + ("" +
	" COMPATIBILITY IDEOGRAPH-F977CJK COMPATIBILITY IDEOGRAPH-F978CJK COMPATI" +
	"BILITY IDEOGRAPH-F979CJK COMPATIBILITY IDEOGRAPH-F97ACJK COMPATIBILITY I" +
	"DEOGRAPH-F97BCJK COMPATIBILITY IDEOGRAPH-F97CCJK COMPATIBILITY IDEOGRAPH" +
	"-F97DCJK COMPATIBILITY IDEOGRAPH-F97ECJK COMPATIBILITY IDEOGRAPH-F97FCJK" +
	" COMPATIBILITY IDEOGRAPH-F980CJK COMPATIBILITY IDEOGRAPH-F981CJK COMPATI" +
	"BILITY IDEOGRAPH-F982CJK COMPATIBILITY IDEOGRAPH-F983CJK COMPATIBILITY I" +
	"DEOGRAPH-F984CJK COMPATIBILITY IDEOGRAPH-F985CJK COMPATIBILITY IDEOGRAPH" +
	"-F986CJK COMPATIBILITY IDEOGRAPH-F987CJK COMPATIBILITY IDEOGRAPH-F988CJK" +
	" COMPATIBILITY IDEOGRAPH-F989CJK COMPATIBILITY IDEOGRAPH-F98ACJK COMPATI" +
	"BILITY IDEOGRAPH-F98BCJK COMPATIBILITY IDEOGRAPH-F98CCJK COMPATIBILITY I" +
	"DEOGRAPH-F98DCJK COMPATIBILITY IDEOGRAPH-F98ECJK COMPATIBILITY IDEOGRAPH" +
	"-F98FCJK COMPATIBILITY IDEOGRAPH-F990CJK COMPATIBILITY IDEOGRAPH-F991CJK" +
	" COMPATIBILITY IDEOGRAPH-F992CJK COMPATIBILITY IDEOGRAPH-F993CJK COMPATI" +
	"BILITY IDEOGRAPH-F994CJK COMPATIBILITY IDEOGRAPH-F995CJK COMPATIBILITY I" +
	"DEOGRAPH-F996CJK COMPATIBILITY IDEOGRAPH-F997CJK COMPATIBILITY IDEOGRAPH" +
	"-F998CJK COMPATIBILITY IDEOGRAPH-F999CJK COMPATIBILITY IDEOGRAPH-F99ACJK" +
	" COMPATIBILITY IDEOGRAPH-F99BCJK COMPATIBILITY IDEOGRAPH-F99CCJK COMPATI" +
	"BILITY IDEOGRAPH-F99DCJK COMPATIBILITY IDEOGRAPH-F99ECJK COMPATIBILITY I" +
	"DEOGRAPH-F99FCJK COMPATIBILITY IDEOGRAPH-F9A0CJK COMPATIBILITY IDEOGRAPH" +
	"-F9A1CJK COMPATIBILITY IDEOGRAPH-F9A2CJK COMPATIBILITY IDEOGRAPH-F9A3CJK" +
	" COMPATIBILITY IDEOGRAPH-F9A4CJK COMPATIBILITY IDEOGRAPH-F9A5CJK COMPATI" +
	"BILITY IDEOGRAPH-F9A6CJK COMPATIBILITY IDEOGRAPH-F9A7CJK COMPATIBILITY I" +
	"DEOGRAPH-F9A8CJK COMPATIBILITY IDEOGRAPH-F9A9CJK COMPATIBILITY IDEOGRAPH" +
	"-F9AACJK COMPATIBILITY IDEOGRAPH-F9ABCJK COMPATIBILITY IDEOGRAPH-F9ACCJK" +
	" COMPATIBILITY IDEOGRAPH-F9ADCJK COMPATIBILITY IDEOGRAPH-F9AECJK COMPATI" +
	"BILITY IDEOGRAPH-F9AFCJK COMPATIBILITY IDEOGRAPH-F9B0CJK COMPATIBILITY I" +
	"DEOGRAPH-F9B1CJK COMPATIBILITY IDEOGRAPH-F9B2CJK COMPATIBILITY IDEOGRAPH" +
	"-F9B3CJK COMPATIBILITY IDEOGRAPH-F9B4CJK COMPATIBILITY IDEOGRAPH-F9B5CJK" +
	" COMPATIBILITY IDEOGRAPH-F9B6CJK COMPATIBILITY IDEOGRAPH-F9B7CJK COMPATI" +
	"BILITY IDEOGRAPH-F9B8CJK COMPATIBILITY IDEOGRAPH-F9B9CJK COMPATIBILITY I" +
	"DEOGRAPH-F9BACJK COMPATIBILITY IDEOGRAPH-F9BBCJK COMPATIBILITY IDEOGRAPH" +
	"-F9BCCJK COMPATIBILITY IDEOGRAPH-F9BDCJK COMPATIBILITY IDEOGRAPH-F9BECJK" +
	" COMPATIBILITY IDEOGRAPH-F9BFCJK COMPATIBILITY IDEOGRAPH-F9C0CJK COMPATI" +
	"BILITY IDEOGRAPH-F9C1CJK COMPATIBILITY IDEOGRAPH-F9C2CJK COMPATIBILITY I" +
	"DEOGRAPH-F9C3CJK COMPATIBILITY IDEOGRAPH-F9C4CJK COMPATIBILITY IDEOGRAPH" +
	"-F9C5CJK COMPATIBILITY IDEOGRAPH-F9C6CJK COMPATIBILITY IDEOGRAPH-F9C7CJK" +
	" COMPATIBILITY IDEOGRAPH-F9C8CJK COMPATIBILITY IDEOGRAPH-F9C9CJK COMPATI" +
	"BILITY IDEOGRAPH-F9CACJK COMPATIBILITY IDEOGRAPH-F9CBCJK COMPATIBILITY I" +
	"DEOGRAPH-F9CCCJK COMPATIBILITY IDEOGRAPH-F9CDCJK COMPATIBILITY IDEOGRAPH" +
	"-F9CECJK COMPATIBILITY IDEOGRAPH-F9CFCJK COMPATIBILITY IDEOGRAPH-F9D0CJK" +
	" COMPATIBILITY IDEOGRAPH-F9D1CJK COMPATIBILITY IDEOGRAPH-F9D2CJK COMPATI" +
	"BILITY IDEOGRAPH-F9D3CJK COMPATIBILITY IDEOGRAPH-F9D4CJK COMPATIBILITY I" +
	"DEOGRAPH-F9D5CJK COMPATIBILITY IDEOGRAPH-F9D6CJK COMPATIBILITY IDEOGRAPH" +
	"-F9D7CJK COMPATIBILITY IDEOGRAPH-F9D8CJK COMPATIBILITY IDEOGRAPH-F9D9CJK" +
	" COMPATIBILITY IDEOGRAPH-F9DACJK COMPATIBILITY IDEOGRAPH-F9DBCJK COMPATI" +
	"BILITY IDEOGRAPH-F9DCCJK COMPATIBILITY IDEOGRAPH-F9DDCJK COMPATIBILITY I" +
	"DEOGRAPH-F9DECJK COMPATIBILITY IDEOGRAPH-F9DFCJK COMPATIBILITY IDEOGRAPH" +
	"-F9E0CJK COMPATIBILITY IDEOGRAPH-F9E1CJK COMPATIBILITY IDEOGRAPH-F9E2CJK" +
	" COMPATIBILITY IDEOGRAPH-F9E3CJK COMPATIBILITY IDEOGRAPH-F9E4CJK COMPATI" +
	"BILITY IDEOGRAPH-F9E5CJK COMPATIBILITY IDEOGRAPH-F9E6CJK COMPATIBILITY I" +
	"DEOGRAPH-F9E7CJK COMPATIBILITY IDEOGRAPH-F9E8CJK COMPATIBILITY IDEOGRAPH" +
	"-F9E9CJK COMPATIBILITY IDEOGRAPH-F9EACJK COMPATIBILITY IDEOGRAPH-F9EBCJK" +
	" COMPATIBILITY IDEOGRAPH-F9ECCJK COMPATIBILITY IDEOGRAPH-F9EDCJK COMPATI" +
	"BILITY IDEOGRAPH-F9EECJK COMPATIBILITY IDEOGRAPH-F9EFCJK COMPATIBILITY I" +
	"DEOGRAPH-F9F0CJK COMPATIBILITY IDEOGRAPH-F9F1CJK COMPATIBILITY IDEOGRAPH" +
	"-F9F2CJK COMPATIBILITY IDEOGRAPH-F9F3CJK COMPATIBILITY IDEOGRAPH-F9F4CJK" +
	" COMPATIBILITY IDEOGRAPH-F9F5CJK COMPATIBILITY IDEOGRAPH-F9F6CJK COMPATI" +
	"BILITY IDEOGRAPH-F9F7CJK COMPATIBILITY IDEOGRAPH-F9F8CJK COMPATIBILITY I" +
	"DEOGRAPH-F9F9CJK COMPATIBILITY IDEOGRAPH-F9FACJK COMPATIBILITY IDEOGRAPH" +
	"-F9FBCJK COMPATIBILITY IDEOGRAPH-F9FCCJK COMPATIBILITY IDEOGRAPH-F9FDCJK" +
	" COMPATIBILITY IDEOGRAPH-F9FECJK COMPATIBILITY IDEOGRAPH-F9FFCJK COMPATI" +
	"BILITY IDEOGRAPH-FA00CJK COMPATIBILITY IDEOGRAPH-FA01CJK COMPATIBILITY I" +
	"DEOGRAPH-FA02CJK COMPATIBILITY IDEOGRAPH-FA03CJK COMPATIBILITY IDEOGRAPH" +
	"-FA04CJK COMPATIBILITY IDEOGRAPH-FA05CJK COMPATIBILITY IDEOGRAPH-FA06CJK") + ("" +
	" COMPATIBILITY IDEOGRAPH-FA07CJK COMPATIBILITY IDEOGRAPH-FA08CJK COMPATI" +
	"BILITY IDEOGRAPH-FA09CJK COMPATIBILITY IDEOGRAPH-FA0ACJK COMPATIBILITY I" +
	"DEOGRAPH-FA0BCJK COMPATIBILITY IDEOGRAPH-FA0CCJK COMPATIBILITY IDEOGRAPH" +
	"-FA0DCJK COMPATIBILITY IDEOGRAPH-FA0ECJK COMPATIBILITY IDEOGRAPH-FA0FCJK" +
	" COMPATIBILITY IDEOGRAPH-FA10CJK COMPATIBILITY IDEOGRAPH-FA11CJK COMPATI" +
	"BILITY IDEOGRAPH-FA12CJK COMPATIBILITY IDEOGRAPH-FA13CJK COMPATIBILITY I" +
	"DEOGRAPH-FA14CJK COMPATIBILITY IDEOGRAPH-FA15CJK COMPATIBILITY IDEOGRAPH" +
	"-FA16CJK COMPATIBILITY IDEOGRAPH-FA17CJK COMPATIBILITY IDEOGRAPH-FA18CJK" +
	" COMPATIBILITY IDEOGRAPH-FA19CJK COMPATIBILITY IDEOGRAPH-FA1ACJK COMPATI" +
	"BILITY IDEOGRAPH-FA1BCJK COMPATIBILITY IDEOGRAPH-FA1CCJK COMPATIBILITY I" +
	"DEOGRAPH-FA1DCJK COMPATIBILITY IDEOGRAPH-FA1ECJK COMPATIBILITY IDEOGRAPH" +
	"-FA1FCJK COMPATIBILITY IDEOGRAPH-FA20CJK COMPATIBILITY IDEOGRAPH-FA21CJK" +
	" COMPATIBILITY IDEOGRAPH-FA22CJK COMPATIBILITY IDEOGRAPH-FA23CJK COMPATI" +
	"BILITY IDEOGRAPH-FA24CJK COMPATIBILITY IDEOGRAPH-FA25CJK COMPATIBILITY I" +
	"DEOGRAPH-FA26CJK COMPATIBILITY IDEOGRAPH-FA27CJK COMPATIBILITY IDEOGRAPH" +
	"-FA28CJK COMPATIBILITY IDEOGRAPH-FA29CJK COMPATIBILITY IDEOGRAPH-FA2ACJK" +
	" COMPATIBILITY IDEOGRAPH-FA2BCJK COMPATIBILITY IDEOGRAPH-FA2CCJK COMPATI" +
	"BILITY IDEOGRAPH-FA2DCJK COMPATIBILITY IDEOGRAPH-FA2ECJK COMPATIBILITY I" +
	"DEOGRAPH-FA2FCJK COMPATIBILITY IDEOGRAPH-FA30CJK COMPATIBILITY IDEOGRAPH" +
	"-FA31CJK COMPATIBILITY IDEOGRAPH-FA32CJK COMPATIBILITY IDEOGRAPH-FA33CJK" +
	" COMPATIBILITY IDEOGRAPH-FA34CJK COMPATIBILITY IDEOGRAPH-FA35CJK COMPATI" +
	"BILITY IDEOGRAPH-FA36CJK COMPATIBILITY IDEOGRAPH-FA37CJK COMPATIBILITY I" +
	"DEOGRAPH-FA38CJK COMPATIBILITY IDEOGRAPH-FA39CJK COMPATIBILITY IDEOGRAPH" +
	"-FA3ACJK COMPATIBILITY IDEOGRAPH-FA3BCJK COMPATIBILITY IDEOGRAPH-FA3CCJK" +
	" COMPATIBILITY IDEOGRAPH-FA3DCJK COMPATIBILITY IDEOGRAPH-FA3ECJK COMPATI" +
	"BILITY IDEOGRAPH-FA3FCJK COMPATIBILITY IDEOGRAPH-FA40CJK COMPATIBILITY I" +
	"DEOGRAPH-FA41CJK COMPATIBILITY IDEOGRAPH-FA42CJK COMPATIBILITY IDEOGRAPH" +
	"-FA43CJK COMPATIBILITY IDEOGRAPH-FA44CJK COMPATIBILITY IDEOGRAPH-FA45CJK" +
	" COMPATIBILITY IDEOGRAPH-FA46CJK COMPATIBILITY IDEOGRAPH-FA47CJK COMPATI" +
	"BILITY IDEOGRAPH-FA48CJK COMPATIBILITY IDEOGRAPH-FA49CJK COMPATIBILITY I" +
	"DEOGRAPH-FA4ACJK COMPATIBILITY IDEOGRAPH-FA4BCJK COMPATIBILITY IDEOGRAPH" +
	"-FA4CCJK COMPATIBILITY IDEOGRAPH-FA4DCJK COMPATIBILITY IDEOGRAPH-FA4ECJK" +
	" COMPATIBILITY IDEOGRAPH-FA4FCJK COMPATIBILITY IDEOGRAPH-FA50CJK COMPATI" +
	"BILITY IDEOGRAPH-FA51CJK COMPATIBILITY IDEOGRAPH-FA52CJK COMPATIBILITY I" +
	"DEOGRAPH-FA53CJK COMPATIBILITY IDEOGRAPH-FA54CJK COMPATIBILITY IDEOGRAPH" +
	"-FA55CJK COMPATIBILITY IDEOGRAPH-FA56CJK COMPATIBILITY IDEOGRAPH-FA57CJK" +
	" COMPATIBILITY IDEOGRAPH-FA58CJK COMPATIBILITY IDEOGRAPH-FA59CJK COMPATI" +
	"BILITY IDEOGRAPH-FA5ACJK COMPATIBILITY IDEOGRAPH-FA5BCJK COMPATIBILITY I" +
	"DEOGRAPH-FA5CCJK COMPATIBILITY IDEOGRAPH-FA5DCJK COMPATIBILITY IDEOGRAPH" +
	"-FA5ECJK COMPATIBILITY IDEOGRAPH-FA5FCJK COMPATIBILITY IDEOGRAPH-FA60CJK" +
	" COMPATIBILITY IDEOGRAPH-FA61CJK COMPATIBILITY IDEOGRAPH-FA62CJK COMPATI" +
	"BILITY IDEOGRAPH-FA63CJK COMPATIBILITY IDEOGRAPH-FA64CJK COMPATIBILITY I" +
	"DEOGRAPH-FA65CJK COMPATIBILITY IDEOGRAPH-FA66CJK COMPATIBILITY IDEOGRAPH" +
	"-FA67CJK COMPATIBILITY IDEOGRAPH-FA68CJK COMPATIBILITY IDEOGRAPH-FA69CJK" +
	" COMPATIBILITY IDEOGRAPH-FA6ACJK COMPATIBILITY IDEOGRAPH-FA6BCJK COMPATI" +
	"BILITY IDEOGRAPH-FA6CCJK COMPATIBILITY IDEOGRAPH-FA6DCJK COMPATIBILITY I" +
	"DEOGRAPH-FA70CJK COMPATIBILITY IDEOGRAPH-FA71CJK COMPATIBILITY IDEOGRAPH" +
	"-FA72CJK COMPATIBILITY IDEOGRAPH-FA73CJK COMPATIBILITY IDEOGRAPH-FA74CJK" +
	" COMPATIBILITY IDEOGRAPH-FA75CJK COMPATIBILITY IDEOGRAPH-FA76CJK COMPATI" +
	"BILITY IDEOGRAPH-FA77CJK COMPATIBILITY IDEOGRAPH-FA78CJK COMPATIBILITY I" +
	"DEOGRAPH-FA79CJK COMPATIBILITY IDEOGRAPH-FA7ACJK COMPATIBILITY IDEOGRAPH" +
	"-FA7BCJK COMPATIBILITY IDEOGRAPH-FA7CCJK COMPATIBILITY IDEOGRAPH-FA7DCJK" +
	" COMPATIBILITY IDEOGRAPH-FA7ECJK COMPATIBILITY IDEOGRAPH-FA7FCJK COMPATI" +
	"BILITY IDEOGRAPH-FA80CJK COMPATIBILITY IDEOGRAPH-FA81CJK COMPATIBILITY I" +
	"DEOGRAPH-FA82CJK COMPATIBILITY IDEOGRAPH-FA83CJK COMPATIBILITY IDEOGRAPH" +
	"-FA84CJK COMPATIBILITY IDEOGRAPH-FA85CJK COMPATIBILITY IDEOGRAPH-FA86CJK" +
	" COMPATIBILITY IDEOGRAPH-FA87CJK COMPATIBILITY IDEOGRAPH-FA88CJK COMPATI" +
	"BILITY IDEOGRAPH-FA89CJK COMPATIBILITY IDEOGRAPH-FA8ACJK COMPATIBILITY I" +
	"DEOGRAPH-FA8BCJK COMPATIBILITY IDEOGRAPH-FA8CCJK COMPATIBILITY IDEOGRAPH" +
	"-FA8DCJK COMPATIBILITY IDEOGRAPH-FA8ECJK COMPATIBILITY IDEOGRAPH-FA8FCJK" +
	" COMPATIBILITY IDEOGRAPH-FA90CJK COMPATIBILITY IDEOGRAPH-FA91CJK COMPATI" +
	"BILITY IDEOGRAPH-FA92CJK COMPATIBILITY IDEOGRAPH-FA93CJK COMPATIBILITY I" +
	"DEOGRAPH-FA94CJK COMPATIBILITY IDEOGRAPH-FA95CJK COMPATIBILITY IDEOGRAPH" +
	"-FA96CJK COMPATIBILITY IDEOGRAPH-FA97CJK COMPATIBILITY IDEOGRAPH-FA98CJK") + ("" +
	" COMPATIBILITY IDEOGRAPH-FA99CJK COMPATIBILITY IDEOGRAPH-FA9ACJK COMPATI" +
	"BILITY IDEOGRAPH-FA9BCJK COMPATIBILITY IDEOGRAPH-FA9CCJK COMPATIBILITY I" +
	"DEOGRAPH-FA9DCJK COMPATIBILITY IDEOGRAPH-FA9ECJK COMPATIBILITY IDEOGRAPH" +
	"-FA9FCJK COMPATIBILITY IDEOGRAPH-FAA0CJK COMPATIBILITY IDEOGRAPH-FAA1CJK" +
	" COMPATIBILITY IDEOGRAPH-FAA2CJK COMPATIBILITY IDEOGRAPH-FAA3CJK COMPATI" +
	"BILITY IDEOGRAPH-FAA4CJK COMPATIBILITY IDEOGRAPH-FAA5CJK COMPATIBILITY I" +
	"DEOGRAPH-FAA6CJK COMPATIBILITY IDEOGRAPH-FAA7CJK COMPATIBILITY IDEOGRAPH" +
	"-FAA8CJK COMPATIBILITY IDEOGRAPH-FAA9CJK COMPATIBILITY IDEOGRAPH-FAAACJK" +
	" COMPATIBILITY IDEOGRAPH-FAABCJK COMPATIBILITY IDEOGRAPH-FAACCJK COMPATI" +
	"BILITY IDEOGRAPH-FAADCJK COMPATIBILITY IDEOGRAPH-FAAECJK COMPATIBILITY I" +
	"DEOGRAPH-FAAFCJK COMPATIBILITY IDEOGRAPH-FAB0CJK COMPATIBILITY IDEOGRAPH" +
	"-FAB1CJK COMPATIBILITY IDEOGRAPH-FAB2CJK COMPATIBILITY IDEOGRAPH-FAB3CJK" +
	" COMPATIBILITY IDEOGRAPH-FAB4CJK COMPATIBILITY IDEOGRAPH-FAB5CJK COMPATI" +
	"BILITY IDEOGRAPH-FAB6CJK COMPATIBILITY IDEOGRAPH-FAB7CJK COMPATIBILITY I" +
	"DEOGRAPH-FAB8CJK COMPATIBILITY IDEOGRAPH-FAB9CJK COMPATIBILITY IDEOGRAPH" +
	"-FABACJK COMPATIBILITY IDEOGRAPH-FABBCJK COMPATIBILITY IDEOGRAPH-FABCCJK" +
	" COMPATIBILITY IDEOGRAPH-FABDCJK COMPATIBILITY IDEOGRAPH-FABECJK COMPATI" +
	"BILITY IDEOGRAPH-FABFCJK COMPATIBILITY IDEOGRAPH-FAC0CJK COMPATIBILITY I" +
	"DEOGRAPH-FAC1CJK COMPATIBILITY IDEOGRAPH-FAC2CJK COMPATIBILITY IDEOGRAPH" +
	"-FAC3CJK COMPATIBILITY IDEOGRAPH-FAC4CJK COMPATIBILITY IDEOGRAPH-FAC5CJK" +
	" COMPATIBILITY IDEOGRAPH-FAC6CJK COMPATIBILITY IDEOGRAPH-FAC7CJK COMPATI" +
	"BILITY IDEOGRAPH-FAC8CJK COMPATIBILITY IDEOGRAPH-FAC9CJK COMPATIBILITY I" +
	"DEOGRAPH-FACACJK COMPATIBILITY IDEOGRAPH-FACBCJK COMPATIBILITY IDEOGRAPH" +
	"-FACCCJK COMPATIBILITY IDEOGRAPH-FACDCJK COMPATIBILITY IDEOGRAPH-FACECJK" +
	" COMPATIBILITY IDEOGRAPH-FACFCJK COMPATIBILITY IDEOGRAPH-FAD0CJK COMPATI" +
	"BILITY IDEOGRAPH-FAD1CJK COMPATIBILITY IDEOGRAPH-FAD2CJK COMPATIBILITY I" +
	"DEOGRAPH-FAD3CJK COMPATIBILITY IDEOGRAPH-FAD4CJK COMPATIBILITY IDEOGRAPH" +
	"-FAD5CJK COMPATIBILITY IDEOGRAPH-FAD6CJK COMPATIBILITY IDEOGRAPH-FAD7CJK" +
	" COMPATIBILITY IDEOGRAPH-FAD8CJK COMPATIBILITY IDEOGRAPH-FAD9LATIN SMALL" +
	" LIGATURE FFLATIN SMALL LIGATURE FILATIN SMALL LIGATURE FLLATIN SMALL LI" +
	"GATURE FFILATIN SMALL LIGATURE FFLLATIN SMALL LIGATURE LONG S TLATIN SMA" +
	"LL LIGATURE STARMENIAN SMALL LIGATURE MEN NOWARMENIAN SMALL LIGATURE MEN" +
	" ECHARMENIAN SMALL LIGATURE MEN INIARMENIAN SMALL LIGATURE VEW NOWARMENI" +
	"AN SMALL LIGATURE MEN XEHHEBREW LETTER YOD WITH HIRIQHEBREW POINT JUDEO-" +
	"SPANISH VARIKAHEBREW LIGATURE YIDDISH YOD YOD PATAHHEBREW LETTER ALTERNA" +
	"TIVE AYINHEBREW LETTER WIDE ALEFHEBREW LETTER WIDE DALETHEBREW LETTER WI" +
	"DE HEHEBREW LETTER WIDE KAFHEBREW LETTER WIDE LAMEDHEBREW LETTER WIDE FI" +
	"NAL MEMHEBREW LETTER WIDE RESHHEBREW LETTER WIDE TAVHEBREW LETTER ALTERN" +
	"ATIVE PLUS SIGNHEBREW LETTER SHIN WITH SHIN DOTHEBREW LETTER SHIN WITH S" +
	"IN DOTHEBREW LETTER SHIN WITH DAGESH AND SHIN DOTHEBREW LETTER SHIN WITH" +
	" DAGESH AND SIN DOTHEBREW LETTER ALEF WITH PATAHHEBREW LETTER ALEF WITH " +
	"QAMATSHEBREW LETTER ALEF WITH MAPIQHEBREW LETTER BET WITH DAGESHHEBREW L" +
	"ETTER GIMEL WITH DAGESHHEBREW LETTER DALET WITH DAGESHHEBREW LETTER HE W" +
	"ITH MAPIQHEBREW LETTER VAV WITH DAGESHHEBREW LETTER ZAYIN WITH DAGESHHEB" +
	"REW LETTER TET WITH DAGESHHEBREW LETTER YOD WITH DAGESHHEBREW LETTER FIN" +
	"AL KAF WITH DAGESHHEBREW LETTER KAF WITH DAGESHHEBREW LETTER LAMED WITH " +
	"DAGESHHEBREW LETTER MEM WITH DAGESHHEBREW LETTER NUN WITH DAGESHHEBREW L" +
	"ETTER SAMEKH WITH DAGESHHEBREW LETTER FINAL PE WITH DAGESHHEBREW LETTER " +
	"PE WITH DAGESHHEBREW LETTER TSADI WITH DAGESHHEBREW LETTER QOF WITH DAGE" +
	"SHHEBREW LETTER RESH WITH DAGESHHEBREW LETTER SHIN WITH DAGESHHEBREW LET" +
	"TER TAV WITH DAGESHHEBREW LETTER VAV WITH HOLAMHEBREW LETTER BET WITH RA" +
	"FEHEBREW LETTER KAF WITH RAFEHEBREW LETTER PE WITH RAFEHEBREW LIGATURE A" +
	"LEF LAMEDARABIC LETTER ALEF WASLA ISOLATED FORMARABIC LETTER ALEF WASLA " +
	"FINAL FORMARABIC LETTER BEEH ISOLATED FORMARABIC LETTER BEEH FINAL FORMA" +
	"RABIC LETTER BEEH INITIAL FORMARABIC LETTER BEEH MEDIAL FORMARABIC LETTE" +
	"R PEH ISOLATED FORMARABIC LETTER PEH FINAL FORMARABIC LETTER PEH INITIAL" +
	" FORMARABIC LETTER PEH MEDIAL FORMARABIC LETTER BEHEH ISOLATED FORMARABI" +
	"C LETTER BEHEH FINAL FORMARABIC LETTER BEHEH INITIAL FORMARABIC LETTER B" +
	"EHEH MEDIAL FORMARABIC LETTER TTEHEH ISOLATED FORMARABIC LETTER TTEHEH F" +
	"INAL FORMARABIC LETTER TTEHEH INITIAL FORMARABIC LETTER TTEHEH MEDIAL FO" +
	"RMARABIC LETTER TEHEH ISOLATED FORMARABIC LETTER TEHEH FINAL FORMARABIC " +
	"LETTER TEHEH INITIAL FORMARABIC LETTER TEHEH MEDIAL FORMARABIC LETTER TT" +
	"EH ISOLATED FORMARABIC LETTER TTEH FINAL FORMARABIC LETTER TTEH INITIAL " +
	"FORMARABIC LETTER TTEH MEDIAL FORMARABIC LETTER VEH ISOLATED FORMARABIC ") + ("" +
	"LETTER VEH FINAL FORMARABIC LETTER VEH INITIAL FORMARABIC LETTER VEH MED" +
	"IAL FORMARABIC LETTER PEHEH ISOLATED FORMARABIC LETTER PEHEH FINAL FORMA" +
	"RABIC LETTER PEHEH INITIAL FORMARABIC LETTER PEHEH MEDIAL FORMARABIC LET" +
	"TER DYEH ISOLATED FORMARABIC LETTER DYEH FINAL FORMARABIC LETTER DYEH IN" +
	"ITIAL FORMARABIC LETTER DYEH MEDIAL FORMARABIC LETTER NYEH ISOLATED FORM" +
	"ARABIC LETTER NYEH FINAL FORMARABIC LETTER NYEH INITIAL FORMARABIC LETTE" +
	"R NYEH MEDIAL FORMARABIC LETTER TCHEH ISOLATED FORMARABIC LETTER TCHEH F" +
	"INAL FORMARABIC LETTER TCHEH INITIAL FORMARABIC LETTER TCHEH MEDIAL FORM" +
	"ARABIC LETTER TCHEHEH ISOLATED FORMARABIC LETTER TCHEHEH FINAL FORMARABI" +
	"C LETTER TCHEHEH INITIAL FORMARABIC LETTER TCHEHEH MEDIAL FORMARABIC LET" +
	"TER DDAHAL ISOLATED FORMARABIC LETTER DDAHAL FINAL FORMARABIC LETTER DAH" +
	"AL ISOLATED FORMARABIC LETTER DAHAL FINAL FORMARABIC LETTER DUL ISOLATED" +
	" FORMARABIC LETTER DUL FINAL FORMARABIC LETTER DDAL ISOLATED FORMARABIC " +
	"LETTER DDAL FINAL FORMARABIC LETTER JEH ISOLATED FORMARABIC LETTER JEH F" +
	"INAL FORMARABIC LETTER RREH ISOLATED FORMARABIC LETTER RREH FINAL FORMAR" +
	"ABIC LETTER KEHEH ISOLATED FORMARABIC LETTER KEHEH FINAL FORMARABIC LETT" +
	"ER KEHEH INITIAL FORMARABIC LETTER KEHEH MEDIAL FORMARABIC LETTER GAF IS" +
	"OLATED FORMARABIC LETTER GAF FINAL FORMARABIC LETTER GAF INITIAL FORMARA" +
	"BIC LETTER GAF MEDIAL FORMARABIC LETTER GUEH ISOLATED FORMARABIC LETTER " +
	"GUEH FINAL FORMARABIC LETTER GUEH INITIAL FORMARABIC LETTER GUEH MEDIAL " +
	"FORMARABIC LETTER NGOEH ISOLATED FORMARABIC LETTER NGOEH FINAL FORMARABI" +
	"C LETTER NGOEH INITIAL FORMARABIC LETTER NGOEH MEDIAL FORMARABIC LETTER " +
	"NOON GHUNNA ISOLATED FORMARABIC LETTER NOON GHUNNA FINAL FORMARABIC LETT" +
	"ER RNOON ISOLATED FORMARABIC LETTER RNOON FINAL FORMARABIC LETTER RNOON " +
	"INITIAL FORMARABIC LETTER RNOON MEDIAL FORMARABIC LETTER HEH WITH YEH AB" +
	"OVE ISOLATED FORMARABIC LETTER HEH WITH YEH ABOVE FINAL FORMARABIC LETTE" +
	"R HEH GOAL ISOLATED FORMARABIC LETTER HEH GOAL FINAL FORMARABIC LETTER H" +
	"EH GOAL INITIAL FORMARABIC LETTER HEH GOAL MEDIAL FORMARABIC LETTER HEH " +
	"DOACHASHMEE ISOLATED FORMARABIC LETTER HEH DOACHASHMEE FINAL FORMARABIC " +
	"LETTER HEH DOACHASHMEE INITIAL FORMARABIC LETTER HEH DOACHASHMEE MEDIAL " +
	"FORMARABIC LETTER YEH BARREE ISOLATED FORMARABIC LETTER YEH BARREE FINAL" +
	" FORMARABIC LETTER YEH BARREE WITH HAMZA ABOVE ISOLATED FORMARABIC LETTE" +
	"R YEH BARREE WITH HAMZA ABOVE FINAL FORMARABIC SYMBOL DOT ABOVEARABIC SY" +
	"MBOL DOT BELOWARABIC SYMBOL TWO DOTS ABOVEARABIC SYMBOL TWO DOTS BELOWAR" +
	"ABIC SYMBOL THREE DOTS ABOVEARABIC SYMBOL THREE DOTS BELOWARABIC SYMBOL " +
	"THREE DOTS POINTING DOWNWARDS ABOVEARABIC SYMBOL THREE DOTS POINTING DOW" +
	"NWARDS BELOWARABIC SYMBOL FOUR DOTS ABOVEARABIC SYMBOL FOUR DOTS BELOWAR" +
	"ABIC SYMBOL DOUBLE VERTICAL BAR BELOWARABIC SYMBOL TWO DOTS VERTICALLY A" +
	"BOVEARABIC SYMBOL TWO DOTS VERTICALLY BELOWARABIC SYMBOL RINGARABIC SYMB" +
	"OL SMALL TAH ABOVEARABIC SYMBOL SMALL TAH BELOWARABIC LETTER NG ISOLATED" +
	" FORMARABIC LETTER NG FINAL FORMARABIC LETTER NG INITIAL FORMARABIC LETT" +
	"ER NG MEDIAL FORMARABIC LETTER U ISOLATED FORMARABIC LETTER U FINAL FORM" +
	"ARABIC LETTER OE ISOLATED FORMARABIC LETTER OE FINAL FORMARABIC LETTER Y" +
	"U ISOLATED FORMARABIC LETTER YU FINAL FORMARABIC LETTER U WITH HAMZA ABO" +
	"VE ISOLATED FORMARABIC LETTER VE ISOLATED FORMARABIC LETTER VE FINAL FOR" +
	"MARABIC LETTER KIRGHIZ OE ISOLATED FORMARABIC LETTER KIRGHIZ OE FINAL FO" +
	"RMARABIC LETTER KIRGHIZ YU ISOLATED FORMARABIC LETTER KIRGHIZ YU FINAL F" +
	"ORMARABIC LETTER E ISOLATED FORMARABIC LETTER E FINAL FORMARABIC LETTER " +
	"E INITIAL FORMARABIC LETTER E MEDIAL FORMARABIC LETTER UIGHUR KAZAKH KIR" +
	"GHIZ ALEF MAKSURA INITIAL FORMARABIC LETTER UIGHUR KAZAKH KIRGHIZ ALEF M" +
	"AKSURA MEDIAL FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ALEF ISOLATE" +
	"D FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ALEF FINAL FORMARABIC LI" +
	"GATURE YEH WITH HAMZA ABOVE WITH AE ISOLATED FORMARABIC LIGATURE YEH WIT" +
	"H HAMZA ABOVE WITH AE FINAL FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WIT" +
	"H WAW ISOLATED FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH WAW FINAL F" +
	"ORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH U ISOLATED FORMARABIC LIGAT" +
	"URE YEH WITH HAMZA ABOVE WITH U FINAL FORMARABIC LIGATURE YEH WITH HAMZA" +
	" ABOVE WITH OE ISOLATED FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH OE" +
	" FINAL FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH YU ISOLATED FORMARA" +
	"BIC LIGATURE YEH WITH HAMZA ABOVE WITH YU FINAL FORMARABIC LIGATURE YEH " +
	"WITH HAMZA ABOVE WITH E ISOLATED FORMARABIC LIGATURE YEH WITH HAMZA ABOV" +
	"E WITH E FINAL FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH E INITIAL F" +
	"ORMARABIC LIGATURE UIGHUR KIRGHIZ YEH WITH HAMZA ABOVE WITH ALEF MAKSURA" +
	" ISOLATED FORMARABIC LIGATURE UIGHUR KIRGHIZ YEH WITH HAMZA ABOVE WITH A") + ("" +
	"LEF MAKSURA FINAL FORMARABIC LIGATURE UIGHUR KIRGHIZ YEH WITH HAMZA ABOV" +
	"E WITH ALEF MAKSURA INITIAL FORMARABIC LETTER FARSI YEH ISOLATED FORMARA" +
	"BIC LETTER FARSI YEH FINAL FORMARABIC LETTER FARSI YEH INITIAL FORMARABI" +
	"C LETTER FARSI YEH MEDIAL FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH " +
	"JEEM ISOLATED FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH HAH ISOLATED" +
	" FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH MEEM ISOLATED FORMARABIC " +
	"LIGATURE YEH WITH HAMZA ABOVE WITH ALEF MAKSURA ISOLATED FORMARABIC LIGA" +
	"TURE YEH WITH HAMZA ABOVE WITH YEH ISOLATED FORMARABIC LIGATURE BEH WITH" +
	" JEEM ISOLATED FORMARABIC LIGATURE BEH WITH HAH ISOLATED FORMARABIC LIGA" +
	"TURE BEH WITH KHAH ISOLATED FORMARABIC LIGATURE BEH WITH MEEM ISOLATED F" +
	"ORMARABIC LIGATURE BEH WITH ALEF MAKSURA ISOLATED FORMARABIC LIGATURE BE" +
	"H WITH YEH ISOLATED FORMARABIC LIGATURE TEH WITH JEEM ISOLATED FORMARABI" +
	"C LIGATURE TEH WITH HAH ISOLATED FORMARABIC LIGATURE TEH WITH KHAH ISOLA" +
	"TED FORMARABIC LIGATURE TEH WITH MEEM ISOLATED FORMARABIC LIGATURE TEH W" +
	"ITH ALEF MAKSURA ISOLATED FORMARABIC LIGATURE TEH WITH YEH ISOLATED FORM" +
	"ARABIC LIGATURE THEH WITH JEEM ISOLATED FORMARABIC LIGATURE THEH WITH ME" +
	"EM ISOLATED FORMARABIC LIGATURE THEH WITH ALEF MAKSURA ISOLATED FORMARAB" +
	"IC LIGATURE THEH WITH YEH ISOLATED FORMARABIC LIGATURE JEEM WITH HAH ISO" +
	"LATED FORMARABIC LIGATURE JEEM WITH MEEM ISOLATED FORMARABIC LIGATURE HA" +
	"H WITH JEEM ISOLATED FORMARABIC LIGATURE HAH WITH MEEM ISOLATED FORMARAB" +
	"IC LIGATURE KHAH WITH JEEM ISOLATED FORMARABIC LIGATURE KHAH WITH HAH IS" +
	"OLATED FORMARABIC LIGATURE KHAH WITH MEEM ISOLATED FORMARABIC LIGATURE S" +
	"EEN WITH JEEM ISOLATED FORMARABIC LIGATURE SEEN WITH HAH ISOLATED FORMAR" +
	"ABIC LIGATURE SEEN WITH KHAH ISOLATED FORMARABIC LIGATURE SEEN WITH MEEM" +
	" ISOLATED FORMARABIC LIGATURE SAD WITH HAH ISOLATED FORMARABIC LIGATURE " +
	"SAD WITH MEEM ISOLATED FORMARABIC LIGATURE DAD WITH JEEM ISOLATED FORMAR" +
	"ABIC LIGATURE DAD WITH HAH ISOLATED FORMARABIC LIGATURE DAD WITH KHAH IS" +
	"OLATED FORMARABIC LIGATURE DAD WITH MEEM ISOLATED FORMARABIC LIGATURE TA" +
	"H WITH HAH ISOLATED FORMARABIC LIGATURE TAH WITH MEEM ISOLATED FORMARABI" +
	"C LIGATURE ZAH WITH MEEM ISOLATED FORMARABIC LIGATURE AIN WITH JEEM ISOL" +
	"ATED FORMARABIC LIGATURE AIN WITH MEEM ISOLATED FORMARABIC LIGATURE GHAI" +
	"N WITH JEEM ISOLATED FORMARABIC LIGATURE GHAIN WITH MEEM ISOLATED FORMAR" +
	"ABIC LIGATURE FEH WITH JEEM ISOLATED FORMARABIC LIGATURE FEH WITH HAH IS" +
	"OLATED FORMARABIC LIGATURE FEH WITH KHAH ISOLATED FORMARABIC LIGATURE FE" +
	"H WITH MEEM ISOLATED FORMARABIC LIGATURE FEH WITH ALEF MAKSURA ISOLATED " +
	"FORMARABIC LIGATURE FEH WITH YEH ISOLATED FORMARABIC LIGATURE QAF WITH H" +
	"AH ISOLATED FORMARABIC LIGATURE QAF WITH MEEM ISOLATED FORMARABIC LIGATU" +
	"RE QAF WITH ALEF MAKSURA ISOLATED FORMARABIC LIGATURE QAF WITH YEH ISOLA" +
	"TED FORMARABIC LIGATURE KAF WITH ALEF ISOLATED FORMARABIC LIGATURE KAF W" +
	"ITH JEEM ISOLATED FORMARABIC LIGATURE KAF WITH HAH ISOLATED FORMARABIC L" +
	"IGATURE KAF WITH KHAH ISOLATED FORMARABIC LIGATURE KAF WITH LAM ISOLATED" +
	" FORMARABIC LIGATURE KAF WITH MEEM ISOLATED FORMARABIC LIGATURE KAF WITH" +
	" ALEF MAKSURA ISOLATED FORMARABIC LIGATURE KAF WITH YEH ISOLATED FORMARA" +
	"BIC LIGATURE LAM WITH JEEM ISOLATED FORMARABIC LIGATURE LAM WITH HAH ISO" +
	"LATED FORMARABIC LIGATURE LAM WITH KHAH ISOLATED FORMARABIC LIGATURE LAM" +
	" WITH MEEM ISOLATED FORMARABIC LIGATURE LAM WITH ALEF MAKSURA ISOLATED F" +
	"ORMARABIC LIGATURE LAM WITH YEH ISOLATED FORMARABIC LIGATURE MEEM WITH J" +
	"EEM ISOLATED FORMARABIC LIGATURE MEEM WITH HAH ISOLATED FORMARABIC LIGAT" +
	"URE MEEM WITH KHAH ISOLATED FORMARABIC LIGATURE MEEM WITH MEEM ISOLATED " +
	"FORMARABIC LIGATURE MEEM WITH ALEF MAKSURA ISOLATED FORMARABIC LIGATURE " +
	"MEEM WITH YEH ISOLATED FORMARABIC LIGATURE NOON WITH JEEM ISOLATED FORMA" +
	"RABIC LIGATURE NOON WITH HAH ISOLATED FORMARABIC LIGATURE NOON WITH KHAH" +
	" ISOLATED FORMARABIC LIGATURE NOON WITH MEEM ISOLATED FORMARABIC LIGATUR" +
	"E NOON WITH ALEF MAKSURA ISOLATED FORMARABIC LIGATURE NOON WITH YEH ISOL" +
	"ATED FORMARABIC LIGATURE HEH WITH JEEM ISOLATED FORMARABIC LIGATURE HEH " +
	"WITH MEEM ISOLATED FORMARABIC LIGATURE HEH WITH ALEF MAKSURA ISOLATED FO" +
	"RMARABIC LIGATURE HEH WITH YEH ISOLATED FORMARABIC LIGATURE YEH WITH JEE" +
	"M ISOLATED FORMARABIC LIGATURE YEH WITH HAH ISOLATED FORMARABIC LIGATURE" +
	" YEH WITH KHAH ISOLATED FORMARABIC LIGATURE YEH WITH MEEM ISOLATED FORMA" +
	"RABIC LIGATURE YEH WITH ALEF MAKSURA ISOLATED FORMARABIC LIGATURE YEH WI" +
	"TH YEH ISOLATED FORMARABIC LIGATURE THAL WITH SUPERSCRIPT ALEF ISOLATED " +
	"FORMARABIC LIGATURE REH WITH SUPERSCRIPT ALEF ISOLATED FORMARABIC LIGATU" +
	"RE ALEF MAKSURA WITH SUPERSCRIPT ALEF ISOLATED FORMARABIC LIGATURE SHADD" +
	"A WITH DAMMATAN ISOLATED FORMARABIC LIGATURE SHADDA WITH KASRATAN ISOLAT") + ("" +
	"ED FORMARABIC LIGATURE SHADDA WITH FATHA ISOLATED FORMARABIC LIGATURE SH" +
	"ADDA WITH DAMMA ISOLATED FORMARABIC LIGATURE SHADDA WITH KASRA ISOLATED " +
	"FORMARABIC LIGATURE SHADDA WITH SUPERSCRIPT ALEF ISOLATED FORMARABIC LIG" +
	"ATURE YEH WITH HAMZA ABOVE WITH REH FINAL FORMARABIC LIGATURE YEH WITH H" +
	"AMZA ABOVE WITH ZAIN FINAL FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH" +
	" MEEM FINAL FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH NOON FINAL FOR" +
	"MARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ALEF MAKSURA FINAL FORMARABIC" +
	" LIGATURE YEH WITH HAMZA ABOVE WITH YEH FINAL FORMARABIC LIGATURE BEH WI" +
	"TH REH FINAL FORMARABIC LIGATURE BEH WITH ZAIN FINAL FORMARABIC LIGATURE" +
	" BEH WITH MEEM FINAL FORMARABIC LIGATURE BEH WITH NOON FINAL FORMARABIC " +
	"LIGATURE BEH WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE BEH WITH YEH FI" +
	"NAL FORMARABIC LIGATURE TEH WITH REH FINAL FORMARABIC LIGATURE TEH WITH " +
	"ZAIN FINAL FORMARABIC LIGATURE TEH WITH MEEM FINAL FORMARABIC LIGATURE T" +
	"EH WITH NOON FINAL FORMARABIC LIGATURE TEH WITH ALEF MAKSURA FINAL FORMA" +
	"RABIC LIGATURE TEH WITH YEH FINAL FORMARABIC LIGATURE THEH WITH REH FINA" +
	"L FORMARABIC LIGATURE THEH WITH ZAIN FINAL FORMARABIC LIGATURE THEH WITH" +
	" MEEM FINAL FORMARABIC LIGATURE THEH WITH NOON FINAL FORMARABIC LIGATURE" +
	" THEH WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE THEH WITH YEH FINAL FO" +
	"RMARABIC LIGATURE FEH WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE FEH WI" +
	"TH YEH FINAL FORMARABIC LIGATURE QAF WITH ALEF MAKSURA FINAL FORMARABIC " +
	"LIGATURE QAF WITH YEH FINAL FORMARABIC LIGATURE KAF WITH ALEF FINAL FORM" +
	"ARABIC LIGATURE KAF WITH LAM FINAL FORMARABIC LIGATURE KAF WITH MEEM FIN" +
	"AL FORMARABIC LIGATURE KAF WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE K" +
	"AF WITH YEH FINAL FORMARABIC LIGATURE LAM WITH MEEM FINAL FORMARABIC LIG" +
	"ATURE LAM WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE LAM WITH YEH FINAL" +
	" FORMARABIC LIGATURE MEEM WITH ALEF FINAL FORMARABIC LIGATURE MEEM WITH " +
	"MEEM FINAL FORMARABIC LIGATURE NOON WITH REH FINAL FORMARABIC LIGATURE N" +
	"OON WITH ZAIN FINAL FORMARABIC LIGATURE NOON WITH MEEM FINAL FORMARABIC " +
	"LIGATURE NOON WITH NOON FINAL FORMARABIC LIGATURE NOON WITH ALEF MAKSURA" +
	" FINAL FORMARABIC LIGATURE NOON WITH YEH FINAL FORMARABIC LIGATURE ALEF " +
	"MAKSURA WITH SUPERSCRIPT ALEF FINAL FORMARABIC LIGATURE YEH WITH REH FIN" +
	"AL FORMARABIC LIGATURE YEH WITH ZAIN FINAL FORMARABIC LIGATURE YEH WITH " +
	"MEEM FINAL FORMARABIC LIGATURE YEH WITH NOON FINAL FORMARABIC LIGATURE Y" +
	"EH WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE YEH WITH YEH FINAL FORMAR" +
	"ABIC LIGATURE YEH WITH HAMZA ABOVE WITH JEEM INITIAL FORMARABIC LIGATURE" +
	" YEH WITH HAMZA ABOVE WITH HAH INITIAL FORMARABIC LIGATURE YEH WITH HAMZ" +
	"A ABOVE WITH KHAH INITIAL FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH " +
	"MEEM INITIAL FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH HEH INITIAL F" +
	"ORMARABIC LIGATURE BEH WITH JEEM INITIAL FORMARABIC LIGATURE BEH WITH HA" +
	"H INITIAL FORMARABIC LIGATURE BEH WITH KHAH INITIAL FORMARABIC LIGATURE " +
	"BEH WITH MEEM INITIAL FORMARABIC LIGATURE BEH WITH HEH INITIAL FORMARABI" +
	"C LIGATURE TEH WITH JEEM INITIAL FORMARABIC LIGATURE TEH WITH HAH INITIA" +
	"L FORMARABIC LIGATURE TEH WITH KHAH INITIAL FORMARABIC LIGATURE TEH WITH" +
	" MEEM INITIAL FORMARABIC LIGATURE TEH WITH HEH INITIAL FORMARABIC LIGATU" +
	"RE THEH WITH MEEM INITIAL FORMARABIC LIGATURE JEEM WITH HAH INITIAL FORM" +
	"ARABIC LIGATURE JEEM WITH MEEM INITIAL FORMARABIC LIGATURE HAH WITH JEEM" +
	" INITIAL FORMARABIC LIGATURE HAH WITH MEEM INITIAL FORMARABIC LIGATURE K" +
	"HAH WITH JEEM INITIAL FORMARABIC LIGATURE KHAH WITH MEEM INITIAL FORMARA" +
	"BIC LIGATURE SEEN WITH JEEM INITIAL FORMARABIC LIGATURE SEEN WITH HAH IN" +
	"ITIAL FORMARABIC LIGATURE SEEN WITH KHAH INITIAL FORMARABIC LIGATURE SEE" +
	"N WITH MEEM INITIAL FORMARABIC LIGATURE SAD WITH HAH INITIAL FORMARABIC " +
	"LIGATURE SAD WITH KHAH INITIAL FORMARABIC LIGATURE SAD WITH MEEM INITIAL" +
	" FORMARABIC LIGATURE DAD WITH JEEM INITIAL FORMARABIC LIGATURE DAD WITH " +
	"HAH INITIAL FORMARABIC LIGATURE DAD WITH KHAH INITIAL FORMARABIC LIGATUR" +
	"E DAD WITH MEEM INITIAL FORMARABIC LIGATURE TAH WITH HAH INITIAL FORMARA" +
	"BIC LIGATURE ZAH WITH MEEM INITIAL FORMARABIC LIGATURE AIN WITH JEEM INI" +
	"TIAL FORMARABIC LIGATURE AIN WITH MEEM INITIAL FORMARABIC LIGATURE GHAIN" +
	" WITH JEEM INITIAL FORMARABIC LIGATURE GHAIN WITH MEEM INITIAL FORMARABI" +
	"C LIGATURE FEH WITH JEEM INITIAL FORMARABIC LIGATURE FEH WITH HAH INITIA" +
	"L FORMARABIC LIGATURE FEH WITH KHAH INITIAL FORMARABIC LIGATURE FEH WITH" +
	" MEEM INITIAL FORMARABIC LIGATURE QAF WITH HAH INITIAL FORMARABIC LIGATU" +
	"RE QAF WITH MEEM INITIAL FORMARABIC LIGATURE KAF WITH JEEM INITIAL FORMA" +
	"RABIC LIGATURE KAF WITH HAH INITIAL FORMARABIC LIGATURE KAF WITH KHAH IN" +
	"ITIAL FORMARABIC LIGATURE KAF WITH LAM INITIAL FORMARABIC LIGATURE KAF W") + ("" +
	"ITH MEEM INITIAL FORMARABIC LIGATURE LAM WITH JEEM INITIAL FORMARABIC LI" +
	"GATURE LAM WITH HAH INITIAL FORMARABIC LIGATURE LAM WITH KHAH INITIAL FO" +
	"RMARABIC LIGATURE LAM WITH MEEM INITIAL FORMARABIC LIGATURE LAM WITH HEH" +
	" INITIAL FORMARABIC LIGATURE MEEM WITH JEEM INITIAL FORMARABIC LIGATURE " +
	"MEEM WITH HAH INITIAL FORMARABIC LIGATURE MEEM WITH KHAH INITIAL FORMARA" +
	"BIC LIGATURE MEEM WITH MEEM INITIAL FORMARABIC LIGATURE NOON WITH JEEM I" +
	"NITIAL FORMARABIC LIGATURE NOON WITH HAH INITIAL FORMARABIC LIGATURE NOO" +
	"N WITH KHAH INITIAL FORMARABIC LIGATURE NOON WITH MEEM INITIAL FORMARABI" +
	"C LIGATURE NOON WITH HEH INITIAL FORMARABIC LIGATURE HEH WITH JEEM INITI" +
	"AL FORMARABIC LIGATURE HEH WITH MEEM INITIAL FORMARABIC LIGATURE HEH WIT" +
	"H SUPERSCRIPT ALEF INITIAL FORMARABIC LIGATURE YEH WITH JEEM INITIAL FOR" +
	"MARABIC LIGATURE YEH WITH HAH INITIAL FORMARABIC LIGATURE YEH WITH KHAH " +
	"INITIAL FORMARABIC LIGATURE YEH WITH MEEM INITIAL FORMARABIC LIGATURE YE" +
	"H WITH HEH INITIAL FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH MEEM ME" +
	"DIAL FORMARABIC LIGATURE YEH WITH HAMZA ABOVE WITH HEH MEDIAL FORMARABIC" +
	" LIGATURE BEH WITH MEEM MEDIAL FORMARABIC LIGATURE BEH WITH HEH MEDIAL F" +
	"ORMARABIC LIGATURE TEH WITH MEEM MEDIAL FORMARABIC LIGATURE TEH WITH HEH" +
	" MEDIAL FORMARABIC LIGATURE THEH WITH MEEM MEDIAL FORMARABIC LIGATURE TH" +
	"EH WITH HEH MEDIAL FORMARABIC LIGATURE SEEN WITH MEEM MEDIAL FORMARABIC " +
	"LIGATURE SEEN WITH HEH MEDIAL FORMARABIC LIGATURE SHEEN WITH MEEM MEDIAL" +
	" FORMARABIC LIGATURE SHEEN WITH HEH MEDIAL FORMARABIC LIGATURE KAF WITH " +
	"LAM MEDIAL FORMARABIC LIGATURE KAF WITH MEEM MEDIAL FORMARABIC LIGATURE " +
	"LAM WITH MEEM MEDIAL FORMARABIC LIGATURE NOON WITH MEEM MEDIAL FORMARABI" +
	"C LIGATURE NOON WITH HEH MEDIAL FORMARABIC LIGATURE YEH WITH MEEM MEDIAL" +
	" FORMARABIC LIGATURE YEH WITH HEH MEDIAL FORMARABIC LIGATURE SHADDA WITH" +
	" FATHA MEDIAL FORMARABIC LIGATURE SHADDA WITH DAMMA MEDIAL FORMARABIC LI" +
	"GATURE SHADDA WITH KASRA MEDIAL FORMARABIC LIGATURE TAH WITH ALEF MAKSUR" +
	"A ISOLATED FORMARABIC LIGATURE TAH WITH YEH ISOLATED FORMARABIC LIGATURE" +
	" AIN WITH ALEF MAKSURA ISOLATED FORMARABIC LIGATURE AIN WITH YEH ISOLATE" +
	"D FORMARABIC LIGATURE GHAIN WITH ALEF MAKSURA ISOLATED FORMARABIC LIGATU" +
	"RE GHAIN WITH YEH ISOLATED FORMARABIC LIGATURE SEEN WITH ALEF MAKSURA IS" +
	"OLATED FORMARABIC LIGATURE SEEN WITH YEH ISOLATED FORMARABIC LIGATURE SH" +
	"EEN WITH ALEF MAKSURA ISOLATED FORMARABIC LIGATURE SHEEN WITH YEH ISOLAT" +
	"ED FORMARABIC LIGATURE HAH WITH ALEF MAKSURA ISOLATED FORMARABIC LIGATUR" +
	"E HAH WITH YEH ISOLATED FORMARABIC LIGATURE JEEM WITH ALEF MAKSURA ISOLA" +
	"TED FORMARABIC LIGATURE JEEM WITH YEH ISOLATED FORMARABIC LIGATURE KHAH " +
	"WITH ALEF MAKSURA ISOLATED FORMARABIC LIGATURE KHAH WITH YEH ISOLATED FO" +
	"RMARABIC LIGATURE SAD WITH ALEF MAKSURA ISOLATED FORMARABIC LIGATURE SAD" +
	" WITH YEH ISOLATED FORMARABIC LIGATURE DAD WITH ALEF MAKSURA ISOLATED FO" +
	"RMARABIC LIGATURE DAD WITH YEH ISOLATED FORMARABIC LIGATURE SHEEN WITH J" +
	"EEM ISOLATED FORMARABIC LIGATURE SHEEN WITH HAH ISOLATED FORMARABIC LIGA" +
	"TURE SHEEN WITH KHAH ISOLATED FORMARABIC LIGATURE SHEEN WITH MEEM ISOLAT" +
	"ED FORMARABIC LIGATURE SHEEN WITH REH ISOLATED FORMARABIC LIGATURE SEEN " +
	"WITH REH ISOLATED FORMARABIC LIGATURE SAD WITH REH ISOLATED FORMARABIC L" +
	"IGATURE DAD WITH REH ISOLATED FORMARABIC LIGATURE TAH WITH ALEF MAKSURA " +
	"FINAL FORMARABIC LIGATURE TAH WITH YEH FINAL FORMARABIC LIGATURE AIN WIT" +
	"H ALEF MAKSURA FINAL FORMARABIC LIGATURE AIN WITH YEH FINAL FORMARABIC L" +
	"IGATURE GHAIN WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE GHAIN WITH YEH" +
	" FINAL FORMARABIC LIGATURE SEEN WITH ALEF MAKSURA FINAL FORMARABIC LIGAT" +
	"URE SEEN WITH YEH FINAL FORMARABIC LIGATURE SHEEN WITH ALEF MAKSURA FINA" +
	"L FORMARABIC LIGATURE SHEEN WITH YEH FINAL FORMARABIC LIGATURE HAH WITH " +
	"ALEF MAKSURA FINAL FORMARABIC LIGATURE HAH WITH YEH FINAL FORMARABIC LIG" +
	"ATURE JEEM WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE JEEM WITH YEH FIN" +
	"AL FORMARABIC LIGATURE KHAH WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE " +
	"KHAH WITH YEH FINAL FORMARABIC LIGATURE SAD WITH ALEF MAKSURA FINAL FORM" +
	"ARABIC LIGATURE SAD WITH YEH FINAL FORMARABIC LIGATURE DAD WITH ALEF MAK" +
	"SURA FINAL FORMARABIC LIGATURE DAD WITH YEH FINAL FORMARABIC LIGATURE SH" +
	"EEN WITH JEEM FINAL FORMARABIC LIGATURE SHEEN WITH HAH FINAL FORMARABIC " +
	"LIGATURE SHEEN WITH KHAH FINAL FORMARABIC LIGATURE SHEEN WITH MEEM FINAL" +
	" FORMARABIC LIGATURE SHEEN WITH REH FINAL FORMARABIC LIGATURE SEEN WITH " +
	"REH FINAL FORMARABIC LIGATURE SAD WITH REH FINAL FORMARABIC LIGATURE DAD" +
	" WITH REH FINAL FORMARABIC LIGATURE SHEEN WITH JEEM INITIAL FORMARABIC L" +
	"IGATURE SHEEN WITH HAH INITIAL FORMARABIC LIGATURE SHEEN WITH KHAH INITI" +
	"AL FORMARABIC LIGATURE SHEEN WITH MEEM INITIAL FORMARABIC LIGATURE SEEN ") + ("" +
	"WITH HEH INITIAL FORMARABIC LIGATURE SHEEN WITH HEH INITIAL FORMARABIC L" +
	"IGATURE TAH WITH MEEM INITIAL FORMARABIC LIGATURE SEEN WITH JEEM MEDIAL " +
	"FORMARABIC LIGATURE SEEN WITH HAH MEDIAL FORMARABIC LIGATURE SEEN WITH K" +
	"HAH MEDIAL FORMARABIC LIGATURE SHEEN WITH JEEM MEDIAL FORMARABIC LIGATUR" +
	"E SHEEN WITH HAH MEDIAL FORMARABIC LIGATURE SHEEN WITH KHAH MEDIAL FORMA" +
	"RABIC LIGATURE TAH WITH MEEM MEDIAL FORMARABIC LIGATURE ZAH WITH MEEM ME" +
	"DIAL FORMARABIC LIGATURE ALEF WITH FATHATAN FINAL FORMARABIC LIGATURE AL" +
	"EF WITH FATHATAN ISOLATED FORMORNATE LEFT PARENTHESISORNATE RIGHT PARENT" +
	"HESISARABIC LIGATURE TEH WITH JEEM WITH MEEM INITIAL FORMARABIC LIGATURE" +
	" TEH WITH HAH WITH JEEM FINAL FORMARABIC LIGATURE TEH WITH HAH WITH JEEM" +
	" INITIAL FORMARABIC LIGATURE TEH WITH HAH WITH MEEM INITIAL FORMARABIC L" +
	"IGATURE TEH WITH KHAH WITH MEEM INITIAL FORMARABIC LIGATURE TEH WITH MEE" +
	"M WITH JEEM INITIAL FORMARABIC LIGATURE TEH WITH MEEM WITH HAH INITIAL F" +
	"ORMARABIC LIGATURE TEH WITH MEEM WITH KHAH INITIAL FORMARABIC LIGATURE J" +
	"EEM WITH MEEM WITH HAH FINAL FORMARABIC LIGATURE JEEM WITH MEEM WITH HAH" +
	" INITIAL FORMARABIC LIGATURE HAH WITH MEEM WITH YEH FINAL FORMARABIC LIG" +
	"ATURE HAH WITH MEEM WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE SEEN WIT" +
	"H HAH WITH JEEM INITIAL FORMARABIC LIGATURE SEEN WITH JEEM WITH HAH INIT" +
	"IAL FORMARABIC LIGATURE SEEN WITH JEEM WITH ALEF MAKSURA FINAL FORMARABI" +
	"C LIGATURE SEEN WITH MEEM WITH HAH FINAL FORMARABIC LIGATURE SEEN WITH M" +
	"EEM WITH HAH INITIAL FORMARABIC LIGATURE SEEN WITH MEEM WITH JEEM INITIA" +
	"L FORMARABIC LIGATURE SEEN WITH MEEM WITH MEEM FINAL FORMARABIC LIGATURE" +
	" SEEN WITH MEEM WITH MEEM INITIAL FORMARABIC LIGATURE SAD WITH HAH WITH " +
	"HAH FINAL FORMARABIC LIGATURE SAD WITH HAH WITH HAH INITIAL FORMARABIC L" +
	"IGATURE SAD WITH MEEM WITH MEEM FINAL FORMARABIC LIGATURE SHEEN WITH HAH" +
	" WITH MEEM FINAL FORMARABIC LIGATURE SHEEN WITH HAH WITH MEEM INITIAL FO" +
	"RMARABIC LIGATURE SHEEN WITH JEEM WITH YEH FINAL FORMARABIC LIGATURE SHE" +
	"EN WITH MEEM WITH KHAH FINAL FORMARABIC LIGATURE SHEEN WITH MEEM WITH KH" +
	"AH INITIAL FORMARABIC LIGATURE SHEEN WITH MEEM WITH MEEM FINAL FORMARABI" +
	"C LIGATURE SHEEN WITH MEEM WITH MEEM INITIAL FORMARABIC LIGATURE DAD WIT" +
	"H HAH WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE DAD WITH KHAH WITH MEE" +
	"M FINAL FORMARABIC LIGATURE DAD WITH KHAH WITH MEEM INITIAL FORMARABIC L" +
	"IGATURE TAH WITH MEEM WITH HAH FINAL FORMARABIC LIGATURE TAH WITH MEEM W" +
	"ITH HAH INITIAL FORMARABIC LIGATURE TAH WITH MEEM WITH MEEM INITIAL FORM" +
	"ARABIC LIGATURE TAH WITH MEEM WITH YEH FINAL FORMARABIC LIGATURE AIN WIT" +
	"H JEEM WITH MEEM FINAL FORMARABIC LIGATURE AIN WITH MEEM WITH MEEM FINAL" +
	" FORMARABIC LIGATURE AIN WITH MEEM WITH MEEM INITIAL FORMARABIC LIGATURE" +
	" AIN WITH MEEM WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE GHAIN WITH ME" +
	"EM WITH MEEM FINAL FORMARABIC LIGATURE GHAIN WITH MEEM WITH YEH FINAL FO" +
	"RMARABIC LIGATURE GHAIN WITH MEEM WITH ALEF MAKSURA FINAL FORMARABIC LIG" +
	"ATURE FEH WITH KHAH WITH MEEM FINAL FORMARABIC LIGATURE FEH WITH KHAH WI" +
	"TH MEEM INITIAL FORMARABIC LIGATURE QAF WITH MEEM WITH HAH FINAL FORMARA" +
	"BIC LIGATURE QAF WITH MEEM WITH MEEM FINAL FORMARABIC LIGATURE LAM WITH " +
	"HAH WITH MEEM FINAL FORMARABIC LIGATURE LAM WITH HAH WITH YEH FINAL FORM" +
	"ARABIC LIGATURE LAM WITH HAH WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE" +
	" LAM WITH JEEM WITH JEEM INITIAL FORMARABIC LIGATURE LAM WITH JEEM WITH " +
	"JEEM FINAL FORMARABIC LIGATURE LAM WITH KHAH WITH MEEM FINAL FORMARABIC " +
	"LIGATURE LAM WITH KHAH WITH MEEM INITIAL FORMARABIC LIGATURE LAM WITH ME" +
	"EM WITH HAH FINAL FORMARABIC LIGATURE LAM WITH MEEM WITH HAH INITIAL FOR" +
	"MARABIC LIGATURE MEEM WITH HAH WITH JEEM INITIAL FORMARABIC LIGATURE MEE" +
	"M WITH HAH WITH MEEM INITIAL FORMARABIC LIGATURE MEEM WITH HAH WITH YEH " +
	"FINAL FORMARABIC LIGATURE MEEM WITH JEEM WITH HAH INITIAL FORMARABIC LIG" +
	"ATURE MEEM WITH JEEM WITH MEEM INITIAL FORMARABIC LIGATURE MEEM WITH KHA" +
	"H WITH JEEM INITIAL FORMARABIC LIGATURE MEEM WITH KHAH WITH MEEM INITIAL" +
	" FORMARABIC LIGATURE MEEM WITH JEEM WITH KHAH INITIAL FORMARABIC LIGATUR" +
	"E HEH WITH MEEM WITH JEEM INITIAL FORMARABIC LIGATURE HEH WITH MEEM WITH" +
	" MEEM INITIAL FORMARABIC LIGATURE NOON WITH HAH WITH MEEM INITIAL FORMAR" +
	"ABIC LIGATURE NOON WITH HAH WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE " +
	"NOON WITH JEEM WITH MEEM FINAL FORMARABIC LIGATURE NOON WITH JEEM WITH M" +
	"EEM INITIAL FORMARABIC LIGATURE NOON WITH JEEM WITH ALEF MAKSURA FINAL F" +
	"ORMARABIC LIGATURE NOON WITH MEEM WITH YEH FINAL FORMARABIC LIGATURE NOO" +
	"N WITH MEEM WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE YEH WITH MEEM WI" +
	"TH MEEM FINAL FORMARABIC LIGATURE YEH WITH MEEM WITH MEEM INITIAL FORMAR" +
	"ABIC LIGATURE BEH WITH KHAH WITH YEH FINAL FORMARABIC LIGATURE TEH WITH ") + ("" +
	"JEEM WITH YEH FINAL FORMARABIC LIGATURE TEH WITH JEEM WITH ALEF MAKSURA " +
	"FINAL FORMARABIC LIGATURE TEH WITH KHAH WITH YEH FINAL FORMARABIC LIGATU" +
	"RE TEH WITH KHAH WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE TEH WITH ME" +
	"EM WITH YEH FINAL FORMARABIC LIGATURE TEH WITH MEEM WITH ALEF MAKSURA FI" +
	"NAL FORMARABIC LIGATURE JEEM WITH MEEM WITH YEH FINAL FORMARABIC LIGATUR" +
	"E JEEM WITH HAH WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE JEEM WITH ME" +
	"EM WITH ALEF MAKSURA FINAL FORMARABIC LIGATURE SEEN WITH KHAH WITH ALEF " +
	"MAKSURA FINAL FORMARABIC LIGATURE SAD WITH HAH WITH YEH FINAL FORMARABIC" +
	" LIGATURE SHEEN WITH HAH WITH YEH FINAL FORMARABIC LIGATURE DAD WITH HAH" +
	" WITH YEH FINAL FORMARABIC LIGATURE LAM WITH JEEM WITH YEH FINAL FORMARA" +
	"BIC LIGATURE LAM WITH MEEM WITH YEH FINAL FORMARABIC LIGATURE YEH WITH H" +
	"AH WITH YEH FINAL FORMARABIC LIGATURE YEH WITH JEEM WITH YEH FINAL FORMA" +
	"RABIC LIGATURE YEH WITH MEEM WITH YEH FINAL FORMARABIC LIGATURE MEEM WIT" +
	"H MEEM WITH YEH FINAL FORMARABIC LIGATURE QAF WITH MEEM WITH YEH FINAL F" +
	"ORMARABIC LIGATURE NOON WITH HAH WITH YEH FINAL FORMARABIC LIGATURE QAF " +
	"WITH MEEM WITH HAH INITIAL FORMARABIC LIGATURE LAM WITH HAH WITH MEEM IN" +
	"ITIAL FORMARABIC LIGATURE AIN WITH MEEM WITH YEH FINAL FORMARABIC LIGATU" +
	"RE KAF WITH MEEM WITH YEH FINAL FORMARABIC LIGATURE NOON WITH JEEM WITH " +
	"HAH INITIAL FORMARABIC LIGATURE MEEM WITH KHAH WITH YEH FINAL FORMARABIC" +
	" LIGATURE LAM WITH JEEM WITH MEEM INITIAL FORMARABIC LIGATURE KAF WITH M" +
	"EEM WITH MEEM FINAL FORMARABIC LIGATURE LAM WITH JEEM WITH MEEM FINAL FO" +
	"RMARABIC LIGATURE NOON WITH JEEM WITH HAH FINAL FORMARABIC LIGATURE JEEM" +
	" WITH HAH WITH YEH FINAL FORMARABIC LIGATURE HAH WITH JEEM WITH YEH FINA" +
	"L FORMARABIC LIGATURE MEEM WITH JEEM WITH YEH FINAL FORMARABIC LIGATURE " +
	"FEH WITH MEEM WITH YEH FINAL FORMARABIC LIGATURE BEH WITH HAH WITH YEH F" +
	"INAL FORMARABIC LIGATURE KAF WITH MEEM WITH MEEM INITIAL FORMARABIC LIGA" +
	"TURE AIN WITH JEEM WITH MEEM INITIAL FORMARABIC LIGATURE SAD WITH MEEM W" +
	"ITH MEEM INITIAL FORMARABIC LIGATURE SEEN WITH KHAH WITH YEH FINAL FORMA" +
	"RABIC LIGATURE NOON WITH JEEM WITH YEH FINAL FORMARABIC LIGATURE SALLA U" +
	"SED AS KORANIC STOP SIGN ISOLATED FORMARABIC LIGATURE QALA USED AS KORAN" +
	"IC STOP SIGN ISOLATED FORMARABIC LIGATURE ALLAH ISOLATED FORMARABIC LIGA" +
	"TURE AKBAR ISOLATED FORMARABIC LIGATURE MOHAMMAD ISOLATED FORMARABIC LIG" +
	"ATURE SALAM ISOLATED FORMARABIC LIGATURE RASOUL ISOLATED FORMARABIC LIGA" +
	"TURE ALAYHE ISOLATED FORMARABIC LIGATURE WASALLAM ISOLATED FORMARABIC LI" +
	"GATURE SALLA ISOLATED FORMARABIC LIGATURE SALLALLAHOU ALAYHE WASALLAMARA" +
	"BIC LIGATURE JALLAJALALOUHOURIAL SIGNARABIC LIGATURE BISMILLAH AR-RAHMAN" +
	" AR-RAHEEMVARIATION SELECTOR-1VARIATION SELECTOR-2VARIATION SELECTOR-3VA" +
	"RIATION SELECTOR-4VARIATION SELECTOR-5VARIATION SELECTOR-6VARIATION SELE" +
	"CTOR-7VARIATION SELECTOR-8VARIATION SELECTOR-9VARIATION SELECTOR-10VARIA" +
	"TION SELECTOR-11VARIATION SELECTOR-12VARIATION SELECTOR-13VARIATION SELE" +
	"CTOR-14VARIATION SELECTOR-15VARIATION SELECTOR-16PRESENTATION FORM FOR V" +
	"ERTICAL COMMAPRESENTATION FORM FOR VERTICAL IDEOGRAPHIC COMMAPRESENTATIO" +
	"N FORM FOR VERTICAL IDEOGRAPHIC FULL STOPPRESENTATION FORM FOR VERTICAL " +
	"COLONPRESENTATION FORM FOR VERTICAL SEMICOLONPRESENTATION FORM FOR VERTI" +
	"CAL EXCLAMATION MARKPRESENTATION FORM FOR VERTICAL QUESTION MARKPRESENTA" +
	"TION FORM FOR VERTICAL LEFT WHITE LENTICULAR BRACKETPRESENTATION FORM FO" +
	"R VERTICAL RIGHT WHITE LENTICULAR BRAKCETPRESENTATION FORM FOR VERTICAL " +
	"HORIZONTAL ELLIPSISCOMBINING LIGATURE LEFT HALFCOMBINING LIGATURE RIGHT " +
	"HALFCOMBINING DOUBLE TILDE LEFT HALFCOMBINING DOUBLE TILDE RIGHT HALFCOM" +
	"BINING MACRON LEFT HALFCOMBINING MACRON RIGHT HALFCOMBINING CONJOINING M" +
	"ACRONCOMBINING LIGATURE LEFT HALF BELOWCOMBINING LIGATURE RIGHT HALF BEL" +
	"OWCOMBINING TILDE LEFT HALF BELOWCOMBINING TILDE RIGHT HALF BELOWCOMBINI" +
	"NG MACRON LEFT HALF BELOWCOMBINING MACRON RIGHT HALF BELOWCOMBINING CONJ" +
	"OINING MACRON BELOWCOMBINING CYRILLIC TITLO LEFT HALFCOMBINING CYRILLIC " +
	"TITLO RIGHT HALFPRESENTATION FORM FOR VERTICAL TWO DOT LEADERPRESENTATIO" +
	"N FORM FOR VERTICAL EM DASHPRESENTATION FORM FOR VERTICAL EN DASHPRESENT" +
	"ATION FORM FOR VERTICAL LOW LINEPRESENTATION FORM FOR VERTICAL WAVY LOW " +
	"LINEPRESENTATION FORM FOR VERTICAL LEFT PARENTHESISPRESENTATION FORM FOR" +
	" VERTICAL RIGHT PARENTHESISPRESENTATION FORM FOR VERTICAL LEFT CURLY BRA" +
	"CKETPRESENTATION FORM FOR VERTICAL RIGHT CURLY BRACKETPRESENTATION FORM " +
	"FOR VERTICAL LEFT TORTOISE SHELL BRACKETPRESENTATION FORM FOR VERTICAL R" +
	"IGHT TORTOISE SHELL BRACKETPRESENTATION FORM FOR VERTICAL LEFT BLACK LEN" +
	"TICULAR BRACKETPRESENTATION FORM FOR VERTICAL RIGHT BLACK LENTICULAR BRA" +
	"CKETPRESENTATION FORM FOR VERTICAL LEFT DOUBLE ANGLE BRACKETPRESENTATION") + ("" +
	" FORM FOR VERTICAL RIGHT DOUBLE ANGLE BRACKETPRESENTATION FORM FOR VERTI" +
	"CAL LEFT ANGLE BRACKETPRESENTATION FORM FOR VERTICAL RIGHT ANGLE BRACKET" +
	"PRESENTATION FORM FOR VERTICAL LEFT CORNER BRACKETPRESENTATION FORM FOR " +
	"VERTICAL RIGHT CORNER BRACKETPRESENTATION FORM FOR VERTICAL LEFT WHITE C" +
	"ORNER BRACKETPRESENTATION FORM FOR VERTICAL RIGHT WHITE CORNER BRACKETSE" +
	"SAME DOTWHITE SESAME DOTPRESENTATION FORM FOR VERTICAL LEFT SQUARE BRACK" +
	"ETPRESENTATION FORM FOR VERTICAL RIGHT SQUARE BRACKETDASHED OVERLINECENT" +
	"RELINE OVERLINEWAVY OVERLINEDOUBLE WAVY OVERLINEDASHED LOW LINECENTRELIN" +
	"E LOW LINEWAVY LOW LINESMALL COMMASMALL IDEOGRAPHIC COMMASMALL FULL STOP" +
	"SMALL SEMICOLONSMALL COLONSMALL QUESTION MARKSMALL EXCLAMATION MARKSMALL" +
	" EM DASHSMALL LEFT PARENTHESISSMALL RIGHT PARENTHESISSMALL LEFT CURLY BR" +
	"ACKETSMALL RIGHT CURLY BRACKETSMALL LEFT TORTOISE SHELL BRACKETSMALL RIG" +
	"HT TORTOISE SHELL BRACKETSMALL NUMBER SIGNSMALL AMPERSANDSMALL ASTERISKS" +
	"MALL PLUS SIGNSMALL HYPHEN-MINUSSMALL LESS-THAN SIGNSMALL GREATER-THAN S" +
	"IGNSMALL EQUALS SIGNSMALL REVERSE SOLIDUSSMALL DOLLAR SIGNSMALL PERCENT " +
	"SIGNSMALL COMMERCIAL ATARABIC FATHATAN ISOLATED FORMARABIC TATWEEL WITH " +
	"FATHATAN ABOVEARABIC DAMMATAN ISOLATED FORMARABIC TAIL FRAGMENTARABIC KA" +
	"SRATAN ISOLATED FORMARABIC FATHA ISOLATED FORMARABIC FATHA MEDIAL FORMAR" +
	"ABIC DAMMA ISOLATED FORMARABIC DAMMA MEDIAL FORMARABIC KASRA ISOLATED FO" +
	"RMARABIC KASRA MEDIAL FORMARABIC SHADDA ISOLATED FORMARABIC SHADDA MEDIA" +
	"L FORMARABIC SUKUN ISOLATED FORMARABIC SUKUN MEDIAL FORMARABIC LETTER HA" +
	"MZA ISOLATED FORMARABIC LETTER ALEF WITH MADDA ABOVE ISOLATED FORMARABIC" +
	" LETTER ALEF WITH MADDA ABOVE FINAL FORMARABIC LETTER ALEF WITH HAMZA AB" +
	"OVE ISOLATED FORMARABIC LETTER ALEF WITH HAMZA ABOVE FINAL FORMARABIC LE" +
	"TTER WAW WITH HAMZA ABOVE ISOLATED FORMARABIC LETTER WAW WITH HAMZA ABOV" +
	"E FINAL FORMARABIC LETTER ALEF WITH HAMZA BELOW ISOLATED FORMARABIC LETT" +
	"ER ALEF WITH HAMZA BELOW FINAL FORMARABIC LETTER YEH WITH HAMZA ABOVE IS" +
	"OLATED FORMARABIC LETTER YEH WITH HAMZA ABOVE FINAL FORMARABIC LETTER YE" +
	"H WITH HAMZA ABOVE INITIAL FORMARABIC LETTER YEH WITH HAMZA ABOVE MEDIAL" +
	" FORMARABIC LETTER ALEF ISOLATED FORMARABIC LETTER ALEF FINAL FORMARABIC" +
	" LETTER BEH ISOLATED FORMARABIC LETTER BEH FINAL FORMARABIC LETTER BEH I" +
	"NITIAL FORMARABIC LETTER BEH MEDIAL FORMARABIC LETTER TEH MARBUTA ISOLAT" +
	"ED FORMARABIC LETTER TEH MARBUTA FINAL FORMARABIC LETTER TEH ISOLATED FO" +
	"RMARABIC LETTER TEH FINAL FORMARABIC LETTER TEH INITIAL FORMARABIC LETTE" +
	"R TEH MEDIAL FORMARABIC LETTER THEH ISOLATED FORMARABIC LETTER THEH FINA" +
	"L FORMARABIC LETTER THEH INITIAL FORMARABIC LETTER THEH MEDIAL FORMARABI" +
	"C LETTER JEEM ISOLATED FORMARABIC LETTER JEEM FINAL FORMARABIC LETTER JE" +
	"EM INITIAL FORMARABIC LETTER JEEM MEDIAL FORMARABIC LETTER HAH ISOLATED " +
	"FORMARABIC LETTER HAH FINAL FORMARABIC LETTER HAH INITIAL FORMARABIC LET" +
	"TER HAH MEDIAL FORMARABIC LETTER KHAH ISOLATED FORMARABIC LETTER KHAH FI" +
	"NAL FORMARABIC LETTER KHAH INITIAL FORMARABIC LETTER KHAH MEDIAL FORMARA" +
	"BIC LETTER DAL ISOLATED FORMARABIC LETTER DAL FINAL FORMARABIC LETTER TH" +
	"AL ISOLATED FORMARABIC LETTER THAL FINAL FORMARABIC LETTER REH ISOLATED " +
	"FORMARABIC LETTER REH FINAL FORMARABIC LETTER ZAIN ISOLATED FORMARABIC L" +
	"ETTER ZAIN FINAL FORMARABIC LETTER SEEN ISOLATED FORMARABIC LETTER SEEN " +
	"FINAL FORMARABIC LETTER SEEN INITIAL FORMARABIC LETTER SEEN MEDIAL FORMA" +
	"RABIC LETTER SHEEN ISOLATED FORMARABIC LETTER SHEEN FINAL FORMARABIC LET" +
	"TER SHEEN INITIAL FORMARABIC LETTER SHEEN MEDIAL FORMARABIC LETTER SAD I" +
	"SOLATED FORMARABIC LETTER SAD FINAL FORMARABIC LETTER SAD INITIAL FORMAR" +
	"ABIC LETTER SAD MEDIAL FORMARABIC LETTER DAD ISOLATED FORMARABIC LETTER " +
	"DAD FINAL FORMARABIC LETTER DAD INITIAL FORMARABIC LETTER DAD MEDIAL FOR" +
	"MARABIC LETTER TAH ISOLATED FORMARABIC LETTER TAH FINAL FORMARABIC LETTE" +
	"R TAH INITIAL FORMARABIC LETTER TAH MEDIAL FORMARABIC LETTER ZAH ISOLATE" +
	"D FORMARABIC LETTER ZAH FINAL FORMARABIC LETTER ZAH INITIAL FORMARABIC L" +
	"ETTER ZAH MEDIAL FORMARABIC LETTER AIN ISOLATED FORMARABIC LETTER AIN FI" +
	"NAL FORMARABIC LETTER AIN INITIAL FORMARABIC LETTER AIN MEDIAL FORMARABI" +
	"C LETTER GHAIN ISOLATED FORMARABIC LETTER GHAIN FINAL FORMARABIC LETTER " +
	"GHAIN INITIAL FORMARABIC LETTER GHAIN MEDIAL FORMARABIC LETTER FEH ISOLA" +
	"TED FORMARABIC LETTER FEH FINAL FORMARABIC LETTER FEH INITIAL FORMARABIC" +
	" LETTER FEH MEDIAL FORMARABIC LETTER QAF ISOLATED FORMARABIC LETTER QAF " +
	"FINAL FORMARABIC LETTER QAF INITIAL FORMARABIC LETTER QAF MEDIAL FORMARA" +
	"BIC LETTER KAF ISOLATED FORMARABIC LETTER KAF FINAL FORMARABIC LETTER KA" +
	"F INITIAL FORMARABIC LETTER KAF MEDIAL FORMARABIC LETTER LAM ISOLATED FO" +
	"RMARABIC LETTER LAM FINAL FORMARABIC LETTER LAM INITIAL FORMARABIC LETTE") + ("" +
	"R LAM MEDIAL FORMARABIC LETTER MEEM ISOLATED FORMARABIC LETTER MEEM FINA" +
	"L FORMARABIC LETTER MEEM INITIAL FORMARABIC LETTER MEEM MEDIAL FORMARABI" +
	"C LETTER NOON ISOLATED FORMARABIC LETTER NOON FINAL FORMARABIC LETTER NO" +
	"ON INITIAL FORMARABIC LETTER NOON MEDIAL FORMARABIC LETTER HEH ISOLATED " +
	"FORMARABIC LETTER HEH FINAL FORMARABIC LETTER HEH INITIAL FORMARABIC LET" +
	"TER HEH MEDIAL FORMARABIC LETTER WAW ISOLATED FORMARABIC LETTER WAW FINA" +
	"L FORMARABIC LETTER ALEF MAKSURA ISOLATED FORMARABIC LETTER ALEF MAKSURA" +
	" FINAL FORMARABIC LETTER YEH ISOLATED FORMARABIC LETTER YEH FINAL FORMAR" +
	"ABIC LETTER YEH INITIAL FORMARABIC LETTER YEH MEDIAL FORMARABIC LIGATURE" +
	" LAM WITH ALEF WITH MADDA ABOVE ISOLATED FORMARABIC LIGATURE LAM WITH AL" +
	"EF WITH MADDA ABOVE FINAL FORMARABIC LIGATURE LAM WITH ALEF WITH HAMZA A" +
	"BOVE ISOLATED FORMARABIC LIGATURE LAM WITH ALEF WITH HAMZA ABOVE FINAL F" +
	"ORMARABIC LIGATURE LAM WITH ALEF WITH HAMZA BELOW ISOLATED FORMARABIC LI" +
	"GATURE LAM WITH ALEF WITH HAMZA BELOW FINAL FORMARABIC LIGATURE LAM WITH" +
	" ALEF ISOLATED FORMARABIC LIGATURE LAM WITH ALEF FINAL FORMZERO WIDTH NO" +
	"-BREAK SPACEFULLWIDTH EXCLAMATION MARKFULLWIDTH QUOTATION MARKFULLWIDTH " +
	"NUMBER SIGNFULLWIDTH DOLLAR SIGNFULLWIDTH PERCENT SIGNFULLWIDTH AMPERSAN" +
	"DFULLWIDTH APOSTROPHEFULLWIDTH LEFT PARENTHESISFULLWIDTH RIGHT PARENTHES" +
	"ISFULLWIDTH ASTERISKFULLWIDTH PLUS SIGNFULLWIDTH COMMAFULLWIDTH HYPHEN-M" +
	"INUSFULLWIDTH FULL STOPFULLWIDTH SOLIDUSFULLWIDTH DIGIT ZEROFULLWIDTH DI" +
	"GIT ONEFULLWIDTH DIGIT TWOFULLWIDTH DIGIT THREEFULLWIDTH DIGIT FOURFULLW" +
	"IDTH DIGIT FIVEFULLWIDTH DIGIT SIXFULLWIDTH DIGIT SEVENFULLWIDTH DIGIT E" +
	"IGHTFULLWIDTH DIGIT NINEFULLWIDTH COLONFULLWIDTH SEMICOLONFULLWIDTH LESS" +
	"-THAN SIGNFULLWIDTH EQUALS SIGNFULLWIDTH GREATER-THAN SIGNFULLWIDTH QUES" +
	"TION MARKFULLWIDTH COMMERCIAL ATFULLWIDTH LATIN CAPITAL LETTER AFULLWIDT" +
	"H LATIN CAPITAL LETTER BFULLWIDTH LATIN CAPITAL LETTER CFULLWIDTH LATIN " +
	"CAPITAL LETTER DFULLWIDTH LATIN CAPITAL LETTER EFULLWIDTH LATIN CAPITAL " +
	"LETTER FFULLWIDTH LATIN CAPITAL LETTER GFULLWIDTH LATIN CAPITAL LETTER H" +
	"FULLWIDTH LATIN CAPITAL LETTER IFULLWIDTH LATIN CAPITAL LETTER JFULLWIDT" +
	"H LATIN CAPITAL LETTER KFULLWIDTH LATIN CAPITAL LETTER LFULLWIDTH LATIN " +
	"CAPITAL LETTER MFULLWIDTH LATIN CAPITAL LETTER NFULLWIDTH LATIN CAPITAL " +
	"LETTER OFULLWIDTH LATIN CAPITAL LETTER PFULLWIDTH LATIN CAPITAL LETTER Q" +
	"FULLWIDTH LATIN CAPITAL LETTER RFULLWIDTH LATIN CAPITAL LETTER SFULLWIDT" +
	"H LATIN CAPITAL LETTER TFULLWIDTH LATIN CAPITAL LETTER UFULLWIDTH LATIN " +
	"CAPITAL LETTER VFULLWIDTH LATIN CAPITAL LETTER WFULLWIDTH LATIN CAPITAL " +
	"LETTER XFULLWIDTH LATIN CAPITAL LETTER YFULLWIDTH LATIN CAPITAL LETTER Z" +
	"FULLWIDTH LEFT SQUARE BRACKETFULLWIDTH REVERSE SOLIDUSFULLWIDTH RIGHT SQ" +
	"UARE BRACKETFULLWIDTH CIRCUMFLEX ACCENTFULLWIDTH LOW LINEFULLWIDTH GRAVE" +
	" ACCENTFULLWIDTH LATIN SMALL LETTER AFULLWIDTH LATIN SMALL LETTER BFULLW" +
	"IDTH LATIN SMALL LETTER CFULLWIDTH LATIN SMALL LETTER DFULLWIDTH LATIN S" +
	"MALL LETTER EFULLWIDTH LATIN SMALL LETTER FFULLWIDTH LATIN SMALL LETTER " +
	"GFULLWIDTH LATIN SMALL LETTER HFULLWIDTH LATIN SMALL LETTER IFULLWIDTH L" +
	"ATIN SMALL LETTER JFULLWIDTH LATIN SMALL LETTER KFULLWIDTH LATIN SMALL L" +
	"ETTER LFULLWIDTH LATIN SMALL LETTER MFULLWIDTH LATIN SMALL LETTER NFULLW" +
	"IDTH LATIN SMALL LETTER OFULLWIDTH LATIN SMALL LETTER PFULLWIDTH LATIN S" +
	"MALL LETTER QFULLWIDTH LATIN SMALL LETTER RFULLWIDTH LATIN SMALL LETTER " +
	"SFULLWIDTH LATIN SMALL LETTER TFULLWIDTH LATIN SMALL LETTER UFULLWIDTH L" +
	"ATIN SMALL LETTER VFULLWIDTH LATIN SMALL LETTER WFULLWIDTH LATIN SMALL L" +
	"ETTER XFULLWIDTH LATIN SMALL LETTER YFULLWIDTH LATIN SMALL LETTER ZFULLW" +
	"IDTH LEFT CURLY BRACKETFULLWIDTH VERTICAL LINEFULLWIDTH RIGHT CURLY BRAC" +
	"KETFULLWIDTH TILDEFULLWIDTH LEFT WHITE PARENTHESISFULLWIDTH RIGHT WHITE " +
	"PARENTHESISHALFWIDTH IDEOGRAPHIC FULL STOPHALFWIDTH LEFT CORNER BRACKETH" +
	"ALFWIDTH RIGHT CORNER BRACKETHALFWIDTH IDEOGRAPHIC COMMAHALFWIDTH KATAKA" +
	"NA MIDDLE DOTHALFWIDTH KATAKANA LETTER WOHALFWIDTH KATAKANA LETTER SMALL" +
	" AHALFWIDTH KATAKANA LETTER SMALL IHALFWIDTH KATAKANA LETTER SMALL UHALF" +
	"WIDTH KATAKANA LETTER SMALL EHALFWIDTH KATAKANA LETTER SMALL OHALFWIDTH " +
	"KATAKANA LETTER SMALL YAHALFWIDTH KATAKANA LETTER SMALL YUHALFWIDTH KATA" +
	"KANA LETTER SMALL YOHALFWIDTH KATAKANA LETTER SMALL TUHALFWIDTH KATAKANA" +
	"-HIRAGANA PROLONGED SOUND MARKHALFWIDTH KATAKANA LETTER AHALFWIDTH KATAK" +
	"ANA LETTER IHALFWIDTH KATAKANA LETTER UHALFWIDTH KATAKANA LETTER EHALFWI" +
	"DTH KATAKANA LETTER OHALFWIDTH KATAKANA LETTER KAHALFWIDTH KATAKANA LETT" +
	"ER KIHALFWIDTH KATAKANA LETTER KUHALFWIDTH KATAKANA LETTER KEHALFWIDTH K" +
	"ATAKANA LETTER KOHALFWIDTH KATAKANA LETTER SAHALFWIDTH KATAKANA LETTER S" +
	"IHALFWIDTH KATAKANA LETTER SUHALFWIDTH KATAKANA LETTER SEHALFWIDTH KATAK") + ("" +
	"ANA LETTER SOHALFWIDTH KATAKANA LETTER TAHALFWIDTH KATAKANA LETTER TIHAL" +
	"FWIDTH KATAKANA LETTER TUHALFWIDTH KATAKANA LETTER TEHALFWIDTH KATAKANA " +
	"LETTER TOHALFWIDTH KATAKANA LETTER NAHALFWIDTH KATAKANA LETTER NIHALFWID" +
	"TH KATAKANA LETTER NUHALFWIDTH KATAKANA LETTER NEHALFWIDTH KATAKANA LETT" +
	"ER NOHALFWIDTH KATAKANA LETTER HAHALFWIDTH KATAKANA LETTER HIHALFWIDTH K" +
	"ATAKANA LETTER HUHALFWIDTH KATAKANA LETTER HEHALFWIDTH KATAKANA LETTER H" +
	"OHALFWIDTH KATAKANA LETTER MAHALFWIDTH KATAKANA LETTER MIHALFWIDTH KATAK" +
	"ANA LETTER MUHALFWIDTH KATAKANA LETTER MEHALFWIDTH KATAKANA LETTER MOHAL" +
	"FWIDTH KATAKANA LETTER YAHALFWIDTH KATAKANA LETTER YUHALFWIDTH KATAKANA " +
	"LETTER YOHALFWIDTH KATAKANA LETTER RAHALFWIDTH KATAKANA LETTER RIHALFWID" +
	"TH KATAKANA LETTER RUHALFWIDTH KATAKANA LETTER REHALFWIDTH KATAKANA LETT" +
	"ER ROHALFWIDTH KATAKANA LETTER WAHALFWIDTH KATAKANA LETTER NHALFWIDTH KA" +
	"TAKANA VOICED SOUND MARKHALFWIDTH KATAKANA SEMI-VOICED SOUND MARKHALFWID" +
	"TH HANGUL FILLERHALFWIDTH HANGUL LETTER KIYEOKHALFWIDTH HANGUL LETTER SS" +
	"ANGKIYEOKHALFWIDTH HANGUL LETTER KIYEOK-SIOSHALFWIDTH HANGUL LETTER NIEU" +
	"NHALFWIDTH HANGUL LETTER NIEUN-CIEUCHALFWIDTH HANGUL LETTER NIEUN-HIEUHH" +
	"ALFWIDTH HANGUL LETTER TIKEUTHALFWIDTH HANGUL LETTER SSANGTIKEUTHALFWIDT" +
	"H HANGUL LETTER RIEULHALFWIDTH HANGUL LETTER RIEUL-KIYEOKHALFWIDTH HANGU" +
	"L LETTER RIEUL-MIEUMHALFWIDTH HANGUL LETTER RIEUL-PIEUPHALFWIDTH HANGUL " +
	"LETTER RIEUL-SIOSHALFWIDTH HANGUL LETTER RIEUL-THIEUTHHALFWIDTH HANGUL L" +
	"ETTER RIEUL-PHIEUPHHALFWIDTH HANGUL LETTER RIEUL-HIEUHHALFWIDTH HANGUL L" +
	"ETTER MIEUMHALFWIDTH HANGUL LETTER PIEUPHALFWIDTH HANGUL LETTER SSANGPIE" +
	"UPHALFWIDTH HANGUL LETTER PIEUP-SIOSHALFWIDTH HANGUL LETTER SIOSHALFWIDT" +
	"H HANGUL LETTER SSANGSIOSHALFWIDTH HANGUL LETTER IEUNGHALFWIDTH HANGUL L" +
	"ETTER CIEUCHALFWIDTH HANGUL LETTER SSANGCIEUCHALFWIDTH HANGUL LETTER CHI" +
	"EUCHHALFWIDTH HANGUL LETTER KHIEUKHHALFWIDTH HANGUL LETTER THIEUTHHALFWI" +
	"DTH HANGUL LETTER PHIEUPHHALFWIDTH HANGUL LETTER HIEUHHALFWIDTH HANGUL L" +
	"ETTER AHALFWIDTH HANGUL LETTER AEHALFWIDTH HANGUL LETTER YAHALFWIDTH HAN" +
	"GUL LETTER YAEHALFWIDTH HANGUL LETTER EOHALFWIDTH HANGUL LETTER EHALFWID" +
	"TH HANGUL LETTER YEOHALFWIDTH HANGUL LETTER YEHALFWIDTH HANGUL LETTER OH" +
	"ALFWIDTH HANGUL LETTER WAHALFWIDTH HANGUL LETTER WAEHALFWIDTH HANGUL LET" +
	"TER OEHALFWIDTH HANGUL LETTER YOHALFWIDTH HANGUL LETTER UHALFWIDTH HANGU" +
	"L LETTER WEOHALFWIDTH HANGUL LETTER WEHALFWIDTH HANGUL LETTER WIHALFWIDT" +
	"H HANGUL LETTER YUHALFWIDTH HANGUL LETTER EUHALFWIDTH HANGUL LETTER YIHA" +
	"LFWIDTH HANGUL LETTER IFULLWIDTH CENT SIGNFULLWIDTH POUND SIGNFULLWIDTH " +
	"NOT SIGNFULLWIDTH MACRONFULLWIDTH BROKEN BARFULLWIDTH YEN SIGNFULLWIDTH " +
	"WON SIGNHALFWIDTH FORMS LIGHT VERTICALHALFWIDTH LEFTWARDS ARROWHALFWIDTH" +
	" UPWARDS ARROWHALFWIDTH RIGHTWARDS ARROWHALFWIDTH DOWNWARDS ARROWHALFWID" +
	"TH BLACK SQUAREHALFWIDTH WHITE CIRCLEINTERLINEAR ANNOTATION ANCHORINTERL" +
	"INEAR ANNOTATION SEPARATORINTERLINEAR ANNOTATION TERMINATOROBJECT REPLAC" +
	"EMENT CHARACTERREPLACEMENT CHARACTERLINEAR B SYLLABLE B008 ALINEAR B SYL" +
	"LABLE B038 ELINEAR B SYLLABLE B028 ILINEAR B SYLLABLE B061 OLINEAR B SYL" +
	"LABLE B010 ULINEAR B SYLLABLE B001 DALINEAR B SYLLABLE B045 DELINEAR B S" +
	"YLLABLE B007 DILINEAR B SYLLABLE B014 DOLINEAR B SYLLABLE B051 DULINEAR " +
	"B SYLLABLE B057 JALINEAR B SYLLABLE B046 JELINEAR B SYLLABLE B036 JOLINE" +
	"AR B SYLLABLE B065 JULINEAR B SYLLABLE B077 KALINEAR B SYLLABLE B044 KEL" +
	"INEAR B SYLLABLE B067 KILINEAR B SYLLABLE B070 KOLINEAR B SYLLABLE B081 " +
	"KULINEAR B SYLLABLE B080 MALINEAR B SYLLABLE B013 MELINEAR B SYLLABLE B0" +
	"73 MILINEAR B SYLLABLE B015 MOLINEAR B SYLLABLE B023 MULINEAR B SYLLABLE" +
	" B006 NALINEAR B SYLLABLE B024 NELINEAR B SYLLABLE B030 NILINEAR B SYLLA" +
	"BLE B052 NOLINEAR B SYLLABLE B055 NULINEAR B SYLLABLE B003 PALINEAR B SY" +
	"LLABLE B072 PELINEAR B SYLLABLE B039 PILINEAR B SYLLABLE B011 POLINEAR B" +
	" SYLLABLE B050 PULINEAR B SYLLABLE B016 QALINEAR B SYLLABLE B078 QELINEA" +
	"R B SYLLABLE B021 QILINEAR B SYLLABLE B032 QOLINEAR B SYLLABLE B060 RALI" +
	"NEAR B SYLLABLE B027 RELINEAR B SYLLABLE B053 RILINEAR B SYLLABLE B002 R" +
	"OLINEAR B SYLLABLE B026 RULINEAR B SYLLABLE B031 SALINEAR B SYLLABLE B00" +
	"9 SELINEAR B SYLLABLE B041 SILINEAR B SYLLABLE B012 SOLINEAR B SYLLABLE " +
	"B058 SULINEAR B SYLLABLE B059 TALINEAR B SYLLABLE B004 TELINEAR B SYLLAB" +
	"LE B037 TILINEAR B SYLLABLE B005 TOLINEAR B SYLLABLE B069 TULINEAR B SYL" +
	"LABLE B054 WALINEAR B SYLLABLE B075 WELINEAR B SYLLABLE B040 WILINEAR B " +
	"SYLLABLE B042 WOLINEAR B SYLLABLE B017 ZALINEAR B SYLLABLE B074 ZELINEAR" +
	" B SYLLABLE B020 ZOLINEAR B SYLLABLE B025 A2LINEAR B SYLLABLE B043 A3LIN" +
	"EAR B SYLLABLE B085 AULINEAR B SYLLABLE B071 DWELINEAR B SYLLABLE B090 D" +
	"WOLINEAR B SYLLABLE B048 NWALINEAR B SYLLABLE B029 PU2LINEAR B SYLLABLE ") + ("" +
	"B062 PTELINEAR B SYLLABLE B076 RA2LINEAR B SYLLABLE B033 RA3LINEAR B SYL" +
	"LABLE B068 RO2LINEAR B SYLLABLE B066 TA2LINEAR B SYLLABLE B087 TWELINEAR" +
	" B SYLLABLE B091 TWOLINEAR B SYMBOL B018LINEAR B SYMBOL B019LINEAR B SYM" +
	"BOL B022LINEAR B SYMBOL B034LINEAR B SYMBOL B047LINEAR B SYMBOL B049LINE" +
	"AR B SYMBOL B056LINEAR B SYMBOL B063LINEAR B SYMBOL B064LINEAR B SYMBOL " +
	"B079LINEAR B SYMBOL B082LINEAR B SYMBOL B083LINEAR B SYMBOL B086LINEAR B" +
	" SYMBOL B089LINEAR B IDEOGRAM B100 MANLINEAR B IDEOGRAM B102 WOMANLINEAR" +
	" B IDEOGRAM B104 DEERLINEAR B IDEOGRAM B105 EQUIDLINEAR B IDEOGRAM B105F" +
	" MARELINEAR B IDEOGRAM B105M STALLIONLINEAR B IDEOGRAM B106F EWELINEAR B" +
	" IDEOGRAM B106M RAMLINEAR B IDEOGRAM B107F SHE-GOATLINEAR B IDEOGRAM B10" +
	"7M HE-GOATLINEAR B IDEOGRAM B108F SOWLINEAR B IDEOGRAM B108M BOARLINEAR " +
	"B IDEOGRAM B109F COWLINEAR B IDEOGRAM B109M BULLLINEAR B IDEOGRAM B120 W" +
	"HEATLINEAR B IDEOGRAM B121 BARLEYLINEAR B IDEOGRAM B122 OLIVELINEAR B ID" +
	"EOGRAM B123 SPICELINEAR B IDEOGRAM B125 CYPERUSLINEAR B MONOGRAM B127 KA" +
	"POLINEAR B MONOGRAM B128 KANAKOLINEAR B IDEOGRAM B130 OILLINEAR B IDEOGR" +
	"AM B131 WINELINEAR B IDEOGRAM B132LINEAR B MONOGRAM B133 AREPALINEAR B M" +
	"ONOGRAM B135 MERILINEAR B IDEOGRAM B140 BRONZELINEAR B IDEOGRAM B141 GOL" +
	"DLINEAR B IDEOGRAM B142LINEAR B IDEOGRAM B145 WOOLLINEAR B IDEOGRAM B146" +
	"LINEAR B IDEOGRAM B150LINEAR B IDEOGRAM B151 HORNLINEAR B IDEOGRAM B152L" +
	"INEAR B IDEOGRAM B153LINEAR B IDEOGRAM B154LINEAR B MONOGRAM B156 TURO2L" +
	"INEAR B IDEOGRAM B157LINEAR B IDEOGRAM B158LINEAR B IDEOGRAM B159 CLOTHL" +
	"INEAR B IDEOGRAM B160LINEAR B IDEOGRAM B161LINEAR B IDEOGRAM B162 GARMEN" +
	"TLINEAR B IDEOGRAM B163 ARMOURLINEAR B IDEOGRAM B164LINEAR B IDEOGRAM B1" +
	"65LINEAR B IDEOGRAM B166LINEAR B IDEOGRAM B167LINEAR B IDEOGRAM B168LINE" +
	"AR B IDEOGRAM B169LINEAR B IDEOGRAM B170LINEAR B IDEOGRAM B171LINEAR B I" +
	"DEOGRAM B172LINEAR B IDEOGRAM B173 MONTHLINEAR B IDEOGRAM B174LINEAR B I" +
	"DEOGRAM B176 TREELINEAR B IDEOGRAM B177LINEAR B IDEOGRAM B178LINEAR B ID" +
	"EOGRAM B179LINEAR B IDEOGRAM B180LINEAR B IDEOGRAM B181LINEAR B IDEOGRAM" +
	" B182LINEAR B IDEOGRAM B183LINEAR B IDEOGRAM B184LINEAR B IDEOGRAM B185L" +
	"INEAR B IDEOGRAM B189LINEAR B IDEOGRAM B190LINEAR B IDEOGRAM B191 HELMET" +
	"LINEAR B IDEOGRAM B220 FOOTSTOOLLINEAR B IDEOGRAM B225 BATHTUBLINEAR B I" +
	"DEOGRAM B230 SPEARLINEAR B IDEOGRAM B231 ARROWLINEAR B IDEOGRAM B232LINE" +
	"AR B IDEOGRAM B233 SWORDLINEAR B IDEOGRAM B234LINEAR B IDEOGRAM B236LINE" +
	"AR B IDEOGRAM B240 WHEELED CHARIOTLINEAR B IDEOGRAM B241 CHARIOTLINEAR B" +
	" IDEOGRAM B242 CHARIOT FRAMELINEAR B IDEOGRAM B243 WHEELLINEAR B IDEOGRA" +
	"M B245LINEAR B IDEOGRAM B246LINEAR B MONOGRAM B247 DIPTELINEAR B IDEOGRA" +
	"M B248LINEAR B IDEOGRAM B249LINEAR B IDEOGRAM B251LINEAR B IDEOGRAM B252" +
	"LINEAR B IDEOGRAM B253LINEAR B IDEOGRAM B254 DARTLINEAR B IDEOGRAM B255L" +
	"INEAR B IDEOGRAM B256LINEAR B IDEOGRAM B257LINEAR B IDEOGRAM B258LINEAR " +
	"B IDEOGRAM B259LINEAR B IDEOGRAM VESSEL B155LINEAR B IDEOGRAM VESSEL B20" +
	"0LINEAR B IDEOGRAM VESSEL B201LINEAR B IDEOGRAM VESSEL B202LINEAR B IDEO" +
	"GRAM VESSEL B203LINEAR B IDEOGRAM VESSEL B204LINEAR B IDEOGRAM VESSEL B2" +
	"05LINEAR B IDEOGRAM VESSEL B206LINEAR B IDEOGRAM VESSEL B207LINEAR B IDE" +
	"OGRAM VESSEL B208LINEAR B IDEOGRAM VESSEL B209LINEAR B IDEOGRAM VESSEL B" +
	"210LINEAR B IDEOGRAM VESSEL B211LINEAR B IDEOGRAM VESSEL B212LINEAR B ID" +
	"EOGRAM VESSEL B213LINEAR B IDEOGRAM VESSEL B214LINEAR B IDEOGRAM VESSEL " +
	"B215LINEAR B IDEOGRAM VESSEL B216LINEAR B IDEOGRAM VESSEL B217LINEAR B I" +
	"DEOGRAM VESSEL B218LINEAR B IDEOGRAM VESSEL B219LINEAR B IDEOGRAM VESSEL" +
	" B221LINEAR B IDEOGRAM VESSEL B222LINEAR B IDEOGRAM VESSEL B226LINEAR B " +
	"IDEOGRAM VESSEL B227LINEAR B IDEOGRAM VESSEL B228LINEAR B IDEOGRAM VESSE" +
	"L B229LINEAR B IDEOGRAM VESSEL B250LINEAR B IDEOGRAM VESSEL B305AEGEAN W" +
	"ORD SEPARATOR LINEAEGEAN WORD SEPARATOR DOTAEGEAN CHECK MARKAEGEAN NUMBE" +
	"R ONEAEGEAN NUMBER TWOAEGEAN NUMBER THREEAEGEAN NUMBER FOURAEGEAN NUMBER" +
	" FIVEAEGEAN NUMBER SIXAEGEAN NUMBER SEVENAEGEAN NUMBER EIGHTAEGEAN NUMBE" +
	"R NINEAEGEAN NUMBER TENAEGEAN NUMBER TWENTYAEGEAN NUMBER THIRTYAEGEAN NU" +
	"MBER FORTYAEGEAN NUMBER FIFTYAEGEAN NUMBER SIXTYAEGEAN NUMBER SEVENTYAEG" +
	"EAN NUMBER EIGHTYAEGEAN NUMBER NINETYAEGEAN NUMBER ONE HUNDREDAEGEAN NUM" +
	"BER TWO HUNDREDAEGEAN NUMBER THREE HUNDREDAEGEAN NUMBER FOUR HUNDREDAEGE" +
	"AN NUMBER FIVE HUNDREDAEGEAN NUMBER SIX HUNDREDAEGEAN NUMBER SEVEN HUNDR" +
	"EDAEGEAN NUMBER EIGHT HUNDREDAEGEAN NUMBER NINE HUNDREDAEGEAN NUMBER ONE" +
	" THOUSANDAEGEAN NUMBER TWO THOUSANDAEGEAN NUMBER THREE THOUSANDAEGEAN NU" +
	"MBER FOUR THOUSANDAEGEAN NUMBER FIVE THOUSANDAEGEAN NUMBER SIX THOUSANDA" +
	"EGEAN NUMBER SEVEN THOUSANDAEGEAN NUMBER EIGHT THOUSANDAEGEAN NUMBER NIN" +
	"E THOUSANDAEGEAN NUMBER TEN THOUSANDAEGEAN NUMBER TWENTY THOUSANDAEGEAN ") + ("" +
	"NUMBER THIRTY THOUSANDAEGEAN NUMBER FORTY THOUSANDAEGEAN NUMBER FIFTY TH" +
	"OUSANDAEGEAN NUMBER SIXTY THOUSANDAEGEAN NUMBER SEVENTY THOUSANDAEGEAN N" +
	"UMBER EIGHTY THOUSANDAEGEAN NUMBER NINETY THOUSANDAEGEAN WEIGHT BASE UNI" +
	"TAEGEAN WEIGHT FIRST SUBUNITAEGEAN WEIGHT SECOND SUBUNITAEGEAN WEIGHT TH" +
	"IRD SUBUNITAEGEAN WEIGHT FOURTH SUBUNITAEGEAN DRY MEASURE FIRST SUBUNITA" +
	"EGEAN LIQUID MEASURE FIRST SUBUNITAEGEAN MEASURE SECOND SUBUNITAEGEAN ME" +
	"ASURE THIRD SUBUNITGREEK ACROPHONIC ATTIC ONE QUARTERGREEK ACROPHONIC AT" +
	"TIC ONE HALFGREEK ACROPHONIC ATTIC ONE DRACHMAGREEK ACROPHONIC ATTIC FIV" +
	"EGREEK ACROPHONIC ATTIC FIFTYGREEK ACROPHONIC ATTIC FIVE HUNDREDGREEK AC" +
	"ROPHONIC ATTIC FIVE THOUSANDGREEK ACROPHONIC ATTIC FIFTY THOUSANDGREEK A" +
	"CROPHONIC ATTIC FIVE TALENTSGREEK ACROPHONIC ATTIC TEN TALENTSGREEK ACRO" +
	"PHONIC ATTIC FIFTY TALENTSGREEK ACROPHONIC ATTIC ONE HUNDRED TALENTSGREE" +
	"K ACROPHONIC ATTIC FIVE HUNDRED TALENTSGREEK ACROPHONIC ATTIC ONE THOUSA" +
	"ND TALENTSGREEK ACROPHONIC ATTIC FIVE THOUSAND TALENTSGREEK ACROPHONIC A" +
	"TTIC FIVE STATERSGREEK ACROPHONIC ATTIC TEN STATERSGREEK ACROPHONIC ATTI" +
	"C FIFTY STATERSGREEK ACROPHONIC ATTIC ONE HUNDRED STATERSGREEK ACROPHONI" +
	"C ATTIC FIVE HUNDRED STATERSGREEK ACROPHONIC ATTIC ONE THOUSAND STATERSG" +
	"REEK ACROPHONIC ATTIC TEN THOUSAND STATERSGREEK ACROPHONIC ATTIC FIFTY T" +
	"HOUSAND STATERSGREEK ACROPHONIC ATTIC TEN MNASGREEK ACROPHONIC HERAEUM O" +
	"NE PLETHRONGREEK ACROPHONIC THESPIAN ONEGREEK ACROPHONIC HERMIONIAN ONEG" +
	"REEK ACROPHONIC EPIDAUREAN TWOGREEK ACROPHONIC THESPIAN TWOGREEK ACROPHO" +
	"NIC CYRENAIC TWO DRACHMASGREEK ACROPHONIC EPIDAUREAN TWO DRACHMASGREEK A" +
	"CROPHONIC TROEZENIAN FIVEGREEK ACROPHONIC TROEZENIAN TENGREEK ACROPHONIC" +
	" TROEZENIAN TEN ALTERNATE FORMGREEK ACROPHONIC HERMIONIAN TENGREEK ACROP" +
	"HONIC MESSENIAN TENGREEK ACROPHONIC THESPIAN TENGREEK ACROPHONIC THESPIA" +
	"N THIRTYGREEK ACROPHONIC TROEZENIAN FIFTYGREEK ACROPHONIC TROEZENIAN FIF" +
	"TY ALTERNATE FORMGREEK ACROPHONIC HERMIONIAN FIFTYGREEK ACROPHONIC THESP" +
	"IAN FIFTYGREEK ACROPHONIC THESPIAN ONE HUNDREDGREEK ACROPHONIC THESPIAN " +
	"THREE HUNDREDGREEK ACROPHONIC EPIDAUREAN FIVE HUNDREDGREEK ACROPHONIC TR" +
	"OEZENIAN FIVE HUNDREDGREEK ACROPHONIC THESPIAN FIVE HUNDREDGREEK ACROPHO" +
	"NIC CARYSTIAN FIVE HUNDREDGREEK ACROPHONIC NAXIAN FIVE HUNDREDGREEK ACRO" +
	"PHONIC THESPIAN ONE THOUSANDGREEK ACROPHONIC THESPIAN FIVE THOUSANDGREEK" +
	" ACROPHONIC DELPHIC FIVE MNASGREEK ACROPHONIC STRATIAN FIFTY MNASGREEK O" +
	"NE HALF SIGNGREEK ONE HALF SIGN ALTERNATE FORMGREEK TWO THIRDS SIGNGREEK" +
	" THREE QUARTERS SIGNGREEK YEAR SIGNGREEK TALENT SIGNGREEK DRACHMA SIGNGR" +
	"EEK OBOL SIGNGREEK TWO OBOLS SIGNGREEK THREE OBOLS SIGNGREEK FOUR OBOLS " +
	"SIGNGREEK FIVE OBOLS SIGNGREEK METRETES SIGNGREEK KYATHOS BASE SIGNGREEK" +
	" LITRA SIGNGREEK OUNKIA SIGNGREEK XESTES SIGNGREEK ARTABE SIGNGREEK AROU" +
	"RA SIGNGREEK GRAMMA SIGNGREEK TRYBLION BASE SIGNGREEK ZERO SIGNGREEK ONE" +
	" QUARTER SIGNGREEK SINUSOID SIGNGREEK INDICTION SIGNNOMISMA SIGNROMAN SE" +
	"XTANS SIGNROMAN UNCIA SIGNROMAN SEMUNCIA SIGNROMAN SEXTULA SIGNROMAN DIM" +
	"IDIA SEXTULA SIGNROMAN SILIQUA SIGNROMAN DENARIUS SIGNROMAN QUINARIUS SI" +
	"GNROMAN SESTERTIUS SIGNROMAN DUPONDIUS SIGNROMAN AS SIGNROMAN CENTURIAL " +
	"SIGNGREEK SYMBOL TAU RHOPHAISTOS DISC SIGN PEDESTRIANPHAISTOS DISC SIGN " +
	"PLUMED HEADPHAISTOS DISC SIGN TATTOOED HEADPHAISTOS DISC SIGN CAPTIVEPHA" +
	"ISTOS DISC SIGN CHILDPHAISTOS DISC SIGN WOMANPHAISTOS DISC SIGN HELMETPH" +
	"AISTOS DISC SIGN GAUNTLETPHAISTOS DISC SIGN TIARAPHAISTOS DISC SIGN ARRO" +
	"WPHAISTOS DISC SIGN BOWPHAISTOS DISC SIGN SHIELDPHAISTOS DISC SIGN CLUBP" +
	"HAISTOS DISC SIGN MANACLESPHAISTOS DISC SIGN MATTOCKPHAISTOS DISC SIGN S" +
	"AWPHAISTOS DISC SIGN LIDPHAISTOS DISC SIGN BOOMERANGPHAISTOS DISC SIGN C" +
	"ARPENTRY PLANEPHAISTOS DISC SIGN DOLIUMPHAISTOS DISC SIGN COMBPHAISTOS D" +
	"ISC SIGN SLINGPHAISTOS DISC SIGN COLUMNPHAISTOS DISC SIGN BEEHIVEPHAISTO" +
	"S DISC SIGN SHIPPHAISTOS DISC SIGN HORNPHAISTOS DISC SIGN HIDEPHAISTOS D" +
	"ISC SIGN BULLS LEGPHAISTOS DISC SIGN CATPHAISTOS DISC SIGN RAMPHAISTOS D" +
	"ISC SIGN EAGLEPHAISTOS DISC SIGN DOVEPHAISTOS DISC SIGN TUNNYPHAISTOS DI" +
	"SC SIGN BEEPHAISTOS DISC SIGN PLANE TREEPHAISTOS DISC SIGN VINEPHAISTOS " +
	"DISC SIGN PAPYRUSPHAISTOS DISC SIGN ROSETTEPHAISTOS DISC SIGN LILYPHAIST" +
	"OS DISC SIGN OX BACKPHAISTOS DISC SIGN FLUTEPHAISTOS DISC SIGN GRATERPHA" +
	"ISTOS DISC SIGN STRAINERPHAISTOS DISC SIGN SMALL AXEPHAISTOS DISC SIGN W" +
	"AVY BANDPHAISTOS DISC SIGN COMBINING OBLIQUE STROKELYCIAN LETTER ALYCIAN" +
	" LETTER ELYCIAN LETTER BLYCIAN LETTER BHLYCIAN LETTER GLYCIAN LETTER DLY" +
	"CIAN LETTER ILYCIAN LETTER WLYCIAN LETTER ZLYCIAN LETTER THLYCIAN LETTER" +
	" JLYCIAN LETTER KLYCIAN LETTER QLYCIAN LETTER LLYCIAN LETTER MLYCIAN LET" +
	"TER NLYCIAN LETTER MMLYCIAN LETTER NNLYCIAN LETTER ULYCIAN LETTER PLYCIA") + ("" +
	"N LETTER KKLYCIAN LETTER RLYCIAN LETTER SLYCIAN LETTER TLYCIAN LETTER TT" +
	"LYCIAN LETTER ANLYCIAN LETTER ENLYCIAN LETTER HLYCIAN LETTER XCARIAN LET" +
	"TER ACARIAN LETTER P2CARIAN LETTER DCARIAN LETTER LCARIAN LETTER UUUCARI" +
	"AN LETTER RCARIAN LETTER LDCARIAN LETTER A2CARIAN LETTER QCARIAN LETTER " +
	"BCARIAN LETTER MCARIAN LETTER OCARIAN LETTER D2CARIAN LETTER TCARIAN LET" +
	"TER SHCARIAN LETTER SH2CARIAN LETTER SCARIAN LETTER C-18CARIAN LETTER UC" +
	"ARIAN LETTER NNCARIAN LETTER XCARIAN LETTER NCARIAN LETTER TT2CARIAN LET" +
	"TER PCARIAN LETTER SSCARIAN LETTER ICARIAN LETTER ECARIAN LETTER UUUUCAR" +
	"IAN LETTER KCARIAN LETTER K2CARIAN LETTER NDCARIAN LETTER UUCARIAN LETTE" +
	"R GCARIAN LETTER G2CARIAN LETTER STCARIAN LETTER ST2CARIAN LETTER NGCARI" +
	"AN LETTER IICARIAN LETTER C-39CARIAN LETTER TTCARIAN LETTER UUU2CARIAN L" +
	"ETTER RRCARIAN LETTER MBCARIAN LETTER MB2CARIAN LETTER MB3CARIAN LETTER " +
	"MB4CARIAN LETTER LD2CARIAN LETTER E2CARIAN LETTER UUU3COPTIC EPACT THOUS" +
	"ANDS MARKCOPTIC EPACT DIGIT ONECOPTIC EPACT DIGIT TWOCOPTIC EPACT DIGIT " +
	"THREECOPTIC EPACT DIGIT FOURCOPTIC EPACT DIGIT FIVECOPTIC EPACT DIGIT SI" +
	"XCOPTIC EPACT DIGIT SEVENCOPTIC EPACT DIGIT EIGHTCOPTIC EPACT DIGIT NINE" +
	"COPTIC EPACT NUMBER TENCOPTIC EPACT NUMBER TWENTYCOPTIC EPACT NUMBER THI" +
	"RTYCOPTIC EPACT NUMBER FORTYCOPTIC EPACT NUMBER FIFTYCOPTIC EPACT NUMBER" +
	" SIXTYCOPTIC EPACT NUMBER SEVENTYCOPTIC EPACT NUMBER EIGHTYCOPTIC EPACT " +
	"NUMBER NINETYCOPTIC EPACT NUMBER ONE HUNDREDCOPTIC EPACT NUMBER TWO HUND" +
	"REDCOPTIC EPACT NUMBER THREE HUNDREDCOPTIC EPACT NUMBER FOUR HUNDREDCOPT" +
	"IC EPACT NUMBER FIVE HUNDREDCOPTIC EPACT NUMBER SIX HUNDREDCOPTIC EPACT " +
	"NUMBER SEVEN HUNDREDCOPTIC EPACT NUMBER EIGHT HUNDREDCOPTIC EPACT NUMBER" +
	" NINE HUNDREDOLD ITALIC LETTER AOLD ITALIC LETTER BEOLD ITALIC LETTER KE" +
	"OLD ITALIC LETTER DEOLD ITALIC LETTER EOLD ITALIC LETTER VEOLD ITALIC LE" +
	"TTER ZEOLD ITALIC LETTER HEOLD ITALIC LETTER THEOLD ITALIC LETTER IOLD I" +
	"TALIC LETTER KAOLD ITALIC LETTER ELOLD ITALIC LETTER EMOLD ITALIC LETTER" +
	" ENOLD ITALIC LETTER ESHOLD ITALIC LETTER OOLD ITALIC LETTER PEOLD ITALI" +
	"C LETTER SHEOLD ITALIC LETTER KUOLD ITALIC LETTER EROLD ITALIC LETTER ES" +
	"OLD ITALIC LETTER TEOLD ITALIC LETTER UOLD ITALIC LETTER EKSOLD ITALIC L" +
	"ETTER PHEOLD ITALIC LETTER KHEOLD ITALIC LETTER EFOLD ITALIC LETTER ERSO" +
	"LD ITALIC LETTER CHEOLD ITALIC LETTER IIOLD ITALIC LETTER UUOLD ITALIC L" +
	"ETTER ESSOLD ITALIC NUMERAL ONEOLD ITALIC NUMERAL FIVEOLD ITALIC NUMERAL" +
	" TENOLD ITALIC NUMERAL FIFTYOLD ITALIC LETTER YEOLD ITALIC LETTER NORTHE" +
	"RN TSEOLD ITALIC LETTER SOUTHERN TSEGOTHIC LETTER AHSAGOTHIC LETTER BAIR" +
	"KANGOTHIC LETTER GIBAGOTHIC LETTER DAGSGOTHIC LETTER AIHVUSGOTHIC LETTER" +
	" QAIRTHRAGOTHIC LETTER IUJAGOTHIC LETTER HAGLGOTHIC LETTER THIUTHGOTHIC " +
	"LETTER EISGOTHIC LETTER KUSMAGOTHIC LETTER LAGUSGOTHIC LETTER MANNAGOTHI" +
	"C LETTER NAUTHSGOTHIC LETTER JERGOTHIC LETTER URUSGOTHIC LETTER PAIRTHRA" +
	"GOTHIC LETTER NINETYGOTHIC LETTER RAIDAGOTHIC LETTER SAUILGOTHIC LETTER " +
	"TEIWSGOTHIC LETTER WINJAGOTHIC LETTER FAIHUGOTHIC LETTER IGGWSGOTHIC LET" +
	"TER HWAIRGOTHIC LETTER OTHALGOTHIC LETTER NINE HUNDREDOLD PERMIC LETTER " +
	"ANOLD PERMIC LETTER BUROLD PERMIC LETTER GAIOLD PERMIC LETTER DOIOLD PER" +
	"MIC LETTER EOLD PERMIC LETTER ZHOIOLD PERMIC LETTER DZHOIOLD PERMIC LETT" +
	"ER ZATAOLD PERMIC LETTER DZITAOLD PERMIC LETTER IOLD PERMIC LETTER KOKEO" +
	"LD PERMIC LETTER LEIOLD PERMIC LETTER MENOEOLD PERMIC LETTER NENOEOLD PE" +
	"RMIC LETTER VOOIOLD PERMIC LETTER PEEIOLD PERMIC LETTER REIOLD PERMIC LE" +
	"TTER SIIOLD PERMIC LETTER TAIOLD PERMIC LETTER UOLD PERMIC LETTER CHERYO" +
	"LD PERMIC LETTER SHOOIOLD PERMIC LETTER SHCHOOIOLD PERMIC LETTER YRYOLD " +
	"PERMIC LETTER YERUOLD PERMIC LETTER OOLD PERMIC LETTER OOOLD PERMIC LETT" +
	"ER EFOLD PERMIC LETTER HAOLD PERMIC LETTER TSIUOLD PERMIC LETTER VEROLD " +
	"PERMIC LETTER YEROLD PERMIC LETTER YERIOLD PERMIC LETTER YATOLD PERMIC L" +
	"ETTER IEOLD PERMIC LETTER YUOLD PERMIC LETTER YAOLD PERMIC LETTER IACOMB" +
	"INING OLD PERMIC LETTER ANCOMBINING OLD PERMIC LETTER DOICOMBINING OLD P" +
	"ERMIC LETTER ZATACOMBINING OLD PERMIC LETTER NENOECOMBINING OLD PERMIC L" +
	"ETTER SIIUGARITIC LETTER ALPAUGARITIC LETTER BETAUGARITIC LETTER GAMLAUG" +
	"ARITIC LETTER KHAUGARITIC LETTER DELTAUGARITIC LETTER HOUGARITIC LETTER " +
	"WOUGARITIC LETTER ZETAUGARITIC LETTER HOTAUGARITIC LETTER TETUGARITIC LE" +
	"TTER YODUGARITIC LETTER KAFUGARITIC LETTER SHINUGARITIC LETTER LAMDAUGAR" +
	"ITIC LETTER MEMUGARITIC LETTER DHALUGARITIC LETTER NUNUGARITIC LETTER ZU" +
	"UGARITIC LETTER SAMKAUGARITIC LETTER AINUGARITIC LETTER PUUGARITIC LETTE" +
	"R SADEUGARITIC LETTER QOPAUGARITIC LETTER RASHAUGARITIC LETTER THANNAUGA" +
	"RITIC LETTER GHAINUGARITIC LETTER TOUGARITIC LETTER IUGARITIC LETTER UUG" +
	"ARITIC LETTER SSUUGARITIC WORD DIVIDEROLD PERSIAN SIGN AOLD PERSIAN SIGN") + ("" +
	" IOLD PERSIAN SIGN UOLD PERSIAN SIGN KAOLD PERSIAN SIGN KUOLD PERSIAN SI" +
	"GN GAOLD PERSIAN SIGN GUOLD PERSIAN SIGN XAOLD PERSIAN SIGN CAOLD PERSIA" +
	"N SIGN JAOLD PERSIAN SIGN JIOLD PERSIAN SIGN TAOLD PERSIAN SIGN TUOLD PE" +
	"RSIAN SIGN DAOLD PERSIAN SIGN DIOLD PERSIAN SIGN DUOLD PERSIAN SIGN THAO" +
	"LD PERSIAN SIGN PAOLD PERSIAN SIGN BAOLD PERSIAN SIGN FAOLD PERSIAN SIGN" +
	" NAOLD PERSIAN SIGN NUOLD PERSIAN SIGN MAOLD PERSIAN SIGN MIOLD PERSIAN " +
	"SIGN MUOLD PERSIAN SIGN YAOLD PERSIAN SIGN VAOLD PERSIAN SIGN VIOLD PERS" +
	"IAN SIGN RAOLD PERSIAN SIGN RUOLD PERSIAN SIGN LAOLD PERSIAN SIGN SAOLD " +
	"PERSIAN SIGN ZAOLD PERSIAN SIGN SHAOLD PERSIAN SIGN SSAOLD PERSIAN SIGN " +
	"HAOLD PERSIAN SIGN AURAMAZDAAOLD PERSIAN SIGN AURAMAZDAA-2OLD PERSIAN SI" +
	"GN AURAMAZDAAHAOLD PERSIAN SIGN XSHAAYATHIYAOLD PERSIAN SIGN DAHYAAUSHOL" +
	"D PERSIAN SIGN DAHYAAUSH-2OLD PERSIAN SIGN BAGAOLD PERSIAN SIGN BUUMISHO" +
	"LD PERSIAN WORD DIVIDEROLD PERSIAN NUMBER ONEOLD PERSIAN NUMBER TWOOLD P" +
	"ERSIAN NUMBER TENOLD PERSIAN NUMBER TWENTYOLD PERSIAN NUMBER HUNDREDDESE" +
	"RET CAPITAL LETTER LONG IDESERET CAPITAL LETTER LONG EDESERET CAPITAL LE" +
	"TTER LONG ADESERET CAPITAL LETTER LONG AHDESERET CAPITAL LETTER LONG ODE" +
	"SERET CAPITAL LETTER LONG OODESERET CAPITAL LETTER SHORT IDESERET CAPITA" +
	"L LETTER SHORT EDESERET CAPITAL LETTER SHORT ADESERET CAPITAL LETTER SHO" +
	"RT AHDESERET CAPITAL LETTER SHORT ODESERET CAPITAL LETTER SHORT OODESERE" +
	"T CAPITAL LETTER AYDESERET CAPITAL LETTER OWDESERET CAPITAL LETTER WUDES" +
	"ERET CAPITAL LETTER YEEDESERET CAPITAL LETTER HDESERET CAPITAL LETTER PE" +
	"EDESERET CAPITAL LETTER BEEDESERET CAPITAL LETTER TEEDESERET CAPITAL LET" +
	"TER DEEDESERET CAPITAL LETTER CHEEDESERET CAPITAL LETTER JEEDESERET CAPI" +
	"TAL LETTER KAYDESERET CAPITAL LETTER GAYDESERET CAPITAL LETTER EFDESERET" +
	" CAPITAL LETTER VEEDESERET CAPITAL LETTER ETHDESERET CAPITAL LETTER THEE" +
	"DESERET CAPITAL LETTER ESDESERET CAPITAL LETTER ZEEDESERET CAPITAL LETTE" +
	"R ESHDESERET CAPITAL LETTER ZHEEDESERET CAPITAL LETTER ERDESERET CAPITAL" +
	" LETTER ELDESERET CAPITAL LETTER EMDESERET CAPITAL LETTER ENDESERET CAPI" +
	"TAL LETTER ENGDESERET CAPITAL LETTER OIDESERET CAPITAL LETTER EWDESERET " +
	"SMALL LETTER LONG IDESERET SMALL LETTER LONG EDESERET SMALL LETTER LONG " +
	"ADESERET SMALL LETTER LONG AHDESERET SMALL LETTER LONG ODESERET SMALL LE" +
	"TTER LONG OODESERET SMALL LETTER SHORT IDESERET SMALL LETTER SHORT EDESE" +
	"RET SMALL LETTER SHORT ADESERET SMALL LETTER SHORT AHDESERET SMALL LETTE" +
	"R SHORT ODESERET SMALL LETTER SHORT OODESERET SMALL LETTER AYDESERET SMA" +
	"LL LETTER OWDESERET SMALL LETTER WUDESERET SMALL LETTER YEEDESERET SMALL" +
	" LETTER HDESERET SMALL LETTER PEEDESERET SMALL LETTER BEEDESERET SMALL L" +
	"ETTER TEEDESERET SMALL LETTER DEEDESERET SMALL LETTER CHEEDESERET SMALL " +
	"LETTER JEEDESERET SMALL LETTER KAYDESERET SMALL LETTER GAYDESERET SMALL " +
	"LETTER EFDESERET SMALL LETTER VEEDESERET SMALL LETTER ETHDESERET SMALL L" +
	"ETTER THEEDESERET SMALL LETTER ESDESERET SMALL LETTER ZEEDESERET SMALL L" +
	"ETTER ESHDESERET SMALL LETTER ZHEEDESERET SMALL LETTER ERDESERET SMALL L" +
	"ETTER ELDESERET SMALL LETTER EMDESERET SMALL LETTER ENDESERET SMALL LETT" +
	"ER ENGDESERET SMALL LETTER OIDESERET SMALL LETTER EWSHAVIAN LETTER PEEPS" +
	"HAVIAN LETTER TOTSHAVIAN LETTER KICKSHAVIAN LETTER FEESHAVIAN LETTER THI" +
	"GHSHAVIAN LETTER SOSHAVIAN LETTER SURESHAVIAN LETTER CHURCHSHAVIAN LETTE" +
	"R YEASHAVIAN LETTER HUNGSHAVIAN LETTER BIBSHAVIAN LETTER DEADSHAVIAN LET" +
	"TER GAGSHAVIAN LETTER VOWSHAVIAN LETTER THEYSHAVIAN LETTER ZOOSHAVIAN LE" +
	"TTER MEASURESHAVIAN LETTER JUDGESHAVIAN LETTER WOESHAVIAN LETTER HA-HASH" +
	"AVIAN LETTER LOLLSHAVIAN LETTER MIMESHAVIAN LETTER IFSHAVIAN LETTER EGGS" +
	"HAVIAN LETTER ASHSHAVIAN LETTER ADOSHAVIAN LETTER ONSHAVIAN LETTER WOOLS" +
	"HAVIAN LETTER OUTSHAVIAN LETTER AHSHAVIAN LETTER ROARSHAVIAN LETTER NUNS" +
	"HAVIAN LETTER EATSHAVIAN LETTER AGESHAVIAN LETTER ICESHAVIAN LETTER UPSH" +
	"AVIAN LETTER OAKSHAVIAN LETTER OOZESHAVIAN LETTER OILSHAVIAN LETTER AWES" +
	"HAVIAN LETTER ARESHAVIAN LETTER ORSHAVIAN LETTER AIRSHAVIAN LETTER ERRSH" +
	"AVIAN LETTER ARRAYSHAVIAN LETTER EARSHAVIAN LETTER IANSHAVIAN LETTER YEW" +
	"OSMANYA LETTER ALEFOSMANYA LETTER BAOSMANYA LETTER TAOSMANYA LETTER JAOS" +
	"MANYA LETTER XAOSMANYA LETTER KHAOSMANYA LETTER DEELOSMANYA LETTER RAOSM" +
	"ANYA LETTER SAOSMANYA LETTER SHIINOSMANYA LETTER DHAOSMANYA LETTER CAYNO" +
	"SMANYA LETTER GAOSMANYA LETTER FAOSMANYA LETTER QAAFOSMANYA LETTER KAAFO" +
	"SMANYA LETTER LAANOSMANYA LETTER MIINOSMANYA LETTER NUUNOSMANYA LETTER W" +
	"AWOSMANYA LETTER HAOSMANYA LETTER YAOSMANYA LETTER AOSMANYA LETTER EOSMA" +
	"NYA LETTER IOSMANYA LETTER OOSMANYA LETTER UOSMANYA LETTER AAOSMANYA LET" +
	"TER EEOSMANYA LETTER OOOSMANYA DIGIT ZEROOSMANYA DIGIT ONEOSMANYA DIGIT " +
	"TWOOSMANYA DIGIT THREEOSMANYA DIGIT FOUROSMANYA DIGIT FIVEOSMANYA DIGIT ") + ("" +
	"SIXOSMANYA DIGIT SEVENOSMANYA DIGIT EIGHTOSMANYA DIGIT NINEOSAGE CAPITAL" +
	" LETTER AOSAGE CAPITAL LETTER AIOSAGE CAPITAL LETTER AINOSAGE CAPITAL LE" +
	"TTER AHOSAGE CAPITAL LETTER BRAOSAGE CAPITAL LETTER CHAOSAGE CAPITAL LET" +
	"TER EHCHAOSAGE CAPITAL LETTER EOSAGE CAPITAL LETTER EINOSAGE CAPITAL LET" +
	"TER HAOSAGE CAPITAL LETTER HYAOSAGE CAPITAL LETTER IOSAGE CAPITAL LETTER" +
	" KAOSAGE CAPITAL LETTER EHKAOSAGE CAPITAL LETTER KYAOSAGE CAPITAL LETTER" +
	" LAOSAGE CAPITAL LETTER MAOSAGE CAPITAL LETTER NAOSAGE CAPITAL LETTER OO" +
	"SAGE CAPITAL LETTER OINOSAGE CAPITAL LETTER PAOSAGE CAPITAL LETTER EHPAO" +
	"SAGE CAPITAL LETTER SAOSAGE CAPITAL LETTER SHAOSAGE CAPITAL LETTER TAOSA" +
	"GE CAPITAL LETTER EHTAOSAGE CAPITAL LETTER TSAOSAGE CAPITAL LETTER EHTSA" +
	"OSAGE CAPITAL LETTER TSHAOSAGE CAPITAL LETTER DHAOSAGE CAPITAL LETTER UO" +
	"SAGE CAPITAL LETTER WAOSAGE CAPITAL LETTER KHAOSAGE CAPITAL LETTER GHAOS" +
	"AGE CAPITAL LETTER ZAOSAGE CAPITAL LETTER ZHAOSAGE SMALL LETTER AOSAGE S" +
	"MALL LETTER AIOSAGE SMALL LETTER AINOSAGE SMALL LETTER AHOSAGE SMALL LET" +
	"TER BRAOSAGE SMALL LETTER CHAOSAGE SMALL LETTER EHCHAOSAGE SMALL LETTER " +
	"EOSAGE SMALL LETTER EINOSAGE SMALL LETTER HAOSAGE SMALL LETTER HYAOSAGE " +
	"SMALL LETTER IOSAGE SMALL LETTER KAOSAGE SMALL LETTER EHKAOSAGE SMALL LE" +
	"TTER KYAOSAGE SMALL LETTER LAOSAGE SMALL LETTER MAOSAGE SMALL LETTER NAO" +
	"SAGE SMALL LETTER OOSAGE SMALL LETTER OINOSAGE SMALL LETTER PAOSAGE SMAL" +
	"L LETTER EHPAOSAGE SMALL LETTER SAOSAGE SMALL LETTER SHAOSAGE SMALL LETT" +
	"ER TAOSAGE SMALL LETTER EHTAOSAGE SMALL LETTER TSAOSAGE SMALL LETTER EHT" +
	"SAOSAGE SMALL LETTER TSHAOSAGE SMALL LETTER DHAOSAGE SMALL LETTER UOSAGE" +
	" SMALL LETTER WAOSAGE SMALL LETTER KHAOSAGE SMALL LETTER GHAOSAGE SMALL " +
	"LETTER ZAOSAGE SMALL LETTER ZHAELBASAN LETTER AELBASAN LETTER BEELBASAN " +
	"LETTER CEELBASAN LETTER CHEELBASAN LETTER DEELBASAN LETTER NDEELBASAN LE" +
	"TTER DHEELBASAN LETTER EIELBASAN LETTER EELBASAN LETTER FEELBASAN LETTER" +
	" GEELBASAN LETTER GJEELBASAN LETTER HEELBASAN LETTER IELBASAN LETTER JEE" +
	"LBASAN LETTER KEELBASAN LETTER LEELBASAN LETTER LLEELBASAN LETTER MEELBA" +
	"SAN LETTER NEELBASAN LETTER NAELBASAN LETTER NJEELBASAN LETTER OELBASAN " +
	"LETTER PEELBASAN LETTER QEELBASAN LETTER REELBASAN LETTER RREELBASAN LET" +
	"TER SEELBASAN LETTER SHEELBASAN LETTER TEELBASAN LETTER THEELBASAN LETTE" +
	"R UELBASAN LETTER VEELBASAN LETTER XEELBASAN LETTER YELBASAN LETTER ZEEL" +
	"BASAN LETTER ZHEELBASAN LETTER GHEELBASAN LETTER GHAMMAELBASAN LETTER KH" +
	"ECAUCASIAN ALBANIAN LETTER ALTCAUCASIAN ALBANIAN LETTER BETCAUCASIAN ALB" +
	"ANIAN LETTER GIMCAUCASIAN ALBANIAN LETTER DATCAUCASIAN ALBANIAN LETTER E" +
	"BCAUCASIAN ALBANIAN LETTER ZARLCAUCASIAN ALBANIAN LETTER EYNCAUCASIAN AL" +
	"BANIAN LETTER ZHILCAUCASIAN ALBANIAN LETTER TASCAUCASIAN ALBANIAN LETTER" +
	" CHACAUCASIAN ALBANIAN LETTER YOWDCAUCASIAN ALBANIAN LETTER ZHACAUCASIAN" +
	" ALBANIAN LETTER IRBCAUCASIAN ALBANIAN LETTER SHACAUCASIAN ALBANIAN LETT" +
	"ER LANCAUCASIAN ALBANIAN LETTER INYACAUCASIAN ALBANIAN LETTER XEYNCAUCAS" +
	"IAN ALBANIAN LETTER DYANCAUCASIAN ALBANIAN LETTER CARCAUCASIAN ALBANIAN " +
	"LETTER JHOXCAUCASIAN ALBANIAN LETTER KARCAUCASIAN ALBANIAN LETTER LYITCA" +
	"UCASIAN ALBANIAN LETTER HEYTCAUCASIAN ALBANIAN LETTER QAYCAUCASIAN ALBAN" +
	"IAN LETTER AORCAUCASIAN ALBANIAN LETTER CHOYCAUCASIAN ALBANIAN LETTER CH" +
	"ICAUCASIAN ALBANIAN LETTER CYAYCAUCASIAN ALBANIAN LETTER MAQCAUCASIAN AL" +
	"BANIAN LETTER QARCAUCASIAN ALBANIAN LETTER NOWCCAUCASIAN ALBANIAN LETTER" +
	" DZYAYCAUCASIAN ALBANIAN LETTER SHAKCAUCASIAN ALBANIAN LETTER JAYNCAUCAS" +
	"IAN ALBANIAN LETTER ONCAUCASIAN ALBANIAN LETTER TYAYCAUCASIAN ALBANIAN L" +
	"ETTER FAMCAUCASIAN ALBANIAN LETTER DZAYCAUCASIAN ALBANIAN LETTER CHATCAU" +
	"CASIAN ALBANIAN LETTER PENCAUCASIAN ALBANIAN LETTER GHEYSCAUCASIAN ALBAN" +
	"IAN LETTER RATCAUCASIAN ALBANIAN LETTER SEYKCAUCASIAN ALBANIAN LETTER VE" +
	"YZCAUCASIAN ALBANIAN LETTER TIWRCAUCASIAN ALBANIAN LETTER SHOYCAUCASIAN " +
	"ALBANIAN LETTER IWNCAUCASIAN ALBANIAN LETTER CYAWCAUCASIAN ALBANIAN LETT" +
	"ER CAYNCAUCASIAN ALBANIAN LETTER YAYDCAUCASIAN ALBANIAN LETTER PIWRCAUCA" +
	"SIAN ALBANIAN LETTER KIWCAUCASIAN ALBANIAN CITATION MARKLINEAR A SIGN AB" +
	"001LINEAR A SIGN AB002LINEAR A SIGN AB003LINEAR A SIGN AB004LINEAR A SIG" +
	"N AB005LINEAR A SIGN AB006LINEAR A SIGN AB007LINEAR A SIGN AB008LINEAR A" +
	" SIGN AB009LINEAR A SIGN AB010LINEAR A SIGN AB011LINEAR A SIGN AB013LINE" +
	"AR A SIGN AB016LINEAR A SIGN AB017LINEAR A SIGN AB020LINEAR A SIGN AB021" +
	"LINEAR A SIGN AB021FLINEAR A SIGN AB021MLINEAR A SIGN AB022LINEAR A SIGN" +
	" AB022FLINEAR A SIGN AB022MLINEAR A SIGN AB023LINEAR A SIGN AB023MLINEAR" +
	" A SIGN AB024LINEAR A SIGN AB026LINEAR A SIGN AB027LINEAR A SIGN AB028LI" +
	"NEAR A SIGN A028BLINEAR A SIGN AB029LINEAR A SIGN AB030LINEAR A SIGN AB0" +
	"31LINEAR A SIGN AB034LINEAR A SIGN AB037LINEAR A SIGN AB038LINEAR A SIGN") + ("" +
	" AB039LINEAR A SIGN AB040LINEAR A SIGN AB041LINEAR A SIGN AB044LINEAR A " +
	"SIGN AB045LINEAR A SIGN AB046LINEAR A SIGN AB047LINEAR A SIGN AB048LINEA" +
	"R A SIGN AB049LINEAR A SIGN AB050LINEAR A SIGN AB051LINEAR A SIGN AB053L" +
	"INEAR A SIGN AB054LINEAR A SIGN AB055LINEAR A SIGN AB056LINEAR A SIGN AB" +
	"057LINEAR A SIGN AB058LINEAR A SIGN AB059LINEAR A SIGN AB060LINEAR A SIG" +
	"N AB061LINEAR A SIGN AB065LINEAR A SIGN AB066LINEAR A SIGN AB067LINEAR A" +
	" SIGN AB069LINEAR A SIGN AB070LINEAR A SIGN AB073LINEAR A SIGN AB074LINE" +
	"AR A SIGN AB076LINEAR A SIGN AB077LINEAR A SIGN AB078LINEAR A SIGN AB079" +
	"LINEAR A SIGN AB080LINEAR A SIGN AB081LINEAR A SIGN AB082LINEAR A SIGN A" +
	"B085LINEAR A SIGN AB086LINEAR A SIGN AB087LINEAR A SIGN A100-102LINEAR A" +
	" SIGN AB118LINEAR A SIGN AB120LINEAR A SIGN A120BLINEAR A SIGN AB122LINE" +
	"AR A SIGN AB123LINEAR A SIGN AB131ALINEAR A SIGN AB131BLINEAR A SIGN A13" +
	"1CLINEAR A SIGN AB164LINEAR A SIGN AB171LINEAR A SIGN AB180LINEAR A SIGN" +
	" AB188LINEAR A SIGN AB191LINEAR A SIGN A301LINEAR A SIGN A302LINEAR A SI" +
	"GN A303LINEAR A SIGN A304LINEAR A SIGN A305LINEAR A SIGN A306LINEAR A SI" +
	"GN A307LINEAR A SIGN A308LINEAR A SIGN A309ALINEAR A SIGN A309BLINEAR A " +
	"SIGN A309CLINEAR A SIGN A310LINEAR A SIGN A311LINEAR A SIGN A312LINEAR A" +
	" SIGN A313ALINEAR A SIGN A313BLINEAR A SIGN A313CLINEAR A SIGN A314LINEA" +
	"R A SIGN A315LINEAR A SIGN A316LINEAR A SIGN A317LINEAR A SIGN A318LINEA" +
	"R A SIGN A319LINEAR A SIGN A320LINEAR A SIGN A321LINEAR A SIGN A322LINEA" +
	"R A SIGN A323LINEAR A SIGN A324LINEAR A SIGN A325LINEAR A SIGN A326LINEA" +
	"R A SIGN A327LINEAR A SIGN A328LINEAR A SIGN A329LINEAR A SIGN A330LINEA" +
	"R A SIGN A331LINEAR A SIGN A332LINEAR A SIGN A333LINEAR A SIGN A334LINEA" +
	"R A SIGN A335LINEAR A SIGN A336LINEAR A SIGN A337LINEAR A SIGN A338LINEA" +
	"R A SIGN A339LINEAR A SIGN A340LINEAR A SIGN A341LINEAR A SIGN A342LINEA" +
	"R A SIGN A343LINEAR A SIGN A344LINEAR A SIGN A345LINEAR A SIGN A346LINEA" +
	"R A SIGN A347LINEAR A SIGN A348LINEAR A SIGN A349LINEAR A SIGN A350LINEA" +
	"R A SIGN A351LINEAR A SIGN A352LINEAR A SIGN A353LINEAR A SIGN A354LINEA" +
	"R A SIGN A355LINEAR A SIGN A356LINEAR A SIGN A357LINEAR A SIGN A358LINEA" +
	"R A SIGN A359LINEAR A SIGN A360LINEAR A SIGN A361LINEAR A SIGN A362LINEA" +
	"R A SIGN A363LINEAR A SIGN A364LINEAR A SIGN A365LINEAR A SIGN A366LINEA" +
	"R A SIGN A367LINEAR A SIGN A368LINEAR A SIGN A369LINEAR A SIGN A370LINEA" +
	"R A SIGN A371LINEAR A SIGN A400-VASLINEAR A SIGN A401-VASLINEAR A SIGN A" +
	"402-VASLINEAR A SIGN A403-VASLINEAR A SIGN A404-VASLINEAR A SIGN A405-VA" +
	"SLINEAR A SIGN A406-VASLINEAR A SIGN A407-VASLINEAR A SIGN A408-VASLINEA" +
	"R A SIGN A409-VASLINEAR A SIGN A410-VASLINEAR A SIGN A411-VASLINEAR A SI" +
	"GN A412-VASLINEAR A SIGN A413-VASLINEAR A SIGN A414-VASLINEAR A SIGN A41" +
	"5-VASLINEAR A SIGN A416-VASLINEAR A SIGN A417-VASLINEAR A SIGN A418-VASL" +
	"INEAR A SIGN A501LINEAR A SIGN A502LINEAR A SIGN A503LINEAR A SIGN A504L" +
	"INEAR A SIGN A505LINEAR A SIGN A506LINEAR A SIGN A508LINEAR A SIGN A509L" +
	"INEAR A SIGN A510LINEAR A SIGN A511LINEAR A SIGN A512LINEAR A SIGN A513L" +
	"INEAR A SIGN A515LINEAR A SIGN A516LINEAR A SIGN A520LINEAR A SIGN A521L" +
	"INEAR A SIGN A523LINEAR A SIGN A524LINEAR A SIGN A525LINEAR A SIGN A526L" +
	"INEAR A SIGN A527LINEAR A SIGN A528LINEAR A SIGN A529LINEAR A SIGN A530L" +
	"INEAR A SIGN A531LINEAR A SIGN A532LINEAR A SIGN A534LINEAR A SIGN A535L" +
	"INEAR A SIGN A536LINEAR A SIGN A537LINEAR A SIGN A538LINEAR A SIGN A539L" +
	"INEAR A SIGN A540LINEAR A SIGN A541LINEAR A SIGN A542LINEAR A SIGN A545L" +
	"INEAR A SIGN A547LINEAR A SIGN A548LINEAR A SIGN A549LINEAR A SIGN A550L" +
	"INEAR A SIGN A551LINEAR A SIGN A552LINEAR A SIGN A553LINEAR A SIGN A554L" +
	"INEAR A SIGN A555LINEAR A SIGN A556LINEAR A SIGN A557LINEAR A SIGN A559L" +
	"INEAR A SIGN A563LINEAR A SIGN A564LINEAR A SIGN A565LINEAR A SIGN A566L" +
	"INEAR A SIGN A568LINEAR A SIGN A569LINEAR A SIGN A570LINEAR A SIGN A571L" +
	"INEAR A SIGN A572LINEAR A SIGN A573LINEAR A SIGN A574LINEAR A SIGN A575L" +
	"INEAR A SIGN A576LINEAR A SIGN A577LINEAR A SIGN A578LINEAR A SIGN A579L" +
	"INEAR A SIGN A580LINEAR A SIGN A581LINEAR A SIGN A582LINEAR A SIGN A583L" +
	"INEAR A SIGN A584LINEAR A SIGN A585LINEAR A SIGN A586LINEAR A SIGN A587L" +
	"INEAR A SIGN A588LINEAR A SIGN A589LINEAR A SIGN A591LINEAR A SIGN A592L" +
	"INEAR A SIGN A594LINEAR A SIGN A595LINEAR A SIGN A596LINEAR A SIGN A598L" +
	"INEAR A SIGN A600LINEAR A SIGN A601LINEAR A SIGN A602LINEAR A SIGN A603L" +
	"INEAR A SIGN A604LINEAR A SIGN A606LINEAR A SIGN A608LINEAR A SIGN A609L" +
	"INEAR A SIGN A610LINEAR A SIGN A611LINEAR A SIGN A612LINEAR A SIGN A613L" +
	"INEAR A SIGN A614LINEAR A SIGN A615LINEAR A SIGN A616LINEAR A SIGN A617L" +
	"INEAR A SIGN A618LINEAR A SIGN A619LINEAR A SIGN A620LINEAR A SIGN A621L" +
	"INEAR A SIGN A622LINEAR A SIGN A623LINEAR A SIGN A624LINEAR A SIGN A626L") + ("" +
	"INEAR A SIGN A627LINEAR A SIGN A628LINEAR A SIGN A629LINEAR A SIGN A634L" +
	"INEAR A SIGN A637LINEAR A SIGN A638LINEAR A SIGN A640LINEAR A SIGN A642L" +
	"INEAR A SIGN A643LINEAR A SIGN A644LINEAR A SIGN A645LINEAR A SIGN A646L" +
	"INEAR A SIGN A648LINEAR A SIGN A649LINEAR A SIGN A651LINEAR A SIGN A652L" +
	"INEAR A SIGN A653LINEAR A SIGN A654LINEAR A SIGN A655LINEAR A SIGN A656L" +
	"INEAR A SIGN A657LINEAR A SIGN A658LINEAR A SIGN A659LINEAR A SIGN A660L" +
	"INEAR A SIGN A661LINEAR A SIGN A662LINEAR A SIGN A663LINEAR A SIGN A664L" +
	"INEAR A SIGN A701 ALINEAR A SIGN A702 BLINEAR A SIGN A703 DLINEAR A SIGN" +
	" A704 ELINEAR A SIGN A705 FLINEAR A SIGN A706 HLINEAR A SIGN A707 JLINEA" +
	"R A SIGN A708 KLINEAR A SIGN A709 LLINEAR A SIGN A709-2 L2LINEAR A SIGN " +
	"A709-3 L3LINEAR A SIGN A709-4 L4LINEAR A SIGN A709-6 L6LINEAR A SIGN A71" +
	"0 WLINEAR A SIGN A711 XLINEAR A SIGN A712 YLINEAR A SIGN A713 OMEGALINEA" +
	"R A SIGN A714 ABBLINEAR A SIGN A715 BBLINEAR A SIGN A717 DDLINEAR A SIGN" +
	" A726 EYYYLINEAR A SIGN A732 JELINEAR A SIGN A800LINEAR A SIGN A801LINEA" +
	"R A SIGN A802LINEAR A SIGN A803LINEAR A SIGN A804LINEAR A SIGN A805LINEA" +
	"R A SIGN A806LINEAR A SIGN A807CYPRIOT SYLLABLE ACYPRIOT SYLLABLE ECYPRI" +
	"OT SYLLABLE ICYPRIOT SYLLABLE OCYPRIOT SYLLABLE UCYPRIOT SYLLABLE JACYPR" +
	"IOT SYLLABLE JOCYPRIOT SYLLABLE KACYPRIOT SYLLABLE KECYPRIOT SYLLABLE KI" +
	"CYPRIOT SYLLABLE KOCYPRIOT SYLLABLE KUCYPRIOT SYLLABLE LACYPRIOT SYLLABL" +
	"E LECYPRIOT SYLLABLE LICYPRIOT SYLLABLE LOCYPRIOT SYLLABLE LUCYPRIOT SYL" +
	"LABLE MACYPRIOT SYLLABLE MECYPRIOT SYLLABLE MICYPRIOT SYLLABLE MOCYPRIOT" +
	" SYLLABLE MUCYPRIOT SYLLABLE NACYPRIOT SYLLABLE NECYPRIOT SYLLABLE NICYP" +
	"RIOT SYLLABLE NOCYPRIOT SYLLABLE NUCYPRIOT SYLLABLE PACYPRIOT SYLLABLE P" +
	"ECYPRIOT SYLLABLE PICYPRIOT SYLLABLE POCYPRIOT SYLLABLE PUCYPRIOT SYLLAB" +
	"LE RACYPRIOT SYLLABLE RECYPRIOT SYLLABLE RICYPRIOT SYLLABLE ROCYPRIOT SY" +
	"LLABLE RUCYPRIOT SYLLABLE SACYPRIOT SYLLABLE SECYPRIOT SYLLABLE SICYPRIO" +
	"T SYLLABLE SOCYPRIOT SYLLABLE SUCYPRIOT SYLLABLE TACYPRIOT SYLLABLE TECY" +
	"PRIOT SYLLABLE TICYPRIOT SYLLABLE TOCYPRIOT SYLLABLE TUCYPRIOT SYLLABLE " +
	"WACYPRIOT SYLLABLE WECYPRIOT SYLLABLE WICYPRIOT SYLLABLE WOCYPRIOT SYLLA" +
	"BLE XACYPRIOT SYLLABLE XECYPRIOT SYLLABLE ZACYPRIOT SYLLABLE ZOIMPERIAL " +
	"ARAMAIC LETTER ALEPHIMPERIAL ARAMAIC LETTER BETHIMPERIAL ARAMAIC LETTER " +
	"GIMELIMPERIAL ARAMAIC LETTER DALETHIMPERIAL ARAMAIC LETTER HEIMPERIAL AR" +
	"AMAIC LETTER WAWIMPERIAL ARAMAIC LETTER ZAYINIMPERIAL ARAMAIC LETTER HET" +
	"HIMPERIAL ARAMAIC LETTER TETHIMPERIAL ARAMAIC LETTER YODHIMPERIAL ARAMAI" +
	"C LETTER KAPHIMPERIAL ARAMAIC LETTER LAMEDHIMPERIAL ARAMAIC LETTER MEMIM" +
	"PERIAL ARAMAIC LETTER NUNIMPERIAL ARAMAIC LETTER SAMEKHIMPERIAL ARAMAIC " +
	"LETTER AYINIMPERIAL ARAMAIC LETTER PEIMPERIAL ARAMAIC LETTER SADHEIMPERI" +
	"AL ARAMAIC LETTER QOPHIMPERIAL ARAMAIC LETTER RESHIMPERIAL ARAMAIC LETTE" +
	"R SHINIMPERIAL ARAMAIC LETTER TAWIMPERIAL ARAMAIC SECTION SIGNIMPERIAL A" +
	"RAMAIC NUMBER ONEIMPERIAL ARAMAIC NUMBER TWOIMPERIAL ARAMAIC NUMBER THRE" +
	"EIMPERIAL ARAMAIC NUMBER TENIMPERIAL ARAMAIC NUMBER TWENTYIMPERIAL ARAMA" +
	"IC NUMBER ONE HUNDREDIMPERIAL ARAMAIC NUMBER ONE THOUSANDIMPERIAL ARAMAI" +
	"C NUMBER TEN THOUSANDPALMYRENE LETTER ALEPHPALMYRENE LETTER BETHPALMYREN" +
	"E LETTER GIMELPALMYRENE LETTER DALETHPALMYRENE LETTER HEPALMYRENE LETTER" +
	" WAWPALMYRENE LETTER ZAYINPALMYRENE LETTER HETHPALMYRENE LETTER TETHPALM" +
	"YRENE LETTER YODHPALMYRENE LETTER KAPHPALMYRENE LETTER LAMEDHPALMYRENE L" +
	"ETTER MEMPALMYRENE LETTER FINAL NUNPALMYRENE LETTER NUNPALMYRENE LETTER " +
	"SAMEKHPALMYRENE LETTER AYINPALMYRENE LETTER PEPALMYRENE LETTER SADHEPALM" +
	"YRENE LETTER QOPHPALMYRENE LETTER RESHPALMYRENE LETTER SHINPALMYRENE LET" +
	"TER TAWPALMYRENE LEFT-POINTING FLEURONPALMYRENE RIGHT-POINTING FLEURONPA" +
	"LMYRENE NUMBER ONEPALMYRENE NUMBER TWOPALMYRENE NUMBER THREEPALMYRENE NU" +
	"MBER FOURPALMYRENE NUMBER FIVEPALMYRENE NUMBER TENPALMYRENE NUMBER TWENT" +
	"YNABATAEAN LETTER FINAL ALEPHNABATAEAN LETTER ALEPHNABATAEAN LETTER FINA" +
	"L BETHNABATAEAN LETTER BETHNABATAEAN LETTER GIMELNABATAEAN LETTER DALETH" +
	"NABATAEAN LETTER FINAL HENABATAEAN LETTER HENABATAEAN LETTER WAWNABATAEA" +
	"N LETTER ZAYINNABATAEAN LETTER HETHNABATAEAN LETTER TETHNABATAEAN LETTER" +
	" FINAL YODHNABATAEAN LETTER YODHNABATAEAN LETTER FINAL KAPHNABATAEAN LET" +
	"TER KAPHNABATAEAN LETTER FINAL LAMEDHNABATAEAN LETTER LAMEDHNABATAEAN LE" +
	"TTER FINAL MEMNABATAEAN LETTER MEMNABATAEAN LETTER FINAL NUNNABATAEAN LE" +
	"TTER NUNNABATAEAN LETTER SAMEKHNABATAEAN LETTER AYINNABATAEAN LETTER PEN" +
	"ABATAEAN LETTER SADHENABATAEAN LETTER QOPHNABATAEAN LETTER RESHNABATAEAN" +
	" LETTER FINAL SHINNABATAEAN LETTER SHINNABATAEAN LETTER TAWNABATAEAN NUM" +
	"BER ONENABATAEAN NUMBER TWONABATAEAN NUMBER THREENABATAEAN NUMBER FOURNA" +
	"BATAEAN CRUCIFORM NUMBER FOURNABATAEAN NUMBER FIVENABATAEAN NUMBER TENNA") + ("" +
	"BATAEAN NUMBER TWENTYNABATAEAN NUMBER ONE HUNDREDHATRAN LETTER ALEPHHATR" +
	"AN LETTER BETHHATRAN LETTER GIMELHATRAN LETTER DALETH-RESHHATRAN LETTER " +
	"HEHATRAN LETTER WAWHATRAN LETTER ZAYNHATRAN LETTER HETHHATRAN LETTER TET" +
	"HHATRAN LETTER YODHHATRAN LETTER KAPHHATRAN LETTER LAMEDHHATRAN LETTER M" +
	"EMHATRAN LETTER NUNHATRAN LETTER SAMEKHHATRAN LETTER AYNHATRAN LETTER PE" +
	"HATRAN LETTER SADHEHATRAN LETTER QOPHHATRAN LETTER SHINHATRAN LETTER TAW" +
	"HATRAN NUMBER ONEHATRAN NUMBER FIVEHATRAN NUMBER TENHATRAN NUMBER TWENTY" +
	"HATRAN NUMBER ONE HUNDREDPHOENICIAN LETTER ALFPHOENICIAN LETTER BETPHOEN" +
	"ICIAN LETTER GAMLPHOENICIAN LETTER DELTPHOENICIAN LETTER HEPHOENICIAN LE" +
	"TTER WAUPHOENICIAN LETTER ZAIPHOENICIAN LETTER HETPHOENICIAN LETTER TETP" +
	"HOENICIAN LETTER YODPHOENICIAN LETTER KAFPHOENICIAN LETTER LAMDPHOENICIA" +
	"N LETTER MEMPHOENICIAN LETTER NUNPHOENICIAN LETTER SEMKPHOENICIAN LETTER" +
	" AINPHOENICIAN LETTER PEPHOENICIAN LETTER SADEPHOENICIAN LETTER QOFPHOEN" +
	"ICIAN LETTER ROSHPHOENICIAN LETTER SHINPHOENICIAN LETTER TAUPHOENICIAN N" +
	"UMBER ONEPHOENICIAN NUMBER TENPHOENICIAN NUMBER TWENTYPHOENICIAN NUMBER " +
	"ONE HUNDREDPHOENICIAN NUMBER TWOPHOENICIAN NUMBER THREEPHOENICIAN WORD S" +
	"EPARATORLYDIAN LETTER ALYDIAN LETTER BLYDIAN LETTER GLYDIAN LETTER DLYDI" +
	"AN LETTER ELYDIAN LETTER VLYDIAN LETTER ILYDIAN LETTER YLYDIAN LETTER KL" +
	"YDIAN LETTER LLYDIAN LETTER MLYDIAN LETTER NLYDIAN LETTER OLYDIAN LETTER" +
	" RLYDIAN LETTER SSLYDIAN LETTER TLYDIAN LETTER ULYDIAN LETTER FLYDIAN LE" +
	"TTER QLYDIAN LETTER SLYDIAN LETTER TTLYDIAN LETTER ANLYDIAN LETTER ENLYD" +
	"IAN LETTER LYLYDIAN LETTER NNLYDIAN LETTER CLYDIAN TRIANGULAR MARKMEROIT" +
	"IC HIEROGLYPHIC LETTER AMEROITIC HIEROGLYPHIC LETTER EMEROITIC HIEROGLYP" +
	"HIC LETTER IMEROITIC HIEROGLYPHIC LETTER OMEROITIC HIEROGLYPHIC LETTER Y" +
	"AMEROITIC HIEROGLYPHIC LETTER WAMEROITIC HIEROGLYPHIC LETTER BAMEROITIC " +
	"HIEROGLYPHIC LETTER BA-2MEROITIC HIEROGLYPHIC LETTER PAMEROITIC HIEROGLY" +
	"PHIC LETTER MAMEROITIC HIEROGLYPHIC LETTER NAMEROITIC HIEROGLYPHIC LETTE" +
	"R NA-2MEROITIC HIEROGLYPHIC LETTER NEMEROITIC HIEROGLYPHIC LETTER NE-2ME" +
	"ROITIC HIEROGLYPHIC LETTER RAMEROITIC HIEROGLYPHIC LETTER RA-2MEROITIC H" +
	"IEROGLYPHIC LETTER LAMEROITIC HIEROGLYPHIC LETTER KHAMEROITIC HIEROGLYPH" +
	"IC LETTER HHAMEROITIC HIEROGLYPHIC LETTER SAMEROITIC HIEROGLYPHIC LETTER" +
	" SA-2MEROITIC HIEROGLYPHIC LETTER SEMEROITIC HIEROGLYPHIC LETTER KAMEROI" +
	"TIC HIEROGLYPHIC LETTER QAMEROITIC HIEROGLYPHIC LETTER TAMEROITIC HIEROG" +
	"LYPHIC LETTER TA-2MEROITIC HIEROGLYPHIC LETTER TEMEROITIC HIEROGLYPHIC L" +
	"ETTER TE-2MEROITIC HIEROGLYPHIC LETTER TOMEROITIC HIEROGLYPHIC LETTER DA" +
	"MEROITIC HIEROGLYPHIC SYMBOL VIDJMEROITIC HIEROGLYPHIC SYMBOL VIDJ-2MERO" +
	"ITIC CURSIVE LETTER AMEROITIC CURSIVE LETTER EMEROITIC CURSIVE LETTER IM" +
	"EROITIC CURSIVE LETTER OMEROITIC CURSIVE LETTER YAMEROITIC CURSIVE LETTE" +
	"R WAMEROITIC CURSIVE LETTER BAMEROITIC CURSIVE LETTER PAMEROITIC CURSIVE" +
	" LETTER MAMEROITIC CURSIVE LETTER NAMEROITIC CURSIVE LETTER NEMEROITIC C" +
	"URSIVE LETTER RAMEROITIC CURSIVE LETTER LAMEROITIC CURSIVE LETTER KHAMER" +
	"OITIC CURSIVE LETTER HHAMEROITIC CURSIVE LETTER SAMEROITIC CURSIVE LETTE" +
	"R ARCHAIC SAMEROITIC CURSIVE LETTER SEMEROITIC CURSIVE LETTER KAMEROITIC" +
	" CURSIVE LETTER QAMEROITIC CURSIVE LETTER TAMEROITIC CURSIVE LETTER TEME" +
	"ROITIC CURSIVE LETTER TOMEROITIC CURSIVE LETTER DAMEROITIC CURSIVE FRACT" +
	"ION ELEVEN TWELFTHSMEROITIC CURSIVE FRACTION ONE HALFMEROITIC CURSIVE LO" +
	"GOGRAM RMTMEROITIC CURSIVE LOGOGRAM IMNMEROITIC CURSIVE NUMBER ONEMEROIT" +
	"IC CURSIVE NUMBER TWOMEROITIC CURSIVE NUMBER THREEMEROITIC CURSIVE NUMBE" +
	"R FOURMEROITIC CURSIVE NUMBER FIVEMEROITIC CURSIVE NUMBER SIXMEROITIC CU" +
	"RSIVE NUMBER SEVENMEROITIC CURSIVE NUMBER EIGHTMEROITIC CURSIVE NUMBER N" +
	"INEMEROITIC CURSIVE NUMBER TENMEROITIC CURSIVE NUMBER TWENTYMEROITIC CUR" +
	"SIVE NUMBER THIRTYMEROITIC CURSIVE NUMBER FORTYMEROITIC CURSIVE NUMBER F" +
	"IFTYMEROITIC CURSIVE NUMBER SIXTYMEROITIC CURSIVE NUMBER SEVENTYMEROITIC" +
	" CURSIVE NUMBER ONE HUNDREDMEROITIC CURSIVE NUMBER TWO HUNDREDMEROITIC C" +
	"URSIVE NUMBER THREE HUNDREDMEROITIC CURSIVE NUMBER FOUR HUNDREDMEROITIC " +
	"CURSIVE NUMBER FIVE HUNDREDMEROITIC CURSIVE NUMBER SIX HUNDREDMEROITIC C" +
	"URSIVE NUMBER SEVEN HUNDREDMEROITIC CURSIVE NUMBER EIGHT HUNDREDMEROITIC" +
	" CURSIVE NUMBER NINE HUNDREDMEROITIC CURSIVE NUMBER ONE THOUSANDMEROITIC" +
	" CURSIVE NUMBER TWO THOUSANDMEROITIC CURSIVE NUMBER THREE THOUSANDMEROIT" +
	"IC CURSIVE NUMBER FOUR THOUSANDMEROITIC CURSIVE NUMBER FIVE THOUSANDMERO" +
	"ITIC CURSIVE NUMBER SIX THOUSANDMEROITIC CURSIVE NUMBER SEVEN THOUSANDME" +
	"ROITIC CURSIVE NUMBER EIGHT THOUSANDMEROITIC CURSIVE NUMBER NINE THOUSAN" +
	"DMEROITIC CURSIVE NUMBER TEN THOUSANDMEROITIC CURSIVE NUMBER TWENTY THOU" +
	"SANDMEROITIC CURSIVE NUMBER THIRTY THOUSANDMEROITIC CURSIVE NUMBER FORTY") + ("" +
	" THOUSANDMEROITIC CURSIVE NUMBER FIFTY THOUSANDMEROITIC CURSIVE NUMBER S" +
	"IXTY THOUSANDMEROITIC CURSIVE NUMBER SEVENTY THOUSANDMEROITIC CURSIVE NU" +
	"MBER EIGHTY THOUSANDMEROITIC CURSIVE NUMBER NINETY THOUSANDMEROITIC CURS" +
	"IVE NUMBER ONE HUNDRED THOUSANDMEROITIC CURSIVE NUMBER TWO HUNDRED THOUS" +
	"ANDMEROITIC CURSIVE NUMBER THREE HUNDRED THOUSANDMEROITIC CURSIVE NUMBER" +
	" FOUR HUNDRED THOUSANDMEROITIC CURSIVE NUMBER FIVE HUNDRED THOUSANDMEROI" +
	"TIC CURSIVE NUMBER SIX HUNDRED THOUSANDMEROITIC CURSIVE NUMBER SEVEN HUN" +
	"DRED THOUSANDMEROITIC CURSIVE NUMBER EIGHT HUNDRED THOUSANDMEROITIC CURS" +
	"IVE NUMBER NINE HUNDRED THOUSANDMEROITIC CURSIVE FRACTION ONE TWELFTHMER" +
	"OITIC CURSIVE FRACTION TWO TWELFTHSMEROITIC CURSIVE FRACTION THREE TWELF" +
	"THSMEROITIC CURSIVE FRACTION FOUR TWELFTHSMEROITIC CURSIVE FRACTION FIVE" +
	" TWELFTHSMEROITIC CURSIVE FRACTION SIX TWELFTHSMEROITIC CURSIVE FRACTION" +
	" SEVEN TWELFTHSMEROITIC CURSIVE FRACTION EIGHT TWELFTHSMEROITIC CURSIVE " +
	"FRACTION NINE TWELFTHSMEROITIC CURSIVE FRACTION TEN TWELFTHSKHAROSHTHI L" +
	"ETTER AKHAROSHTHI VOWEL SIGN IKHAROSHTHI VOWEL SIGN UKHAROSHTHI VOWEL SI" +
	"GN VOCALIC RKHAROSHTHI VOWEL SIGN EKHAROSHTHI VOWEL SIGN OKHAROSHTHI VOW" +
	"EL LENGTH MARKKHAROSHTHI SIGN DOUBLE RING BELOWKHAROSHTHI SIGN ANUSVARAK" +
	"HAROSHTHI SIGN VISARGAKHAROSHTHI LETTER KAKHAROSHTHI LETTER KHAKHAROSHTH" +
	"I LETTER GAKHAROSHTHI LETTER GHAKHAROSHTHI LETTER CAKHAROSHTHI LETTER CH" +
	"AKHAROSHTHI LETTER JAKHAROSHTHI LETTER NYAKHAROSHTHI LETTER TTAKHAROSHTH" +
	"I LETTER TTHAKHAROSHTHI LETTER DDAKHAROSHTHI LETTER DDHAKHAROSHTHI LETTE" +
	"R NNAKHAROSHTHI LETTER TAKHAROSHTHI LETTER THAKHAROSHTHI LETTER DAKHAROS" +
	"HTHI LETTER DHAKHAROSHTHI LETTER NAKHAROSHTHI LETTER PAKHAROSHTHI LETTER" +
	" PHAKHAROSHTHI LETTER BAKHAROSHTHI LETTER BHAKHAROSHTHI LETTER MAKHAROSH" +
	"THI LETTER YAKHAROSHTHI LETTER RAKHAROSHTHI LETTER LAKHAROSHTHI LETTER V" +
	"AKHAROSHTHI LETTER SHAKHAROSHTHI LETTER SSAKHAROSHTHI LETTER SAKHAROSHTH" +
	"I LETTER ZAKHAROSHTHI LETTER HAKHAROSHTHI LETTER KKAKHAROSHTHI LETTER TT" +
	"THAKHAROSHTHI LETTER TTTAKHAROSHTHI LETTER VHAKHAROSHTHI SIGN BAR ABOVEK" +
	"HAROSHTHI SIGN CAUDAKHAROSHTHI SIGN DOT BELOWKHAROSHTHI VIRAMAKHAROSHTHI" +
	" DIGIT ONEKHAROSHTHI DIGIT TWOKHAROSHTHI DIGIT THREEKHAROSHTHI DIGIT FOU" +
	"RKHAROSHTHI NUMBER TENKHAROSHTHI NUMBER TWENTYKHAROSHTHI NUMBER ONE HUND" +
	"REDKHAROSHTHI NUMBER ONE THOUSANDKHAROSHTHI FRACTION ONE HALFKHAROSHTHI " +
	"PUNCTUATION DOTKHAROSHTHI PUNCTUATION SMALL CIRCLEKHAROSHTHI PUNCTUATION" +
	" CIRCLEKHAROSHTHI PUNCTUATION CRESCENT BARKHAROSHTHI PUNCTUATION MANGALA" +
	"MKHAROSHTHI PUNCTUATION LOTUSKHAROSHTHI PUNCTUATION DANDAKHAROSHTHI PUNC" +
	"TUATION DOUBLE DANDAKHAROSHTHI PUNCTUATION LINESOLD SOUTH ARABIAN LETTER" +
	" HEOLD SOUTH ARABIAN LETTER LAMEDHOLD SOUTH ARABIAN LETTER HETHOLD SOUTH" +
	" ARABIAN LETTER MEMOLD SOUTH ARABIAN LETTER QOPHOLD SOUTH ARABIAN LETTER" +
	" WAWOLD SOUTH ARABIAN LETTER SHINOLD SOUTH ARABIAN LETTER RESHOLD SOUTH " +
	"ARABIAN LETTER BETHOLD SOUTH ARABIAN LETTER TAWOLD SOUTH ARABIAN LETTER " +
	"SATOLD SOUTH ARABIAN LETTER KAPHOLD SOUTH ARABIAN LETTER NUNOLD SOUTH AR" +
	"ABIAN LETTER KHETHOLD SOUTH ARABIAN LETTER SADHEOLD SOUTH ARABIAN LETTER" +
	" SAMEKHOLD SOUTH ARABIAN LETTER FEOLD SOUTH ARABIAN LETTER ALEFOLD SOUTH" +
	" ARABIAN LETTER AYNOLD SOUTH ARABIAN LETTER DHADHEOLD SOUTH ARABIAN LETT" +
	"ER GIMELOLD SOUTH ARABIAN LETTER DALETHOLD SOUTH ARABIAN LETTER GHAYNOLD" +
	" SOUTH ARABIAN LETTER TETHOLD SOUTH ARABIAN LETTER ZAYNOLD SOUTH ARABIAN" +
	" LETTER DHALETHOLD SOUTH ARABIAN LETTER YODHOLD SOUTH ARABIAN LETTER THA" +
	"WOLD SOUTH ARABIAN LETTER THETHOLD SOUTH ARABIAN NUMBER ONEOLD SOUTH ARA" +
	"BIAN NUMBER FIFTYOLD SOUTH ARABIAN NUMERIC INDICATOROLD NORTH ARABIAN LE" +
	"TTER HEHOLD NORTH ARABIAN LETTER LAMOLD NORTH ARABIAN LETTER HAHOLD NORT" +
	"H ARABIAN LETTER MEEMOLD NORTH ARABIAN LETTER QAFOLD NORTH ARABIAN LETTE" +
	"R WAWOLD NORTH ARABIAN LETTER ES-2OLD NORTH ARABIAN LETTER REHOLD NORTH " +
	"ARABIAN LETTER BEHOLD NORTH ARABIAN LETTER TEHOLD NORTH ARABIAN LETTER E" +
	"S-1OLD NORTH ARABIAN LETTER KAFOLD NORTH ARABIAN LETTER NOONOLD NORTH AR" +
	"ABIAN LETTER KHAHOLD NORTH ARABIAN LETTER SADOLD NORTH ARABIAN LETTER ES" +
	"-3OLD NORTH ARABIAN LETTER FEHOLD NORTH ARABIAN LETTER ALEFOLD NORTH ARA" +
	"BIAN LETTER AINOLD NORTH ARABIAN LETTER DADOLD NORTH ARABIAN LETTER GEEM" +
	"OLD NORTH ARABIAN LETTER DALOLD NORTH ARABIAN LETTER GHAINOLD NORTH ARAB" +
	"IAN LETTER TAHOLD NORTH ARABIAN LETTER ZAINOLD NORTH ARABIAN LETTER THAL" +
	"OLD NORTH ARABIAN LETTER YEHOLD NORTH ARABIAN LETTER THEHOLD NORTH ARABI" +
	"AN LETTER ZAHOLD NORTH ARABIAN NUMBER ONEOLD NORTH ARABIAN NUMBER TENOLD" +
	" NORTH ARABIAN NUMBER TWENTYMANICHAEAN LETTER ALEPHMANICHAEAN LETTER BET" +
	"HMANICHAEAN LETTER BHETHMANICHAEAN LETTER GIMELMANICHAEAN LETTER GHIMELM" +
	"ANICHAEAN LETTER DALETHMANICHAEAN LETTER HEMANICHAEAN LETTER WAWMANICHAE") + ("" +
	"AN SIGN UDMANICHAEAN LETTER ZAYINMANICHAEAN LETTER ZHAYINMANICHAEAN LETT" +
	"ER JAYINMANICHAEAN LETTER JHAYINMANICHAEAN LETTER HETHMANICHAEAN LETTER " +
	"TETHMANICHAEAN LETTER YODHMANICHAEAN LETTER KAPHMANICHAEAN LETTER XAPHMA" +
	"NICHAEAN LETTER KHAPHMANICHAEAN LETTER LAMEDHMANICHAEAN LETTER DHAMEDHMA" +
	"NICHAEAN LETTER THAMEDHMANICHAEAN LETTER MEMMANICHAEAN LETTER NUNMANICHA" +
	"EAN LETTER SAMEKHMANICHAEAN LETTER AYINMANICHAEAN LETTER AAYINMANICHAEAN" +
	" LETTER PEMANICHAEAN LETTER FEMANICHAEAN LETTER SADHEMANICHAEAN LETTER Q" +
	"OPHMANICHAEAN LETTER XOPHMANICHAEAN LETTER QHOPHMANICHAEAN LETTER RESHMA" +
	"NICHAEAN LETTER SHINMANICHAEAN LETTER SSHINMANICHAEAN LETTER TAWMANICHAE" +
	"AN ABBREVIATION MARK ABOVEMANICHAEAN ABBREVIATION MARK BELOWMANICHAEAN N" +
	"UMBER ONEMANICHAEAN NUMBER FIVEMANICHAEAN NUMBER TENMANICHAEAN NUMBER TW" +
	"ENTYMANICHAEAN NUMBER ONE HUNDREDMANICHAEAN PUNCTUATION STARMANICHAEAN P" +
	"UNCTUATION FLEURONMANICHAEAN PUNCTUATION DOUBLE DOT WITHIN DOTMANICHAEAN" +
	" PUNCTUATION DOT WITHIN DOTMANICHAEAN PUNCTUATION DOTMANICHAEAN PUNCTUAT" +
	"ION TWO DOTSMANICHAEAN PUNCTUATION LINE FILLERAVESTAN LETTER AAVESTAN LE" +
	"TTER AAAVESTAN LETTER AOAVESTAN LETTER AAOAVESTAN LETTER ANAVESTAN LETTE" +
	"R AANAVESTAN LETTER AEAVESTAN LETTER AEEAVESTAN LETTER EAVESTAN LETTER E" +
	"EAVESTAN LETTER OAVESTAN LETTER OOAVESTAN LETTER IAVESTAN LETTER IIAVEST" +
	"AN LETTER UAVESTAN LETTER UUAVESTAN LETTER KEAVESTAN LETTER XEAVESTAN LE" +
	"TTER XYEAVESTAN LETTER XVEAVESTAN LETTER GEAVESTAN LETTER GGEAVESTAN LET" +
	"TER GHEAVESTAN LETTER CEAVESTAN LETTER JEAVESTAN LETTER TEAVESTAN LETTER" +
	" THEAVESTAN LETTER DEAVESTAN LETTER DHEAVESTAN LETTER TTEAVESTAN LETTER " +
	"PEAVESTAN LETTER FEAVESTAN LETTER BEAVESTAN LETTER BHEAVESTAN LETTER NGE" +
	"AVESTAN LETTER NGYEAVESTAN LETTER NGVEAVESTAN LETTER NEAVESTAN LETTER NY" +
	"EAVESTAN LETTER NNEAVESTAN LETTER MEAVESTAN LETTER HMEAVESTAN LETTER YYE" +
	"AVESTAN LETTER YEAVESTAN LETTER VEAVESTAN LETTER REAVESTAN LETTER LEAVES" +
	"TAN LETTER SEAVESTAN LETTER ZEAVESTAN LETTER SHEAVESTAN LETTER ZHEAVESTA" +
	"N LETTER SHYEAVESTAN LETTER SSHEAVESTAN LETTER HEAVESTAN ABBREVIATION MA" +
	"RKTINY TWO DOTS OVER ONE DOT PUNCTUATIONSMALL TWO DOTS OVER ONE DOT PUNC" +
	"TUATIONLARGE TWO DOTS OVER ONE DOT PUNCTUATIONLARGE ONE DOT OVER TWO DOT" +
	"S PUNCTUATIONLARGE TWO RINGS OVER ONE RING PUNCTUATIONLARGE ONE RING OVE" +
	"R TWO RINGS PUNCTUATIONINSCRIPTIONAL PARTHIAN LETTER ALEPHINSCRIPTIONAL " +
	"PARTHIAN LETTER BETHINSCRIPTIONAL PARTHIAN LETTER GIMELINSCRIPTIONAL PAR" +
	"THIAN LETTER DALETHINSCRIPTIONAL PARTHIAN LETTER HEINSCRIPTIONAL PARTHIA" +
	"N LETTER WAWINSCRIPTIONAL PARTHIAN LETTER ZAYININSCRIPTIONAL PARTHIAN LE" +
	"TTER HETHINSCRIPTIONAL PARTHIAN LETTER TETHINSCRIPTIONAL PARTHIAN LETTER" +
	" YODHINSCRIPTIONAL PARTHIAN LETTER KAPHINSCRIPTIONAL PARTHIAN LETTER LAM" +
	"EDHINSCRIPTIONAL PARTHIAN LETTER MEMINSCRIPTIONAL PARTHIAN LETTER NUNINS" +
	"CRIPTIONAL PARTHIAN LETTER SAMEKHINSCRIPTIONAL PARTHIAN LETTER AYININSCR" +
	"IPTIONAL PARTHIAN LETTER PEINSCRIPTIONAL PARTHIAN LETTER SADHEINSCRIPTIO" +
	"NAL PARTHIAN LETTER QOPHINSCRIPTIONAL PARTHIAN LETTER RESHINSCRIPTIONAL " +
	"PARTHIAN LETTER SHININSCRIPTIONAL PARTHIAN LETTER TAWINSCRIPTIONAL PARTH" +
	"IAN NUMBER ONEINSCRIPTIONAL PARTHIAN NUMBER TWOINSCRIPTIONAL PARTHIAN NU" +
	"MBER THREEINSCRIPTIONAL PARTHIAN NUMBER FOURINSCRIPTIONAL PARTHIAN NUMBE" +
	"R TENINSCRIPTIONAL PARTHIAN NUMBER TWENTYINSCRIPTIONAL PARTHIAN NUMBER O" +
	"NE HUNDREDINSCRIPTIONAL PARTHIAN NUMBER ONE THOUSANDINSCRIPTIONAL PAHLAV" +
	"I LETTER ALEPHINSCRIPTIONAL PAHLAVI LETTER BETHINSCRIPTIONAL PAHLAVI LET" +
	"TER GIMELINSCRIPTIONAL PAHLAVI LETTER DALETHINSCRIPTIONAL PAHLAVI LETTER" +
	" HEINSCRIPTIONAL PAHLAVI LETTER WAW-AYIN-RESHINSCRIPTIONAL PAHLAVI LETTE" +
	"R ZAYININSCRIPTIONAL PAHLAVI LETTER HETHINSCRIPTIONAL PAHLAVI LETTER TET" +
	"HINSCRIPTIONAL PAHLAVI LETTER YODHINSCRIPTIONAL PAHLAVI LETTER KAPHINSCR" +
	"IPTIONAL PAHLAVI LETTER LAMEDHINSCRIPTIONAL PAHLAVI LETTER MEM-QOPHINSCR" +
	"IPTIONAL PAHLAVI LETTER NUNINSCRIPTIONAL PAHLAVI LETTER SAMEKHINSCRIPTIO" +
	"NAL PAHLAVI LETTER PEINSCRIPTIONAL PAHLAVI LETTER SADHEINSCRIPTIONAL PAH" +
	"LAVI LETTER SHININSCRIPTIONAL PAHLAVI LETTER TAWINSCRIPTIONAL PAHLAVI NU" +
	"MBER ONEINSCRIPTIONAL PAHLAVI NUMBER TWOINSCRIPTIONAL PAHLAVI NUMBER THR" +
	"EEINSCRIPTIONAL PAHLAVI NUMBER FOURINSCRIPTIONAL PAHLAVI NUMBER TENINSCR" +
	"IPTIONAL PAHLAVI NUMBER TWENTYINSCRIPTIONAL PAHLAVI NUMBER ONE HUNDREDIN" +
	"SCRIPTIONAL PAHLAVI NUMBER ONE THOUSANDPSALTER PAHLAVI LETTER ALEPHPSALT" +
	"ER PAHLAVI LETTER BETHPSALTER PAHLAVI LETTER GIMELPSALTER PAHLAVI LETTER" +
	" DALETHPSALTER PAHLAVI LETTER HEPSALTER PAHLAVI LETTER WAW-AYIN-RESHPSAL" +
	"TER PAHLAVI LETTER ZAYINPSALTER PAHLAVI LETTER HETHPSALTER PAHLAVI LETTE" +
	"R YODHPSALTER PAHLAVI LETTER KAPHPSALTER PAHLAVI LETTER LAMEDHPSALTER PA" +
	"HLAVI LETTER MEM-QOPHPSALTER PAHLAVI LETTER NUNPSALTER PAHLAVI LETTER SA") + ("" +
	"MEKHPSALTER PAHLAVI LETTER PEPSALTER PAHLAVI LETTER SADHEPSALTER PAHLAVI" +
	" LETTER SHINPSALTER PAHLAVI LETTER TAWPSALTER PAHLAVI SECTION MARKPSALTE" +
	"R PAHLAVI TURNED SECTION MARKPSALTER PAHLAVI FOUR DOTS WITH CROSSPSALTER" +
	" PAHLAVI FOUR DOTS WITH DOTPSALTER PAHLAVI NUMBER ONEPSALTER PAHLAVI NUM" +
	"BER TWOPSALTER PAHLAVI NUMBER THREEPSALTER PAHLAVI NUMBER FOURPSALTER PA" +
	"HLAVI NUMBER TENPSALTER PAHLAVI NUMBER TWENTYPSALTER PAHLAVI NUMBER ONE " +
	"HUNDREDOLD TURKIC LETTER ORKHON AOLD TURKIC LETTER YENISEI AOLD TURKIC L" +
	"ETTER YENISEI AEOLD TURKIC LETTER ORKHON IOLD TURKIC LETTER YENISEI IOLD" +
	" TURKIC LETTER YENISEI EOLD TURKIC LETTER ORKHON OOLD TURKIC LETTER ORKH" +
	"ON OEOLD TURKIC LETTER YENISEI OEOLD TURKIC LETTER ORKHON ABOLD TURKIC L" +
	"ETTER YENISEI ABOLD TURKIC LETTER ORKHON AEBOLD TURKIC LETTER YENISEI AE" +
	"BOLD TURKIC LETTER ORKHON AGOLD TURKIC LETTER YENISEI AGOLD TURKIC LETTE" +
	"R ORKHON AEGOLD TURKIC LETTER YENISEI AEGOLD TURKIC LETTER ORKHON ADOLD " +
	"TURKIC LETTER YENISEI ADOLD TURKIC LETTER ORKHON AEDOLD TURKIC LETTER OR" +
	"KHON EZOLD TURKIC LETTER YENISEI EZOLD TURKIC LETTER ORKHON AYOLD TURKIC" +
	" LETTER YENISEI AYOLD TURKIC LETTER ORKHON AEYOLD TURKIC LETTER YENISEI " +
	"AEYOLD TURKIC LETTER ORKHON AEKOLD TURKIC LETTER YENISEI AEKOLD TURKIC L" +
	"ETTER ORKHON OEKOLD TURKIC LETTER YENISEI OEKOLD TURKIC LETTER ORKHON AL" +
	"OLD TURKIC LETTER YENISEI ALOLD TURKIC LETTER ORKHON AELOLD TURKIC LETTE" +
	"R ORKHON ELTOLD TURKIC LETTER ORKHON EMOLD TURKIC LETTER ORKHON ANOLD TU" +
	"RKIC LETTER ORKHON AENOLD TURKIC LETTER YENISEI AENOLD TURKIC LETTER ORK" +
	"HON ENTOLD TURKIC LETTER YENISEI ENTOLD TURKIC LETTER ORKHON ENCOLD TURK" +
	"IC LETTER YENISEI ENCOLD TURKIC LETTER ORKHON ENYOLD TURKIC LETTER YENIS" +
	"EI ENYOLD TURKIC LETTER YENISEI ANGOLD TURKIC LETTER ORKHON ENGOLD TURKI" +
	"C LETTER YENISEI AENGOLD TURKIC LETTER ORKHON EPOLD TURKIC LETTER ORKHON" +
	" OPOLD TURKIC LETTER ORKHON ICOLD TURKIC LETTER ORKHON ECOLD TURKIC LETT" +
	"ER YENISEI ECOLD TURKIC LETTER ORKHON AQOLD TURKIC LETTER YENISEI AQOLD " +
	"TURKIC LETTER ORKHON IQOLD TURKIC LETTER YENISEI IQOLD TURKIC LETTER ORK" +
	"HON OQOLD TURKIC LETTER YENISEI OQOLD TURKIC LETTER ORKHON AROLD TURKIC " +
	"LETTER YENISEI AROLD TURKIC LETTER ORKHON AEROLD TURKIC LETTER ORKHON AS" +
	"OLD TURKIC LETTER ORKHON AESOLD TURKIC LETTER ORKHON ASHOLD TURKIC LETTE" +
	"R YENISEI ASHOLD TURKIC LETTER ORKHON ESHOLD TURKIC LETTER YENISEI ESHOL" +
	"D TURKIC LETTER ORKHON ATOLD TURKIC LETTER YENISEI ATOLD TURKIC LETTER O" +
	"RKHON AETOLD TURKIC LETTER YENISEI AETOLD TURKIC LETTER ORKHON OTOLD TUR" +
	"KIC LETTER ORKHON BASHOLD HUNGARIAN CAPITAL LETTER AOLD HUNGARIAN CAPITA" +
	"L LETTER AAOLD HUNGARIAN CAPITAL LETTER EBOLD HUNGARIAN CAPITAL LETTER A" +
	"MBOLD HUNGARIAN CAPITAL LETTER ECOLD HUNGARIAN CAPITAL LETTER ENCOLD HUN" +
	"GARIAN CAPITAL LETTER ECSOLD HUNGARIAN CAPITAL LETTER EDOLD HUNGARIAN CA" +
	"PITAL LETTER ANDOLD HUNGARIAN CAPITAL LETTER EOLD HUNGARIAN CAPITAL LETT" +
	"ER CLOSE EOLD HUNGARIAN CAPITAL LETTER EEOLD HUNGARIAN CAPITAL LETTER EF" +
	"OLD HUNGARIAN CAPITAL LETTER EGOLD HUNGARIAN CAPITAL LETTER EGYOLD HUNGA" +
	"RIAN CAPITAL LETTER EHOLD HUNGARIAN CAPITAL LETTER IOLD HUNGARIAN CAPITA" +
	"L LETTER IIOLD HUNGARIAN CAPITAL LETTER EJOLD HUNGARIAN CAPITAL LETTER E" +
	"KOLD HUNGARIAN CAPITAL LETTER AKOLD HUNGARIAN CAPITAL LETTER UNKOLD HUNG" +
	"ARIAN CAPITAL LETTER ELOLD HUNGARIAN CAPITAL LETTER ELYOLD HUNGARIAN CAP" +
	"ITAL LETTER EMOLD HUNGARIAN CAPITAL LETTER ENOLD HUNGARIAN CAPITAL LETTE" +
	"R ENYOLD HUNGARIAN CAPITAL LETTER OOLD HUNGARIAN CAPITAL LETTER OOOLD HU" +
	"NGARIAN CAPITAL LETTER NIKOLSBURG OEOLD HUNGARIAN CAPITAL LETTER RUDIMEN" +
	"TA OEOLD HUNGARIAN CAPITAL LETTER OEEOLD HUNGARIAN CAPITAL LETTER EPOLD " +
	"HUNGARIAN CAPITAL LETTER EMPOLD HUNGARIAN CAPITAL LETTER EROLD HUNGARIAN" +
	" CAPITAL LETTER SHORT EROLD HUNGARIAN CAPITAL LETTER ESOLD HUNGARIAN CAP" +
	"ITAL LETTER ESZOLD HUNGARIAN CAPITAL LETTER ETOLD HUNGARIAN CAPITAL LETT" +
	"ER ENTOLD HUNGARIAN CAPITAL LETTER ETYOLD HUNGARIAN CAPITAL LETTER ECHOL" +
	"D HUNGARIAN CAPITAL LETTER UOLD HUNGARIAN CAPITAL LETTER UUOLD HUNGARIAN" +
	" CAPITAL LETTER NIKOLSBURG UEOLD HUNGARIAN CAPITAL LETTER RUDIMENTA UEOL" +
	"D HUNGARIAN CAPITAL LETTER EVOLD HUNGARIAN CAPITAL LETTER EZOLD HUNGARIA" +
	"N CAPITAL LETTER EZSOLD HUNGARIAN CAPITAL LETTER ENT-SHAPED SIGNOLD HUNG" +
	"ARIAN CAPITAL LETTER USOLD HUNGARIAN SMALL LETTER AOLD HUNGARIAN SMALL L" +
	"ETTER AAOLD HUNGARIAN SMALL LETTER EBOLD HUNGARIAN SMALL LETTER AMBOLD H" +
	"UNGARIAN SMALL LETTER ECOLD HUNGARIAN SMALL LETTER ENCOLD HUNGARIAN SMAL" +
	"L LETTER ECSOLD HUNGARIAN SMALL LETTER EDOLD HUNGARIAN SMALL LETTER ANDO" +
	"LD HUNGARIAN SMALL LETTER EOLD HUNGARIAN SMALL LETTER CLOSE EOLD HUNGARI" +
	"AN SMALL LETTER EEOLD HUNGARIAN SMALL LETTER EFOLD HUNGARIAN SMALL LETTE" +
	"R EGOLD HUNGARIAN SMALL LETTER EGYOLD HUNGARIAN SMALL LETTER EHOLD HUNGA") + ("" +
	"RIAN SMALL LETTER IOLD HUNGARIAN SMALL LETTER IIOLD HUNGARIAN SMALL LETT" +
	"ER EJOLD HUNGARIAN SMALL LETTER EKOLD HUNGARIAN SMALL LETTER AKOLD HUNGA" +
	"RIAN SMALL LETTER UNKOLD HUNGARIAN SMALL LETTER ELOLD HUNGARIAN SMALL LE" +
	"TTER ELYOLD HUNGARIAN SMALL LETTER EMOLD HUNGARIAN SMALL LETTER ENOLD HU" +
	"NGARIAN SMALL LETTER ENYOLD HUNGARIAN SMALL LETTER OOLD HUNGARIAN SMALL " +
	"LETTER OOOLD HUNGARIAN SMALL LETTER NIKOLSBURG OEOLD HUNGARIAN SMALL LET" +
	"TER RUDIMENTA OEOLD HUNGARIAN SMALL LETTER OEEOLD HUNGARIAN SMALL LETTER" +
	" EPOLD HUNGARIAN SMALL LETTER EMPOLD HUNGARIAN SMALL LETTER EROLD HUNGAR" +
	"IAN SMALL LETTER SHORT EROLD HUNGARIAN SMALL LETTER ESOLD HUNGARIAN SMAL" +
	"L LETTER ESZOLD HUNGARIAN SMALL LETTER ETOLD HUNGARIAN SMALL LETTER ENTO" +
	"LD HUNGARIAN SMALL LETTER ETYOLD HUNGARIAN SMALL LETTER ECHOLD HUNGARIAN" +
	" SMALL LETTER UOLD HUNGARIAN SMALL LETTER UUOLD HUNGARIAN SMALL LETTER N" +
	"IKOLSBURG UEOLD HUNGARIAN SMALL LETTER RUDIMENTA UEOLD HUNGARIAN SMALL L" +
	"ETTER EVOLD HUNGARIAN SMALL LETTER EZOLD HUNGARIAN SMALL LETTER EZSOLD H" +
	"UNGARIAN SMALL LETTER ENT-SHAPED SIGNOLD HUNGARIAN SMALL LETTER USOLD HU" +
	"NGARIAN NUMBER ONEOLD HUNGARIAN NUMBER FIVEOLD HUNGARIAN NUMBER TENOLD H" +
	"UNGARIAN NUMBER FIFTYOLD HUNGARIAN NUMBER ONE HUNDREDOLD HUNGARIAN NUMBE" +
	"R ONE THOUSANDHANIFI ROHINGYA LETTER AHANIFI ROHINGYA LETTER BAHANIFI RO" +
	"HINGYA LETTER PAHANIFI ROHINGYA LETTER TAHANIFI ROHINGYA LETTER TTAHANIF" +
	"I ROHINGYA LETTER JAHANIFI ROHINGYA LETTER CAHANIFI ROHINGYA LETTER HAHA" +
	"NIFI ROHINGYA LETTER KHAHANIFI ROHINGYA LETTER FAHANIFI ROHINGYA LETTER " +
	"DAHANIFI ROHINGYA LETTER DDAHANIFI ROHINGYA LETTER RAHANIFI ROHINGYA LET" +
	"TER RRAHANIFI ROHINGYA LETTER ZAHANIFI ROHINGYA LETTER SAHANIFI ROHINGYA" +
	" LETTER SHAHANIFI ROHINGYA LETTER KAHANIFI ROHINGYA LETTER GAHANIFI ROHI" +
	"NGYA LETTER LAHANIFI ROHINGYA LETTER MAHANIFI ROHINGYA LETTER NAHANIFI R" +
	"OHINGYA LETTER WAHANIFI ROHINGYA LETTER KINNA WAHANIFI ROHINGYA LETTER Y" +
	"AHANIFI ROHINGYA LETTER KINNA YAHANIFI ROHINGYA LETTER NGAHANIFI ROHINGY" +
	"A LETTER NYAHANIFI ROHINGYA LETTER VAHANIFI ROHINGYA VOWEL AHANIFI ROHIN" +
	"GYA VOWEL IHANIFI ROHINGYA VOWEL UHANIFI ROHINGYA VOWEL EHANIFI ROHINGYA" +
	" VOWEL OHANIFI ROHINGYA MARK SAKINHANIFI ROHINGYA MARK NA KHONNAHANIFI R" +
	"OHINGYA SIGN HARBAHAYHANIFI ROHINGYA SIGN TAHALAHANIFI ROHINGYA SIGN TAN" +
	"AHANIFI ROHINGYA SIGN TASSIHANIFI ROHINGYA DIGIT ZEROHANIFI ROHINGYA DIG" +
	"IT ONEHANIFI ROHINGYA DIGIT TWOHANIFI ROHINGYA DIGIT THREEHANIFI ROHINGY" +
	"A DIGIT FOURHANIFI ROHINGYA DIGIT FIVEHANIFI ROHINGYA DIGIT SIXHANIFI RO" +
	"HINGYA DIGIT SEVENHANIFI ROHINGYA DIGIT EIGHTHANIFI ROHINGYA DIGIT NINER" +
	"UMI DIGIT ONERUMI DIGIT TWORUMI DIGIT THREERUMI DIGIT FOURRUMI DIGIT FIV" +
	"ERUMI DIGIT SIXRUMI DIGIT SEVENRUMI DIGIT EIGHTRUMI DIGIT NINERUMI NUMBE" +
	"R TENRUMI NUMBER TWENTYRUMI NUMBER THIRTYRUMI NUMBER FORTYRUMI NUMBER FI" +
	"FTYRUMI NUMBER SIXTYRUMI NUMBER SEVENTYRUMI NUMBER EIGHTYRUMI NUMBER NIN" +
	"ETYRUMI NUMBER ONE HUNDREDRUMI NUMBER TWO HUNDREDRUMI NUMBER THREE HUNDR" +
	"EDRUMI NUMBER FOUR HUNDREDRUMI NUMBER FIVE HUNDREDRUMI NUMBER SIX HUNDRE" +
	"DRUMI NUMBER SEVEN HUNDREDRUMI NUMBER EIGHT HUNDREDRUMI NUMBER NINE HUND" +
	"REDRUMI FRACTION ONE HALFRUMI FRACTION ONE QUARTERRUMI FRACTION ONE THIR" +
	"DRUMI FRACTION TWO THIRDSOLD SOGDIAN LETTER ALEPHOLD SOGDIAN LETTER FINA" +
	"L ALEPHOLD SOGDIAN LETTER BETHOLD SOGDIAN LETTER FINAL BETHOLD SOGDIAN L" +
	"ETTER GIMELOLD SOGDIAN LETTER HEOLD SOGDIAN LETTER FINAL HEOLD SOGDIAN L" +
	"ETTER WAWOLD SOGDIAN LETTER ZAYINOLD SOGDIAN LETTER HETHOLD SOGDIAN LETT" +
	"ER YODHOLD SOGDIAN LETTER KAPHOLD SOGDIAN LETTER LAMEDHOLD SOGDIAN LETTE" +
	"R MEMOLD SOGDIAN LETTER NUNOLD SOGDIAN LETTER FINAL NUNOLD SOGDIAN LETTE" +
	"R FINAL NUN WITH VERTICAL TAILOLD SOGDIAN LETTER SAMEKHOLD SOGDIAN LETTE" +
	"R AYINOLD SOGDIAN LETTER ALTERNATE AYINOLD SOGDIAN LETTER PEOLD SOGDIAN " +
	"LETTER SADHEOLD SOGDIAN LETTER FINAL SADHEOLD SOGDIAN LETTER FINAL SADHE" +
	" WITH VERTICAL TAILOLD SOGDIAN LETTER RESH-AYIN-DALETHOLD SOGDIAN LETTER" +
	" SHINOLD SOGDIAN LETTER TAWOLD SOGDIAN LETTER FINAL TAWOLD SOGDIAN LETTE" +
	"R FINAL TAW WITH VERTICAL TAILOLD SOGDIAN NUMBER ONEOLD SOGDIAN NUMBER T" +
	"WOOLD SOGDIAN NUMBER THREEOLD SOGDIAN NUMBER FOUROLD SOGDIAN NUMBER FIVE" +
	"OLD SOGDIAN NUMBER TENOLD SOGDIAN NUMBER TWENTYOLD SOGDIAN NUMBER THIRTY" +
	"OLD SOGDIAN NUMBER ONE HUNDREDOLD SOGDIAN FRACTION ONE HALFOLD SOGDIAN L" +
	"IGATURE AYIN-DALETHSOGDIAN LETTER ALEPHSOGDIAN LETTER BETHSOGDIAN LETTER" +
	" GIMELSOGDIAN LETTER HESOGDIAN LETTER WAWSOGDIAN LETTER ZAYINSOGDIAN LET" +
	"TER HETHSOGDIAN LETTER YODHSOGDIAN LETTER KAPHSOGDIAN LETTER LAMEDHSOGDI" +
	"AN LETTER MEMSOGDIAN LETTER NUNSOGDIAN LETTER SAMEKHSOGDIAN LETTER AYINS" +
	"OGDIAN LETTER PESOGDIAN LETTER SADHESOGDIAN LETTER RESH-AYINSOGDIAN LETT" +
	"ER SHINSOGDIAN LETTER TAWSOGDIAN LETTER FETHSOGDIAN LETTER LESHSOGDIAN I") + ("" +
	"NDEPENDENT SHINSOGDIAN COMBINING DOT BELOWSOGDIAN COMBINING TWO DOTS BEL" +
	"OWSOGDIAN COMBINING DOT ABOVESOGDIAN COMBINING TWO DOTS ABOVESOGDIAN COM" +
	"BINING CURVE ABOVESOGDIAN COMBINING CURVE BELOWSOGDIAN COMBINING HOOK AB" +
	"OVESOGDIAN COMBINING HOOK BELOWSOGDIAN COMBINING LONG HOOK BELOWSOGDIAN " +
	"COMBINING RESH BELOWSOGDIAN COMBINING STROKE BELOWSOGDIAN NUMBER ONESOGD" +
	"IAN NUMBER TENSOGDIAN NUMBER TWENTYSOGDIAN NUMBER ONE HUNDREDSOGDIAN PUN" +
	"CTUATION TWO VERTICAL BARSSOGDIAN PUNCTUATION TWO VERTICAL BARS WITH DOT" +
	"SSOGDIAN PUNCTUATION CIRCLE WITH DOTSOGDIAN PUNCTUATION TWO CIRCLES WITH" +
	" DOTSSOGDIAN PUNCTUATION HALF CIRCLE WITH DOTELYMAIC LETTER ALEPHELYMAIC" +
	" LETTER BETHELYMAIC LETTER GIMELELYMAIC LETTER DALETHELYMAIC LETTER HEEL" +
	"YMAIC LETTER WAWELYMAIC LETTER ZAYINELYMAIC LETTER HETHELYMAIC LETTER TE" +
	"THELYMAIC LETTER YODHELYMAIC LETTER KAPHELYMAIC LETTER LAMEDHELYMAIC LET" +
	"TER MEMELYMAIC LETTER NUNELYMAIC LETTER SAMEKHELYMAIC LETTER AYINELYMAIC" +
	" LETTER PEELYMAIC LETTER SADHEELYMAIC LETTER QOPHELYMAIC LETTER RESHELYM" +
	"AIC LETTER SHINELYMAIC LETTER TAWELYMAIC LIGATURE ZAYIN-YODHBRAHMI SIGN " +
	"CANDRABINDUBRAHMI SIGN ANUSVARABRAHMI SIGN VISARGABRAHMI SIGN JIHVAMULIY" +
	"ABRAHMI SIGN UPADHMANIYABRAHMI LETTER ABRAHMI LETTER AABRAHMI LETTER IBR" +
	"AHMI LETTER IIBRAHMI LETTER UBRAHMI LETTER UUBRAHMI LETTER VOCALIC RBRAH" +
	"MI LETTER VOCALIC RRBRAHMI LETTER VOCALIC LBRAHMI LETTER VOCALIC LLBRAHM" +
	"I LETTER EBRAHMI LETTER AIBRAHMI LETTER OBRAHMI LETTER AUBRAHMI LETTER K" +
	"ABRAHMI LETTER KHABRAHMI LETTER GABRAHMI LETTER GHABRAHMI LETTER NGABRAH" +
	"MI LETTER CABRAHMI LETTER CHABRAHMI LETTER JABRAHMI LETTER JHABRAHMI LET" +
	"TER NYABRAHMI LETTER TTABRAHMI LETTER TTHABRAHMI LETTER DDABRAHMI LETTER" +
	" DDHABRAHMI LETTER NNABRAHMI LETTER TABRAHMI LETTER THABRAHMI LETTER DAB" +
	"RAHMI LETTER DHABRAHMI LETTER NABRAHMI LETTER PABRAHMI LETTER PHABRAHMI " +
	"LETTER BABRAHMI LETTER BHABRAHMI LETTER MABRAHMI LETTER YABRAHMI LETTER " +
	"RABRAHMI LETTER LABRAHMI LETTER VABRAHMI LETTER SHABRAHMI LETTER SSABRAH" +
	"MI LETTER SABRAHMI LETTER HABRAHMI LETTER LLABRAHMI LETTER OLD TAMIL LLL" +
	"ABRAHMI LETTER OLD TAMIL RRABRAHMI LETTER OLD TAMIL NNNABRAHMI VOWEL SIG" +
	"N AABRAHMI VOWEL SIGN BHATTIPROLU AABRAHMI VOWEL SIGN IBRAHMI VOWEL SIGN" +
	" IIBRAHMI VOWEL SIGN UBRAHMI VOWEL SIGN UUBRAHMI VOWEL SIGN VOCALIC RBRA" +
	"HMI VOWEL SIGN VOCALIC RRBRAHMI VOWEL SIGN VOCALIC LBRAHMI VOWEL SIGN VO" +
	"CALIC LLBRAHMI VOWEL SIGN EBRAHMI VOWEL SIGN AIBRAHMI VOWEL SIGN OBRAHMI" +
	" VOWEL SIGN AUBRAHMI VIRAMABRAHMI DANDABRAHMI DOUBLE DANDABRAHMI PUNCTUA" +
	"TION DOTBRAHMI PUNCTUATION DOUBLE DOTBRAHMI PUNCTUATION LINEBRAHMI PUNCT" +
	"UATION CRESCENT BARBRAHMI PUNCTUATION LOTUSBRAHMI NUMBER ONEBRAHMI NUMBE" +
	"R TWOBRAHMI NUMBER THREEBRAHMI NUMBER FOURBRAHMI NUMBER FIVEBRAHMI NUMBE" +
	"R SIXBRAHMI NUMBER SEVENBRAHMI NUMBER EIGHTBRAHMI NUMBER NINEBRAHMI NUMB" +
	"ER TENBRAHMI NUMBER TWENTYBRAHMI NUMBER THIRTYBRAHMI NUMBER FORTYBRAHMI " +
	"NUMBER FIFTYBRAHMI NUMBER SIXTYBRAHMI NUMBER SEVENTYBRAHMI NUMBER EIGHTY" +
	"BRAHMI NUMBER NINETYBRAHMI NUMBER ONE HUNDREDBRAHMI NUMBER ONE THOUSANDB" +
	"RAHMI DIGIT ZEROBRAHMI DIGIT ONEBRAHMI DIGIT TWOBRAHMI DIGIT THREEBRAHMI" +
	" DIGIT FOURBRAHMI DIGIT FIVEBRAHMI DIGIT SIXBRAHMI DIGIT SEVENBRAHMI DIG" +
	"IT EIGHTBRAHMI DIGIT NINEBRAHMI NUMBER JOINERKAITHI SIGN CANDRABINDUKAIT" +
	"HI SIGN ANUSVARAKAITHI SIGN VISARGAKAITHI LETTER AKAITHI LETTER AAKAITHI" +
	" LETTER IKAITHI LETTER IIKAITHI LETTER UKAITHI LETTER UUKAITHI LETTER EK" +
	"AITHI LETTER AIKAITHI LETTER OKAITHI LETTER AUKAITHI LETTER KAKAITHI LET" +
	"TER KHAKAITHI LETTER GAKAITHI LETTER GHAKAITHI LETTER NGAKAITHI LETTER C" +
	"AKAITHI LETTER CHAKAITHI LETTER JAKAITHI LETTER JHAKAITHI LETTER NYAKAIT" +
	"HI LETTER TTAKAITHI LETTER TTHAKAITHI LETTER DDAKAITHI LETTER DDDHAKAITH" +
	"I LETTER DDHAKAITHI LETTER RHAKAITHI LETTER NNAKAITHI LETTER TAKAITHI LE" +
	"TTER THAKAITHI LETTER DAKAITHI LETTER DHAKAITHI LETTER NAKAITHI LETTER P" +
	"AKAITHI LETTER PHAKAITHI LETTER BAKAITHI LETTER BHAKAITHI LETTER MAKAITH" +
	"I LETTER YAKAITHI LETTER RAKAITHI LETTER LAKAITHI LETTER VAKAITHI LETTER" +
	" SHAKAITHI LETTER SSAKAITHI LETTER SAKAITHI LETTER HAKAITHI VOWEL SIGN A" +
	"AKAITHI VOWEL SIGN IKAITHI VOWEL SIGN IIKAITHI VOWEL SIGN UKAITHI VOWEL " +
	"SIGN UUKAITHI VOWEL SIGN EKAITHI VOWEL SIGN AIKAITHI VOWEL SIGN OKAITHI " +
	"VOWEL SIGN AUKAITHI SIGN VIRAMAKAITHI SIGN NUKTAKAITHI ABBREVIATION SIGN" +
	"KAITHI ENUMERATION SIGNKAITHI NUMBER SIGNKAITHI SECTION MARKKAITHI DOUBL" +
	"E SECTION MARKKAITHI DANDAKAITHI DOUBLE DANDAKAITHI NUMBER SIGN ABOVESOR" +
	"A SOMPENG LETTER SAHSORA SOMPENG LETTER TAHSORA SOMPENG LETTER BAHSORA S" +
	"OMPENG LETTER CAHSORA SOMPENG LETTER DAHSORA SOMPENG LETTER GAHSORA SOMP" +
	"ENG LETTER MAHSORA SOMPENG LETTER NGAHSORA SOMPENG LETTER LAHSORA SOMPEN" +
	"G LETTER NAHSORA SOMPENG LETTER VAHSORA SOMPENG LETTER PAHSORA SOMPENG L") + ("" +
	"ETTER YAHSORA SOMPENG LETTER RAHSORA SOMPENG LETTER HAHSORA SOMPENG LETT" +
	"ER KAHSORA SOMPENG LETTER JAHSORA SOMPENG LETTER NYAHSORA SOMPENG LETTER" +
	" AHSORA SOMPENG LETTER EEHSORA SOMPENG LETTER IHSORA SOMPENG LETTER UHSO" +
	"RA SOMPENG LETTER OHSORA SOMPENG LETTER EHSORA SOMPENG LETTER MAESORA SO" +
	"MPENG DIGIT ZEROSORA SOMPENG DIGIT ONESORA SOMPENG DIGIT TWOSORA SOMPENG" +
	" DIGIT THREESORA SOMPENG DIGIT FOURSORA SOMPENG DIGIT FIVESORA SOMPENG D" +
	"IGIT SIXSORA SOMPENG DIGIT SEVENSORA SOMPENG DIGIT EIGHTSORA SOMPENG DIG" +
	"IT NINECHAKMA SIGN CANDRABINDUCHAKMA SIGN ANUSVARACHAKMA SIGN VISARGACHA" +
	"KMA LETTER AACHAKMA LETTER ICHAKMA LETTER UCHAKMA LETTER ECHAKMA LETTER " +
	"KAACHAKMA LETTER KHAACHAKMA LETTER GAACHAKMA LETTER GHAACHAKMA LETTER NG" +
	"AACHAKMA LETTER CAACHAKMA LETTER CHAACHAKMA LETTER JAACHAKMA LETTER JHAA" +
	"CHAKMA LETTER NYAACHAKMA LETTER TTAACHAKMA LETTER TTHAACHAKMA LETTER DDA" +
	"ACHAKMA LETTER DDHAACHAKMA LETTER NNAACHAKMA LETTER TAACHAKMA LETTER THA" +
	"ACHAKMA LETTER DAACHAKMA LETTER DHAACHAKMA LETTER NAACHAKMA LETTER PAACH" +
	"AKMA LETTER PHAACHAKMA LETTER BAACHAKMA LETTER BHAACHAKMA LETTER MAACHAK" +
	"MA LETTER YYAACHAKMA LETTER YAACHAKMA LETTER RAACHAKMA LETTER LAACHAKMA " +
	"LETTER WAACHAKMA LETTER SAACHAKMA LETTER HAACHAKMA VOWEL SIGN ACHAKMA VO" +
	"WEL SIGN ICHAKMA VOWEL SIGN IICHAKMA VOWEL SIGN UCHAKMA VOWEL SIGN UUCHA" +
	"KMA VOWEL SIGN ECHAKMA VOWEL SIGN AICHAKMA VOWEL SIGN OCHAKMA VOWEL SIGN" +
	" AUCHAKMA VOWEL SIGN OICHAKMA O MARKCHAKMA AU MARKCHAKMA VIRAMACHAKMA MA" +
	"AYYAACHAKMA DIGIT ZEROCHAKMA DIGIT ONECHAKMA DIGIT TWOCHAKMA DIGIT THREE" +
	"CHAKMA DIGIT FOURCHAKMA DIGIT FIVECHAKMA DIGIT SIXCHAKMA DIGIT SEVENCHAK" +
	"MA DIGIT EIGHTCHAKMA DIGIT NINECHAKMA SECTION MARKCHAKMA DANDACHAKMA DOU" +
	"BLE DANDACHAKMA QUESTION MARKCHAKMA LETTER LHAACHAKMA VOWEL SIGN AACHAKM" +
	"A VOWEL SIGN EIMAHAJANI LETTER AMAHAJANI LETTER IMAHAJANI LETTER UMAHAJA" +
	"NI LETTER EMAHAJANI LETTER OMAHAJANI LETTER KAMAHAJANI LETTER KHAMAHAJAN" +
	"I LETTER GAMAHAJANI LETTER GHAMAHAJANI LETTER CAMAHAJANI LETTER CHAMAHAJ" +
	"ANI LETTER JAMAHAJANI LETTER JHAMAHAJANI LETTER NYAMAHAJANI LETTER TTAMA" +
	"HAJANI LETTER TTHAMAHAJANI LETTER DDAMAHAJANI LETTER DDHAMAHAJANI LETTER" +
	" NNAMAHAJANI LETTER TAMAHAJANI LETTER THAMAHAJANI LETTER DAMAHAJANI LETT" +
	"ER DHAMAHAJANI LETTER NAMAHAJANI LETTER PAMAHAJANI LETTER PHAMAHAJANI LE" +
	"TTER BAMAHAJANI LETTER BHAMAHAJANI LETTER MAMAHAJANI LETTER RAMAHAJANI L" +
	"ETTER LAMAHAJANI LETTER VAMAHAJANI LETTER SAMAHAJANI LETTER HAMAHAJANI L" +
	"ETTER RRAMAHAJANI SIGN NUKTAMAHAJANI ABBREVIATION SIGNMAHAJANI SECTION M" +
	"ARKMAHAJANI LIGATURE SHRISHARADA SIGN CANDRABINDUSHARADA SIGN ANUSVARASH" +
	"ARADA SIGN VISARGASHARADA LETTER ASHARADA LETTER AASHARADA LETTER ISHARA" +
	"DA LETTER IISHARADA LETTER USHARADA LETTER UUSHARADA LETTER VOCALIC RSHA" +
	"RADA LETTER VOCALIC RRSHARADA LETTER VOCALIC LSHARADA LETTER VOCALIC LLS" +
	"HARADA LETTER ESHARADA LETTER AISHARADA LETTER OSHARADA LETTER AUSHARADA" +
	" LETTER KASHARADA LETTER KHASHARADA LETTER GASHARADA LETTER GHASHARADA L" +
	"ETTER NGASHARADA LETTER CASHARADA LETTER CHASHARADA LETTER JASHARADA LET" +
	"TER JHASHARADA LETTER NYASHARADA LETTER TTASHARADA LETTER TTHASHARADA LE" +
	"TTER DDASHARADA LETTER DDHASHARADA LETTER NNASHARADA LETTER TASHARADA LE" +
	"TTER THASHARADA LETTER DASHARADA LETTER DHASHARADA LETTER NASHARADA LETT" +
	"ER PASHARADA LETTER PHASHARADA LETTER BASHARADA LETTER BHASHARADA LETTER" +
	" MASHARADA LETTER YASHARADA LETTER RASHARADA LETTER LASHARADA LETTER LLA" +
	"SHARADA LETTER VASHARADA LETTER SHASHARADA LETTER SSASHARADA LETTER SASH" +
	"ARADA LETTER HASHARADA VOWEL SIGN AASHARADA VOWEL SIGN ISHARADA VOWEL SI" +
	"GN IISHARADA VOWEL SIGN USHARADA VOWEL SIGN UUSHARADA VOWEL SIGN VOCALIC" +
	" RSHARADA VOWEL SIGN VOCALIC RRSHARADA VOWEL SIGN VOCALIC LSHARADA VOWEL" +
	" SIGN VOCALIC LLSHARADA VOWEL SIGN ESHARADA VOWEL SIGN AISHARADA VOWEL S" +
	"IGN OSHARADA VOWEL SIGN AUSHARADA SIGN VIRAMASHARADA SIGN AVAGRAHASHARAD" +
	"A SIGN JIHVAMULIYASHARADA SIGN UPADHMANIYASHARADA OMSHARADA DANDASHARADA" +
	" DOUBLE DANDASHARADA ABBREVIATION SIGNSHARADA SEPARATORSHARADA SANDHI MA" +
	"RKSHARADA SIGN NUKTASHARADA VOWEL MODIFIER MARKSHARADA EXTRA SHORT VOWEL" +
	" MARKSHARADA SUTRA MARKSHARADA DIGIT ZEROSHARADA DIGIT ONESHARADA DIGIT " +
	"TWOSHARADA DIGIT THREESHARADA DIGIT FOURSHARADA DIGIT FIVESHARADA DIGIT " +
	"SIXSHARADA DIGIT SEVENSHARADA DIGIT EIGHTSHARADA DIGIT NINESHARADA EKAMS" +
	"HARADA SIGN SIDDHAMSHARADA HEADSTROKESHARADA CONTINUATION SIGNSHARADA SE" +
	"CTION MARK-1SHARADA SECTION MARK-2SINHALA ARCHAIC DIGIT ONESINHALA ARCHA" +
	"IC DIGIT TWOSINHALA ARCHAIC DIGIT THREESINHALA ARCHAIC DIGIT FOURSINHALA" +
	" ARCHAIC DIGIT FIVESINHALA ARCHAIC DIGIT SIXSINHALA ARCHAIC DIGIT SEVENS" +
	"INHALA ARCHAIC DIGIT EIGHTSINHALA ARCHAIC DIGIT NINESINHALA ARCHAIC NUMB" +
	"ER TENSINHALA ARCHAIC NUMBER TWENTYSINHALA ARCHAIC NUMBER THIRTYSINHALA ") + ("" +
	"ARCHAIC NUMBER FORTYSINHALA ARCHAIC NUMBER FIFTYSINHALA ARCHAIC NUMBER S" +
	"IXTYSINHALA ARCHAIC NUMBER SEVENTYSINHALA ARCHAIC NUMBER EIGHTYSINHALA A" +
	"RCHAIC NUMBER NINETYSINHALA ARCHAIC NUMBER ONE HUNDREDSINHALA ARCHAIC NU" +
	"MBER ONE THOUSANDKHOJKI LETTER AKHOJKI LETTER AAKHOJKI LETTER IKHOJKI LE" +
	"TTER UKHOJKI LETTER EKHOJKI LETTER AIKHOJKI LETTER OKHOJKI LETTER AUKHOJ" +
	"KI LETTER KAKHOJKI LETTER KHAKHOJKI LETTER GAKHOJKI LETTER GGAKHOJKI LET" +
	"TER GHAKHOJKI LETTER NGAKHOJKI LETTER CAKHOJKI LETTER CHAKHOJKI LETTER J" +
	"AKHOJKI LETTER JJAKHOJKI LETTER NYAKHOJKI LETTER TTAKHOJKI LETTER TTHAKH" +
	"OJKI LETTER DDAKHOJKI LETTER DDHAKHOJKI LETTER NNAKHOJKI LETTER TAKHOJKI" +
	" LETTER THAKHOJKI LETTER DAKHOJKI LETTER DDDAKHOJKI LETTER DHAKHOJKI LET" +
	"TER NAKHOJKI LETTER PAKHOJKI LETTER PHAKHOJKI LETTER BAKHOJKI LETTER BBA" +
	"KHOJKI LETTER BHAKHOJKI LETTER MAKHOJKI LETTER YAKHOJKI LETTER RAKHOJKI " +
	"LETTER LAKHOJKI LETTER VAKHOJKI LETTER SAKHOJKI LETTER HAKHOJKI LETTER L" +
	"LAKHOJKI VOWEL SIGN AAKHOJKI VOWEL SIGN IKHOJKI VOWEL SIGN IIKHOJKI VOWE" +
	"L SIGN UKHOJKI VOWEL SIGN EKHOJKI VOWEL SIGN AIKHOJKI VOWEL SIGN OKHOJKI" +
	" VOWEL SIGN AUKHOJKI SIGN ANUSVARAKHOJKI SIGN VIRAMAKHOJKI SIGN NUKTAKHO" +
	"JKI SIGN SHADDAKHOJKI DANDAKHOJKI DOUBLE DANDAKHOJKI WORD SEPARATORKHOJK" +
	"I SECTION MARKKHOJKI DOUBLE SECTION MARKKHOJKI ABBREVIATION SIGNKHOJKI S" +
	"IGN SUKUNMULTANI LETTER AMULTANI LETTER IMULTANI LETTER UMULTANI LETTER " +
	"EMULTANI LETTER KAMULTANI LETTER KHAMULTANI LETTER GAMULTANI LETTER GHAM" +
	"ULTANI LETTER CAMULTANI LETTER CHAMULTANI LETTER JAMULTANI LETTER JJAMUL" +
	"TANI LETTER NYAMULTANI LETTER TTAMULTANI LETTER TTHAMULTANI LETTER DDAMU" +
	"LTANI LETTER DDDAMULTANI LETTER DDHAMULTANI LETTER NNAMULTANI LETTER TAM" +
	"ULTANI LETTER THAMULTANI LETTER DAMULTANI LETTER DHAMULTANI LETTER NAMUL" +
	"TANI LETTER PAMULTANI LETTER PHAMULTANI LETTER BAMULTANI LETTER BHAMULTA" +
	"NI LETTER MAMULTANI LETTER YAMULTANI LETTER RAMULTANI LETTER LAMULTANI L" +
	"ETTER VAMULTANI LETTER SAMULTANI LETTER HAMULTANI LETTER RRAMULTANI LETT" +
	"ER RHAMULTANI SECTION MARKKHUDAWADI LETTER AKHUDAWADI LETTER AAKHUDAWADI" +
	" LETTER IKHUDAWADI LETTER IIKHUDAWADI LETTER UKHUDAWADI LETTER UUKHUDAWA" +
	"DI LETTER EKHUDAWADI LETTER AIKHUDAWADI LETTER OKHUDAWADI LETTER AUKHUDA" +
	"WADI LETTER KAKHUDAWADI LETTER KHAKHUDAWADI LETTER GAKHUDAWADI LETTER GG" +
	"AKHUDAWADI LETTER GHAKHUDAWADI LETTER NGAKHUDAWADI LETTER CAKHUDAWADI LE" +
	"TTER CHAKHUDAWADI LETTER JAKHUDAWADI LETTER JJAKHUDAWADI LETTER JHAKHUDA" +
	"WADI LETTER NYAKHUDAWADI LETTER TTAKHUDAWADI LETTER TTHAKHUDAWADI LETTER" +
	" DDAKHUDAWADI LETTER DDDAKHUDAWADI LETTER RRAKHUDAWADI LETTER DDHAKHUDAW" +
	"ADI LETTER NNAKHUDAWADI LETTER TAKHUDAWADI LETTER THAKHUDAWADI LETTER DA" +
	"KHUDAWADI LETTER DHAKHUDAWADI LETTER NAKHUDAWADI LETTER PAKHUDAWADI LETT" +
	"ER PHAKHUDAWADI LETTER BAKHUDAWADI LETTER BBAKHUDAWADI LETTER BHAKHUDAWA" +
	"DI LETTER MAKHUDAWADI LETTER YAKHUDAWADI LETTER RAKHUDAWADI LETTER LAKHU" +
	"DAWADI LETTER VAKHUDAWADI LETTER SHAKHUDAWADI LETTER SAKHUDAWADI LETTER " +
	"HAKHUDAWADI SIGN ANUSVARAKHUDAWADI VOWEL SIGN AAKHUDAWADI VOWEL SIGN IKH" +
	"UDAWADI VOWEL SIGN IIKHUDAWADI VOWEL SIGN UKHUDAWADI VOWEL SIGN UUKHUDAW" +
	"ADI VOWEL SIGN EKHUDAWADI VOWEL SIGN AIKHUDAWADI VOWEL SIGN OKHUDAWADI V" +
	"OWEL SIGN AUKHUDAWADI SIGN NUKTAKHUDAWADI SIGN VIRAMAKHUDAWADI DIGIT ZER" +
	"OKHUDAWADI DIGIT ONEKHUDAWADI DIGIT TWOKHUDAWADI DIGIT THREEKHUDAWADI DI" +
	"GIT FOURKHUDAWADI DIGIT FIVEKHUDAWADI DIGIT SIXKHUDAWADI DIGIT SEVENKHUD" +
	"AWADI DIGIT EIGHTKHUDAWADI DIGIT NINEGRANTHA SIGN COMBINING ANUSVARA ABO" +
	"VEGRANTHA SIGN CANDRABINDUGRANTHA SIGN ANUSVARAGRANTHA SIGN VISARGAGRANT" +
	"HA LETTER AGRANTHA LETTER AAGRANTHA LETTER IGRANTHA LETTER IIGRANTHA LET" +
	"TER UGRANTHA LETTER UUGRANTHA LETTER VOCALIC RGRANTHA LETTER VOCALIC LGR" +
	"ANTHA LETTER EEGRANTHA LETTER AIGRANTHA LETTER OOGRANTHA LETTER AUGRANTH" +
	"A LETTER KAGRANTHA LETTER KHAGRANTHA LETTER GAGRANTHA LETTER GHAGRANTHA " +
	"LETTER NGAGRANTHA LETTER CAGRANTHA LETTER CHAGRANTHA LETTER JAGRANTHA LE" +
	"TTER JHAGRANTHA LETTER NYAGRANTHA LETTER TTAGRANTHA LETTER TTHAGRANTHA L" +
	"ETTER DDAGRANTHA LETTER DDHAGRANTHA LETTER NNAGRANTHA LETTER TAGRANTHA L" +
	"ETTER THAGRANTHA LETTER DAGRANTHA LETTER DHAGRANTHA LETTER NAGRANTHA LET" +
	"TER PAGRANTHA LETTER PHAGRANTHA LETTER BAGRANTHA LETTER BHAGRANTHA LETTE" +
	"R MAGRANTHA LETTER YAGRANTHA LETTER RAGRANTHA LETTER LAGRANTHA LETTER LL" +
	"AGRANTHA LETTER VAGRANTHA LETTER SHAGRANTHA LETTER SSAGRANTHA LETTER SAG" +
	"RANTHA LETTER HACOMBINING BINDU BELOWGRANTHA SIGN NUKTAGRANTHA SIGN AVAG" +
	"RAHAGRANTHA VOWEL SIGN AAGRANTHA VOWEL SIGN IGRANTHA VOWEL SIGN IIGRANTH" +
	"A VOWEL SIGN UGRANTHA VOWEL SIGN UUGRANTHA VOWEL SIGN VOCALIC RGRANTHA V" +
	"OWEL SIGN VOCALIC RRGRANTHA VOWEL SIGN EEGRANTHA VOWEL SIGN AIGRANTHA VO" +
	"WEL SIGN OOGRANTHA VOWEL SIGN AUGRANTHA SIGN VIRAMAGRANTHA OMGRANTHA AU ") + ("" +
	"LENGTH MARKGRANTHA SIGN PLUTAGRANTHA LETTER VEDIC ANUSVARAGRANTHA LETTER" +
	" VEDIC DOUBLE ANUSVARAGRANTHA LETTER VOCALIC RRGRANTHA LETTER VOCALIC LL" +
	"GRANTHA VOWEL SIGN VOCALIC LGRANTHA VOWEL SIGN VOCALIC LLCOMBINING GRANT" +
	"HA DIGIT ZEROCOMBINING GRANTHA DIGIT ONECOMBINING GRANTHA DIGIT TWOCOMBI" +
	"NING GRANTHA DIGIT THREECOMBINING GRANTHA DIGIT FOURCOMBINING GRANTHA DI" +
	"GIT FIVECOMBINING GRANTHA DIGIT SIXCOMBINING GRANTHA LETTER ACOMBINING G" +
	"RANTHA LETTER KACOMBINING GRANTHA LETTER NACOMBINING GRANTHA LETTER VICO" +
	"MBINING GRANTHA LETTER PANEWA LETTER ANEWA LETTER AANEWA LETTER INEWA LE" +
	"TTER IINEWA LETTER UNEWA LETTER UUNEWA LETTER VOCALIC RNEWA LETTER VOCAL" +
	"IC RRNEWA LETTER VOCALIC LNEWA LETTER VOCALIC LLNEWA LETTER ENEWA LETTER" +
	" AINEWA LETTER ONEWA LETTER AUNEWA LETTER KANEWA LETTER KHANEWA LETTER G" +
	"ANEWA LETTER GHANEWA LETTER NGANEWA LETTER NGHANEWA LETTER CANEWA LETTER" +
	" CHANEWA LETTER JANEWA LETTER JHANEWA LETTER NYANEWA LETTER NYHANEWA LET" +
	"TER TTANEWA LETTER TTHANEWA LETTER DDANEWA LETTER DDHANEWA LETTER NNANEW" +
	"A LETTER TANEWA LETTER THANEWA LETTER DANEWA LETTER DHANEWA LETTER NANEW" +
	"A LETTER NHANEWA LETTER PANEWA LETTER PHANEWA LETTER BANEWA LETTER BHANE" +
	"WA LETTER MANEWA LETTER MHANEWA LETTER YANEWA LETTER RANEWA LETTER RHANE" +
	"WA LETTER LANEWA LETTER LHANEWA LETTER WANEWA LETTER SHANEWA LETTER SSAN" +
	"EWA LETTER SANEWA LETTER HANEWA VOWEL SIGN AANEWA VOWEL SIGN INEWA VOWEL" +
	" SIGN IINEWA VOWEL SIGN UNEWA VOWEL SIGN UUNEWA VOWEL SIGN VOCALIC RNEWA" +
	" VOWEL SIGN VOCALIC RRNEWA VOWEL SIGN VOCALIC LNEWA VOWEL SIGN VOCALIC L" +
	"LNEWA VOWEL SIGN ENEWA VOWEL SIGN AINEWA VOWEL SIGN ONEWA VOWEL SIGN AUN" +
	"EWA SIGN VIRAMANEWA SIGN CANDRABINDUNEWA SIGN ANUSVARANEWA SIGN VISARGAN" +
	"EWA SIGN NUKTANEWA SIGN AVAGRAHANEWA SIGN FINAL ANUSVARANEWA OMNEWA SIDD" +
	"HINEWA DANDANEWA DOUBLE DANDANEWA COMMANEWA GAP FILLERNEWA ABBREVIATION " +
	"SIGNNEWA DIGIT ZERONEWA DIGIT ONENEWA DIGIT TWONEWA DIGIT THREENEWA DIGI" +
	"T FOURNEWA DIGIT FIVENEWA DIGIT SIXNEWA DIGIT SEVENNEWA DIGIT EIGHTNEWA " +
	"DIGIT NINENEWA PLACEHOLDER MARKNEWA INSERTION SIGNNEWA SANDHI MARKNEWA L" +
	"ETTER VEDIC ANUSVARATIRHUTA ANJITIRHUTA LETTER ATIRHUTA LETTER AATIRHUTA" +
	" LETTER ITIRHUTA LETTER IITIRHUTA LETTER UTIRHUTA LETTER UUTIRHUTA LETTE" +
	"R VOCALIC RTIRHUTA LETTER VOCALIC RRTIRHUTA LETTER VOCALIC LTIRHUTA LETT" +
	"ER VOCALIC LLTIRHUTA LETTER ETIRHUTA LETTER AITIRHUTA LETTER OTIRHUTA LE" +
	"TTER AUTIRHUTA LETTER KATIRHUTA LETTER KHATIRHUTA LETTER GATIRHUTA LETTE" +
	"R GHATIRHUTA LETTER NGATIRHUTA LETTER CATIRHUTA LETTER CHATIRHUTA LETTER" +
	" JATIRHUTA LETTER JHATIRHUTA LETTER NYATIRHUTA LETTER TTATIRHUTA LETTER " +
	"TTHATIRHUTA LETTER DDATIRHUTA LETTER DDHATIRHUTA LETTER NNATIRHUTA LETTE" +
	"R TATIRHUTA LETTER THATIRHUTA LETTER DATIRHUTA LETTER DHATIRHUTA LETTER " +
	"NATIRHUTA LETTER PATIRHUTA LETTER PHATIRHUTA LETTER BATIRHUTA LETTER BHA" +
	"TIRHUTA LETTER MATIRHUTA LETTER YATIRHUTA LETTER RATIRHUTA LETTER LATIRH" +
	"UTA LETTER VATIRHUTA LETTER SHATIRHUTA LETTER SSATIRHUTA LETTER SATIRHUT" +
	"A LETTER HATIRHUTA VOWEL SIGN AATIRHUTA VOWEL SIGN ITIRHUTA VOWEL SIGN I" +
	"ITIRHUTA VOWEL SIGN UTIRHUTA VOWEL SIGN UUTIRHUTA VOWEL SIGN VOCALIC RTI" +
	"RHUTA VOWEL SIGN VOCALIC RRTIRHUTA VOWEL SIGN VOCALIC LTIRHUTA VOWEL SIG" +
	"N VOCALIC LLTIRHUTA VOWEL SIGN ETIRHUTA VOWEL SIGN SHORT ETIRHUTA VOWEL " +
	"SIGN AITIRHUTA VOWEL SIGN OTIRHUTA VOWEL SIGN SHORT OTIRHUTA VOWEL SIGN " +
	"AUTIRHUTA SIGN CANDRABINDUTIRHUTA SIGN ANUSVARATIRHUTA SIGN VISARGATIRHU" +
	"TA SIGN VIRAMATIRHUTA SIGN NUKTATIRHUTA SIGN AVAGRAHATIRHUTA GVANGTIRHUT" +
	"A ABBREVIATION SIGNTIRHUTA OMTIRHUTA DIGIT ZEROTIRHUTA DIGIT ONETIRHUTA " +
	"DIGIT TWOTIRHUTA DIGIT THREETIRHUTA DIGIT FOURTIRHUTA DIGIT FIVETIRHUTA " +
	"DIGIT SIXTIRHUTA DIGIT SEVENTIRHUTA DIGIT EIGHTTIRHUTA DIGIT NINESIDDHAM" +
	" LETTER ASIDDHAM LETTER AASIDDHAM LETTER ISIDDHAM LETTER IISIDDHAM LETTE" +
	"R USIDDHAM LETTER UUSIDDHAM LETTER VOCALIC RSIDDHAM LETTER VOCALIC RRSID" +
	"DHAM LETTER VOCALIC LSIDDHAM LETTER VOCALIC LLSIDDHAM LETTER ESIDDHAM LE" +
	"TTER AISIDDHAM LETTER OSIDDHAM LETTER AUSIDDHAM LETTER KASIDDHAM LETTER " +
	"KHASIDDHAM LETTER GASIDDHAM LETTER GHASIDDHAM LETTER NGASIDDHAM LETTER C" +
	"ASIDDHAM LETTER CHASIDDHAM LETTER JASIDDHAM LETTER JHASIDDHAM LETTER NYA" +
	"SIDDHAM LETTER TTASIDDHAM LETTER TTHASIDDHAM LETTER DDASIDDHAM LETTER DD" +
	"HASIDDHAM LETTER NNASIDDHAM LETTER TASIDDHAM LETTER THASIDDHAM LETTER DA" +
	"SIDDHAM LETTER DHASIDDHAM LETTER NASIDDHAM LETTER PASIDDHAM LETTER PHASI" +
	"DDHAM LETTER BASIDDHAM LETTER BHASIDDHAM LETTER MASIDDHAM LETTER YASIDDH" +
	"AM LETTER RASIDDHAM LETTER LASIDDHAM LETTER VASIDDHAM LETTER SHASIDDHAM " +
	"LETTER SSASIDDHAM LETTER SASIDDHAM LETTER HASIDDHAM VOWEL SIGN AASIDDHAM" +
	" VOWEL SIGN ISIDDHAM VOWEL SIGN IISIDDHAM VOWEL SIGN USIDDHAM VOWEL SIGN" +
	" UUSIDDHAM VOWEL SIGN VOCALIC RSIDDHAM VOWEL SIGN VOCALIC RRSIDDHAM VOWE") + ("" +
	"L SIGN ESIDDHAM VOWEL SIGN AISIDDHAM VOWEL SIGN OSIDDHAM VOWEL SIGN AUSI" +
	"DDHAM SIGN CANDRABINDUSIDDHAM SIGN ANUSVARASIDDHAM SIGN VISARGASIDDHAM S" +
	"IGN VIRAMASIDDHAM SIGN NUKTASIDDHAM SIGN SIDDHAMSIDDHAM DANDASIDDHAM DOU" +
	"BLE DANDASIDDHAM SEPARATOR DOTSIDDHAM SEPARATOR BARSIDDHAM REPETITION MA" +
	"RK-1SIDDHAM REPETITION MARK-2SIDDHAM REPETITION MARK-3SIDDHAM END OF TEX" +
	"T MARKSIDDHAM SECTION MARK WITH TRIDENT AND U-SHAPED ORNAMENTSSIDDHAM SE" +
	"CTION MARK WITH TRIDENT AND DOTTED CRESCENTSSIDDHAM SECTION MARK WITH RA" +
	"YS AND DOTTED CRESCENTSSIDDHAM SECTION MARK WITH RAYS AND DOTTED DOUBLE " +
	"CRESCENTSSIDDHAM SECTION MARK WITH RAYS AND DOTTED TRIPLE CRESCENTSSIDDH" +
	"AM SECTION MARK DOUBLE RINGSIDDHAM SECTION MARK DOUBLE RING WITH RAYSSID" +
	"DHAM SECTION MARK WITH DOUBLE CRESCENTSSIDDHAM SECTION MARK WITH TRIPLE " +
	"CRESCENTSSIDDHAM SECTION MARK WITH QUADRUPLE CRESCENTSSIDDHAM SECTION MA" +
	"RK WITH SEPTUPLE CRESCENTSSIDDHAM SECTION MARK WITH CIRCLES AND RAYSSIDD" +
	"HAM SECTION MARK WITH CIRCLES AND TWO ENCLOSURESSIDDHAM SECTION MARK WIT" +
	"H CIRCLES AND FOUR ENCLOSURESSIDDHAM LETTER THREE-CIRCLE ALTERNATE ISIDD" +
	"HAM LETTER TWO-CIRCLE ALTERNATE ISIDDHAM LETTER TWO-CIRCLE ALTERNATE IIS" +
	"IDDHAM LETTER ALTERNATE USIDDHAM VOWEL SIGN ALTERNATE USIDDHAM VOWEL SIG" +
	"N ALTERNATE UUMODI LETTER AMODI LETTER AAMODI LETTER IMODI LETTER IIMODI" +
	" LETTER UMODI LETTER UUMODI LETTER VOCALIC RMODI LETTER VOCALIC RRMODI L" +
	"ETTER VOCALIC LMODI LETTER VOCALIC LLMODI LETTER EMODI LETTER AIMODI LET" +
	"TER OMODI LETTER AUMODI LETTER KAMODI LETTER KHAMODI LETTER GAMODI LETTE" +
	"R GHAMODI LETTER NGAMODI LETTER CAMODI LETTER CHAMODI LETTER JAMODI LETT" +
	"ER JHAMODI LETTER NYAMODI LETTER TTAMODI LETTER TTHAMODI LETTER DDAMODI " +
	"LETTER DDHAMODI LETTER NNAMODI LETTER TAMODI LETTER THAMODI LETTER DAMOD" +
	"I LETTER DHAMODI LETTER NAMODI LETTER PAMODI LETTER PHAMODI LETTER BAMOD" +
	"I LETTER BHAMODI LETTER MAMODI LETTER YAMODI LETTER RAMODI LETTER LAMODI" +
	" LETTER VAMODI LETTER SHAMODI LETTER SSAMODI LETTER SAMODI LETTER HAMODI" +
	" LETTER LLAMODI VOWEL SIGN AAMODI VOWEL SIGN IMODI VOWEL SIGN IIMODI VOW" +
	"EL SIGN UMODI VOWEL SIGN UUMODI VOWEL SIGN VOCALIC RMODI VOWEL SIGN VOCA" +
	"LIC RRMODI VOWEL SIGN VOCALIC LMODI VOWEL SIGN VOCALIC LLMODI VOWEL SIGN" +
	" EMODI VOWEL SIGN AIMODI VOWEL SIGN OMODI VOWEL SIGN AUMODI SIGN ANUSVAR" +
	"AMODI SIGN VISARGAMODI SIGN VIRAMAMODI SIGN ARDHACANDRAMODI DANDAMODI DO" +
	"UBLE DANDAMODI ABBREVIATION SIGNMODI SIGN HUVAMODI DIGIT ZEROMODI DIGIT " +
	"ONEMODI DIGIT TWOMODI DIGIT THREEMODI DIGIT FOURMODI DIGIT FIVEMODI DIGI" +
	"T SIXMODI DIGIT SEVENMODI DIGIT EIGHTMODI DIGIT NINEMONGOLIAN BIRGA WITH" +
	" ORNAMENTMONGOLIAN ROTATED BIRGAMONGOLIAN DOUBLE BIRGA WITH ORNAMENTMONG" +
	"OLIAN TRIPLE BIRGA WITH ORNAMENTMONGOLIAN BIRGA WITH DOUBLE ORNAMENTMONG" +
	"OLIAN ROTATED BIRGA WITH ORNAMENTMONGOLIAN ROTATED BIRGA WITH DOUBLE ORN" +
	"AMENTMONGOLIAN INVERTED BIRGAMONGOLIAN INVERTED BIRGA WITH DOUBLE ORNAME" +
	"NTMONGOLIAN SWIRL BIRGAMONGOLIAN SWIRL BIRGA WITH ORNAMENTMONGOLIAN SWIR" +
	"L BIRGA WITH DOUBLE ORNAMENTMONGOLIAN TURNED SWIRL BIRGA WITH DOUBLE ORN" +
	"AMENTTAKRI LETTER ATAKRI LETTER AATAKRI LETTER ITAKRI LETTER IITAKRI LET" +
	"TER UTAKRI LETTER UUTAKRI LETTER ETAKRI LETTER AITAKRI LETTER OTAKRI LET" +
	"TER AUTAKRI LETTER KATAKRI LETTER KHATAKRI LETTER GATAKRI LETTER GHATAKR" +
	"I LETTER NGATAKRI LETTER CATAKRI LETTER CHATAKRI LETTER JATAKRI LETTER J" +
	"HATAKRI LETTER NYATAKRI LETTER TTATAKRI LETTER TTHATAKRI LETTER DDATAKRI" +
	" LETTER DDHATAKRI LETTER NNATAKRI LETTER TATAKRI LETTER THATAKRI LETTER " +
	"DATAKRI LETTER DHATAKRI LETTER NATAKRI LETTER PATAKRI LETTER PHATAKRI LE" +
	"TTER BATAKRI LETTER BHATAKRI LETTER MATAKRI LETTER YATAKRI LETTER RATAKR" +
	"I LETTER LATAKRI LETTER VATAKRI LETTER SHATAKRI LETTER SATAKRI LETTER HA" +
	"TAKRI LETTER RRATAKRI SIGN ANUSVARATAKRI SIGN VISARGATAKRI VOWEL SIGN AA" +
	"TAKRI VOWEL SIGN ITAKRI VOWEL SIGN IITAKRI VOWEL SIGN UTAKRI VOWEL SIGN " +
	"UUTAKRI VOWEL SIGN ETAKRI VOWEL SIGN AITAKRI VOWEL SIGN OTAKRI VOWEL SIG" +
	"N AUTAKRI SIGN VIRAMATAKRI SIGN NUKTATAKRI LETTER ARCHAIC KHATAKRI DIGIT" +
	" ZEROTAKRI DIGIT ONETAKRI DIGIT TWOTAKRI DIGIT THREETAKRI DIGIT FOURTAKR" +
	"I DIGIT FIVETAKRI DIGIT SIXTAKRI DIGIT SEVENTAKRI DIGIT EIGHTTAKRI DIGIT" +
	" NINEAHOM LETTER KAAHOM LETTER KHAAHOM LETTER NGAAHOM LETTER NAAHOM LETT" +
	"ER TAAHOM LETTER ALTERNATE TAAHOM LETTER PAAHOM LETTER PHAAHOM LETTER BA" +
	"AHOM LETTER MAAHOM LETTER JAAHOM LETTER CHAAHOM LETTER THAAHOM LETTER RA" +
	"AHOM LETTER LAAHOM LETTER SAAHOM LETTER NYAAHOM LETTER HAAHOM LETTER AAH" +
	"OM LETTER DAAHOM LETTER DHAAHOM LETTER GAAHOM LETTER ALTERNATE GAAHOM LE" +
	"TTER GHAAHOM LETTER BHAAHOM LETTER JHAAHOM LETTER ALTERNATE BAAHOM CONSO" +
	"NANT SIGN MEDIAL LAAHOM CONSONANT SIGN MEDIAL RAAHOM CONSONANT SIGN MEDI" +
	"AL LIGATING RAAHOM VOWEL SIGN AAHOM VOWEL SIGN AAAHOM VOWEL SIGN IAHOM V") + ("" +
	"OWEL SIGN IIAHOM VOWEL SIGN UAHOM VOWEL SIGN UUAHOM VOWEL SIGN EAHOM VOW" +
	"EL SIGN AWAHOM VOWEL SIGN OAHOM VOWEL SIGN AIAHOM VOWEL SIGN AMAHOM SIGN" +
	" KILLERAHOM DIGIT ZEROAHOM DIGIT ONEAHOM DIGIT TWOAHOM DIGIT THREEAHOM D" +
	"IGIT FOURAHOM DIGIT FIVEAHOM DIGIT SIXAHOM DIGIT SEVENAHOM DIGIT EIGHTAH" +
	"OM DIGIT NINEAHOM NUMBER TENAHOM NUMBER TWENTYAHOM SIGN SMALL SECTIONAHO" +
	"M SIGN SECTIONAHOM SIGN RULAIAHOM SYMBOL VIDOGRA LETTER ADOGRA LETTER AA" +
	"DOGRA LETTER IDOGRA LETTER IIDOGRA LETTER UDOGRA LETTER UUDOGRA LETTER E" +
	"DOGRA LETTER AIDOGRA LETTER ODOGRA LETTER AUDOGRA LETTER KADOGRA LETTER " +
	"KHADOGRA LETTER GADOGRA LETTER GHADOGRA LETTER NGADOGRA LETTER CADOGRA L" +
	"ETTER CHADOGRA LETTER JADOGRA LETTER JHADOGRA LETTER NYADOGRA LETTER TTA" +
	"DOGRA LETTER TTHADOGRA LETTER DDADOGRA LETTER DDHADOGRA LETTER NNADOGRA " +
	"LETTER TADOGRA LETTER THADOGRA LETTER DADOGRA LETTER DHADOGRA LETTER NAD" +
	"OGRA LETTER PADOGRA LETTER PHADOGRA LETTER BADOGRA LETTER BHADOGRA LETTE" +
	"R MADOGRA LETTER YADOGRA LETTER RADOGRA LETTER LADOGRA LETTER VADOGRA LE" +
	"TTER SHADOGRA LETTER SSADOGRA LETTER SADOGRA LETTER HADOGRA LETTER RRADO" +
	"GRA VOWEL SIGN AADOGRA VOWEL SIGN IDOGRA VOWEL SIGN IIDOGRA VOWEL SIGN U" +
	"DOGRA VOWEL SIGN UUDOGRA VOWEL SIGN VOCALIC RDOGRA VOWEL SIGN VOCALIC RR" +
	"DOGRA VOWEL SIGN EDOGRA VOWEL SIGN AIDOGRA VOWEL SIGN ODOGRA VOWEL SIGN " +
	"AUDOGRA SIGN ANUSVARADOGRA SIGN VISARGADOGRA SIGN VIRAMADOGRA SIGN NUKTA" +
	"DOGRA ABBREVIATION SIGNWARANG CITI CAPITAL LETTER NGAAWARANG CITI CAPITA" +
	"L LETTER AWARANG CITI CAPITAL LETTER WIWARANG CITI CAPITAL LETTER YUWARA" +
	"NG CITI CAPITAL LETTER YAWARANG CITI CAPITAL LETTER YOWARANG CITI CAPITA" +
	"L LETTER IIWARANG CITI CAPITAL LETTER UUWARANG CITI CAPITAL LETTER EWARA" +
	"NG CITI CAPITAL LETTER OWARANG CITI CAPITAL LETTER ANGWARANG CITI CAPITA" +
	"L LETTER GAWARANG CITI CAPITAL LETTER KOWARANG CITI CAPITAL LETTER ENYWA" +
	"RANG CITI CAPITAL LETTER YUJWARANG CITI CAPITAL LETTER UCWARANG CITI CAP" +
	"ITAL LETTER ENNWARANG CITI CAPITAL LETTER ODDWARANG CITI CAPITAL LETTER " +
	"TTEWARANG CITI CAPITAL LETTER NUNGWARANG CITI CAPITAL LETTER DAWARANG CI" +
	"TI CAPITAL LETTER ATWARANG CITI CAPITAL LETTER AMWARANG CITI CAPITAL LET" +
	"TER BUWARANG CITI CAPITAL LETTER PUWARANG CITI CAPITAL LETTER HIYOWARANG" +
	" CITI CAPITAL LETTER HOLOWARANG CITI CAPITAL LETTER HORRWARANG CITI CAPI" +
	"TAL LETTER HARWARANG CITI CAPITAL LETTER SSUUWARANG CITI CAPITAL LETTER " +
	"SIIWARANG CITI CAPITAL LETTER VIYOWARANG CITI SMALL LETTER NGAAWARANG CI" +
	"TI SMALL LETTER AWARANG CITI SMALL LETTER WIWARANG CITI SMALL LETTER YUW" +
	"ARANG CITI SMALL LETTER YAWARANG CITI SMALL LETTER YOWARANG CITI SMALL L" +
	"ETTER IIWARANG CITI SMALL LETTER UUWARANG CITI SMALL LETTER EWARANG CITI" +
	" SMALL LETTER OWARANG CITI SMALL LETTER ANGWARANG CITI SMALL LETTER GAWA" +
	"RANG CITI SMALL LETTER KOWARANG CITI SMALL LETTER ENYWARANG CITI SMALL L" +
	"ETTER YUJWARANG CITI SMALL LETTER UCWARANG CITI SMALL LETTER ENNWARANG C" +
	"ITI SMALL LETTER ODDWARANG CITI SMALL LETTER TTEWARANG CITI SMALL LETTER" +
	" NUNGWARANG CITI SMALL LETTER DAWARANG CITI SMALL LETTER ATWARANG CITI S" +
	"MALL LETTER AMWARANG CITI SMALL LETTER BUWARANG CITI SMALL LETTER PUWARA" +
	"NG CITI SMALL LETTER HIYOWARANG CITI SMALL LETTER HOLOWARANG CITI SMALL " +
	"LETTER HORRWARANG CITI SMALL LETTER HARWARANG CITI SMALL LETTER SSUUWARA" +
	"NG CITI SMALL LETTER SIIWARANG CITI SMALL LETTER VIYOWARANG CITI DIGIT Z" +
	"EROWARANG CITI DIGIT ONEWARANG CITI DIGIT TWOWARANG CITI DIGIT THREEWARA" +
	"NG CITI DIGIT FOURWARANG CITI DIGIT FIVEWARANG CITI DIGIT SIXWARANG CITI" +
	" DIGIT SEVENWARANG CITI DIGIT EIGHTWARANG CITI DIGIT NINEWARANG CITI NUM" +
	"BER TENWARANG CITI NUMBER TWENTYWARANG CITI NUMBER THIRTYWARANG CITI NUM" +
	"BER FORTYWARANG CITI NUMBER FIFTYWARANG CITI NUMBER SIXTYWARANG CITI NUM" +
	"BER SEVENTYWARANG CITI NUMBER EIGHTYWARANG CITI NUMBER NINETYWARANG CITI" +
	" OMNANDINAGARI LETTER ANANDINAGARI LETTER AANANDINAGARI LETTER INANDINAG" +
	"ARI LETTER IINANDINAGARI LETTER UNANDINAGARI LETTER UUNANDINAGARI LETTER" +
	" VOCALIC RNANDINAGARI LETTER VOCALIC RRNANDINAGARI LETTER ENANDINAGARI L" +
	"ETTER AINANDINAGARI LETTER ONANDINAGARI LETTER AUNANDINAGARI LETTER KANA" +
	"NDINAGARI LETTER KHANANDINAGARI LETTER GANANDINAGARI LETTER GHANANDINAGA" +
	"RI LETTER NGANANDINAGARI LETTER CANANDINAGARI LETTER CHANANDINAGARI LETT" +
	"ER JANANDINAGARI LETTER JHANANDINAGARI LETTER NYANANDINAGARI LETTER TTAN" +
	"ANDINAGARI LETTER TTHANANDINAGARI LETTER DDANANDINAGARI LETTER DDHANANDI" +
	"NAGARI LETTER NNANANDINAGARI LETTER TANANDINAGARI LETTER THANANDINAGARI " +
	"LETTER DANANDINAGARI LETTER DHANANDINAGARI LETTER NANANDINAGARI LETTER P" +
	"ANANDINAGARI LETTER PHANANDINAGARI LETTER BANANDINAGARI LETTER BHANANDIN" +
	"AGARI LETTER MANANDINAGARI LETTER YANANDINAGARI LETTER RANANDINAGARI LET" +
	"TER LANANDINAGARI LETTER VANANDINAGARI LETTER SHANANDINAGARI LETTER SSAN") + ("" +
	"ANDINAGARI LETTER SANANDINAGARI LETTER HANANDINAGARI LETTER LLANANDINAGA" +
	"RI LETTER RRANANDINAGARI VOWEL SIGN AANANDINAGARI VOWEL SIGN INANDINAGAR" +
	"I VOWEL SIGN IINANDINAGARI VOWEL SIGN UNANDINAGARI VOWEL SIGN UUNANDINAG" +
	"ARI VOWEL SIGN VOCALIC RNANDINAGARI VOWEL SIGN VOCALIC RRNANDINAGARI VOW" +
	"EL SIGN ENANDINAGARI VOWEL SIGN AINANDINAGARI VOWEL SIGN ONANDINAGARI VO" +
	"WEL SIGN AUNANDINAGARI SIGN ANUSVARANANDINAGARI SIGN VISARGANANDINAGARI " +
	"SIGN VIRAMANANDINAGARI SIGN AVAGRAHANANDINAGARI SIGN SIDDHAMNANDINAGARI " +
	"HEADSTROKENANDINAGARI VOWEL SIGN PRISHTHAMATRA EZANABAZAR SQUARE LETTER " +
	"AZANABAZAR SQUARE VOWEL SIGN IZANABAZAR SQUARE VOWEL SIGN UEZANABAZAR SQ" +
	"UARE VOWEL SIGN UZANABAZAR SQUARE VOWEL SIGN EZANABAZAR SQUARE VOWEL SIG" +
	"N OEZANABAZAR SQUARE VOWEL SIGN OZANABAZAR SQUARE VOWEL SIGN AIZANABAZAR" +
	" SQUARE VOWEL SIGN AUZANABAZAR SQUARE VOWEL SIGN REVERSED IZANABAZAR SQU" +
	"ARE VOWEL LENGTH MARKZANABAZAR SQUARE LETTER KAZANABAZAR SQUARE LETTER K" +
	"HAZANABAZAR SQUARE LETTER GAZANABAZAR SQUARE LETTER GHAZANABAZAR SQUARE " +
	"LETTER NGAZANABAZAR SQUARE LETTER CAZANABAZAR SQUARE LETTER CHAZANABAZAR" +
	" SQUARE LETTER JAZANABAZAR SQUARE LETTER NYAZANABAZAR SQUARE LETTER TTAZ" +
	"ANABAZAR SQUARE LETTER TTHAZANABAZAR SQUARE LETTER DDAZANABAZAR SQUARE L" +
	"ETTER DDHAZANABAZAR SQUARE LETTER NNAZANABAZAR SQUARE LETTER TAZANABAZAR" +
	" SQUARE LETTER THAZANABAZAR SQUARE LETTER DAZANABAZAR SQUARE LETTER DHAZ" +
	"ANABAZAR SQUARE LETTER NAZANABAZAR SQUARE LETTER PAZANABAZAR SQUARE LETT" +
	"ER PHAZANABAZAR SQUARE LETTER BAZANABAZAR SQUARE LETTER BHAZANABAZAR SQU" +
	"ARE LETTER MAZANABAZAR SQUARE LETTER TSAZANABAZAR SQUARE LETTER TSHAZANA" +
	"BAZAR SQUARE LETTER DZAZANABAZAR SQUARE LETTER DZHAZANABAZAR SQUARE LETT" +
	"ER ZHAZANABAZAR SQUARE LETTER ZAZANABAZAR SQUARE LETTER -AZANABAZAR SQUA" +
	"RE LETTER YAZANABAZAR SQUARE LETTER RAZANABAZAR SQUARE LETTER LAZANABAZA" +
	"R SQUARE LETTER VAZANABAZAR SQUARE LETTER SHAZANABAZAR SQUARE LETTER SSA" +
	"ZANABAZAR SQUARE LETTER SAZANABAZAR SQUARE LETTER HAZANABAZAR SQUARE LET" +
	"TER KSSAZANABAZAR SQUARE FINAL CONSONANT MARKZANABAZAR SQUARE SIGN VIRAM" +
	"AZANABAZAR SQUARE SIGN CANDRABINDUZANABAZAR SQUARE SIGN CANDRABINDU WITH" +
	" ORNAMENTZANABAZAR SQUARE SIGN CANDRA WITH ORNAMENTZANABAZAR SQUARE SIGN" +
	" ANUSVARAZANABAZAR SQUARE SIGN VISARGAZANABAZAR SQUARE CLUSTER-INITIAL L" +
	"ETTER RAZANABAZAR SQUARE CLUSTER-FINAL LETTER YAZANABAZAR SQUARE CLUSTER" +
	"-FINAL LETTER RAZANABAZAR SQUARE CLUSTER-FINAL LETTER LAZANABAZAR SQUARE" +
	" CLUSTER-FINAL LETTER VAZANABAZAR SQUARE INITIAL HEAD MARKZANABAZAR SQUA" +
	"RE CLOSING HEAD MARKZANABAZAR SQUARE MARK TSHEGZANABAZAR SQUARE MARK SHA" +
	"DZANABAZAR SQUARE MARK DOUBLE SHADZANABAZAR SQUARE MARK LONG TSHEGZANABA" +
	"ZAR SQUARE INITIAL DOUBLE-LINED HEAD MARKZANABAZAR SQUARE CLOSING DOUBLE" +
	"-LINED HEAD MARKZANABAZAR SQUARE SUBJOINERSOYOMBO LETTER ASOYOMBO VOWEL " +
	"SIGN ISOYOMBO VOWEL SIGN UESOYOMBO VOWEL SIGN USOYOMBO VOWEL SIGN ESOYOM" +
	"BO VOWEL SIGN OSOYOMBO VOWEL SIGN OESOYOMBO VOWEL SIGN AISOYOMBO VOWEL S" +
	"IGN AUSOYOMBO VOWEL SIGN VOCALIC RSOYOMBO VOWEL SIGN VOCALIC LSOYOMBO VO" +
	"WEL LENGTH MARKSOYOMBO LETTER KASOYOMBO LETTER KHASOYOMBO LETTER GASOYOM" +
	"BO LETTER GHASOYOMBO LETTER NGASOYOMBO LETTER CASOYOMBO LETTER CHASOYOMB" +
	"O LETTER JASOYOMBO LETTER JHASOYOMBO LETTER NYASOYOMBO LETTER TTASOYOMBO" +
	" LETTER TTHASOYOMBO LETTER DDASOYOMBO LETTER DDHASOYOMBO LETTER NNASOYOM" +
	"BO LETTER TASOYOMBO LETTER THASOYOMBO LETTER DASOYOMBO LETTER DHASOYOMBO" +
	" LETTER NASOYOMBO LETTER PASOYOMBO LETTER PHASOYOMBO LETTER BASOYOMBO LE" +
	"TTER BHASOYOMBO LETTER MASOYOMBO LETTER TSASOYOMBO LETTER TSHASOYOMBO LE" +
	"TTER DZASOYOMBO LETTER ZHASOYOMBO LETTER ZASOYOMBO LETTER -ASOYOMBO LETT" +
	"ER YASOYOMBO LETTER RASOYOMBO LETTER LASOYOMBO LETTER VASOYOMBO LETTER S" +
	"HASOYOMBO LETTER SSASOYOMBO LETTER SASOYOMBO LETTER HASOYOMBO LETTER KSS" +
	"ASOYOMBO SIGN JIHVAMULIYASOYOMBO SIGN UPADHMANIYASOYOMBO CLUSTER-INITIAL" +
	" LETTER RASOYOMBO CLUSTER-INITIAL LETTER LASOYOMBO CLUSTER-INITIAL LETTE" +
	"R SHASOYOMBO CLUSTER-INITIAL LETTER SASOYOMBO FINAL CONSONANT SIGN GSOYO" +
	"MBO FINAL CONSONANT SIGN KSOYOMBO FINAL CONSONANT SIGN NGSOYOMBO FINAL C" +
	"ONSONANT SIGN DSOYOMBO FINAL CONSONANT SIGN NSOYOMBO FINAL CONSONANT SIG" +
	"N BSOYOMBO FINAL CONSONANT SIGN MSOYOMBO FINAL CONSONANT SIGN RSOYOMBO F" +
	"INAL CONSONANT SIGN LSOYOMBO FINAL CONSONANT SIGN SHSOYOMBO FINAL CONSON" +
	"ANT SIGN SSOYOMBO FINAL CONSONANT SIGN -ASOYOMBO SIGN ANUSVARASOYOMBO SI" +
	"GN VISARGASOYOMBO GEMINATION MARKSOYOMBO SUBJOINERSOYOMBO MARK TSHEGSOYO" +
	"MBO MARK SHADSOYOMBO MARK DOUBLE SHADSOYOMBO MARK PLUTASOYOMBO HEAD MARK" +
	" WITH MOON AND SUN AND TRIPLE FLAMESOYOMBO HEAD MARK WITH MOON AND SUN A" +
	"ND FLAMESOYOMBO HEAD MARK WITH MOON AND SUNSOYOMBO TERMINAL MARK-1SOYOMB" +
	"O TERMINAL MARK-2PAU CIN HAU LETTER PAPAU CIN HAU LETTER KAPAU CIN HAU L") + ("" +
	"ETTER LAPAU CIN HAU LETTER MAPAU CIN HAU LETTER DAPAU CIN HAU LETTER ZAP" +
	"AU CIN HAU LETTER VAPAU CIN HAU LETTER NGAPAU CIN HAU LETTER HAPAU CIN H" +
	"AU LETTER GAPAU CIN HAU LETTER KHAPAU CIN HAU LETTER SAPAU CIN HAU LETTE" +
	"R BAPAU CIN HAU LETTER CAPAU CIN HAU LETTER TAPAU CIN HAU LETTER THAPAU " +
	"CIN HAU LETTER NAPAU CIN HAU LETTER PHAPAU CIN HAU LETTER RAPAU CIN HAU " +
	"LETTER FAPAU CIN HAU LETTER CHAPAU CIN HAU LETTER APAU CIN HAU LETTER EP" +
	"AU CIN HAU LETTER IPAU CIN HAU LETTER OPAU CIN HAU LETTER UPAU CIN HAU L" +
	"ETTER UAPAU CIN HAU LETTER IAPAU CIN HAU LETTER FINAL PPAU CIN HAU LETTE" +
	"R FINAL KPAU CIN HAU LETTER FINAL TPAU CIN HAU LETTER FINAL MPAU CIN HAU" +
	" LETTER FINAL NPAU CIN HAU LETTER FINAL LPAU CIN HAU LETTER FINAL WPAU C" +
	"IN HAU LETTER FINAL NGPAU CIN HAU LETTER FINAL YPAU CIN HAU RISING TONE " +
	"LONGPAU CIN HAU RISING TONEPAU CIN HAU SANDHI GLOTTAL STOPPAU CIN HAU RI" +
	"SING TONE LONG FINALPAU CIN HAU RISING TONE FINALPAU CIN HAU SANDHI GLOT" +
	"TAL STOP FINALPAU CIN HAU SANDHI TONE LONGPAU CIN HAU SANDHI TONEPAU CIN" +
	" HAU SANDHI TONE LONG FINALPAU CIN HAU SANDHI TONE FINALPAU CIN HAU MID-" +
	"LEVEL TONEPAU CIN HAU GLOTTAL STOP VARIANTPAU CIN HAU MID-LEVEL TONE LON" +
	"G FINALPAU CIN HAU MID-LEVEL TONE FINALPAU CIN HAU LOW-FALLING TONE LONG" +
	"PAU CIN HAU LOW-FALLING TONEPAU CIN HAU GLOTTAL STOPPAU CIN HAU LOW-FALL" +
	"ING TONE LONG FINALPAU CIN HAU LOW-FALLING TONE FINALPAU CIN HAU GLOTTAL" +
	" STOP FINALBHAIKSUKI LETTER ABHAIKSUKI LETTER AABHAIKSUKI LETTER IBHAIKS" +
	"UKI LETTER IIBHAIKSUKI LETTER UBHAIKSUKI LETTER UUBHAIKSUKI LETTER VOCAL" +
	"IC RBHAIKSUKI LETTER VOCALIC RRBHAIKSUKI LETTER VOCALIC LBHAIKSUKI LETTE" +
	"R EBHAIKSUKI LETTER AIBHAIKSUKI LETTER OBHAIKSUKI LETTER AUBHAIKSUKI LET" +
	"TER KABHAIKSUKI LETTER KHABHAIKSUKI LETTER GABHAIKSUKI LETTER GHABHAIKSU" +
	"KI LETTER NGABHAIKSUKI LETTER CABHAIKSUKI LETTER CHABHAIKSUKI LETTER JAB" +
	"HAIKSUKI LETTER JHABHAIKSUKI LETTER NYABHAIKSUKI LETTER TTABHAIKSUKI LET" +
	"TER TTHABHAIKSUKI LETTER DDABHAIKSUKI LETTER DDHABHAIKSUKI LETTER NNABHA" +
	"IKSUKI LETTER TABHAIKSUKI LETTER THABHAIKSUKI LETTER DABHAIKSUKI LETTER " +
	"DHABHAIKSUKI LETTER NABHAIKSUKI LETTER PABHAIKSUKI LETTER PHABHAIKSUKI L" +
	"ETTER BABHAIKSUKI LETTER BHABHAIKSUKI LETTER MABHAIKSUKI LETTER YABHAIKS" +
	"UKI LETTER RABHAIKSUKI LETTER LABHAIKSUKI LETTER VABHAIKSUKI LETTER SHAB" +
	"HAIKSUKI LETTER SSABHAIKSUKI LETTER SABHAIKSUKI LETTER HABHAIKSUKI VOWEL" +
	" SIGN AABHAIKSUKI VOWEL SIGN IBHAIKSUKI VOWEL SIGN IIBHAIKSUKI VOWEL SIG" +
	"N UBHAIKSUKI VOWEL SIGN UUBHAIKSUKI VOWEL SIGN VOCALIC RBHAIKSUKI VOWEL " +
	"SIGN VOCALIC RRBHAIKSUKI VOWEL SIGN VOCALIC LBHAIKSUKI VOWEL SIGN EBHAIK" +
	"SUKI VOWEL SIGN AIBHAIKSUKI VOWEL SIGN OBHAIKSUKI VOWEL SIGN AUBHAIKSUKI" +
	" SIGN CANDRABINDUBHAIKSUKI SIGN ANUSVARABHAIKSUKI SIGN VISARGABHAIKSUKI " +
	"SIGN VIRAMABHAIKSUKI SIGN AVAGRAHABHAIKSUKI DANDABHAIKSUKI DOUBLE DANDAB" +
	"HAIKSUKI WORD SEPARATORBHAIKSUKI GAP FILLER-1BHAIKSUKI GAP FILLER-2BHAIK" +
	"SUKI DIGIT ZEROBHAIKSUKI DIGIT ONEBHAIKSUKI DIGIT TWOBHAIKSUKI DIGIT THR" +
	"EEBHAIKSUKI DIGIT FOURBHAIKSUKI DIGIT FIVEBHAIKSUKI DIGIT SIXBHAIKSUKI D" +
	"IGIT SEVENBHAIKSUKI DIGIT EIGHTBHAIKSUKI DIGIT NINEBHAIKSUKI NUMBER ONEB" +
	"HAIKSUKI NUMBER TWOBHAIKSUKI NUMBER THREEBHAIKSUKI NUMBER FOURBHAIKSUKI " +
	"NUMBER FIVEBHAIKSUKI NUMBER SIXBHAIKSUKI NUMBER SEVENBHAIKSUKI NUMBER EI" +
	"GHTBHAIKSUKI NUMBER NINEBHAIKSUKI NUMBER TENBHAIKSUKI NUMBER TWENTYBHAIK" +
	"SUKI NUMBER THIRTYBHAIKSUKI NUMBER FORTYBHAIKSUKI NUMBER FIFTYBHAIKSUKI " +
	"NUMBER SIXTYBHAIKSUKI NUMBER SEVENTYBHAIKSUKI NUMBER EIGHTYBHAIKSUKI NUM" +
	"BER NINETYBHAIKSUKI HUNDREDS UNIT MARKMARCHEN HEAD MARKMARCHEN MARK SHAD" +
	"MARCHEN LETTER KAMARCHEN LETTER KHAMARCHEN LETTER GAMARCHEN LETTER NGAMA" +
	"RCHEN LETTER CAMARCHEN LETTER CHAMARCHEN LETTER JAMARCHEN LETTER NYAMARC" +
	"HEN LETTER TAMARCHEN LETTER THAMARCHEN LETTER DAMARCHEN LETTER NAMARCHEN" +
	" LETTER PAMARCHEN LETTER PHAMARCHEN LETTER BAMARCHEN LETTER MAMARCHEN LE" +
	"TTER TSAMARCHEN LETTER TSHAMARCHEN LETTER DZAMARCHEN LETTER WAMARCHEN LE" +
	"TTER ZHAMARCHEN LETTER ZAMARCHEN LETTER -AMARCHEN LETTER YAMARCHEN LETTE" +
	"R RAMARCHEN LETTER LAMARCHEN LETTER SHAMARCHEN LETTER SAMARCHEN LETTER H" +
	"AMARCHEN LETTER AMARCHEN SUBJOINED LETTER KAMARCHEN SUBJOINED LETTER KHA" +
	"MARCHEN SUBJOINED LETTER GAMARCHEN SUBJOINED LETTER NGAMARCHEN SUBJOINED" +
	" LETTER CAMARCHEN SUBJOINED LETTER CHAMARCHEN SUBJOINED LETTER JAMARCHEN" +
	" SUBJOINED LETTER NYAMARCHEN SUBJOINED LETTER TAMARCHEN SUBJOINED LETTER" +
	" THAMARCHEN SUBJOINED LETTER DAMARCHEN SUBJOINED LETTER NAMARCHEN SUBJOI" +
	"NED LETTER PAMARCHEN SUBJOINED LETTER PHAMARCHEN SUBJOINED LETTER BAMARC" +
	"HEN SUBJOINED LETTER MAMARCHEN SUBJOINED LETTER TSAMARCHEN SUBJOINED LET" +
	"TER TSHAMARCHEN SUBJOINED LETTER DZAMARCHEN SUBJOINED LETTER WAMARCHEN S" +
	"UBJOINED LETTER ZHAMARCHEN SUBJOINED LETTER ZAMARCHEN SUBJOINED LETTER Y") + ("" +
	"AMARCHEN SUBJOINED LETTER RAMARCHEN SUBJOINED LETTER LAMARCHEN SUBJOINED" +
	" LETTER SHAMARCHEN SUBJOINED LETTER SAMARCHEN SUBJOINED LETTER HAMARCHEN" +
	" SUBJOINED LETTER AMARCHEN VOWEL SIGN AAMARCHEN VOWEL SIGN IMARCHEN VOWE" +
	"L SIGN UMARCHEN VOWEL SIGN EMARCHEN VOWEL SIGN OMARCHEN SIGN ANUSVARAMAR" +
	"CHEN SIGN CANDRABINDUMASARAM GONDI LETTER AMASARAM GONDI LETTER AAMASARA" +
	"M GONDI LETTER IMASARAM GONDI LETTER IIMASARAM GONDI LETTER UMASARAM GON" +
	"DI LETTER UUMASARAM GONDI LETTER EMASARAM GONDI LETTER AIMASARAM GONDI L" +
	"ETTER OMASARAM GONDI LETTER AUMASARAM GONDI LETTER KAMASARAM GONDI LETTE" +
	"R KHAMASARAM GONDI LETTER GAMASARAM GONDI LETTER GHAMASARAM GONDI LETTER" +
	" NGAMASARAM GONDI LETTER CAMASARAM GONDI LETTER CHAMASARAM GONDI LETTER " +
	"JAMASARAM GONDI LETTER JHAMASARAM GONDI LETTER NYAMASARAM GONDI LETTER T" +
	"TAMASARAM GONDI LETTER TTHAMASARAM GONDI LETTER DDAMASARAM GONDI LETTER " +
	"DDHAMASARAM GONDI LETTER NNAMASARAM GONDI LETTER TAMASARAM GONDI LETTER " +
	"THAMASARAM GONDI LETTER DAMASARAM GONDI LETTER DHAMASARAM GONDI LETTER N" +
	"AMASARAM GONDI LETTER PAMASARAM GONDI LETTER PHAMASARAM GONDI LETTER BAM" +
	"ASARAM GONDI LETTER BHAMASARAM GONDI LETTER MAMASARAM GONDI LETTER YAMAS" +
	"ARAM GONDI LETTER RAMASARAM GONDI LETTER LAMASARAM GONDI LETTER VAMASARA" +
	"M GONDI LETTER SHAMASARAM GONDI LETTER SSAMASARAM GONDI LETTER SAMASARAM" +
	" GONDI LETTER HAMASARAM GONDI LETTER LLAMASARAM GONDI LETTER KSSAMASARAM" +
	" GONDI LETTER JNYAMASARAM GONDI LETTER TRAMASARAM GONDI VOWEL SIGN AAMAS" +
	"ARAM GONDI VOWEL SIGN IMASARAM GONDI VOWEL SIGN IIMASARAM GONDI VOWEL SI" +
	"GN UMASARAM GONDI VOWEL SIGN UUMASARAM GONDI VOWEL SIGN VOCALIC RMASARAM" +
	" GONDI VOWEL SIGN EMASARAM GONDI VOWEL SIGN AIMASARAM GONDI VOWEL SIGN O" +
	"MASARAM GONDI VOWEL SIGN AUMASARAM GONDI SIGN ANUSVARAMASARAM GONDI SIGN" +
	" VISARGAMASARAM GONDI SIGN NUKTAMASARAM GONDI SIGN CANDRAMASARAM GONDI S" +
	"IGN HALANTAMASARAM GONDI VIRAMAMASARAM GONDI REPHAMASARAM GONDI RA-KARAM" +
	"ASARAM GONDI DIGIT ZEROMASARAM GONDI DIGIT ONEMASARAM GONDI DIGIT TWOMAS" +
	"ARAM GONDI DIGIT THREEMASARAM GONDI DIGIT FOURMASARAM GONDI DIGIT FIVEMA" +
	"SARAM GONDI DIGIT SIXMASARAM GONDI DIGIT SEVENMASARAM GONDI DIGIT EIGHTM" +
	"ASARAM GONDI DIGIT NINEGUNJALA GONDI LETTER AGUNJALA GONDI LETTER AAGUNJ" +
	"ALA GONDI LETTER IGUNJALA GONDI LETTER IIGUNJALA GONDI LETTER UGUNJALA G" +
	"ONDI LETTER UUGUNJALA GONDI LETTER EEGUNJALA GONDI LETTER AIGUNJALA GOND" +
	"I LETTER OOGUNJALA GONDI LETTER AUGUNJALA GONDI LETTER YAGUNJALA GONDI L" +
	"ETTER VAGUNJALA GONDI LETTER BAGUNJALA GONDI LETTER BHAGUNJALA GONDI LET" +
	"TER MAGUNJALA GONDI LETTER KAGUNJALA GONDI LETTER KHAGUNJALA GONDI LETTE" +
	"R TAGUNJALA GONDI LETTER THAGUNJALA GONDI LETTER LAGUNJALA GONDI LETTER " +
	"GAGUNJALA GONDI LETTER GHAGUNJALA GONDI LETTER DAGUNJALA GONDI LETTER DH" +
	"AGUNJALA GONDI LETTER NAGUNJALA GONDI LETTER CAGUNJALA GONDI LETTER CHAG" +
	"UNJALA GONDI LETTER TTAGUNJALA GONDI LETTER TTHAGUNJALA GONDI LETTER LLA" +
	"GUNJALA GONDI LETTER JAGUNJALA GONDI LETTER JHAGUNJALA GONDI LETTER DDAG" +
	"UNJALA GONDI LETTER DDHAGUNJALA GONDI LETTER NGAGUNJALA GONDI LETTER PAG" +
	"UNJALA GONDI LETTER PHAGUNJALA GONDI LETTER HAGUNJALA GONDI LETTER RAGUN" +
	"JALA GONDI LETTER SAGUNJALA GONDI VOWEL SIGN AAGUNJALA GONDI VOWEL SIGN " +
	"IGUNJALA GONDI VOWEL SIGN IIGUNJALA GONDI VOWEL SIGN UGUNJALA GONDI VOWE" +
	"L SIGN UUGUNJALA GONDI VOWEL SIGN EEGUNJALA GONDI VOWEL SIGN AIGUNJALA G" +
	"ONDI VOWEL SIGN OOGUNJALA GONDI VOWEL SIGN AUGUNJALA GONDI SIGN ANUSVARA" +
	"GUNJALA GONDI SIGN VISARGAGUNJALA GONDI VIRAMAGUNJALA GONDI OMGUNJALA GO" +
	"NDI DIGIT ZEROGUNJALA GONDI DIGIT ONEGUNJALA GONDI DIGIT TWOGUNJALA GOND" +
	"I DIGIT THREEGUNJALA GONDI DIGIT FOURGUNJALA GONDI DIGIT FIVEGUNJALA GON" +
	"DI DIGIT SIXGUNJALA GONDI DIGIT SEVENGUNJALA GONDI DIGIT EIGHTGUNJALA GO" +
	"NDI DIGIT NINEMAKASAR LETTER KAMAKASAR LETTER GAMAKASAR LETTER NGAMAKASA" +
	"R LETTER PAMAKASAR LETTER BAMAKASAR LETTER MAMAKASAR LETTER TAMAKASAR LE" +
	"TTER DAMAKASAR LETTER NAMAKASAR LETTER CAMAKASAR LETTER JAMAKASAR LETTER" +
	" NYAMAKASAR LETTER YAMAKASAR LETTER RAMAKASAR LETTER LAMAKASAR LETTER VA" +
	"MAKASAR LETTER SAMAKASAR LETTER AMAKASAR ANGKAMAKASAR VOWEL SIGN IMAKASA" +
	"R VOWEL SIGN UMAKASAR VOWEL SIGN EMAKASAR VOWEL SIGN OMAKASAR PASSIMBANG" +
	"MAKASAR END OF SECTIONTAMIL FRACTION ONE THREE-HUNDRED-AND-TWENTIETHTAMI" +
	"L FRACTION ONE ONE-HUNDRED-AND-SIXTIETHTAMIL FRACTION ONE EIGHTIETHTAMIL" +
	" FRACTION ONE SIXTY-FOURTHTAMIL FRACTION ONE FORTIETHTAMIL FRACTION ONE " +
	"THIRTY-SECONDTAMIL FRACTION THREE EIGHTIETHSTAMIL FRACTION THREE SIXTY-F" +
	"OURTHSTAMIL FRACTION ONE TWENTIETHTAMIL FRACTION ONE SIXTEENTH-1TAMIL FR" +
	"ACTION ONE SIXTEENTH-2TAMIL FRACTION ONE TENTHTAMIL FRACTION ONE EIGHTHT" +
	"AMIL FRACTION THREE TWENTIETHSTAMIL FRACTION THREE SIXTEENTHSTAMIL FRACT" +
	"ION ONE FIFTHTAMIL FRACTION ONE QUARTERTAMIL FRACTION ONE HALF-1TAMIL FR") + ("" +
	"ACTION ONE HALF-2TAMIL FRACTION THREE QUARTERSTAMIL FRACTION DOWNSCALING" +
	" FACTOR KIIZHTAMIL SIGN NELTAMIL SIGN CEVITUTAMIL SIGN AAZHAAKKUTAMIL SI" +
	"GN UZHAKKUTAMIL SIGN MUUVUZHAKKUTAMIL SIGN KURUNITAMIL SIGN PATHAKKUTAMI" +
	"L SIGN MUKKURUNITAMIL SIGN KAACUTAMIL SIGN PANAMTAMIL SIGN PONTAMIL SIGN" +
	" VARAAKANTAMIL SIGN PAARAMTAMIL SIGN KUZHITAMIL SIGN VELITAMIL WET CULTI" +
	"VATION SIGNTAMIL DRY CULTIVATION SIGNTAMIL LAND SIGNTAMIL SALT PAN SIGNT" +
	"AMIL TRADITIONAL CREDIT SIGNTAMIL TRADITIONAL NUMBER SIGNTAMIL CURRENT S" +
	"IGNTAMIL AND ODD SIGNTAMIL SPENT SIGNTAMIL TOTAL SIGNTAMIL IN POSSESSION" +
	" SIGNTAMIL STARTING FROM SIGNTAMIL SIGN MUTHALIYATAMIL SIGN VAKAIYARAATA" +
	"MIL PUNCTUATION END OF TEXTCUNEIFORM SIGN ACUNEIFORM SIGN A TIMES ACUNEI" +
	"FORM SIGN A TIMES BADCUNEIFORM SIGN A TIMES GAN2 TENUCUNEIFORM SIGN A TI" +
	"MES HACUNEIFORM SIGN A TIMES IGICUNEIFORM SIGN A TIMES LAGAR GUNUCUNEIFO" +
	"RM SIGN A TIMES MUSHCUNEIFORM SIGN A TIMES SAGCUNEIFORM SIGN A2CUNEIFORM" +
	" SIGN ABCUNEIFORM SIGN AB TIMES ASH2CUNEIFORM SIGN AB TIMES DUN3 GUNUCUN" +
	"EIFORM SIGN AB TIMES GALCUNEIFORM SIGN AB TIMES GAN2 TENUCUNEIFORM SIGN " +
	"AB TIMES HACUNEIFORM SIGN AB TIMES IGI GUNUCUNEIFORM SIGN AB TIMES IMINC" +
	"UNEIFORM SIGN AB TIMES LAGABCUNEIFORM SIGN AB TIMES SHESHCUNEIFORM SIGN " +
	"AB TIMES U PLUS U PLUS UCUNEIFORM SIGN AB GUNUCUNEIFORM SIGN AB2CUNEIFOR" +
	"M SIGN AB2 TIMES BALAGCUNEIFORM SIGN AB2 TIMES GAN2 TENUCUNEIFORM SIGN A" +
	"B2 TIMES ME PLUS ENCUNEIFORM SIGN AB2 TIMES SHA3CUNEIFORM SIGN AB2 TIMES" +
	" TAK4CUNEIFORM SIGN ADCUNEIFORM SIGN AKCUNEIFORM SIGN AK TIMES ERIN2CUNE" +
	"IFORM SIGN AK TIMES SHITA PLUS GISHCUNEIFORM SIGN ALCUNEIFORM SIGN AL TI" +
	"MES ALCUNEIFORM SIGN AL TIMES DIM2CUNEIFORM SIGN AL TIMES GISHCUNEIFORM " +
	"SIGN AL TIMES HACUNEIFORM SIGN AL TIMES KAD3CUNEIFORM SIGN AL TIMES KICU" +
	"NEIFORM SIGN AL TIMES SHECUNEIFORM SIGN AL TIMES USHCUNEIFORM SIGN ALANC" +
	"UNEIFORM SIGN ALEPHCUNEIFORM SIGN AMARCUNEIFORM SIGN AMAR TIMES SHECUNEI" +
	"FORM SIGN ANCUNEIFORM SIGN AN OVER ANCUNEIFORM SIGN AN THREE TIMESCUNEIF" +
	"ORM SIGN AN PLUS NAGA OPPOSING AN PLUS NAGACUNEIFORM SIGN AN PLUS NAGA S" +
	"QUAREDCUNEIFORM SIGN ANSHECUNEIFORM SIGN APINCUNEIFORM SIGN ARADCUNEIFOR" +
	"M SIGN ARAD TIMES KURCUNEIFORM SIGN ARKABCUNEIFORM SIGN ASAL2CUNEIFORM S" +
	"IGN ASHCUNEIFORM SIGN ASH ZIDA TENUCUNEIFORM SIGN ASH KABA TENUCUNEIFORM" +
	" SIGN ASH OVER ASH TUG2 OVER TUG2 TUG2 OVER TUG2 PAPCUNEIFORM SIGN ASH O" +
	"VER ASH OVER ASHCUNEIFORM SIGN ASH OVER ASH OVER ASH CROSSING ASH OVER A" +
	"SH OVER ASHCUNEIFORM SIGN ASH2CUNEIFORM SIGN ASHGABCUNEIFORM SIGN BACUNE" +
	"IFORM SIGN BADCUNEIFORM SIGN BAG3CUNEIFORM SIGN BAHAR2CUNEIFORM SIGN BAL" +
	"CUNEIFORM SIGN BAL OVER BALCUNEIFORM SIGN BALAGCUNEIFORM SIGN BARCUNEIFO" +
	"RM SIGN BARA2CUNEIFORM SIGN BICUNEIFORM SIGN BI TIMES ACUNEIFORM SIGN BI" +
	" TIMES GARCUNEIFORM SIGN BI TIMES IGI GUNUCUNEIFORM SIGN BUCUNEIFORM SIG" +
	"N BU OVER BU ABCUNEIFORM SIGN BU OVER BU UNCUNEIFORM SIGN BU CROSSING BU" +
	"CUNEIFORM SIGN BULUGCUNEIFORM SIGN BULUG OVER BULUGCUNEIFORM SIGN BURCUN" +
	"EIFORM SIGN BUR2CUNEIFORM SIGN DACUNEIFORM SIGN DAGCUNEIFORM SIGN DAG KI" +
	"SIM5 TIMES A PLUS MASHCUNEIFORM SIGN DAG KISIM5 TIMES AMARCUNEIFORM SIGN" +
	" DAG KISIM5 TIMES BALAGCUNEIFORM SIGN DAG KISIM5 TIMES BICUNEIFORM SIGN " +
	"DAG KISIM5 TIMES GACUNEIFORM SIGN DAG KISIM5 TIMES GA PLUS MASHCUNEIFORM" +
	" SIGN DAG KISIM5 TIMES GICUNEIFORM SIGN DAG KISIM5 TIMES GIR2CUNEIFORM S" +
	"IGN DAG KISIM5 TIMES GUDCUNEIFORM SIGN DAG KISIM5 TIMES HACUNEIFORM SIGN" +
	" DAG KISIM5 TIMES IRCUNEIFORM SIGN DAG KISIM5 TIMES IR PLUS LUCUNEIFORM " +
	"SIGN DAG KISIM5 TIMES KAKCUNEIFORM SIGN DAG KISIM5 TIMES LACUNEIFORM SIG" +
	"N DAG KISIM5 TIMES LUCUNEIFORM SIGN DAG KISIM5 TIMES LU PLUS MASH2CUNEIF" +
	"ORM SIGN DAG KISIM5 TIMES LUMCUNEIFORM SIGN DAG KISIM5 TIMES NECUNEIFORM" +
	" SIGN DAG KISIM5 TIMES PAP PLUS PAPCUNEIFORM SIGN DAG KISIM5 TIMES SICUN" +
	"EIFORM SIGN DAG KISIM5 TIMES TAK4CUNEIFORM SIGN DAG KISIM5 TIMES U2 PLUS" +
	" GIR2CUNEIFORM SIGN DAG KISIM5 TIMES USHCUNEIFORM SIGN DAMCUNEIFORM SIGN" +
	" DARCUNEIFORM SIGN DARA3CUNEIFORM SIGN DARA4CUNEIFORM SIGN DICUNEIFORM S" +
	"IGN DIBCUNEIFORM SIGN DIMCUNEIFORM SIGN DIM TIMES SHECUNEIFORM SIGN DIM2" +
	"CUNEIFORM SIGN DINCUNEIFORM SIGN DIN KASKAL U GUNU DISHCUNEIFORM SIGN DI" +
	"SHCUNEIFORM SIGN DUCUNEIFORM SIGN DU OVER DUCUNEIFORM SIGN DU GUNUCUNEIF" +
	"ORM SIGN DU SHESHIGCUNEIFORM SIGN DUBCUNEIFORM SIGN DUB TIMES ESH2CUNEIF" +
	"ORM SIGN DUB2CUNEIFORM SIGN DUGCUNEIFORM SIGN DUGUDCUNEIFORM SIGN DUHCUN" +
	"EIFORM SIGN DUNCUNEIFORM SIGN DUN3CUNEIFORM SIGN DUN3 GUNUCUNEIFORM SIGN" +
	" DUN3 GUNU GUNUCUNEIFORM SIGN DUN4CUNEIFORM SIGN DUR2CUNEIFORM SIGN ECUN" +
	"EIFORM SIGN E TIMES PAPCUNEIFORM SIGN E OVER E NUN OVER NUNCUNEIFORM SIG" +
	"N E2CUNEIFORM SIGN E2 TIMES A PLUS HA PLUS DACUNEIFORM SIGN E2 TIMES GAR" +
	"CUNEIFORM SIGN E2 TIMES MICUNEIFORM SIGN E2 TIMES SALCUNEIFORM SIGN E2 T") + ("" +
	"IMES SHECUNEIFORM SIGN E2 TIMES UCUNEIFORM SIGN EDINCUNEIFORM SIGN EGIRC" +
	"UNEIFORM SIGN ELCUNEIFORM SIGN ENCUNEIFORM SIGN EN TIMES GAN2CUNEIFORM S" +
	"IGN EN TIMES GAN2 TENUCUNEIFORM SIGN EN TIMES MECUNEIFORM SIGN EN CROSSI" +
	"NG ENCUNEIFORM SIGN EN OPPOSING ENCUNEIFORM SIGN EN SQUAREDCUNEIFORM SIG" +
	"N ERENCUNEIFORM SIGN ERIN2CUNEIFORM SIGN ESH2CUNEIFORM SIGN EZENCUNEIFOR" +
	"M SIGN EZEN TIMES ACUNEIFORM SIGN EZEN TIMES A PLUS LALCUNEIFORM SIGN EZ" +
	"EN TIMES A PLUS LAL TIMES LALCUNEIFORM SIGN EZEN TIMES ANCUNEIFORM SIGN " +
	"EZEN TIMES BADCUNEIFORM SIGN EZEN TIMES DUN3 GUNUCUNEIFORM SIGN EZEN TIM" +
	"ES DUN3 GUNU GUNUCUNEIFORM SIGN EZEN TIMES HACUNEIFORM SIGN EZEN TIMES H" +
	"A GUNUCUNEIFORM SIGN EZEN TIMES IGI GUNUCUNEIFORM SIGN EZEN TIMES KASKAL" +
	"CUNEIFORM SIGN EZEN TIMES KASKAL SQUAREDCUNEIFORM SIGN EZEN TIMES KU3CUN" +
	"EIFORM SIGN EZEN TIMES LACUNEIFORM SIGN EZEN TIMES LAL TIMES LALCUNEIFOR" +
	"M SIGN EZEN TIMES LICUNEIFORM SIGN EZEN TIMES LUCUNEIFORM SIGN EZEN TIME" +
	"S U2CUNEIFORM SIGN EZEN TIMES UDCUNEIFORM SIGN GACUNEIFORM SIGN GA GUNUC" +
	"UNEIFORM SIGN GA2CUNEIFORM SIGN GA2 TIMES A PLUS DA PLUS HACUNEIFORM SIG" +
	"N GA2 TIMES A PLUS HACUNEIFORM SIGN GA2 TIMES A PLUS IGICUNEIFORM SIGN G" +
	"A2 TIMES AB2 TENU PLUS TABCUNEIFORM SIGN GA2 TIMES ANCUNEIFORM SIGN GA2 " +
	"TIMES ASHCUNEIFORM SIGN GA2 TIMES ASH2 PLUS GALCUNEIFORM SIGN GA2 TIMES " +
	"BADCUNEIFORM SIGN GA2 TIMES BAR PLUS RACUNEIFORM SIGN GA2 TIMES BURCUNEI" +
	"FORM SIGN GA2 TIMES BUR PLUS RACUNEIFORM SIGN GA2 TIMES DACUNEIFORM SIGN" +
	" GA2 TIMES DICUNEIFORM SIGN GA2 TIMES DIM TIMES SHECUNEIFORM SIGN GA2 TI" +
	"MES DUBCUNEIFORM SIGN GA2 TIMES ELCUNEIFORM SIGN GA2 TIMES EL PLUS LACUN" +
	"EIFORM SIGN GA2 TIMES ENCUNEIFORM SIGN GA2 TIMES EN TIMES GAN2 TENUCUNEI" +
	"FORM SIGN GA2 TIMES GAN2 TENUCUNEIFORM SIGN GA2 TIMES GARCUNEIFORM SIGN " +
	"GA2 TIMES GICUNEIFORM SIGN GA2 TIMES GI4CUNEIFORM SIGN GA2 TIMES GI4 PLU" +
	"S ACUNEIFORM SIGN GA2 TIMES GIR2 PLUS SUCUNEIFORM SIGN GA2 TIMES HA PLUS" +
	" LU PLUS ESH2CUNEIFORM SIGN GA2 TIMES HALCUNEIFORM SIGN GA2 TIMES HAL PL" +
	"US LACUNEIFORM SIGN GA2 TIMES HI PLUS LICUNEIFORM SIGN GA2 TIMES HUB2CUN" +
	"EIFORM SIGN GA2 TIMES IGI GUNUCUNEIFORM SIGN GA2 TIMES ISH PLUS HU PLUS " +
	"ASHCUNEIFORM SIGN GA2 TIMES KAKCUNEIFORM SIGN GA2 TIMES KASKALCUNEIFORM " +
	"SIGN GA2 TIMES KIDCUNEIFORM SIGN GA2 TIMES KID PLUS LALCUNEIFORM SIGN GA" +
	"2 TIMES KU3 PLUS ANCUNEIFORM SIGN GA2 TIMES LACUNEIFORM SIGN GA2 TIMES M" +
	"E PLUS ENCUNEIFORM SIGN GA2 TIMES MICUNEIFORM SIGN GA2 TIMES NUNCUNEIFOR" +
	"M SIGN GA2 TIMES NUN OVER NUNCUNEIFORM SIGN GA2 TIMES PACUNEIFORM SIGN G" +
	"A2 TIMES SALCUNEIFORM SIGN GA2 TIMES SARCUNEIFORM SIGN GA2 TIMES SHECUNE" +
	"IFORM SIGN GA2 TIMES SHE PLUS TURCUNEIFORM SIGN GA2 TIMES SHIDCUNEIFORM " +
	"SIGN GA2 TIMES SUMCUNEIFORM SIGN GA2 TIMES TAK4CUNEIFORM SIGN GA2 TIMES " +
	"UCUNEIFORM SIGN GA2 TIMES UDCUNEIFORM SIGN GA2 TIMES UD PLUS DUCUNEIFORM" +
	" SIGN GA2 OVER GA2CUNEIFORM SIGN GABACUNEIFORM SIGN GABA CROSSING GABACU" +
	"NEIFORM SIGN GADCUNEIFORM SIGN GAD OVER GAD GAR OVER GARCUNEIFORM SIGN G" +
	"ALCUNEIFORM SIGN GAL GAD OVER GAD GAR OVER GARCUNEIFORM SIGN GALAMCUNEIF" +
	"ORM SIGN GAMCUNEIFORM SIGN GANCUNEIFORM SIGN GAN2CUNEIFORM SIGN GAN2 TEN" +
	"UCUNEIFORM SIGN GAN2 OVER GAN2CUNEIFORM SIGN GAN2 CROSSING GAN2CUNEIFORM" +
	" SIGN GARCUNEIFORM SIGN GAR3CUNEIFORM SIGN GASHANCUNEIFORM SIGN GESHTINC" +
	"UNEIFORM SIGN GESHTIN TIMES KURCUNEIFORM SIGN GICUNEIFORM SIGN GI TIMES " +
	"ECUNEIFORM SIGN GI TIMES UCUNEIFORM SIGN GI CROSSING GICUNEIFORM SIGN GI" +
	"4CUNEIFORM SIGN GI4 OVER GI4CUNEIFORM SIGN GI4 CROSSING GI4CUNEIFORM SIG" +
	"N GIDIMCUNEIFORM SIGN GIR2CUNEIFORM SIGN GIR2 GUNUCUNEIFORM SIGN GIR3CUN" +
	"EIFORM SIGN GIR3 TIMES A PLUS IGICUNEIFORM SIGN GIR3 TIMES GAN2 TENUCUNE" +
	"IFORM SIGN GIR3 TIMES IGICUNEIFORM SIGN GIR3 TIMES LU PLUS IGICUNEIFORM " +
	"SIGN GIR3 TIMES PACUNEIFORM SIGN GISALCUNEIFORM SIGN GISHCUNEIFORM SIGN " +
	"GISH CROSSING GISHCUNEIFORM SIGN GISH TIMES BADCUNEIFORM SIGN GISH TIMES" +
	" TAK4CUNEIFORM SIGN GISH TENUCUNEIFORM SIGN GUCUNEIFORM SIGN GU CROSSING" +
	" GUCUNEIFORM SIGN GU2CUNEIFORM SIGN GU2 TIMES KAKCUNEIFORM SIGN GU2 TIME" +
	"S KAK TIMES IGI GUNUCUNEIFORM SIGN GU2 TIMES NUNCUNEIFORM SIGN GU2 TIMES" +
	" SAL PLUS TUG2CUNEIFORM SIGN GU2 GUNUCUNEIFORM SIGN GUDCUNEIFORM SIGN GU" +
	"D TIMES A PLUS KURCUNEIFORM SIGN GUD TIMES KURCUNEIFORM SIGN GUD OVER GU" +
	"D LUGALCUNEIFORM SIGN GULCUNEIFORM SIGN GUMCUNEIFORM SIGN GUM TIMES SHEC" +
	"UNEIFORM SIGN GURCUNEIFORM SIGN GUR7CUNEIFORM SIGN GURUNCUNEIFORM SIGN G" +
	"URUSHCUNEIFORM SIGN HACUNEIFORM SIGN HA TENUCUNEIFORM SIGN HA GUNUCUNEIF" +
	"ORM SIGN HALCUNEIFORM SIGN HICUNEIFORM SIGN HI TIMES ASHCUNEIFORM SIGN H" +
	"I TIMES ASH2CUNEIFORM SIGN HI TIMES BADCUNEIFORM SIGN HI TIMES DISHCUNEI" +
	"FORM SIGN HI TIMES GADCUNEIFORM SIGN HI TIMES KINCUNEIFORM SIGN HI TIMES" +
	" NUNCUNEIFORM SIGN HI TIMES SHECUNEIFORM SIGN HI TIMES UCUNEIFORM SIGN H") + ("" +
	"UCUNEIFORM SIGN HUB2CUNEIFORM SIGN HUB2 TIMES ANCUNEIFORM SIGN HUB2 TIME" +
	"S HALCUNEIFORM SIGN HUB2 TIMES KASKALCUNEIFORM SIGN HUB2 TIMES LISHCUNEI" +
	"FORM SIGN HUB2 TIMES UDCUNEIFORM SIGN HUL2CUNEIFORM SIGN ICUNEIFORM SIGN" +
	" I ACUNEIFORM SIGN IBCUNEIFORM SIGN IDIMCUNEIFORM SIGN IDIM OVER IDIM BU" +
	"RCUNEIFORM SIGN IDIM OVER IDIM SQUAREDCUNEIFORM SIGN IGCUNEIFORM SIGN IG" +
	"ICUNEIFORM SIGN IGI DIBCUNEIFORM SIGN IGI RICUNEIFORM SIGN IGI OVER IGI " +
	"SHIR OVER SHIR UD OVER UDCUNEIFORM SIGN IGI GUNUCUNEIFORM SIGN ILCUNEIFO" +
	"RM SIGN IL TIMES GAN2 TENUCUNEIFORM SIGN IL2CUNEIFORM SIGN IMCUNEIFORM S" +
	"IGN IM TIMES TAK4CUNEIFORM SIGN IM CROSSING IMCUNEIFORM SIGN IM OPPOSING" +
	" IMCUNEIFORM SIGN IM SQUAREDCUNEIFORM SIGN IMINCUNEIFORM SIGN INCUNEIFOR" +
	"M SIGN IRCUNEIFORM SIGN ISHCUNEIFORM SIGN KACUNEIFORM SIGN KA TIMES ACUN" +
	"EIFORM SIGN KA TIMES ADCUNEIFORM SIGN KA TIMES AD PLUS KU3CUNEIFORM SIGN" +
	" KA TIMES ASH2CUNEIFORM SIGN KA TIMES BADCUNEIFORM SIGN KA TIMES BALAGCU" +
	"NEIFORM SIGN KA TIMES BARCUNEIFORM SIGN KA TIMES BICUNEIFORM SIGN KA TIM" +
	"ES ERIN2CUNEIFORM SIGN KA TIMES ESH2CUNEIFORM SIGN KA TIMES GACUNEIFORM " +
	"SIGN KA TIMES GALCUNEIFORM SIGN KA TIMES GAN2 TENUCUNEIFORM SIGN KA TIME" +
	"S GARCUNEIFORM SIGN KA TIMES GAR PLUS SHA3 PLUS ACUNEIFORM SIGN KA TIMES" +
	" GICUNEIFORM SIGN KA TIMES GIR2CUNEIFORM SIGN KA TIMES GISH PLUS SARCUNE" +
	"IFORM SIGN KA TIMES GISH CROSSING GISHCUNEIFORM SIGN KA TIMES GUCUNEIFOR" +
	"M SIGN KA TIMES GUR7CUNEIFORM SIGN KA TIMES IGICUNEIFORM SIGN KA TIMES I" +
	"MCUNEIFORM SIGN KA TIMES KAKCUNEIFORM SIGN KA TIMES KICUNEIFORM SIGN KA " +
	"TIMES KIDCUNEIFORM SIGN KA TIMES LICUNEIFORM SIGN KA TIMES LUCUNEIFORM S" +
	"IGN KA TIMES MECUNEIFORM SIGN KA TIMES ME PLUS DUCUNEIFORM SIGN KA TIMES" +
	" ME PLUS GICUNEIFORM SIGN KA TIMES ME PLUS TECUNEIFORM SIGN KA TIMES MIC" +
	"UNEIFORM SIGN KA TIMES MI PLUS NUNUZCUNEIFORM SIGN KA TIMES NECUNEIFORM " +
	"SIGN KA TIMES NUNCUNEIFORM SIGN KA TIMES PICUNEIFORM SIGN KA TIMES RUCUN" +
	"EIFORM SIGN KA TIMES SACUNEIFORM SIGN KA TIMES SARCUNEIFORM SIGN KA TIME" +
	"S SHACUNEIFORM SIGN KA TIMES SHECUNEIFORM SIGN KA TIMES SHIDCUNEIFORM SI" +
	"GN KA TIMES SHUCUNEIFORM SIGN KA TIMES SIGCUNEIFORM SIGN KA TIMES SUHURC" +
	"UNEIFORM SIGN KA TIMES TARCUNEIFORM SIGN KA TIMES UCUNEIFORM SIGN KA TIM" +
	"ES U2CUNEIFORM SIGN KA TIMES UDCUNEIFORM SIGN KA TIMES UMUM TIMES PACUNE" +
	"IFORM SIGN KA TIMES USHCUNEIFORM SIGN KA TIMES ZICUNEIFORM SIGN KA2CUNEI" +
	"FORM SIGN KA2 CROSSING KA2CUNEIFORM SIGN KABCUNEIFORM SIGN KAD2CUNEIFORM" +
	" SIGN KAD3CUNEIFORM SIGN KAD4CUNEIFORM SIGN KAD5CUNEIFORM SIGN KAD5 OVER" +
	" KAD5CUNEIFORM SIGN KAKCUNEIFORM SIGN KAK TIMES IGI GUNUCUNEIFORM SIGN K" +
	"ALCUNEIFORM SIGN KAL TIMES BADCUNEIFORM SIGN KAL CROSSING KALCUNEIFORM S" +
	"IGN KAM2CUNEIFORM SIGN KAM4CUNEIFORM SIGN KASKALCUNEIFORM SIGN KASKAL LA" +
	"GAB TIMES U OVER LAGAB TIMES UCUNEIFORM SIGN KASKAL OVER KASKAL LAGAB TI" +
	"MES U OVER LAGAB TIMES UCUNEIFORM SIGN KESH2CUNEIFORM SIGN KICUNEIFORM S" +
	"IGN KI TIMES BADCUNEIFORM SIGN KI TIMES UCUNEIFORM SIGN KI TIMES UDCUNEI" +
	"FORM SIGN KIDCUNEIFORM SIGN KINCUNEIFORM SIGN KISALCUNEIFORM SIGN KISHCU" +
	"NEIFORM SIGN KISIM5CUNEIFORM SIGN KISIM5 OVER KISIM5CUNEIFORM SIGN KUCUN" +
	"EIFORM SIGN KU OVER HI TIMES ASH2 KU OVER HI TIMES ASH2CUNEIFORM SIGN KU" +
	"3CUNEIFORM SIGN KU4CUNEIFORM SIGN KU4 VARIANT FORMCUNEIFORM SIGN KU7CUNE" +
	"IFORM SIGN KULCUNEIFORM SIGN KUL GUNUCUNEIFORM SIGN KUNCUNEIFORM SIGN KU" +
	"RCUNEIFORM SIGN KUR OPPOSING KURCUNEIFORM SIGN KUSHU2CUNEIFORM SIGN KWU3" +
	"18CUNEIFORM SIGN LACUNEIFORM SIGN LAGABCUNEIFORM SIGN LAGAB TIMES ACUNEI" +
	"FORM SIGN LAGAB TIMES A PLUS DA PLUS HACUNEIFORM SIGN LAGAB TIMES A PLUS" +
	" GARCUNEIFORM SIGN LAGAB TIMES A PLUS LALCUNEIFORM SIGN LAGAB TIMES ALCU" +
	"NEIFORM SIGN LAGAB TIMES ANCUNEIFORM SIGN LAGAB TIMES ASH ZIDA TENUCUNEI" +
	"FORM SIGN LAGAB TIMES BADCUNEIFORM SIGN LAGAB TIMES BICUNEIFORM SIGN LAG" +
	"AB TIMES DARCUNEIFORM SIGN LAGAB TIMES ENCUNEIFORM SIGN LAGAB TIMES GACU" +
	"NEIFORM SIGN LAGAB TIMES GARCUNEIFORM SIGN LAGAB TIMES GUDCUNEIFORM SIGN" +
	" LAGAB TIMES GUD PLUS GUDCUNEIFORM SIGN LAGAB TIMES HACUNEIFORM SIGN LAG" +
	"AB TIMES HALCUNEIFORM SIGN LAGAB TIMES HI TIMES NUNCUNEIFORM SIGN LAGAB " +
	"TIMES IGI GUNUCUNEIFORM SIGN LAGAB TIMES IMCUNEIFORM SIGN LAGAB TIMES IM" +
	" PLUS HACUNEIFORM SIGN LAGAB TIMES IM PLUS LUCUNEIFORM SIGN LAGAB TIMES " +
	"KICUNEIFORM SIGN LAGAB TIMES KINCUNEIFORM SIGN LAGAB TIMES KU3CUNEIFORM " +
	"SIGN LAGAB TIMES KULCUNEIFORM SIGN LAGAB TIMES KUL PLUS HI PLUS ACUNEIFO" +
	"RM SIGN LAGAB TIMES LAGABCUNEIFORM SIGN LAGAB TIMES LISHCUNEIFORM SIGN L" +
	"AGAB TIMES LUCUNEIFORM SIGN LAGAB TIMES LULCUNEIFORM SIGN LAGAB TIMES ME" +
	"CUNEIFORM SIGN LAGAB TIMES ME PLUS ENCUNEIFORM SIGN LAGAB TIMES MUSHCUNE" +
	"IFORM SIGN LAGAB TIMES NECUNEIFORM SIGN LAGAB TIMES SHE PLUS SUMCUNEIFOR" +
	"M SIGN LAGAB TIMES SHITA PLUS GISH PLUS ERIN2CUNEIFORM SIGN LAGAB TIMES ") + ("" +
	"SHITA PLUS GISH TENUCUNEIFORM SIGN LAGAB TIMES SHU2CUNEIFORM SIGN LAGAB " +
	"TIMES SHU2 PLUS SHU2CUNEIFORM SIGN LAGAB TIMES SUMCUNEIFORM SIGN LAGAB T" +
	"IMES TAGCUNEIFORM SIGN LAGAB TIMES TAK4CUNEIFORM SIGN LAGAB TIMES TE PLU" +
	"S A PLUS SU PLUS NACUNEIFORM SIGN LAGAB TIMES UCUNEIFORM SIGN LAGAB TIME" +
	"S U PLUS ACUNEIFORM SIGN LAGAB TIMES U PLUS U PLUS UCUNEIFORM SIGN LAGAB" +
	" TIMES U2 PLUS ASHCUNEIFORM SIGN LAGAB TIMES UDCUNEIFORM SIGN LAGAB TIME" +
	"S USHCUNEIFORM SIGN LAGAB SQUAREDCUNEIFORM SIGN LAGARCUNEIFORM SIGN LAGA" +
	"R TIMES SHECUNEIFORM SIGN LAGAR TIMES SHE PLUS SUMCUNEIFORM SIGN LAGAR G" +
	"UNUCUNEIFORM SIGN LAGAR GUNU OVER LAGAR GUNU SHECUNEIFORM SIGN LAHSHUCUN" +
	"EIFORM SIGN LALCUNEIFORM SIGN LAL TIMES LALCUNEIFORM SIGN LAMCUNEIFORM S" +
	"IGN LAM TIMES KURCUNEIFORM SIGN LAM TIMES KUR PLUS RUCUNEIFORM SIGN LICU" +
	"NEIFORM SIGN LILCUNEIFORM SIGN LIMMU2CUNEIFORM SIGN LISHCUNEIFORM SIGN L" +
	"UCUNEIFORM SIGN LU TIMES BADCUNEIFORM SIGN LU2CUNEIFORM SIGN LU2 TIMES A" +
	"LCUNEIFORM SIGN LU2 TIMES BADCUNEIFORM SIGN LU2 TIMES ESH2CUNEIFORM SIGN" +
	" LU2 TIMES ESH2 TENUCUNEIFORM SIGN LU2 TIMES GAN2 TENUCUNEIFORM SIGN LU2" +
	" TIMES HI TIMES BADCUNEIFORM SIGN LU2 TIMES IMCUNEIFORM SIGN LU2 TIMES K" +
	"AD2CUNEIFORM SIGN LU2 TIMES KAD3CUNEIFORM SIGN LU2 TIMES KAD3 PLUS ASHCU" +
	"NEIFORM SIGN LU2 TIMES KICUNEIFORM SIGN LU2 TIMES LA PLUS ASHCUNEIFORM S" +
	"IGN LU2 TIMES LAGABCUNEIFORM SIGN LU2 TIMES ME PLUS ENCUNEIFORM SIGN LU2" +
	" TIMES NECUNEIFORM SIGN LU2 TIMES NUCUNEIFORM SIGN LU2 TIMES SI PLUS ASH" +
	"CUNEIFORM SIGN LU2 TIMES SIK2 PLUS BUCUNEIFORM SIGN LU2 TIMES TUG2CUNEIF" +
	"ORM SIGN LU2 TENUCUNEIFORM SIGN LU2 CROSSING LU2CUNEIFORM SIGN LU2 OPPOS" +
	"ING LU2CUNEIFORM SIGN LU2 SQUAREDCUNEIFORM SIGN LU2 SHESHIGCUNEIFORM SIG" +
	"N LU3CUNEIFORM SIGN LUGALCUNEIFORM SIGN LUGAL OVER LUGALCUNEIFORM SIGN L" +
	"UGAL OPPOSING LUGALCUNEIFORM SIGN LUGAL SHESHIGCUNEIFORM SIGN LUHCUNEIFO" +
	"RM SIGN LULCUNEIFORM SIGN LUMCUNEIFORM SIGN LUM OVER LUMCUNEIFORM SIGN L" +
	"UM OVER LUM GAR OVER GARCUNEIFORM SIGN MACUNEIFORM SIGN MA TIMES TAK4CUN" +
	"EIFORM SIGN MA GUNUCUNEIFORM SIGN MA2CUNEIFORM SIGN MAHCUNEIFORM SIGN MA" +
	"RCUNEIFORM SIGN MASHCUNEIFORM SIGN MASH2CUNEIFORM SIGN MECUNEIFORM SIGN " +
	"MESCUNEIFORM SIGN MICUNEIFORM SIGN MINCUNEIFORM SIGN MUCUNEIFORM SIGN MU" +
	" OVER MUCUNEIFORM SIGN MUGCUNEIFORM SIGN MUG GUNUCUNEIFORM SIGN MUNSUBCU" +
	"NEIFORM SIGN MURGU2CUNEIFORM SIGN MUSHCUNEIFORM SIGN MUSH TIMES ACUNEIFO" +
	"RM SIGN MUSH TIMES KURCUNEIFORM SIGN MUSH TIMES ZACUNEIFORM SIGN MUSH OV" +
	"ER MUSHCUNEIFORM SIGN MUSH OVER MUSH TIMES A PLUS NACUNEIFORM SIGN MUSH " +
	"CROSSING MUSHCUNEIFORM SIGN MUSH3CUNEIFORM SIGN MUSH3 TIMES ACUNEIFORM S" +
	"IGN MUSH3 TIMES A PLUS DICUNEIFORM SIGN MUSH3 TIMES DICUNEIFORM SIGN MUS" +
	"H3 GUNUCUNEIFORM SIGN NACUNEIFORM SIGN NA2CUNEIFORM SIGN NAGACUNEIFORM S" +
	"IGN NAGA INVERTEDCUNEIFORM SIGN NAGA TIMES SHU TENUCUNEIFORM SIGN NAGA O" +
	"PPOSING NAGACUNEIFORM SIGN NAGARCUNEIFORM SIGN NAM NUTILLUCUNEIFORM SIGN" +
	" NAMCUNEIFORM SIGN NAM2CUNEIFORM SIGN NECUNEIFORM SIGN NE TIMES ACUNEIFO" +
	"RM SIGN NE TIMES UDCUNEIFORM SIGN NE SHESHIGCUNEIFORM SIGN NICUNEIFORM S" +
	"IGN NI TIMES ECUNEIFORM SIGN NI2CUNEIFORM SIGN NIMCUNEIFORM SIGN NIM TIM" +
	"ES GAN2 TENUCUNEIFORM SIGN NIM TIMES GAR PLUS GAN2 TENUCUNEIFORM SIGN NI" +
	"NDA2CUNEIFORM SIGN NINDA2 TIMES ANCUNEIFORM SIGN NINDA2 TIMES ASHCUNEIFO" +
	"RM SIGN NINDA2 TIMES ASH PLUS ASHCUNEIFORM SIGN NINDA2 TIMES GUDCUNEIFOR" +
	"M SIGN NINDA2 TIMES ME PLUS GAN2 TENUCUNEIFORM SIGN NINDA2 TIMES NECUNEI" +
	"FORM SIGN NINDA2 TIMES NUNCUNEIFORM SIGN NINDA2 TIMES SHECUNEIFORM SIGN " +
	"NINDA2 TIMES SHE PLUS A ANCUNEIFORM SIGN NINDA2 TIMES SHE PLUS ASHCUNEIF" +
	"ORM SIGN NINDA2 TIMES SHE PLUS ASH PLUS ASHCUNEIFORM SIGN NINDA2 TIMES U" +
	"2 PLUS ASHCUNEIFORM SIGN NINDA2 TIMES USHCUNEIFORM SIGN NISAGCUNEIFORM S" +
	"IGN NUCUNEIFORM SIGN NU11CUNEIFORM SIGN NUNCUNEIFORM SIGN NUN LAGAR TIME" +
	"S GARCUNEIFORM SIGN NUN LAGAR TIMES MASHCUNEIFORM SIGN NUN LAGAR TIMES S" +
	"ALCUNEIFORM SIGN NUN LAGAR TIMES SAL OVER NUN LAGAR TIMES SALCUNEIFORM S" +
	"IGN NUN LAGAR TIMES USHCUNEIFORM SIGN NUN TENUCUNEIFORM SIGN NUN OVER NU" +
	"NCUNEIFORM SIGN NUN CROSSING NUNCUNEIFORM SIGN NUN CROSSING NUN LAGAR OV" +
	"ER LAGARCUNEIFORM SIGN NUNUZCUNEIFORM SIGN NUNUZ AB2 TIMES ASHGABCUNEIFO" +
	"RM SIGN NUNUZ AB2 TIMES BICUNEIFORM SIGN NUNUZ AB2 TIMES DUGCUNEIFORM SI" +
	"GN NUNUZ AB2 TIMES GUDCUNEIFORM SIGN NUNUZ AB2 TIMES IGI GUNUCUNEIFORM S" +
	"IGN NUNUZ AB2 TIMES KAD3CUNEIFORM SIGN NUNUZ AB2 TIMES LACUNEIFORM SIGN " +
	"NUNUZ AB2 TIMES NECUNEIFORM SIGN NUNUZ AB2 TIMES SILA3CUNEIFORM SIGN NUN" +
	"UZ AB2 TIMES U2CUNEIFORM SIGN NUNUZ KISIM5 TIMES BICUNEIFORM SIGN NUNUZ " +
	"KISIM5 TIMES BI UCUNEIFORM SIGN PACUNEIFORM SIGN PADCUNEIFORM SIGN PANCU" +
	"NEIFORM SIGN PAPCUNEIFORM SIGN PESH2CUNEIFORM SIGN PICUNEIFORM SIGN PI T" +
	"IMES ACUNEIFORM SIGN PI TIMES ABCUNEIFORM SIGN PI TIMES BICUNEIFORM SIGN") + ("" +
	" PI TIMES BUCUNEIFORM SIGN PI TIMES ECUNEIFORM SIGN PI TIMES ICUNEIFORM " +
	"SIGN PI TIMES IBCUNEIFORM SIGN PI TIMES UCUNEIFORM SIGN PI TIMES U2CUNEI" +
	"FORM SIGN PI CROSSING PICUNEIFORM SIGN PIRIGCUNEIFORM SIGN PIRIG TIMES K" +
	"ALCUNEIFORM SIGN PIRIG TIMES UDCUNEIFORM SIGN PIRIG TIMES ZACUNEIFORM SI" +
	"GN PIRIG OPPOSING PIRIGCUNEIFORM SIGN RACUNEIFORM SIGN RABCUNEIFORM SIGN" +
	" RICUNEIFORM SIGN RUCUNEIFORM SIGN SACUNEIFORM SIGN SAG NUTILLUCUNEIFORM" +
	" SIGN SAGCUNEIFORM SIGN SAG TIMES ACUNEIFORM SIGN SAG TIMES DUCUNEIFORM " +
	"SIGN SAG TIMES DUBCUNEIFORM SIGN SAG TIMES HACUNEIFORM SIGN SAG TIMES KA" +
	"KCUNEIFORM SIGN SAG TIMES KURCUNEIFORM SIGN SAG TIMES LUMCUNEIFORM SIGN " +
	"SAG TIMES MICUNEIFORM SIGN SAG TIMES NUNCUNEIFORM SIGN SAG TIMES SALCUNE" +
	"IFORM SIGN SAG TIMES SHIDCUNEIFORM SIGN SAG TIMES TABCUNEIFORM SIGN SAG " +
	"TIMES U2CUNEIFORM SIGN SAG TIMES UBCUNEIFORM SIGN SAG TIMES UMCUNEIFORM " +
	"SIGN SAG TIMES URCUNEIFORM SIGN SAG TIMES USHCUNEIFORM SIGN SAG OVER SAG" +
	"CUNEIFORM SIGN SAG GUNUCUNEIFORM SIGN SALCUNEIFORM SIGN SAL LAGAB TIMES " +
	"ASH2CUNEIFORM SIGN SANGA2CUNEIFORM SIGN SARCUNEIFORM SIGN SHACUNEIFORM S" +
	"IGN SHA3CUNEIFORM SIGN SHA3 TIMES ACUNEIFORM SIGN SHA3 TIMES BADCUNEIFOR" +
	"M SIGN SHA3 TIMES GISHCUNEIFORM SIGN SHA3 TIMES NECUNEIFORM SIGN SHA3 TI" +
	"MES SHU2CUNEIFORM SIGN SHA3 TIMES TURCUNEIFORM SIGN SHA3 TIMES UCUNEIFOR" +
	"M SIGN SHA3 TIMES U PLUS ACUNEIFORM SIGN SHA6CUNEIFORM SIGN SHAB6CUNEIFO" +
	"RM SIGN SHAR2CUNEIFORM SIGN SHECUNEIFORM SIGN SHE HUCUNEIFORM SIGN SHE O" +
	"VER SHE GAD OVER GAD GAR OVER GARCUNEIFORM SIGN SHE OVER SHE TAB OVER TA" +
	"B GAR OVER GARCUNEIFORM SIGN SHEG9CUNEIFORM SIGN SHENCUNEIFORM SIGN SHES" +
	"HCUNEIFORM SIGN SHESH2CUNEIFORM SIGN SHESHLAMCUNEIFORM SIGN SHIDCUNEIFOR" +
	"M SIGN SHID TIMES ACUNEIFORM SIGN SHID TIMES IMCUNEIFORM SIGN SHIMCUNEIF" +
	"ORM SIGN SHIM TIMES ACUNEIFORM SIGN SHIM TIMES BALCUNEIFORM SIGN SHIM TI" +
	"MES BULUGCUNEIFORM SIGN SHIM TIMES DINCUNEIFORM SIGN SHIM TIMES GARCUNEI" +
	"FORM SIGN SHIM TIMES IGICUNEIFORM SIGN SHIM TIMES IGI GUNUCUNEIFORM SIGN" +
	" SHIM TIMES KUSHU2CUNEIFORM SIGN SHIM TIMES LULCUNEIFORM SIGN SHIM TIMES" +
	" MUGCUNEIFORM SIGN SHIM TIMES SALCUNEIFORM SIGN SHINIGCUNEIFORM SIGN SHI" +
	"RCUNEIFORM SIGN SHIR TENUCUNEIFORM SIGN SHIR OVER SHIR BUR OVER BURCUNEI" +
	"FORM SIGN SHITACUNEIFORM SIGN SHUCUNEIFORM SIGN SHU OVER INVERTED SHUCUN" +
	"EIFORM SIGN SHU2CUNEIFORM SIGN SHUBURCUNEIFORM SIGN SICUNEIFORM SIGN SI " +
	"GUNUCUNEIFORM SIGN SIGCUNEIFORM SIGN SIG4CUNEIFORM SIGN SIG4 OVER SIG4 S" +
	"HU2CUNEIFORM SIGN SIK2CUNEIFORM SIGN SILA3CUNEIFORM SIGN SUCUNEIFORM SIG" +
	"N SU OVER SUCUNEIFORM SIGN SUDCUNEIFORM SIGN SUD2CUNEIFORM SIGN SUHURCUN" +
	"EIFORM SIGN SUMCUNEIFORM SIGN SUMASHCUNEIFORM SIGN SURCUNEIFORM SIGN SUR" +
	"9CUNEIFORM SIGN TACUNEIFORM SIGN TA ASTERISKCUNEIFORM SIGN TA TIMES HICU" +
	"NEIFORM SIGN TA TIMES MICUNEIFORM SIGN TA GUNUCUNEIFORM SIGN TABCUNEIFOR" +
	"M SIGN TAB OVER TAB NI OVER NI DISH OVER DISHCUNEIFORM SIGN TAB SQUAREDC" +
	"UNEIFORM SIGN TAGCUNEIFORM SIGN TAG TIMES BICUNEIFORM SIGN TAG TIMES GUD" +
	"CUNEIFORM SIGN TAG TIMES SHECUNEIFORM SIGN TAG TIMES SHUCUNEIFORM SIGN T" +
	"AG TIMES TUG2CUNEIFORM SIGN TAG TIMES UDCUNEIFORM SIGN TAK4CUNEIFORM SIG" +
	"N TARCUNEIFORM SIGN TECUNEIFORM SIGN TE GUNUCUNEIFORM SIGN TICUNEIFORM S" +
	"IGN TI TENUCUNEIFORM SIGN TILCUNEIFORM SIGN TIRCUNEIFORM SIGN TIR TIMES " +
	"TAK4CUNEIFORM SIGN TIR OVER TIRCUNEIFORM SIGN TIR OVER TIR GAD OVER GAD " +
	"GAR OVER GARCUNEIFORM SIGN TUCUNEIFORM SIGN TUG2CUNEIFORM SIGN TUKCUNEIF" +
	"ORM SIGN TUMCUNEIFORM SIGN TURCUNEIFORM SIGN TUR OVER TUR ZA OVER ZACUNE" +
	"IFORM SIGN UCUNEIFORM SIGN U GUDCUNEIFORM SIGN U U UCUNEIFORM SIGN U OVE" +
	"R U PA OVER PA GAR OVER GARCUNEIFORM SIGN U OVER U SUR OVER SURCUNEIFORM" +
	" SIGN U OVER U U REVERSED OVER U REVERSEDCUNEIFORM SIGN U2CUNEIFORM SIGN" +
	" UBCUNEIFORM SIGN UDCUNEIFORM SIGN UD KUSHU2CUNEIFORM SIGN UD TIMES BADC" +
	"UNEIFORM SIGN UD TIMES MICUNEIFORM SIGN UD TIMES U PLUS U PLUS UCUNEIFOR" +
	"M SIGN UD TIMES U PLUS U PLUS U GUNUCUNEIFORM SIGN UD GUNUCUNEIFORM SIGN" +
	" UD SHESHIGCUNEIFORM SIGN UD SHESHIG TIMES BADCUNEIFORM SIGN UDUGCUNEIFO" +
	"RM SIGN UMCUNEIFORM SIGN UM TIMES LAGABCUNEIFORM SIGN UM TIMES ME PLUS D" +
	"ACUNEIFORM SIGN UM TIMES SHA3CUNEIFORM SIGN UM TIMES UCUNEIFORM SIGN UMB" +
	"INCUNEIFORM SIGN UMUMCUNEIFORM SIGN UMUM TIMES KASKALCUNEIFORM SIGN UMUM" +
	" TIMES PACUNEIFORM SIGN UNCUNEIFORM SIGN UN GUNUCUNEIFORM SIGN URCUNEIFO" +
	"RM SIGN UR CROSSING URCUNEIFORM SIGN UR SHESHIGCUNEIFORM SIGN UR2CUNEIFO" +
	"RM SIGN UR2 TIMES A PLUS HACUNEIFORM SIGN UR2 TIMES A PLUS NACUNEIFORM S" +
	"IGN UR2 TIMES ALCUNEIFORM SIGN UR2 TIMES HACUNEIFORM SIGN UR2 TIMES NUNC" +
	"UNEIFORM SIGN UR2 TIMES U2CUNEIFORM SIGN UR2 TIMES U2 PLUS ASHCUNEIFORM " +
	"SIGN UR2 TIMES U2 PLUS BICUNEIFORM SIGN UR4CUNEIFORM SIGN URICUNEIFORM S" +
	"IGN URI3CUNEIFORM SIGN URUCUNEIFORM SIGN URU TIMES ACUNEIFORM SIGN URU T") + ("" +
	"IMES ASHGABCUNEIFORM SIGN URU TIMES BARCUNEIFORM SIGN URU TIMES DUNCUNEI" +
	"FORM SIGN URU TIMES GACUNEIFORM SIGN URU TIMES GALCUNEIFORM SIGN URU TIM" +
	"ES GAN2 TENUCUNEIFORM SIGN URU TIMES GARCUNEIFORM SIGN URU TIMES GUCUNEI" +
	"FORM SIGN URU TIMES HACUNEIFORM SIGN URU TIMES IGICUNEIFORM SIGN URU TIM" +
	"ES IMCUNEIFORM SIGN URU TIMES ISHCUNEIFORM SIGN URU TIMES KICUNEIFORM SI" +
	"GN URU TIMES LUMCUNEIFORM SIGN URU TIMES MINCUNEIFORM SIGN URU TIMES PAC" +
	"UNEIFORM SIGN URU TIMES SHECUNEIFORM SIGN URU TIMES SIG4CUNEIFORM SIGN U" +
	"RU TIMES TUCUNEIFORM SIGN URU TIMES U PLUS GUDCUNEIFORM SIGN URU TIMES U" +
	"DCUNEIFORM SIGN URU TIMES URUDACUNEIFORM SIGN URUDACUNEIFORM SIGN URUDA " +
	"TIMES UCUNEIFORM SIGN USHCUNEIFORM SIGN USH TIMES ACUNEIFORM SIGN USH TI" +
	"MES KUCUNEIFORM SIGN USH TIMES KURCUNEIFORM SIGN USH TIMES TAK4CUNEIFORM" +
	" SIGN USHXCUNEIFORM SIGN USH2CUNEIFORM SIGN USHUMXCUNEIFORM SIGN UTUKICU" +
	"NEIFORM SIGN UZ3CUNEIFORM SIGN UZ3 TIMES KASKALCUNEIFORM SIGN UZUCUNEIFO" +
	"RM SIGN ZACUNEIFORM SIGN ZA TENUCUNEIFORM SIGN ZA SQUARED TIMES KURCUNEI" +
	"FORM SIGN ZAGCUNEIFORM SIGN ZAMXCUNEIFORM SIGN ZE2CUNEIFORM SIGN ZICUNEI" +
	"FORM SIGN ZI OVER ZICUNEIFORM SIGN ZI3CUNEIFORM SIGN ZIBCUNEIFORM SIGN Z" +
	"IB KABA TENUCUNEIFORM SIGN ZIGCUNEIFORM SIGN ZIZ2CUNEIFORM SIGN ZUCUNEIF" +
	"ORM SIGN ZU5CUNEIFORM SIGN ZU5 TIMES ACUNEIFORM SIGN ZUBURCUNEIFORM SIGN" +
	" ZUMCUNEIFORM SIGN KAP ELAMITECUNEIFORM SIGN AB TIMES NUNCUNEIFORM SIGN " +
	"AB2 TIMES ACUNEIFORM SIGN AMAR TIMES KUGCUNEIFORM SIGN DAG KISIM5 TIMES " +
	"U2 PLUS MASHCUNEIFORM SIGN DAG3CUNEIFORM SIGN DISH PLUS SHUCUNEIFORM SIG" +
	"N DUB TIMES SHECUNEIFORM SIGN EZEN TIMES GUDCUNEIFORM SIGN EZEN TIMES SH" +
	"ECUNEIFORM SIGN GA2 TIMES AN PLUS KAK PLUS ACUNEIFORM SIGN GA2 TIMES ASH" +
	"2CUNEIFORM SIGN GE22CUNEIFORM SIGN GIGCUNEIFORM SIGN HUSHCUNEIFORM SIGN " +
	"KA TIMES ANSHECUNEIFORM SIGN KA TIMES ASH3CUNEIFORM SIGN KA TIMES GISHCU" +
	"NEIFORM SIGN KA TIMES GUDCUNEIFORM SIGN KA TIMES HI TIMES ASH2CUNEIFORM " +
	"SIGN KA TIMES LUMCUNEIFORM SIGN KA TIMES PACUNEIFORM SIGN KA TIMES SHULC" +
	"UNEIFORM SIGN KA TIMES TUCUNEIFORM SIGN KA TIMES UR2CUNEIFORM SIGN LAGAB" +
	" TIMES GICUNEIFORM SIGN LU2 SHESHIG TIMES BADCUNEIFORM SIGN LU2 TIMES ES" +
	"H2 PLUS LALCUNEIFORM SIGN LU2 TIMES SHUCUNEIFORM SIGN MESHCUNEIFORM SIGN" +
	" MUSH3 TIMES ZACUNEIFORM SIGN NA4CUNEIFORM SIGN NINCUNEIFORM SIGN NIN9CU" +
	"NEIFORM SIGN NINDA2 TIMES BALCUNEIFORM SIGN NINDA2 TIMES GICUNEIFORM SIG" +
	"N NU11 ROTATED NINETY DEGREESCUNEIFORM SIGN PESH2 ASTERISKCUNEIFORM SIGN" +
	" PIR2CUNEIFORM SIGN SAG TIMES IGI GUNUCUNEIFORM SIGN TI2CUNEIFORM SIGN U" +
	"M TIMES MECUNEIFORM SIGN U UCUNEIFORM NUMERIC SIGN TWO ASHCUNEIFORM NUME" +
	"RIC SIGN THREE ASHCUNEIFORM NUMERIC SIGN FOUR ASHCUNEIFORM NUMERIC SIGN " +
	"FIVE ASHCUNEIFORM NUMERIC SIGN SIX ASHCUNEIFORM NUMERIC SIGN SEVEN ASHCU" +
	"NEIFORM NUMERIC SIGN EIGHT ASHCUNEIFORM NUMERIC SIGN NINE ASHCUNEIFORM N" +
	"UMERIC SIGN THREE DISHCUNEIFORM NUMERIC SIGN FOUR DISHCUNEIFORM NUMERIC " +
	"SIGN FIVE DISHCUNEIFORM NUMERIC SIGN SIX DISHCUNEIFORM NUMERIC SIGN SEVE" +
	"N DISHCUNEIFORM NUMERIC SIGN EIGHT DISHCUNEIFORM NUMERIC SIGN NINE DISHC" +
	"UNEIFORM NUMERIC SIGN FOUR UCUNEIFORM NUMERIC SIGN FIVE UCUNEIFORM NUMER" +
	"IC SIGN SIX UCUNEIFORM NUMERIC SIGN SEVEN UCUNEIFORM NUMERIC SIGN EIGHT " +
	"UCUNEIFORM NUMERIC SIGN NINE UCUNEIFORM NUMERIC SIGN ONE GESH2CUNEIFORM " +
	"NUMERIC SIGN TWO GESH2CUNEIFORM NUMERIC SIGN THREE GESH2CUNEIFORM NUMERI" +
	"C SIGN FOUR GESH2CUNEIFORM NUMERIC SIGN FIVE GESH2CUNEIFORM NUMERIC SIGN" +
	" SIX GESH2CUNEIFORM NUMERIC SIGN SEVEN GESH2CUNEIFORM NUMERIC SIGN EIGHT" +
	" GESH2CUNEIFORM NUMERIC SIGN NINE GESH2CUNEIFORM NUMERIC SIGN ONE GESHUC" +
	"UNEIFORM NUMERIC SIGN TWO GESHUCUNEIFORM NUMERIC SIGN THREE GESHUCUNEIFO" +
	"RM NUMERIC SIGN FOUR GESHUCUNEIFORM NUMERIC SIGN FIVE GESHUCUNEIFORM NUM" +
	"ERIC SIGN TWO SHAR2CUNEIFORM NUMERIC SIGN THREE SHAR2CUNEIFORM NUMERIC S" +
	"IGN THREE SHAR2 VARIANT FORMCUNEIFORM NUMERIC SIGN FOUR SHAR2CUNEIFORM N" +
	"UMERIC SIGN FIVE SHAR2CUNEIFORM NUMERIC SIGN SIX SHAR2CUNEIFORM NUMERIC " +
	"SIGN SEVEN SHAR2CUNEIFORM NUMERIC SIGN EIGHT SHAR2CUNEIFORM NUMERIC SIGN" +
	" NINE SHAR2CUNEIFORM NUMERIC SIGN ONE SHARUCUNEIFORM NUMERIC SIGN TWO SH" +
	"ARUCUNEIFORM NUMERIC SIGN THREE SHARUCUNEIFORM NUMERIC SIGN THREE SHARU " +
	"VARIANT FORMCUNEIFORM NUMERIC SIGN FOUR SHARUCUNEIFORM NUMERIC SIGN FIVE" +
	" SHARUCUNEIFORM NUMERIC SIGN SHAR2 TIMES GAL PLUS DISHCUNEIFORM NUMERIC " +
	"SIGN SHAR2 TIMES GAL PLUS MINCUNEIFORM NUMERIC SIGN ONE BURUCUNEIFORM NU" +
	"MERIC SIGN TWO BURUCUNEIFORM NUMERIC SIGN THREE BURUCUNEIFORM NUMERIC SI" +
	"GN THREE BURU VARIANT FORMCUNEIFORM NUMERIC SIGN FOUR BURUCUNEIFORM NUME" +
	"RIC SIGN FIVE BURUCUNEIFORM NUMERIC SIGN THREE VARIANT FORM ESH16CUNEIFO" +
	"RM NUMERIC SIGN THREE VARIANT FORM ESH21CUNEIFORM NUMERIC SIGN FOUR VARI" +
	"ANT FORM LIMMUCUNEIFORM NUMERIC SIGN FOUR VARIANT FORM LIMMU4CUNEIFORM N") + ("" +
	"UMERIC SIGN FOUR VARIANT FORM LIMMU ACUNEIFORM NUMERIC SIGN FOUR VARIANT" +
	" FORM LIMMU BCUNEIFORM NUMERIC SIGN SIX VARIANT FORM ASH9CUNEIFORM NUMER" +
	"IC SIGN SEVEN VARIANT FORM IMIN3CUNEIFORM NUMERIC SIGN SEVEN VARIANT FOR" +
	"M IMIN ACUNEIFORM NUMERIC SIGN SEVEN VARIANT FORM IMIN BCUNEIFORM NUMERI" +
	"C SIGN EIGHT VARIANT FORM USSUCUNEIFORM NUMERIC SIGN EIGHT VARIANT FORM " +
	"USSU3CUNEIFORM NUMERIC SIGN NINE VARIANT FORM ILIMMUCUNEIFORM NUMERIC SI" +
	"GN NINE VARIANT FORM ILIMMU3CUNEIFORM NUMERIC SIGN NINE VARIANT FORM ILI" +
	"MMU4CUNEIFORM NUMERIC SIGN NINE VARIANT FORM ILIMMU ACUNEIFORM NUMERIC S" +
	"IGN TWO ASH TENUCUNEIFORM NUMERIC SIGN THREE ASH TENUCUNEIFORM NUMERIC S" +
	"IGN FOUR ASH TENUCUNEIFORM NUMERIC SIGN FIVE ASH TENUCUNEIFORM NUMERIC S" +
	"IGN SIX ASH TENUCUNEIFORM NUMERIC SIGN ONE BAN2CUNEIFORM NUMERIC SIGN TW" +
	"O BAN2CUNEIFORM NUMERIC SIGN THREE BAN2CUNEIFORM NUMERIC SIGN FOUR BAN2C" +
	"UNEIFORM NUMERIC SIGN FOUR BAN2 VARIANT FORMCUNEIFORM NUMERIC SIGN FIVE " +
	"BAN2CUNEIFORM NUMERIC SIGN FIVE BAN2 VARIANT FORMCUNEIFORM NUMERIC SIGN " +
	"NIGIDAMINCUNEIFORM NUMERIC SIGN NIGIDAESHCUNEIFORM NUMERIC SIGN ONE ESHE" +
	"3CUNEIFORM NUMERIC SIGN TWO ESHE3CUNEIFORM NUMERIC SIGN ONE THIRD DISHCU" +
	"NEIFORM NUMERIC SIGN TWO THIRDS DISHCUNEIFORM NUMERIC SIGN FIVE SIXTHS D" +
	"ISHCUNEIFORM NUMERIC SIGN ONE THIRD VARIANT FORM ACUNEIFORM NUMERIC SIGN" +
	" TWO THIRDS VARIANT FORM ACUNEIFORM NUMERIC SIGN ONE EIGHTH ASHCUNEIFORM" +
	" NUMERIC SIGN ONE QUARTER ASHCUNEIFORM NUMERIC SIGN OLD ASSYRIAN ONE SIX" +
	"THCUNEIFORM NUMERIC SIGN OLD ASSYRIAN ONE QUARTERCUNEIFORM NUMERIC SIGN " +
	"ONE QUARTER GURCUNEIFORM NUMERIC SIGN ONE HALF GURCUNEIFORM NUMERIC SIGN" +
	" ELAMITE ONE THIRDCUNEIFORM NUMERIC SIGN ELAMITE TWO THIRDSCUNEIFORM NUM" +
	"ERIC SIGN ELAMITE FORTYCUNEIFORM NUMERIC SIGN ELAMITE FIFTYCUNEIFORM NUM" +
	"ERIC SIGN FOUR U VARIANT FORMCUNEIFORM NUMERIC SIGN FIVE U VARIANT FORMC" +
	"UNEIFORM NUMERIC SIGN SIX U VARIANT FORMCUNEIFORM NUMERIC SIGN SEVEN U V" +
	"ARIANT FORMCUNEIFORM NUMERIC SIGN EIGHT U VARIANT FORMCUNEIFORM NUMERIC " +
	"SIGN NINE U VARIANT FORMCUNEIFORM PUNCTUATION SIGN OLD ASSYRIAN WORD DIV" +
	"IDERCUNEIFORM PUNCTUATION SIGN VERTICAL COLONCUNEIFORM PUNCTUATION SIGN " +
	"DIAGONAL COLONCUNEIFORM PUNCTUATION SIGN DIAGONAL TRICOLONCUNEIFORM PUNC" +
	"TUATION SIGN DIAGONAL QUADCOLONCUNEIFORM SIGN AB TIMES NUN TENUCUNEIFORM" +
	" SIGN AB TIMES SHU2CUNEIFORM SIGN AD TIMES ESH2CUNEIFORM SIGN BAD TIMES " +
	"DISH TENUCUNEIFORM SIGN BAHAR2 TIMES AB2CUNEIFORM SIGN BAHAR2 TIMES NICU" +
	"NEIFORM SIGN BAHAR2 TIMES ZACUNEIFORM SIGN BU OVER BU TIMES NA2CUNEIFORM" +
	" SIGN DA TIMES TAK4CUNEIFORM SIGN DAG TIMES KURCUNEIFORM SIGN DIM TIMES " +
	"IGICUNEIFORM SIGN DIM TIMES U U UCUNEIFORM SIGN DIM2 TIMES UDCUNEIFORM S" +
	"IGN DUG TIMES ANSHECUNEIFORM SIGN DUG TIMES ASHCUNEIFORM SIGN DUG TIMES " +
	"ASH AT LEFTCUNEIFORM SIGN DUG TIMES DINCUNEIFORM SIGN DUG TIMES DUNCUNEI" +
	"FORM SIGN DUG TIMES ERIN2CUNEIFORM SIGN DUG TIMES GACUNEIFORM SIGN DUG T" +
	"IMES GICUNEIFORM SIGN DUG TIMES GIR2 GUNUCUNEIFORM SIGN DUG TIMES GISHCU" +
	"NEIFORM SIGN DUG TIMES HACUNEIFORM SIGN DUG TIMES HICUNEIFORM SIGN DUG T" +
	"IMES IGI GUNUCUNEIFORM SIGN DUG TIMES KASKALCUNEIFORM SIGN DUG TIMES KUR" +
	"CUNEIFORM SIGN DUG TIMES KUSHU2CUNEIFORM SIGN DUG TIMES KUSHU2 PLUS KASK" +
	"ALCUNEIFORM SIGN DUG TIMES LAK-020CUNEIFORM SIGN DUG TIMES LAMCUNEIFORM " +
	"SIGN DUG TIMES LAM TIMES KURCUNEIFORM SIGN DUG TIMES LUH PLUS GISHCUNEIF" +
	"ORM SIGN DUG TIMES MASHCUNEIFORM SIGN DUG TIMES MESCUNEIFORM SIGN DUG TI" +
	"MES MICUNEIFORM SIGN DUG TIMES NICUNEIFORM SIGN DUG TIMES PICUNEIFORM SI" +
	"GN DUG TIMES SHECUNEIFORM SIGN DUG TIMES SI GUNUCUNEIFORM SIGN E2 TIMES " +
	"KURCUNEIFORM SIGN E2 TIMES PAPCUNEIFORM SIGN ERIN2 XCUNEIFORM SIGN ESH2 " +
	"CROSSING ESH2CUNEIFORM SIGN EZEN SHESHIG TIMES ASHCUNEIFORM SIGN EZEN SH" +
	"ESHIG TIMES HICUNEIFORM SIGN EZEN SHESHIG TIMES IGI GUNUCUNEIFORM SIGN E" +
	"ZEN SHESHIG TIMES LACUNEIFORM SIGN EZEN SHESHIG TIMES LALCUNEIFORM SIGN " +
	"EZEN SHESHIG TIMES MECUNEIFORM SIGN EZEN SHESHIG TIMES MESCUNEIFORM SIGN" +
	" EZEN SHESHIG TIMES SUCUNEIFORM SIGN EZEN TIMES SUCUNEIFORM SIGN GA2 TIM" +
	"ES BAHAR2CUNEIFORM SIGN GA2 TIMES DIM GUNUCUNEIFORM SIGN GA2 TIMES DUG T" +
	"IMES IGI GUNUCUNEIFORM SIGN GA2 TIMES DUG TIMES KASKALCUNEIFORM SIGN GA2" +
	" TIMES ERENCUNEIFORM SIGN GA2 TIMES GACUNEIFORM SIGN GA2 TIMES GAR PLUS " +
	"DICUNEIFORM SIGN GA2 TIMES GAR PLUS NECUNEIFORM SIGN GA2 TIMES HA PLUS A" +
	"CUNEIFORM SIGN GA2 TIMES KUSHU2 PLUS KASKALCUNEIFORM SIGN GA2 TIMES LAMC" +
	"UNEIFORM SIGN GA2 TIMES LAM TIMES KURCUNEIFORM SIGN GA2 TIMES LUHCUNEIFO" +
	"RM SIGN GA2 TIMES MUSHCUNEIFORM SIGN GA2 TIMES NECUNEIFORM SIGN GA2 TIME" +
	"S NE PLUS E2CUNEIFORM SIGN GA2 TIMES NE PLUS GICUNEIFORM SIGN GA2 TIMES " +
	"SHIMCUNEIFORM SIGN GA2 TIMES ZIZ2CUNEIFORM SIGN GABA ROTATED NINETY DEGR" +
	"EESCUNEIFORM SIGN GESHTIN TIMES UCUNEIFORM SIGN GISH TIMES GISH CROSSING") + ("" +
	" GISHCUNEIFORM SIGN GU2 TIMES IGI GUNUCUNEIFORM SIGN GUD PLUS GISH TIMES" +
	" TAK4CUNEIFORM SIGN HA TENU GUNUCUNEIFORM SIGN HI TIMES ASH OVER HI TIME" +
	"S ASHCUNEIFORM SIGN KA TIMES BUCUNEIFORM SIGN KA TIMES KACUNEIFORM SIGN " +
	"KA TIMES U U UCUNEIFORM SIGN KA TIMES URCUNEIFORM SIGN LAGAB TIMES ZU OV" +
	"ER ZUCUNEIFORM SIGN LAK-003CUNEIFORM SIGN LAK-021CUNEIFORM SIGN LAK-025C" +
	"UNEIFORM SIGN LAK-030CUNEIFORM SIGN LAK-050CUNEIFORM SIGN LAK-051CUNEIFO" +
	"RM SIGN LAK-062CUNEIFORM SIGN LAK-079 OVER LAK-079 GUNUCUNEIFORM SIGN LA" +
	"K-080CUNEIFORM SIGN LAK-081 OVER LAK-081CUNEIFORM SIGN LAK-092CUNEIFORM " +
	"SIGN LAK-130CUNEIFORM SIGN LAK-142CUNEIFORM SIGN LAK-210CUNEIFORM SIGN L" +
	"AK-219CUNEIFORM SIGN LAK-220CUNEIFORM SIGN LAK-225CUNEIFORM SIGN LAK-228" +
	"CUNEIFORM SIGN LAK-238CUNEIFORM SIGN LAK-265CUNEIFORM SIGN LAK-266CUNEIF" +
	"ORM SIGN LAK-343CUNEIFORM SIGN LAK-347CUNEIFORM SIGN LAK-348CUNEIFORM SI" +
	"GN LAK-383CUNEIFORM SIGN LAK-384CUNEIFORM SIGN LAK-390CUNEIFORM SIGN LAK" +
	"-441CUNEIFORM SIGN LAK-449CUNEIFORM SIGN LAK-449 TIMES GUCUNEIFORM SIGN " +
	"LAK-449 TIMES IGICUNEIFORM SIGN LAK-449 TIMES PAP PLUS LU3CUNEIFORM SIGN" +
	" LAK-449 TIMES PAP PLUS PAP PLUS LU3CUNEIFORM SIGN LAK-449 TIMES U2 PLUS" +
	" BACUNEIFORM SIGN LAK-450CUNEIFORM SIGN LAK-457CUNEIFORM SIGN LAK-470CUN" +
	"EIFORM SIGN LAK-483CUNEIFORM SIGN LAK-490CUNEIFORM SIGN LAK-492CUNEIFORM" +
	" SIGN LAK-493CUNEIFORM SIGN LAK-495CUNEIFORM SIGN LAK-550CUNEIFORM SIGN " +
	"LAK-608CUNEIFORM SIGN LAK-617CUNEIFORM SIGN LAK-617 TIMES ASHCUNEIFORM S" +
	"IGN LAK-617 TIMES BADCUNEIFORM SIGN LAK-617 TIMES DUN3 GUNU GUNUCUNEIFOR" +
	"M SIGN LAK-617 TIMES KU3CUNEIFORM SIGN LAK-617 TIMES LACUNEIFORM SIGN LA" +
	"K-617 TIMES TARCUNEIFORM SIGN LAK-617 TIMES TECUNEIFORM SIGN LAK-617 TIM" +
	"ES U2CUNEIFORM SIGN LAK-617 TIMES UDCUNEIFORM SIGN LAK-617 TIMES URUDACU" +
	"NEIFORM SIGN LAK-636CUNEIFORM SIGN LAK-648CUNEIFORM SIGN LAK-648 TIMES D" +
	"UBCUNEIFORM SIGN LAK-648 TIMES GACUNEIFORM SIGN LAK-648 TIMES IGICUNEIFO" +
	"RM SIGN LAK-648 TIMES IGI GUNUCUNEIFORM SIGN LAK-648 TIMES NICUNEIFORM S" +
	"IGN LAK-648 TIMES PAP PLUS PAP PLUS LU3CUNEIFORM SIGN LAK-648 TIMES SHES" +
	"H PLUS KICUNEIFORM SIGN LAK-648 TIMES UDCUNEIFORM SIGN LAK-648 TIMES URU" +
	"DACUNEIFORM SIGN LAK-724CUNEIFORM SIGN LAK-749CUNEIFORM SIGN LU2 GUNU TI" +
	"MES ASHCUNEIFORM SIGN LU2 TIMES DISHCUNEIFORM SIGN LU2 TIMES HALCUNEIFOR" +
	"M SIGN LU2 TIMES PAPCUNEIFORM SIGN LU2 TIMES PAP PLUS PAP PLUS LU3CUNEIF" +
	"ORM SIGN LU2 TIMES TAK4CUNEIFORM SIGN MI PLUS ZA7CUNEIFORM SIGN MUSH OVE" +
	"R MUSH TIMES GACUNEIFORM SIGN MUSH OVER MUSH TIMES KAKCUNEIFORM SIGN NIN" +
	"DA2 TIMES DIM GUNUCUNEIFORM SIGN NINDA2 TIMES GISHCUNEIFORM SIGN NINDA2 " +
	"TIMES GULCUNEIFORM SIGN NINDA2 TIMES HICUNEIFORM SIGN NINDA2 TIMES KESH2" +
	"CUNEIFORM SIGN NINDA2 TIMES LAK-050CUNEIFORM SIGN NINDA2 TIMES MASHCUNEI" +
	"FORM SIGN NINDA2 TIMES PAP PLUS PAPCUNEIFORM SIGN NINDA2 TIMES UCUNEIFOR" +
	"M SIGN NINDA2 TIMES U PLUS UCUNEIFORM SIGN NINDA2 TIMES URUDACUNEIFORM S" +
	"IGN SAG GUNU TIMES HACUNEIFORM SIGN SAG TIMES ENCUNEIFORM SIGN SAG TIMES" +
	" SHE AT LEFTCUNEIFORM SIGN SAG TIMES TAK4CUNEIFORM SIGN SHA6 TENUCUNEIFO" +
	"RM SIGN SHE OVER SHECUNEIFORM SIGN SHE PLUS HUB2CUNEIFORM SIGN SHE PLUS " +
	"NAM2CUNEIFORM SIGN SHE PLUS SARCUNEIFORM SIGN SHU2 PLUS DUG TIMES NICUNE" +
	"IFORM SIGN SHU2 PLUS E2 TIMES ANCUNEIFORM SIGN SI TIMES TAK4CUNEIFORM SI" +
	"GN TAK4 PLUS SAGCUNEIFORM SIGN TUM TIMES GAN2 TENUCUNEIFORM SIGN TUM TIM" +
	"ES THREE DISHCUNEIFORM SIGN UR2 INVERTEDCUNEIFORM SIGN UR2 TIMES UDCUNEI" +
	"FORM SIGN URU TIMES DARA3CUNEIFORM SIGN URU TIMES LAK-668CUNEIFORM SIGN " +
	"URU TIMES LU3CUNEIFORM SIGN ZA7CUNEIFORM SIGN ZU OVER ZU PLUS SARCUNEIFO" +
	"RM SIGN ZU5 TIMES THREE DISH TENUEGYPTIAN HIEROGLYPH A001EGYPTIAN HIEROG" +
	"LYPH A002EGYPTIAN HIEROGLYPH A003EGYPTIAN HIEROGLYPH A004EGYPTIAN HIEROG" +
	"LYPH A005EGYPTIAN HIEROGLYPH A005AEGYPTIAN HIEROGLYPH A006EGYPTIAN HIERO" +
	"GLYPH A006AEGYPTIAN HIEROGLYPH A006BEGYPTIAN HIEROGLYPH A007EGYPTIAN HIE" +
	"ROGLYPH A008EGYPTIAN HIEROGLYPH A009EGYPTIAN HIEROGLYPH A010EGYPTIAN HIE" +
	"ROGLYPH A011EGYPTIAN HIEROGLYPH A012EGYPTIAN HIEROGLYPH A013EGYPTIAN HIE" +
	"ROGLYPH A014EGYPTIAN HIEROGLYPH A014AEGYPTIAN HIEROGLYPH A015EGYPTIAN HI" +
	"EROGLYPH A016EGYPTIAN HIEROGLYPH A017EGYPTIAN HIEROGLYPH A017AEGYPTIAN H" +
	"IEROGLYPH A018EGYPTIAN HIEROGLYPH A019EGYPTIAN HIEROGLYPH A020EGYPTIAN H" +
	"IEROGLYPH A021EGYPTIAN HIEROGLYPH A022EGYPTIAN HIEROGLYPH A023EGYPTIAN H" +
	"IEROGLYPH A024EGYPTIAN HIEROGLYPH A025EGYPTIAN HIEROGLYPH A026EGYPTIAN H" +
	"IEROGLYPH A027EGYPTIAN HIEROGLYPH A028EGYPTIAN HIEROGLYPH A029EGYPTIAN H" +
	"IEROGLYPH A030EGYPTIAN HIEROGLYPH A031EGYPTIAN HIEROGLYPH A032EGYPTIAN H" +
	"IEROGLYPH A032AEGYPTIAN HIEROGLYPH A033EGYPTIAN HIEROGLYPH A034EGYPTIAN " +
	"HIEROGLYPH A035EGYPTIAN HIEROGLYPH A036EGYPTIAN HIEROGLYPH A037EGYPTIAN " +
	"HIEROGLYPH A038EGYPTIAN HIEROGLYPH A039EGYPTIAN HIEROGLYPH A040EGYPTIAN ") + ("" +
	"HIEROGLYPH A040AEGYPTIAN HIEROGLYPH A041EGYPTIAN HIEROGLYPH A042EGYPTIAN" +
	" HIEROGLYPH A042AEGYPTIAN HIEROGLYPH A043EGYPTIAN HIEROGLYPH A043AEGYPTI" +
	"AN HIEROGLYPH A044EGYPTIAN HIEROGLYPH A045EGYPTIAN HIEROGLYPH A045AEGYPT" +
	"IAN HIEROGLYPH A046EGYPTIAN HIEROGLYPH A047EGYPTIAN HIEROGLYPH A048EGYPT" +
	"IAN HIEROGLYPH A049EGYPTIAN HIEROGLYPH A050EGYPTIAN HIEROGLYPH A051EGYPT" +
	"IAN HIEROGLYPH A052EGYPTIAN HIEROGLYPH A053EGYPTIAN HIEROGLYPH A054EGYPT" +
	"IAN HIEROGLYPH A055EGYPTIAN HIEROGLYPH A056EGYPTIAN HIEROGLYPH A057EGYPT" +
	"IAN HIEROGLYPH A058EGYPTIAN HIEROGLYPH A059EGYPTIAN HIEROGLYPH A060EGYPT" +
	"IAN HIEROGLYPH A061EGYPTIAN HIEROGLYPH A062EGYPTIAN HIEROGLYPH A063EGYPT" +
	"IAN HIEROGLYPH A064EGYPTIAN HIEROGLYPH A065EGYPTIAN HIEROGLYPH A066EGYPT" +
	"IAN HIEROGLYPH A067EGYPTIAN HIEROGLYPH A068EGYPTIAN HIEROGLYPH A069EGYPT" +
	"IAN HIEROGLYPH A070EGYPTIAN HIEROGLYPH B001EGYPTIAN HIEROGLYPH B002EGYPT" +
	"IAN HIEROGLYPH B003EGYPTIAN HIEROGLYPH B004EGYPTIAN HIEROGLYPH B005EGYPT" +
	"IAN HIEROGLYPH B005AEGYPTIAN HIEROGLYPH B006EGYPTIAN HIEROGLYPH B007EGYP" +
	"TIAN HIEROGLYPH B008EGYPTIAN HIEROGLYPH B009EGYPTIAN HIEROGLYPH C001EGYP" +
	"TIAN HIEROGLYPH C002EGYPTIAN HIEROGLYPH C002AEGYPTIAN HIEROGLYPH C002BEG" +
	"YPTIAN HIEROGLYPH C002CEGYPTIAN HIEROGLYPH C003EGYPTIAN HIEROGLYPH C004E" +
	"GYPTIAN HIEROGLYPH C005EGYPTIAN HIEROGLYPH C006EGYPTIAN HIEROGLYPH C007E" +
	"GYPTIAN HIEROGLYPH C008EGYPTIAN HIEROGLYPH C009EGYPTIAN HIEROGLYPH C010E" +
	"GYPTIAN HIEROGLYPH C010AEGYPTIAN HIEROGLYPH C011EGYPTIAN HIEROGLYPH C012" +
	"EGYPTIAN HIEROGLYPH C013EGYPTIAN HIEROGLYPH C014EGYPTIAN HIEROGLYPH C015" +
	"EGYPTIAN HIEROGLYPH C016EGYPTIAN HIEROGLYPH C017EGYPTIAN HIEROGLYPH C018" +
	"EGYPTIAN HIEROGLYPH C019EGYPTIAN HIEROGLYPH C020EGYPTIAN HIEROGLYPH C021" +
	"EGYPTIAN HIEROGLYPH C022EGYPTIAN HIEROGLYPH C023EGYPTIAN HIEROGLYPH C024" +
	"EGYPTIAN HIEROGLYPH D001EGYPTIAN HIEROGLYPH D002EGYPTIAN HIEROGLYPH D003" +
	"EGYPTIAN HIEROGLYPH D004EGYPTIAN HIEROGLYPH D005EGYPTIAN HIEROGLYPH D006" +
	"EGYPTIAN HIEROGLYPH D007EGYPTIAN HIEROGLYPH D008EGYPTIAN HIEROGLYPH D008" +
	"AEGYPTIAN HIEROGLYPH D009EGYPTIAN HIEROGLYPH D010EGYPTIAN HIEROGLYPH D01" +
	"1EGYPTIAN HIEROGLYPH D012EGYPTIAN HIEROGLYPH D013EGYPTIAN HIEROGLYPH D01" +
	"4EGYPTIAN HIEROGLYPH D015EGYPTIAN HIEROGLYPH D016EGYPTIAN HIEROGLYPH D01" +
	"7EGYPTIAN HIEROGLYPH D018EGYPTIAN HIEROGLYPH D019EGYPTIAN HIEROGLYPH D02" +
	"0EGYPTIAN HIEROGLYPH D021EGYPTIAN HIEROGLYPH D022EGYPTIAN HIEROGLYPH D02" +
	"3EGYPTIAN HIEROGLYPH D024EGYPTIAN HIEROGLYPH D025EGYPTIAN HIEROGLYPH D02" +
	"6EGYPTIAN HIEROGLYPH D027EGYPTIAN HIEROGLYPH D027AEGYPTIAN HIEROGLYPH D0" +
	"28EGYPTIAN HIEROGLYPH D029EGYPTIAN HIEROGLYPH D030EGYPTIAN HIEROGLYPH D0" +
	"31EGYPTIAN HIEROGLYPH D031AEGYPTIAN HIEROGLYPH D032EGYPTIAN HIEROGLYPH D" +
	"033EGYPTIAN HIEROGLYPH D034EGYPTIAN HIEROGLYPH D034AEGYPTIAN HIEROGLYPH " +
	"D035EGYPTIAN HIEROGLYPH D036EGYPTIAN HIEROGLYPH D037EGYPTIAN HIEROGLYPH " +
	"D038EGYPTIAN HIEROGLYPH D039EGYPTIAN HIEROGLYPH D040EGYPTIAN HIEROGLYPH " +
	"D041EGYPTIAN HIEROGLYPH D042EGYPTIAN HIEROGLYPH D043EGYPTIAN HIEROGLYPH " +
	"D044EGYPTIAN HIEROGLYPH D045EGYPTIAN HIEROGLYPH D046EGYPTIAN HIEROGLYPH " +
	"D046AEGYPTIAN HIEROGLYPH D047EGYPTIAN HIEROGLYPH D048EGYPTIAN HIEROGLYPH" +
	" D048AEGYPTIAN HIEROGLYPH D049EGYPTIAN HIEROGLYPH D050EGYPTIAN HIEROGLYP" +
	"H D050AEGYPTIAN HIEROGLYPH D050BEGYPTIAN HIEROGLYPH D050CEGYPTIAN HIEROG" +
	"LYPH D050DEGYPTIAN HIEROGLYPH D050EEGYPTIAN HIEROGLYPH D050FEGYPTIAN HIE" +
	"ROGLYPH D050GEGYPTIAN HIEROGLYPH D050HEGYPTIAN HIEROGLYPH D050IEGYPTIAN " +
	"HIEROGLYPH D051EGYPTIAN HIEROGLYPH D052EGYPTIAN HIEROGLYPH D052AEGYPTIAN" +
	" HIEROGLYPH D053EGYPTIAN HIEROGLYPH D054EGYPTIAN HIEROGLYPH D054AEGYPTIA" +
	"N HIEROGLYPH D055EGYPTIAN HIEROGLYPH D056EGYPTIAN HIEROGLYPH D057EGYPTIA" +
	"N HIEROGLYPH D058EGYPTIAN HIEROGLYPH D059EGYPTIAN HIEROGLYPH D060EGYPTIA" +
	"N HIEROGLYPH D061EGYPTIAN HIEROGLYPH D062EGYPTIAN HIEROGLYPH D063EGYPTIA" +
	"N HIEROGLYPH D064EGYPTIAN HIEROGLYPH D065EGYPTIAN HIEROGLYPH D066EGYPTIA" +
	"N HIEROGLYPH D067EGYPTIAN HIEROGLYPH D067AEGYPTIAN HIEROGLYPH D067BEGYPT" +
	"IAN HIEROGLYPH D067CEGYPTIAN HIEROGLYPH D067DEGYPTIAN HIEROGLYPH D067EEG" +
	"YPTIAN HIEROGLYPH D067FEGYPTIAN HIEROGLYPH D067GEGYPTIAN HIEROGLYPH D067" +
	"HEGYPTIAN HIEROGLYPH E001EGYPTIAN HIEROGLYPH E002EGYPTIAN HIEROGLYPH E00" +
	"3EGYPTIAN HIEROGLYPH E004EGYPTIAN HIEROGLYPH E005EGYPTIAN HIEROGLYPH E00" +
	"6EGYPTIAN HIEROGLYPH E007EGYPTIAN HIEROGLYPH E008EGYPTIAN HIEROGLYPH E00" +
	"8AEGYPTIAN HIEROGLYPH E009EGYPTIAN HIEROGLYPH E009AEGYPTIAN HIEROGLYPH E" +
	"010EGYPTIAN HIEROGLYPH E011EGYPTIAN HIEROGLYPH E012EGYPTIAN HIEROGLYPH E" +
	"013EGYPTIAN HIEROGLYPH E014EGYPTIAN HIEROGLYPH E015EGYPTIAN HIEROGLYPH E" +
	"016EGYPTIAN HIEROGLYPH E016AEGYPTIAN HIEROGLYPH E017EGYPTIAN HIEROGLYPH " +
	"E017AEGYPTIAN HIEROGLYPH E018EGYPTIAN HIEROGLYPH E019EGYPTIAN HIEROGLYPH" +
	" E020EGYPTIAN HIEROGLYPH E020AEGYPTIAN HIEROGLYPH E021EGYPTIAN HIEROGLYP") + ("" +
	"H E022EGYPTIAN HIEROGLYPH E023EGYPTIAN HIEROGLYPH E024EGYPTIAN HIEROGLYP" +
	"H E025EGYPTIAN HIEROGLYPH E026EGYPTIAN HIEROGLYPH E027EGYPTIAN HIEROGLYP" +
	"H E028EGYPTIAN HIEROGLYPH E028AEGYPTIAN HIEROGLYPH E029EGYPTIAN HIEROGLY" +
	"PH E030EGYPTIAN HIEROGLYPH E031EGYPTIAN HIEROGLYPH E032EGYPTIAN HIEROGLY" +
	"PH E033EGYPTIAN HIEROGLYPH E034EGYPTIAN HIEROGLYPH E034AEGYPTIAN HIEROGL" +
	"YPH E036EGYPTIAN HIEROGLYPH E037EGYPTIAN HIEROGLYPH E038EGYPTIAN HIEROGL" +
	"YPH F001EGYPTIAN HIEROGLYPH F001AEGYPTIAN HIEROGLYPH F002EGYPTIAN HIEROG" +
	"LYPH F003EGYPTIAN HIEROGLYPH F004EGYPTIAN HIEROGLYPH F005EGYPTIAN HIEROG" +
	"LYPH F006EGYPTIAN HIEROGLYPH F007EGYPTIAN HIEROGLYPH F008EGYPTIAN HIEROG" +
	"LYPH F009EGYPTIAN HIEROGLYPH F010EGYPTIAN HIEROGLYPH F011EGYPTIAN HIEROG" +
	"LYPH F012EGYPTIAN HIEROGLYPH F013EGYPTIAN HIEROGLYPH F013AEGYPTIAN HIERO" +
	"GLYPH F014EGYPTIAN HIEROGLYPH F015EGYPTIAN HIEROGLYPH F016EGYPTIAN HIERO" +
	"GLYPH F017EGYPTIAN HIEROGLYPH F018EGYPTIAN HIEROGLYPH F019EGYPTIAN HIERO" +
	"GLYPH F020EGYPTIAN HIEROGLYPH F021EGYPTIAN HIEROGLYPH F021AEGYPTIAN HIER" +
	"OGLYPH F022EGYPTIAN HIEROGLYPH F023EGYPTIAN HIEROGLYPH F024EGYPTIAN HIER" +
	"OGLYPH F025EGYPTIAN HIEROGLYPH F026EGYPTIAN HIEROGLYPH F027EGYPTIAN HIER" +
	"OGLYPH F028EGYPTIAN HIEROGLYPH F029EGYPTIAN HIEROGLYPH F030EGYPTIAN HIER" +
	"OGLYPH F031EGYPTIAN HIEROGLYPH F031AEGYPTIAN HIEROGLYPH F032EGYPTIAN HIE" +
	"ROGLYPH F033EGYPTIAN HIEROGLYPH F034EGYPTIAN HIEROGLYPH F035EGYPTIAN HIE" +
	"ROGLYPH F036EGYPTIAN HIEROGLYPH F037EGYPTIAN HIEROGLYPH F037AEGYPTIAN HI" +
	"EROGLYPH F038EGYPTIAN HIEROGLYPH F038AEGYPTIAN HIEROGLYPH F039EGYPTIAN H" +
	"IEROGLYPH F040EGYPTIAN HIEROGLYPH F041EGYPTIAN HIEROGLYPH F042EGYPTIAN H" +
	"IEROGLYPH F043EGYPTIAN HIEROGLYPH F044EGYPTIAN HIEROGLYPH F045EGYPTIAN H" +
	"IEROGLYPH F045AEGYPTIAN HIEROGLYPH F046EGYPTIAN HIEROGLYPH F046AEGYPTIAN" +
	" HIEROGLYPH F047EGYPTIAN HIEROGLYPH F047AEGYPTIAN HIEROGLYPH F048EGYPTIA" +
	"N HIEROGLYPH F049EGYPTIAN HIEROGLYPH F050EGYPTIAN HIEROGLYPH F051EGYPTIA" +
	"N HIEROGLYPH F051AEGYPTIAN HIEROGLYPH F051BEGYPTIAN HIEROGLYPH F051CEGYP" +
	"TIAN HIEROGLYPH F052EGYPTIAN HIEROGLYPH F053EGYPTIAN HIEROGLYPH G001EGYP" +
	"TIAN HIEROGLYPH G002EGYPTIAN HIEROGLYPH G003EGYPTIAN HIEROGLYPH G004EGYP" +
	"TIAN HIEROGLYPH G005EGYPTIAN HIEROGLYPH G006EGYPTIAN HIEROGLYPH G006AEGY" +
	"PTIAN HIEROGLYPH G007EGYPTIAN HIEROGLYPH G007AEGYPTIAN HIEROGLYPH G007BE" +
	"GYPTIAN HIEROGLYPH G008EGYPTIAN HIEROGLYPH G009EGYPTIAN HIEROGLYPH G010E" +
	"GYPTIAN HIEROGLYPH G011EGYPTIAN HIEROGLYPH G011AEGYPTIAN HIEROGLYPH G012" +
	"EGYPTIAN HIEROGLYPH G013EGYPTIAN HIEROGLYPH G014EGYPTIAN HIEROGLYPH G015" +
	"EGYPTIAN HIEROGLYPH G016EGYPTIAN HIEROGLYPH G017EGYPTIAN HIEROGLYPH G018" +
	"EGYPTIAN HIEROGLYPH G019EGYPTIAN HIEROGLYPH G020EGYPTIAN HIEROGLYPH G020" +
	"AEGYPTIAN HIEROGLYPH G021EGYPTIAN HIEROGLYPH G022EGYPTIAN HIEROGLYPH G02" +
	"3EGYPTIAN HIEROGLYPH G024EGYPTIAN HIEROGLYPH G025EGYPTIAN HIEROGLYPH G02" +
	"6EGYPTIAN HIEROGLYPH G026AEGYPTIAN HIEROGLYPH G027EGYPTIAN HIEROGLYPH G0" +
	"28EGYPTIAN HIEROGLYPH G029EGYPTIAN HIEROGLYPH G030EGYPTIAN HIEROGLYPH G0" +
	"31EGYPTIAN HIEROGLYPH G032EGYPTIAN HIEROGLYPH G033EGYPTIAN HIEROGLYPH G0" +
	"34EGYPTIAN HIEROGLYPH G035EGYPTIAN HIEROGLYPH G036EGYPTIAN HIEROGLYPH G0" +
	"36AEGYPTIAN HIEROGLYPH G037EGYPTIAN HIEROGLYPH G037AEGYPTIAN HIEROGLYPH " +
	"G038EGYPTIAN HIEROGLYPH G039EGYPTIAN HIEROGLYPH G040EGYPTIAN HIEROGLYPH " +
	"G041EGYPTIAN HIEROGLYPH G042EGYPTIAN HIEROGLYPH G043EGYPTIAN HIEROGLYPH " +
	"G043AEGYPTIAN HIEROGLYPH G044EGYPTIAN HIEROGLYPH G045EGYPTIAN HIEROGLYPH" +
	" G045AEGYPTIAN HIEROGLYPH G046EGYPTIAN HIEROGLYPH G047EGYPTIAN HIEROGLYP" +
	"H G048EGYPTIAN HIEROGLYPH G049EGYPTIAN HIEROGLYPH G050EGYPTIAN HIEROGLYP" +
	"H G051EGYPTIAN HIEROGLYPH G052EGYPTIAN HIEROGLYPH G053EGYPTIAN HIEROGLYP" +
	"H G054EGYPTIAN HIEROGLYPH H001EGYPTIAN HIEROGLYPH H002EGYPTIAN HIEROGLYP" +
	"H H003EGYPTIAN HIEROGLYPH H004EGYPTIAN HIEROGLYPH H005EGYPTIAN HIEROGLYP" +
	"H H006EGYPTIAN HIEROGLYPH H006AEGYPTIAN HIEROGLYPH H007EGYPTIAN HIEROGLY" +
	"PH H008EGYPTIAN HIEROGLYPH I001EGYPTIAN HIEROGLYPH I002EGYPTIAN HIEROGLY" +
	"PH I003EGYPTIAN HIEROGLYPH I004EGYPTIAN HIEROGLYPH I005EGYPTIAN HIEROGLY" +
	"PH I005AEGYPTIAN HIEROGLYPH I006EGYPTIAN HIEROGLYPH I007EGYPTIAN HIEROGL" +
	"YPH I008EGYPTIAN HIEROGLYPH I009EGYPTIAN HIEROGLYPH I009AEGYPTIAN HIEROG" +
	"LYPH I010EGYPTIAN HIEROGLYPH I010AEGYPTIAN HIEROGLYPH I011EGYPTIAN HIERO" +
	"GLYPH I011AEGYPTIAN HIEROGLYPH I012EGYPTIAN HIEROGLYPH I013EGYPTIAN HIER" +
	"OGLYPH I014EGYPTIAN HIEROGLYPH I015EGYPTIAN HIEROGLYPH K001EGYPTIAN HIER" +
	"OGLYPH K002EGYPTIAN HIEROGLYPH K003EGYPTIAN HIEROGLYPH K004EGYPTIAN HIER" +
	"OGLYPH K005EGYPTIAN HIEROGLYPH K006EGYPTIAN HIEROGLYPH K007EGYPTIAN HIER" +
	"OGLYPH K008EGYPTIAN HIEROGLYPH L001EGYPTIAN HIEROGLYPH L002EGYPTIAN HIER" +
	"OGLYPH L002AEGYPTIAN HIEROGLYPH L003EGYPTIAN HIEROGLYPH L004EGYPTIAN HIE" +
	"ROGLYPH L005EGYPTIAN HIEROGLYPH L006EGYPTIAN HIEROGLYPH L006AEGYPTIAN HI") + ("" +
	"EROGLYPH L007EGYPTIAN HIEROGLYPH L008EGYPTIAN HIEROGLYPH M001EGYPTIAN HI" +
	"EROGLYPH M001AEGYPTIAN HIEROGLYPH M001BEGYPTIAN HIEROGLYPH M002EGYPTIAN " +
	"HIEROGLYPH M003EGYPTIAN HIEROGLYPH M003AEGYPTIAN HIEROGLYPH M004EGYPTIAN" +
	" HIEROGLYPH M005EGYPTIAN HIEROGLYPH M006EGYPTIAN HIEROGLYPH M007EGYPTIAN" +
	" HIEROGLYPH M008EGYPTIAN HIEROGLYPH M009EGYPTIAN HIEROGLYPH M010EGYPTIAN" +
	" HIEROGLYPH M010AEGYPTIAN HIEROGLYPH M011EGYPTIAN HIEROGLYPH M012EGYPTIA" +
	"N HIEROGLYPH M012AEGYPTIAN HIEROGLYPH M012BEGYPTIAN HIEROGLYPH M012CEGYP" +
	"TIAN HIEROGLYPH M012DEGYPTIAN HIEROGLYPH M012EEGYPTIAN HIEROGLYPH M012FE" +
	"GYPTIAN HIEROGLYPH M012GEGYPTIAN HIEROGLYPH M012HEGYPTIAN HIEROGLYPH M01" +
	"3EGYPTIAN HIEROGLYPH M014EGYPTIAN HIEROGLYPH M015EGYPTIAN HIEROGLYPH M01" +
	"5AEGYPTIAN HIEROGLYPH M016EGYPTIAN HIEROGLYPH M016AEGYPTIAN HIEROGLYPH M" +
	"017EGYPTIAN HIEROGLYPH M017AEGYPTIAN HIEROGLYPH M018EGYPTIAN HIEROGLYPH " +
	"M019EGYPTIAN HIEROGLYPH M020EGYPTIAN HIEROGLYPH M021EGYPTIAN HIEROGLYPH " +
	"M022EGYPTIAN HIEROGLYPH M022AEGYPTIAN HIEROGLYPH M023EGYPTIAN HIEROGLYPH" +
	" M024EGYPTIAN HIEROGLYPH M024AEGYPTIAN HIEROGLYPH M025EGYPTIAN HIEROGLYP" +
	"H M026EGYPTIAN HIEROGLYPH M027EGYPTIAN HIEROGLYPH M028EGYPTIAN HIEROGLYP" +
	"H M028AEGYPTIAN HIEROGLYPH M029EGYPTIAN HIEROGLYPH M030EGYPTIAN HIEROGLY" +
	"PH M031EGYPTIAN HIEROGLYPH M031AEGYPTIAN HIEROGLYPH M032EGYPTIAN HIEROGL" +
	"YPH M033EGYPTIAN HIEROGLYPH M033AEGYPTIAN HIEROGLYPH M033BEGYPTIAN HIERO" +
	"GLYPH M034EGYPTIAN HIEROGLYPH M035EGYPTIAN HIEROGLYPH M036EGYPTIAN HIERO" +
	"GLYPH M037EGYPTIAN HIEROGLYPH M038EGYPTIAN HIEROGLYPH M039EGYPTIAN HIERO" +
	"GLYPH M040EGYPTIAN HIEROGLYPH M040AEGYPTIAN HIEROGLYPH M041EGYPTIAN HIER" +
	"OGLYPH M042EGYPTIAN HIEROGLYPH M043EGYPTIAN HIEROGLYPH M044EGYPTIAN HIER" +
	"OGLYPH N001EGYPTIAN HIEROGLYPH N002EGYPTIAN HIEROGLYPH N003EGYPTIAN HIER" +
	"OGLYPH N004EGYPTIAN HIEROGLYPH N005EGYPTIAN HIEROGLYPH N006EGYPTIAN HIER" +
	"OGLYPH N007EGYPTIAN HIEROGLYPH N008EGYPTIAN HIEROGLYPH N009EGYPTIAN HIER" +
	"OGLYPH N010EGYPTIAN HIEROGLYPH N011EGYPTIAN HIEROGLYPH N012EGYPTIAN HIER" +
	"OGLYPH N013EGYPTIAN HIEROGLYPH N014EGYPTIAN HIEROGLYPH N015EGYPTIAN HIER" +
	"OGLYPH N016EGYPTIAN HIEROGLYPH N017EGYPTIAN HIEROGLYPH N018EGYPTIAN HIER" +
	"OGLYPH N018AEGYPTIAN HIEROGLYPH N018BEGYPTIAN HIEROGLYPH N019EGYPTIAN HI" +
	"EROGLYPH N020EGYPTIAN HIEROGLYPH N021EGYPTIAN HIEROGLYPH N022EGYPTIAN HI" +
	"EROGLYPH N023EGYPTIAN HIEROGLYPH N024EGYPTIAN HIEROGLYPH N025EGYPTIAN HI" +
	"EROGLYPH N025AEGYPTIAN HIEROGLYPH N026EGYPTIAN HIEROGLYPH N027EGYPTIAN H" +
	"IEROGLYPH N028EGYPTIAN HIEROGLYPH N029EGYPTIAN HIEROGLYPH N030EGYPTIAN H" +
	"IEROGLYPH N031EGYPTIAN HIEROGLYPH N032EGYPTIAN HIEROGLYPH N033EGYPTIAN H" +
	"IEROGLYPH N033AEGYPTIAN HIEROGLYPH N034EGYPTIAN HIEROGLYPH N034AEGYPTIAN" +
	" HIEROGLYPH N035EGYPTIAN HIEROGLYPH N035AEGYPTIAN HIEROGLYPH N036EGYPTIA" +
	"N HIEROGLYPH N037EGYPTIAN HIEROGLYPH N037AEGYPTIAN HIEROGLYPH N038EGYPTI" +
	"AN HIEROGLYPH N039EGYPTIAN HIEROGLYPH N040EGYPTIAN HIEROGLYPH N041EGYPTI" +
	"AN HIEROGLYPH N042EGYPTIAN HIEROGLYPH NL001EGYPTIAN HIEROGLYPH NL002EGYP" +
	"TIAN HIEROGLYPH NL003EGYPTIAN HIEROGLYPH NL004EGYPTIAN HIEROGLYPH NL005E" +
	"GYPTIAN HIEROGLYPH NL005AEGYPTIAN HIEROGLYPH NL006EGYPTIAN HIEROGLYPH NL" +
	"007EGYPTIAN HIEROGLYPH NL008EGYPTIAN HIEROGLYPH NL009EGYPTIAN HIEROGLYPH" +
	" NL010EGYPTIAN HIEROGLYPH NL011EGYPTIAN HIEROGLYPH NL012EGYPTIAN HIEROGL" +
	"YPH NL013EGYPTIAN HIEROGLYPH NL014EGYPTIAN HIEROGLYPH NL015EGYPTIAN HIER" +
	"OGLYPH NL016EGYPTIAN HIEROGLYPH NL017EGYPTIAN HIEROGLYPH NL017AEGYPTIAN " +
	"HIEROGLYPH NL018EGYPTIAN HIEROGLYPH NL019EGYPTIAN HIEROGLYPH NL020EGYPTI" +
	"AN HIEROGLYPH NU001EGYPTIAN HIEROGLYPH NU002EGYPTIAN HIEROGLYPH NU003EGY" +
	"PTIAN HIEROGLYPH NU004EGYPTIAN HIEROGLYPH NU005EGYPTIAN HIEROGLYPH NU006" +
	"EGYPTIAN HIEROGLYPH NU007EGYPTIAN HIEROGLYPH NU008EGYPTIAN HIEROGLYPH NU" +
	"009EGYPTIAN HIEROGLYPH NU010EGYPTIAN HIEROGLYPH NU010AEGYPTIAN HIEROGLYP" +
	"H NU011EGYPTIAN HIEROGLYPH NU011AEGYPTIAN HIEROGLYPH NU012EGYPTIAN HIERO" +
	"GLYPH NU013EGYPTIAN HIEROGLYPH NU014EGYPTIAN HIEROGLYPH NU015EGYPTIAN HI" +
	"EROGLYPH NU016EGYPTIAN HIEROGLYPH NU017EGYPTIAN HIEROGLYPH NU018EGYPTIAN" +
	" HIEROGLYPH NU018AEGYPTIAN HIEROGLYPH NU019EGYPTIAN HIEROGLYPH NU020EGYP" +
	"TIAN HIEROGLYPH NU021EGYPTIAN HIEROGLYPH NU022EGYPTIAN HIEROGLYPH NU022A" +
	"EGYPTIAN HIEROGLYPH O001EGYPTIAN HIEROGLYPH O001AEGYPTIAN HIEROGLYPH O00" +
	"2EGYPTIAN HIEROGLYPH O003EGYPTIAN HIEROGLYPH O004EGYPTIAN HIEROGLYPH O00" +
	"5EGYPTIAN HIEROGLYPH O005AEGYPTIAN HIEROGLYPH O006EGYPTIAN HIEROGLYPH O0" +
	"06AEGYPTIAN HIEROGLYPH O006BEGYPTIAN HIEROGLYPH O006CEGYPTIAN HIEROGLYPH" +
	" O006DEGYPTIAN HIEROGLYPH O006EEGYPTIAN HIEROGLYPH O006FEGYPTIAN HIEROGL" +
	"YPH O007EGYPTIAN HIEROGLYPH O008EGYPTIAN HIEROGLYPH O009EGYPTIAN HIEROGL" +
	"YPH O010EGYPTIAN HIEROGLYPH O010AEGYPTIAN HIEROGLYPH O010BEGYPTIAN HIERO" +
	"GLYPH O010CEGYPTIAN HIEROGLYPH O011EGYPTIAN HIEROGLYPH O012EGYPTIAN HIER") + ("" +
	"OGLYPH O013EGYPTIAN HIEROGLYPH O014EGYPTIAN HIEROGLYPH O015EGYPTIAN HIER" +
	"OGLYPH O016EGYPTIAN HIEROGLYPH O017EGYPTIAN HIEROGLYPH O018EGYPTIAN HIER" +
	"OGLYPH O019EGYPTIAN HIEROGLYPH O019AEGYPTIAN HIEROGLYPH O020EGYPTIAN HIE" +
	"ROGLYPH O020AEGYPTIAN HIEROGLYPH O021EGYPTIAN HIEROGLYPH O022EGYPTIAN HI" +
	"EROGLYPH O023EGYPTIAN HIEROGLYPH O024EGYPTIAN HIEROGLYPH O024AEGYPTIAN H" +
	"IEROGLYPH O025EGYPTIAN HIEROGLYPH O025AEGYPTIAN HIEROGLYPH O026EGYPTIAN " +
	"HIEROGLYPH O027EGYPTIAN HIEROGLYPH O028EGYPTIAN HIEROGLYPH O029EGYPTIAN " +
	"HIEROGLYPH O029AEGYPTIAN HIEROGLYPH O030EGYPTIAN HIEROGLYPH O030AEGYPTIA" +
	"N HIEROGLYPH O031EGYPTIAN HIEROGLYPH O032EGYPTIAN HIEROGLYPH O033EGYPTIA" +
	"N HIEROGLYPH O033AEGYPTIAN HIEROGLYPH O034EGYPTIAN HIEROGLYPH O035EGYPTI" +
	"AN HIEROGLYPH O036EGYPTIAN HIEROGLYPH O036AEGYPTIAN HIEROGLYPH O036BEGYP" +
	"TIAN HIEROGLYPH O036CEGYPTIAN HIEROGLYPH O036DEGYPTIAN HIEROGLYPH O037EG" +
	"YPTIAN HIEROGLYPH O038EGYPTIAN HIEROGLYPH O039EGYPTIAN HIEROGLYPH O040EG" +
	"YPTIAN HIEROGLYPH O041EGYPTIAN HIEROGLYPH O042EGYPTIAN HIEROGLYPH O043EG" +
	"YPTIAN HIEROGLYPH O044EGYPTIAN HIEROGLYPH O045EGYPTIAN HIEROGLYPH O046EG" +
	"YPTIAN HIEROGLYPH O047EGYPTIAN HIEROGLYPH O048EGYPTIAN HIEROGLYPH O049EG" +
	"YPTIAN HIEROGLYPH O050EGYPTIAN HIEROGLYPH O050AEGYPTIAN HIEROGLYPH O050B" +
	"EGYPTIAN HIEROGLYPH O051EGYPTIAN HIEROGLYPH P001EGYPTIAN HIEROGLYPH P001" +
	"AEGYPTIAN HIEROGLYPH P002EGYPTIAN HIEROGLYPH P003EGYPTIAN HIEROGLYPH P00" +
	"3AEGYPTIAN HIEROGLYPH P004EGYPTIAN HIEROGLYPH P005EGYPTIAN HIEROGLYPH P0" +
	"06EGYPTIAN HIEROGLYPH P007EGYPTIAN HIEROGLYPH P008EGYPTIAN HIEROGLYPH P0" +
	"09EGYPTIAN HIEROGLYPH P010EGYPTIAN HIEROGLYPH P011EGYPTIAN HIEROGLYPH Q0" +
	"01EGYPTIAN HIEROGLYPH Q002EGYPTIAN HIEROGLYPH Q003EGYPTIAN HIEROGLYPH Q0" +
	"04EGYPTIAN HIEROGLYPH Q005EGYPTIAN HIEROGLYPH Q006EGYPTIAN HIEROGLYPH Q0" +
	"07EGYPTIAN HIEROGLYPH R001EGYPTIAN HIEROGLYPH R002EGYPTIAN HIEROGLYPH R0" +
	"02AEGYPTIAN HIEROGLYPH R003EGYPTIAN HIEROGLYPH R003AEGYPTIAN HIEROGLYPH " +
	"R003BEGYPTIAN HIEROGLYPH R004EGYPTIAN HIEROGLYPH R005EGYPTIAN HIEROGLYPH" +
	" R006EGYPTIAN HIEROGLYPH R007EGYPTIAN HIEROGLYPH R008EGYPTIAN HIEROGLYPH" +
	" R009EGYPTIAN HIEROGLYPH R010EGYPTIAN HIEROGLYPH R010AEGYPTIAN HIEROGLYP" +
	"H R011EGYPTIAN HIEROGLYPH R012EGYPTIAN HIEROGLYPH R013EGYPTIAN HIEROGLYP" +
	"H R014EGYPTIAN HIEROGLYPH R015EGYPTIAN HIEROGLYPH R016EGYPTIAN HIEROGLYP" +
	"H R016AEGYPTIAN HIEROGLYPH R017EGYPTIAN HIEROGLYPH R018EGYPTIAN HIEROGLY" +
	"PH R019EGYPTIAN HIEROGLYPH R020EGYPTIAN HIEROGLYPH R021EGYPTIAN HIEROGLY" +
	"PH R022EGYPTIAN HIEROGLYPH R023EGYPTIAN HIEROGLYPH R024EGYPTIAN HIEROGLY" +
	"PH R025EGYPTIAN HIEROGLYPH R026EGYPTIAN HIEROGLYPH R027EGYPTIAN HIEROGLY" +
	"PH R028EGYPTIAN HIEROGLYPH R029EGYPTIAN HIEROGLYPH S001EGYPTIAN HIEROGLY" +
	"PH S002EGYPTIAN HIEROGLYPH S002AEGYPTIAN HIEROGLYPH S003EGYPTIAN HIEROGL" +
	"YPH S004EGYPTIAN HIEROGLYPH S005EGYPTIAN HIEROGLYPH S006EGYPTIAN HIEROGL" +
	"YPH S006AEGYPTIAN HIEROGLYPH S007EGYPTIAN HIEROGLYPH S008EGYPTIAN HIEROG" +
	"LYPH S009EGYPTIAN HIEROGLYPH S010EGYPTIAN HIEROGLYPH S011EGYPTIAN HIEROG" +
	"LYPH S012EGYPTIAN HIEROGLYPH S013EGYPTIAN HIEROGLYPH S014EGYPTIAN HIEROG" +
	"LYPH S014AEGYPTIAN HIEROGLYPH S014BEGYPTIAN HIEROGLYPH S015EGYPTIAN HIER" +
	"OGLYPH S016EGYPTIAN HIEROGLYPH S017EGYPTIAN HIEROGLYPH S017AEGYPTIAN HIE" +
	"ROGLYPH S018EGYPTIAN HIEROGLYPH S019EGYPTIAN HIEROGLYPH S020EGYPTIAN HIE" +
	"ROGLYPH S021EGYPTIAN HIEROGLYPH S022EGYPTIAN HIEROGLYPH S023EGYPTIAN HIE" +
	"ROGLYPH S024EGYPTIAN HIEROGLYPH S025EGYPTIAN HIEROGLYPH S026EGYPTIAN HIE" +
	"ROGLYPH S026AEGYPTIAN HIEROGLYPH S026BEGYPTIAN HIEROGLYPH S027EGYPTIAN H" +
	"IEROGLYPH S028EGYPTIAN HIEROGLYPH S029EGYPTIAN HIEROGLYPH S030EGYPTIAN H" +
	"IEROGLYPH S031EGYPTIAN HIEROGLYPH S032EGYPTIAN HIEROGLYPH S033EGYPTIAN H" +
	"IEROGLYPH S034EGYPTIAN HIEROGLYPH S035EGYPTIAN HIEROGLYPH S035AEGYPTIAN " +
	"HIEROGLYPH S036EGYPTIAN HIEROGLYPH S037EGYPTIAN HIEROGLYPH S038EGYPTIAN " +
	"HIEROGLYPH S039EGYPTIAN HIEROGLYPH S040EGYPTIAN HIEROGLYPH S041EGYPTIAN " +
	"HIEROGLYPH S042EGYPTIAN HIEROGLYPH S043EGYPTIAN HIEROGLYPH S044EGYPTIAN " +
	"HIEROGLYPH S045EGYPTIAN HIEROGLYPH S046EGYPTIAN HIEROGLYPH T001EGYPTIAN " +
	"HIEROGLYPH T002EGYPTIAN HIEROGLYPH T003EGYPTIAN HIEROGLYPH T003AEGYPTIAN" +
	" HIEROGLYPH T004EGYPTIAN HIEROGLYPH T005EGYPTIAN HIEROGLYPH T006EGYPTIAN" +
	" HIEROGLYPH T007EGYPTIAN HIEROGLYPH T007AEGYPTIAN HIEROGLYPH T008EGYPTIA" +
	"N HIEROGLYPH T008AEGYPTIAN HIEROGLYPH T009EGYPTIAN HIEROGLYPH T009AEGYPT" +
	"IAN HIEROGLYPH T010EGYPTIAN HIEROGLYPH T011EGYPTIAN HIEROGLYPH T011AEGYP" +
	"TIAN HIEROGLYPH T012EGYPTIAN HIEROGLYPH T013EGYPTIAN HIEROGLYPH T014EGYP" +
	"TIAN HIEROGLYPH T015EGYPTIAN HIEROGLYPH T016EGYPTIAN HIEROGLYPH T016AEGY" +
	"PTIAN HIEROGLYPH T017EGYPTIAN HIEROGLYPH T018EGYPTIAN HIEROGLYPH T019EGY" +
	"PTIAN HIEROGLYPH T020EGYPTIAN HIEROGLYPH T021EGYPTIAN HIEROGLYPH T022EGY" +
	"PTIAN HIEROGLYPH T023EGYPTIAN HIEROGLYPH T024EGYPTIAN HIEROGLYPH T025EGY") + ("" +
	"PTIAN HIEROGLYPH T026EGYPTIAN HIEROGLYPH T027EGYPTIAN HIEROGLYPH T028EGY" +
	"PTIAN HIEROGLYPH T029EGYPTIAN HIEROGLYPH T030EGYPTIAN HIEROGLYPH T031EGY" +
	"PTIAN HIEROGLYPH T032EGYPTIAN HIEROGLYPH T032AEGYPTIAN HIEROGLYPH T033EG" +
	"YPTIAN HIEROGLYPH T033AEGYPTIAN HIEROGLYPH T034EGYPTIAN HIEROGLYPH T035E" +
	"GYPTIAN HIEROGLYPH T036EGYPTIAN HIEROGLYPH U001EGYPTIAN HIEROGLYPH U002E" +
	"GYPTIAN HIEROGLYPH U003EGYPTIAN HIEROGLYPH U004EGYPTIAN HIEROGLYPH U005E" +
	"GYPTIAN HIEROGLYPH U006EGYPTIAN HIEROGLYPH U006AEGYPTIAN HIEROGLYPH U006" +
	"BEGYPTIAN HIEROGLYPH U007EGYPTIAN HIEROGLYPH U008EGYPTIAN HIEROGLYPH U00" +
	"9EGYPTIAN HIEROGLYPH U010EGYPTIAN HIEROGLYPH U011EGYPTIAN HIEROGLYPH U01" +
	"2EGYPTIAN HIEROGLYPH U013EGYPTIAN HIEROGLYPH U014EGYPTIAN HIEROGLYPH U01" +
	"5EGYPTIAN HIEROGLYPH U016EGYPTIAN HIEROGLYPH U017EGYPTIAN HIEROGLYPH U01" +
	"8EGYPTIAN HIEROGLYPH U019EGYPTIAN HIEROGLYPH U020EGYPTIAN HIEROGLYPH U02" +
	"1EGYPTIAN HIEROGLYPH U022EGYPTIAN HIEROGLYPH U023EGYPTIAN HIEROGLYPH U02" +
	"3AEGYPTIAN HIEROGLYPH U024EGYPTIAN HIEROGLYPH U025EGYPTIAN HIEROGLYPH U0" +
	"26EGYPTIAN HIEROGLYPH U027EGYPTIAN HIEROGLYPH U028EGYPTIAN HIEROGLYPH U0" +
	"29EGYPTIAN HIEROGLYPH U029AEGYPTIAN HIEROGLYPH U030EGYPTIAN HIEROGLYPH U" +
	"031EGYPTIAN HIEROGLYPH U032EGYPTIAN HIEROGLYPH U032AEGYPTIAN HIEROGLYPH " +
	"U033EGYPTIAN HIEROGLYPH U034EGYPTIAN HIEROGLYPH U035EGYPTIAN HIEROGLYPH " +
	"U036EGYPTIAN HIEROGLYPH U037EGYPTIAN HIEROGLYPH U038EGYPTIAN HIEROGLYPH " +
	"U039EGYPTIAN HIEROGLYPH U040EGYPTIAN HIEROGLYPH U041EGYPTIAN HIEROGLYPH " +
	"U042EGYPTIAN HIEROGLYPH V001EGYPTIAN HIEROGLYPH V001AEGYPTIAN HIEROGLYPH" +
	" V001BEGYPTIAN HIEROGLYPH V001CEGYPTIAN HIEROGLYPH V001DEGYPTIAN HIEROGL" +
	"YPH V001EEGYPTIAN HIEROGLYPH V001FEGYPTIAN HIEROGLYPH V001GEGYPTIAN HIER" +
	"OGLYPH V001HEGYPTIAN HIEROGLYPH V001IEGYPTIAN HIEROGLYPH V002EGYPTIAN HI" +
	"EROGLYPH V002AEGYPTIAN HIEROGLYPH V003EGYPTIAN HIEROGLYPH V004EGYPTIAN H" +
	"IEROGLYPH V005EGYPTIAN HIEROGLYPH V006EGYPTIAN HIEROGLYPH V007EGYPTIAN H" +
	"IEROGLYPH V007AEGYPTIAN HIEROGLYPH V007BEGYPTIAN HIEROGLYPH V008EGYPTIAN" +
	" HIEROGLYPH V009EGYPTIAN HIEROGLYPH V010EGYPTIAN HIEROGLYPH V011EGYPTIAN" +
	" HIEROGLYPH V011AEGYPTIAN HIEROGLYPH V011BEGYPTIAN HIEROGLYPH V011CEGYPT" +
	"IAN HIEROGLYPH V012EGYPTIAN HIEROGLYPH V012AEGYPTIAN HIEROGLYPH V012BEGY" +
	"PTIAN HIEROGLYPH V013EGYPTIAN HIEROGLYPH V014EGYPTIAN HIEROGLYPH V015EGY" +
	"PTIAN HIEROGLYPH V016EGYPTIAN HIEROGLYPH V017EGYPTIAN HIEROGLYPH V018EGY" +
	"PTIAN HIEROGLYPH V019EGYPTIAN HIEROGLYPH V020EGYPTIAN HIEROGLYPH V020AEG" +
	"YPTIAN HIEROGLYPH V020BEGYPTIAN HIEROGLYPH V020CEGYPTIAN HIEROGLYPH V020" +
	"DEGYPTIAN HIEROGLYPH V020EEGYPTIAN HIEROGLYPH V020FEGYPTIAN HIEROGLYPH V" +
	"020GEGYPTIAN HIEROGLYPH V020HEGYPTIAN HIEROGLYPH V020IEGYPTIAN HIEROGLYP" +
	"H V020JEGYPTIAN HIEROGLYPH V020KEGYPTIAN HIEROGLYPH V020LEGYPTIAN HIEROG" +
	"LYPH V021EGYPTIAN HIEROGLYPH V022EGYPTIAN HIEROGLYPH V023EGYPTIAN HIEROG" +
	"LYPH V023AEGYPTIAN HIEROGLYPH V024EGYPTIAN HIEROGLYPH V025EGYPTIAN HIERO" +
	"GLYPH V026EGYPTIAN HIEROGLYPH V027EGYPTIAN HIEROGLYPH V028EGYPTIAN HIERO" +
	"GLYPH V028AEGYPTIAN HIEROGLYPH V029EGYPTIAN HIEROGLYPH V029AEGYPTIAN HIE" +
	"ROGLYPH V030EGYPTIAN HIEROGLYPH V030AEGYPTIAN HIEROGLYPH V031EGYPTIAN HI" +
	"EROGLYPH V031AEGYPTIAN HIEROGLYPH V032EGYPTIAN HIEROGLYPH V033EGYPTIAN H" +
	"IEROGLYPH V033AEGYPTIAN HIEROGLYPH V034EGYPTIAN HIEROGLYPH V035EGYPTIAN " +
	"HIEROGLYPH V036EGYPTIAN HIEROGLYPH V037EGYPTIAN HIEROGLYPH V037AEGYPTIAN" +
	" HIEROGLYPH V038EGYPTIAN HIEROGLYPH V039EGYPTIAN HIEROGLYPH V040EGYPTIAN" +
	" HIEROGLYPH V040AEGYPTIAN HIEROGLYPH W001EGYPTIAN HIEROGLYPH W002EGYPTIA" +
	"N HIEROGLYPH W003EGYPTIAN HIEROGLYPH W003AEGYPTIAN HIEROGLYPH W004EGYPTI" +
	"AN HIEROGLYPH W005EGYPTIAN HIEROGLYPH W006EGYPTIAN HIEROGLYPH W007EGYPTI" +
	"AN HIEROGLYPH W008EGYPTIAN HIEROGLYPH W009EGYPTIAN HIEROGLYPH W009AEGYPT" +
	"IAN HIEROGLYPH W010EGYPTIAN HIEROGLYPH W010AEGYPTIAN HIEROGLYPH W011EGYP" +
	"TIAN HIEROGLYPH W012EGYPTIAN HIEROGLYPH W013EGYPTIAN HIEROGLYPH W014EGYP" +
	"TIAN HIEROGLYPH W014AEGYPTIAN HIEROGLYPH W015EGYPTIAN HIEROGLYPH W016EGY" +
	"PTIAN HIEROGLYPH W017EGYPTIAN HIEROGLYPH W017AEGYPTIAN HIEROGLYPH W018EG" +
	"YPTIAN HIEROGLYPH W018AEGYPTIAN HIEROGLYPH W019EGYPTIAN HIEROGLYPH W020E" +
	"GYPTIAN HIEROGLYPH W021EGYPTIAN HIEROGLYPH W022EGYPTIAN HIEROGLYPH W023E" +
	"GYPTIAN HIEROGLYPH W024EGYPTIAN HIEROGLYPH W024AEGYPTIAN HIEROGLYPH W025" +
	"EGYPTIAN HIEROGLYPH X001EGYPTIAN HIEROGLYPH X002EGYPTIAN HIEROGLYPH X003" +
	"EGYPTIAN HIEROGLYPH X004EGYPTIAN HIEROGLYPH X004AEGYPTIAN HIEROGLYPH X00" +
	"4BEGYPTIAN HIEROGLYPH X005EGYPTIAN HIEROGLYPH X006EGYPTIAN HIEROGLYPH X0" +
	"06AEGYPTIAN HIEROGLYPH X007EGYPTIAN HIEROGLYPH X008EGYPTIAN HIEROGLYPH X" +
	"008AEGYPTIAN HIEROGLYPH Y001EGYPTIAN HIEROGLYPH Y001AEGYPTIAN HIEROGLYPH" +
	" Y002EGYPTIAN HIEROGLYPH Y003EGYPTIAN HIEROGLYPH Y004EGYPTIAN HIEROGLYPH" +
	" Y005EGYPTIAN HIEROGLYPH Y006EGYPTIAN HIEROGLYPH Y007EGYPTIAN HIEROGLYPH") + ("" +
	" Y008EGYPTIAN HIEROGLYPH Z001EGYPTIAN HIEROGLYPH Z002EGYPTIAN HIEROGLYPH" +
	" Z002AEGYPTIAN HIEROGLYPH Z002BEGYPTIAN HIEROGLYPH Z002CEGYPTIAN HIEROGL" +
	"YPH Z002DEGYPTIAN HIEROGLYPH Z003EGYPTIAN HIEROGLYPH Z003AEGYPTIAN HIERO" +
	"GLYPH Z003BEGYPTIAN HIEROGLYPH Z004EGYPTIAN HIEROGLYPH Z004AEGYPTIAN HIE" +
	"ROGLYPH Z005EGYPTIAN HIEROGLYPH Z005AEGYPTIAN HIEROGLYPH Z006EGYPTIAN HI" +
	"EROGLYPH Z007EGYPTIAN HIEROGLYPH Z008EGYPTIAN HIEROGLYPH Z009EGYPTIAN HI" +
	"EROGLYPH Z010EGYPTIAN HIEROGLYPH Z011EGYPTIAN HIEROGLYPH Z012EGYPTIAN HI" +
	"EROGLYPH Z013EGYPTIAN HIEROGLYPH Z014EGYPTIAN HIEROGLYPH Z015EGYPTIAN HI" +
	"EROGLYPH Z015AEGYPTIAN HIEROGLYPH Z015BEGYPTIAN HIEROGLYPH Z015CEGYPTIAN" +
	" HIEROGLYPH Z015DEGYPTIAN HIEROGLYPH Z015EEGYPTIAN HIEROGLYPH Z015FEGYPT" +
	"IAN HIEROGLYPH Z015GEGYPTIAN HIEROGLYPH Z015HEGYPTIAN HIEROGLYPH Z015IEG" +
	"YPTIAN HIEROGLYPH Z016EGYPTIAN HIEROGLYPH Z016AEGYPTIAN HIEROGLYPH Z016B" +
	"EGYPTIAN HIEROGLYPH Z016CEGYPTIAN HIEROGLYPH Z016DEGYPTIAN HIEROGLYPH Z0" +
	"16EEGYPTIAN HIEROGLYPH Z016FEGYPTIAN HIEROGLYPH Z016GEGYPTIAN HIEROGLYPH" +
	" Z016HEGYPTIAN HIEROGLYPH AA001EGYPTIAN HIEROGLYPH AA002EGYPTIAN HIEROGL" +
	"YPH AA003EGYPTIAN HIEROGLYPH AA004EGYPTIAN HIEROGLYPH AA005EGYPTIAN HIER" +
	"OGLYPH AA006EGYPTIAN HIEROGLYPH AA007EGYPTIAN HIEROGLYPH AA007AEGYPTIAN " +
	"HIEROGLYPH AA007BEGYPTIAN HIEROGLYPH AA008EGYPTIAN HIEROGLYPH AA009EGYPT" +
	"IAN HIEROGLYPH AA010EGYPTIAN HIEROGLYPH AA011EGYPTIAN HIEROGLYPH AA012EG" +
	"YPTIAN HIEROGLYPH AA013EGYPTIAN HIEROGLYPH AA014EGYPTIAN HIEROGLYPH AA01" +
	"5EGYPTIAN HIEROGLYPH AA016EGYPTIAN HIEROGLYPH AA017EGYPTIAN HIEROGLYPH A" +
	"A018EGYPTIAN HIEROGLYPH AA019EGYPTIAN HIEROGLYPH AA020EGYPTIAN HIEROGLYP" +
	"H AA021EGYPTIAN HIEROGLYPH AA022EGYPTIAN HIEROGLYPH AA023EGYPTIAN HIEROG" +
	"LYPH AA024EGYPTIAN HIEROGLYPH AA025EGYPTIAN HIEROGLYPH AA026EGYPTIAN HIE" +
	"ROGLYPH AA027EGYPTIAN HIEROGLYPH AA028EGYPTIAN HIEROGLYPH AA029EGYPTIAN " +
	"HIEROGLYPH AA030EGYPTIAN HIEROGLYPH AA031EGYPTIAN HIEROGLYPH AA032EGYPTI" +
	"AN HIEROGLYPH VERTICAL JOINEREGYPTIAN HIEROGLYPH HORIZONTAL JOINEREGYPTI" +
	"AN HIEROGLYPH INSERT AT TOP STARTEGYPTIAN HIEROGLYPH INSERT AT BOTTOM ST" +
	"ARTEGYPTIAN HIEROGLYPH INSERT AT TOP ENDEGYPTIAN HIEROGLYPH INSERT AT BO" +
	"TTOM ENDEGYPTIAN HIEROGLYPH OVERLAY MIDDLEEGYPTIAN HIEROGLYPH BEGIN SEGM" +
	"ENTEGYPTIAN HIEROGLYPH END SEGMENTANATOLIAN HIEROGLYPH A001ANATOLIAN HIE" +
	"ROGLYPH A002ANATOLIAN HIEROGLYPH A003ANATOLIAN HIEROGLYPH A004ANATOLIAN " +
	"HIEROGLYPH A005ANATOLIAN HIEROGLYPH A006ANATOLIAN HIEROGLYPH A007ANATOLI" +
	"AN HIEROGLYPH A008ANATOLIAN HIEROGLYPH A009ANATOLIAN HIEROGLYPH A010ANAT" +
	"OLIAN HIEROGLYPH A010AANATOLIAN HIEROGLYPH A011ANATOLIAN HIEROGLYPH A012" +
	"ANATOLIAN HIEROGLYPH A013ANATOLIAN HIEROGLYPH A014ANATOLIAN HIEROGLYPH A" +
	"015ANATOLIAN HIEROGLYPH A016ANATOLIAN HIEROGLYPH A017ANATOLIAN HIEROGLYP" +
	"H A018ANATOLIAN HIEROGLYPH A019ANATOLIAN HIEROGLYPH A020ANATOLIAN HIEROG" +
	"LYPH A021ANATOLIAN HIEROGLYPH A022ANATOLIAN HIEROGLYPH A023ANATOLIAN HIE" +
	"ROGLYPH A024ANATOLIAN HIEROGLYPH A025ANATOLIAN HIEROGLYPH A026ANATOLIAN " +
	"HIEROGLYPH A026AANATOLIAN HIEROGLYPH A027ANATOLIAN HIEROGLYPH A028ANATOL" +
	"IAN HIEROGLYPH A029ANATOLIAN HIEROGLYPH A030ANATOLIAN HIEROGLYPH A031ANA" +
	"TOLIAN HIEROGLYPH A032ANATOLIAN HIEROGLYPH A033ANATOLIAN HIEROGLYPH A034" +
	"ANATOLIAN HIEROGLYPH A035ANATOLIAN HIEROGLYPH A036ANATOLIAN HIEROGLYPH A" +
	"037ANATOLIAN HIEROGLYPH A038ANATOLIAN HIEROGLYPH A039ANATOLIAN HIEROGLYP" +
	"H A039AANATOLIAN HIEROGLYPH A040ANATOLIAN HIEROGLYPH A041ANATOLIAN HIERO" +
	"GLYPH A041AANATOLIAN HIEROGLYPH A042ANATOLIAN HIEROGLYPH A043ANATOLIAN H" +
	"IEROGLYPH A044ANATOLIAN HIEROGLYPH A045ANATOLIAN HIEROGLYPH A045AANATOLI" +
	"AN HIEROGLYPH A046ANATOLIAN HIEROGLYPH A046AANATOLIAN HIEROGLYPH A046BAN" +
	"ATOLIAN HIEROGLYPH A047ANATOLIAN HIEROGLYPH A048ANATOLIAN HIEROGLYPH A04" +
	"9ANATOLIAN HIEROGLYPH A050ANATOLIAN HIEROGLYPH A051ANATOLIAN HIEROGLYPH " +
	"A052ANATOLIAN HIEROGLYPH A053ANATOLIAN HIEROGLYPH A054ANATOLIAN HIEROGLY" +
	"PH A055ANATOLIAN HIEROGLYPH A056ANATOLIAN HIEROGLYPH A057ANATOLIAN HIERO" +
	"GLYPH A058ANATOLIAN HIEROGLYPH A059ANATOLIAN HIEROGLYPH A060ANATOLIAN HI" +
	"EROGLYPH A061ANATOLIAN HIEROGLYPH A062ANATOLIAN HIEROGLYPH A063ANATOLIAN" +
	" HIEROGLYPH A064ANATOLIAN HIEROGLYPH A065ANATOLIAN HIEROGLYPH A066ANATOL" +
	"IAN HIEROGLYPH A066AANATOLIAN HIEROGLYPH A066BANATOLIAN HIEROGLYPH A066C" +
	"ANATOLIAN HIEROGLYPH A067ANATOLIAN HIEROGLYPH A068ANATOLIAN HIEROGLYPH A" +
	"069ANATOLIAN HIEROGLYPH A070ANATOLIAN HIEROGLYPH A071ANATOLIAN HIEROGLYP" +
	"H A072ANATOLIAN HIEROGLYPH A073ANATOLIAN HIEROGLYPH A074ANATOLIAN HIEROG" +
	"LYPH A075ANATOLIAN HIEROGLYPH A076ANATOLIAN HIEROGLYPH A077ANATOLIAN HIE" +
	"ROGLYPH A078ANATOLIAN HIEROGLYPH A079ANATOLIAN HIEROGLYPH A080ANATOLIAN " +
	"HIEROGLYPH A081ANATOLIAN HIEROGLYPH A082ANATOLIAN HIEROGLYPH A083ANATOLI" +
	"AN HIEROGLYPH A084ANATOLIAN HIEROGLYPH A085ANATOLIAN HIEROGLYPH A086ANAT") + ("" +
	"OLIAN HIEROGLYPH A087ANATOLIAN HIEROGLYPH A088ANATOLIAN HIEROGLYPH A089A" +
	"NATOLIAN HIEROGLYPH A090ANATOLIAN HIEROGLYPH A091ANATOLIAN HIEROGLYPH A0" +
	"92ANATOLIAN HIEROGLYPH A093ANATOLIAN HIEROGLYPH A094ANATOLIAN HIEROGLYPH" +
	" A095ANATOLIAN HIEROGLYPH A096ANATOLIAN HIEROGLYPH A097ANATOLIAN HIEROGL" +
	"YPH A097AANATOLIAN HIEROGLYPH A098ANATOLIAN HIEROGLYPH A098AANATOLIAN HI" +
	"EROGLYPH A099ANATOLIAN HIEROGLYPH A100ANATOLIAN HIEROGLYPH A100AANATOLIA" +
	"N HIEROGLYPH A101ANATOLIAN HIEROGLYPH A101AANATOLIAN HIEROGLYPH A102ANAT" +
	"OLIAN HIEROGLYPH A102AANATOLIAN HIEROGLYPH A103ANATOLIAN HIEROGLYPH A104" +
	"ANATOLIAN HIEROGLYPH A104AANATOLIAN HIEROGLYPH A104BANATOLIAN HIEROGLYPH" +
	" A104CANATOLIAN HIEROGLYPH A105ANATOLIAN HIEROGLYPH A105AANATOLIAN HIERO" +
	"GLYPH A105BANATOLIAN HIEROGLYPH A106ANATOLIAN HIEROGLYPH A107ANATOLIAN H" +
	"IEROGLYPH A107AANATOLIAN HIEROGLYPH A107BANATOLIAN HIEROGLYPH A107CANATO" +
	"LIAN HIEROGLYPH A108ANATOLIAN HIEROGLYPH A109ANATOLIAN HIEROGLYPH A110AN" +
	"ATOLIAN HIEROGLYPH A110AANATOLIAN HIEROGLYPH A110BANATOLIAN HIEROGLYPH A" +
	"111ANATOLIAN HIEROGLYPH A112ANATOLIAN HIEROGLYPH A113ANATOLIAN HIEROGLYP" +
	"H A114ANATOLIAN HIEROGLYPH A115ANATOLIAN HIEROGLYPH A115AANATOLIAN HIERO" +
	"GLYPH A116ANATOLIAN HIEROGLYPH A117ANATOLIAN HIEROGLYPH A118ANATOLIAN HI" +
	"EROGLYPH A119ANATOLIAN HIEROGLYPH A120ANATOLIAN HIEROGLYPH A121ANATOLIAN" +
	" HIEROGLYPH A122ANATOLIAN HIEROGLYPH A123ANATOLIAN HIEROGLYPH A124ANATOL" +
	"IAN HIEROGLYPH A125ANATOLIAN HIEROGLYPH A125AANATOLIAN HIEROGLYPH A126AN" +
	"ATOLIAN HIEROGLYPH A127ANATOLIAN HIEROGLYPH A128ANATOLIAN HIEROGLYPH A12" +
	"9ANATOLIAN HIEROGLYPH A130ANATOLIAN HIEROGLYPH A131ANATOLIAN HIEROGLYPH " +
	"A132ANATOLIAN HIEROGLYPH A133ANATOLIAN HIEROGLYPH A134ANATOLIAN HIEROGLY" +
	"PH A135ANATOLIAN HIEROGLYPH A135AANATOLIAN HIEROGLYPH A136ANATOLIAN HIER" +
	"OGLYPH A137ANATOLIAN HIEROGLYPH A138ANATOLIAN HIEROGLYPH A139ANATOLIAN H" +
	"IEROGLYPH A140ANATOLIAN HIEROGLYPH A141ANATOLIAN HIEROGLYPH A142ANATOLIA" +
	"N HIEROGLYPH A143ANATOLIAN HIEROGLYPH A144ANATOLIAN HIEROGLYPH A145ANATO" +
	"LIAN HIEROGLYPH A146ANATOLIAN HIEROGLYPH A147ANATOLIAN HIEROGLYPH A148AN" +
	"ATOLIAN HIEROGLYPH A149ANATOLIAN HIEROGLYPH A150ANATOLIAN HIEROGLYPH A15" +
	"1ANATOLIAN HIEROGLYPH A152ANATOLIAN HIEROGLYPH A153ANATOLIAN HIEROGLYPH " +
	"A154ANATOLIAN HIEROGLYPH A155ANATOLIAN HIEROGLYPH A156ANATOLIAN HIEROGLY" +
	"PH A157ANATOLIAN HIEROGLYPH A158ANATOLIAN HIEROGLYPH A159ANATOLIAN HIERO" +
	"GLYPH A160ANATOLIAN HIEROGLYPH A161ANATOLIAN HIEROGLYPH A162ANATOLIAN HI" +
	"EROGLYPH A163ANATOLIAN HIEROGLYPH A164ANATOLIAN HIEROGLYPH A165ANATOLIAN" +
	" HIEROGLYPH A166ANATOLIAN HIEROGLYPH A167ANATOLIAN HIEROGLYPH A168ANATOL" +
	"IAN HIEROGLYPH A169ANATOLIAN HIEROGLYPH A170ANATOLIAN HIEROGLYPH A171ANA" +
	"TOLIAN HIEROGLYPH A172ANATOLIAN HIEROGLYPH A173ANATOLIAN HIEROGLYPH A174" +
	"ANATOLIAN HIEROGLYPH A175ANATOLIAN HIEROGLYPH A176ANATOLIAN HIEROGLYPH A" +
	"177ANATOLIAN HIEROGLYPH A178ANATOLIAN HIEROGLYPH A179ANATOLIAN HIEROGLYP" +
	"H A180ANATOLIAN HIEROGLYPH A181ANATOLIAN HIEROGLYPH A182ANATOLIAN HIEROG" +
	"LYPH A183ANATOLIAN HIEROGLYPH A184ANATOLIAN HIEROGLYPH A185ANATOLIAN HIE" +
	"ROGLYPH A186ANATOLIAN HIEROGLYPH A187ANATOLIAN HIEROGLYPH A188ANATOLIAN " +
	"HIEROGLYPH A189ANATOLIAN HIEROGLYPH A190ANATOLIAN HIEROGLYPH A191ANATOLI" +
	"AN HIEROGLYPH A192ANATOLIAN HIEROGLYPH A193ANATOLIAN HIEROGLYPH A194ANAT" +
	"OLIAN HIEROGLYPH A195ANATOLIAN HIEROGLYPH A196ANATOLIAN HIEROGLYPH A197A" +
	"NATOLIAN HIEROGLYPH A198ANATOLIAN HIEROGLYPH A199ANATOLIAN HIEROGLYPH A2" +
	"00ANATOLIAN HIEROGLYPH A201ANATOLIAN HIEROGLYPH A202ANATOLIAN HIEROGLYPH" +
	" A202AANATOLIAN HIEROGLYPH A202BANATOLIAN HIEROGLYPH A203ANATOLIAN HIERO" +
	"GLYPH A204ANATOLIAN HIEROGLYPH A205ANATOLIAN HIEROGLYPH A206ANATOLIAN HI" +
	"EROGLYPH A207ANATOLIAN HIEROGLYPH A207AANATOLIAN HIEROGLYPH A208ANATOLIA" +
	"N HIEROGLYPH A209ANATOLIAN HIEROGLYPH A209AANATOLIAN HIEROGLYPH A210ANAT" +
	"OLIAN HIEROGLYPH A211ANATOLIAN HIEROGLYPH A212ANATOLIAN HIEROGLYPH A213A" +
	"NATOLIAN HIEROGLYPH A214ANATOLIAN HIEROGLYPH A215ANATOLIAN HIEROGLYPH A2" +
	"15AANATOLIAN HIEROGLYPH A216ANATOLIAN HIEROGLYPH A216AANATOLIAN HIEROGLY" +
	"PH A217ANATOLIAN HIEROGLYPH A218ANATOLIAN HIEROGLYPH A219ANATOLIAN HIERO" +
	"GLYPH A220ANATOLIAN HIEROGLYPH A221ANATOLIAN HIEROGLYPH A222ANATOLIAN HI" +
	"EROGLYPH A223ANATOLIAN HIEROGLYPH A224ANATOLIAN HIEROGLYPH A225ANATOLIAN" +
	" HIEROGLYPH A226ANATOLIAN HIEROGLYPH A227ANATOLIAN HIEROGLYPH A227AANATO" +
	"LIAN HIEROGLYPH A228ANATOLIAN HIEROGLYPH A229ANATOLIAN HIEROGLYPH A230AN" +
	"ATOLIAN HIEROGLYPH A231ANATOLIAN HIEROGLYPH A232ANATOLIAN HIEROGLYPH A23" +
	"3ANATOLIAN HIEROGLYPH A234ANATOLIAN HIEROGLYPH A235ANATOLIAN HIEROGLYPH " +
	"A236ANATOLIAN HIEROGLYPH A237ANATOLIAN HIEROGLYPH A238ANATOLIAN HIEROGLY" +
	"PH A239ANATOLIAN HIEROGLYPH A240ANATOLIAN HIEROGLYPH A241ANATOLIAN HIERO" +
	"GLYPH A242ANATOLIAN HIEROGLYPH A243ANATOLIAN HIEROGLYPH A244ANATOLIAN HI") + ("" +
	"EROGLYPH A245ANATOLIAN HIEROGLYPH A246ANATOLIAN HIEROGLYPH A247ANATOLIAN" +
	" HIEROGLYPH A248ANATOLIAN HIEROGLYPH A249ANATOLIAN HIEROGLYPH A250ANATOL" +
	"IAN HIEROGLYPH A251ANATOLIAN HIEROGLYPH A252ANATOLIAN HIEROGLYPH A253ANA" +
	"TOLIAN HIEROGLYPH A254ANATOLIAN HIEROGLYPH A255ANATOLIAN HIEROGLYPH A256" +
	"ANATOLIAN HIEROGLYPH A257ANATOLIAN HIEROGLYPH A258ANATOLIAN HIEROGLYPH A" +
	"259ANATOLIAN HIEROGLYPH A260ANATOLIAN HIEROGLYPH A261ANATOLIAN HIEROGLYP" +
	"H A262ANATOLIAN HIEROGLYPH A263ANATOLIAN HIEROGLYPH A264ANATOLIAN HIEROG" +
	"LYPH A265ANATOLIAN HIEROGLYPH A266ANATOLIAN HIEROGLYPH A267ANATOLIAN HIE" +
	"ROGLYPH A267AANATOLIAN HIEROGLYPH A268ANATOLIAN HIEROGLYPH A269ANATOLIAN" +
	" HIEROGLYPH A270ANATOLIAN HIEROGLYPH A271ANATOLIAN HIEROGLYPH A272ANATOL" +
	"IAN HIEROGLYPH A273ANATOLIAN HIEROGLYPH A274ANATOLIAN HIEROGLYPH A275ANA" +
	"TOLIAN HIEROGLYPH A276ANATOLIAN HIEROGLYPH A277ANATOLIAN HIEROGLYPH A278" +
	"ANATOLIAN HIEROGLYPH A279ANATOLIAN HIEROGLYPH A280ANATOLIAN HIEROGLYPH A" +
	"281ANATOLIAN HIEROGLYPH A282ANATOLIAN HIEROGLYPH A283ANATOLIAN HIEROGLYP" +
	"H A284ANATOLIAN HIEROGLYPH A285ANATOLIAN HIEROGLYPH A286ANATOLIAN HIEROG" +
	"LYPH A287ANATOLIAN HIEROGLYPH A288ANATOLIAN HIEROGLYPH A289ANATOLIAN HIE" +
	"ROGLYPH A289AANATOLIAN HIEROGLYPH A290ANATOLIAN HIEROGLYPH A291ANATOLIAN" +
	" HIEROGLYPH A292ANATOLIAN HIEROGLYPH A293ANATOLIAN HIEROGLYPH A294ANATOL" +
	"IAN HIEROGLYPH A294AANATOLIAN HIEROGLYPH A295ANATOLIAN HIEROGLYPH A296AN" +
	"ATOLIAN HIEROGLYPH A297ANATOLIAN HIEROGLYPH A298ANATOLIAN HIEROGLYPH A29" +
	"9ANATOLIAN HIEROGLYPH A299AANATOLIAN HIEROGLYPH A300ANATOLIAN HIEROGLYPH" +
	" A301ANATOLIAN HIEROGLYPH A302ANATOLIAN HIEROGLYPH A303ANATOLIAN HIEROGL" +
	"YPH A304ANATOLIAN HIEROGLYPH A305ANATOLIAN HIEROGLYPH A306ANATOLIAN HIER" +
	"OGLYPH A307ANATOLIAN HIEROGLYPH A308ANATOLIAN HIEROGLYPH A309ANATOLIAN H" +
	"IEROGLYPH A309AANATOLIAN HIEROGLYPH A310ANATOLIAN HIEROGLYPH A311ANATOLI" +
	"AN HIEROGLYPH A312ANATOLIAN HIEROGLYPH A313ANATOLIAN HIEROGLYPH A314ANAT" +
	"OLIAN HIEROGLYPH A315ANATOLIAN HIEROGLYPH A316ANATOLIAN HIEROGLYPH A317A" +
	"NATOLIAN HIEROGLYPH A318ANATOLIAN HIEROGLYPH A319ANATOLIAN HIEROGLYPH A3" +
	"20ANATOLIAN HIEROGLYPH A321ANATOLIAN HIEROGLYPH A322ANATOLIAN HIEROGLYPH" +
	" A323ANATOLIAN HIEROGLYPH A324ANATOLIAN HIEROGLYPH A325ANATOLIAN HIEROGL" +
	"YPH A326ANATOLIAN HIEROGLYPH A327ANATOLIAN HIEROGLYPH A328ANATOLIAN HIER" +
	"OGLYPH A329ANATOLIAN HIEROGLYPH A329AANATOLIAN HIEROGLYPH A330ANATOLIAN " +
	"HIEROGLYPH A331ANATOLIAN HIEROGLYPH A332AANATOLIAN HIEROGLYPH A332BANATO" +
	"LIAN HIEROGLYPH A332CANATOLIAN HIEROGLYPH A333ANATOLIAN HIEROGLYPH A334A" +
	"NATOLIAN HIEROGLYPH A335ANATOLIAN HIEROGLYPH A336ANATOLIAN HIEROGLYPH A3" +
	"36AANATOLIAN HIEROGLYPH A336BANATOLIAN HIEROGLYPH A336CANATOLIAN HIEROGL" +
	"YPH A337ANATOLIAN HIEROGLYPH A338ANATOLIAN HIEROGLYPH A339ANATOLIAN HIER" +
	"OGLYPH A340ANATOLIAN HIEROGLYPH A341ANATOLIAN HIEROGLYPH A342ANATOLIAN H" +
	"IEROGLYPH A343ANATOLIAN HIEROGLYPH A344ANATOLIAN HIEROGLYPH A345ANATOLIA" +
	"N HIEROGLYPH A346ANATOLIAN HIEROGLYPH A347ANATOLIAN HIEROGLYPH A348ANATO" +
	"LIAN HIEROGLYPH A349ANATOLIAN HIEROGLYPH A350ANATOLIAN HIEROGLYPH A351AN" +
	"ATOLIAN HIEROGLYPH A352ANATOLIAN HIEROGLYPH A353ANATOLIAN HIEROGLYPH A35" +
	"4ANATOLIAN HIEROGLYPH A355ANATOLIAN HIEROGLYPH A356ANATOLIAN HIEROGLYPH " +
	"A357ANATOLIAN HIEROGLYPH A358ANATOLIAN HIEROGLYPH A359ANATOLIAN HIEROGLY" +
	"PH A359AANATOLIAN HIEROGLYPH A360ANATOLIAN HIEROGLYPH A361ANATOLIAN HIER" +
	"OGLYPH A362ANATOLIAN HIEROGLYPH A363ANATOLIAN HIEROGLYPH A364ANATOLIAN H" +
	"IEROGLYPH A364AANATOLIAN HIEROGLYPH A365ANATOLIAN HIEROGLYPH A366ANATOLI" +
	"AN HIEROGLYPH A367ANATOLIAN HIEROGLYPH A368ANATOLIAN HIEROGLYPH A368AANA" +
	"TOLIAN HIEROGLYPH A369ANATOLIAN HIEROGLYPH A370ANATOLIAN HIEROGLYPH A371" +
	"ANATOLIAN HIEROGLYPH A371AANATOLIAN HIEROGLYPH A372ANATOLIAN HIEROGLYPH " +
	"A373ANATOLIAN HIEROGLYPH A374ANATOLIAN HIEROGLYPH A375ANATOLIAN HIEROGLY" +
	"PH A376ANATOLIAN HIEROGLYPH A377ANATOLIAN HIEROGLYPH A378ANATOLIAN HIERO" +
	"GLYPH A379ANATOLIAN HIEROGLYPH A380ANATOLIAN HIEROGLYPH A381ANATOLIAN HI" +
	"EROGLYPH A381AANATOLIAN HIEROGLYPH A382ANATOLIAN HIEROGLYPH A383 RA OR R" +
	"IANATOLIAN HIEROGLYPH A383AANATOLIAN HIEROGLYPH A384ANATOLIAN HIEROGLYPH" +
	" A385ANATOLIAN HIEROGLYPH A386ANATOLIAN HIEROGLYPH A386AANATOLIAN HIEROG" +
	"LYPH A387ANATOLIAN HIEROGLYPH A388ANATOLIAN HIEROGLYPH A389ANATOLIAN HIE" +
	"ROGLYPH A390ANATOLIAN HIEROGLYPH A391ANATOLIAN HIEROGLYPH A392ANATOLIAN " +
	"HIEROGLYPH A393 EIGHTANATOLIAN HIEROGLYPH A394ANATOLIAN HIEROGLYPH A395A" +
	"NATOLIAN HIEROGLYPH A396ANATOLIAN HIEROGLYPH A397ANATOLIAN HIEROGLYPH A3" +
	"98ANATOLIAN HIEROGLYPH A399ANATOLIAN HIEROGLYPH A400ANATOLIAN HIEROGLYPH" +
	" A401ANATOLIAN HIEROGLYPH A402ANATOLIAN HIEROGLYPH A403ANATOLIAN HIEROGL" +
	"YPH A404ANATOLIAN HIEROGLYPH A405ANATOLIAN HIEROGLYPH A406ANATOLIAN HIER" +
	"OGLYPH A407ANATOLIAN HIEROGLYPH A408ANATOLIAN HIEROGLYPH A409ANATOLIAN H") + ("" +
	"IEROGLYPH A410 BEGIN LOGOGRAM MARKANATOLIAN HIEROGLYPH A410A END LOGOGRA" +
	"M MARKANATOLIAN HIEROGLYPH A411ANATOLIAN HIEROGLYPH A412ANATOLIAN HIEROG" +
	"LYPH A413ANATOLIAN HIEROGLYPH A414ANATOLIAN HIEROGLYPH A415ANATOLIAN HIE" +
	"ROGLYPH A416ANATOLIAN HIEROGLYPH A417ANATOLIAN HIEROGLYPH A418ANATOLIAN " +
	"HIEROGLYPH A419ANATOLIAN HIEROGLYPH A420ANATOLIAN HIEROGLYPH A421ANATOLI" +
	"AN HIEROGLYPH A422ANATOLIAN HIEROGLYPH A423ANATOLIAN HIEROGLYPH A424ANAT" +
	"OLIAN HIEROGLYPH A425ANATOLIAN HIEROGLYPH A426ANATOLIAN HIEROGLYPH A427A" +
	"NATOLIAN HIEROGLYPH A428ANATOLIAN HIEROGLYPH A429ANATOLIAN HIEROGLYPH A4" +
	"30ANATOLIAN HIEROGLYPH A431ANATOLIAN HIEROGLYPH A432ANATOLIAN HIEROGLYPH" +
	" A433ANATOLIAN HIEROGLYPH A434ANATOLIAN HIEROGLYPH A435ANATOLIAN HIEROGL" +
	"YPH A436ANATOLIAN HIEROGLYPH A437ANATOLIAN HIEROGLYPH A438ANATOLIAN HIER" +
	"OGLYPH A439ANATOLIAN HIEROGLYPH A440ANATOLIAN HIEROGLYPH A441ANATOLIAN H" +
	"IEROGLYPH A442ANATOLIAN HIEROGLYPH A443ANATOLIAN HIEROGLYPH A444ANATOLIA" +
	"N HIEROGLYPH A445ANATOLIAN HIEROGLYPH A446ANATOLIAN HIEROGLYPH A447ANATO" +
	"LIAN HIEROGLYPH A448ANATOLIAN HIEROGLYPH A449ANATOLIAN HIEROGLYPH A450AN" +
	"ATOLIAN HIEROGLYPH A450AANATOLIAN HIEROGLYPH A451ANATOLIAN HIEROGLYPH A4" +
	"52ANATOLIAN HIEROGLYPH A453ANATOLIAN HIEROGLYPH A454ANATOLIAN HIEROGLYPH" +
	" A455ANATOLIAN HIEROGLYPH A456ANATOLIAN HIEROGLYPH A457ANATOLIAN HIEROGL" +
	"YPH A457AANATOLIAN HIEROGLYPH A458ANATOLIAN HIEROGLYPH A459ANATOLIAN HIE" +
	"ROGLYPH A460ANATOLIAN HIEROGLYPH A461ANATOLIAN HIEROGLYPH A462ANATOLIAN " +
	"HIEROGLYPH A463ANATOLIAN HIEROGLYPH A464ANATOLIAN HIEROGLYPH A465ANATOLI" +
	"AN HIEROGLYPH A466ANATOLIAN HIEROGLYPH A467ANATOLIAN HIEROGLYPH A468ANAT" +
	"OLIAN HIEROGLYPH A469ANATOLIAN HIEROGLYPH A470ANATOLIAN HIEROGLYPH A471A" +
	"NATOLIAN HIEROGLYPH A472ANATOLIAN HIEROGLYPH A473ANATOLIAN HIEROGLYPH A4" +
	"74ANATOLIAN HIEROGLYPH A475ANATOLIAN HIEROGLYPH A476ANATOLIAN HIEROGLYPH" +
	" A477ANATOLIAN HIEROGLYPH A478ANATOLIAN HIEROGLYPH A479ANATOLIAN HIEROGL" +
	"YPH A480ANATOLIAN HIEROGLYPH A481ANATOLIAN HIEROGLYPH A482ANATOLIAN HIER" +
	"OGLYPH A483ANATOLIAN HIEROGLYPH A484ANATOLIAN HIEROGLYPH A485ANATOLIAN H" +
	"IEROGLYPH A486ANATOLIAN HIEROGLYPH A487ANATOLIAN HIEROGLYPH A488ANATOLIA" +
	"N HIEROGLYPH A489ANATOLIAN HIEROGLYPH A490ANATOLIAN HIEROGLYPH A491ANATO" +
	"LIAN HIEROGLYPH A492ANATOLIAN HIEROGLYPH A493ANATOLIAN HIEROGLYPH A494AN" +
	"ATOLIAN HIEROGLYPH A495ANATOLIAN HIEROGLYPH A496ANATOLIAN HIEROGLYPH A49" +
	"7ANATOLIAN HIEROGLYPH A501ANATOLIAN HIEROGLYPH A502ANATOLIAN HIEROGLYPH " +
	"A503ANATOLIAN HIEROGLYPH A504ANATOLIAN HIEROGLYPH A505ANATOLIAN HIEROGLY" +
	"PH A506ANATOLIAN HIEROGLYPH A507ANATOLIAN HIEROGLYPH A508ANATOLIAN HIERO" +
	"GLYPH A509ANATOLIAN HIEROGLYPH A510ANATOLIAN HIEROGLYPH A511ANATOLIAN HI" +
	"EROGLYPH A512ANATOLIAN HIEROGLYPH A513ANATOLIAN HIEROGLYPH A514ANATOLIAN" +
	" HIEROGLYPH A515ANATOLIAN HIEROGLYPH A516ANATOLIAN HIEROGLYPH A517ANATOL" +
	"IAN HIEROGLYPH A518ANATOLIAN HIEROGLYPH A519ANATOLIAN HIEROGLYPH A520ANA" +
	"TOLIAN HIEROGLYPH A521ANATOLIAN HIEROGLYPH A522ANATOLIAN HIEROGLYPH A523" +
	"ANATOLIAN HIEROGLYPH A524ANATOLIAN HIEROGLYPH A525ANATOLIAN HIEROGLYPH A" +
	"526ANATOLIAN HIEROGLYPH A527ANATOLIAN HIEROGLYPH A528ANATOLIAN HIEROGLYP" +
	"H A529ANATOLIAN HIEROGLYPH A530BAMUM LETTER PHASE-A NGKUE MFONBAMUM LETT" +
	"ER PHASE-A GBIEE FONBAMUM LETTER PHASE-A PON MFON PIPAEMGBIEEBAMUM LETTE" +
	"R PHASE-A PON MFON PIPAEMBABAMUM LETTER PHASE-A NAA MFONBAMUM LETTER PHA" +
	"SE-A SHUENSHUETBAMUM LETTER PHASE-A TITA MFONBAMUM LETTER PHASE-A NZA MF" +
	"ONBAMUM LETTER PHASE-A SHINDA PA NJIBAMUM LETTER PHASE-A PON PA NJI PIPA" +
	"EMGBIEEBAMUM LETTER PHASE-A PON PA NJI PIPAEMBABAMUM LETTER PHASE-A MAEM" +
	"BGBIEEBAMUM LETTER PHASE-A TU MAEMBABAMUM LETTER PHASE-A NGANGUBAMUM LET" +
	"TER PHASE-A MAEMVEUXBAMUM LETTER PHASE-A MANSUAEBAMUM LETTER PHASE-A MVE" +
	"UAENGAMBAMUM LETTER PHASE-A SEUNYAMBAMUM LETTER PHASE-A NTOQPENBAMUM LET" +
	"TER PHASE-A KEUKEUTNDABAMUM LETTER PHASE-A NKINDIBAMUM LETTER PHASE-A SU" +
	"UBAMUM LETTER PHASE-A NGKUENZEUMBAMUM LETTER PHASE-A LAPAQBAMUM LETTER P" +
	"HASE-A LET KUTBAMUM LETTER PHASE-A NTAP MFAABAMUM LETTER PHASE-A MAEKEUP" +
	"BAMUM LETTER PHASE-A PASHAEBAMUM LETTER PHASE-A GHEUAERAEBAMUM LETTER PH" +
	"ASE-A PAMSHAEBAMUM LETTER PHASE-A MON NGGEUAETBAMUM LETTER PHASE-A NZUN " +
	"MEUTBAMUM LETTER PHASE-A U YUQ NAEBAMUM LETTER PHASE-A GHEUAEGHEUAEBAMUM" +
	" LETTER PHASE-A NTAP NTAABAMUM LETTER PHASE-A SISABAMUM LETTER PHASE-A M" +
	"GBASABAMUM LETTER PHASE-A MEUNJOMNDEUQBAMUM LETTER PHASE-A MOOMPUQBAMUM " +
	"LETTER PHASE-A KAFABAMUM LETTER PHASE-A PA LEERAEWABAMUM LETTER PHASE-A " +
	"NDA LEERAEWABAMUM LETTER PHASE-A PETBAMUM LETTER PHASE-A MAEMKPENBAMUM L" +
	"ETTER PHASE-A NIKABAMUM LETTER PHASE-A PUPBAMUM LETTER PHASE-A TUAEPBAMU" +
	"M LETTER PHASE-A LUAEPBAMUM LETTER PHASE-A SONJAMBAMUM LETTER PHASE-A TE" +
	"UTEUWENBAMUM LETTER PHASE-A MAENYIBAMUM LETTER PHASE-A KETBAMUM LETTER P") + ("" +
	"HASE-A NDAANGGEUAETBAMUM LETTER PHASE-A KUOQBAMUM LETTER PHASE-A MOOMEUT" +
	"BAMUM LETTER PHASE-A SHUMBAMUM LETTER PHASE-A LOMMAEBAMUM LETTER PHASE-A" +
	" FIRIBAMUM LETTER PHASE-A ROMBAMUM LETTER PHASE-A KPOQBAMUM LETTER PHASE" +
	"-A SOQBAMUM LETTER PHASE-A MAP PIEETBAMUM LETTER PHASE-A SHIRAEBAMUM LET" +
	"TER PHASE-A NTAPBAMUM LETTER PHASE-A SHOQ NSHUT YUMBAMUM LETTER PHASE-A " +
	"NYIT MONGKEUAEQBAMUM LETTER PHASE-A PAARAEBAMUM LETTER PHASE-A NKAARAEBA" +
	"MUM LETTER PHASE-A UNKNOWNBAMUM LETTER PHASE-A NGGENBAMUM LETTER PHASE-A" +
	" MAESIBAMUM LETTER PHASE-A NJAMBAMUM LETTER PHASE-A MBANYIBAMUM LETTER P" +
	"HASE-A NYETBAMUM LETTER PHASE-A TEUAENBAMUM LETTER PHASE-A SOTBAMUM LETT" +
	"ER PHASE-A PAAMBAMUM LETTER PHASE-A NSHIEEBAMUM LETTER PHASE-A MAEMBAMUM" +
	" LETTER PHASE-A NYIBAMUM LETTER PHASE-A KAQBAMUM LETTER PHASE-A NSHABAMU" +
	"M LETTER PHASE-A VEEBAMUM LETTER PHASE-A LUBAMUM LETTER PHASE-A NENBAMUM" +
	" LETTER PHASE-A NAQBAMUM LETTER PHASE-A MBAQBAMUM LETTER PHASE-B NSHUETB" +
	"AMUM LETTER PHASE-B TU MAEMGBIEEBAMUM LETTER PHASE-B SIEEBAMUM LETTER PH" +
	"ASE-B SET TUBAMUM LETTER PHASE-B LOM NTEUMBAMUM LETTER PHASE-B MBA MAELE" +
	"EBAMUM LETTER PHASE-B KIEEMBAMUM LETTER PHASE-B YEURAEBAMUM LETTER PHASE" +
	"-B MBAARAEBAMUM LETTER PHASE-B KAMBAMUM LETTER PHASE-B PEESHIBAMUM LETTE" +
	"R PHASE-B YAFU LEERAEWABAMUM LETTER PHASE-B LAM NSHUT NYAMBAMUM LETTER P" +
	"HASE-B NTIEE SHEUOQBAMUM LETTER PHASE-B NDU NJAABAMUM LETTER PHASE-B GHE" +
	"UGHEUAEMBAMUM LETTER PHASE-B PITBAMUM LETTER PHASE-B TU NSIEEBAMUM LETTE" +
	"R PHASE-B SHET NJAQBAMUM LETTER PHASE-B SHEUAEQTUBAMUM LETTER PHASE-B MF" +
	"ON TEUAEQBAMUM LETTER PHASE-B MBIT MBAAKETBAMUM LETTER PHASE-B NYI NTEUM" +
	"BAMUM LETTER PHASE-B KEUPUQBAMUM LETTER PHASE-B GHEUGHENBAMUM LETTER PHA" +
	"SE-B KEUYEUXBAMUM LETTER PHASE-B LAANAEBAMUM LETTER PHASE-B PARUMBAMUM L" +
	"ETTER PHASE-B VEUMBAMUM LETTER PHASE-B NGKINDI MVOPBAMUM LETTER PHASE-B " +
	"NGGEU MBUBAMUM LETTER PHASE-B WUAETBAMUM LETTER PHASE-B SAKEUAEBAMUM LET" +
	"TER PHASE-B TAAMBAMUM LETTER PHASE-B MEUQBAMUM LETTER PHASE-B NGGUOQBAMU" +
	"M LETTER PHASE-B NGGUOQ LARGEBAMUM LETTER PHASE-B MFIYAQBAMUM LETTER PHA" +
	"SE-B SUEBAMUM LETTER PHASE-B MBEURIBAMUM LETTER PHASE-B MONTIEENBAMUM LE" +
	"TTER PHASE-B NYAEMAEBAMUM LETTER PHASE-B PUNGAAMBAMUM LETTER PHASE-B MEU" +
	"T NGGEETBAMUM LETTER PHASE-B FEUXBAMUM LETTER PHASE-B MBUOQBAMUM LETTER " +
	"PHASE-B FEEBAMUM LETTER PHASE-B KEUAEMBAMUM LETTER PHASE-B MA NJEUAENABA" +
	"MUM LETTER PHASE-B MA NJUQABAMUM LETTER PHASE-B LETBAMUM LETTER PHASE-B " +
	"NGGAAMBAMUM LETTER PHASE-B NSENBAMUM LETTER PHASE-B MABAMUM LETTER PHASE" +
	"-B KIQBAMUM LETTER PHASE-B NGOMBAMUM LETTER PHASE-C NGKUE MAEMBABAMUM LE" +
	"TTER PHASE-C NZABAMUM LETTER PHASE-C YUMBAMUM LETTER PHASE-C WANGKUOQBAM" +
	"UM LETTER PHASE-C NGGENBAMUM LETTER PHASE-C NDEUAEREEBAMUM LETTER PHASE-" +
	"C NGKAQBAMUM LETTER PHASE-C GHARAEBAMUM LETTER PHASE-C MBEEKEETBAMUM LET" +
	"TER PHASE-C GBAYIBAMUM LETTER PHASE-C NYIR MKPARAQ MEUNBAMUM LETTER PHAS" +
	"E-C NTU MBITBAMUM LETTER PHASE-C MBEUMBAMUM LETTER PHASE-C PIRIEENBAMUM " +
	"LETTER PHASE-C NDOMBUBAMUM LETTER PHASE-C MBAA CABBAGE-TREEBAMUM LETTER " +
	"PHASE-C KEUSHEUAEPBAMUM LETTER PHASE-C GHAPBAMUM LETTER PHASE-C KEUKAQBA" +
	"MUM LETTER PHASE-C YU MUOMAEBAMUM LETTER PHASE-C NZEUMBAMUM LETTER PHASE" +
	"-C MBUEBAMUM LETTER PHASE-C NSEUAENBAMUM LETTER PHASE-C MBITBAMUM LETTER" +
	" PHASE-C YEUQBAMUM LETTER PHASE-C KPARAQBAMUM LETTER PHASE-C KAABAMUM LE" +
	"TTER PHASE-C SEUXBAMUM LETTER PHASE-C NDIDABAMUM LETTER PHASE-C TAASHAEB" +
	"AMUM LETTER PHASE-C NJUEQBAMUM LETTER PHASE-C TITA YUEBAMUM LETTER PHASE" +
	"-C SUAETBAMUM LETTER PHASE-C NGGUAEN NYAMBAMUM LETTER PHASE-C VEUXBAMUM " +
	"LETTER PHASE-C NANSANAQBAMUM LETTER PHASE-C MA KEUAERIBAMUM LETTER PHASE" +
	"-C NTAABAMUM LETTER PHASE-C NGGUONBAMUM LETTER PHASE-C LAPBAMUM LETTER P" +
	"HASE-C MBIRIEENBAMUM LETTER PHASE-C MGBASAQBAMUM LETTER PHASE-C NTEUNGBA" +
	"BAMUM LETTER PHASE-C TEUTEUXBAMUM LETTER PHASE-C NGGUMBAMUM LETTER PHASE" +
	"-C FUEBAMUM LETTER PHASE-C NDEUTBAMUM LETTER PHASE-C NSABAMUM LETTER PHA" +
	"SE-C NSHAQBAMUM LETTER PHASE-C BUNGBAMUM LETTER PHASE-C VEUAEPENBAMUM LE" +
	"TTER PHASE-C MBERAEBAMUM LETTER PHASE-C RUBAMUM LETTER PHASE-C NJAEMBAMU" +
	"M LETTER PHASE-C LAMBAMUM LETTER PHASE-C TITUAEPBAMUM LETTER PHASE-C NSU" +
	"OT NGOMBAMUM LETTER PHASE-C NJEEEEBAMUM LETTER PHASE-C KETBAMUM LETTER P" +
	"HASE-C NGGUBAMUM LETTER PHASE-C MAESIBAMUM LETTER PHASE-C MBUAEMBAMUM LE" +
	"TTER PHASE-C LUBAMUM LETTER PHASE-C KUTBAMUM LETTER PHASE-C NJAMBAMUM LE" +
	"TTER PHASE-C NGOMBAMUM LETTER PHASE-C WUPBAMUM LETTER PHASE-C NGGUEETBAM" +
	"UM LETTER PHASE-C NSOMBAMUM LETTER PHASE-C NTENBAMUM LETTER PHASE-C KUOP" +
	" NKAARAEBAMUM LETTER PHASE-C NSUNBAMUM LETTER PHASE-C NDAMBAMUM LETTER P" +
	"HASE-C MA NSIEEBAMUM LETTER PHASE-C YAABAMUM LETTER PHASE-C NDAPBAMUM LE" +
	"TTER PHASE-C SHUEQBAMUM LETTER PHASE-C SETFONBAMUM LETTER PHASE-C MBIBAM") + ("" +
	"UM LETTER PHASE-C MAEMBABAMUM LETTER PHASE-C MBANYIBAMUM LETTER PHASE-C " +
	"KEUSEUXBAMUM LETTER PHASE-C MBEUXBAMUM LETTER PHASE-C KEUMBAMUM LETTER P" +
	"HASE-C MBAA PICKETBAMUM LETTER PHASE-C YUWOQBAMUM LETTER PHASE-C NJEUXBA" +
	"MUM LETTER PHASE-C MIEEBAMUM LETTER PHASE-C MUAEBAMUM LETTER PHASE-C SHI" +
	"QBAMUM LETTER PHASE-C KEN LAWBAMUM LETTER PHASE-C KEN FATIGUEBAMUM LETTE" +
	"R PHASE-C NGAQBAMUM LETTER PHASE-C NAQBAMUM LETTER PHASE-C LIQBAMUM LETT" +
	"ER PHASE-C PINBAMUM LETTER PHASE-C PENBAMUM LETTER PHASE-C TETBAMUM LETT" +
	"ER PHASE-D MBUOBAMUM LETTER PHASE-D WAPBAMUM LETTER PHASE-D NJIBAMUM LET" +
	"TER PHASE-D MFONBAMUM LETTER PHASE-D NJIEEBAMUM LETTER PHASE-D LIEEBAMUM" +
	" LETTER PHASE-D NJEUTBAMUM LETTER PHASE-D NSHEEBAMUM LETTER PHASE-D NGGA" +
	"AMAEBAMUM LETTER PHASE-D NYAMBAMUM LETTER PHASE-D WUAENBAMUM LETTER PHAS" +
	"E-D NGKUNBAMUM LETTER PHASE-D SHEEBAMUM LETTER PHASE-D NGKAPBAMUM LETTER" +
	" PHASE-D KEUAETMEUNBAMUM LETTER PHASE-D TEUTBAMUM LETTER PHASE-D SHEUAEB" +
	"AMUM LETTER PHASE-D NJAPBAMUM LETTER PHASE-D SUEBAMUM LETTER PHASE-D KET" +
	"BAMUM LETTER PHASE-D YAEMMAEBAMUM LETTER PHASE-D KUOMBAMUM LETTER PHASE-" +
	"D SAPBAMUM LETTER PHASE-D MFEUTBAMUM LETTER PHASE-D NDEUXBAMUM LETTER PH" +
	"ASE-D MALEERIBAMUM LETTER PHASE-D MEUTBAMUM LETTER PHASE-D SEUAEQBAMUM L" +
	"ETTER PHASE-D YENBAMUM LETTER PHASE-D NJEUAEMBAMUM LETTER PHASE-D KEUOT " +
	"MBUAEBAMUM LETTER PHASE-D NGKEURIBAMUM LETTER PHASE-D TUBAMUM LETTER PHA" +
	"SE-D GHAABAMUM LETTER PHASE-D NGKYEEBAMUM LETTER PHASE-D FEUFEUAETBAMUM " +
	"LETTER PHASE-D NDEEBAMUM LETTER PHASE-D MGBOFUMBAMUM LETTER PHASE-D LEUA" +
	"EPBAMUM LETTER PHASE-D NDONBAMUM LETTER PHASE-D MONIBAMUM LETTER PHASE-D" +
	" MGBEUNBAMUM LETTER PHASE-D PUUTBAMUM LETTER PHASE-D MGBIEEBAMUM LETTER " +
	"PHASE-D MFOBAMUM LETTER PHASE-D LUMBAMUM LETTER PHASE-D NSIEEPBAMUM LETT" +
	"ER PHASE-D MBAABAMUM LETTER PHASE-D KWAETBAMUM LETTER PHASE-D NYETBAMUM " +
	"LETTER PHASE-D TEUAENBAMUM LETTER PHASE-D SOTBAMUM LETTER PHASE-D YUWOQB" +
	"AMUM LETTER PHASE-D KEUMBAMUM LETTER PHASE-D RAEMBAMUM LETTER PHASE-D TE" +
	"EEEBAMUM LETTER PHASE-D NGKEUAEQBAMUM LETTER PHASE-D MFEUAEBAMUM LETTER " +
	"PHASE-D NSIEETBAMUM LETTER PHASE-D KEUPBAMUM LETTER PHASE-D PIPBAMUM LET" +
	"TER PHASE-D PEUTAEBAMUM LETTER PHASE-D NYUEBAMUM LETTER PHASE-D LETBAMUM" +
	" LETTER PHASE-D NGGAAMBAMUM LETTER PHASE-D MFIEEBAMUM LETTER PHASE-D NGG" +
	"WAENBAMUM LETTER PHASE-D YUOMBAMUM LETTER PHASE-D PAPBAMUM LETTER PHASE-" +
	"D YUOPBAMUM LETTER PHASE-D NDAMBAMUM LETTER PHASE-D NTEUMBAMUM LETTER PH" +
	"ASE-D SUAEBAMUM LETTER PHASE-D KUNBAMUM LETTER PHASE-D NGGEUXBAMUM LETTE" +
	"R PHASE-D NGKIEEBAMUM LETTER PHASE-D TUOTBAMUM LETTER PHASE-D MEUNBAMUM " +
	"LETTER PHASE-D KUQBAMUM LETTER PHASE-D NSUMBAMUM LETTER PHASE-D TEUNBAMU" +
	"M LETTER PHASE-D MAENJETBAMUM LETTER PHASE-D NGGAPBAMUM LETTER PHASE-D L" +
	"EUMBAMUM LETTER PHASE-D NGGUOMBAMUM LETTER PHASE-D NSHUTBAMUM LETTER PHA" +
	"SE-D NJUEQBAMUM LETTER PHASE-D GHEUAEBAMUM LETTER PHASE-D KUBAMUM LETTER" +
	" PHASE-D REN OLDBAMUM LETTER PHASE-D TAEBAMUM LETTER PHASE-D TOQBAMUM LE" +
	"TTER PHASE-D NYIBAMUM LETTER PHASE-D RIIBAMUM LETTER PHASE-D LEEEEBAMUM " +
	"LETTER PHASE-D MEEEEBAMUM LETTER PHASE-D MBAMUM LETTER PHASE-D SUUBAMUM " +
	"LETTER PHASE-D MUBAMUM LETTER PHASE-D SHIIBAMUM LETTER PHASE-D SHEUXBAMU" +
	"M LETTER PHASE-D KYEEBAMUM LETTER PHASE-D NUBAMUM LETTER PHASE-D SHUBAMU" +
	"M LETTER PHASE-D NTEEBAMUM LETTER PHASE-D PEEBAMUM LETTER PHASE-D NIBAMU" +
	"M LETTER PHASE-D SHOQBAMUM LETTER PHASE-D PUQBAMUM LETTER PHASE-D MVOPBA" +
	"MUM LETTER PHASE-D LOQBAMUM LETTER PHASE-D REN MUCHBAMUM LETTER PHASE-D " +
	"TIBAMUM LETTER PHASE-D NTUUBAMUM LETTER PHASE-D MBAA SEVENBAMUM LETTER P" +
	"HASE-D SAQBAMUM LETTER PHASE-D FAABAMUM LETTER PHASE-E NDAPBAMUM LETTER " +
	"PHASE-E TOONBAMUM LETTER PHASE-E MBEUMBAMUM LETTER PHASE-E LAPBAMUM LETT" +
	"ER PHASE-E VOMBAMUM LETTER PHASE-E LOONBAMUM LETTER PHASE-E PAABAMUM LET" +
	"TER PHASE-E SOMBAMUM LETTER PHASE-E RAQBAMUM LETTER PHASE-E NSHUOPBAMUM " +
	"LETTER PHASE-E NDUNBAMUM LETTER PHASE-E PUAEBAMUM LETTER PHASE-E TAMBAMU" +
	"M LETTER PHASE-E NGKABAMUM LETTER PHASE-E KPEUXBAMUM LETTER PHASE-E WUOB" +
	"AMUM LETTER PHASE-E SEEBAMUM LETTER PHASE-E NGGEUAETBAMUM LETTER PHASE-E" +
	" PAAMBAMUM LETTER PHASE-E TOOBAMUM LETTER PHASE-E KUOPBAMUM LETTER PHASE" +
	"-E LOMBAMUM LETTER PHASE-E NSHIEEBAMUM LETTER PHASE-E NGOPBAMUM LETTER P" +
	"HASE-E MAEMBAMUM LETTER PHASE-E NGKEUXBAMUM LETTER PHASE-E NGOQBAMUM LET" +
	"TER PHASE-E NSHUEBAMUM LETTER PHASE-E RIMGBABAMUM LETTER PHASE-E NJEUXBA" +
	"MUM LETTER PHASE-E PEEMBAMUM LETTER PHASE-E SAABAMUM LETTER PHASE-E NGGU" +
	"RAEBAMUM LETTER PHASE-E MGBABAMUM LETTER PHASE-E GHEUXBAMUM LETTER PHASE" +
	"-E NGKEUAEMBAMUM LETTER PHASE-E NJAEMLIBAMUM LETTER PHASE-E MAPBAMUM LET" +
	"TER PHASE-E LOOTBAMUM LETTER PHASE-E NGGEEEEBAMUM LETTER PHASE-E NDIQBAM" +
	"UM LETTER PHASE-E TAEN NTEUMBAMUM LETTER PHASE-E SETBAMUM LETTER PHASE-E") + ("" +
	" PUMBAMUM LETTER PHASE-E NDAA SOFTNESSBAMUM LETTER PHASE-E NGGUAESHAE NY" +
	"AMBAMUM LETTER PHASE-E YIEEBAMUM LETTER PHASE-E GHEUNBAMUM LETTER PHASE-" +
	"E TUAEBAMUM LETTER PHASE-E YEUAEBAMUM LETTER PHASE-E POBAMUM LETTER PHAS" +
	"E-E TUMAEBAMUM LETTER PHASE-E KEUAEBAMUM LETTER PHASE-E SUAENBAMUM LETTE" +
	"R PHASE-E TEUAEQBAMUM LETTER PHASE-E VEUAEBAMUM LETTER PHASE-E WEUXBAMUM" +
	" LETTER PHASE-E LAAMBAMUM LETTER PHASE-E PUBAMUM LETTER PHASE-E TAAQBAMU" +
	"M LETTER PHASE-E GHAAMAEBAMUM LETTER PHASE-E NGEUREUTBAMUM LETTER PHASE-" +
	"E SHEUAEQBAMUM LETTER PHASE-E MGBENBAMUM LETTER PHASE-E MBEEBAMUM LETTER" +
	" PHASE-E NZAQBAMUM LETTER PHASE-E NKOMBAMUM LETTER PHASE-E GBETBAMUM LET" +
	"TER PHASE-E TUMBAMUM LETTER PHASE-E KUETBAMUM LETTER PHASE-E YAPBAMUM LE" +
	"TTER PHASE-E NYI CLEAVERBAMUM LETTER PHASE-E YITBAMUM LETTER PHASE-E MFE" +
	"UQBAMUM LETTER PHASE-E NDIAQBAMUM LETTER PHASE-E PIEEQBAMUM LETTER PHASE" +
	"-E YUEQBAMUM LETTER PHASE-E LEUAEMBAMUM LETTER PHASE-E FUEBAMUM LETTER P" +
	"HASE-E GBEUXBAMUM LETTER PHASE-E NGKUPBAMUM LETTER PHASE-E KETBAMUM LETT" +
	"ER PHASE-E MAEBAMUM LETTER PHASE-E NGKAAMIBAMUM LETTER PHASE-E GHETBAMUM" +
	" LETTER PHASE-E FABAMUM LETTER PHASE-E NTUMBAMUM LETTER PHASE-E PEUTBAMU" +
	"M LETTER PHASE-E YEUMBAMUM LETTER PHASE-E NGGEUAEBAMUM LETTER PHASE-E NY" +
	"I BETWEENBAMUM LETTER PHASE-E NZUQBAMUM LETTER PHASE-E POONBAMUM LETTER " +
	"PHASE-E MIEEBAMUM LETTER PHASE-E FUETBAMUM LETTER PHASE-E NAEBAMUM LETTE" +
	"R PHASE-E MUAEBAMUM LETTER PHASE-E GHEUAEBAMUM LETTER PHASE-E FU IBAMUM " +
	"LETTER PHASE-E MVIBAMUM LETTER PHASE-E PUAQBAMUM LETTER PHASE-E NGKUMBAM" +
	"UM LETTER PHASE-E KUTBAMUM LETTER PHASE-E PIETBAMUM LETTER PHASE-E NTAPB" +
	"AMUM LETTER PHASE-E YEUAETBAMUM LETTER PHASE-E NGGUPBAMUM LETTER PHASE-E" +
	" PA PEOPLEBAMUM LETTER PHASE-E FU CALLBAMUM LETTER PHASE-E FOMBAMUM LETT" +
	"ER PHASE-E NJEEBAMUM LETTER PHASE-E ABAMUM LETTER PHASE-E TOQBAMUM LETTE" +
	"R PHASE-E OBAMUM LETTER PHASE-E IBAMUM LETTER PHASE-E LAQBAMUM LETTER PH" +
	"ASE-E PA PLURALBAMUM LETTER PHASE-E TAABAMUM LETTER PHASE-E TAQBAMUM LET" +
	"TER PHASE-E NDAA MY HOUSEBAMUM LETTER PHASE-E SHIQBAMUM LETTER PHASE-E Y" +
	"EUXBAMUM LETTER PHASE-E NGUAEBAMUM LETTER PHASE-E YUAENBAMUM LETTER PHAS" +
	"E-E YOQ SWIMMINGBAMUM LETTER PHASE-E YOQ COVERBAMUM LETTER PHASE-E YUQBA" +
	"MUM LETTER PHASE-E YUNBAMUM LETTER PHASE-E KEUXBAMUM LETTER PHASE-E PEUX" +
	"BAMUM LETTER PHASE-E NJEE EPOCHBAMUM LETTER PHASE-E PUEBAMUM LETTER PHAS" +
	"E-E WUEBAMUM LETTER PHASE-E FEEBAMUM LETTER PHASE-E VEEBAMUM LETTER PHAS" +
	"E-E LUBAMUM LETTER PHASE-E MIBAMUM LETTER PHASE-E REUXBAMUM LETTER PHASE" +
	"-E RAEBAMUM LETTER PHASE-E NGUAETBAMUM LETTER PHASE-E NGABAMUM LETTER PH" +
	"ASE-E SHOBAMUM LETTER PHASE-E SHOQBAMUM LETTER PHASE-E FU REMEDYBAMUM LE" +
	"TTER PHASE-E NABAMUM LETTER PHASE-E PIBAMUM LETTER PHASE-E LOQBAMUM LETT" +
	"ER PHASE-E KOBAMUM LETTER PHASE-E MENBAMUM LETTER PHASE-E MABAMUM LETTER" +
	" PHASE-E MAQBAMUM LETTER PHASE-E TEUBAMUM LETTER PHASE-E KIBAMUM LETTER " +
	"PHASE-E MONBAMUM LETTER PHASE-E TENBAMUM LETTER PHASE-E FAQBAMUM LETTER " +
	"PHASE-E GHOMBAMUM LETTER PHASE-F KABAMUM LETTER PHASE-F UBAMUM LETTER PH" +
	"ASE-F KUBAMUM LETTER PHASE-F EEBAMUM LETTER PHASE-F REEBAMUM LETTER PHAS" +
	"E-F TAEBAMUM LETTER PHASE-F NYIBAMUM LETTER PHASE-F LABAMUM LETTER PHASE" +
	"-F RIIBAMUM LETTER PHASE-F RIEEBAMUM LETTER PHASE-F MEEEEBAMUM LETTER PH" +
	"ASE-F TAABAMUM LETTER PHASE-F NDAABAMUM LETTER PHASE-F NJAEMBAMUM LETTER" +
	" PHASE-F MBAMUM LETTER PHASE-F SUUBAMUM LETTER PHASE-F SHIIBAMUM LETTER " +
	"PHASE-F SIBAMUM LETTER PHASE-F SEUXBAMUM LETTER PHASE-F KYEEBAMUM LETTER" +
	" PHASE-F KETBAMUM LETTER PHASE-F NUAEBAMUM LETTER PHASE-F NUBAMUM LETTER" +
	" PHASE-F NJUAEBAMUM LETTER PHASE-F YOQBAMUM LETTER PHASE-F SHUBAMUM LETT" +
	"ER PHASE-F YABAMUM LETTER PHASE-F NSHABAMUM LETTER PHASE-F PEUXBAMUM LET" +
	"TER PHASE-F NTEEBAMUM LETTER PHASE-F WUEBAMUM LETTER PHASE-F PEEBAMUM LE" +
	"TTER PHASE-F RUBAMUM LETTER PHASE-F NIBAMUM LETTER PHASE-F REUXBAMUM LET" +
	"TER PHASE-F KENBAMUM LETTER PHASE-F NGKWAENBAMUM LETTER PHASE-F NGGABAMU" +
	"M LETTER PHASE-F SHOBAMUM LETTER PHASE-F PUAEBAMUM LETTER PHASE-F FOMBAM" +
	"UM LETTER PHASE-F WABAMUM LETTER PHASE-F LIBAMUM LETTER PHASE-F LOQBAMUM" +
	" LETTER PHASE-F KOBAMUM LETTER PHASE-F MBENBAMUM LETTER PHASE-F RENBAMUM" +
	" LETTER PHASE-F MABAMUM LETTER PHASE-F MOBAMUM LETTER PHASE-F MBAABAMUM " +
	"LETTER PHASE-F TETBAMUM LETTER PHASE-F KPABAMUM LETTER PHASE-F SAMBABAMU" +
	"M LETTER PHASE-F VUEQMRO LETTER TAMRO LETTER NGIMRO LETTER YOMRO LETTER " +
	"MIMMRO LETTER BAMRO LETTER DAMRO LETTER AMRO LETTER PHIMRO LETTER KHAIMR" +
	"O LETTER HAOMRO LETTER DAIMRO LETTER CHUMRO LETTER KEAAEMRO LETTER OLMRO" +
	" LETTER MAEMMRO LETTER NINMRO LETTER PAMRO LETTER OOMRO LETTER OMRO LETT" +
	"ER ROMRO LETTER SHIMRO LETTER THEAMRO LETTER EAMRO LETTER WAMRO LETTER E" +
	"MRO LETTER KOMRO LETTER LANMRO LETTER LAMRO LETTER HAIMRO LETTER RIMRO L") + ("" +
	"ETTER TEKMRO DIGIT ZEROMRO DIGIT ONEMRO DIGIT TWOMRO DIGIT THREEMRO DIGI" +
	"T FOURMRO DIGIT FIVEMRO DIGIT SIXMRO DIGIT SEVENMRO DIGIT EIGHTMRO DIGIT" +
	" NINEMRO DANDAMRO DOUBLE DANDABASSA VAH LETTER ENNIBASSA VAH LETTER KABA" +
	"SSA VAH LETTER SEBASSA VAH LETTER FABASSA VAH LETTER MBEBASSA VAH LETTER" +
	" YIEBASSA VAH LETTER GAHBASSA VAH LETTER DHIIBASSA VAH LETTER KPAHBASSA " +
	"VAH LETTER JOBASSA VAH LETTER HWAHBASSA VAH LETTER WABASSA VAH LETTER ZO" +
	"BASSA VAH LETTER GBUBASSA VAH LETTER DOBASSA VAH LETTER CEBASSA VAH LETT" +
	"ER UWUBASSA VAH LETTER TOBASSA VAH LETTER BABASSA VAH LETTER VUBASSA VAH" +
	" LETTER YEINBASSA VAH LETTER PABASSA VAH LETTER WADDABASSA VAH LETTER AB" +
	"ASSA VAH LETTER OBASSA VAH LETTER OOBASSA VAH LETTER UBASSA VAH LETTER E" +
	"EBASSA VAH LETTER EBASSA VAH LETTER IBASSA VAH COMBINING HIGH TONEBASSA " +
	"VAH COMBINING LOW TONEBASSA VAH COMBINING MID TONEBASSA VAH COMBINING LO" +
	"W-MID TONEBASSA VAH COMBINING HIGH-LOW TONEBASSA VAH FULL STOPPAHAWH HMO" +
	"NG VOWEL KEEBPAHAWH HMONG VOWEL KEEVPAHAWH HMONG VOWEL KIBPAHAWH HMONG V" +
	"OWEL KIVPAHAWH HMONG VOWEL KAUBPAHAWH HMONG VOWEL KAUVPAHAWH HMONG VOWEL" +
	" KUBPAHAWH HMONG VOWEL KUVPAHAWH HMONG VOWEL KEBPAHAWH HMONG VOWEL KEVPA" +
	"HAWH HMONG VOWEL KAIBPAHAWH HMONG VOWEL KAIVPAHAWH HMONG VOWEL KOOBPAHAW" +
	"H HMONG VOWEL KOOVPAHAWH HMONG VOWEL KAWBPAHAWH HMONG VOWEL KAWVPAHAWH H" +
	"MONG VOWEL KUABPAHAWH HMONG VOWEL KUAVPAHAWH HMONG VOWEL KOBPAHAWH HMONG" +
	" VOWEL KOVPAHAWH HMONG VOWEL KIABPAHAWH HMONG VOWEL KIAVPAHAWH HMONG VOW" +
	"EL KABPAHAWH HMONG VOWEL KAVPAHAWH HMONG VOWEL KWBPAHAWH HMONG VOWEL KWV" +
	"PAHAWH HMONG VOWEL KAABPAHAWH HMONG VOWEL KAAVPAHAWH HMONG CONSONANT VAU" +
	"PAHAWH HMONG CONSONANT NTSAUPAHAWH HMONG CONSONANT LAUPAHAWH HMONG CONSO" +
	"NANT HAUPAHAWH HMONG CONSONANT NLAUPAHAWH HMONG CONSONANT RAUPAHAWH HMON" +
	"G CONSONANT NKAUPAHAWH HMONG CONSONANT QHAUPAHAWH HMONG CONSONANT YAUPAH" +
	"AWH HMONG CONSONANT HLAUPAHAWH HMONG CONSONANT MAUPAHAWH HMONG CONSONANT" +
	" CHAUPAHAWH HMONG CONSONANT NCHAUPAHAWH HMONG CONSONANT HNAUPAHAWH HMONG" +
	" CONSONANT PLHAUPAHAWH HMONG CONSONANT NTHAUPAHAWH HMONG CONSONANT NAUPA" +
	"HAWH HMONG CONSONANT AUPAHAWH HMONG CONSONANT XAUPAHAWH HMONG CONSONANT " +
	"CAUPAHAWH HMONG MARK CIM TUBPAHAWH HMONG MARK CIM SOPAHAWH HMONG MARK CI" +
	"M KESPAHAWH HMONG MARK CIM KHAVPAHAWH HMONG MARK CIM SUAMPAHAWH HMONG MA" +
	"RK CIM HOMPAHAWH HMONG MARK CIM TAUMPAHAWH HMONG SIGN VOS THOMPAHAWH HMO" +
	"NG SIGN VOS TSHAB CEEBPAHAWH HMONG SIGN CIM CHEEMPAHAWH HMONG SIGN VOS T" +
	"HIABPAHAWH HMONG SIGN VOS FEEMPAHAWH HMONG SIGN XYEEM NTXIVPAHAWH HMONG " +
	"SIGN XYEEM RHOPAHAWH HMONG SIGN XYEEM TOVPAHAWH HMONG SIGN XYEEM FAIBPAH" +
	"AWH HMONG SIGN VOS SEEVPAHAWH HMONG SIGN MEEJ SUABPAHAWH HMONG SIGN VOS " +
	"NRUAPAHAWH HMONG SIGN IB YAMPAHAWH HMONG SIGN XAUSPAHAWH HMONG SIGN CIM " +
	"TSOV ROGPAHAWH HMONG DIGIT ZEROPAHAWH HMONG DIGIT ONEPAHAWH HMONG DIGIT " +
	"TWOPAHAWH HMONG DIGIT THREEPAHAWH HMONG DIGIT FOURPAHAWH HMONG DIGIT FIV" +
	"EPAHAWH HMONG DIGIT SIXPAHAWH HMONG DIGIT SEVENPAHAWH HMONG DIGIT EIGHTP" +
	"AHAWH HMONG DIGIT NINEPAHAWH HMONG NUMBER TENSPAHAWH HMONG NUMBER HUNDRE" +
	"DSPAHAWH HMONG NUMBER TEN THOUSANDSPAHAWH HMONG NUMBER MILLIONSPAHAWH HM" +
	"ONG NUMBER HUNDRED MILLIONSPAHAWH HMONG NUMBER TEN BILLIONSPAHAWH HMONG " +
	"NUMBER TRILLIONSPAHAWH HMONG SIGN VOS LUBPAHAWH HMONG SIGN XYOOPAHAWH HM" +
	"ONG SIGN HLIPAHAWH HMONG SIGN THIRD-STAGE HLIPAHAWH HMONG SIGN ZWJ THAJP" +
	"AHAWH HMONG SIGN HNUBPAHAWH HMONG SIGN NQIGPAHAWH HMONG SIGN XIABPAHAWH " +
	"HMONG SIGN NTUJPAHAWH HMONG SIGN AVPAHAWH HMONG SIGN TXHEEJ CEEVPAHAWH H" +
	"MONG SIGN MEEJ TSEEBPAHAWH HMONG SIGN TAUPAHAWH HMONG SIGN LOSPAHAWH HMO" +
	"NG SIGN MUSPAHAWH HMONG SIGN CIM HAIS LUS NTOG NTOGPAHAWH HMONG SIGN CIM" +
	" CUAM TSHOOJPAHAWH HMONG SIGN CIM TXWVPAHAWH HMONG SIGN CIM TXWV CHWVPAH" +
	"AWH HMONG SIGN CIM PUB DAWBPAHAWH HMONG SIGN CIM NRES TOSPAHAWH HMONG CL" +
	"AN SIGN TSHEEJPAHAWH HMONG CLAN SIGN YEEGPAHAWH HMONG CLAN SIGN LISPAHAW" +
	"H HMONG CLAN SIGN LAUJPAHAWH HMONG CLAN SIGN XYOOJPAHAWH HMONG CLAN SIGN" +
	" KOOPAHAWH HMONG CLAN SIGN HAWJPAHAWH HMONG CLAN SIGN MUASPAHAWH HMONG C" +
	"LAN SIGN THOJPAHAWH HMONG CLAN SIGN TSABPAHAWH HMONG CLAN SIGN PHABPAHAW" +
	"H HMONG CLAN SIGN KHABPAHAWH HMONG CLAN SIGN HAMPAHAWH HMONG CLAN SIGN V" +
	"AJPAHAWH HMONG CLAN SIGN FAJPAHAWH HMONG CLAN SIGN YAJPAHAWH HMONG CLAN " +
	"SIGN TSWBPAHAWH HMONG CLAN SIGN KWMPAHAWH HMONG CLAN SIGN VWJMEDEFAIDRIN" +
	" CAPITAL LETTER MMEDEFAIDRIN CAPITAL LETTER SMEDEFAIDRIN CAPITAL LETTER " +
	"VMEDEFAIDRIN CAPITAL LETTER WMEDEFAIDRIN CAPITAL LETTER ATIUMEDEFAIDRIN " +
	"CAPITAL LETTER ZMEDEFAIDRIN CAPITAL LETTER KPMEDEFAIDRIN CAPITAL LETTER " +
	"PMEDEFAIDRIN CAPITAL LETTER TMEDEFAIDRIN CAPITAL LETTER GMEDEFAIDRIN CAP" +
	"ITAL LETTER FMEDEFAIDRIN CAPITAL LETTER IMEDEFAIDRIN CAPITAL LETTER KMED" +
	"EFAIDRIN CAPITAL LETTER AMEDEFAIDRIN CAPITAL LETTER JMEDEFAIDRIN CAPITAL") + ("" +
	" LETTER EMEDEFAIDRIN CAPITAL LETTER BMEDEFAIDRIN CAPITAL LETTER CMEDEFAI" +
	"DRIN CAPITAL LETTER UMEDEFAIDRIN CAPITAL LETTER YUMEDEFAIDRIN CAPITAL LE" +
	"TTER LMEDEFAIDRIN CAPITAL LETTER QMEDEFAIDRIN CAPITAL LETTER HPMEDEFAIDR" +
	"IN CAPITAL LETTER NYMEDEFAIDRIN CAPITAL LETTER XMEDEFAIDRIN CAPITAL LETT" +
	"ER DMEDEFAIDRIN CAPITAL LETTER OEMEDEFAIDRIN CAPITAL LETTER NMEDEFAIDRIN" +
	" CAPITAL LETTER RMEDEFAIDRIN CAPITAL LETTER OMEDEFAIDRIN CAPITAL LETTER " +
	"AIMEDEFAIDRIN CAPITAL LETTER YMEDEFAIDRIN SMALL LETTER MMEDEFAIDRIN SMAL" +
	"L LETTER SMEDEFAIDRIN SMALL LETTER VMEDEFAIDRIN SMALL LETTER WMEDEFAIDRI" +
	"N SMALL LETTER ATIUMEDEFAIDRIN SMALL LETTER ZMEDEFAIDRIN SMALL LETTER KP" +
	"MEDEFAIDRIN SMALL LETTER PMEDEFAIDRIN SMALL LETTER TMEDEFAIDRIN SMALL LE" +
	"TTER GMEDEFAIDRIN SMALL LETTER FMEDEFAIDRIN SMALL LETTER IMEDEFAIDRIN SM" +
	"ALL LETTER KMEDEFAIDRIN SMALL LETTER AMEDEFAIDRIN SMALL LETTER JMEDEFAID" +
	"RIN SMALL LETTER EMEDEFAIDRIN SMALL LETTER BMEDEFAIDRIN SMALL LETTER CME" +
	"DEFAIDRIN SMALL LETTER UMEDEFAIDRIN SMALL LETTER YUMEDEFAIDRIN SMALL LET" +
	"TER LMEDEFAIDRIN SMALL LETTER QMEDEFAIDRIN SMALL LETTER HPMEDEFAIDRIN SM" +
	"ALL LETTER NYMEDEFAIDRIN SMALL LETTER XMEDEFAIDRIN SMALL LETTER DMEDEFAI" +
	"DRIN SMALL LETTER OEMEDEFAIDRIN SMALL LETTER NMEDEFAIDRIN SMALL LETTER R" +
	"MEDEFAIDRIN SMALL LETTER OMEDEFAIDRIN SMALL LETTER AIMEDEFAIDRIN SMALL L" +
	"ETTER YMEDEFAIDRIN DIGIT ZEROMEDEFAIDRIN DIGIT ONEMEDEFAIDRIN DIGIT TWOM" +
	"EDEFAIDRIN DIGIT THREEMEDEFAIDRIN DIGIT FOURMEDEFAIDRIN DIGIT FIVEMEDEFA" +
	"IDRIN DIGIT SIXMEDEFAIDRIN DIGIT SEVENMEDEFAIDRIN DIGIT EIGHTMEDEFAIDRIN" +
	" DIGIT NINEMEDEFAIDRIN NUMBER TENMEDEFAIDRIN NUMBER ELEVENMEDEFAIDRIN NU" +
	"MBER TWELVEMEDEFAIDRIN NUMBER THIRTEENMEDEFAIDRIN NUMBER FOURTEENMEDEFAI" +
	"DRIN NUMBER FIFTEENMEDEFAIDRIN NUMBER SIXTEENMEDEFAIDRIN NUMBER SEVENTEE" +
	"NMEDEFAIDRIN NUMBER EIGHTEENMEDEFAIDRIN NUMBER NINETEENMEDEFAIDRIN DIGIT" +
	" ONE ALTERNATE FORMMEDEFAIDRIN DIGIT TWO ALTERNATE FORMMEDEFAIDRIN DIGIT" +
	" THREE ALTERNATE FORMMEDEFAIDRIN COMMAMEDEFAIDRIN FULL STOPMEDEFAIDRIN S" +
	"YMBOL AIVAMEDEFAIDRIN EXCLAMATION OHMIAO LETTER PAMIAO LETTER BAMIAO LET" +
	"TER YI PAMIAO LETTER PLAMIAO LETTER MAMIAO LETTER MHAMIAO LETTER ARCHAIC" +
	" MAMIAO LETTER FAMIAO LETTER VAMIAO LETTER VFAMIAO LETTER TAMIAO LETTER " +
	"DAMIAO LETTER YI TTAMIAO LETTER YI TAMIAO LETTER TTAMIAO LETTER DDAMIAO " +
	"LETTER NAMIAO LETTER NHAMIAO LETTER YI NNAMIAO LETTER ARCHAIC NAMIAO LET" +
	"TER NNAMIAO LETTER NNHAMIAO LETTER LAMIAO LETTER LYAMIAO LETTER LHAMIAO " +
	"LETTER LHYAMIAO LETTER TLHAMIAO LETTER DLHAMIAO LETTER TLHYAMIAO LETTER " +
	"DLHYAMIAO LETTER KAMIAO LETTER GAMIAO LETTER YI KAMIAO LETTER QAMIAO LET" +
	"TER QGAMIAO LETTER NGAMIAO LETTER NGHAMIAO LETTER ARCHAIC NGAMIAO LETTER" +
	" HAMIAO LETTER XAMIAO LETTER GHAMIAO LETTER GHHAMIAO LETTER TSSAMIAO LET" +
	"TER DZZAMIAO LETTER NYAMIAO LETTER NYHAMIAO LETTER TSHAMIAO LETTER DZHAM" +
	"IAO LETTER YI TSHAMIAO LETTER YI DZHAMIAO LETTER REFORMED TSHAMIAO LETTE" +
	"R SHAMIAO LETTER SSAMIAO LETTER ZHAMIAO LETTER ZSHAMIAO LETTER TSAMIAO L" +
	"ETTER DZAMIAO LETTER YI TSAMIAO LETTER SAMIAO LETTER ZAMIAO LETTER ZSAMI" +
	"AO LETTER ZZAMIAO LETTER ZZSAMIAO LETTER ARCHAIC ZZAMIAO LETTER ZZYAMIAO" +
	" LETTER ZZSYAMIAO LETTER WAMIAO LETTER AHMIAO LETTER HHAMIAO LETTER BRIM" +
	"IAO LETTER SYIMIAO LETTER DZYIMIAO LETTER TEMIAO LETTER TSEMIAO LETTER R" +
	"TEMIAO SIGN CONSONANT MODIFIER BARMIAO LETTER NASALIZATIONMIAO SIGN ASPI" +
	"RATIONMIAO SIGN REFORMED VOICINGMIAO SIGN REFORMED ASPIRATIONMIAO VOWEL " +
	"SIGN AMIAO VOWEL SIGN AAMIAO VOWEL SIGN AHHMIAO VOWEL SIGN ANMIAO VOWEL " +
	"SIGN ANGMIAO VOWEL SIGN OMIAO VOWEL SIGN OOMIAO VOWEL SIGN WOMIAO VOWEL " +
	"SIGN WMIAO VOWEL SIGN EMIAO VOWEL SIGN ENMIAO VOWEL SIGN ENGMIAO VOWEL S" +
	"IGN OEYMIAO VOWEL SIGN IMIAO VOWEL SIGN IAMIAO VOWEL SIGN IANMIAO VOWEL " +
	"SIGN IANGMIAO VOWEL SIGN IOMIAO VOWEL SIGN IEMIAO VOWEL SIGN IIMIAO VOWE" +
	"L SIGN IUMIAO VOWEL SIGN INGMIAO VOWEL SIGN UMIAO VOWEL SIGN UAMIAO VOWE" +
	"L SIGN UANMIAO VOWEL SIGN UANGMIAO VOWEL SIGN UUMIAO VOWEL SIGN UEIMIAO " +
	"VOWEL SIGN UNGMIAO VOWEL SIGN YMIAO VOWEL SIGN YIMIAO VOWEL SIGN AEMIAO " +
	"VOWEL SIGN AEEMIAO VOWEL SIGN ERRMIAO VOWEL SIGN ROUNDED ERRMIAO VOWEL S" +
	"IGN ERMIAO VOWEL SIGN ROUNDED ERMIAO VOWEL SIGN AIMIAO VOWEL SIGN EIMIAO" +
	" VOWEL SIGN AUMIAO VOWEL SIGN OUMIAO VOWEL SIGN NMIAO VOWEL SIGN NGMIAO " +
	"VOWEL SIGN UOGMIAO VOWEL SIGN YUIMIAO VOWEL SIGN OGMIAO VOWEL SIGN OERMI" +
	"AO VOWEL SIGN VWMIAO VOWEL SIGN IGMIAO VOWEL SIGN EAMIAO VOWEL SIGN IONG" +
	"MIAO VOWEL SIGN UIMIAO TONE RIGHTMIAO TONE TOP RIGHTMIAO TONE ABOVEMIAO " +
	"TONE BELOWMIAO LETTER TONE-2MIAO LETTER TONE-3MIAO LETTER TONE-4MIAO LET" +
	"TER TONE-5MIAO LETTER TONE-6MIAO LETTER TONE-7MIAO LETTER TONE-8MIAO LET" +
	"TER REFORMED TONE-1MIAO LETTER REFORMED TONE-2MIAO LETTER REFORMED TONE-" +
	"4MIAO LETTER REFORMED TONE-5MIAO LETTER REFORMED TONE-6MIAO LETTER REFOR") + ("" +
	"MED TONE-8TANGUT ITERATION MARKNUSHU ITERATION MARKOLD CHINESE HOOK MARK" +
	"OLD CHINESE ITERATION MARKTANGUT COMPONENT-001TANGUT COMPONENT-002TANGUT" +
	" COMPONENT-003TANGUT COMPONENT-004TANGUT COMPONENT-005TANGUT COMPONENT-0" +
	"06TANGUT COMPONENT-007TANGUT COMPONENT-008TANGUT COMPONENT-009TANGUT COM" +
	"PONENT-010TANGUT COMPONENT-011TANGUT COMPONENT-012TANGUT COMPONENT-013TA" +
	"NGUT COMPONENT-014TANGUT COMPONENT-015TANGUT COMPONENT-016TANGUT COMPONE" +
	"NT-017TANGUT COMPONENT-018TANGUT COMPONENT-019TANGUT COMPONENT-020TANGUT" +
	" COMPONENT-021TANGUT COMPONENT-022TANGUT COMPONENT-023TANGUT COMPONENT-0" +
	"24TANGUT COMPONENT-025TANGUT COMPONENT-026TANGUT COMPONENT-027TANGUT COM" +
	"PONENT-028TANGUT COMPONENT-029TANGUT COMPONENT-030TANGUT COMPONENT-031TA" +
	"NGUT COMPONENT-032TANGUT COMPONENT-033TANGUT COMPONENT-034TANGUT COMPONE" +
	"NT-035TANGUT COMPONENT-036TANGUT COMPONENT-037TANGUT COMPONENT-038TANGUT" +
	" COMPONENT-039TANGUT COMPONENT-040TANGUT COMPONENT-041TANGUT COMPONENT-0" +
	"42TANGUT COMPONENT-043TANGUT COMPONENT-044TANGUT COMPONENT-045TANGUT COM" +
	"PONENT-046TANGUT COMPONENT-047TANGUT COMPONENT-048TANGUT COMPONENT-049TA" +
	"NGUT COMPONENT-050TANGUT COMPONENT-051TANGUT COMPONENT-052TANGUT COMPONE" +
	"NT-053TANGUT COMPONENT-054TANGUT COMPONENT-055TANGUT COMPONENT-056TANGUT" +
	" COMPONENT-057TANGUT COMPONENT-058TANGUT COMPONENT-059TANGUT COMPONENT-0" +
	"60TANGUT COMPONENT-061TANGUT COMPONENT-062TANGUT COMPONENT-063TANGUT COM" +
	"PONENT-064TANGUT COMPONENT-065TANGUT COMPONENT-066TANGUT COMPONENT-067TA" +
	"NGUT COMPONENT-068TANGUT COMPONENT-069TANGUT COMPONENT-070TANGUT COMPONE" +
	"NT-071TANGUT COMPONENT-072TANGUT COMPONENT-073TANGUT COMPONENT-074TANGUT" +
	" COMPONENT-075TANGUT COMPONENT-076TANGUT COMPONENT-077TANGUT COMPONENT-0" +
	"78TANGUT COMPONENT-079TANGUT COMPONENT-080TANGUT COMPONENT-081TANGUT COM" +
	"PONENT-082TANGUT COMPONENT-083TANGUT COMPONENT-084TANGUT COMPONENT-085TA" +
	"NGUT COMPONENT-086TANGUT COMPONENT-087TANGUT COMPONENT-088TANGUT COMPONE" +
	"NT-089TANGUT COMPONENT-090TANGUT COMPONENT-091TANGUT COMPONENT-092TANGUT" +
	" COMPONENT-093TANGUT COMPONENT-094TANGUT COMPONENT-095TANGUT COMPONENT-0" +
	"96TANGUT COMPONENT-097TANGUT COMPONENT-098TANGUT COMPONENT-099TANGUT COM" +
	"PONENT-100TANGUT COMPONENT-101TANGUT COMPONENT-102TANGUT COMPONENT-103TA" +
	"NGUT COMPONENT-104TANGUT COMPONENT-105TANGUT COMPONENT-106TANGUT COMPONE" +
	"NT-107TANGUT COMPONENT-108TANGUT COMPONENT-109TANGUT COMPONENT-110TANGUT" +
	" COMPONENT-111TANGUT COMPONENT-112TANGUT COMPONENT-113TANGUT COMPONENT-1" +
	"14TANGUT COMPONENT-115TANGUT COMPONENT-116TANGUT COMPONENT-117TANGUT COM" +
	"PONENT-118TANGUT COMPONENT-119TANGUT COMPONENT-120TANGUT COMPONENT-121TA" +
	"NGUT COMPONENT-122TANGUT COMPONENT-123TANGUT COMPONENT-124TANGUT COMPONE" +
	"NT-125TANGUT COMPONENT-126TANGUT COMPONENT-127TANGUT COMPONENT-128TANGUT" +
	" COMPONENT-129TANGUT COMPONENT-130TANGUT COMPONENT-131TANGUT COMPONENT-1" +
	"32TANGUT COMPONENT-133TANGUT COMPONENT-134TANGUT COMPONENT-135TANGUT COM" +
	"PONENT-136TANGUT COMPONENT-137TANGUT COMPONENT-138TANGUT COMPONENT-139TA" +
	"NGUT COMPONENT-140TANGUT COMPONENT-141TANGUT COMPONENT-142TANGUT COMPONE" +
	"NT-143TANGUT COMPONENT-144TANGUT COMPONENT-145TANGUT COMPONENT-146TANGUT" +
	" COMPONENT-147TANGUT COMPONENT-148TANGUT COMPONENT-149TANGUT COMPONENT-1" +
	"50TANGUT COMPONENT-151TANGUT COMPONENT-152TANGUT COMPONENT-153TANGUT COM" +
	"PONENT-154TANGUT COMPONENT-155TANGUT COMPONENT-156TANGUT COMPONENT-157TA" +
	"NGUT COMPONENT-158TANGUT COMPONENT-159TANGUT COMPONENT-160TANGUT COMPONE" +
	"NT-161TANGUT COMPONENT-162TANGUT COMPONENT-163TANGUT COMPONENT-164TANGUT" +
	" COMPONENT-165TANGUT COMPONENT-166TANGUT COMPONENT-167TANGUT COMPONENT-1" +
	"68TANGUT COMPONENT-169TANGUT COMPONENT-170TANGUT COMPONENT-171TANGUT COM" +
	"PONENT-172TANGUT COMPONENT-173TANGUT COMPONENT-174TANGUT COMPONENT-175TA" +
	"NGUT COMPONENT-176TANGUT COMPONENT-177TANGUT COMPONENT-178TANGUT COMPONE" +
	"NT-179TANGUT COMPONENT-180TANGUT COMPONENT-181TANGUT COMPONENT-182TANGUT" +
	" COMPONENT-183TANGUT COMPONENT-184TANGUT COMPONENT-185TANGUT COMPONENT-1" +
	"86TANGUT COMPONENT-187TANGUT COMPONENT-188TANGUT COMPONENT-189TANGUT COM" +
	"PONENT-190TANGUT COMPONENT-191TANGUT COMPONENT-192TANGUT COMPONENT-193TA" +
	"NGUT COMPONENT-194TANGUT COMPONENT-195TANGUT COMPONENT-196TANGUT COMPONE" +
	"NT-197TANGUT COMPONENT-198TANGUT COMPONENT-199TANGUT COMPONENT-200TANGUT" +
	" COMPONENT-201TANGUT COMPONENT-202TANGUT COMPONENT-203TANGUT COMPONENT-2" +
	"04TANGUT COMPONENT-205TANGUT COMPONENT-206TANGUT COMPONENT-207TANGUT COM" +
	"PONENT-208TANGUT COMPONENT-209TANGUT COMPONENT-210TANGUT COMPONENT-211TA" +
	"NGUT COMPONENT-212TANGUT COMPONENT-213TANGUT COMPONENT-214TANGUT COMPONE" +
	"NT-215TANGUT COMPONENT-216TANGUT COMPONENT-217TANGUT COMPONENT-218TANGUT" +
	" COMPONENT-219TANGUT COMPONENT-220TANGUT COMPONENT-221TANGUT COMPONENT-2" +
	"22TANGUT COMPONENT-223TANGUT COMPONENT-224TANGUT COMPONENT-225TANGUT COM") + ("" +
	"PONENT-226TANGUT COMPONENT-227TANGUT COMPONENT-228TANGUT COMPONENT-229TA" +
	"NGUT COMPONENT-230TANGUT COMPONENT-231TANGUT COMPONENT-232TANGUT COMPONE" +
	"NT-233TANGUT COMPONENT-234TANGUT COMPONENT-235TANGUT COMPONENT-236TANGUT" +
	" COMPONENT-237TANGUT COMPONENT-238TANGUT COMPONENT-239TANGUT COMPONENT-2" +
	"40TANGUT COMPONENT-241TANGUT COMPONENT-242TANGUT COMPONENT-243TANGUT COM" +
	"PONENT-244TANGUT COMPONENT-245TANGUT COMPONENT-246TANGUT COMPONENT-247TA" +
	"NGUT COMPONENT-248TANGUT COMPONENT-249TANGUT COMPONENT-250TANGUT COMPONE" +
	"NT-251TANGUT COMPONENT-252TANGUT COMPONENT-253TANGUT COMPONENT-254TANGUT" +
	" COMPONENT-255TANGUT COMPONENT-256TANGUT COMPONENT-257TANGUT COMPONENT-2" +
	"58TANGUT COMPONENT-259TANGUT COMPONENT-260TANGUT COMPONENT-261TANGUT COM" +
	"PONENT-262TANGUT COMPONENT-263TANGUT COMPONENT-264TANGUT COMPONENT-265TA" +
	"NGUT COMPONENT-266TANGUT COMPONENT-267TANGUT COMPONENT-268TANGUT COMPONE" +
	"NT-269TANGUT COMPONENT-270TANGUT COMPONENT-271TANGUT COMPONENT-272TANGUT" +
	" COMPONENT-273TANGUT COMPONENT-274TANGUT COMPONENT-275TANGUT COMPONENT-2" +
	"76TANGUT COMPONENT-277TANGUT COMPONENT-278TANGUT COMPONENT-279TANGUT COM" +
	"PONENT-280TANGUT COMPONENT-281TANGUT COMPONENT-282TANGUT COMPONENT-283TA" +
	"NGUT COMPONENT-284TANGUT COMPONENT-285TANGUT COMPONENT-286TANGUT COMPONE" +
	"NT-287TANGUT COMPONENT-288TANGUT COMPONENT-289TANGUT COMPONENT-290TANGUT" +
	" COMPONENT-291TANGUT COMPONENT-292TANGUT COMPONENT-293TANGUT COMPONENT-2" +
	"94TANGUT COMPONENT-295TANGUT COMPONENT-296TANGUT COMPONENT-297TANGUT COM" +
	"PONENT-298TANGUT COMPONENT-299TANGUT COMPONENT-300TANGUT COMPONENT-301TA" +
	"NGUT COMPONENT-302TANGUT COMPONENT-303TANGUT COMPONENT-304TANGUT COMPONE" +
	"NT-305TANGUT COMPONENT-306TANGUT COMPONENT-307TANGUT COMPONENT-308TANGUT" +
	" COMPONENT-309TANGUT COMPONENT-310TANGUT COMPONENT-311TANGUT COMPONENT-3" +
	"12TANGUT COMPONENT-313TANGUT COMPONENT-314TANGUT COMPONENT-315TANGUT COM" +
	"PONENT-316TANGUT COMPONENT-317TANGUT COMPONENT-318TANGUT COMPONENT-319TA" +
	"NGUT COMPONENT-320TANGUT COMPONENT-321TANGUT COMPONENT-322TANGUT COMPONE" +
	"NT-323TANGUT COMPONENT-324TANGUT COMPONENT-325TANGUT COMPONENT-326TANGUT" +
	" COMPONENT-327TANGUT COMPONENT-328TANGUT COMPONENT-329TANGUT COMPONENT-3" +
	"30TANGUT COMPONENT-331TANGUT COMPONENT-332TANGUT COMPONENT-333TANGUT COM" +
	"PONENT-334TANGUT COMPONENT-335TANGUT COMPONENT-336TANGUT COMPONENT-337TA" +
	"NGUT COMPONENT-338TANGUT COMPONENT-339TANGUT COMPONENT-340TANGUT COMPONE" +
	"NT-341TANGUT COMPONENT-342TANGUT COMPONENT-343TANGUT COMPONENT-344TANGUT" +
	" COMPONENT-345TANGUT COMPONENT-346TANGUT COMPONENT-347TANGUT COMPONENT-3" +
	"48TANGUT COMPONENT-349TANGUT COMPONENT-350TANGUT COMPONENT-351TANGUT COM" +
	"PONENT-352TANGUT COMPONENT-353TANGUT COMPONENT-354TANGUT COMPONENT-355TA" +
	"NGUT COMPONENT-356TANGUT COMPONENT-357TANGUT COMPONENT-358TANGUT COMPONE" +
	"NT-359TANGUT COMPONENT-360TANGUT COMPONENT-361TANGUT COMPONENT-362TANGUT" +
	" COMPONENT-363TANGUT COMPONENT-364TANGUT COMPONENT-365TANGUT COMPONENT-3" +
	"66TANGUT COMPONENT-367TANGUT COMPONENT-368TANGUT COMPONENT-369TANGUT COM" +
	"PONENT-370TANGUT COMPONENT-371TANGUT COMPONENT-372TANGUT COMPONENT-373TA" +
	"NGUT COMPONENT-374TANGUT COMPONENT-375TANGUT COMPONENT-376TANGUT COMPONE" +
	"NT-377TANGUT COMPONENT-378TANGUT COMPONENT-379TANGUT COMPONENT-380TANGUT" +
	" COMPONENT-381TANGUT COMPONENT-382TANGUT COMPONENT-383TANGUT COMPONENT-3" +
	"84TANGUT COMPONENT-385TANGUT COMPONENT-386TANGUT COMPONENT-387TANGUT COM" +
	"PONENT-388TANGUT COMPONENT-389TANGUT COMPONENT-390TANGUT COMPONENT-391TA" +
	"NGUT COMPONENT-392TANGUT COMPONENT-393TANGUT COMPONENT-394TANGUT COMPONE" +
	"NT-395TANGUT COMPONENT-396TANGUT COMPONENT-397TANGUT COMPONENT-398TANGUT" +
	" COMPONENT-399TANGUT COMPONENT-400TANGUT COMPONENT-401TANGUT COMPONENT-4" +
	"02TANGUT COMPONENT-403TANGUT COMPONENT-404TANGUT COMPONENT-405TANGUT COM" +
	"PONENT-406TANGUT COMPONENT-407TANGUT COMPONENT-408TANGUT COMPONENT-409TA" +
	"NGUT COMPONENT-410TANGUT COMPONENT-411TANGUT COMPONENT-412TANGUT COMPONE" +
	"NT-413TANGUT COMPONENT-414TANGUT COMPONENT-415TANGUT COMPONENT-416TANGUT" +
	" COMPONENT-417TANGUT COMPONENT-418TANGUT COMPONENT-419TANGUT COMPONENT-4" +
	"20TANGUT COMPONENT-421TANGUT COMPONENT-422TANGUT COMPONENT-423TANGUT COM" +
	"PONENT-424TANGUT COMPONENT-425TANGUT COMPONENT-426TANGUT COMPONENT-427TA" +
	"NGUT COMPONENT-428TANGUT COMPONENT-429TANGUT COMPONENT-430TANGUT COMPONE" +
	"NT-431TANGUT COMPONENT-432TANGUT COMPONENT-433TANGUT COMPONENT-434TANGUT" +
	" COMPONENT-435TANGUT COMPONENT-436TANGUT COMPONENT-437TANGUT COMPONENT-4" +
	"38TANGUT COMPONENT-439TANGUT COMPONENT-440TANGUT COMPONENT-441TANGUT COM" +
	"PONENT-442TANGUT COMPONENT-443TANGUT COMPONENT-444TANGUT COMPONENT-445TA" +
	"NGUT COMPONENT-446TANGUT COMPONENT-447TANGUT COMPONENT-448TANGUT COMPONE" +
	"NT-449TANGUT COMPONENT-450TANGUT COMPONENT-451TANGUT COMPONENT-452TANGUT" +
	" COMPONENT-453TANGUT COMPONENT-454TANGUT COMPONENT-455TANGUT COMPONENT-4") + ("" +
	"56TANGUT COMPONENT-457TANGUT COMPONENT-458TANGUT COMPONENT-459TANGUT COM" +
	"PONENT-460TANGUT COMPONENT-461TANGUT COMPONENT-462TANGUT COMPONENT-463TA" +
	"NGUT COMPONENT-464TANGUT COMPONENT-465TANGUT COMPONENT-466TANGUT COMPONE" +
	"NT-467TANGUT COMPONENT-468TANGUT COMPONENT-469TANGUT COMPONENT-470TANGUT" +
	" COMPONENT-471TANGUT COMPONENT-472TANGUT COMPONENT-473TANGUT COMPONENT-4" +
	"74TANGUT COMPONENT-475TANGUT COMPONENT-476TANGUT COMPONENT-477TANGUT COM" +
	"PONENT-478TANGUT COMPONENT-479TANGUT COMPONENT-480TANGUT COMPONENT-481TA" +
	"NGUT COMPONENT-482TANGUT COMPONENT-483TANGUT COMPONENT-484TANGUT COMPONE" +
	"NT-485TANGUT COMPONENT-486TANGUT COMPONENT-487TANGUT COMPONENT-488TANGUT" +
	" COMPONENT-489TANGUT COMPONENT-490TANGUT COMPONENT-491TANGUT COMPONENT-4" +
	"92TANGUT COMPONENT-493TANGUT COMPONENT-494TANGUT COMPONENT-495TANGUT COM" +
	"PONENT-496TANGUT COMPONENT-497TANGUT COMPONENT-498TANGUT COMPONENT-499TA" +
	"NGUT COMPONENT-500TANGUT COMPONENT-501TANGUT COMPONENT-502TANGUT COMPONE" +
	"NT-503TANGUT COMPONENT-504TANGUT COMPONENT-505TANGUT COMPONENT-506TANGUT" +
	" COMPONENT-507TANGUT COMPONENT-508TANGUT COMPONENT-509TANGUT COMPONENT-5" +
	"10TANGUT COMPONENT-511TANGUT COMPONENT-512TANGUT COMPONENT-513TANGUT COM" +
	"PONENT-514TANGUT COMPONENT-515TANGUT COMPONENT-516TANGUT COMPONENT-517TA" +
	"NGUT COMPONENT-518TANGUT COMPONENT-519TANGUT COMPONENT-520TANGUT COMPONE" +
	"NT-521TANGUT COMPONENT-522TANGUT COMPONENT-523TANGUT COMPONENT-524TANGUT" +
	" COMPONENT-525TANGUT COMPONENT-526TANGUT COMPONENT-527TANGUT COMPONENT-5" +
	"28TANGUT COMPONENT-529TANGUT COMPONENT-530TANGUT COMPONENT-531TANGUT COM" +
	"PONENT-532TANGUT COMPONENT-533TANGUT COMPONENT-534TANGUT COMPONENT-535TA" +
	"NGUT COMPONENT-536TANGUT COMPONENT-537TANGUT COMPONENT-538TANGUT COMPONE" +
	"NT-539TANGUT COMPONENT-540TANGUT COMPONENT-541TANGUT COMPONENT-542TANGUT" +
	" COMPONENT-543TANGUT COMPONENT-544TANGUT COMPONENT-545TANGUT COMPONENT-5" +
	"46TANGUT COMPONENT-547TANGUT COMPONENT-548TANGUT COMPONENT-549TANGUT COM" +
	"PONENT-550TANGUT COMPONENT-551TANGUT COMPONENT-552TANGUT COMPONENT-553TA" +
	"NGUT COMPONENT-554TANGUT COMPONENT-555TANGUT COMPONENT-556TANGUT COMPONE" +
	"NT-557TANGUT COMPONENT-558TANGUT COMPONENT-559TANGUT COMPONENT-560TANGUT" +
	" COMPONENT-561TANGUT COMPONENT-562TANGUT COMPONENT-563TANGUT COMPONENT-5" +
	"64TANGUT COMPONENT-565TANGUT COMPONENT-566TANGUT COMPONENT-567TANGUT COM" +
	"PONENT-568TANGUT COMPONENT-569TANGUT COMPONENT-570TANGUT COMPONENT-571TA" +
	"NGUT COMPONENT-572TANGUT COMPONENT-573TANGUT COMPONENT-574TANGUT COMPONE" +
	"NT-575TANGUT COMPONENT-576TANGUT COMPONENT-577TANGUT COMPONENT-578TANGUT" +
	" COMPONENT-579TANGUT COMPONENT-580TANGUT COMPONENT-581TANGUT COMPONENT-5" +
	"82TANGUT COMPONENT-583TANGUT COMPONENT-584TANGUT COMPONENT-585TANGUT COM" +
	"PONENT-586TANGUT COMPONENT-587TANGUT COMPONENT-588TANGUT COMPONENT-589TA" +
	"NGUT COMPONENT-590TANGUT COMPONENT-591TANGUT COMPONENT-592TANGUT COMPONE" +
	"NT-593TANGUT COMPONENT-594TANGUT COMPONENT-595TANGUT COMPONENT-596TANGUT" +
	" COMPONENT-597TANGUT COMPONENT-598TANGUT COMPONENT-599TANGUT COMPONENT-6" +
	"00TANGUT COMPONENT-601TANGUT COMPONENT-602TANGUT COMPONENT-603TANGUT COM" +
	"PONENT-604TANGUT COMPONENT-605TANGUT COMPONENT-606TANGUT COMPONENT-607TA" +
	"NGUT COMPONENT-608TANGUT COMPONENT-609TANGUT COMPONENT-610TANGUT COMPONE" +
	"NT-611TANGUT COMPONENT-612TANGUT COMPONENT-613TANGUT COMPONENT-614TANGUT" +
	" COMPONENT-615TANGUT COMPONENT-616TANGUT COMPONENT-617TANGUT COMPONENT-6" +
	"18TANGUT COMPONENT-619TANGUT COMPONENT-620TANGUT COMPONENT-621TANGUT COM" +
	"PONENT-622TANGUT COMPONENT-623TANGUT COMPONENT-624TANGUT COMPONENT-625TA" +
	"NGUT COMPONENT-626TANGUT COMPONENT-627TANGUT COMPONENT-628TANGUT COMPONE" +
	"NT-629TANGUT COMPONENT-630TANGUT COMPONENT-631TANGUT COMPONENT-632TANGUT" +
	" COMPONENT-633TANGUT COMPONENT-634TANGUT COMPONENT-635TANGUT COMPONENT-6" +
	"36TANGUT COMPONENT-637TANGUT COMPONENT-638TANGUT COMPONENT-639TANGUT COM" +
	"PONENT-640TANGUT COMPONENT-641TANGUT COMPONENT-642TANGUT COMPONENT-643TA" +
	"NGUT COMPONENT-644TANGUT COMPONENT-645TANGUT COMPONENT-646TANGUT COMPONE" +
	"NT-647TANGUT COMPONENT-648TANGUT COMPONENT-649TANGUT COMPONENT-650TANGUT" +
	" COMPONENT-651TANGUT COMPONENT-652TANGUT COMPONENT-653TANGUT COMPONENT-6" +
	"54TANGUT COMPONENT-655TANGUT COMPONENT-656TANGUT COMPONENT-657TANGUT COM" +
	"PONENT-658TANGUT COMPONENT-659TANGUT COMPONENT-660TANGUT COMPONENT-661TA" +
	"NGUT COMPONENT-662TANGUT COMPONENT-663TANGUT COMPONENT-664TANGUT COMPONE" +
	"NT-665TANGUT COMPONENT-666TANGUT COMPONENT-667TANGUT COMPONENT-668TANGUT" +
	" COMPONENT-669TANGUT COMPONENT-670TANGUT COMPONENT-671TANGUT COMPONENT-6" +
	"72TANGUT COMPONENT-673TANGUT COMPONENT-674TANGUT COMPONENT-675TANGUT COM" +
	"PONENT-676TANGUT COMPONENT-677TANGUT COMPONENT-678TANGUT COMPONENT-679TA" +
	"NGUT COMPONENT-680TANGUT COMPONENT-681TANGUT COMPONENT-682TANGUT COMPONE" +
	"NT-683TANGUT COMPONENT-684TANGUT COMPONENT-685TANGUT COMPONENT-686TANGUT") + ("" +
	" COMPONENT-687TANGUT COMPONENT-688TANGUT COMPONENT-689TANGUT COMPONENT-6" +
	"90TANGUT COMPONENT-691TANGUT COMPONENT-692TANGUT COMPONENT-693TANGUT COM" +
	"PONENT-694TANGUT COMPONENT-695TANGUT COMPONENT-696TANGUT COMPONENT-697TA" +
	"NGUT COMPONENT-698TANGUT COMPONENT-699TANGUT COMPONENT-700TANGUT COMPONE" +
	"NT-701TANGUT COMPONENT-702TANGUT COMPONENT-703TANGUT COMPONENT-704TANGUT" +
	" COMPONENT-705TANGUT COMPONENT-706TANGUT COMPONENT-707TANGUT COMPONENT-7" +
	"08TANGUT COMPONENT-709TANGUT COMPONENT-710TANGUT COMPONENT-711TANGUT COM" +
	"PONENT-712TANGUT COMPONENT-713TANGUT COMPONENT-714TANGUT COMPONENT-715TA" +
	"NGUT COMPONENT-716TANGUT COMPONENT-717TANGUT COMPONENT-718TANGUT COMPONE" +
	"NT-719TANGUT COMPONENT-720TANGUT COMPONENT-721TANGUT COMPONENT-722TANGUT" +
	" COMPONENT-723TANGUT COMPONENT-724TANGUT COMPONENT-725TANGUT COMPONENT-7" +
	"26TANGUT COMPONENT-727TANGUT COMPONENT-728TANGUT COMPONENT-729TANGUT COM" +
	"PONENT-730TANGUT COMPONENT-731TANGUT COMPONENT-732TANGUT COMPONENT-733TA" +
	"NGUT COMPONENT-734TANGUT COMPONENT-735TANGUT COMPONENT-736TANGUT COMPONE" +
	"NT-737TANGUT COMPONENT-738TANGUT COMPONENT-739TANGUT COMPONENT-740TANGUT" +
	" COMPONENT-741TANGUT COMPONENT-742TANGUT COMPONENT-743TANGUT COMPONENT-7" +
	"44TANGUT COMPONENT-745TANGUT COMPONENT-746TANGUT COMPONENT-747TANGUT COM" +
	"PONENT-748TANGUT COMPONENT-749TANGUT COMPONENT-750TANGUT COMPONENT-751TA" +
	"NGUT COMPONENT-752TANGUT COMPONENT-753TANGUT COMPONENT-754TANGUT COMPONE" +
	"NT-755KATAKANA LETTER ARCHAIC EHIRAGANA LETTER ARCHAIC YEHENTAIGANA LETT" +
	"ER A-1HENTAIGANA LETTER A-2HENTAIGANA LETTER A-3HENTAIGANA LETTER A-WOHE" +
	"NTAIGANA LETTER I-1HENTAIGANA LETTER I-2HENTAIGANA LETTER I-3HENTAIGANA " +
	"LETTER I-4HENTAIGANA LETTER U-1HENTAIGANA LETTER U-2HENTAIGANA LETTER U-" +
	"3HENTAIGANA LETTER U-4HENTAIGANA LETTER U-5HENTAIGANA LETTER E-2HENTAIGA" +
	"NA LETTER E-3HENTAIGANA LETTER E-4HENTAIGANA LETTER E-5HENTAIGANA LETTER" +
	" E-6HENTAIGANA LETTER O-1HENTAIGANA LETTER O-2HENTAIGANA LETTER O-3HENTA" +
	"IGANA LETTER KA-1HENTAIGANA LETTER KA-2HENTAIGANA LETTER KA-3HENTAIGANA " +
	"LETTER KA-4HENTAIGANA LETTER KA-5HENTAIGANA LETTER KA-6HENTAIGANA LETTER" +
	" KA-7HENTAIGANA LETTER KA-8HENTAIGANA LETTER KA-9HENTAIGANA LETTER KA-10" +
	"HENTAIGANA LETTER KA-11HENTAIGANA LETTER KA-KEHENTAIGANA LETTER KI-1HENT" +
	"AIGANA LETTER KI-2HENTAIGANA LETTER KI-3HENTAIGANA LETTER KI-4HENTAIGANA" +
	" LETTER KI-5HENTAIGANA LETTER KI-6HENTAIGANA LETTER KI-7HENTAIGANA LETTE" +
	"R KI-8HENTAIGANA LETTER KU-1HENTAIGANA LETTER KU-2HENTAIGANA LETTER KU-3" +
	"HENTAIGANA LETTER KU-4HENTAIGANA LETTER KU-5HENTAIGANA LETTER KU-6HENTAI" +
	"GANA LETTER KU-7HENTAIGANA LETTER KE-1HENTAIGANA LETTER KE-2HENTAIGANA L" +
	"ETTER KE-3HENTAIGANA LETTER KE-4HENTAIGANA LETTER KE-5HENTAIGANA LETTER " +
	"KE-6HENTAIGANA LETTER KO-1HENTAIGANA LETTER KO-2HENTAIGANA LETTER KO-3HE" +
	"NTAIGANA LETTER KO-KIHENTAIGANA LETTER SA-1HENTAIGANA LETTER SA-2HENTAIG" +
	"ANA LETTER SA-3HENTAIGANA LETTER SA-4HENTAIGANA LETTER SA-5HENTAIGANA LE" +
	"TTER SA-6HENTAIGANA LETTER SA-7HENTAIGANA LETTER SA-8HENTAIGANA LETTER S" +
	"I-1HENTAIGANA LETTER SI-2HENTAIGANA LETTER SI-3HENTAIGANA LETTER SI-4HEN" +
	"TAIGANA LETTER SI-5HENTAIGANA LETTER SI-6HENTAIGANA LETTER SU-1HENTAIGAN" +
	"A LETTER SU-2HENTAIGANA LETTER SU-3HENTAIGANA LETTER SU-4HENTAIGANA LETT" +
	"ER SU-5HENTAIGANA LETTER SU-6HENTAIGANA LETTER SU-7HENTAIGANA LETTER SU-" +
	"8HENTAIGANA LETTER SE-1HENTAIGANA LETTER SE-2HENTAIGANA LETTER SE-3HENTA" +
	"IGANA LETTER SE-4HENTAIGANA LETTER SE-5HENTAIGANA LETTER SO-1HENTAIGANA " +
	"LETTER SO-2HENTAIGANA LETTER SO-3HENTAIGANA LETTER SO-4HENTAIGANA LETTER" +
	" SO-5HENTAIGANA LETTER SO-6HENTAIGANA LETTER SO-7HENTAIGANA LETTER TA-1H" +
	"ENTAIGANA LETTER TA-2HENTAIGANA LETTER TA-3HENTAIGANA LETTER TA-4HENTAIG" +
	"ANA LETTER TI-1HENTAIGANA LETTER TI-2HENTAIGANA LETTER TI-3HENTAIGANA LE" +
	"TTER TI-4HENTAIGANA LETTER TI-5HENTAIGANA LETTER TI-6HENTAIGANA LETTER T" +
	"I-7HENTAIGANA LETTER TU-1HENTAIGANA LETTER TU-2HENTAIGANA LETTER TU-3HEN" +
	"TAIGANA LETTER TU-4HENTAIGANA LETTER TU-TOHENTAIGANA LETTER TE-1HENTAIGA" +
	"NA LETTER TE-2HENTAIGANA LETTER TE-3HENTAIGANA LETTER TE-4HENTAIGANA LET" +
	"TER TE-5HENTAIGANA LETTER TE-6HENTAIGANA LETTER TE-7HENTAIGANA LETTER TE" +
	"-8HENTAIGANA LETTER TE-9HENTAIGANA LETTER TO-1HENTAIGANA LETTER TO-2HENT" +
	"AIGANA LETTER TO-3HENTAIGANA LETTER TO-4HENTAIGANA LETTER TO-5HENTAIGANA" +
	" LETTER TO-6HENTAIGANA LETTER TO-RAHENTAIGANA LETTER NA-1HENTAIGANA LETT" +
	"ER NA-2HENTAIGANA LETTER NA-3HENTAIGANA LETTER NA-4HENTAIGANA LETTER NA-" +
	"5HENTAIGANA LETTER NA-6HENTAIGANA LETTER NA-7HENTAIGANA LETTER NA-8HENTA" +
	"IGANA LETTER NA-9HENTAIGANA LETTER NI-1HENTAIGANA LETTER NI-2HENTAIGANA " +
	"LETTER NI-3HENTAIGANA LETTER NI-4HENTAIGANA LETTER NI-5HENTAIGANA LETTER" +
	" NI-6HENTAIGANA LETTER NI-7HENTAIGANA LETTER NI-TEHENTAIGANA LETTER NU-1" +
	"HENTAIGANA LETTER NU-2HENTAIGANA LETTER NU-3HENTAIGANA LETTER NE-1HENTAI") + ("" +
	"GANA LETTER NE-2HENTAIGANA LETTER NE-3HENTAIGANA LETTER NE-4HENTAIGANA L" +
	"ETTER NE-5HENTAIGANA LETTER NE-6HENTAIGANA LETTER NE-KOHENTAIGANA LETTER" +
	" NO-1HENTAIGANA LETTER NO-2HENTAIGANA LETTER NO-3HENTAIGANA LETTER NO-4H" +
	"ENTAIGANA LETTER NO-5HENTAIGANA LETTER HA-1HENTAIGANA LETTER HA-2HENTAIG" +
	"ANA LETTER HA-3HENTAIGANA LETTER HA-4HENTAIGANA LETTER HA-5HENTAIGANA LE" +
	"TTER HA-6HENTAIGANA LETTER HA-7HENTAIGANA LETTER HA-8HENTAIGANA LETTER H" +
	"A-9HENTAIGANA LETTER HA-10HENTAIGANA LETTER HA-11HENTAIGANA LETTER HI-1H" +
	"ENTAIGANA LETTER HI-2HENTAIGANA LETTER HI-3HENTAIGANA LETTER HI-4HENTAIG" +
	"ANA LETTER HI-5HENTAIGANA LETTER HI-6HENTAIGANA LETTER HI-7HENTAIGANA LE" +
	"TTER HU-1HENTAIGANA LETTER HU-2HENTAIGANA LETTER HU-3HENTAIGANA LETTER H" +
	"E-1HENTAIGANA LETTER HE-2HENTAIGANA LETTER HE-3HENTAIGANA LETTER HE-4HEN" +
	"TAIGANA LETTER HE-5HENTAIGANA LETTER HE-6HENTAIGANA LETTER HE-7HENTAIGAN" +
	"A LETTER HO-1HENTAIGANA LETTER HO-2HENTAIGANA LETTER HO-3HENTAIGANA LETT" +
	"ER HO-4HENTAIGANA LETTER HO-5HENTAIGANA LETTER HO-6HENTAIGANA LETTER HO-" +
	"7HENTAIGANA LETTER HO-8HENTAIGANA LETTER MA-1HENTAIGANA LETTER MA-2HENTA" +
	"IGANA LETTER MA-3HENTAIGANA LETTER MA-4HENTAIGANA LETTER MA-5HENTAIGANA " +
	"LETTER MA-6HENTAIGANA LETTER MA-7HENTAIGANA LETTER MI-1HENTAIGANA LETTER" +
	" MI-2HENTAIGANA LETTER MI-3HENTAIGANA LETTER MI-4HENTAIGANA LETTER MI-5H" +
	"ENTAIGANA LETTER MI-6HENTAIGANA LETTER MI-7HENTAIGANA LETTER MU-1HENTAIG" +
	"ANA LETTER MU-2HENTAIGANA LETTER MU-3HENTAIGANA LETTER MU-4HENTAIGANA LE" +
	"TTER ME-1HENTAIGANA LETTER ME-2HENTAIGANA LETTER ME-MAHENTAIGANA LETTER " +
	"MO-1HENTAIGANA LETTER MO-2HENTAIGANA LETTER MO-3HENTAIGANA LETTER MO-4HE" +
	"NTAIGANA LETTER MO-5HENTAIGANA LETTER MO-6HENTAIGANA LETTER YA-1HENTAIGA" +
	"NA LETTER YA-2HENTAIGANA LETTER YA-3HENTAIGANA LETTER YA-4HENTAIGANA LET" +
	"TER YA-5HENTAIGANA LETTER YA-YOHENTAIGANA LETTER YU-1HENTAIGANA LETTER Y" +
	"U-2HENTAIGANA LETTER YU-3HENTAIGANA LETTER YU-4HENTAIGANA LETTER YO-1HEN" +
	"TAIGANA LETTER YO-2HENTAIGANA LETTER YO-3HENTAIGANA LETTER YO-4HENTAIGAN" +
	"A LETTER YO-5HENTAIGANA LETTER YO-6HENTAIGANA LETTER RA-1HENTAIGANA LETT" +
	"ER RA-2HENTAIGANA LETTER RA-3HENTAIGANA LETTER RA-4HENTAIGANA LETTER RI-" +
	"1HENTAIGANA LETTER RI-2HENTAIGANA LETTER RI-3HENTAIGANA LETTER RI-4HENTA" +
	"IGANA LETTER RI-5HENTAIGANA LETTER RI-6HENTAIGANA LETTER RI-7HENTAIGANA " +
	"LETTER RU-1HENTAIGANA LETTER RU-2HENTAIGANA LETTER RU-3HENTAIGANA LETTER" +
	" RU-4HENTAIGANA LETTER RU-5HENTAIGANA LETTER RU-6HENTAIGANA LETTER RE-1H" +
	"ENTAIGANA LETTER RE-2HENTAIGANA LETTER RE-3HENTAIGANA LETTER RE-4HENTAIG" +
	"ANA LETTER RO-1HENTAIGANA LETTER RO-2HENTAIGANA LETTER RO-3HENTAIGANA LE" +
	"TTER RO-4HENTAIGANA LETTER RO-5HENTAIGANA LETTER RO-6HENTAIGANA LETTER W" +
	"A-1HENTAIGANA LETTER WA-2HENTAIGANA LETTER WA-3HENTAIGANA LETTER WA-4HEN" +
	"TAIGANA LETTER WA-5HENTAIGANA LETTER WI-1HENTAIGANA LETTER WI-2HENTAIGAN" +
	"A LETTER WI-3HENTAIGANA LETTER WI-4HENTAIGANA LETTER WI-5HENTAIGANA LETT" +
	"ER WE-1HENTAIGANA LETTER WE-2HENTAIGANA LETTER WE-3HENTAIGANA LETTER WE-" +
	"4HENTAIGANA LETTER WO-1HENTAIGANA LETTER WO-2HENTAIGANA LETTER WO-3HENTA" +
	"IGANA LETTER WO-4HENTAIGANA LETTER WO-5HENTAIGANA LETTER WO-6HENTAIGANA " +
	"LETTER WO-7HENTAIGANA LETTER N-MU-MO-1HENTAIGANA LETTER N-MU-MO-2HIRAGAN" +
	"A LETTER SMALL WIHIRAGANA LETTER SMALL WEHIRAGANA LETTER SMALL WOKATAKAN" +
	"A LETTER SMALL WIKATAKANA LETTER SMALL WEKATAKANA LETTER SMALL WOKATAKAN" +
	"A LETTER SMALL NNUSHU CHARACTER-1B170NUSHU CHARACTER-1B171NUSHU CHARACTE" +
	"R-1B172NUSHU CHARACTER-1B173NUSHU CHARACTER-1B174NUSHU CHARACTER-1B175NU" +
	"SHU CHARACTER-1B176NUSHU CHARACTER-1B177NUSHU CHARACTER-1B178NUSHU CHARA" +
	"CTER-1B179NUSHU CHARACTER-1B17ANUSHU CHARACTER-1B17BNUSHU CHARACTER-1B17" +
	"CNUSHU CHARACTER-1B17DNUSHU CHARACTER-1B17ENUSHU CHARACTER-1B17FNUSHU CH" +
	"ARACTER-1B180NUSHU CHARACTER-1B181NUSHU CHARACTER-1B182NUSHU CHARACTER-1" +
	"B183NUSHU CHARACTER-1B184NUSHU CHARACTER-1B185NUSHU CHARACTER-1B186NUSHU" +
	" CHARACTER-1B187NUSHU CHARACTER-1B188NUSHU CHARACTER-1B189NUSHU CHARACTE" +
	"R-1B18ANUSHU CHARACTER-1B18BNUSHU CHARACTER-1B18CNUSHU CHARACTER-1B18DNU" +
	"SHU CHARACTER-1B18ENUSHU CHARACTER-1B18FNUSHU CHARACTER-1B190NUSHU CHARA" +
	"CTER-1B191NUSHU CHARACTER-1B192NUSHU CHARACTER-1B193NUSHU CHARACTER-1B19" +
	"4NUSHU CHARACTER-1B195NUSHU CHARACTER-1B196NUSHU CHARACTER-1B197NUSHU CH" +
	"ARACTER-1B198NUSHU CHARACTER-1B199NUSHU CHARACTER-1B19ANUSHU CHARACTER-1" +
	"B19BNUSHU CHARACTER-1B19CNUSHU CHARACTER-1B19DNUSHU CHARACTER-1B19ENUSHU" +
	" CHARACTER-1B19FNUSHU CHARACTER-1B1A0NUSHU CHARACTER-1B1A1NUSHU CHARACTE" +
	"R-1B1A2NUSHU CHARACTER-1B1A3NUSHU CHARACTER-1B1A4NUSHU CHARACTER-1B1A5NU" +
	"SHU CHARACTER-1B1A6NUSHU CHARACTER-1B1A7NUSHU CHARACTER-1B1A8NUSHU CHARA" +
	"CTER-1B1A9NUSHU CHARACTER-1B1AANUSHU CHARACTER-1B1ABNUSHU CHARACTER-1B1A" +
	"CNUSHU CHARACTER-1B1ADNUSHU CHARACTER-1B1AENUSHU CHARACTER-1B1AFNUSHU CH") + ("" +
	"ARACTER-1B1B0NUSHU CHARACTER-1B1B1NUSHU CHARACTER-1B1B2NUSHU CHARACTER-1" +
	"B1B3NUSHU CHARACTER-1B1B4NUSHU CHARACTER-1B1B5NUSHU CHARACTER-1B1B6NUSHU" +
	" CHARACTER-1B1B7NUSHU CHARACTER-1B1B8NUSHU CHARACTER-1B1B9NUSHU CHARACTE" +
	"R-1B1BANUSHU CHARACTER-1B1BBNUSHU CHARACTER-1B1BCNUSHU CHARACTER-1B1BDNU" +
	"SHU CHARACTER-1B1BENUSHU CHARACTER-1B1BFNUSHU CHARACTER-1B1C0NUSHU CHARA" +
	"CTER-1B1C1NUSHU CHARACTER-1B1C2NUSHU CHARACTER-1B1C3NUSHU CHARACTER-1B1C" +
	"4NUSHU CHARACTER-1B1C5NUSHU CHARACTER-1B1C6NUSHU CHARACTER-1B1C7NUSHU CH" +
	"ARACTER-1B1C8NUSHU CHARACTER-1B1C9NUSHU CHARACTER-1B1CANUSHU CHARACTER-1" +
	"B1CBNUSHU CHARACTER-1B1CCNUSHU CHARACTER-1B1CDNUSHU CHARACTER-1B1CENUSHU" +
	" CHARACTER-1B1CFNUSHU CHARACTER-1B1D0NUSHU CHARACTER-1B1D1NUSHU CHARACTE" +
	"R-1B1D2NUSHU CHARACTER-1B1D3NUSHU CHARACTER-1B1D4NUSHU CHARACTER-1B1D5NU" +
	"SHU CHARACTER-1B1D6NUSHU CHARACTER-1B1D7NUSHU CHARACTER-1B1D8NUSHU CHARA" +
	"CTER-1B1D9NUSHU CHARACTER-1B1DANUSHU CHARACTER-1B1DBNUSHU CHARACTER-1B1D" +
	"CNUSHU CHARACTER-1B1DDNUSHU CHARACTER-1B1DENUSHU CHARACTER-1B1DFNUSHU CH" +
	"ARACTER-1B1E0NUSHU CHARACTER-1B1E1NUSHU CHARACTER-1B1E2NUSHU CHARACTER-1" +
	"B1E3NUSHU CHARACTER-1B1E4NUSHU CHARACTER-1B1E5NUSHU CHARACTER-1B1E6NUSHU" +
	" CHARACTER-1B1E7NUSHU CHARACTER-1B1E8NUSHU CHARACTER-1B1E9NUSHU CHARACTE" +
	"R-1B1EANUSHU CHARACTER-1B1EBNUSHU CHARACTER-1B1ECNUSHU CHARACTER-1B1EDNU" +
	"SHU CHARACTER-1B1EENUSHU CHARACTER-1B1EFNUSHU CHARACTER-1B1F0NUSHU CHARA" +
	"CTER-1B1F1NUSHU CHARACTER-1B1F2NUSHU CHARACTER-1B1F3NUSHU CHARACTER-1B1F" +
	"4NUSHU CHARACTER-1B1F5NUSHU CHARACTER-1B1F6NUSHU CHARACTER-1B1F7NUSHU CH" +
	"ARACTER-1B1F8NUSHU CHARACTER-1B1F9NUSHU CHARACTER-1B1FANUSHU CHARACTER-1" +
	"B1FBNUSHU CHARACTER-1B1FCNUSHU CHARACTER-1B1FDNUSHU CHARACTER-1B1FENUSHU" +
	" CHARACTER-1B1FFNUSHU CHARACTER-1B200NUSHU CHARACTER-1B201NUSHU CHARACTE" +
	"R-1B202NUSHU CHARACTER-1B203NUSHU CHARACTER-1B204NUSHU CHARACTER-1B205NU" +
	"SHU CHARACTER-1B206NUSHU CHARACTER-1B207NUSHU CHARACTER-1B208NUSHU CHARA" +
	"CTER-1B209NUSHU CHARACTER-1B20ANUSHU CHARACTER-1B20BNUSHU CHARACTER-1B20" +
	"CNUSHU CHARACTER-1B20DNUSHU CHARACTER-1B20ENUSHU CHARACTER-1B20FNUSHU CH" +
	"ARACTER-1B210NUSHU CHARACTER-1B211NUSHU CHARACTER-1B212NUSHU CHARACTER-1" +
	"B213NUSHU CHARACTER-1B214NUSHU CHARACTER-1B215NUSHU CHARACTER-1B216NUSHU" +
	" CHARACTER-1B217NUSHU CHARACTER-1B218NUSHU CHARACT