# Contributing to revive

Please contribute to this repository if any of the following is true:

* You are interested in improving the revive source or docs.
* You have expertise in community development, communication, or education.
* You want open source communities to be more collaborative and inclusive.
* You want to help lower the burden to first time contributors.

## How to contribute

Prerequisites:

* Familiarity with [GitHub PRs](https://help.github.com/articles/using-pull-requests) (pull requests) and issues.
* Knowledge of Go and familiarity with static code analysis, or tech writing.

## Submitting a Pull Request

All submissions, including submissions by project members, require review. We use GitHub pull requests for this purpose. See our [developer guide](DEVELOPING.md) for instructions on building the project.

Pull requests (fixes, new features, tests) are a great way to contribute to the project and help us make it better. Ideally, try to keep your PRs as focused as possible and keep your commits atomic and readable.

To avoid disappointment when working on a PR, please ask us first in case someone else is already working on a PR for a change you wished to make. It's always a good idea to file an issue before starting work on a PR unless it's for something minor (such as a typo fix).

We greatly appreciate any attention to tests. These help us validate that new work continues to function as expected over time.

In particular, this community seeks the following types of contributions:

* Improvement of the documentation. For example, tutorial on development of a custom rule, or a formatter.
* Development of new rules for providing an even stricter preset of validations.
* Development of new formatters for more readable output of the linting process.

This contribution guide was inspired by others including contributing to
Google open-source, React, Gulp, Babel, Guess.js.
