// Code generated by go-swagger; DO NOT EDIT.

package packer_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewPackerServiceGetRegistryParams creates a new PackerServiceGetRegistryParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewPackerServiceGetRegistryParams() *PackerServiceGetRegistryParams {
	return &PackerServiceGetRegistryParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewPackerServiceGetRegistryParamsWithTimeout creates a new PackerServiceGetRegistryParams object
// with the ability to set a timeout on a request.
func NewPackerServiceGetRegistryParamsWithTimeout(timeout time.Duration) *PackerServiceGetRegistryParams {
	return &PackerServiceGetRegistryParams{
		timeout: timeout,
	}
}

// NewPackerServiceGetRegistryParamsWithContext creates a new PackerServiceGetRegistryParams object
// with the ability to set a context for a request.
func NewPackerServiceGetRegistryParamsWithContext(ctx context.Context) *PackerServiceGetRegistryParams {
	return &PackerServiceGetRegistryParams{
		Context: ctx,
	}
}

// NewPackerServiceGetRegistryParamsWithHTTPClient creates a new PackerServiceGetRegistryParams object
// with the ability to set a custom HTTPClient for a request.
func NewPackerServiceGetRegistryParamsWithHTTPClient(client *http.Client) *PackerServiceGetRegistryParams {
	return &PackerServiceGetRegistryParams{
		HTTPClient: client,
	}
}

/*
PackerServiceGetRegistryParams contains all the parameters to send to the API endpoint

	for the packer service get registry operation.

	Typically these are written to a http.Request.
*/
type PackerServiceGetRegistryParams struct {

	/* LocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	LocationOrganizationID string

	/* LocationProjectID.

	   project_id is the projects id.
	*/
	LocationProjectID string

	/* LocationRegionProvider.

	   provider is the named cloud provider ("aws", "gcp", "azure").
	*/
	LocationRegionProvider *string

	/* LocationRegionRegion.

	   region is the cloud region ("us-west1", "us-east1").
	*/
	LocationRegionRegion *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the packer service get registry params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PackerServiceGetRegistryParams) WithDefaults() *PackerServiceGetRegistryParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the packer service get registry params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PackerServiceGetRegistryParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the packer service get registry params
func (o *PackerServiceGetRegistryParams) WithTimeout(timeout time.Duration) *PackerServiceGetRegistryParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the packer service get registry params
func (o *PackerServiceGetRegistryParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the packer service get registry params
func (o *PackerServiceGetRegistryParams) WithContext(ctx context.Context) *PackerServiceGetRegistryParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the packer service get registry params
func (o *PackerServiceGetRegistryParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the packer service get registry params
func (o *PackerServiceGetRegistryParams) WithHTTPClient(client *http.Client) *PackerServiceGetRegistryParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the packer service get registry params
func (o *PackerServiceGetRegistryParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithLocationOrganizationID adds the locationOrganizationID to the packer service get registry params
func (o *PackerServiceGetRegistryParams) WithLocationOrganizationID(locationOrganizationID string) *PackerServiceGetRegistryParams {
	o.SetLocationOrganizationID(locationOrganizationID)
	return o
}

// SetLocationOrganizationID adds the locationOrganizationId to the packer service get registry params
func (o *PackerServiceGetRegistryParams) SetLocationOrganizationID(locationOrganizationID string) {
	o.LocationOrganizationID = locationOrganizationID
}

// WithLocationProjectID adds the locationProjectID to the packer service get registry params
func (o *PackerServiceGetRegistryParams) WithLocationProjectID(locationProjectID string) *PackerServiceGetRegistryParams {
	o.SetLocationProjectID(locationProjectID)
	return o
}

// SetLocationProjectID adds the locationProjectId to the packer service get registry params
func (o *PackerServiceGetRegistryParams) SetLocationProjectID(locationProjectID string) {
	o.LocationProjectID = locationProjectID
}

// WithLocationRegionProvider adds the locationRegionProvider to the packer service get registry params
func (o *PackerServiceGetRegistryParams) WithLocationRegionProvider(locationRegionProvider *string) *PackerServiceGetRegistryParams {
	o.SetLocationRegionProvider(locationRegionProvider)
	return o
}

// SetLocationRegionProvider adds the locationRegionProvider to the packer service get registry params
func (o *PackerServiceGetRegistryParams) SetLocationRegionProvider(locationRegionProvider *string) {
	o.LocationRegionProvider = locationRegionProvider
}

// WithLocationRegionRegion adds the locationRegionRegion to the packer service get registry params
func (o *PackerServiceGetRegistryParams) WithLocationRegionRegion(locationRegionRegion *string) *PackerServiceGetRegistryParams {
	o.SetLocationRegionRegion(locationRegionRegion)
	return o
}

// SetLocationRegionRegion adds the locationRegionRegion to the packer service get registry params
func (o *PackerServiceGetRegistryParams) SetLocationRegionRegion(locationRegionRegion *string) {
	o.LocationRegionRegion = locationRegionRegion
}

// WriteToRequest writes these params to a swagger request
func (o *PackerServiceGetRegistryParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param location.organization_id
	if err := r.SetPathParam("location.organization_id", o.LocationOrganizationID); err != nil {
		return err
	}

	// path param location.project_id
	if err := r.SetPathParam("location.project_id", o.LocationProjectID); err != nil {
		return err
	}

	if o.LocationRegionProvider != nil {

		// query param location.region.provider
		var qrLocationRegionProvider string

		if o.LocationRegionProvider != nil {
			qrLocationRegionProvider = *o.LocationRegionProvider
		}
		qLocationRegionProvider := qrLocationRegionProvider
		if qLocationRegionProvider != "" {

			if err := r.SetQueryParam("location.region.provider", qLocationRegionProvider); err != nil {
				return err
			}
		}
	}

	if o.LocationRegionRegion != nil {

		// query param location.region.region
		var qrLocationRegionRegion string

		if o.LocationRegionRegion != nil {
			qrLocationRegionRegion = *o.LocationRegionRegion
		}
		qLocationRegionRegion := qrLocationRegionRegion
		if qLocationRegionRegion != "" {

			if err := r.SetQueryParam("location.region.region", qLocationRegionRegion); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
