# Contributing

Thank you for your interest in contributing to Grafana Plugin SDK for Go! We welcome all people who want to contribute in a healthy and constructive manner within our community. To help us create a safe and positive community experience for all, we require all participants to adhere to the [Code of Conduct](CODE_OF_CONDUCT.md).

This document is a guide to help you through the process of contributing to Grafana Plugin SDK for Go.

## Become a contributor

You can contribute to Grafana Plugin SDK for Go in several ways. Here are some examples:

- Contribute to the Grafana SDK for Go codebase.
- Report bugs and enhancements.

For more ways to contribute, check out the [Open Source Guides](https://opensource.guide/how-to-contribute/).

### Report bugs

Report a bug by submitting a [bug report](https://github.com/grafana/grafana-plugin-sdk-go/issues/new?labels=bug&template=1-bug_report.md). Make sure that you provide as much information as possible on how to reproduce the bug.

Before submitting a new issue, try to make sure someone hasn't already reported the problem. Look through the [existing issues](https://github.com/grafana/grafana-plugin-sdk-go/issues) for similar issues.

#### Security issues

If you believe you've found a security vulnerability, please read our [security policy](https://github.com/grafana/grafana-plugin-sdk-go/security/policy) for more details.

### Suggest enhancements

If you have an idea of how to improve Grafana Plugin SDK for Go, submit an [enhancement request](https://github.com/grafana/grafana-plugin-sdk-go/issues/new?labels=enhancement&template=2-enhancement_request.md).

## Where do I go from here?

- Set up your [development environment](contribute/developer-guide.md).
