// Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.

package components

import (
	"encoding/json"
	"fmt"
)

type RiskSource string

const (
	RiskSourceUnknown RiskSource = ""
	RiskSourceCensys  RiskSource = "censys"
	RiskSourceCve     RiskSource = "cve"
)

func (e RiskSource) ToPointer() *RiskSource {
	return &e
}
func (e *RiskSource) UnmarshalJSON(data []byte) error {
	var v string
	if err := json.Unmarshal(data, &v); err != nil {
		return err
	}
	switch v {
	case "":
		fallthrough
	case "censys":
		fallthrough
	case "cve":
		*e = RiskSource(v)
		return nil
	default:
		return fmt.Errorf("invalid value for RiskSource: %v", v)
	}
}

type Severity string

const (
	SeverityUnknown  Severity = ""
	SeverityLow      Severity = "low"
	SeverityMedium   Severity = "medium"
	SeverityHigh     Severity = "high"
	SeverityCritical Severity = "critical"
)

func (e Severity) ToPointer() *Severity {
	return &e
}
func (e *Severity) UnmarshalJSON(data []byte) error {
	var v string
	if err := json.Unmarshal(data, &v); err != nil {
		return err
	}
	switch v {
	case "":
		fallthrough
	case "low":
		fallthrough
	case "medium":
		fallthrough
	case "high":
		fallthrough
	case "critical":
		*e = Severity(v)
		return nil
	default:
		return fmt.Errorf("invalid value for Severity: %v", v)
	}
}

type RiskSource1 string

const (
	RiskSource1Unknown    RiskSource1 = ""
	RiskSource1Censys     RiskSource1 = "censys"
	RiskSource1Recog      RiskSource1 = "recog"
	RiskSource1Wappalyzer RiskSource1 = "wappalyzer"
	RiskSource1ThirdParty RiskSource1 = "third_party"
)

func (e RiskSource1) ToPointer() *RiskSource1 {
	return &e
}
func (e *RiskSource1) UnmarshalJSON(data []byte) error {
	var v string
	if err := json.Unmarshal(data, &v); err != nil {
		return err
	}
	switch v {
	case "":
		fallthrough
	case "censys":
		fallthrough
	case "recog":
		fallthrough
	case "wappalyzer":
		fallthrough
	case "third_party":
		*e = RiskSource1(v)
		return nil
	default:
		return fmt.Errorf("invalid value for RiskSource1: %v", v)
	}
}

type Risk struct {
	Confidence *float64     `json:"confidence,omitempty"`
	Cvss       *Cvss        `json:"cvss,omitempty"`
	Evidence   []Evidence   `json:"evidence,omitempty"`
	ID         *string      `json:"id,omitempty"`
	Metrics    *Metrics     `json:"metrics,omitempty"`
	Name       *string      `json:"name,omitempty"`
	RiskSource *RiskSource  `json:"risk_source,omitempty"`
	Severity   *Severity    `json:"severity,omitempty"`
	Source     *RiskSource1 `json:"source,omitempty"`
	Year       *int         `json:"year,omitempty"`
}

func (o *Risk) GetConfidence() *float64 {
	if o == nil {
		return nil
	}
	return o.Confidence
}

func (o *Risk) GetCvss() *Cvss {
	if o == nil {
		return nil
	}
	return o.Cvss
}

func (o *Risk) GetEvidence() []Evidence {
	if o == nil {
		return nil
	}
	return o.Evidence
}

func (o *Risk) GetID() *string {
	if o == nil {
		return nil
	}
	return o.ID
}

func (o *Risk) GetMetrics() *Metrics {
	if o == nil {
		return nil
	}
	return o.Metrics
}

func (o *Risk) GetName() *string {
	if o == nil {
		return nil
	}
	return o.Name
}

func (o *Risk) GetRiskSource() *RiskSource {
	if o == nil {
		return nil
	}
	return o.RiskSource
}

func (o *Risk) GetSeverity() *Severity {
	if o == nil {
		return nil
	}
	return o.Severity
}

func (o *Risk) GetSource() *RiskSource1 {
	if o == nil {
		return nil
	}
	return o.Source
}

func (o *Risk) GetYear() *int {
	if o == nil {
		return nil
	}
	return o.Year
}
