package voicenavigator

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeVoiceConfig invokes the voicenavigator.DescribeVoiceConfig API synchronously
func (client *Client) DescribeVoiceConfig(request *DescribeVoiceConfigRequest) (response *DescribeVoiceConfigResponse, err error) {
	response = CreateDescribeVoiceConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeVoiceConfigWithChan invokes the voicenavigator.DescribeVoiceConfig API asynchronously
func (client *Client) DescribeVoiceConfigWithChan(request *DescribeVoiceConfigRequest) (<-chan *DescribeVoiceConfigResponse, <-chan error) {
	responseChan := make(chan *DescribeVoiceConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeVoiceConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeVoiceConfigWithCallback invokes the voicenavigator.DescribeVoiceConfig API asynchronously
func (client *Client) DescribeVoiceConfigWithCallback(request *DescribeVoiceConfigRequest, callback func(response *DescribeVoiceConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeVoiceConfigResponse
		var err error
		defer close(result)
		response, err = client.DescribeVoiceConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeVoiceConfigRequest is the request struct for api DescribeVoiceConfig
type DescribeVoiceConfigRequest struct {
	*requests.RpcRequest
	InstanceId      string           `position:"Query" name:"InstanceId"`
	InstanceOwnerId requests.Integer `position:"Query" name:"InstanceOwnerId"`
}

// DescribeVoiceConfigResponse is the response struct for api DescribeVoiceConfig
type DescribeVoiceConfigResponse struct {
	*responses.BaseResponse
	SpeechNoiseThreshold string `json:"SpeechNoiseThreshold" xml:"SpeechNoiseThreshold"`
	AsrCustomizationId   string `json:"AsrCustomizationId" xml:"AsrCustomizationId"`
	Voice                string `json:"Voice" xml:"Voice"`
	RequestId            string `json:"RequestId" xml:"RequestId"`
	AsrClassVocabularyId string `json:"AsrClassVocabularyId" xml:"AsrClassVocabularyId"`
	AsrVocabularyId      string `json:"AsrVocabularyId" xml:"AsrVocabularyId"`
	AsrAcousticModelId   string `json:"AsrAcousticModelId" xml:"AsrAcousticModelId"`
	Volume               int    `json:"Volume" xml:"Volume"`
	SpeechRate           int    `json:"SpeechRate" xml:"SpeechRate"`
	ApesIpList           []Ip   `json:"ApesIpList" xml:"ApesIpList"`
}

// CreateDescribeVoiceConfigRequest creates a request to invoke DescribeVoiceConfig API
func CreateDescribeVoiceConfigRequest() (request *DescribeVoiceConfigRequest) {
	request = &DescribeVoiceConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("VoiceNavigator", "2018-06-12", "DescribeVoiceConfig", "voicebot", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeVoiceConfigResponse creates a response to parse from DescribeVoiceConfig response
func CreateDescribeVoiceConfigResponse() (response *DescribeVoiceConfigResponse) {
	response = &DescribeVoiceConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
