package rdc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetJoinCode invokes the rdc.GetJoinCode API synchronously
// api document: https://help.aliyun.com/api/rdc/getjoincode.html
func (client *Client) GetJoinCode(request *GetJoinCodeRequest) (response *GetJoinCodeResponse, err error) {
	response = CreateGetJoinCodeResponse()
	err = client.DoAction(request, response)
	return
}

// GetJoinCodeWithChan invokes the rdc.GetJoinCode API asynchronously
// api document: https://help.aliyun.com/api/rdc/getjoincode.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetJoinCodeWithChan(request *GetJoinCodeRequest) (<-chan *GetJoinCodeResponse, <-chan error) {
	responseChan := make(chan *GetJoinCodeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetJoinCode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetJoinCodeWithCallback invokes the rdc.GetJoinCode API asynchronously
// api document: https://help.aliyun.com/api/rdc/getjoincode.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetJoinCodeWithCallback(request *GetJoinCodeRequest, callback func(response *GetJoinCodeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetJoinCodeResponse
		var err error
		defer close(result)
		response, err = client.GetJoinCode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetJoinCodeRequest is the request struct for api GetJoinCode
type GetJoinCodeRequest struct {
	*requests.RpcRequest
	CorpIdentifier string `position:"Query" name:"CorpIdentifier"`
}

// GetJoinCodeResponse is the response struct for api GetJoinCode
type GetJoinCodeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetJoinCodeRequest creates a request to invoke GetJoinCode API
func CreateGetJoinCodeRequest() (request *GetJoinCodeRequest) {
	request = &GetJoinCodeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rdc", "2018-08-21", "GetJoinCode", "rdc", "openAPI")
	return
}

// CreateGetJoinCodeResponse creates a response to parse from GetJoinCode response
func CreateGetJoinCodeResponse() (response *GetJoinCodeResponse) {
	response = &GetJoinCodeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
