package onsmqtt

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UnRegisterDeviceCredential invokes the onsmqtt.UnRegisterDeviceCredential API synchronously
func (client *Client) UnRegisterDeviceCredential(request *UnRegisterDeviceCredentialRequest) (response *UnRegisterDeviceCredentialResponse, err error) {
	response = CreateUnRegisterDeviceCredentialResponse()
	err = client.DoAction(request, response)
	return
}

// UnRegisterDeviceCredentialWithChan invokes the onsmqtt.UnRegisterDeviceCredential API asynchronously
func (client *Client) UnRegisterDeviceCredentialWithChan(request *UnRegisterDeviceCredentialRequest) (<-chan *UnRegisterDeviceCredentialResponse, <-chan error) {
	responseChan := make(chan *UnRegisterDeviceCredentialResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UnRegisterDeviceCredential(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UnRegisterDeviceCredentialWithCallback invokes the onsmqtt.UnRegisterDeviceCredential API asynchronously
func (client *Client) UnRegisterDeviceCredentialWithCallback(request *UnRegisterDeviceCredentialRequest, callback func(response *UnRegisterDeviceCredentialResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UnRegisterDeviceCredentialResponse
		var err error
		defer close(result)
		response, err = client.UnRegisterDeviceCredential(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UnRegisterDeviceCredentialRequest is the request struct for api UnRegisterDeviceCredential
type UnRegisterDeviceCredentialRequest struct {
	*requests.RpcRequest
	ClientId   string `position:"Query" name:"ClientId"`
	InstanceId string `position:"Query" name:"InstanceId"`
}

// UnRegisterDeviceCredentialResponse is the response struct for api UnRegisterDeviceCredential
type UnRegisterDeviceCredentialResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUnRegisterDeviceCredentialRequest creates a request to invoke UnRegisterDeviceCredential API
func CreateUnRegisterDeviceCredentialRequest() (request *UnRegisterDeviceCredentialRequest) {
	request = &UnRegisterDeviceCredentialRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OnsMqtt", "2020-04-20", "UnRegisterDeviceCredential", "onsmqtt", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUnRegisterDeviceCredentialResponse creates a response to parse from UnRegisterDeviceCredential response
func CreateUnRegisterDeviceCredentialResponse() (response *UnRegisterDeviceCredentialResponse) {
	response = &UnRegisterDeviceCredentialResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
