package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteLiveStreamWatermarkRule invokes the live.DeleteLiveStreamWatermarkRule API synchronously
func (client *Client) DeleteLiveStreamWatermarkRule(request *DeleteLiveStreamWatermarkRuleRequest) (response *DeleteLiveStreamWatermarkRuleResponse, err error) {
	response = CreateDeleteLiveStreamWatermarkRuleResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteLiveStreamWatermarkRuleWithChan invokes the live.DeleteLiveStreamWatermarkRule API asynchronously
func (client *Client) DeleteLiveStreamWatermarkRuleWithChan(request *DeleteLiveStreamWatermarkRuleRequest) (<-chan *DeleteLiveStreamWatermarkRuleResponse, <-chan error) {
	responseChan := make(chan *DeleteLiveStreamWatermarkRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteLiveStreamWatermarkRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteLiveStreamWatermarkRuleWithCallback invokes the live.DeleteLiveStreamWatermarkRule API asynchronously
func (client *Client) DeleteLiveStreamWatermarkRuleWithCallback(request *DeleteLiveStreamWatermarkRuleRequest, callback func(response *DeleteLiveStreamWatermarkRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteLiveStreamWatermarkRuleResponse
		var err error
		defer close(result)
		response, err = client.DeleteLiveStreamWatermarkRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteLiveStreamWatermarkRuleRequest is the request struct for api DeleteLiveStreamWatermarkRule
type DeleteLiveStreamWatermarkRuleRequest struct {
	*requests.RpcRequest
	Stream  string           `position:"Query" name:"Stream"`
	App     string           `position:"Query" name:"App"`
	OwnerId requests.Integer `position:"Query" name:"OwnerId"`
	Domain  string           `position:"Query" name:"Domain"`
	RuleId  string           `position:"Query" name:"RuleId"`
}

// DeleteLiveStreamWatermarkRuleResponse is the response struct for api DeleteLiveStreamWatermarkRule
type DeleteLiveStreamWatermarkRuleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteLiveStreamWatermarkRuleRequest creates a request to invoke DeleteLiveStreamWatermarkRule API
func CreateDeleteLiveStreamWatermarkRuleRequest() (request *DeleteLiveStreamWatermarkRuleRequest) {
	request = &DeleteLiveStreamWatermarkRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DeleteLiveStreamWatermarkRule", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteLiveStreamWatermarkRuleResponse creates a response to parse from DeleteLiveStreamWatermarkRule response
func CreateDeleteLiveStreamWatermarkRuleResponse() (response *DeleteLiveStreamWatermarkRuleResponse) {
	response = &DeleteLiveStreamWatermarkRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
