package linkwan

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListGatewayTransferFlowStats invokes the linkwan.ListGatewayTransferFlowStats API synchronously
func (client *Client) ListGatewayTransferFlowStats(request *ListGatewayTransferFlowStatsRequest) (response *ListGatewayTransferFlowStatsResponse, err error) {
	response = CreateListGatewayTransferFlowStatsResponse()
	err = client.DoAction(request, response)
	return
}

// ListGatewayTransferFlowStatsWithChan invokes the linkwan.ListGatewayTransferFlowStats API asynchronously
func (client *Client) ListGatewayTransferFlowStatsWithChan(request *ListGatewayTransferFlowStatsRequest) (<-chan *ListGatewayTransferFlowStatsResponse, <-chan error) {
	responseChan := make(chan *ListGatewayTransferFlowStatsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListGatewayTransferFlowStats(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListGatewayTransferFlowStatsWithCallback invokes the linkwan.ListGatewayTransferFlowStats API asynchronously
func (client *Client) ListGatewayTransferFlowStatsWithCallback(request *ListGatewayTransferFlowStatsRequest, callback func(response *ListGatewayTransferFlowStatsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListGatewayTransferFlowStatsResponse
		var err error
		defer close(result)
		response, err = client.ListGatewayTransferFlowStats(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListGatewayTransferFlowStatsRequest is the request struct for api ListGatewayTransferFlowStats
type ListGatewayTransferFlowStatsRequest struct {
	*requests.RpcRequest
	EndMillis        requests.Integer `position:"Query" name:"EndMillis"`
	IotInstanceId    string           `position:"Query" name:"IotInstanceId"`
	TimeIntervalUnit string           `position:"Query" name:"TimeIntervalUnit"`
	GwEui            string           `position:"Query" name:"GwEui"`
	ApiProduct       string           `position:"Body" name:"ApiProduct"`
	ApiRevision      string           `position:"Body" name:"ApiRevision"`
	BeginMillis      requests.Integer `position:"Query" name:"BeginMillis"`
}

// ListGatewayTransferFlowStatsResponse is the response struct for api ListGatewayTransferFlowStats
type ListGatewayTransferFlowStatsResponse struct {
	*responses.BaseResponse
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Success   bool       `json:"Success" xml:"Success"`
	Data      []FlowStat `json:"Data" xml:"Data"`
}

// CreateListGatewayTransferFlowStatsRequest creates a request to invoke ListGatewayTransferFlowStats API
func CreateListGatewayTransferFlowStatsRequest() (request *ListGatewayTransferFlowStatsRequest) {
	request = &ListGatewayTransferFlowStatsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("LinkWAN", "2019-03-01", "ListGatewayTransferFlowStats", "linkwan", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListGatewayTransferFlowStatsResponse creates a response to parse from ListGatewayTransferFlowStats response
func CreateListGatewayTransferFlowStatsResponse() (response *ListGatewayTransferFlowStatsResponse) {
	response = &ListGatewayTransferFlowStatsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
