package foas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetClusterQueueInfo invokes the foas.GetClusterQueueInfo API synchronously
func (client *Client) GetClusterQueueInfo(request *GetClusterQueueInfoRequest) (response *GetClusterQueueInfoResponse, err error) {
	response = CreateGetClusterQueueInfoResponse()
	err = client.DoAction(request, response)
	return
}

// GetClusterQueueInfoWithChan invokes the foas.GetClusterQueueInfo API asynchronously
func (client *Client) GetClusterQueueInfoWithChan(request *GetClusterQueueInfoRequest) (<-chan *GetClusterQueueInfoResponse, <-chan error) {
	responseChan := make(chan *GetClusterQueueInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetClusterQueueInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetClusterQueueInfoWithCallback invokes the foas.GetClusterQueueInfo API asynchronously
func (client *Client) GetClusterQueueInfoWithCallback(request *GetClusterQueueInfoRequest, callback func(response *GetClusterQueueInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetClusterQueueInfoResponse
		var err error
		defer close(result)
		response, err = client.GetClusterQueueInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetClusterQueueInfoRequest is the request struct for api GetClusterQueueInfo
type GetClusterQueueInfoRequest struct {
	*requests.RoaRequest
	ClusterId string `position:"Path" name:"clusterId"`
}

// GetClusterQueueInfoResponse is the response struct for api GetClusterQueueInfo
type GetClusterQueueInfoResponse struct {
	*responses.BaseResponse
	RequestId string                      `json:"RequestId" xml:"RequestId"`
	Queues    QueuesInGetClusterQueueInfo `json:"Queues" xml:"Queues"`
}

// CreateGetClusterQueueInfoRequest creates a request to invoke GetClusterQueueInfo API
func CreateGetClusterQueueInfoRequest() (request *GetClusterQueueInfoRequest) {
	request = &GetClusterQueueInfoRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("foas", "2018-11-11", "GetClusterQueueInfo", "/api/v2/clusters/[clusterId]/queueinfo", "foas", "openAPI")
	request.Method = requests.GET
	return
}

// CreateGetClusterQueueInfoResponse creates a response to parse from GetClusterQueueInfo response
func CreateGetClusterQueueInfoResponse() (response *GetClusterQueueInfoResponse) {
	response = &GetClusterQueueInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
