package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteDcdnDeliverTask invokes the dcdn.DeleteDcdnDeliverTask API synchronously
func (client *Client) DeleteDcdnDeliverTask(request *DeleteDcdnDeliverTaskRequest) (response *DeleteDcdnDeliverTaskResponse, err error) {
	response = CreateDeleteDcdnDeliverTaskResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteDcdnDeliverTaskWithChan invokes the dcdn.DeleteDcdnDeliverTask API asynchronously
func (client *Client) DeleteDcdnDeliverTaskWithChan(request *DeleteDcdnDeliverTaskRequest) (<-chan *DeleteDcdnDeliverTaskResponse, <-chan error) {
	responseChan := make(chan *DeleteDcdnDeliverTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteDcdnDeliverTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteDcdnDeliverTaskWithCallback invokes the dcdn.DeleteDcdnDeliverTask API asynchronously
func (client *Client) DeleteDcdnDeliverTaskWithCallback(request *DeleteDcdnDeliverTaskRequest, callback func(response *DeleteDcdnDeliverTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteDcdnDeliverTaskResponse
		var err error
		defer close(result)
		response, err = client.DeleteDcdnDeliverTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteDcdnDeliverTaskRequest is the request struct for api DeleteDcdnDeliverTask
type DeleteDcdnDeliverTaskRequest struct {
	*requests.RpcRequest
	DeliverId requests.Integer `position:"Query" name:"DeliverId"`
	OwnerId   requests.Integer `position:"Query" name:"OwnerId"`
}

// DeleteDcdnDeliverTaskResponse is the response struct for api DeleteDcdnDeliverTask
type DeleteDcdnDeliverTaskResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteDcdnDeliverTaskRequest creates a request to invoke DeleteDcdnDeliverTask API
func CreateDeleteDcdnDeliverTaskRequest() (request *DeleteDcdnDeliverTaskRequest) {
	request = &DeleteDcdnDeliverTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DeleteDcdnDeliverTask", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteDcdnDeliverTaskResponse creates a response to parse from DeleteDcdnDeliverTask response
func CreateDeleteDcdnDeliverTaskResponse() (response *DeleteDcdnDeliverTaskResponse) {
	response = &DeleteDcdnDeliverTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
