package afs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AnalyzeNvc invokes the afs.AnalyzeNvc API synchronously
// api document: https://help.aliyun.com/api/afs/analyzenvc.html
func (client *Client) AnalyzeNvc(request *AnalyzeNvcRequest) (response *AnalyzeNvcResponse, err error) {
	response = CreateAnalyzeNvcResponse()
	err = client.DoAction(request, response)
	return
}

// AnalyzeNvcWithChan invokes the afs.AnalyzeNvc API asynchronously
// api document: https://help.aliyun.com/api/afs/analyzenvc.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AnalyzeNvcWithChan(request *AnalyzeNvcRequest) (<-chan *AnalyzeNvcResponse, <-chan error) {
	responseChan := make(chan *AnalyzeNvcResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AnalyzeNvc(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AnalyzeNvcWithCallback invokes the afs.AnalyzeNvc API asynchronously
// api document: https://help.aliyun.com/api/afs/analyzenvc.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AnalyzeNvcWithCallback(request *AnalyzeNvcRequest, callback func(response *AnalyzeNvcResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AnalyzeNvcResponse
		var err error
		defer close(result)
		response, err = client.AnalyzeNvc(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AnalyzeNvcRequest is the request struct for api AnalyzeNvc
type AnalyzeNvcRequest struct {
	*requests.RpcRequest
	SourceIp     string `position:"Query" name:"SourceIp"`
	Data         string `position:"Query" name:"Data"`
	ScoreJsonStr string `position:"Query" name:"ScoreJsonStr"`
}

// AnalyzeNvcResponse is the response struct for api AnalyzeNvc
type AnalyzeNvcResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	BizCode   string `json:"BizCode" xml:"BizCode"`
}

// CreateAnalyzeNvcRequest creates a request to invoke AnalyzeNvc API
func CreateAnalyzeNvcRequest() (request *AnalyzeNvcRequest) {
	request = &AnalyzeNvcRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("afs", "2018-01-12", "AnalyzeNvc", "afs", "openAPI")
	return
}

// CreateAnalyzeNvcResponse creates a response to parse from AnalyzeNvc response
func CreateAnalyzeNvcResponse() (response *AnalyzeNvcResponse) {
	response = &AnalyzeNvcResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
