package teststyleattribute

import (
	_ "embed"
	"fmt"
	"testing"

	"github.com/a-h/templ"
	"github.com/a-h/templ/generator/htmldiff"
)

//go:embed expected.html
var expected string

func Test(t *testing.T) {
	var stringCSS = "background-color:blue;color:red"
	var safeCSS = templ.SafeCSS("background-color:blue;color:red;")
	var mapStringString = map[string]string{
		"color":            "red",
		"background-color": "blue",
	}
	var mapStringSafeCSSProperty = map[string]templ.SafeCSSProperty{
		"color":            templ.SafeCSSProperty("red"),
		"background-color": templ.SafeCSSProperty("blue"),
	}
	var kvStringStringSlice = []templ.KeyValue[string, string]{
		templ.KV("background-color", "blue"),
		templ.KV("color", "red"),
	}
	var kvStringBoolSlice = []templ.KeyValue[string, bool]{
		templ.KV("background-color:blue", true),
		templ.KV("color:red", true),
		templ.KV("color:blue", false),
	}
	var kvSafeCSSBoolSlice = []templ.KeyValue[templ.SafeCSS, bool]{
		templ.KV(templ.SafeCSS("background-color:blue"), true),
		templ.KV(templ.SafeCSS("color:red"), true),
		templ.KV(templ.SafeCSS("color:blue"), false),
	}

	tests := []any{
		stringCSS,
		safeCSS,
		mapStringString,
		mapStringSafeCSSProperty,
		kvStringStringSlice,
		kvStringBoolSlice,
		kvSafeCSSBoolSlice,
	}

	for _, test := range tests {
		t.Run(fmt.Sprintf("%T", test), func(t *testing.T) {
			component := Button(test, "Click me")

			diff, err := htmldiff.Diff(component, expected)
			if err != nil {
				t.Fatal(err)
			}
			if diff != "" {
				t.Error(diff)
			}
		})
	}
}
