// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.31.0
// 	protoc        v4.23.2
// source: google/cloud/talent/v4beta1/filters.proto

package talentpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	latlng "google.golang.org/genproto/googleapis/type/latlng"
	timeofday "google.golang.org/genproto/googleapis/type/timeofday"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Specify whether to include telecommute jobs.
type LocationFilter_TelecommutePreference int32

const (
	// Default value if the telecommute preference isn't specified.
	LocationFilter_TELECOMMUTE_PREFERENCE_UNSPECIFIED LocationFilter_TelecommutePreference = 0
	// Deprecated: Ignore telecommute status of jobs. Use
	// TELECOMMUTE_JOBS_EXCLUDED if want to exclude telecommute jobs.
	//
	// Deprecated: Marked as deprecated in google/cloud/talent/v4beta1/filters.proto.
	LocationFilter_TELECOMMUTE_EXCLUDED LocationFilter_TelecommutePreference = 1
	// Allow telecommute jobs.
	LocationFilter_TELECOMMUTE_ALLOWED LocationFilter_TelecommutePreference = 2
	// Exclude telecommute jobs.
	LocationFilter_TELECOMMUTE_JOBS_EXCLUDED LocationFilter_TelecommutePreference = 3
)

// Enum value maps for LocationFilter_TelecommutePreference.
var (
	LocationFilter_TelecommutePreference_name = map[int32]string{
		0: "TELECOMMUTE_PREFERENCE_UNSPECIFIED",
		1: "TELECOMMUTE_EXCLUDED",
		2: "TELECOMMUTE_ALLOWED",
		3: "TELECOMMUTE_JOBS_EXCLUDED",
	}
	LocationFilter_TelecommutePreference_value = map[string]int32{
		"TELECOMMUTE_PREFERENCE_UNSPECIFIED": 0,
		"TELECOMMUTE_EXCLUDED":               1,
		"TELECOMMUTE_ALLOWED":                2,
		"TELECOMMUTE_JOBS_EXCLUDED":          3,
	}
)

func (x LocationFilter_TelecommutePreference) Enum() *LocationFilter_TelecommutePreference {
	p := new(LocationFilter_TelecommutePreference)
	*p = x
	return p
}

func (x LocationFilter_TelecommutePreference) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LocationFilter_TelecommutePreference) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_talent_v4beta1_filters_proto_enumTypes[0].Descriptor()
}

func (LocationFilter_TelecommutePreference) Type() protoreflect.EnumType {
	return &file_google_cloud_talent_v4beta1_filters_proto_enumTypes[0]
}

func (x LocationFilter_TelecommutePreference) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LocationFilter_TelecommutePreference.Descriptor instead.
func (LocationFilter_TelecommutePreference) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4beta1_filters_proto_rawDescGZIP(), []int{1, 0}
}

// Specify the type of filtering.
type CompensationFilter_FilterType int32

const (
	// Filter type unspecified. Position holder, INVALID, should never be used.
	CompensationFilter_FILTER_TYPE_UNSPECIFIED CompensationFilter_FilterType = 0
	// Filter by `base compensation entry's` unit. A job is a match if and
	// only if the job contains a base CompensationEntry and the base
	// CompensationEntry's unit matches provided
	// [units][google.cloud.talent.v4beta1.CompensationFilter.units]. Populate
	// one or more
	// [units][google.cloud.talent.v4beta1.CompensationFilter.units].
	//
	// See
	// [CompensationInfo.CompensationEntry][google.cloud.talent.v4beta1.CompensationInfo.CompensationEntry]
	// for definition of base compensation entry.
	CompensationFilter_UNIT_ONLY CompensationFilter_FilterType = 1
	// Filter by `base compensation entry's` unit and amount / range. A job
	// is a match if and only if the job contains a base CompensationEntry, and
	// the base entry's unit matches provided
	// [CompensationUnit][google.cloud.talent.v4beta1.CompensationInfo.CompensationUnit]
	// and amount or range overlaps with provided
	// [CompensationRange][google.cloud.talent.v4beta1.CompensationInfo.CompensationRange].
	//
	// See
	// [CompensationInfo.CompensationEntry][google.cloud.talent.v4beta1.CompensationInfo.CompensationEntry]
	// for definition of base compensation entry.
	//
	// Set exactly one
	// [units][google.cloud.talent.v4beta1.CompensationFilter.units] and
	// populate [range][google.cloud.talent.v4beta1.CompensationFilter.range].
	CompensationFilter_UNIT_AND_AMOUNT CompensationFilter_FilterType = 2
	// Filter by annualized base compensation amount and `base compensation
	// entry's` unit. Populate
	// [range][google.cloud.talent.v4beta1.CompensationFilter.range] and zero or
	// more [units][google.cloud.talent.v4beta1.CompensationFilter.units].
	CompensationFilter_ANNUALIZED_BASE_AMOUNT CompensationFilter_FilterType = 3
	// Filter by annualized total compensation amount and `base compensation
	// entry's` unit . Populate
	// [range][google.cloud.talent.v4beta1.CompensationFilter.range] and zero or
	// more [units][google.cloud.talent.v4beta1.CompensationFilter.units].
	CompensationFilter_ANNUALIZED_TOTAL_AMOUNT CompensationFilter_FilterType = 4
)

// Enum value maps for CompensationFilter_FilterType.
var (
	CompensationFilter_FilterType_name = map[int32]string{
		0: "FILTER_TYPE_UNSPECIFIED",
		1: "UNIT_ONLY",
		2: "UNIT_AND_AMOUNT",
		3: "ANNUALIZED_BASE_AMOUNT",
		4: "ANNUALIZED_TOTAL_AMOUNT",
	}
	CompensationFilter_FilterType_value = map[string]int32{
		"FILTER_TYPE_UNSPECIFIED": 0,
		"UNIT_ONLY":               1,
		"UNIT_AND_AMOUNT":         2,
		"ANNUALIZED_BASE_AMOUNT":  3,
		"ANNUALIZED_TOTAL_AMOUNT": 4,
	}
)

func (x CompensationFilter_FilterType) Enum() *CompensationFilter_FilterType {
	p := new(CompensationFilter_FilterType)
	*p = x
	return p
}

func (x CompensationFilter_FilterType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CompensationFilter_FilterType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_talent_v4beta1_filters_proto_enumTypes[1].Descriptor()
}

func (CompensationFilter_FilterType) Type() protoreflect.EnumType {
	return &file_google_cloud_talent_v4beta1_filters_proto_enumTypes[1]
}

func (x CompensationFilter_FilterType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CompensationFilter_FilterType.Descriptor instead.
func (CompensationFilter_FilterType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4beta1_filters_proto_rawDescGZIP(), []int{2, 0}
}

// The traffic density to use when calculating commute time.
type CommuteFilter_RoadTraffic int32

const (
	// Road traffic situation isn't specified.
	CommuteFilter_ROAD_TRAFFIC_UNSPECIFIED CommuteFilter_RoadTraffic = 0
	// Optimal commute time without considering any traffic impact.
	CommuteFilter_TRAFFIC_FREE CommuteFilter_RoadTraffic = 1
	// Commute time calculation takes in account the peak traffic impact.
	CommuteFilter_BUSY_HOUR CommuteFilter_RoadTraffic = 2
)

// Enum value maps for CommuteFilter_RoadTraffic.
var (
	CommuteFilter_RoadTraffic_name = map[int32]string{
		0: "ROAD_TRAFFIC_UNSPECIFIED",
		1: "TRAFFIC_FREE",
		2: "BUSY_HOUR",
	}
	CommuteFilter_RoadTraffic_value = map[string]int32{
		"ROAD_TRAFFIC_UNSPECIFIED": 0,
		"TRAFFIC_FREE":             1,
		"BUSY_HOUR":                2,
	}
)

func (x CommuteFilter_RoadTraffic) Enum() *CommuteFilter_RoadTraffic {
	p := new(CommuteFilter_RoadTraffic)
	*p = x
	return p
}

func (x CommuteFilter_RoadTraffic) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CommuteFilter_RoadTraffic) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_talent_v4beta1_filters_proto_enumTypes[2].Descriptor()
}

func (CommuteFilter_RoadTraffic) Type() protoreflect.EnumType {
	return &file_google_cloud_talent_v4beta1_filters_proto_enumTypes[2]
}

func (x CommuteFilter_RoadTraffic) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CommuteFilter_RoadTraffic.Descriptor instead.
func (CommuteFilter_RoadTraffic) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4beta1_filters_proto_rawDescGZIP(), []int{3, 0}
}

// The query required to perform a search query.
type JobQuery struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The query string that matches against the job title, description, and
	// location fields.
	//
	// The maximum number of allowed characters is 255.
	Query string `protobuf:"bytes,1,opt,name=query,proto3" json:"query,omitempty"`
	// The language code of [query][google.cloud.talent.v4beta1.JobQuery.query].
	// For example, "en-US". This field helps to better interpret the query.
	//
	// If a value isn't specified, the query language code is automatically
	// detected, which may not be accurate.
	//
	// Language code should be in BCP-47 format, such as "en-US" or "sr-Latn".
	// For more information, see
	// [Tags for Identifying Languages](https://tools.ietf.org/html/bcp47).
	QueryLanguageCode string `protobuf:"bytes,14,opt,name=query_language_code,json=queryLanguageCode,proto3" json:"query_language_code,omitempty"`
	// This filter specifies the company entities to search against.
	//
	// If a value isn't specified, jobs are searched for against all
	// companies.
	//
	// If multiple values are specified, jobs are searched against the
	// companies specified.
	//
	// The format is
	// "projects/{project_id}/tenants/{tenant_id}/companies/{company_id}". For
	// example, "projects/foo/tenants/bar/companies/baz".
	//
	// If tenant id is unspecified, the default tenant is used. For
	// example, "projects/foo/companies/bar".
	//
	// At most 20 company filters are allowed.
	Companies []string `protobuf:"bytes,2,rep,name=companies,proto3" json:"companies,omitempty"`
	// The location filter specifies geo-regions containing the jobs to
	// search against. See
	// [LocationFilter][google.cloud.talent.v4beta1.LocationFilter] for more
	// information.
	//
	// If a location value isn't specified, jobs fitting the other search
	// criteria are retrieved regardless of where they're located.
	//
	// If multiple values are specified, jobs are retrieved from any of the
	// specified locations. If different values are specified for the
	// [LocationFilter.distance_in_miles][google.cloud.talent.v4beta1.LocationFilter.distance_in_miles]
	// parameter, the maximum provided distance is used for all locations.
	//
	// At most 5 location filters are allowed.
	LocationFilters []*LocationFilter `protobuf:"bytes,3,rep,name=location_filters,json=locationFilters,proto3" json:"location_filters,omitempty"`
	// The category filter specifies the categories of jobs to search against.
	// See [JobCategory][google.cloud.talent.v4beta1.JobCategory] for more
	// information.
	//
	// If a value isn't specified, jobs from any category are searched against.
	//
	// If multiple values are specified, jobs from any of the specified
	// categories are searched against.
	JobCategories []JobCategory `protobuf:"varint,4,rep,packed,name=job_categories,json=jobCategories,proto3,enum=google.cloud.talent.v4beta1.JobCategory" json:"job_categories,omitempty"`
	// Allows filtering jobs by commute time with different travel methods (for
	//  example, driving or public transit).
	//
	// Note: This only works when you specify a
	// [CommuteMethod][google.cloud.talent.v4beta1.CommuteMethod]. In this case,
	// [location_filters][google.cloud.talent.v4beta1.JobQuery.location_filters]
	// is ignored.
	//
	//  Currently we don't support sorting by commute time.
	CommuteFilter *CommuteFilter `protobuf:"bytes,5,opt,name=commute_filter,json=commuteFilter,proto3" json:"commute_filter,omitempty"`
	// This filter specifies the company
	// [Company.display_name][google.cloud.talent.v4beta1.Company.display_name] of
	// the jobs to search against. The company name must match the value exactly.
	//
	// Alternatively, the value being searched for can be wrapped in different
	// match operators.
	// `SUBSTRING_MATCH([value])`
	// The company name must contain a case insensitive substring match of the
	// value. Using this function may increase latency.
	//
	// Sample Value: `SUBSTRING_MATCH(google)`
	//
	// `MULTI_WORD_TOKEN_MATCH([value])`
	// The value will be treated as a multi word token and the company name must
	// contain a case insensitive match of the value. Using this function may
	// increase latency.
	//
	// Sample Value: `MULTI_WORD_TOKEN_MATCH(google)`
	//
	// If a value isn't specified, jobs within the search results are
	// associated with any company.
	//
	// If multiple values are specified, jobs within the search results may be
	// associated with any of the specified companies.
	//
	// At most 20 company display name filters are allowed.
	CompanyDisplayNames []string `protobuf:"bytes,6,rep,name=company_display_names,json=companyDisplayNames,proto3" json:"company_display_names,omitempty"`
	// This search filter is applied only to
	// [Job.compensation_info][google.cloud.talent.v4beta1.Job.compensation_info].
	// For example, if the filter is specified as "Hourly job with per-hour
	// compensation > $15", only jobs meeting these criteria are searched. If a
	// filter isn't defined, all open jobs are searched.
	CompensationFilter *CompensationFilter `protobuf:"bytes,7,opt,name=compensation_filter,json=compensationFilter,proto3" json:"compensation_filter,omitempty"`
	// This filter specifies a structured syntax to match against the
	// [Job.custom_attributes][google.cloud.talent.v4beta1.Job.custom_attributes]
	// marked as `filterable`.
	//
	// The syntax for this expression is a subset of SQL syntax.
	//
	// Supported operators are: `=`, `!=`, `<`, `<=`, `>`, and `>=` where the
	// left of the operator is a custom field key and the right of the operator
	// is a number or a quoted string. You must escape backslash (\\) and
	// quote (\") characters.
	//
	// Supported functions are `LOWER([field_name])` to
	// perform a case insensitive match and `EMPTY([field_name])` to filter on the
	// existence of a key.
	//
	// Boolean expressions (AND/OR/NOT) are supported up to 3 levels of
	// nesting (for example, "((A AND B AND C) OR NOT D) AND E"), a maximum of 100
	// comparisons or functions are allowed in the expression. The expression
	// must be < 10000 bytes in length.
	//
	// Sample Query:
	// `(LOWER(driving_license)="class \"a\"" OR EMPTY(driving_license)) AND
	// driving_years > 10`
	CustomAttributeFilter string `protobuf:"bytes,8,opt,name=custom_attribute_filter,json=customAttributeFilter,proto3" json:"custom_attribute_filter,omitempty"`
	// This flag controls the spell-check feature. If false, the
	// service attempts to correct a misspelled query,
	// for example, "enginee" is corrected to "engineer".
	//
	// Defaults to false: a spell check is performed.
	DisableSpellCheck bool `protobuf:"varint,9,opt,name=disable_spell_check,json=disableSpellCheck,proto3" json:"disable_spell_check,omitempty"`
	// The employment type filter specifies the employment type of jobs to
	// search against, such as
	// [EmploymentType.FULL_TIME][google.cloud.talent.v4beta1.EmploymentType.FULL_TIME].
	//
	// If a value isn't specified, jobs in the search results includes any
	// employment type.
	//
	// If multiple values are specified, jobs in the search results include
	// any of the specified employment types.
	EmploymentTypes []EmploymentType `protobuf:"varint,10,rep,packed,name=employment_types,json=employmentTypes,proto3,enum=google.cloud.talent.v4beta1.EmploymentType" json:"employment_types,omitempty"`
	// This filter specifies the locale of jobs to search against,
	// for example, "en-US".
	//
	// If a value isn't specified, the search results can contain jobs in any
	// locale.
	//
	//
	// Language codes should be in BCP-47 format, such as "en-US" or "sr-Latn".
	// For more information, see
	// [Tags for Identifying Languages](https://tools.ietf.org/html/bcp47).
	//
	// At most 10 language code filters are allowed.
	LanguageCodes []string `protobuf:"bytes,11,rep,name=language_codes,json=languageCodes,proto3" json:"language_codes,omitempty"`
	// Jobs published within a range specified by this filter are searched
	// against.
	PublishTimeRange *TimestampRange `protobuf:"bytes,12,opt,name=publish_time_range,json=publishTimeRange,proto3" json:"publish_time_range,omitempty"`
	// This filter specifies a list of job names to be excluded during search.
	//
	// At most 400 excluded job names are allowed.
	ExcludedJobs []string `protobuf:"bytes,13,rep,name=excluded_jobs,json=excludedJobs,proto3" json:"excluded_jobs,omitempty"`
}

func (x *JobQuery) Reset() {
	*x = JobQuery{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_talent_v4beta1_filters_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JobQuery) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JobQuery) ProtoMessage() {}

func (x *JobQuery) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_talent_v4beta1_filters_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JobQuery.ProtoReflect.Descriptor instead.
func (*JobQuery) Descriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4beta1_filters_proto_rawDescGZIP(), []int{0}
}

func (x *JobQuery) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

func (x *JobQuery) GetQueryLanguageCode() string {
	if x != nil {
		return x.QueryLanguageCode
	}
	return ""
}

func (x *JobQuery) GetCompanies() []string {
	if x != nil {
		return x.Companies
	}
	return nil
}

func (x *JobQuery) GetLocationFilters() []*LocationFilter {
	if x != nil {
		return x.LocationFilters
	}
	return nil
}

func (x *JobQuery) GetJobCategories() []JobCategory {
	if x != nil {
		return x.JobCategories
	}
	return nil
}

func (x *JobQuery) GetCommuteFilter() *CommuteFilter {
	if x != nil {
		return x.CommuteFilter
	}
	return nil
}

func (x *JobQuery) GetCompanyDisplayNames() []string {
	if x != nil {
		return x.CompanyDisplayNames
	}
	return nil
}

func (x *JobQuery) GetCompensationFilter() *CompensationFilter {
	if x != nil {
		return x.CompensationFilter
	}
	return nil
}

func (x *JobQuery) GetCustomAttributeFilter() string {
	if x != nil {
		return x.CustomAttributeFilter
	}
	return ""
}

func (x *JobQuery) GetDisableSpellCheck() bool {
	if x != nil {
		return x.DisableSpellCheck
	}
	return false
}

func (x *JobQuery) GetEmploymentTypes() []EmploymentType {
	if x != nil {
		return x.EmploymentTypes
	}
	return nil
}

func (x *JobQuery) GetLanguageCodes() []string {
	if x != nil {
		return x.LanguageCodes
	}
	return nil
}

func (x *JobQuery) GetPublishTimeRange() *TimestampRange {
	if x != nil {
		return x.PublishTimeRange
	}
	return nil
}

func (x *JobQuery) GetExcludedJobs() []string {
	if x != nil {
		return x.ExcludedJobs
	}
	return nil
}

// Geographic region of the search.
type LocationFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The address name, such as "Mountain View" or "Bay Area".
	Address string `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
	// CLDR region code of the country/region. This field may be used in two ways:
	//
	// 1) If telecommute preference is not set, this field is used address
	// ambiguity of the user-input address. For example, "Liverpool" may refer to
	// "Liverpool, NY, US" or "Liverpool, UK". This region code biases the
	// address resolution toward a specific country or territory. If this field is
	// not set, address resolution is biased toward the United States by default.
	//
	// 2) If telecommute preference is set to TELECOMMUTE_ALLOWED, the
	// telecommute location filter will be limited to the region specified in this
	// field. If this field is not set, the telecommute job locations will not be
	//
	// See
	// https://unicode-org.github.io/cldr-staging/charts/latest/supplemental/territory_information.html
	// for details. Example: "CH" for Switzerland.
	RegionCode string `protobuf:"bytes,2,opt,name=region_code,json=regionCode,proto3" json:"region_code,omitempty"`
	// The latitude and longitude of the geographic center to search from. This
	// field is ignored if `address` is provided.
	LatLng *latlng.LatLng `protobuf:"bytes,3,opt,name=lat_lng,json=latLng,proto3" json:"lat_lng,omitempty"`
	// The distance_in_miles is applied when the location being searched for is
	// identified as a city or smaller. This field is ignored if the location
	// being searched for is a state or larger.
	DistanceInMiles float64 `protobuf:"fixed64,4,opt,name=distance_in_miles,json=distanceInMiles,proto3" json:"distance_in_miles,omitempty"`
	// Allows the client to return jobs without a
	// set location, specifically, telecommuting jobs (telecommuting is considered
	// by the service as a special location).
	// [Job.posting_region][google.cloud.talent.v4beta1.Job.posting_region]
	// indicates if a job permits telecommuting. If this field is set to
	// [TelecommutePreference.TELECOMMUTE_ALLOWED][google.cloud.talent.v4beta1.LocationFilter.TelecommutePreference.TELECOMMUTE_ALLOWED],
	// telecommuting jobs are searched, and
	// [address][google.cloud.talent.v4beta1.LocationFilter.address] and
	// [lat_lng][google.cloud.talent.v4beta1.LocationFilter.lat_lng] are ignored.
	// If not set or set to
	// [TelecommutePreference.TELECOMMUTE_EXCLUDED][google.cloud.talent.v4beta1.LocationFilter.TelecommutePreference.TELECOMMUTE_EXCLUDED],
	// the telecommute status of the jobs is ignored. Jobs that have
	// [PostingRegion.TELECOMMUTE][google.cloud.talent.v4beta1.PostingRegion.TELECOMMUTE]
	// and have additional
	// [Job.addresses][google.cloud.talent.v4beta1.Job.addresses] may still be
	// matched based on other location filters using
	// [address][google.cloud.talent.v4beta1.LocationFilter.address] or
	// [latlng][].
	//
	// This filter can be used by itself to search exclusively for telecommuting
	// jobs, or it can be combined with another location
	// filter to search for a combination of job locations,
	// such as "Mountain View" or "telecommuting" jobs. However, when used in
	// combination with other location filters, telecommuting jobs can be
	// treated as less relevant than other jobs in the search response.
	//
	// This field is only used for job search requests.
	TelecommutePreference LocationFilter_TelecommutePreference `protobuf:"varint,5,opt,name=telecommute_preference,json=telecommutePreference,proto3,enum=google.cloud.talent.v4beta1.LocationFilter_TelecommutePreference" json:"telecommute_preference,omitempty"`
	// Whether to apply negation to the filter so profiles matching the filter
	// are excluded.
	Negated bool `protobuf:"varint,6,opt,name=negated,proto3" json:"negated,omitempty"`
}

func (x *LocationFilter) Reset() {
	*x = LocationFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_talent_v4beta1_filters_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LocationFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LocationFilter) ProtoMessage() {}

func (x *LocationFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_talent_v4beta1_filters_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LocationFilter.ProtoReflect.Descriptor instead.
func (*LocationFilter) Descriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4beta1_filters_proto_rawDescGZIP(), []int{1}
}

func (x *LocationFilter) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

func (x *LocationFilter) GetRegionCode() string {
	if x != nil {
		return x.RegionCode
	}
	return ""
}

func (x *LocationFilter) GetLatLng() *latlng.LatLng {
	if x != nil {
		return x.LatLng
	}
	return nil
}

func (x *LocationFilter) GetDistanceInMiles() float64 {
	if x != nil {
		return x.DistanceInMiles
	}
	return 0
}

func (x *LocationFilter) GetTelecommutePreference() LocationFilter_TelecommutePreference {
	if x != nil {
		return x.TelecommutePreference
	}
	return LocationFilter_TELECOMMUTE_PREFERENCE_UNSPECIFIED
}

func (x *LocationFilter) GetNegated() bool {
	if x != nil {
		return x.Negated
	}
	return false
}

// Filter on job compensation type and amount.
type CompensationFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Type of filter.
	Type CompensationFilter_FilterType `protobuf:"varint,1,opt,name=type,proto3,enum=google.cloud.talent.v4beta1.CompensationFilter_FilterType" json:"type,omitempty"`
	// Required. Specify desired `base compensation entry's`
	// [CompensationInfo.CompensationUnit][google.cloud.talent.v4beta1.CompensationInfo.CompensationUnit].
	Units []CompensationInfo_CompensationUnit `protobuf:"varint,2,rep,packed,name=units,proto3,enum=google.cloud.talent.v4beta1.CompensationInfo_CompensationUnit" json:"units,omitempty"`
	// Compensation range.
	Range *CompensationInfo_CompensationRange `protobuf:"bytes,3,opt,name=range,proto3" json:"range,omitempty"`
	// If set to true, jobs with unspecified compensation range fields are
	// included.
	IncludeJobsWithUnspecifiedCompensationRange bool `protobuf:"varint,4,opt,name=include_jobs_with_unspecified_compensation_range,json=includeJobsWithUnspecifiedCompensationRange,proto3" json:"include_jobs_with_unspecified_compensation_range,omitempty"`
}

func (x *CompensationFilter) Reset() {
	*x = CompensationFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_talent_v4beta1_filters_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CompensationFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CompensationFilter) ProtoMessage() {}

func (x *CompensationFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_talent_v4beta1_filters_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CompensationFilter.ProtoReflect.Descriptor instead.
func (*CompensationFilter) Descriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4beta1_filters_proto_rawDescGZIP(), []int{2}
}

func (x *CompensationFilter) GetType() CompensationFilter_FilterType {
	if x != nil {
		return x.Type
	}
	return CompensationFilter_FILTER_TYPE_UNSPECIFIED
}

func (x *CompensationFilter) GetUnits() []CompensationInfo_CompensationUnit {
	if x != nil {
		return x.Units
	}
	return nil
}

func (x *CompensationFilter) GetRange() *CompensationInfo_CompensationRange {
	if x != nil {
		return x.Range
	}
	return nil
}

func (x *CompensationFilter) GetIncludeJobsWithUnspecifiedCompensationRange() bool {
	if x != nil {
		return x.IncludeJobsWithUnspecifiedCompensationRange
	}
	return false
}

// Parameters needed for commute search.
type CommuteFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The method of transportation to calculate the commute time for.
	CommuteMethod CommuteMethod `protobuf:"varint,1,opt,name=commute_method,json=commuteMethod,proto3,enum=google.cloud.talent.v4beta1.CommuteMethod" json:"commute_method,omitempty"`
	// Required. The latitude and longitude of the location to calculate the
	// commute time from.
	StartCoordinates *latlng.LatLng `protobuf:"bytes,2,opt,name=start_coordinates,json=startCoordinates,proto3" json:"start_coordinates,omitempty"`
	// Required. The maximum travel time in seconds. The maximum allowed value is
	// `3600s` (one hour). Format is `123s`.
	TravelDuration *durationpb.Duration `protobuf:"bytes,3,opt,name=travel_duration,json=travelDuration,proto3" json:"travel_duration,omitempty"`
	// If `true`, jobs without street level addresses may also be returned.
	// For city level addresses, the city center is used. For state and coarser
	// level addresses, text matching is used.
	// If this field is set to `false` or isn't specified, only jobs that include
	// street level addresses will be returned by commute search.
	AllowImpreciseAddresses bool `protobuf:"varint,4,opt,name=allow_imprecise_addresses,json=allowImpreciseAddresses,proto3" json:"allow_imprecise_addresses,omitempty"`
	// Traffic factor to take into account while searching by commute.
	//
	// Types that are assignable to TrafficOption:
	//	*CommuteFilter_RoadTraffic_
	//	*CommuteFilter_DepartureTime
	TrafficOption isCommuteFilter_TrafficOption `protobuf_oneof:"traffic_option"`
}

func (x *CommuteFilter) Reset() {
	*x = CommuteFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_talent_v4beta1_filters_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommuteFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommuteFilter) ProtoMessage() {}

func (x *CommuteFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_talent_v4beta1_filters_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommuteFilter.ProtoReflect.Descriptor instead.
func (*CommuteFilter) Descriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4beta1_filters_proto_rawDescGZIP(), []int{3}
}

func (x *CommuteFilter) GetCommuteMethod() CommuteMethod {
	if x != nil {
		return x.CommuteMethod
	}
	return CommuteMethod_COMMUTE_METHOD_UNSPECIFIED
}

func (x *CommuteFilter) GetStartCoordinates() *latlng.LatLng {
	if x != nil {
		return x.StartCoordinates
	}
	return nil
}

func (x *CommuteFilter) GetTravelDuration() *durationpb.Duration {
	if x != nil {
		return x.TravelDuration
	}
	return nil
}

func (x *CommuteFilter) GetAllowImpreciseAddresses() bool {
	if x != nil {
		return x.AllowImpreciseAddresses
	}
	return false
}

func (m *CommuteFilter) GetTrafficOption() isCommuteFilter_TrafficOption {
	if m != nil {
		return m.TrafficOption
	}
	return nil
}

func (x *CommuteFilter) GetRoadTraffic() CommuteFilter_RoadTraffic {
	if x, ok := x.GetTrafficOption().(*CommuteFilter_RoadTraffic_); ok {
		return x.RoadTraffic
	}
	return CommuteFilter_ROAD_TRAFFIC_UNSPECIFIED
}

func (x *CommuteFilter) GetDepartureTime() *timeofday.TimeOfDay {
	if x, ok := x.GetTrafficOption().(*CommuteFilter_DepartureTime); ok {
		return x.DepartureTime
	}
	return nil
}

type isCommuteFilter_TrafficOption interface {
	isCommuteFilter_TrafficOption()
}

type CommuteFilter_RoadTraffic_ struct {
	// Specifies the traffic density to use when calculating commute time.
	RoadTraffic CommuteFilter_RoadTraffic `protobuf:"varint,5,opt,name=road_traffic,json=roadTraffic,proto3,enum=google.cloud.talent.v4beta1.CommuteFilter_RoadTraffic,oneof"`
}

type CommuteFilter_DepartureTime struct {
	// The departure time used to calculate traffic impact, represented as
	// [google.type.TimeOfDay][google.type.TimeOfDay] in local time zone.
	//
	// Currently traffic model is restricted to hour level resolution.
	DepartureTime *timeofday.TimeOfDay `protobuf:"bytes,6,opt,name=departure_time,json=departureTime,proto3,oneof"`
}

func (*CommuteFilter_RoadTraffic_) isCommuteFilter_TrafficOption() {}

func (*CommuteFilter_DepartureTime) isCommuteFilter_TrafficOption() {}

var File_google_cloud_talent_v4beta1_filters_proto protoreflect.FileDescriptor

var file_google_cloud_talent_v4beta1_filters_proto_rawDesc = []byte{
	0x0a, 0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x74,
	0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2f, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1b, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74,
	0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76,
	0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2f, 0x76,
	0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x18, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65,
	0x2f, 0x6c, 0x61, 0x74, 0x6c, 0x6e, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x6f,
	0x66, 0x64, 0x61, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xe7, 0x06, 0x0a, 0x08, 0x4a,
	0x6f, 0x62, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x12, 0x2e, 0x0a,
	0x13, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f,
	0x63, 0x6f, 0x64, 0x65, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x1c, 0x0a,
	0x09, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x6e, 0x69, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x09, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x6e, 0x69, 0x65, 0x73, 0x12, 0x56, 0x0a, 0x10, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x52, 0x0f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x73, 0x12, 0x4f, 0x0a, 0x0e, 0x6a, 0x6f, 0x62, 0x5f, 0x63, 0x61, 0x74, 0x65, 0x67,
	0x6f, 0x72, 0x69, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x28, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e,
	0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x43, 0x61, 0x74,
	0x65, 0x67, 0x6f, 0x72, 0x79, 0x52, 0x0d, 0x6a, 0x6f, 0x62, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f,
	0x72, 0x69, 0x65, 0x73, 0x12, 0x51, 0x0a, 0x0e, 0x63, 0x6f, 0x6d, 0x6d, 0x75, 0x74, 0x65, 0x5f,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65,
	0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x75,
	0x74, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x52, 0x0d, 0x63, 0x6f, 0x6d, 0x6d, 0x75, 0x74,
	0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x32, 0x0a, 0x15, 0x63, 0x6f, 0x6d, 0x70, 0x61,
	0x6e, 0x79, 0x5f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73,
	0x18, 0x06, 0x20, 0x03, 0x28, 0x09, 0x52, 0x13, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x6e, 0x79, 0x44,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x12, 0x60, 0x0a, 0x13, 0x63,
	0x6f, 0x6d, 0x70, 0x65, 0x6e, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76,
	0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x65, 0x6e, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x52, 0x12, 0x63, 0x6f, 0x6d, 0x70, 0x65,
	0x6e, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x36, 0x0a,
	0x17, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x65, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x15,
	0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x46,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x2e, 0x0a, 0x13, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65,
	0x5f, 0x73, 0x70, 0x65, 0x6c, 0x6c, 0x5f, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x18, 0x09, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x11, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x70, 0x65, 0x6c, 0x6c,
	0x43, 0x68, 0x65, 0x63, 0x6b, 0x12, 0x56, 0x0a, 0x10, 0x65, 0x6d, 0x70, 0x6c, 0x6f, 0x79, 0x6d,
	0x65, 0x6e, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0e, 0x32,
	0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74,
	0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x6d,
	0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0f, 0x65, 0x6d,
	0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x25, 0x0a,
	0x0e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x73, 0x18,
	0x0b, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43,
	0x6f, 0x64, 0x65, 0x73, 0x12, 0x59, 0x0a, 0x12, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x10, 0x70,
	0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x54, 0x69, 0x6d, 0x65, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12,
	0x23, 0x0a, 0x0d, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x64, 0x5f, 0x6a, 0x6f, 0x62, 0x73,
	0x18, 0x0d, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0c, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x64,
	0x4a, 0x6f, 0x62, 0x73, 0x22, 0xd1, 0x03, 0x0a, 0x0e, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x18, 0x0a, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65,
	0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73,
	0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x64, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x43, 0x6f,
	0x64, 0x65, 0x12, 0x2c, 0x0a, 0x07, 0x6c, 0x61, 0x74, 0x5f, 0x6c, 0x6e, 0x67, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70,
	0x65, 0x2e, 0x4c, 0x61, 0x74, 0x4c, 0x6e, 0x67, 0x52, 0x06, 0x6c, 0x61, 0x74, 0x4c, 0x6e, 0x67,
	0x12, 0x2a, 0x0a, 0x11, 0x64, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x6e, 0x5f,
	0x6d, 0x69, 0x6c, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x01, 0x52, 0x0f, 0x64, 0x69, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x6e, 0x4d, 0x69, 0x6c, 0x65, 0x73, 0x12, 0x78, 0x0a, 0x16,
	0x74, 0x65, 0x6c, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x75, 0x74, 0x65, 0x5f, 0x70, 0x72, 0x65, 0x66,
	0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x41, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65,
	0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e, 0x54, 0x65, 0x6c, 0x65, 0x63, 0x6f,
	0x6d, 0x6d, 0x75, 0x74, 0x65, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52,
	0x15, 0x74, 0x65, 0x6c, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x75, 0x74, 0x65, 0x50, 0x72, 0x65, 0x66,
	0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x6e, 0x65, 0x67, 0x61, 0x74, 0x65,
	0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x6e, 0x65, 0x67, 0x61, 0x74, 0x65, 0x64,
	0x22, 0x95, 0x01, 0x0a, 0x15, 0x54, 0x65, 0x6c, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x75, 0x74, 0x65,
	0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x26, 0x0a, 0x22, 0x54, 0x45,
	0x4c, 0x45, 0x43, 0x4f, 0x4d, 0x4d, 0x55, 0x54, 0x45, 0x5f, 0x50, 0x52, 0x45, 0x46, 0x45, 0x52,
	0x45, 0x4e, 0x43, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x1c, 0x0a, 0x14, 0x54, 0x45, 0x4c, 0x45, 0x43, 0x4f, 0x4d, 0x4d, 0x55, 0x54,
	0x45, 0x5f, 0x45, 0x58, 0x43, 0x4c, 0x55, 0x44, 0x45, 0x44, 0x10, 0x01, 0x1a, 0x02, 0x08, 0x01,
	0x12, 0x17, 0x0a, 0x13, 0x54, 0x45, 0x4c, 0x45, 0x43, 0x4f, 0x4d, 0x4d, 0x55, 0x54, 0x45, 0x5f,
	0x41, 0x4c, 0x4c, 0x4f, 0x57, 0x45, 0x44, 0x10, 0x02, 0x12, 0x1d, 0x0a, 0x19, 0x54, 0x45, 0x4c,
	0x45, 0x43, 0x4f, 0x4d, 0x4d, 0x55, 0x54, 0x45, 0x5f, 0x4a, 0x4f, 0x42, 0x53, 0x5f, 0x45, 0x58,
	0x43, 0x4c, 0x55, 0x44, 0x45, 0x44, 0x10, 0x03, 0x22, 0x8b, 0x04, 0x0a, 0x12, 0x43, 0x6f, 0x6d,
	0x70, 0x65, 0x6e, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12,
	0x53, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c,
	0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70,
	0x65, 0x6e, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e, 0x46,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04,
	0x74, 0x79, 0x70, 0x65, 0x12, 0x59, 0x0a, 0x05, 0x75, 0x6e, 0x69, 0x74, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x0e, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x65, 0x6e, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e,
	0x66, 0x6f, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x65, 0x6e, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x55,
	0x6e, 0x69, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x75, 0x6e, 0x69, 0x74, 0x73, 0x12,
	0x55, 0x0a, 0x05, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61,
	0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6d,
	0x70, 0x65, 0x6e, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x43, 0x6f,
	0x6d, 0x70, 0x65, 0x6e, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x52,
	0x05, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x65, 0x0a, 0x30, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64,
	0x65, 0x5f, 0x6a, 0x6f, 0x62, 0x73, 0x5f, 0x77, 0x69, 0x74, 0x68, 0x5f, 0x75, 0x6e, 0x73, 0x70,
	0x65, 0x63, 0x69, 0x66, 0x69, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x65, 0x6e, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x2b, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x4a, 0x6f, 0x62, 0x73, 0x57, 0x69, 0x74,
	0x68, 0x55, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x65, 0x64, 0x43, 0x6f, 0x6d, 0x70,
	0x65, 0x6e, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x22, 0x86, 0x01,
	0x0a, 0x0a, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1b, 0x0a, 0x17,
	0x46, 0x49, 0x4c, 0x54, 0x45, 0x52, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x55, 0x4e, 0x49,
	0x54, 0x5f, 0x4f, 0x4e, 0x4c, 0x59, 0x10, 0x01, 0x12, 0x13, 0x0a, 0x0f, 0x55, 0x4e, 0x49, 0x54,
	0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x41, 0x4d, 0x4f, 0x55, 0x4e, 0x54, 0x10, 0x02, 0x12, 0x1a, 0x0a,
	0x16, 0x41, 0x4e, 0x4e, 0x55, 0x41, 0x4c, 0x49, 0x5a, 0x45, 0x44, 0x5f, 0x42, 0x41, 0x53, 0x45,
	0x5f, 0x41, 0x4d, 0x4f, 0x55, 0x4e, 0x54, 0x10, 0x03, 0x12, 0x1b, 0x0a, 0x17, 0x41, 0x4e, 0x4e,
	0x55, 0x41, 0x4c, 0x49, 0x5a, 0x45, 0x44, 0x5f, 0x54, 0x4f, 0x54, 0x41, 0x4c, 0x5f, 0x41, 0x4d,
	0x4f, 0x55, 0x4e, 0x54, 0x10, 0x04, 0x22, 0xb1, 0x04, 0x0a, 0x0d, 0x43, 0x6f, 0x6d, 0x6d, 0x75,
	0x74, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x56, 0x0a, 0x0e, 0x63, 0x6f, 0x6d, 0x6d,
	0x75, 0x74, 0x65, 0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43,
	0x6f, 0x6d, 0x6d, 0x75, 0x74, 0x65, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0d, 0x63, 0x6f, 0x6d, 0x6d, 0x75, 0x74, 0x65, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64,
	0x12, 0x45, 0x0a, 0x11, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x63, 0x6f, 0x6f, 0x72, 0x64, 0x69,
	0x6e, 0x61, 0x74, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x4c, 0x61, 0x74, 0x4c, 0x6e, 0x67,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x73, 0x74, 0x61, 0x72, 0x74, 0x43, 0x6f, 0x6f, 0x72,
	0x64, 0x69, 0x6e, 0x61, 0x74, 0x65, 0x73, 0x12, 0x47, 0x0a, 0x0f, 0x74, 0x72, 0x61, 0x76, 0x65,
	0x6c, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0e, 0x74, 0x72, 0x61, 0x76, 0x65, 0x6c, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x3a, 0x0a, 0x19, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x63,
	0x69, 0x73, 0x65, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x17, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x49, 0x6d, 0x70, 0x72, 0x65, 0x63,
	0x69, 0x73, 0x65, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x12, 0x5b, 0x0a, 0x0c,
	0x72, 0x6f, 0x61, 0x64, 0x5f, 0x74, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x75, 0x74, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e, 0x52,
	0x6f, 0x61, 0x64, 0x54, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x48, 0x00, 0x52, 0x0b, 0x72, 0x6f,
	0x61, 0x64, 0x54, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x12, 0x3f, 0x0a, 0x0e, 0x64, 0x65, 0x70,
	0x61, 0x72, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x4f, 0x66, 0x44, 0x61, 0x79, 0x48, 0x00, 0x52, 0x0d, 0x64, 0x65, 0x70,
	0x61, 0x72, 0x74, 0x75, 0x72, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x4c, 0x0a, 0x0b, 0x52, 0x6f,
	0x61, 0x64, 0x54, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x12, 0x1c, 0x0a, 0x18, 0x52, 0x4f, 0x41,
	0x44, 0x5f, 0x54, 0x52, 0x41, 0x46, 0x46, 0x49, 0x43, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x10, 0x0a, 0x0c, 0x54, 0x52, 0x41, 0x46, 0x46,
	0x49, 0x43, 0x5f, 0x46, 0x52, 0x45, 0x45, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x42, 0x55, 0x53,
	0x59, 0x5f, 0x48, 0x4f, 0x55, 0x52, 0x10, 0x02, 0x42, 0x10, 0x0a, 0x0e, 0x74, 0x72, 0x61, 0x66,
	0x66, 0x69, 0x63, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x70, 0x0a, 0x1f, 0x63, 0x6f,
	0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74,
	0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x42, 0x0c, 0x46,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x37, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x67, 0x6f, 0x2f, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x34, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2f, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x70, 0x62, 0x3b, 0x74, 0x61,
	0x6c, 0x65, 0x6e, 0x74, 0x70, 0x62, 0xa2, 0x02, 0x03, 0x43, 0x54, 0x53, 0x62, 0x06, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_talent_v4beta1_filters_proto_rawDescOnce sync.Once
	file_google_cloud_talent_v4beta1_filters_proto_rawDescData = file_google_cloud_talent_v4beta1_filters_proto_rawDesc
)

func file_google_cloud_talent_v4beta1_filters_proto_rawDescGZIP() []byte {
	file_google_cloud_talent_v4beta1_filters_proto_rawDescOnce.Do(func() {
		file_google_cloud_talent_v4beta1_filters_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_talent_v4beta1_filters_proto_rawDescData)
	})
	return file_google_cloud_talent_v4beta1_filters_proto_rawDescData
}

var file_google_cloud_talent_v4beta1_filters_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_cloud_talent_v4beta1_filters_proto_msgTypes = make([]protoimpl.MessageInfo, 4)
var file_google_cloud_talent_v4beta1_filters_proto_goTypes = []interface{}{
	(LocationFilter_TelecommutePreference)(0),  // 0: google.cloud.talent.v4beta1.LocationFilter.TelecommutePreference
	(CompensationFilter_FilterType)(0),         // 1: google.cloud.talent.v4beta1.CompensationFilter.FilterType
	(CommuteFilter_RoadTraffic)(0),             // 2: google.cloud.talent.v4beta1.CommuteFilter.RoadTraffic
	(*JobQuery)(nil),                           // 3: google.cloud.talent.v4beta1.JobQuery
	(*LocationFilter)(nil),                     // 4: google.cloud.talent.v4beta1.LocationFilter
	(*CompensationFilter)(nil),                 // 5: google.cloud.talent.v4beta1.CompensationFilter
	(*CommuteFilter)(nil),                      // 6: google.cloud.talent.v4beta1.CommuteFilter
	(JobCategory)(0),                           // 7: google.cloud.talent.v4beta1.JobCategory
	(EmploymentType)(0),                        // 8: google.cloud.talent.v4beta1.EmploymentType
	(*TimestampRange)(nil),                     // 9: google.cloud.talent.v4beta1.TimestampRange
	(*latlng.LatLng)(nil),                      // 10: google.type.LatLng
	(CompensationInfo_CompensationUnit)(0),     // 11: google.cloud.talent.v4beta1.CompensationInfo.CompensationUnit
	(*CompensationInfo_CompensationRange)(nil), // 12: google.cloud.talent.v4beta1.CompensationInfo.CompensationRange
	(CommuteMethod)(0),                         // 13: google.cloud.talent.v4beta1.CommuteMethod
	(*durationpb.Duration)(nil),                // 14: google.protobuf.Duration
	(*timeofday.TimeOfDay)(nil),                // 15: google.type.TimeOfDay
}
var file_google_cloud_talent_v4beta1_filters_proto_depIdxs = []int32{
	4,  // 0: google.cloud.talent.v4beta1.JobQuery.location_filters:type_name -> google.cloud.talent.v4beta1.LocationFilter
	7,  // 1: google.cloud.talent.v4beta1.JobQuery.job_categories:type_name -> google.cloud.talent.v4beta1.JobCategory
	6,  // 2: google.cloud.talent.v4beta1.JobQuery.commute_filter:type_name -> google.cloud.talent.v4beta1.CommuteFilter
	5,  // 3: google.cloud.talent.v4beta1.JobQuery.compensation_filter:type_name -> google.cloud.talent.v4beta1.CompensationFilter
	8,  // 4: google.cloud.talent.v4beta1.JobQuery.employment_types:type_name -> google.cloud.talent.v4beta1.EmploymentType
	9,  // 5: google.cloud.talent.v4beta1.JobQuery.publish_time_range:type_name -> google.cloud.talent.v4beta1.TimestampRange
	10, // 6: google.cloud.talent.v4beta1.LocationFilter.lat_lng:type_name -> google.type.LatLng
	0,  // 7: google.cloud.talent.v4beta1.LocationFilter.telecommute_preference:type_name -> google.cloud.talent.v4beta1.LocationFilter.TelecommutePreference
	1,  // 8: google.cloud.talent.v4beta1.CompensationFilter.type:type_name -> google.cloud.talent.v4beta1.CompensationFilter.FilterType
	11, // 9: google.cloud.talent.v4beta1.CompensationFilter.units:type_name -> google.cloud.talent.v4beta1.CompensationInfo.CompensationUnit
	12, // 10: google.cloud.talent.v4beta1.CompensationFilter.range:type_name -> google.cloud.talent.v4beta1.CompensationInfo.CompensationRange
	13, // 11: google.cloud.talent.v4beta1.CommuteFilter.commute_method:type_name -> google.cloud.talent.v4beta1.CommuteMethod
	10, // 12: google.cloud.talent.v4beta1.CommuteFilter.start_coordinates:type_name -> google.type.LatLng
	14, // 13: google.cloud.talent.v4beta1.CommuteFilter.travel_duration:type_name -> google.protobuf.Duration
	2,  // 14: google.cloud.talent.v4beta1.CommuteFilter.road_traffic:type_name -> google.cloud.talent.v4beta1.CommuteFilter.RoadTraffic
	15, // 15: google.cloud.talent.v4beta1.CommuteFilter.departure_time:type_name -> google.type.TimeOfDay
	16, // [16:16] is the sub-list for method output_type
	16, // [16:16] is the sub-list for method input_type
	16, // [16:16] is the sub-list for extension type_name
	16, // [16:16] is the sub-list for extension extendee
	0,  // [0:16] is the sub-list for field type_name
}

func init() { file_google_cloud_talent_v4beta1_filters_proto_init() }
func file_google_cloud_talent_v4beta1_filters_proto_init() {
	if File_google_cloud_talent_v4beta1_filters_proto != nil {
		return
	}
	file_google_cloud_talent_v4beta1_common_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_talent_v4beta1_filters_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JobQuery); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_talent_v4beta1_filters_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LocationFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_talent_v4beta1_filters_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CompensationFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_talent_v4beta1_filters_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommuteFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_talent_v4beta1_filters_proto_msgTypes[3].OneofWrappers = []interface{}{
		(*CommuteFilter_RoadTraffic_)(nil),
		(*CommuteFilter_DepartureTime)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_talent_v4beta1_filters_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   4,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_talent_v4beta1_filters_proto_goTypes,
		DependencyIndexes: file_google_cloud_talent_v4beta1_filters_proto_depIdxs,
		EnumInfos:         file_google_cloud_talent_v4beta1_filters_proto_enumTypes,
		MessageInfos:      file_google_cloud_talent_v4beta1_filters_proto_msgTypes,
	}.Build()
	File_google_cloud_talent_v4beta1_filters_proto = out.File
	file_google_cloud_talent_v4beta1_filters_proto_rawDesc = nil
	file_google_cloud_talent_v4beta1_filters_proto_goTypes = nil
	file_google_cloud_talent_v4beta1_filters_proto_depIdxs = nil
}
