// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

//go:build go1.23

package datalabeling

import (
	"iter"

	datalabelingpb "cloud.google.com/go/datalabeling/apiv1beta1/datalabelingpb"
	"github.com/googleapis/gax-go/v2/iterator"
)

// All returns an iterator. If an error is returned by the iterator, the
// iterator will stop after that iteration.
func (it *AnnotatedDatasetIterator) All() iter.Seq2[*datalabelingpb.AnnotatedDataset, error] {
	return iterator.RangeAdapter(it.Next)
}

// All returns an iterator. If an error is returned by the iterator, the
// iterator will stop after that iteration.
func (it *AnnotationSpecSetIterator) All() iter.Seq2[*datalabelingpb.AnnotationSpecSet, error] {
	return iterator.RangeAdapter(it.Next)
}

// All returns an iterator. If an error is returned by the iterator, the
// iterator will stop after that iteration.
func (it *DataItemIterator) All() iter.Seq2[*datalabelingpb.DataItem, error] {
	return iterator.RangeAdapter(it.Next)
}

// All returns an iterator. If an error is returned by the iterator, the
// iterator will stop after that iteration.
func (it *DatasetIterator) All() iter.Seq2[*datalabelingpb.Dataset, error] {
	return iterator.RangeAdapter(it.Next)
}

// All returns an iterator. If an error is returned by the iterator, the
// iterator will stop after that iteration.
func (it *EvaluationIterator) All() iter.Seq2[*datalabelingpb.Evaluation, error] {
	return iterator.RangeAdapter(it.Next)
}

// All returns an iterator. If an error is returned by the iterator, the
// iterator will stop after that iteration.
func (it *EvaluationJobIterator) All() iter.Seq2[*datalabelingpb.EvaluationJob, error] {
	return iterator.RangeAdapter(it.Next)
}

// All returns an iterator. If an error is returned by the iterator, the
// iterator will stop after that iteration.
func (it *ExampleIterator) All() iter.Seq2[*datalabelingpb.Example, error] {
	return iterator.RangeAdapter(it.Next)
}

// All returns an iterator. If an error is returned by the iterator, the
// iterator will stop after that iteration.
func (it *InstructionIterator) All() iter.Seq2[*datalabelingpb.Instruction, error] {
	return iterator.RangeAdapter(it.Next)
}

// All returns an iterator. If an error is returned by the iterator, the
// iterator will stop after that iteration.
func (it *SearchExampleComparisonsResponse_ExampleComparisonIterator) All() iter.Seq2[*datalabelingpb.SearchExampleComparisonsResponse_ExampleComparison, error] {
	return iterator.RangeAdapter(it.Next)
}
