// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.31.0
// 	protoc        v4.23.2
// source: google/cloud/automl/v1/operations.proto

package automlpb

import (
	reflect "reflect"
	sync "sync"

	status "google.golang.org/genproto/googleapis/rpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Metadata used across all long running operations returned by AutoML API.
type OperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Ouptut only. Details of specific operation. Even if this field is empty,
	// the presence allows to distinguish different types of operations.
	//
	// Types that are assignable to Details:
	//	*OperationMetadata_DeleteDetails
	//	*OperationMetadata_DeployModelDetails
	//	*OperationMetadata_UndeployModelDetails
	//	*OperationMetadata_CreateModelDetails
	//	*OperationMetadata_CreateDatasetDetails
	//	*OperationMetadata_ImportDataDetails
	//	*OperationMetadata_BatchPredictDetails
	//	*OperationMetadata_ExportDataDetails
	//	*OperationMetadata_ExportModelDetails
	Details isOperationMetadata_Details `protobuf_oneof:"details"`
	// Output only. Progress of operation. Range: [0, 100].
	// Not used currently.
	ProgressPercent int32 `protobuf:"varint,13,opt,name=progress_percent,json=progressPercent,proto3" json:"progress_percent,omitempty"`
	// Output only. Partial failures encountered.
	// E.g. single files that couldn't be read.
	// This field should never exceed 20 entries.
	// Status details field will contain standard GCP error details.
	PartialFailures []*status.Status `protobuf:"bytes,2,rep,name=partial_failures,json=partialFailures,proto3" json:"partial_failures,omitempty"`
	// Output only. Time when the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Time when the operation was updated for the last time.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *OperationMetadata) Reset() {
	*x = OperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_automl_v1_operations_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OperationMetadata) ProtoMessage() {}

func (x *OperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_automl_v1_operations_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OperationMetadata.ProtoReflect.Descriptor instead.
func (*OperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_automl_v1_operations_proto_rawDescGZIP(), []int{0}
}

func (m *OperationMetadata) GetDetails() isOperationMetadata_Details {
	if m != nil {
		return m.Details
	}
	return nil
}

func (x *OperationMetadata) GetDeleteDetails() *DeleteOperationMetadata {
	if x, ok := x.GetDetails().(*OperationMetadata_DeleteDetails); ok {
		return x.DeleteDetails
	}
	return nil
}

func (x *OperationMetadata) GetDeployModelDetails() *DeployModelOperationMetadata {
	if x, ok := x.GetDetails().(*OperationMetadata_DeployModelDetails); ok {
		return x.DeployModelDetails
	}
	return nil
}

func (x *OperationMetadata) GetUndeployModelDetails() *UndeployModelOperationMetadata {
	if x, ok := x.GetDetails().(*OperationMetadata_UndeployModelDetails); ok {
		return x.UndeployModelDetails
	}
	return nil
}

func (x *OperationMetadata) GetCreateModelDetails() *CreateModelOperationMetadata {
	if x, ok := x.GetDetails().(*OperationMetadata_CreateModelDetails); ok {
		return x.CreateModelDetails
	}
	return nil
}

func (x *OperationMetadata) GetCreateDatasetDetails() *CreateDatasetOperationMetadata {
	if x, ok := x.GetDetails().(*OperationMetadata_CreateDatasetDetails); ok {
		return x.CreateDatasetDetails
	}
	return nil
}

func (x *OperationMetadata) GetImportDataDetails() *ImportDataOperationMetadata {
	if x, ok := x.GetDetails().(*OperationMetadata_ImportDataDetails); ok {
		return x.ImportDataDetails
	}
	return nil
}

func (x *OperationMetadata) GetBatchPredictDetails() *BatchPredictOperationMetadata {
	if x, ok := x.GetDetails().(*OperationMetadata_BatchPredictDetails); ok {
		return x.BatchPredictDetails
	}
	return nil
}

func (x *OperationMetadata) GetExportDataDetails() *ExportDataOperationMetadata {
	if x, ok := x.GetDetails().(*OperationMetadata_ExportDataDetails); ok {
		return x.ExportDataDetails
	}
	return nil
}

func (x *OperationMetadata) GetExportModelDetails() *ExportModelOperationMetadata {
	if x, ok := x.GetDetails().(*OperationMetadata_ExportModelDetails); ok {
		return x.ExportModelDetails
	}
	return nil
}

func (x *OperationMetadata) GetProgressPercent() int32 {
	if x != nil {
		return x.ProgressPercent
	}
	return 0
}

func (x *OperationMetadata) GetPartialFailures() []*status.Status {
	if x != nil {
		return x.PartialFailures
	}
	return nil
}

func (x *OperationMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *OperationMetadata) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

type isOperationMetadata_Details interface {
	isOperationMetadata_Details()
}

type OperationMetadata_DeleteDetails struct {
	// Details of a Delete operation.
	DeleteDetails *DeleteOperationMetadata `protobuf:"bytes,8,opt,name=delete_details,json=deleteDetails,proto3,oneof"`
}

type OperationMetadata_DeployModelDetails struct {
	// Details of a DeployModel operation.
	DeployModelDetails *DeployModelOperationMetadata `protobuf:"bytes,24,opt,name=deploy_model_details,json=deployModelDetails,proto3,oneof"`
}

type OperationMetadata_UndeployModelDetails struct {
	// Details of an UndeployModel operation.
	UndeployModelDetails *UndeployModelOperationMetadata `protobuf:"bytes,25,opt,name=undeploy_model_details,json=undeployModelDetails,proto3,oneof"`
}

type OperationMetadata_CreateModelDetails struct {
	// Details of CreateModel operation.
	CreateModelDetails *CreateModelOperationMetadata `protobuf:"bytes,10,opt,name=create_model_details,json=createModelDetails,proto3,oneof"`
}

type OperationMetadata_CreateDatasetDetails struct {
	// Details of CreateDataset operation.
	CreateDatasetDetails *CreateDatasetOperationMetadata `protobuf:"bytes,30,opt,name=create_dataset_details,json=createDatasetDetails,proto3,oneof"`
}

type OperationMetadata_ImportDataDetails struct {
	// Details of ImportData operation.
	ImportDataDetails *ImportDataOperationMetadata `protobuf:"bytes,15,opt,name=import_data_details,json=importDataDetails,proto3,oneof"`
}

type OperationMetadata_BatchPredictDetails struct {
	// Details of BatchPredict operation.
	BatchPredictDetails *BatchPredictOperationMetadata `protobuf:"bytes,16,opt,name=batch_predict_details,json=batchPredictDetails,proto3,oneof"`
}

type OperationMetadata_ExportDataDetails struct {
	// Details of ExportData operation.
	ExportDataDetails *ExportDataOperationMetadata `protobuf:"bytes,21,opt,name=export_data_details,json=exportDataDetails,proto3,oneof"`
}

type OperationMetadata_ExportModelDetails struct {
	// Details of ExportModel operation.
	ExportModelDetails *ExportModelOperationMetadata `protobuf:"bytes,22,opt,name=export_model_details,json=exportModelDetails,proto3,oneof"`
}

func (*OperationMetadata_DeleteDetails) isOperationMetadata_Details() {}

func (*OperationMetadata_DeployModelDetails) isOperationMetadata_Details() {}

func (*OperationMetadata_UndeployModelDetails) isOperationMetadata_Details() {}

func (*OperationMetadata_CreateModelDetails) isOperationMetadata_Details() {}

func (*OperationMetadata_CreateDatasetDetails) isOperationMetadata_Details() {}

func (*OperationMetadata_ImportDataDetails) isOperationMetadata_Details() {}

func (*OperationMetadata_BatchPredictDetails) isOperationMetadata_Details() {}

func (*OperationMetadata_ExportDataDetails) isOperationMetadata_Details() {}

func (*OperationMetadata_ExportModelDetails) isOperationMetadata_Details() {}

// Details of operations that perform deletes of any entities.
type DeleteOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DeleteOperationMetadata) Reset() {
	*x = DeleteOperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_automl_v1_operations_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteOperationMetadata) ProtoMessage() {}

func (x *DeleteOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_automl_v1_operations_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteOperationMetadata.ProtoReflect.Descriptor instead.
func (*DeleteOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_automl_v1_operations_proto_rawDescGZIP(), []int{1}
}

// Details of DeployModel operation.
type DeployModelOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DeployModelOperationMetadata) Reset() {
	*x = DeployModelOperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_automl_v1_operations_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeployModelOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeployModelOperationMetadata) ProtoMessage() {}

func (x *DeployModelOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_automl_v1_operations_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeployModelOperationMetadata.ProtoReflect.Descriptor instead.
func (*DeployModelOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_automl_v1_operations_proto_rawDescGZIP(), []int{2}
}

// Details of UndeployModel operation.
type UndeployModelOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *UndeployModelOperationMetadata) Reset() {
	*x = UndeployModelOperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_automl_v1_operations_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UndeployModelOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UndeployModelOperationMetadata) ProtoMessage() {}

func (x *UndeployModelOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_automl_v1_operations_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UndeployModelOperationMetadata.ProtoReflect.Descriptor instead.
func (*UndeployModelOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_automl_v1_operations_proto_rawDescGZIP(), []int{3}
}

// Details of CreateDataset operation.
type CreateDatasetOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *CreateDatasetOperationMetadata) Reset() {
	*x = CreateDatasetOperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_automl_v1_operations_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateDatasetOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateDatasetOperationMetadata) ProtoMessage() {}

func (x *CreateDatasetOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_automl_v1_operations_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateDatasetOperationMetadata.ProtoReflect.Descriptor instead.
func (*CreateDatasetOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_automl_v1_operations_proto_rawDescGZIP(), []int{4}
}

// Details of CreateModel operation.
type CreateModelOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *CreateModelOperationMetadata) Reset() {
	*x = CreateModelOperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_automl_v1_operations_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateModelOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateModelOperationMetadata) ProtoMessage() {}

func (x *CreateModelOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_automl_v1_operations_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateModelOperationMetadata.ProtoReflect.Descriptor instead.
func (*CreateModelOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_automl_v1_operations_proto_rawDescGZIP(), []int{5}
}

// Details of ImportData operation.
type ImportDataOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ImportDataOperationMetadata) Reset() {
	*x = ImportDataOperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_automl_v1_operations_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportDataOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportDataOperationMetadata) ProtoMessage() {}

func (x *ImportDataOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_automl_v1_operations_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportDataOperationMetadata.ProtoReflect.Descriptor instead.
func (*ImportDataOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_automl_v1_operations_proto_rawDescGZIP(), []int{6}
}

// Details of ExportData operation.
type ExportDataOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Information further describing this export data's output.
	OutputInfo *ExportDataOperationMetadata_ExportDataOutputInfo `protobuf:"bytes,1,opt,name=output_info,json=outputInfo,proto3" json:"output_info,omitempty"`
}

func (x *ExportDataOperationMetadata) Reset() {
	*x = ExportDataOperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_automl_v1_operations_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportDataOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportDataOperationMetadata) ProtoMessage() {}

func (x *ExportDataOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_automl_v1_operations_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportDataOperationMetadata.ProtoReflect.Descriptor instead.
func (*ExportDataOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_automl_v1_operations_proto_rawDescGZIP(), []int{7}
}

func (x *ExportDataOperationMetadata) GetOutputInfo() *ExportDataOperationMetadata_ExportDataOutputInfo {
	if x != nil {
		return x.OutputInfo
	}
	return nil
}

// Details of BatchPredict operation.
type BatchPredictOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The input config that was given upon starting this
	// batch predict operation.
	InputConfig *BatchPredictInputConfig `protobuf:"bytes,1,opt,name=input_config,json=inputConfig,proto3" json:"input_config,omitempty"`
	// Output only. Information further describing this batch predict's output.
	OutputInfo *BatchPredictOperationMetadata_BatchPredictOutputInfo `protobuf:"bytes,2,opt,name=output_info,json=outputInfo,proto3" json:"output_info,omitempty"`
}

func (x *BatchPredictOperationMetadata) Reset() {
	*x = BatchPredictOperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_automl_v1_operations_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchPredictOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchPredictOperationMetadata) ProtoMessage() {}

func (x *BatchPredictOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_automl_v1_operations_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchPredictOperationMetadata.ProtoReflect.Descriptor instead.
func (*BatchPredictOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_automl_v1_operations_proto_rawDescGZIP(), []int{8}
}

func (x *BatchPredictOperationMetadata) GetInputConfig() *BatchPredictInputConfig {
	if x != nil {
		return x.InputConfig
	}
	return nil
}

func (x *BatchPredictOperationMetadata) GetOutputInfo() *BatchPredictOperationMetadata_BatchPredictOutputInfo {
	if x != nil {
		return x.OutputInfo
	}
	return nil
}

// Details of ExportModel operation.
type ExportModelOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Information further describing the output of this model
	// export.
	OutputInfo *ExportModelOperationMetadata_ExportModelOutputInfo `protobuf:"bytes,2,opt,name=output_info,json=outputInfo,proto3" json:"output_info,omitempty"`
}

func (x *ExportModelOperationMetadata) Reset() {
	*x = ExportModelOperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_automl_v1_operations_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportModelOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportModelOperationMetadata) ProtoMessage() {}

func (x *ExportModelOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_automl_v1_operations_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportModelOperationMetadata.ProtoReflect.Descriptor instead.
func (*ExportModelOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_automl_v1_operations_proto_rawDescGZIP(), []int{9}
}

func (x *ExportModelOperationMetadata) GetOutputInfo() *ExportModelOperationMetadata_ExportModelOutputInfo {
	if x != nil {
		return x.OutputInfo
	}
	return nil
}

// Further describes this export data's output.
// Supplements
// [OutputConfig][google.cloud.automl.v1.OutputConfig].
type ExportDataOperationMetadata_ExportDataOutputInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The output location to which the exported data is written.
	//
	// Types that are assignable to OutputLocation:
	//	*ExportDataOperationMetadata_ExportDataOutputInfo_GcsOutputDirectory
	OutputLocation isExportDataOperationMetadata_ExportDataOutputInfo_OutputLocation `protobuf_oneof:"output_location"`
}

func (x *ExportDataOperationMetadata_ExportDataOutputInfo) Reset() {
	*x = ExportDataOperationMetadata_ExportDataOutputInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_automl_v1_operations_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportDataOperationMetadata_ExportDataOutputInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportDataOperationMetadata_ExportDataOutputInfo) ProtoMessage() {}

func (x *ExportDataOperationMetadata_ExportDataOutputInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_automl_v1_operations_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportDataOperationMetadata_ExportDataOutputInfo.ProtoReflect.Descriptor instead.
func (*ExportDataOperationMetadata_ExportDataOutputInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_automl_v1_operations_proto_rawDescGZIP(), []int{7, 0}
}

func (m *ExportDataOperationMetadata_ExportDataOutputInfo) GetOutputLocation() isExportDataOperationMetadata_ExportDataOutputInfo_OutputLocation {
	if m != nil {
		return m.OutputLocation
	}
	return nil
}

func (x *ExportDataOperationMetadata_ExportDataOutputInfo) GetGcsOutputDirectory() string {
	if x, ok := x.GetOutputLocation().(*ExportDataOperationMetadata_ExportDataOutputInfo_GcsOutputDirectory); ok {
		return x.GcsOutputDirectory
	}
	return ""
}

type isExportDataOperationMetadata_ExportDataOutputInfo_OutputLocation interface {
	isExportDataOperationMetadata_ExportDataOutputInfo_OutputLocation()
}

type ExportDataOperationMetadata_ExportDataOutputInfo_GcsOutputDirectory struct {
	// The full path of the Google Cloud Storage directory created, into which
	// the exported data is written.
	GcsOutputDirectory string `protobuf:"bytes,1,opt,name=gcs_output_directory,json=gcsOutputDirectory,proto3,oneof"`
}

func (*ExportDataOperationMetadata_ExportDataOutputInfo_GcsOutputDirectory) isExportDataOperationMetadata_ExportDataOutputInfo_OutputLocation() {
}

// Further describes this batch predict's output.
// Supplements
// [BatchPredictOutputConfig][google.cloud.automl.v1.BatchPredictOutputConfig].
type BatchPredictOperationMetadata_BatchPredictOutputInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The output location into which prediction output is written.
	//
	// Types that are assignable to OutputLocation:
	//	*BatchPredictOperationMetadata_BatchPredictOutputInfo_GcsOutputDirectory
	OutputLocation isBatchPredictOperationMetadata_BatchPredictOutputInfo_OutputLocation `protobuf_oneof:"output_location"`
}

func (x *BatchPredictOperationMetadata_BatchPredictOutputInfo) Reset() {
	*x = BatchPredictOperationMetadata_BatchPredictOutputInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_automl_v1_operations_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchPredictOperationMetadata_BatchPredictOutputInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchPredictOperationMetadata_BatchPredictOutputInfo) ProtoMessage() {}

func (x *BatchPredictOperationMetadata_BatchPredictOutputInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_automl_v1_operations_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchPredictOperationMetadata_BatchPredictOutputInfo.ProtoReflect.Descriptor instead.
func (*BatchPredictOperationMetadata_BatchPredictOutputInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_automl_v1_operations_proto_rawDescGZIP(), []int{8, 0}
}

func (m *BatchPredictOperationMetadata_BatchPredictOutputInfo) GetOutputLocation() isBatchPredictOperationMetadata_BatchPredictOutputInfo_OutputLocation {
	if m != nil {
		return m.OutputLocation
	}
	return nil
}

func (x *BatchPredictOperationMetadata_BatchPredictOutputInfo) GetGcsOutputDirectory() string {
	if x, ok := x.GetOutputLocation().(*BatchPredictOperationMetadata_BatchPredictOutputInfo_GcsOutputDirectory); ok {
		return x.GcsOutputDirectory
	}
	return ""
}

type isBatchPredictOperationMetadata_BatchPredictOutputInfo_OutputLocation interface {
	isBatchPredictOperationMetadata_BatchPredictOutputInfo_OutputLocation()
}

type BatchPredictOperationMetadata_BatchPredictOutputInfo_GcsOutputDirectory struct {
	// The full path of the Google Cloud Storage directory created, into which
	// the prediction output is written.
	GcsOutputDirectory string `protobuf:"bytes,1,opt,name=gcs_output_directory,json=gcsOutputDirectory,proto3,oneof"`
}

func (*BatchPredictOperationMetadata_BatchPredictOutputInfo_GcsOutputDirectory) isBatchPredictOperationMetadata_BatchPredictOutputInfo_OutputLocation() {
}

// Further describes the output of model export.
// Supplements
// [ModelExportOutputConfig][google.cloud.automl.v1.ModelExportOutputConfig].
type ExportModelOperationMetadata_ExportModelOutputInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The full path of the Google Cloud Storage directory created, into which
	// the model will be exported.
	GcsOutputDirectory string `protobuf:"bytes,1,opt,name=gcs_output_directory,json=gcsOutputDirectory,proto3" json:"gcs_output_directory,omitempty"`
}

func (x *ExportModelOperationMetadata_ExportModelOutputInfo) Reset() {
	*x = ExportModelOperationMetadata_ExportModelOutputInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_automl_v1_operations_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportModelOperationMetadata_ExportModelOutputInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportModelOperationMetadata_ExportModelOutputInfo) ProtoMessage() {}

func (x *ExportModelOperationMetadata_ExportModelOutputInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_automl_v1_operations_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportModelOperationMetadata_ExportModelOutputInfo.ProtoReflect.Descriptor instead.
func (*ExportModelOperationMetadata_ExportModelOutputInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_automl_v1_operations_proto_rawDescGZIP(), []int{9, 0}
}

func (x *ExportModelOperationMetadata_ExportModelOutputInfo) GetGcsOutputDirectory() string {
	if x != nil {
		return x.GcsOutputDirectory
	}
	return ""
}

var File_google_cloud_automl_v1_operations_proto protoreflect.FileDescriptor

var file_google_cloud_automl_v1_operations_proto_rawDesc = []byte{
	0x0a, 0x27, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x75, 0x74, 0x6f, 0x6d, 0x6c, 0x2f, 0x76, 0x31, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x16, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x6c, 0x2e, 0x76,
	0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x61, 0x75, 0x74, 0x6f, 0x6d, 0x6c, 0x2f, 0x76, 0x31, 0x2f, 0x69, 0x6f, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f,
	0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xb5, 0x09, 0x0a,
	0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x12, 0x58, 0x0a, 0x0e, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x5f, 0x64, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x6c,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x48, 0x00, 0x52, 0x0d, 0x64,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x68, 0x0a, 0x14,
	0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x64, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x73, 0x18, 0x18, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x6c,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x48, 0x00, 0x52, 0x12, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x44,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x6e, 0x0a, 0x16, 0x75, 0x6e, 0x64, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73,
	0x18, 0x19, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x6c, 0x2e, 0x76, 0x31, 0x2e,
	0x55, 0x6e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x48, 0x00,
	0x52, 0x14, 0x75, 0x6e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x44,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x68, 0x0a, 0x14, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x0a,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x48, 0x00, 0x52, 0x12, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73,
	0x12, 0x6e, 0x0a, 0x16, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x73,
	0x65, 0x74, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x1e, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x75, 0x74, 0x6f, 0x6d, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x48, 0x00, 0x52, 0x14, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73,
	0x12, 0x65, 0x0a, 0x13, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f,
	0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x74,
	0x6f, 0x6d, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x61, 0x74,
	0x61, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x48, 0x00, 0x52, 0x11, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x61, 0x74, 0x61,
	0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x6b, 0x0a, 0x15, 0x62, 0x61, 0x74, 0x63, 0x68,
	0x5f, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73,
	0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x6c, 0x2e, 0x76, 0x31, 0x2e,
	0x42, 0x61, 0x74, 0x63, 0x68, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x48, 0x00, 0x52,
	0x13, 0x62, 0x61, 0x74, 0x63, 0x68, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x73, 0x12, 0x65, 0x0a, 0x13, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x64,
	0x61, 0x74, 0x61, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x15, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72,
	0x74, 0x44, 0x61, 0x74, 0x61, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x48, 0x00, 0x52, 0x11, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74,
	0x44, 0x61, 0x74, 0x61, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x68, 0x0a, 0x14, 0x65,
	0x78, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x64, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x73, 0x18, 0x16, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x6c, 0x2e,
	0x76, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x48,
	0x00, 0x52, 0x12, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x44, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x29, 0x0a, 0x10, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73,
	0x73, 0x5f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x0f, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x50, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74,
	0x12, 0x3d, 0x0a, 0x10, 0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x66, 0x61, 0x69, 0x6c,
	0x75, 0x72, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x0f,
	0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x73, 0x12,
	0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x42, 0x09, 0x0a, 0x07, 0x64, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x73, 0x22, 0x19, 0x0a, 0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22,
	0x1e, 0x0a, 0x1c, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22,
	0x20, 0x0a, 0x1e, 0x55, 0x6e, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x4d, 0x6f, 0x64, 0x65, 0x6c,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x22, 0x20, 0x0a, 0x1e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x73,
	0x65, 0x74, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x22, 0x1e, 0x0a, 0x1c, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x6f, 0x64,
	0x65, 0x6c, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x22, 0x1d, 0x0a, 0x1b, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x61, 0x74,
	0x61, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x22, 0xe7, 0x01, 0x0a, 0x1b, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x61, 0x74,
	0x61, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x12, 0x69, 0x0a, 0x0b, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x69, 0x6e, 0x66,
	0x6f, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x6c, 0x2e, 0x76, 0x31,
	0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x61, 0x74, 0x61, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x45, 0x78, 0x70,
	0x6f, 0x72, 0x74, 0x44, 0x61, 0x74, 0x61, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x49, 0x6e, 0x66,
	0x6f, 0x52, 0x0a, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x1a, 0x5d, 0x0a,
	0x14, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x61, 0x74, 0x61, 0x4f, 0x75, 0x74, 0x70, 0x75,
	0x74, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x32, 0x0a, 0x14, 0x67, 0x63, 0x73, 0x5f, 0x6f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x5f, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x12, 0x67, 0x63, 0x73, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x42, 0x11, 0x0a, 0x0f, 0x6f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xc3, 0x02, 0x0a,
	0x1d, 0x42, 0x61, 0x74, 0x63, 0x68, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x52,
	0x0a, 0x0c, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61,
	0x74, 0x63, 0x68, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0b, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x6d, 0x0a, 0x0b, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x69, 0x6e, 0x66,
	0x6f, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x6c, 0x2e, 0x76, 0x31,
	0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x42,
	0x61, 0x74, 0x63, 0x68, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x4f, 0x75, 0x74, 0x70, 0x75,
	0x74, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0a, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x49, 0x6e, 0x66,
	0x6f, 0x1a, 0x5f, 0x0a, 0x16, 0x42, 0x61, 0x74, 0x63, 0x68, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63,
	0x74, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x32, 0x0a, 0x14, 0x67,
	0x63, 0x73, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74,
	0x6f, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x12, 0x67, 0x63, 0x73,
	0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x42,
	0x11, 0x0a, 0x0f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0xd6, 0x01, 0x0a, 0x1c, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x4d, 0x6f, 0x64,
	0x65, 0x6c, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x12, 0x6b, 0x0a, 0x0b, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x69, 0x6e,
	0x66, 0x6f, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x6c, 0x2e, 0x76,
	0x31, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x45,
	0x78, 0x70, 0x6f, 0x72, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0a, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x49, 0x6e, 0x66, 0x6f,
	0x1a, 0x49, 0x0a, 0x15, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x30, 0x0a, 0x14, 0x67, 0x63, 0x73,
	0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x67, 0x63, 0x73, 0x4f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x42, 0xa0, 0x01, 0x0a, 0x1a,
	0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x6c, 0x2e, 0x76, 0x31, 0x50, 0x01, 0x5a, 0x32, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67,
	0x6f, 0x2f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x6c, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x61,
	0x75, 0x74, 0x6f, 0x6d, 0x6c, 0x70, 0x62, 0x3b, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x6c, 0x70, 0x62,
	0xaa, 0x02, 0x16, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x41, 0x75, 0x74, 0x6f, 0x4d, 0x4c, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x16, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x41, 0x75, 0x74, 0x6f, 0x4d, 0x6c, 0x5c,
	0x56, 0x31, 0xea, 0x02, 0x19, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x3a, 0x3a, 0x41, 0x75, 0x74, 0x6f, 0x4d, 0x4c, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_automl_v1_operations_proto_rawDescOnce sync.Once
	file_google_cloud_automl_v1_operations_proto_rawDescData = file_google_cloud_automl_v1_operations_proto_rawDesc
)

func file_google_cloud_automl_v1_operations_proto_rawDescGZIP() []byte {
	file_google_cloud_automl_v1_operations_proto_rawDescOnce.Do(func() {
		file_google_cloud_automl_v1_operations_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_automl_v1_operations_proto_rawDescData)
	})
	return file_google_cloud_automl_v1_operations_proto_rawDescData
}

var file_google_cloud_automl_v1_operations_proto_msgTypes = make([]protoimpl.MessageInfo, 13)
var file_google_cloud_automl_v1_operations_proto_goTypes = []interface{}{
	(*OperationMetadata)(nil),                                    // 0: google.cloud.automl.v1.OperationMetadata
	(*DeleteOperationMetadata)(nil),                              // 1: google.cloud.automl.v1.DeleteOperationMetadata
	(*DeployModelOperationMetadata)(nil),                         // 2: google.cloud.automl.v1.DeployModelOperationMetadata
	(*UndeployModelOperationMetadata)(nil),                       // 3: google.cloud.automl.v1.UndeployModelOperationMetadata
	(*CreateDatasetOperationMetadata)(nil),                       // 4: google.cloud.automl.v1.CreateDatasetOperationMetadata
	(*CreateModelOperationMetadata)(nil),                         // 5: google.cloud.automl.v1.CreateModelOperationMetadata
	(*ImportDataOperationMetadata)(nil),                          // 6: google.cloud.automl.v1.ImportDataOperationMetadata
	(*ExportDataOperationMetadata)(nil),                          // 7: google.cloud.automl.v1.ExportDataOperationMetadata
	(*BatchPredictOperationMetadata)(nil),                        // 8: google.cloud.automl.v1.BatchPredictOperationMetadata
	(*ExportModelOperationMetadata)(nil),                         // 9: google.cloud.automl.v1.ExportModelOperationMetadata
	(*ExportDataOperationMetadata_ExportDataOutputInfo)(nil),     // 10: google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo
	(*BatchPredictOperationMetadata_BatchPredictOutputInfo)(nil), // 11: google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfo
	(*ExportModelOperationMetadata_ExportModelOutputInfo)(nil),   // 12: google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfo
	(*status.Status)(nil),                                        // 13: google.rpc.Status
	(*timestamppb.Timestamp)(nil),                                // 14: google.protobuf.Timestamp
	(*BatchPredictInputConfig)(nil),                              // 15: google.cloud.automl.v1.BatchPredictInputConfig
}
var file_google_cloud_automl_v1_operations_proto_depIdxs = []int32{
	1,  // 0: google.cloud.automl.v1.OperationMetadata.delete_details:type_name -> google.cloud.automl.v1.DeleteOperationMetadata
	2,  // 1: google.cloud.automl.v1.OperationMetadata.deploy_model_details:type_name -> google.cloud.automl.v1.DeployModelOperationMetadata
	3,  // 2: google.cloud.automl.v1.OperationMetadata.undeploy_model_details:type_name -> google.cloud.automl.v1.UndeployModelOperationMetadata
	5,  // 3: google.cloud.automl.v1.OperationMetadata.create_model_details:type_name -> google.cloud.automl.v1.CreateModelOperationMetadata
	4,  // 4: google.cloud.automl.v1.OperationMetadata.create_dataset_details:type_name -> google.cloud.automl.v1.CreateDatasetOperationMetadata
	6,  // 5: google.cloud.automl.v1.OperationMetadata.import_data_details:type_name -> google.cloud.automl.v1.ImportDataOperationMetadata
	8,  // 6: google.cloud.automl.v1.OperationMetadata.batch_predict_details:type_name -> google.cloud.automl.v1.BatchPredictOperationMetadata
	7,  // 7: google.cloud.automl.v1.OperationMetadata.export_data_details:type_name -> google.cloud.automl.v1.ExportDataOperationMetadata
	9,  // 8: google.cloud.automl.v1.OperationMetadata.export_model_details:type_name -> google.cloud.automl.v1.ExportModelOperationMetadata
	13, // 9: google.cloud.automl.v1.OperationMetadata.partial_failures:type_name -> google.rpc.Status
	14, // 10: google.cloud.automl.v1.OperationMetadata.create_time:type_name -> google.protobuf.Timestamp
	14, // 11: google.cloud.automl.v1.OperationMetadata.update_time:type_name -> google.protobuf.Timestamp
	10, // 12: google.cloud.automl.v1.ExportDataOperationMetadata.output_info:type_name -> google.cloud.automl.v1.ExportDataOperationMetadata.ExportDataOutputInfo
	15, // 13: google.cloud.automl.v1.BatchPredictOperationMetadata.input_config:type_name -> google.cloud.automl.v1.BatchPredictInputConfig
	11, // 14: google.cloud.automl.v1.BatchPredictOperationMetadata.output_info:type_name -> google.cloud.automl.v1.BatchPredictOperationMetadata.BatchPredictOutputInfo
	12, // 15: google.cloud.automl.v1.ExportModelOperationMetadata.output_info:type_name -> google.cloud.automl.v1.ExportModelOperationMetadata.ExportModelOutputInfo
	16, // [16:16] is the sub-list for method output_type
	16, // [16:16] is the sub-list for method input_type
	16, // [16:16] is the sub-list for extension type_name
	16, // [16:16] is the sub-list for extension extendee
	0,  // [0:16] is the sub-list for field type_name
}

func init() { file_google_cloud_automl_v1_operations_proto_init() }
func file_google_cloud_automl_v1_operations_proto_init() {
	if File_google_cloud_automl_v1_operations_proto != nil {
		return
	}
	file_google_cloud_automl_v1_io_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_automl_v1_operations_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_automl_v1_operations_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteOperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_automl_v1_operations_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeployModelOperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_automl_v1_operations_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UndeployModelOperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_automl_v1_operations_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateDatasetOperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_automl_v1_operations_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateModelOperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_automl_v1_operations_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportDataOperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_automl_v1_operations_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportDataOperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_automl_v1_operations_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchPredictOperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_automl_v1_operations_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportModelOperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_automl_v1_operations_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportDataOperationMetadata_ExportDataOutputInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_automl_v1_operations_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchPredictOperationMetadata_BatchPredictOutputInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_automl_v1_operations_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportModelOperationMetadata_ExportModelOutputInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_automl_v1_operations_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*OperationMetadata_DeleteDetails)(nil),
		(*OperationMetadata_DeployModelDetails)(nil),
		(*OperationMetadata_UndeployModelDetails)(nil),
		(*OperationMetadata_CreateModelDetails)(nil),
		(*OperationMetadata_CreateDatasetDetails)(nil),
		(*OperationMetadata_ImportDataDetails)(nil),
		(*OperationMetadata_BatchPredictDetails)(nil),
		(*OperationMetadata_ExportDataDetails)(nil),
		(*OperationMetadata_ExportModelDetails)(nil),
	}
	file_google_cloud_automl_v1_operations_proto_msgTypes[10].OneofWrappers = []interface{}{
		(*ExportDataOperationMetadata_ExportDataOutputInfo_GcsOutputDirectory)(nil),
	}
	file_google_cloud_automl_v1_operations_proto_msgTypes[11].OneofWrappers = []interface{}{
		(*BatchPredictOperationMetadata_BatchPredictOutputInfo_GcsOutputDirectory)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_automl_v1_operations_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   13,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_automl_v1_operations_proto_goTypes,
		DependencyIndexes: file_google_cloud_automl_v1_operations_proto_depIdxs,
		MessageInfos:      file_google_cloud_automl_v1_operations_proto_msgTypes,
	}.Build()
	File_google_cloud_automl_v1_operations_proto = out.File
	file_google_cloud_automl_v1_operations_proto_rawDesc = nil
	file_google_cloud_automl_v1_operations_proto_goTypes = nil
	file_google_cloud_automl_v1_operations_proto_depIdxs = nil
}
