10 PRINT "PROGRAM FILE 33: EXCEPTION - UNDERFLOW OF"
15 PRINT "        NUMERIC EXPRESSIONS."
20 PRINT "    ANSI STANDARD 7.4"
30 PRINT
40 PRINT "THIS PROGRAM TESTS VARIOUS CASES OF NUMERIC UNDERFLOW."
50 PRINT
60 PRINT "SECTION 33.1: POSITIVE UNDERFLOW"
70 PRINT
80 PRINT "THIS SECTION TESTS THE RESULT OF EXPRESSION EVALUATION"
90 PRINT "LESS THAN POSITIVE MACHINE INFINITESIMAL."
100 PRINT
110 PRINT "TO PASS THIS TEST:"
120 PRINT
130 PRINT "    1) A MESSAGE IDENTIFYING AN EXCEPTION MAY BE"
140 PRINT "       DISPLAYED (NOT MANDATORY), AND"
150 PRINT
160 PRINT "    2) ZERO MUST BE SUPPLIED AS THE VALUE"
170 PRINT "       OF THE EXPRESSION."
180 PRINT
190 PRINT "               BEGIN TEST"
200 PRINT
210 REM S IS A SWITCH TO INDICATE FIRST TIME THROUGH LOOP (S=1)
220 REM OR SUBSEQUENT ITERATIONS (S=0). UNDERFLOW SHOULD NOT OCCUR
230 REM FIRST TIME.
240 LET S=1
250 LET M=10
260 LET F=1
270 LET A=.8E-36
280 LET B=1
290 PRINT "ABOUT TO COMPUTE ";A;" / ";M
300 LET A=A/M
310 PRINT "RESULT = ";A
320 PRINT
330 PRINT "----------------------------------------"
340 PRINT
350 IF B<=A THEN 420
360 IF A=0 THEN 420
370 LET B=A
380 LET S=0
390 LET F=F*1.1
400 LET M=10^F
410 GOTO 290
420 REM CONVERGE
430 IF S=0 THEN 470
440 PRINT "*** TEST FAILED: UNDERFLOW OCCURRED ABOVE MAXIMUM"
450 PRINT "    MACHINE INFINITESIMAL. ***"
460 GOTO 510
470 IF A=0 THEN 500
480 PRINT "*** TEST FAILED: VALUE SUPPLIED NOT EQUAL ZERO. ***"
490 GOTO 510
500 PRINT "*** TEST PASSED *** "
510 PRINT
520 PRINT "                END TEST"
530 PRINT
540 PRINT "SECTION 33.2: NEGATIVE UNDERFLOW"
550 PRINT
560 PRINT "THIS SECTION TESTS THE RESULT OF EXPRESSION EVALUATION"
570 PRINT "GREATER THAN NEGATIVE MACHINE INFINITESIMAL."
580 PRINT
590 PRINT "TO PASS THIS TEST:"
600 PRINT
610 PRINT "    1) A MESSAGE IDENTIFYING AN EXCEPTION MAY BE"
620 PRINT "       DISPLAYED (NOT MANDATORY), AND"
630 PRINT
640 PRINT "    2) ZERO MUST BE SUPPLIED AS THE VALUE"
650 PRINT "       OF THE EXPRESSION."
660 PRINT
670 PRINT "               BEGIN TEST"
680 PRINT
690 LET S=1
700 LET M=10
710 LET F=1
720 LET A=-.8E-36
730 LET B=-1
740 PRINT "ABOUT TO COMPUTE ";A;" / ";M
750 LET A=A/M
760 PRINT "RESULT = ";A
770 PRINT
780 PRINT "----------------------------------------"
790 PRINT
800 IF B>=A THEN 870
810 IF A=0 THEN 870
820 LET B=A
830 LET S=0
840 LET F=F*1.1
850 LET M=10^F
860 GOTO 740
870 REM CONVERGE
880 IF S=0 THEN 920
890 PRINT "*** TEST FAILED: UNDERFLOW OCCURRED BELOW MINIMUM"
900 PRINT "    MACHINE INFINITESIMAL. ***"
910 GOTO 960
920 IF A=0 THEN 950
930 PRINT "*** TEST FAILED: VALUE SUPPLIED NOT EQUAL ZERO. ***"
940 GOTO 960
950 PRINT "*** TEST PASSED *** "
960 PRINT
970 PRINT "                END TEST"
980 PRINT
990 PRINT "END PROGRAM 33"
1000 END
