/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util;

import java.io.File;
import java.util.Date;
import java.util.Vector;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceFactory;
import org.apache.tools.ant.util.FileNameMapper;

public class ResourceUtils {
    public static Resource[] selectOutOfDateSources(ProjectComponent logTo, Resource[] source, FileNameMapper mapper, ResourceFactory targets) {
        long now = new Date().getTime();
        StringBuffer targetList = new StringBuffer();
        if (Os.isFamily("windows")) {
            now += 2000L;
        }
        Vector<Resource> vresult = new Vector<Resource>();
        for (int counter = 0; counter < source.length; ++counter) {
            String[] targetnames;
            if (source[counter].getLastModified() > now) {
                logTo.log("Warning: " + source[counter].getName() + " modified in the future.", 1);
            }
            if ((targetnames = mapper.mapFileName(source[counter].getName().replace('/', File.separatorChar))) != null) {
                boolean added = false;
                targetList.setLength(0);
                for (int ctarget = 0; !added && ctarget < targetnames.length; ++ctarget) {
                    Resource atarget = targets.getResource(targetnames[ctarget].replace(File.separatorChar, '/'));
                    if (!atarget.isExists()) {
                        logTo.log(source[counter].getName() + " added as " + atarget.getName() + " doesn't exist.", 3);
                        vresult.addElement(source[counter]);
                        added = true;
                        continue;
                    }
                    if (atarget.getLastModified() < source[counter].getLastModified()) {
                        logTo.log(source[counter].getName() + " added as " + atarget.getName() + " is outdated.", 3);
                        vresult.addElement(source[counter]);
                        added = true;
                        continue;
                    }
                    if (targetList.length() > 0) {
                        targetList.append(", ");
                    }
                    targetList.append(atarget.getName());
                }
                if (added) continue;
                logTo.log(source[counter].getName() + " omitted as " + targetList.toString() + (targetnames.length == 1 ? " is" : " are ") + " up to date.", 3);
                continue;
            }
            logTo.log(source[counter].getName() + " skipped - don't know how to handle it", 3);
        }
        Object[] result = new Resource[vresult.size()];
        vresult.copyInto(result);
        return result;
    }
}

