/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzt;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.games.PlayerLevelCreator;

public final class PlayerLevel
implements SafeParcelable {
    public static final Parcelable.Creator<PlayerLevel> CREATOR = new PlayerLevelCreator();
    private final int zzCY;
    private final int zzanQ;
    private final long zzanR;
    private final long zzanS;

    public PlayerLevel(int value, long minXp, long maxXp) {
        this(1, value, minXp, maxXp);
    }

    PlayerLevel(int versionCode, int levelNumber, long minXp, long maxXp) {
        zzu.zza(minXp >= 0L, (Object)"Min XP must be positive!");
        zzu.zza(maxXp > minXp, (Object)"Max XP must be more than min XP!");
        this.zzCY = versionCode;
        this.zzanQ = levelNumber;
        this.zzanR = minXp;
        this.zzanS = maxXp;
    }

    public int getVersionCode() {
        return this.zzCY;
    }

    public int getLevelNumber() {
        return this.zzanQ;
    }

    public long getMinXp() {
        return this.zzanR;
    }

    public long getMaxXp() {
        return this.zzanS;
    }

    public int hashCode() {
        return zzt.hashCode(this.zzanQ, this.zzanR, this.zzanS);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PlayerLevel)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        PlayerLevel playerLevel = (PlayerLevel)obj;
        return zzt.equal(playerLevel.getLevelNumber(), this.getLevelNumber()) && zzt.equal(playerLevel.getMinXp(), this.getMinXp()) && zzt.equal(playerLevel.getMaxXp(), this.getMaxXp());
    }

    public String toString() {
        return zzt.zzt(this).zzg("LevelNumber", this.getLevelNumber()).zzg("MinXp", this.getMinXp()).zzg("MaxXp", this.getMaxXp()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        PlayerLevelCreator.zza(this, out, flags);
    }
}

