/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import com.google.android.gms.analytics.ExceptionReporter;
import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.internal.zzab;
import com.google.android.gms.analytics.internal.zzad;
import com.google.android.gms.analytics.internal.zzal;
import com.google.android.gms.analytics.internal.zzam;
import com.google.android.gms.analytics.internal.zzd;
import com.google.android.gms.analytics.internal.zze;
import com.google.android.gms.analytics.internal.zzf;
import com.google.android.gms.analytics.internal.zzh;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.internal.zznx;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;

public class Tracker
extends zzd {
    private boolean zzIH;
    private final Map<String, String> zzyn = new HashMap<String, String>();
    private final Map<String, String> zzII = new HashMap<String, String>();
    private final zzad zzIJ;
    private final zza zzIK;
    private ExceptionReporter zzIL;
    private zzal zzIM;

    Tracker(zzf analytics, String trackingId, zzad rateLimiter) {
        super(analytics);
        if (trackingId != null) {
            this.zzyn.put("&tid", trackingId);
        }
        this.zzyn.put("useSecure", "1");
        this.zzyn.put("&a", Integer.toString(new Random().nextInt(Integer.MAX_VALUE) + 1));
        this.zzIJ = rateLimiter == null ? new zzad("tracking") : rateLimiter;
        this.zzIK = new zza(analytics);
    }

    @Override
    protected void zzhn() {
        String string2;
        this.zzIK.zza();
        String string3 = this.zzhm().zzjL();
        if (string3 != null) {
            this.set("&an", string3);
        }
        if ((string2 = this.zzhm().zzjN()) != null) {
            this.set("&av", string2);
        }
    }

    void zza(zzal zzal2) {
        String string2;
        this.zzaT("Loading Tracker config values");
        this.zzIM = zzal2;
        if (this.zzIM.zzky()) {
            string2 = this.zzIM.getTrackingId();
            this.set("&tid", string2);
            this.zza("trackingId loaded", string2);
        }
        if (this.zzIM.zzkz()) {
            string2 = Double.toString(this.zzIM.zzkA());
            this.set("&sf", string2);
            this.zza("Sample frequency loaded", string2);
        }
        if (this.zzIM.zzkB()) {
            int n = this.zzIM.getSessionTimeout();
            this.setSessionTimeout(n);
            this.zza("Session timeout loaded", n);
        }
        if (this.zzIM.zzkC()) {
            boolean bl = this.zzIM.zzkD();
            this.enableAutoActivityTracking(bl);
            this.zza("Auto activity tracking loaded", bl);
        }
        if (this.zzIM.zzkE()) {
            boolean bl = this.zzIM.zzkF();
            if (bl) {
                this.set("&aip", "1");
            }
            this.zza("Anonymize ip loaded", bl);
        }
        this.enableExceptionReporting(this.zzIM.zzkG());
    }

    private boolean zzho() {
        return this.zzIL != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableExceptionReporting(boolean enable) {
        Tracker tracker = this;
        synchronized (tracker) {
            if (this.zzho() == enable) {
                return;
            }
            if (enable) {
                Context context = this.getContext();
                Thread.UncaughtExceptionHandler uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
                this.zzIL = new ExceptionReporter(this, uncaughtExceptionHandler, context);
                Thread.setDefaultUncaughtExceptionHandler(this.zzIL);
                this.zzaT("Uncaught exceptions will be reported to Google Analytics");
            } else {
                Thread.UncaughtExceptionHandler uncaughtExceptionHandler = this.zzIL.zzhh();
                Thread.setDefaultUncaughtExceptionHandler(uncaughtExceptionHandler);
                this.zzaT("Uncaught exceptions will not be reported to Google Analytics");
            }
        }
    }

    public void setSessionTimeout(long sessionTimeout) {
        this.zzIK.setSessionTimeout(sessionTimeout * 1000L);
    }

    public void enableAutoActivityTracking(boolean enabled) {
        this.zzIK.enableAutoActivityTracking(enabled);
    }

    private static boolean zza(Map.Entry<String, String> entry) {
        String string2 = entry.getKey();
        String string3 = entry.getValue();
        return string2.startsWith("&") && string2.length() >= 2;
    }

    private static String zzb(Map.Entry<String, String> entry) {
        if (!Tracker.zza(entry)) {
            return null;
        }
        return entry.getKey().substring(1);
    }

    private static void zza(Map<String, String> map, Map<String, String> map2) {
        zzu.zzu(map2);
        if (map == null) {
            return;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string2 = Tracker.zzb(entry);
            if (string2 == null) continue;
            map2.put(string2, entry.getValue());
        }
    }

    private static void zzb(Map<String, String> map, Map<String, String> map2) {
        zzu.zzu(map2);
        if (map == null) {
            return;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string2 = Tracker.zzb(entry);
            if (string2 == null || map2.containsKey(string2)) continue;
            map2.put(string2, entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Map<String, String> params) {
        final long l = this.zzhP().currentTimeMillis();
        if (this.zzhg().getAppOptOut()) {
            this.zzaU("AppOptOut is set to true. Not sending Google Analytics hit");
            return;
        }
        final boolean bl = this.zzhg().isDryRunEnabled();
        final HashMap<String, String> hashMap = new HashMap<String, String>();
        Tracker.zza(this.zzyn, hashMap);
        Tracker.zza(params, hashMap);
        final boolean bl2 = zzam.zze(this.zzyn.get("useSecure"), true);
        Tracker.zzb(this.zzII, hashMap);
        this.zzII.clear();
        final String string2 = (String)hashMap.get("t");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.zzhQ().zzg(hashMap, "Missing hit type parameter");
            return;
        }
        final String string3 = (String)hashMap.get("tid");
        if (TextUtils.isEmpty((CharSequence)string3)) {
            this.zzhQ().zzg(hashMap, "Missing tracking id parameter");
            return;
        }
        final boolean bl3 = this.zzhp();
        Tracker tracker = this;
        synchronized (tracker) {
            if ("screenview".equalsIgnoreCase(string2) || "pageview".equalsIgnoreCase(string2) || "appview".equalsIgnoreCase(string2) || TextUtils.isEmpty((CharSequence)string2)) {
                int n = Integer.parseInt(this.zzyn.get("&a"));
                n = ++n >= Integer.MAX_VALUE ? 1 : n;
                this.zzyn.put("&a", Integer.toString(n));
            }
        }
        this.zzhS().zze(new Runnable(){

            @Override
            public void run() {
                boolean bl4;
                double d;
                if (Tracker.this.zzIK.zzhq()) {
                    hashMap.put("sc", "start");
                }
                zzam.zzc(hashMap, "cid", Tracker.this.zzhg().getClientId());
                String string22 = (String)hashMap.get("sf");
                if (string22 != null && zzam.zza(d = zzam.zza(string22, 100.0), (String)hashMap.get("cid"))) {
                    Tracker.this.zzb("Sampling enabled. Hit sampled out. sample rate", d);
                    return;
                }
                com.google.android.gms.analytics.internal.zza zza2 = Tracker.this.zzhW();
                if (bl3) {
                    zzam.zzb((Map<String, String>)hashMap, "ate", zza2.zzhy());
                    zzam.zzb((Map<String, String>)hashMap, "adid", zza2.zzhC());
                } else {
                    hashMap.remove("ate");
                    hashMap.remove("adid");
                }
                zznx zznx2 = Tracker.this.zzhX().zzix();
                zzam.zzb((Map<String, String>)hashMap, "an", zznx2.zzjL());
                zzam.zzb((Map<String, String>)hashMap, "av", zznx2.zzjN());
                zzam.zzb((Map<String, String>)hashMap, "aid", zznx2.zzsK());
                zzam.zzb((Map<String, String>)hashMap, "aiid", zznx2.zzwi());
                hashMap.put("v", "1");
                hashMap.put("_v", zze.zzJB);
                zzam.zzb((Map<String, String>)hashMap, "ul", Tracker.this.zzhY().zzjE().getLanguage());
                zzam.zzb((Map<String, String>)hashMap, "sr", Tracker.this.zzhY().zzjF());
                boolean bl22 = bl4 = string2.equals("transaction") || string2.equals("item");
                if (!bl4 && !Tracker.this.zzIJ.zzkb()) {
                    Tracker.this.zzhQ().zzg(hashMap, "Too many hits sent too quickly, rate limiting invoked");
                    return;
                }
                long l3 = zzam.zzbj((String)hashMap.get("ht"));
                if (l3 == 0L) {
                    l3 = l;
                }
                if (bl) {
                    zzab zzab2 = new zzab(Tracker.this, hashMap, l3, bl2);
                    Tracker.this.zzhQ().zzc("Dry run enabled. Would have sent hit", zzab2);
                    return;
                }
                String string32 = (String)hashMap.get("cid");
                HashMap<String, String> hashMap2 = new HashMap<String, String>();
                zzam.zza(hashMap2, "uid", hashMap);
                zzam.zza(hashMap2, "an", hashMap);
                zzam.zza(hashMap2, "aid", hashMap);
                zzam.zza(hashMap2, "av", hashMap);
                zzam.zza(hashMap2, "aiid", hashMap);
                zzh zzh2 = new zzh(0L, string32, string3, !TextUtils.isEmpty((CharSequence)((CharSequence)hashMap.get("adid"))), 0L, hashMap2);
                long l2 = Tracker.this.zzhl().zza(zzh2);
                hashMap.put("_s", String.valueOf(l2));
                zzab zzab3 = new zzab(Tracker.this, hashMap, l3, bl2);
                Tracker.this.zzhl().zza(zzab3);
            }
        });
    }

    public String get(String key) {
        this.zzia();
        if (TextUtils.isEmpty((CharSequence)key)) {
            return null;
        }
        if (this.zzyn.containsKey(key)) {
            return this.zzyn.get(key);
        }
        if (key.equals("&ul")) {
            return zzam.zza(Locale.getDefault());
        }
        if (key.equals("&cid")) {
            return this.zzhV().zziP();
        }
        if (key.equals("&sr")) {
            return this.zzhY().zzjF();
        }
        if (key.equals("&aid")) {
            return this.zzhX().zzix().zzsK();
        }
        if (key.equals("&an")) {
            return this.zzhX().zzix().zzjL();
        }
        if (key.equals("&av")) {
            return this.zzhX().zzix().zzjN();
        }
        if (key.equals("&aiid")) {
            return this.zzhX().zzix().zzwi();
        }
        return null;
    }

    public void set(String key, String value) {
        zzu.zzb(key, (Object)"Key should be non-null");
        if (TextUtils.isEmpty((CharSequence)key)) {
            return;
        }
        this.zzyn.put(key, value);
    }

    public void setSampleRate(double sampleRate) {
        this.set("&sf", Double.toString(sampleRate));
    }

    public void setUseSecure(boolean useSecure) {
        this.set("useSecure", zzam.zzH(useSecure));
    }

    public void setScreenName(String screenName) {
        this.set("&cd", screenName);
    }

    public void setLocation(String location) {
        this.set("&dl", location);
    }

    public void setReferrer(String referrer) {
        this.set("&dr", referrer);
    }

    public void setPage(String page) {
        this.set("&dp", page);
    }

    public void setHostname(String hostname) {
        this.set("&dh", hostname);
    }

    public void setTitle(String title) {
        this.set("&dt", title);
    }

    public void setLanguage(String language) {
        this.set("&ul", language);
    }

    public void setEncoding(String encoding) {
        this.set("&de", encoding);
    }

    public void setScreenColors(String screenColors) {
        this.set("&sd", screenColors);
    }

    public void setScreenResolution(int width, int height) {
        if (width < 0 && height < 0) {
            this.zzaW("Invalid width or height. The values should be non-negative.");
            return;
        }
        this.set("&sr", width + "x" + height);
    }

    public void setViewportSize(String viewportSize) {
        this.set("&vp", viewportSize);
    }

    public void setClientId(String clientId) {
        this.set("&cid", clientId);
    }

    public void setAppName(String appName) {
        this.set("&an", appName);
    }

    public void setAppId(String appId) {
        this.set("&aid", appId);
    }

    public void setAppInstallerId(String appInstallerId) {
        this.set("&aiid", appInstallerId);
    }

    public void setAppVersion(String appVersion) {
        this.set("&av", appVersion);
    }

    public void setAnonymizeIp(boolean anonymize) {
        this.set("&aip", zzam.zzH(anonymize));
    }

    public void setCampaignParamsOnNextHit(Uri uri) {
        if (uri == null || uri.isOpaque()) {
            return;
        }
        String string2 = uri.getQueryParameter("referrer");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        Uri uri2 = Uri.parse((String)("http://hostname/?" + string2));
        String string3 = uri2.getQueryParameter("utm_id");
        if (string3 != null) {
            this.zzII.put("&ci", string3);
        }
        if ((string3 = uri2.getQueryParameter("anid")) != null) {
            this.zzII.put("&anid", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_campaign")) != null) {
            this.zzII.put("&cn", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_content")) != null) {
            this.zzII.put("&cc", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_medium")) != null) {
            this.zzII.put("&cm", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_source")) != null) {
            this.zzII.put("&cs", string3);
        }
        if ((string3 = uri2.getQueryParameter("utm_term")) != null) {
            this.zzII.put("&ck", string3);
        }
        if ((string3 = uri2.getQueryParameter("dclid")) != null) {
            this.zzII.put("&dclid", string3);
        }
        if ((string3 = uri2.getQueryParameter("gclid")) != null) {
            this.zzII.put("&gclid", string3);
        }
        if ((string3 = uri2.getQueryParameter("aclid")) != null) {
            this.zzII.put("&aclid", string3);
        }
    }

    public void enableAdvertisingIdCollection(boolean enabled) {
        this.zzIH = enabled;
    }

    boolean zzhp() {
        return this.zzIH;
    }

    static String zzp(Activity activity) {
        zzu.zzu(activity);
        Intent intent = activity.getIntent();
        if (intent == null) {
            return null;
        }
        String string2 = intent.getStringExtra("android.intent.extra.REFERRER_NAME");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        return string2;
    }

    private class zza
    extends zzd
    implements GoogleAnalytics.zza {
        private boolean zzIV;
        private int zzIW;
        private long zzIX;
        private boolean zzIY;
        private long zzIZ;

        protected zza(zzf zzf2) {
            super(zzf2);
            this.zzIX = -1L;
        }

        @Override
        protected void zzhn() {
        }

        public void setSessionTimeout(long sessionTimeout) {
            this.zzIX = sessionTimeout;
            this.zzhr();
        }

        public void enableAutoActivityTracking(boolean enabled) {
            this.zzIV = enabled;
            this.zzhr();
        }

        public synchronized boolean zzhq() {
            boolean bl = this.zzIY;
            this.zzIY = false;
            return bl;
        }

        private void zzhr() {
            if (this.zzIX >= 0L || this.zzIV) {
                this.zzhg().zza(Tracker.this.zzIK);
            } else {
                this.zzhg().zzb(Tracker.this.zzIK);
            }
        }

        @Override
        public void zzn(Activity activity) {
            if (this.zzIW == 0 && this.zzhs()) {
                this.zzIY = true;
            }
            ++this.zzIW;
            if (this.zzIV) {
                String string2;
                Intent intent = activity.getIntent();
                if (intent != null) {
                    Tracker.this.setCampaignParamsOnNextHit(intent.getData());
                }
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("&t", "screenview");
                Tracker.this.set("&cd", Tracker.this.zzIM != null ? Tracker.this.zzIM.zzq(activity) : activity.getClass().getCanonicalName());
                if (TextUtils.isEmpty((CharSequence)((CharSequence)hashMap.get("&dr"))) && !TextUtils.isEmpty((CharSequence)(string2 = Tracker.zzp(activity)))) {
                    hashMap.put("&dr", string2);
                }
                Tracker.this.send(hashMap);
            }
        }

        @Override
        public void zzo(Activity activity) {
            --this.zzIW;
            this.zzIW = Math.max(0, this.zzIW);
            if (this.zzIW == 0) {
                this.zzIZ = this.zzhP().elapsedRealtime();
            }
        }

        boolean zzhs() {
            return this.zzhP().elapsedRealtime() >= this.zzIZ + Math.max(1000L, this.zzIX);
        }
    }
}

