/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.Messenger;
import android.os.RemoteException;
import android.view.View;
import com.google.android.gms.ads.internal.client.AdRequestParcel;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.zzk;
import com.google.android.gms.ads.internal.overlay.zzf;
import com.google.android.gms.ads.internal.purchase.GInAppPurchaseManagerInfoParcel;
import com.google.android.gms.ads.internal.purchase.zzc;
import com.google.android.gms.ads.internal.purchase.zzd;
import com.google.android.gms.ads.internal.purchase.zzg;
import com.google.android.gms.ads.internal.purchase.zzj;
import com.google.android.gms.ads.internal.request.AdRequestInfoParcel;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.zza;
import com.google.android.gms.ads.internal.zzl;
import com.google.android.gms.ads.internal.zzn;
import com.google.android.gms.ads.internal.zzo;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.internal.zzbz;
import com.google.android.gms.internal.zzdi;
import com.google.android.gms.internal.zzdz;
import com.google.android.gms.internal.zzef;
import com.google.android.gms.internal.zzfc;
import com.google.android.gms.internal.zzff;
import com.google.android.gms.internal.zzfj;
import com.google.android.gms.internal.zzgd;
import com.google.android.gms.internal.zzha;
import com.google.android.gms.internal.zzhb;
import com.google.android.gms.internal.zzhl;
import java.util.ArrayList;
import java.util.UUID;

@zzgd
public abstract class zzb
extends zza
implements zzf,
zzj,
zzdi,
zzdz {
    protected final zzef zzoq;
    private final Messenger mMessenger;
    protected transient boolean zzor;

    public zzb(Context context, AdSizeParcel adSizeParcel, String string2, zzef zzef2, VersionInfoParcel versionInfoParcel) {
        this(new zzp(context, adSizeParcel, string2, versionInfoParcel), zzef2, null);
    }

    zzb(zzp zzp2, zzef zzef2, zzn zzn2) {
        super(zzp2, zzn2);
        this.zzoq = zzef2;
        this.mMessenger = new Messenger((Handler)new zzfc(this.zzon.zzpH));
        this.zzor = false;
    }

    @Override
    public boolean zzb(AdRequestParcel adRequestParcel) {
        if (!this.zzaU()) {
            return false;
        }
        Bundle bundle = null;
        bundle = this.zza(zzo.zzby().zzD(this.zzon.zzpH));
        this.zzom.cancel();
        this.zzon.zzqh = 0;
        AdRequestInfoParcel.zza zza2 = this.zza(adRequestParcel, bundle);
        this.zzon.zzpL = zzo.zzbr().zza(this.zzon.zzpH, zza2, this.zzon.zzpI, this);
        return true;
    }

    @Override
    public void zzb(zzha zzha2) {
        super.zzb(zzha2);
        if (zzha2.errorCode == 3 && zzha2.zzFm != null && zzha2.zzFm.zzxH != null) {
            com.google.android.gms.ads.internal.util.client.zzb.zzay("Pinging no fill URLs.");
            zzo.zzbG().zza(this.zzon.zzpH, this.zzon.zzpJ.zzGG, zzha2, this.zzon.zzpG, false, zzha2.zzFm.zzxH);
        }
    }

    @Override
    protected boolean zza(zzha zzha2, zzha zzha3) {
        if (zzha2 != null && zzha2.zzyc != null) {
            zzha2.zzyc.zza((zzdz)null);
        }
        if (zzha3.zzyc != null) {
            zzha3.zzyc.zza(this);
        }
        int n = 0;
        int n2 = 0;
        if (zzha3.zzFm != null) {
            n = zzha3.zzFm.zzxM;
            n2 = zzha3.zzFm.zzxN;
        }
        this.zzon.zzqf.zzf(n, n2);
        return true;
    }

    @Override
    public void onAdClicked() {
        if (this.zzon.zzpO == null) {
            com.google.android.gms.ads.internal.util.client.zzb.zzaC("Ad state was null when trying to ping click URLs.");
            return;
        }
        if (this.zzon.zzpO.zzFm != null && this.zzon.zzpO.zzFm.zzxF != null) {
            zzo.zzbG().zza(this.zzon.zzpH, this.zzon.zzpJ.zzGG, this.zzon.zzpO, this.zzon.zzpG, false, this.zza(this.zzon.zzpO.zzFm.zzxF, this.zzon.zzpO.zzCC));
        }
        if (this.zzon.zzpO.zzxZ != null && this.zzon.zzpO.zzxZ.zzxx != null) {
            zzo.zzbG().zza(this.zzon.zzpH, this.zzon.zzpJ.zzGG, this.zzon.zzpO, this.zzon.zzpG, false, this.zzon.zzpO.zzxZ.zzxx);
        }
        super.onAdClicked();
    }

    @Override
    boolean zza(zzha zzha2) {
        AdRequestParcel adRequestParcel;
        boolean bl = false;
        if (this.zzoo != null) {
            adRequestParcel = this.zzoo;
            this.zzoo = null;
        } else {
            adRequestParcel = zzha2.zzCm;
            bl = adRequestParcel.extras != null ? adRequestParcel.extras.getBoolean("_noRefresh", false) : false;
        }
        return this.zza(adRequestParcel, zzha2, bl);
    }

    protected boolean zza(AdRequestParcel adRequestParcel, zzha zzha2, boolean bl) {
        if (!bl && this.zzon.zzbM()) {
            if (zzha2.zzxJ > 0L) {
                this.zzom.zza(adRequestParcel, zzha2.zzxJ);
            } else if (zzha2.zzFm != null && zzha2.zzFm.zzxJ > 0L) {
                this.zzom.zza(adRequestParcel, zzha2.zzFm.zzxJ);
            } else if (!zzha2.zzCK && zzha2.errorCode == 2) {
                this.zzom.zzf(adRequestParcel);
            }
        }
        return this.zzom.zzbp();
    }

    @Override
    public void pause() {
        zzu.zzbY("pause must be called on the main UI thread.");
        if (this.zzon.zzpO != null && this.zzon.zzbM()) {
            zzo.zzbx().zza(this.zzon.zzpO.zzzE.getWebView());
        }
        if (this.zzon.zzpO != null && this.zzon.zzpO.zzya != null) {
            try {
                this.zzon.zzpO.zzya.pause();
            }
            catch (RemoteException remoteException) {
                com.google.android.gms.ads.internal.util.client.zzb.zzaC("Could not pause mediation adapter.");
            }
        }
        this.zzop.zzi(this.zzon.zzpO);
        this.zzom.pause();
    }

    @Override
    public void resume() {
        zzu.zzbY("resume must be called on the main UI thread.");
        if (this.zzon.zzpO != null && this.zzon.zzbM()) {
            zzo.zzbx().zzb(this.zzon.zzpO.zzzE.getWebView());
        }
        if (this.zzon.zzpO != null && this.zzon.zzpO.zzya != null) {
            try {
                this.zzon.zzpO.zzya.resume();
            }
            catch (RemoteException remoteException) {
                com.google.android.gms.ads.internal.util.client.zzb.zzaC("Could not resume mediation adapter.");
            }
        }
        this.zzom.resume();
        this.zzop.zzj(this.zzon.zzpO);
    }

    @Override
    protected boolean zzc(AdRequestParcel adRequestParcel) {
        return super.zzc(adRequestParcel) && !this.zzor;
    }

    protected boolean zzaU() {
        boolean bl = true;
        if (!zzo.zzbv().zza(this.zzon.zzpH.getPackageManager(), this.zzon.zzpH.getPackageName(), "android.permission.INTERNET") || !zzo.zzbv().zzG(this.zzon.zzpH)) {
            bl = false;
        }
        return bl;
    }

    @Override
    public void zzaV() {
        this.zzop.zzg(this.zzon.zzpO);
        this.zzor = false;
        this.zzaQ();
        this.zzon.zzpQ.zzfR();
    }

    @Override
    public void zzaW() {
        this.zzor = true;
        this.zzaS();
    }

    @Override
    public void zzaX() {
        this.onAdClicked();
    }

    @Override
    public void zzaY() {
        this.zzaV();
    }

    @Override
    public void zzaZ() {
        this.zzaO();
    }

    @Override
    public void zzba() {
        this.zzaW();
    }

    @Override
    public void zzbb() {
        if (this.zzon.zzpO != null) {
            com.google.android.gms.ads.internal.util.client.zzb.zzaC("Mediation adapter " + this.zzon.zzpO.zzyb + " refreshed, but mediation adapters should never refresh.");
        }
        this.zza(this.zzon.zzpO, true);
        this.zzaT();
    }

    private AdRequestInfoParcel.zza zza(AdRequestParcel adRequestParcel, Bundle bundle) {
        Object object;
        Object object2;
        PackageInfo packageInfo;
        PackageManager packageManager;
        ApplicationInfo applicationInfo = this.zzon.zzpH.getApplicationInfo();
        try {
            packageManager = this.zzon.zzpH.getPackageManager();
            packageInfo = packageManager.getPackageInfo(applicationInfo.packageName, 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            packageInfo = null;
        }
        packageManager = this.zzon.zzpH.getResources().getDisplayMetrics();
        Bundle bundle2 = null;
        if (this.zzon.zzpK != null && this.zzon.zzpK.getParent() != null) {
            object2 = new int[2];
            this.zzon.zzpK.getLocationOnScreen((int[])object2);
            Object object3 = object2[0];
            object = object2[1];
            int bl = this.zzon.zzpK.getWidth();
            int l = this.zzon.zzpK.getHeight();
            int n = 0;
            if (this.zzon.zzpK.isShown() && object3 + bl > 0 && object + l > 0 && object3 <= packageManager.widthPixels && object <= packageManager.heightPixels) {
                n = 1;
            }
            bundle2 = new Bundle(5);
            bundle2.putInt("x", (int)object3);
            bundle2.putInt("y", (int)object);
            bundle2.putInt("width", bl);
            bundle2.putInt("height", l);
            bundle2.putInt("visible", n);
        }
        object2 = zzo.zzby().zzfW();
        this.zzon.zzpQ = new zzhb((String)object2, this.zzon.zzpG);
        this.zzon.zzpQ.zzh(adRequestParcel);
        String string2 = zzo.zzbv().zza(this.zzon.zzpH, (View)this.zzon.zzpK, this.zzon.zzpN);
        object = zzl.zzq(this.zzon.zzpH).zzbn();
        boolean bl = zzl.zzq(this.zzon.zzpH).zzbl();
        long l = 0L;
        if (this.zzon.zzpU != null) {
            try {
                l = this.zzon.zzpU.getValue();
            }
            catch (RemoteException string3) {
                com.google.android.gms.ads.internal.util.client.zzb.zzaC("Cannot get correlation id, default to 0.");
            }
        }
        String string3 = UUID.randomUUID().toString();
        Bundle bundle3 = zzo.zzby().zza(this.zzon.zzpH, this, (String)object2);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.zzon.zzqa.size(); ++i) {
            arrayList.add(this.zzon.zzqa.keyAt(i));
        }
        return new AdRequestInfoParcel.zza(bundle2, adRequestParcel, this.zzon.zzpN, this.zzon.zzpG, applicationInfo, packageInfo, (String)object2, zzo.zzby().getSessionId(), this.zzon.zzpJ, bundle3, this.zzon.zzqd, arrayList, bundle, zzo.zzby().zzga(), this.mMessenger, packageManager.widthPixels, packageManager.heightPixels, packageManager.density, string2, bl, (int)object, l, string3, zzbz.zzdb(), this.zzon.zzpF, this.zzon.zzqb);
    }

    @Override
    public void zza(zzff zzff2) {
        zzu.zzbY("setInAppPurchaseListener must be called on the main UI thread.");
        this.zzon.zzpV = zzff2;
    }

    @Override
    public void zza(zzfj zzfj2, String string2) {
        zzu.zzbY("setPlayStorePurchaseParams must be called on the main UI thread.");
        this.zzon.zzqe = new com.google.android.gms.ads.internal.purchase.zzk(string2);
        this.zzon.zzpW = zzfj2;
        if (!zzo.zzby().zzfZ() && zzfj2 != null) {
            new zzc(this.zzon.zzpH, this.zzon.zzpW, this.zzon.zzqe).zzgi();
        }
    }

    @Override
    public void zza(String string2, ArrayList<String> arrayList) {
        zzd zzd2 = new zzd(string2, arrayList, this.zzon.zzpH, this.zzon.zzpJ.zzGG);
        if (this.zzon.zzpV == null) {
            com.google.android.gms.ads.internal.util.client.zzb.zzaC("InAppPurchaseListener is not set. Try to launch default purchase flow.");
            if (!zzk.zzcA().zzP(this.zzon.zzpH)) {
                com.google.android.gms.ads.internal.util.client.zzb.zzaC("Google Play Service unavailable, cannot launch default purchase flow.");
                return;
            }
            if (this.zzon.zzpW == null) {
                com.google.android.gms.ads.internal.util.client.zzb.zzaC("PlayStorePurchaseListener is not set.");
                return;
            }
            if (this.zzon.zzqe == null) {
                com.google.android.gms.ads.internal.util.client.zzb.zzaC("PlayStorePurchaseVerifier is not initialized.");
                return;
            }
            if (this.zzon.zzqi) {
                com.google.android.gms.ads.internal.util.client.zzb.zzaC("An in-app purchase request is already in progress, abort");
                return;
            }
            this.zzon.zzqi = true;
            try {
                if (!this.zzon.zzpW.isValidPurchase(string2)) {
                    this.zzon.zzqi = false;
                    return;
                }
            }
            catch (RemoteException remoteException) {
                com.google.android.gms.ads.internal.util.client.zzb.zzaC("Could not start In-App purchase.");
                this.zzon.zzqi = false;
                return;
            }
            zzo.zzbF().zza(this.zzon.zzpH, this.zzon.zzpJ.zzGJ, new GInAppPurchaseManagerInfoParcel(this.zzon.zzpH, this.zzon.zzqe, zzd2, this));
        } else {
            try {
                this.zzon.zzpV.zza(zzd2);
            }
            catch (RemoteException remoteException) {
                com.google.android.gms.ads.internal.util.client.zzb.zzaC("Could not start In-App purchase.");
            }
        }
    }

    @Override
    public void zza(String string2, boolean bl, int n, final Intent intent, com.google.android.gms.ads.internal.purchase.zzf zzf2) {
        try {
            if (this.zzon.zzpW != null) {
                this.zzon.zzpW.zza(new zzg(this.zzon.zzpH, string2, bl, n, intent, zzf2));
            }
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.client.zzb.zzaC("Fail to invoke PlayStorePurchaseListener.");
        }
        zzhl.zzGk.postDelayed(new Runnable(){

            @Override
            public void run() {
                int n = zzo.zzbF().zzd(intent);
                zzo.zzbF();
                if (n == 0 && zzb.this.zzon.zzpO != null && zzb.this.zzon.zzpO.zzzE != null && zzb.this.zzon.zzpO.zzzE.zzgD() != null) {
                    zzb.this.zzon.zzpO.zzzE.zzgD().close();
                }
                zzb.this.zzon.zzqi = false;
            }
        }, 500L);
    }

    protected void zza(zzha zzha2, boolean bl) {
        if (zzha2 == null) {
            com.google.android.gms.ads.internal.util.client.zzb.zzaC("Ad state was null when trying to ping impression URLs.");
            return;
        }
        super.zzc(zzha2);
        if (zzha2.zzFm != null && zzha2.zzFm.zzxG != null) {
            zzo.zzbG().zza(this.zzon.zzpH, this.zzon.zzpJ.zzGG, zzha2, this.zzon.zzpG, bl, this.zza(zzha2.zzFm.zzxG, zzha2.zzCC));
        }
        if (zzha2.zzxZ != null && zzha2.zzxZ.zzxy != null) {
            zzo.zzbG().zza(this.zzon.zzpH, this.zzon.zzpJ.zzGG, zzha2, this.zzon.zzpG, bl, zzha2.zzxZ.zzxy);
        }
    }

    @Override
    public String getMediationAdapterClassName() {
        if (this.zzon.zzpO == null) {
            return null;
        }
        return this.zzon.zzpO.zzyb;
    }

    @Override
    public void showInterstitial() {
        throw new IllegalStateException("showInterstitial is not supported for current ad type");
    }
}

