/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt5.android;

import android.app.Service;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.qtproject.qt5.android.QtNative;
import org.qtproject.qt5.android.QtNativeLibrariesDir;

public class QtServiceDelegate {
    private static final String NATIVE_LIBRARIES_KEY = "native.libraries";
    private static final String BUNDLED_LIBRARIES_KEY = "bundled.libraries";
    private static final String MAIN_LIBRARY_KEY = "main.library";
    private static final String ENVIRONMENT_VARIABLES_KEY = "environment.variables";
    private static final String APPLICATION_PARAMETERS_KEY = "application.parameters";
    private static final String STATIC_INIT_CLASSES_KEY = "static.init.classes";
    private static final String APP_DISPLAY_METRIC_SCREEN_DESKTOP_KEY = "display.screen.desktop";
    private static final String APP_DISPLAY_METRIC_SCREEN_XDPI_KEY = "display.screen.dpi.x";
    private static final String APP_DISPLAY_METRIC_SCREEN_YDPI_KEY = "display.screen.dpi.y";
    private static final String APP_DISPLAY_METRIC_SCREEN_DENSITY_KEY = "display.screen.density";
    private Service m_service = null;
    private String m_mainLib;
    private static String m_environmentVariables = null;
    private static String m_applicationParameters = null;

    public boolean loadApplication(Service service, ClassLoader classLoader, Bundle bundle) {
        if (!bundle.containsKey(NATIVE_LIBRARIES_KEY) || !bundle.containsKey(BUNDLED_LIBRARIES_KEY)) {
            return false;
        }
        this.m_service = service;
        QtNative.setService(this.m_service, this);
        QtNative.setClassLoader(classLoader);
        QtNative.setApplicationDisplayMetrics(10, 10, 10, 10, 120.0, 120.0, 1.0, 1.0);
        if (bundle.containsKey(STATIC_INIT_CLASSES_KEY)) {
            for (String string : bundle.getStringArray(STATIC_INIT_CLASSES_KEY)) {
                if (string.length() == 0) continue;
                try {
                    Method exception;
                    Class<?> exception2 = classLoader.loadClass(string);
                    Object obj = exception2.newInstance();
                    try {
                        exception = exception2.getMethod("setService", Service.class, Object.class);
                        exception.invoke(obj, this.m_service, this);
                    }
                    catch (Exception exception3) {
                        // empty catch block
                    }
                    try {
                        exception = exception2.getMethod("setContext", Context.class);
                        exception.invoke(obj, this.m_service);
                    }
                    catch (Exception exception4) {}
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        QtNative.loadQtLibraries(bundle.getStringArrayList(NATIVE_LIBRARIES_KEY));
        ArrayList arrayList = bundle.getStringArrayList(BUNDLED_LIBRARIES_KEY);
        QtNative.loadBundledLibraries(arrayList, QtNativeLibrariesDir.nativeLibrariesDir((Context)this.m_service));
        this.m_mainLib = bundle.getString(MAIN_LIBRARY_KEY);
        m_environmentVariables = bundle.getString(ENVIRONMENT_VARIABLES_KEY);
        String string = "QT_ANDROID_FONTS_MONOSPACE=Droid Sans Mono;Droid Sans;Droid Sans Fallback\tQT_ANDROID_FONTS_SERIF=Droid Serif\tHOME=" + this.m_service.getFilesDir().getAbsolutePath() + "\tTMPDIR=" + this.m_service.getFilesDir().getAbsolutePath();
        string = Build.VERSION.SDK_INT < 14 ? string + "\tQT_ANDROID_FONTS=Droid Sans;Droid Sans Fallback" : string + "\tQT_ANDROID_FONTS=Roboto;Droid Sans;Droid Sans Fallback";
        m_environmentVariables = m_environmentVariables != null && m_environmentVariables.length() > 0 ? string + "\t" + m_environmentVariables : string;
        m_applicationParameters = bundle.containsKey(APPLICATION_PARAMETERS_KEY) ? bundle.getString(APPLICATION_PARAMETERS_KEY) : "";
        return true;
    }

    public boolean startApplication() {
        try {
            String string = QtNativeLibrariesDir.nativeLibrariesDir((Context)this.m_service);
            QtNative.startApplication(m_applicationParameters, m_environmentVariables, this.m_mainLib, string);
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public void onDestroy() {
        QtNative.setService(null, null);
    }
}

