/*
 * Copyright (c) 2016 Apple Inc. All rights reserved.
 * Copyright (c) 2016 Canon Inc. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */

// DO NOT EDIT THIS FILE. It is automatically generated from JavaScript files for
// builtins by the script: Source/JavaScriptCore/Scripts/generate-js-builtins.py

#pragma once

#include <JavaScriptCore/BuiltinUtils.h>
#include <JavaScriptCore/Identifier.h>
#include <JavaScriptCore/JSFunction.h>
#include <JavaScriptCore/UnlinkedFunctionExecutable.h>

namespace JSC {
class FunctionExecutable;
}

namespace WebCore {

/* ReadableByteStreamInternals */
extern const char* const s_readableByteStreamInternalsPrivateInitializeReadableByteStreamControllerCode;
extern const int s_readableByteStreamInternalsPrivateInitializeReadableByteStreamControllerCodeLength;
extern const JSC::ConstructAbility s_readableByteStreamInternalsPrivateInitializeReadableByteStreamControllerCodeConstructAbility;
extern const JSC::ConstructorKind s_readableByteStreamInternalsPrivateInitializeReadableByteStreamControllerCodeConstructorKind;
extern const char* const s_readableByteStreamInternalsPrivateInitializeReadableStreamBYOBRequestCode;
extern const int s_readableByteStreamInternalsPrivateInitializeReadableStreamBYOBRequestCodeLength;
extern const JSC::ConstructAbility s_readableByteStreamInternalsPrivateInitializeReadableStreamBYOBRequestCodeConstructAbility;
extern const JSC::ConstructorKind s_readableByteStreamInternalsPrivateInitializeReadableStreamBYOBRequestCodeConstructorKind;
extern const char* const s_readableByteStreamInternalsIsReadableByteStreamControllerCode;
extern const int s_readableByteStreamInternalsIsReadableByteStreamControllerCodeLength;
extern const JSC::ConstructAbility s_readableByteStreamInternalsIsReadableByteStreamControllerCodeConstructAbility;
extern const JSC::ConstructorKind s_readableByteStreamInternalsIsReadableByteStreamControllerCodeConstructorKind;
extern const char* const s_readableByteStreamInternalsIsReadableStreamBYOBRequestCode;
extern const int s_readableByteStreamInternalsIsReadableStreamBYOBRequestCodeLength;
extern const JSC::ConstructAbility s_readableByteStreamInternalsIsReadableStreamBYOBRequestCodeConstructAbility;
extern const JSC::ConstructorKind s_readableByteStreamInternalsIsReadableStreamBYOBRequestCodeConstructorKind;
extern const char* const s_readableByteStreamInternalsIsReadableStreamBYOBReaderCode;
extern const int s_readableByteStreamInternalsIsReadableStreamBYOBReaderCodeLength;
extern const JSC::ConstructAbility s_readableByteStreamInternalsIsReadableStreamBYOBReaderCodeConstructAbility;
extern const JSC::ConstructorKind s_readableByteStreamInternalsIsReadableStreamBYOBReaderCodeConstructorKind;
extern const char* const s_readableByteStreamInternalsReadableByteStreamControllerCancelCode;
extern const int s_readableByteStreamInternalsReadableByteStreamControllerCancelCodeLength;
extern const JSC::ConstructAbility s_readableByteStreamInternalsReadableByteStreamControllerCancelCodeConstructAbility;
extern const JSC::ConstructorKind s_readableByteStreamInternalsReadableByteStreamControllerCancelCodeConstructorKind;
extern const char* const s_readableByteStreamInternalsReadableByteStreamControllerErrorCode;
extern const int s_readableByteStreamInternalsReadableByteStreamControllerErrorCodeLength;
extern const JSC::ConstructAbility s_readableByteStreamInternalsReadableByteStreamControllerErrorCodeConstructAbility;
extern const JSC::ConstructorKind s_readableByteStreamInternalsReadableByteStreamControllerErrorCodeConstructorKind;
extern const char* const s_readableByteStreamInternalsReadableByteStreamControllerCloseCode;
extern const int s_readableByteStreamInternalsReadableByteStreamControllerCloseCodeLength;
extern const JSC::ConstructAbility s_readableByteStreamInternalsReadableByteStreamControllerCloseCodeConstructAbility;
extern const JSC::ConstructorKind s_readableByteStreamInternalsReadableByteStreamControllerCloseCodeConstructorKind;
extern const char* const s_readableByteStreamInternalsReadableByteStreamControllerClearPendingPullIntosCode;
extern const int s_readableByteStreamInternalsReadableByteStreamControllerClearPendingPullIntosCodeLength;
extern const JSC::ConstructAbility s_readableByteStreamInternalsReadableByteStreamControllerClearPendingPullIntosCodeConstructAbility;
extern const JSC::ConstructorKind s_readableByteStreamInternalsReadableByteStreamControllerClearPendingPullIntosCodeConstructorKind;
extern const char* const s_readableByteStreamInternalsReadableByteStreamControllerGetDesiredSizeCode;
extern const int s_readableByteStreamInternalsReadableByteStreamControllerGetDesiredSizeCodeLength;
extern const JSC::ConstructAbility s_readableByteStreamInternalsReadableByteStreamControllerGetDesiredSizeCodeConstructAbility;
extern const JSC::ConstructorKind s_readableByteStreamInternalsReadableByteStreamControllerGetDesiredSizeCodeConstructorKind;
extern const char* const s_readableByteStreamInternalsReadableStreamHasBYOBReaderCode;
extern const int s_readableByteStreamInternalsReadableStreamHasBYOBReaderCodeLength;
extern const JSC::ConstructAbility s_readableByteStreamInternalsReadableStreamHasBYOBReaderCodeConstructAbility;
extern const JSC::ConstructorKind s_readableByteStreamInternalsReadableStreamHasBYOBReaderCodeConstructorKind;
extern const char* const s_readableByteStreamInternalsReadableStreamHasDefaultReaderCode;
extern const int s_readableByteStreamInternalsReadableStreamHasDefaultReaderCodeLength;
extern const JSC::ConstructAbility s_readableByteStreamInternalsReadableStreamHasDefaultReaderCodeConstructAbility;
extern const JSC::ConstructorKind s_readableByteStreamInternalsReadableStreamHasDefaultReaderCodeConstructorKind;
extern const char* const s_readableByteStreamInternalsReadableByteStreamControllerHandleQueueDrainCode;
extern const int s_readableByteStreamInternalsReadableByteStreamControllerHandleQueueDrainCodeLength;
extern const JSC::ConstructAbility s_readableByteStreamInternalsReadableByteStreamControllerHandleQueueDrainCodeConstructAbility;
extern const JSC::ConstructorKind s_readableByteStreamInternalsReadableByteStreamControllerHandleQueueDrainCodeConstructorKind;
extern const char* const s_readableByteStreamInternalsReadableByteStreamControllerPullCode;
extern const int s_readableByteStreamInternalsReadableByteStreamControllerPullCodeLength;
extern const JSC::ConstructAbility s_readableByteStreamInternalsReadableByteStreamControllerPullCodeConstructAbility;
extern const JSC::ConstructorKind s_readableByteStreamInternalsReadableByteStreamControllerPullCodeConstructorKind;
extern const char* const s_readableByteStreamInternalsReadableByteStreamControllerShouldCallPullCode;
extern const int s_readableByteStreamInternalsReadableByteStreamControllerShouldCallPullCodeLength;
extern const JSC::ConstructAbility s_readableByteStreamInternalsReadableByteStreamControllerShouldCallPullCodeConstructAbility;
extern const JSC::ConstructorKind s_readableByteStreamInternalsReadableByteStreamControllerShouldCallPullCodeConstructorKind;
extern const char* const s_readableByteStreamInternalsReadableByteStreamControllerCallPullIfNeededCode;
extern const int s_readableByteStreamInternalsReadableByteStreamControllerCallPullIfNeededCodeLength;
extern const JSC::ConstructAbility s_readableByteStreamInternalsReadableByteStreamControllerCallPullIfNeededCodeConstructAbility;
extern const JSC::ConstructorKind s_readableByteStreamInternalsReadableByteStreamControllerCallPullIfNeededCodeConstructorKind;
extern const char* const s_readableByteStreamInternalsTransferBufferToCurrentRealmCode;
extern const int s_readableByteStreamInternalsTransferBufferToCurrentRealmCodeLength;
extern const JSC::ConstructAbility s_readableByteStreamInternalsTransferBufferToCurrentRealmCodeConstructAbility;
extern const JSC::ConstructorKind s_readableByteStreamInternalsTransferBufferToCurrentRealmCodeConstructorKind;
extern const char* const s_readableByteStreamInternalsReadableByteStreamControllerEnqueueCode;
extern const int s_readableByteStreamInternalsReadableByteStreamControllerEnqueueCodeLength;
extern const JSC::ConstructAbility s_readableByteStreamInternalsReadableByteStreamControllerEnqueueCodeConstructAbility;
extern const JSC::ConstructorKind s_readableByteStreamInternalsReadableByteStreamControllerEnqueueCodeConstructorKind;
extern const char* const s_readableByteStreamInternalsReadableByteStreamControllerEnqueueChunkCode;
extern const int s_readableByteStreamInternalsReadableByteStreamControllerEnqueueChunkCodeLength;
extern const JSC::ConstructAbility s_readableByteStreamInternalsReadableByteStreamControllerEnqueueChunkCodeConstructAbility;
extern const JSC::ConstructorKind s_readableByteStreamInternalsReadableByteStreamControllerEnqueueChunkCodeConstructorKind;
extern const char* const s_readableByteStreamInternalsReadableByteStreamControllerRespondWithNewViewCode;
extern const int s_readableByteStreamInternalsReadableByteStreamControllerRespondWithNewViewCodeLength;
extern const JSC::ConstructAbility s_readableByteStreamInternalsReadableByteStreamControllerRespondWithNewViewCodeConstructAbility;
extern const JSC::ConstructorKind s_readableByteStreamInternalsReadableByteStreamControllerRespondWithNewViewCodeConstructorKind;
extern const char* const s_readableByteStreamInternalsReadableByteStreamControllerRespondCode;
extern const int s_readableByteStreamInternalsReadableByteStreamControllerRespondCodeLength;
extern const JSC::ConstructAbility s_readableByteStreamInternalsReadableByteStreamControllerRespondCodeConstructAbility;
extern const JSC::ConstructorKind s_readableByteStreamInternalsReadableByteStreamControllerRespondCodeConstructorKind;
extern const char* const s_readableByteStreamInternalsReadableByteStreamControllerRespondInternalCode;
extern const int s_readableByteStreamInternalsReadableByteStreamControllerRespondInternalCodeLength;
extern const JSC::ConstructAbility s_readableByteStreamInternalsReadableByteStreamControllerRespondInternalCodeConstructAbility;
extern const JSC::ConstructorKind s_readableByteStreamInternalsReadableByteStreamControllerRespondInternalCodeConstructorKind;
extern const char* const s_readableByteStreamInternalsReadableByteStreamControllerRespondInReadableStateCode;
extern const int s_readableByteStreamInternalsReadableByteStreamControllerRespondInReadableStateCodeLength;
extern const JSC::ConstructAbility s_readableByteStreamInternalsReadableByteStreamControllerRespondInReadableStateCodeConstructAbility;
extern const JSC::ConstructorKind s_readableByteStreamInternalsReadableByteStreamControllerRespondInReadableStateCodeConstructorKind;
extern const char* const s_readableByteStreamInternalsReadableByteStreamControllerRespondInClosedStateCode;
extern const int s_readableByteStreamInternalsReadableByteStreamControllerRespondInClosedStateCodeLength;
extern const JSC::ConstructAbility s_readableByteStreamInternalsReadableByteStreamControllerRespondInClosedStateCodeConstructAbility;
extern const JSC::ConstructorKind s_readableByteStreamInternalsReadableByteStreamControllerRespondInClosedStateCodeConstructorKind;
extern const char* const s_readableByteStreamInternalsReadableByteStreamControllerProcessPullDescriptorsCode;
extern const int s_readableByteStreamInternalsReadableByteStreamControllerProcessPullDescriptorsCodeLength;
extern const JSC::ConstructAbility s_readableByteStreamInternalsReadableByteStreamControllerProcessPullDescriptorsCodeConstructAbility;
extern const JSC::ConstructorKind s_readableByteStreamInternalsReadableByteStreamControllerProcessPullDescriptorsCodeConstructorKind;
extern const char* const s_readableByteStreamInternalsReadableByteStreamControllerFillDescriptorFromQueueCode;
extern const int s_readableByteStreamInternalsReadableByteStreamControllerFillDescriptorFromQueueCodeLength;
extern const JSC::ConstructAbility s_readableByteStreamInternalsReadableByteStreamControllerFillDescriptorFromQueueCodeConstructAbility;
extern const JSC::ConstructorKind s_readableByteStreamInternalsReadableByteStreamControllerFillDescriptorFromQueueCodeConstructorKind;
extern const char* const s_readableByteStreamInternalsReadableByteStreamControllerShiftPendingDescriptorCode;
extern const int s_readableByteStreamInternalsReadableByteStreamControllerShiftPendingDescriptorCodeLength;
extern const JSC::ConstructAbility s_readableByteStreamInternalsReadableByteStreamControllerShiftPendingDescriptorCodeConstructAbility;
extern const JSC::ConstructorKind s_readableByteStreamInternalsReadableByteStreamControllerShiftPendingDescriptorCodeConstructorKind;
extern const char* const s_readableByteStreamInternalsReadableByteStreamControllerInvalidateBYOBRequestCode;
extern const int s_readableByteStreamInternalsReadableByteStreamControllerInvalidateBYOBRequestCodeLength;
extern const JSC::ConstructAbility s_readableByteStreamInternalsReadableByteStreamControllerInvalidateBYOBRequestCodeConstructAbility;
extern const JSC::ConstructorKind s_readableByteStreamInternalsReadableByteStreamControllerInvalidateBYOBRequestCodeConstructorKind;
extern const char* const s_readableByteStreamInternalsReadableByteStreamControllerCommitDescriptorCode;
extern const int s_readableByteStreamInternalsReadableByteStreamControllerCommitDescriptorCodeLength;
extern const JSC::ConstructAbility s_readableByteStreamInternalsReadableByteStreamControllerCommitDescriptorCodeConstructAbility;
extern const JSC::ConstructorKind s_readableByteStreamInternalsReadableByteStreamControllerCommitDescriptorCodeConstructorKind;
extern const char* const s_readableByteStreamInternalsReadableByteStreamControllerConvertDescriptorCode;
extern const int s_readableByteStreamInternalsReadableByteStreamControllerConvertDescriptorCodeLength;
extern const JSC::ConstructAbility s_readableByteStreamInternalsReadableByteStreamControllerConvertDescriptorCodeConstructAbility;
extern const JSC::ConstructorKind s_readableByteStreamInternalsReadableByteStreamControllerConvertDescriptorCodeConstructorKind;
extern const char* const s_readableByteStreamInternalsReadableStreamFulfillReadIntoRequestCode;
extern const int s_readableByteStreamInternalsReadableStreamFulfillReadIntoRequestCodeLength;
extern const JSC::ConstructAbility s_readableByteStreamInternalsReadableStreamFulfillReadIntoRequestCodeConstructAbility;
extern const JSC::ConstructorKind s_readableByteStreamInternalsReadableStreamFulfillReadIntoRequestCodeConstructorKind;
extern const char* const s_readableByteStreamInternalsReadableStreamBYOBReaderReadCode;
extern const int s_readableByteStreamInternalsReadableStreamBYOBReaderReadCodeLength;
extern const JSC::ConstructAbility s_readableByteStreamInternalsReadableStreamBYOBReaderReadCodeConstructAbility;
extern const JSC::ConstructorKind s_readableByteStreamInternalsReadableStreamBYOBReaderReadCodeConstructorKind;
extern const char* const s_readableByteStreamInternalsReadableByteStreamControllerPullIntoCode;
extern const int s_readableByteStreamInternalsReadableByteStreamControllerPullIntoCodeLength;
extern const JSC::ConstructAbility s_readableByteStreamInternalsReadableByteStreamControllerPullIntoCodeConstructAbility;
extern const JSC::ConstructorKind s_readableByteStreamInternalsReadableByteStreamControllerPullIntoCodeConstructorKind;
extern const char* const s_readableByteStreamInternalsReadableStreamAddReadIntoRequestCode;
extern const int s_readableByteStreamInternalsReadableStreamAddReadIntoRequestCodeLength;
extern const JSC::ConstructAbility s_readableByteStreamInternalsReadableStreamAddReadIntoRequestCodeConstructAbility;
extern const JSC::ConstructorKind s_readableByteStreamInternalsReadableStreamAddReadIntoRequestCodeConstructorKind;

#define WEBCORE_FOREACH_READABLEBYTESTREAMINTERNALS_BUILTIN_DATA(macro) \
    macro(privateInitializeReadableByteStreamController, readableByteStreamInternalsPrivateInitializeReadableByteStreamController, 3) \
    macro(privateInitializeReadableStreamBYOBRequest, readableByteStreamInternalsPrivateInitializeReadableStreamBYOBRequest, 2) \
    macro(isReadableByteStreamController, readableByteStreamInternalsIsReadableByteStreamController, 1) \
    macro(isReadableStreamBYOBRequest, readableByteStreamInternalsIsReadableStreamBYOBRequest, 1) \
    macro(isReadableStreamBYOBReader, readableByteStreamInternalsIsReadableStreamBYOBReader, 1) \
    macro(readableByteStreamControllerCancel, readableByteStreamInternalsReadableByteStreamControllerCancel, 2) \
    macro(readableByteStreamControllerError, readableByteStreamInternalsReadableByteStreamControllerError, 2) \
    macro(readableByteStreamControllerClose, readableByteStreamInternalsReadableByteStreamControllerClose, 1) \
    macro(readableByteStreamControllerClearPendingPullIntos, readableByteStreamInternalsReadableByteStreamControllerClearPendingPullIntos, 1) \
    macro(readableByteStreamControllerGetDesiredSize, readableByteStreamInternalsReadableByteStreamControllerGetDesiredSize, 1) \
    macro(readableStreamHasBYOBReader, readableByteStreamInternalsReadableStreamHasBYOBReader, 1) \
    macro(readableStreamHasDefaultReader, readableByteStreamInternalsReadableStreamHasDefaultReader, 1) \
    macro(readableByteStreamControllerHandleQueueDrain, readableByteStreamInternalsReadableByteStreamControllerHandleQueueDrain, 1) \
    macro(readableByteStreamControllerPull, readableByteStreamInternalsReadableByteStreamControllerPull, 1) \
    macro(readableByteStreamControllerShouldCallPull, readableByteStreamInternalsReadableByteStreamControllerShouldCallPull, 1) \
    macro(readableByteStreamControllerCallPullIfNeeded, readableByteStreamInternalsReadableByteStreamControllerCallPullIfNeeded, 1) \
    macro(transferBufferToCurrentRealm, readableByteStreamInternalsTransferBufferToCurrentRealm, 1) \
    macro(readableByteStreamControllerEnqueue, readableByteStreamInternalsReadableByteStreamControllerEnqueue, 2) \
    macro(readableByteStreamControllerEnqueueChunk, readableByteStreamInternalsReadableByteStreamControllerEnqueueChunk, 4) \
    macro(readableByteStreamControllerRespondWithNewView, readableByteStreamInternalsReadableByteStreamControllerRespondWithNewView, 2) \
    macro(readableByteStreamControllerRespond, readableByteStreamInternalsReadableByteStreamControllerRespond, 2) \
    macro(readableByteStreamControllerRespondInternal, readableByteStreamInternalsReadableByteStreamControllerRespondInternal, 2) \
    macro(readableByteStreamControllerRespondInReadableState, readableByteStreamInternalsReadableByteStreamControllerRespondInReadableState, 3) \
    macro(readableByteStreamControllerRespondInClosedState, readableByteStreamInternalsReadableByteStreamControllerRespondInClosedState, 2) \
    macro(readableByteStreamControllerProcessPullDescriptors, readableByteStreamInternalsReadableByteStreamControllerProcessPullDescriptors, 1) \
    macro(readableByteStreamControllerFillDescriptorFromQueue, readableByteStreamInternalsReadableByteStreamControllerFillDescriptorFromQueue, 2) \
    macro(readableByteStreamControllerShiftPendingDescriptor, readableByteStreamInternalsReadableByteStreamControllerShiftPendingDescriptor, 1) \
    macro(readableByteStreamControllerInvalidateBYOBRequest, readableByteStreamInternalsReadableByteStreamControllerInvalidateBYOBRequest, 1) \
    macro(readableByteStreamControllerCommitDescriptor, readableByteStreamInternalsReadableByteStreamControllerCommitDescriptor, 2) \
    macro(readableByteStreamControllerConvertDescriptor, readableByteStreamInternalsReadableByteStreamControllerConvertDescriptor, 1) \
    macro(readableStreamFulfillReadIntoRequest, readableByteStreamInternalsReadableStreamFulfillReadIntoRequest, 3) \
    macro(readableStreamBYOBReaderRead, readableByteStreamInternalsReadableStreamBYOBReaderRead, 2) \
    macro(readableByteStreamControllerPullInto, readableByteStreamInternalsReadableByteStreamControllerPullInto, 2) \
    macro(readableStreamAddReadIntoRequest, readableByteStreamInternalsReadableStreamAddReadIntoRequest, 1) \

#define WEBCORE_BUILTIN_READABLEBYTESTREAMINTERNALS_PRIVATEINITIALIZEREADABLEBYTESTREAMCONTROLLER 1
#define WEBCORE_BUILTIN_READABLEBYTESTREAMINTERNALS_PRIVATEINITIALIZEREADABLESTREAMBYOBREQUEST 1
#define WEBCORE_BUILTIN_READABLEBYTESTREAMINTERNALS_ISREADABLEBYTESTREAMCONTROLLER 1
#define WEBCORE_BUILTIN_READABLEBYTESTREAMINTERNALS_ISREADABLESTREAMBYOBREQUEST 1
#define WEBCORE_BUILTIN_READABLEBYTESTREAMINTERNALS_ISREADABLESTREAMBYOBREADER 1
#define WEBCORE_BUILTIN_READABLEBYTESTREAMINTERNALS_READABLEBYTESTREAMCONTROLLERCANCEL 1
#define WEBCORE_BUILTIN_READABLEBYTESTREAMINTERNALS_READABLEBYTESTREAMCONTROLLERERROR 1
#define WEBCORE_BUILTIN_READABLEBYTESTREAMINTERNALS_READABLEBYTESTREAMCONTROLLERCLOSE 1
#define WEBCORE_BUILTIN_READABLEBYTESTREAMINTERNALS_READABLEBYTESTREAMCONTROLLERCLEARPENDINGPULLINTOS 1
#define WEBCORE_BUILTIN_READABLEBYTESTREAMINTERNALS_READABLEBYTESTREAMCONTROLLERGETDESIREDSIZE 1
#define WEBCORE_BUILTIN_READABLEBYTESTREAMINTERNALS_READABLESTREAMHASBYOBREADER 1
#define WEBCORE_BUILTIN_READABLEBYTESTREAMINTERNALS_READABLESTREAMHASDEFAULTREADER 1
#define WEBCORE_BUILTIN_READABLEBYTESTREAMINTERNALS_READABLEBYTESTREAMCONTROLLERHANDLEQUEUEDRAIN 1
#define WEBCORE_BUILTIN_READABLEBYTESTREAMINTERNALS_READABLEBYTESTREAMCONTROLLERPULL 1
#define WEBCORE_BUILTIN_READABLEBYTESTREAMINTERNALS_READABLEBYTESTREAMCONTROLLERSHOULDCALLPULL 1
#define WEBCORE_BUILTIN_READABLEBYTESTREAMINTERNALS_READABLEBYTESTREAMCONTROLLERCALLPULLIFNEEDED 1
#define WEBCORE_BUILTIN_READABLEBYTESTREAMINTERNALS_TRANSFERBUFFERTOCURRENTREALM 1
#define WEBCORE_BUILTIN_READABLEBYTESTREAMINTERNALS_READABLEBYTESTREAMCONTROLLERENQUEUE 1
#define WEBCORE_BUILTIN_READABLEBYTESTREAMINTERNALS_READABLEBYTESTREAMCONTROLLERENQUEUECHUNK 1
#define WEBCORE_BUILTIN_READABLEBYTESTREAMINTERNALS_READABLEBYTESTREAMCONTROLLERRESPONDWITHNEWVIEW 1
#define WEBCORE_BUILTIN_READABLEBYTESTREAMINTERNALS_READABLEBYTESTREAMCONTROLLERRESPOND 1
#define WEBCORE_BUILTIN_READABLEBYTESTREAMINTERNALS_READABLEBYTESTREAMCONTROLLERRESPONDINTERNAL 1
#define WEBCORE_BUILTIN_READABLEBYTESTREAMINTERNALS_READABLEBYTESTREAMCONTROLLERRESPONDINREADABLESTATE 1
#define WEBCORE_BUILTIN_READABLEBYTESTREAMINTERNALS_READABLEBYTESTREAMCONTROLLERRESPONDINCLOSEDSTATE 1
#define WEBCORE_BUILTIN_READABLEBYTESTREAMINTERNALS_READABLEBYTESTREAMCONTROLLERPROCESSPULLDESCRIPTORS 1
#define WEBCORE_BUILTIN_READABLEBYTESTREAMINTERNALS_READABLEBYTESTREAMCONTROLLERFILLDESCRIPTORFROMQUEUE 1
#define WEBCORE_BUILTIN_READABLEBYTESTREAMINTERNALS_READABLEBYTESTREAMCONTROLLERSHIFTPENDINGDESCRIPTOR 1
#define WEBCORE_BUILTIN_READABLEBYTESTREAMINTERNALS_READABLEBYTESTREAMCONTROLLERINVALIDATEBYOBREQUEST 1
#define WEBCORE_BUILTIN_READABLEBYTESTREAMINTERNALS_READABLEBYTESTREAMCONTROLLERCOMMITDESCRIPTOR 1
#define WEBCORE_BUILTIN_READABLEBYTESTREAMINTERNALS_READABLEBYTESTREAMCONTROLLERCONVERTDESCRIPTOR 1
#define WEBCORE_BUILTIN_READABLEBYTESTREAMINTERNALS_READABLESTREAMFULFILLREADINTOREQUEST 1
#define WEBCORE_BUILTIN_READABLEBYTESTREAMINTERNALS_READABLESTREAMBYOBREADERREAD 1
#define WEBCORE_BUILTIN_READABLEBYTESTREAMINTERNALS_READABLEBYTESTREAMCONTROLLERPULLINTO 1
#define WEBCORE_BUILTIN_READABLEBYTESTREAMINTERNALS_READABLESTREAMADDREADINTOREQUEST 1

#define WEBCORE_FOREACH_READABLEBYTESTREAMINTERNALS_BUILTIN_CODE(macro) \
    macro(readableByteStreamInternalsPrivateInitializeReadableByteStreamControllerCode, privateInitializeReadableByteStreamController, static_cast<const char*>(nullptr), s_readableByteStreamInternalsPrivateInitializeReadableByteStreamControllerCodeLength) \
    macro(readableByteStreamInternalsPrivateInitializeReadableStreamBYOBRequestCode, privateInitializeReadableStreamBYOBRequest, static_cast<const char*>(nullptr), s_readableByteStreamInternalsPrivateInitializeReadableStreamBYOBRequestCodeLength) \
    macro(readableByteStreamInternalsIsReadableByteStreamControllerCode, isReadableByteStreamController, static_cast<const char*>(nullptr), s_readableByteStreamInternalsIsReadableByteStreamControllerCodeLength) \
    macro(readableByteStreamInternalsIsReadableStreamBYOBRequestCode, isReadableStreamBYOBRequest, static_cast<const char*>(nullptr), s_readableByteStreamInternalsIsReadableStreamBYOBRequestCodeLength) \
    macro(readableByteStreamInternalsIsReadableStreamBYOBReaderCode, isReadableStreamBYOBReader, static_cast<const char*>(nullptr), s_readableByteStreamInternalsIsReadableStreamBYOBReaderCodeLength) \
    macro(readableByteStreamInternalsReadableByteStreamControllerCancelCode, readableByteStreamControllerCancel, static_cast<const char*>(nullptr), s_readableByteStreamInternalsReadableByteStreamControllerCancelCodeLength) \
    macro(readableByteStreamInternalsReadableByteStreamControllerErrorCode, readableByteStreamControllerError, static_cast<const char*>(nullptr), s_readableByteStreamInternalsReadableByteStreamControllerErrorCodeLength) \
    macro(readableByteStreamInternalsReadableByteStreamControllerCloseCode, readableByteStreamControllerClose, static_cast<const char*>(nullptr), s_readableByteStreamInternalsReadableByteStreamControllerCloseCodeLength) \
    macro(readableByteStreamInternalsReadableByteStreamControllerClearPendingPullIntosCode, readableByteStreamControllerClearPendingPullIntos, static_cast<const char*>(nullptr), s_readableByteStreamInternalsReadableByteStreamControllerClearPendingPullIntosCodeLength) \
    macro(readableByteStreamInternalsReadableByteStreamControllerGetDesiredSizeCode, readableByteStreamControllerGetDesiredSize, static_cast<const char*>(nullptr), s_readableByteStreamInternalsReadableByteStreamControllerGetDesiredSizeCodeLength) \
    macro(readableByteStreamInternalsReadableStreamHasBYOBReaderCode, readableStreamHasBYOBReader, static_cast<const char*>(nullptr), s_readableByteStreamInternalsReadableStreamHasBYOBReaderCodeLength) \
    macro(readableByteStreamInternalsReadableStreamHasDefaultReaderCode, readableStreamHasDefaultReader, static_cast<const char*>(nullptr), s_readableByteStreamInternalsReadableStreamHasDefaultReaderCodeLength) \
    macro(readableByteStreamInternalsReadableByteStreamControllerHandleQueueDrainCode, readableByteStreamControllerHandleQueueDrain, static_cast<const char*>(nullptr), s_readableByteStreamInternalsReadableByteStreamControllerHandleQueueDrainCodeLength) \
    macro(readableByteStreamInternalsReadableByteStreamControllerPullCode, readableByteStreamControllerPull, static_cast<const char*>(nullptr), s_readableByteStreamInternalsReadableByteStreamControllerPullCodeLength) \
    macro(readableByteStreamInternalsReadableByteStreamControllerShouldCallPullCode, readableByteStreamControllerShouldCallPull, static_cast<const char*>(nullptr), s_readableByteStreamInternalsReadableByteStreamControllerShouldCallPullCodeLength) \
    macro(readableByteStreamInternalsReadableByteStreamControllerCallPullIfNeededCode, readableByteStreamControllerCallPullIfNeeded, static_cast<const char*>(nullptr), s_readableByteStreamInternalsReadableByteStreamControllerCallPullIfNeededCodeLength) \
    macro(readableByteStreamInternalsTransferBufferToCurrentRealmCode, transferBufferToCurrentRealm, static_cast<const char*>(nullptr), s_readableByteStreamInternalsTransferBufferToCurrentRealmCodeLength) \
    macro(readableByteStreamInternalsReadableByteStreamControllerEnqueueCode, readableByteStreamControllerEnqueue, static_cast<const char*>(nullptr), s_readableByteStreamInternalsReadableByteStreamControllerEnqueueCodeLength) \
    macro(readableByteStreamInternalsReadableByteStreamControllerEnqueueChunkCode, readableByteStreamControllerEnqueueChunk, static_cast<const char*>(nullptr), s_readableByteStreamInternalsReadableByteStreamControllerEnqueueChunkCodeLength) \
    macro(readableByteStreamInternalsReadableByteStreamControllerRespondWithNewViewCode, readableByteStreamControllerRespondWithNewView, static_cast<const char*>(nullptr), s_readableByteStreamInternalsReadableByteStreamControllerRespondWithNewViewCodeLength) \
    macro(readableByteStreamInternalsReadableByteStreamControllerRespondCode, readableByteStreamControllerRespond, static_cast<const char*>(nullptr), s_readableByteStreamInternalsReadableByteStreamControllerRespondCodeLength) \
    macro(readableByteStreamInternalsReadableByteStreamControllerRespondInternalCode, readableByteStreamControllerRespondInternal, static_cast<const char*>(nullptr), s_readableByteStreamInternalsReadableByteStreamControllerRespondInternalCodeLength) \
    macro(readableByteStreamInternalsReadableByteStreamControllerRespondInReadableStateCode, readableByteStreamControllerRespondInReadableState, static_cast<const char*>(nullptr), s_readableByteStreamInternalsReadableByteStreamControllerRespondInReadableStateCodeLength) \
    macro(readableByteStreamInternalsReadableByteStreamControllerRespondInClosedStateCode, readableByteStreamControllerRespondInClosedState, static_cast<const char*>(nullptr), s_readableByteStreamInternalsReadableByteStreamControllerRespondInClosedStateCodeLength) \
    macro(readableByteStreamInternalsReadableByteStreamControllerProcessPullDescriptorsCode, readableByteStreamControllerProcessPullDescriptors, static_cast<const char*>(nullptr), s_readableByteStreamInternalsReadableByteStreamControllerProcessPullDescriptorsCodeLength) \
    macro(readableByteStreamInternalsReadableByteStreamControllerFillDescriptorFromQueueCode, readableByteStreamControllerFillDescriptorFromQueue, static_cast<const char*>(nullptr), s_readableByteStreamInternalsReadableByteStreamControllerFillDescriptorFromQueueCodeLength) \
    macro(readableByteStreamInternalsReadableByteStreamControllerShiftPendingDescriptorCode, readableByteStreamControllerShiftPendingDescriptor, static_cast<const char*>(nullptr), s_readableByteStreamInternalsReadableByteStreamControllerShiftPendingDescriptorCodeLength) \
    macro(readableByteStreamInternalsReadableByteStreamControllerInvalidateBYOBRequestCode, readableByteStreamControllerInvalidateBYOBRequest, static_cast<const char*>(nullptr), s_readableByteStreamInternalsReadableByteStreamControllerInvalidateBYOBRequestCodeLength) \
    macro(readableByteStreamInternalsReadableByteStreamControllerCommitDescriptorCode, readableByteStreamControllerCommitDescriptor, static_cast<const char*>(nullptr), s_readableByteStreamInternalsReadableByteStreamControllerCommitDescriptorCodeLength) \
    macro(readableByteStreamInternalsReadableByteStreamControllerConvertDescriptorCode, readableByteStreamControllerConvertDescriptor, static_cast<const char*>(nullptr), s_readableByteStreamInternalsReadableByteStreamControllerConvertDescriptorCodeLength) \
    macro(readableByteStreamInternalsReadableStreamFulfillReadIntoRequestCode, readableStreamFulfillReadIntoRequest, static_cast<const char*>(nullptr), s_readableByteStreamInternalsReadableStreamFulfillReadIntoRequestCodeLength) \
    macro(readableByteStreamInternalsReadableStreamBYOBReaderReadCode, readableStreamBYOBReaderRead, static_cast<const char*>(nullptr), s_readableByteStreamInternalsReadableStreamBYOBReaderReadCodeLength) \
    macro(readableByteStreamInternalsReadableByteStreamControllerPullIntoCode, readableByteStreamControllerPullInto, static_cast<const char*>(nullptr), s_readableByteStreamInternalsReadableByteStreamControllerPullIntoCodeLength) \
    macro(readableByteStreamInternalsReadableStreamAddReadIntoRequestCode, readableStreamAddReadIntoRequest, static_cast<const char*>(nullptr), s_readableByteStreamInternalsReadableStreamAddReadIntoRequestCodeLength) \

#define WEBCORE_FOREACH_READABLEBYTESTREAMINTERNALS_BUILTIN_FUNCTION_NAME(macro) \
    macro(isReadableByteStreamController) \
    macro(isReadableStreamBYOBReader) \
    macro(isReadableStreamBYOBRequest) \
    macro(privateInitializeReadableByteStreamController) \
    macro(privateInitializeReadableStreamBYOBRequest) \
    macro(readableByteStreamControllerCallPullIfNeeded) \
    macro(readableByteStreamControllerCancel) \
    macro(readableByteStreamControllerClearPendingPullIntos) \
    macro(readableByteStreamControllerClose) \
    macro(readableByteStreamControllerCommitDescriptor) \
    macro(readableByteStreamControllerConvertDescriptor) \
    macro(readableByteStreamControllerEnqueue) \
    macro(readableByteStreamControllerEnqueueChunk) \
    macro(readableByteStreamControllerError) \
    macro(readableByteStreamControllerFillDescriptorFromQueue) \
    macro(readableByteStreamControllerGetDesiredSize) \
    macro(readableByteStreamControllerHandleQueueDrain) \
    macro(readableByteStreamControllerInvalidateBYOBRequest) \
    macro(readableByteStreamControllerProcessPullDescriptors) \
    macro(readableByteStreamControllerPull) \
    macro(readableByteStreamControllerPullInto) \
    macro(readableByteStreamControllerRespond) \
    macro(readableByteStreamControllerRespondInClosedState) \
    macro(readableByteStreamControllerRespondInReadableState) \
    macro(readableByteStreamControllerRespondInternal) \
    macro(readableByteStreamControllerRespondWithNewView) \
    macro(readableByteStreamControllerShiftPendingDescriptor) \
    macro(readableByteStreamControllerShouldCallPull) \
    macro(readableStreamAddReadIntoRequest) \
    macro(readableStreamBYOBReaderRead) \
    macro(readableStreamFulfillReadIntoRequest) \
    macro(readableStreamHasBYOBReader) \
    macro(readableStreamHasDefaultReader) \
    macro(transferBufferToCurrentRealm) \

#define DECLARE_BUILTIN_GENERATOR(codeName, functionName, overriddenName, argumentCount) \
    JSC::FunctionExecutable* codeName##Generator(JSC::VM&);

WEBCORE_FOREACH_READABLEBYTESTREAMINTERNALS_BUILTIN_CODE(DECLARE_BUILTIN_GENERATOR)
#undef DECLARE_BUILTIN_GENERATOR

class ReadableByteStreamInternalsBuiltinsWrapper : private JSC::WeakHandleOwner {
public:
    explicit ReadableByteStreamInternalsBuiltinsWrapper(JSC::VM& vm)
        : m_vm(vm)
        WEBCORE_FOREACH_READABLEBYTESTREAMINTERNALS_BUILTIN_FUNCTION_NAME(INITIALIZE_BUILTIN_NAMES)
#define INITIALIZE_BUILTIN_SOURCE_MEMBERS(name, functionName, overriddenName, length) , m_##name##Source(JSC::makeSource(StringImpl::createFromLiteral(s_##name, length), { }))
        WEBCORE_FOREACH_READABLEBYTESTREAMINTERNALS_BUILTIN_CODE(INITIALIZE_BUILTIN_SOURCE_MEMBERS)
#undef INITIALIZE_BUILTIN_SOURCE_MEMBERS
    {
    }

#define EXPOSE_BUILTIN_EXECUTABLES(name, functionName, overriddenName, length) \
    JSC::UnlinkedFunctionExecutable* name##Executable(); \
    const JSC::SourceCode& name##Source() const { return m_##name##Source; }
    WEBCORE_FOREACH_READABLEBYTESTREAMINTERNALS_BUILTIN_CODE(EXPOSE_BUILTIN_EXECUTABLES)
#undef EXPOSE_BUILTIN_EXECUTABLES

    WEBCORE_FOREACH_READABLEBYTESTREAMINTERNALS_BUILTIN_FUNCTION_NAME(DECLARE_BUILTIN_IDENTIFIER_ACCESSOR)

    void exportNames();

private:
    JSC::VM& m_vm;

    WEBCORE_FOREACH_READABLEBYTESTREAMINTERNALS_BUILTIN_FUNCTION_NAME(DECLARE_BUILTIN_NAMES)

#define DECLARE_BUILTIN_SOURCE_MEMBERS(name, functionName, overriddenName, length) \
    JSC::SourceCode m_##name##Source;\
    JSC::Weak<JSC::UnlinkedFunctionExecutable> m_##name##Executable;
    WEBCORE_FOREACH_READABLEBYTESTREAMINTERNALS_BUILTIN_CODE(DECLARE_BUILTIN_SOURCE_MEMBERS)
#undef DECLARE_BUILTIN_SOURCE_MEMBERS

};

#define DEFINE_BUILTIN_EXECUTABLES(name, functionName, overriddenName, length) \
inline JSC::UnlinkedFunctionExecutable* ReadableByteStreamInternalsBuiltinsWrapper::name##Executable() \
{\
    if (!m_##name##Executable) {\
        JSC::Identifier executableName = functionName##PublicName();\
        if (overriddenName)\
            executableName = JSC::Identifier::fromString(m_vm, overriddenName);\
        m_##name##Executable = JSC::Weak<JSC::UnlinkedFunctionExecutable>(JSC::createBuiltinExecutable(m_vm, m_##name##Source, executableName, s_##name##ConstructorKind, s_##name##ConstructAbility), this, &m_##name##Executable);\
    }\
    return m_##name##Executable.get();\
}
WEBCORE_FOREACH_READABLEBYTESTREAMINTERNALS_BUILTIN_CODE(DEFINE_BUILTIN_EXECUTABLES)
#undef DEFINE_BUILTIN_EXECUTABLES

inline void ReadableByteStreamInternalsBuiltinsWrapper::exportNames()
{
#define EXPORT_FUNCTION_NAME(name) m_vm.propertyNames->appendExternalName(name##PublicName(), name##PrivateName());
    WEBCORE_FOREACH_READABLEBYTESTREAMINTERNALS_BUILTIN_FUNCTION_NAME(EXPORT_FUNCTION_NAME)
#undef EXPORT_FUNCTION_NAME
}

class ReadableByteStreamInternalsBuiltinFunctions {
public:
    explicit ReadableByteStreamInternalsBuiltinFunctions(JSC::VM& vm) : m_vm(vm) { }

    void init(JSC::JSGlobalObject&);
    template<typename Visitor> void visit(Visitor&);

public:
    JSC::VM& m_vm;

#define DECLARE_BUILTIN_SOURCE_MEMBERS(functionName) \
    JSC::WriteBarrier<JSC::JSFunction> m_##functionName##Function;
    WEBCORE_FOREACH_READABLEBYTESTREAMINTERNALS_BUILTIN_FUNCTION_NAME(DECLARE_BUILTIN_SOURCE_MEMBERS)
#undef DECLARE_BUILTIN_SOURCE_MEMBERS
};

inline void ReadableByteStreamInternalsBuiltinFunctions::init(JSC::JSGlobalObject& globalObject)
{
#define EXPORT_FUNCTION(codeName, functionName, overriddenName, length)\
    m_##functionName##Function.set(m_vm, &globalObject, JSC::JSFunction::create(m_vm, codeName##Generator(m_vm), &globalObject));
    WEBCORE_FOREACH_READABLEBYTESTREAMINTERNALS_BUILTIN_CODE(EXPORT_FUNCTION)
#undef EXPORT_FUNCTION
}

template<typename Visitor>
inline void ReadableByteStreamInternalsBuiltinFunctions::visit(Visitor& visitor)
{
#define VISIT_FUNCTION(name) visitor.append(m_##name##Function);
    WEBCORE_FOREACH_READABLEBYTESTREAMINTERNALS_BUILTIN_FUNCTION_NAME(VISIT_FUNCTION)
#undef VISIT_FUNCTION
}

template void ReadableByteStreamInternalsBuiltinFunctions::visit(JSC::AbstractSlotVisitor&);
template void ReadableByteStreamInternalsBuiltinFunctions::visit(JSC::SlotVisitor&);



} // namespace WebCore
