/*
 * Decompiled with CFR 0.152.
 */
package gnu.math;

import gnu.math.CQuantity;
import gnu.math.Complex;
import gnu.math.DFloNum;
import gnu.math.DQuantity;
import gnu.math.Dimensions;
import gnu.math.Numeric;
import gnu.math.RealNum;
import gnu.math.Unit;

public abstract class Quantity
extends Numeric {
    public Unit unit() {
        return Unit.Empty;
    }

    public Dimensions dimensions() {
        return this.unit().dimensions();
    }

    public abstract Complex number();

    public RealNum re() {
        return this.number().re();
    }

    public RealNum im() {
        return this.number().im();
    }

    public final double reValue() {
        return this.doubleValue();
    }

    public final double imValue() {
        return this.doubleImagValue();
    }

    public double doubleValue() {
        return this.unit().doubleValue() * this.re().doubleValue();
    }

    public double doubleImagValue() {
        return this.unit().doubleValue() * this.im().doubleValue();
    }

    public static Quantity make(Complex complex, Unit unit) {
        if (unit == Unit.Empty) {
            return complex;
        }
        if (complex instanceof DFloNum) {
            return new DQuantity(complex.doubleValue(), unit);
        }
        return new CQuantity(complex, unit);
    }

    public static Quantity make(RealNum realNum, RealNum realNum2, Unit unit) {
        if (unit == Unit.Empty) {
            return Complex.make(realNum, realNum2);
        }
        if (!(!realNum2.isZero() || realNum.isExact() && realNum2.isExact())) {
            return new DQuantity(realNum.doubleValue(), unit);
        }
        return new CQuantity(realNum, realNum2, unit);
    }

    public static Quantity make(double d, double d2, Unit unit) {
        if (unit == Unit.Empty) {
            return Complex.make(d, d2);
        }
        if (d2 == 0.0) {
            return new DQuantity(d, unit);
        }
        return new CQuantity(new DFloNum(d), new DFloNum(d2), unit);
    }

    public Numeric neg() {
        return Quantity.make((Complex)this.number().neg(), this.unit());
    }

    public Numeric abs() {
        return Quantity.make((Complex)this.number().abs(), this.unit());
    }

    public static int compare(Quantity quantity, Quantity quantity2) {
        if (quantity.unit() == quantity2.unit()) {
            return Complex.compare(quantity.number(), quantity2.number());
        }
        if (quantity.dimensions() != quantity2.dimensions() || quantity.imValue() != quantity2.imValue()) {
            return -3;
        }
        return DFloNum.compare(quantity.reValue(), quantity2.reValue());
    }

    public int compare(Object object2) {
        if (!(object2 instanceof Quantity)) {
            return ((Numeric)object2).compareReversed(this);
        }
        return Quantity.compare(this, (Quantity)object2);
    }

    public int compareReversed(Numeric numeric) {
        if (numeric instanceof Quantity) {
            return Quantity.compare((Quantity)numeric, this);
        }
        throw new IllegalArgumentException();
    }

    public static Quantity add(Quantity quantity, Quantity quantity2, int n) {
        if (quantity.unit() == quantity2.unit()) {
            return Quantity.make(Complex.add(quantity.number(), quantity2.number(), n), quantity.unit());
        }
        if (quantity.dimensions() != quantity2.dimensions()) {
            throw new ArithmeticException("units mis-match");
        }
        double d = quantity.unit().doubleValue();
        double d2 = (quantity.reValue() + (double)n * quantity2.reValue()) / d;
        double d3 = (quantity.imValue() + (double)n * quantity2.imValue()) / d;
        return Quantity.make(d2, d3, quantity.unit());
    }

    public Numeric add(Object object2, int n) {
        if (object2 instanceof Quantity) {
            return Quantity.add(this, (Quantity)object2, n);
        }
        return ((Numeric)object2).addReversed(this, n);
    }

    public Numeric addReversed(Numeric numeric, int n) {
        if (numeric instanceof Quantity) {
            return Quantity.add((Quantity)numeric, this, n);
        }
        throw new IllegalArgumentException();
    }

    public static Quantity times(Quantity quantity, Quantity quantity2) {
        Unit unit = Unit.times(quantity.unit(), quantity2.unit());
        Numeric numeric = quantity.number().mul(quantity2.number());
        return Quantity.make((Complex)numeric, unit);
    }

    public Numeric mul(Object object2) {
        if (object2 instanceof Quantity) {
            return Quantity.times(this, (Quantity)object2);
        }
        return ((Numeric)object2).mulReversed(this);
    }

    public Numeric mulReversed(Numeric numeric) {
        if (numeric instanceof Quantity) {
            return Quantity.times((Quantity)numeric, this);
        }
        throw new IllegalArgumentException();
    }

    public static Quantity divide(Quantity quantity, Quantity quantity2) {
        Unit unit = Unit.divide(quantity.unit(), quantity2.unit());
        Numeric numeric = quantity.number().div(quantity2.number());
        return Quantity.make((Complex)numeric, unit);
    }

    public Numeric div(Object object2) {
        if (object2 instanceof Quantity) {
            return Quantity.divide(this, (Quantity)object2);
        }
        return ((Numeric)object2).divReversed(this);
    }

    public Numeric divReversed(Numeric numeric) {
        if (numeric instanceof Quantity) {
            return Quantity.divide((Quantity)numeric, this);
        }
        throw new IllegalArgumentException();
    }

    public String toString(int n) {
        String string = this.number().toString(n);
        if (this.unit() == Unit.Empty) {
            return string;
        }
        return string + this.unit().toString();
    }
}

