/*
 * Decompiled with CFR 0.152.
 */
package gnu.text;

import gnu.text.WriterRef;
import java.io.Writer;
import java.lang.reflect.Method;

public class WriterManager
implements Runnable {
    public static final WriterManager instance = new WriterManager();
    WriterRef first;

    public synchronized WriterRef register(Writer port) {
        WriterRef ref = new WriterRef(port);
        WriterRef first = this.first;
        if (first != null) {
            ref.next = first.next;
            first.prev = ref;
        }
        this.first = ref;
        return ref;
    }

    public synchronized void unregister(Object key) {
        if (key == null) {
            return;
        }
        WriterRef ref = (WriterRef)key;
        WriterRef next = ref.next;
        WriterRef prev = ref.prev;
        if (next != null) {
            next.prev = prev;
        }
        if (prev != null) {
            prev.next = next;
        }
        if (ref == this.first) {
            this.first = next;
        }
    }

    @Override
    public synchronized void run() {
        WriterRef ref = this.first;
        while (ref != null) {
            Object port = ref.get();
            if (port != null) {
                try {
                    ((Writer)port).close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ref = ref.next;
        }
        this.first = null;
    }

    public boolean registerShutdownHook() {
        try {
            Runtime runtime = Runtime.getRuntime();
            Class<?> rclass = runtime.getClass();
            Class[] params = new Class[]{Thread.class};
            Method method = rclass.getDeclaredMethod("addShutdownHook", params);
            Object[] args = new Object[]{new Thread(this)};
            method.invoke((Object)runtime, args);
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }
}

