/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.filechooser.FileFilter;

public class FileType {
    private static final ArrayList allTypes = new ArrayList();
    public static final FileType ANY = FileType.makeFileType("All", new String[0], "All Files");
    public static final FileType ALS = FileType.makeFileType("ALS", new String[]{"als"}, "ALS Simulation Deck (als)");
    public static final FileType ALSVECTOR = FileType.makeFileType("ALS Vectors", new String[]{"vec"}, "ALS Vector Deck (vec)");
    public static final FileType ARCHSIM = FileType.makeFileType("ArchSim", new String[]{"xml"}, "ArchSim Deck (xml)");
    public static final FileType ARCHSIMOUT = FileType.makeFileType("ArchSim Output", new String[]{"asj"}, "ArchSim Journal (asj)");
    public static final FileType CDL = FileType.makeFileType("CDL", new String[]{"cdl"}, "CDL Deck (cdl)");
    public static final FileType CIF = FileType.makeFileType("CIF", new String[]{"cif"}, "CIF File (cif)");
    public static final FileType COSMOS = FileType.makeFileType("COSMOS", new String[]{"sim"}, "COSMOS File (sim)");
    public static final FileType DB = FileType.makeFileType("DB", new String[]{"db"}, "Calibre DRC Error File (db)");
    public static final FileType DEF = FileType.makeFileType("DEF", new String[]{"def"}, "DEF File (def)");
    public static final FileType DXF = FileType.makeFileType("DXF", new String[]{"dxf"}, "DXF File (dxf)");
    public static final FileType EAGLE = FileType.makeFileType("Eagle", new String[]{"txt"}, "Eagle File (txt)");
    public static final FileType ECAD = FileType.makeFileType("ECAD", new String[]{"enl"}, "ECAD File (enl)");
    public static final FileType EDIF = FileType.makeFileType("EDIF", new String[]{"edif"}, "EDIF File (edif)");
    public static final FileType ELIB = FileType.makeFileType("ELIB", new String[]{"elib"}, "Library File (elib)");
    public static final FileType EPS = FileType.makeFileType("Encapsulated PostScript", new String[]{"eps"}, "Encapsulated PostScript (eps)");
    public static final FileType EPIC = FileType.makeFileType("EPIC output", new String[]{"out"}, "EPIC simulation output (out)");
    public static final FileType ERR = FileType.makeFileType("ERR", new String[]{"err"}, "Assura DRC Error File (err)");
    public static final FileType ESIM = FileType.makeFileType("ESIM", new String[]{"sim"}, "ESIM File (sim)");
    public static final FileType FASTHENRY = FileType.makeFileType("FastHenry", new String[]{"inp"}, "FastHenry File (inp)");
    public static final FileType FPGA = FileType.makeFileType("FPGA", new String[]{"fpga"}, "FPGA Architecture File (fpga)");
    public static final FileType GDS = FileType.makeFileType("GDS", new String[]{"gds"}, "GDS File (gds)");
    public static final FileType GDSMAP = FileType.makeFileType("GDS Map", new String[]{"map"}, "GDS Layer Map File (map)");
    public static final FileType HSPICEOUT = FileType.makeFileTypeNumeric("HSpice Output", new String[]{"tr"}, "HSpice Output File (tr0,1,2...)");
    public static final FileType HPGL = FileType.makeFileType("HPGL", new String[]{"hpgl2"}, "HPGL File (hpgl2)");
    public static final FileType HTML = FileType.makeFileType("HTML", new String[]{"html"}, "HTML File (html)");
    public static final FileType IRSIM = FileType.makeFileType("IRSIM", new String[]{"sim"}, "IRSIM Deck (sim)");
    public static final FileType IRSIMPARAM = FileType.makeFileType("IRSIM Parameters", new String[]{"prm"}, "IRSIM Parameter Deck (prm)");
    public static final FileType IRSIMVECTOR = FileType.makeFileType("IRSIM Vectors", new String[]{"cmd"}, "IRSIM Vector Deck (cmd)");
    public static final FileType JAVA = FileType.makeFileType("Java", new String[]{"java", "bsh"}, "Java Script File (java, bsh)");
    public static final FileType JELIB = FileType.makeFileType("JELIB", new String[]{"jelib"}, "Library File (jelib)");
    public static final FileType J3D = FileType.makeFileType("J3D", new String[]{"j3d"}, "Java3D Demo File (j3d}");
    public static final FileType L = FileType.makeFileType("L", new String[]{"L"}, "L File (L)");
    public static final FileType LEF = FileType.makeFileType("LEF", new String[]{"lef"}, "LEF File (lef)");
    public static final FileType LIBFILE = FileType.makeFileType("LIBFILE", new String[]{"jelib", "elib", "txt"}, "Library File");
    public static final FileType MAXWELL = FileType.makeFileType("Maxwell", new String[]{"mac"}, "Maxwell Deck (mac)");
    public static final FileType MOSSIM = FileType.makeFileType("MOSSIM", new String[]{"ntk"}, "MOSSIM Deck (ntk)");
    public static final FileType MOV = FileType.makeFileType("Movie", new String[]{"mov"}, "Movie File (mov)");
    public static final FileType PADARR = FileType.makeFileType("Pad Array", new String[]{"arr"}, "Pad Generator Array File (arr)");
    public static final FileType PADS = FileType.makeFileType("Pads", new String[]{"asc"}, "Pads File (asc)");
    public static final FileType PAL = FileType.makeFileType("PAL", new String[]{"pal"}, "PAL File (pal)");
    public static final FileType POSTSCRIPT = FileType.makeFileType("PostScript", new String[]{"ps"}, "PostScript (ps)");
    public static final FileType PNG = FileType.makeFileType("PNG", new String[]{"png"}, "PNG (png)");
    public static final FileType PREFS = FileType.makeFileType("Preferences", new String[]{"xml"}, "Preferences (xml)");
    public static final FileType PROJECT = FileType.makeFileType("Project Management", new String[]{"proj"}, "Project Management (proj)");
    public static final FileType PSPICEOUT = FileType.makeFileType("PSpice Output", new String[]{"txt"}, "PSpice/Spice3 Text Output File (txt)");
    public static final FileType RAWSPICEOUT = FileType.makeFileType("RawSpice Output", new String[]{"raw"}, "Spice Raw Output File (raw)");
    public static final FileType RAWSSPICEOUT = FileType.makeFileType("Raw SmartSpice Output", new String[]{"raw"}, "SmartSPICE Raw Output File (raw)");
    public static final FileType READABLEDUMP = FileType.makeFileType("ReadableDump", new String[]{"txt"}, "Readable Dump Library File (txt)");
    public static final FileType RSIM = FileType.makeFileType("RSIM", new String[]{"sim"}, "RSIM File (sim)");
    public static final FileType SILOS = FileType.makeFileType("Silos", new String[]{"sil"}, "Silos Deck (sil)");
    public static final FileType SKILL = FileType.makeFileType("Skill", new String[]{"il"}, "Skill Deck (il)");
    public static final FileType SKILLEXPORTSONLY = FileType.makeFileType("SkillExports Only", new String[]{"il"}, "Skill Deck (il)");
    public static final FileType SPICE = FileType.makeFileType("Spice", new String[]{"spi", "sp"}, "Spice Deck (spi, sp)");
    public static final FileType SPICEOUT = FileType.makeFileType("Spice Output", new String[]{"spo"}, "Spice/GNUCap Output File (spo)");
    public static final FileType SUE = FileType.makeFileType("Sue", new String[]{"sue"}, "Sue File (sue)");
    public static final FileType TEGAS = FileType.makeFileType("Tegas", new String[]{"tdl"}, "Tegas File (tdl)");
    public static final FileType TEXT = FileType.makeFileType("Text", new String[]{"txt"}, "Text File (txt)");
    public static final FileType VERILOG = FileType.makeFileType("Verilog", new String[]{"v"}, "Verilog Deck (v)");
    public static final FileType VERILOGOUT = FileType.makeFileType("Verilog Output", new String[]{"dump"}, "Verilog VCD Dump (vcd)");
    public static final FileType XML = FileType.makeFileType("XML", new String[]{"xml"}, "XML File (xml)");
    public static final FileType DEFAULTLIB = JELIB;
    public static final FileType[] libraryTypes = new FileType[]{JELIB, ELIB};
    private static String[] libraryTypesExt;
    private static String libraryTypesExtReadable;
    public static final FileType LIBRARYFORMATS;
    private String name;
    private String[] extensions;
    private String desc;
    private boolean allowNumbers;
    private FileFilterSwing ffs;
    private FileFilterAWT ffa;

    private FileType() {
    }

    private static FileType makeFileType(String name, String[] extensions, String desc) {
        FileType ft = new FileType();
        ft.name = name;
        ft.extensions = extensions;
        ft.desc = desc;
        ft.ffs = null;
        ft.ffa = null;
        ft.allowNumbers = false;
        allTypes.add(ft);
        return ft;
    }

    private static FileType makeFileTypeNumeric(String name, String[] extensions, String desc) {
        FileType ft = FileType.makeFileType(name, extensions, desc);
        ft.allowNumbers = true;
        return ft;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.desc;
    }

    public String[] getExtensions() {
        if (this.allowNumbers) {
            String[] newExtensions = new String[this.extensions.length];
            for (int i = 0; i < this.extensions.length; ++i) {
                newExtensions[i] = this.extensions[i] + "0";
            }
            return newExtensions;
        }
        return this.extensions;
    }

    public FileFilterSwing getFileFilterSwing() {
        if (this.ffs == null) {
            this.ffs = new FileFilterSwing(this.extensions, this.desc, this.allowNumbers);
        }
        return this.ffs;
    }

    public FileFilterAWT getFileFilterAWT() {
        if (this.ffa == null) {
            this.ffa = new FileFilterAWT(this.extensions, this.desc, this.allowNumbers);
        }
        return this.ffa;
    }

    public String toString() {
        return this.name;
    }

    public static FileType getType(FileFilter filter) {
        Iterator it = allTypes.iterator();
        while (it.hasNext()) {
            FileType type = (FileType)it.next();
            if (type.ffs != filter) continue;
            return type;
        }
        return null;
    }

    public static FileType getType(FilenameFilter filter) {
        Iterator it = allTypes.iterator();
        while (it.hasNext()) {
            FileType type = (FileType)it.next();
            if (type.ffa != filter) continue;
            return type;
        }
        return null;
    }

    private static boolean matches(String fileName, String[] extensions, boolean allowNumbers) {
        if (extensions.length == 0) {
            return true;
        }
        int i = fileName.lastIndexOf(46);
        if (i < 0) {
            return false;
        }
        String thisExtension = fileName.substring(i + 1);
        if (thisExtension == null) {
            return false;
        }
        for (int j = 0; j < extensions.length; ++j) {
            String extension = extensions[j];
            if (extension.equalsIgnoreCase(thisExtension)) {
                return true;
            }
            if (!allowNumbers || thisExtension.length() <= extension.length() || !thisExtension.startsWith(extension)) continue;
            boolean allDigits = true;
            for (int k = extension.length(); k < thisExtension.length(); ++k) {
                if (Character.isDigit(thisExtension.charAt(k))) continue;
                allDigits = false;
            }
            if (!allDigits) continue;
            return true;
        }
        return false;
    }

    static {
        ArrayList<String> exts = new ArrayList<String>();
        for (int i = 0; i < libraryTypes.length; ++i) {
            FileType type = libraryTypes[i];
            String[] typeExts = type.getExtensions();
            for (int j = 0; j < typeExts.length; ++j) {
                exts.add(typeExts[j]);
            }
        }
        libraryTypesExt = new String[exts.size()];
        StringBuffer buf = new StringBuffer("(");
        for (int i = 0; i < exts.size(); ++i) {
            FileType.libraryTypesExt[i] = (String)exts.get(i);
            buf.append((String)exts.get(i));
            buf.append(", ");
        }
        if (buf.length() > 2) {
            buf.replace(buf.length() - 2, buf.length(), ")");
        }
        libraryTypesExtReadable = buf.toString();
        LIBRARYFORMATS = FileType.makeFileType("LibraryFormats", libraryTypesExt, "Library Formats " + libraryTypesExtReadable);
    }

    private static class FileFilterAWT
    implements FilenameFilter {
        private String[] extensions;
        private String desc;
        private boolean allowNumbers;

        public FileFilterAWT(String[] extensions, String desc, boolean allowNumbers) {
            this.extensions = extensions;
            this.desc = desc;
            this.allowNumbers = allowNumbers;
        }

        public boolean accept(File f, String fileName) {
            return FileType.matches(fileName, this.extensions, this.allowNumbers);
        }

        public String getDescription() {
            return this.desc;
        }
    }

    private static class FileFilterSwing
    extends FileFilter {
        private String[] extensions;
        private String desc;
        private boolean allowNumbers;

        public FileFilterSwing(String[] extensions, String desc, boolean allowNumbers) {
            this.extensions = extensions;
            this.desc = desc;
            this.allowNumbers = allowNumbers;
        }

        public boolean accept(File f) {
            if (f == null) {
                return false;
            }
            if (f.isDirectory()) {
                return true;
            }
            String fileName = f.getName();
            return FileType.matches(fileName, this.extensions, this.allowNumbers);
        }

        public String getDescription() {
            return this.desc;
        }
    }
}

