# This is a shell script that calls functions and scripts from
# tml@iki.fi's personal work environment. It is not expected to be
# usable unmodified by others, and is included only for reference.

MOD=zlib
VER=1.2.3
REV=2
ARCH=win64

THIS=${MOD}_${VER}-${REV}_${ARCH}

RUNZIP=${THIS}.zip
DEVZIP=${MOD}-dev_${VER}-${REV}_${ARCH}.zip

HEX=`echo $THIS | md5sum | cut -d' ' -f1`
TARGET=c:/devel/target/$HEX

usewin64
usemsvs9x64

(

set -x

# The zlib makefilery is somewhat sucky, but it is just a simple DLL
# built out of a handful of source files, so just simply do the
# compilation here instead

x86_64-w64-mingw32-windres --define GCC_WINDRES -o zlibrc.o -v win32/zlib1.rc
x86_64-w64-mingw32-gcc -O3 -Wall -shared win32/zlib.def -o zlib1.dll -Wl,--out-implib,libz.dll.a adler32.c compress.c crc32.c deflate.c gzio.c infback.c inffast.c inflate.c inftrees.c trees.c uncompr.c zutil.c zlibrc.o &&

# The somewhat odd name zdll.lib for the MSVS import library was
# traditionally used for the 32-bit library, so continue like that?
lib -def:win32/zlib.def -machine:X64 -name:zlib1.dll -out:zdll.lib &&

mkdir -p $TARGET/{bin,include,lib} &&
cp zlib1.dll $TARGET/bin &&
cp libz.dll.a $TARGET/lib &&
cp zdll.lib win32/zlib.def $TARGET/lib &&
cp zlib.h zconf.h $TARGET/include &&

rm -f /tmp/$RUNZIP /tmp/$DEVZIP &&
(cd /devel/target/$HEX &&
zip /tmp/$RUNZIP bin/zlib1.dll &&
zip -r -D /tmp/$DEVZIP lib include
)

) 2>&1 | tee /devel/src/tml/packaging/$THIS.log

(cd /devel && zip /tmp/$DEVZIP src/tml/packaging/$THIS.{sh,log}) &&
manifestify /tmp/$RUNZIP /tmp/$DEVZIP
