# This is a shell script that calls functions and scripts from
# tml@iki.fi's personal work environment. It is not expected to be
# usable unmodified by others, and is included only for reference.

MOD=glib
VER=2.17.6
REV=1
ARCH=win64

THIS=${MOD}_${VER}-${REV}_${ARCH}

RUNZIP=${MOD}_${VER}-${REV}_${ARCH}.zip
DEVZIP=${MOD}-dev_${VER}-${REV}_${ARCH}.zip

HEX=`echo $THIS | md5sum | cut -d' ' -f1`
TARGET=c:/devel/target/$HEX

usestable
usemingw64
usemsvs9x64

(

set -x

# Avoid the silly "relink" stuff in libtool
sed -e 's/need_relink=yes/need_relink=no # no way --tml/' <ltmain.sh >ltmain.temp && mv ltmain.temp ltmain.sh

# Avoid using "file" in libtool. Otherwise libtool won't create a
# shared library, and give the extremely confusing and annoying
# warning "Trying to link with static lib archive [...] But I
# can only do this if you have shared version of the
# library, which you do not appear to have."

# Screw libtool. I know what I am doing. Yes, I do want to link with a
# static libintl now. (The proxy-libintl libintl wrapper.)

sed -e 's!file /!dont-want-to-use-file!' <configure >configure.temp && mv configure.temp configure &&

# Fix problems with libtool and Win64

sed -e 's!file format pe-i386!file format pe-!' <ltmain.sh >ltmain.sh.temp && mv ltmain.sh.temp ltmain.sh &&
sed -e 's!file_magic file format pei\*-i386!file_magic file format pei*-!' <configure >configure.temp && mv configure.temp configure &&

patch -p0 <<\EOF
Index: glib/gmain.c
===================================================================
--- glib/gmain.c	(revision 7307)
+++ glib/gmain.c	(revision 7308)
@@ -1717,20 +1717,21 @@
   result->tv_usec = r.tv_usec;
 #else
   FILETIME ft;
-  guint64 *time64 = (guint64 *) &ft;
+  guint64 time64;
 
   g_return_if_fail (result != NULL);
 
   GetSystemTimeAsFileTime (&ft);
+  memmove (&time64, &ft, sizeof (FILETIME));
 
   /* Convert from 100s of nanoseconds since 1601-01-01
    * to Unix epoch. Yes, this is Y2038 unsafe.
    */
-  *time64 -= G_GINT64_CONSTANT (116444736000000000);
-  *time64 /= 10;
+  time64 -= G_GINT64_CONSTANT (116444736000000000);
+  time64 /= 10;
 
-  result->tv_sec = *time64 / 1000000;
-  result->tv_usec = *time64 % 1000000;
+  result->tv_sec = time64 / 1000000;
+  result->tv_usec = time64 % 1000000;
 #endif
 }
 
EOF

CC='x86_64-pc-mingw32-gcc' CPPFLAGS='-I/opt/proxy-libintl/include' LDFLAGS='-L/opt/proxy-libintl/lib64 -Wl,--enable-auto-image-base' CFLAGS=-O2 ./configure --host=x86_64-pc-mingw32 --disable-gtk-doc --prefix=$TARGET &&
libtoolcacheize &&
make glibconfig.h.win32 &&
make glibconfig.h &&
mv glibconfig.h glibconfig.h.autogened &&
cp glibconfig.h.win32 glibconfig.h &&
make -j3 install &&

./glib-zip &&

mv /tmp/glib-$VER.zip /tmp/$RUNZIP &&
mv /tmp/glib-dev-$VER.zip /tmp/$DEVZIP

) 2>&1 | tee /devel/src/tml/make/$THIS.log

(cd /devel && zip /tmp/$DEVZIP src/tml/make/$THIS.{sh,log}) &&
manifestify /tmp/$RUNZIP /tmp/$DEVZIP
