# This is a shell script that calls functions and scripts from
# tml@iki.fi's personal work environment. It is not expected to be
# usable unmodified by others, and is included only for reference.

MOD=icon-naming-utils
VER=0.8.7
REV=1
ARCH=win32

THIS=${MOD}_${VER}-${REV}_${ARCH}

RUNZIP=${MOD}_${VER}-${REV}_${ARCH}.zip
DEVZIP=${MOD}-dev_${VER}-${REV}_${ARCH}.zip

HEX=`echo $THIS | md5sum | cut -d' ' -f1`
TARGET=c:/devel/target/$HEX

usestable

(

set -x

patch --verbose <<'EOF'
--- ../0.8.6.orig/icon-name-mapping.pl.in
+++ icon-name-mapping.pl.in
@@ -11,6 +11,7 @@
 use strict;
 use XML::Simple;
 use Getopt::Long;
+use Cwd;
 
 my $PROGRAM = "icon-name-mapping";
 
@@ -18,6 +19,13 @@
 my $LN_S = ($^O eq 'MSWin32' ? 'cp' : 'ln -s');
 my $mapdir = $ENV{INU_DATA_DIR} || "@DATADIR@";
 
+if ($^O eq 'MSWin32')
+  {
+    my $prefix = $0;
+    $prefix =~ s!([\\/])[^\\/]+$!$1..!;
+    $mapdir = $prefix . $1 . 'share' . $1 . 'icon-naming-utils';
+  }
+
 ############################################################################
 my @default_getopt_config = ("permute", "pass_through", "bundling",
 			     "no_auto_abbrev", "no_ignore_case");
@@ -38,29 +46,36 @@
     return $mapping;
 }
 
+sub tls_system {
+    my $cmd = shift;
+
+    print $cmd, "\n";
+    system ($cmd);
+}
+
 sub tls_map_icons {
     my $mapping = shift;
     my $dirname = shift;
 
     print "Setting up icon mapping for: $dirname\n";
-    chomp (my $cwd = `pwd`);
+    my $cwd = Cwd::cwd();
     chdir $dirname;
     foreach my $icon (@{$mapping->{context}->{$dirname}->{icon}}) {
         if (-f "$icon->{name}.png") {
             foreach my $legacy (@{$icon->{link}}) {
-                system ("$LN_S $icon->{name}.png $legacy.png")
+                tls_system ("$LN_S $icon->{name}.png $legacy.png")
                     if (! -e "$legacy.png");
             }
         } elsif (-f "$icon->{name}.svg") {
             foreach my $legacy (@{$icon->{link}}) {
-                system ("$LN_S $icon->{name}.svg $legacy.svg")
+                tls_system ("$LN_S $icon->{name}.svg $legacy.svg")
                     if (! -e "$legacy.svg");
             }
         }
 
         if (-f "$icon->{name}.icon") {
             foreach my $legacy (@{$icon->{link}}) {
-                system ("$LN_S $icon->{name}.icon $legacy.icon")
+                tls_system ("$LN_S $icon->{name}.icon $legacy.icon")
                     if (! -e "$legacy.icon");
             }
         }
EOF

PERL=$INTLTOOL_PERL ./configure --prefix=$TARGET &&

PERL=$INTLTOOL_PERL make install &&

cd /devel/target/$HEX &&

rm -f /tmp/$RUNZIP &&
zip -r -D /tmp/$RUNZIP libexec share/icon-naming-utils &&
rm -f /tmp/$DEVZIP &&
zip -r -D /tmp/$DEVZIP share/dtds share/pkgconfig

) 2>&1 | tee /devel/src/tml/make/$THIS.log

(cd /devel && zip /tmp/$DEVZIP src/tml/make/$THIS.{sh,log}) &&
manifestify /tmp/$RUNZIP /tmp/$DEVZIP
