#	Nasal Logic for the KFC250 Autopilot
var lat_mode = props.globals.initNode("/autopilot/locks/lat-mode", 0, "INT");	# 0 = wing holder, 1 = HDG SEL, 2 = NAV, 3 =
var vert_mode = props.globals.initNode("/autopilot/locks/vert-mode", 0, "INT");	# 0 = pitch holder, 1 = ALT HOLD,

var ap_sw = props.globals.getNode("/autopilot/switches/ap", 1);
var fd_sw = props.globals.getNode("/autopilot/switches/fd", 1);

var hdg_btn = func{
	lat_mode.setIntValue( 1 );
	if( nav_auto_capture_timer.running ) nav_auto_capture_timer.stop();
}

var nav_hdg_defl = props.globals.getNode("/instrumentation/nav/heading-needle-deflection-norm", 1);
var nav_auto_capture = func{
	if( nav_hdg_defl.getDoubleValue() > -0.8 and nav_hdg_defl.getDoubleValue() < 0.8 ){
		lat_mode.setIntValue( 2 );
		nav_auto_capture_timer.stop();
	}
}
var nav_auto_capture_timer = maketimer( 0.5, nav_auto_capture );
nav_auto_capture_timer.simulatedTime = 1;

var nav_btn = func{
	if( nav_hdg_defl.getDoubleValue() > -0.8 and nav_hdg_defl.getDoubleValue() < 0.8 ){
		lat_mode.setIntValue( 2 );
	} else {
		nav_auto_capture_timer.start();
	}
}

var alt_btn = func{
	vert_mode.setIntValue( 1 );
}

setlistener( ap_sw, func {
	if( ap_sw.getBoolValue() ){
		lat_mode.setIntValue( 0 );
		vert_mode.setIntValue( 0 );
		setprop("/autopilot/settings/target-pitch-deg", getprop("/orientation/pitch-deg") );
	}
});
