# Simulation of Alpha/Velis Electro Tachometer (RPM) by Bea Wolf (D-ECHO) based on

# A3XX Lower ECAM Canvas
# Joshua Davidson (it0uchpods)

# References:
#	https://www.kanardia.eu/wp-content/uploads/manuals/RPM-Manual.pdf
#	POH (see -jsb.xml)

var RPM_main = nil;
var RPM_display = nil;

var volts = props.globals.getNode( "/systems/electrical/outputs/eis", 1 );

var instrument_dir = "Aircraft/AlphaElectro/Models/Instruments/RPM/";


var canvas_RPM_base = {
	init: func(canvas_group, file) {
		canvas.parsesvg(canvas_group, file, {'font-mapper': global.canvas.FontMapper});
		
		var svg_keys = me.getKeys();
		foreach (var key; svg_keys) {
			me[key] = canvas_group.getElementById(key);
		}

		me.page = canvas_group;
		
		return me;
	},
	getKeys: func() {
		return [];
	},
	update: func() {
		if ( volts.getDoubleValue() > 10) {
			RPM_main.page.show();
			RPM_main.update();
		} else {
			RPM_main.page.hide();
		}
	},
};

var last_color = [ 0, 0 ];	# 0 = white, 1 = yellow, 2 = red
	
var canvas_RPM_main = {
	new: func(canvas_group, file) {
		var m = { parents: [canvas_RPM_main , canvas_RPM_base] };
		m.init(canvas_group, file);

		return m;
	},
	getKeys: func() {
		return ["rpm.digits", "power.digits"];
	},
	update: func() {
		var power_val = alphaelectro.engine.power_hp.getDoubleValue() * 0.7457;
		
		me["power.digits"].setText(sprintf("%2d", math.round( power_val )));
		
		# Color coding, according to POH (p.2-5)
		#	green: 0 - 48
		#	yellow: 49 - 65
		#	red: >= 66
		#	according to POH, indication stays white unless in warning/caution range (p.7-33)
		if( power_val >= 66 ){
			if( last_color[0] != 2 ){
				me["power.digits"].setColor( 1, 0.27, 0.24 );
				last_color[0] = 2;
			}
		} elsif( power_val >= 49 ){
			if( last_color[0] != 1 ){
				me["power.digits"].setColor( 0.86, 0.98, 0.02 );
				last_color[0] = 1;
			}
		} else {
			if( last_color[0] != 0 ){
				me["power.digits"].setColor( 1, 1, 1 );
				last_color[0] = 0;
			}
		}
		
		
		var rpm_val = alphaelectro.engine.rpm.getDoubleValue();
		
		me["rpm.digits"].setText(sprintf("%4d", math.round( rpm_val, 10 )));
		
		# Color coding, according to POH (p.2-5)
		#	green: 0 - 2299
		#	yellow: 2300-2499
		#	red: >= 2500
		#	according to POH, indication stays white unless in warning/caution range (p.7-33)
		if( rpm_val >= 2500 ){
			if( last_color[1] != 2 ){
				me["rpm.digits"].setColor( 1, 0.27, 0.24 );
				last_color[1] = 2;
			}
		} elsif( rpm_val >= 2300 ){
			if( last_color[1] != 1 ){
				me["rpm.digits"].setColor( 0.86, 0.98, 0.02 );
				last_color[1] = 1;
			}
		} else {
			if( last_color[1] != 0 ){
				me["rpm.digits"].setColor( 1, 1, 1 );
				last_color[1] = 0;
			}
		}
	}
	
};

var base_updater = maketimer( 0.02, canvas_RPM_base.update );
base_updater.simulatedTime = 1;

var ls = setlistener("sim/signals/fdm-initialized", func {
	removelistener( ls );
	RPM_display = canvas.new({
		"name": "RPM",
		"size": [320, 240],
		"view": [320, 240],
		"mipmapping": 1
	});
	RPM_display.addPlacement({"node": "RPM.display"});
	var groupMain = RPM_display.createGroup();


	RPM_main = canvas_RPM_main.new(groupMain, instrument_dir~"RPM_main.svg");

	RPM_main.update();
	base_updater.start();
});
