/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.cdi;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionTarget;
import org.apache.wicket.util.collections.ClassMetaCache;

public class NonContextual<T> {
    private static final Object lock = new Object();
    private static volatile Map<BeanManager, ClassMetaCache<NonContextual<?>>> cache = Collections.emptyMap();
    final InjectionTarget<T> it;
    final BeanManager manager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void undeploy(BeanManager beanManager) {
        if (cache.containsKey(beanManager)) {
            Object object = lock;
            synchronized (object) {
                WeakHashMap newCache = new WeakHashMap(cache);
                newCache.remove(beanManager);
                cache = Collections.unmodifiableMap(newCache);
            }
        }
    }

    public static <T> NonContextual<T> of(Class<? extends T> clazz, BeanManager manager) {
        ClassMetaCache<NonContextual<?>> meta = NonContextual.getCache(manager);
        NonContextual<? extends T> nc = (NonContextual<? extends T>)meta.get(clazz);
        if (nc == null) {
            nc = new NonContextual<T>(manager, clazz);
            meta.put(clazz, nc);
        }
        return nc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ClassMetaCache<NonContextual<?>> getCache(BeanManager manager) {
        ClassMetaCache meta = cache.get(manager);
        if (meta == null) {
            Object object = lock;
            synchronized (object) {
                meta = cache.get(manager);
                if (meta == null) {
                    meta = new ClassMetaCache();
                    WeakHashMap newCache = new WeakHashMap(cache);
                    newCache.put(manager, meta);
                    cache = Collections.unmodifiableMap(newCache);
                }
            }
        }
        return meta;
    }

    private NonContextual(BeanManager manager, Class<? extends T> clazz) {
        this.manager = manager;
        AnnotatedType type = manager.createAnnotatedType(clazz);
        this.it = manager.createInjectionTarget(type);
    }

    public void postConstruct(T instance) {
        CreationalContext cc = this.manager.createCreationalContext(null);
        this.it.inject(instance, cc);
        this.it.postConstruct(instance);
    }

    public void inject(T instance) {
        CreationalContext cc = this.manager.createCreationalContext(null);
        this.it.inject(instance, cc);
    }

    public void preDestroy(T instance) {
        this.it.preDestroy(instance);
    }
}

