/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.cdi;

import javax.enterprise.inject.spi.BeanManager;
import org.apache.wicket.Application;
import org.apache.wicket.IApplicationListener;
import org.apache.wicket.cdi.NonContextual;
import org.apache.wicket.util.lang.Args;

class CdiShutdownCleaner
implements IApplicationListener {
    private final BeanManager beanManager;
    private final boolean preDestroyApplication;

    public CdiShutdownCleaner(BeanManager beanManager, boolean preDestroyApplication) {
        Args.notNull((Object)beanManager, (String)"beanManager");
        this.beanManager = beanManager;
        this.preDestroyApplication = preDestroyApplication;
    }

    public void onAfterInitialized(Application application) {
    }

    public void onBeforeDestroyed(Application application) {
        if (this.preDestroyApplication) {
            NonContextual.of(application.getClass(), this.beanManager).preDestroy(application);
        }
        NonContextual.undeploy(this.beanManager);
    }
}

