/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.atmosphere;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.lang.reflect.Method;
import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.atmosphere.AtmosphereEvent;
import org.apache.wicket.atmosphere.NoFilterPredicate;
import org.apache.wicket.atmosphere.Subscribe;
import org.apache.wicket.behavior.Behavior;

public class EventSubscription {
    private final String componentPath;
    private final Integer behaviorIndex;
    private final String methodName;
    private final Predicate<AtmosphereEvent> filter;
    private final Predicate<AtmosphereEvent> contextAwareFilter;

    public EventSubscription(Component component, Behavior behavior, Method method) {
        this.componentPath = component.getPageRelativePath();
        this.behaviorIndex = behavior == null ? null : Integer.valueOf(component.getBehaviorId(behavior));
        Class<?> eventType = method.getParameterTypes()[1];
        Subscribe subscribe = method.getAnnotation(Subscribe.class);
        this.filter = Predicates.and(EventSubscription.payloadOfType(eventType), EventSubscription.createFilter(subscribe.filter()));
        this.contextAwareFilter = EventSubscription.createFilter(subscribe.contextAwareFilter());
        this.methodName = method.getName();
    }

    public EventSubscription(Component component, Behavior behavior, Method method, Predicate<AtmosphereEvent> filter, Predicate<AtmosphereEvent> contextAwareFilter) {
        this.componentPath = component.getPageRelativePath();
        this.behaviorIndex = behavior == null ? null : Integer.valueOf(component.getBehaviorId(behavior));
        this.filter = filter == null ? new NoFilterPredicate() : filter;
        this.contextAwareFilter = contextAwareFilter == null ? new NoFilterPredicate() : contextAwareFilter;
        this.methodName = method.getName();
    }

    private static Predicate<AtmosphereEvent> payloadOfType(final Class<?> type) {
        return new Predicate<AtmosphereEvent>(){

            public boolean apply(AtmosphereEvent input) {
                return type.isInstance(input.getPayload());
            }
        };
    }

    private static Predicate<AtmosphereEvent> createFilter(Class<? extends Predicate<AtmosphereEvent>> filterClass) {
        try {
            return filterClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new WicketRuntimeException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new WicketRuntimeException((Throwable)e);
        }
    }

    public String getComponentPath() {
        return this.componentPath;
    }

    public Integer getBehaviorIndex() {
        return this.behaviorIndex;
    }

    public Predicate<AtmosphereEvent> getFilter() {
        return this.filter;
    }

    public Predicate<AtmosphereEvent> getContextAwareFilter() {
        return this.contextAwareFilter;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.componentPath, this.behaviorIndex, this.methodName});
    }

    public boolean equals(Object obj) {
        if (obj instanceof EventSubscription) {
            EventSubscription other = (EventSubscription)obj;
            return Objects.equal((Object)this.componentPath, (Object)other.getComponentPath()) && Objects.equal((Object)this.behaviorIndex, (Object)other.getBehaviorIndex()) && Objects.equal((Object)this.methodName, (Object)other.getMethodName());
        }
        return false;
    }
}

