/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.repeater.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.wicket.extensions.markup.html.repeater.tree.ITreeProvider;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IDetachable;
import org.apache.wicket.model.IModel;

public class ProviderSubset<T>
implements Set<T>,
IDetachable {
    private static final long serialVersionUID = 1L;
    private ITreeProvider<T> provider;
    private Set<IModel<T>> models = new HashSet<IModel<T>>();

    public ProviderSubset(ITreeProvider<T> provider) {
        this(provider, false);
    }

    public ProviderSubset(ITreeProvider<T> provider, boolean addRoots) {
        this.provider = provider;
        if (addRoots) {
            Iterator<T> roots = provider.getRoots();
            while (roots.hasNext()) {
                this.add(roots.next());
            }
        }
    }

    public void detach() {
        for (IModel<T> model : this.models) {
            model.detach();
        }
    }

    @Override
    public int size() {
        return this.models.size();
    }

    @Override
    public boolean isEmpty() {
        return this.models.size() == 0;
    }

    @Override
    public void clear() {
        this.detach();
        this.models.clear();
    }

    @Override
    public boolean contains(Object o) {
        IModel<T> model = this.model(o);
        boolean contains = this.models.contains(model);
        model.detach();
        return contains;
    }

    @Override
    public boolean add(T t) {
        return this.models.add(this.model(t));
    }

    @Override
    public boolean remove(Object o) {
        IModel<T> model = this.model(o);
        boolean removed = this.models.remove(model);
        model.detach();
        return removed;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private Iterator<IModel<T>> iterator;
            private IModel<T> current;
            {
                this.iterator = ProviderSubset.this.models.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public T next() {
                this.current = this.iterator.next();
                return this.current.getObject();
            }

            @Override
            public void remove() {
                this.iterator.remove();
                this.current.detach();
                this.current = null;
            }
        };
    }

    @Override
    public boolean addAll(Collection<? extends T> ts) {
        boolean changed = false;
        for (T t : ts) {
            changed |= this.add(t);
        }
        return changed;
    }

    @Override
    public boolean containsAll(Collection<?> cs) {
        for (Object c : cs) {
            if (this.contains(c)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> cs) {
        boolean changed = false;
        for (Object c : cs) {
            changed |= this.remove(c);
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <S> S[] toArray(S[] a) {
        throw new UnsupportedOperationException();
    }

    private IModel<T> model(Object o) {
        return this.provider.model(o);
    }

    public IModel<Set<T>> createModel() {
        return new AbstractReadOnlyModel<Set<T>>(){
            private static final long serialVersionUID = 1L;

            public Set<T> getObject() {
                return ProviderSubset.this;
            }

            public void detach() {
                ProviderSubset.this.detach();
            }
        };
    }
}

