/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.form.palette;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.extensions.markup.html.form.palette.component.Choices;
import org.apache.wicket.extensions.markup.html.form.palette.component.Recorder;
import org.apache.wicket.extensions.markup.html.form.palette.component.Selection;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.panel.GenericPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.request.resource.CssResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.resource.JQueryPluginResourceReference;

public class Palette<T>
extends GenericPanel<Collection<? extends T>> {
    private static final String SELECTED_HEADER_ID = "selectedHeader";
    private static final String AVAILABLE_HEADER_ID = "availableHeader";
    private static final long serialVersionUID = 1L;
    private final IModel<? extends Collection<? extends T>> choicesModel;
    private final IChoiceRenderer<T> choiceRenderer;
    private final int rows;
    private final boolean allowOrder;
    private final boolean allowMoveAll;
    private Recorder<T> recorderComponent;
    private Component choicesComponent;
    private Component selectionComponent;
    private static final ResourceReference JAVASCRIPT = new JQueryPluginResourceReference(Palette.class, "palette.js");
    private static final ResourceReference CSS = new CssResourceReference(Palette.class, "palette.css");

    public Palette(String id, IModel<? extends Collection<? extends T>> choicesModel, IChoiceRenderer<T> choiceRenderer, int rows, boolean allowOrder) {
        this(id, null, choicesModel, choiceRenderer, rows, allowOrder);
    }

    public Palette(String id, IModel<? extends List<? extends T>> model, IModel<? extends Collection<? extends T>> choicesModel, IChoiceRenderer<T> choiceRenderer, int rows, boolean allowOrder) {
        this(id, model, choicesModel, choiceRenderer, rows, allowOrder, false);
    }

    public Palette(String id, IModel<? extends List<? extends T>> model, IModel<? extends Collection<? extends T>> choicesModel, IChoiceRenderer<T> choiceRenderer, int rows, boolean allowOrder, boolean allowMoveAll) {
        super(id, model);
        this.choicesModel = choicesModel;
        this.choiceRenderer = choiceRenderer;
        this.rows = rows;
        this.allowOrder = allowOrder;
        this.allowMoveAll = allowMoveAll;
    }

    protected void onBeforeRender() {
        if (this.get("recorder") == null) {
            this.initFactories();
        }
        super.onBeforeRender();
    }

    private void initFactories() {
        this.recorderComponent = this.newRecorderComponent();
        this.add(new Component[]{this.recorderComponent});
        this.choicesComponent = this.newChoicesComponent();
        this.add(new Component[]{this.choicesComponent});
        this.selectionComponent = this.newSelectionComponent();
        this.add(new Component[]{this.selectionComponent});
        this.add(new Component[]{this.newAddComponent()});
        this.add(new Component[]{this.newRemoveComponent()});
        this.add(new Component[]{this.newUpComponent().setVisible(this.allowOrder)});
        this.add(new Component[]{this.newDownComponent().setVisible(this.allowOrder)});
        this.add(new Component[]{this.newAddAllComponent().setVisible(this.allowMoveAll)});
        this.add(new Component[]{this.newRemoveAllComponent().setVisible(this.allowMoveAll)});
        this.add(new Component[]{this.newAvailableHeader(AVAILABLE_HEADER_ID)});
        this.add(new Component[]{this.newSelectedHeader(SELECTED_HEADER_ID)});
    }

    protected ResourceReference getCSS() {
        return CSS;
    }

    public final boolean isPaletteEnabled() {
        return this.isEnabledInHierarchy();
    }

    public Iterator<T> getSelectedChoices() {
        return this.getRecorderComponent().getSelectedChoices();
    }

    public Iterator<T> getUnselectedChoices() {
        return this.getRecorderComponent().getUnselectedChoices();
    }

    protected Recorder<T> newRecorderComponent() {
        return new Recorder<T>("recorder", this){
            private static final long serialVersionUID = 1L;

            public void updateModel() {
                super.updateModel();
                Palette.this.updateModel();
            }
        };
    }

    protected Component newAvailableHeader(String componentId) {
        return new Label(componentId, (IModel)new ResourceModel("palette.available", "Available"));
    }

    protected Component newSelectedHeader(String componentId) {
        return new Label(componentId, (IModel)new ResourceModel("palette.selected", "Selected"));
    }

    protected Component newDownComponent() {
        return new PaletteButton("moveDownButton"){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.getAttributes().put((Object)"onclick", (Object)Palette.this.getDownOnClickJS());
            }
        };
    }

    protected Component newUpComponent() {
        return new PaletteButton("moveUpButton"){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.getAttributes().put((Object)"onclick", (Object)Palette.this.getUpOnClickJS());
            }
        };
    }

    protected Component newRemoveComponent() {
        return new PaletteButton("removeButton"){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.getAttributes().put((Object)"onclick", (Object)Palette.this.getRemoveOnClickJS());
            }
        };
    }

    protected Component newAddComponent() {
        return new PaletteButton("addButton"){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.getAttributes().put((Object)"onclick", (Object)Palette.this.getAddOnClickJS());
            }
        };
    }

    protected Component newSelectionComponent() {
        return new Selection<T>("selection", this){
            private static final long serialVersionUID = 1L;

            @Override
            protected Map<String, String> getAdditionalAttributes(Object choice) {
                return Palette.this.getAdditionalAttributesForSelection(choice);
            }

            @Override
            protected boolean localizeDisplayValues() {
                return Palette.this.localizeDisplayValues();
            }
        };
    }

    protected Component newAddAllComponent() {
        return new PaletteButton("addAllButton"){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.getAttributes().put((Object)"onclick", (Object)Palette.this.getAddAllOnClickJS());
            }
        };
    }

    protected Component newRemoveAllComponent() {
        return new PaletteButton("removeAllButton"){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.getAttributes().put((Object)"onclick", (Object)Palette.this.getRemoveAllOnClickJS());
            }
        };
    }

    protected Map<String, String> getAdditionalAttributesForSelection(Object choice) {
        return null;
    }

    protected Component newChoicesComponent() {
        return new Choices<T>("choices", this){
            private static final long serialVersionUID = 1L;

            @Override
            protected Map<String, String> getAdditionalAttributes(Object choice) {
                return Palette.this.getAdditionalAttributesForChoices(choice);
            }

            @Override
            protected boolean localizeDisplayValues() {
                return Palette.this.localizeDisplayValues();
            }
        };
    }

    protected boolean localizeDisplayValues() {
        return true;
    }

    protected Map<String, String> getAdditionalAttributesForChoices(Object choice) {
        return null;
    }

    protected Component getChoicesComponent() {
        return this.choicesComponent;
    }

    protected Component getSelectionComponent() {
        return this.selectionComponent;
    }

    public final Recorder<T> getRecorderComponent() {
        return this.recorderComponent;
    }

    public Collection<? extends T> getChoices() {
        return (Collection)this.choicesModel.getObject();
    }

    public Collection<T> getModelCollection() {
        return (Collection)this.getDefaultModelObject();
    }

    public IChoiceRenderer<T> getChoiceRenderer() {
        return this.choiceRenderer;
    }

    public int getRows() {
        return this.rows;
    }

    protected final void updateModel() {
        Iterator<T> it = this.getRecorderComponent().getSelectedChoices();
        this.modelChanging();
        Collection<T> collection = this.getModelCollection();
        collection.clear();
        while (it.hasNext()) {
            collection.add(it.next());
        }
        this.modelChanged();
        IModel defaultModel = this.getDefaultModel();
        defaultModel.setObject(collection);
    }

    protected String buildJSCall(String funcName) {
        return funcName + "('" + this.getChoicesComponent().getMarkupId() + "','" + this.getSelectionComponent().getMarkupId() + "','" + this.getRecorderComponent().getMarkupId() + "');";
    }

    public String getChoicesOnFocusJS() {
        return this.buildJSCall("Wicket.Palette.choicesOnFocus");
    }

    public String getSelectionOnFocusJS() {
        return this.buildJSCall("Wicket.Palette.selectionOnFocus");
    }

    public String getAddOnClickJS() {
        return this.buildJSCall("Wicket.Palette.add");
    }

    public String getRemoveOnClickJS() {
        return this.buildJSCall("Wicket.Palette.remove");
    }

    public String getUpOnClickJS() {
        return this.buildJSCall("Wicket.Palette.moveUp");
    }

    public String getDownOnClickJS() {
        return this.buildJSCall("Wicket.Palette.moveDown");
    }

    public String getAddAllOnClickJS() {
        return this.buildJSCall("Wicket.Palette.addAll");
    }

    public String getRemoveAllOnClickJS() {
        return this.buildJSCall("Wicket.Palette.removeAll");
    }

    protected void onDetach() {
        this.choicesModel.detach();
        super.onDetach();
    }

    public void renderHead(IHeaderResponse response) {
        ResourceReference css = this.getCSS();
        if (css != null) {
            response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)css));
        }
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)JAVASCRIPT));
    }

    private class PaletteButton
    extends WebMarkupContainer {
        private static final long serialVersionUID = 1L;

        public PaletteButton(String id) {
            super(id);
        }

        protected void onComponentTag(ComponentTag tag) {
            super.onComponentTag(tag);
            if (!Palette.this.isPaletteEnabled()) {
                tag.getAttributes().put((Object)"disabled", (Object)"disabled");
            }
        }
    }
}

