/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.ext.search.tika;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxrs.ext.search.SearchBean;
import org.apache.tika.detect.DefaultDetector;
import org.apache.tika.detect.Detector;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.ToTextContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class TikaContentExtractor {
    private static final Logger LOG = LogUtils.getL7dLogger(TikaContentExtractor.class);
    private final List<Parser> parsers;
    private final Detector detector;

    public TikaContentExtractor() {
        this((Parser)new AutoDetectParser(), false);
    }

    public TikaContentExtractor(Parser parser) {
        this(parser, false);
    }

    public TikaContentExtractor(List<Parser> parsers) {
        this(parsers, (Detector)new DefaultDetector());
    }

    public TikaContentExtractor(List<Parser> parsers, Detector detector) {
        this.parsers = parsers;
        this.detector = detector;
    }

    public TikaContentExtractor(Parser parser, boolean validateMediaType) {
        this(Collections.singletonList(parser), (Detector)(validateMediaType ? new DefaultDetector() : null));
    }

    public TikaContent extract(InputStream in) {
        return this.extract(in, (javax.ws.rs.core.MediaType)null);
    }

    public TikaContent extract(InputStream in, javax.ws.rs.core.MediaType mt) {
        return this.extract(in, (ContentHandler)new ToTextContentHandler(), mt);
    }

    public TikaContent extract(InputStream in, ContentHandler handler) {
        return this.extract(in, handler, (javax.ws.rs.core.MediaType)null);
    }

    public TikaContent extract(InputStream in, ContentHandler handler, javax.ws.rs.core.MediaType mt) {
        return this.extract(in, handler, mt, null);
    }

    public TikaContent extract(InputStream in, ContentHandler handler, ParseContext context) {
        return this.extract(in, handler, null, context);
    }

    public TikaContent extract(InputStream in, ContentHandler handler, javax.ws.rs.core.MediaType mtHint, ParseContext context) {
        if (in == null) {
            return null;
        }
        Metadata metadata = new Metadata();
        try {
            MediaType mediaType = null;
            if (mtHint != null) {
                mediaType = MediaType.parse((String)mtHint.toString());
            } else if (this.detector != null && in.markSupported()) {
                mediaType = this.detector.detect(in, metadata);
            }
            if (mediaType != null) {
                metadata.set("Content-Type", mediaType.toString());
            }
            Parser parser = null;
            if (this.parsers.size() == 1) {
                parser = this.parsers.get(0);
            } else {
                for (Parser p : this.parsers) {
                    if (mediaType != null && !p.getSupportedTypes(context).contains(mediaType)) continue;
                    parser = p;
                    break;
                }
            }
            if (parser == null) {
                return null;
            }
            if (context == null) {
                context = new ParseContext();
            }
            if (context.get(Parser.class) == null) {
                context.set(Parser.class, parser instanceof AutoDetectParser ? parser : new AutoDetectParser());
            }
            try {
                parser.parse(in, handler, metadata, context);
            }
            catch (Exception ex) {
                if (handler == null) {
                    handler = new IgnoreContentHandler();
                    parser.parse(in, handler, metadata, context);
                }
                throw ex;
            }
            return new TikaContent((ContentHandler)handler, metadata, mediaType);
        }
        catch (IOException ex) {
            LOG.log(Level.WARNING, "Unable to extract media type from input stream", ex);
        }
        catch (SAXException ex) {
            LOG.log(Level.WARNING, "Unable to parse input stream", ex);
        }
        catch (TikaException ex) {
            LOG.log(Level.WARNING, "Unable to parse input stream", ex);
        }
        return null;
    }

    public TikaContent extractMetadata(InputStream in) {
        return this.extract(in, (ContentHandler)null);
    }

    public SearchBean extractMetadataToSearchBean(InputStream in) {
        TikaContent tc = this.extractMetadata(in);
        if (tc == null) {
            return null;
        }
        Metadata metadata = tc.getMetadata();
        SearchBean bean = new SearchBean();
        for (String property : metadata.names()) {
            bean.set(property, metadata.get(property));
        }
        return bean;
    }

    private static final class IgnoreContentHandler
    extends ToTextContentHandler {
        private IgnoreContentHandler() {
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        public String toString() {
            return "";
        }
    }

    public static class TikaContent
    implements Serializable {
        private static final long serialVersionUID = -1240120543378490963L;
        private ContentHandler content;
        private Metadata metadata;
        private MediaType mediaType;

        public TikaContent(ContentHandler content, Metadata metadata, MediaType mediaType) {
            this.content = content;
            this.metadata = metadata;
            this.mediaType = mediaType;
        }

        public String getContent() {
            return this.content instanceof ToTextContentHandler ? this.content.toString() : null;
        }

        public Metadata getMetadata() {
            return this.metadata;
        }

        public MediaType getMediaType() {
            return this.mediaType;
        }
    }
}

