/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka;

import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.camel.CamelContext;
import org.apache.camel.SSLContextParametersAware;
import org.apache.camel.component.kafka.DefaultKafkaManualCommitFactory;
import org.apache.camel.component.kafka.KafkaConfiguration;
import org.apache.camel.component.kafka.KafkaEndpoint;
import org.apache.camel.component.kafka.KafkaManualCommitFactory;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.spi.Metadata;
import org.apache.camel.util.ObjectHelper;

public class KafkaComponent
extends DefaultComponent
implements SSLContextParametersAware {
    private KafkaConfiguration configuration;
    @Metadata(label="advanced")
    private ExecutorService workerPool;
    @Metadata(label="security", defaultValue="false")
    private boolean useGlobalSslContextParameters;
    @Metadata(label="consumer", defaultValue="false")
    private boolean breakOnFirstError;
    @Metadata(label="consumer", defaultValue="false")
    private boolean allowManualCommit;
    @Metadata(label="consumer,advanced")
    private KafkaManualCommitFactory kafkaManualCommitFactory = new DefaultKafkaManualCommitFactory();

    public KafkaComponent() {
    }

    public KafkaComponent(CamelContext context) {
        super(context);
    }

    protected KafkaEndpoint createEndpoint(String uri, String remaining, Map<String, Object> params) throws Exception {
        if (ObjectHelper.isEmpty((Object)remaining)) {
            throw new IllegalArgumentException("Topic must be configured on endpoint using syntax kafka:topic");
        }
        KafkaEndpoint endpoint = new KafkaEndpoint(uri, this);
        if (this.configuration != null) {
            KafkaConfiguration copy = this.configuration.copy();
            endpoint.setConfiguration(copy);
        }
        endpoint.getConfiguration().setTopic(remaining);
        endpoint.getConfiguration().setWorkerPool(this.getWorkerPool());
        endpoint.getConfiguration().setBreakOnFirstError(this.isBreakOnFirstError());
        endpoint.getConfiguration().setAllowManualCommit(this.isAllowManualCommit());
        this.setProperties(endpoint.getConfiguration(), params);
        this.setProperties((Object)endpoint, params);
        if (endpoint.getConfiguration().getSslContextParameters() == null) {
            endpoint.getConfiguration().setSslContextParameters(this.retrieveGlobalSslContextParameters());
        }
        return endpoint;
    }

    public KafkaConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(KafkaConfiguration configuration) {
        this.configuration = configuration;
    }

    public String getBrokers() {
        return this.configuration != null ? this.configuration.getBrokers() : null;
    }

    public void setBrokers(String brokers) {
        if (this.configuration == null) {
            this.configuration = new KafkaConfiguration();
        }
        this.configuration.setBrokers(brokers);
    }

    public ExecutorService getWorkerPool() {
        return this.workerPool;
    }

    public void setWorkerPool(ExecutorService workerPool) {
        this.workerPool = workerPool;
    }

    public boolean isUseGlobalSslContextParameters() {
        return this.useGlobalSslContextParameters;
    }

    public void setUseGlobalSslContextParameters(boolean useGlobalSslContextParameters) {
        this.useGlobalSslContextParameters = useGlobalSslContextParameters;
    }

    public boolean isBreakOnFirstError() {
        return this.breakOnFirstError;
    }

    public void setBreakOnFirstError(boolean breakOnFirstError) {
        this.breakOnFirstError = breakOnFirstError;
    }

    public boolean isAllowManualCommit() {
        return this.allowManualCommit;
    }

    public void setAllowManualCommit(boolean allowManualCommit) {
        this.allowManualCommit = allowManualCommit;
    }

    public KafkaManualCommitFactory getKafkaManualCommitFactory() {
        return this.kafkaManualCommitFactory;
    }

    public void setKafkaManualCommitFactory(KafkaManualCommitFactory kafkaManualCommitFactory) {
        this.kafkaManualCommitFactory = kafkaManualCommitFactory;
    }
}

