/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.spi;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.javamoney.moneta.spi.ConvertBigDecimal;

enum ConvertNumberValue {
    INSTANCE;

    private final Map<Class<? extends Number>, ConvertNumberValueI> convertIMap = new HashMap<Class<? extends Number>, ConvertNumberValueI>();

    private ConvertNumberValue() {
        this.convertIMap.put(BigDecimal.class, new ConvertNumberValueBigDecimal());
        this.convertIMap.put(BigInteger.class, new ConvertNumberValueBigInteger());
        this.convertIMap.put(Float.class, new ConvertNumberValueFloat());
        this.convertIMap.put(Double.class, new ConvertNumberValueDouble());
        this.convertIMap.put(Long.class, new ConvertNumberValueLong());
        this.convertIMap.put(Integer.class, new ConvertNumberValueInteger());
        this.convertIMap.put(Short.class, new ConvertNumberValueShort());
        this.convertIMap.put(Byte.class, new ConvertNumberValueByte());
        this.convertIMap.put(AtomicInteger.class, new ConvertNumberValueAtomicInteger());
        this.convertIMap.put(AtomicLong.class, new ConvertNumberValueAtomicLong());
    }

    public static <T extends Number> T of(Class<T> numberType, Number number) {
        return INSTANCE.convert(numberType, number);
    }

    public static <T extends Number> T ofExact(Class<T> numberType, Number number) {
        return INSTANCE.convertExact(numberType, number);
    }

    public <T extends Number> T convert(Class<T> numberType, Number number) {
        return Optional.ofNullable(this.convertIMap.get(numberType)).orElseThrow(() -> new IllegalArgumentException("Unsupported numeric type: " + numberType)).convert(numberType, number);
    }

    public <T extends Number> T convertExact(Class<T> numberType, Number number) {
        return Optional.ofNullable(this.convertIMap.get(numberType)).orElseThrow(() -> new IllegalArgumentException("Unsupported numeric type: " + numberType)).convertExact(numberType, number);
    }

    static class ConvertNumberValueAtomicLong
    implements ConvertNumberValueI<AtomicLong> {
        ConvertNumberValueAtomicLong() {
        }

        @Override
        public <E extends Number> AtomicLong convert(Class<E> numberType, Number number) {
            return new AtomicLong(number.longValue());
        }

        @Override
        public <E extends Number> AtomicLong convertExact(Class<E> numberType, Number number) {
            return new AtomicLong(ConvertBigDecimal.of(number).longValueExact());
        }
    }

    static class ConvertNumberValueAtomicInteger
    implements ConvertNumberValueI<AtomicInteger> {
        ConvertNumberValueAtomicInteger() {
        }

        @Override
        public <E extends Number> AtomicInteger convert(Class<E> numberType, Number number) {
            return new AtomicInteger(number.intValue());
        }

        @Override
        public <E extends Number> AtomicInteger convertExact(Class<E> numberType, Number number) {
            return new AtomicInteger(ConvertBigDecimal.of(number).intValueExact());
        }
    }

    static class ConvertNumberValueByte
    implements ConvertNumberValueI<Byte> {
        ConvertNumberValueByte() {
        }

        @Override
        public <E extends Number> Byte convert(Class<E> numberType, Number number) {
            return number.byteValue();
        }

        @Override
        public <E extends Number> Byte convertExact(Class<E> numberType, Number number) {
            return ConvertBigDecimal.of(number).byteValueExact();
        }
    }

    static class ConvertNumberValueShort
    implements ConvertNumberValueI<Short> {
        ConvertNumberValueShort() {
        }

        @Override
        public <E extends Number> Short convert(Class<E> numberType, Number number) {
            return number.shortValue();
        }

        @Override
        public <E extends Number> Short convertExact(Class<E> numberType, Number number) {
            return ConvertBigDecimal.of(number).shortValueExact();
        }
    }

    static class ConvertNumberValueInteger
    implements ConvertNumberValueI<Integer> {
        ConvertNumberValueInteger() {
        }

        @Override
        public <E extends Number> Integer convert(Class<E> numberType, Number number) {
            return number.intValue();
        }

        @Override
        public <E extends Number> Integer convertExact(Class<E> numberType, Number number) {
            return ConvertBigDecimal.of(number).intValueExact();
        }
    }

    static class ConvertNumberValueLong
    implements ConvertNumberValueI<Long> {
        ConvertNumberValueLong() {
        }

        @Override
        public <E extends Number> Long convert(Class<E> numberType, Number number) {
            return number.longValue();
        }

        @Override
        public <E extends Number> Long convertExact(Class<E> numberType, Number number) {
            return ConvertBigDecimal.of(number).longValueExact();
        }
    }

    static class ConvertNumberValueFloat
    implements ConvertNumberValueI<Float> {
        ConvertNumberValueFloat() {
        }

        @Override
        public <E extends Number> Float convert(Class<E> numberType, Number number) {
            return Float.valueOf(number.floatValue());
        }

        @Override
        public <E extends Number> Float convertExact(Class<E> numberType, Number number) {
            float f = number.floatValue();
            if (f == Float.NEGATIVE_INFINITY || f == Float.POSITIVE_INFINITY) {
                throw new ArithmeticException("Value not exact mappable to float: " + number);
            }
            return Float.valueOf(f);
        }
    }

    static class ConvertNumberValueDouble
    implements ConvertNumberValueI<Double> {
        ConvertNumberValueDouble() {
        }

        @Override
        public <E extends Number> Double convert(Class<E> numberType, Number number) {
            return number.doubleValue();
        }

        @Override
        public <E extends Number> Double convertExact(Class<E> numberType, Number number) {
            double d = number.doubleValue();
            if (d == Double.NEGATIVE_INFINITY || d == Double.POSITIVE_INFINITY) {
                throw new ArithmeticException("Value not exact mappable to double: " + number);
            }
            return d;
        }
    }

    static class ConvertNumberValueBigInteger
    implements ConvertNumberValueI<BigInteger> {
        ConvertNumberValueBigInteger() {
        }

        @Override
        public <E extends Number> BigInteger convert(Class<E> numberType, Number number) {
            return ConvertBigDecimal.of(number).toBigInteger();
        }

        @Override
        public <E extends Number> BigInteger convertExact(Class<E> numberType, Number number) {
            return ConvertBigDecimal.of(number).toBigIntegerExact();
        }
    }

    static class ConvertNumberValueBigDecimal
    implements ConvertNumberValueI<BigDecimal> {
        ConvertNumberValueBigDecimal() {
        }

        @Override
        public <E extends Number> BigDecimal convert(Class<E> numberType, Number number) {
            return ConvertBigDecimal.of(number);
        }

        @Override
        public <E extends Number> BigDecimal convertExact(Class<E> numberType, Number number) {
            return ConvertBigDecimal.of(number);
        }
    }

    static interface ConvertNumberValueI<T extends Number> {
        public <E extends Number> T convert(Class<E> var1, Number var2);

        public <E extends Number> T convertExact(Class<E> var1, Number var2);
    }
}

