/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.cloud;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.camel.CamelContext;
import org.apache.camel.builder.xml.TimeUnitAdapter;
import org.apache.camel.model.cloud.AggregatingServiceCallServiceDiscoveryConfiguration;
import org.apache.camel.model.cloud.ConsulServiceCallServiceDiscoveryConfiguration;
import org.apache.camel.model.cloud.DnsServiceCallServiceDiscoveryConfiguration;
import org.apache.camel.model.cloud.EtcdServiceCallServiceDiscoveryConfiguration;
import org.apache.camel.model.cloud.KubernetesServiceCallServiceDiscoveryConfiguration;
import org.apache.camel.model.cloud.ServiceCallDefinition;
import org.apache.camel.model.cloud.ServiceCallServiceDiscoveryConfiguration;
import org.apache.camel.model.cloud.StaticServiceCallServiceDiscoveryConfiguration;
import org.apache.camel.spi.Metadata;

@Metadata(label="routing,cloud,service-discovery")
@XmlRootElement(name="cachingServiceDiscovery")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class CachingServiceCallServiceDiscoveryConfiguration
extends ServiceCallServiceDiscoveryConfiguration {
    @XmlAttribute
    @Metadata(defaultValue="60")
    private Integer timeout = 60;
    @XmlAttribute
    @XmlJavaTypeAdapter(value=TimeUnitAdapter.class)
    @Metadata(defaultValue="SECONDS")
    private TimeUnit units = TimeUnit.SECONDS;
    @XmlElements(value={@XmlElement(name="consulServiceDiscovery", type=ConsulServiceCallServiceDiscoveryConfiguration.class), @XmlElement(name="dnsServiceDiscovery", type=DnsServiceCallServiceDiscoveryConfiguration.class), @XmlElement(name="etcdServiceDiscovery", type=EtcdServiceCallServiceDiscoveryConfiguration.class), @XmlElement(name="kubernetesServiceDiscovery", type=KubernetesServiceCallServiceDiscoveryConfiguration.class), @XmlElement(name="aggregatingServiceDiscovery", type=AggregatingServiceCallServiceDiscoveryConfiguration.class), @XmlElement(name="staticServiceDiscovery", type=StaticServiceCallServiceDiscoveryConfiguration.class)})
    private ServiceCallServiceDiscoveryConfiguration serviceDiscoveryConfiguration;

    public CachingServiceCallServiceDiscoveryConfiguration() {
        this(null);
    }

    public CachingServiceCallServiceDiscoveryConfiguration(ServiceCallDefinition parent) {
        super(parent, "caching-service-discovery");
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public TimeUnit getUnits() {
        return this.units;
    }

    public void setUnits(TimeUnit units) {
        this.units = units;
    }

    public ServiceCallServiceDiscoveryConfiguration getServiceDiscoveryConfiguration() {
        return this.serviceDiscoveryConfiguration;
    }

    public void setServiceDiscoveryConfiguration(ServiceCallServiceDiscoveryConfiguration serviceDiscoveryConfiguration) {
        this.serviceDiscoveryConfiguration = serviceDiscoveryConfiguration;
    }

    public CachingServiceCallServiceDiscoveryConfiguration timeout(Integer timeout) {
        this.setTimeout(timeout);
        return this;
    }

    public CachingServiceCallServiceDiscoveryConfiguration units(TimeUnit units) {
        this.setUnits(units);
        return this;
    }

    public CachingServiceCallServiceDiscoveryConfiguration serviceDiscoveryConfiguration(ServiceCallServiceDiscoveryConfiguration serviceDiscoveryConfiguration) {
        this.setServiceDiscoveryConfiguration(serviceDiscoveryConfiguration);
        return this;
    }

    public CachingServiceCallServiceDiscoveryConfiguration cachingServiceDiscovery() {
        CachingServiceCallServiceDiscoveryConfiguration conf = new CachingServiceCallServiceDiscoveryConfiguration();
        this.setServiceDiscoveryConfiguration(conf);
        return this.serviceDiscoveryConfiguration(conf);
    }

    public ConsulServiceCallServiceDiscoveryConfiguration consulServiceDiscovery() {
        ConsulServiceCallServiceDiscoveryConfiguration conf = new ConsulServiceCallServiceDiscoveryConfiguration();
        this.setServiceDiscoveryConfiguration(conf);
        return conf;
    }

    public DnsServiceCallServiceDiscoveryConfiguration dnsServiceDiscovery() {
        DnsServiceCallServiceDiscoveryConfiguration conf = new DnsServiceCallServiceDiscoveryConfiguration();
        this.setServiceDiscoveryConfiguration(conf);
        return conf;
    }

    public EtcdServiceCallServiceDiscoveryConfiguration etcdServiceDiscovery() {
        EtcdServiceCallServiceDiscoveryConfiguration conf = new EtcdServiceCallServiceDiscoveryConfiguration();
        this.setServiceDiscoveryConfiguration(conf);
        return conf;
    }

    public KubernetesServiceCallServiceDiscoveryConfiguration kubernetesServiceDiscovery() {
        KubernetesServiceCallServiceDiscoveryConfiguration conf = new KubernetesServiceCallServiceDiscoveryConfiguration();
        this.setServiceDiscoveryConfiguration(conf);
        return conf;
    }

    public AggregatingServiceCallServiceDiscoveryConfiguration aggregatingServiceDiscovery() {
        AggregatingServiceCallServiceDiscoveryConfiguration conf = new AggregatingServiceCallServiceDiscoveryConfiguration();
        this.setServiceDiscoveryConfiguration(conf);
        return conf;
    }

    public StaticServiceCallServiceDiscoveryConfiguration staticServiceDiscovery() {
        StaticServiceCallServiceDiscoveryConfiguration conf = new StaticServiceCallServiceDiscoveryConfiguration();
        this.setServiceDiscoveryConfiguration(conf);
        return conf;
    }

    @Override
    protected void postProcessFactoryParameters(CamelContext camelContext, Map<String, Object> parameters) throws Exception {
        if (this.serviceDiscoveryConfiguration != null) {
            parameters.put("serviceDiscovery", this.serviceDiscoveryConfiguration.newInstance(camelContext));
        }
    }
}

