/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.collection.impl.metadata.cpe;

import org.apache.uima.collection.metadata.CasProcessorErrorRateThreshold;
import org.apache.uima.resource.metadata.impl.MetaDataObject_impl;
import org.apache.uima.resource.metadata.impl.PropertyXmlInfo;
import org.apache.uima.resource.metadata.impl.XmlizationInfo;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLParser;
import org.w3c.dom.Element;
import org.xml.sax.helpers.AttributesImpl;

public class CasProcessorErrorRateThresholdImpl
extends MetaDataObject_impl
implements CasProcessorErrorRateThreshold {
    private static final long serialVersionUID = -9214395691914383261L;
    private String value;
    private String action;
    private static final XmlizationInfo XMLIZATION_INFO = new XmlizationInfo("errorRateThreshold", new PropertyXmlInfo[0]);

    public void setMaxErrorCount(int aErrorCount) {
        int sampleSize;
        try {
            sampleSize = this.getMaxErrorSampleSize();
        }
        catch (NumberFormatException e) {
            sampleSize = 1;
        }
        this.setValue(String.valueOf(aErrorCount) + "/" + String.valueOf(sampleSize));
    }

    public int getMaxErrorCount() {
        String errorCount = this.getValue();
        if (errorCount == null) {
            return 1;
        }
        int pos = 0;
        pos = errorCount.indexOf("/");
        if (pos > -1) {
            errorCount = errorCount.trim().substring(0, pos);
        }
        return Integer.parseInt(errorCount);
    }

    public void setMaxErrorSampleSize(int aSampleSize) {
        int errorCount;
        try {
            errorCount = this.getMaxErrorCount();
        }
        catch (NumberFormatException e) {
            errorCount = 1;
        }
        this.setValue(String.valueOf(errorCount) + "/" + String.valueOf(aSampleSize));
    }

    public int getMaxErrorSampleSize() {
        String errorSample = this.getValue();
        if (errorSample == null) {
            return 1;
        }
        int pos = 0;
        pos = errorSample.indexOf("/");
        if (pos > -1) {
            errorSample = errorSample.trim().substring(pos + 1);
        }
        return Integer.parseInt(errorSample);
    }

    public void setAction(String aAction) {
        this.action = aAction;
    }

    public String getAction() {
        return this.action;
    }

    public void buildFromXMLElement(Element aElement, XMLParser aParser, XMLParser.ParsingOptions aOptions) throws InvalidXMLException {
        this.setAction(aElement.getAttribute("action"));
        this.setValue(aElement.getAttribute("value"));
    }

    protected AttributesImpl getXMLAttributes() {
        AttributesImpl attrs = super.getXMLAttributes();
        attrs.addAttribute("", "action", "action", "CDATA", String.valueOf(this.getAction()));
        attrs.addAttribute("", "value", "value", "CDATA", this.getValue());
        return attrs;
    }

    protected XmlizationInfo getXmlizationInfo() {
        return XMLIZATION_INFO;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        this.value = string;
    }
}

