/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.docanalyzer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SpringLayout;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.uima.UIMAException;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UIMARuntimeException;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.internal.util.BrowserUtil;
import org.apache.uima.internal.util.XMLUtils;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.tools.docanalyzer.PrefsMediator;
import org.apache.uima.tools.images.Images;
import org.apache.uima.tools.stylemap.ColorParser;
import org.apache.uima.tools.stylemap.StyleMapEditor;
import org.apache.uima.tools.stylemap.StyleMapEntry;
import org.apache.uima.tools.util.gui.Caption;
import org.apache.uima.tools.util.gui.SpringUtilities;
import org.apache.uima.tools.util.htmlview.AnnotationViewGenerator;
import org.apache.uima.tools.viewer.CasAnnotationViewer;
import org.apache.uima.util.CasCreationUtils;
import org.apache.uima.util.CasToInlineXml;
import org.apache.uima.util.FileUtils;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;
import org.apache.uima.util.XmlCasDeserializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class AnnotationViewerDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -7259891069111863433L;
    private File tempDir = this.createTempDir();
    protected AnnotationViewGenerator annotationViewGenerator;
    private StyleMapEditor styleMapEditor;
    private PrefsMediator med1;
    private File styleMapFile;
    JList<String> analyzedResultsList;
    String inputDirPath = null;
    TypeSystem typeSystem = null;
    String[] typesToDisplay = null;
    JRadioButton javaViewerRB = null;
    JRadioButton javaViewerUCRB = null;
    JRadioButton htmlRB = null;
    JRadioButton xmlRB = null;
    private CAS cas;
    private boolean processedStyleMap = false;
    private String defaultCasViewName = "_InitialView";

    public AnnotationViewerDialog(JFrame aParentFrame, String aDialogTitle, PrefsMediator med, File aStyleMapFile, String aPerformanceStats, TypeSystem aTypeSystem, String[] aTypesToDisplay, String interactiveTempFN, boolean javaViewerRBisSelected, boolean javaViewerUCRBisSelected, boolean xmlRBisSelected, CAS cas) {
        super((Frame)aParentFrame, aDialogTitle);
        this.med1 = med;
        this.cas = cas;
        this.annotationViewGenerator = new AnnotationViewGenerator(this.tempDir);
        this.launchThatViewer(med.getOutputDir(), interactiveTempFN, aTypeSystem, aTypesToDisplay, javaViewerRBisSelected, javaViewerUCRBisSelected, xmlRBisSelected, aStyleMapFile, this.tempDir);
    }

    private void resetFiles(String filenameFilter) {
        File dir = new File(this.inputDirPath);
        InteractiveFilter iFilter = new InteractiveFilter(filenameFilter);
        String[] documents = dir.list(iFilter);
        if (documents == null) {
            documents = new String[]{};
        }
        this.analyzedResultsList.setListData((String[])documents);
    }

    public AnnotationViewerDialog(JFrame aParentFrame, String aDialogTitle, PrefsMediator med, File aStyleMapFile, String aPerformanceStats, TypeSystem aTypeSystem, String[] aTypesToDisplay, boolean generatedStyleMap, CAS cas) {
        super((Frame)aParentFrame, aDialogTitle);
        this.med1 = med;
        this.cas = cas;
        this.styleMapFile = aStyleMapFile;
        final String performanceStats = aPerformanceStats;
        this.typeSystem = aTypeSystem;
        this.typesToDisplay = aTypesToDisplay;
        this.annotationViewGenerator = new AnnotationViewGenerator(this.tempDir);
        this.styleMapEditor = new StyleMapEditor(aParentFrame, cas);
        JPanel resultsTitlePanel = new JPanel();
        resultsTitlePanel.setLayout(new BoxLayout(resultsTitlePanel, 1));
        resultsTitlePanel.add(new JLabel("These are the Analyzed Documents."));
        resultsTitlePanel.add(new JLabel("Select viewer type and double-click file to open."));
        this.inputDirPath = med.getOutputDir();
        this.analyzedResultsList = new JList();
        this.resetFiles("");
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.getViewport().add(this.analyzedResultsList, null);
        JPanel southernPanel = new JPanel();
        southernPanel.setLayout(new BoxLayout(southernPanel, 1));
        JPanel filterPanel = new JPanel();
        filterPanel.setLayout(new BoxLayout(filterPanel, 0));
        filterPanel.add(new JLabel("Filter: Filename contains "));
        final JTextField filenameFilter = new JTextField();
        filenameFilter.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                AnnotationViewerDialog.this.resetFiles(filenameFilter.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AnnotationViewerDialog.this.resetFiles(filenameFilter.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                AnnotationViewerDialog.this.resetFiles(filenameFilter.getText());
            }
        });
        filterPanel.add(filenameFilter);
        filterPanel.setBorder(new EmptyBorder(4, 4, 4, 4));
        southernPanel.add(filterPanel);
        JPanel controlsPanel = new JPanel();
        controlsPanel.setLayout(new SpringLayout());
        Caption displayFormatLabel = new Caption("Results Display Format:");
        controlsPanel.add(displayFormatLabel);
        JPanel displayFormatPanel = new JPanel();
        displayFormatPanel.setLayout(new FlowLayout(0));
        displayFormatPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.javaViewerRB = new JRadioButton("Java Viewer");
        this.javaViewerUCRB = new JRadioButton("JV user colors");
        this.htmlRB = new JRadioButton("HTML");
        this.xmlRB = new JRadioButton("XML");
        ButtonGroup displayFormatButtonGroup = new ButtonGroup();
        displayFormatButtonGroup.add(this.javaViewerRB);
        displayFormatButtonGroup.add(this.javaViewerUCRB);
        displayFormatButtonGroup.add(this.htmlRB);
        displayFormatButtonGroup.add(this.xmlRB);
        this.javaViewerRB.setSelected(true);
        if ("Java Viewer".equals(med.getViewType())) {
            this.javaViewerRB.setSelected(true);
        } else if ("JV User Colors".equals(med.getViewType())) {
            this.javaViewerUCRB.setSelected(true);
        } else if ("HTML".equals(med.getViewType())) {
            this.htmlRB.setSelected(true);
        } else if ("XML".equals(med.getViewType())) {
            this.xmlRB.setSelected(true);
        }
        displayFormatPanel.add(this.javaViewerRB);
        displayFormatPanel.add(this.javaViewerUCRB);
        displayFormatPanel.add(this.htmlRB);
        displayFormatPanel.add(this.xmlRB);
        controlsPanel.add(displayFormatPanel);
        SpringUtilities.makeCompactGrid(controlsPanel, 1, 2, 4, 4, 0, 0);
        JButton editStyleMapButton = new JButton("Edit Style Map");
        editStyleMapButton.addActionListener(this);
        southernPanel.add(controlsPanel);
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new FlowLayout(2));
        buttonsPanel.add(editStyleMapButton);
        if (performanceStats != null) {
            JButton perfStatsButton = new JButton("Performance Stats");
            perfStatsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    JOptionPane.showMessageDialog((Component)ae.getSource(), performanceStats, null, -1);
                }
            });
            buttonsPanel.add(perfStatsButton);
        }
        JButton closeButton = new JButton("Close");
        buttonsPanel.add(closeButton);
        southernPanel.add(buttonsPanel);
        this.getContentPane().add((Component)resultsTitlePanel, "North");
        this.getContentPane().add((Component)scrollPane, "Center");
        this.getContentPane().add((Component)southernPanel, "South");
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                AnnotationViewerDialog.this.setVisible(false);
            }
        });
        this.setDefaultCloseOperation(2);
        AnnotationViewerDialog.setLF();
        this.analyzedResultsList.setCellRenderer(new MyListCellRenderer());
        ListMouseAdapter mouseListener = new ListMouseAdapter();
        this.analyzedResultsList.addMouseListener(mouseListener);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        String styleMapXml = null;
        AnalysisEngineDescription selectedAE = null;
        try {
            if (this.styleMapFile.exists()) {
                styleMapXml = FileUtils.file2String((File)this.styleMapFile);
            }
            if (selectedAE == null) {
                selectedAE = this.promptForAE();
            }
            if (selectedAE != null) {
                this.styleMapEditor.setAnalysisEngine(selectedAE);
                String newStyleMap = this.styleMapEditor.launchEditor(selectedAE.getAnalysisEngineMetaData(), styleMapXml, this.cas);
                if (newStyleMap != null) {
                    this.styleMapFile = this.med1.getStylemapFile();
                    FileWriter writer = new FileWriter(this.styleMapFile);
                    writer.write(newStyleMap);
                    writer.close();
                    this.annotationViewGenerator.processStyleMap(this.styleMapFile);
                }
            }
        }
        catch (Exception e) {
            this.displayError(e);
        }
    }

    public String getDefaultCasViewName() {
        return this.defaultCasViewName;
    }

    public void setDefaultCasViewName(String defaultCasViewName) {
        this.defaultCasViewName = defaultCasViewName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launchThatViewer(String inputDirPath, String fileName, TypeSystem typeSystem, String[] aTypesToDisplay, boolean javaViewerRBisSelected, boolean javaViewerUCRBisSelected, boolean xmlRBisSelected, File styleMapFile, File viewerDirectory) {
        try {
            File xcasFile = new File(inputDirPath, fileName);
            CAS cas = CasCreationUtils.createCas((Collection)Collections.EMPTY_LIST, (TypeSystem)typeSystem, (Properties)UIMAFramework.getDefaultPerformanceTuningProperties());
            try (FileInputStream xcasInStream = null;){
                xcasInStream = new FileInputStream(xcasFile);
                XmlCasDeserializer.deserialize((InputStream)xcasInStream, (CAS)cas, (boolean)true);
            }
            cas = cas.getView(this.defaultCasViewName);
            if (javaViewerRBisSelected || javaViewerUCRBisSelected) {
                this.med1.setViewType(javaViewerRBisSelected ? "Java Viewer" : "JV User Colors");
                CasAnnotationViewer viewer = new CasAnnotationViewer();
                viewer.setDisplayedTypes(aTypesToDisplay);
                if (javaViewerUCRBisSelected) {
                    this.getColorsForTypesFromFile(viewer, styleMapFile);
                } else {
                    viewer.setHiddenTypes(new String[]{"uima.cpm.FileLocation"});
                }
                viewer.setCAS(cas);
                JDialog dialog = new JDialog((Dialog)this, "Annotation Results for " + fileName + " in " + inputDirPath);
                dialog.getContentPane().add(viewer);
                dialog.setSize(850, 630);
                dialog.pack();
                dialog.show();
            } else {
                CAS defaultView = cas.getView("_InitialView");
                if (defaultView.getDocumentText() == null) {
                    this.displayError("The HTML and XML Viewers can only view the default text document, which was not found in this CAS.");
                    return;
                }
                File inlineXmlFile = new File(viewerDirectory, "inline.xml");
                CasToInlineXml casToInlineXml = new CasToInlineXml();
                casToInlineXml.setFormattedOutput(false);
                String xmlAnnotations = casToInlineXml.generateXML(defaultView);
                FileOutputStream outStream = new FileOutputStream(inlineXmlFile);
                outStream.write(xmlAnnotations.getBytes("UTF-8"));
                outStream.close();
                if (xmlRBisSelected) {
                    this.med1.setViewType("XML");
                    BrowserUtil.openUrlInDefaultBrowser((String)inlineXmlFile.getAbsolutePath());
                } else {
                    this.med1.setViewType("HTML");
                    if (!this.processedStyleMap) {
                        if (!styleMapFile.exists()) {
                            this.annotationViewGenerator.autoGenerateStyleMapFile(this.promptForAE().getAnalysisEngineMetaData(), styleMapFile);
                        }
                        this.annotationViewGenerator.processStyleMap(styleMapFile);
                        this.processedStyleMap = true;
                    }
                    this.annotationViewGenerator.processDocument(inlineXmlFile);
                    File genFile = new File(viewerDirectory, "index.html");
                    BrowserUtil.openUrlInDefaultBrowser((String)genFile.getAbsolutePath());
                }
            }
        }
        catch (Exception ex) {
            this.displayError(ex);
        }
    }

    public static String getTextValue(Node node) {
        Node first = node.getFirstChild();
        if (first != null) {
            Text text = (Text)node.getFirstChild();
            return text.getNodeValue().trim();
        }
        return null;
    }

    public static Node getFirstChildByName(Node node, String name) {
        NodeList children = node.getChildNodes();
        for (int c = 0; c < children.getLength(); ++c) {
            Node n = children.item(c);
            if (!n.getNodeName().equals(name)) continue;
            return n;
        }
        return null;
    }

    public void getColorsForTypesFromFile(CasAnnotationViewer viewer, File aStyleMapFile) {
        ArrayList<Color> colorList = new ArrayList<Color>();
        ArrayList<String> typeList = new ArrayList<String>();
        ArrayList<String> notCheckedList = new ArrayList<String>();
        ArrayList<String> hiddenList = new ArrayList<String>();
        hiddenList.add("uima.cpm.FileLocation");
        if (aStyleMapFile.exists()) {
            FileInputStream stream = null;
            Document parse = null;
            try {
                stream = new FileInputStream(aStyleMapFile);
                DocumentBuilder db = XMLUtils.createDocumentBuilderFactory().newDocumentBuilder();
                parse = db.parse(stream);
            }
            catch (FileNotFoundException e) {
                throw new UIMARuntimeException((Throwable)e);
            }
            catch (ParserConfigurationException e) {
                throw new UIMARuntimeException((Throwable)e);
            }
            catch (FactoryConfigurationError e) {
                throw new UIMARuntimeException((Throwable)e);
            }
            catch (SAXException e) {
                throw new UIMARuntimeException((Throwable)e);
            }
            catch (IOException e) {
                throw new UIMARuntimeException((Throwable)e);
            }
            Element node0 = parse.getDocumentElement();
            NodeList nodeList = node0.getChildNodes();
            ColorParser cParser = new ColorParser();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                String nodeName = node.getNodeName();
                if (!nodeName.equals("rule")) continue;
                NodeList childrenList = node.getChildNodes();
                String type = "";
                String label = "";
                StyleMapEntry sme = null;
                String colorText = "";
                for (int j = 0; j < childrenList.getLength(); ++j) {
                    Node child = childrenList.item(j);
                    String childName = child.getNodeName();
                    if (childName.equals("pattern")) {
                        type = AnnotationViewerDialog.getTextValue(child);
                    }
                    if (childName.equals("label")) {
                        label = AnnotationViewerDialog.getTextValue(child);
                    }
                    if (!childName.equals("style")) continue;
                    colorText = AnnotationViewerDialog.getTextValue(child);
                }
                sme = cParser.parseAndAssignColors(type, label, label, colorText);
                if (!sme.getChecked()) {
                    notCheckedList.add(sme.getAnnotationTypeName());
                }
                if (!sme.getHidden()) {
                    colorList.add(sme.getBackground());
                    typeList.add(sme.getAnnotationTypeName());
                    continue;
                }
                hiddenList.add(sme.getAnnotationTypeName());
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            viewer.assignColorsFromList(colorList, typeList);
            viewer.assignCheckedFromList(notCheckedList);
            String[] hiddenArr = new String[hiddenList.size()];
            hiddenList.toArray(hiddenArr);
            viewer.setHiddenTypes(hiddenArr);
        }
    }

    public void displayError(String aErrorString) {
        StringBuffer buf = new StringBuffer(aErrorString.length());
        int CHARS_PER_LINE = 80;
        int charCount = 0;
        StringTokenizer tokenizer = new StringTokenizer(aErrorString, " \n", true);
        while (tokenizer.hasMoreTokens()) {
            String tok = tokenizer.nextToken();
            if (tok.equals("\n")) {
                buf.append("\n");
                charCount = 0;
                continue;
            }
            if (charCount > 0 && charCount + tok.length() > 80) {
                buf.append("\n").append(tok);
                charCount = tok.length();
                continue;
            }
            buf.append(tok);
            charCount += tok.length();
        }
        JOptionPane.showMessageDialog(this, buf.toString(), "Error", 0);
    }

    public void displayError(Throwable aThrowable) {
        aThrowable.printStackTrace();
        String message = aThrowable.toString();
        while (aThrowable instanceof UIMAException || aThrowable instanceof UIMARuntimeException) {
            if (aThrowable instanceof UIMAException) {
                aThrowable = ((UIMAException)aThrowable).getCause();
            } else if (aThrowable instanceof UIMARuntimeException) {
                aThrowable = ((UIMARuntimeException)aThrowable).getCause();
            }
            if (aThrowable == null) continue;
            message = message + "\nCausedBy: " + aThrowable.toString();
        }
        this.displayError(message);
    }

    protected AnalysisEngineDescription promptForAE() throws IOException, InvalidXMLException, ResourceInitializationException {
        if (this.med1.getTAEfile() != null) {
            File taeFile = new File(this.med1.getTAEfile());
            XMLInputSource in = new XMLInputSource(taeFile);
            AnalysisEngineDescription aed = UIMAFramework.getXMLParser().parseAnalysisEngineDescription(in);
            return aed;
        }
        String taeDir = this.med1.getTAEfile();
        JFileChooser chooser = new JFileChooser(taeDir);
        chooser.setDialogTitle("Select the Analysis Engine that Generated this Output");
        chooser.setFileSelectionMode(0);
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            XMLInputSource in = new XMLInputSource(chooser.getSelectedFile());
            return UIMAFramework.getXMLParser().parseAnalysisEngineDescription(in);
        }
        return null;
    }

    private static void setLF() {
        String laf = UIManager.getSystemLookAndFeelClassName();
        try {
            UIManager.setLookAndFeel(laf);
        }
        catch (UnsupportedLookAndFeelException exc) {
            System.err.println("Warning: UnsupportedLookAndFeel: " + laf);
        }
        catch (Exception exc) {
            System.err.println("Error loading " + laf + ": " + exc);
        }
    }

    private File createTempDir() {
        File temp = new File(System.getProperty("java.io.tmpdir"), System.getProperty("user.name"));
        temp.mkdir();
        return temp;
    }

    class ListMouseAdapter
    extends MouseAdapter {
        ListMouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            try {
                String fileName;
                if (e.getClickCount() == 2 && (fileName = AnnotationViewerDialog.this.analyzedResultsList.getSelectedValue()) != null) {
                    AnnotationViewerDialog.this.analyzedResultsList.setCursor(Cursor.getPredefinedCursor(3));
                    AnnotationViewerDialog.this.launchThatViewer(AnnotationViewerDialog.this.inputDirPath, fileName, AnnotationViewerDialog.this.typeSystem, AnnotationViewerDialog.this.typesToDisplay, AnnotationViewerDialog.this.javaViewerRB.isSelected(), AnnotationViewerDialog.this.javaViewerUCRB.isSelected(), AnnotationViewerDialog.this.xmlRB.isSelected(), AnnotationViewerDialog.this.styleMapFile, AnnotationViewerDialog.this.tempDir);
                    AnnotationViewerDialog.this.analyzedResultsList.setCursor(Cursor.getDefaultCursor());
                }
            }
            catch (Exception ex) {
                AnnotationViewerDialog.this.displayError(ex);
            }
        }
    }

    static class MyListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = 7231915634689270693L;

        public MyListCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList analyzedResultsList, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            ImageIcon xmlIcon = Images.getImageIcon("/org/apache/uima/tools/images/xml_16.gif");
            this.setIcon(xmlIcon);
            this.setText(value.toString());
            this.setBackground(isSelected ? Color.orange : Color.white);
            this.setForeground(isSelected ? Color.black : Color.black);
            return this;
        }
    }

    static class InteractiveFilter
    implements FilenameFilter {
        private final String filenameFilter;

        public InteractiveFilter(String filenameFilter) {
            this.filenameFilter = filenameFilter;
        }

        @Override
        public boolean accept(File dir, String name) {
            if (name.equals("interactive_temp")) {
                return false;
            }
            if (name.equals("interactive_out")) {
                return false;
            }
            if (!name.isEmpty()) {
                return name.contains(this.filenameFilter);
            }
            return true;
        }
    }
}

