/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.jcas.cas;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.uima.cas.ShortArrayFS;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JCasRegistry;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.cas.TOP_Type;

public final class ShortArray
extends TOP
implements ShortArrayFS,
Iterable<Short> {
    public static final int typeIndexID;
    public static final int type;

    @Override
    public int getTypeIndexID() {
        return typeIndexID;
    }

    private ShortArray() {
    }

    public ShortArray(int addr, TOP_Type type) {
        super(addr, type);
    }

    public ShortArray(JCas jcas, int length) {
        this(jcas.getLowLevelCas().ll_createShortArray(length), jcas.getType(typeIndexID));
    }

    @Override
    public short get(int i) {
        this.jcasType.casImpl.checkArrayBounds(this.addr, i);
        return this.jcasType.ll_cas.ll_getShortArrayValue(this.addr, i);
    }

    @Override
    public void set(int i, short v) {
        this.jcasType.casImpl.checkArrayBounds(this.addr, i);
        this.jcasType.ll_cas.ll_setShortArrayValue(this.addr, i, v);
    }

    @Override
    public void copyFromArray(short[] src, int srcOffset, int destOffset, int length) {
        this.jcasType.casImpl.checkArrayBounds(this.addr, destOffset, length);
        for (int i = 0; i < length; ++i) {
            this.jcasType.ll_cas.ll_setShortArrayValue(this.addr, i + destOffset, src[i + srcOffset]);
        }
    }

    @Override
    public void copyToArray(int srcOffset, short[] dest, int destOffset, int length) {
        this.jcasType.casImpl.checkArrayBounds(this.addr, srcOffset, length);
        for (int i = 0; i < length; ++i) {
            dest[i + destOffset] = this.jcasType.ll_cas.ll_getShortArrayValue(this.addr, i + srcOffset);
        }
    }

    @Override
    public short[] toArray() {
        int size = this.size();
        short[] outArray = new short[size];
        this.copyToArray(0, outArray, 0, size);
        return outArray;
    }

    @Override
    public int size() {
        return this.jcasType.casImpl.ll_getArraySize(this.addr);
    }

    @Override
    public void copyToArray(int srcOffset, String[] dest, int destOffset, int length) {
        this.jcasType.casImpl.checkArrayBounds(this.addr, srcOffset, length);
        for (int i = 0; i < length; ++i) {
            dest[i + destOffset] = Short.toString(this.jcasType.ll_cas.ll_getShortArrayValue(this.addr, i + srcOffset));
        }
    }

    @Override
    public void copyFromArray(String[] src, int srcOffset, int destOffset, int length) {
        this.jcasType.casImpl.checkArrayBounds(this.addr, destOffset, length);
        for (int i = 0; i < length; ++i) {
            this.jcasType.ll_cas.ll_setShortArrayValue(this.addr, i + destOffset, Short.parseShort(src[i + srcOffset]));
        }
    }

    @Override
    public String[] toStringArray() {
        int size = this.size();
        String[] strArray = new String[size];
        this.copyToArray(0, strArray, 0, size);
        return strArray;
    }

    @Override
    public Iterator<Short> iterator() {
        return new Iterator<Short>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < ShortArray.this.size();
            }

            @Override
            public Short next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return ShortArray.this.get(this.i++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    static {
        type = typeIndexID = JCasRegistry.register(ShortArray.class);
    }
}

