/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail.resolver;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.activation.DataSource;
import javax.activation.FileTypeMap;
import org.apache.commons.mail.activation.PathDataSource;
import org.apache.commons.mail.resolver.DataSourceBaseResolver;

public final class DataSourcePathResolver
extends DataSourceBaseResolver {
    private final Path baseDir;
    private final OpenOption[] options;

    public DataSourcePathResolver() {
        this(Paths.get(".", new String[0]));
    }

    public DataSourcePathResolver(Path baseDir) {
        this(baseDir, false, new OpenOption[0]);
    }

    public DataSourcePathResolver(Path baseDir, boolean lenient, OpenOption ... options) {
        super(lenient);
        this.baseDir = baseDir;
        this.options = options;
    }

    public Path getBaseDir() {
        return this.baseDir;
    }

    @Override
    public DataSource resolve(String resourceLocation) throws IOException {
        return this.resolve(resourceLocation, this.isLenient());
    }

    @Override
    public DataSource resolve(String resourceLocation, boolean isLenient) throws IOException {
        PathDataSource result = null;
        if (!this.isCid(resourceLocation)) {
            Path file = Paths.get(resourceLocation, new String[0]);
            if (!file.isAbsolute()) {
                Path path = file = this.getBaseDir() != null ? this.getBaseDir().resolve(resourceLocation) : Paths.get(resourceLocation, new String[0]);
            }
            if (Files.exists(file, new LinkOption[0])) {
                result = new PathDataSource(file, FileTypeMap.getDefaultFileTypeMap(), this.options);
            } else if (!isLenient) {
                throw new IOException("Cant resolve the following file resource :" + file.toAbsolutePath());
            }
        }
        return result;
    }
}

