/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import nl.basjes.parse.useragent.UserAgent;
import nl.basjes.parse.useragent.UserAgentAnalyzer;
import org.apache.turbine.util.RunData;

public class BrowserDetector {
    private String userAgentString = "";
    private static UserAgentAnalyzer uaa = ((UserAgentAnalyzer.UserAgentAnalyzerBuilder)((UserAgentAnalyzer.UserAgentAnalyzerBuilder)UserAgentAnalyzer.newBuilder().withFields(new String[]{"AgentName", "AgentVersion", "OperatingSystemName"})).hideMatcherLoadStats()).build();
    private static volatile ConcurrentMap<String, UserAgent> userAgentCache = new ConcurrentHashMap<String, UserAgent>();
    private String browserName = "";
    private float browserVersion = 1.0f;
    private String browserPlatform = "unknown";

    public BrowserDetector(String userAgentString) {
        this.userAgentString = userAgentString;
        UserAgent userAgent = this.getUserAgent();
        this.browserName = userAgent.getValue("AgentName");
        String version = userAgent.getValue("AgentVersion");
        this.browserVersion = BrowserDetector.toFloat(version);
        this.browserPlatform = userAgent.getValue("OperatingSystemName");
    }

    public BrowserDetector(RunData data) {
        this(data.getUserAgent());
    }

    public String getBrowserName() {
        return this.browserName;
    }

    public String getBrowserPlatform() {
        return this.browserPlatform;
    }

    public float getBrowserVersion() {
        return this.browserVersion;
    }

    public String getUserAgentString() {
        return this.userAgentString;
    }

    public UserAgent getUserAgent() {
        return BrowserDetector.parse(this.userAgentString);
    }

    private static UserAgent parse(String userAgentString) {
        return userAgentCache.computeIfAbsent(userAgentString, arg_0 -> ((UserAgentAnalyzer)uaa).parse(arg_0));
    }

    private static final float toFloat(String s) {
        return Float.parseFloat(s);
    }
}

